#!/usr/bin/perl
require 'mainlibrary.pl';
#=========================================================================
#Filename: viewprogress.cgi
#Written By: Trevor Barnett
#File Description:
#  A page that displays a list of chapters from which the student can pick.
#  When the student picks a chapter, the page displays the number of quizzes
#  in the chapter the student has taken, the average percentage the student
#  scored correct, and other information about the students performance in
#  that chapter.  If the student has not taken any quizzes for that chapter,
#  the page displays default information that explains the student must
#  finish a quiz before any progress can be viewed for the current chapter.
#  Students are only allowed to view results for their own work and are not
#  allowed to view other students quizzes or progress.  
#=========================================================================
use CGI;
use DBI;
require 'cookielib/cookie.lib';
my $line;
my $q=new CGI;
my $chapter=$q->param('chapter');
my $quiz=$q->param('quiz');
my $counter=0;
my $userid;

if(&GetCookies('userid')){
  $userid = $Cookies{'userid'};
}

print "Content-type:text/html\n\n";

if(!$chapter){
open(MAINPAGE, "student.html");
while($line=<MAINPAGE>){
if($line eq "<!--MAIN--!>\n"){
  print <<CHAPTERSELECTION;
<form method=post action="viewprogress.cgi" name="chapter1">
<input type=hidden name="chapter" value="1">
</FORM>
<form method=post action="viewprogress.cgi" name="chapter2">
<input type=hidden name="chapter" value="2">
</FORM>
<form method=post action="viewprogress.cgi" name="chapter3">
<input type=hidden name="chapter" value="3">
</FORM>
<form method=post action="viewprogress.cgi" name="chapter4">
<input type=hidden name="chapter" value="4">
</FORM>
<form method=post action="viewprogress.cgi" name="chapter5">
<input type=hidden name="chapter" value="5">
</FORM>
<form method=post action="viewprogress.cgi" name="chapter6">
<input type=hidden name="chapter" value="6">
</FORM>
<form method=post action="viewprogress.cgi" name="chapter7">
<input type=hidden name="chapter" value="7">
</FORM>
<form method=post action="viewprogress.cgi" name="chapter8">
<input type=hidden name="chapter" value="8">
</FORM>
<form method=post action="viewprogress.cgi" name="chapter9">
<input type=hidden name="chapter" value="9">
</FORM>
<div align="center"><b><font size="5" color="#FFFFFF">View Progress</font>
  </b>
  <p><b><font size="4" color="#000080">Select a chapter</font></b></p>
  <center>
  <table border="0" cellspacing="3" style="border-collapse: collapse" bordercolor="#111111" width="75%" cellpadding="3">
    <tr>
      <td width="50%" align="center"><b><a href="Javascript:document.chapter1.submit()">
      <font size="4" color="#000080">Chapter 1</font></a></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter6.submit()">
      <font color="#000080">Chapter 6</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter2.submit()">
      <font color="#000080">Chapter 2</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter7.submit()">
      <font color="#000080">Chapter 7</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter3.submit()">
      <font color="#000080">Chapter 3</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter8.submit()">
      <font color="#000080">Chapter 8</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter4.submit()">
      <font color="#000080">Chapter 4</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter9.submit()">
      <font color="#000080">Chapter 9</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter5.submit()">
      <font color="#000080">Chapter 5</font></a></font></b></td>
      <td width="50%" align="center">&nbsp;</td>
    </tr>
  </table>
  </center>
CHAPTERSELECTION
}#end $line equals main
print "$line";
}#end while
close (MAINPAGE);
}# end if !$chapter
elsif(!$quiz){
#==============================FIND WHICH QUIZZES THEY HAVE TAKEN HERE =========================================
my $database = $dbname;
my $port = $dbport;
my $dsn = $dbpassword;

my $dbh = DBI->connect($dsn)
   or exit(1);
my $quiztakencounter=0;
my @isquiztaken;
my $sth;

for(my $i=1; $i<20; $i++){
    $sth = $dbh->prepare ("SELECT quiznumber FROM quizzes WHERE userid='$userid' AND chapter='$chapter' AND quiznumber='$i'");
    $sth->execute();
    my $temp=$sth->fetchrow_array();
    $sth->finish();
    if($temp){
      $isquiztaken[$quiztakencounter]=$temp;
      $quiztakencounter++;
    }
}
$dbh->disconnect();
#===============================================================================================================
open(STUDENT, "student.html");
while($line=<STUDENT>){
if($line eq "<!--MAIN--!>\n"){

if($quiztakencounter eq "0"){
    #print no quizzes taken for this chapter
    print <<ERROR;
<p align="center"><font color="#FFFFFF" size="5">View Progress</font> <p align="center">
<font size="4" color="#000080">Chapter $chapter</font><p align="center"><b>
<font size="4">You have not taken any quizzes in this chapter.</font></b><p align="center">
ERROR
}
else{
   print<<HEADER;
<p align="center"><font color="#FFFFFF" size="5">View Progress</font></p>
<p align="center"><font size="4" color="#000080">Chapter $chapter -- Select a quiz</font></p>
HEADER

   for(my $j=1; $j<=$quiztakencounter; $j++){
    print "<form method=post action=\"viewprogress.cgi\" name=\"quiz$j\">";
    print "<input type=hidden name=quiz value=$j>";
    print "<input type=hidden name=chapter value=$chapter>";
    print "</form>";
   }
    print "<table border=\"0\" cellspacing=\"5\" style=\"border-collapse: collapse\" bordercolor=\"#111111\" width=\"57%\" cellpadding=\"5\" align=\"center\">";
    print "<p align=\"center\">";
    for(my $i=1; $i<=$quiztakencounter; $i++){
      print "<tr><td align=\"center\"><b><a href=\"Javascript:document.quiz$i.submit()\">Quiz $i Results</a></b></td></tr>";
    }
    print "</p>";
    print "</table>";

} #end else
} #end if hidden line
  print "$line";
} #end while line equals mainpage
close(STUDENT);
}# end if not quiz
else{
open(STUDENT, "student.html");
while($line=<STUDENT>){
if($line eq "<!--MAIN--!>\n"){

my $date;
my $totalquestions;
my $numcorrectanswers;
my $incorrectanswers;
my $percent;

my $database = $dbname;
my $port = $dbport;
my $dsn = $dbpassword;

my $dbh = DBI->connect($dsn)
   or exit(1);
my $sth;

$sth = $dbh->prepare ("SELECT date FROM quizzes WHERE userid='$userid' AND chapter='$chapter' AND quiznumber='$quiz'");
$sth->execute();
$date=$sth->fetchrow_array();
$sth->finish();

$sth = $dbh->prepare ("SELECT numcorrect FROM quizzes WHERE userid='$userid' AND chapter='$chapter' AND quiznumber='$quiz'");
$sth->execute();
$numcorrectanswers=$sth->fetchrow_array();
$sth->finish();

$sth = $dbh->prepare ("SELECT numquestions FROM quizzes WHERE userid='$userid' AND chapter='$chapter' AND quiznumber='$quiz'");
$sth->execute();
$totalquestions=$sth->fetchrow_array();
$sth->finish();

$dbh->disconnect();

$percent=(($numcorrectanswers/1.0)/($totalquestions/1.0))*100.0;
$percent=sprintf("%.1f", $percent);
$incorrectanswers=$totalquestions-$numcorrectanswers;

print <<HEADER;
<p align="center"><font color="#FFFFFF" size="5">View Progress</font> <p align="center">
<font size="4" color="#000080"><b>Chapter $chapter, Quiz $quiz</b></font><p>
HEADER
print <<TABLE;
      <div align="center">
        <center>
        <table border="2" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%">
          <tr>
            <td width="100%">
            <p align="center"><b><font size="5">Summary:</font></b></p>
            <blockquote>
              <p><font size="4">Date Taken: $date<br>
                 Total Questions: $totalquestions<br>
                 Correct Answers: $numcorrectanswers<br>
                 Incorrect Answers: $incorrectanswers<br>
                 Percentage Correct: $percent%<br></font></blockquote>
            </td>
          </tr>
        </table>
        </center>
      </div>
TABLE
} #end hidden line
print "$line";
}#end while
close(STUDENT);
}
exit(0);
