#!/usr/bin/perl
require 'mainlibrary.pl';
#=========================================================================
#Filename: viewclassprogress.cgi
#Written By: Trevor Barnett
#File Description:
#  A page that displays a list of chapters.  When the teacher selects a
#  chapter, the page displays all the quizzes from that chapter.  If no 
#  quizzes exist for that chapter or if no students have taken any quizzes
#  for that chapter, the page displays a message explaining which of these
#  has occurred.  Otherwise the page displays a list of the available
#  quizzes that have recorded progress.  When the user clicks one of the
#  quizzes in this list, the page then displays the number of students who
#  have taken the quiz, the percentage of questions that they answered
#  correctly, and other information to help the teacher see how the class
#  is progressing.  The script calculates this information by comparing the
#  answers in the quiz file to the student answers in the database.  
#=========================================================================
use CGI;
use DBI;
require 'cookielib/cookie.lib';
my $line;
my $q=new CGI;
my $chapter=$q->param('chapter');
my $quiz=$q->param('quiz');
my $counter=0;

print "Content-type:text/html\n\n";

if(!$chapter){
open(MAINPAGE, "teacher.html");
while($line=<MAINPAGE>){
if($line eq "<!--MAIN--!>\n"){
  print <<CHAPTERSELECTION;
<form method=post action="viewclassprogress.cgi" name="chapter1">
<input type=hidden name="chapter" value="1">
</FORM>
<form method=post action="viewclassprogress.cgi" name="chapter2">
<input type=hidden name="chapter" value="2">
</FORM>
<form method=post action="viewclassprogress.cgi" name="chapter3">
<input type=hidden name="chapter" value="3">
</FORM>
<form method=post action="viewclassprogress.cgi" name="chapter4">
<input type=hidden name="chapter" value="4">
</FORM>
<form method=post action="viewclassprogress.cgi" name="chapter5">
<input type=hidden name="chapter" value="5">
</FORM>
<form method=post action="viewclassprogress.cgi" name="chapter6">
<input type=hidden name="chapter" value="6">
</FORM>
<form method=post action="viewclassprogress.cgi" name="chapter7">
<input type=hidden name="chapter" value="7">
</FORM>
<form method=post action="viewclassprogress.cgi" name="chapter8">
<input type=hidden name="chapter" value="8">
</FORM>
<form method=post action="viewclassprogress.cgi" name="chapter9">
<input type=hidden name="chapter" value="9">
</FORM>
<div align="center"><b><font size="5" color="#FFFFFF">View Class Progress</font>
  </b>
  <p><b><font size="4" color="#000080">Select a chapter</font></b></p>
  <center>
  <table border="0" cellspacing="3" style="border-collapse: collapse" bordercolor="#111111" width="75%" cellpadding="3">
    <tr>
      <td width="50%" align="center"><b><a href="Javascript:document.chapter1.submit()">
      <font size="4" color="#000080">Chapter 1</font></a></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter6.submit()">
      <font color="#000080">Chapter 6</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter2.submit()">
      <font color="#000080">Chapter 2</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter7.submit()">
      <font color="#000080">Chapter 7</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter3.submit()">
      <font color="#000080">Chapter 3</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter8.submit()">
      <font color="#000080">Chapter 8</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter4.submit()">
      <font color="#000080">Chapter 4</font></a></font></b></td>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter9.submit()">
      <font color="#000080">Chapter 9</font></a></font></b></td>
    </tr>
    <tr>
      <td width="50%" align="center"><b><font size="4"><a href="Javascript:document.chapter5.submit()">
      <font color="#000080">Chapter 5</font></a></font></b></td>
      <td width="50%" align="center">&nbsp;</td>
    </tr>
  </table>
  </center>
CHAPTERSELECTION
}#end $line equals main
print "$line";
}#end while
close (MAINPAGE);
}# end if !$chapter
elsif(!$quiz){
open(STUDENT, "teacher.html");
while($line=<STUDENT>){
if($line eq "<!--MAIN--!>\n"){
print<<HEADER;
<p align="center"><font color="#FFFFFF" size="5">View Class Progress</font></p>
<p align="center"><font size="4" color="#000080">Chapter $chapter -- Select a quiz</font></p>
HEADER
my @quizzes; 
my $quizcounter=0;

   for(my $j=1; $j<=100; $j++){
    if(-e "chapter$chapter/quiz$j.txt"){
      print "<form method=post action=\"viewclassprogress.cgi\" name=\"quiz$j\">";
      print "<input type=hidden name=quiz value=$j>";
      print "<input type=hidden name=chapter value=$chapter>";
      print "</form>";
      $quizzes[$quizcounter]=$j;
      $quizcounter++;
    }
   }
    print "<table border=\"0\" cellspacing=\"5\" style=\"border-collapse: collapse\" bordercolor=\"#111111\" width=\"70%\" cellpadding=\"5\" align=\"center\">";
    print "<p align=\"center\">";
    for(my $i=0; $i<$quizcounter; $i++){
      if(($i % 2) eq 0){
        print "<tr><td align=\"center\"><b><a href=\"Javascript:document.quiz$quizzes[$i].submit()\">Quiz $quizzes[$i] Results</a></b></td>";
      }
      else{
        print "<td align=\"center\"><b><a href=\"Javascript:document.quiz$quizzes[$i].submit()\">Quiz $quizzes[$i] Results</a></b></td></tr>";
      }
    }
    print "</p>";
    print "</table>";

} #end if hidden line
  print "$line";
} #end while line equals mainpage
close(STUDENT);
}# end if not quiz
else{
open(STUDENT, "teacher.html");
while($line=<STUDENT>){
if($line eq "<!--MAIN--!>\n"){

my $numstudents=0;
my $dateoffirstquiz=20049999;
my $dateoflastquiz=0;
my $totalquestions=0;
my $totalcorrect=0;
my $numquestions;
my $percent;
my $date;

my $database = $dbname;
my $port = $dbport;
my $dsn = $dbpassword;

my $dbh = DBI->connect($dsn);
my $sth;

$sth = $dbh->prepare ("SELECT * FROM quizzes WHERE chapter='$chapter' AND quiznumber='$quiz'");
$sth->execute();
while(@array=$sth->fetchrow_array()){
  $numquestions=$array[5];
  my $date=$array[3];
  if($date>$dateoflastquiz){
    $dateoflastquiz=$date;
  }
  if($date<$dateoffirstquiz){
    $dateoffirstquiz=$date; 
  }
  $numstudents++;
  $totalcorrect+=$array[4];
  $totalquestions+=$numquestions;
}
$sth->finish();

$dbh->disconnect();

$percent=(($totalcorrect/1.0)/($totalquestions/1.0))*100.0;
$percent=sprintf("%.1f", $percent);

print <<HEADER;
<p align="center"><font color="#FFFFFF" size="5">View Class Progress</font> <p align="center">
<font size="4" color="#000080"><b>Chapter $chapter, Quiz $quiz</b></font><p>
HEADER

if($numstudents>0){
print <<TABLE;
      <div align="center">
        <center>
        <table border="2" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%">
          <tr>
            <td width="100%">
            <p align="center"><b><font size="5">Summary:</font></b></p>
            <blockquote>
              <p><font size="4">Quizzes Recorded: $numstudents<br>
                 Total Questions: $totalquestions<br>
                 Average Percentage: $percent% <br>
                 Date of First Quiz: $dateoffirstquiz<br>
                 Date of Last Quiz: $dateoflastquiz<br></font></blockquote>
            </td>
          </tr>
        </table>
        </center>
      </div>
TABLE
}
else{
print <<HEADER;
<p align="center"><font size="4">No students have taken quizzes in this chapter</font> <p align="center">
HEADER
}
} #end hidden line
print "$line";
}#end while
close(STUDENT);
}
exit(0);
