#!/usr/bin/perl
#=========================================================================
#Filename: postsyllabus.cgi
#Written By: Trevor Barnett
#File Description:
#  Accepts a file as form input from the CGI.  If the file has a .txt or
#  .html extension, the script copies the file to the syllabus directory 
#  on the server.  When the script finishes copying the file, it changes
#  the file permissions to 0744 so that the file can be read by everyone.
#  If the file does not have an appropriate extension, the script displays
#  an error message.  
#=========================================================================
use strict;
use CGI;
my $line;
my $q=new CGI;
my $file=$q->param('syllabusfile');
my $tmpFilename = $q->tmpFileName($file);
#my $mimeType = $q->uploadInfo($file)->{'Content-Type'};
my $syllabusname = "syllabus/syllabus.";
my $line;
my $type;

print "Content-type:text/html\n\n";
if(!$file){
  #no file submitted
  open(MAINPAGE, "teacher.html");
  while($line=<MAINPAGE>){
    print "$line";
    if($line eq "<!--MAIN--!>\n"){
       print <<ERROR;
          <b><font size="5" color="#FF0000">   <p align="center"> Error!</p></font></b>
          <font size="4"><p align="center">You did not submit a file.</p></font>
ERROR
    }#end if
  }#end while
  close(MAINPAGE);
}
elsif((substr($file, -4, 4) ne "html") && (substr($file, -4, 4) ne "HTML") && (substr($file, -3, 3) ne "txt") && (substr($file, -3, 3) ne "TXT")){
  # they have submitted the wrong kind of file send them an error
  open(MAINPAGE, "teacher.html");
  while($line=<MAINPAGE>){
    print "$line";
    if($line eq "<!--MAIN--!>\n"){
       print <<ERROR;
          <b><font size="5" color="#FF0000">   <p align="center"> Error!</p></font></b>
          <font size="4"><p align="center">You have submitted the wrong type of file.<br> You must submit a .txt or .html file.</p></font>
ERROR
    }#end if
  }#end while
  close(MAINPAGE);
}
else{
  #file is good, set it as current syllabus
  if((substr($file, -4, 4) eq "html") || (substr($file, -4, 4) eq "HTML")){
     $syllabusname = $syllabusname . substr($file, -4, 4);
    $type = "html";
  }
  if((substr($file, -3, 3) eq "txt") || (substr($file, -3, 3) eq "TXT")){
     $syllabusname = $syllabusname . substr($file, -3, 3);
    $type = "txt";
  }
  if(-e "syllabus/syllabus.html"){
    unlink("syllabus/syllabus.html");
  }
  if(-e "syllabus/syllabus.txt"){
    unlink("syllabus/syllabus.txt");
  }
  open(READFILE, "$tmpFilename");
  open(OUTFILE, ">$syllabusname");
  while (<READFILE>){
    $_ =~ s/body/body onLoad="resizeTo(screen.availWidth*.37, screen.availHeight*.35); moveTo(screen.availWidth*.6, screen.availHeight*.05)"/;
    $_ =~ s/BODY/body onLoad="resizeTo(screen.availWidth*.37, screen.availHeight*.35); moveTo(screen.availWidth*.6, screen.availHeight*.05)"/;
    print OUTFILE $_;
  }
  close(READFILE);
  close(OUTFILE);
  chmod 0744, $syllabusname or die "failed doing chmod on syllabusname";
  open(MAINPAGE, "teacher.html");
  while($line=<MAINPAGE>){
    print "$line";
    if($line eq "<!--MAIN--!>\n"){
      print <<SUCCESS;
              <p align="center">  <font size="5" color="#FFFFFF">Post Syllabus
              </font>
              <p align="center">  <font size="4">
Syllabus was successfully posted.&nbsp;<br> To view the syllabus you just posted, click
<a href="javascript:popup()">here</a>.</font>
SUCCESS

      } #end line equals MAIN
   } # end while
}

exit(0);
