#!/usr/bin/perl
#=========================================================================
#Filename: glossary.cgi
#Written By: Trevor Barnett
#File Description:
#  Accepts one of two different text inputs from CGI.  The first is a search
#  word the script uses to look for a specific entry in the glossary.  The
#  second is a letter of the alphabet that the script uses to look up all
#  the words that start with that letter in the glossary.  If the first
#  input is not null, the script uses the search word to search the glossary
#  for a matching word component.  If a word component is found, the script
#  prints out the word component and a definition of the components meaning.
#  If a word component is not found, the script prints out a message saying
#  that no results were found.  If the first input is null, the script uses
#  the second input to search the glossary for all word components that
#  start with that letter.  The script displays all matching word components
#  and their definitions in a table for easy viewing.  
#=========================================================================
use strict;
use CGI;
my $line;
my $q=new CGI;
my $searchword = $q->param('searchword');
my $letter = $q->param('letter');
my $wordcomponent;
my $componentmeaning;
my $searchwordfound;
my $choppedletter;
my @sortedcomponents;
my @components;
my $counter=0;
my $first;
my $wordtoprint;

print "Content-type:text/html\n\n";

if($searchword){ 
  $searchwordfound = "false";
  #open glossary
  open(GLOSSARY, "glossary/glossary.txt");
  while(($line=<GLOSSARY>)&&($searchwordfound ne "true")){
  #searchwordnotfound and still have file lines
  $componentmeaning="";
  #chop it until you get ;
  $choppedletter="";
  while(($choppedletter ne ";")&&($line)){
    $choppedletter=chop($line);
    if ($choppedletter ne ";"){
      $componentmeaning=$choppedletter . $componentmeaning;
    }
  }
  #compare to see if word is searchword
  if($line eq $searchword){
    #if so then set searchwordfound to true
    $wordcomponent = $line;
    $searchwordfound = "true"
  }
  }  #end of while statement
}
else{
  #create the sorted array
  #@sorted=sort(@words) puts them in alphabetical order
  open(GLOSSARY, "glossary/glossary.txt");
  while($line=<GLOSSARY>){
    $first = substr($line, 0, 1);
    if($first eq $letter){
       $components[$counter]=$line;
       $counter++;
    }

  }
  @sortedcomponents = sort(@components);
}


open(STUDENTPAGE, "student.html");
while($line=<STUDENTPAGE>){
  if($line eq "<!--MAIN--!>\n"){
    if(($searchword) && ($searchwordfound eq "false")){
print<<SEARCHERROR;
<form name="glossarybrowseA" method=post action="glossary.cgi">
<input type=hidden name="letter" value="a">
</FORM>
<form name="glossarybrowseB" method=post action="glossary.cgi">
<input type=hidden name="letter" value="b">
</FORM>
<form name="glossarybrowseC" method=post action="glossary.cgi">
<input type=hidden name="letter" value="c">
</FORM>
<form name="glossarybrowseD" method=post action="glossary.cgi">
<input type=hidden name="letter" value="d">
</FORM>
<form name="glossarybrowseE" method=post action="glossary.cgi">
<input type=hidden name="letter" value="e">
</FORM>
<form name="glossarybrowseF" method=post action="glossary.cgi">
<input type=hidden name="letter" value="f">
</FORM>
<form name="glossarybrowseG" method=post action="glossary.cgi">
<input type=hidden name="letter" value="g">
</FORM>
<form name="glossarybrowseH" method=post action="glossary.cgi">
<input type=hidden name="letter" value="h">
</FORM>
<form name="glossarybrowseI" method=post action="glossary.cgi">
<input type=hidden name="letter" value="i">
</FORM>
<form name="glossarybrowseJ" method=post action="glossary.cgi">
<input type=hidden name="letter" value="j">
</FORM>
<form name="glossarybrowseK" method=post action="glossary.cgi">
<input type=hidden name="letter" value="k">
</FORM>
<form name="glossarybrowseL" method=post action="glossary.cgi">
<input type=hidden name="letter" value="l">
</FORM>
<form name="glossarybrowseM" method=post action="glossary.cgi">
<input type=hidden name="letter" value="m">
</FORM>
<form name="glossarybrowseN" method=post action="glossary.cgi">
<input type=hidden name="letter" value="n">
</FORM>
<form name="glossarybrowseO" method=post action="glossary.cgi">
<input type=hidden name="letter" value="o">
</FORM>
<form name="glossarybrowseP" method=post action="glossary.cgi">
<input type=hidden name="letter" value="p">
</FORM>
<form name="glossarybrowseQ" method=post action="glossary.cgi">
<input type=hidden name="letter" value="q">
</FORM>
<form name="glossarybrowseR" method=post action="glossary.cgi">
<input type=hidden name="letter" value="r">
</FORM>
<form name="glossarybrowseS" method=post action="glossary.cgi">
<input type=hidden name="letter" value="s">
</FORM>
<form name="glossarybrowseT" method=post action="glossary.cgi">
<input type=hidden name="letter" value="t">
</FORM>
<form name="glossarybrowseU" method=post action="glossary.cgi">
<input type=hidden name="letter" value="u">
</FORM>
<form name="glossarybrowseV" method=post action="glossary.cgi">
<input type=hidden name="letter" value="v">
</FORM>
<form name="glossarybrowseW" method=post action="glossary.cgi">
<input type=hidden name="letter" value="w">
</FORM>
<form name="glossarybrowseX" method=post action="glossary.cgi">
<input type=hidden name="letter" value="x">
</FORM>
<form name="glossarybrowseY" method=post action="glossary.cgi">
<input type=hidden name="letter" value="y">
</FORM>
<form name="glossarybrowseZ" method=post action="glossary.cgi">
<input type=hidden name="letter" value="z">
</FORM>
<div align="center">
<p><b><font size="5" color="#FFFFFF">Glossary</font></b></p>
<u><b>
<font size="4">Search Results:</font></b></u><br>

  <center>
  <table border="0" cellspacing="3" style="border-collapse: collapse" bordercolor="#111111" width="60%" cellpadding="3">
    <tr>
      <td width="100%">
      <p align="center"><font size="4" color="#FF0000"><b>No results found</b></font></td>
    </tr>
  </table>
  </center>
</div>
</center>
<br><p>
                <div align="center">
  <center>
  <table border="0" cellspacing="5" style="border-collapse: collapse" bordercolor="#111111" width="80%" cellpadding="5">
    <tr>

      <td width="50%">
      <p align="center"><b><font size="4">Search Again?</font></b></td>
      <td width="50%">
      <p align="center"><font size="4"><b>Or b</b></font><b><font size="4">rowse 
      by first letter:</font></b></td>
    </tr>
    <tr>
<form method=post name="glossaryhit" action="glossary.cgi">
      <td width="50%">
      <p align="center"><input type=text name="searchword" size="20"></td>
      <td width="50%" align="center"><a href="Javascript:document.glossarybrowseA.submit()">
      <font color="#000080">A</font></a><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseB.submit()">
      <font color="#000080">B</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseC.submit()">
      <font color="#000080">C</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseD.submit()">
      <font color="#000080">D</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseE.submit()">
      <font color="#000080">E</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseF.submit()">
      <font color="#000080">F</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseG.submit()">
      <font color="#000080">G</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseH.submit()">
      <font color="#000080">H</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseI.submit()">
      <font color="#000080">I</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseJ.submit()">
      <font color="#000080">J</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseK.submit()">
      <font color="#000080">K</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseL.submit()">
      <font color="#000080">L</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseM.submit()">
      <font color="#000080">M</font></A></td>
    </tr>
    <tr>    
      <td width="50%">
      <p align="center"><b><input type=submit name="searchsubmit" value="Search" style="width: 75; height: 22; font-size: 15px"></b></td>
      </FORM>
      <td width="50%" align="center"><a href="Javascript:document.glossarybrowseN.submit()">
      <font color="#000080">N</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseO.submit()">
      <font color="#000080">O</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseP.submit()">
      <font color="#000080">P</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseQ.submit()">
      <font color="#000080">Q</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseR.submit()">
      <font color="#000080">R</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseS.submit()">
      <font color="#000080">S</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseT.submit()">
      <font color="#000080">T</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseU.submit()">
      <font color="#000080">U</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseV.submit()">
      <font color="#000080">V</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseW.submit()">
      <font color="#000080">W</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseX.submit()">
      <font color="#000080">X</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseY.submit()">
      <font color="#000080">Y</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseZ.submit()">
      <font color="#000080">Z</font></A></td>

    </tr>
  </table>
  </center>
SEARCHERROR
    }
    elsif ($searchword && ($searchwordfound eq "true")){
print <<SEARCHWORD;
<form name="glossarybrowseA" method=post action="glossary.cgi">
<input type=hidden name="letter" value="a">
</FORM>
<form name="glossarybrowseB" method=post action="glossary.cgi">
<input type=hidden name="letter" value="b">
</FORM>
<form name="glossarybrowseC" method=post action="glossary.cgi">
<input type=hidden name="letter" value="c">
</FORM>
<form name="glossarybrowseD" method=post action="glossary.cgi">
<input type=hidden name="letter" value="d">
</FORM>
<form name="glossarybrowseE" method=post action="glossary.cgi">
<input type=hidden name="letter" value="e">
</FORM>
<form name="glossarybrowseF" method=post action="glossary.cgi">
<input type=hidden name="letter" value="f">
</FORM>
<form name="glossarybrowseG" method=post action="glossary.cgi">
<input type=hidden name="letter" value="g">
</FORM>
<form name="glossarybrowseH" method=post action="glossary.cgi">
<input type=hidden name="letter" value="h">
</FORM>
<form name="glossarybrowseI" method=post action="glossary.cgi">
<input type=hidden name="letter" value="i">
</FORM>
<form name="glossarybrowseJ" method=post action="glossary.cgi">
<input type=hidden name="letter" value="j">
</FORM>
<form name="glossarybrowseK" method=post action="glossary.cgi">
<input type=hidden name="letter" value="k">
</FORM>
<form name="glossarybrowseL" method=post action="glossary.cgi">
<input type=hidden name="letter" value="l">
</FORM>
<form name="glossarybrowseM" method=post action="glossary.cgi">
<input type=hidden name="letter" value="m">
</FORM>
<form name="glossarybrowseN" method=post action="glossary.cgi">
<input type=hidden name="letter" value="n">
</FORM>
<form name="glossarybrowseO" method=post action="glossary.cgi">
<input type=hidden name="letter" value="o">
</FORM>
<form name="glossarybrowseP" method=post action="glossary.cgi">
<input type=hidden name="letter" value="p">
</FORM>
<form name="glossarybrowseQ" method=post action="glossary.cgi">
<input type=hidden name="letter" value="q">
</FORM>
<form name="glossarybrowseR" method=post action="glossary.cgi">
<input type=hidden name="letter" value="r">
</FORM>
<form name="glossarybrowseS" method=post action="glossary.cgi">
<input type=hidden name="letter" value="s">
</FORM>
<form name="glossarybrowseT" method=post action="glossary.cgi">
<input type=hidden name="letter" value="t">
</FORM>
<form name="glossarybrowseU" method=post action="glossary.cgi">
<input type=hidden name="letter" value="u">
</FORM>
<form name="glossarybrowseV" method=post action="glossary.cgi">
<input type=hidden name="letter" value="v">
</FORM>
<form name="glossarybrowseW" method=post action="glossary.cgi">
<input type=hidden name="letter" value="w">
</FORM>
<form name="glossarybrowseX" method=post action="glossary.cgi">
<input type=hidden name="letter" value="x">
</FORM>
<form name="glossarybrowseY" method=post action="glossary.cgi">
<input type=hidden name="letter" value="y">
</FORM>
<form name="glossarybrowseZ" method=post action="glossary.cgi">
<input type=hidden name="letter" value="z">
</FORM>
<div align="center">
<p><b><font size="5" color="#FFFFFF">Glossary</font></b></p>
<u><b>
<font size="4">Search Results:</font></b></u><br>

  <center>
  <table border="0" cellspacing="3" style="border-collapse: collapse" bordercolor="#111111" width="60%" cellpadding="3">
    <tr>
      <td width="100%"><center><b><font size="4"><font color="#FFFFFF">$searchword</font> means
      <font color="#000080">$componentmeaning</font></font></b></center></td>
    </tr>
  </table>
  </center>
</div>
</center>
<br><p>
                <div align="center">
  <center>
  <table border="0" cellspacing="5" style="border-collapse: collapse" bordercolor="#111111" width="80%" cellpadding="5">
    <tr>

      <td width="50%">
      <p align="center"><b><font size="4">Search Again?</font></b></td>
      <td width="50%">
      <p align="center"><font size="4"><b>Or b</b></font><b><font size="4">rowse 
      by first letter:</font></b></td>
    </tr>
    <tr>
<form method=post name="glossaryhit" action="glossary.cgi">
      <td width="50%">
      <p align="center"><input type=text name="searchword" size="20"></td>
      <td width="50%" align="center"><a href="Javascript:document.glossarybrowseA.submit()">
      <font color="#000080">A</font></a><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseB.submit()">
      <font color="#000080">B</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseC.submit()">
      <font color="#000080">C</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseD.submit()">
      <font color="#000080">D</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseE.submit()">
      <font color="#000080">E</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseF.submit()">
      <font color="#000080">F</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseG.submit()">
      <font color="#000080">G</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseH.submit()">
      <font color="#000080">H</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseI.submit()">
      <font color="#000080">I</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseJ.submit()">
      <font color="#000080">J</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseK.submit()">
      <font color="#000080">K</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseL.submit()">
      <font color="#000080">L</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseM.submit()">
      <font color="#000080">M</font></A></td>
    </tr>
    <tr>    
      <td width="50%">
      <p align="center"><b><input type=submit name="searchsubmit" value="Search" style="width: 75; height: 22; font-size: 15px"></b></td>
      </FORM>
      <td width="50%" align="center"><a href="Javascript:document.glossarybrowseN.submit()">
      <font color="#000080">N</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseO.submit()">
      <font color="#000080">O</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseP.submit()">
      <font color="#000080">P</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseQ.submit()">
      <font color="#000080">Q</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseR.submit()">
      <font color="#000080">R</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseS.submit()">
      <font color="#000080">S</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseT.submit()">
      <font color="#000080">T</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseU.submit()">
      <font color="#000080">U</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseV.submit()">
      <font color="#000080">V</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseW.submit()">
      <font color="#000080">W</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseX.submit()">
      <font color="#000080">X</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseY.submit()">
      <font color="#000080">Y</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseZ.submit()">
      <font color="#000080">Z</font></A></td>

    </tr>
  </table>
  </center>
SEARCHWORD
    }
    else{
      #browse by letter, not search word
      $counter=0;
print <<TOPPART;
<form name="glossarybrowseA" method=post action="glossary.cgi">
<input type=hidden name="letter" value="a">
</FORM>
<form name="glossarybrowseB" method=post action="glossary.cgi">
<input type=hidden name="letter" value="b">
</FORM>
<form name="glossarybrowseC" method=post action="glossary.cgi">
<input type=hidden name="letter" value="c">
</FORM>
<form name="glossarybrowseD" method=post action="glossary.cgi">
<input type=hidden name="letter" value="d">
</FORM>
<form name="glossarybrowseE" method=post action="glossary.cgi">
<input type=hidden name="letter" value="e">
</FORM>
<form name="glossarybrowseF" method=post action="glossary.cgi">
<input type=hidden name="letter" value="f">
</FORM>
<form name="glossarybrowseG" method=post action="glossary.cgi">
<input type=hidden name="letter" value="g">
</FORM>
<form name="glossarybrowseH" method=post action="glossary.cgi">
<input type=hidden name="letter" value="h">
</FORM>
<form name="glossarybrowseI" method=post action="glossary.cgi">
<input type=hidden name="letter" value="i">
</FORM>
<form name="glossarybrowseJ" method=post action="glossary.cgi">
<input type=hidden name="letter" value="j">
</FORM>
<form name="glossarybrowseK" method=post action="glossary.cgi">
<input type=hidden name="letter" value="k">
</FORM>
<form name="glossarybrowseL" method=post action="glossary.cgi">
<input type=hidden name="letter" value="l">
</FORM>
<form name="glossarybrowseM" method=post action="glossary.cgi">
<input type=hidden name="letter" value="m">
</FORM>
<form name="glossarybrowseN" method=post action="glossary.cgi">
<input type=hidden name="letter" value="n">
</FORM>
<form name="glossarybrowseO" method=post action="glossary.cgi">
<input type=hidden name="letter" value="o">
</FORM>
<form name="glossarybrowseP" method=post action="glossary.cgi">
<input type=hidden name="letter" value="p">
</FORM>
<form name="glossarybrowseQ" method=post action="glossary.cgi">
<input type=hidden name="letter" value="q">
</FORM>
<form name="glossarybrowseR" method=post action="glossary.cgi">
<input type=hidden name="letter" value="r">
</FORM>
<form name="glossarybrowseS" method=post action="glossary.cgi">
<input type=hidden name="letter" value="s">
</FORM>
<form name="glossarybrowseT" method=post action="glossary.cgi">
<input type=hidden name="letter" value="t">
</FORM>
<form name="glossarybrowseU" method=post action="glossary.cgi">
<input type=hidden name="letter" value="u">
</FORM>
<form name="glossarybrowseV" method=post action="glossary.cgi">
<input type=hidden name="letter" value="v">
</FORM>
<form name="glossarybrowseW" method=post action="glossary.cgi">
<input type=hidden name="letter" value="w">
</FORM>
<form name="glossarybrowseX" method=post action="glossary.cgi">
<input type=hidden name="letter" value="x">
</FORM>
<form name="glossarybrowseY" method=post action="glossary.cgi">
<input type=hidden name="letter" value="y">
</FORM>
<form name="glossarybrowseZ" method=post action="glossary.cgi">
<input type=hidden name="letter" value="z">
</FORM>
<div align="center">
<p><b><font size="5" color="#FFFFFF">Glossary</font></b><p>
TOPPART

my $component;
my $meaning;
$letter=uc($letter);

print "<textarea rows=\"8\" name=\"textarea\" cols=\"50\" readonly>";
print "	Entries for $letter\n\n";
foreach $wordtoprint (@sortedcomponents){
  $choppedletter="";
  $component = "";
  $meaning = "";
  while(($choppedletter ne ";")){
    $choppedletter=chop($wordtoprint);
    if ($choppedletter ne ";"){
      $meaning=$choppedletter . $meaning;
    }
  }
  $component = $wordtoprint;
  #print the component then the meaning
  print "$component	==>  $meaning";
}
if(!$component){
  print "	No entries start with this letter";
}
print "</textarea>";

print <<BOTTOMPART;
  <div align="center">
  <center>
  <table border="0" cellspacing="5" style="border-collapse: collapse" bordercolor="#111111" width="80%" cellpadding="5">
    <tr>

      <td width="50%">
      <p align="center"><b><font size="4">Search Again?</font></b></td>
      <td width="50%">
      <p align="center"><font size="4"><b>Or b</b></font><b><font size="4">rowse 
      by first letter:</font></b></td>
    </tr>
    <tr>
<form method=post name="glossaryhit" action="glossary.cgi">
      <td width="50%">
      <p align="center"><input type=text name="searchword" size="20"></td>
      <td width="50%" align="center"><a href="Javascript:document.glossarybrowseA.submit()">
      <font color="#000080">A</font></a><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseB.submit()">
      <font color="#000080">B</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseC.submit()">
      <font color="#000080">C</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseD.submit()">
      <font color="#000080">D</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseE.submit()">
      <font color="#000080">E</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseF.submit()">
      <font color="#000080">F</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseG.submit()">
      <font color="#000080">G</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseH.submit()">
      <font color="#000080">H</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseI.submit()">
      <font color="#000080">I</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseJ.submit()">
      <font color="#000080">J</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseK.submit()">
      <font color="#000080">K</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseL.submit()">
      <font color="#000080">L</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseM.submit()">
      <font color="#000080">M</font></A></td>
    </tr>
    <tr>    
      <td width="50%">
      <p align="center"><b><input type=submit name="searchsubmit" value="Search" style="width: 75; height: 22; font-size: 15px"></b></td>
      </FORM>
      <td width="50%" align="center"><a href="Javascript:document.glossarybrowseN.submit()">
      <font color="#000080">N</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseO.submit()">
      <font color="#000080">O</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseP.submit()">
      <font color="#000080">P</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseQ.submit()">
      <font color="#000080">Q</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseR.submit()">
      <font color="#000080">R</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseS.submit()">
      <font color="#000080">S</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseT.submit()">
      <font color="#000080">T</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseU.submit()">
      <font color="#000080">U</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseV.submit()">
      <font color="#000080">V</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseW.submit()">
      <font color="#000080">W</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseX.submit()">
      <font color="#000080">X</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseY.submit()">
      <font color="#000080">Y</font></A><font color="#000080"> </font> <a href="Javascript:document.glossarybrowseZ.submit()">
      <font color="#000080">Z</font></A></td>

    </tr>
  </table>
  </center>
BOTTOMPART
      while($sortedcomponents[$counter]){
        $counter++;
      }#end of while statement
    }#end of else statement
  } # end of if line eq <!--main--!>
print "$line";
} # end of while loop

close(STUDENTPAGE);

exit(0);
