#!/usr/bin/perl
#=========================================================================
#Filename: exercises.cgi
#Written By: Trevor Barnett
#File Description:
#  Accepts a chapter number and exercise number as input from CGI.  The
#  script opens the exercise page template and prints out the file content
#  until it finds a hidden comment used to mark the main part of this page.
#  At this point, the script stops printing the template file and opens the
#  exercise file using the chapter number and exercise number accepted as
#  CGI input.  Then the script prints out the exercise form by interpreting
#  the predefined standard for exercise files.  The script also prints out
#  JavaScript which is used to submit other forms on the exercise page, like
#  the hint page forms.  After the script finishes printing the exercise,
#  the script resumes printing the remainder of the exercise page template
#  file and exits.  
#=========================================================================
use strict;
use CGI;
my $line;
my $q=new CGI;
my $chapter = $q->param('chapter');
my $exercise = $q->param('exercise');
my @chapterlist = ("Select a chapter", "Chapter 1 -- Word-Building Basics", "Chapter 2 -- Word-Building Tools: Greek Components", "Chapter 3 -- Word-Building Tools: Latin Components", "Chapter 4 -- Mythology", "Chapter 5 -- Medicine", "Chapter 6 -- Politics and Law", "Chapter 7 -- Commerce and Economics", "Chapter 8 -- Philosophy and Psychology", "Chapter 9 -- History");
my $searchforexercises="true";
my $exercisenum=1;
my $question=1;
my @answer;
my @questions;
my @answer1;
my @answer2;
my @answer3;
my @answer4;
my $counter=1;
my $numexercises;
my $questionnum=1;
my $numberofexercises=0;

print "Content-type:text/html\n\n";

open(EXERCISEPAGE, "exercisepage.html");
while($line=<EXERCISEPAGE>){
  if($chapter){
    $line =~ s/option value=\"$chapter\"/option value=\"$chapter\" selected/;
  }

  print "$line";
  if($line eq "<!--CHAPTERBANNER--!>\n"){
    if(($chapter)&&($chapter ne "0")){
      print "$chapterlist[$chapter]";
    }
    else{
      print "No Chapter Selected";
    }
  }
  if($line eq "<!--STARTOFEXERCISE--!>\n"){
    if((!$chapter) || ($chapter eq "0")){
      print "<p align=\"center\"><font size=\"4\"><b>No Chapter Selected</b></font></p>";
      print "<p align=\"center\"><font size=\"4\"><b>No Exercises Available</b></font></p>";
    }
    else{
      print "<p align=\"center\"><font size=\"4\"><b>$chapterlist[$chapter]</b></font></p>";
        while((!(-e "chapter$chapter/exercise$exercisenum.txt")) && ($exercisenum<100)){
          $exercisenum++;
        }
        while(-e "chapter$chapter/exercise$exercisenum.txt"){
          print "<form name=\"exercise$exercisenum\" method=post action=\"exercises.cgi\">";
          print "<p align=\"center\"><font size=\"4\"><b><a href=\"Javascript:document.exercise$exercisenum.submit()\">Exercise $exercisenum</a></b></font></p>";
          print "<input type=hidden name=chapter value=$chapter>";
          print "<input type=hidden name=exercise value=$exercisenum>\n";
          print "</FORM>\n";
          $exercisenum=$exercisenum+1;
          $numberofexercises++;
          while((!(-e "chapter$chapter/exercise$exercisenum.txt")) && ($exercisenum<100)){
            $exercisenum++;
          }
         }
         if($numberofexercises eq "0"){
            print "<p align=\"center\"><font size=\"4\"><b>No Exercises Available</b></font></p>";
         } #end if numberofexercises equals 0
      } # end of else
  } # end of line eq startofexercise
  if($line eq "<!--STARTOFMAIN--!>\n"){
    if((!$chapter)||($chapter eq "0")){
	print "<p align=\"center\"><b><font size=\"5\">No Chapter Selected</font></b></p>";
    }
    else{
	print "<p align=\"center\"><b><font size=\"5\">$chapterlist[$chapter]</font></b></p>";
    }
    if(!$exercise){
	print "<p align=\"center\"><b><font size=\"5\">No Exercise Selected</font></b></p>";
    }
    else{
      #print the exercise!
      print "<p align=\"center\"><b><font size=\"5\">Exercise $exercise</font></b></p>";

      open(EXERCISE, "chapter$chapter/exercise$exercise.txt");
      $line=<EXERCISE>;
      $numexercises=$line;
      print "<form method=post name=exercise$exercise action=\"exercisegrader.cgi\">";
      print "<div align=\"center\"><center> <table border=\"0\" cellspacing=\"1\" style=\"border-collapse: collapse\" bordercolor=\"#111111\" width=\"80%\">";
      print "<tr><td width=\"100%\">";
      while($line=<EXERCISE>){
        print "<hr>";
        if($line eq "<MC>\n"){
        $line=<EXERCISE>;
        $questions[$question]=$line;
#        print "<b>$question.</b> $line [<a href=\"Javascript:document.question$question.submit()\">Hint</a>]<br>";
        print "<b>$question.</b> $line <input type=button style=\"width: 32; height: 20; font-size: 12px\" name=submit$question value=Hint onClick=\"Javascript:document.question$question.submit()\"><br>";
        $line=<EXERCISE>;
        print "<input type=radio name=question$question value=\"A\">A: $line<br>";
        $answer1[$question]=$line;
        $line=<EXERCISE>;
        print "<input type=radio name=question$question value=\"B\">B: $line<br>";
        $answer2[$question]=$line;
        $line=<EXERCISE>;
        print "<input type=radio name=question$question value=\"C\">C: $line<br>";
        $answer3[$question]=$line;
        $line=<EXERCISE>;
        print "<input type=radio name=question$question value=\"D\">D: $line<br>";
        $answer4[$question]=$line;
        #read answer and store it
        $line=<EXERCISE>;
        $answer[$question]=$line;
        $question=$question+1;
        }
        elsif($line eq "<TF>\n"){
        $line=<EXERCISE>;
        $questions[$question]=$line;
#        print "<b>$question.</b> $line [<a href=\"Javascript:document.question$question.submit()\">Hint</a>]<br>";
        print "<b>$question.</b> $line <input type=button style=\"width: 32; height: 20; font-size: 12px\" name=submit$question value=Hint onClick=\"Javascript:document.question$question.submit()\"><br>";
        print "<input type=radio name=question$question value=\"true\"> True <br>";
        print "<input type=radio name=question$question value=\"false\"> False <br>";
        $line=<EXERCISE>;
        $answer[$question]=$line;
        $question=$question+1;
        }
        elsif($line eq "<FIB>\n"){
        $line=<EXERCISE>;
        $questions[$question]=$line;
#        print "<b>$question.</b> $line [<a href=\"Javascript:document.question$question.submit()\">Hint</a>]<br>";
        print "<b>$question.</b> $line <input type=button style=\"width: 32; height: 20; font-size: 12px\" name=submit$question value=Hint onClick=\"Javascript:document.question$question.submit()\"><br>";
        $line=<EXERCISE>;
        $answer[$question]=$line;
        print "<input type=text name=question$question> <br>";
        $question=$question+1;
        }
      }
      close(EXERCISE);
      print "<hr><br><center><input type=submit name=submit value=\"Submit Answers for Grading\">&nbsp;&nbsp;&nbsp;&nbsp;";
      print "<input type=reset name=reset value=\"Clear Answers and Start Over\"></center>";
      while($answer[$counter]){
        print "<input type=hidden name=answer value=$answer[$counter]>";
        $counter=$counter+1;
      }
      print "<input type=hidden name=chapter value=\"$chapter\"> <br>";
      print "<input type=hidden name=exercise value=\"$exercise\"><br>";
      print "<input type=hidden name=numexercises value=\"$numexercises\"><br>";
      print "</FORM>";

      print "</td></tr></table></center></div></tr></table></div>";
      #print the hint forms
      while($questionnum<=$numexercises){
        print "<form method=post name=question$questionnum action=\"hintgenerator.cgi\" onSubmit=\"hintimage=window.open('hint','hintimage','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no, width=1, height=1, left=3000, top=3000'); hintimage.focus(); return false;\" target=\"hintimage\" >\n";
        print "<input type=hidden name=questionnum value=$questionnum>\n";
        print "<input type=hidden name=exercise value=$exercise>\n";
        print "<input type=hidden name=chapter value=$chapter>\n";
        $answer1[$questionnum] =~ s/"/''/g;
        $answer2[$questionnum] =~ s/"/''/g;
        $answer3[$questionnum] =~ s/"/''/g;
        $answer4[$questionnum] =~ s/"/''/g;
        $questions[$questionnum] =~ s/"/''/g;
        print "<input type=hidden name=answer1 value=\"$answer1[$questionnum]\">\n";
        print "<input type=hidden name=answer2 value=\"$answer2[$questionnum]\">\n";
        print "<input type=hidden name=answer3 value=\"$answer3[$questionnum]\">\n";
        print "<input type=hidden name=answer4 value=\"$answer4[$questionnum]\">\n";
        print "<input type=hidden name=question value=\"$questions[$questionnum]\">\n";
        print "</FORM>";
        $questionnum=$questionnum+1;
      }
      #stop printing the hint forms!

    }
  }
}

close EXERCISEPAGE;
exit(0);
