#!/usr/bin/perl
#=========================================================================
#Filename: exercisegrader.cgi
#Written By: Trevor Barnett
#File Description:
#  Accepts a chapter number, exercise number, and up to 25 pairs of user
#  answers and correct answers as CGI input.  The script inserts the user
#  answers and correct answers into two different arrays to allow for easier
#  processing.  The script compares the two sets of array elements and counts
#  the number of matches to determine the total number of correct responses.
#  Then the script prints out a summary of the exercise containing the
#  percentage of correct answers, the number of correct answers, the number
#  of incorrect answers, and the number of questions not answered.  Then the
#  script opens the exercise file using the chapter number and exercise number
#  accepted as CGI input.  The script reads the exercise questions from the
#  exercise file and prints out all the questions.  Under every question the
#  script prints the users answer, correct answer, and whether it is correct
#  or incorrect.  The script prints all of this information in html format
#  using the exercises-webpage template.  This template allows the user to
#  immediately select a new chapter and exercise from the current screen.  
#=========================================================================
use strict;
use CGI;
my $line;
my $q=new CGI;
my $chapter = $q->param('chapter');
my $exercise = $q->param('exercise');
my @chapterlist = ("Select a chapter", "Chapter 1 -- Word-Building Basics", "Chapter 2 -- Word-Building Tools: Greek Components", "Chapter 3 -- Word-Building Tools: Latin Components", "Chapter 4 -- Mythology", "Chapter 5 -- Medicine", "Chapter 6 -- Politics and Law", "Chapter 7 -- Commerce and Economics", "Chapter 8 -- Philosophy and Psychology", "Chapter 9 -- History");
my $searchforexercises="true";
my $exercisenum=1;
my $question=1;
my $numexercises=$q->param('numexercises');
my @answer=$q->param('answer');
my $counter=1;
my $question1=$q->param('question1');
my $question2=$q->param('question2');
my $question3=$q->param('question3');
my $question4=$q->param('question4');
my $question5=$q->param('question5');
my $question6=$q->param('question6');
my $question7=$q->param('question7');
my $question8=$q->param('question8');
my $question9=$q->param('question9');
my $question10=$q->param('question10');
my $question11=$q->param('question11');
my $question12=$q->param('question12');
my $question13=$q->param('question13');
my $question14=$q->param('question14');
my $question15=$q->param('question15');
my $question16=$q->param('question16');
my $question17=$q->param('question17');
my $question18=$q->param('question18');
my $question19=$q->param('question19');
my $question20=$q->param('question20');
my $question21=$q->param('question21');
my $question22=$q->param('question22');
my $question23=$q->param('question23');
my $question24=$q->param('question24');
my $question25=$q->param('question25');
my @questionresult;
my @useranswers=($question1, $question2,$question3,$question4,$question5,$question6,$question7,$question8,$question9,
                 $question10, $question11, $question12, $question13, $question14, $question15, $question16, $question17,
                 $question18, $question19, $question20, $question21,$question22,$question23,$question24,$question25);
my $numcorrectanswers=0;
my $numunanswered=0;
my $qcounter=0;
while($qcounter<$numexercises){
  if($useranswers[$qcounter] eq $answer[$qcounter]){
    $questionresult[$qcounter]="Correct";
    $numcorrectanswers=$numcorrectanswers+1;
  }
  elsif(!$useranswers[$qcounter]){
    $questionresult[$qcounter]="Not Answered";
    $numunanswered=$numunanswered+1;
  }
  else{
    $questionresult[$qcounter]="Incorrect";
  }
  $qcounter=$qcounter+1;
}
my $percentcorrect=(($numcorrectanswers/1.0)/($numexercises/1.0))*100.0;
$percentcorrect=sprintf("%.1f", $percentcorrect);
my $numincorrectanswers=$numexercises-$numcorrectanswers-$numunanswered;

print "Content-type:text/html\n\n";

open(EXERCISEPAGE, "exercisepage.html");
while($line=<EXERCISEPAGE>){
  if($chapter){
    $line =~ s/option value=\"$chapter\"/option value=\"$chapter\" selected/;
  }
  else{
    $line =~ s/$chapterlist[0]/$chapterlist[0] selected/;
  }
  print "$line";
  if($line eq "<!--CHAPTERBANNER--!>\n"){
    if(($chapter)&&($chapter ne "0")){
      print "$chapterlist[$chapter]";
    }
    else{
      print "No Chapter Selected";
    }
  }
  if($line eq "<!--STARTOFEXERCISE--!>\n"){
    if((!$chapter) || ($chapter eq "0")){
      print "<p align=\"center\"><font size=\"4\"><b>No Chapter Selected</b></font></p>";
      print "<p align=\"center\"><font size=\"4\"><b>No Exercises Available</b></font></p>";
    }
    else{
      print "<p align=\"center\"><font size=\"4\"><b>$chapterlist[$chapter]</b></font></p>";
      while($searchforexercises eq "true"){
        if(-e "chapter$chapter/exercise$exercisenum.txt") {
          print "<form name=\"exercise$exercisenum\" method=post action=\"exercises.cgi\">";
          print "<p align=\"center\"><font size=\"4\"><b><a href=\"Javascript:document.exercise$exercisenum.submit()\">Exercise $exercisenum</a></b></font></p>";
          print "<input type=hidden name=chapter value=$chapter>";
          print "<input type=hidden name=exercise value=$exercisenum>";
          print "</FORM>";
          $exercisenum=$exercisenum+1;
        }
        else{
          $searchforexercises="false";
          if($exercisenum == 1){
            print "<p align=\"center\"><font size=\"4\"><b>No Exercises Available</b></font></p>";
          }
        }
      }
    }
  }
  if($line eq "<!--STARTOFMAIN--!>\n"){
    if((!$chapter)||($chapter eq "0")){
	print "<p align=\"center\"><b><font size=\"5\">No Chapter Selected</font></b></p>";
    }
    else{
	print "<p align=\"center\"><b><font size=\"5\">$chapterlist[$chapter]</font></b></p>";
    }
    if(!$exercise){
	print "<p align=\"center\"><b><font size=\"5\">No Exercise Selected</font></b></p>";
    }
    else{
      #print the exercise!
      print "<p align=\"center\"><b><font size=\"5\">Exercise $exercise Results</font></b></p>";
      #insert graph of results here!!!
      print<<TABLE;
      <div align="center">
        <center>
        <table border="2" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%">
          <tr>
            <td width="100%">
            <p align="center"><b><font size="5">Summary: $percentcorrect% Correct</font></b></p>
            <blockquote>
              <p><font size="4">Out of $numexercises Questions, here are 
            your results:<br>$numcorrectanswers <font color="#008000">Correct</font><br> $numincorrectanswers
              <font color="#800000">Incorrect</font><br> $numunanswered 
              <font color="#000080">Not Answered</font></font></blockquote>
            </td>
          </tr>
        </table>
        </center>
      </div>
<br><p></p><br>
TABLE
      print "<div align=\"center\"><center> <table border=\"0\" cellspacing=\"1\" style=\"border-collapse: collapse\" bordercolor=\"#111111\" width=\"80%\">";
      print "<tr><td width=\"100%\">";

      open(EXERCISE, "chapter$chapter/exercise$exercise.txt");
      $line=<EXERCISE>;
      while($line=<EXERCISE>){
        print "<hr>";
        if($line eq "<MC>\n"){
        $line=<EXERCISE>;
        print "<b>$question.</b> $line <br>";
        print "&nbsp;&nbsp;&nbsp;Your Answer: $useranswers[$question-1]<br>";
        print "&nbsp;&nbsp;&nbsp;The Correct Answer: $answer[$question-1]<br>";
        if($questionresult[$question-1] eq "Correct"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"5\" color=\"#008000\">Correct</font></b>";
        }
        elsif($questionresult[$question-1] eq "Incorrect"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#800000\" size=\"5\">Incorrect</font></b>";
        }
        elsif($questionresult[$question-1] eq "Not Answered"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#000080\" size=\"5\">Not Answered</font></b>";
        }

        $line=<EXERCISE>;
        $line=<EXERCISE>;
        $line=<EXERCISE>;
        $line=<EXERCISE>;
        $line=<EXERCISE>;
        $question=$question+1;
        }
        elsif($line eq "<TF>\n"){
        $line=<EXERCISE>;
        print "<b>$question.</b> $line <br>";
        print "&nbsp;&nbsp;&nbsp;Your Answer: $useranswers[$question-1]<br>";
        print "&nbsp;&nbsp;&nbsp;The Correct Answer: $answer[$question-1]<br>";
        if($questionresult[$question-1] eq "Correct"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"5\" color=\"#008000\">Correct</font></b>";
        }
        elsif($questionresult[$question-1] eq "Incorrect"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#800000\" size=\"5\">Incorrect</font></b>";
        }
        elsif($questionresult[$question-1] eq "Not Answered"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#000080\" size=\"5\">Not Answered</font></b>";
        }
        $line=<EXERCISE>;
        $question=$question+1;
        }
        elsif($line eq "<FIB>\n"){
        $line=<EXERCISE>;
        print "<b>$question.</b> $line <br>";
        print "&nbsp;&nbsp;&nbsp;Your Answer: $useranswers[$question-1]<br>";
        print "&nbsp;&nbsp;&nbsp;The Correct Answer: $answer[$question-1]<br>";
        if($questionresult[$question-1] eq "Correct"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font size=\"5\" color=\"#008000\">Correct</font></b>";
        }
        elsif($questionresult[$question-1] eq "Incorrect"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#800000\" size=\"5\">Incorrect</font></b>";
        }
        elsif($questionresult[$question-1] eq "Not Answered"){
          print "<p>&nbsp;&nbsp;&nbsp;<b><font color=\"#000080\" size=\"5\">Not Answered</font></b>";
        }
        $line=<EXERCISE>;
        $question=$question+1;
        }
      }
      close(EXERCISE);
      print "<hr><br>";
      print "</FORM>";
      print "</td></tr></table></center></div></tr></table></div>";
    }
  }
}

close EXERCISEPAGE;
exit(0);
