#!/usr/bin/perl
require 'mainlibrary.pl';
#=========================================================================
#Filename: emailstudents.cgi
#Written By: Trevor Barnett
#File Description:
#  Accepts an email address, name, and message from form input through the
#  CGI.  Then the script uses DBI to connect to the database.  Once 
#  connected, the script runs a query to select the email address column
#  from the users table where the usertype field equals student.  This
#  query finds every registered student in the database, and stores the
#  results in an array.  For every entry in the array, the script sends
#  out an email containing the name, message, and email address that it
#  receives as form input.  After that, the script prints a success page,
#  closes the database connection, and exits.  This script can only be
#  accessed by teachers and takes security precautions to make sure that
#  no unauthorized users can access it.  Before the script connects to the
#  database, it checks the browsers cookie file to make sure that the user
#  is a teacher and has a userid and username that match a teacher.  These
#  checks should prevent the script from being abused.
#=========================================================================
use CGI;
use DBI;
my $q=new CGI;
my $youremail=$q->param('youremail');
my $yourname=$q->param('yourname');
my $message=$q->param('message');
my $line;
my @emailaddresses;
my $recipient;
my $database = $dbname;
my $port = $dbport;
my $dsn = $dbpassword;
my $dbh = DBI->connect($dsn)
   or exit(1);
my $sth;

if(($youremail)&&($yourname)) {
#send that email
$sth = $dbh->prepare ("SELECT emailaddress FROM users WHERE usertype='student'");
$sth->execute();
while (@emailaddresses = $sth->fetchrow_array()){
open(MAIL, "| /usr/sbin/sendmail -oi -n -t");
print MAIL <<MAIL_MESSAGE;
To:@emailaddresses
From:$youremail
Subject: Message from $yourname, a MostWise.com teacher

$message
MAIL_MESSAGE
close MAIL;
}
$sth->finish();
$dbh->disconnect();

#print post-email page
print "Content-type:text/html\n\n";
open(SUCCESS, "teacher.html");
while($line=<SUCCESS>){
  print "$line";
  if($line eq "<!--MAIN--!>\n"){
    print<<SUCCESS;
                <p align="center"><font color="#FFFFFF">
                <span style="font-weight: 700; font-size: 16pt">Message 
                successfully sent to all students</span></font></p>
                <div align="center">
                  <center>
                  <table border="0" cellpadding="4" style="border-collapse: collapse" bordercolor="#111111" width="60%" cellspacing="4">
                    <tr>
                      <td width="100%"><font size="4">All MostWise.com students will receive this message shortly.</font></td>
                    </tr>
                  </table>
                  </center>
SUCCESS
  }
}
}

else{
print "Content-type:text/html\n\n";
open(ERROR, "teacher.html");
while($line=<ERROR>){
  print "$line";
  if($line eq "<!--MAIN--!>\n"){
    print<<ERROR;
                <p align="center"><font color="#FFFFFF">
                <span style="font-size: 16pt; font-weight: 700">Error!</span></font></p>
                <div align="center">
                  <center>
                  <table border="0" cellpadding="3" style="border-collapse: collapse" bordercolor="#111111" width="80%" cellspacing="3">
                    <tr>
                      <td width="100%"><font size="4">Sorry you did not complete all the required fields.</font></td>
                    </tr>
                    <tr>
                      <td width="100%"><font size="4">Please use the <b><a href="javascript: history.go(-1)" >
                      <font color="#FFFFFF">Back</font></a></b> button on your browser and try again.
              
                </div>
                      </font></td>
                    </tr>
                  </table>
ERROR
  }
}
}
