#!/usr/bin/perl
require 'mainlibrary.pl';
#=========================================================================
#Filename: changepassword.cgi
#Written By: Trevor Barnett
#  Accepts an old password, new password, and a retype of the new password 
#  as input from CGI. If the old password matches the password in the 
#  database and the new passwords are the same, then this script will 
#  connect to the database and change the users password to the new password.  
#  All passwords are stored using a one-way encryption algorithm.  
#=========================================================================
use CGI; #Common Gateway Interface
use DBI; #DataBase interface
require 'cookielib/cookie.lib';  #Cookie library
my $line; #line of HTML from a webpage template
my $name; #username that is retrieved from cookies
my $type; #usertype that is retrieved from cookies
my $id;   #userid that is retrieved from cookies
my $q=new CGI; #CGI variable
my $usertype; #usertype that is retrieved from the database
my $userid; #userid that is retrieved from the database
my $oldpassword = $q->param('oldpassword'); #old password supplied from CGI
my $newpassword = $q->param('newpassword'); #new password supplied from CGI
my $retypepassword = $q -> param('retypepassword'); #should be the same as newpassword

#print the content in HTML
print "Content-type:text/html\n\n";

#Get the information from the cookies
if((&GetCookies('name'))&&(&GetCookies('userid'))&&(&GetCookies('usertype'))){
  $name=$Cookies{'name'};
  $type=$Cookies{'usertype'};
  $id=$Cookies{'userid'};
} 
else{
  #if you can't get the cookies then take then to the MostWise homepage
  #because they aren't logged in
  open(HOMEPAGE, "../html/homeoriginal.html");
  while($line=<HOMEPAGE>){
    print "$line\n";
  }
  close (HOMEPAGE);
  exit(0);
}

#We have the cookies so connect to the database
my $database = $dbname; #database name
my $port = $dbport; #database port
my $dsn = $dbpassword; #password file location

#connect to database
my $dbh = DBI->connect($dsn)
   or exit(1);

#query database for userid
my $sth = $dbh->prepare ("SELECT userid FROM users WHERE username = '$name' AND password=PASSWORD('$oldpassword')");
$sth->execute();
$userid= $sth->fetchrow_array();
$sth->finish();

#query database for usertype
$sth = $dbh->prepare ("SELECT usertype FROM users WHERE username = '$name' AND password=PASSWORD('$oldpassword')");
$sth->execute();
$usertype = $sth->fetchrow_array();
$sth->finish();

#check to see which webpage template to display
if($type eq "administrator"){
  open(PAGE, "administrator.html");
}
elsif($type eq "teacher"){
  open(PAGE, "teacher.html");
}
elsif($type eq "student"){
  open(PAGE, "student.html");
}

#get each line from webpage template and print it out
while($line=<PAGE>){
  #if we get the special line then print out information about the password change
  if($line eq "<!--MAIN--!>\n"){
    #check to see if password info matches cookie and database info
    if(($newpassword eq $retypepassword)&&($userid eq $id)&&($newpassword)&&($usertype eq $type)){
      #change the password in the database
      $sth = $dbh->prepare("UPDATE users SET password = PASSWORD('$newpassword') WHERE userid='$userid'");
      $sth->execute();
      $sth->finish();
      print<<RESETPASSWORD;
        <p align="center"><font size="5" color="#FFFFFF">Password Changed</font><font size="4"><p align="center">          
        </div><center>
        Your password has been successfully changed.</center></font>
RESETPASSWORD
    }
    else{
      #information did not match so do not change the password
      print<<ERROR;
      <p><center><font style="font-size: 16pt" color="#FF3300" face="Arial Black">Error!</font></center><br>
      <div align="center">
      <center>
      <table border="0" cellpadding="2" style="border-collapse: collapse" bordercolor="#111111" width="60%">
      <tr>
      <td width="100%"><font size="4">Passwords do not match.  Please use the <a href="javascript: history.go(-1)" >Back</a> button and try again.</font></td>
      </tr>
      </table>
      </center>
      </div>
ERROR
    }
  }
  print "$line"; #this line contains one line of html code from the webpage template
}

#close the webpage template file
close PAGE;
$dbh->disconnect(); #disconnect from the database
exit(0); #exit the program

