#!/usr/bin/perl
#=========================================================================
#Filename: addtoglossary.cgi
#Written By: Trevor Barnett
#File Description:
#  Initially displays a form that contains empty text fields for word 
#  components and the components meaning.  When submitted, this form adds 
#  these entries to the site glossary.
#=========================================================================
use strict;
use CGI;  #needed for accepting input
my $line; #String variable used to print documents
my $q=new CGI;  #CGI variable
my $componentNumber=8; #number of possible pairs
my $component1 = $q->param('component1'); #String CGI input containing word component 1
my $component2 = $q->param('component2'); #String CGI input containing word component 2
my $component3 = $q->param('component3'); #String CGI input containing word component 3
my $component4 = $q->param('component4'); #String CGI input containing word component 4
my $component5 = $q->param('component5'); #String CGI input containing word component 5
my $component6 = $q->param('component6'); #String CGI input containing word component 6
my $component7 = $q->param('component7'); #String CGI input containing word component 7
my $component8 = $q->param('component8'); #String CGI input containing word component 8

my $meaning1 = $q->param('meaning1'); #String CGI input containing component meaning 1
my $meaning2 = $q->param('meaning2'); #String CGI input containing component meaning 2
my $meaning3 = $q->param('meaning3'); #String CGI input containing component meaning 3
my $meaning4 = $q->param('meaning4'); #String CGI input containing component meaning 4
my $meaning5 = $q->param('meaning5'); #String CGI input containing component meaning 5
my $meaning6 = $q->param('meaning6'); #String CGI input containing component meaning 6
my $meaning7 = $q->param('meaning7'); #String CGI input containing component meaning 7
my $meaning8 = $q->param('meaning8'); #String CGI input containing component meaning 8

my $success="true"; #true if number of components matches number of meanings
my @component=($component1, $component2, $component3, $component4, $component5, 
               $component6, $component7, $component8); #array containing word components
my @meaning=($meaning1, $meaning2, $meaning3, $meaning4, $meaning5,
             $meaning6, $meaning7, $meaning8); #array containing word meanings
my $counter=0; #loop counter variable

#check to make sure our pairs match up
while($counter<$componentNumber){
if($component[$counter]){
  if(!$meaning[$counter]){
    $success="false";
  }
}   
$counter = $counter + 1;
}
#end of check
#check to see if glossary exists
if(!(-e "glossary/glossary.txt")){
  $success="false";
}
#end of glossary exists check

# if everything checks out ok, then add the pairs to the glossary
# pairs are added as "wordcomponent;wordmeaning"
if($success eq "true"){
  $counter=0;
  #open file for writing or give error
  open(FILEOUT, ">>glossary/glossary.txt") or dienice("Can't open glossary for writing: $!");
  #lock file
  flock(FILEOUT, 2);
  seek(FILEOUT, 0, 2);
  while($counter<10){
    if($component[$counter]){
      if($meaning[$counter]){
        #add it to the glossary
        print FILEOUT "$component[$counter]; $meaning[$counter]\n";
      }
    }   
    $counter = $counter + 1;
  }
  #close and unlock file
  close(FILEOUT);
}

#print the page in HTML
print "Content-type:text/html\n\n";
#open the administrator webpage template
open(ADMINPAGE, "administrator.html");
#prints all the lines in the document
while($line=<ADMINPAGE>){
  #if we hit the special line then print information based on success or failure
  if($line eq "<!--MAIN--!>\n"){
    # if we were successful in adding to the glossary then print this page
    if($success eq "true"){
     print <<SUCCESS;
     <center><b><font color="#000080" size="4">Words added successfully.&nbsp; Add 
     more to glossary.</font></b></center>
     <div align="center">
     <center>
     <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="75%">
     <tr>
     <form method=post action="addtoglossary.cgi" name="addtoglossary">
     <td width="50%" align="center"><b>Word Component</b></td>
     <td width="50%" align="center"><b>Component Meaning</b></td>
     </tr>
     <tr>
     <td width="50%" align="center"><input type=text name="component1" size="15"></td>
     <td width="50%" align="center"><input type=text name="meaning1" size="35"></td>
     </tr>
     <tr>
     <td width="50%" align="center"><input type=text name="component2" size="15"></td>
     <td width="50%" align="center"><input type=text name="meaning2" size="35"></td>
     </tr>
     <tr>
     <td width="50%" align="center"><input type=text name="component3" size="15"></td>
     <td width="50%" align="center"><input type=text name="meaning3" size="35"></td>
     </tr>
     <tr>
     <td width="50%" align="center"><input type=text name="component4" size="15"></td>
     <td width="50%" align="center"><input type=text name="meaning4" size="35"></td>
     </tr>
     <tr>
     <td width="50%" align="center"><input type=text name="component5" size="15"></td>
     <td width="50%" align="center"><input type=text name="meaning5" size="35"></td>
     </tr>
     <tr>
     <td width="50%" align="center"><input type=text name="component6" size="15"></td>
     <td width="50%" align="center"><input type=text name="meaning6" size="35"></td>
     </tr>
     <tr>
     <td width="50%" align="center"><input type=text name="component7" size="15"></td>
     <td width="50%" align="center"><input type=text name="meaning7" size="35"></td>
     </tr>
     <tr>
     <td width="50%" align="center"><input type=text name="component8" size="15"></td>
     <td width="50%" align="center"><input type=text name="meaning8" size="35"></td>
     </tr>
     </table>
     </center>
     </div>
     <table height="5">
     <tr><td></td></tr></table>
     <center><input type="submit" name="submit" value="Add To Glossary">
     </FORM></center>
SUCCESS
    } #else print the error page
    else{
     print<<NOTSUCCESS;
     <center><b><font size="5" color="#FF0000">Error adding to glossary</font></center></b></p>
     <div align="center">
     <center>
     <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="60%">
     <tr>
     <td width="100%"><font size="4">No new components have been added.&nbsp; Check to make sure that you have entered both components and meanings.
     </font></td>
     </tr>
     </table>
     </center>
     </div>
NOTSUCCESS
   }
  } # end of if line eq <!--main--!>
  print "$line"; #line is from adminpage
} # end of while loop
#close the administrator page
close ADMINPAGE;
exit(0);

#procedure dienice generates an error if the glossary cannot be opening
sub dienice {
 my($msg) = @_; 
 print "Content-type:text/html\n\n";
 print "<html>\n<head>\n<title>Error Opening File!</title>\n";
 print "</head>\n";
 print "<body><h2>Error</h2>\n<b>";
 print $msg; 
print "\n</b></body>\n</html>"; 
exit; 
}

