        /*
 *
 * gridblock.java
 */

/**
 *  A gridblock object is a multidimensional array of block objects
 *
 * Darra Ricks
 */
import java.awt.*;
import javax.swing.*;



public class gridblock extends JPanel {

    Block myblocks[][];
    globals Global = new globals();
    Category cat1,cat2;
    int catid1,catid2; //category index number
    int myindex1,myindex2; //grid block position index
    int butwidth,buthieght;
    int width, hieght;
    int optnum;
    int falserowcnt[];
    int falsecolcnt[];
    boolean truerowcnt[];
    boolean truecolcnt[];
    globals Globals = new globals();
    boolean autocomp = false;

    ///Constructor which sets the indexes of each grid region
    gridblock(int opt_num, int idx1, int idx2,int catidx1,int catidx2) {
        optnum = opt_num;
        myindex1 = idx1;
        myindex2 = idx2;
        catid1 = catidx1;
        catid2 = catidx2;

        myblocks = new Block[opt_num][opt_num];
        falserowcnt = new int[opt_num];
        falsecolcnt = new int[opt_num];

        truerowcnt = new boolean[opt_num];
        truecolcnt = new boolean[opt_num];


        butwidth = Global.offset;
        buthieght = butwidth;
        width = (butwidth * opt_num);
        hieght = width;

        this.setSize(width, hieght);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        Dimension paneldimension = new Dimension(width, hieght);
        this.setPreferredSize(paneldimension);
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();

        this.setLayout(gbag);


        int xpos = 0;
        int ypos = 0;
        //Create Block objects, add actionlisteners and align them on the gridblock panel
        for (int i = 0; i < opt_num; ++i) {
            for (int j = 0; j < opt_num; ++j) {
                myblocks[i][j] = new Block(i, j, myindex1, myindex2);
                Dimension blockdimension = new Dimension(24, 24);
                myblocks[i][j].setPreferredSize(blockdimension);

                gbc.gridx = xpos;
                gbc.gridy = ypos;
                gbag.setConstraints(myblocks[i][j], gbc);
                this.add(myblocks[i][j]);
                ++xpos;
            }
            xpos = 0;

            ++ypos;
        }

		//Each grid block region corresponds to a category pair, cat1 and cat1
        cat1 = new Category(opt_num);
        cat2 = new Category(opt_num);
    }



    //Action listener for blocks to ensure that no more that numberofoptions-1 false blocks are selected and only one true block is
    //selected
   public void autocomplete()
   {
       for(int i=0; i<optnum; ++i)
       {
           for(int j=0; j<optnum; ++j)
           {
               autocomplete2(i,j,myblocks[i][j].getblocknum());
           }
       }
   }



    public void autocomplete2(int rowindex1, int colindex2, int status) {

			//If status of block is true then set all remaining blocks in its corresponding
			//row and column to false
            if (status == 2) {
                for (int i = 0; i < optnum; ++i) {
                    if (i != colindex2) //if i does not equal the true blocks column index
                    {
                        myblocks[rowindex1][i].setblock(1); //set all in row to false
                    }

                    if (i != rowindex1) //if i does not equal the true blocks row index
                    {
                        myblocks[i][colindex2].setblock(1);  //set all in column to false
                    }
                }
            }


            if((status ==1) && (optnum == 2))
            {
                for(int i= 0; i<optnum; ++i)
                {
                    if(i != colindex2)
                    {
                        myblocks[rowindex1][i].setblock(2);
                    }
                    if(i!=rowindex1)
                    {
                        myblocks[i][colindex2].setblock(2);
                    }
                }
            }
    } //end autocomplete2

	//Returns the status of a block based on its location in the grid block region
    public int getblockstatus(int opt1idx, int opt2idx)
    {
       return myblocks[opt1idx][opt2idx].getblocknum();
    }
	//Returns the block object located at (opt1idx,opt2idx) in the grid block region
    public Block getblock(int opt1idx, int opt2idx)
    {
       return myblocks[opt1idx][opt2idx];
    }
//Resets all grid blocks in region to null status
    public void reset() {
        for (int i = 0; i < optnum; ++i) {
            for (int j = 0; j < optnum; ++j) {
                myblocks[i][j].setblock(3);
                myblocks[i][j].setcomp_or_user = true;
                myblocks[i][j].setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }

	//Returns true if there are no null (status =3) blocks within the grid block region and false if not
    public boolean iscomplete()
    {
        boolean complete = true;
        int status;
        for (int i = 0; i < optnum; ++i) {
            for (int j = 0; j < optnum; ++j) {
                status = myblocks[i][j].getblocknum();
                if(status ==3) //if a null block is found then grid region is not complet
                    complete = false;
            }
        }
        return complete;
    }//end iscomplete

	//Returns true if all blocks in grid block region are null or (status 3)
    public boolean isclear()
    {
        boolean clear = true;
        int status;
        for (int i = 0; i < optnum; ++i) {
            for (int j = 0; j < optnum; ++j) {
                status = myblocks[i][j].getblocknum();
                if(status !=3)
                    clear = false;
            }
        }
        return clear;
    } //end isclear
}//end class gridblock
