/*
Clue.java
Used to store a clue enterd by the user through the user control panel
*/

import java.util.*;
import java.io.*;

public class Clue implements Serializable {

    String maincat1_name;
    public int maincat1_idx;
    String mainopt1_name;
    public int mainopt1_idx;
    String maincat2_name;
    public int maincat2_idx;
    String mainopt2_name;
    public int mainopt2_idx;
    boolean pending; //Flag which signals if clue can be applied to grid immediately or not
    boolean constant_pending = false;
    int boolopt; //Index 0: default "IS",  Index 1: "IS NOT", Index 2: "GREATER THAN", Index 3:  "LESS THAN"
    int andor;  //Index 0: default "", Index 1: "AND" Index 2: "OR"
    int vectoridx; //represents index in clue vector

	//Vectors for additional categories and options
    Vector <String> addt_catname = new Vector <String>();
    Vector <String> original_addt_catname = new Vector <String>(); //Original vector will NOT change through puzzle processing will remain constant
    Vector <Integer> addt_catidx = new Vector <Integer>();
     Vector <Integer> original_addt_catidx = new Vector <Integer>();
     
    Vector <String> addt_optname = new Vector <String>();
    Vector <String> original_addt_optname = new Vector <String>();
    
    Vector <Integer> addt_optidx = new Vector <Integer>();
     Vector <Integer> original_addt_optidx = new Vector <Integer>();
	//Vector for associate clues
    Vector <assoc_clue> assoc_clues = new Vector <assoc_clue>();
   
    public Clue()
    {
        boolean pending = false;

    }
	//Inner class associate clue used to store derived clues from main
	//clue.
    
    public class assoc_clue
    {
        int boolopt;
        String catname;
        int catidx;
        String optname;
        int optidx;

        public assoc_clue(int cindx, int oindex, int bool_opt )
        {
            boolopt = bool_opt;
            catidx = cindx;
            optidx = oindex;
        }

        public int get_assoc_boolopt()
        {
            return boolopt;
        }

        public int get_assoc_catidx()
        {
			return catidx;
        }
        public int get_assoc_optidx()
        {
            return optidx;
        }
    } //end inner class associate clue

	//Adds associate clue to associate clue vector
    public void add_associate_clue( int cindx, int oindex, int bool_opt)
    {
        assoc_clues.add(new assoc_clue(cindx,oindex,bool_opt));
    }

    public void setcategory1(String catname, int catindex,String optname,int optidx)
    {
        maincat1_name = catname;
        maincat1_idx = catindex;
        mainopt1_name = optname;
        mainopt1_idx =optidx;
    }

    public void setcategory2(String catname, int catindex,String optname,int optidx)
    {
        maincat2_name = catname;
        maincat2_idx = catindex;
        mainopt2_name = optname;
        mainopt2_idx =optidx;
        setaddit_cat(catname,catindex,optname,optidx);
        setorigaddit_cat(catname, catindex, optname, optidx);
    }
    public void setbooleanoption(int idx)
    {
       boolopt =idx;
    }
    public int getbooleanoption()
    {
		return boolopt;
    }
    public void setand_or(int idx)
    {
        andor = idx;
    }
    public int getand_or()
    {
        return andor;
    }

    public void deleteaddit_cat(int idx)
    {
        addt_catname.remove(idx);
        addt_catidx.remove(idx);
        addt_optname.remove(idx);
        addt_optidx.remove(idx);
        
        
    }
    public void deleteaddit_cat(String catname, int catidx, String optnam, int optidx)
    {  
        int idx = addt_catname.indexOf(catname);
        addt_catname.removeElementAt(idx);
        addt_catidx.removeElementAt(idx);
        
        idx = addt_optname.indexOf(optnam);
        addt_optname.removeElementAt(idx);
        addt_optidx.removeElementAt(idx);
    
    }

    public void setaddit_cat(String catname, int catidx, String optname, int optidx)
    {
        addt_catname.add(catname);
        addt_catidx.add(catidx);
        addt_optname.add(optname);
        addt_optidx.add(optidx);
    }
    
    
    //Sets original constant additional clue vectors
    public void setorigaddit_cat(String catname, int catidx, String optname, int optidx)
    {
        original_addt_catname.add(catname);
        original_addt_catidx.add(catidx);
        original_addt_optname.add(optname);
        original_addt_optidx.add(optidx); 
    }
    
    public void reset()
    {
        
        addt_catname.clear();
        addt_catidx.clear();
        addt_optname.clear();
        addt_optidx.clear();
        
        for(int idx =0; idx < original_addt_catname.size(); ++idx)
        {
            addt_catname.add(original_addt_catname.elementAt(idx));
            addt_catidx.add(original_addt_catidx.elementAt(idx));
            addt_optname.add(original_addt_optname.elementAt(idx));
            addt_optidx.add(original_addt_optidx.elementAt(idx));
           
        }
        
        pending = constant_pending;
    }

} //end Class Clue
