/*
 * Clue builder user interface which allows user to enter clues of logic puzzle
 *
 * UserControls.java
 *
 * Created on Mar 7, 2010, 12:44:43 PM
 *
 *Darra Ricks
 */
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.*;
import java.io.*;

public class UserControls extends javax.swing.JPanel implements Serializable{

    /** Creates new form UserControls */
    String[] Categories;
    String[][] Options;
    Vector<JComboBox> additional_cats;
    Vector<JComboBox> additional_opts;
    Vector<Deletebut> additional_delete;
    JPanel panel;
    GridBagConstraints panel_constr;
    GridBagLayout panelgridbag;
    int panelrow = 0;
    int panelcol = 0;
    String boolchoices[] = {"-", "AND", "OR"};
    JButton addbut;
    JButton deletebut;
    JLabel catlabel;
    JLabel optlabel;
    int numofcat;

    public UserControls(String[] categories, String[][] options) {

        panelgridbag = new GridBagLayout();
        panel_constr = new GridBagConstraints();
        numofcat = categories.length;
        Categories = new String[categories.length + 1];
        catlabel = new JLabel("Category");
        optlabel = new JLabel("Option");
        Categories[0] = "";
        for (int i = 1; i < Categories.length; ++i) 
            Categories[i] = categories[i - 1];

        addbut = new JButton();
        Options = new String[options.length + 1][];
        Options[0] = new String[1];
        Options[0][0] = "";

        for (int i = 1; i < Options.length; ++i) 
            Options[i] = options[i - 1];
       
        initComponents();

        panel = new JPanel();
        panel.setLayout(panelgridbag);
        Addbuthandler addbuthandler = new Addbuthandler();
        addbut.addActionListener(addbuthandler);

        Dimension d = new Dimension(380, 250);
        panel.setBounds(10, 250, d.width, d.height);
        this.add(panel);

        additional_cats = new Vector();
        additional_opts = new Vector();
        additional_delete = new Vector();

        Cat1_dropd.addItemListener(
                new ItemListener() {
                    public void itemStateChanged(ItemEvent event) {
                        if (event.getStateChange() == ItemEvent.SELECTED) {

                           ///Set the Option 1 drop down box according to the item selected in the Category dropdown box
                            String[] tempcategories = new String[numofcat + 1];
                            Opt1dropd.setModel(new DefaultComboBoxModel(Options[Cat1_dropd.getSelectedIndex()]));

                            if (Cat1_dropd.getSelectedIndex() != 0) {
                                for (int i = 0; i < Categories.length; ++i) 
                                    tempcategories[i] = Categories[i];
                                //Set the selected index from the Category 1 drop down box to "-" in the Category 2 drop down box
                                //so the user cannot select the same category twice
                                tempcategories[Cat1_dropd.getSelectedIndex()] = "-";
                                cat2dropd.setModel(new DefaultComboBoxModel(tempcategories));
                            }
                        }
                    }
                });

        cat2dropd.addItemListener(
                new ItemListener() {
                    public void itemStateChanged(ItemEvent event) {
                        if (event.getStateChange() == ItemEvent.SELECTED) {
                            //Set the Option 2 drop down box according to the selected item index in the category 2 drop down box
                            if (cat2dropd.getSelectedItem() != "-") 
                                opt2dropd.setModel(new DefaultComboBoxModel(Options[cat2dropd.getSelectedIndex()]));
                        }
                    }
                });

            cluelist = new DefaultListModel();
            panel_constr.insets = new Insets(0,5,0,5);
    }

    private void showmessage(String msg) {
        JOptionPane.showMessageDialog(this, msg);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jProgressBar1 = new javax.swing.JProgressBar();
        jLabel4 = new javax.swing.JLabel();
        Applybut = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        label1 = new java.awt.Label();
        cluebank = new java.awt.List();
        deleteclue = new javax.swing.JButton();
        Cat1_dropd = new javax.swing.JComboBox();
        label2 = new java.awt.Label();
        cat2dropd = new javax.swing.JComboBox(Categories);
        addcatbut = new javax.swing.JButton();
        Opt1dropd = new javax.swing.JComboBox();
        jLabel6 = new javax.swing.JLabel();
        opt2dropd = new javax.swing.JComboBox();
        addcluebut = new javax.swing.JButton();
        andordropd = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        booloptdropd = new javax.swing.JComboBox();
        jLabel7 = new javax.swing.JLabel();

        setBackground(new java.awt.Color(255, 255, 204));
        setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        setMaximumSize(new java.awt.Dimension(400, 795));
        setMinimumSize(new java.awt.Dimension(400, 795));
        setPreferredSize(new java.awt.Dimension(400, 795));

        jLabel4.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLabel4.setText("Clue Bank");

        Applybut.setText("Apply Clues");
        Applybut.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ApplybutActionPerformed(evt);
            }
        });

        jLabel3.setFont(new java.awt.Font("Tahoma", 1, 14));
        jLabel3.setText("CLUE BUILDER");

        jLabel2.setFont(new java.awt.Font("Tahoma", 1, 12));
        jLabel2.setText("Option 1");

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        jLabel1.setText("Category 1");

        label1.setFont(new java.awt.Font("Tahoma", 1, 12));
        label1.setText("Operation");

        cluebank.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cluebankActionPerformed(evt);
            }
        });

        deleteclue.setText("Delete Clue");
        deleteclue.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteclueActionPerformed(evt);
            }
        });

        Cat1_dropd.setModel(new javax.swing.DefaultComboBoxModel(Categories));
        Cat1_dropd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Cat1_dropdActionPerformed(evt);
            }
        });

        label2.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        label2.setText("Category 2");

        addcatbut.setText("Add Category");
        addcatbut.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addcatbutActionPerformed(evt);
            }
        });

        Opt1dropd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Opt1dropdActionPerformed(evt);
            }
        });

        jLabel6.setFont(new java.awt.Font("Tahoma", 1, 12));
        jLabel6.setText("Option 2");

        addcluebut.setText("Add Clue");
        addcluebut.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addcluebutActionPerformed(evt);
            }
        });

        andordropd.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "","AND", "OR" }));
        andordropd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                andordropdActionPerformed(evt);
            }
        });

        jLabel5.setFont(new java.awt.Font("Tahoma", 1, 12));
        jLabel5.setText("AND/OR");

        booloptdropd.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "IS", "IS NOT" }));
        booloptdropd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                booloptdropdActionPerformed(evt);
            }
        });

        jLabel7.setBackground(new java.awt.Color(255, 255, 255));
        jLabel7.setIcon(new javax.swing.ImageIcon(getClass().getResource("/hammer-wrench.gif"))); // NOI18N
        jLabel7.setText("jLabel7");
        jLabel7.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel7, javax.swing.GroupLayout.PREFERRED_SIZE, 46, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 124, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 68, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(cat2dropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(label2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(Cat1_dropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(34, 34, 34)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(Opt1dropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(jLabel6)
                                            .addComponent(opt2dropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 64, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addGap(37, 37, 37)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(label1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(booloptdropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(andordropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(jLabel5))))))
                        .addGap(129, 129, 129))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(addcatbut, javax.swing.GroupLayout.PREFERRED_SIZE, 126, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(261, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel4, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 185, Short.MAX_VALUE)
                        .addComponent(addcluebut)
                        .addContainerGap(58, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                .addComponent(deleteclue)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(Applybut))
                            .addComponent(cluebank, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 329, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addContainerGap(58, Short.MAX_VALUE))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(booloptdropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel6, javax.swing.GroupLayout.PREFERRED_SIZE, 26, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel5)))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addContainerGap()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel7)
                                    .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(65, 65, 65)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(label1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 18, Short.MAX_VALUE)
                                        .addComponent(jLabel2)))))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(Cat1_dropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(Opt1dropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(14, 14, 14)
                        .addComponent(label2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cat2dropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(6, 6, 6)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(andordropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(opt2dropd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addGap(18, 18, 18)
                .addComponent(addcatbut)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 359, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(addcluebut))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cluebank, javax.swing.GroupLayout.PREFERRED_SIZE, 115, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(deleteclue)
                    .addComponent(Applybut))
                .addGap(102, 102, 102))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void Cat1_dropdActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Cat1_dropdActionPerformed
    }//GEN-LAST:event_Cat1_dropdActionPerformed

    private void Opt1dropdActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Opt1dropdActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_Opt1dropdActionPerformed

    private void booloptdropdActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_booloptdropdActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_booloptdropdActionPerformed
    /*
     * 
     * 
     * Action Listener for Add category button, when pressed a new category drop down box and option drop down box
     * appears for user to enter an additional category
     */
    private class Addbuthandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {
            addtoclue();
        }
    }

    private class Delebutbuthandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {
        }
    }
/*
 * Deletbut
 * A JButton object which has an integer index component myindex
 */
    private class Deletebut extends JButton {
        public int myindex;
        @Override
        public void setText(String text) {
            super.setText(text);
        }

        public Deletebut() {
            myindex = 0;
            setText("Delete");
        }
    }

    /*
     * Delect_addt_clue
     * Deletes the last category and option dropdown box added to the UserControls panel, takes in the index of the delete button
     * pressed and deletes the corresponding dropdown boxes
     */
    private void delete_addt_clue(int index) {

        //If the index is 0 which mean that this is the last set of dropdown box left on the usercontrol
        //panel enable the main Category 1 and Category 2 drop down boxes
        if (index == 0) {
            Cat1_dropd.setEnabled(true);
            cat2dropd.setEnabled(true);
            andordropd.setEnabled(true);
            Opt1dropd.setEnabled(true);
            opt2dropd.setEnabled(true);
            booloptdropd.setEnabled(true);
        }

        if (booloptdropd.getSelectedIndex() == 0) //if "IS"
        {
            //int catdropdidx = (additional_cats.elementAt(index)).getSelectedIndex();
        }

        //Enable the category and option dropdown boxes and delete button before the index
        if (index != 0) {
            additional_cats.elementAt(index - 1).setEnabled(true);
            additional_opts.elementAt(index - 1).setEnabled(true);
            additional_delete.elementAt(index - 1).setEnabled(true);
        }

        //Delete the category and option dropdown boxes and delete button at the index
        panel.remove(additional_cats.lastElement());
        panel.remove(additional_opts.lastElement());
        panel.remove(additional_delete.lastElement());
        additional_cats.removeElementAt(index);
        additional_opts.removeElementAt(index);
        additional_delete.removeElementAt(index);


        //reset usercontrol panel indexes
        panelcol = 0;
        --panelrow;
        panel.repaint();

    }
    private void andordropdActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_andordropdActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_andordropdActionPerformed

   private boolean checkdropdboxes()
   {
        boolean noerror = true;
        //Error Checcking for Additional Category dropdown boxes

        //If No additional Categories have been added make sure all initial dropdown boxes have been selected


        if (additional_cats.size() == 0) {
            if ((Cat1_dropd.getSelectedItem() == "") || (cat2dropd.getSelectedItem() == "") || (cat2dropd.getSelectedItem() == "-"))
                noerror = false;


            if (andordropd.getSelectedItem() == "")
                noerror = false;

            if (noerror)
            {
                Cat1_dropd.setEnabled(false);
                cat2dropd.setEnabled(false);
                andordropd.setEnabled(false);
                Opt1dropd.setEnabled(false);
                opt2dropd.setEnabled(false);
                booloptdropd.setEnabled(false);
            }

        }

        else {

            Object cat_holder = additional_cats.lastElement().getSelectedItem();
            Object opt_holder = additional_opts.lastElement().getSelectedItem();

            if ((cat_holder == "") || (cat_holder == "-") || (opt_holder == "") || (opt_holder == "-"))
                noerror = false;



             }

          return noerror;
   }
    /*
     * Addcatbut
     * Action Listener for Add category button, when pressed a new category drop down box and option drop down box
     * appears for user to enter an additional category
     */
    private void addcatbutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addcatbutActionPerformed

        boolean noerror = checkdropdboxes();
        //Error Checcking for Additional Category dropdown boxes

        //If No additional Categories have been added make sure all initial dropdown boxes have been selected

        if(additional_cats.size()<6)
        {
       

                if (noerror == false)
                    showmessage("Before adding an additional category Categories 1 and 2 and all additional catogories must be selected and the AND/OR option must be chosen.");
                else
                    addtoclue();
        

        }
        else
            showmessage("No more than six additional categorys may be added to a clue");
  
    }//GEN-LAST:event_addcatbutActionPerformed
/*
 * Addtoclue
 * Add category and option drop down boxes to panel, add delete button to panel
 */
    private void addtoclue() {
        final JComboBox catcombbx = new JComboBox(Categories);
        final JComboBox optcombx = new JComboBox(Options[0]);
        final Deletebut deletebut = new Deletebut();
        int boolopt = booloptdropd.getSelectedIndex();
        int andoropt = andordropd.getSelectedIndex() - 1;

        additional_cats.addElement(catcombbx);
        additional_opts.addElement(optcombx);
        deletebut.myindex = additional_delete.size();
        additional_delete.addElement(deletebut);
        String[] tempcats = new String[Categories.length];

        for (int i = 0; i < Categories.length; ++i) 
            tempcats[i] = Categories[i];
  
        tempcats[Cat1_dropd.getSelectedIndex()] = "-";

        if (boolopt == 0 && (andordropd.getSelectedIndex() == 1)) //if "IS" and "AND"
        {
            tempcats[cat2dropd.getSelectedIndex()] = "-";
            for (int i = 0; i < additional_cats.size() - 1; ++i) {
                int indx = additional_cats.elementAt(i).getSelectedIndex();
                tempcats[indx] = "-";
            }

            additional_cats.lastElement().setModel(new DefaultComboBoxModel(tempcats));
            //Set Action Listener for last category dropdown box added
            additional_cats.lastElement().addItemListener(
                    new ItemListener() {

                        public void itemStateChanged(ItemEvent event) {
                            if (event.getStateChange() == ItemEvent.SELECTED) {

                                //Set Option Drop down box according to the item index selected in additional category
                                if (catcombbx.getSelectedItem() != "-") 
                                    additional_opts.lastElement().setModel(new DefaultComboBoxModel(Options[catcombbx.getSelectedIndex()]));                           
                            }
                        }
                    });
        }


        //If IS NOT and OR is selected or IS and OR is selected then multiple options within
        //each category can be selected
        if ((boolopt == 1) || ((boolopt == 0) && (andordropd.getSelectedIndex() == 2))) //if "IS NOT" or "IS" and "OR"
        {
            additional_cats.lastElement().setModel(new DefaultComboBoxModel(tempcats));
            additional_cats.lastElement().addItemListener(
                    new ItemListener() {
                        public void itemStateChanged(ItemEvent event) {

                            if (event.getStateChange() == ItemEvent.SELECTED) {
                                String[][] tempopt2 = new String[Options.length][];

                                for (int i = 0; i < Options.length; ++i) {
                                    tempopt2[i] = new String[Options[i].length];
                                    for (int j = 0; j < Options[i].length; ++j) 
                                        tempopt2[i][j] = Options[i][j];
                                    
                                }

                                //Set items which are already selected to "-"
                                tempopt2[Cat1_dropd.getSelectedIndex()][Opt1dropd.getSelectedIndex()] = "-";
                                tempopt2[cat2dropd.getSelectedIndex()][opt2dropd.getSelectedIndex()] = "-";
                                if ((additional_cats.size()) > 1) {
                                    for (int i = 0; i < additional_cats.size() - 1; ++i) 
                                        tempopt2[additional_cats.elementAt(i).getSelectedIndex()][additional_opts.elementAt(i).getSelectedIndex()] = "-";                                    
                                }
                                int indx = additional_cats.lastElement().getSelectedIndex();
                                additional_opts.lastElement().setModel(new DefaultComboBoxModel(tempopt2[indx]));
                            }
                        }
                    });
        }

        //Add action listener for delete button
        additional_delete.lastElement().addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                delete_addt_clue(deletebut.myindex);
            }
        });

        if (additional_cats.size() == 1) {
            panelcol = 0;
            panelrow = 1;
        }
        //Add drop down boxes to panel
        add_clue_dropbxs(additional_cats.size() - 1);
    }


    //Add_clue dropboxs
    //Adds dropdown poxes to User control panel using Gridbag layout
    private void add_clue_dropbxs(int index) {
        panel_constr.gridx = panelcol;
        panel_constr.gridy = panelrow;

        panelgridbag.setConstraints(catlabel, panel_constr);
        panel.add(catlabel);
        ++panelcol;

        panel_constr.gridx = panelcol;
        panelgridbag.setConstraints(optlabel, panel_constr);
        panel.add(optlabel);

        ++panelrow;
        panelcol = 0;
        panel_constr.gridx = panelcol;
        panel_constr.gridy = panelrow;
        panelgridbag.setConstraints(additional_cats.elementAt(index), panel_constr);
        panel.add(additional_cats.lastElement());
        ++panelcol;
        panel_constr.gridx = panelcol;
        panelgridbag.setConstraints(additional_opts.elementAt(index), panel_constr);
        panel.add(additional_opts.lastElement());
        ++panelcol;

        panel_constr.gridx = panelcol;
        panelgridbag.setConstraints(additional_delete.elementAt(index), panel_constr);
        panel.add(additional_delete.elementAt(index));
    }
    private void addcluebutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addcluebutActionPerformed
        // TODO add your handling code her
    }//GEN-LAST:event_addcluebutActionPerformed
   //Adds the string version of the clue currently represented in the dropdown boxes to the usercontrol panel
    //clue bank
    public void addcluetocluebank() {

        if(checkdropdboxes())
        {
            clue = "" + Opt1dropd.getSelectedItem().toString() + " " + booloptdropd.getSelectedItem().toString() + " ";
            clue = clue + opt2dropd.getSelectedItem().toString()+" ";

            for (int i = 0; i < additional_cats.size(); ++i) {
                clue += andordropd.getSelectedItem().toString() + " ";
                clue = clue + additional_opts.elementAt(i).getSelectedItem().toString() + " ";
            }

            cluebank.add(clue);
        }
        else
            showmessage("All Clue drop down boxes must have a value selected in order to add clue to clue bank");
    }

    //Resets the entire user control panel so that no options or categories are selected
    public void resetusercontrolpanel() {
        int size = additional_cats.size();
        for (int i = 0; i < size; ++i) {
            panel.remove(additional_cats.lastElement());
            additional_cats.remove(additional_cats.lastElement());
            panel.remove(additional_opts.lastElement());
            additional_opts.remove(additional_opts.lastElement());
            panel.remove(additional_delete.lastElement());
            additional_delete.remove(additional_delete.lastElement());
        }

        Cat1_dropd.setModel(new DefaultComboBoxModel(Categories));
        Cat1_dropd.setEnabled(true);
        cat2dropd.setModel(new DefaultComboBoxModel(Categories));
        cat2dropd.setEnabled(true);

        Opt1dropd.setEnabled(true);
        Opt1dropd.setSelectedIndex(0);
        opt2dropd.setEnabled(true);
        opt2dropd.setSelectedIndex(0);

        andordropd.setEnabled(true);
        andordropd.setSelectedIndex(0);
        booloptdropd.setEnabled(true);
        booloptdropd.setSelectedIndex(0);
        panel.repaint();
    }
    private void cluebankActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cluebankActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_cluebankActionPerformed

    private void ApplybutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ApplybutActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_ApplybutActionPerformed

    private void deleteclueActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteclueActionPerformed
    }//GEN-LAST:event_deleteclueActionPerformed
    String clue;
    DefaultListModel cluelist;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JButton Applybut;
    public javax.swing.JComboBox Cat1_dropd;
    public javax.swing.JComboBox Opt1dropd;
    public javax.swing.JButton addcatbut;
    public javax.swing.JButton addcluebut;
    public javax.swing.JComboBox andordropd;
    public javax.swing.JComboBox booloptdropd;
    public javax.swing.JComboBox cat2dropd;
    public java.awt.List cluebank;
    public javax.swing.JButton deleteclue;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JProgressBar jProgressBar1;
    private java.awt.Label label1;
    private java.awt.Label label2;
    public javax.swing.JComboBox opt2dropd;
    // End of variables declaration//GEN-END:variables
}
