/*
 * Maingrid.java
 *
 */

/**
 * The Maingrid object is a jagged array of gridblock objects which creates the user interface for the Logic
 * Puzzle grid solver, also includes functions for undo,redo,save,step solve
 * Darra Ricks
 */
import java.awt.*;
import javax.swing.*;
import javax.swing.JCheckBox;
import javax.swing.border.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.*;
import java.util.ArrayList;
import java.io.*;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
public class Maingrid extends JFrame  {

    gridblock[][] gridregions;
    String[][] optionnames;
    UserControls usercontrols;
    int rowcounter = 0;
    int xpos, ypos, width, hieght, numofcat, numofopt;
    String[] categorynames;
    globals Globals = new globals();
    GridBagLayout buttongridbag = new GridBagLayout();
    GridBagConstraints button_constr = new GridBagConstraints();
    GridBagLayout v_lbls_gridbag = new GridBagLayout();
    GridBagConstraints v_lbls_constr = new GridBagConstraints();
    GridBagLayout horz_lbls_gridbag = new GridBagLayout();
    GridBagConstraints horz_lbls_constr = new GridBagConstraints();
    GridBagLayout this_gridbag = new GridBagLayout();
    GridBagConstraints this_constr = new GridBagConstraints();
    JPanel buttonpanel = new JPanel();
    JPanel horiz_lbls_panel = new JPanel();
    JPanel vert_lbls_panel = new JPanel();
    JPanel controlbut_panel = new JPanel();
    JButton stepsolvebut = new JButton("Step Solve >>");
    JButton resetbut = new JButton("Reset Grid");
    JButton undobut = new JButton("Undo");
    JButton redobut = new JButton("Redo");
    JButton allsolve = new JButton("All Solve");
    JButton savebut = new JButton("Save Grid to File");
    JButton exit_homebut = new JButton("Go Back to HomePage");
    JFileChooser filechooser;
    FileFilter filefilter;
    File defaultfile;
    Writer output;
    Vector<gridaction> undostack = new Vector<gridaction>();
    Vector<gridaction> redostack = new Vector<gridaction>();
    Vector<Clue> clues = new Vector<Clue>();
    JCheckBox autocompletecb;
    HomeScreen myhomescreen;
    GridScreen thisgridscreen;
    boolean conflictexists = false;
    int optrowidx;
    int optcolidx;
    int cat1idx;
    int cat2idx;

    /*Maingrid Constructor */
    Maingrid(int numcat, int numopt, GridScreen gridscreen) {
        //Declare and generate a jagged array and add to maingrid panel

        myhomescreen = gridscreen.myhomescreen;
        usercontrols = gridscreen.usercontrols;
        thisgridscreen = gridscreen;
        this.setLayout(null);
        this.setTitle("Logic Puzzle Solver");

        numofcat = numcat;
        numofopt = numopt;
        categorynames = new String[numofcat];
        rowcounter = 0;
        gridregions = new gridblock[numofcat - 1][];

        //Create jagged array of gridblock regions
        for (int i = numofcat - 1; i > 0; --i)
        {
            gridregions[rowcounter] = new gridblock[i];
            for (int j = 0; j < gridregions[rowcounter].length; ++j) {
                gridregions[rowcounter][j] = new gridblock(numofopt, rowcounter, j, rowcounter + 1, i + 1);
            }
            ++rowcounter;
        }


    }//end Maingrid constructor

    /* Maingrid constructor */
    Maingrid(int numcat, int numopt, gridblock[][] ingridregions, String[] categorys, UserControls userc, HomeScreen homescreen) {
        myhomescreen = homescreen;
        numofcat = numcat;
        numofopt = numopt;
        gridregions = ingridregions;
        categorynames = new String[categorys.length];

        for (int i = 0; i < categorys.length; ++i) {
            categorynames[i] = categorys[i];
        }
        usercontrols = userc;
        initializeComponents();
    }

    /*
     * Addcluebuthandler
     * Action Listener for Add Clue Button
     */
    private class Addcluebuthandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {

            /*  Create a new clue object setting the main category and options 1 and 2 and any additional categories and options
                based on what the user selects from the category and option drop downs on the usercontrol panel
            */
            Clue a_clue = new Clue();
            String main_cat1_name = (String) usercontrols.Cat1_dropd.getSelectedItem();
            int main_cat1idx = usercontrols.Cat1_dropd.getSelectedIndex() - 1;

            String main_cat2_name = (String) usercontrols.cat2dropd.getSelectedItem();
            int main_cat2idx = usercontrols.cat2dropd.getSelectedIndex() - 1;

            String opt1name = (String) usercontrols.Opt1dropd.getSelectedItem();
            int opt1idx = usercontrols.Opt1dropd.getSelectedIndex();

            String opt2name = (String) usercontrols.opt2dropd.getSelectedItem();
            int opt2idx = usercontrols.opt2dropd.getSelectedIndex();

            a_clue.setcategory1(main_cat1_name, main_cat1idx, opt1name, opt1idx);
            a_clue.setcategory2(main_cat2_name, main_cat2idx, opt2name, opt2idx);
            a_clue.setand_or(usercontrols.andordropd.getSelectedIndex());
            a_clue.setbooleanoption(usercontrols.booloptdropd.getSelectedIndex());

            int numof_addtcats = usercontrols.additional_cats.size();
            boolean samecategory = true;
            
            /*  Set additional categories and options by getting the selected additional categories and options from additional category and option dropdown boxes,
                check to see if all category selections are in the same category, if all additional categories
                are the same then the clue is not a pending clue and can be solved immediately
             */

            if (numof_addtcats > 0) {

                int curr_cat_idx = main_cat2idx;
                JComboBox combobx = new JComboBox();

                for (int i = 0; i < numof_addtcats; ++i)
                {
                    combobx = usercontrols.additional_cats.elementAt(i);
                    if (combobx.getSelectedIndex() != 0)// if selected item is not the first item which is always blank
                    {
                        String catname = (String) usercontrols.additional_cats.elementAt(i).getSelectedItem();
                        int catidx = usercontrols.additional_cats.elementAt(i).getSelectedIndex() - 1;

                        if (curr_cat_idx != catidx) //if any category index differs from the previous one then all the category selections are not the same
                            samecategory = false;
                        
                        String optname = (String) usercontrols.additional_opts.elementAt(i).getSelectedItem();
                        int optidx = usercontrols.additional_opts.elementAt(i).getSelectedIndex();
                        a_clue.setaddit_cat(catname, catidx, optname, optidx);

                    } //end combobx.getSelectedIndex() if statement
                }//end i for loop

                if ((a_clue.getand_or() == 2) && (a_clue.getbooleanoption() == 0)) //if "OR"/"IS" is selected
                {
                    a_clue.pending = true;

                    /*  If "OR/IS" is selected and all option choices are in the same category then
                        the options within this category not listed in the clue are false
                     */
                    if (samecategory) //clue options are in the same category
                    {
                        boolean found = false;   //flag which signals if a category is not listed in a clue
                        a_clue.pending = false;

                        for (int optionidx = 0; optionidx  < numofopt; ++optionidx )
                        { //loop through all options in category
                            found = false;
                            for (int j = 0; j < a_clue.addt_catidx.size(); ++j)
                            {
                                if (a_clue.addt_optidx.elementAt(j) ==optionidx ) //option is found
                                    found = true;                                
                            }
                            
                            if (!found)    //if option is not found then set it as a false associate clue
                                a_clue.add_associate_clue(a_clue.addt_catidx.elementAt(0), optionidx, 1); //set to false
                        }//end optionidx loop
                    }//end samecategory if statement

                }
                else  //clue is not an IS/OR clue therefore it is not pending
                {
                    a_clue.pending = false;
                }//end IS/OR if/else statement

            }// end numofaddtcats>0 if statement

            clues.add(a_clue); // add newly configured clue to clue vector
            usercontrols.addcluetocluebank(); // add clue usercontrol selections to clue list box
            usercontrols.resetusercontrolpanel(); //reset controls in usercontrol panel
        }
    }

    /*
     *  Allsolvebuthandler
        Action Listener for All Solve button
     *
     */
    private class Allsolvebuthandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {
            solvepuzzle();
        }
    }

    /*
     * Check Pending Clues
     *
     * This method updates pending clues by checking the logic grid for any selections which correspond to pending clue
     * additional categories.  The method returns true if any changes were made to the logic grid
     */
    public boolean checkpendingclues() {
        Clue aclue = new Clue();
        boolean modified = false; //flag which signals if this method modifies the logic grid

        for (int i = 0; i < clues.size(); ++i) { //loop through each clue in clue vector
            aclue = clues.elementAt(i);
            
            if (aclue.pending) { //if clue(i) is pending
                int maincat1 = aclue.maincat1_idx;
                int opt1idx = aclue.mainopt1_idx;
                int addcatidx;
                int addoptidx;
                int status = 0;

                if (aclue.addt_catidx.size() == 1) {//if only one additional category is left in pending clue
                    boolean trueblockfound = false;
                    addcatidx = aclue.addt_catidx.lastElement();
                    addoptidx = aclue.addt_optidx.lastElement();

                    
                    //Check corresponding gridregion to ensure that there are no other true blocks in the corresponding row and column
                    for (int j = 0; j < numofopt; ++j) {
                        status = getblockstatus(maincat1, j, addcatidx, addoptidx);
                        if (status == 2) {
                            trueblockfound = true;
                        }
                        status = getblockstatus(maincat1, opt1idx, addcatidx, j);
                        if (status == 2) {
                            trueblockfound = true;
                        }
                    }

                    if (trueblockfound) {
                        showMessage("Pending Clue Conflict found");
                    } else {
                        //Set block to true and the clue is no longer pending
                        setblockstatus(maincat1, opt1idx, addcatidx, addoptidx, 2);
                        modified = true;
                        aclue.pending = false;
                    }
                } else if (aclue.addt_catidx.size() > 1) {//more than one additional category left


                    int size = aclue.addt_catidx.size();
                    for (int j = 0; j < size; ++j) {
                        addcatidx = aclue.addt_catidx.elementAt(j);
                        addoptidx = aclue.addt_optidx.elementAt(j);

                         //Check the status of block which corresponds to addcatidx and addoptidx
                        status = getblockstatus(maincat1, opt1idx, addcatidx, addoptidx);
                        if (status == 1) //if the status of the block is false then delete this possible (category,option) pair
                        {
                            aclue.deleteaddit_cat(j);
                            modified = true;
                            --size;
                        }
                        if (status == 2) //If status is true this pending clue is already solved so it is no longer pending                        
                            aclue.pending = false;
                        
                    }// end j loop
                }// end aclue.addt_catidx.size() > 1 else if statement
            }//end pending clue if statement

        }//end clue loop

        return modified;
    }

/* DeletecluebutHandler
 * Action Listener for Delete Clue button.  When pressed the highlight clue in the clue list box located on the Usercontrols
 * panel is deleted and removed from clue vector
 */
    private class Deletecluebuthandler implements ActionListener {
            public void actionPerformed(ActionEvent event) {
            if ((clues.size() > 0) && (usercontrols.cluebank.getSelectedIndex() != -1)) {
                clues.remove(usercontrols.cluebank.getSelectedIndex());

                int indx = usercontrols.cluebank.getSelectedIndex();
                usercontrols.cluebank.remove(indx);
            }
        }
    }//end Deletecluebuthandler

   /*
    * ExitbutHandler
    * Action Listener for Exit button.  When pressed the application navigates back to home screen
    */
    private class ExitbutHandler implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            gotohomescreen();
        }
    }

    /*
     * Getblockstatus
       Returns the block status of the block in the logic grid corresponding to its category 1 index,
     * option1 index, category 2 index and option 2 index
     */
   public int getblockstatus(int cat1idx, int opt1idx, int cat2idx, int opt2idx) {
        int blockstatus = 0;

        //Loop through jagged array of grid block regions
        for (int i = 0; i < gridregions.length; ++i) {
            for (int j = 0; j < gridregions[i].length; ++j) {

                //Get the category indexes of gridregion(i,j)
                int cid1 = gridregions[i][j].cat1.getid();
                int cid2 = gridregions[i][j].cat2.getid();

               //if the indexes correspond
                if ((cat1idx == cid1) && (cat2idx == cid2)) 
                    blockstatus = gridregions[i][j].getblockstatus(opt1idx, opt2idx);
                
                if ((cat2idx == cid1) && (cat1idx == cid2)) 
                    blockstatus = gridregions[i][j].getblockstatus(opt2idx, opt1idx);
            }
        }
        return blockstatus;
    }//end getblockstatus

   /*
    * Gricomplete
    * Return true if there are no null blocks (status =3) in logic grid
    */
    public boolean gridcomplete() {
        boolean complete = true;

        //Loop through jagged array of grid regions
        for (int i = 0; i < numofcat - 1; ++i) {
            for (int j = 0; j < gridregions[i].length; ++j) {
                if (!gridregions[i][j].iscomplete()) 
                    complete = false;            
            }
        }

        return complete;
    }//end gridcomplete()
 
/*
 * GridbutHandler
 * Action Listener for grid button, when pressed the status and color of the button changes and
 * a gridaction is added to the undo stack of maingrid
 */
    private class Gridbuthandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {
            undobut.setEnabled(true); //enable undo button
           ((Block) event.getSource()).block_click();

            Block ablock = (Block) event.getSource();
            int ridx1 = ablock.regionidx1;
            int ridx2 = ablock.regionidx2;
            int bidx1 = ablock.index1;
            int bidx2 = ablock.index2;
            int prevbstatus = ablock.status;
            //Add grid action to undo stack
            undostack.add(new gridaction(prevbstatus, ridx1, ridx2, bidx1, bidx2, ablock.comp_or_user));
        }
    }//end Gridbuthandler

     public void initializeComponents() {
        this.setLayout(null);
        width = 850;
        hieght = 700;
        BufferedImage image = null;
        try {
            
            image = ImageIO.read(this.getClass().getResource("question-mark-red.jpg"));
        } catch (IOException e) {
            e.printStackTrace();
        }
       this.setIconImage(image);
       this.setTitle("Logic Puzzle Solver");
        this.setSize(width, hieght);
        vert_lbls_panel.setBackground(Color.WHITE);
        vert_lbls_panel.setLayout(v_lbls_gridbag);

        Dimension vert_panel_d = new Dimension(80, Globals.offset * (numofcat - 1) * (numofopt));
        vert_lbls_panel.setPreferredSize(vert_panel_d);
        v_lbls_constr.weighty = 0.5;
        v_lbls_constr.anchor = v_lbls_constr.WEST;
        buttonpanel.setOpaque(false);
    

        buttonpanel.setLayout(buttongridbag);
        Dimension button_panel_d = new Dimension(numofopt * Globals.offset * (numofcat - 1), numofopt * Globals.offset * (numofcat - 1));
        buttonpanel.setPreferredSize(button_panel_d);

        Dimension horiz_panel_d = new Dimension(Globals.offset * (numofcat - 1) * (numofopt) + 50, 100);
        horiz_lbls_panel.setPreferredSize(horiz_panel_d);
        horiz_lbls_panel.setBackground(Color.WHITE);


        Stepsolvebuthandler stephandler = new Stepsolvebuthandler();
        Resetbuthandler resetbuthandler = new Resetbuthandler();
        Undobuthandler undobuthandler = new Undobuthandler();
        Redobuthandler redobuthandler = new Redobuthandler();
        SavebutHandler savebuthandler = new SavebutHandler();
        ExitbutHandler exitbuthandler = new ExitbutHandler();

        Addcluebuthandler addcluebuthandler = new Addcluebuthandler();
        Deletecluebuthandler deletecluebuthandler = new Deletecluebuthandler();
        Allsolvebuthandler allsolvebuthandler = new Allsolvebuthandler();

        Submitcluebuthandler submitbuthandler = new Submitcluebuthandler();

        usercontrols.deleteclue.addActionListener(deletecluebuthandler);
        usercontrols.Applybut.addActionListener(submitbuthandler);

        stepsolvebut.addActionListener(stephandler);
        Dimension component_d = new Dimension(120, 20);
        Dimension component_d2 = new Dimension(60, 50);
        stepsolvebut.setPreferredSize(component_d);
        resetbut.addActionListener(resetbuthandler);
        Dimension componentsize = component_d.getSize();
        Dimension componentsize2 = component_d2.getSize();


        Dimension panelsize = new Dimension(150, 400);
       controlbut_panel.setBounds(650, 370, panelsize.width+5, panelsize.height);
       Border bevel = BorderFactory.createRaisedBevelBorder();

        controlbut_panel.setBorder(bevel);
        undobut.setBounds(0, 200, componentsize2.width, componentsize2.height);
        undobut.addActionListener(undobuthandler);
        undobut.setEnabled(false);

        redobut.setBounds(60, 200, componentsize2.width, componentsize2.height);
        redobut.addActionListener(redobuthandler);
        redobut.setEnabled(false);
        Dimension d2 = exit_homebut.getPreferredSize();
        exit_homebut.setBounds(650, 575,d2.width, d2.height);
        exit_homebut.addActionListener(exitbuthandler);
        stepsolvebut.setBounds(0, 0, componentsize.width, componentsize.height);
        resetbut.setBounds(650, 620, d2.width, d2.height);
     
        savebut.setBounds(650, 550, d2.width, d2.height);
        savebut.addActionListener(savebuthandler);
    
        allsolve.addActionListener(allsolvebuthandler);
        allsolve.setBounds(0, 300, componentsize.width, componentsize.height);
        controlbut_panel.add(stepsolvebut);
    
        controlbut_panel.add(undobut);
        controlbut_panel.add(redobut);
        controlbut_panel.add(allsolve);
        this.add(resetbut);
        this.add(savebut);
        this.add(exit_homebut);
        filechooser = new JFileChooser();
        Dimension size = usercontrols.getPreferredSize();
        usercontrols.setBounds(838, 20, size.width, size.height);
        this.add(controlbut_panel);
        this.add(usercontrols);
        usercontrols.addcluebut.addActionListener(addcluebuthandler);

        filefilter = new FileFilter();
        defaultfile = new File("grid.lps");
    }

     /*
      * Generategrid
      * Generates logic grid based on the number of options and categories chosen by user
      */
    void generategrid(String[][] options) {
        optionnames = options;
        int offset = 0;
        xpos = 0;
        ypos = 35;

        int cat1index = 0;
        int cat2index = numofcat - 1;
        int xposlbl = 60;
        int yposlbl = 20;
        int xpos2 = 40;
        int ypos2 = 110;
        int counter = 0;
        int width = Globals.offset * numofopt;
        int hieght = Globals.offset * numofopt;

        Diagonallabel[] diag_lbls = new Diagonallabel[(numofcat - 1) * numofopt];
        JLabel[] cat_lbls = new JLabel[(numofcat - 1) * numofopt];

        Gridbuthandler gridbuthandler = new Gridbuthandler();
        int vert_lbl_counter = 0;
        int horz_lbl_counter = 0;

        for (int i = 0; i < numofcat - 1; ++i) {
              for (int j = 0; j < gridregions[i].length; ++j) {
            
                //Set Category index number, category name and option names for category 1 and 2 of each grid region
                gridregions[i][j].cat1.setCat_name(categorynames[cat1index]);
                gridregions[i][j].cat1.setoptions(options[cat1index]);
                gridregions[i][j].cat1.setid(cat1index);

                gridregions[i][j].cat2.setCat_name(categorynames[cat2index]);
                gridregions[i][j].cat2.setoptions(options[cat2index]);
                gridregions[i][j].cat2.setid(cat2index);


                //Add Action Listener and stet option names for each block in grid
                for (int k = 0; k < numofopt; ++k) {
                    for (int l = 0; l < numofopt; ++l) {
                        gridregions[i][j].myblocks[k][l].addActionListener(gridbuthandler);
                        gridregions[i][j].myblocks[k][l].setoptionnames(gridregions[i][j].cat1.getOpt_name(k), gridregions[i][j].cat2.getOpt_name(l));
                    }
                }

                // Create diagonal labels for horizantal panel of logic grid on the first ith iteration
                if (i == 0) {
                    for (int k = 0; k < numofopt; ++k) {

                        diag_lbls[horz_lbl_counter] = new Diagonallabel(gridregions[i][j].cat2.getOpt_name(k));
                        diag_lbls[horz_lbl_counter].setLocation(xposlbl, yposlbl);
                        diag_lbls[horz_lbl_counter].setSize(Globals.textbx_width, 60);

                        this.add(diag_lbls[horz_lbl_counter]);
                        diag_lbls[horz_lbl_counter].repaint();
                        xposlbl += Globals.offset;
                        ++horz_lbl_counter;
                    }
                }


                 //Create labels for vertical panel of logic grid on the first jth iteration
                if (j == 0) {
                    for (int k = 0; k < numofopt; ++k) {
                        cat_lbls[vert_lbl_counter] = new JLabel(gridregions[i][j].cat1.getOpt_name(k));

                        cat_lbls[vert_lbl_counter].setSize(40, 10);
                        v_lbls_constr.gridx = 0;
                        v_lbls_constr.gridy = vert_lbl_counter;
                        v_lbls_gridbag.setConstraints(cat_lbls[vert_lbl_counter], v_lbls_constr);
                        vert_lbls_panel.add(cat_lbls[vert_lbl_counter]);

                        ypos2 += Globals.offset;
                        ++vert_lbl_counter;

                    }
                } //end j if statement

                button_constr.gridx = xpos;
                button_constr.gridy = ypos;
                buttongridbag.setConstraints(gridregions[i][j], button_constr);
                //add gridregion (i,j) to gridpanel
                buttonpanel.add(gridregions[i][j]);

                ++xpos;
                --cat2index;
            }// j loop
            cat2index = numofcat - 1;
            ++cat1index;
            xpos = 0;
            ++ypos;
        }//end i loop

        //add vertical labels to grid button panel
        this.add(vert_lbls_panel);
        Dimension size = vert_lbls_panel.getPreferredSize();
        vert_lbls_panel.setBounds(0, 65, size.width, size.height);

        //add grid button panel to main frame
        this.add(buttonpanel);

        size = buttonpanel.getPreferredSize();
        buttonpanel.setBounds(85, 65, size.width, size.height);
        buttonpanel.repaint();
        this.repaint();
    }// end generategrid

    /*
     * Gotohomescreen
     * Asks user to save before exiting and then navigates to the homescren
     */
      void gotohomescreen() {

        int choice = JOptionPane.showConfirmDialog(this, "Would you like to save the current grid before exiting?");

        switch (choice) {
            case JOptionPane.YES_OPTION:
                saveFile();
                this.setVisible(false);
                myhomescreen.setVisible(true);

                break;
            case JOptionPane.NO_OPTION:
                this.setVisible(false);
                myhomescreen.setVisible(true);

                break;
            case JOptionPane.CANCEL_OPTION:
                break;
            case JOptionPane.CLOSED_OPTION:
                break;

        }
    }//end gotohomescreen

  /*
   * Isgridclear
   * Returns true if all blocks in logic grid are of null status (3)
   */
    public boolean isgridclear() {
        boolean clear = true;

        for (int i = 0; i < numofcat - 1; ++i)
        {
            for (int j = 0; j < gridregions[i].length; ++j)
            {
                if (!gridregions[i][j].isclear()) 
                    clear = false;                
            }
        }
        return clear;
    }//end isgridclear

 /*
  * Obvioustruthcomplete
  * Fills in obvious derivations based on existing selections in logic grid.  If a grid region has a row
  * or column which has one remaining blank block  then the status of the block can be derived
  */
   public void obvioustruthcomplete(gridblock region) {
        int length = region.myblocks[0].length;

        int falsecounter1 = 0;
        int falsecounter2 = 0;
        int blankrowindex1 = -1;
        int blankcolindex2 = -1;
        int truecount1 = 0;
        int truecount2 = 0;
        int i, j;
        for (i = 0; i < length; ++i) {
            for (j = 0; j < length; j++) {

                //Store blank column index
                if (region.myblocks[i][j].getblocknum() == 3) 
                    blankcolindex2 = j;
                //Store blank row index
                if (region.myblocks[j][i].getblocknum() == 3) 
                    blankrowindex1 = j;
                //Increment false block counter for jth column
                if (region.myblocks[i][j].getblocknum() == 1) 
                    ++falsecounter1;
                //Increment false block counter for jth row
                if (region.myblocks[j][i].getblocknum() == 1) 
                    ++falsecounter2;
                //Increment true block counter for jth column
                if (region.myblocks[i][j].getblocknum() == 2) 
                    ++truecount1;
                //Increment true block counter for jth row
                if (region.myblocks[j][i].getblocknum() == 2) 
                    ++truecount2;
            } //end j loop

                //if length -1 falseblocks then the remaining block must be true
            if ((falsecounter1 == (length - 1)) && (blankcolindex2 != -1)) 
                region.myblocks[i][blankcolindex2].setblock(2);
            
            if ((falsecounter2 == (length - 1)) && (blankrowindex1 != -1)) 
                region.myblocks[blankrowindex1][i].setblock(2);

                //if length-2 false blocks and one true block then the remaining block must be false
            if ((truecount1 == 1) && (falsecounter1 == (length - 2)) && (blankcolindex2 != -1)) 
                region.myblocks[i][blankcolindex2].setblock(1);
 
            if ((truecount2 == 1) && (falsecounter2 == (length - 2)) && (blankrowindex1 != -1)) 
                region.myblocks[blankrowindex1][i].setblock(1);

            //reset counters
            falsecounter1 = 0;
            falsecounter2 = 0;
            blankrowindex1 = -1;
            blankcolindex2 = -1;
            truecount1 = 0;
            truecount2 = 0;
        }//end outer i loop
        
    }//end obvioustruthcomplete

   /*
    * Redobuthandler
    * Action Listener for Redo button, when pressed the last undid action from the undo button is applied back
    * to the logic grid
    */
      private class Redobuthandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {
            gridaction action;
            int regionidx1, regionidx2, blockidx1, blockidx2, status;

            boolean cmporuser;
            if (!(redostack.isEmpty())) {//if redo stack is not empty

                //get the last action added to the redo stack and add it to the undo stack
                action = redostack.lastElement();
                undostack.add(action);
                redostack.remove(redostack.size() - 1);
                regionidx1 = action.regionidx1;
                regionidx2 = action.regionidx2;
                blockidx1 = action.blockidx1;
                blockidx2 = action.blockidx2;
                status = action.status;
                cmporuser = action.comporuser;

                //apply this action to the logic grid
                gridregions[regionidx1][regionidx2].myblocks[blockidx1][blockidx2].setblock(status);
                gridregions[regionidx1][regionidx2].myblocks[blockidx1][blockidx2].comp_or_user = cmporuser;

            } else  //disable redo button if redo stack is empty
                redobut.setEnabled(false);
            

        }//end actionPerformed Redo button
    }//end RedobuttonHandler

/*
 * Removeconflictborders
 * Removes red border from blocks which are no longer conflicting
 */
    public void removeconflictborders(Block block1, Block block2, Block keyblock) {
        keyblock.setBorder(BorderFactory.createEmptyBorder());
        block1.setBorder(BorderFactory.createEmptyBorder());
        block2.setBorder(BorderFactory.createEmptyBorder());
        keyblock.repaint();
        block1.repaint();
        block2.repaint();
    }
 /*
  * Resetbuthandler
  * Resets all logic grid buttons to a status of null (3)
  */
    private class Resetbuthandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {

            for (int i = 0; i < numofcat - 1; ++i) 
                for (int j = 0; j < gridregions[i].length; ++j) 
                    gridregions[i][j].reset();
        }
    }//end Resetbuthandler
     

     //Action Listener for Save Button
        private class SavebutHandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {
            boolean flag = saveFile();

        }
    }
    /*
     * Savefile
     * Method which opens File Chooser Dialogue box for user to select or enter the name to save the logic file
     */
 
      boolean saveFile() {
        JFileChooser fc = new JFileChooser();

        // Start in current directory
        fc.setCurrentDirectory(new File("."));

        // Set filter for Logic Puzzle Solver Files .lps
        fc.setFileFilter(filefilter);

        // Set to a default name for save
        fc.setSelectedFile(defaultfile);

        // Show save dialog file chooser
        int result = fc.showSaveDialog(this);

        if (result == JFileChooser.CANCEL_OPTION) { //user selects CANCEL
            return true;
        } 
        else if (result == JFileChooser.APPROVE_OPTION)//user selects OK
        {
            defaultfile = fc.getSelectedFile(); //get selected file from file chooser
            if (defaultfile.exists()) {
                int response = JOptionPane.showConfirmDialog(null,"Overwrite existing grid file with file name:  " + defaultfile.getName(), "Confirm Overwrite",
                JOptionPane.OK_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE);

                if(response == JOptionPane.CANCEL_OPTION) //if user selects CANCEL from overwrite message box
                    return false;                
            }

            return writetoFile(defaultfile); //write to selected file
        } 
        else
            return false;
    } //end savefile
  
  //Sets the category string names
    public void setcategories(String[] categories) {
        for (int i = 0; i < categories.length; ++i) {
            categorynames[i] = categories[i];
        }
    }

    //Sets the clue vector to the inputted list
    public void setclues(java.util.List list) {
        for (int i = 0; i < list.size(); ++i) {
            clues.add((Clue) list.get(i));
        }
    }

    //Set the usercontrol panel
   public void setUsercontrols(UserControls usersc) {
        usercontrols = usersc;
    }
    

  // Set any block in the logic grid based on its category1index, category2index,option1index and option2index
 public void setblockstatus(int cat1idx, int opt1idx, int cat2idx, int opt2idx, int status) {

     //Loop through jagged array of grid regions 
        for (int i = 0; i < gridregions.length; ++i) {
            for (int j = 0; j < gridregions[i].length; ++j) {
                int cid1 = gridregions[i][j].cat1.getid();
                int cid2 = gridregions[i][j].cat2.getid();

                if ((cat1idx == cid1) && (cat2idx == cid2)) 
                    gridregions[i][j].getblock(opt1idx, opt2idx).setblock(status);
                
                if ((cat2idx == cid1) && (cat1idx == cid2)) 
                    gridregions[i][j].getblock(opt2idx, opt1idx).setblock(status);
                
            } //End gridregions column inner loop
        }//End gridregions row inner loop
    }//End setblockstatus

 //Displays message dialogue box with message
  public void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

 /*
  * Show Mismatch Pair
  *
  * Reveals logical mismatches on the logic grid, uses input variables keyblock, block 1 and block 2.  The keyblock is the base
  * of the mismatch and block 1 and block 2 are the conflicting block selections based on the keyblock.
  * For example:
  * Keyblock :  John is Not KY
  * Block 1 :   John is obese
  * Block 2:    Obese is KY
  *
  * Based on the keyblock indicating John IS NOT KY block 1 and block 2 conflict
  *
  * The method composes a conflict messages and displays the message in pop up dialogue box
  */
   public void showmismatchpair(Block blk1, Block blk2, Block keyblk) {

        String msg; // string message show in conflict dialogue box
        msg = "MISMATCH\n";
        if (keyblk.getblocknum() == 2) { //if true block
            msg += keyblk.cat1optname + " is " + keyblk.cat2optname + "\n";
        } else if (keyblk.getblocknum() == 1) { //if false block
            msg += " " + keyblk.cat1optname + " is NOT " + keyblk.cat2optname + "\n";
        }
        if (blk1.getblocknum() == 2) {
            msg += blk1.cat1optname + " is " + blk1.cat2optname;
        } else if (blk1.getblocknum() == 1) {
            msg += blk1.cat1optname + " is NOT " + blk1.cat2optname;
        }

        msg += "\n";

        if (blk2.getblocknum() == 2) {
            msg += blk2.cat1optname + " is " + blk2.cat2optname;
        } else if (blk2.getblocknum() == 1) {
            msg += blk2.cat1optname + " is NOT " + blk2.cat2optname;
        }

        //Highlight conflicting blocks in red
        blk1.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        blk2.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        keyblk.setBorder(BorderFactory.createLineBorder(Color.RED, 2));

        blk1.repaint();
        blk2.repaint();
        keyblk.repaint();

        JOptionPane.showMessageDialog(this, msg);


        //Stop stepsolve method gridregion loop by setting indexes larger than boundary
        optcolidx = numofopt;
        optrowidx = numofopt;
        cat1idx = numofcat;
        cat2idx = numofcat;

        conflictexists = true; //flag signaling conflicts in grid
    }//end show mismatch pair
/*
 * Show Step solve Message
 *
 * Composes a message which indicates stepsolve derivations to user and displays this message in a
 * pop up dialogue box.  The method is based on a keyblock,block1 and block 2.  As in the show mismatch pair method
 * the keyblock is the base of the derivation
 * For Example:
 *
 * Key Block :  John is KY
 * Block 1:     KY is not obese
 * Therefore is can be derived that
 * Block 2:     John is not obese
 */
    public void showstepsolvemsg(Block block1, Block block2, Block keyblock) {
        String msg = "";

        //Compose msg based on whether keyblock is true or false
        if (keyblock.getblocknum() == 2) {
            msg += keyblock.cat1optname + " is " + keyblock.cat2optname + " therefore, \n";

            if (block1.getblocknum() == 2) { //if keyblock is true
                msg += "Since " + block1.cat1optname + " is " + block1.cat2optname + "\n";
                msg += block2.cat1optname + "is " + block2.cat2optname;
            } else if (block1.getblocknum() == 1) {
                msg += "Since " + block1.cat1optname + " is NOT " + block1.cat2optname + "\n";
                msg += block2.cat1optname + "is NOT " + block2.cat2optname;
            } else if (block2.getblocknum() == 2) {
                msg += "Since " + block2.cat1optname + " is " + block2.cat2optname + "\n";
                msg += block1.cat1optname + " is " + block1.cat2optname;
            } else if (block2.getblocknum() == 1) {
                msg += "Since " + block2.cat1optname + " is NOT " + block2.cat2optname + "\n";
                msg += block1.cat1optname + " is NOT " + block1.cat2optname;
            }
        } else if (keyblock.getblocknum() == 1) { //if keyblock is false
            msg += keyblock.cat1optname + " is NOT " + keyblock.cat2optname + " therefore, \n";
            if (block1.getblocknum() == 2) {
                msg += "Since " + block1.cat1optname + " is " + block1.cat2optname + "\n";
                msg += block2.cat1optname + " is NOT " + block2.cat2optname;
            } else if (block2.getblocknum() == 2) {
                msg += "Since " + block2.cat1optname + " is " + block2.cat2optname + "\n";
                msg += block1.cat1optname + " is NOT " + block1.cat2optname;
            }
        }
        JOptionPane.showMessageDialog(this, msg);
    }//End showStepsolvemsg


    /*
     * Solve Puzzle;
     *
     * Recursively calls stepsolve method in effort to completely solve the logic grid
     */
 public void solvepuzzle() {
        boolean finished = false;  //flag to indicate whether the grid can be solved any further
        while (!finished) {

            for (int i = 0; i < numofcat - 1; ++i)  /*Grid region row loop*/
                for (int j = 0; j < gridregions[i].length; ++j) 
                    //Call Autocomplete method on each grid region to fill in derived falses from true blocks in the grid
                    gridregions[i][j].autocomplete();              
            //Recursively call stepsolve method until it returns false
            if (stepsolve()) 
                finished = false;
            else 
                finished = true;          
        }//end while not finished loop

        if (gridcomplete()) 
            JOptionPane.showMessageDialog(this, "Congratulations! Puzzle Solved!");
        else 
            JOptionPane.showMessageDialog(this, "Puzzle Not Completely Solved.  ");
        

    }//end solve puzzle

 /*
  * Method called when step solve button is pressed.  This method loops through the jagged array of gridregions in the
  * logic grid and attempts to derive new information from the information already entered in the logic grid
  */
 public boolean stepsolve() {
       int length = numofcat-1;
     
        String regionoptname1, regionoptname2, corr_cat1optname, corr_cat2optname;
        int optrowblock, optcolblock, cat2rowidx, cat1colidx;
      

        Block block1;
        Block block2;
        Block keyblock;
        conflictexists = false;
        boolean modified = false;
        /*Looping through jagged array of gridregions, each gridregion corresponds to a specific category (category1 and category 2*/

        for (cat1idx = 0; cat1idx <length; ++cat1idx) {  /*Grid region row loop*/
                int gridregionrowlength= gridregions[cat1idx].length;
            for (cat2idx = 0; cat2idx < gridregionrowlength; ++cat2idx) { /*Grid region column loop*/

                /*Loop through grid blocks in the (Cat1idx,Cat2idx) gridregion*/
                for (optrowidx = 0; optrowidx < numofopt; ++optrowidx) {
                    for (optcolidx = 0; optcolidx < numofopt; ++optcolidx) {

                        keyblock = gridregions[cat1idx][cat2idx].myblocks[optrowidx][optcolidx];
                        int cat1blockstatus, cat2blockstatus;
                        /*Calculate the row index for vertical propagation for the gridregion that corresponds to gridregion{cat1idx,cat2idx}*/
                        cat2rowidx = length - cat2idx;

                        /*Calculate the column index for horizantal progation for the gridregion that corresponds to gridregion{cat1idx,cat2idx}*/
                        cat1colidx = length - cat1idx;

                        /*Store the option names for Category 1 and Category 2 of gridregion (cat1idx, cat2idx)*/
                        regionoptname1 = gridregions[cat1idx][cat2idx].cat1.getOpt_name(optrowidx);
                        regionoptname2 = gridregions[cat1idx][cat2idx].cat2.getOpt_name(optcolidx);

                        /*If a true block is found in kth row of gridregion,*/
                        if (gridregions[cat1idx][cat2idx].myblocks[optrowidx][optcolidx].getblocknum() == 2) {

                            /*Then loop through each grid region in Category 1 row and set  Category 1 's corresponding grid region and Category 2's corresponding grid region
                             * block by block, and set gridregion1 = gridregion2 and gridregion2 = gridregion1
                             *
                             */

                            /*Start Vertical Learning and Propagation for true block*/
                           
                            
                            for (int i = 0; i < cat2idx; ++i) {
                                for (int j = 0; j < numofopt; ++j) {
                                    if(!conflictexists)
                                    {
                                    
                                    block1 = gridregions[cat1idx][i].myblocks[optrowidx][j];
                                    block2 = gridregions[cat2rowidx][i].myblocks[optcolidx][j];
                                    removeconflictborders(block1, block2, keyblock);
                                    /*Store the gridblock (i,j) value*/
                                    cat1blockstatus = gridregions[cat1idx][i].myblocks[optrowidx][j].getblocknum();
                                    cat2blockstatus = gridregions[cat2rowidx][i].myblocks[optcolidx][j].getblocknum();

                                    corr_cat2optname = gridregions[cat2rowidx][i].cat2.getOpt_name(j);
                                    corr_cat1optname = gridregions[cat1idx][i].cat1.getOpt_name(i);
                                    
                                    if ((cat1blockstatus != 3) && (cat2blockstatus != 3) && (cat1blockstatus != cat2blockstatus)) 
                                        showmismatchpair(block1, block2, keyblock);
                                    

                                    if (!conflictexists) {
                                        if ((cat1blockstatus == 3) && (cat2blockstatus != 3)) {
                                            showstepsolvemsg(block1, block2, keyblock);
                                            block1.setblock(cat2blockstatus);
                                            modified = true;
                                        } else if ((cat1blockstatus != 3) && (cat2blockstatus == 3)) {
                                            showstepsolvemsg(block1, block2, keyblock);
                                            block2.setblock(cat1blockstatus);
                                            modified = true;
                                        }
                                    }
                                    }//end not conflict exists if statement

                                } //end j loop
                            }//end i loop
                            
                            if (!conflictexists) {
                                //beginning horizantal propogation for true blcok
                                //outer for loop for grid region columns

                                for (int i = 0; i < cat1idx; ++i) {
                                    //inner loop for block columns
                                    for (int j = 0; j < numofopt; ++j) {

                                        cat1blockstatus = gridregions[i][cat1colidx].myblocks[j][optrowidx].getblocknum();
                                        cat2blockstatus = gridregions[i][cat2idx].myblocks[j][optcolidx].getblocknum();
            
                                        block1 = gridregions[i][cat1colidx].myblocks[j][optrowidx];
                                        block2 = gridregions[i][cat2idx].myblocks[j][optcolidx];

                                        if (((cat1blockstatus == 1) && (cat2blockstatus == 2)) || ((cat1blockstatus == 2) && (cat2blockstatus == 1))) 
                                            showmismatchpair(block1, block2, keyblock);
                                        

                                        if (!conflictexists) {
                                            if ((cat1blockstatus == 3) && (cat2blockstatus != 3)) {
                                                showstepsolvemsg(block1, block2, keyblock);
                                                gridregions[i][cat1colidx].myblocks[j][optrowidx].setblock(cat2blockstatus);
                                                modified = true;
                                            } else if ((cat1blockstatus != 3) && (cat2blockstatus == 3)) {
                                                showstepsolvemsg(block1, block2, keyblock);
                                                gridregions[i][cat2idx].myblocks[j][optcolidx].setblock(cat1blockstatus);
                                                modified = true;
                                            }
                                        }//end inner conflictexist if statment

                                    }//end j loop
                                }//end i loop
                            }// end outer conflict exists if statement



                        } //end if true block statement

                        //if gridblock is false "red" meaning that category1 option does not equal category2 option
                        if ((!conflictexists)&&gridregions[cat1idx][cat2idx].myblocks[optrowidx][optcolidx].getblocknum() == 1) {

                            //looping through each grid region corresponding to category 2 and setting the blocks within these regions to
                            //equal category 1
                            for (int i = 0; i < cat2idx; ++i) {
                                for (int j = 0; j < numofopt; ++j) {
                                    if(!conflictexists)
                                    {
                                    cat1blockstatus = gridregions[cat1idx][i].myblocks[optrowidx][j].getblocknum();
                                    cat2blockstatus = gridregions[cat2rowidx][i].myblocks[optcolidx][j].getblocknum();
                                    block1 = gridregions[cat1idx][i].myblocks[optrowidx][j];
                                    block2 = gridregions[cat2rowidx][i].myblocks[optcolidx][j];
                                    removeconflictborders(block1, block2, keyblock);

                                    //Beginning Horizantal Propogation for false block
                                    if ((cat2blockstatus == 2) && (cat1blockstatus == 2)) 
                                        showmismatchpair(block1, block2, keyblock);
                                    

                                    if (!conflictexists) {
                                        if ((cat1blockstatus == 3) && (cat2blockstatus == 2)) {
                                            showstepsolvemsg(block1, block2, keyblock);
                                            gridregions[cat1idx][i].myblocks[optrowidx][j].setblock(1);
                                            modified = true;
                                        } else if ((cat1blockstatus == 2) && (cat2blockstatus == 3)) {
                                            showstepsolvemsg(block1, block2, keyblock);
                                            gridregions[cat2rowidx][i].myblocks[optcolidx][j].setblock(1);
                                            modified = true;
                                        }
                                    }//end no conflictexists if statement
                                    }
                                } //end j loop
                            }//end i loop


                            //Beginning Vertical Propogation for False Block
                            if (!conflictexists) {
                                for (int i = 0; i < cat1idx; ++i) {
                                    //inner loop for block columns
                                    for (int j = 0; j < numofopt; ++j) {

                                        cat1blockstatus = gridregions[i][cat1colidx].myblocks[j][optrowidx].getblocknum();

                                        cat2blockstatus = gridregions[i][cat2idx].myblocks[j][optcolidx].getblocknum();
                                        block1 = gridregions[i][cat1colidx].myblocks[j][optrowidx];
                                        block2 = gridregions[i][cat2idx].myblocks[j][optcolidx];
                                        removeconflictborders(block1, block2, keyblock);

                                        if ((cat1blockstatus == 3) && (cat2blockstatus == 2)) {
                                            showstepsolvemsg(block1, block2, keyblock);
                                            gridregions[i][cat1colidx].myblocks[j][optrowidx].setblock(1);
                                            modified = true;

                                        } else if ((cat1blockstatus == 2) && (cat2blockstatus == 3)) {
                                            showstepsolvemsg(block1, block2, keyblock);
                                            gridregions[i][cat2idx].myblocks[j][optcolidx].setblock(1);
                                            modified = true;

                                        }

                                    }//end j loop
                                }//end i loop
                            }//end conflict exists if statement
                        }
                    }  //end optcolidx for loop
                } //end optrowidx for loop
              
                  //derive obvious truth for each grid region
                if(!conflictexists)
                obvioustruthcomplete(gridregions[cat1idx][cat2idx]);

            } //End gridregions column loop category 2
           
        }//End gridregions row loop category 1

        boolean modified2 = false; //secondary flag which will indicate if the pending clues method modified the logic

        modified2 = checkpendingclues();
        if (modified || modified2)  //if the logic grid has been modified then return true and if not return false
            return true;
        else 
            return false;
    }

 /*
  * StepSolvebutHandler
  * Action listener for Step Solve button
  */
   private class Stepsolvebuthandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {
            stepsolve();
        }
    }

   /*
    * SubmitCluebutHandler
    * Action listener for Apply Clue button, this method applies entered clues to grid
    */
   private class Submitcluebuthandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {

            int choice = 0;
            int currstatus;
            if (clues.size() > 0) { //if clue vector is not empty

                if (!isgridclear())  //if grid has entered selections
                {
                    choice = JOptionPane.showConfirmDialog(buttonpanel, "Selections in the grid have been previously made, applying clues could result in"
                            + " modifiying existing selections, Would you like to proceed anyway?");
                }

                if (choice == 0) { //if user selects OKAY from Grid Selections warning box
                    int maincat1idx;
                    int maincat2idx;
                    int mainopt1idx;
                    int mainopt2idx;
                    int bool_choice;
                    Clue aclue = new Clue();

                    for (int i = 0; i < clues.size(); ++i) { //loop through entered clues and apply them to logic grid
                        aclue = clues.elementAt(i);
                        //if clue(i)'s associate clue vector is not empty apply associate clues to grid
                        if ((aclue.assoc_clues.size() > 0)) {
                            int assoc_catidx;
                            int assoc_optidx;
                            int status;
                            for (int j = 0; j < aclue.assoc_clues.size(); ++j) {
                                assoc_catidx = aclue.assoc_clues.elementAt(j).catidx;
                                assoc_optidx = aclue.assoc_clues.elementAt(j).optidx;
                                status = aclue.assoc_clues.elementAt(j).get_assoc_boolopt();
                                setblockstatus(aclue.maincat1_idx, aclue.mainopt1_idx, assoc_catidx, assoc_optidx, status);
                            }//end jth associate clue loop
                        } else if (aclue.pending == false) { //if clue(i) is not pending apply clue to grid
                            bool_choice = aclue.boolopt;
                            maincat1idx = aclue.maincat1_idx;
                            mainopt1idx = aclue.mainopt1_idx;
                            String msg;
                            int addcatidx = aclue.addt_catidx.elementAt(0);

                            int addoptidx = aclue.addt_optidx.elementAt(0);
                            if (aclue.addt_catname.size() > 0) { //loop through additional categorys in clue and apply to grid
                                for (int j = 0; j < aclue.addt_catname.size(); ++j) {
                                    addcatidx = aclue.addt_catidx.elementAt(j);
                                    addoptidx = aclue.addt_optidx.elementAt(j);
                                    currstatus = getblockstatus(maincat1idx, mainopt1idx, addcatidx, addoptidx);

                                    if (bool_choice == 0) //choice is IS therefor set to True (2) else set to False(1)
                                        setblockstatus(maincat1idx, mainopt1idx, addcatidx, addoptidx, 2);
                                    else 
                                        setblockstatus(maincat1idx, mainopt1idx, addcatidx, addoptidx, 1);
                                    

                                }//end j for loop
                            } //end aclue.addt_catname.size() if

                        }//end if pending else/if statment

                    }//end clue(i) for loop
                }
            } else {//Clue Vector is Empty
                showMessage("No Clues Have Been Entered");
            }//end if clue vector empty if statement

        }//end Apply buttton Action Performed
    }//end Submitbuthandler


   /*
    * Undobuthandler
    * Action Listener for Undo button , when pressed the last selection made on the logic grid is removed and is stored
    * in the redobutton stack
    */
private class Undobuthandler implements ActionListener {

        public void actionPerformed(ActionEvent event) {

            gridaction action;
            int regionidx1, regionidx2, blockidx1, blockidx2, status;

            boolean cmporuser;
            if (!(undostack.isEmpty())) {

                action = undostack.lastElement();

                //store action at the top of the undo stack and add this action to the top of the redo stack
                redostack.add(undostack.remove(undostack.size() - 1));
                redobut.setEnabled(true);
                regionidx1 = action.regionidx1;
                regionidx2 = action.regionidx2;
                blockidx1 = action.blockidx1;
                blockidx2 = action.blockidx2;
                status = action.status;
                cmporuser = action.comporuser;
                //set block to blank to undo
                gridregions[regionidx1][regionidx2].myblocks[blockidx1][blockidx2].setblock(3);
                gridregions[regionidx1][regionidx2].myblocks[blockidx1][blockidx2].comp_or_user = true;

            } else  //if undo stack vector is empty disable undo button
                undobut.setEnabled(false);
            
        }//Undo button Action Performed
    }//end Undo button handler

/*
 * writetoFile
 * Writes logic grid to a text file and writes clue vector
 */
     public boolean writetoFile(File file) {
        try {

            output = new BufferedWriter(new FileWriter(file));

            //Write number of categories and options
            output.write(Integer.toString(numofcat) + "\n" + Integer.toString(numofopt) + "\n");

            //Write Category names
            for (int i = 0; i < numofcat; ++i) 
                output.write(categorynames[i] + "\n");

            //Write Option names
            for (int i = 0; i < numofopt; ++i) 
                for (int j = 0; j < numofopt; ++j) 
                    output.write(optionnames[i][j] + "\n");
                           
            //Write each blocks status
            for (int i = 0; i < numofcat - 1; ++i) 
                for (int j = 0; j < gridregions[i].length; ++j)
                    //Loop through gridregion (i,j)'s blocks and write status to file
                    for (int k = 0; k < numofopt; ++k) {
                        for (int l = 0; l < numofopt; ++l) {
                            if (l != 0) 
                                output.write(" ");                          
                            output.write(Integer.toString(gridregions[i][j].myblocks[k][l].getblocknum()));
                        }
                        output.write("\n");
                    }

            //Write the number of clues in cluebank
            output.write(Integer.toString(usercontrols.cluebank.getItemCount()));
            output.write("\n");

            //Write each clue string
            if (usercontrols.cluebank.getItemCount() > 0) {
                int count = usercontrols.cluebank.getItemCount();
                for (int i = 0; i < count; ++i) {
                    output.write(usercontrols.cluebank.getItem(i));
                    output.write("\n");
                }
            }
            //Write the number of clues in clue vector
            output.write(Integer.toString(clues.size()));
            output.close(); //close output stream
        } catch (IOException e) {
            JOptionPane.showMessageDialog(this, "File does not exist: " + file);
        }

            //Create a clue list object file
            //Create a list object to store clues in clue vector
            java.util.List cluelist = new ArrayList();
            for (int i = 0; i < clues.size(); ++i) 
                cluelist.add(clues.elementAt(i));
            
            FileOutputStream outstream_file = null;
            ObjectOutputStream outstream_obj = null;

            //create file name for clue list object file
            String cluefile = file.getName() + "_cluedata";
            try {
                outstream_file = new FileOutputStream(cluefile);
                outstream_obj = new ObjectOutputStream(outstream_file);
                //write clue list object to file
                outstream_obj.writeObject(cluelist);
                outstream_obj.close();
                outstream_file.close();
            } catch (IOException e) {
                showMessage("Error Writing clues to file");
            }

        return true;
    }//end writetofile
     
}//end class Maingrid
