/*
	Diagonallabel.java
	Diagonal label which displays on upper horizantal panel of the logic , used to label the
	columns in the logic grid
*/
import java.awt.*;
import javax.swing.*;

public class Diagonallabel extends JComponent {

    JLabel label;

    public Diagonallabel(String text) {
        label = new JLabel(text);
        label.setFont(new Font("SansSerif", Font.PLAIN, 12));
        label.setOpaque(false);
		Dimension pref = label.getPreferredSize();
        label.setSize(label.getPreferredSize());
        setPreferredSize(pref);
    }

	//Paint Component for label which is configured so that the label displays slanted
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);

        Graphics2D twod_graphic = (Graphics2D) g;
        twod_graphic.translate(30, 30);
        twod_graphic.rotate(14.5 * (Math.PI / 8.0));
        twod_graphic.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        label.paint(twod_graphic);
    }//end paintcomponent

}//end class Diagonal Label


