/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class Maingrid
extends JFrame {
    gridblock[][] gridregions;
    String[][] optionnames;
    UserControls usercontrols;
    int rowcounter = 0;
    int xpos;
    int ypos;
    int width;
    int hieght;
    int numofcat;
    int numofopt;
    String[] categorynames;
    globals Globals = new globals();
    GridBagLayout buttongridbag = new GridBagLayout();
    GridBagConstraints button_constr = new GridBagConstraints();
    GridBagLayout v_lbls_gridbag = new GridBagLayout();
    GridBagConstraints v_lbls_constr = new GridBagConstraints();
    GridBagLayout horz_lbls_gridbag = new GridBagLayout();
    GridBagConstraints horz_lbls_constr = new GridBagConstraints();
    GridBagLayout this_gridbag = new GridBagLayout();
    GridBagConstraints this_constr = new GridBagConstraints();
    JPanel buttonpanel = new JPanel();
    JPanel horiz_lbls_panel = new JPanel();
    JPanel vert_lbls_panel = new JPanel();
    JPanel controlbut_panel = new JPanel();
    JButton stepsolvebut = new JButton("Step Solve >>");
    JButton resetbut = new JButton("Reset Grid");
    JButton undobut = new JButton("Undo");
    JButton redobut = new JButton("Redo");
    JButton allsolve = new JButton("All Solve");
    JButton savebut = new JButton("Save Grid to File");
    JButton exit_homebut = new JButton("Go Back to HomePage");
    JFileChooser filechooser;
    FileFilter filefilter;
    File defaultfile;
    Writer output;
    Vector<gridaction> undostack = new Vector();
    Vector<gridaction> redostack = new Vector();
    Vector<Clue> clues = new Vector();
    JCheckBox autocompletecb;
    SplashScreen myhomescreen;
    SplashScreen thisgridscreen;
    boolean conflictexists = false;
    int optrowidx;
    int optcolidx;
    int cat1idx;
    int cat2idx;

    Maingrid(int numcat, int numopt, SplashScreen gridscreen) {
        this.myhomescreen = gridscreen.myhomescreen;
        this.usercontrols = gridscreen.usercontrols;
        this.thisgridscreen = gridscreen;
        this.setLayout(null);
        this.setTitle("Logic Puzzle Solver");
        this.numofcat = numcat;
        this.numofopt = numopt;
        this.categorynames = new String[this.numofcat];
        this.rowcounter = 0;
        this.gridregions = new gridblock[this.numofcat - 1][];
        for (int i = this.numofcat - 1; i > 0; --i) {
            this.gridregions[this.rowcounter] = new gridblock[i];
            for (int j = 0; j < this.gridregions[this.rowcounter].length; ++j) {
                this.gridregions[this.rowcounter][j] = new gridblock(this.numofopt, this.rowcounter, j, this.rowcounter + 1, i + 1);
            }
            ++this.rowcounter;
        }
    }

    Maingrid(int numcat, int numopt, gridblock[][] ingridregions, String[] categorys, UserControls userc, SplashScreen homescreen) {
        this.myhomescreen = homescreen;
        this.numofcat = numcat;
        this.numofopt = numopt;
        this.gridregions = ingridregions;
        this.categorynames = new String[categorys.length];
        for (int i = 0; i < categorys.length; ++i) {
            this.categorynames[i] = categorys[i];
        }
        this.usercontrols = userc;
        this.initializeComponents();
    }

    public boolean checkpendingclues() {
        Clue aclue = new Clue();
        boolean modified = false;
        for (int i = 0; i < this.clues.size(); ++i) {
            int j;
            int addoptidx;
            int addcatidx;
            aclue = this.clues.elementAt(i);
            if (!aclue.pending) continue;
            int maincat1 = aclue.maincat1_idx;
            int opt1idx = aclue.mainopt1_idx;
            int status = 0;
            if (aclue.addt_catidx.size() == 1) {
                boolean trueblockfound = false;
                addcatidx = aclue.addt_catidx.lastElement();
                addoptidx = aclue.addt_optidx.lastElement();
                for (j = 0; j < this.numofopt; ++j) {
                    status = this.getblockstatus(maincat1, j, addcatidx, addoptidx);
                    if (status == 2) {
                        trueblockfound = true;
                    }
                    if ((status = this.getblockstatus(maincat1, opt1idx, addcatidx, j)) != 2) continue;
                    trueblockfound = true;
                }
                if (trueblockfound) {
                    this.showMessage("Pending Clue Conflict found");
                    continue;
                }
                this.setblockstatus(maincat1, opt1idx, addcatidx, addoptidx, 2);
                modified = true;
                aclue.pending = false;
                continue;
            }
            if (aclue.addt_catidx.size() <= 1) continue;
            int size = aclue.addt_catidx.size();
            for (j = 0; j < size; ++j) {
                addcatidx = aclue.addt_catidx.elementAt(j);
                status = this.getblockstatus(maincat1, opt1idx, addcatidx, addoptidx = aclue.addt_optidx.elementAt(j).intValue());
                if (status == 1) {
                    aclue.deleteaddit_cat(j);
                    modified = true;
                    --size;
                }
                if (status != 2) continue;
                aclue.pending = false;
            }
        }
        return modified;
    }

    public int getblockstatus(int cat1idx, int opt1idx, int cat2idx, int opt2idx) {
        int blockstatus = 0;
        for (int i = 0; i < this.gridregions.length; ++i) {
            for (int j = 0; j < this.gridregions[i].length; ++j) {
                int cid1 = this.gridregions[i][j].cat1.getid();
                int cid2 = this.gridregions[i][j].cat2.getid();
                if (cat1idx == cid1 && cat2idx == cid2) {
                    blockstatus = this.gridregions[i][j].getblockstatus(opt1idx, opt2idx);
                }
                if (cat2idx != cid1 || cat1idx != cid2) continue;
                blockstatus = this.gridregions[i][j].getblockstatus(opt2idx, opt1idx);
            }
        }
        return blockstatus;
    }

    public boolean gridcomplete() {
        boolean complete = true;
        for (int i = 0; i < this.numofcat - 1; ++i) {
            for (int j = 0; j < this.gridregions[i].length; ++j) {
                if (this.gridregions[i][j].iscomplete()) continue;
                complete = false;
            }
        }
        return complete;
    }

    public void initializeComponents() {
        this.setLayout(null);
        this.width = 850;
        this.hieght = 700;
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("question-mark-red.jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setIconImage(image);
        this.setTitle("Logic Puzzle Solver");
        this.setSize(this.width, this.hieght);
        this.vert_lbls_panel.setBackground(Color.WHITE);
        this.vert_lbls_panel.setLayout(this.v_lbls_gridbag);
        Dimension vert_panel_d = new Dimension(80, this.Globals.offset * (this.numofcat - 1) * this.numofopt);
        this.vert_lbls_panel.setPreferredSize(vert_panel_d);
        this.v_lbls_constr.weighty = 0.5;
        this.v_lbls_constr.anchor = 17;
        this.buttonpanel.setOpaque(false);
        this.buttonpanel.setLayout(this.buttongridbag);
        Dimension button_panel_d = new Dimension(this.numofopt * this.Globals.offset * (this.numofcat - 1), this.numofopt * this.Globals.offset * (this.numofcat - 1));
        this.buttonpanel.setPreferredSize(button_panel_d);
        Dimension horiz_panel_d = new Dimension(this.Globals.offset * (this.numofcat - 1) * this.numofopt + 50, 100);
        this.horiz_lbls_panel.setPreferredSize(horiz_panel_d);
        this.horiz_lbls_panel.setBackground(Color.WHITE);
        Stepsolvebuthandler stephandler = new Stepsolvebuthandler();
        Resetbuthandler resetbuthandler = new Resetbuthandler();
        Undobuthandler undobuthandler = new Undobuthandler();
        Redobuthandler redobuthandler = new Redobuthandler();
        SavebutHandler savebuthandler = new SavebutHandler();
        ExitbutHandler exitbuthandler = new ExitbutHandler();
        Addcluebuthandler addcluebuthandler = new Addcluebuthandler();
        Deletecluebuthandler deletecluebuthandler = new Deletecluebuthandler();
        Allsolvebuthandler allsolvebuthandler = new Allsolvebuthandler();
        Submitcluebuthandler submitbuthandler = new Submitcluebuthandler();
        this.usercontrols.deleteclue.addActionListener(deletecluebuthandler);
        this.usercontrols.Applybut.addActionListener(submitbuthandler);
        this.stepsolvebut.addActionListener(stephandler);
        Dimension component_d = new Dimension(120, 20);
        Dimension component_d2 = new Dimension(60, 50);
        this.stepsolvebut.setPreferredSize(component_d);
        this.resetbut.addActionListener(resetbuthandler);
        Dimension componentsize = component_d.getSize();
        Dimension componentsize2 = component_d2.getSize();
        Dimension panelsize = new Dimension(150, 400);
        this.controlbut_panel.setBounds(650, 370, panelsize.width + 5, panelsize.height);
        Border bevel = BorderFactory.createRaisedBevelBorder();
        this.controlbut_panel.setBorder(bevel);
        this.undobut.setBounds(0, 200, componentsize2.width, componentsize2.height);
        this.undobut.addActionListener(undobuthandler);
        this.undobut.setEnabled(false);
        this.redobut.setBounds(60, 200, componentsize2.width, componentsize2.height);
        this.redobut.addActionListener(redobuthandler);
        this.redobut.setEnabled(false);
        Dimension d2 = this.exit_homebut.getPreferredSize();
        this.exit_homebut.setBounds(650, 575, d2.width, d2.height);
        this.exit_homebut.addActionListener(exitbuthandler);
        this.stepsolvebut.setBounds(0, 0, componentsize.width, componentsize.height);
        this.resetbut.setBounds(650, 620, d2.width, d2.height);
        this.savebut.setBounds(650, 550, d2.width, d2.height);
        this.savebut.addActionListener(savebuthandler);
        this.allsolve.addActionListener(allsolvebuthandler);
        this.allsolve.setBounds(0, 300, componentsize.width, componentsize.height);
        this.controlbut_panel.add(this.stepsolvebut);
        this.controlbut_panel.add(this.undobut);
        this.controlbut_panel.add(this.redobut);
        this.controlbut_panel.add(this.allsolve);
        this.add(this.resetbut);
        this.add(this.savebut);
        this.add(this.exit_homebut);
        this.filechooser = new JFileChooser();
        Dimension size = this.usercontrols.getPreferredSize();
        this.usercontrols.setBounds(838, 20, size.width, size.height);
        this.add(this.controlbut_panel);
        this.add(this.usercontrols);
        this.usercontrols.addcluebut.addActionListener(addcluebuthandler);
        this.filefilter = new FileFilter();
        this.defaultfile = new File("grid.lps");
    }

    void generategrid(String[][] options) {
        this.optionnames = options;
        boolean offset = false;
        this.xpos = 0;
        this.ypos = 35;
        int cat1index = 0;
        int cat2index = this.numofcat - 1;
        int xposlbl = 60;
        int yposlbl = 20;
        int xpos2 = 40;
        int ypos2 = 110;
        boolean counter = false;
        int width = this.Globals.offset * this.numofopt;
        int hieght = this.Globals.offset * this.numofopt;
        Diagonallabel[] diag_lbls = new Diagonallabel[(this.numofcat - 1) * this.numofopt];
        JLabel[] cat_lbls = new JLabel[(this.numofcat - 1) * this.numofopt];
        Gridbuthandler gridbuthandler = new Gridbuthandler();
        int vert_lbl_counter = 0;
        int horz_lbl_counter = 0;
        for (int i = 0; i < this.numofcat - 1; ++i) {
            for (int j = 0; j < this.gridregions[i].length; ++j) {
                int k;
                this.gridregions[i][j].cat1.setCat_name(this.categorynames[cat1index]);
                this.gridregions[i][j].cat1.setoptions(options[cat1index]);
                this.gridregions[i][j].cat1.setid(cat1index);
                this.gridregions[i][j].cat2.setCat_name(this.categorynames[cat2index]);
                this.gridregions[i][j].cat2.setoptions(options[cat2index]);
                this.gridregions[i][j].cat2.setid(cat2index);
                for (k = 0; k < this.numofopt; ++k) {
                    for (int l = 0; l < this.numofopt; ++l) {
                        this.gridregions[i][j].myblocks[k][l].addActionListener(gridbuthandler);
                        this.gridregions[i][j].myblocks[k][l].setoptionnames(this.gridregions[i][j].cat1.getOpt_name(k), this.gridregions[i][j].cat2.getOpt_name(l));
                    }
                }
                if (i == 0) {
                    for (k = 0; k < this.numofopt; ++k) {
                        diag_lbls[horz_lbl_counter] = new Diagonallabel(this.gridregions[i][j].cat2.getOpt_name(k));
                        diag_lbls[horz_lbl_counter].setLocation(xposlbl, yposlbl);
                        diag_lbls[horz_lbl_counter].setSize(this.Globals.textbx_width, 60);
                        this.add(diag_lbls[horz_lbl_counter]);
                        diag_lbls[horz_lbl_counter].repaint();
                        xposlbl += this.Globals.offset;
                        ++horz_lbl_counter;
                    }
                }
                if (j == 0) {
                    for (k = 0; k < this.numofopt; ++k) {
                        cat_lbls[vert_lbl_counter] = new JLabel(this.gridregions[i][j].cat1.getOpt_name(k));
                        cat_lbls[vert_lbl_counter].setSize(40, 10);
                        this.v_lbls_constr.gridx = 0;
                        this.v_lbls_constr.gridy = vert_lbl_counter;
                        this.v_lbls_gridbag.setConstraints(cat_lbls[vert_lbl_counter], this.v_lbls_constr);
                        this.vert_lbls_panel.add(cat_lbls[vert_lbl_counter]);
                        ypos2 += this.Globals.offset;
                        ++vert_lbl_counter;
                    }
                }
                this.button_constr.gridx = this.xpos++;
                this.button_constr.gridy = this.ypos;
                this.buttongridbag.setConstraints(this.gridregions[i][j], this.button_constr);
                this.buttonpanel.add(this.gridregions[i][j]);
                --cat2index;
            }
            cat2index = this.numofcat - 1;
            ++cat1index;
            this.xpos = 0;
            ++this.ypos;
        }
        this.add(this.vert_lbls_panel);
        Dimension size = this.vert_lbls_panel.getPreferredSize();
        this.vert_lbls_panel.setBounds(0, 65, size.width, size.height);
        this.add(this.buttonpanel);
        size = this.buttonpanel.getPreferredSize();
        this.buttonpanel.setBounds(85, 65, size.width, size.height);
        this.buttonpanel.repaint();
        this.repaint();
    }

    void gotohomescreen() {
        int choice = JOptionPane.showConfirmDialog(this, "Would you like to save the current grid before exiting?");
        switch (choice) {
            case 0: {
                this.saveFile();
                this.setVisible(false);
                this.myhomescreen.setVisible(true);
                break;
            }
            case 1: {
                this.setVisible(false);
                this.myhomescreen.setVisible(true);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public boolean isgridclear() {
        boolean clear = true;
        for (int i = 0; i < this.numofcat - 1; ++i) {
            for (int j = 0; j < this.gridregions[i].length; ++j) {
                if (this.gridregions[i][j].isclear()) continue;
                clear = false;
            }
        }
        return clear;
    }

    public void obvioustruthcomplete(gridblock region) {
        int length = region.myblocks[0].length;
        int falsecounter1 = 0;
        int falsecounter2 = 0;
        int blankrowindex1 = -1;
        int blankcolindex2 = -1;
        int truecount1 = 0;
        int truecount2 = 0;
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                if (region.myblocks[i][j].getblocknum() == 3) {
                    blankcolindex2 = j;
                }
                if (region.myblocks[j][i].getblocknum() == 3) {
                    blankrowindex1 = j;
                }
                if (region.myblocks[i][j].getblocknum() == 1) {
                    ++falsecounter1;
                }
                if (region.myblocks[j][i].getblocknum() == 1) {
                    ++falsecounter2;
                }
                if (region.myblocks[i][j].getblocknum() == 2) {
                    ++truecount1;
                }
                if (region.myblocks[j][i].getblocknum() != 2) continue;
                ++truecount2;
            }
            if (falsecounter1 == length - 1 && blankcolindex2 != -1) {
                region.myblocks[i][blankcolindex2].setblock(2);
            }
            if (falsecounter2 == length - 1 && blankrowindex1 != -1) {
                region.myblocks[blankrowindex1][i].setblock(2);
            }
            if (truecount1 == 1 && falsecounter1 == length - 2 && blankcolindex2 != -1) {
                region.myblocks[i][blankcolindex2].setblock(1);
            }
            if (truecount2 == 1 && falsecounter2 == length - 2 && blankrowindex1 != -1) {
                region.myblocks[blankrowindex1][i].setblock(1);
            }
            falsecounter1 = 0;
            falsecounter2 = 0;
            blankrowindex1 = -1;
            blankcolindex2 = -1;
            truecount1 = 0;
            truecount2 = 0;
        }
    }

    public void removeconflictborders(Block block1, Block block2, Block keyblock) {
        keyblock.setBorder(BorderFactory.createEmptyBorder());
        block1.setBorder(BorderFactory.createEmptyBorder());
        block2.setBorder(BorderFactory.createEmptyBorder());
        keyblock.repaint();
        block1.repaint();
        block2.repaint();
    }

    boolean saveFile() {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("."));
        fc.setFileFilter(this.filefilter);
        fc.setSelectedFile(this.defaultfile);
        int result = fc.showSaveDialog(this);
        if (result == 1) {
            return true;
        }
        if (result == 0) {
            int response;
            this.defaultfile = fc.getSelectedFile();
            if (this.defaultfile.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing grid file with file name:  " + this.defaultfile.getName(), "Confirm Overwrite", 2, 3)) == 2) {
                return false;
            }
            return this.writetoFile(this.defaultfile);
        }
        return false;
    }

    public void setcategories(String[] categories) {
        for (int i = 0; i < categories.length; ++i) {
            this.categorynames[i] = categories[i];
        }
    }

    public void setclues(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.clues.add((Clue)list.get(i));
        }
    }

    public void setUsercontrols(UserControls usersc) {
        this.usercontrols = usersc;
    }

    public void setblockstatus(int cat1idx, int opt1idx, int cat2idx, int opt2idx, int status) {
        for (int i = 0; i < this.gridregions.length; ++i) {
            for (int j = 0; j < this.gridregions[i].length; ++j) {
                int cid1 = this.gridregions[i][j].cat1.getid();
                int cid2 = this.gridregions[i][j].cat2.getid();
                if (cat1idx == cid1 && cat2idx == cid2) {
                    this.gridregions[i][j].getblock(opt1idx, opt2idx).setblock(status);
                }
                if (cat2idx != cid1 || cat1idx != cid2) continue;
                this.gridregions[i][j].getblock(opt2idx, opt1idx).setblock(status);
            }
        }
    }

    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public void showmismatchpair(Block blk1, Block blk2, Block keyblk) {
        String msg = "MISMATCH\n";
        if (keyblk.getblocknum() == 2) {
            msg = msg + keyblk.cat1optname + " is " + keyblk.cat2optname + "\n";
        } else if (keyblk.getblocknum() == 1) {
            msg = msg + " " + keyblk.cat1optname + " is NOT " + keyblk.cat2optname + "\n";
        }
        if (blk1.getblocknum() == 2) {
            msg = msg + blk1.cat1optname + " is " + blk1.cat2optname;
        } else if (blk1.getblocknum() == 1) {
            msg = msg + blk1.cat1optname + " is NOT " + blk1.cat2optname;
        }
        msg = msg + "\n";
        if (blk2.getblocknum() == 2) {
            msg = msg + blk2.cat1optname + " is " + blk2.cat2optname;
        } else if (blk2.getblocknum() == 1) {
            msg = msg + blk2.cat1optname + " is NOT " + blk2.cat2optname;
        }
        blk1.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        blk2.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        keyblk.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        blk1.repaint();
        blk2.repaint();
        keyblk.repaint();
        JOptionPane.showMessageDialog(this, msg);
        this.optcolidx = this.numofopt;
        this.optrowidx = this.numofopt;
        this.cat1idx = this.numofcat;
        this.cat2idx = this.numofcat;
        this.conflictexists = true;
    }

    public void showstepsolvemsg(Block block1, Block block2, Block keyblock) {
        String msg = "";
        if (keyblock.getblocknum() == 2) {
            msg = msg + keyblock.cat1optname + " is " + keyblock.cat2optname + " therefore, \n";
            if (block1.getblocknum() == 2) {
                msg = msg + "Since " + block1.cat1optname + " is " + block1.cat2optname + "\n";
                msg = msg + block2.cat1optname + "is " + block2.cat2optname;
            } else if (block1.getblocknum() == 1) {
                msg = msg + "Since " + block1.cat1optname + " is NOT " + block1.cat2optname + "\n";
                msg = msg + block2.cat1optname + "is NOT " + block2.cat2optname;
            } else if (block2.getblocknum() == 2) {
                msg = msg + "Since " + block2.cat1optname + " is " + block2.cat2optname + "\n";
                msg = msg + block1.cat1optname + " is " + block1.cat2optname;
            } else if (block2.getblocknum() == 1) {
                msg = msg + "Since " + block2.cat1optname + " is NOT " + block2.cat2optname + "\n";
                msg = msg + block1.cat1optname + " is NOT " + block1.cat2optname;
            }
        } else if (keyblock.getblocknum() == 1) {
            msg = msg + keyblock.cat1optname + " is NOT " + keyblock.cat2optname + " therefore, \n";
            if (block1.getblocknum() == 2) {
                msg = msg + "Since " + block1.cat1optname + " is " + block1.cat2optname + "\n";
                msg = msg + block2.cat1optname + " is NOT " + block2.cat2optname;
            } else if (block2.getblocknum() == 2) {
                msg = msg + "Since " + block2.cat1optname + " is " + block2.cat2optname + "\n";
                msg = msg + block1.cat1optname + " is NOT " + block1.cat2optname;
            }
        }
        JOptionPane.showMessageDialog(this, msg);
    }

    public void solvepuzzle() {
        boolean finished = false;
        while (!finished) {
            for (int i = 0; i < this.numofcat - 1; ++i) {
                for (int j = 0; j < this.gridregions[i].length; ++j) {
                    this.gridregions[i][j].autocomplete();
                }
            }
            if (this.stepsolve()) {
                finished = false;
                continue;
            }
            finished = true;
        }
        if (this.gridcomplete()) {
            JOptionPane.showMessageDialog(this, "Congratulations! Puzzle Solved!");
        } else {
            JOptionPane.showMessageDialog(this, "Puzzle Not Completely Solved.  ");
        }
    }

    public boolean stepsolve() {
        int length = this.numofcat - 1;
        this.conflictexists = false;
        boolean modified = false;
        this.cat1idx = 0;
        while (this.cat1idx < length) {
            int gridregionrowlength = this.gridregions[this.cat1idx].length;
            this.cat2idx = 0;
            while (this.cat2idx < gridregionrowlength) {
                this.optrowidx = 0;
                while (this.optrowidx < this.numofopt) {
                    this.optcolidx = 0;
                    while (this.optcolidx < this.numofopt) {
                        int cat2blockstatus;
                        int cat1blockstatus;
                        Block block2;
                        Block block1;
                        int j;
                        int i;
                        Block keyblock = this.gridregions[this.cat1idx][this.cat2idx].myblocks[this.optrowidx][this.optcolidx];
                        int cat2rowidx = length - this.cat2idx;
                        int cat1colidx = length - this.cat1idx;
                        String regionoptname1 = this.gridregions[this.cat1idx][this.cat2idx].cat1.getOpt_name(this.optrowidx);
                        String regionoptname2 = this.gridregions[this.cat1idx][this.cat2idx].cat2.getOpt_name(this.optcolidx);
                        if (this.gridregions[this.cat1idx][this.cat2idx].myblocks[this.optrowidx][this.optcolidx].getblocknum() == 2) {
                            for (i = 0; i < this.cat2idx; ++i) {
                                for (j = 0; j < this.numofopt; ++j) {
                                    if (this.conflictexists) continue;
                                    block1 = this.gridregions[this.cat1idx][i].myblocks[this.optrowidx][j];
                                    block2 = this.gridregions[cat2rowidx][i].myblocks[this.optcolidx][j];
                                    this.removeconflictborders(block1, block2, keyblock);
                                    cat1blockstatus = this.gridregions[this.cat1idx][i].myblocks[this.optrowidx][j].getblocknum();
                                    cat2blockstatus = this.gridregions[cat2rowidx][i].myblocks[this.optcolidx][j].getblocknum();
                                    String corr_cat2optname = this.gridregions[cat2rowidx][i].cat2.getOpt_name(j);
                                    String corr_cat1optname = this.gridregions[this.cat1idx][i].cat1.getOpt_name(i);
                                    if (cat1blockstatus != 3 && cat2blockstatus != 3 && cat1blockstatus != cat2blockstatus) {
                                        this.showmismatchpair(block1, block2, keyblock);
                                    }
                                    if (this.conflictexists) continue;
                                    if (cat1blockstatus == 3 && cat2blockstatus != 3) {
                                        this.showstepsolvemsg(block1, block2, keyblock);
                                        block1.setblock(cat2blockstatus);
                                        modified = true;
                                        continue;
                                    }
                                    if (cat1blockstatus == 3 || cat2blockstatus != 3) continue;
                                    this.showstepsolvemsg(block1, block2, keyblock);
                                    block2.setblock(cat1blockstatus);
                                    modified = true;
                                }
                            }
                            if (!this.conflictexists) {
                                for (i = 0; i < this.cat1idx; ++i) {
                                    for (j = 0; j < this.numofopt; ++j) {
                                        cat1blockstatus = this.gridregions[i][cat1colidx].myblocks[j][this.optrowidx].getblocknum();
                                        cat2blockstatus = this.gridregions[i][this.cat2idx].myblocks[j][this.optcolidx].getblocknum();
                                        block1 = this.gridregions[i][cat1colidx].myblocks[j][this.optrowidx];
                                        block2 = this.gridregions[i][this.cat2idx].myblocks[j][this.optcolidx];
                                        if (cat1blockstatus == 1 && cat2blockstatus == 2 || cat1blockstatus == 2 && cat2blockstatus == 1) {
                                            this.showmismatchpair(block1, block2, keyblock);
                                        }
                                        if (this.conflictexists) continue;
                                        if (cat1blockstatus == 3 && cat2blockstatus != 3) {
                                            this.showstepsolvemsg(block1, block2, keyblock);
                                            this.gridregions[i][cat1colidx].myblocks[j][this.optrowidx].setblock(cat2blockstatus);
                                            modified = true;
                                            continue;
                                        }
                                        if (cat1blockstatus == 3 || cat2blockstatus != 3) continue;
                                        this.showstepsolvemsg(block1, block2, keyblock);
                                        this.gridregions[i][this.cat2idx].myblocks[j][this.optcolidx].setblock(cat1blockstatus);
                                        modified = true;
                                    }
                                }
                            }
                        }
                        if (!this.conflictexists && this.gridregions[this.cat1idx][this.cat2idx].myblocks[this.optrowidx][this.optcolidx].getblocknum() == 1) {
                            for (i = 0; i < this.cat2idx; ++i) {
                                for (j = 0; j < this.numofopt; ++j) {
                                    if (this.conflictexists) continue;
                                    cat1blockstatus = this.gridregions[this.cat1idx][i].myblocks[this.optrowidx][j].getblocknum();
                                    cat2blockstatus = this.gridregions[cat2rowidx][i].myblocks[this.optcolidx][j].getblocknum();
                                    block1 = this.gridregions[this.cat1idx][i].myblocks[this.optrowidx][j];
                                    block2 = this.gridregions[cat2rowidx][i].myblocks[this.optcolidx][j];
                                    this.removeconflictborders(block1, block2, keyblock);
                                    if (cat2blockstatus == 2 && cat1blockstatus == 2) {
                                        this.showmismatchpair(block1, block2, keyblock);
                                    }
                                    if (this.conflictexists) continue;
                                    if (cat1blockstatus == 3 && cat2blockstatus == 2) {
                                        this.showstepsolvemsg(block1, block2, keyblock);
                                        this.gridregions[this.cat1idx][i].myblocks[this.optrowidx][j].setblock(1);
                                        modified = true;
                                        continue;
                                    }
                                    if (cat1blockstatus != 2 || cat2blockstatus != 3) continue;
                                    this.showstepsolvemsg(block1, block2, keyblock);
                                    this.gridregions[cat2rowidx][i].myblocks[this.optcolidx][j].setblock(1);
                                    modified = true;
                                }
                            }
                            if (!this.conflictexists) {
                                for (i = 0; i < this.cat1idx; ++i) {
                                    for (j = 0; j < this.numofopt; ++j) {
                                        cat1blockstatus = this.gridregions[i][cat1colidx].myblocks[j][this.optrowidx].getblocknum();
                                        cat2blockstatus = this.gridregions[i][this.cat2idx].myblocks[j][this.optcolidx].getblocknum();
                                        block1 = this.gridregions[i][cat1colidx].myblocks[j][this.optrowidx];
                                        block2 = this.gridregions[i][this.cat2idx].myblocks[j][this.optcolidx];
                                        this.removeconflictborders(block1, block2, keyblock);
                                        if (cat1blockstatus == 3 && cat2blockstatus == 2) {
                                            this.showstepsolvemsg(block1, block2, keyblock);
                                            this.gridregions[i][cat1colidx].myblocks[j][this.optrowidx].setblock(1);
                                            modified = true;
                                            continue;
                                        }
                                        if (cat1blockstatus != 2 || cat2blockstatus != 3) continue;
                                        this.showstepsolvemsg(block1, block2, keyblock);
                                        this.gridregions[i][this.cat2idx].myblocks[j][this.optcolidx].setblock(1);
                                        modified = true;
                                    }
                                }
                            }
                        }
                        ++this.optcolidx;
                    }
                    ++this.optrowidx;
                }
                if (!this.conflictexists) {
                    this.obvioustruthcomplete(this.gridregions[this.cat1idx][this.cat2idx]);
                }
                ++this.cat2idx;
            }
            ++this.cat1idx;
        }
        boolean modified2 = false;
        modified2 = this.checkpendingclues();
        return modified || modified2;
    }

    public boolean writetoFile(File file) {
        int i;
        try {
            int j;
            int i2;
            this.output = new BufferedWriter(new FileWriter(file));
            this.output.write(Integer.toString(this.numofcat) + "\n" + Integer.toString(this.numofopt) + "\n");
            for (i2 = 0; i2 < this.numofcat; ++i2) {
                this.output.write(this.categorynames[i2] + "\n");
            }
            for (i2 = 0; i2 < this.numofopt; ++i2) {
                for (j = 0; j < this.numofopt; ++j) {
                    this.output.write(this.optionnames[i2][j] + "\n");
                }
            }
            for (i2 = 0; i2 < this.numofcat - 1; ++i2) {
                for (j = 0; j < this.gridregions[i2].length; ++j) {
                    for (int k = 0; k < this.numofopt; ++k) {
                        for (int l = 0; l < this.numofopt; ++l) {
                            if (l != 0) {
                                this.output.write(" ");
                            }
                            this.output.write(Integer.toString(this.gridregions[i2][j].myblocks[k][l].getblocknum()));
                        }
                        this.output.write("\n");
                    }
                }
            }
            this.output.write(Integer.toString(this.usercontrols.cluebank.getItemCount()));
            this.output.write("\n");
            if (this.usercontrols.cluebank.getItemCount() > 0) {
                int count = this.usercontrols.cluebank.getItemCount();
                for (i = 0; i < count; ++i) {
                    this.output.write(this.usercontrols.cluebank.getItem(i));
                    this.output.write("\n");
                }
            }
            this.output.write(Integer.toString(this.clues.size()));
            this.output.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "File does not exist: " + file);
        }
        ArrayList<Clue> cluelist = new ArrayList<Clue>();
        for (i = 0; i < this.clues.size(); ++i) {
            cluelist.add(this.clues.elementAt(i));
        }
        FileOutputStream outstream_file = null;
        ObjectOutputStream outstream_obj = null;
        String cluefile = file.getName() + "_cluedata";
        try {
            outstream_file = new FileOutputStream(cluefile);
            outstream_obj = new ObjectOutputStream(outstream_file);
            outstream_obj.writeObject(cluelist);
            outstream_obj.close();
            outstream_file.close();
        }
        catch (IOException e) {
            this.showMessage("Error Writing clues to file");
        }
        return true;
    }

    private class Undobuthandler
    implements ActionListener {
        private Undobuthandler() {
        }

        public void actionPerformed(ActionEvent event) {
            if (!Maingrid.this.undostack.isEmpty()) {
                gridaction action = Maingrid.this.undostack.remove(Maingrid.this.undostack.size() - 1);
                if (Maingrid.this.undostack.size() == 0) {
                    Maingrid.this.undobut.setEnabled(false);
                }
                Maingrid.this.redostack.add(action);
                Maingrid.this.redobut.setEnabled(true);
                int regionidx1 = action.regionidx1;
                int regionidx2 = action.regionidx2;
                int blockidx1 = action.blockidx1;
                int blockidx2 = action.blockidx2;
                int status = action.status;
                boolean cmporuser = action.comporuser;
                Maingrid.this.gridregions[regionidx1][regionidx2].myblocks[blockidx1][blockidx2].setblock(3);
                Maingrid.this.gridregions[regionidx1][regionidx2].myblocks[blockidx1][blockidx2].comp_or_user = true;
            } else {
                Maingrid.this.undobut.setEnabled(false);
            }
        }
    }

    private class Submitcluebuthandler
    implements ActionListener {
        private Submitcluebuthandler() {
        }

        public void actionPerformed(ActionEvent event) {
            int choice = 0;
            if (Maingrid.this.clues.size() > 0) {
                if (!Maingrid.this.isgridclear()) {
                    choice = JOptionPane.showConfirmDialog(Maingrid.this.buttonpanel, "Selections in the grid have been previously made, applying clues could result in modifiying existing selections, Would you like to proceed anyway?");
                }
                if (choice == 0) {
                    Clue aclue = new Clue();
                    for (int i = 0; i < Maingrid.this.clues.size(); ++i) {
                        int j;
                        aclue = Maingrid.this.clues.elementAt(i);
                        if (aclue.assoc_clues.size() > 0) {
                            for (j = 0; j < aclue.assoc_clues.size(); ++j) {
                                int assoc_catidx = aclue.assoc_clues.elementAt((int)j).catidx;
                                int assoc_optidx = aclue.assoc_clues.elementAt((int)j).optidx;
                                int status = aclue.assoc_clues.elementAt(j).get_assoc_boolopt();
                                Maingrid.this.setblockstatus(aclue.maincat1_idx, aclue.mainopt1_idx, assoc_catidx, assoc_optidx, status);
                            }
                            continue;
                        }
                        if (aclue.pending) continue;
                        int bool_choice = aclue.boolopt;
                        int maincat1idx = aclue.maincat1_idx;
                        int mainopt1idx = aclue.mainopt1_idx;
                        int addcatidx = aclue.addt_catidx.elementAt(0);
                        int addoptidx = aclue.addt_optidx.elementAt(0);
                        if (aclue.addt_catname.size() <= 0) continue;
                        for (j = 0; j < aclue.addt_catname.size(); ++j) {
                            addcatidx = aclue.addt_catidx.elementAt(j);
                            addoptidx = aclue.addt_optidx.elementAt(j);
                            int currstatus = Maingrid.this.getblockstatus(maincat1idx, mainopt1idx, addcatidx, addoptidx);
                            if (bool_choice == 0) {
                                Maingrid.this.setblockstatus(maincat1idx, mainopt1idx, addcatidx, addoptidx, 2);
                                continue;
                            }
                            Maingrid.this.setblockstatus(maincat1idx, mainopt1idx, addcatidx, addoptidx, 1);
                        }
                    }
                }
            } else {
                Maingrid.this.showMessage("No Clues Have Been Entered");
            }
        }
    }

    private class Stepsolvebuthandler
    implements ActionListener {
        private Stepsolvebuthandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Maingrid.this.stepsolve();
        }
    }

    private class SavebutHandler
    implements ActionListener {
        private SavebutHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            boolean flag = Maingrid.this.saveFile();
        }
    }

    private class Resetbuthandler
    implements ActionListener {
        private Resetbuthandler() {
        }

        public void actionPerformed(ActionEvent event) {
            for (int i = 0; i < Maingrid.this.numofcat - 1; ++i) {
                for (int j = 0; j < Maingrid.this.gridregions[i].length; ++j) {
                    Maingrid.this.gridregions[i][j].reset();
                }
            }
            Maingrid.this.redostack.clear();
            Maingrid.this.redobut.setEnabled(false);
            Maingrid.this.undostack.clear();
            Maingrid.this.undobut.setEnabled(false);
        }
    }

    private class Redobuthandler
    implements ActionListener {
        private Redobuthandler() {
        }

        public void actionPerformed(ActionEvent event) {
            if (!Maingrid.this.redostack.isEmpty()) {
                gridaction action = Maingrid.this.redostack.remove(Maingrid.this.redostack.size() - 1);
                if (Maingrid.this.redostack.size() == 0) {
                    Maingrid.this.redobut.setEnabled(false);
                }
                Maingrid.this.undostack.add(action);
                Maingrid.this.undobut.setEnabled(true);
                int regionidx1 = action.regionidx1;
                int regionidx2 = action.regionidx2;
                int blockidx1 = action.blockidx1;
                int blockidx2 = action.blockidx2;
                int status = action.status;
                boolean cmporuser = action.comporuser;
                Maingrid.this.gridregions[regionidx1][regionidx2].myblocks[blockidx1][blockidx2].setblock(status);
                Maingrid.this.gridregions[regionidx1][regionidx2].myblocks[blockidx1][blockidx2].comp_or_user = cmporuser;
            } else {
                Maingrid.this.redobut.setEnabled(false);
            }
        }
    }

    private class Gridbuthandler
    implements ActionListener {
        private Gridbuthandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Maingrid.this.undobut.setEnabled(true);
            ((Block)event.getSource()).block_click();
            Block ablock = (Block)event.getSource();
            int ridx1 = ablock.regionidx1;
            int ridx2 = ablock.regionidx2;
            int bidx1 = ablock.index1;
            int bidx2 = ablock.index2;
            int prevbstatus = ablock.status;
            Maingrid.this.undostack.add(new gridaction(prevbstatus, ridx1, ridx2, bidx1, bidx2, ablock.comp_or_user));
        }
    }

    private class ExitbutHandler
    implements ActionListener {
        private ExitbutHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Maingrid.this.gotohomescreen();
        }
    }

    private class Deletecluebuthandler
    implements ActionListener {
        private Deletecluebuthandler() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Maingrid.this.clues.size() > 0 && Maingrid.this.usercontrols.cluebank.getSelectedIndex() != -1) {
                Maingrid.this.clues.remove(Maingrid.this.usercontrols.cluebank.getSelectedIndex());
                int indx = Maingrid.this.usercontrols.cluebank.getSelectedIndex();
                Maingrid.this.usercontrols.cluebank.remove(indx);
            }
        }
    }

    private class Allsolvebuthandler
    implements ActionListener {
        private Allsolvebuthandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Maingrid.this.solvepuzzle();
        }
    }

    private class Addcluebuthandler
    implements ActionListener {
        private Addcluebuthandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Clue a_clue = new Clue();
            String main_cat1_name = (String)Maingrid.this.usercontrols.Cat1_dropd.getSelectedItem();
            int main_cat1idx = Maingrid.this.usercontrols.Cat1_dropd.getSelectedIndex() - 1;
            String main_cat2_name = (String)Maingrid.this.usercontrols.cat2dropd.getSelectedItem();
            int main_cat2idx = Maingrid.this.usercontrols.cat2dropd.getSelectedIndex() - 1;
            String opt1name = (String)Maingrid.this.usercontrols.Opt1dropd.getSelectedItem();
            int opt1idx = Maingrid.this.usercontrols.Opt1dropd.getSelectedIndex();
            String opt2name = (String)Maingrid.this.usercontrols.opt2dropd.getSelectedItem();
            int opt2idx = Maingrid.this.usercontrols.opt2dropd.getSelectedIndex();
            a_clue.setcategory1(main_cat1_name, main_cat1idx, opt1name, opt1idx);
            a_clue.setcategory2(main_cat2_name, main_cat2idx, opt2name, opt2idx);
            a_clue.setand_or(Maingrid.this.usercontrols.andordropd.getSelectedIndex());
            a_clue.setbooleanoption(Maingrid.this.usercontrols.booloptdropd.getSelectedIndex());
            int numof_addtcats = Maingrid.this.usercontrols.additional_cats.size();
            boolean samecategory = true;
            if (numof_addtcats > 0) {
                int curr_cat_idx = main_cat2idx;
                JComboBox combobx = new JComboBox();
                for (int i = 0; i < numof_addtcats; ++i) {
                    combobx = Maingrid.this.usercontrols.additional_cats.elementAt(i);
                    if (combobx.getSelectedIndex() == 0) continue;
                    String catname = (String)Maingrid.this.usercontrols.additional_cats.elementAt(i).getSelectedItem();
                    int catidx = Maingrid.this.usercontrols.additional_cats.elementAt(i).getSelectedIndex() - 1;
                    if (curr_cat_idx != catidx) {
                        samecategory = false;
                    }
                    String optname = (String)Maingrid.this.usercontrols.additional_opts.elementAt(i).getSelectedItem();
                    int optidx = Maingrid.this.usercontrols.additional_opts.elementAt(i).getSelectedIndex();
                    a_clue.setaddit_cat(catname, catidx, optname, optidx);
                }
                if (a_clue.getand_or() == 2 && a_clue.getbooleanoption() == 0) {
                    a_clue.pending = true;
                    if (samecategory) {
                        boolean found = false;
                        a_clue.pending = false;
                        for (int optionidx = 0; optionidx < Maingrid.this.numofopt; ++optionidx) {
                            found = false;
                            for (int j = 0; j < a_clue.addt_catidx.size(); ++j) {
                                if (a_clue.addt_optidx.elementAt(j) != optionidx) continue;
                                found = true;
                            }
                            if (found) continue;
                            a_clue.add_associate_clue(a_clue.addt_catidx.elementAt(0), optionidx, 1);
                        }
                    }
                } else {
                    a_clue.pending = false;
                }
            }
            Maingrid.this.clues.add(a_clue);
            Maingrid.this.usercontrols.addcluetocluebank();
            Maingrid.this.usercontrols.resetusercontrolpanel();
        }
    }
}

