#!/usr/local/bin/perl -w

# measure the complexity of a KATR program.

# input: standard in; a KATR program.
#	assumption: all rules start on new lines.
#  outputs:
#	number of nodes
#	number of rules
#	number of elements in left-hand sides of rules.

# Raphael Finkel, <raphael@cs.uky.edu> 11/18/1999

$nodeCount = 0;
$ruleCount = 0;
$elementCount = 0;
while (defined($line = <STDIN>)) { # one line of input
	$line =~ s/%.*//; # remove comments
	next if ($line =~ /^\s*$/); # ignore empty lines
	if ($line =~ /^\w+:\s*$/) { # a node
		# print "Node: $line";
		$nodeCount += 1;
	} elsif ($line =~ /^\s*<([^>]*)>\s*=/) { # a rule
		$ruleCount += 1;
		@elements = split /\s+/, $1;
		$count = 1 + $#elements;
		# print "$count: $line";
		$elementCount += $count;
	}
} # one line

print "Nodes $nodeCount; rules $ruleCount; elements $elementCount\n";


