/**
*    Name:   Rule.java
*    Author: Lei Shen 
*    Date:   Feb. 16, 1999
*/
import java.util.*;

/**
*   data structure for storing individual rules
*   A rule is somthing like:
*     <atom1 atom2 atom3> == terms
*/
class Rule {

   //left hand side path
   private Vector  vecAtoms;

   //Replace atoms for vecAtoms eg., < 1 2/3 4> =+= <5> , RHS => <5 1 3 4>
   //vecAtoms = [1, 2, 4] ; repVecAtoms = [1, 3, 4]
   private Vector repVecAtoms;

   //right hand side terms
   private Vector  vecTerms;

   //set rule or not
   private boolean bSet = false;

   //set suppressed or not -- '=+= operator specific'
   private boolean bNotSuppressed = false;

   /*
    *   After filling out by Parser
    *     1) vecAtoms should not be null
    *     2) vecAtoms not null, but have 0 element in vector means
    *        left hand side is <>
    *     3) vecTerms == null means right hand side is empty
    *     4) vecTerms if not null, then can not have 0 element
    */
   public Rule(){
   }

   public Vector getVecAtoms(){
      return vecAtoms;
   }

   public Vector getRepVecAtoms(){
      return repVecAtoms;
   }

   public Vector getVecTerms(){
      return vecTerms;
   }

   public boolean isSet(){
      return bSet;
   }

   public void setSet(){
      bSet = true;
   }

   public boolean isNotSuppressed(){
      return bNotSuppressed;
   }

   public void setNotSuppressed(){
      bNotSuppressed = true;
   }

   public void setVecAtoms(Vector vec){
      vecAtoms = vec;
   }

   public void setRepVecAtoms(Vector vec){
      repVecAtoms = vec;
   }

   public void addToVecTerms(Vector vec){
      if(vecTerms == null)
         vecTerms = vec;

      else if(vec != null){
         for(int i = 0; i < vec.size(); i ++){ 
             vecTerms.addElement(vec.elementAt(i));
         }
      }
   }

   public String toString(){

      StringBuffer str = new StringBuffer();
      if(bSet)
         str.append("{ ");
      else
          str.append("< ");

      for(int i = 0; i < vecAtoms.size(); i ++){
           str.append(vecAtoms.elementAt(i).toString());
           if(vecAtoms.elementAt(i) != repVecAtoms.elementAt(i))
              str.append("/"+repVecAtoms.elementAt(i).toString());
           str.append(" ");
      }

      if(bSet)
         str.append("} ");
      else
         str.append("> ");

      if(bNotSuppressed)
         str.append(" =+=  ");
      else
         str.append(" ==  ");

      if(vecTerms != null)
         for(int i = 0; i < vecTerms.size(); i ++){
             str.append(vecTerms.elementAt(i).toString());
         }
      else
         str.append("#null#");

      str.append("\n");
      return str.toString();
   }
}
