/**
*    Name:    Term.java
*    Author:  Lei Shen
*    Date:    Feb. 16, 1999
*/
import java.util.*;

/*
 *    The right side of rule is consist of 0+ terms.
 *    Seven basic terms:
 *       atom, <atoms>, Node, Node:<atoms>, 
 *       "<atoms>", "Node", "Node:<atoms>"
 *    Recursive terms:
 *       <terms>, Node:<terms>, "<terms>", "Node:<terms>"
 *
 *    Set term:
 *       {atoms} should only appear on the left side of rule
 * 
 */
class Term {

   //node name if any
   private String   strNode;

   //subterms if any
   private Vector   vecTerms;

   //global or local
   private boolean  bGlobal = false;

   //set term
   private boolean  bSet = false;
   
   public Term(){
   }

   public String getNode(){
      return strNode;
   }

   public Vector getVecTerms(){
      return vecTerms;
   }

   public boolean isGlobal(){
      return bGlobal;
   }

   public boolean isSet(){
      return bSet;
   }

   public void setNode(String str){
      strNode = str;
   }

   public void setSubTerms(Vector vec){
      vecTerms = vec;
   }

   public void setGlobal(){
      bGlobal = true;
   }

   public void setSet(){
      bSet = true;
   }

   /**
     * No sub terms and no global signs
     */
   public boolean isIdentifier(){
      boolean result = true;
      if(vecTerms != null || bGlobal)
          result = false;
      return result;
   }
 
   public String toString(){
       if(strNode == null && vecTerms == null)
           return " #null# ";

       StringBuffer  str = new StringBuffer();
       str.append(" ");

       if(bGlobal)
          str.append( "\"" );

       if(strNode != null)
          str.append(strNode);

       if(strNode != null && vecTerms != null)
          if(bSet)
             str.append(":{");
          else
             str.append(":<");

       if(strNode == null && vecTerms != null)
          if(bSet)
             str.append("{");
          else
             str.append("<");
       
       if(vecTerms != null)
          for(int i = 0; i < vecTerms.size(); i ++){
              str.append(vecTerms.elementAt(i).toString());
          }

       if((strNode != null && vecTerms != null) || 
          (strNode == null && vecTerms != null))
          if(bSet)
             str.append("}");
          else
             str.append(">");

       if(bGlobal)
          str.append("\"");

       str.append(" ");
       return str.toString();
   }

   /*
    *  The last term right before == is the path part for the rule
    *  Under this circumstance:
    *    the term must be in the format of: <atom1 ... >
    */
   public boolean toVecAtoms(Vector vecAtomsResult){

       if(getNode() != null || isGlobal())
           return false;

       else if(vecTerms != null){
           Term   curTerm  = null;
           for(int i = 0; i < vecTerms.size(); i ++){
              curTerm = (Term)vecTerms.elementAt(i);
              if(!curTerm.isIdentifier()){
                  return false;
              }
              vecAtomsResult.addElement(curTerm.getNode());          
           }
       }
       return true;
   }
}
