/**
*    Name:   Theory.java
*    Author: Suresh Thesayi
*    Date:   Jan. 11, 2000
*/

import java.util.*;
import java.io.*;

/*
 * This file mainly contains a class Check. The procedures in class Check is
 * called from the parser. It mainly provides the functionality of storing
 * and retriving string objects from a hashtable. The main purpose of doing
 * this is to provide extra error checking functionality for the software.
 * eg., The rule
 *       <$abc* b $abc*> == ....   is incorrect due to the presence of
 * two $abc*. The presence of similar regular expressions (Like $abc* in the
 * above example) should be diffentiated.
 * Thus the rule
 *       <$abc*#1 b $abc*#2> == .... is proper. The atoms matched by the
 * first $abc* will be stored under a new name '1' and the atoms matched
 * by the second $abc* will be stored under a new name '2'. To aid the
 * programmer it is proper to intimate to him
 * such error during compiling. This is the main purpose of this class
 * Check.
 */
class Check {

   /**
   * checkTable   : stores all regular expressions appearing in 
   *		    LHS of a rule.
   **/
   public Hashtable checkTable;

   /**
   * Check()    : Constructor
   * checkTablePut(): insert a string into checkTable
   * checkTableGet(): returns the value stored for a name or return null
   **/
   Check() {
        checkTable = new Hashtable();
        }

   public void checkTablePut(String string) {
        checkTable.put(string,(String)"YES");
        }

   public String checkTableGet(String string) {
        return (String)checkTable.get(string);
        }

}
