/* Result.java */

public class Result implements Constants
{
      Buffer broadcastReceiveBuffer;
      Buffer privateReceiveBuffer;
      Buffer privateSendBuffer;

      int    resultStatus;
      int    hostID;
      int    machineID;

      protected int resultID;
      protected char resultName[];

// Constructor of Class Result
Result(){
   resultID = -1;
   broadcastReceiveBuffer = new Buffer();
   privateReceiveBuffer = new Buffer();
   privateSendBuffer = new Buffer();
}

Result( int bufferType ){
   resultID = -1;
   broadcastReceiveBuffer = new Buffer(bufferType);
   privateReceiveBuffer = new Buffer(bufferType);
   privateSendBuffer = new Buffer(bufferType);
}

// Set and Get functions for Class Job
public void SetResultID( int jobID ){ resultID = jobID; }

public void SetResultName( String jobname )
{ 
   int cnt = jobname.length();
   char strtmp[] = jobname.toCharArray();
   resultName = new char[cnt+1];
   for(int i=0; i<cnt; i++)
   {
      resultName[i] = strtmp[i];
   }
   resultName[cnt] = '\0'; 
}

public int GetResultID(){ return resultID; }

public String GetResultName()
{
   String str = new String(resultName); 
   return str; 
}

}

