/* JobManager.java */
import java.io.*;

public class JobManager extends JavaPVM implements Constants 
{
      JobPool jobPool;
      int     runType;
      int     reliability;
      int     nextHostID;
      int     nextMachineID;

      Buffer  broadcastBuffer;
      AgentInfo[]  host = new AgentInfo[MAXHOSTNUMBER];
      int     hostNum;
      String  hostName[] = new String[MAXHOSTNUMBER];
      Result[]   results;
      int     jobinmachine[] = new int[MAXHOSTNUMBER];
      int     resendJobID;
      Machine[] machines;

// Constructor of Class JobManager
JobManager(Job[] job0, int jobnum, Buffer bcbuffer, int runtype, int reliable)
   throws IOException
{
   super(0, null, 0);
   String tmpname;
   String tmp1;
   results = new Result[jobnum];
   jobPool = new JobPool(job0, jobnum);
   broadcastBuffer = bcbuffer;
   int len;
   
// get host names from file "hostname".

   DataInputStream filein = new DataInputStream(new FileInputStream("hostname")); 

   hostNum = 0;
   String line;
   do{
      line = filein.readLine();
      if(line != null)
      {
	 hostName[hostNum] = line;
	 jobinmachine[hostNum] = 0;
	 hostNum++;
      }
   }
   while(line != null);

   filein.close();

   System.out.println("The hostname file includes the following hosts:"); 
   for(int i=0; i<hostNum; i++)
   {
      System.out.println(hostName[i]);
   }
   System.out.println("\n");

   runType = runtype;
   reliability = reliable;
   resendJobID = 0;
   
}

protected void finalize() throws IOException
{
      System.out.println("Information: pvm has halted.");
      pvm_halt();
}

public Result[] Run()
{
   int    mytid;
   int    tids[] = new int[MAXJOBNUMBER];
   int    tid[] = new int[1];
   int    info;
   int    status[] = new int[MAXHOSTNUMBER];
   int    acthostNum, narch, actjobNum, numt;
   int    i, j, k;
   Buffer bufptr;
   int    currentJobID;
   int    currentHostID;
   int    currentMachineID;
   int    nextJobID;
   int    times;
   int    totalJobNum = jobPool.totalJobNum;
   int    stat;
   int    tmpCount;
   int    tmpJobID;
   int    sendJobID;
   int    knext;
   int    tmptimes;
   int    tmpnextJobID;

   machines = new Machine[MAXMACHINENUMBER];

   info = pvm_addhosts(hostName, hostNum, status);

   if(info < 1)
      System.out.println("Warning: No hosts are added");
   else 
   {
      int info1 = info + 1;
      System.out.println(info + " hosts are added");
   }

// How many jobs are spawned on one host simultaneously?
   switch(runType)
   {
      case NICE:
	 times = 1;
	 break;
      case NORMAL:
	 times = 2;
	 break;
      case FAST:
	 times = 3;
	 break;
      default:
	 times = 2;
	 break;
    }

   // spawn jobs
   actjobNum = 0;
   for(j=0; j<times; j++)
   {
      for(i=0; i<hostNum; i++)
      {
         if(actjobNum >= totalJobNum) break;

         System.out.println("JobName = " + jobPool.job[actjobNum].GetJobName());
         System.out.println("hostName = " + hostName[i]);
         numt = pvm_spawn(jobPool.job[actjobNum].GetJobName(),
		       null, PvmTaskHost,
		       hostName[i], 1, tid);
         System.out.println("i = " + i + "  numt = " + numt);
         if(numt == 1)
         {
            machines[i] = new Machine();
	    machines[i].InsertJobID(actjobNum);
	    machines[i].status = SPAWNED;

	    jobinmachine[i]++;
            host[actjobNum] = new AgentInfo();
            host[actjobNum].myTid = tid[0];
            host[actjobNum].hostName = hostName[i];
            host[actjobNum].jobID = actjobNum;
	    jobPool.job[actjobNum].hostID = actjobNum;
	    jobPool.job[actjobNum].machineID = i;
	    tids[actjobNum] = tid[0];
	    actjobNum++;
         }
      }
   }
   nextJobID = actjobNum;

   // Broadcast data if any
 pvm_initsend(PvmDataDefault);

 if(broadcastBuffer != null)
 {
   int signal[] = new int[1];
   signal[0] = 1;
   pvm_pkint(signal, 1, 1);
   PackBuffer(broadcastBuffer);
 }
 else
 {
   int signal[] = new int[1];
   signal[0] = -1;
   pvm_pkint(signal, 1, 1);
 } 
 pvm_mcast(tids, actjobNum, 0);

   // Send private data 
   for(j=0; j<actjobNum; j++)
   {
      pvm_initsend(PvmDataDefault);

      int jtmp[] = new int[1];
      jtmp[0] = j;
      pvm_pkint(jtmp, 1, 1);

      bufptr = jobPool.job[j].privateSendBuffer;

      PackBuffer(bufptr);

      info = pvm_send(host[j].myTid, 1);
      if(info < 0)
      {
	 System.out.println(" Warning: It is fail to send private data to " +
	      host[j].hostName);
      }
      else
      {
	 jobPool.job[j].jobStatus = SENT;
      }

   }

// Receive data from Agents
  while(jobPool.jobNumber > 0)
  {
    int arrived;
    arrived = pvm_nrecv(-1, 2);
    if(arrived > 0)
    {
      int curJobID[] = new int[1];
      pvm_upkint(curJobID, 1, 1);
      currentJobID = curJobID[0];
      currentHostID = jobPool.job[currentJobID].hostID;
      currentMachineID = jobPool.job[currentJobID].machineID;
      System.out.println("Received: JobID = " + currentJobID + "  HostID = "
	   + currentHostID + "  MachineID = " + currentMachineID);
      if(jobPool.job[currentJobID].jobStatus == SENT)
      {
	 results[currentJobID] = new Result();

         bufptr = results[currentJobID].privateReceiveBuffer;

         UnpackBuffer(bufptr);

         machines[currentMachineID].RemoveJobID(currentJobID);

         jobPool.job[currentJobID].jobStatus = FINISHED;
	 jobPool.jobNumber--;

	 if(jobPool.jobNumber > 0)
	 {
	    if(nextJobID < totalJobNum)
	    {
	       tmpnextJobID = nextJobID;
	       while(jobPool.job[nextJobID].jobStatus != INITIAL)
	       {
		  nextJobID++;
		  if(nextJobID >= totalJobNum)
		  {
		     nextJobID = tmpnextJobID;
                     break;
                  }
               }

	       sendJobID = nextJobID;
	       knext = 1;
	       for(i=0; i<nextJobID; i++)
	       {
		  if(jobPool.job[i].jobStatus == INITIAL)
		  {
		     sendJobID = i;
		     knext = 0;
		     break;
                  }
               }
               
               String curJobName = jobPool.job[currentJobID].GetJobName();
	       if(curJobName.compareTo(
                         jobPool.job[sendJobID].GetJobName()) != 0)
	       {
		  pvm_kill(host[currentHostID].myTid);
                  numt = pvm_spawn(jobPool.job[sendJobID].GetJobName(),
		                   null, PvmTaskHost,
		                   host[currentHostID].hostName,
				   1, tid);
                  if(numt == 1)
                  { 
                     host[currentHostID].myTid = tid[0];
                  }
		  else
		  {
		     System.out.println("spawn " 
                          +  jobPool.job[sendJobID].GetJobName()
			  + " on " + host[currentHostID].hostName 
			  + " fails.");
                     break;
                  }
               }
                    
                // send broadcast data if any
                pvm_initsend(PvmDataDefault);

                if(broadcastBuffer != null)
                {
                   int signal[] = new int[1];
                   signal[0] = 1;
                   pvm_pkint(signal, 1, 1);
                   PackBuffer(broadcastBuffer);
                }
                else
                {
                   int signal[] = new int[1];
                   signal[0] = -1;
                   pvm_pkint(signal, 1, 1);
                } 
                info = pvm_send(host[currentHostID].myTid, 0);
                if(info < 0)
                {
	           System.out.println(" Warning: It is fail to send broadcast" 
                     + " data to " + host[currentHostID].hostName);
		   break;
                }

 // send private data
               pvm_initsend(PvmDataDefault);

               int tmpJobID1[] = new int[1];
               tmpJobID1[0] = sendJobID;
               pvm_pkint(tmpJobID1, 1, 1);

	       bufptr = jobPool.job[sendJobID].privateSendBuffer;

               PackBuffer(bufptr);

               info = pvm_send(host[currentHostID].myTid, 1);
               if(info < 0)
               {
	           System.out.println(" Warning: It is fail to send private"  
                     + " data to " + host[currentHostID].hostName);
               }
               else
               {
	          machines[currentMachineID].InsertJobID(sendJobID);
	          machines[currentMachineID].status = SPAWNED;

	          jobPool.job[sendJobID].jobStatus = SENT;
	          jobPool.job[sendJobID].hostID = currentHostID;
	          jobPool.job[sendJobID].machineID = currentMachineID;
	          host[currentHostID].jobID = sendJobID;
		  if(knext == 1)
		     nextJobID++;
               }
            }
	    else
	    {
	       if(Resend(currentMachineID, currentHostID, 
			 currentJobID, INITIAL) == 0)
               {
	          if(jobinmachine[currentMachineID] > 1)
	          {
		     pvm_kill(host[currentHostID].myTid);
		     jobinmachine[currentMachineID]--;
                  }
	          else
	          {
		     if(reliability == HIGH) 
		        Resend(currentMachineID, currentHostID, 
			 currentJobID, SENT);
                  }
	       }
            }
         }
      }
    }
  }

   for(i=0; i<nextHostID; i++)
      pvm_kill(host[i].myTid);

   info = pvm_delhosts(hostName, hostNum, status);

   pvm_exit();

   for(i=0; i<actjobNum; i++)
      jobPool.RemoveJob(i);
      
   return results; 
    
}

protected int Resend(int currentMachineID, int currentHostID,
			int currentJobID, int resendJobStatus)
{
   int    i;
   int    tid[] = new int[1];
   int    numt;
   Buffer bufptr;
   int    info;

      System.out.println("currentMachineID = " + currentMachineID
                       +  " currentHostID = " + currentHostID
                       +  " currentJobID = " + currentJobID
                       +  " resendJobStatus = " + resendJobStatus);

// find the job to be sent
   for(i=0; i<jobPool.totalJobNum; i++)
   {
       resendJobID = resendJobID%jobPool.totalJobNum;
       if(jobPool.job[resendJobID].jobStatus == resendJobStatus)
       {
          String curJobName = jobPool.job[currentJobID].GetJobName();
	  if(curJobName.compareTo(
                         jobPool.job[resendJobID].GetJobName()) != 0)
	  {
	     pvm_kill(host[currentHostID].myTid);
             numt = pvm_spawn(jobPool.job[resendJobID].GetJobName(),
	                 null, PvmTaskHost,
	                 host[currentHostID].hostName,
		         1, tid);
             if(numt == 1)
             { 
                host[currentHostID].myTid = tid[0];
             }
	     else
	     {
	        System.out.println("spawn "
                     + jobPool.job[resendJobID].GetJobName()
		     + " on " + host[currentHostID].hostName 
		     + " fails.");
                break;
             }
          }
	  
         // send broadcast data if any
         pvm_initsend(PvmDataDefault);

         if(broadcastBuffer != null)
         {
            int signal[] = new int[1];
            signal[0] = 1;
            pvm_pkint(signal, 1, 1);
            PackBuffer(broadcastBuffer);
         }
         else
         {
            int signal[] = new int[1];
            signal[0] = -1;
            pvm_pkint(signal, 1, 1);
         } 
         info = pvm_send(host[currentHostID].myTid, 0);
         if(info < 0)
         {
	    System.out.println(" Warning: It is fail to send broadcast data to "
	         + host[currentHostID].hostName);
	    break;
         }

 // send private data
          pvm_initsend(PvmDataDefault);

          int tmpJobID[] = new int[1];
          tmpJobID[0] = resendJobID;
          pvm_pkint(tmpJobID, 1, 1);

	  bufptr = jobPool.job[resendJobID].privateSendBuffer;

          PackBuffer(bufptr);

          info = pvm_send(host[currentHostID].myTid, 1);
          if(info < 0)
          {
	     System.out.println(" Warning: It is fail to send private data to "
	          + host[currentHostID].hostName);
          }
          else
          {
	     machines[currentMachineID].InsertJobID(resendJobID);
	     machines[currentMachineID].status = SPAWNED;

	     jobPool.job[resendJobID].hostID = currentHostID;
	     jobPool.job[resendJobID].machineID = currentMachineID;
	     host[currentHostID].jobID = resendJobID;
	     resendJobID++;
          }
          return 1;
       }
       resendJobID++;
    }
    return 0;
}
   
public void PackBuffer(Buffer bufptr)
{

   int i;

   int inttmp[] = new int[1];
   inttmp[0] = bufptr.intcnt;
   pvm_pkint(inttmp, 1, 1);
   if(bufptr.intcnt != 0)
      for(i=0; i<bufptr.intcnt; i++)
      {
         int numtmp[] = new int[1];
         numtmp[0] = bufptr.intnum[i];
         pvm_pkint(numtmp, 1, 1);
	 pvm_pkint(bufptr.intptr[i], bufptr.intnum[i], 1);
      }

   int flttmp[] = new int[1];
   flttmp[0] = bufptr.floatcnt;
   pvm_pkint(flttmp, 1, 1);
   if(bufptr.floatcnt != 0)
      for(i=0; i<bufptr.floatcnt; i++)
      {
         int numtmp[] = new int[1];
         numtmp[0] = bufptr.floatnum[i];
         pvm_pkint(numtmp, 1, 1);
	 pvm_pkfloat(bufptr.floatptr[i], bufptr.floatnum[i], 1);
      }
   int strtmp[] = new int[1];
   strtmp[0] = bufptr.strcnt;
   pvm_pkint(strtmp, 1, 1);
   if(bufptr.strcnt != 0)
      for(i=0; i<bufptr.strcnt; i++)
      {
         pvm_pkstr(bufptr.strptr[i]);
      }
}

// Utility Function
public void UnpackBuffer(Buffer bufptr)
{
   int i;

   int inttmp[] = new int[1];
   pvm_upkint(inttmp, 1, 1);
   bufptr.intcnt = inttmp[0];
   if(bufptr.intcnt != 0)
       for(i=0; i<bufptr.intcnt; i++)
       {
          int numtmp[] = new int[1];
          pvm_upkint(numtmp, 1, 1);
          bufptr.intnum[i] = numtmp[0];
          bufptr.intptr[i] = new int[bufptr.intnum[i]];
	  pvm_upkint(bufptr.intptr[i], bufptr.intnum[i], 1);
       }

   int flttmp[] = new int[1];
   pvm_upkint(flttmp, 1, 1);
   bufptr.floatcnt = flttmp[0];
   if(bufptr.floatcnt != 0)
      for(i=0; i<bufptr.floatcnt; i++)
      {
          int numtmp[] = new int[1];
          pvm_upkint(numtmp, 1, 1);
          bufptr.floatnum[i] = numtmp[0];
          bufptr.floatptr[i] = new float[bufptr.floatnum[i]];
          pvm_upkfloat(bufptr.floatptr[i], bufptr.floatnum[i], 1);
      }

   int strtmp[] = new int[1];
   pvm_upkint(strtmp, 1, 1);
   bufptr.strcnt = strtmp[0];
   if(bufptr.strcnt != 0)
      for(i=0; i<bufptr.strcnt; i++)
      {
         char chartmp[] = new char[MAXSTRLENGTH];
         pvm_upkstr(chartmp);
         bufptr.strptr[i] = new String(chartmp);
      }
}

}
