/* Job.java */

public class Job implements Constants
{
      Buffer broadcastReceiveBuffer;
      Buffer privateReceiveBuffer;
      Buffer privateSendBuffer;

      int    jobStatus;
      int    hostID;
      int    machineID;

      protected int jobID;
      protected char jobName[];

// Constructor of Class Job
Job(){
   jobID = -1;
   broadcastReceiveBuffer = new Buffer();
   privateReceiveBuffer = new Buffer();
   privateSendBuffer = new Buffer();
}

Job( int bufferType ){
   jobID = -1;
   broadcastReceiveBuffer = new Buffer(bufferType);
   privateReceiveBuffer = new Buffer(bufferType);
   privateSendBuffer = new Buffer(bufferType);
}

// Set and Get functions for Class Job
public void SetJobID( int jobid ){ jobID = jobid; }

public void SetJobName( String jobname )
{ 
   int cnt = jobname.length();
   char strtmp[] = jobname.toCharArray();
   jobName = new char[cnt+1];
   for(int i=0; i<cnt; i++)
   {
      jobName[i] = strtmp[i];
   }
   jobName[cnt] = '\0'; 
}

public int GetJobID(){ return jobID; }

public String GetJobName()
{
   String str = new String(jobName); 
   return str; 
}

}

