//list.h
#ifndef LIST_H
#define LIST_H

#include <stdio.h>
#include <malloc.h>
#include <assert.h>

template<class T> class List;
template<class T> class ListIterator;


template<class T>
class ListNode {
  friend class List<T>;
  friend class ListIterator<T>;
 public:
  ListNode( T &);
  virtual ~ListNode(void) {}
 private:
  T data;
  ListNode *nextPtr;
  ListNode *prevPtr;
  T & getData();
  void setData( T &);
  int operator==( ListNode<T> &) ;
  virtual void Print(void) {}
};

template<class T>
class List {
  friend class ListIterator<T>;

  public:
    List();
    List( List<T> &value) { operator=(value); }
    virtual ~List();
    void Delete(void);
    void InsertAtFront( T &);
    void InsertAtBack( T &);
    int  InsertAtFrontDistinct( T &);
    int  InsertAtBackDistinct( T &);
    int  RemoveFromFront(T &);
    int  RemoveFromBack(T &);
    void Append( List<T> &);
    void AppendDistinct( List<T> &);
    int  isEmpty();
    int  operator==( List<T> &) ;
    int  operator!=( List<T> &) ;
    int  operator<=( List<T> &) ;
    int  contains( ListNode<T> &) ;
    int  count(void) ;
    List<T> & operator=( List<T> &);
    virtual void Print(void);
  private:
    int NodeCount;
    ListNode<T> *firstPtr;
    ListNode<T> *lastPtr;
    ListNode<T> *getNewNode( T &);
};

template<class T>
class ListIterator {
  private:
    List<T>     *ListPtr;
    ListNode<T> *NodePtr;
  public:     
    ListIterator();
    ListIterator(List<T> *ListPtr);
    ListIterator( ListIterator<T> &);
    virtual ~ListIterator() {}
    ListIterator<T> & operator= ( ListIterator<T> &RHS);
    int operator == ( ListIterator<T> &RHS) ;
    int operator != ( ListIterator<T> &RHS) ;
    int Next(void);
    int Prev(void);
    int getData(T &);
    int setData(T &);
    int Remove(void);
    int Remove(T &);
    int InsertAfter( T &);
    int InsertBefore( T &);
    int First(void);
    int Last(void);
    int Valid(void) { return NodePtr==NULL ? 0 : 1; }
};

#endif


