// Sample application main program

// This program adds the numbers from 1 to n by partitioning this range into
// groups of size DATANUMBER, each of which is packaged as a separate job to
// be independently calculated.

import java.io.*;

public class UserMain implements Constants
{
   public static void main(String[] args)
   {
      int lastNumber;
      int jobNumber;
      int sum;
      int countOfJobNumber;

      int startNumber[] = new int[1];
      int dataNumber[] = new int[1];

      int DATANUMBER = 10;  // size of datagroups

      try
      {
	 DataInputStream in = new DataInputStream(System.in);   
         System.out.println("Calculate: 1+2+3+ ... +N = ?");
         System.out.println("Please input N");
	 String str = in.readLine();
	 Integer integer = new Integer(str);
	 lastNumber = integer.intValue();

// How many jobs? 
         jobNumber = lastNumber/DATANUMBER;
         Job jobs[] = new Job[jobNumber+1];

// Pack startNumber and dataNumber into job buffers.
         startNumber[0] = 1;
         dataNumber[0] = DATANUMBER;
         for(countOfJobNumber=0; countOfJobNumber<jobNumber; countOfJobNumber++)
         {
            jobs[countOfJobNumber] = new Job();
            jobs[countOfJobNumber].SetJobName("workerDriver");
            jobs[countOfJobNumber].privateSendBuffer.PackInt(startNumber, 1);
            jobs[countOfJobNumber].privateSendBuffer.PackInt(dataNumber, 1);
            startNumber[0] += DATANUMBER;
         }

// If the data number in the last job is less than DATANUMBER, pack the
// startNumber and dataNumber here.
         if(startNumber[0] <= lastNumber || lastNumber == 1)
         {
            jobs[jobNumber] = new Job();
            dataNumber[0]=lastNumber - startNumber[0] + 1;
            jobs[jobNumber].SetJobName("workerDriver");
            jobs[jobNumber].privateSendBuffer.PackInt(startNumber, 1);
            jobs[jobNumber].privateSendBuffer.PackInt(dataNumber, 1);
            jobNumber++;
         }
     
// Create jobManager.
         JobManager jobManager = new JobManager(
            jobs, // array of work
            jobNumber, // length of work array
            null, // we aren't using a broadcast buffer
            NICE, // only one agent on a machine
            LOW  // re-send outstanding work to machines that finish
            );

// Run jobManager and get results. 
         Result results[] = new Result[jobNumber];
         results = jobManager.Run();

// Add all partial sums to get the total sum. 
         sum = 0;
         for(countOfJobNumber=0; countOfJobNumber<jobNumber; countOfJobNumber++)
         {
           int partialSum[] = new int[1];
           results[countOfJobNumber].privateReceiveBuffer.UnpackInt(partialSum, 1);
           sum += partialSum[0];
         }

// Print out the sum.
         System.out.println(" Sum = "  + sum);
      }

      catch(IOException e)
      {
	 System.err.println(e.getMessage());
      }
      
   }
}
