// Sample application main program

// This program adds the numbers from 1 to n by partitioning this range into
// groups of size DATANUMBER, each of which is packaged as a separate job to
// be independently calculated.

#include <iostream.h>
#include "jobpool.h"

#define DATANUMBER 10    // size of data groups

main()
{
   Job *jobs;
   Result *results;
   int startNumber, dataNumber;
   int lastNumber;
   JobNumber jobNumber;
   CheckTime checkTime; // how many seconds between checking liveness of workers
   int partialSum, sum;
   int countOfJobNumber;

   cout << "Calculate: 1+2+3+ ... +N = ?" << endl;
   cout << "Please input N" << endl;
   cin >> lastNumber ; 

// How many jobs? 
   jobNumber = lastNumber/DATANUMBER;
   jobs = new Job[jobNumber+1];

// Pack startNumber and dataNumber into job buffers.
   startNumber = 1;
   dataNumber = DATANUMBER;
   for(countOfJobNumber=0; countOfJobNumber<jobNumber; countOfJobNumber++)
   {
      jobs[countOfJobNumber].SetJobName("worker");
      jobs[countOfJobNumber].privateSendBuffer->PackInt(&startNumber, 1);
      jobs[countOfJobNumber].privateSendBuffer->PackInt(&dataNumber, 1);
      startNumber += DATANUMBER;
   }

// If the data number in the last job is less than DATANUMBER, pack the
// startNumber and dataNumber here.
   if(startNumber <= lastNumber || lastNumber == 1)
   {
      dataNumber=lastNumber - startNumber + 1;
      jobs[jobNumber].SetJobName("worker");
      jobs[jobNumber].privateSendBuffer->PackInt(&startNumber, 1);
      jobs[jobNumber].privateSendBuffer->PackInt(&dataNumber, 1);
      jobNumber++;
   }
     
// How frequently we check if machines are still alive (in seconds)
   checkTime = 1;

// Create jobManager.
   static JobManager jobManager(
      jobs, // array of work
      jobNumber, // length of work array
      NULL, // we aren't using a broadcast buffer
      NICE, // only one agent on a machine
      HIGH, // re-send outstanding work to machines that finish
      AUTOSTART, // start PVM if it is not already running
      checkTime // how often to check if machines are still running
   );

// Run jobManager and get results. 
   results = jobManager.Run();

// Add all partial sums to get the total sum. 
   sum = 0;
   for(countOfJobNumber=0; countOfJobNumber<jobNumber; countOfJobNumber++)
   {
      results[countOfJobNumber].privateReceiveBuffer->UnpackInt(&partialSum, 1);
      sum += partialSum;
   }

// Print out the sum.
   cout << endl;
   cout << " Sum = " << sum << endl;

   return 0;
}
