/* Job Manager Program */

#include <stdio.h>
#include <string.h>
#include "jobpool_c.h"
#include "cfortran.h"

void cjmgr(char *name, int *number, int *intbuf, int *intpt, float *fltbuf,
	     int *fltpt)
{
   static JobManager *jobManagerptr;
   Job *job;
   Result *result;
   Buffer *bcBuffer;
   int n, i, k, num;
   int    jobnum, intnum, fltnum;

   bcBuffer = (Buffer *)malloc(sizeof(Buffer));
   InitBuffer(bcBuffer, OUTOF_PLACE);

   PackInt(bcBuffer, &intpt[0], 1);
   PackInt(bcBuffer, &fltpt[0], 1);

   if(intpt[0] != 0)
      PackInt(bcBuffer, &intbuf[0], intpt[0]);

   if(fltpt[0] != 0)
      PackFloat(bcBuffer, &fltbuf[0], fltpt[0]);

   n = *number;

   job = (Job *)malloc(sizeof(Job)*n);

   for(i=0; i<n; i++)
      InitJob(&(job[i]), OUTOF_PLACE);
   
   result = (Result *)malloc(sizeof(Result)*n);

   for(i=0; i<n; i++)
      InitResult(&(result[i]), OUTOF_PLACE);
   
   for(i=0; i<n; i++)
   {
      if(intpt[i+1] != 0)
         intnum = intpt[i+1] - intpt[i];
      else
	 intnum = 0;

      if(fltpt[i+1] != 0)
         fltnum = fltpt[i+1] - fltpt[i];
      else
	 fltnum = 0;

      SetJobName(&(job[i]), name);
      jobnum = i;
      PackInt(job[i].privateSendBuffer, &jobnum, 1);
      PackInt(job[i].privateSendBuffer, &intnum, 1);
      PackInt(job[i].privateSendBuffer, &fltnum, 1);
      if(intpt[i+1] != 0)
      {
         PackInt(job[i].privateSendBuffer, &intbuf[intpt[i]], intnum);
      }
      if(fltpt[i+1] != 0)
      {
         PackFloat(job[i].privateSendBuffer, &fltbuf[fltpt[i]], fltnum);
      }
   }

   jobManagerptr = (JobManager *)malloc(sizeof(JobManager));

   InitJobManager(jobManagerptr, job, n, bcBuffer, NICE, HIGH, AUTOSTART, 5);

   result = RunJobManager(jobManagerptr); 

   intpt[0] = 0;  
   fltpt[0] = 0;  

   for(i=0; i<n; i++)
   {
      UnpackInt(result[i].privateReceiveBuffer, &intnum, 1);
      UnpackInt(result[i].privateReceiveBuffer, &fltnum, 1);
      if(intnum != 0)
      {
	 intpt[i+1] = intpt[i] + intnum;
         UnpackInt(result[i].privateReceiveBuffer, &intbuf[intpt[i]], intnum);
      }
      if(fltnum != 0)
      {
	 fltpt[i+1] = fltpt[i] + fltnum;
         UnpackFloat(result[i].privateReceiveBuffer, &fltbuf[fltpt[i]], fltnum);
      }
   }
/*   EndJobManager(jobManagerptr); */ 
}
FCALLSCSUB6(cjmgr,CJMGR,cjmgr,PSTRING,PINT,INTV,INTV,FLOATV,INTV)

