/* worker Program */
#include <stdlib.h>
#include <stdio.h>
#include "jobpool_c.h"
#include "cfortran.h"

#define MAXDAT 100
#define MAXIND 100

#define FWORKER(FJOBNUM,INTBUF,INTPT,FLTBUF,FLTPT)   CCALLSFSUB5(FWORKER,fworker,INT,INTV,INTV,FLOATV,INTV,FJOBNUM,INTBUF,INTPT,FLTBUF,FLTPT)

Result* worker(Job *);

main()
{
   JobAgent jobAgent;

   InitJobAgent(&jobAgent);

   RunJobAgent(&jobAgent, worker);

}

Result* worker(Job *job)
{
   FILE *fp;
   int   intbuf[MAXDAT];
   float fltbuf[MAXDAT];
   int   intpt[MAXIND], fltpt[MAXIND];
   int   fjobnum;
   int   jobnum, intnum, fltnum;
   int   i;
   Result *result;

   result = (Result *) malloc(sizeof(Result));

   InitResult(result, OUTOF_PLACE);

   for(i=0; i<MAXDAT; i++)
   {
      intbuf[i] = 0;
      fltbuf[i] = 0;
   }

   for(i=0; i<MAXIND; i++)
   {
      intpt[i] = 0;
      fltpt[i] = 0;
   }

   UnpackInt(job->broadcastReceiveBuffer, &intpt[0], 1);
   UnpackInt(job->broadcastReceiveBuffer, &fltpt[0], 1);

   if(intpt[0] != 0)
      UnpackInt(job->broadcastReceiveBuffer, &intbuf[0], intpt[0]);

   if(fltpt[0] != 0)
      UnpackFloat(job->broadcastReceiveBuffer, &fltbuf[0], fltpt[0]);

   fp = fopen("www", "w");

   UnpackInt(job->privateReceiveBuffer, &jobnum, 1);
   UnpackInt(job->privateReceiveBuffer, &intnum, 1);
   UnpackInt(job->privateReceiveBuffer, &fltnum, 1);
   fprintf(fp, "New: %d %d %d \n", jobnum, intnum, fltnum);
   fjobnum = jobnum + 1;
   intpt[1] = intpt[0] + intnum;
   fltpt[1] = fltpt[0] + fltnum;

   if(intnum != 0)
      UnpackInt(job->privateReceiveBuffer, &intbuf[intpt[0]], intnum);

   if(fltnum != 0)
      UnpackFloat(job->privateReceiveBuffer, &fltbuf[fltpt[0]], fltnum);

   fprintf(fp, "New1: %d %d %d \n", intbuf[0],intbuf[1],intpt[1]);
   fclose(fp);

   FWORKER(fjobnum,intbuf,intpt,fltbuf,fltpt); 

   fp = fopen("ww", "w");
   fprintf(fp, "New2: %d %d %d \n", intbuf[0],intbuf[1],intpt[1]);
   fclose(fp);
   PackInt(result->privateSendBuffer, &intpt[0], 1);
   PackInt(result->privateSendBuffer, &fltpt[0], 1);
   if(intpt[0] != 0)
   {
      PackInt(result->privateSendBuffer, &intbuf[0], intpt[0]);
   }
   if(fltpt[0] != 0)
   {
      PackFloat(result->privateSendBuffer, &fltbuf[0], fltpt[0]);
   }

   return result;
}
