//package DatabaseExplorer;

import java.util.*;
import java.sql.*;
import java.rmi.*;

public interface DBAccessInterface extends java.rmi.Remote
{
// DatabaseAccess interface
	public String getErrorMsg(int sID) throws RemoteException;  //sID is Session ID
	public int getLoginProps(int sID) throws RemoteException;
	public int getDBMSInfo(int sID) throws RemoteException;
	public int getDriverInfo(int sID) throws RemoteException;
	public int getSQLInfo(int sID) throws RemoteException;
	public Vector getCatalog(int sID) throws RemoteException;
	public Vector getSchema(int sID) throws RemoteException;
	public Vector getTables(String catalog, String schema, String[] tabletypes, int sID)
		throws RemoteException;
	public String[] getTableTypes(int sID) throws RemoteException;
	public int openSession(String url, String user, String passwd) throws RemoteException;
	public int[] exeSQLstatement(String sql, int sID) throws RemoteException;
	public int selectAll(String tablename, int sID) throws RemoteException;
	public void closeTable(int tID) throws RemoteException;
	public void closeSession(int sID) throws RemoteException;
	public void setCommit(int sID) throws RemoteException;
	public void setRollback (int sID) throws RemoteException;
// DataTable interface
	public String getTableError(int tID) throws RemoteException;  //tID is table ID
	public String getColumnTitle(int index, int tID) throws RemoteException;
	public String[] getColumnTitles(int tID) throws RemoteException;
	public int getColumnType(int index, int tID) throws RemoteException;
	public int getNumOfColumns(int tID) throws RemoteException;
	public int getNumOfRows(int tID) throws RemoteException;
	public Vector getRow(int index, int tID) throws RemoteException;
	public Object[] getColumn(int index, int tID) throws RemoteException;
	public Object getDataAt(int row, int column, int tID) throws RemoteException;
	
} //DBAccessInterface
