//package DatabaseExplorer;

import java.util.*;
import java.sql.*;
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;

public class DBAccess extends UnicastRemoteObject 
	implements DBAccessInterface
{
	public int maxSessions = 50;
	public int maxTables = 200;

	private DatabaseAccess[] sessions = new DatabaseAccess[maxSessions];
	private DataTable[] datatables = new DataTable[maxTables];
	private Stack sessions_stack = new Stack();
	private Stack datatables_stack = new Stack();
// Constructor.
   public DBAccess() throws RemoteException
   {
	for(int i=0; i<sessions.length; i++)
	{
	    sessions_stack.push(new Integer(i));
	} //for
	for(int j=0; j< datatables.length; j++)
	{
	    datatables_stack.push(new Integer(j));
	} //for
   }// DBAccess

// This method print message or information.
   public static void printMsg(String message)
   {
	System.out.println(message);
   } //printMsg

/************************************************************/
/* The following method related to DatabaseAccess interface */
/************************************************************/
// This method returns any error message.
   public String getErrorMsg(int sID) throws RemoteException
   {
	return sessions[sID].getErrorMessage();
   } // getErrorMeg
	
// This method returns the login properties.
   public int getLoginProps(int sID) throws RemoteException
   {
	int tID = -1;
	if(!datatables_stack.empty())
	{
	   tID = ((Integer)(datatables_stack.pop())).intValue();
	   datatables[tID] = sessions[sID].getLoginProperties();
	} //if
	return tID;
   } //getLoginProps

// This method gets the database information.
   public int getDBMSInfo( int sID) throws RemoteException
   {
	int tID = -1;
        if(! datatables_stack.empty())
	{
	    tID = ((Integer)(datatables_stack.pop())).intValue();
	    datatables[tID] = sessions[sID].getRDBMSinfo();
	} //if
	return tID;
   } // getDBMSInfo

// This method returns the Drivers information.
   public int getDriverInfo(int sID)
   {
	int tID = -1;
	if(! datatables_stack.empty())
	{
	    tID = ((Integer)(datatables_stack.pop())).intValue();
	    datatables[tID] = sessions[sID].getDriverInfo();
	} // if
	return tID;
   } // getDriverInfo

// This method gets the SQL level information.
   public int getSQLInfo(int sID) throws RemoteException
   {
	int tID = -1;
        if(! datatables_stack.empty())
        {
            tID = ((Integer)(datatables_stack.pop())).intValue();
            datatables[tID] = sessions[sID].getSQLLevelInfo();
        } //if
        return tID;
   } //getSQLInfo

// This method returns the catalog names in the database.
   public Vector getCatalog(int sID) throws RemoteException
   {
	return sessions[sID].getCatalogNames();
   } //getCatalog

// This method returns the schema names in the database.
   public Vector getSchema(int sID) throws RemoteException
   {
	return sessions[sID].getSchemaNames();
   } // getSchema

// This method returns a list of tables in a specificcatalog and
// schema.
   public Vector getTables(String catalog, String schema, String[] tabletypes,
	int sID) throws RemoteException
   {
	return sessions[sID].getTableNames(catalog, schema, tabletypes);
   } // getTables

// This methods gets all the table types accepted in the database.
   public String[] getTableTypes(int sID) throws RemoteException
   {
	return sessions[sID].getTableTypes();
   } //getTableTypes

// This method creates a connection to the database.
   public int openSession(String url, String user, String passwd)
   {
	int sID = -1;
        int val = -1;
	if(!sessions_stack.empty())
        {
	   sID = ((Integer)(sessions_stack.pop())).intValue();
	   sessions[sID] = new DatabaseAccess();
	   val = sessions[sID].openSession(url,user,passwd);
	   if (val == (-1)){
		sessions_stack.push(new Integer(sID));
		return -2;  // -2 means the openSession failed 
	   }
        } //if
	return sID;
   } // openSession

// This method is used to exxcute SQL statement.
   public int[] exeSQLstatement(String sql, int sID) throws RemoteException
   {
	DataTable[] temp = sessions[sID].exeSQLstatement(sql);
	int[] tIDs = new int[temp.length];
	System.out.println("The temp length is " + temp.length);
	int tID;

	for(int i = 0; i<temp.length; i++)
	{
	   tID = -1;
	   if(! datatables_stack.empty())
	   {
	       	tID = ((Integer)(datatables_stack.pop())).intValue();
	 	tIDs[i] = tID;
	       	datatables[tID] = temp[i];
	   } //if
	} //for
		
	return tIDs;
   } //exeSQLstatement

// This method returns all the data values in a table.
   public int selectAll(String tablename, int sID) throws RemoteException
   {
	int tID = -1;
	if(! datatables_stack.empty())
	{
	    tID = ((Integer)(datatables_stack.pop())).intValue();
	    datatables[tID] = sessions[sID].selectall(tablename);
	} // if
	return tID;
   } //selectAll

// This method is used to close the table already opened.
   public void closeTable(int tID) throws RemoteException
   {
	datatables[tID] = null;
	datatables_stack.push(new Integer(tID));
   } // closeTable

// This method is used to close the connection to the remote database.
   public void closeSession(int sID) throws RemoteException
   {
	sessions[sID].closeSession();
	sessions_stack.push(new Integer(sID));
   } //closeSession

// This method is used to commit the change to the database.
   public void setCommit(int sID) throws RemoteException
   {
	sessions[sID].setCommit();
   } //setCommit

// This method is used to rollback the change to the database.
   public void setRollback(int sID) throws RemoteException
   {
        sessions[sID].setRollback();
   } //setRollback

/********************************************************/
/* The following methods related to DataTable interface */
/********************************************************/
// This method is used to return error message in the DataTable.
   public String getTableError(int tID) throws RemoteException
   {
	return datatables[tID].getDataTableError();
   } // getTableError    

// This method returns the title of the specified column in a table.
   public String getColumnTitle(int index, int tID) throws RemoteException
   {
	return datatables[tID].getColumnTitle(index);
   } //getColumnTitle

// This method returns titles of all the columns in a table.
   public String[] getColumnTitles(int tID) throws RemoteException
   {
	return datatables[tID].getColumnTitles();
   } //getColumnTitles
   
// This method returns the data type of specified column.
   public int getColumnType(int index, int tID) throws RemoteException
   {
	return datatables[tID].getColumnType(index);
   } // getColumnType

// This method returns the number of column in the specified table.
   public int getNumOfColumns(int tID) throws RemoteException
   {
	return datatables[tID].getNumOfColumns();
   } //getNumOfColumns

// This method returns the number of rows in the specified table.
   public int getNumOfRows(int tID) throws RemoteException
   {
	return datatables[tID].getNumOfRows();
   } //getNumOfRows

// This method returns a row in a table.
   public Vector getRow(int index, int tID) throws RemoteException
   {
	return datatables[tID].getRow(index);
   } //getRow

// This method returns a column in a table.
   public Object[] getColumn(int index, int tID) throws RemoteException
   {
	return datatables[tID].getColumn(index);
   } //getColumn

// This method is used to get an individual data cell in a table.
   public Object getDataAt(int row, int column, int tID) throws RemoteException
   {
	return datatables[tID].getDataAt(row,column);
   } // getDataAt
} //DBAccess
