  using System;
  using System.Security.Cryptography;
  using System.Text;
  using System.Xml;

public class AuthenticationUtility : System.Web.UI.UserControl
{
	private const String XML_NODE_LIST 	= "configuration/system.web/authentication/forms";
	private const String CONFIG_FILE	= "E:\\inetpub\\wwwroot\\authentication\\Web.Config";

	private byte[] getMD5Hash(byte[] data)
	{
		MD5 md5Package 	= new MD5CryptoServiceProvider();
		byte[] md5Hash 	= new byte[50];
		md5Hash 		= md5Package.ComputeHash(data);
		return md5Hash;
	}

	private String getPasswordHashString(String password)
	{
		ASCIIEncoding textConverter = new ASCIIEncoding();
		Encoding ascii 	= Encoding.ASCII;
		byte[] pwdArr 	= new byte[7];
		pwdArr 	     	= textConverter.GetBytes(password);
		byte[] pwdHash     	= new byte[50];
		pwdHash		= getMD5Hash(pwdArr);
		String pwdHashStr	= new String(ascii.GetChars(pwdHash));
		return pwdHashStr;
	}

	public void addUserToFile(String newUser, String password)
	{
		String pwdHashStr = getPasswordHashString(password);
	 	XmlDocument doc = new XmlDocument();
	 	doc.Load(CONFIG_FILE);
	 	XmlNodeList nodeList = doc.SelectSingleNode(XML_NODE_LIST).ChildNodes;
	  	foreach(XmlNode node in nodeList)
                	 	{
 	  		XmlElement element = doc.CreateElement("user");
	  		XmlAttribute nameAttr      = element.SetAttributeNode("name", "");
                    		nameAttr.Value                         =  newUser;
                   		XmlAttribute pwdAttr       = element.SetAttributeNode("password", "");
                    		pwdAttr.Value	    = pwdHashStr;
 	  		XmlNode root = doc.DocumentElement;
                    		node.InsertAfter(element, node.FirstChild);
                    		doc.Save(CONFIG_FILE);  
		}
	}

	private void removeUserFromFile(String user)
	{
	 	XmlDocument doc = new XmlDocument();
		doc.Load(CONFIG_FILE);
		XmlNode root = doc.DocumentElement;
		XmlNode credentialsNode = doc.SelectSingleNode(XML_NODE_LIST+ "/credentials");
	 	XmlNodeList nodeList       = credentialsNode.ChildNodes;
			Console.WriteLine(credentialsNode.Name);
		foreach(XmlNode node in nodeList)
                	 	{
			Console.WriteLine(node.Attributes[0].Value);
			if (node.Attributes[0].Value.Equals(user))
			{
				Console.WriteLine(node.Name);
				Console.WriteLine("val="+node.Attributes[0].Value);
				credentialsNode.RemoveChild(node);
			}
                    		doc.Save( CONFIG_FILE);  
		}
	
	}

	public bool verifyUser(String username, String password)
	{
  		String storedPwd = "";
		XmlDocument doc = new XmlDocument();
		doc.Load(CONFIG_FILE);
	  	XmlNodeList nodeList = doc.SelectSingleNode( XML_NODE_LIST + "/credentials").ChildNodes;
		 foreach(XmlNode node in nodeList)
	                	{
			Console.WriteLine(node.Attributes[0].Value);
			if (node.Attributes[0].Value.Equals(username))
			{
				storedPwd = node.Attributes[1].Value;	
				break;
			}
		}
		if (getPasswordHashString(password).Equals(storedPwd))
		{
			Console.Write("equals");
			return true;
		}
		else
		{
			Console.Write("NOT equals");
			return false;
		}
	}

	public static void Main(String[] args){}
}
