 <%@ WebService Language="C#" Class="service" Debug="true" %>
//this bins and is used 2 serialize an object and deserialize it
//saves full state

using System;
using System.IO;
using System.Reflection;
using System.Collections;
using System.Text.RegularExpressions;
using System.Web.Services;
using System.Runtime.Serialization;
using System.Xml.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Collections;
using System.Data;
using System.Data.OleDb;

using System.Reflection;

public class Constants
{
	public const String GENERATE_PROBLEM = "generateProblem";
	public const int INVALID_PROBLEM_NO = -1;
	public const int INITIAL_PROBLEMS = 10;
	public const int INITIAL_LOAD     = 0;

	public const int START_PROB     = 0;
	public const int NO_OF_PROBS    = 1;

	public const String TABLE_NAME = "CustomerDLLs";
	
	public const String FINISHED_WORK_DIR = "e:\\inetpub\\wwwroot\\CSAHWS\\work\\finished\\";
	public const String UNFINISHED_WORK_DIR = "e:\\inetpub\\wwwroot\\CSAHWS\\work\\unfinished\\";
	public const String UPLOADED_WORK_DIR = "e:\\inetpub\\wwwroot\\CSAHWS\\work\\uploaded\\";
	public const String SERVICE_BIN_DIR = "e:\\inetpub\\wwwroot\\CSAHWebService\\bin\\";
	public const String CUSTOMER_BIN_DIR = "e:\\Inetpub\\wwwroot\\authentication\\bin\\";

	public const String CLIENT_UPLOAD_URL = "http://206.240.24.73/CSAHWS/work/unfinished/";

	public const String STATUS_FINISHED = "Finished.";
	public const String STATUS_IN_PROGRESS = "Not Finished, in progress.";
	public const String STATUS_NOT_STARTED = "Not started processing.";
	public const String STATUS_DLLFILE_NOT_FOUND = "Error, DLL not found.";
	public const String STATUS_STATUSFILE_NOT_FOUND = "Problem finished but Status file not found.";

	public const String ERROR_TIMEOBJECT_NULL = "DLLTimeObject is null";
	public const String ERROR_TIMEOBJECT_LOAD = "DLLTimeObject not successfully loaded in scheduler";

	public const String ERROR_SCHEDULER_SELECT_DLL = "GetSelectedDLL() method failed in scheduler";

	public const String ERROR_IN_SERVER = "Error in Server.";
	public const String SERVER_WORK_DONE = "You have finished work.";
}

public class service: WebService
{

	public service()
	{}

	public DatabaseManager getDatabaseManager()
	{
		return Scheduler.getSchedulerInstance().getDatabaseManager();
	}
	
	[WebMethod]
	public DataSet listDLLs(String customerName)
	{	
		String SQLStatement = "select * from "+Constants.TABLE_NAME+" where username = '"+customerName+"'";
		DataSet objDataSet = getDatabaseManager().executeSQL(SQLStatement);
		return objDataSet;
	}

	
	[WebMethod]
	public bool RemoveDLLFile(String DLLName, String customerName)
	{
		Application.Lock();
		bool returnBool = false;
		try {
			File.Delete(Constants.UNFINISHED_WORK_DIR + DLLName);
			File.Delete(Constants.FINISHED_WORK_DIR + DLLName);

			String statusFileName = Regex.Replace(DLLName, ".dll", ".status");
			File.Delete(Constants.UNFINISHED_WORK_DIR + statusFileName);
			File.Delete(Constants.FINISHED_WORK_DIR + statusFileName);
			File.Delete(Constants.SERVICE_BIN_DIR + DLLName);
			File.Delete(Constants.CUSTOMER_BIN_DIR + DLLName);
			returnBool = getDatabaseManager().executeDeleteQuery(DLLName, customerName);
		}
		catch (Exception e)
		{
			//return e.ToString()+Constants.UNFINISHED_WORK_DIR + DLLName;
			logTimeStamp("RemoveDLLFile exception : " + e.ToString());
		}
		Application.UnLock();
		return returnBool;
	}

	private MemoryStream ConvertFileStreamToMemoryStream(FileStream fileStream)
	{
		BinaryFormatter formatter = new BinaryFormatter();
		Object objectFromFileStream = (Object)formatter.Deserialize(fileStream);
		MemoryStream memoryStream = new MemoryStream();
		formatter = new BinaryFormatter();
		formatter.Serialize(memoryStream, objectFromFileStream);
		return memoryStream;
	}
	

	[WebMethod]
	[XmlInclude(typeof(KeyValueObject))]
	public CommObject getStatusOfDLL(String DLLName)
	{

		Application.Lock();
		CommObject commObject = new CommObject();
		CommObjectFunctions functions = new CommObjectFunctions();
		String finishedDLL = Constants.FINISHED_WORK_DIR+DLLName;
		bool okflag = false;
				
		if (File.Exists(finishedDLL)) 
		{
			String finishedStatus = Regex.Replace(finishedDLL,"dll","status");
			if (File.Exists(finishedStatus)) {
				FileStream fs = File.Open(finishedStatus, FileMode.Open);
				functions.addElement("errMsg", Constants.STATUS_FINISHED);
				okflag = true;
				Byte[] byteArrayFromStream = ConvertFileStreamToMemoryStream(fs).ToArray();
				functions.addElement("serArr", byteArrayFromStream);
				fs.Close();
			}
			else
			{
				functions.addElement("errMsg", Constants.STATUS_STATUSFILE_NOT_FOUND+finishedStatus+"**");
			}
		}
		else
		{
			String unfinishedDLL = Regex.Replace(finishedDLL,"finished","unfinished");
			if (File.Exists(unfinishedDLL))
			{
				String unfinishedStatus = Regex.Replace(unfinishedDLL,"dll","status");
				if (File.Exists(unfinishedStatus))
				{
					FileStream fs = File.Open(unfinishedStatus, FileMode.Open);	
					Byte[] byteArrayFromStream = ConvertFileStreamToMemoryStream(fs).ToArray();
					functions.addElement("serArr", byteArrayFromStream);
					functions.addElement("errMsg", Constants.STATUS_IN_PROGRESS);
					fs.Close();
					okflag = true;
				}
				else
				{
					functions.addElement("errMsg", Constants.STATUS_NOT_STARTED);
				}
			}
			else 
			{
				functions.addElement("errMsg", Constants.STATUS_DLLFILE_NOT_FOUND+unfinishedDLL);
			}
		}
		commObject.parameterList =  functions.getArrayList(); 
		Application.UnLock();
		return commObject;
	}

	[WebMethod]
	
	//public String checkDLL(String filename)
	public bool checkDLL(String filename)
	{
		String debugMsg = "";
		bool returnBool = false;
		String DLLToVerify = Constants.UPLOADED_WORK_DIR + filename;
		logTimeStamp("Dll to verify  = "+ DLLToVerify);
		if (File.Exists(DLLToVerify)) 
		{
			logTimeStamp("file exists");
			try {
				Assembly Assem = Assembly.LoadFrom(DLLToVerify);

				//Regex regex = new Regex(@"\\");
				//String[] dirArr = regex.Split(DLLToVerify);
				//String classTypeDLL = dirArr[dirArr.Length - 1];

				//String classType = Regex.Replace(classTypeDLL, ".dll", "");
		
				//Type T = Assem.GetType(classType, true);	
				
			
				foreach (Type type in Assem.GetTypes())
				{
					Type [] Interfaces = type.GetInterfaces();       
					if (Interfaces.Length != 0) 
					{
						foreach (Type NextInterface in Interfaces)     
						{       
							if (NextInterface.FullName == "IAppInterface")
							{
								String destDir = Regex.Replace(DLLToVerify,"uploaded","unfinished");
								File.Move(DLLToVerify, destDir);
								//copy dll to service's bin dir.
								File.Copy(destDir, Constants.SERVICE_BIN_DIR + filename);
								//File.Copy(destDir, Constants.CUSTOMER_BIN_DIR + filename);
								returnBool = true;
								break;
							}
						}
					}
				}
				
			}
			catch(Exception e)
			{
				returnBool = false;
				debugMsg = e.ToString();
				logTimeStamp("checkDLL: " + debugMsg);
			}
		}
		else 
		{
			logTimeStamp("file does not exists");
			returnBool = false;
		}
		return  returnBool;
		//return debugMsg;
	}

	private int getNonce(String nonceIdentity)
	{
		/*
		NonceDetails nonceDetails = new NonceDetails();
		return nonceDetails.generateAndStoreNonce(nonceIdentity);
		*/
		return getDatabaseManager().generateAndStoreNonce();
	}
	
	private object getArrayItem(ArrayList list, int index)
	{
		if (list == null) 
			return null;

		object[] objarr = list.ToArray();
		
		return objarr[index];
	}

	private void logTimeStamp(String msg)
	{
		try{

		StreamWriter sr;
		if (File.Exists("e:\\logfile.txt") == false) {
			sr = File.CreateText("e:\\logfile.txt");

			sr.WriteLine(msg);
			sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
		else {
			
			sr = File.AppendText("e:\\logfile.txt");
			sr.WriteLine(msg);
			sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
	        
		}
		catch (Exception e)
		{
		//fail silently
		}
	}

	[WebMethod] 
	[XmlInclude(typeof(KeyValueObject))]
	public CommObject sendClassForWork() 
	{
	
		Application.Lock();
		DateTime startTime, endTime;
		startTime = DateTime.Now;

		//logTimeStamp("start sendclassforwork");
		int probNo = Constants.INVALID_PROBLEM_NO;
		ClientManager clientManager = new ClientManager();
		CommObject commObject = new CommObject();			
		CommObjectFunctions functions = new CommObjectFunctions();

		ArrayList probInfoList = new ArrayList();

		bool ok = false;
		Scheduler scheduler = Scheduler.getSchedulerInstance();

		if (scheduler.getDLLCount() == 0)
		{
			bool loadSucceed = scheduler.loadDLLs();
			if (!loadSucceed)
			{
				functions.addElement("appName", Constants.ERROR_TIMEOBJECT_LOAD);
			}
			else
			{
				ok = true;
			}
		}
		else 
		{
			ok = true;
		}
	
		if (ok == true)
		{		
			String selectedDLL = "";
			try {
				selectedDLL = (String)scheduler.getSelectedDLL();
				if (selectedDLL == "")	{
					functions.addElement("errMsg", "Selected DLL = nothing" + Constants.SERVER_WORK_DONE );
					probInfoList.Insert(Constants.START_PROB, Constants.INVALID_PROBLEM_NO);
					probInfoList.Insert(Constants.NO_OF_PROBS, Constants.INVALID_PROBLEM_NO);
				}
				else {
					
					String classTypeNameDLL = Regex.Replace(selectedDLL, "status", "dll");
					functions.addElement("appName", Constants.CLIENT_UPLOAD_URL + selectedDLL);
				        functions = clientManager.generateWork ( functions, Constants.UNFINISHED_WORK_DIR );	
					ArrayList probList = (ArrayList)functions.getElement("problemList");
					if (getArrayItem(probList, Constants.START_PROB) != null)
					{

						if ((int)getArrayItem(probList, Constants.START_PROB) == Constants.INVALID_PROBLEM_NO)
						{
			                 		functions.addElement("errMsg", 
								Constants.SERVER_WORK_DONE + "problemno = -1 " + selectedDLL);
							//RemoveDLLFile(selectedDLL, "");
							getDatabaseManager().executeSQL("UPDATE CustomerDLLs SET status = true WHERE DLL= '"+classTypeNameDLL+"'");
							logTimeStamp("work over");
						}
						else 
						{
							if (getArrayItem(probList, Constants.START_PROB) != null)
							{
					
								probNo = (int)getArrayItem(probList, Constants.START_PROB);			
						

								String nonceIdentity = DateTime.Now.TimeOfDay.TotalMilliseconds + ""; 
								 
								functions.addElement("nonce", getNonce(nonceIdentity));
								//getDatabaseManager().AddToOutStandingWork((String)functions.getElement("appName"), probNo,probList);
							}
						}
					}
					
				}
				//update tt here *****************************
			}
			catch (Exception e)
			{
				selectedDLL = "";
				functions.addElement("errMsg ", Constants.ERROR_SCHEDULER_SELECT_DLL+e.ToString());
			}
		}
		commObject.displayStr = "debug: "+functions.getElement("errMsg");		
		commObject.parameterList =  functions.getArrayList(); 
		endTime = DateTime.Now;

		//TimeSpan timeSpan = endTime.Subtract(startTime);
		//logTimeStamp("end Send class for Work " + timeSpan.TotalMilliseconds);
			
		Application.UnLock();
		return commObject;
	}

	[WebMethod]
	[XmlInclude(typeof(KeyValueObject))]
	public string takeResult(CommObject rs)
	{
	Application.Lock();
	String result = "Started....";
	try
	{	
		CommObjectFunctions functions = new CommObjectFunctions();
		functions.setHashtable(rs.parameterList);

		Byte[] arr = null;
		int nonce = 0;
		if (functions.getElement("serArr") != null)
			arr = (Byte[])functions.getElement("serArr");
		nonce  = (int)functions.getElement("nonce");
//		NonceDetails nonceDetails = new NonceDetails();
		bool clientOK = getDatabaseManager().verifyClientNonce(nonce);
		result += "clientOK = "+clientOK+nonce;
	
		if (clientOK) 
		{
			if (arr != null) 
			{
				ClientManager clientManager = new ClientManager();
				Object objectFromArray = clientManager.getObjectFromArray(arr);
				Type argType = objectFromArray.GetType();
				String classNameFromType = (String)argType.Module.Name;
				classNameFromType = Regex.Replace( classNameFromType, ".dll", "");

				string statusFileNameWithPath = 
					Constants.UNFINISHED_WORK_DIR + classNameFromType + ".status";

				Object sourceObject = clientManager.getObjectFromFile(statusFileNameWithPath);			

				if (sourceObject != null)
				{
					//means the status file does not exist, so create it.
					Type type = sourceObject.GetType();	
			
					result += "Got type...\n";
			
					MethodInfo Method = type.GetMethod("acceptResult");
					logTimeStamp("calling acceptresult() , cpuload = " + functions.getElement("cpuLoad"));
	
					Object[] margs = new object[1];
			
					margs[0] = objectFromArray;
		
					try {
						result += "invoking accept result = ";
						ArrayList resultArr = clientManager.invokeMethod(
								sourceObject, margs, type, "acceptResult", "int");
						result +=  resultArr[0];
						result += "\n";		
					}
					catch (Exception e)
					{
						logTimeStamp(e.ToString());
						return result + "\n Exception: " + e.ToString();
					}

				}
				else
				{
					logTimeStamp("Creating status file...");
					sourceObject = objectFromArray;
				}

				try 
				{
					logTimeStamp("putting object in file...");
					clientManager.putObjectInFile(sourceObject, statusFileNameWithPath);
				}
				catch (Exception e) {
					logTimeStamp(e.ToString());
					return "Exception in takeResult method at server.";
				}
			}
	  		else 
			{
				logTimeStamp("ARR IS NULL AT SERVER");
	  		}
		}
		else {
			result +=  "NONCE NOT FOUND: "+nonce;
		}
		} 
		catch (Exception e)
		{
			result += e.ToString();
		}
		Application.UnLock();
		return result;	
	}
	
	[XmlInclude(typeof(KeyValueObject))]
	[WebMethod]
	public CommObject takeResultGenerateWork(CommObject resultObject)
	{
		Application.Lock();
		
		
		CommObjectFunctions functions = new CommObjectFunctions();

		functions.setHashtable(resultObject.parameterList);
		String result = "Started....";
		Byte[] arr = null;
		int nonce = 0;
				

		if (functions.getElement("serArr") != null)
			arr = (Byte[])functions.getElement("serArr");


		if (functions.getElement("nonce") != null)
			nonce  = (int)functions.getElement("nonce");	

//		NonceDetails nonceDetails = new NonceDetails();
		bool clientOK = getDatabaseManager().verifyClientNonce(nonce);
		logTimeStamp("clientOK TRDW = "+clientOK+nonce);
	
		String selectedDLL = "";


		if (clientOK) 
		{
			if (arr != null) 
			{
				ClientManager clientManager = new ClientManager();
				selectedDLL = clientManager.getDLLName((String)functions.getElement("appName"));
				Object objectFromArray = clientManager.getObjectFromArray(arr);
				Type argType = objectFromArray.GetType();
				String classNameFromType = (String)argType.Module.Name;


				// if work is marked complete
				if (getDatabaseManager().getStatus(selectedDLL) != true)
				{
					

				classNameFromType = Regex.Replace( classNameFromType, ".dll", "");

				string statusFileNameWithPath = 
					Constants.UNFINISHED_WORK_DIR + classNameFromType + ".status";
				logTimeStamp("returned dll = "+ (String)functions.getElement("appName"));
				printProbList((ArrayList)functions.getElement("problemList"));
				Object sourceObject = clientManager.getObjectFromFile(statusFileNameWithPath);			

				

				if (sourceObject != null)
				{
					Type type = sourceObject.GetType();	
			
					//result += "Got type...\n";
			
					MethodInfo Method = type.GetMethod("acceptResult");
					//result += "calling acceptresult() , cpuload = " + functions.getElement("cpuLoad") + "\n\n";
	
					Object[] margs = new object[1];
			
					margs[0] = objectFromArray;
		
					try {
						logTimeStamp("invoking accept result = ");
						ArrayList resultArr = clientManager.invokeMethod(sourceObject, 
									margs, type, "acceptResult", "int");
						logTimeStamp("putting object in file...\n");
						result += clientManager.putObjectInFile(sourceObject, statusFileNameWithPath);

					
						
						ArrayList probList = (ArrayList)functions.getElement("problemList");
						int probNo = (int)getArrayItem(probList, Constants.START_PROB);
						logTimeStamp("returned problem no = " + probNo);
						getDatabaseManager().deleteProblem((String)functions.getElement("appName"), probNo);										
					}
					catch (Exception e)
					{
						logTimeStamp(e.ToString());
					}

				}
				else
				{
					logTimeStamp("Creating status file...\n");
					sourceObject = objectFromArray;
					logTimeStamp("putting object in file...\n");
					result += clientManager.putObjectInFile(sourceObject, statusFileNameWithPath);
				}

				try {
					
					
					// Do More Work (adaptive).
					//
				
					DateTime startTime = DateTime.Now;
					Scheduler scheduler = Scheduler.getSchedulerInstance();
					selectedDLL = scheduler.getSelectedDLL();
	
					Boolean haswork = true;			
					while ((selectedDLL != "")&&(haswork))
					{
						functions = new CommObjectFunctions();
						functions.addElement("appName", Constants.CLIENT_UPLOAD_URL + selectedDLL);
						logTimeStamp("selected dll  = "+ selectedDLL);
						functions = clientManager.generateWork ( functions, Constants.UNFINISHED_WORK_DIR);	
						ArrayList probList = (ArrayList)functions.getElement("problemList");
						
						if(probList != null)
						{
							int probNo = -1;
							if (getArrayItem(probList, Constants.START_PROB) != null)
							{								
								haswork = false;
								probNo = (int)getArrayItem(probList, Constants.START_PROB);
								logTimeStamp("selected Dll = " + selectedDLL + " prob no = " + probNo);

								String nonceIdentity = DateTime.Now.TimeOfDay.TotalMilliseconds + "";
								functions.addElement("nonce", getNonce(nonceIdentity));
								logTimeStamp("nonce sent = " + (int)functions.getElement("nonce"));
								//getDatabaseManager().AddToOutStandingWork((String)functions.getElement("appName"), probNo,probList);							
							}

							//String selectedDLL = clientManager.getDLLName((String)functions.getElement("appName"));
							result += "selectedDLL = "+selectedDLL;
							if (functions.getElement("errMsg") != null)
							{
								functions.addElement("debugmsg1",(String)functions.getElement("errMsg"));	
								logTimeStamp((String)functions.getElement("errMsg"));
							}
						}
						else	
						{
						       	logTimeStamp("\ndll = "+selectedDLL+"\n");
							//getDatabaseManager().setStatus(selectedDLL);
							logTimeStamp("problist is null for dll = " + selectedDLL);		
							selectedDLL = scheduler.getSelectedDLL();
							haswork = true;	
						}

						
						//
						//Store Hashtable entries in ArrayList
						//
						resultObject.parameterList = functions.getArrayList();

						//DateTime endTime = DateTime.Now;
						//TimeSpan ts = endTime.Subtract(startTime);
						//logTimeStamp("new work generation time = "+ ts.TotalMilliseconds);
					}
					resultObject.displayStr = result;
					if (selectedDLL == "")
					{
						logTimeStamp("This selected dll is empty ");
						//return null;
						resultObject = null;
					}
						
					
				}
				catch (Exception e) {
					logTimeStamp("Exception in takeResult method at server." + e.ToString());
				}
	
				
				}
				else
				{
					//return null;
					resultObject = null;
				}
			}
	  		else 
			{
				logTimeStamp("ARR IS NULL AT SERVER");
				resultObject = null;
				//return null;
	  		}
		}
		else {
			logTimeStamp("NONCE NOT FOUND: "+nonce);
			resultObject = null;
			//return null;
		}
		
		
		Application.UnLock();
		return resultObject;

	}


	private void printProbList(ArrayList list)
	{
		System.Collections.IEnumerator myEnumerator = list.GetEnumerator();
		while ( myEnumerator.MoveNext() )
         		logTimeStamp("enum = " + myEnumerator.Current);	
	}


	[WebMethod]
	public bool addDLLToDB(String DLLName, String customerName)
	{
		return (getDatabaseManager().executeInsertQuery(DLLName, customerName));
	}
}



