using System;
using System.IO;
using System.Data;
using System.Collections;

public class Scheduler: IScheduler {

private const string targetDirectory = "E:\\inetpub\\wwwroot\\CSAHWS\\work\\unfinished";
private DatabaseManager DBManager = null;
static private Scheduler scheduler = null;

protected Scheduler()
{}

static public Scheduler getSchedulerInstance()
{
	if (scheduler == null)
	{
		scheduler = new Scheduler();
	}
	return scheduler;
}

public DatabaseManager getDatabaseManager()
{
	return DatabaseManager.getDBManagerInstance();
}

public void setDatabaseManager(DatabaseManager DBManager)
{
	this.DBManager = DBManager;
}

public int getDLLCount()
{
	return getDatabaseManager().getRecordCount();
}

private String[] getDLLs()
{
	return Directory.GetFiles(targetDirectory);
}

public DataSet getDLLsOfCustomer(String customerName)
{
	return getDatabaseManager().executeSQL("select DLL from CustomerDLLs where username = '"+customerName+"'");
}

public bool loadDLLs()
{
	try 
	{
		getDatabaseManager().loadData(getDLLs());
	}
	catch (Exception e)
	{
		Console.Write("Scheduler: "+e.ToString());
		return false;
	}
	return true;
}

public String getSelectedDLL()
{
	String selectedDLL = "";
	String SQLStatement = "SELECT DLL FROM CustomerDLLs WHERE status<>True ";
	SQLStatement += " ORDER BY TimeLastAccessed";
	
	DataSet dataSet = getDatabaseManager().executeSQL(SQLStatement);
	try
	{
		if (getDatabaseManager().getRecordCount() != 0)
		{
		
			if ((dataSet != null) && (dataSet.Tables.Count != 0))
			{
				selectedDLL = (String)dataSet.Tables[0].Rows[0][0];
				updateTimeStamp(selectedDLL);
			}
		}
	}
	catch (Exception e)
	{
		selectedDLL = "";
		Console.WriteLine("************" + e.ToString());
		//return e.ToString();
		return "****" + dataSet.Tables[0].Rows[0][0];
	}
	return selectedDLL;
}

private void updateTimeStamp(String DLL)
{
	String SQLStatement = "update CustomerDLLs set TimeLastAccessed = TimeLastAccessed + 1 where DLL = '"+DLL+"'";
	getDatabaseManager().executeSQL(SQLStatement);
}

public void addDLL(String DLLToAdd)
{
	String SQLStatement = "Insert into CustomerDLLs(DLL) values ('"+DLLToAdd+"')";
	getDatabaseManager().executeSQL(SQLStatement);
}
/*
public static void Main(String[] args)
{
	Scheduler s = Scheduler.getSchedulerInstance();
	if (s!=null)
	Console.WriteLine(s.getDLLCount()+s.getSelectedDLL());
}
*/
} // end of class