using System;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Collections;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.RegularExpressions;

public class DatabaseManager
{
	private String tableName = "CustomerDLLs";
	static private DatabaseManager DBManager = null;

	protected DatabaseManager()
	{}

	private String getDLLName(String DLLFileNameWithPath)
	{
		Regex r = new Regex(@"\\");
		string[] parts = r.Split(DLLFileNameWithPath);
		return parts[parts.Length - 1];
	}

	public static DatabaseManager getDBManagerInstance()
	{
		if (DBManager == null)
		{
			DBManager = new DatabaseManager();
		}
		return DBManager;
	}

	public bool loadData(String[] DLLs)
	{
		String SQLStatement = "";
		try 
		{
			for (int ctr = 0; ctr < DLLs.Length; ctr++)
			{
				SQLStatement = "insert into "+this.tableName+" (username, DLL,TimeLastAccessed) values (";
				SQLStatement += "'ramya','"+getDLLName(DLLs[ctr])+"',0)";
				executeSQL(SQLStatement);
			}
			return true;
		}
		catch (Exception e)
		{
			logTimeStamp("DatabaseManager error: loadData()"+e.ToString());
			logTimeStamp("----------------------------------------------------------------------------------------");
			return false;
		}
	}

	//delete all table entries related to this DLL
	public bool executeDeleteQuery(String DLLName, String customerName)
	{
		bool returnBool = false;
		try
		{
			String SQLStatement = "Delete from "+this.tableName+" where DLL = '"+DLLName+"'";
			if (customerName.Length > 0)
			{
				SQLStatement += " and username = '"+customerName+"'";
			}
			if (executeSQL(SQLStatement) != null)
				returnBool = true;
			SQLStatement = "Delete from OutstandingWork where ApplicationName like '*"+DLLName+"'";
			if (executeSQL(SQLStatement) != null)
				returnBool = true;
			else
				returnBool = false;
			logTimeStamp("SQLStatement is "+SQLStatement);
			logTimeStamp("bool is " + returnBool);
		}
		catch (Exception e)
		{
			logTimeStamp("DatabaseManager: "+e.ToString());
		}
		return returnBool;
	}

	public bool executeInsertQuery(String DLLName, String customerName)
	{
		bool returnBool = false;
		try
		{
			String SQLStatement = "insert into "+this.tableName+" (username, DLL, TimeLastAccessed)";
			SQLStatement += " values ('" +customerName+ "','"+DLLName+"', 0)";
			if (executeSQL(SQLStatement) != null)
			{
				returnBool = true;
			}
		}
		catch (Exception e)
		{
			logTimeStamp("DatabaseManager: executeInsertQuery: "+e.ToString());
			//returnBool = false;
		}
		return returnBool;
	}

	private OleDbConnection getConnection()
	{
		try 
		{
			String connectionString = 
		  	"Provider=Microsoft.Jet.OLEDB.4.0;"
			+"Data Source=" 
			+ "E:\\inetpub\\wwwroot\\csahwebservice\\db3.mdb";
			//+ "Server.MapPath(db3.mdb)";
			OleDbConnection connection = new OleDbConnection(connectionString);	
			return connection;
		}
		catch (Exception e)
		{
			logTimeStamp(e.ToString());
			return null;
		}
	}	

	public DataSet executeSQL(String sqlStatement)
	{
		DataSet objDataSet = null;
		try
		{
	   		OleDbConnection connection = getConnection();
			if (connection != null)		
			{
				OleDbDataAdapter objDataAdapter = new OleDbDataAdapter(sqlStatement, connection);
				objDataSet = new DataSet();
				objDataAdapter.Fill(objDataSet);
				connection.Close();
				logTimeStamp("executeSQL : ok");
			}
			else
			{objDataSet = null;}
		}
		catch (Exception e)
		{
			logTimeStamp("DatabaseManager error in executeSQL()"+sqlStatement);
			logTimeStamp(e.ToString());
			objDataSet = null;
		}
		return objDataSet;
	}

	public int getRecordCount()
	{
   		OleDbConnection connection = getConnection();
		String SQLStatement = "select count(*) from "+this.tableName;
		int recordCount = 0;
			
		if (connection != null)
		{
			OleDbCommand myCommand = new OleDbCommand(SQLStatement, connection);
   			myCommand.Connection.Open();
   			OleDbDataReader myReader = myCommand.ExecuteReader();
			while(myReader.Read()) 
     			{
        			recordCount = myReader.GetInt32(0);
			}
			myReader.Close();
			connection.Close();
		}
		else
		{recordCount = -1;}
		return (int)recordCount;
	}

	public DataSet getRecords()
	{
		return executeSQL("select * from "+this.tableName);
	}

	public bool setStatus(String dll)
	{
		bool returnBool = false;
		String SQLStatement = "UPDATE "+this.tableName+" SET status = true WHERE DLL= '"+dll+"'";
		if (executeSQL(SQLStatement) != null)
			returnBool = true;
		return returnBool;
	}

	public bool getStatus(String dll)
	{
		OleDbConnection connection = getConnection();
		String SQLStatement = "select status from "+this.tableName+ " where DLL = '"+dll+"'";
		Boolean workOver = false;
			
		if (connection != null)
		{
			OleDbCommand myCommand = new OleDbCommand(SQLStatement, connection);
   			myCommand.Connection.Open();
   			OleDbDataReader myReader = myCommand.ExecuteReader();
			while(myReader.Read()) 
     			{
        			workOver = myReader.GetBoolean(0);
			}
			myReader.Close();
			connection.Close();
		}
		return (Boolean)workOver;
	}


public void AddToOutStandingWork(String appName, int ProblemNo,ArrayList problem)
{
	
	try
	{
		if (checkWorkExists(appName,ProblemNo) == false)
		{
			OleDbConnection connection = getConnection();
			OleDbCommand myCommand = new OleDbCommand();
			myCommand.Connection = connection;
			myCommand.Connection.Open();

			myCommand.CommandText = "INSERT INTO OutstandingWork (Problem,ApplicationName,ProblemNo) VALUES (?,'" + appName + "'," + ProblemNo + ")";
			logTimeStamp(myCommand.CommandText);
			MemoryStream memoryStream=new MemoryStream();
			BinaryFormatter binaryFormatter = new BinaryFormatter();
			binaryFormatter.Serialize(memoryStream,problem);
		
			Byte[] byteArray = memoryStream.ToArray();

			OleDbParameter myParameter = new OleDbParameter("Prob",OleDbType.VarBinary);
			myParameter.Value = byteArray;
			myCommand.Parameters.Add(myParameter);
			myCommand.ExecuteNonQuery();
			myCommand.Connection.Close();	
		}		
	}
	catch(Exception e)
	{
		logTimeStamp(e.Message);
		logTimeStamp(e.StackTrace);
	}
}

public ArrayList getNextProblem(String appName)
{
		ArrayList returnValue = null;
	try
	{
		OleDbConnection connection = getConnection();

		String sql = "Select Problem from OutstandingWork where ApplicationName = '"+ appName +"' order by Counter";
		Byte[] bytearr = new Byte[4192];

		if (connection != null)
		{
			logTimeStamp(sql);
			OleDbCommand myCommand = new OleDbCommand(sql, connection);
   			myCommand.Connection.Open();
		
			OleDbDataReader myReader = myCommand.ExecuteReader();
			myReader.Read();
			myReader.GetBytes(0,0,bytearr,0,4192);

			myReader.Close();
			connection.Close();

			Stream stream = new MemoryStream(bytearr);
			stream.Position = 0;

			BinaryFormatter	binaryFormatter = new BinaryFormatter();
			returnValue = (ArrayList)binaryFormatter.Deserialize(stream);
			

		}
	}
	catch(Exception e)
	{
		logTimeStamp(e.Message);
		logTimeStamp(e.StackTrace);
	}
		
		return returnValue;				
}


public void deleteProblem(String appName, int ProblemNo)
{
	try
	{
		OleDbConnection connection = getConnection();
		String sql = "Delete from OutstandingWork where ApplicationName = '" + appName + "' And ProblemNo = "+ProblemNo;
		logTimeStamp(sql);
		OleDbCommand myCommand = new OleDbCommand(sql, connection);
		if(myCommand.Connection.State == ConnectionState.Closed)
		{
			myCommand.Connection.Open();
		}
		myCommand.ExecuteNonQuery();	
		myCommand.Connection.Close();
	}
	catch(Exception e)
	{
			
		logTimeStamp(e.Message);
		logTimeStamp(e.StackTrace);
		deleteProblem(appName,ProblemNo);
	}
}


	public void updateCounter(String appName, int ProblemNo)
	{
		try
		{
		
		OleDbConnection connection = getConnection();
		String sql = "UPDATE OutstandingWork SET [Counter]=[Counter] + 1 WHERE ApplicationName = '" + appName + "' And ProblemNo = "+ProblemNo;
		
		OleDbCommand myCommand = new OleDbCommand(sql, connection);
		myCommand.Connection.Open();
		myCommand.ExecuteNonQuery();	
		myCommand.Connection.Close();	

		}
		catch(Exception e)
		{
			logTimeStamp(e.Message);
			logTimeStamp(e.StackTrace);
		}

	}

	public bool checkWorkExists(String appName, int ProblemNo)
	{
		bool exists = false;
		try
		{
			OleDbConnection connection = getConnection();

			String sql = "Select Count(*) from OutstandingWork where ApplicationName = '"+ appName +"' AND ProblemNo = " + ProblemNo;		
	
			if (connection != null)
			{
				OleDbCommand myCommand = new OleDbCommand(sql, connection);
	   			myCommand.Connection.Open();
			
				OleDbDataReader myReader = myCommand.ExecuteReader();
				myReader.Read();
				if(myReader.GetInt32(0) > 0) 
				{
					exists = true;
				}

				myReader.Close();
				connection.Close();
			}

		
		}
		catch(Exception e)
		{
			logTimeStamp(e.Message);
			logTimeStamp(e.StackTrace);
		}
	
		return exists;		
	}

	public bool verifyClientNonce(int nonce)
	{
		int returnValue = -1;	
		try
		{
			OleDbConnection connection = getConnection();
			String sql = "Delete from Nonces where Nonce = " + nonce;
			OleDbCommand myCommand = new OleDbCommand(sql, connection);
			myCommand.Connection.Open();
			myCommand.CommandText = sql;
			returnValue = myCommand.ExecuteNonQuery();	
			myCommand.Connection.Close();
		}
		catch(Exception e)
		{
			logTimeStamp(e.Message);
			logTimeStamp(e.StackTrace);
		}
	
		if (returnValue > 0) return true;
		else return false;
	}

	public int generateAndStoreNonce()
	{

		Random clientNonce = new Random();
		int nonce = clientNonce.Next();

		try
		{			
			OleDbConnection connection = getConnection();
			OleDbCommand myCommand = new OleDbCommand();
			myCommand.Connection = connection;
			myCommand.Connection.Open();
			myCommand.CommandText = "INSERT INTO Nonces (Nonce) VALUES (" + nonce + ")";
			myCommand.ExecuteNonQuery();
			myCommand.Connection.Close();	
			
		}
		catch(Exception e)
		{
			logTimeStamp(e.Message);
			logTimeStamp(e.StackTrace);
		}
		
		return nonce;
	}


	private void logTimeStamp(String msg)
	{
		try{

		StreamWriter sr;
		if (File.Exists("e:\\logfile.txt") == false) {
			sr = File.CreateText("e:\\logfile.txt");

			sr.WriteLine(msg);
			//sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
		else {
			
			sr = File.AppendText("e:\\logfile.txt");
			sr.WriteLine(msg);
		//	sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
	        
		}
		catch (Exception e)
		{
			//fail silently
			Console.WriteLine(e.ToString());
		}
	}

	
/*
	public static void Main(String[] args)
	{

		DatabaseManager d = DatabaseManager.getDBManagerInstance();
		int nonce = d.generateAndStoreNonce();
		Console.WriteLine("nonce = " + nonce);
		bool val = d.verifyClientNonce(nonce);
		Console.WriteLine("deleted = " + val);
			
		String appName = "http://206.240.24.73/CSAHWS/work/unfinished/eigen.dll";


		ArrayList x = new ArrayList();
		x.Add(1);
		x.Add(5);
		x.Add(9);

		d.AddToOutStandingWork(appName,1,x);
	//	Console.WriteLine("exists = " + d.checkWorkExists(appName,1));

		ArrayList returnValue = d.getNextProblem(appName);
		if (returnValue == null) Console.WriteLine("null problems");
		else
		{
			
	
		Console.WriteLine(returnValue[0]);
		Console.WriteLine(returnValue[1]);
		Console.WriteLine(returnValue[2]);
		}

		//d.updateCounter(appName,1);

		//d.deleteProblem(appName,1);

		
	}
*/



}