using System;
using System.Collections;
using System.IO;
using System.Runtime.Serialization;
using System.Reflection;
using System.Threading;
using System.Xml.Serialization;

[Serializable]
public class message
{
	public float lb;
	public float ub;
	public float s_lb;
	public float s_ub;
}


[Serializable]
public class workObject
{
	public float lb;
	public float ub;
	public float s_lb;
	public float s_ub;
	public bool given;
	public bool done;
}


[Serializable]
public class eigen : IAppInterface
{

	private const int START_PROB     = 0;
	private const int NO_OF_PROBS    = 1;
	private const int LB    = 2;
	private const int UB    = 3;
	private const int S_LB  = 4;
	private const int S_UB  = 5;

	//length of diagonal of matrix
	private int size = 30;
	public float lowerBound;
	public float upperBound;
	private float TOTAL_ROOTS = 0;

	private float[] diagonal;
	private float[] subdiagonal;

	//master worklist maintained at the server
	public ArrayList workList = null;

	//current problem given to the client
	//public message currWorkObj = null;
	public ArrayList currProblem = null;
	public int currProbNo = -1;

	public int problemCounter = -1;
	    
	//Results returned by the client
   	public ArrayList clientResultList = null;
	
        	
	private const float EPSILON = 0.000001F;
	private const int SUCCESS = 1;
	private const int FAILURE = -1;

	public eigen()
	{
		diagonal = new float[size];
		subdiagonal = new float[size-1];
		for(int count = 0; count < size; count++) diagonal[count] = 2;

		for(int count = 0; count < size-1; count++) subdiagonal[count] = 1;
		workList = new ArrayList();
		calculateMinMax();
		
				
		TOTAL_ROOTS = getNumberOfEigens(lowerBound) - getNumberOfEigens(upperBound);
		//Console.WriteLine("TOTAL_ROOTS is " + TOTAL_ROOTS);
		init();
	}

	//sets the currProblem that will be used in calculate()
	public int setProblem(ArrayList problem, int currprobno)
	{
		this.currProblem = problem;
		this.currProbNo  = currprobno;
		return this.currProbNo;
	}

	//return the number of agreements in sign
	int getNumberOfEigens(float lambda)
	{
		//Find number of agreements in sign of consecutive members
		//of the sequence {fk(lambda)}
		int count = 0, i = 0;

		while(i < size)
		{
			//Console.Write(fn(i, lambda) + "...");
			//Console.WriteLine(fn(i+1, lambda));

			if ( (fn(i, lambda) >= 0)&&(fn(i+1, lambda) >= 0))
			{
				//Console.WriteLine("count inc");
				count++;
			}

			else if ((fn(i, lambda) < 0)&&(fn(i+1, lambda) < 0))
			{
				//Console.WriteLine("count dec");
				count++;
			}
			//Console.WriteLine("count is " + count);
			i = i + 1;
		}
		//Console.WriteLine("Agreements in sign = " + count);
		return count;
	}

	float fn(int k, float lambda)
	{
		if (k==0) return 1;
		else if (k == 1) return (diagonal[0]-lambda);
		else
		{
			
			float alpha = diagonal[k-1];
			//Console.Write("alpha = " + alpha);
			float beta = subdiagonal[k-2];
			//Console.Write("beta = " +  beta);
			//Console.WriteLine((alpha-lambda)*fn(k-1) - (beta)*(beta)*fn(k-2));
			return (alpha-lambda)*fn(k-1, lambda) - (beta)*(beta)*fn(k-2, lambda);
		}
	}

	//calculate a and b
	public void calculateMinMax()
	{
		float min = diagonal[1] - Math.Abs(subdiagonal[1]) - Math.Abs(subdiagonal[0]);
		float max = diagonal[1] - Math.Abs(subdiagonal[1]) - Math.Abs(subdiagonal[0]);
		//Console.WriteLine("min = " + min);
		//Console.WriteLine("max = " + max);
		for (int i = 2; i < size-1; i++)
		{
			float mintmp = diagonal[i] - Math.Abs(subdiagonal[i]) - Math.Abs(subdiagonal[i-1]);
			float maxtmp = diagonal[i] + Math.Abs(subdiagonal[i]) + Math.Abs(subdiagonal[i-1]);
			//Console.WriteLine("mintmp = " + mintmp);
			//Console.WriteLine("maxtmp = " + maxtmp);
			if (mintmp < min)
				min = mintmp;
			if (maxtmp > max)
				max = maxtmp;
		}
		lowerBound = min;
		upperBound = max;
		//Console.WriteLine("lowerbound = " + lowerBound);
		//Console.WriteLine("upperbound = " + upperBound);
	}

	private void init()
	{
		workList = new ArrayList();
		
		workObject workObj = new workObject();
		workObj.lb = lowerBound;
		workObj.ub = upperBound;
		workObj.s_lb = getNumberOfEigens(lowerBound);
		workObj.s_ub = getNumberOfEigens(upperBound);
		workObj.given = false;
		workObj.done = false;

		workList.Add(workObj);
	}

	private void printResult(ArrayList resultList)
	{
		workObject result = new workObject();
		//Console.WriteLine("............Printing worklist...............");
		
		foreach ( object i in resultList ) 
		{
			result = (workObject)i;

			//Console.Write(result.lb + " ");
			//Console.Write(result.ub+ " ");
			//Console.Write(result.s_lb+ " ");
			//Console.Write(result.s_ub+ " ");
			//Console.Write(result.done+ " ");
			//Console.Write(result.given+ " ");
			//Console.WriteLine("");
		}
		//Console.WriteLine(".............................................");
	}

	private void printDebugResult(ArrayList resultList)
	{
		message result = new message();
		foreach ( object i in resultList ) 
		{
			Console.WriteLine(".................Printing message............");
			result = (message)i;
			Console.WriteLine("lowerBound = " + result.lb);
			Console.WriteLine("upperBound = " + result.ub);
			Console.WriteLine("s(lb) = " + result.s_lb);
			Console.WriteLine("s(ub) = " + result.s_ub);
			Console.WriteLine(".............................................");
		}
	}

	private void showMessage(message currWorkObj)
	{
		if (currWorkObj == null)
			Console.WriteLine("Message object is NULL");
		else
		{
			Console.WriteLine(".........Message.........");
			Console.Write(currWorkObj.lb + " ");
			Console.Write(currWorkObj.ub + " ");
			Console.Write(currWorkObj.s_lb + " ");
			Console.Write(currWorkObj.s_ub);
			Console.WriteLine("\n.........................");
		}
	}

	
	private object getArrayItem(ArrayList list, int index)
	{
		object[] objarr = list.ToArray();
		if (index < list.Count)
			return objarr[index];
		else
			return null;
	}

	private ArrayList getArrayList(object[] objarr)
	{
		ArrayList temp = new ArrayList();
		for (int i = 0; i < objarr.Length; i++)
			temp.Add(objarr[i]);	
		return temp;
	}

	private void logTimeStamp(String msg)
	{
		try{

		StreamWriter sr;
		if (File.Exists("e:\\logfile.txt") == false) {
			sr = File.CreateText("e:\\logfile.txt");

			sr.WriteLine(msg);
			//sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
		else {
			
			sr = File.AppendText("e:\\logfile.txt");
			sr.WriteLine(msg);
		//	sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
	        
		}
		catch (Exception e)
		{
		//fail silently
		Console.WriteLine(e.ToString());
		}
	}

	//Load the currWorkObj with work from the WorkList.
	public ArrayList generateProblem(int cpuLoad, int noOfProblems)
	{
		ArrayList eigenProbList = new ArrayList();
		workObject objToUpdate = null;
		bool morework = false;
		foreach ( object work in workList ) 
		{
			//currWorkObj = new message();
			
			workObject workObj = (workObject)work;
			//the work is not already given out or finished
			if ((workObj.given == false) && (workObj.done == false))
			{
				objToUpdate = workObj;

				object[] objarr = new object[6];
				problemCounter += 1;
				objarr[START_PROB] = problemCounter;
				objarr[NO_OF_PROBS] = SUCCESS;
	
				objarr[LB] = workObj.lb;
				objarr[UB] = workObj.ub;
				objarr[S_LB] = workObj.s_lb;
				objarr[S_UB] = workObj.s_ub;
				eigenProbList.Clear();
				eigenProbList = getArrayList(objarr);
				morework = true;
				break;
			}
		}

		if (morework == false)
			eigenProbList = null;

		//mark the problem as given in the worklist
		if (objToUpdate != null)
		{
			if (workList.Contains(objToUpdate))
			{
				workList.Remove(objToUpdate);
				objToUpdate.given = true;
				workList.Add(objToUpdate);
			}
		}

 		return eigenProbList;		
	}

	//checks if the given interval already exists in the worklist
	private bool isDuplicate(float LB, float UB)
	{
		bool retBool = false;
		foreach (object obj in workList) 
		{
			workObject workObj = (workObject)obj;
			if ( (workObj.lb == LB) && (workObj.ub == UB))
			{
				retBool = true;
				break;
			}
		}
		return retBool;
	}


	//The client returns an ArrayList consisting of objects
	//of type message.
	public int acceptResult(Object child)
	{
		ArrayList tempWorkList = new ArrayList();
		//Console.WriteLine("-----------------------------");
		float LB = ((message)((eigen)child).clientResultList[0]).lb;
		float UB = ((message)((eigen)child).clientResultList[0]).ub;

		foreach (object clientObj in ((eigen)child).clientResultList)
		{
			message obj = new message();
			obj = (message)clientObj;
			//showMessage(obj);
			
			if (obj.lb < LB)
				LB = obj.lb;
			if (obj.ub > UB)
				UB = obj.ub;
		}
		//Console.WriteLine("LB = " + LB + ", UB = " + UB);
		//Console.WriteLine("---------------------------");
		
		//Enumerate over worklist and add the elements that
		//needs to be deleted from worklist to a tempworklist.
		//Then delete those from worklist. This needs to be
		//done because it is not possible to modify the arraylist
		//within a foreach of the same arraylist.
		
		foreach (object obj in workList) 
		{
			workObject workObj = (workObject)obj;
			if ( (workObj.lb == LB) && (workObj.ub == UB))
			{
				tempWorkList.Add(obj);
			}
		}
		
		foreach(object obj in tempWorkList)
		{
			//debug code
			workObject workObj = (workObject)obj;
			//Console.WriteLine("deleting from list: " + workObj.lb + " , " + workObj.ub);
			//end debug code
			workList.Remove(obj);
			logTimeStamp("removed = " + workObj.lb + " " + workObj.ub);
		}

		//add the 2 new intervals
		foreach (object clientObj in ((eigen)child).clientResultList)
		{
			message clientcurrWorkObj = new message();
			clientcurrWorkObj = (message)clientObj;
			
			workObject workObj = new workObject();

			//add the interval if no of eigens in the interval is > 0
			if (clientcurrWorkObj.s_lb > clientcurrWorkObj.s_ub)
			{
				if (isDuplicate(clientcurrWorkObj.lb, clientcurrWorkObj.ub) == false)
				{
					workObj.lb = clientcurrWorkObj.lb;
					workObj.ub = clientcurrWorkObj.ub;
					workObj.s_lb = clientcurrWorkObj.s_lb;
					workObj.s_ub = clientcurrWorkObj.s_ub;
					workObj.given = false;
					if (clientcurrWorkObj.ub - clientcurrWorkObj.lb <= EPSILON)
					{
						workObj.done = true;
						workObj.given = true;
					}	
					else
						workObj.done = false;
					logTimeStamp("adding to list: " + workObj.lb + " , " + workObj.ub);
			
					workList.Add(workObj);
				}
			}
		}

		return SUCCESS;
	}

	public string startUp()
	{		
		return "StartUp calling calculate: " + calculate(); 
	}

	//checks in currProblem to see if there is work to do
	//and populates the result of type message in clientResultList
	public int calculate()
	{

		
		if (this.currProblem == null)
		{
			Console.WriteLine("Nothing to calculate, currWorkObj is NULL");
		}

		else
		{
			float lb = (float)getArrayItem(currProblem, LB);
			float ub = (float)getArrayItem(currProblem, UB);;
			float s_lb = (float)getArrayItem(currProblem, S_LB);
			float s_ub = (float)getArrayItem(currProblem, S_UB);

			float mid = (lb + ub)/2;
			float s_mid = getNumberOfEigens(mid);
			//Console.WriteLine("Finding mid = " + mid + " for s_mid = " + s_mid);

			clientResultList = new ArrayList();
			message resObj = new message();
			resObj.lb = lb;
			resObj.ub = mid;
			resObj.s_lb = s_lb;
			resObj.s_ub = s_mid;
			clientResultList.Add(resObj);

			resObj = new message();
			resObj.lb = mid;
			resObj.ub = ub;
			resObj.s_lb = s_mid;
			resObj.s_ub = s_ub;
			clientResultList.Add(resObj);
			//printDebugResult(clientResultList);
		}

		return SUCCESS;
	}

	public string showResult()
	{
		String resStr = "<table><tr><td>LowerBound</td><td>UpperBound</td><td>Given</td><td>Done</td></tr>";

		workObject result = new workObject();
		foreach ( object i in workList ) 
		{

			resStr += "<tr>";
			result = (workObject)i;
	
			resStr += "<td>"+ result.lb +"</td>";	
			resStr += "<td>"+ result.ub +"</td>";	
			//resStr += "<td>"+ result.s_lb +"</td>";	
			//resStr += "<td>"+ result.s_ub +"</td>";	
			resStr += "<td>"+ result.given +"</td>";	
			resStr += "<td>"+ result.done +"</td>";	

			resStr += "</tr>";

		/*

	
			resStr += "lowerBound = " + result.lb + "\n";
			resStr += "upperBound = " + result.ub + "\n";
			resStr += "s(lb) = " + result.s_lb + "\n";
			resStr += "s(ub) = " + result.s_ub + "\n";
			resStr += "done = " + result.done + "\n";
			resStr += "given = " + result.given + "\n";
		*/
		}
		resStr += "</table>";
		return resStr;
	}

	public static void Main(String[] args)
	{
		//To find the eigen values of a symmetric matrix, use Gerschgorin Circle
		//to find the the lowest and the highest limits, a and b.
		//Use bisection to bisect the [a,b] interval and use s(a) - s(b) to find
		//the number of eigen values between a and b. Each time, check if the
		//number of eigen values in each interval is 0, if 0, ignore interval.

		eigen e = new eigen();
		ArrayList testobj;
		while ((testobj = e.generateProblem(1, 1)) != null)
		{
			//Console.WriteLine("In LOOP : ");
			e.setProblem(testobj, 1);
			e.startUp();	
			e.acceptResult(e);
		}

/*
		testobj = e.generateProblem(1, 1);
		e.setProblem(testobj, 1);
			e.startUp();	
			e.acceptResult(e);

*/				
		Console.WriteLine(e.showResult());

	}
}





