using System;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Reflection;
using nsService;
using System.Collections;
using System.Text.RegularExpressions;	
//for cpu load
using System.Threading;
using System.Diagnostics;

namespace WorkerThread
{


/*
* The ServerInteractionClass has all the functionality needed to interact
* with the WebService.
*/
public class ServerInteractionClass
{
	private Type type;
	//CommObject resultObject = null;
	CommObjectFunctions functions = null;
	String message = "";

	private const int OPTIMUM_LOAD = 50;
	private const int MORE_PROBLEMS = 2;
	private const int LESS_PROBLEMS = 0;
	private const int SAME_PROBLEMS = 1;

	private const int START_PROB     = 0;
	private const int NO_OF_PROBS    = 1;

	//CounterSample aspNetCounterSample;
	CounterSample winLogonCounterSample, IECounterSample, totalLoadCounterSample;
	//PerformanceCounter aspNetPerfCounter
	PerformanceCounter winLogonPerfCounter, IEPerfCounter, totalLoadPerfCounter;

	ManualResetEvent m_EventStopThread;
	ManualResetEvent m_EventThreadStopped;
	ClientInIE form;

	public ServerInteractionClass()
	{}

	public ServerInteractionClass(ManualResetEvent m_EventStopThread,
			         ManualResetEvent m_EventThreadStopped, 
			         ClientInIE form)
	{
		this.m_EventStopThread = m_EventStopThread;
		this.m_EventThreadStopped = m_EventThreadStopped;
		this.form = form;
	}

	private Type getType()
	{
		return type;
	}

	private void setType(Type toType)
	{
		type = toType;
	}

	private String extractDLLNameFromPath(String fullPath)
	{
		Regex regex = new Regex("/");
		String[] temp = regex.Split(fullPath);
		
		Match m = Regex.Match(@fullPath, ".dll");

		// If it is a .dll file, replace .dll from the last
		// string after '/' to nothing else replace .status
		// to nothing

		if (m.Success)
			return ""+Regex.Replace(temp[temp.Length - 1],".dll","");
		else
			return ""+Regex.Replace(temp[temp.Length - 1],".status","");
	}

	private String constructDLLFileNameFromStatusFileName(String statusFileName)
	{
		return ""+Regex.Replace(statusFileName,".status",".dll");
	}

	/*
	* Dynamically invoke method with the given signature on the sourceObject.
	*/
	public ArrayList invokeMethod(Object sourceObject, Object[] argObject, String methodName, String retType)
	{ 	
		ArrayList retList = new ArrayList();
		//-999 value is ignored
		try
		{
			Type type = getType();

			MethodInfo method = type.GetMethod(methodName);
			//form.showMessage("method = " + method.ToString());
			if (retType.Equals("int"))
			{
				//form.showMessage("int...");
				//retList.Add( (int)method.Invoke(sourceObject, argObject) );
				retList.Add( (int)method.Invoke(sourceObject, argObject) );
			
			}
			else if (retType.Equals("int[]"))
			{
				int[] intArr = (int[])method.Invoke(sourceObject, argObject);
				retList.Add(intArr[0]);
				retList.Add(intArr[1]);
			}
			else if (retType.Equals("String"))
			{
				String retStr = (String)method.Invoke(sourceObject, argObject);
				retList.Add(retStr);
			}
			else if (retType.Equals("object"))
			{
				object retObj = (object)method.Invoke(sourceObject, argObject);
				retList.Add(retObj);
			}

			else
			{
				retList.Add ( -999);
			}
		}
		catch(Exception e)
		{
			//form.showMessage(e.ToString());
			Console.Write("INVOKEMETHOD at ServerInteractionClass: "+e.ToString());
			retList = null;
		}
		return retList;
	}

	/*
	* Serialize given object to MemoryStream
	*/
	private MemoryStream serializeObject(Object objectToSerialize)
	{
		MemoryStream stream = new MemoryStream();
		stream.Position = 0;
		BinaryFormatter format = new BinaryFormatter();
		format.Serialize(stream, objectToSerialize);
		return stream;
	}

	/*
	* Initialize counters to calculate CPULoad because of this process.
	*/
	private void initCounter()
	{		

		try
		{
		//aspNetCounterSample = new CounterSample();
		//aspNetPerfCounter = new PerformanceCounter();
		//aspNetPerfCounter.CategoryName = "Process";
		//aspNetPerfCounter.CounterName = "% Processor Time";
		//aspNetPerfCounter.InstanceName = "aspnet_wp";
		//aspNetPerfCounter.MachineName = ".";
		//aspNetCounterSample = aspNetPerfCounter.NextSample();
		winLogonCounterSample = new CounterSample();
		winLogonPerfCounter = new PerformanceCounter();
		winLogonPerfCounter.CategoryName = "Process";
		winLogonPerfCounter.CounterName = "% Processor Time";
		winLogonPerfCounter.InstanceName = "WINLOGON";
		winLogonPerfCounter.MachineName = ".";
		winLogonCounterSample = winLogonPerfCounter.NextSample();

		IECounterSample = new CounterSample();
		IEPerfCounter = new PerformanceCounter();
		IEPerfCounter.CategoryName = "Process";
		IEPerfCounter.CounterName = "% Processor Time";
		IEPerfCounter.InstanceName = "IEXPLORE";
		IEPerfCounter.MachineName = ".";
		IECounterSample = IEPerfCounter.NextSample();

		totalLoadCounterSample = new CounterSample();
		totalLoadPerfCounter = new PerformanceCounter();
		totalLoadPerfCounter.CategoryName = "Processor";
		totalLoadPerfCounter.CounterName = "% Processor Time";
		totalLoadPerfCounter.InstanceName = "_Total";
		totalLoadPerfCounter.MachineName = ".";
		totalLoadCounterSample = totalLoadPerfCounter.NextSample();
		}

		catch(System.Security.SecurityException se)
		{
			logTimeStamp(se.ToString());	
		}
		catch (Exception e)
		{
			logTimeStamp(e.ToString());		
		}
		return;
	}

	/*
	* Calculate CPULoad due to this process.
	*/
	private int calculateCPULoad()
	{
		int load = 1;

		try
		{
			//(int)CounterSample.Calculate(
			//aspNetCounterSample, aspNetPerfCounter.NextSample()) 
			//	+
		        load =   (int)CounterSample.Calculate(
		                  winLogonCounterSample, winLogonPerfCounter.NextSample()) 
				+
		          (int)CounterSample.Calculate(
		                  IECounterSample, IEPerfCounter.NextSample()) ;
		}
		catch (Exception e)
		{			logTimeStamp(e.ToString());	}
		return load;
	}

	/*
	* Get total load on the CPU.
	*/
	private int getTotalLoad()
	{
		int totalload = 50;
		try 
		{
			totalload = (int)CounterSample.Calculate(
				totalLoadCounterSample, totalLoadPerfCounter.NextSample()) ;
		}
		catch (Exception e)
		{			logTimeStamp(e.ToString());	}
		return totalload;
	}
	
	/*
	* Set value indicating how many problems the client can take based on the CPULoad.
	*/
	private void setLoadValue()
	{
		int ourLoad   = calculateCPULoad();
		int totalLoad  = getTotalLoad();
		if (totalLoad < OPTIMUM_LOAD) 
		{
			functions.addElement("cpuLoad", MORE_PROBLEMS);
			//resultObject.cpuLoad = MORE_PROBLEMS;
		}
		else 
		{
			if (ourLoad  < (0.75 * totalLoad))
			{
				functions.addElement("cpuLoad", LESS_PROBLEMS);
				//resultObject.cpuLoad = LESS_PROBLEMS;
			}
			else
			{
				functions.addElement("cpuLoad", SAME_PROBLEMS);
				//resultObject.cpuLoad = SAME_PROBLEMS;
			}
		}
	}
	
	/*
	* Create object dynamically by loading Assembly from DLL File
	*/
	private Object getObjectFromAssembly(String DLLFileNameWithPath)
	{
		try
		{
			Assembly Assem = Assembly.LoadFrom(DLLFileNameWithPath);													
			setType(getAssemblyType(Assem));
			//message +="After loading assembly in client: "+Assem.GetType(classType, true);	
			return Activator.CreateInstance(this.getType());
		}
		catch(Exception e)
		{
			//form.showMessage("getobjfromassembly : dllnamewithpath : "+ DLLFileNameWithPath + " classtype = " + classType);
			form.showMessage("getobjectfromassembly: "+e.ToString());
			return null;
		}
	}

	/*
	* Call method to get some work from the server.
	*/
	public String DoWorkForServer()
	{
		//form.showMessage("first");
		initCounter();
		Console.WriteLine("Before Creating new service:");
		service csahService =  new service();
		Console.WriteLine("Created new service:");
		CommObject sourceObject = csahService.sendClassForWork();
		Console.WriteLine("called send classfor work");		
		CommObjectFunctions fns1 = new CommObjectFunctions();
		fns1.setHashtable(sourceObject.parameterList);
		message += "@@ AFTER CALLING sendClassForWork---"+fns1.toString()+"@@";
		sourceObject = doClientWork(sourceObject);
		
		message += csahService.takeResult(sourceObject);
		message += sourceObject.displayStr;
		CommObjectFunctions fns = new CommObjectFunctions();
		fns.setHashtable(sourceObject.parameterList);

		message += "#####------"+fns.toString()+"##";	
		//return message;			
		return "Completed a unit of work.";
	}

//	private object getArrayItem(ArrayList list, int index)
//	{
//		object[] objarr = list.ToArray();
//		return objarr[index];
//	}


	/*
	* Validate values returned from server.
	*/
	private void checkFunctions(CommObjectFunctions functions)
	{
		if (functions.getElement("appName") == null)
			throw new Exception("appName is null");
		if ( (functions.getElement("errMsg") != null) && (!functions.getElement("errMsg").Equals("")) )
			throw new Exception("errMsg is not null"+functions.getElement("errMsg"));

		if (functions.getElement("problemList") == null)
			throw new Exception("No problems returned by the server.");
		else {
			
		Object[] prob = (Object[])functions.getElement("problemList");
		if ((int)prob[START_PROB] < 0)
			throw new Exception("Start Problem <= 0");
		if ((int)prob[NO_OF_PROBS] < 0)
			throw new Exception("No of Problems <= 0");

		}

		if (functions.getElement("appName") == null || functions.getElement("appName").Equals("")) 
			//throw new Exception("No Application dll name received");
			form.showMessage("You have finished the work.");
	}

	private ArrayList getArrayList(Object[] objarr)
	{
		ArrayList list = new ArrayList();
		for(int i=0; i<objarr.Length; i++)
		{
			list.Add(objarr[i]);	
		}
		return list;
	}

	private Type getAssemblyType(Assembly Assem)
	{
		foreach(Type t in Assem.GetTypes())
		{
			Type [] Interfaces = t.GetInterfaces();       
			if (Interfaces.Length != 0) 
			{
				foreach (Type NextInterface in Interfaces)     
				{       
					logTimeStamp(t.FullName);
					if (NextInterface.FullName == "IAppInterface")
					{
						return t;
					}
				}
			}
		}
		return null;
	}

	/*
	* Call the startUp method in the DLL to do work.
	*/
	public CommObject doClientWork(CommObject sourceObject)
	{
		//logTimeStamp("in do client work:");
		functions  =  new CommObjectFunctions();
		//logTimeStamp("new commobjfunctions");
		functions.setHashtable(sourceObject.parameterList);
		
		if (functions != null)
			message += "In DoClientWork() - " + functions.toString();
		
		checkFunctions(functions);
		
		Object[] currProblem = (Object[])functions.getElement("problemList");
		logTimeStamp("start prob no = " + (int)currProblem[START_PROB] + " no of probs = " + (int)currProblem[NO_OF_PROBS]);

		//ClientInIE.progressBar.Maximum = (int)currProblem[NO_OF_PROBS];

		if (ClientInIE.progressBar.Value == ClientInIE.progressBar.Maximum)
		{
			ClientInIE.progressBar.Value = ClientInIE.progressBar.Minimum;
		}

		//To show increment for eigen in progress bar, reset max to 10
		//else it is always 1
		//if (ClientInIE.progressBar.Maximum == 1)
		//{
		//	ClientInIE.progressBar.Maximum = 10;
			//ClientInIE.progressBar.Value = 1;
		//}
	
		String FileNameWithPath = (String)functions.getElement("appName");
		logTimeStamp("file name " + FileNameWithPath);
		//String classType = extractDLLNameFromPath(FileNameWithPath);
		String DLLFileNameWithPath = constructDLLFileNameFromStatusFileName(FileNameWithPath);
		//Object workObject = getObjectFromAssembly(DLLFileNameWithPath, classType);
		Object workObject = getObjectFromAssembly(DLLFileNameWithPath);
		
		Object[] args = null;
		for(int counter = (int)currProblem[START_PROB]; 
			counter < (int)currProblem[START_PROB] + (int)currProblem[NO_OF_PROBS]; 
			++counter)
		{
			//Problem tempProb = new Problem();
			args 	  = new Object[2];
			//eigen expects an arraylist, so convert object[] to arraylist
			args[0]   = getArrayList(currProblem);
			args[1]   = counter;
				
			invokeMethod(workObject, args, "setProblem", "int");
	
			invokeMethod(workObject, null, "startUp", "String");
			ClientInIE.progressBar.PerformStep();
		}
		message += "**********after for loop";
		//ClientInIE.progressBar.PerformStep();
		
		MemoryStream stream = serializeObject(workObject); 
		functions.addElement("serArr",stream.ToArray()); 
		setLoadValue(); 
		sourceObject.parameterList = functions.getObjectArrayList(); 
		return sourceObject;
	}
	
	private void logTimeStamp(String msg)
	{
		try{

		StreamWriter sr;
		if (File.Exists("c:\\clientlogfile.txt") == false) {
			sr = File.CreateText("c:\\clientlogfile.txt");

			sr.WriteLine(msg);
			//sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
		else {
			
			sr = File.AppendText("c:\\clientlogfile.txt");
			sr.WriteLine(msg);
		//	sr.WriteLine (DateTime.Now.ToLongTimeString() + ": " + DateTime.Now.Second + ":" + DateTime.Now.Millisecond);
			sr.Flush();
        		sr.Close();
		
		}
	        
		}
		catch (Exception e)
		{
			Console.Write(e.ToString());
			//fail silently
		}
	}

	/*
	* Call method to get some work from the server, return results to the server and do more
	* work until there is no more work at the server.
	*/
	public void Run()
	{
		try{
			initCounter();
		}
		catch(Exception ex)
		{
			form.showMessage(ex.ToString());
		}
		

		try
		{
						
			logTimeStamp("out of init counter");
			service csahService =  new service();
			logTimeStamp("after new service");
			DateTime startTime = DateTime.Now;
			CommObject sourceObject = csahService.sendClassForWork();
			//TimeSpan ts = DateTime.Now.Subtract(startTime);
			//logTimeStamp("initial send class for work " + ts.TotalMilliseconds);
			if ( sourceObject == null)
			{
				form.showMessage("You have finshed the work.");
				return;
			}

			logTimeStamp("out of init counter");
			sourceObject = doClientWork(sourceObject);
			logTimeStamp("out of doclientwork");
			message += "\n*******************\n";
			while(true)
			{
				//startTime = DateTime.Now;

				sourceObject = csahService.takeResultGenerateWork(sourceObject);
				//ts = DateTime.Now.Subtract(startTime);
				//logTimeStamp("take result generate work " + ts.TotalMilliseconds);

				
				if(sourceObject == null) logTimeStamp("source object is null");
				message += sourceObject.displayStr;
				CommObjectFunctions fns = new CommObjectFunctions();
				
				fns.setHashtable(sourceObject.parameterList);

				checkFunctions(fns);

				sourceObject = doClientWork(sourceObject);		
				// Reset message
				message = "";

				// check if thread is cancelled
            			if ( m_EventStopThread.WaitOne(0, true) )
                		{
		                	// inform main thread that this thread stopped
	                    		m_EventThreadStopped.Set();
					ClientInIE.progressBar.Visible = false;
				        //return;
					break;
					
                		}
			} //while true loop

			// Make synchronous call to main form
            		// to inform it that thread finished
            		form.Invoke(form.m_DelegateThreadFinished, null);
		}
		catch (System.NullReferenceException ex)
		{
			logTimeStamp(ex.ToString());
			form.showMessage("You have finished the work.");
		}
		catch(Exception e)
		{
			logTimeStamp("exception in try " + e.Message);
			form.showMessage(e.ToString());		
		}
		
	}
}

}