    using System;
    using System.IO;
    using System.Web;
    using System.Web.UI;
    using System.Web.UI.WebControls;
    using nsService;
    using System.ComponentModel;
    using System.Windows.Forms;
    using System.Drawing;
    using System.Threading;

    namespace WorkerThread
    {

    public class ClientInIE : System.Windows.Forms.UserControl {

	public delegate void DelegateThreadFinished();

	// worker thread
    	Thread m_WorkerThread;

    	// events used to stop worker thread
    	ManualResetEvent m_EventStopThread;
    	ManualResetEvent m_EventThreadStopped;
	public DelegateThreadFinished m_DelegateThreadFinished;

	private System.ComponentModel.Container components = null;
	private System.Windows.Forms.Panel panel;
	public static System.Windows.Forms.ProgressBar progressBar;
  	private System.Windows.Forms.Label message;
	private System.Windows.Forms.Button button, adaptiveButton, stopButton, stopNowButton;
	private System.Windows.Forms.ToolTip toolTip;

	public ClientInIE()
	{
		InitializeComponent();
	    	// initialize events
	    	m_DelegateThreadFinished = new DelegateThreadFinished(this.ThreadFinished);
        		m_EventStopThread = new ManualResetEvent(false);
        		m_EventThreadStopped = new ManualResetEvent(false);
	}

    	protected override void Dispose( bool disposing )
    	{
       		if( disposing )
       		{
       			if( components != null )
                		components.Dispose();
           	}
            	base.Dispose( disposing );
		showMessage("Hey, am disposing");
		
    	}

	/*
	**************************************************************************
	* Functions to set attributes on the buttons used in the form - Begin
	**************************************************************************
	*/
	private void setSize(System.Windows.Forms.Button button, int length, int width)
	{
		button.Size =new System.Drawing.Size (length, width);	
	}

	private void setText(System.Windows.Forms.Button button, String text)
	{
		button.Text = text;
	}
	
	private void setStyle(System.Windows.Forms.Button button, FlatStyle style)
	{
		button.FlatStyle = style;
	}
	
	private void setHandler(System.Windows.Forms.Button button, System.EventHandler handler)
	{
		button.Click += handler;
	}
	
	private void setLocation(System.Windows.Forms.Button button, int xcoord, int ycoord)
	{
		button.Location = new System.Drawing.Point(xcoord, ycoord);
	}

	private void setColor(System.Windows.Forms.Button button, System.Drawing.Color foreColor, System.Drawing.Color backColor)
	{
		button.ForeColor = foreColor;
		button.BackColor = backColor;
	}
	/*
	**************************************************************************
	* Functions to set attributes on the buttons used in the form - End
	**************************************************************************
	*/

	public void InitializeComponent()
	{
		this.panel = new System.Windows.Forms.Panel();
		this.panel.Name = "CSAH panel";
	        	this.panel.Size = new System.Drawing.Size(400, 300);
	 	this.panel.TabIndex = 1;
		this.panel.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;

		progressBar = new System.Windows.Forms.ProgressBar();
		progressBar.Location = new System.Drawing.Point(100, 125);
		progressBar.Width = 200;
		progressBar.Name = "progressBar";
		progressBar.TabIndex = 0;
		progressBar.Visible = false;
		progressBar.Value = 1;
		progressBar.Step = 1;
		progressBar.Minimum = 0;
		progressBar.Maximum = 200;
		
		toolTip = new ToolTip();

		button = new System.Windows.Forms.Button();
		setLocation(button, 80, 50);
	  	setSize(button, 100, 50);
		setText(button, "Do work");
		setStyle(button, FlatStyle.Popup);
		setHandler(button, new System.EventHandler(buttonClick));
		setColor(button, Color.White, Color.CornflowerBlue);
		toolTip.SetToolTip(button, "Download a unit of work from the server");
		//button.Paint += new System.Windows.Forms.PaintEventHandler(button_Paint); 

		adaptiveButton = new System.Windows.Forms.Button();
		setLocation(adaptiveButton, 210, 50);
	  	setSize(adaptiveButton, 100, 50);
		setText(adaptiveButton, "(Adaptive)Do work");
		setStyle(adaptiveButton, FlatStyle.Popup);
		setHandler(adaptiveButton, new System.EventHandler(adaptiveButtonClick));
		setColor(adaptiveButton, Color.Blue, Color.White);
		toolTip.SetToolTip(adaptiveButton, "Download a unit of work from the server, based on my CPU load");
		
		stopButton = new System.Windows.Forms.Button();
		setLocation(stopButton, 80, 200);
	  	setSize(stopButton, 100, 50);
		setText(stopButton, "Stop process");
		setStyle(stopButton, FlatStyle.Popup);
		setHandler(stopButton, new System.EventHandler(stopButtonClick));
		setColor(stopButton, Color.Green, Color.LightYellow);
		toolTip.SetToolTip(stopButton, "Stop computing after completing current unit of work");

		stopNowButton = new System.Windows.Forms.Button();
		setLocation(stopNowButton, 210, 200);
	  	setSize( stopNowButton, 100, 50);
		setText(stopNowButton, "Stop process Now");
		setStyle(stopNowButton, FlatStyle.Popup);
		setHandler(stopNowButton, new System.EventHandler(stopNowButtonClick));
		setColor(stopNowButton, Color.Black, Color.PaleGreen);
		toolTip.SetToolTip(stopNowButton, "Stop computing Immediately (without saving)");

		message = new System.Windows.Forms.Label();
		message.Location = new System.Drawing.Point(0,50);
		message.Size = new System.Drawing.Size (150, 50);
	   
	    	//Always set the Size of the Control or you will get unexpected results!!
		this.panel.Controls.AddRange(new System.Windows.Forms.Control[] 
			{this.button, this.adaptiveButton, this.message,this.stopButton, this.stopNowButton, progressBar});
	        
		this.Size =new System.Drawing.Size (400, 300);
 	       	this.BackColor = System.Drawing.Color.Lavender;

         		//Add the controls 
	       	this.Controls.Add(panel);
	}



	

	/*
	* "DoWork" Button Event Handler
	*/
	protected void buttonClick(object sender, EventArgs e)
	{
		Refresh();
		ServerInteractionClass serverInteractionClass = new ServerInteractionClass();
		MessageBox.Show(serverInteractionClass.DoWorkForServer());
	}

	/*
	* "AdaptiveDoWork" Button Event Handler
	*/
	protected void adaptiveButtonClick(object sender, EventArgs e)
	{
//		DateTime startTime = DateTime.Now;
        	Refresh();
		
		progressBar.Visible = true;
		// reset events
        		m_EventStopThread.Reset();
       		m_EventThreadStopped.Reset();

        		// create worker thread instance
        		m_WorkerThread = new Thread(new ThreadStart(this.WorkerThreadFunction));

        		m_WorkerThread.Name = "Worker Thread Sample";   // looks nice in Output window

        		m_WorkerThread.Start();
   	}

	/*
	* "StopWork" Button Event Handler
	*/
	protected void stopButtonClick(object sender, EventArgs e)
	{
    		StopThread();
	}
	
	/*
	* "StopWorkNow" Button Event Handler
	*/
	protected void stopNowButtonClick(object sender, EventArgs e) 
	{
		try
		{
			m_WorkerThread.Abort();
		}
		catch (Exception excep)
		{showMessage("Stopped doing work.");
			Console.WriteLine(excep.ToString());
		}
//		Application.Exit();
	}

	/*
	* Worker thread function.
    	* Called indirectly from adaptiveButtonClick
	*/
    	private void WorkerThreadFunction()
    	{
       		stopButton.Enabled = true;
       		ServerInteractionClass serverInteractionClass;
       		serverInteractionClass = new ServerInteractionClass(m_EventStopThread, m_EventThreadStopped, this);
       		serverInteractionClass.Run();
       		//MessageBox.Show("work over");
		progressBar.Visible = false;
    	}

	/*
 	*Stop worker thread if it is running.
    	*Called when user presses Stop button or form is closed.
	*/
    	public void StopThread()
    	{
        		if ( m_WorkerThread != null  &&  m_WorkerThread.IsAlive )  // thread is active
        		{	
        			// set event "Stop"
            			m_EventStopThread.Set();

           			 // wait when thread  will stop or finish
            			while (m_WorkerThread.IsAlive)
            			{
            		                		if ( WaitHandle.WaitAll(
                				(new ManualResetEvent[] {m_EventThreadStopped}), 
                        			100,
                       			 true) )
                    			{
                        				break;
                    			}

                    			Application.DoEvents();
           			 }
          			MessageBox.Show("Stopped doing work.");
        		}
		progressBar.Visible = false;
 	}
	
	/*
	* Set initial state of controls.
    	* Called from worker thread using delegate and Control.Invoke
	*/
   	 private void ThreadFinished()
    	{
        		adaptiveButton.Enabled = true;
        		stopButton.Enabled = false;
   	 }

	public static void Main()
	{
		ClientInIE c = new ClientInIE();

        		// create worker thread instance
        		Thread m_WorkerThread = new Thread(new ThreadStart(c.WorkerThreadFunction));

        		m_WorkerThread.Name = "Worker Thread Sample";   // looks nice in Output window

        		m_WorkerThread.Start();
	}

	/*
	* Controls Progress bar display
	*/
	public void callProgressBarMethod()
	{
		progressBar.PerformStep();
	}

	/*
	* Popup debug messages
	*/					
	public void showMessage(String msg)
	{
		MessageBox.Show(msg);
	}
}

}