#include "bitdriver.h"

void testBitSetOP(u_long index)
{
   u_int i;
   u_long numbef, numaft;
   BitSet *WordSet1;
   BitSet *WordSet2;
   BitSet *Result;

   WordSet1 = CreateBitSet(index, 0);
   WordSet2 = CreateBitSet(index, 0);
   Result = CreateBitSet(index, 0);

   fprintf(stderr, "Flipping ON set 1\n");
   for(i=0;i<index*2/3;i++)
   {
      BitSetCount(WordSet1);
	  numbef = WordSet1->count;
      BitSetFlip(i, WordSet1, ON);
      BitSetCount(WordSet1);
	  numaft = WordSet1->count;
      if(numbef!=numaft-1)
      {
         fprintf(stderr, "Flipping index ON Set 1 %d failed.", i);
      }
   }

   BitSetPrint(WordSet1);

   fprintf(stderr, "Flipping ON set 2\n");
   for(i=index*1/3;i<index;i++)
   {
      BitSetCount(WordSet2);
	  numbef = WordSet2->count;
      BitSetFlip(i, WordSet2, ON);
      BitSetCount(WordSet2);
	  numaft = WordSet2->count;
      if(numbef!=numaft-1)
      {
         fprintf(stderr, "Flipping index ON Set 2 %d failed.", i);
      }
   }

   BitSetPrint(WordSet2);

   fprintf(stderr, "AND\n");
   BitSetOP(Result, WordSet1, WordSet2, AND);
   BitSetCount(Result);
   numaft = Result->count;
   if(numaft != index/3)
   {
      fprintf(stderr, "AND operation failed\n");
      BitSetPrint(Result);
   } 
   fprintf(stderr, "OR\n");
   BitSetOP(Result, WordSet1, WordSet2, OR);
   BitSetCount(Result);
   numaft = Result->count;
   if(numaft != index)
   {
      fprintf(stderr, "OR operation failed\n");
      BitSetPrint(Result);
   } 
   fprintf(stderr, "XOR\n");
   BitSetOP(Result, WordSet1, WordSet2, XOR);
   BitSetCount(Result);
   numaft = Result->count;
   BitSetPrint(WordSet1);
   BitSetPrint(WordSet2);
   BitSetPrint(Result);

}

void testBitSetCount(u_int index)
{
   u_long num=0;
   BitSet *WordSet;

   WordSet = CreateBitSet(index, 0);
 
   WordSet->length[0] = 0x00542e10;
   while(WordSet->length[0]!= 0)
   {
      num = BitSetExtract(WordSet);
      fprintf(stderr, "%ld ", num);
   }
 //  BitSetCount(&num, WordSet);
  
/*
   for(cnt=0;cnt<index;cnt++)
   {
      BitSetFlip(cnt, WordSet, ON);
      BitSetCount(&num, WordSet);
      if(cnt!=num-1)
      {
         fprintf(stderr, "error index=%ld numofbits=%ld\n", cnt, num);
      }
   }

   for(cnt=index;cnt>0;cnt--)
   {
      BitSetCount(&num, WordSet);
      BitSetFlip(cnt-1, WordSet, OFF);
      if(cnt!=num)
      {
         fprintf(stderr, "error index=%ld numofbits=%ld\n", cnt-1, num);
      }
   }
*/
}

void testBitSetPrint(u_long index)
{
   BitSet *WordSet;
   u_long cnt;

   WordSet = CreateBitSet(index, 0);

   for(cnt=0;cnt<index;cnt++)
   {
      BitSetFlip(cnt, WordSet, ON);
      fprintf(stderr, "%ld ", cnt);
      BitSetPrint(WordSet);
   }
   fprintf(stderr, "\n");

   for(cnt=index;cnt>0;cnt--)
   {
      BitSetFlip(cnt-1, WordSet, OFF);
      fprintf(stderr, "%ld ", cnt-1);
      BitSetPrint(WordSet);
   }
}

void testBitSetFlip(u_long index)
{
   u_int i;
   BitSet *WordSet;
   u_long numbef, numaft;

   WordSet = CreateBitSet(index, 0);

   fprintf(stderr, "Flipping ON\n");
   for(i=0;i<index;i++)
   {
      BitSetCount(WordSet);
      numbef = WordSet->count;
      BitSetFlip(i, WordSet, ON);
      BitSetCount(WordSet);
      numaft = WordSet->count;
      if(numbef!=numaft-1)
      {
         fprintf(stderr, "Flipping index ON %d failed.", i);
      }
   }

   fprintf(stderr, "Flipping OFF\n");
   for(i=0;i<index/2;i++)
   {
      BitSetCount(WordSet);
      numbef = WordSet->count;
      BitSetFlip(i, WordSet, OFF);
      BitSetCount(WordSet);
      numaft = WordSet->count;
      if(numbef!=numaft+1)
      {
         fprintf(stderr, "Flipping index OFF %d failed.", i);
      }
   }

   fprintf(stderr, "Toggle ON\n");
   for(i=0;i<index/2;i++)
   {
      BitSetCount(WordSet);
      numbef = WordSet->count;
      BitSetFlip(i, WordSet, TOGGLE);
      BitSetCount(WordSet);
      numaft = WordSet->count;
      if(numbef!=numaft-1)
      {
         fprintf(stderr, "Flipping index TOGGLE ON %d failed.", i);
      }
   }

   fprintf(stderr, "Toggle OFF\n");
   for(i=index/2;i<index;i++)
   {
      BitSetCount(WordSet);
      numbef = WordSet->count;
      BitSetFlip(i, WordSet, TOGGLE);
      BitSetCount(WordSet);
      numaft = WordSet->count;
      if(numbef!=numaft+1)
      {
         fprintf(stderr, "Flipping index TOGGLE OFF %d failed.", i);
      }
   }
}

int main(int argc, char **argv)
{
   if(argc!=3) 
   {
      fprintf(stderr, "Invalid number of arguments.");
      exit(1);
   }

   switch (atoi(argv[2]))
   {
      case 1:
         testBitSetCount(atoi(argv[1]));
         break;
      case 2:
         testBitSetPrint(atoi(argv[1]));
         break;
      case 3:
         testBitSetFlip(atoi(argv[1]));
         break;
      case 4:
         testBitSetOP(atoi(argv[1]));
         break;
      default:
         fprintf(stderr,"Invalid mode");
         exit(1);
         break;
   }

   return 1;
}
