#ifndef __ALSAD_STREAM_LIST_H
#define __ALSAD_STREAM_LIST_H


/** \addtogroup stream_list */
/** @{*/
 
/*! \file alsad_stream_list.h
*   \brief This is the header for the Stream-List Library
*   \author Daniel R. Warren
*   \version 1.0
*   \date    November 2004
*/



#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include "circ_buff.h"
#include "alsad_net_lib.h"
#include "alsad_shared_lib.h"
#include "alsad_data_pipe_list.h"


struct alsad_stream_node{
   int closing;
   alsad_stream_props_t *stream_props;
   circ_buff_t *audio_circ_buff;
   alsad_data_pipe_list_t sources;
   alsad_data_pipe_list_t sinks;
};

typedef struct alsad_stream_node alsad_stream_node_t;


struct alsad_stream_list{
   int shutdown;
   linked_list_t *streams;
};

typedef struct alsad_stream_list alsad_stream_list_t;


struct alsad_send_stream_list_args{
  int sock;
};

typedef struct alsad_send_stream_list_args alsad_send_stream_list_args_t;

int alsad_stream_list_init(alsad_stream_list_t *new_list,
                                               unsigned int num_streams);

void alsad_stream_list_destroy(alsad_stream_list_t *destroy_list);

int alsad_stream_node_init(alsad_stream_node_t **new_stream_node, 
		alsad_stream_props_t *new_chan, 
		alsad_config_keys_t *keys);

void alsad_stream_node_destroy(alsad_stream_node_t *destroy_chan);
	
alsad_stream_node_t *alsad_stream_list_insert(
		             alsad_stream_list_t *head_of_list,
	                     alsad_stream_node_t *new_chan_node);

alsad_stream_node_t* alsad_stream_list_remove(
		             alsad_stream_list_t *head_of_list,
			     unsigned int ident);

alsad_stream_node_t *alsad_stream_list_find(alsad_stream_list_t *head_of_list,
	        	unsigned int ident);

//Leaving out until I know if I need it
//void alsad_print_stream_list(alsad_stream_list_t *head_of_list);

int alsad_stream_list_send(int sock, alsad_stream_list_t *head_of_list);

int alsad_stream_list_send_pipes(int sock, alsad_stream_list_t *list,
                                                   unsigned int ident);
int alsad_stream_node_compare(void *identifier, void *stream_node);

int alsad_stream_send_stream_nodes(void *stream_node, void *args);


/** @}*/

#endif
