#ifndef __ALSAD_DATA_PIPE_LIST_H
#define __ALSAD_DATA_PIPE_LIST_H

/** \addtogroup data_pipe_list */
/** @{*/
 
/*! \file alsad_data_pipe_list.h
*   \brief This is the header for the Data-Pipe List Library
*   \author Daniel R. Warren
*   \version 1.0
*   \date    November 2004
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include "alsad_net_lib.h"
#include "linked_list.h"


struct alsad_data_pipe_node{
   int closing;
   unsigned long long thread_byte_id;
   alsad_data_pipe_t *pipe;
};

typedef struct alsad_data_pipe_node alsad_data_pipe_node_t;


struct alsad_data_pipe_list{
   linked_list_t *pipe_list;
};

typedef struct alsad_data_pipe_list alsad_data_pipe_list_t;


struct alsad_data_pipe_list_send_args{
  int sock;
  int code;
};

typedef struct alsad_data_pipe_list_send_args alsad_data_pipe_list_send_args_t;


int alsad_data_pipe_list_init(alsad_data_pipe_list_t *new_list,
                                               unsigned int num_data_pipes);

void alsad_data_pipe_list_destroy(alsad_data_pipe_list_t *destroy_list);

int alsad_data_pipe_node_init(alsad_data_pipe_node_t **new_data_pipe_node,
                                 alsad_data_pipe_t *new_data_pipe);

void alsad_data_pipe_node_destroy(alsad_data_pipe_node_t *destroy_pipe_node);
                    
alsad_data_pipe_node_t *alsad_data_pipe_list_insert(
                                         alsad_data_pipe_list_t *list,
                                         alsad_data_pipe_node_t *new_node);


alsad_data_pipe_node_t* alsad_data_pipe_list_remove(
                                            alsad_data_pipe_list_t *list,
                                            unsigned int ident);
              
alsad_data_pipe_node_t *alsad_data_pipe_list_find(alsad_data_pipe_list_t *list,
            unsigned int ident);
            

unsigned long alsad_data_pipe_find_slowest(alsad_data_pipe_list_t *list,
            unsigned long global_byte_id);

              
int alsad_data_pipe_list_send(int sock, alsad_data_pipe_list_t *list, int code);
  
int alsad_data_pipe_node_send_pipe(void *data_pipe, void *args);

int alsad_data_pipe_node_compare_equal(void *identifier, void *data_pipe_node);

int alsad_data_pipe_node_compare_greater_than(void *data_pipe_node_a,
                                              void *data_pipe_node_b,
                                              void *args);

/** @}*/

 
#endif
