% codes used in this table
% /P: preposition
% /A: adjective
% /Kstem: adjective, takes comparitive and superlative, based on
% the known stem or the given one, if present.
% /Iending: adjective based on the known stem, given ending
% /N: noun, plural in -n
% /S: noun, plural in -s
% /Eending: the stem + the ending gives a valid form
% /C: proper noun, takes dative
% /Dstem: form diminutives on the known stem or the given one, if present.
% /V: verb based on the known stem
% /T: verb participle ends in -t based on the known stem
% /Bform: verb participle has the given form
% /Gcomplement: the verb takes the given adverbial complement
% /H: the word needs spelling attention, usually because it is Hebrew.
% {my spelling code}: the proper spelling of this word or fragment; use ~ for space
% /Lprefix: the known stem takes the given prefix
% /-form: the given form, which might get generated, is spurious
% GYD: German-Yiddish Dictionary
% V: suggestion from "vi men zogt es oyf yidish"
% Y: from YIVO
% use u02bc (ʼ) for internal quote marks.
% genders: m masc; f fem; n neut; d number
% Copyright © Raphael Finkel 2007-2010 raphael@cs.uky.edu  
% <a rel="license" href="http://creativecommons.org/licenses/by-nc/3.0/us/"><img alt="Creative Commons License" style="border-width:0"
% src="http://i.creativecommons.org/l/by-nc/3.0/us/88x31.png" /></a><br /><span xmlns:dc="http://purl.org/dc/elements/1.1/" href="http://purl.org/dc/dcmitype/Text" property="dc:title"
% rel="dc:type">Yiddish word list</span> by <span xmlns:cc="http://creativecommons.org/ns#" property="cc:attributionName">Raphael Finkel</span> is licensed under a <a
% rel="license" href="http://creativecommons.org/licenses/by-nc/3.0/us/">Creative Commons Attribution-Noncommercial 3.0 United States License</a>.

% ordinary Yiddish words

a/P [article] [def: a]
a/Een [m] [def: the letter A] 
abazhu'r [m] [def: lampshade] /D
abi [conj] [def: if only]
aboni'r/V/Baboni'rt [def: subscribe] abone'nt/N [m] [def: subscriber]
	abonement/N [m] [def: subscription]
	abonament/N [m] [def: subscription] [usage: not recommended]
abort/N [m] [def: abortion]
absolut/A [def: absolute]
abstrakt/A [def: abstract] abstraktsye/S [f] [def: abstraction]
absu'rd/N [m] [def: absurdity] /A [def: absurd] 
ad{ed}/H [prep] [def: until] adayem{ed-hywm}/H [def: until today]
adadzhyo [adv] [def: adagio (music)] % Stutchkoff
adapti'r/V/Badapti'rt [def: adapt]
	adaptirer/S [m] [def: adapter]
	adaptatsye/S [f] [def: adaptation]
adar{adr}/H [m] [def: month of Adar]
adayem{ed-hywm}/H [adv] [def: until today]
adekva't/N [m] [def: equivalent] % Forwards: Hershl Glaser
	umadekva't/A [def: inadequate] % Forwards
a'derabe{adrb#}/H [def: on the contrary; you're welcome; of course]
adir{adir}/Xadirem{adyrym} [m] [def: wealthy person] 
aditsye [f] [def: addition (mathematics)] % Stutchkoff
adl [m] [def: nobility] /Iik [def: noble] 
administi'r/V/Badministi'rt [def: manage; administer] [def: manage; administer]
	administratsye/S [f] [def: administration; management] 
	administrati'v/A [def: administrative]
	administrato'r/N [m] [def: administrator; manager]
admira'l/N [m] admiralshe/S [f] [def: admiral] 
adopti'r/V/Badopti'rt [def: adopt] 
adoyn{adwn}/Xadoynem{adwnym}/H adoynis{adwnyT}/N [f] [def: important (usually non-Jewish) person]
	adoyni{adwny}/H [def: Mister]
adrenal/A [def: adrenal (physiology)]
	adrenali'n [m] [def: adrenalin]
adres/N [m] [def: address] vebadres/N
	adresi'r/V/Badresi'rt [def: address] 
		zikh-adresirt/A [def: self-addressed] 
adventi'st/N [m] [def: Adventist (with "zibn togiker")]
adverb/N [m] [def: adverb]
advoka't/N [m] advokatke/S [f] [def: lawyer]
	farteydik-advoka't/N [m] [def: defense attorney]
	[idiom: dem ruekhs{rwHs} advokat = devil's advocate] [note: V]
adye [def: adieu]
adyektiv/N [m] [def: adjective]
adyuta'nt/N [m] [def: aide, adjutant]
ae'rodrom/N [m] [def: airport] 
afe'r [adv] [def: out from below] [usage: Polish Yiddish; used as adverbial complement]
afere/S [f] [def: affair, love affair] 
afi'd/N [m] [def: aphid (insect)]
afi'ks/N [m] [def: affix (grammatical)]
afikoymen{afikwmn}/H/S [m] [def: afikomen (matsoh eaten at end of Passover seder)] 
afile{afylw}/H [def: even, only]
afilii'r/V/Bafilii'rt [def: affiliate] % Forwards: Yoel Matveyev
afi'r/N [m] afo'r/N [m] [def: handwriting model; stitching pattern]
afish/N [m/f] [def: poster] [note: Weinreich says m, GYD says f]
afrikans [noun] [def: Afrikaans (language)] 
age'nt/N [m] [def: agent]
	agentsye/S [f] agentu'r/N [f] age'nts/N [f] [def: agency] 
		veter-agentu'r/N [f] [def: weather service] % Yiddish League
	pirsem{pyrswm}-age'nt/N [m] [def: publicity agent] 
agev{agB}/H [def: by the way]
	derekh_agev{drx-agB} [def: by the way]
agitatsye/S [f] [def: agitation] 
	agitator/S [m] [def: agitator]
agmes{egmwT}/H [def: sorrow]
agnostiker/S [m] [def: agnostic]
agole{eglh}/Xagoles{eglwT}/H [f] [def: horse-drawn wagon; hearse (Jewish)]
	balegole/Xbalegoles [m] /Ish [def: wagoneer, coachman]
	balegole{bel-eglh}/Xbalegoles_{bel-eglwT}/H [m] [def: wagoneer, coachman]
	balegoletshik{bel-eglhtshik}/H/Ees [m] [def: wagon driver]
agrafke/S [f] [def: safety pin] % Mendl Man
a'gres/X/N [m] [def: gooseberry] 
agresye/S [f] [def: aggression] 
	agresor/N [m] [def: aggressor]
	agresi'v/A [def: aggressive; pushy] agresivkayt/N [f] [def: aggressiveness] 
agrikultu'r [f] [def: agriculture]
	agrar- [prefix] [def: agricultural]
	agrono'm/N [m] [def: agriculturist, agronomist]
agune{egwnh}/Xagunes{egwnwT}/H [f] [def: deserted wife]
aha [interj] [def: aha! expression of justification]
ahave{ahBh}/H [f] [def: love] ahavas{ahBT}/H [def: love of]
	ahavas_yisroel{ahBT-yQr#l} [def: love of fellow-Jews] 
	beahave{bahBh} [adv] [def: with love]
aher [adv] ahertsu [adv] ahertsutsu [adv] [def: hither]
	ahin [adv] ahintsu [adv] ahintsutsu [adv] vuahin [adv] [def: thither]
	hinherik/A [def: zig-zag]
	bizaherik/A [def: previous, former; preceding]
air [m] [def: reeds (plant)]
akadish{aKdish}/A [def: Akkadian (language)] % Stutchkoff
akademye/S [f] [def: academy; meeting, convention, conference]
	akademish/A [def: academic]
	akademiker/S [m] [def: academician] % Forwards
akatsye/S [f] [def: acacia (tree)]
aker/V/T [def: plow] /Gadurkh/Garayn
	faraker/V/Bfarakert [def: plow]
	tseaker/V/Btseakert [def: plow]
	aker/S [m] [def: plow]
	akerer/S [m] [def: plowman]
aker/S [m] [def: acre (area)]
akeyde{ekdh}/H [def: binding of Isaac]
akh [interj] [def: ah: expression of disgust or wonder]
akharey{aHry}/H [def: after]
	-/Xakhora'yem{aHrym}/H [m] [def: buttocks] [usage: impolite]
a'khberosh{exbrwS}/Xakhberoshem{exbrwSym}/H [m] [def: prankster; mischievous brat; thief]
akhdes{aHdwT}/H [def: unity]
	lakhodem{l#Hdym} [def: retail] /Idik
		lakhodemnik{l#Hdymnik}/Ees [m] lakhodemnitse{l#Hdymnitse}/S [f] [def: retail buyer]
	yokhed{yHyd}/Xyekhidem{yHydym}/H [m] [def: individual] yekhidish{yHydish}/A
		yekhidey_sgule{yHydy-sgwlh} [def: exceptional people] 
	meyakhed{myHd}/H [verb] [def: separate oneself (with "zikh zayn")]
	yikhed{yiHwd}/Xyekhudem{yiHwdym} [f] [def: separateness; prohibition against being alone with a married woman; meditation on God's oneness (mystic)]
akhes{aHT}/H [def: one]
	yad_akhes{yd-aHT} [def: plan; conspiracy] /Idik
akhl/V/T [def: eat, gorge oneself (humorous)]
	akhler/S [m] [def: heavy eater] 
akhper/V/T [def: honor, venerate] /Idik [def: venerable] /Ilekh [def: reverential]
akhrayes{aHrywT}/N [def: responsibility] /Idik [def: responsible] 
	akhrayesdikayt{aHrywTdikayt}/N [f] [def: responsibility] 
	umakhrayesdik{umaHrywTdik}/A [def: irresponsible] 
	akhrayeslo'zikayt{aHrywTlozikayt}/N [f] [def: irresponsibility] [usage: inadmissible]
akhren{aHrwn}/Xakhroynem{aHrwnym}/H [m] [def: last]
	sitre_akhre{sytr#-aHr#} [m] [def: demonic side of the world (mystic)]
akhsanye{axsny#}/Xakhsanyes{axsnywT}/H [def: inn; shelter] akhsani{axsny}/H [m] [def: innkeeper]
	akhsanik/Ees [m] [def: hotel thief (ganovem-loshn)]
akht/A [d] [def: 8] akhtns [adv] [def: eighth] akhtl/Xakhtlekh [d] [def: 1/8]
	akhtsn [d] [def: 18] akhtsnt/A [def: 18th]
		akhtsntl [d] [def: 1/18]
	akhtsik/A [def: 80] akhtsikst/A [def: 80th]
		akhtsikstl [def: 1/80]
	[idiom: redn fun akhtsn un draytsn = stop pussyfooting around; talk about money]
akhtung/N [f] [def: esteem; attention]
	akht [f] [def: attention]
		a'khtgeber/S [m] a'khtgeberin/S [f] [def: observer]
	farakht/V/Bfarakht [def: hate; despise; consider worthless] /Ilekh
		farakhtung/N [f] [def: contempt]
	[idiom: gebn akht = watch out] % Shpiglblat
	[idiom: nemen in akht = keep in mind] % Stutchkoff
akhzer{axzr}/Xakhzorem{axzrym}/H [m] [def: vicious person; brute] /Iish
	akhzoryes{axzrywT}/N [def: viciousness] /Idik [def: vicious]
akord/N [m] [def: accord; chord (music)]
akordeo'n/N [m] akordyo'n/N [m] [def: accordion (musical instrument)] 
	akordyoni'st/N [m] akordyonistke/S [f] [def: accordionist] 
akore{ekrh}/Xakores{ekrwT}/H [f] [def: barren woman]
akraytshik/Ees [m] akrayets/Xakraytses [m] [def: heel, crust (bread) (Russian край)] /D
	okraytsik/Ees [m] /D % D-H Katz
akroba't [m] [def: acrobat] /Iish [def: acrobatic] 
	akrobatin/S [f] [def: acrobat (female)]
	akrobatik [f] [def: acrobatics (subject)]
aks/N [n] [def: axis; axle] /Iyal [def: axial (chemistry)] 
	umdrey-aks/N [f] [def: rotational axis] 
	igrek-aks/N [f] [def: Y axis (mathematics)] 
	iks-aks/N [f] [def: X axis (mathematics)] 
aksesuar/N [m] [def: accessory]
akshn{ekSn}/Xakshonem{ekSnym} [m] askshnte{ekSnte}/S [f] [def: stubborn person]
	akshn{ekSn}/V/T [def: be stubborn] /Garayn/Gayn
	farakshnt{farekSnt}/A [def: stubborn, tenacious, obstinate]
	akshones{ekSnwT}/H/Idik [def: stubbornness, obstinacy, mulishness]
aksl/X/N [m] [def: shoulder (without the scapula) (body part)] /Dakse
	[idiom: tsien/kvetshn mit di akslen = shrug one's shoulders]
akt/N [m] [def: act]
	eynakter/S [m] [def: one-act play] 
	aktue'l/A [def: actual, real; current]  aktuelkayt/N [f] [def: reality] 
	antra'kt [m?] [def: intermission, entracte]
aktinyum [m] [def: actinium (Ac)] 
aktiv/A [def: active] aktivistish/A
	aktivi'st/N [m] aktivistke/S [f] [def: activist]
	aktivi'zm/N [m] [def: activism]
	aktivite't/N [f] [def: activity]
	aktivi'r/V/Baktivi'rt [def: activate]
		aktivizi'r/V/Baktivizi'rt [def: activate, realize] [usage: inadmissible]
	reakti'v/N [m] [def: reactant, reagant (chemical)]
		reakti'v/A [def: reactive]
	hiperaktivkayt/N [f] [def: hyperactivity] % Forwards
	tsvishnakti'v/A interakti'v/A [def: interactive] % Yiddish League
aktsent/N [m] [def: accent]
	aktsenti'r/V/Baktsenti'rt [def: accent]
aktsepti'r/V/Baktsepti'rt [def: accept]
aktsiden't/N [m?] [def: accident]
aktsi'z/N [m] [def: excise tax] 
	aktsizne [adj indeclinable] [def: excise]
	aktsiznik/Ees [m] [def: tax collector] % Stutchkoff
	aktsi'znitshke/S [f] [def: tax collector's wife] % Sholem Aleykhem
aktsye/S [f] [def: action, stock (financial security)]
	transaktsye/S [f] [def: transaction]
aktyor/N [m] [def: actor] aktyorish/A aktrise/S [f] [def: actress]
akupunkturi'st/N [m] akupunkturistke/S [def: acupuncturist] % Forwards
akurat/A [def: accurate]
	[idiom: mitn akurat = precisely] % Itsik Manger
akushe'r/N [m] akusho'r/N [m] [def: obstetrician (medicine)]
	akusherye [f] [def: obstetrics (medicine)]
	akusherke/S [f] akusherin/S [f] [def: midwife] 
	akusherski [adj indeclinable] [def: midwife]
akustik/N [f] [def: accoustics] akustish/A
akuzativ/A [def: accusative (grammar)]
akuzi'r/V/Bakuzi'rt [def: accuse] akuzatsye/S [f] [def: accusation]
akvar akvaryum [m] [def: aquarium, fish tank]
akvare'l/N [m?] [def: water color (painting)]
akzyome/S [f] [def: axiom] 
alafon/N [m?] [def: allophone (linguistics)] % D-H Katz
alarem/S [m] alarm/S [m] [def: alarm, alert] 
	larem/V/T [def: vociferously object] % Menakhem Kipnis
albanish/A [def: Albanian (language)]
albaster/A [def: alabaster]
albatros/N [m] [def: albatross]
album/N albom/N [m?] [def: album; songbook; picture book]
ale [adj] [def: all]
	ile [adj] [def: all] % southern variant
	aldos [adj] [def: all] [usage: with a neuter noun]
	alts ales alem altsding [def: everything]
	alts [adv] [def: all the more; still, yet; always (Khassidic Yiddish)]
	[idiom: alts +comparative (like neenter) = closer and closer]
	[idiom: nokh alts = still (modal)]
	alemen/S [m] [def: everyone] [usage: dative and accusative only]
		[idiom: nokh alemen = all finished; after death (euphamism)]
		[idiom: mit alemen = healthy; sane]
		[idiom: nit mit alemen = slightly unwell]
	al alde aldem aldi [def: all the]
	a'lerley [def: all sorts of]
alee/S [f] [def: alley, street]
alef{alf}/H [def: Hebrew letter Alef] alefbeyz{alf-byT}/H alfabet [def: alphabet]
	alfabetish/A [def: literate]
	analfabet/N [m] [def: illiterate person; ignoramus] /Iish
		analfabeti'zm [m] [def: illiteracy]
alegorye/S [f] [def: allegory] alegorish/A [def: allegorical]
alegro [adv] [def: allegro (music)] % Stutchkoff
alembik/S [n] [def: still, alembic]
alergye/S [f] [def: sensitivity; alergy] alergish/A [def: sensitive]
aleykhem{elyxm}/H/C [def: to you]
	[idiom: sholem{Slwm} aleykhem{elyxm} = hello (first speaker)] % with a handshake
	[idiom: aleykhem{elyxm} sholem{Slwm} = hello (second speaker)]
aleyn [def: oneself (with a personal pronoun), only]
	aleyns [adv] [def: only] aleynkayt/N [f] [def: solitude]
alfabetish/A [def: literate] umalfabetish/A [def: illiterate]
alfons/N [m] [def: pimp] 
algebre [f?] [def: algebra]
	algebraish/A algebrish/A [def: algebraic]
	algebrist/N [m] [def: algebraist]
algemeyn/A [def: general] algemeynkayt/N [f] [def: generality]
	algemeynerung/N [f] [def: generalization] 
	faralgemeyner/V/Bfaralgemeynert [def: generalize]
algori'tm/N [m] [def: algorithm] % Forwards: Yoel Matveyev 
aligator/N [m] [def: alligator]
alii'r/V/Balii'rt [def: ally]
	alya'nts/N [f] [def: alliance, coalition]
	alya'nt/N [m] [def: ally]
alimentn [noun] [def: alimony] 
aliye{elyh}/Xaliyes{elywT}/H [f] [def: rise, immigration, Torah honor]
	shir_hamayles{Syr-hmelwT}/H/N [m] [def: song of ascents; Psalm]
	mayle{melh}/Xmayles{melwT}/H [f] [def: advantage]
		lemayle{lmelh} [adv] [def: above]
	[idiom: khapn di ershte aliye{elyh} = grab priority] [note: V]
	[idiom: shel-mayle{Sl-melh} = heavenly]
alker/S/N [m] /D [def: niche, alcove]
alakhsn{alxswn}/S [m] [def: diagonal, slant]
alkn/S [def: ??]
alkoho'l [m] [def: alcohol (chemical)] /Iish [def: alcoholic] 
	alkoho'liker/S [m] [def: alcoholic]
	alkoholi'zm/N [m] [def: alcoholism (disease)] % Forwards: Yoel Matveyev 
alkov/N [m] alkove/S [f] [def: bedroom]
almana'kh/N [m] [def: almanac]
almemer/S [m] balemer/S [m] [def: lectern for a holy book]
almen{almn}/H/S [m] [def: widower]
	almone{almnh}/Xalmones{almnwT}/H [f] [def: widow]
		almoneshaft{almnhshaft}/N [f] [def: widowhood]
almer/S [m] [def: closet; wardrobe] /Delmer
alp/N [m?] [def: Alp (mountain range)] /Iish % Forwards: Yoel Matveyev
alpagn/A alipagn/A [def: of alpaca]
als [prep] [def: as (German)]
alt/Kelt elterlekh/A altink/A [def: old, stale]
	altitshke/A [def: old]
		altitshker/S [m] altitshke/S [f] [def: old person; old spouse]
	altlekh/A [def: somewhat old]
	elter/V/T [def: age (with "zikh")]
		baeltert/A [def: aged] % Forwards: Boris Sandler
		fareltert/A [def: aged; obsolete]
	alterheyt altkayt/N [f] [def: age]
	altetshk/A [def: old one]
	-/Xeltern [def: parents] elterns
		-/Xureltern [def: great-grandparents and their ancestors]
	mitlelter [def: Middle Ages] /Ilekh
	uralt/A [def: original]
	altertum/N [n] [def: antiquity]
	altfrenkish/A [def: old-fashioned]
	mitl-elter [def: Middle Ages] 
		mitl-alter [def: Middle Ages] [usage: inadmissible] /Ilekh
	altertimlekh/A [def: old-fashioned] [usage: inadmissible]
		altertimlekhkayt/N [f] [def: old fashion] [usage: inadmissible]
alt [m?] alto [m?] [def: alto (music)]
alternati'v/N [m] [def: choice, alternative] /A
a'ltshaymer [m] [def: Alzheimer's disease] 
alu'f{alwf}/Xalufem{alwfym}/H [m] [def: wealthy person]
aluminyum [m] [def: aluminum (Al)]
aluzye/S [f] [def: allusion]
am/N [f] nam/N [f] [def: wetnurse] 
am [def: as ... possible (German)] [grammar: ... adjective in superlative dative]
am_{em}/H [def: nation]
	amkho{emx} [n] [def: common people] 
	hamoyn_am{hmwn_em}/H [def: common people; rabble]
amater [m] [def: horse-lover (thieves' argot)]
amator/N [m] amater/N [m] [def: amateur] 
	amatorish/A [def: amateur] 
ambasade/S [f] [def: embassy] 
	ambasado'r/N [m] [def: ambassador] 
ambeterne [f?] [def: state lottery in Galicia] % der groyser verterbukh
	ambe [f?] [def: pick-two win in state lottery]
	terne [f?] [def: pick-three win in state lottery]
ambitsye/S [f] [def: ambition] /Iz [def: ambitious] 
	ambitsyezkayt/N [f] [def: ambitiousness] % Forwards: Shikl Fishman
ambivalent/A [def: ambivalent] 
ambrazur/N [m?] [def: embrasure] 
ambrozye [def: ambrosia]
ambula'ns/N [m] [def: ambulance]
ambulatorye/S [f] [def: infirmary (for outpatients)] 
amendi'r/V/ amendi'rt [def: amend] 
	amendirung/N [f] [def: amendment] 
ameritsyum [m] [def: americium (Am)] 
amharish/A [def: Amharic (language)]
amide{emydh}/Xamides{emydwT} [def: amidah prayer (Jewish)]
	maymed{memd}/H [def: situation]
amnesti'r/V/Bamnesti'rt [def: grant amnesty] 
	amnestye/S [f] [def: amnesty] 
amnon_vetomer{amnwn-|wWmr} [def: pansy (flower, Viola wittrockiana)]
amorets{em-horc}/Xameratsem{em-h#rcym}/H [m] [def: ignoramus]
	ameratses{em-h#rcwT}/H [n] [def: ignorant behavior; lack of Jewish knowledge] /Idik
amoyre{amwr#}/Xamoyroyem{amwro|im}/H [def: Talmudic sage]
amper/V/T [def: quarrel (with "zikh")] tseamper/V/Btseampert
	a'mpernish/N [n] [def: quarrel, sqabble]
aplua [f?] [def: genre (theatrical)]
apoplektsye/S poplektsye/S [f] [def: apoplexy (disease)]
apostro'f/N [m] [def: apostrophe (punctuation symbol)]
amt/N [m] [def: office]
	/Ilekh [def: official]
	amti'r/V/Bamti'rt [def: hold office]
	baamt/A [def: official, clerk]
	yustitsamt/N [m] [def: Justice Department]
	postamt/N [m] [def: postoffice] 
	shtimamt/N [m] [def: board of elections]
	tsenzusamt/N [m] [def: census office]
amuzi'r/V/Bamuzi'rt [def: amuse; have a good time (with "zikh")]
an/V/T [def: foresee, predict, anticipate] [usage: not recommended]
anaka'rd/N [m?] [def: cashew (nut)]
analizi'r/V/Banalizi'rt [def: analyze] analiz/N [m] [def: analysis]
	psikhoanaliz [m] [def: psychoanalysis]
		psikhoanalitiker/S [m] [def: psychoanalyst]
	analitiker/S [m] anali'tikerin/S [f] [def: analyst] 
	analitish/A [def: analitic] 
analogye/S [f] [def: analogy] analogi'zm/N [m] [def: analogy] 
	analogish/A [def: analogous]
ana'nas/N [m] [def: pineapple (food)]
anarkhi'st/N [m] anarkhistke/S [f] [def: anarchist] anarkhistish/A
	anarkhi'zm [m] [def: anarchism]
anatomye/S [f] [def: anatomy] 
andante [adv] [def: andante (music)] % Stutchkoff
ander/A andersh/A [def: other; next]
	a'ndershdik/A [def: different]
	ana'nd anander anandern [def: each other]
		anandik/A [def: mutual] [usage: neologism]
	baynand [adv] [def: together]
	durkhana'nd [adv] [def: in sequence, together] /Idik
	no'khanand [adv] [def: in a row; continually]
	vi'deranand [adv] [def: repeatedly]
	andersh/V/T [def: change] /Giber
	a'ndershkayt/N [f] [def: difference] 
	funander [adv] [def: apart]
andes/X [m] [def: gooseberry]
androgine/S [f] [def: androgyne]
	androginish/A [def: androgynous]
anekdot/N [m] [def: anecdote]
aneksi'r/V/Baneksi'rt [def: annex]
anemish/A [def: anemic]
an/V/T [def: become aware] /Gforoys
	anen [def: awareness, imagination]
	anung [f] [def: inkling]
anestezye/S [f] [def: anesthesia]
	anestetik/N [f] [def: anesthetic]
	anestezyolog/N [m] [def: anesthesiologist (occupation)] 
angazhi'r/V/Bangazhi'rt [def: engage, hire; make a commitment (with "zikh")] 
angine [f] [def: tonsilitis (disease)] 
angl/N [m?] [def: hinge; fish hook]
anglikanish/A [def: Anglican (religion)]
angst/N [m/f] [def: suffering]
	-/Xangstn [def: agony]
animatsye/S [f] [def: animation] [note: V]
	animi'rt/A [def: animated (film)] [note: V]
anker/V/T [def: anchor (a ship)]
	faranker/V/Bfarankert [def: anchor]
	anker/S [m] [def: anchor]
ankete/S [f] [def: questionnaire]
anomalye/S [f] [def: anomaly]
anonim/A [def: anonimous]
anonsi'r/V/Banonsi'rt [def: announce; advertise]
	ano'ns/N [m] [def: announcement; advertisement]
	anonsirer/S [m] [def: advertiser]
ansambl/N [m] [def: ensemble]
-/Xanshey{anSy}/H [def: men of]
anta'nt/N [m] [def: entente, agreement] % Yiddish League
anti- [prefix] [def: anti-] 
antik/N/D [m] [def: antique; a real gem; something exquisite]
	antik/A [def: ancient, antique] 
	antikva'r/N [m] antikva'rin/S [f] [def: antiquarian, second-hand bookseller]
antimon [m] [def: antimony (Sb)] 
antinomi'zm/N [m] [def: antinomianism (religous philosophy)] % Forwards: Yoel Matveyev
antipatye/S [f] [def: antipathy]
antipke/S [f] [def: part of a pipe]
antologye/S [f] [def: anthology]
antonovke/S [f] [def: winter-hardy cooking apple (Russian антоновка)]
antoysh/V/Bantoysht [def: disappoint] antoyshung/N [f] [def: disappointment]
antplek/V/Bantplekt [def: uncover, reveal]
	antplekung/N [f] [def: disclosure]
antreprenye'r [m] [def: entrepreneur] % Sholem Aleykhem: Baym Keynig Akhashveyresh
antropologye [f] [def: anthropology]
	antropolog/N [m] [def: anthropologist] /Iish [def: antropological]
antshous [n?] antshovis [n?] [def: anchovy (fish)]
anttsik/V/Banttsikt [def: delight (German)]
	anttsikung/N [f] [def: delight]
antvikl/V/Bantviklt [def: develop] antviklung/N [f] [def: development]
	shpet-antvikler/S [m] [def: late bloomer] [note: V] 
anumlt [adv] /Iik anu'mltn [adv] anustn [adv] [def: once, recently, just now]
	[idiom: a litvisher anumlt = recently]
anvelop/N [m?] [def: envelope (English)]
apara't/N [m] /D aparatu'r/N [f] [def: apparatus]
	her-apara'tl/Eekh [n] [def: hearing aid] % Yiddish League
	foto-apara't/N [m] [def: photographic camera] 
	distili'r-apara't/N [m] [def: distillation apparatus] 
	aparatshik/Ees [m] [def: beaurocrat (Russian аппаратчик)]
apatye/S [f] [def: apathy] apatish/A
ape'l/N [m] [def: appeal; roll call] 
	apeli'r/V/Bapeli'rt [def: appeal (juridicial)]
apenditsi't [m] [def: appendicitis]
apeti't/N [m] [def: appetite] /Ilekh
apetropes{apwtrwpws}/Xapetropsem{apwtrwpwsym} [m] [def: guardian (ad litem)]
	apitrupus/Xapitrupsym [m]
	apetropses{apwtrwpswT} [m/f] [def: guardianship]
apikoyres{apykwrs}/Xapikorsem{apykwrsym}/H [m] [def: unbeliever, cynic, heretic]
	apikorsish{apykwrsish}/A [def: heretical]
	apikorses{apykwrswT} [def: heresy]
apl/X/N [m] shvartsapl/X/N [n] [def: pupil of eye]
aplikatsye/S [f] [def: application]
aplodi'r/V/Baplodi'rt [def: applaud]
	aplodisme'nt/N [m] [def: applause]
apokalipsis/N [def: apocalypse] apokaliptish/A [def: apocalyptic] 
apologye/S [def: apologetic] apologetish/A [def: apologetic] 
aposto'l/N [m] [def: apostle] /Iish [def: apostolic] 
apotropos{aptrwps}/Xapotroposem{aptrwpsym}/H [m] [def: legal guardian]
apoy'teke{apwWyk#}/H [f] apoy'teke_{apwWyky} [f] poy'teke{pwWyky} [f] [def: fortune]
apriko's/N [m] [def: apricot] 
april [m] [def: April]
aptey'k/N [f] [def: pharmacy (store)] /D [def: medicine chest]
	apteyker/S [m] /D [n] aptey'kerin/S [f] /D [n] [def: pharmacist]
	apteykeray'/N [n] [def: pharmacy (profession)]
	aptey'kerish/A [def: pharmaceutical]
ar/V/T [def: bother] [usage: only 3rd person, impersonal: "es art + acc"]
araber [m] [def: Arab] arabish/A [def: Arabian, Arabic]
	arabi'st/N [m] [def: Arabist] % Forwards
aranzhi'r/V/Baranzhi'rt [def: arrange] aranzhirung/N [f]
arayn [adv] araynet [adv] arayntsu [adv] [def: into]
	krikaray'n/N [m] [def: re-entry] % Yiddish League
arb/V/T [def: inherit]
arbe{arbe}/H [def: four]
arbes/X/D [def: pea (food)]
arbet/V/T [def: work, labor]
	/Gop/Goys/Gdurkh/Giber/Gmit/Garoyf/Garoys/Goyf/Gayn
	/Gtsuzamen [def: collaborate (not pejorative)] 
	/Gon [def: damage]
	baarbet/V/Bbaarbet [def: cultivate]
		baarbetung/N [f] [def: cultivation]
	a'rbeter/X/S [m] a'rbeterin/S [f] [def: worker]
		boyarbeter/S [m] [def: construction worker] [note: V] 
		fremdarbeter/S [m] [def: foreign worker] % Forwards
		mitarbeter/S [m] [def: co-worker]
		shmidarbeter/S [m] [def: steelworker] 
		vander-arbeter/S [m] [def: migrant worker]
	erdarbeter/X [m] [def: farmer]
	fararbet/V/Bfararbet [def: produce; make dirty]
		fararbet/A [def: occupied, busy]
	tsuzamenarbet [f] mitarbet [f] [def: cooperative work, collaboration]
	arbet|sloz/A [def: unemployed]
		arbet|slo'zikayt/N [f] [def: joblessness; unemployment]
	funanderarbetung/N [f] [def: demolition]
	oysarbetung/N [f] [def: design]
	arbet/S [f] [def: work]
		dro'tarbet [f] [def: filigree] 
		e'rdarbet [f] [def: farming]
		fa'rmarbet [f] [def: farm work] % Forwards
		filigra'n-arbet [f] [def: filigree]
		ha'ntarbet/N [f] [def: handwork] 
		hey'marbet [f] [def: housework]
		hoy'zarbet [f] [def: housework]
		shva'rtsarbet [f] [def: unskilled work] 
			shvartsa'rbeter/S [m] [def: unskilled worker] 
		shtu'barbet [f] [def: housework]
		za'mlarbet [f] [def: collection work]
		[idiom: linke arbet = illegal work (prostitution, robbery, ...)]
	arbetzam/A [def: hard-working] [usage: not recommended]
	[idiom: zikh nemen tsu der arbet = get to work]
	[idiom: arbetn far zikh = freelance]
arbitrarish/A [def: arbitrary]
arbl/X [m] /Idik [def: sleeve]
	hemd-arbl/X [m] [def: shirtsleeves] % Esther Kraytman: Briliantn
	arblloz/A [def: sleeveless] % I. J. Singer
	[idiom: er farshtekt im in arbl = he's superior to him] % Stutchkoff
	[idiom: redn fun arbl = improvise lines (actors' argot)]
arbuz/N [m] [def: watermelon] /D
arende/S [f] [def: leasehold] arenda'r/N/Ees [m] renda'r/N/Ees [m] arendarke/S [f] [def: leaseholder]
arene/S [f] [def: arena] 
aresti'r/V/Baresti'rt [def: arrest]
	arest [def: arrest]
		hoyzarest [def: house arrest] 
	aresta'nt/N [m] [def: person arrested, prisoner] /Iish arestantske/A
	mitaresta'nt/N [m] [def: co-prisoner]
	arest/N [m] [def: arrest]
argon [m] [def: argon (Ar)] 
argumenti'r/V/Bargumenti'rt [def: argument (reason)] 
	argume'nt/N [m] [def: argument (reason)] 
	argumentatsye/S [f] [def: reasoning, logical argument]
arikhes{aryxwT}/H [def: length] 
	bearikhes{baryxwT} [adv] [def: at length] /Idik
	arikhas{aryxT}/H [def: length of]
aristokra't/N [m] /Iish aristokratke/S aristokratin/S [f] ristokra't/N [m] [def: aristocrat]
	aristokratye/S [f] ristokratye/S [f] [def: aristocracy]
	stekra't/N [m] [def: aristocrat] [usage: colloquial] % Sholem Aleykhem
aritmetik [f] [def: arithmetic (subject)]
arkade/S [f] [def: shopping mall; arcade]
arkheolog/N [m] [def: archeologist] /Iish arkheologye [f] [def: archeology] 
arkhetip/N [m] [def: archetype] /Iish % Forwards: Yosl Matveyev
arkhitekt/N [m] arkhitekto'r/N [m] [def: architect]
	arkhitektish/A [def: architectural]
	arkhitektu'r/N [f] [def: architecture]
		/Ie'l /Iish [def: architectural] [usage: doubtful admissibility]
	arkhitektonish/A [def: architectural] 
arkhiv/N [m] [def: archive] /Ialish [def: archival] 
	archivar/N [m] archivarke/S [f] arkhivi'st/N [m] arkhivistke/S [f] [def: archivist] 
arktik/N [f?] [def: arctic region] arktish/A [def: arctic]
	antarktik/N [f?] [def: arctic region] % Forwards: Berinski
	antarktish/A [def: arctic]
armey'/N [f] [def: army] armeyer/S [n] [def: soldier; legionnaire]
	roytarmey [f] [def: Red (Soviet) Army] roytarmeyer/S [n] [def: Red Army guard]
	platsdarm/N [m?] [def: military base] 
aroma't/N [m] [def: aroma] /Iish [def: aromatic] 
arop [adv] aropet [adv] [def: down]
	funoybnarop [m] [def: condescension, haughtiness]
aroyf [adv] aroyfet [adv] aroyftsu [adv] [def: up (preposition)]
aroys [adv] aroyset [adv] [def: out]
arsen [m] arshenik [m] arsenik [m] [def: arsenic (As)] 
arsena'l/N [m] [def: arsenal]
art/N [m] [def: manner]
	filartik/A [def: full-fledged] filartikayt/N [f] [def: comprehensiveness] 
	groysartik/A [def: wonderful (German)] 
	farsheydnartik/A [def: multifaceted]
		farsheydnartikayt/N [f] [def: multifaceted nature]
	rednsart/N [m] [def: manner of speaking]
arterye/S [f] [def: artery] 
artikl/N [m] [def: article] artikele/Ekh [def: small article]
artilerye/S [f] [def: artillery] 
arti'st/N [m] [def: artist] /Iish artistke/S [f] [def: artist]
	gastarti'st/N [m] [def: guest artist] [note: V] 
arts [m?] [def: raw material; ore]
aruf{aroyf}/H [def: up (converb)]
arum/P arum [adv] arumet [adv] [def: around]
	arumik/A [def: surrounding]
	hintnarum [adv] [def: about, around] % Der Nister
	um [prep] derum [adv] [def: around] 
	[idiom: grod un um = evens and odds (children's game)]
	um [prep] [def: in order to (with "tsu")] 
	drum darum [def: therefore (German)]
	[idiom: arum un arum = altogether]
arure{arwrh}/Xarures{arwrwT}/H [f] [def: forbidden thing; shrew]
aryer [def: Aryan]
arzenik [m] [def: arsenic (chemical)] arsen [m]
asekuratsye/S [def: protective measure (Russian)] 
	asekuri'r/V/Basekuri'rt sekuri'r/V/Bsekuri'rt [def: insure]
aser{asr}/H/V/T [def: forbid]
	/Gayn [def: imprison (Litvish Yiddish)]
	oser{oswr}/H [adj] [def: forbidden]
	oser{oswr}/H [interj] [def: by my honor] [grammar: only in negative constructions]
	iser{#yswr}/Xisurem{#yswrym}/H [m] [def: prohibition] 
	asir{asyr}/Xasirem{asyrym}/H [m] [def: prisoner] 
aseres{eQrT}/H [def: ten]
asfalt [m] [def: asphalt]
ash/N [n] [def: ash]
	[idiom: makhn ash un blote fun = slander]
/Dash [n] [def: a kind of onion (food)] % échalote [French] escalonia [Latin]
asher{aSr}/H [def: who]
ashkenaz{aSKnz}/Xashkenazem{aSKnzym}/H [m] [def: Ashkenazic Jew] /Iish
asife{asyfh}/Xasifes{asyfwT}/H [f] [def: meeting]
asimili'r/V/Basimili'rt [def: assimilate]
	asimilator/N/Iish [def: assimilator]
	asimilirung/N [f] [def: assimilation] asimilatsye/S [f]
asistent/N [m] [def: assistant (English)] 
a'skere{asKrh} [f] [def: diphtheria (disease)]
asketish/A [def: ascetic] asketi'zm/N [m] [def: asceticism] 
asmira'd/N [m?] [def: emerald] /D % Y. L. Perets
asoben/A [def: apart] 
asore{eQr#}/H [def: ten (Aramaic)]
asotsii'r/V/Basotsiirt [def: associate (with "zikh")] 
	asotsyatsye/S [f] [def: association]
	[idiom: asotsiirter profesor = associate professor]
aspiratsye/S [f] [def: aspiration]
	aspira'nt/N [m] [def: doctoral student]
aspiri'n/N [m] [def: aspirin]
astatin [m] [def: astatine (At)] 
astme [f] [def: asthma] /Itish
astronom/N [m] [def: astronomer]
	astronomye [f] [def: astronomy]
astronoy't/N [m] [def: astronaut, cosmonaut]
	astronomye [f] [def: astronomy]
asuse{aswT#} [interj] [def: gesundheit!] [usage: Hungarian religious] % Michael Wex.
	asis [interj] [def: gesundheit]
ataki'r/V/Bataki'rt [def: attack; criticise]
	ata'k/N [m] atake/S [f] [def: attack] 
	atakirer/S [def: attacker, assailant]
atashe'/Een [m] [def: attaché]
ate{aWh}/H atem{aWm}/H [def: you]
atei'st/N [m] /Iish ateistke/S [f] [def: atheist]
	atei'zm [m] [def: atheism]
	monotei'zm [m] [def: monotheism] 
		monotei'st/N [m] /Iish monotheistke/S [f] [def: monotheist] 
	pantei'zm [m] [def: pantheism]
		pantei'st/N [m] /Iish [def: pantheist]
atelye'/N [m] [def: studio]
atem{aWm}/H [def: you (plural)]
atentat/N [m] [def: assasination] 
atesti'r/V/Batesti'rt [def: certify]
	atesta't/N [m?] [def: diploma; certificate]
	atestatsye/S [f] [def: endorsement; score, evaluation]
atlas/N [m] [def: atlas]
atles [m?] [def: satin (material)] /In
atle't/N/Iish [m] [def: athlete, jock]
	atletik [f] [def: gym, athletics (subject)] 
atmosfe'r/N [f] atmosfere/S [f] [def: atmosphere]
atom/N [m] [def: atom] /Iish
atore{etrh}/Xatores{etrwT}/H [def: crown; collar band of a tallis; foreskin]
atraktsye/S [f] [def: attraction]
	bonus-atraktsye/S [f] [def: special feature] [note: V] 
	[idiom: zayn an atraktsye = be featured] [note: V]
atributi'v/A [def: attributive (linguistic)]
atrofi'r/V/Batrofi'rt [def: atrophy]
atrope [f] [def: deadly nightshade, Atropa belladonna]
atsetaminofe'n [m] [def: acetominophen, paracetamol (drug)] % Yiddish League
tsves{ecBwT}/H [f] [def: sadness, melancholy] /Idik
atyuta'nt/N [m] [def: attendant, retainer, flunky] % Sholem Aleykhem
avade{avd#y}/H [adv] [def: certainly]
avanga'rd/N [def: avant guard (French)] /Iish
avansi'r/V/Bavansi'rt [def: advance] avansirung/N
avantu'r/S [f] /Iish avanture/S [def: adventure]
	avanturi'st/N [m] avanturistke/S [f] [def: adventurer; risk-taker]
	avanturi'zm/N [m] [def: adventurism]
	avanturistish/A [def: adventurous; sporting]
aveyde{aBydh}/Xaveydes{aBydwT}/H [f] [def: lost object] 
	mayved{maBd} [verb] [def: lose (with "zayn")] 
	ibed{#ybwd} [m] [def: left over]
		leibed{l#ybwd} [def: lose (with "geyn")]
aveyre{eByrh}/Xaveyres{eByrwT}/H [f] [def: sin; waste]
	bal_aveyrenik{bel-eByrhnik}/Ees [m] bal_aveyrenitse{bel-eByrhnitse}/S [f] [def: sinful person]
avgust [m] [def: August]
avirn [m?] [def: stink]
avle{evlh}/Xavles{evlwT}/H [def: sin; mistreatment]
	baavl{baevl}/V/Bbaavlt{baevlt} [def: mistreat, abuse, oppress]
avokade/S [f] [def: avocado (food)]
avoyde{eBwdh}/Xavoydes{eBwdwT}/H [def: work, worship]
	avoydas{eBwdT}/H [def: worship of]
	avoyde_zore{eBwdh-zrh} [f] [def: idolatry; idol]
	avoydes_perekh{eBwdT-prx} [f] [def: backbreaking work]
avyo'n/N [def: airplane] 
	a'vyalinye/S [f] [def: airline] [note: V]
	avyatsye/S [f] [def: aviation]
ay [def: ay: expression of delight or wonder]
ayen{eʼ}/H [def: Hebrew letter Ayin]
ayen-hore{e|yn-hre}/H/S [m/f] [def: evil eye] 
ayl/N [m?] [def: owl (bird, order Strigiformes)]
ayl/V/T [def: hasten] /Gfarbay/Gdurkh/Garoys/Gariber/Gavek/Gtsu
	ay'lenish/N [n] [def: hurry]
	aylik/A [def: hurried]
	geayl{ge#ayl}/N [n] [def: rush]
ayn [def: in (separable converb)]
aynflus/V/T [def: influence] aynflus/N
	baaynflus{ba#aynflus}/V/Bbaanynflust{ba#aynflust} [def: influence] 
	baaynflusung{ba#aynflusung}/N [f] [def: influence] 
aynshtaynyum [m] [def: einsteinium (Es)] 
ayter/S/D [m] [def: udder] /Idik
ayz [n] [def: ice] /Ien [def: icy] /Iik
	ayz-smorke/S [def: icicle] 
ayzn/S [n] [def: iron (Fe)] ayzern/A ribayzn{rib#ayzn}/S [m] [def: grater]
	a'kerayzn{aker#ayzn}/S [n] [def: plow]
	bi'glayzn{bigl#ayzn}/S [n] [def: iron (appliance)]
	gli'ayzn{gli#ayzn}/S [n] [def: soldering iron] % Stutchkoff
	gro'bayzn{grob#ayzn}/S [n] [def: hoe]
	ley'tayzn{leyt#ayzn}/S [n] [def: soldering iron] % Stutchkoff
	pre'sayzn{pres#ayzn}/S [m] [def: iron (appliance)] 
	[idiom: shtol un ayzn = firm]
az [def: that; when; if]
aza azan azelkh/A [def: such]
aza'rt [m] [def: heat; excitement; gambling] 
	azartnik/Ees [m] [def: gambler]
aza's azasye [def: don't!]
azbuke/S [f] [def: Russian alphabet (Russian азбука)]
azh [def: actually; surprisingly]
azhu'r/A [def: up-to-date (French au jour)]
azi'l [m] [def: asylum]
azimut/N [m] [def: azimuth (astronomy)] 
azore{ezrh}/Xazores{ezrwT}/H [def: courtyard]
	ezras{ezrT}/H [def: courtyard of]
azot [m] [def: nitrogen (N)] 
azoy [def: such; so; thus; yes]
	 azoyns azoyne/A azelkhe/A 
		[idiom: azoyns un azelkhes = excellent]
	 viazoy [def: how?]
baal{bel}/H [m] [def: master]
	baley{bely}/H [def: masters of]
	balebos [m] balebos_{bel-hbyT}/Xbalebatem{bely-bWym}/Xbalebatem_{balebatym} [m] [def: boss, householder, owner] 
		/Dbalebes [def: householder] 
		baleboste/S/D [f] baleboste_{bel-hbyTte}/S [def: housewife; mare (balegole-loshn)]
		baleba'teve/V/Bbaleba'tevet [def: deal with household affairs]
		balebatish/A balebatish_{bel-hbWysh}/A [def: orderly] % usually loses Hebraic spelling
			balebatishkayt/N [f] [def: orderliness; household goods] % loses Hebraic spelling
	balmagie{bel-mgyh}/H/S [m] [def: proofreader; checker of holy texts]
	baletekeye{bel-Wwke}/H/S [m] [def: shofer blower]
babke/S [def: butter cake]
	babkele/Ekh [def: money (thieves' argot)]
bader/V/T [def: bother, annoy (American)]
badke{bdke}/Vbadkenen{bkdenen}/T [def:
badkhn{bdHn}/Xbadkhonem{bdHnym}/H [m] [def: jester (wedding)]
	badkhones{badHnwT}/H [f] [def: art of wedding jesters]
bafel/V/Bbafoyln [def: order, command]
	bafoyl/V/Bbafoyln % variant
	bafel/N [m] bafoyl/N [m] [def: order, command] 
	bafeler/Iish [def: commander]
baga'zh/N [m] [def: baggage]
bagin/V/Bbagunen [def: begin] [usage: archaic]
	baginen [m] [def: dawn, daybreak]
bagleyt/V/Bbagleyt [def: accompany] /Gnokh/Garoys
	baleyt/V/Bbaleyt [def: accompany] /Gnokh/Garoys % variant form
		baleyter/S bagleyter/S [def: companion] 
		leytung/N [f] [def: guidance, direction, management] 
	bagleytung/N [f] baleytung/N [f] leytung/N [f] [def: accompaniment]
	bagleyter/S [m] bagley'terin/S [f] [def: companion]
		lebnsbagleyter/S [m] lebnsbagley'terin/S [f] [def: life companion] 
bagnedik/V/Bbagnetikt [def: forgive; release from prison] 
	bagne'dikung/N [f] [def: pardon]
bagnet/N [m] [def: bayonet] 
bahavnt/A [def: proficient] bahavntkayt/N [f] [def: proficiency] 
bak/N /Iik /Dbek [f] [def: cheek]
	kinbak/N [def: chin]
	rozbekldik/A [def: rosy-cheeked]
bak/V/T [def: bake] /Gop
	/Gfrish [def: freshly baked]
	/Bgebakn /Gop [def: bake] /Giber/Goys
		/Gfrish [def: freshly baked] % variant
		/Gayn [def: become part of]
			[idiom: ayngebakn in hartsn = part of oneself]
	gebe'ks/N [n] [def: pastry; baked goods]
		putergebeks/N [def: baked dairy goods]
		tsukergebeks/N [def: sweet pastries]
	beker/S [m] be'kerin/S be'kerke/S [f] [def: baker]
	bekeray'/N [f] [def: bakery]
	derbakn/A [def: polished, fully prepared; mature] 
	bekn/S [m] [def: pan (frying or sauce); pool; pelvis] /Dbeke
bakalaver/S [m] bakala'verin/S [f] [def: bachelor (education)]
	bakalavra't/N [m] [def: bachelor degree (education)]
bakaley' [m?] [def: dried fruit; grocery] /In
	bakaleynik/Ees [m] bakaleyshtshik/Ees [m] [def: dried-fruit seller]
bakara' [m?] [def: baccarat (card game)]
bakoshe{bkSh}/Xbakoshes{bkSwT}/H [f] [def: request]
	[idiom: loyt ayer bakoshe{bkSh} = as per your request] [note: V]
	[idiom: oyf ayer bakoshe{bkSh} = upon request] [note: V]
bakterye/X/S [f] [def: bacterium] 
baktshi/S [f?] [def: melon garden (Russian бахчи)]
bakvem/K [def: pleasant] /Ilekh
	bakvemkayt/N [f] [def: pleasantness] bakvemlekhkayt/N [f]
	u'mbakve'm/K u'mbakve'mlekh/A [def: uncomfortable; unpleasant]
		u'mbakve'mlekhkayt/N [f] [def: unpleasantness]
bal/Xbeler [m] [def: dance, ball (social event)]
bal/N [m] [def: ball (round object)]
bala'beshke/S [def: a cooked food made with buckwheat flour]
balade/S [f] [def: ballad] 
	folkbalade/S [f] [def: folk ballad] % Forwards: Itsik Gottesman
balaga'n/N [m] [def: mess; bedlam; showbooth] % < Russian < Turkic "wooden house" < Persian balakhaana "external room" < PIE *bhelg "wooden plank"
balagure/V/T [def: converse, gab] % Der Nister
balahure/V/Bbalahuret [def: gossip]
balalayke/S [f] [def: balalaika] /D
balake/V/T [def: prate, babble] % Stutchkoff
balang/V/Bbalangt [def: belong (English)] /Gon
balans/N [m] balants/N [m] [def: balance]
	u'mbala'ns/N [m] [def: imbalance] % Forwards: Yankev Goldshteyn
	balansi'r/V/Bbalansi'rt [def: balance]
		balansirtkayt/N [f] [def: state of balance] % Forwards: Genadi Estraykh
bald/Iik [def: soon; immediately]
	[idiom: vi bald = since]
balebetshe/V/Bbalebetshet [def: babble, chatter]
	batshke/V/T [def: prate, babble]
balem/S [m] [def: ball] /D
	koyshbol [m] [def: basketball]
	netsball [m] [def: volleyball]
	fusbol [m] [def: soccer] fusboli'st/N [m] [def: soccer player]
	beysbol [m] [def: baseball]
	netsbol [m] [def: basketball]
balemutshe/V/Bbalemutshet [def: gibber; procrastinate; waste time] 
	balamute/V/Bbalamutet [def: prattle, chatter] % Mendele
balet/N [m] [def: ballet]
ba'leve/V/T [def: pamper] % Stutchkoff
	tseba'leve/V/Btseba'levet [def: spoil (child)] 
baleye/S [f] [def: wash basin (for clothing)]
balkn/S [m] balke/S [f] [def: balcony; rafters; ceiling] balkon/N [m] % both forms exist; < Italian < Old Germanic "wooden platform" < PIE *bhelg "wooden plank"
baln{beln}/Xbalonem{belnym}/H [m] balnte{belnte}/S [f] [def: eager person, interested person]
	balones{belnwT} [f] [def: eagerness]
balon/N [m] [def: baloon]
balye/S [f] baleye/S [f] [def: laundry bucket]
balzam [m] [def: balm, balsam] 
	balzami'r/V/Bbalzamirt [def: embalm]
		balzamirer/S [m] [def: embalmer]
		balzamirung/N [f] [def: embalming]
	farbalzami'r/V/Bfarbalzami'rt [def: embalm] % Forwards: Genadi Estraykh
bambuk [m?] bambus [m?] [def: bamboo (grass, tree)]
ban/N [f] [def: train]
	ayznban/N [f] [def: train]
	shlogban/N [f] [def: military train (??)] % Y. Y. Singer
	unterban/N [f] [def: subway]
bana'l/A [def: [banal, trite]
	banalite't/N [f] banalkayt/N [f] [def: banality; triteness]
banane/S [f] banan/N [m] [def: banana]
	kokh-banane/S [f] kokh-banan/N [m] [def: plaintain (fruit)] 
bandazh/N [m] [def: bandage] 
	bandazhi'r/V/Bbandazhi'rt [def: bandage] /Garum
bande/S [f] [def: gang, band] /Dband
bandero'l/N [m] [def: (mailing) wrapper] 
bandi't/N [m] [def: bandit]
bandure/S [f] [def: bandura (stringed instrument) (Ukrainian банду́ра)]
bang [def: anxious] % Harkavy
	[idiom: es tut mir bang (oyf) = I am sorry (for)]
bank/Xbenk [f] [def: bench] /Dbenk [def: small bench; stool; chair (furniture)] 
	/Dfusbenk [def: footstool (furniture)]
	/Dkikhbenk [def: kitchen chair (furniture)]
	shpiglbank/Xshpiglbenk [f] [def: some sort of bench ??] % Bergelson: Yosef Shur
	shulbank/Xshulbenk [f] [def: school desk (furniture)]
	shuldbank/Xshuldbenk [f] [def: dock (court)]
	tombank/Xtombenk [m] tubank/Xtubenk [def: countertop (furniture)] % especially in a store
	tsolbank/Xtsolbenk [m] [def: store counter]
	[idiom: tsushteln dir a benkele tsu emetsn = tattle on you to someone]
bank/Xbenk [f/m] [def: bank] 
	bankoma't [m] [def: automated teller machine (ATM)] 
	bankno't/N [m] [def: banknote]
	bankrot/N [m] [def: bankruptcy] 
		bankrotnik/Ees [m] [def: bankrupt person]
	banki'r/N [m] bankirer/S [m] [def: banker]
	bankroti'r/V/Bbankroti'rt [def: bankrupt]
	[idiom: durkh s'bank = on the average]
banke/S [f] [def: medicinal cupping; tin can (Russian банка)]
banket/N [m] [def: banquet]
bansher; inn{b#Sr}/H [def: insofar as; because it is said that]
	[idiom: bansher bekheyn{bxn} = as far as that's concerned]
bantshok [m?] [def: Faro (card game)] % Sholem Aleykhem
bantu [def: Bantu (language family)]
banye/S [f] [def: gourd; trunk]
baobakht/V/Bbaobakhtet [def: observe (German)]
bapti'st/N [m] [def: Baptist]
bar/A [def: cash (German)]
bar/N [f] /D barne/S berne/S [f] [def: pear]
	erdbar/N [m] [def: Jerusalem artichoke (vegetable)]
bar_{br}/H [def: son (Aramaic), in the category of]
	ben{bn}/Xbonem{bnym}/H [m] [def: son, child]
		bney{bny}/H [def: children of]
		bnok/Ees [def: son (pejorative)]
	barmitsve{br-mycvh}/Xbarmitsves{br-mycvwT} [def: Bar Mitsvah (ceremony or lad)]
	ba'rmenen{br-mynn} [def: corpse; remains]
barabane/V/T tarabanye/V/T [def: play the drum]
	barabaneve/V/T /Gon [def: annoy, pester]
	baraba'n/N [m] barabane/S [f] [def: drum (musical instrument or industrial container)]
barabolye/S [f] barabulye/S [f] barebulye/S [f] barbolye/S [f] [def: potato] 
barak/N [m] [def: barrack]
bara'n/Ees [m] [def: ram (male sheep) (animal)]
baranke/S [f] [def: sable (fur)] 
	barankove/A [def: sable (fur)]
barashkn/A [def: sheepskin] 
barbar/N [m] [def: barbarian] /Iish [def: barbaric]
bare/V/T [def: gull, cheat verbally; have sex with (vulgar)] /Gop
	opgebaret/A [def: fooled; mangy]
barg/Xberg [m] [def: mountain] /Iik [def: mountainous] /Dberg [n] [def: hill]
	bergldik/A geberglt/A [def: hilly]
	mistbarg/Xmistberg [m] [def: landfill] [note: V] 
	bergeray' [n] [def: mining (industry)]
	[idiom: iberkern berg = do one's best]
barikade/S [f] [def: barricade] 
ba'rishnye/S [f] [def: lady (Russian барышня)] 
bariton/N [m] [def: baritone] 
barke/S [f] [def: shoulder; freight ship]
	[idiom: tsien/kvetshn/heybn mit di barkes = shrug one's shoulders]
barkhe't [?] [def: velvet] /In [def: usage: doubtful admissibility] 
barm/V/T [def: be merciful] barmenen
	derbarem/V/Bderbaremt [def: be merciful]
	derbaremdik/A [def: merciful, compassionate] 
		umderbaremdik/A [def: unmerciful]
barometer/S [m] [def: barometer] 
baron/N [m] [def: baron]
barsuk/Ees [m] [def: badger (animal, Mustelidae spp.)]
baveltik/V/T geveltik/V/Bgeveltikt [def: dominate, rule]
	geveltikung/N [f] [def: domination]
bershtl/V/T [def: brush]
	barsht/V/T/Bgeborshtn /Gop bersht/V/T /Gop [def: brush] 
	barsht/Xbersht [f] [def: brush] /Dbersht
		farbbarsht/Xfarbbersht [f] [def: paintbrush]
		golbershtl/Eekh [n] [def: shaving brush] % Harduf
		kopnbershtl/Eekh [n] [def: hairbrush]
		tseynbershtl/Eekh [n] [def: toothbrush] % Katlo Kanye
	tseburshet/A [def: unkempt]
	tseborsht/V/Btseborshtn [def: tousle]
barye/V/T [def: eat (klezmer-loshn)]
barye'r/N [m] baryere/S [f] [def: barrier; hurdle (sport)] 
	[idiom: aribershpringen dem baryer = clear the hurdle]
baryum [m] [def: barium (Ba)] 
barzh/N [m] barsh/N [m] [def: bass (fish)] % Stutchkoff, Michael Wex
bas/Xbeser [m] [def: bass (voice)] /Iov
	b'aseve/V/T [def: speak with a deep voice; growl]
		/Gtsu [def: respond in a deep voice]
	baso'k/Ees [m] [def: yes-man; flunkey]
	ko'nterbas/Xko'nterbeser [m] [def: contrabass (voice); bass (violin)]
bas_{bT}/H [f] [def: daughter]
	simkhas_bas{QymHT-bT} [def: baby naming for daughter]
baseyn/N [m] [def: pool (water)] 
	shvimbaseyn/N [m] [def: swimming pool] 
bash [m?] [def: money (ganovem-loshn)]
bashaymperlekh/A [def: obvious]
bashert/A [def: destined]
	bashertkayt/N [f] [def: destiny]
bashtan [m?] [def: melon garden (Ukrainian баштан)]
	bashtanshtshik/Ees [m] [def: garden owner (Ukrainian баштанщик)]
bashta't/V/Bbashta't [def: hide, secure] 
bastilye [f] [def: prison; Bastille] 
batalyon/N [m] [def: battalion]
batate/S/Xbatatn [f] [def: sweet potato] 
batayt/V/Bbatayt [def: signify]
	batayt/N [m] [def: meaning] /Iik [def: significant]
	daytlekh/A [def: precise; clear; distinct]
		daytlekhkayt/N [f] [def: precision, exactitude]
		umdaytlekhkayt/N [f] [def: imprecision, inexactness, unclarity]
	badayt/V/Bbadayt [def: signify] [usage: inadmissible]
		badayt/N [m] badaytung/N [f] [def: meaning] [usage: inadmissible]
	tsveydaytik/A [def: ambiguous; enigmatic]
		tsveydaytikayt/N [f] [def: ambiguity]
batek/Ees [m] [def: whip (Polish "bat")] % Sholem Asch: Motke Ganef
baterye/S [f] baterey/N [f] [def: battery (electric)]
	batereyke/S [f] [def: flashlight] 
bati'st [m] [def: cambric (material)] /In
batribt/A [def: sad] % no Yiddish base verb
batri'g/V/Bbatri'gt [def: falsify, fake; gull, fool] [usage: not recommended]
	batriger/S [m] [def: seducer; charlatan] [usage: not recommended]
		batri'gerish/A [def: fraudulent, deceitful] [usage: not recommended]
batsi'l/N [m] [def: bacillus]
batsirk/N [m] [def: district, ward, county] 
batyushke [m] [def: Orthodox priest (Russian батюшка "father")]
bay/P bam [prep]  [def: at, at the home of, by, near; in the opinion of]
	derbay/Iik [def: present; neighboring, nearby, close]
	farbay/P [def: past, gone; dying] /Iik [def: transitory, temporary, ephemeral]
		[idiom: khorev{Hrwb}/krank farbay = deathly ill]
	bayzamen [adv] [def: in company, together (often with "mit")]
baybak/Ees/D/Ishen [m] [def: marmot (animal); lazybones; fool]
baydl/N [n] [def: hut, shed, booth; tent]
bayer/V/T [def: spin a tale, fool] 
bayes{byT}/Xbatem{bWym}/H [m] [def: house; tefillin box] /Lha{h}
	bes{byT}/Xbatey{bWy}/H [def: houses of]
	ben_bayes{bn-byT}/Xbney_bayes{bny-byT} [m] [def: member of the household]
	[idiom: a yishoen{ySen} al{el} beyse{byTw} = sexually impotent man] % Job 8:15 ?? spelling
bayke/V/T [def: tell lies]
	bayke [def: unbelievable story (Russian байки)]
bayl/V/T [def: clench; beat up] /Garoys [def: protrude]
	bal/V/T [def: clench] /Garoys [def: protrude] % variant
	tsebayl/V/Btsebaylt [def: beat up]
	bayl/N [def: lump (swelling)]
	baylekhl/Eekh [def: ball] % B. Sandler
baynir [def: adrenal gland]
bays/V/Bgebisn [def: bite] /Garayn/Gadurkh/Gayn/Gon/Goys
	/Gop [def: bite off]
	/Giber [def: eat breakfast]
		i'berbay'sn [n] [def: breakfast]
		tsubays/N [m] tsubaysn/S [n] tsubaysung/N [f] [def: snack]
	farbays/V/Bfarbisn [def: snack]
		farbaysn/S [n] [def: snack food]
		farbaysekht|s/N [n] [def: snack food]
	farbisn/A [def: grim; stubborn, obstinate]
		farbisnkayt/N [f] [def: bitterness; obstinacy]
		[idiom: a farbisener hund = a mean, bitter person]
	farbaysung/N [f] [def: sting] % Sholem Aleykhem
	tsebays/V/Btsebisn [def: eat]
	o'nbaysn/S [n] [def: lunch]
	bis/N [m] [def: bite] bisn/S [m] [def: morsel, bite] 
	bayser/S [def: biter]
	baysik/A [def: biting, sharp; painful] 
	bay'senish/N [n] [def: biting sensation]
baystru'k/Ees [m] [def: scamp; bastard (vulgar)]
bayt/V/Bgebitn [def: exchange, change] /Giber/Gtse
	/Goys [def: take turns (with "zikh"); change (money); grow older than] 
	farbayt/V/Bfarbitn [def: exchange; replace]
		farbaytung/N [f] [def: replacement, substitute]
		farbaytlekh/A [def: replaceable] 
	tsebayt/V/Btsebitn [def: change (money)]
	oysbayt/N [m] opbayt/N [m] [def: exchange]
	shprakhbayt/N [m] [def: language evolution] % Forwards: Shikl Fishman
	bay'tevdik/A [def: changeable] 
		bay'tevdikayt/N [f] [def: changeability, mutability; lability]
	bay'tenish/Xbay'tenishn [n] [def: change; vicissitude; variation]
	ge'ltbayter/S [def: money changer] % Yiddish League
	umgebitn/A [def: reversed] % Sholem Aleykhem
	[idiom: es bayt zikh gornit oys = it makes no difference]
baytl/V/T [def: sift (especially flour)]
	[idiom: gebaytlt broyt = rye bread] % Z. Sher, Fun der alter un nayer velt
baytl/N [m] /Dbayt [def: wallet, handbag, pouch, purse; scrotum] 
	baytldik/A [def: baggy]
	nash-baytele/Ekh [n] [def: goodie bag (for children)] [note: V] 
	baytl/V/T /Goys [def: steal; go bankrupt (with "zikh")]
baytsh/N [f] [def: whip] /D [def: necklace chain]
	baytsh/V/T [def: whip]
	baytshl/V/T [def: whip]
		/Goys [def: steal (horse) (thieves' argot)]
baze/Xbazn [f] bazis/N [f] [def: base (general and chemical); basis]
	bazish/A [def: basic (chemical)]
	ey'lbaze [f] [def: oil base (paint)]
	vaser-baze [f] [def: water base (paint)]
baza'kht/A [def: slow, deliberate, leisurely; dispassionate; demure] 
bazar/N [m] [def: bazaar] 
bazesn/A [def: crazy]
bazilik [m?] [def: basil (herb)]
bazi'r/V/Bbazi'rt [def: base]
	bazirung/N [f] [def: headquarters] % Forwards: Genadi Estraykh
be [interj] [def: well: expression of doubt, pooh! expression of dismissal]
be/Een [m] [def: the letter B] 
bebe/V/T [def: babble] /Gop
be'bekhe/S [def: blanket, rag; intestines (in plural)]
	[idiom: farzetsn di bebekhes = do without something necessary to pay for another necessity]
bebrikl/Eekh [def: sticktight (burr of Bidens spp. such as Beggar's ticks)] % Forwards: Boris Sandler
bedieved{bdyeBd}/H [adv] [def: after the fact, a postiori]
beduiner/X [m] [def: Bedouin] 
befresye{bfrhsyh} [adv] [def: in public (usually sinning in public)]
befeyresh{bfyrwS}/H/A [def: explicitly]
befra't{bfrt}/H/Lu{|w} [def: in particular]
beged{bgd}/Xbgodem{bgdym}/H [m/n] [def: clothing] -/Xbgodemlekh{bgdymlekh}
	-/Xbigdey{bgdy} [def: clothing of or for]
begilufn{bgylwfyn} [adj predicative] [def: tipsy]  /Idik
	ibergelufn{ibergylwfyn} [adj predicative] [def: drunk]
beheyme{bhmh}/Xbeheymes{bhmwT}/H [f] [def: cow; beast; fool; uncouth person]
	beheymele{bhmhle}/Ekh [def: calf]
behole{bhlh}/Xbeholes{bhlwT}/H [f] [def: commotion; confusion]
	mevuel{mBwhl} [adj] [def: confused] /Idik [def: confused; afraid]
bekas [m?] [def: snipe (bird, Scolopacidae spp.)]
beke/V/T [def: bleat (sound of a cow)] 
be'keshe/S [f] [def: long jacket (Chassidic clothing)] 
bekher/S/D [def: drinking cup]
	 be'kherl/Eekh [def: chanterelle mushroom, Cantharellus cibarius] % Forwards: Yoel Matveyev
bekherem{bHrm} [adv] [def: under threat of excommunication]
	[idiom: freg im bekherem{bHrm} = he has no idea whatsoever]
bekhey'n{bxn} ubekhey'n{|wbxn} uvekhey'n{|wBxn} lekhey'n{lxn}/H [adv] [def: therefore]
bekhla'l{bxll}/H [def: generally]
bekn/S [m] [def: basin; pool (artificial); pelvis (body part); roasting pan; tray] 
	broy'tbekn/S [m] [def: bread pan (utensil)] % Forwards: S-R Schaechter 
	va'shbekn/S [m] [def: washbasin]
belakhesh{blHS}/H [adv] [def: quietly]
belaz{ble″z}/H [def: in the vernacular]
beldeve/V/T [def: prattle, chatter] % Kulbak: Zelmenyaner
belebeke/V/T [def: prattle, utter nonsense] % Menakhem Kipnis
beletristik [f] [def: belles lettres, fiction] beletristish/A
belik/Ees [m] belke/S [f] [def: rafter, girder, beam; ceiling]
belme/S [f] belem [m?] [def: cataract (disease)]
	farbelmet/A [def: with cataracts]
bengalish/A [def: Bengal (language)]
benefit/N [m] [def: benefit]
benimes{bne|ymwT}/H [def: pleasant] /Idik
benk/V/T [def: yearn] /Goys
	benkndikerheyt [adv] [def: while yearning] 
	benkshaft/N [f] [def: nostalgia] be'nkenish [n] [def: yearning]
	farbenk/V/Bfarbenkt [def: strongly yearn]
		farbenktkayt/N [f] [def: strong yearning]
benkart/N [m] [def: bastard]
bentsh/V/T [def: bless, recite after-meal grace] /Gop
	bentshung/N [f] [def: blessing]
	bentsher/S [m] [def: booklet for after-meal grace; kheder greeter] /D
bentsh/N [m] bents/N [m] terebe'nts/Ees [m] [def: slap, thud, blow]
benzin [def: benzine, gasoline]
ber/N/D [m] [def: bear] /Iish [def: bearish] 
	berele/Ekh [n] [def: burr] 
beret/N [m] [def: beret (cap) (clothing)] /D
bere/S [f] [def: lake]
be'reze/S [f] [def: birch (tree, Betula spp.)] /Ive /In
	bero'zeve/A % Z. Shneyer
	beryoze/S [f] [def: birch (tree, Betula spp.)] /Ive
berkelyum [m] [def: berkelium (Bk)] 
berilyum [m] [def: beryllium (Be)] 
berline/S [f] [def: barge (boat)]
	berlinke/S [f] [def: raft]
be'rvene/S [f] brevne/S [f] [def: rafter (part of a house)]
berye{bryh}/Xberyes{brywT}/H [m/f] [def: expert; hard-working person; efficient housewife (f)] 
	beryesh{bryhsh}/K [def: skillful, deft, expert] /Idik
		be'ryeshkayt{bryhshkayt}/N [f] be'ryeshaft{bryhshaft}/N [f] [def: expertise]
	berye{bryh}/V/T [def: manage under difficult circumstance (with "zikh")] 
		/Goys [def: show off, ostentate (with "zikh")]
berze/S [f] [def: stock exchange] berzn/A
	bi'rzhevik/Ees [m] [def: stock broker]
beshas{bSeT}/H/P [def: while]
beshtike{bSWyk|h}/H [def: silently; surreptitiously]
beshum{bSwm}/H [def: in no manner of]
-/Xbesomem{bQmym}/H [def: spices]
bestye/S [f] [def: beast] bestyal/A /Iish
bet/N/D [n/f] [def: bed]
	bankbet/D [f]
	fe'ldbetl/Eekh [n] [def: cot]
	he'sebet{hsb-bet}/N [m/f] [def: pillowed seat for Passover Seder leader]
	iberbet/N [n] [def: bedcover, comforter] 
	himlbet/N [n/f] [def: canopy bed; sofa bed]
	oysleygbet/N/D [n] [def: folding bed (opened when needed)]
	ti'shgebet/N [n] [def: tablecloth] % Sholem Aleykhem
	to'plbet/N [n] [def: double bed]
	tro'gbletl/Eekh [n] [def: stretcher] % Opatoshu
	bet/V/T /Gunter [def: use as a sheet; stuff]
	[idiom: gelegn tsu bet = sick]
bet/V/T [def: request] /Gon/Gtsu/Garoys/Gop % < Gothic bida "pray"
	/Giber [def: reconcile]
	/Gayn/Garayn [def: invite]
	/Goys [def: attain by requesting]
	bet/V/Bgebotn [def: request] /Giber/Gayn/Gon % both participles exist
	farbet/V/Bfarbet [def: invite] farbetung/N [f] [def: invitation]
	derbet/V/Bderbet [def: achieve by request] % Esther Kraytman: Briliantn
	% the adjectival form is not the participial, but "gebetn", with all
	% converbs
	iberbetung/N [f] [def: reconciliation] % Forwards: Ludin
	u'mgebe'tn/A u'mfarbe'tn/A [def: uninvited; unasked-for]
	oy'sgebe'tn/A [def: requested]
	gebot/X/N [n] [def: commandment]
	gebe't/N [n] [def: prayer; plea] % Harduf 
	beter/S [m] [def: requester]
	shtilbet [def: silent request]
	[idiom: zikh lozn betn = play hard-to-get]
	[idiom: vi ir hot gebetn = as per your request] [note: V]
	betl/V/T [def: beg] /Gtsuzamen/Goys
		betler/S/Xbetleyrim [m] [def: beggar] /D /Iish be'tlerin/S [f] [def: beggar-woman]
betokhn{btHwn}/H [def: trust, confidence]
	betuekh{btwH}/Xbetukhem{btwHym} [def: confident]
	mavtiyekh{mBtyH}/H [verb] [def: assure (with "zayn")] 
	muvtekh{mwBtH}/H [def: trusted]
	bal_betokhn{bel-btHwn} [m] [def: optimist]
	[idiom: hot betokhn{btHwn} = be of good courage!]
beto'n [m] [def: concrete] 
betshe/V/T [def: bleat, jabber] 
	betsh/N [m] [def: bleat (sound of a sheep)]
beyde beydn beydns beyder [def: both]
beyg/V/Bgeboygn [def: bend, decline (grammar)] % not "boyg"
	/Gariber/Garop/Gayn/Gon/Garunter/Gunter/Gtsu/Giber/Gavek/Gop
	/Goys [def: droop]
	farbeyg/V/Bfarboygn [def: bow]
	tsebeyg/V/Btseboygn [def: bend]
	beygl/X [m] [def: bagel]
		beygldik/A [def: curved] % Sholem Aleykhem
		[idiom: lign in drerd un bakn beygl = be in straitened circumstances]
		[idiom: a lokh fun a beygl = absolutely nothing]
	boygn/S [m] [def: bow; sheet of paper] /Dbeyg
		elnboygn/S [m] [def: elbow]
		fregboygn/S [m] [def: questionnaire]
		regnboygn/S/Idik [m] [def: rainbow]
		tsetlboygn/S [m] [def: account sheet] % Der Nister
		[idiom: ibertsien dem boygn = exaggerate]
		[idiom: fayl oysn boygn = rapidly]
	boygik/A [def: bent] beygik/A beygevdik/A boygzam/A [def: flexible, lithe]
		beygevdikayt/N [f] [def: flexibility] 
		u'mbey'gik/A u'mbey'gevdik/A [def: inflexible, rigid]
	beygung/N [f] [def: bending, declension (grammar)] 
	oysbeyg/N [m] [def: bend, curve] 
	ibergeboygnkayt/N [f] [def: bent-over nature] % Der Nister
beylik [def: white meat (poultry)]
beyn/Eer [m] [def: bone]
	/Iish /Iik /Ierdik /Ierik [def: bony]
	/Iern [def: made of bone]
	/Dbeynd [def: little bones; gambling]
	gebeyn beynikayt/N [f]
	breytbeynerik/A [def: large-boned]
	baknbeyn/Eer [m] [def: cheekbone] 
	breytbeynik/A [def: strong-boned]
	elfnbeyn [m] helfandbeyn [m] [def: ivory]
	fishbeyn/Eer [m] [def: fish bone; whalebone; corset stay]
	hirshnbeyn [m] [def: antler (material)] % Sholem Aleykhem
	markhbeyn [m] [def: marrow bone]
	nozbeyn [m] [def: nasal cartilage]
	ruknbeyn [m] [def: backbone]
	knibeyndl/Eekh [n] [def: kneecap, patella (body part)] 
	shpitsbeynik/A [def: scrawny]
	vintshbeyndl/Eekh [n] [def: wishbone (American)] 
	[idiom: aroystsien di kley fun di beyner = impoverish]
	[idiom: onbrekhn di beyner = attack, harm]
	[idiom: a yung mit beyner = a strapping lad]
	[idiom: ton emetsn in beyn = purposely annoy]
	[idiom: hitn di beyner = be careful]
beyn_hashmoshes{byn-hSmSwT}/H [m] [def: evening, dusk] /Idik
	beyn_hashmoshesdikayt{byn-hSmSwTdikayt}/N [f] [def: duskiness]
beyomeynu{bymynw}/H [def: in our days]
beys_{bʼ}/H [m/f] [def: Hebrew letter Beys]
beys{beT}/H/P [def: while; during]
beyt/N [f] [def: (garden) bed] 
beytse{bych}/Xbeytsem{bycym}/H [f] [def: egg; testicles (in plural)]
beyz/K [def: evil, bad; angry; indignant; fierce, severe] /Iik /Ilekh
	beyzer/V/T [def: become angry (with "zikh")]
	gebeyzer/S [n] [def: anger]
	tsebeyzer/V/Btsebeyzert [def: become angry]
	derbeyzer/V/Bderbeyzert [def: anger, vex; become angry (with "zikh")]
	beyzkayt/N [f] [def: anger, malice] 
	[idiom: mit beyzn = by force]
	[idiom: mit gutn tsi mit beyzn = by hook or by crook]
bez/N [m] [def: lilac]
bezbozhnik/Ees [m] bezbo'zhnitse/S [f] [def: atheist (Russian безбожник)] % Boris Sandler
bezbushnik{bezbwShnik}/Ees [m] bezbu'shnitse{bezbwShnitse}/S [f] [def: shameless person]
bezdushne/A [def: soulless]
bezem/S/Eer [m] [def: broom] /D 
	bezem/V/T [def: lash with a broom (in a bath house)] % Sholem Aleykhem: Oreme un Freylekhe
	[idiom: biz di nayer bezemer = for a long time] % Itsik Kipnis
beznog [m] [def: amputee, legless person (Russian безногий)] % Avrom Karpinovitsh
bezo'l{bzwl} [adj] [def: cheap, inexpensive]
bezpokoye/V/Bbezpokoyet [def: bother (Russian беспокоить), exert effort (Russian)] 
bezshe [f] [def: unbleached cotton cloth (material)] /In
bgide{bgydh}/H [f] [def: treason] 
bibele/S [f] bibulke/S [f] [def: cigarette paper]
biber/S [m] [def: beaver] /In
	bobrik [m?] [def: fake beaver fur]
	[idiom: shvitsn vi a biber = sweat profusely]
	[idiom: tseveynen zikh vi a biber = weap copiously]
bibl [f] [def: Bible] /Iish
	biblyotek/N [f] [def: library]
		shtatbiblyotek/N  [def: public library]
		biblyoteker/S [m] biblyote'kerin/S [f] biblyote'kershe/S [f] [def: librarian] 
	biblyografye/S [def: bibliography] biblyografish/A [def: bibliographical]
		biblyogra'f/N [m] [def: bibliographer]
bi'deve/V/T [def: suffer (with "zikh"); drudge]
	/Giber [def: suffer until a calamity is finished] % Y. Y. Singer
	/Gon [def: suffer for a long time]
	bidne/A [def: unfortunate, wretched]
bifsteyk/N [m] [def: beefsteak, steak (food)]
bigl/V/T [def: iron, press] /Goys/Gop
	u'mgebi'glt/A [def: unpressed]
bigo't/N [m] [def: bigot] /Iish
	bigo'tishkayt/N [f] [def: bigotry]
bik/Ees [m] [def: bull (animal)] /D
bikarbonat [m] [def: bicarbonate]
biker{bykwr}/H [def: visit, search] mevaker{mBkr}
biks/N [f] [def: rifle (weapon)] /D
	besomem{bQmym}-biksl/Eekh [def: spice pouch]
bil/V/T [def: howl (sound of a dog), bark (sound of a dog)] /Gon
	biler/S
	tsebil/V/Btsebilt [def: make a loud sound] % Sutskever
	bileray'/N [f/n] [def: barking] 
bilbl{bylbwl}/Xbilbulem{bylbwlym}/H [m] [def: slander, calumny]
	mevalbl{mBlbl}/H [verb] [def: confuse (with "zayn")]
		mevulbl{mBwlbl} [adj] [def: confused] 
bild/Eer [n] [def: picture] /D bi'lderish/A [def: picturesque]
	bildlekh/K [def: picturesque]	
	bilderishkayt/N [f] [def: picturesqueness]
	kritsbild/Eer [f] [def: engraving; tatoo]
	likhtbild/Eer [f] [def: slide, transparency (photographic)] 
	shpiglbild/Eer [def: mirror image]
	bild/V/T [def: paint] /Gop
	opbild/Eer [n] [def: image] 
bild/V/T [def: educate] /Goys
	bildung/N [f] [def: education]
		ay'nbildung/N [f] [def: fantasy]
		fakhbildung/N [f] [def: vocational education] 
		folksbildung/N [f] [def: public education] % Forwards: Khariton Berman
		zelbstbildung/N [f] [def: self-education] 
	gebildet/A [def: educated]
	u'mgebi'ldet/A [def: uneducated]
	yesod{yswd}-bildung [def: basic education]
bile't/N [m] [def: ticket]
	ba'nbile't/N [m] [def: railway ticket]
	b|khinem{Hynm}-bile't [def: complimentary ticket] 
	fli-bile't/N [m] [def: plane ticket] [note: V]
bilik/K [def: cheap]
	shpot-bilik/A [def: dirt cheap]
	farbilik/V/Bfarbilikt [def: cheapen]
bilkher/A [def: preferable]
bilyard [n/m] [def: billiards (game)]
	bilyardove/S [f] [def: billiard hall] % Avrom Karpinovitsh
bilyon/N [m] [def: billion] 
	bilyone'r/N [m] [def: billionaire]
bim-bom [interj] [def: ding-dong (sound of a bell)]
bimber [m] [def: pocket watch (ganovem-loshn)]
bime{bymh}/H [f] [def: readers platform in a synagogue]
bimkem{bmkwm}/H [n] [def: substitute] [prep] [def: instead of]
bin/N [f] [def: bee (insect)]
	binekhe/S [f] [def: bee] % Z. Shneyer
	ferdbin/N [f] [def: hornet (insect)]
	va'serbin/N [f] [def: drone (male bee)]
bin bist bistu iz zay zaynen zenen zayt zent zaynt zayn geven gevezn/A [def: be]
	binen izn [def: be] [grammar: redoubled form]
	iz [conj] [def: so] [grammar: at start of sentence; not a sentence unit]
	baygeven [def: be present] baytsuzayn bayzayn
	voylzayn [def: well-being]
	zayendik/A [def: being] zayik/A [def: existing] 
	/Vopzayn/Bopgeven [def: be absent; stay as long as]
		[grammar: not in present tense]
		opzayn [m] [def: absence]
	/Voyszayn/Boysgeven [def: to have been in many places; to stay a while] [usage: not in present tense]
	sʼiz [def: it is]
	gevezn/A [def: former] 
bind/V/Bgebundn [def: bind; commit oneself (with "zikh")]
	/Garayn/Garum/Gtsu/Gtsunoyf/Gtsuzamen/Gunter/Gop/Giber/Goys/Gon
	/Goyf [def: untie; become free of debt; lose virginity; bear a child (with "vern")]
	u'mgebu'ndn/A [def: untied; unhemmed; disjointed]
	derbind/V/Bderbundn farbind/V/Bfarbunden [def: bind]
	aynbinder/S [m] [def: bookbinder] aynbinderin/S [f] 
		aynbindn/V/Bayngebundn [def: bind books] aynbund [def: binding (bood)]
	farbind/V/Bfarbundn [def: unite]
		farbindung/N [f] [def: compound (chemical)]
		farbinder/X [def: hyphen; uniter; contact (person)]
		farbi'ndenish/N [n] farbundnkayt/N [f] farbindung/N [f] [def: unification]
			gesheft|s-farbindung/N [f] [def: network (professional)] [note: V] 
			gezelshaft-farbindung/N [f] [def: network (social)] [note: V] 
		farba'nd/N [m] [def: union]
			alfarbandish/A [def: (Soviet) Union-wide]
			ra'tnfarba'nd/Iish [m] [def: Soviet Union]
	tsebind/V/Btsebundn [def: untie; unclasp]
	bund/N [m] [def: alliance, association, Jewish Labor Party] /Iish
		bundi'st/N [m] bundistke/S [f] [def: Bundist, member of Jewish Labor Party]
		bundi'zm [m] [def: Bundism]
		shlislbund/N [def: keyring] % Daytshmerism?
		tsuzamenbund/N [def: connection]
		tsubund/N [m] [def: attachment; fondness]
	bindik/A [def: coherent]
	binde/S [f] [def: sling] 
	/Dbint [def: bundle] 
		bintlekhvayz [adv] [def: in groups]
	tsugebundnkayt/N [f] [def: close friendship] 
	[idiom: geknipt un gebundn mit = part and parcel of]
	band/Xbend [m] [def: volume (book)]
		filbendik/A [def: multi-volume] % Forwards
	band/Xbender [f] [def: ribbon, band, tape] /Dbend
		akslband/Xakslbender [f] [def: epaulette (clothing)]
		arumband/Xarumbender [f] [def: cummerbund (clothing)] 
		gartlband/Xgartlbender [def: cummerbund (clothing)] 
		haldzband/Xhaldzbender [f] [def: necklace (clothing)] 
		kopband/Xkopbender [f] [def: headband (clothing)] 
		oremband/Xorembender [f] [def: bracelet (clothing)]
		reyfband/Xreyfbender [def: cummerbund (clothing)]
		shukhbendl/Eekh [n] [def: shoelace (clothing)]
		shtimband/Xstimbender [f] [def: vocal chord] % Der Tumler
		zo'knbendl/Eekh [n] [def: garter (clothing)]
bine/S [f] [def: stage (in a theater)]
	[idiom: oyfesn di bine = steal the show]
binokl/N [m] [def: binocular; opera glass]
binyen{bnyn}/Xbinyonem{bnynym}/H [m] [def: building]
bir/N [n] [def: beer] /D
	vortslbir/N [n] rutbir/N [n] [def: root beer] [note: V] 
	[idiom: englishe bir = ale]
birger/S [m] [def: citizen] /Ilekh
	birger/V/T/Gayn [def: settle (a country)]
	birgershaft/N [f] [def: citizenship]
	birgertum [n] [def: citizenry] % Forwards
	kley'nbirger/X/S [m] [def: petty bourgeois; lower middle class] /Ilekh
-/Xbirgolen [def: female breasts (body part) (klezmer-loshn)]
bis/N [m] [def: encore] bis [interj] [def: encore!] 
	[idiom: oyf bis = as an encore]
	bis/D abisl bishinke [def: bit]
	bislekh/A [def: somewhat]
	bislekhvayz [adv] tsubislekh [adv] [def: by small amounts] 
biskup/N bishof/N [m] [def: bishop]
	artsibishof/N [m] arkhibishof/N [m] [def: archbishop] % Shpiglblat
biskvit/N [m] [def: biscuit (British), cracker (food)] /D
bistre/A [def: swift; agile; over-clever] 
bit/N [m] [def: basin, tub] /D
bite [interj] [def: please] [usage: doubtful admissibility]
	bite/S [f] [def: request]  [usage: doubtful admissibility]
bitel{bytwl}/H [def: nullification]
biter/K [def: bitter] biterlekh/A
	biternish/N [n] [def: bitterness]
	biterkayt/N [f] [def: bitterness] 
	farbiter/V/Bfarbitert [def: make bitter]
		farbiterung/N [f] [def: bitterness]
bitsikli'r/V/Bbitsikli'rt [def: ride a bicycle] 
	bitsikle't/N [def: bicycle]
bivua'k/N [m] [def: bivouac, improvised shelter]
biye{by#h}/ [f] [def: sexual intercourse] 
biyesh{bywS}/H [def: embarrassment]
	mevayesh{mBywS}/H [verb] [def: embarrass (with "zayn")] 
	bushe{bwSh}/Xbushes{bwSwT}/H [def: embarrassment, shame]
	bayshn{bESn} [m] [def: easily embarrassed person]
	[idiom: nit brengen tsu bushe{bwSh} = save face] [note: V]
biz/P [def: until, at the time (in future) when] bizkl
bizmut [m] [def: bismuth (Bi)] 
biznes/Ees [m] [def: business, trade] [usage: doubtful admissibility]
bizoyen{bzywn}/Xbizyoynes{bzywnwT}/H [m] [def: embarrassment, shame; insult]
	mevaze{mBz|h}/H [verb] [def: embarrass, shame, insult (with "zayn")] 
	mevazedik{mBz|hdik}/A [def: shameful]
	mevuze{mBwz|h} [adj] [def: unworthy, dishonorable, ugly; insulted (with "vern")]
	nivze{nyBz|h}/Xnivzim{nyBzym} [m] [def: contemptible person] /Idik [def: despicable, disgusting]
	mevuze_umevaze{mBwz|h-|umBz|h} [verb] [def: ridicule (with "zayn")]
bkhine{bHynh}/Xbkhines{bHynwT}/H [f] [def: test; category]
bkhire{bHyrh}/H [f] [def: choice]
bkhor{bxwr}/Xbkhorem{bxwrym} [m] [def: first-born]
	bkhoyre{bxwrh}/H [f] [def: right of the first-born; right of way] 
blami'r/V/Bblami'rt [def: dishonor oneself (with "zikh")]
blank/V/T [def: gleam]
	blank/N [m] [def: blank (form)] 
	blank/A [def: glossy, shiny, brilliant; spick-and-span] 
blas/K [def: pale]
	blaskayt/N [f] [def: paleness]
	bloyblas/A bloblas/A [def: pale blue] 
	farblas/V/Bfarblast [def: become pale] % Der Nister
blat/Xbleter [m/n] [def: leaf, page; newspaper (informal)]
	/Dblet [def: leaflet, handout (paper)] 
	ble'terish/A [def: leafy] 
	bleter/V/T [def: turn pages; surf (internet)] /Goyf/Gdurkh/Giber
	barekhn-blat/Xbarekhn-bleter [m/n] [def: spreadsheet] 
		oysrekhn-blat/Xoysrekhn-bleter [m/n] [def: spreadsheet] 
	faygnblat/Xfaygnbleter [m/n] [def: fig leaf]
	fli'bletl/Eekh [n] [def: flyer, brochure] % Forwards
	flugblat/Xflugbleter [m/n] /Dflugblet [n] [def: leaflet] 
	fokhnblat/Xfokhnbleter [m/n] [def: gingko (tree)]
	heymblat/Xheymbleter /Dheymblet [m/n] [def: home page (computer)]
	klepbletl/Eekh [n] [def: post-it note] [note: V]
	krikhblat/Xkrikhbleter [def: vine, tendril] 
	kroy'nbletl/Eekh [n] [def: petal (botanical)]
	kvores{kBrwT}-bletl/Eekh [n] [def: gray hair] % Harkavy
	lo'rberble'tl/Eekh [n] [def: bay leaf (food)] % Forwards: S-R Schaechter
	-/Xsam{sm}-bletlekh [n] [def: poison ivy] % Weinreich
		[idiom: baysn emetsn fun sam{sm}-bletlekh = have poison ivy] [note: V]
	-/Xsharfbleter [n] [def: holly (tree)] 
	-/Xtey'bletblekh [n] [def: tea leaves] % Yiddish League
	togblat/Xtogbleter [m/n] [def: newspaper]
	tseglider-blat/Xtseglider-bleter [m/n] [def: spreadsheet] 
	tsiferblat/Xtsiferbleter [m/n] [def: watchface] /Dtsiferblet
	vebsblat/Xvebsbleter /Dvebsblet [m/n] [def: web site]
	vokhnblat/Xvokhnbleter [def: weekly publication] % Harduf
	[idiom: leyenen/zingen/shpiln fun blat = sight read/sing] [note: V] 
blat/A [def: illegal; underworld]
	blatnik/Ees [m] [def: organized criminal] % Sholem Aleykhem
	[idiom: shlogn blat mit = join up with]
blay/N/A [n] [def: lead (Pb)] /Ien /Iern
	blayer/S 
blayb/V/Bgeblibn [def: remain; be decided (with "bay")] /Giber/Goys/Gtsurik
	farblayb/V/Bfarblibn [def: remain, survive]
	iberblaybekhts/N [n] [def: remnant]
	blaybik/K [def: permanent] 
	lebnsgeblibener/S [def: survivor]
bleke/V/T blekekhts/V/T [def: bleat (sound of a sheep)] 
	blekets/V/T [def: chant unintelligibly] 
	blekekhts/N [n] [def: bleating]
blekh/N [n] [def: tin; tin plate; badge]
	/Iern /In [def: tin] 
	/D [def: tin can]
	blekher/S [m] [def: tinsmith] 
	blekheray'/N [f] [def: tin works] 
	shitsblekh/N [n] [def: fender (fireplace); bumper (automotive)]
blend/V/T [def: dazzle; blind]
	ble'ndenish/N [n] [def: delusion, dazzlement; blind-man's bluff (game); buttercup (flower)]
	blendekhts [n] [def: glamor; dazzle]
blender/S [m] [def: blender (American)] 
bleykh/K [def: pale] gebleykht/A oysgebleykht/A
	bleykhkayt/N [f] [def: paleness]
	bleykh/V/T [def: bleach] 
		bleykhekhts/N [n] [def: bleach]
	farbleykht/A [def: dim, pale] % Forwards: Ludin
bli/V/T [def: bloom] /Goyf/Goys/Gfunander/Gop
	tsebli/V/Btsblit [def: bloom, blossom, flourish]
	farbli/V/Bfarblit [def: fade, wither] 
	bli/N [m] [def: bloom, prime] 
		oyfbli/N [m] [def: flourishing; blossoming]
	blum/N [f] /Dblim [n] [def: bloom, flower]
		bliml/V/T [def: bloom] % Forwards
		fe'ldblum/N [f] [def: meadow flower]
		glo'knblum [def: bluebell (flower, Hyacinthoides spp.)]
		ki'mlblum/N [f] [def: caraway flower]
		kornbliml/Eekh [n] [def: cornflower (Centaurea cyanus)] % Stutchkoff
		monblum/N [f] [def: poppy flower]
	bliekhts/N [n] [def: blossom] 
	bliung/N [f] [def: blooming] 
	shpet-tseblier/S [m] [def: late bloomer] [note: V] 
bli{bly}/H [def: without]
blik/V/T [def: blink] /Gop/Garayn/Garoys
	blik/N [m] [def: glance]
		araynblik/N [m] [def: glance, cursory inspection]
		aroysblik/N [m] [def: view; panorama] 
		iberblik/N [m] [def: overview]
		onblik/N [m] [def: appearance; vista] 
			[idiom: hobn dem onblik fun = resemble]
			[idiom: oyfn onblik = at first glance]
		opblik/N [m] [def: sideways glance]
		oygnblik/N/D [def: blink of an eye]
		oysblik/N [m] [def: point of view] 
		tsurikblik/N [def: retrospect]
blind/A [def: blind] /Ilekh [def: near-blind]
	blindkayt/N [f] [def: blindness] 
	blinderheyt [adv] [def: in a state of blindness] 
	blindevate/A [def: blind] % Forwards: Boris Sandler
	blend/V/T [def: shimmer; be dazzling]
		farblend/V/Bfarblendt [def: dazzle; trick the eyes]
		farble'ndenish/N [n] [def: hallucination]
		blendik/A [def: dazzling]
	-/Xblindelekh [def: children's game, like hide-and-seek (game)]
blintse/S bline/S blintshe/S [f] [def: crépe, blintz (food)]
blishtshe/V/T blintsl/V/T [def: sparkle, glitter, twinkle; shine]
	blishtsh/N [m] [def: glitter, glamor] 
blit/N [m?] [def: young sprout (botany)]
	bavlblit/N [def: cotton blooms] % L. Shapiro
blits/V/T [def: flash] /Garoys/Goyf
	tseblits/V/Btseblitst [def: flash]
	blits/N [m] [def: flash, lighting] /Iik [def: sparkling]
	[idiom: meg dunern un blitsn = come hell or high water]
blitshke [f] [def: wool yarn] /In % Sholem Aleykhem
blo/A bloy/A bloyik/A bloylekh/A [def: blue] 
	helbloy/A [def: bright blue] % Sholem Aleykhem
	bloykayt/N [f] blokayt/N [f] [def: blueness] 
	bloy/V/T [def: become blue (with "zikh")] 
blof/V/T [m] [def: bluff] 
	blof/N [m] [def: bluff] 
	blofer/S [m] [def: bluffer; liar] 
blog/N [m] [def: blog, weblog] [note: V] 
	blogi'r/V/Bblogi'rt [def: write a weblog] [note: V]
	bloger/S [def: blogger] % Forwards: S-R Schaechter
	blogeray'/N [n] [def: blogging]
blok/N [m] [def: block (of houses)] kinderblok/N
	bloknot/N [m] [def: note pad] 
	klepblok/N [m] [def: post-it pad] [note: V]
blokir/V/Bblokirt [def: block, obstruct]
	blokade/S [f] [def: blockade]
blond/A [def: blond] /Iin /Iink
blondzhe/V/T [def: wander aimlessly, ramble; go astray] /Gavek/Garum
	farblondzhe/V/Bfarblondzhet [def: become lost]
		farblo'ndzhenish/N [n] [def: wandering lost]
	blondzhe [m] [def: wander (with "ton")] 
		blo'ndzhenish/N [n] [def: aimless wandering]
	blonke/V/T [def: wander] /Garum
		farblonke/V/Bfarblonket [def: become lost]
		blo'nkeve/V/T % Stutchkoff
blote/S [f] [def: mud; dirt; nonsense] blotik/A blotkele
	farblotik/V/Bfarblotikt [def: muddy]
	blotikerheyt [adv] [def: muddily]
	[idiom: araynforn in a blote = land in a mess]
bloter/S [m] [def: blister] /Dbleter
	[idiom: yeytser-hore{ycr-hre} bleterl = hickey]
bloyz/A [def: unadorned, plain; naked] /Ilekh
	antbloy'z/V/Bantbloy'zt [def: bare, uncover]
		antbloyztkayt/N [f] [def: nakedness]
	bloyz [adv] [def: just, only]
	bloyz/N [m] [def: gap, lacuna, hole]
	oysbleyz/V/T [def: denude, uncover, strip]
bloz/V/T [def: blow (air); gloat (with "zikh")] /Garayn/Garoys/Goys/Gavek
	/Gon [def: be prideful (with "zikh")]
	/Bgeblozn /Garayn/Gon/Goys/Gavek [def: blow] % variant participle
		/Goyf [def: inflate; kindle]
	tsebloz/V/Btseblozn/Btseblozt [def: blow on coal to make a fire]
	farblozn/A [def: wind-blown] % Der Nister
	bloz/N [m] [def: blow; bladder (body part)] 
	blozer/S [m] [def: blower]
		bleter-blozer/S [m] [def: leaf blower]
		fayer-blozer/S [m] [def: blow-torch] % Forwards: S-R Schaechter
	/Dblez [def: bubble] /Dgazblez [def: gas bubble]
		blezl/V/T [def: bubble] /Garoys
		zeyfblezl/Eekh [n] [def: soap bubble] 
		ble'zerl/Eekh [n] [def: dandelion (plant)]
	[idiom: blozn fun zikh = put on airs]
bludne/A [def: prodigal (Russian блудный)] % L. Shapiro, Sholem Aleykhem
blut/N [n] [def: blood] blutik/K [def: bloody]
	geblit/N [def: blood]
	blut/V/T [def: bleed]
	blu'tikayt/N [f] [def: bloodiness]
		fulblu'tikayt/N [f] [def: power, full force]
		reynblu'tikayt/N [f] [def: purebloodedness] % Forwards: Yoel Matveyev
	blutik/V/T blut/V/T [def: bleed; become bloody (with "zikh"); make bloody]
		[idiom: es blutikt im = he is bleeding]
	farblutik/V/Bfarblutikt [def: make bloody]
	mentshnblut/N [n] [def: human blood]
	tseblutik/V/Btseblutikt [def: make bloody]
	tsignblut/N [n] [def: goat's blood] % Forwards: S-R Schaechter
	kaltblutik/A [def: without sympathy; indifferent]
		kaltblutikayt/N [f] [def: indifference]
	[idiom: geyn bizn blut arayn = come to blows]
bluze/S [f] [def: blouse] bluzke/S/D [f]
blyage/V/T [def: attempt to convince, tell a slight lie] % Forwards: M-S Hoffman
	blyage/S [f] [def: trickery, fraud]
	blyager/S [m] blyagerke/S [f] [def: swindler, humbug, imposter]
blyaki'r/V/Bblyaki'rt [def: bleach, fade (color)] /Gop/Goys
	blya'keve/V/T /Gop [def: bleach, fade (color)]
	blyake/V/T /Gop [def: bleach, fade (color)] % Shpiglblat
blyask/N [m?] [def: bright light] % khvalyes khapn zikh on, on a blyask fun der levone
bob/Ees [m] [def: broad bean, fava bean, Vicia_faba (food)] /Dbeb
	soyebob/Ees [m] [def: soybean]
	stroy'tshebob/Ees [m] stru'tshkebob/Ees [def: string beans (food)] % Shaechter
	bo'besnitse/S [f] [def: (cooked) bean seller]
	[idiom: shvartser bob = common vetch]
	[idiom: himl un erd un strutshkebob = everything but the kitchen sink]
bobe/S/C/J [f] [def: grandmother] bobish/A
	bobenyu [f] [def: dear grandmother]] 
	bobele [f] [def: little grandmother, baby]
	elter-bobe/S [f] [def: great-grandmother] 
	zeyde-bobe [def: grandparents] % plural
	babske [adj] [def: old-wives'] [grammar: indeclinable]
	ba'betshke/S [f] ba'betse/S [f] [def: little grandmother]
	shlepe-bobe [f] [def: blind-man's bluf, Colin Maillard (game)]
	[idiom: babske refues{rfw#wT} = folk remedies]
bobke/S [f] [def: goat or sheep excrement; something worthless (vulgar)]
bobre/V/T [def: mess around (with "zikh"), move with difficulty (with "zikh")]
bod/V/T [def: bathe; wallow (with "zikh"); punishment] /Goys/Gop
	/Bgebodn /Goys/Gop % variant participle
	[idiom: heys gebodn = eydl gebodn = aristocratic]
	bo'deve/V/T [def: swim] % Avrom Karpinovitsh
	bod/Xbeder [f] [def: bath]
		shvitsbod/Xshvitsbeder [f] [def: Turkish bath] 
		[idiom: ikh hob dikh in bod = to hell with you]
		[idiom: firn in bod arayn = dupe, deceive]
		[idiom: aroyfleygn di bod (af emetsn) = blame (someone)]
	bederay'/N [n] [def: occupation supervising a bath house]
	gebodenerheyt [adv] [def: having bathed]
	beder/S [m] [def: bath-keeper] 
	blutbod [f] [def: bloodbath, pogrom, massacre, slaughter]
boday [adv] [def: even; if only; rather]
bodn/S [m] [def: terrain, ground, soil] 
	valdbodn/S [m] [def: forest floor] 
bohe'm/N [m] /Iish bohemyen/N [m] [def: Bohemian, artist, sensualist]
bohemyum [m] [def: rhenium (Re)] 
bok/Xbek [m] [def: male goat]
bokal/N [m?] [def: goblet] 
bokem bokom [adj predicative] [def: awry]
	[idiom: oysfaln/oysgeyn bokem = go awry]
bokh/N [m] [def: river, stream] /D
bokher{bHwr}/Xbokhrem{bHwrym}/H /Ish /Iish [def: bachelor; adolescent boy, young man; fellow; penis (body part) (jocular)]
	bokherte{bHwrte}/S [def: lass, wife]
	bokherl{bHwrl}/Xbokhuremlekh{bHwrymleX} [n] [def: bachelor]
	bokhere'ts{bHwrets}/N [def: lad; prankster] [usage: pejorative, humorous]
	bokhervayz{bHwrvayz} [def: as a lad]
	bokher{bHwr}/V/T [def: dress to attract women (with "zikh")]
	bokhershaft{bHwrshaft} [def: bachelorhood]
	khosn_bokher{HTn-bHwr} [m] [def: marriagable lad] 
	yeshive_bokher{ySyBh-bHwr} [m] [def: yeshivah student] 
boks [m] [def: boxing (sport)] 
	bokser/S [m] [def: boxer] 
	boks/V/T [def: box (sport)] 
bokser/S/N [m] [def: carob] 
boky{bky}/Xbekiyem{bkAm}/H [m] [def: expert]
	bekiyes{bky#wT} [f?] [def: expertise]
bol [m] [def: ball] 
	fusbol [m] [def: soccer (sport); soccer ball]
	hantbol [m] [def: handball (sport)]
	koyshbol [m] [def: basketball (sport)] 
	netsbol [m] [def: volleyball (sport)] 
	oy'smaydbol [m] [def: dodge ball (sport)] 
bolbe/V/T bolbene/V/T [def: prattle, chatter] /Goys [def: tell tales]
bolshevi'st/N [m] /Iish [def: Bolshevist]
	 bolshevik/Ees [m] bolshevistke/S [f] [def: Bolshevist] 
boltay'/V [def: prate, babble] % Stutchkoff
bom [n] [def: a nonsense syllable for singing]
	bomke/V/T [def: sing nonsense syllables]
		/Gunter [def: sing along]
		/Gtsu /Gnokh [def: agree verbally]
			u'nterbomker/X/S [m] no'khbomker/X/S [m] tsu'bomker/X/S [m] [def: yes-man, flunky] % Stutchkoff
		tsebomke/V/Btsebomket [def: sing nonsense syllables] % Sholem Aleykhem
	bom/V/T /Gtsu [def: mumble in agreement]
	bamke/V/T [def: sing nonsense syllables]
bombe/S [f] [def: bomb]
	atom-bombe [def: atomic bomb] [note: V] 
	brenbombe/S tsindbombe/S [def: fire bomb]
	yoder-bombe [def: nuclear bomb] [note: V] 
	bombardi'r/V/Bbombardi'rt [def: bomb]
		tsemombardi'r/V/Btsebombardi'rt [def: bomb]
		bombarde/S bombardirung/N bombirung/N [f] [def: bombardment]
	bombastik [f] [def: bombast; pride] bombastish/A [def: bombastic; prideful] 
bombl/V/T [def: toss in the wind (clothing); dangle (with "zikh")]
	/Garop/Gunter/Gnokh
bombonierke/S [f] [def: box of candies]
bomut [def: part of equipment connecting horse to cart] 
-/Xbondlekh [def: beans] [usage: Polish Yiddish, Carpathian Yiddish]
bonder/S [def: woodworker; good-for-nothing]
	[idiom: zetsn vi a bonder = display ignorance]
bonk/Ees [m] [def: bastard]
	bonkevate/A [def: sly (with "oygn")] % Sholem Aleykhem
bonus/N [m] [def: bonus] 
bor [m] [def: boron (B)] 
borbl/V/T [def: wriggle, squirm (with "zikh")]
bord/Xberd [f] [def: beard] /Dberd
	berdik/A bordik/A baberdikt/A baberdlt/A [def: bearded]
	ba'knbord/Xba'knberd [f] [def: sideburn]
	gelbord/N [def: blond beard]
	kozheberdl/Eekh [n] kozeberdl/Eekh [n] [def: goatlike beard] % Stutchkoff
	baknbard/N/Xbaknberd [m?] [def: Franz-Josef beard]
	[idiom: a vits mit a bord = a stale joke]
borde'l/N/S [m?] [def: bordello, house of prostitution] % < PIE *bherdh "wooden plank"
bordo [adj] [def: bordeaux (color)]
bore/V/T [def: fight (with "zikh")] /Gop
	/Gayn [def: conquer] % Sholem Aleykhem
borekh{brwx}/Xbrukhem{brwxym}/H [adj] [def: blessed]
	brokhe{brxh}/Xbrokhes{brxwT}/H [def: blessing]
	borekh_habe{brwX-hb#}/H [def: welcome] 
	yisborekh{yTbrx}/H [def: may he be blessed]
	hashem_yisborekh{hSm-yTbrx}/H [def: God (blessed be)]
	[idiom: makht brokhe{brxh} = have something to eat (imperative)]
	[idiom: in mazl{mzl} un in brokhe{brxh} = good luck (to them)]
borer{bwrr}/H [def: arbitrator]
	borer{bwrr}/H/V/T [def: arbitrate]
	boreres{bwrrwT}/H [n] [def: arbitration]
borg/V/T [def: lend, borrow] /Goys
	farborg/V/Bfarborgt [def: lend; hide]
	farborgn/A [def: hidden]
bo'rovke/S [f] [def: bilberry (Vaccinium spp.); lingonberry/cowberry (Vaccinium vitis-idaea); cranberry (Vaccinium oxycoccos) (Polish borówki)]
borsht/N [m] borshtsh/N [m] [def: beet soup]
	kratsborsht/N [m] [def: chopped herring (Khassidic)]
	[idiom: bilik vi borsht = very inexpensive]
bortik/Ees [def: part of a vest (clothing)] % Stutchkoff
borti'r/V/Bborti'rt [def: board (a conveyence)] 
	borti'r-kartl/Eekh [n] [def: boarding pass] 
bortn/S [m] [def: shore, coast] 
borves/A [def: barefoot]
boryum [m] [def: bohrium (Bh)] 
bos/Xboses [def: boss (English)]
boser{bQr}/H [def: flesh]
bosya'k/Ees [m] [def: drifter, vagabond]
bot/N [m] [def: boot (clothing; for rain or snow)] 
	botik/Ees [m] [def: boot] /D
bot/V/Bgebotn /Gon [def: bid, offer] % rare in plain form
	onbot/N [m] [def: bid, offer] 
botanik [f] [def: botany (subject)] botanish/A [def: botanical]
	botaniker/S [m] [def: botanist]
boterskatsh [m] [def: butterscotch] 
botl{btwl}/H [def: worthless; void, annulled]
	batl{btl}/H/V/T [def: waste] /Goys
	batlen{btln}/Xbatlonem{btlnym}/H [m] [def: unemployed person, loafer]
		batlones{btlnwT}/H [def: idleness; emptiness]
		batlon{btln}/Iish [def: idle]
	mevatl{mBtl}/H/V/T [verb] [def: nullify (with "zayn")]
	botl_umevutl{btl~|umBwtl} [adj] [def: nullifed] [grammar: predicative]
	levatole{lBtlh} [def: in vain]
	oyver_bo'tl{ewBr-btl} [adj] [def: senile] [grammar: predicative] /Ish
	bitl{bytwl}/H [m?] [def: nullification; disregard, disrespect] /Idik
bots [m] [def: dolt]
botshan/Ees [m] butshan/Ees [def: stork]
botshkar [m] [def: Chassid (klezmer-loshn)]
botshn/A [def: byways (with "vegn")] % Mendl Man
botvine botshene botshvene [f] [def: beet leaves] 
boy/V/T [def: build] /Goyf/Gtsu/Gnokh/Goys/Garayn/Gmit/Garum
	/Giber [def: rebuild]
	funanderboy [m] [def: development] % Forwards: Yitskhok Luden
	geboy/N [n] gebay/N [n] [def: construction; structure]
	oyfboy [m] oysboy [m] [def: construction]
	nokhboy [def: reconstruction]
	shifboyeray'/N [n] [def: ship building]
	gebayde/S [f] [def: building] gebay' [f?]
	boyung/N [f] [def: construction]
boyd/N [def: buggy, covered wagon (vehicle)] /Dbayd
boydek{bwdk} [verb] [def: inspect, examine (with "zayn")]
	badken{bdkn}/V/T [def: ritually inspect]
boydem/S/Xbeydemer [m] [def: attic (part of building)] /D
	[idiom: zikh oyslozn a boydem/taykh = come to nothing, fizzle out]
boye/S [f] [def: buoy]
boyer/V/T [def: perforate] /Goys tseboyer/V/Btseboyert
	boyer/S [m] [def: drill (tool)] 
	ekber/S [m] e'kboyer/S [m] [def: drill (tool)]
	ekber/V/T [def: bother]
boyker [m?] [def: slap] % Stutchkoff
	boyker/V/T [def: slap, thrash] /Gdurkh
boykh/Xbaykher [m] [def: belly] /Dbaykh
	baykhik/A [def: potbellied]
	bay'khldik/A [def: be pregnant (pejorative)]
	dikbaykhik/A [def: fat]
	fulbaykhik/A [def: potbellied] 
	[idiom: aynredn a kind in boykh = take advantage of gullability]
boykoti'r/V/Bboykoti'rt [def: boycot] boykot/N [m]
boylet{bwlt}/H/A [def: apparent, obvious] /Idik
boym/Xbeymer [m] [def: tree] /Dbeym
	beymish/A bey'merish/A [def: tree-like]
	barnboym/Xbarnbeymer [m] [def: pear (tree)]
	ey'bnboym/Xey'bnbeymer [m] [def: yew (tree)] % Perloff: bal-khay un foygl
	ey'khnboym/Xey'khnbeymer [m] [def: oak (tree)]
	ashboym/Xashbeymer [m] [def: ash (tree)] 
	bobboym/Xbobbeymer [m] [def: broom (shrub)]
	bokserboym/Xbokserbeymer [m] [def: carob (tree)] 
	eplboym/Xeplbeymer [m] [def: apple (tree)]
	faygnboym/Xfaygnbeymer [m] [def: fig (tree)]
	frukhtboym/Xfrukhtbeymer [m] [def: fruit tree]
	karshnboym/Xkarshnbeymer [m] [def: cherry (tree)]
	kestnboym/Xkestnbeymer [m] kashtanboym/Xkashtanbeymer [def: chestnut (tree)] 
	knupboym/Xknupbeymer [m] [def: elm (tree)] 
	la'rkhnboym/Xla'rkhnbeymer [m] le'rkhnboym/Xle'rkhnbeymer [def: larch (tree)]
	lindnboym/Xlindnbeymer [m] [def: linden (tree)]
	mandlboym/Xmandlbeymer [m] [def: almond (tree)]
	negelekh-boym/Xnegelekh-beymer [m] [def: clove tree (Syzygium aromaticum)]
	nezboym/Xnezbeymer [m] [def: maple] 
	nodlboym/Xnodlbeymer [m] [def: evergreen, conifer (tree)] 
	nu'snboym/Xnusnbeymer [m] [def: nut tree]
	te'nenboym/Xte'nenbeymer [m] [def: spruce (tree)] 
	tse'derboym/Xtse'derbeymer [m] [def: cedar (tree)]
	tsu'geboym/Xtsu'gebeymer [m] [def: hemlock (tree)] 
	valdboym/Xvaldbeymer [m] [def: forest tree] 
	vaynshlboym/Xvaynshlbeymer [m] [def: sour-cherry (tree)]
	yodleboym/Xyodlebeymer [m] [def: fir (tree); frost (on window)]
	[idiom: dos epele falt nisht vayt funem beymele = a chip off the old block]
boyml/N [m] [def: oil (edible)] /Idik [def: oily, bland] 
	boymldikayt/N [f] [def: oiliness] 
	boymlung/N [f] [def: annointing; unction] 
	shpritsboyml [m] [def: spray oil for cooking] % Forwards: S-R Schaechter 
boyne/S [f] skotoboyne/S [f] [def: slaughter-house]
boyne/N [f] [def: chickpeas]
boyre{bwr#}/H [m] [def: creator] /Lha{h}
boyreyekh{bwrH}/Xborkhem{bwrHym} [def: fugitive; refugee]
boyt/V/T [def: shake (liquid)] /Gon
boytshik/Ees [def: lad, boy (American)] /D
braki'r/V/Bbraki'rt [def: reject, condemn] /Goys
	brakirer/S [m] [def: picky person] 
	brakeve/V/T [def: reject] /Garoys % Sholem Aleykhem
		farbrakeve/V/Bfarbrakevet
brand/N [m] [def: fire, blaze] 
	[idiom: brand tayer = extremely expensive]
	brandopfer/N [def: sacrifice]
brand/N [f] [def: gangrene; blight (grain disease)] 
branzhe/S [f] [def: branch; field of interest; line of work]
	fli'branzhe/S [f] a'vyabranzhe/S [f] [def: airline industry] [note: V]
brashek/A [def: ??]
braslet/N [f?] /D brandzelet/N [f?] [def: bracelet (clothing)]
brat/N/Eer [m] [def: brother]
	[idiom: nash brat = one of us]
braunston/S [def: brownstone house (English)]
brav/A [def: brave]
	bravo [interj] [def: bravo!] 
braye/V/T [def: talk at length] /Goys
	[idiom: vos zol ikh aykh lang brayen = to make a long story short]
brazge/V/T [def: clatter, knock together; smash]
	brazg/N [m] brazgera'y/N [n] [def: sound of smashing]
	brazdenk/V/T [def: smite, hit]
bredye/V/T [def: jabber; talk nonsense]
breg/N/Ees [m] [def: shore; brim; edge]
brekh/V/Bgebrokhn [def: break; wring the hands; twist; vomit]
	/Goyf/Gdurkh/Gop/Gunter/Garayn/Giber/Gtsuzamen/Gon
	/Garoys/Goys [def: vomit]
	/Gayn [def: break up]
	tsebrekh/V/Btsebrokhn [def: break]
	farbrekh/V/Bfarbrokhn [def: break the law, wring (the hands)]
		farbrekh/N [m] farbrekhn/S [m] [def: crime]
			[idiom: shverer farbrekh = felony] % Weinreich
		farbrekher/S [def: criminal] /Iish
		[idiom: bageyn a farbrekhn = commit a crime]
	brekher/S [m] [def: breaker; gang leader] % Sholem Aleykhem
		bey'nbrekher/S [m] [def: bone-breaker, thug] % Sholem Aleykhem
	brekhik/A brekedik/A [def: breakable]
		brekhevdik/A [def: breakable, fragile]
	arayn'brekh/N [m] [def: burglary (event)]
		aray'nbrekher/S [m] [def: burglar] /Iish
		aray'nbrekheray' [f/n] [def: burglary (occupation)]
	oysbrokh/N [m] [def: outbreak]
		oysbrukh/N [m] [def: outbreak] [usage: doubtful admissibility]
	unterbrokhn/A [def: interrupted] u'mu'nterbro'khn/A [def: uninterrupted]
	indnbrekh/N [m] indnbrokh/N [m] [def: surf (ocean)]
	brekhekhts [m] [def: vomit]
	gebrekht/A gebrikht/A [def: ruptured; herniated]
brekl/V/T [def: crumble; hesitate (with "zikh")] 
	/Dbrek [n] [def: scrap, crumb] % no positive form
	tsebrekl/V/Btsebreklt [def: broken into small pieces]
brem/N [f] [def: eyebrow] 
	farbremt/A [def: with eyebrows]
	babre'm/V/Bbabre'mt brem/V/T /Garum [def: border]
brem [m?] bremnye/S [f] [def: armful (of kindling)] % Kulbak: Zelmenyaner: bremnye
bremze/V/T bremz/V/T [def: brake (vehicle); tinkle; strum]
bren/V/T [def: burn] /Gop/Garayn
	/Gdurkh [def: burn through, blow (fuse)] [note: V]
	/Goys [def: burn out, blow (fuse)] [note: V]
	/Gtsu [def: scorch; stick (to pot) (with "zikh")]
	farbren/V/Bfarbrent [def: burn up]
	tsebren/V/Btsebrent [def: burn for a while]
	bren [m] [def: ferver, ardor; very bustling situation] 
		aynbren/N [m] [def: sauce, roux (food)]
	brener/S [m] [def: burner (on a stove)] /D
	brenenish/N [n] [def: burning feeling; heartburn]
		hartsbrenen [m?] [def: heartburn]
breng/V/T [def: bring]
	/Garayn/Garop/Garoys/Garoyf/Gtsuzamen/Goys/Gunter/Gtsu/Goyf/Gmit
	/Gtsuzamen/Gtsunoyf/Gaheym/Gtsurik/Gon/Gaher
	/Gfir [def: suggest] 
	/Gum [def: kill]
	/Gop [def: bring back, return; deliver (object)]
	/Bgebrakht [def: bring]  % variant participle
		/Garayn/Garop/Garoys/Garoyf/Gtsuzamen/Goys/Gunter/Gtsu/Goyf/Gmit
		/Gtsuzamen/Gtsunoyf/Gaheym/Gtsurik/Gon/Gaher/Gahin/Gop
		/Gum [def: kill]
	farbreng/V/T /Bfarbrakht [def: pass the time pleasantly]
		farbrengen/S [m] [def: party, celebration; religious evening (Chassidic)]
	oysbrenger/S [m] [def: spendthrift]
brentsh/S [def: branch] [usage: American]
bret/Eer/D [f/n] [def: board] bretern/A [def: made of boards]
	biglbret/Eer [f] [def: ironing board]
	elektre-bret/Eer [f] [def: power strip or board (electric)] 
	fentsterbret/Eer/D [def: windowsill]
	gipsbret/Eer [f/n] [def: drywall, sheetrock, gypsum board] 
	indlbret/Eer [f] [def: surfboard]
	la'dlbret/Eer [f] [def: fretboard (on a stringed musical instrument)] [note: V]
	meldbret/Eer [f] [def: announcement board] 
	molbret/Eer [f] [def: painter's pallette]
	shokhbret/Eer [f] [def: chessboard] /D
	tore_bret{thrh-bret}/Eer [f] [def: table for washing corpses]
	tsilbret/Eer [f] [def: target, goal]
	vashbret/Eer [f] [def: washboard] /D
	za'ltsbretl/Eekh [n] [def: board for kashering food with salt]
	zeglbret/Eer [f] [def: sailboard (sport)]
		zeglbretler/S [m] [def: sailboarder] % Forwards
bretonish/A [def: Breton (language)]
breyl [m] [def: braille] 
breyre{bryrh}/Xbreyres{bryrwT}/H [f] [def: choice]
	beleys_breyre{blyT-bryrh} [adv] [def: as a last resort; reluctantly]
breyt/K [def: wide, broad, generous (with "zikh firn")] /Ilekh
	breytkayt/N [f] breyt/N [f] [def: width] 
	breyter/V/T [def: broaden] /Goys
		oysbreyterung/N [f] [def: broadening]
	farbreyt/V/Bfarbreyt farbreyter/V/Bfarbreytert [def: broaden]
		farbreyterung/N [f] [def: broadening]
breyt/V/T [def: prepare] /Gfor/Gon
	forbreytung/N [def: preparation] 
	bareyt/V/T /Gtsu/Gfor [def: prepare] [usage: inadmissible]
breyzl [m?] [def: breadcrumbs] % Forwards: S-R Schaechter
brezent/N [m] [def: tarpaulin] 
bri/V/T [def: burn; scald] /Gop
	/Goys [def: burn out; burn brightly]
	farbri/V/Bfarbrit [def: scald; boil] 
	briekhts/N [n] [def: scalding-hot substance]
	bray/V/Bgebray|t [def: brew] 
		/Dbrayz [def: still (brewing)]
		brayeray'/N [f] [def: brewery]
	broye/V/T [def: brew]  /Garum [def: disturb (with "zikh")] 
		broyer/S [m] [def: brewer] 
		broyeray'/N [f] [def: brewery] 
		broyz/N/Xbrayzer [f] broyhoyz/Xbroyhayzer [n] [def: brewery] /Dbrayz
bridke/K [def: ugly, loathsome, nasty] 
bridzh [m] [def: bridge (card game)]
brigade/S [f] [def: brigade] 
brik/N/D [f] [def: bridge] hengbrik/N/D [f] [def: suspension bridge]
	brikl/Eekh [def: bridge (of a ship)]
	bre'terbrik/N [f] [def: wooden bridge] % Chava Rozenfarb: Botshani
brike/V/T /Gavek brikeve/V/T [def: kick; refuse to behave (with "zikh")]
	brik [m?] [def: kick]
	tsebrike/V/Btsebriket [def: kick]
bril/N [def: eyeglass (clothing)]
	 -/Xzunbriln [def: sunglasses]
bril/V/T [def: roar (sound of a lion, bear, or slaughtered ox)] /Goyf
brilyant/N [m] [def: diamond] /In barlyant/N [m] /In
	brilya'nteve/V/Bbrilyantevet [def: sparkle (poetic)]
brindze [def: sheep cheese]
brinke/V/T [def: play piano (badly)] % Mirele Efros, maybe Russian "brenchat"
bris{bryT}/H/N [m] [def: circumcision; baby naming; convenant]
	zakhor_bris{zxwr-bryT} [def: prayer "remember the covenant"] % Bergelson
	bri'snitse{bryTnitse}/S [f] [def: birth celebration for a girl] 
britshke/S [f] [def: 2-wheel carriage (horse-drawn)]
britve/S [def: shaving blade] 
briv/X/D [m] [def: epistle, letter]
	blitsbriv/X/D [m] [def: e-mail]
	dankbriv/X/D [m] [def: thank-you note]
	libebriv/X/D [m] [def: love letter]
	kimpet-brivl/Eekh [def: childbirth amulet]
brivke/S [f] [def: paper parcel to hold stones (jewelers' argot)]
briye{bry#h}/Xbriyes{bry#wT}/H [def: creation, creature]
	briyas{bry#T}/H [def: creation of]
	/Xbruem{brw#ym}/H [def: creatures] [grammar: plural; no singular] 
		/Xbru'emlekh{brw#ymlekh} [def: little creatures]
bro'devke/S [f] bro'dovke/S [f] [def: wart (Russian бородавка, Polish brodawka)]
brodye/V/T /Gdurkh/Garayn/Gariber brodze/V/T brodzhe/V/T [def: wade; plot, trudge]
brodzhe/V/T [def: wander, ramble, prowl, wade (in water)]  /Garum
	brodyage/S [m/f] [def: vagabond, vagrant, tramp, hobo] 
brok/V/T [def: shred, crumble; chop] /Gon
	/Garayn [def: infuse]
	tsebro'k/V/Btsebro'kt [def: crumble up]
	farbro'kt/A [def: crumbled]
	gebro'ks/N [def: crumbled cracker; food cooked with crumbled matso]
	[idiom: khotsh hak un brok = no matter how hard you try]
	[idiom: khotsh nem un (verb) = you could just (verb)]
broka't/N [m] broka'd/N [m] [def: brocade] /Ien
brokh/N [def: curse; fracture; disaster, calamity]
	brukh/N [m?] [def: fracture, split]
		tsuzamenbrukh/N [m?] [def: disintegration] % Forwards: Ludin
	durkhbrokh/N [m] [def: breakthrough, discovery; incursion]
	onbrokh [m] [def: day break (with "oyf tog")]
brokoli [m?] [def: broccoli (vegetable)] % Forwards: S-R Schaechter 
brom [m] [def: bromine (Br)] 
bronbozhe/S [def: moribund cow (katsoves-loshn) (Polish: broń Boże)]
brone/S [f] [def: harrow] 
bronfn/S [m] [def: liquor, whiskey]
	[idiom: traybn bronfn = distill liquor]
brondz [m] [def: bronze] /In
	brondzovnik/Ees [m] [def: bronze-worker] 
brontsh [m] [def: brunch]  [note: V]
brosh/N [m?] broshke/S [f] [def: broach, breastpin (clothing)] /D
broshu'r/N [f] broshurke/S [f] [def: brochure, pamphlet] 
brot/V/Bgebrotn [def: roast] /Gop
	farbrot/V/Bfarbrotn [def: roast]
	tsebrotn/A [def: roasted]
	[idiom: farbrotn baym hartsn = anger] % Stutchkoff
broykh/V/T [def: need] [usage: doubtful admissibility] [grammar: er broykh]
	farbroykh/V/Bfarbroykht [def: need; demand] 
	gebroy'kh/V/Bgebroy'kht [def: use] [usage: doubtful admissibility]
		gebroy'kh/N [m] [def: need; use]
		gebroykher/N [m] [def: consumer]
		gebroy'khedik/A [def: needy; requiring] % Der Nister: Mashber
broyn/A [def: brown] /Ilekh
	broyn/N [m] [def: brown] 
	broyn/V/T [def: brown] /Gtsu [def: toast]
	farbroyn/V/Bfarbroynt [def: toast]
	kashtanbroyn/A [def: chestnut brown]
	opgebroynt/A [def: browned] 
broyt/N [n] [def: bread (food)] /Dbreyt
	be'knbroyt [n] [def: tip, gratuity (to a messenger)] % Stutchkoff
	be'tlbroyt [n] [def: handout (charity)]
	ki'mlbroyt [n] [def: caraway bread]
	kitsve{kycBh}-broyt [f] [def: handout (charity); relief, dole] 
	knoblbroyt [n] [def: garlic bread]
	kumisbroyt [n] [def: hardtack; dry biscuit]
	malkhes{mlxwT}-broyt [n] [def: fancy bread for special occasion]
	mandlbroyt [n] [def: almond bread]
	ovntbroyt [def: evening meal, supper] % PY
	vaysbroyt [n] [def: white bread]
	[idiom: gefrisht broyt = French toast]
	[idiom: gefrishte matse{mch} = matso brei]
	[idiom: opgegebn broyt = vengeance]
broyz/V/T [def: act angrily; storm] /Goyf [def: storm]
	oyfbroyz/N [m] [def: storm] /Iik /Indik [def: stormy]
brud [m] [def: filth] /Iik [def: filthy] 
bruder/Xbrider [m] [def: brother] /Iish
	bruderl/Xbriderlekh [n] [def: little brother]
	bru'derke/S [m] [def: dear brother]
	mitbruder/Xmitbrider [m] [def: close comrade; co-religionist]
		mitbriderish/A [def: brotherly] % Forwards: M-S Hoffman
	shifbruder/Xshifbrider [m] [def: fellow passenger]
	tsvilingbruder/Xtsvilingbrider [def: twin]
	brudershaft/N [f] bridershaft/N [f] [def: brotherhood]
		gutbrudershaft/N [f] [def: comradery, sociability]
	briderlekh/A [def: brotherly] briderlekhkayt/N [f] [def: brotherliness]
	farbridert/A [def: fraternized] 
		farbriderung/N [f] [def: friendship; fraternization] 
	gut-bruder/Xgute-brider [m] [def: friend, comrade] /Iish
	brider/V/T [def: be friendly (with "zikh mit")] % Bashevis
bruk/N [m] [def: cobblestone]
	bruki'r/V/Bbruki'rt [def: pave] /Goys
brukve/S [f] brikev/S [f?] [def: turnip (vegetable); rutabaga (vegetable)]
bruluye/V/T [def: purr (sound of a cat)] % Avrom Karpinovitsh
brum/V/T [def: hum; growl] /Gtsu/Gunter/Garoys
	brum/N [m] bruml/V/T
	brum/N [m] gebru'm/N [m] bru'menish/N [m] [def: growl, roar]
	brumke/V/T /Gunter [def: clang]
	leybnbrum/N [m] [def: lion's roar]
	horn-brumer/S [m] [def: bull horn] 
brunem/S/Xbrinemer [m] brunen/S [def: well] % variant plural
brunet/N brunetin/S [f] brunetke/S [f] [def: brunette]
	brunet/A [def: brunet] 
bru'sline/S [f] bru'snitse/S brukne/S [f] [def: bilberry (Vaccinium spp.); lingonberry/cowberry (Vaccinium vitis-idaea); cranberry (Vaccinium oxycoccos)]
brust/N/Xbristn [f] /Iik [def: breast; brisket (beef)] /Dbrist
bruta'l/A [def: brutal] 
	brutalite't/N [f] [def: brutality]
	brutalizi'r/V/Bbrutalizi'rt [def: brutalize, treat brutally] 
bshas{bSeT}/H [def: while]
bsule{bTwlh}/Xbsules{bTwlwT}/H [f] [def: virgin, maiden]
bsure{bQwrh}/Xbsures{bQwrwT}/H [f] [def: news, tidings]
bude/S [f] [def: booth; kennel]
	budke/S [def: stall; small shop; (dog) house]
		budotshnik/Ees [m] [def: stallkeeper] % Der Nister
		confesye-budke/S [f] vide{vydwy}-budke/S [f] [def: confessional] [note: V]
		shtim-budke/S [f] [def: voting booth] % Yiddish League
	budinke/S [def: tiny shed]
bu'dizm/N [m] [def: Buddhism (religion)]
	budist/N [def: Buddhist]
budua'r/N [def: boudoir]
budzhet/N [m] [def: budget] 
bufe't/N [m] [def: buffet; restaurant counter]
bufloks/N [m] buflaks/N [m] [def: buffalo (animal)]
buhay'/Ees [m] [def: bull (animal)] 
buk/V/T [def: bow (with "zikh")]
buk/Ees [m] [def: beech (tree)] 
buke't/N [m] [def: bouquet]
bukh/Xbikher [n] /Dbikh [def: book]
	brenbukh/Xbrenbikher [n] [def: book to be burnt]
	hantbukh/Xhantbikher [n] [def: handbook; guidebook; manual] /Dhantbikh
	kinderbukh/Xkinderbikher [n] [def: children's book] /Dkinderbikh 
	kokhbukh/Xkokhbikher [n] [def: cookbook] % Forwards
	lernbukh/Xlernbikher [n] [def: textbook] /Dlernbikh
	notits-bikhl/Eekh [n] [def: note pad] 
	tashnbukh/Xtashnbikher [n] [def: pocket-sized book] /Dtashnbikh
	tekstbukh/Xtekstbikher [n] [def: textbook] % Forwards
	togbukh/Xtogbikher [n] [def: diary] /Dtogbikh
		veb-totbikhl/Eekh [n] [def: blog, weblog] [note: V]
	trelbukh/Ees [m] [def: paunch, beer belly]
	verterbukh/Xverterbikher [n] [def: dictionary]
	zamlbukh/Xzamlbikher [n] [def: collection]
	bukini'st/N [def: archivist, antiquarian] /Iish
bukhe/V/T [def: punch (with the fist)] /Gon
	bu'khentse/S bu'khentsye/S [f] [def: punch]
bukhshtab/N [m] [def: letter of the alphabet]
	bukhshteblekh/A [def: literal] 
bukhte/S [f] [def: gulf, bay (water)] /D
buksi'r/V/Bbuksi'rt [def: tow]
	buksi'r/N [m] [def: tugboat]
bulan/N [def: a kind of horse] /A
bulave/S [f] [def: stick, black-jack; scepter]
bulbe/S [f] bulve/S [f] [def: potato; mis-speak (acting; with "bageyn")]
	bulbevate/A [def: bulbous]
	bulbenik/Ees [m] [def: kugl (food); actor who misses lines (actors' argot)]
bulbe/V/T [def: bubble]
	bulbe/D [f?] [def: bubble]
	bulbl/V/T [def: bubble (sound)]
buldog/N [m] [def: bulldog] 
buletin/N [m] [def: bulletin] 
	buleten/N [m] byuletin/N [m] [def: bulletin] [usage: inadmissible]
bulke/S [f] [def: bread roll (food)] /D
bulke/V/T [def: boil; bubble; ringlet]
bulva'n [def: well-muscled boor; moron; tailor's manikin]
	bulekh/S [m] [def: boor, oaf]
bulvar/N [def: boulevard]
bulyo'n [m?] [def: bouillon (food)] % Sholem Aleykhem
bunde/S [f] [def: hooded cloak (clothing)]
bunker/S [m?] [def: bunker]
bunt/A [def: colored, gaudy] 
bunt/N [def: rebellion, mutiny] /Iarish [def: rebellious, mutinous] 
	bu'nteve/V/T [def: stir (to rebellion), rebel (with "zikh")] 
	buntovnik/Ees bunta'r [m] [def: rebel, mutineer, revolutionary] 
bunt/N [m] [def: bundle, bunch] /D
bur/Xburem{bwrym} [m] [def: ignoramus]
burbl/V/T [def: bubble] 
burdzhu'k/Ees burdyu'k/Es [def: oaf, churl]
bure/S [f] [def: gale]
	bure/V/T [def: gust] /Goyf [def: anger]
burekas/N [def: boureka (food: filled savory pastry)]
burg/N [def: palace; chateau; fort] 
burik/Ees [m] [def: beet] /D % not burek 
	borek/N [m] [def: beet] % variant
burke/S [def: parka (clothing); hooded fur cape (clothing)]
burile/S [m] [def: rude fellow]
burnes/N [m] [def: burnoose (clothing)] /D
burtshe/V/T buratshe/V/T [def: growl, grumble]
	burtsh/N [m] [def: growl; rumble] 
burya'n/X [m] [def: weed]
burzhua'/Een [m] [def: bourgeois] /Iz
	burzhuy/N/Ees [def: bourgeois] [usage: contemptuous]
	burzhuazye/S [f] [def: bourgeoisie] 
	burzhuk/Ees [m] [def: bourgeois person (pejorative)
bus/N [m] [def: bus] % Stutchkoff
	shulbus/N [m] [def: school bus] [note: V]
busol/N [m] busole/S [f] [def: compass (magnetic)]
bu'sheve/V/T [def: rage; storm; oppress]
	tsebushevet/A [def: storming, oppressive]
bushl/Een [m] [def: stork (bird)]
bushl/Een [m] [def: bushel (measure: American)]
busi'r/V/Bbusi'rt [def: bus (transitive)] 
butl/N/Ees [m] [def: bottle]
butske/V/T [def: bump into each other (with "zikh")]
	tsebutske/V/Btsebutsket [def: bump into each other (with "zikh")] % Der Nister
buzem/S/Eer [m] [def: bosom]
	[idiom: leygn nit keyn feygelekh in buzem = be practical]
byografye/S [f] [def: biography]
	oytobyografye/S [f] [def: autobiography]
	byografish/A [def: biographical] 
		oytobyografish/A [def: autobiographical]
	byograf/N [m] [def: biographer]
byologye [f] [def: biology]
	byologish/A [def: biological]
	byolog/N [m] [def: byologist]
	byonish/A [def: bionic] [note: V] 
	byopsir/V/Bbyopsirt [def: biopsy] % Forwards: Sholem Berger
		byopsye/S [f] [def: biopsy] % Forwards: Sholem Berger
byuro'/N [n] [def: office; desk] /Dbyurokh byurke/S [f] [def: desk] 
	onvayz-byuro'/N [n] [def: clearinghouse] [note: V]
	veter-byuro'/N [m/n] [def: weather service] % Yiddish League
	byurokra't/N [m] [def: beaurocrat]
	byurokratye/S [f] [def: bureaucracy]
	byurolistke/S [f] [def: secretary] % Esther Kraytman: Briliantn
byust/N [m] [def: bust] /D
dabuve/N/Bdabuvet [def: trace; discover, find] % Avrom Karpinovitsh
-/Xdadem{ddym}/H [def: breasts (vulgar)]
daf{df}/Xdapem{dpym}/H [m] [def: page]
dakh/Xdekher [m] [def: roof (part of building)] /Ddekh
	i'bertsi-dekhl/Eekh [def: awning] [note: V]
	fardekhtik/V/Bfardekhtikt [def: cover; hide a secret; accuse, suspect]
		fardekhtik/A [def: hidden, secret]
		fardekhtlekhkayt/N [f] [def: accusation] % Sholem Asch: Ist River
	badekhtik/A [def: considerately; with deliberation] % Bashevis
	opdakh/N [m] [def: shed; shelter, refuge] 
	shindldakh/Xshindldekher [m] [def: shingle roof] % Chava Rozenfarb: Botshani
	shtroydakh/Xshtroydekher [m] [def: straw roof] % Chava Rozenfarb: Botshani 
	shtotdakh/Xshtotdekher [m] [def: town roofs] % Bergelson: Yosef Shur
	valddakh/Xvalddekher [m] [def: forest canopy] 
	dashik/Ees [m] [def: cap visor (clothing)] /D
dakht/V/T [def: mention; appear, seem, think (with "zikh")] /Goys
	dukht/V/T [def: appear] /Goys % variant base
	badakht/A [def: with deliberation] % geredt badakht un ruik
		badakhtkayt/N [f] [def: deliberation] % Forwards: Mishe Lev
	fardakht/N [m] [def: suspicion] [usage: deprecated]
	gede'khenish/N [n] [def: memory; remembrance, recollection] 
	opdukht/N [m] [def: mirage, illusion; phantom]
	[idiom: nisht far dir gedakht = it shouldn't happen to you]
daled{dʼ}/H [def: letter Dalet]
dales{dlwT}/H [m] [def: poverty]
	bedales{bdlwT} [adj predicative] [def: impoverished, indigent]
	[idiom: shteln bedales{bdlwT} = impoverish]
	[idiom: bin ikh bedales{bdlwT}! = I don't care at all]
dalfn{dlfwn}/Xdalfonem{dlfnym}/H [m] [def: poor man] [def: usage: humorous] % from Haman's son
	dalfnte{dlfnte}/S [f] [def: poor woman]
dalozhe/V/Bdalozhet [def: announce; make a report about]
dam/V/T [def: damn]
	farda'm/V/Bfarda'mt [def: reject, disapprove, deprecate] [usage: not recommended]
dam{dm}/Xdomem{dmym}/H [m] [def: blood] 
	tsedamt{tsedmt}/A [def: bloodied]
	bosr_vedom{bQr-|udm}/H [def: flesh and blood]
	hashem_yinkom_domoy{hy″d}/H [interj] [def: may God avenge his death]
	hashem_yinkom_domom{hy″d}/H [interj] [def: may God avenge their death]
	shfikhes{SfyxT}-domem{dmym} [def: strong insult, humiliation; bloodletting (usually figurative)]
	aliles_dam{elylT-dm} [m/n] [def: blood libel]
dambe/S [f] [def: dam, dike] 
dame/S/N [f] [def: lady]
	hoy'fdame/S [f] [def: court lady]
	damotshke/S [f] [def: lady (ironic)] % Forwards: M-S Hoffman
damf/N [m] [def: steam] % plural very unusual
	damfer/S [m] [def: steamer] 
	damf/V/T [def: emit steam] /Goys
	damp/V/T [def: emit steam] /Goys
	dempik/A [def: damp; humid]
	oysdempekhts/Eer [n] [def: vapor] % Bashevis: oysdempekhtser fun markh
	demp/V/T [def: stew] 
damke/S [f] [def: checkers (game, object)] 
dan [adv] [def: then]
dank/V/T [def: thank] /Gop/Gopet
	badank/V/Bbadankt [def: thank]
	fardank/V/Bfardankt [def: thank]
	dank/N [m] [def: thanks; gratitude]
		dankbar/A [def: thankful, grateful]
		dankbarkayt/N [f] dankshaft/N [f] [def: gratitude]
		u'mda'nkbar/A [def: ungrateful]
danostshik/Ees [m] [def: informer (Russian доносчик)] 
dar/K [def: thin; lean]
	darink/A [def: small and thin]
	dar/V/T [def: be thin] /Goys/Gop/Gayn/Gtsu fardart/A
		oysgedartkayt/N [f] [def: flimsiness]
	da'renish/N [n] [def: emaciation]
		ay'ndarenish/N [n] [def: misfortune] % Sholem Aleykhem
darf/V/T badarf/V/Bbadarft [def: need, require]
	badarf/N [m] [def: need] 
		baderftik/A [def: required]
	baderfer/X [m] [def: needy person]
		bade'rfenish/N [n] [def: need; excretory function (often "geyn oyf")]
darmoyed{darmo|yed}/N/Ees [m] [def: parasite, sponger] 
date/S [f] [def: date] datum/S [m]
	dati'r/V/Bdati'rt [def: set a date] /Gforoys
	datirung/N [def: dating] 
dati'v/N [m] [def: dative (grammar)] /A
datn [def: data]
datshe/S [f/n] [def: cottage; summer house]
	datshnik/Ees [def: someone living in a summer house] 
davke{dvk#}/H [def: actually; only so; necessarily]
	lav_davke{lav-dvk#} [adv] [def: not necessarily; not completely]
davn/Vdavnen/T [def: pray (Jewish prayer)] % Borokhov derives from {df-nen}
	/Gop/Gunter
	fardavn/Vfardavnen/Bfardavnt [def: immerse in prayer (with "zikh")] % Chaim Grade
	davner/S [def: person praying]
		mitdavner/S [def: fellow congregant]
	daven/V/T [def: pray (Jewish prayer)] /Gop/Gunter davener/S % variant spelling
davolno [interj] [def: enough! (Russian довольно)] 
dayge{d#gh}/Xdayges{d#gwT}/H [f] [def: worry, anxiety]
	dayge{d#gh}/H/V/T [def: worry]
	fardayget{fard#ght}/A [def: worried] 
	[idiom: nit dayn bobes dayge = none of your business]
	[idiom: dayge nisht = never mind; don't go out of your way]
daytsh/N [m/n] [def: German] altdaytsh/N [m/n] [def: Old German]
	day'tshmerish/A [def: imitation of German]
	daytshmeri'zm/N [m] [def: imitation of German] 
	daytshl/V/T [def: affect German language (with "zikh")] % Stutchkoff
de/Een [m] [def: the letter D] 
debati'r/V/Bdebati'rt [def: debate] 
	debate/S [f] [def: debate] 
debiti'r/V/Bdebiti'rt [def: be in debit; owe money]
	debitor/N [m] [def: debtor]
debyu't/N [m] [def: debut] 
dediki'r/V/Bdediki'rt [def: dedicate] dedikatsye/S [f] [def: dedication]
defamatsye/S [f] [def: defamation]
defekti'v/A [def: defective]
	[idiom: zayn in der defensive = be on the defense]
defensi'v/A [def: defensive]
	defensive/S [f] [def: defensive forces]
defili'r/V/Bdefili'rt [def: march past, parade] 
defini'r/V/Bdefini'rt [def: define] definitiv/A [def: definitive] 
	definitsye/S [f] [def: definition]
defitsi't/N [m] [def: deficit] % Harduf 
degenera't/N [m] [def: degenerate] 
degradi'r/V/Bdegradi'rt [def: degrade]
dehayne{dhInw}/H [def: namely]
dek/N [m] [def: ship's deck] tsvishndek/N [m]
dek/V/T [def: cover] /Gop/Gtsu/Goys/Giber/Gtsu
	/Gayn [def: tuck in]
	/Goyf [def: uncover]
		oyfdekung/N [f] [def: revelation]
	antdek/V/Bantdekt [def: uncover; discover]
		antdekung/N [f] [def: discovery] 
	fardek/V/Bfardekt [def: cover; surpass]
	badek/V/Bbadekt [def: cover, veil]
		badekns [def: veiling the bride]
	dek [m/f] deke/S [f] dekung/N [f] [def: cover; blanket; lid]
		/Ddek [def: cover; lid, pot cover]
			knidekl/Eekh [def: kneecap, patella (body part)]
		hartsdekl/Eekh [n] [def: beloved, darling]
		iberdek/N [m] [def: comforter; bedspread]
		luftdek/N [m] [def: atmosphere] % Yiddish League
		oygndekl/Eekh [n] [def: eyelid]
		tsudek/N [m] [def: blanket; bedspread; mantle]
			bettsudek/N [m] [def: bedspread] % Stutchkoff
			lu'fttsudek/N [m] [def: atmosphere] % Yiddish League
			tsudekenish/N [n] [def: covering] % Forwards: Yoel Matveyev
dekade'nts [f] [def: decadence] dekade'nt/A [def: decadent] 
deka'n/N [m] [def: dean; deacon (Church)] 
	dekana't/N [m?] [def: dean's office; deaconage]
dekhe/V/T [def: gasp, breath hard] /Gop
	/Goyf [def: finish panting] 
	dekh/N [m] [def: gasp, breath] 
	[idiom: khapn a dekh = catch one's breadth]
deklami'r/V/Bdeklami'rt [def: declare; recite]
	deklamatsye/S [f] deklaratsye/S [f] [def: declaration] 
deklari'r/V/Bdeklari'rt [def: declare] 
	deklarirung/N [f] [def: declaration] 
deklinatsye/S [f] [def: declination; declension]
	deklini'r/V/Bdeklini'rt [def: decline] % Harduf 
deko [m?] [def: decagram; 10 grams (measure of weight)] % Eve Jochnowitz
dekolt/N [m] [def: decolette]
	dekolte' [adj] [def: V-necked] [grammar: indeclinable]
	dekolti'r/V/Bdekolti'rt [def: V-necked; (often with "zikh")]
dekor/N [m] [def: decor] dekoratsye/S [f] [def: scenery (drama); decoration]
	dekorati'v/A [def: decorative]
	dekori'r/V/Bdekori'rt [def: decorate] % Harduf 
dekre't/N [m] [def: decree] % Harduf 
delegi'r/V/Bdelegi'rt [def: delegate]
	delega't/N [m] [def: delegate] delegatsye/S [f] [def: delegation] 
delfi'n/N [m] [def: dolphin (animal)] 
delika't/A [def: delicate]
	delikate's/N [m] [def: delicacy (food)]
	delikate'sn/S [m] [def: delicatessen] [usage: American]
deliryum/N [m?] [def: delirium] % Forwards: Yoel Matveyev
demago'g/N [m] [def: demagogue] /Iish [def: demagogic]
	demagogye/S [f] [def: demagogy] 
demer [m?] demerung/N [f] [def: dusk, twighlight] [usage: not recommended]
	demer/V/T [def: become dark] [usage: not recommended]
demisyoni'r/V/Bdemisyoni'rt [def: resign] 
	demisye/S [f] [def: resignation; dismissal]
demb/N/Ees [m] [def: oak (tree)] /In /Iov
demografye [f] [def: demography]
	demografish/A [def: demographic] % Forwards
demokratsye/S [f] demokratye/S [f] [def: democracy]
	demokra't/N [m] [def: democrat] % Harduf 
	demokratish/A [def: democratic] 
	demokratizatsye/S [f] [def: democritization] 
	demokratizi'r/V/Bdemokratizi'rt [def: democratize] 
demon [m] [def: demon]
	demonizi'r/V/Bdemonizi'rt [def: demonize] 
demonstri'r/V/Bdemonstri'rt [def: demonstrate] 
	demonstratsye/S [f] [def: demonstration (political)]
	demonstra'nt/N [m] [def: demonstrator]
	demonstrati'v/A [def: open, visible]
den [def: in that case; else; (after question, expecting negative answer)]
deneshke/S [def: money (Russian денежку "coin")]
denik/Ees [m] [def: cap visor (clothing)]
denk/V/T [def: opine; think]
	badenk/V/Bbadenkt [def: consider]
	fardenk/V/Bfardenkt [def: blame] [grammar: takes dative]
	gedenk/V/Bgedenkt [def: remember] /Gnokh
		fargedenk/V/Bfargedenkt [def: commit to memory; remember] 
		fargedenklekh/A [def: memorable] 
		ondenk/N [m] [def: memory]
			ondenkung/N [f] [def: memento]
	geda'nk/N [m] [def: thought; idea]
		hi'ntergeda'nk/N [m] [def: hidden reason]
		no'khgeda'nk/N [m] [def: afterthought, reconsideration]
		[idiom: es iz nit azoy lib dos geshank vi der gedank = it's the thought that counts] [note: V]
		[idiom: zayn bay di (klore) gedanken = be mentally sound]
	gede'nk/N [def: memory] /Ilekh [def: memorable]
	gede'khenish/N [n] gede'khtenish/N [n] [def: memory, recollection]
		gedekhtnis [n] [def: memory; remembrance, recollection] [usage: inadmissible]
	denker/S de'nkerin/S [def: intellectual]
		mitdenker/X [def: similar thinker]
	denkmol/Xdenkmeler [m] [def: monument]
	fraydenker/S [m] [def: freethinker, atheist]
denominatsyone'l/A [def: denominational (religious)] 
	u'mdenominatsyone'l/A [def: non-denominational] 
denti'st/N [m] dentistke/S [f] dentistin/S [f] [def: dentist]
	dentistik [f] dentisteray'/N [n]
	danti'st/N [m] dantistke/S dantistin/S [f] [def: dentist]
denuntsye/S [f] [def: denunciation] 
departme'nt/N [m] [def: department (US government)] 
	departeme'nt/N [m] [def: department (government)]
	departame'nt/N [m] [def: department (Russian government)]
depe'sh/N/S [f] [def: telegram] % both plurals exist
	depeshi'r/V/Bdepeshi'rt [def: send a telegram]
	[idiom: klapn a depesh = send a telegram]
depo/Een [m] [def: warehouse]
deporti'r/V/Bdepo'rtirt [def: deport] deportatsye/S [f] [def: deportation]
depozit/N [m?] [def: bank deposit]
deprimi'r/V/Bdeprimi'rt [def: depress, discourage]
	depresye/S [f] [def: depression]
	depresiv/A [def: depressive] % Forwards: S-R Schaechter
deputat/N [def: deputy, elected member (Russian)] 
	deputatsye/S [f] [def: delegation]
derbive/V/Bderbivet [def: attain (with "zikh")]
derekh{drx}/Xdrokhem{drxym}/H [def: path]
	bederekh{bdrx} [def: on the road]
		[idiom: bederekh{bdrx} klal{Kll} = ordinarily]
		[idiom: bederekh{bdrx} moshl{mWl} = as an example]
	/Lha{h} [def: the road]
	/Lke{K} [def: like the way]
	madrekh{mdryx}/Xmadrikhem{mdryxym}/H [m] [def: guide; mentor]
	moyre_derekh{mwrh-drx}/H [m] [def: guide; role model] 
	kfitses_haderekh{kfycT-hdrx} [f] [def: shortcut (mystic)]
	tseyde{cydh}-lederekh{ldrx} [f] [def: food for the road]
	derekh_agev{drx-agB} [interj] [def: by the way] 
	derekh_erets{drx-#rc} [m] [def: respect, esteem; good manners] /Idik
		umderekh_erets{umdrx-#rc} [m] [def: disrespect]
	[idiom: hoytsoes{hwcowT} haderekh{hdrx} = travel expenses]
derfarung/N [f] [def: experience] [usage: inadmissible]
	derfa'rn/A [def: experienced] derfarnkayt/N [f] [def: experience]
	u'mderfa'rn/A [def: inexperienced] 
derfolg/N [m] [def: success (German)] /Iraykh
dergordzhe/V/Bdergordzhet [def: humor, cater to the whims of]
derinerung/N [f] erinerung/N [f] [def: memory, recollection] [usage: inadmissible]
derivat/N [def: derivative] 
	derivati'v/N [def: derivative (mathematics); derivative (substance)]
derkutshe/V/Bderkutshet [def: bother, pester]
	dokutshe/V/Bdokutshet [def: bother, pester] % variant
	dekutshe/V/Bdekutshet [def: bother, pester] % Sholem Aleykhem
	derkatsh/Ees [m] [def: brigand]
derlang/V/Bderlangt [def: hand over, pass, hand; reach; hit (with "a klap")]
	/Garayn [def: bring in (food)] 
	/Garum [def: distribute] % Berish Goldstein
	/Garoyf [def: attain] % Der Nister
	derlanger/X [m] [def: server] derlangerke/S [f] % Der Nister, Avrom Karpinovitsh
derober/V/Bderobert [def: conquer] [usage: inadmissible]
	deroberung/N [f] [def: conquest] [usage: inadmissible]
desa'nt/N [m?] [def: invasion, incursion]
desen/S [m] [def: model, pattern]
despot/N [m] [def: despot] /Iish
destrukti'v/A [def: destructive] % Forwards: Yoel Matveyev
desyatine [f] [def: tenth part (land measure)] 
desyatnik/Ees [m] [def: constable (Russian десятник)]
deta'l/N [m] [def: detail] % Harduf 
deta'nt/N [m] [def: détant]
detekti'v/N [m] [def: detective] % Harduf 
	detekti'r/V/Bdetekti'rt [def: detect, observe] % Yoel Matveyev
detsember/S [m] [def: December]
detsidi'r/V/Bdetsidi'rt [def: decide]
	detsizye/S [f] [def: decision, conclusion]
devi'z/N [m] [def: motto, slogan; foreign currency]
deye{deh}/Xdeyes{dewT}/H [f] [def: opinion; knowledge; influence]
	bedeye{bdeh} [verb] [def: be of the opinion (with "zayn tsu"); plan (with "hobn")]
	yediye{ydyeh}/Xyediyes{ydyewT}/H [f] [def: news; announcements]
	moydiye{mwdy|e}/H [verb] [def: inform (with "zayn")]
		moydoe{mwdeh}/Xmoydooys{mwdewT} [f] [def: announcment]
	keyedue{Kydue}/H [def: as is well known]
	das{deT}/H [m] [def: religion, opinion of] /Lle{l} [def: according to]
		meabed_atsme_ladaas{mabd-ecmw-ldeT} [m] [def: person who commits suicide]
	-/Xkhiluke_deyes{Hylwky-dewT}/N [def: differences of opinion]
	lekhol_hadeyes{lxl-hdewT} [adv] [def: in everyone's opinion]
	mideye{my-ywde} [adv] [def: who knows?]
deyet [f] [def: diet] dyete/S [f]
	[idiom: haltn deyet = go on a diet]
deyver/V/T /Goys [def: emaciated]
deyzhe/S [f] [def: water basin; kneading-trough]
	 deyzhke/S [f] [def: small basin] /D
deze'rt [m?] [def: dessert] % Forwards: Sholem Berger
dezerti'r/V/Bderzerti'rt [def: desert] dezerti'r [m] [def: deserter]
dezhu'r/N [m?] dezhurstve/S [f] [def: night-guard duty]
di dos dem [article] [def: the, this]
	der [article] [def: the, this]
		derfa'r [adv] [def: therefore]
		derfu'n [adv] [def: thence]
		dervegn [adv] [def: concerning]
		derno'kh [adv] dernokhet [adv] [def: thereafter; afterwards]
		derba'y [adv] [def: near]
		dermi't [adv] [def: with; herewith]
		dertsu' [adv] [def: too, in addition; thereto]
	dos/N [f] [def: buttocks] /Iik [def: fat in the buttocks; annoying; suspect]
	dos [adv] [def: in this way; just now]
	di [article] [def: stall where something is sold, as in "di puter", does not become "der" in the dative (Vilna)] % Avrom Karpinovitsh
	de'stvegn [adv] [def: nonetheless (with "fun -")]
		funde'stvegn [def: nonetheless, nevertheless] 
	nokhdem [def: afterward]
	fardem [def: before]
	oyserdem [def: besides]
diabolish/A [def: diabolic] 
diber{dybwr}/Xdiburem{dybwrym}/H [m] [def: word; speech; power of speech]
	dibraye{dbry#}/H [def: commandments (Aramaic)]
	divrey{dBry}/H [def: words of]
	dabr{dbr}/V/T [def: speak] /Giber [def: convince]
		tsedabr{tsedbr}/V/Btsedbrt{tsedbrt} [def: converse]
	kitser_hadover{kycwr-hdBr} [adv] [def: in short; to make a long story short]
	[idiom: oysredn/onredn oser_ledaber{osur-ldbr} oyf emetsn = say awful things about]
	[idiom: s'iz oser_ledaber{osur-ldbr} = one mustn't say such things]
	[idiom: toykh{Wwx} keday{Kdy} diber{dybwr} = immediately]
dibom [adv] [def: upright (posture)]
dibuk{dybwk}/Xdibukem{dybwkym}/H [def: spirit possessing someone else's body; moribund cow (katsoves-loshn)]
	dveykes{dBykwT}/H [def: mystical attachment] /Idik
	fardveyket{fardByket}/A [def: mystically attached]
		fardveyketkayt{fardByketkayt}/N [f] [def: mystical attachment]
difere'nts/N [f] [def: difference]
	diferentsi'r/V/Bdiferentsi'rt [def: differentiate]
		diferentsirung/N [f] [def: differentiation] % D-H Katz
difteri't/N difteri'ten [m] [def: diphtheria (disease)]
digital/A/Iish [def: digital]
	 digitizi'rt/A digitalizi'rt/A [def: digitized, digitalized] 
dik/K [def: broad; thick] /Ilekh
dikdek{dykdwk}/H [m] [def: Hebrew grammar; detail]
	medakdek{mdkdk}/Xmedakdeykem{mdkdkym}/H [m] [def: punctilious person]
dikh/N [m] [def: thigh] % Harduf, Michael Wex
dikhe/V/T [def: breathe (Russian дышать)] 
dikhter/S [m] /Iish di'khterin/S [f] [def: poet]
	dikhtung/N [f] [def: poetry]
	gedikht/N [n] [def: poem (German)]
	dikht/V/T [def: write poetry] /Giber [usage: doubtful admissibility]
	badikht/V/Bbadikht [def: write poetry] 
dikti'r/V/Bdikti'rt [def: dictate, prescribe]
	dikta't/N [m] [def: order; dictation]
		diktator/N [m] [def: dictator] /Iish
		diktatu'r/N [f] [def: dictatorship] % Harduf 
	diktsye/S [f] [def: diction] 
	dikta'nt [m?] [def: paper written by dictation] [usage: not recommended]
dil/N [m] [def: floor]
dileme/S [f] [def: dilemma] % Harduf 
dileta'nt [m] /Iish [def: diletant]
dilizha'ns/N [m] [def: stagecoach]
dimensye/S [n] [def: dimension]
	dimensyone'l/A [def: dimensional]
dime'nt/N [m] [def: diamond] /In /Iik /D
diminutiv/A [def: diminutive]
dimyen{dmywn}/Xdimyoynes{dmywnwT}/H [def: appearance, falsehood]
	/Lha{h} [def: imagination]
din/A [def: thin] /Iik /Iink /Ilekh
din/V/T [def: serve; worship] /Gop/Gtsu
	/Goys [def: complete a term of (military) service; be demobilized]
	fardin/V/Bfardint [def: earn; steal (ganovem-loshn)] /Gop
		fardiner/S [def: bread-winner]
		fardinst/N/D [n] [def: earnings]
			fardinstful/A [def: brave; highly qualified]
		[idiom: kosher{KSr} fardint = well deserved]
	badin/V/Bbadint [def: serve, wait on] badinung/N [f] [def: service]
		badiner/S [m] badi'nerte/S [f] [def: servant; attendant]
	derdin/V/Bderdint [def: become/get as a result of service (with "zikh tsu")]
	dinst/N [f] [def: female servant] /Iish folksdinst/N [f]
	diner/S [m] di'nerke/S [f] [def: server]
		dinershaft/N [f] [def: servitude; the servants]
	dineray'/N [n] dinung/N [f] [def: service]
	getsndiner/S [def: idol worshiper]
	dinst/N [n] [def: service; military service] 
		got|sdinst/N [n] [def: prayer] 
		militer-dinst/N [n] [def: military service] 
		shklafndinst/N [n] [def: slavery]
		[idiom: tsu emetsns dinst = at someone's service]
din_{dyn}/Xdinem{dynym} [m] [def: law]
	beyzdin{byT-dyn}/H [n] [def: rabbinic court]
	av_beys_din{aB-byT-dyn} [m] [def: head Rabbi]
	dayen{dAn}/Xdayonem{dAnym} [def: religious judge]
		dayones{dInwT} [f] [def: position as religious judge]
	[idiom: hu{hw#} hadin{hdin} = such is the rule]
	[idiom: yoym{ywm} hadin{hdin} = Yom Kippur]
	[idiom: lifnim{lfnym}-mishures{mshwrT}-hadin{hdin} = within legal boundaries]
dinamik [f] [def: dynamics (subject); dynamics (music)] 
	dinami'zm/N [m] [def: dynamism] 
	aerodinamik [f] [def: aerodynamics (subject)] 
	byodinamik [f] [def: biodynamics (subject)] 
	elektrodinamik [f] [def: electrodynamics (subject)] 
	hidrodinamik [f] [def: hydrodynamics (subject)] 
	termodinamik [f] [def: thermodynamics (subject)] 
	dinamish/A [def: dynamic]
dinami't [m] [def: dynamite] % Harduf 
dinamo [m] [def: dynamo] 
dinastye/S [f] [def: dynasty] % Harduf 
ding/V/Bgedungen [def: hire, rent; haggle, dicker (with "zikh")] /Goys/Gop
	/Gon [def: employ (perfective)]
	farding/V/Bfardungen [def: rent out]
	bading/V/T/Bbadungen [def: settle on (with "zikh oyf"); agree on price]
	di'ngenish/N [n] [def: dickering]
	bading/N [m] badingung/N [def: condition]
	u'mbadi'ngt/A [def: untouched]
	forbading/N [m] [def: precondition] 
dinozaver/S [m] [def: dinosaur (animal)]
dinstik/N [m] [def: Tuesday]
dinye/S [f] [def: melon] dinke/S [f] [def: cantaloupe]
diplo'm/N [m] [def: diploma] diplome/S [f] 
	dimplomi'rt/A [def: having a diploma] % Stutchkoff
diploma't/N [m] [def: diplomat] /Iish [def: diplomatic] % Harduf 
	diplomatye [f] [def: diplomacy] % Harduf 
dire{dyrh}/Xdires{dyrwT}/H [f] [def: apartment] /D
	oyker_dire{ewkr-dyrh} [verb] [def: move, change abode (with "zayn")]
dire'kt/A [def: direct]
	dire'ktor/S/Xdirekto'rn [m] dire'ktorin/S [f] direktorshe/S [f] [def: director]
	direkti'v/N [m] [def: order] 
	u'mdire'kt/A [def: indirect]
dirigi'r/V/Bdirigi'rt dirizhi'r/V/Bdirizhi'rt [def: direct] /Gtsu
	dirige'nt/N [m] dirige'ntin/S [f] dirizho'r/N [m] [def: director]
dirizhabl/N [m?] [def: dirigible]
disertatsye/S [f] [def: dissertation] % Harduf 
dishe/V/T [def: breathe heavily; gasp for breath (with "zikh") (Polish dyszeć)]
	/Goys [def: kill]
dishl/N [m] [def: wagon shaft; wooden shaft for spanning horses]
	[idiom: oysdreyen dem dishl = make a U turn] [note: V] 
disk/N [m] [def: disk (computer)] disket/N [def: diskette]
	kompaktdisk/N [def: compact disk (CD)]
	kompaktl/N [def: compact disk (CD)]
	kompaktlnik/Ees [m] [def: portable compact disk player] [note: V] 
diskote'k/N [f] [def: discotheque] % Harduf 
diskret/A [def: discreet]
diskrimini'r/V/Bdiskrimini'rt [def: discriminate]
	diskriminatsye/S [f] [def: discrimination]
diskuti'r/V/Bdiskuti'rt [def: discuss] diskusye/S [f] [def: discussion]
disona'nts/N [m] [def: dissonance; discord] 
dispozitsye/S [f] [def: inclination, disposition; utilization, disposition] 
	predispozitsye/S [f] [def: predisposition] 
disprosyum [m] [def: dysprosium (Dy)] 
disput/N [m] [def: dispute]
	disputatsye/S [f] [def: disputation]
	disputant/N [m] [def: disputant]
dista'nts/N [f] [def: distance]
	distantsi'r/V/Bdistantsi'rt [def: distance]
distili'r/V/Bdistilir't [def: distill]
distrikt/N [m?] [def: region, district]
	gerikht-distrikt/N [m?] [def: court district]
	politsey-distrikt/N [m?] [def: precinct]
	voyndistrikt/N [m?] [def: residential area]
distsipli'n/N [f] [def: discipline] % Harduf 
	distsiplini'r/V/Bdistsiplini'rt [def: discipline] % Harduf 
diva'n/N/Ees [m] [def: sofa (furniture); carpet, rug (Polish Yiddish)] /Ddivand
diverzye/S [f] [def: change; divergence; diversion (tactic)]
divizi'r/V/Bdivizi'rt [def: divide] divizye/S [f] [def: division (military)]
	divide'nt/N [def: dividend (money)]
dizhu'r/N [m] [def: tour of duty] 
	dizhuri'r/V/Bdizhuri'rt [def: be on duty] 
	dizhurn/A [def: on-duty] 
dlibe/V/T /Goys [def: pick]
	dlube/V/T /Goys dulube/V/T /Goys [def: pick] % variants
	[idiom: dliben di noz = pick one's nose]
dlonye/S [f] [def: palm of hand]
dlot/N [n] [def: chisel (instrument)]
dno/N/Ees [m] [def: bottom of container]
	denik/Ees [m] [def: bottom of a pot]
do /Izik /Iik danen danent danet [def: here]
	dosdozike [adj] derdoziker [adj] didozike [adj] [def: this very]
	demdozikn [adj] [def: this very]
	doikayt/N [f] [def: presence, existence] 
	u'mdo'ik/A [def: absent] % Sutskever
dobu've/V/Bdobu'vet dobive/V/Bdobivet [def: get, obtain, reach (with "zikh")] 
dogesh{dgS}/H [def: emphasis, Hebrew punctuation mark indicating doubling]
dogmat/N [m?] [def: dogma] /Iish
	dogmati'zm/N [m] [def: dogmatism]
	dogma'tiker/S [m] [def: dogmatic person]
dokh [def: of course; yet, still]
dok/N [m] [def: dock, pier] 
do'khene/S [f] [def: bedspread] % Chassidic speech
dokter/Xdoktoyrem{doktoyrym} [m] do'ktershe/S do'kterke/S do'kterin/S [f] [def: doctor (occupation)]
	dokterl/Xdoktoyremlekh{doktoyrymlekh} [n] [def: doctor (pejorative)]
	dokter/V/T [def: visit doctors (with "zikh")]
	doktorye [def: the science of medicine]
	[idiom: zayn a dokter far zikh = have a private medical practice]
	dokto'r/N [m] dokto'rshe/S [f] [def: doctor (holder of title)] 
		doktora'nt/N [m] [def: doctoral student]
		doktora't/N [m?] [def: doctoral thesis] % Forwards: P. Portnoy
doktrin/N [m] doktrine/S [f] [def: doctrine] 
dokume'nt/N [m] [def: document] /Ia'l
	dokumenti'r/V/Bdokumenti'rt [def: document] 
	dokumentatsye/S [f] [def: documentation] % Forwards: M-S Hoffman
	dokumenta'r/A [def: documentary (film)] % Forwards: B. Sandler
dolar/N [m] [def: dollar (American currency)] /Idik
	toler/S [m] [def: dollar (American currency)] 
	shmolyare/S [f] [def: dollar (humorous)] % Forwards: M-S Hoffman
dolete/S [f] [def: chisel (tool)] % Harduf
do'lmetsher/S [m] dolme'tsherke/S [f] [def: interpreter]
	tolmatsh [m] tlumatsh/Ees [m] tlumatshke/S [f] [def: interpreter (Ukrainian толмач)]
dolye/S [f] [def: lot, fate] 
domini'r/V/Bdomini'rt [def: dominate; have influence over]
	dominirung/N [f] [def: domination]
	domina'nt/A [def: dominant (also musical)]
domino/S [m] domine/S [f] [def: checkers (game, game piece)] % Harduf, Stutchkoff
domovik/Ees [m] [def: house elf]
don [m] [def: Mr. (Spanish, Italian)] dona [f] [def: Miss (Spanish, Italian)]
	primadona/S [f] [def: prima donna] 
donershtik/N [m] [def: Thursday]
donkikhotish/A [def: Quixotic, idealistic]
donos [m?] [def: denunciation (Russian донос)] /D % Sholem Aleykhem
donzhe/V/T zdonzhe/V/T [def: be in time] [usage: not recommended]
dopros/N [m?] [def: interrogation (Russian допрос)]
dor{dwr}/Xdoyres{dwrwT}/H [m] [def: generation] /Lha{h} [def: the generation]
	doyresdik{dwrwTdik}/A [def: across the generations]
	dor_hafloge{dwr-hflgh} [def: generation of dispersal, at the time of the Tower of Babel]
	[idiom: hiskatnu{hTktnw} hadoyres{hdwrwT} = the generations have declined]
dorayso{d#wreyT#}/H [def: ritual law with Biblical support]
dorem{drwm}/H [m] [def: south] doremdik{drwmdik}/K
dorf/Xderfer [n] [def: village] /Iish [def: rural]
	/Dderf [n] [def: hamlet]
	dorfs- [prefix] [def: of a village]
dorn/Xderner [m] [def: thorn]
dorobe/V/Bdorobet [def: reach through effort (with "zikh tsu") (Polish)] 
dorsh/N [m] [def: cod (fish)]
dorsht/V/T [def: thirst]
	dorsht/N [m] [def: thirst] /Iik [def: thirsty]
	blutdorshtik/A [def: bloodthirsty, ferocious]
	% variant spelling:
	dursht/V/T [def: thirst] dursht/N [m] [def: thirst] /Iik
		blutdurshtik/A [def: bloodthirsty]
dort dortn [def: there]
	dortik/A [adj attributive] [def: residing there]
dos/V/T [def: defecate (slang, impolite)] % Harduf, Michael Wex
	/Garoys [def: expell]
dosade/S [f] [def: annoyance (Ukrainian досада)]
dotse'nt/N [m] [def: docent] 
dover{dBr}/H [def: thing]
	doverakher{dBr-aHr}/H [def: unpleasant thing; pig; scoundrel]
	baldover{bel-dBr}/H [def: defendent]
dovyereno'st/N [m?] [def: power of attorney (Russian доверенность)] [usage: doubtful admissibility]
doyer/V/T [def: last, endure]
	gedoyer/V/Bgedoyert [def: last; continue]
		doyer/N [m] gedoy'er/N [m] [def: duration]
		oy'sdo'yer/N [m] [def: patience; stoicism]
	langdoyerndik/A [def: boring]
	badoyer/V/Bbadoyert [def: regret; fell sorrow for] badoyerung/N [f] [def: regret]
	[idiom: tsum badoyern = unfortunately]
doyfek{dwfk}/H [verb] [def: hit, pulse (with "zayn")]
	deyfek{dfk}/N [m] [def: pulse]
doykhek{dwHk}/H [m] [def: shortage] 
	dakhkes{dHkwT} [n] [def: need] 
	doykhek{dwHk}/H [verb] [def: urge (with "zayn")] 
	dkhak{dHk}/H [m?] [def: extreme difficulty]
		shas_hadkhak{bSeT-hdHk} [f?] [def: a time of difficulty]
		beshas_hadkhak{bSeT-hdHk} [adv] [def: at a time of difficulty]
doyme{dwmh}/H [adj] [def: similar] [grammar: indeclinable]
	kedoyme{kdwmh} [def: likewise; similar]
	ukhdoyme{|wxdwmh} vekedoyme{|wKdwmh} [def: and similar, etc.] 
	dami{dmy}/H [def: similar]
doymen [m?] [def: thumb] [usage: not recommended]
doyne/S [def: kind of Gypsy melody or dance] 
doyres_{dwrs}/V/T [def: trample]
doze/S [f] [def: dose (medicine)] 
	dozi'r/V/Bdozi'rt [def: dose] [note: V]
	iberdoze/S [f] [def: overdose] [note: V]
		iberdozi'r/V/Biberdozi'rt [def: over-medicate] [note: V]
dozore/S dozorts/Ees [m] [def: overseer, guardian, inspector; onlooker (Russian дозор)] 
	dozor [m?] [def: government-appointed supervision of Jewish communal affairs]
dr [m] [def: Dr.]
drab [m] [def: a jerk] drabke/S [f] [def: slut] 
draguner/S [m] dragu'n/N [m] [def: dragoon, cavalryman]
drake/S [def: fight]
drakon/N [m] [def: dragon (mythical creature); Draco (constellation); Draco (Athenian lawgiver)]
drame/S [f] [def: drama]
	dramatish/A [def: dramatic]
		dramatishkayt/N [f] [def: drama]
	folksdrame/S [f] [def: folk drama] 
	dramaturg/N [m] [def: playwright] /Iish
		dramaturgye/S [f] [def: playwriting]
	dramatizi'r/V/Bdramatizi'rt [def: dramatize] 
drape/V/T [def: scratch; clamber (with "zikh")] /Goys/Garoyf/Garop/Garoys
	tsedrape/V/Btsedrapet [def: scratch]
	drap/N [n] [def: scratch from a claw]
drapi'r/V/Bdrapi'rt [def: drape; hang with (with "mit")]
	drapn/A [def: made of cloth]
drastish/A [def: drastic]
dravidish/A [def: Dravidic (language family)]
dray/N [d] [def: 3] drit/A [def: 3rd] dritik/A [def: tertiary]
	dritl [d] [def: 1/3] dritns [def: 3rd]
	drayer/S [m] [def: three-kopek coin (Russian currency)]
		drayerl/Eekh [n] [def: three-ruble note (Russian currency)]
	drayek/N [m] [def: triangle] /Iekhik
	draytsn [d] [def: 13] /It draytsntl [n] [def: 1/13]
	draysik [d] /A [def: 30] /Ist draysikstl [n] [def: 1/30]
	drithalbn [def: 2.5]
	zibethalbn [def: 6.5]
drek [m] [def: dirt, excrement, slut, weak-hearted person]
	/Iik [def: dirty] 
dreksler/S/X [m] [def: woodturner (occupation)]
drelye/S [f] drilye/S [f] [def: jellied calves' feet (food); fish aspic (food)]
dreml/V/T [def: nap]
	/Gayn [def: fall asleep]
	/Gunter [def: nod off]
	dreml/N [m]
	driml/V/T /Gayn [def: nap] % variant
		[idiom: khapn a dreml = take a nap]
	antdriml/V/Bantdrimlt [def: go to sleep]
dren [m] [def: cornelian cherry (Cornus mas); fruit of cornelian cherry]
dreng/V/T [def: wring] /Goys
	drenger/S [m] [def: wringer]
		badrenger/X/S [m] [def: oppressor] % Forwards: Yechiyel Szeintuch
	drang/N [m] gedreng [n?] [def: desire, impulse; striving] 
	gedra'ng/N [n] [def: crowd, throng; congestion]
dresh/V/Bgedroshn [def: thresh] /Goys
	dresher/S [def: thresher]
	oysgedroshenerheyt [adv] [def: worn out, exhausted] % Forwards: Riki Royz
	/Xdreshtes /Xdreshtshes [def: shudder, shiver, quiver]
dretl/N/Eekh [n] [def: staple]
	tsondretl/Eekh [def: braces (dentistry)] [note: V]
drey/V/T [def: twirl; turn; twist]
	/Gavek/Gtsunoyf/Gum/Gop/Gon/Garoys/Garop/Goyf/Garoyf
	/Garayn [def: entangle]
	/Garum [def: twirl; pivot (with "zikh"); hang out (with "zikh")] 
	/Gayn [def: encircle]
	/Giber [def: invert; turn upside-down]
	/Goys [def: turn about; make a U turn (with "zikh"); evade] [note: V] 
	/Ddreyd [def: top (toy)]
		gedreydlt/A [def: twining, twisty] % Der Nister
		drey'dldik/A [def: circuitous] % D-H Katz
	fardrey/V/Bfardreyt [def: confuse] fardrey'enish/N [n] [def: confusion]
	tsedreyt/A [def: confused; deranged]
	drey/N [m] [def: twirling; subterfuge]
		dreyer/S [def: twirler, confuser; swindler]
		drey'enish/N [n] [def: twirling, confusion]
		kopdrey'enish/N [n] [def: flattery, impossible task, disorder]
	gedrey [n] [def: swirl (mixture)] 
	oysdrey/N [m] [def: evasion; turn, bend; misleading argument]
	[idiom: dreyen mit dem hintl = wiggle the behind]
dreyf/V/T [def: drift]
	/Giber [def: overturn; muddle; turn (key); turn backwards]
dreyst/K [def: courageous, bold]
	dreystkayt/N [f] [def: courage, boldness] 
dribl/V/T [def: unravel, fray] /Goys
	tripl/V/T /Goys [def: unravel, fray]
	tripe/V/T /Goys [def: unravel, fray]
	tsedribl/V/Btsedriblt [def: shatter; break]
drige/V/T [def: kick] 
	flyaskedrige/S [m/f] [def: religious zealot; loafer]
drinde/S [f] [def: a kind of horse] 
drik/V/T [def: squeeze; press; oppress]
	/Garoys/Gtsu/Garayn/Gtsuzamen/Gtsunoyf
	/Goys [def: express]
	/Gunter [def: suppress, oppress]
	badrik/V/Bbadrikt [def: squeeze, oppress]
		badrikung/N [f] [def: squeezing, oppression]
	fardrik/V/Bfardrikt [def: squeeze]
	derdrik/V/Bderdrikt [def: squeeze] % Forwards: Boris Sandler; Esther Kraytman: Briliantn
	tsedrik/V/Btsedrikt [def: crush]
	oysdriker/S [def: expresser]
		oysdriklekh/A [def: expressive]
		oy'sdrikful/A [def: expressive] % Forwards: Boris Sandler
		oysdrikung/N [def: expression, evidence]
	unterdrik unterdrikung/N [f] [def: oppress; suppress]
		unterdriker/S/X [def: oppressor]
	drikung/N [f] [def: stress; pressure] drik'enish/N [n] [def: pressure]
		svive{sByBh}-drikung/N [f] svive{sByBh}-druk/N [f] [def: peer pressure] [note: V] 
	[idiom: drikn hent = shake hands]
drike/S [f] [def: staff, pole]
drim/N [m] [def: thread; wisp]
dring/V/Bgedrungen [def: argue, claim; deduce (with "fun"); penetrate]
	/Garayn/Garoys/Gdurkh/Goys/Gayn
	arayndringer/S [m] [def: deducer]
	dringlekh/A [def: urgent; penetrating] % Harduf
		arayndringlekh [def: penetrating] 
		u'mdri'nglekh/K [def: postponable, delayable]
	durkhdringlekh/A [def: implied; penetrating]
		durkhdringlekhkayt/N [f] [def: penetrating quality] % Forwards: Boris Sandler
	dringevdik/A [def: penetrable] 
	oysdringung/N [f] [def: deduction] 
dripe/V/T [def: defecate (taboo)]
	dripke/S [f] [def: filthy person]
	fardripe/V/Bfardripet [def: make filthy]
drivl/-drivl oysgedrivlt/A tsedrivlt/A [def: worn out]
driz/N [f] [def: gland] /D
	limfdriz/N [f] [def: lymph node] % Stutchkoff
	shilddriz/N [f] [def: thyroid gland] 
	shlaymdriz/N [f] [def: pituitary gland]
	tsu'gobdriz/N [f] [def: pituitary gland] % Forwards: Sholem Berger
	u'ntermogn-driz/N [f] boykhdriz/N [f] shpaykhldriz/N [f] [def: pancreas (gland)]
dro/V/T [def: threaten; flutter]
	badro/V/Bbadrot [def: threaten] 
	droung/N [f] [def: threat] 
drobne/A [def: tiny] drobnink/A
	dribne/A [def: tiny] dribnink/A dri'bnitshke/A 
	drob/N [m] [def: fraction (mathematics) (Russian дробь)]
drogist/N [m] [def: druggist] % Bergelson
dron/N [m] [def: drone (bee)]
drong/N/Xdreng/Xdrenger [m] [def: pole; bar; fool] /Ievat
	/Ddreng [def: kindling (in plural)]
	[idiom: mazl{mzl} vi a drong = poor luck]
drosh{drwS}/Xdroshem{drwSym} [m] drash{drS}/H/N/D [m] [def: homily, sermon]
	droshe{drSh}/Xdroshes{drSwT}/H [f] [def: homily, sermon]
	darshn{drSn}/Xdarshonem{drSnym}/H [def: preacher] 
	darshen{drSen}/V/T [def: sermonize; preach]
	midresh{mdrS}/H [m] [def: Rabbinic legend]
		medresh{mdrS}/Xmedroshem{mdrSym}/H [m] [def: Rabbinic legend; parable] 
		besmedresh{byT-mdrS}/Xbote_midroshem{bTy-mdrSym} [m] [def: house of study] /Idik
			bes-hamedresh{byT-hmdrS} [m] [def: house of study]
		midreshnik{mdrSnik}/Ees [def: ??]
droshke/S [f] [def: droshky (horse-drawn cab) (vehicle)] 
drosl/N [m] [def: blackbird, thrush (bird)]
drot/N [m/n] [def: wire] shtekhldrot/N [m] [def: barbed wire]
	dratve/S [f] [def: cord for shoe repair]
droyb/D [n] dreybke/S [f] [def: giblets, poultry innards; horde of children] % includes heads, intestines
drozd/N [m?] [def: thrush (bird)] 
drozh [m] [def: goosebumps]
drozhke/S [f] [def: 3-wheel horse-drawn carriage]
drudl/V/T /Gon [def: become angry]
druk/V/T /Gayn/Garoys/Gayn/Gop/Giber [def: press; print]
	druker/S [m] [def: printer] 
		drukeray'/N [f] [def: printing shop] 
	druk/N [m] [def: print; pressure] 
		blutdruk/N [m] [def: blood pressure] 
		fusdruk/N [m] [def: footprint; spoor]
		va'serdruk/N [m] [def: water pressure] % Forwards: Noyekh Barera
		drukloz/A [def: relaxed, stressless] % Forwards: Riki Royz
	ayndruk/N [def: impression]
		ayndruksful/A [def: impressive] 
		baayndrukt{ba#ayndrukt}/A [def: impressed]
	oysdruk/N [def: expression]
	gedrukterheyt [adv] [def: in print]
dubine/S [f] [def: blackjack (weapon)]
dubnyum [m] [def: dubnium (Db)] 
dudl/V/T [def: play badly (instrument), cheat] 
	tsedudl/V/Btsedudlt [def: confuse] 
due'l/N [m] [def: duel]
	duelya'nt/N [m] [def: duelist]
due't/N [m] [def: duet]
duft/N [def: fragrance] royznduft/N
dugme{dwgm#}/Xdugmes{dwgm#wT}/H [f] [def: example]
	ledugme{ldwgm#}/H [adv] [def: for example]
duhe/S [f] [def: bow over a horse-collar (Ukrainian дуге)]
dukat/N [m] [def: ducat]
dukh [m?] [def: steam]
	[idiom: fun im iz keyn dukh iz nito = he has completely disappeared]
dukhn{dwxn}/Vdukhnen{dwxnen}/T [def: recite priestly blessing (Jewish religious)]
dukhovne/A [def: clergy (Ukrainian духовне)]
dul/V/T [def: confuse; annoy] /Gon
	tsedul/V/Btsedult [def: confuse]
	fardul/V/Bfardult [def: stun, daze] 
	du'lenish/N [n] [def: confusion]
	dul/A [def: insane; confused]
		duler [def: obfuscator, fool]
dum/V/T [def: brood, hover, loom]
dume [def: town hall; Russian Parliament (1906-1917)] 
dumpik/A [def: stale]
	fardumpt/A dumpik/A fardumpn/A [def: stale, smelly]
		fardumptkayt/N [f] [def: staleness] % Forwards: Boris Sandler
duner/V/T [def: thunder]
	/Goys/Garoys [def: speak loudly and angrily]
	duner/N [m] [def: thunder] /Idik [def: thunderous]
	geduner/S [n] [def: thunderstorm] 
	[idiom: a duner iz mir = woe is me]
duplikat/A [def: duplicate]
	dupliki'r/V/Bdupliki'rt [def: duplicate; clone] 
dupye/S [f] [def: vagina (body part; taboo)] 
durak/Ees [m] [def: fool] % Mendele
dure/V/T [def: annoy; chatter, prattle]
	[idiom: duren emetsn a kop = annoy someone]
durkh/P durkhet [adv] adurkh/P adurkhet [adv] [def: through]
	derdurkh [adv] [def: thereby] 
	durkhoys [adv] [def: throughout; absolutely, positively]
		/Iik [def: certain; necessary]
	durkhdem [adv] [def: thereby]
dush/N [m] tush/N [m] [def: sprinkle; shower bath]
dushe/V/T [def: suffocate; stew meat] /Gtsu
	dushne/A [def: stuffy (Polish duszny)]
		duzhdik/A [def: sultry]
	gedishekhts/N [n] [def: stewed meat (food)] 
du'shenyu [noun] du'shenke du'shinke [def: beloved, darling (Polish dusza)] [grammar: indeclinable]
	lyube-dushe [def: beloved, darling]
dutske/S [f] [def: goad, shove] 
dvar{dBr}/Xdvorem{dBrym}/H [m] [def: word, thing]
dvorets/Xdvortses [m?] [def: palace]
	dvoryanin/Ees [m] [def: nobleman]
	dvornik/Ees [m] [def: janitor]
dyabe't [f?] [def: diabetes (disease)] /Iish
dyafragme/S [f] [def: diaphragm (anatomy)]
dyagona'l/A [def: diagonal]
dyagno'z/N [m] [def: diagnosis] 
	[idiom: shteln dem dyagnoz = diagnose]
dyale'kt/N [m] [def: dialect] /Iish
	hoyptdyale'kt/N [m] [def: principal dialect] 
	iberdyalektish/A [def: trans-dialect] 
	dyalektologye/S [f] [def: dialectology]
dyalektik [f] [def: dialectics (philosophy)]
	dyalektiker/X [m] [def: philosopher]
dyalo'g/N [m] [def: dialog]
dyameter/S [m] [def: diameter]
dyapazon [m?] [def: diapason, octave]
dyaspore/S [f] [def: Diaspora] 
dyegekhts [f/n] dzhegekhts [f/n] [def: grease; pitch, tar] 
dyele/S [f] [def: court case]
dzhet/N [m] [def: jet airplane]
dzhez [m] [def: jazz]
dzhedzhits [m] [def: lord] % Mendl Man 
dzhimdzhik/Ees [m] [def: gadget, widget]
-/Xdzhins -/Xbloydzhins [def: jeans (clothing)] [note: V]
dzhobe/V/T [def: peck] % Harduf 
dzhokhe/V/T dzhukhe/V/T dzhukhnye/V/T [def: slap, punch]
	dzhokh/N [m] dzhukh/N [m] dzhukhnye/S [f] [def: slap, punch]
dzhudo [m?] [def: judo (sport)]
dzin [interj] [def: ding! (sound of a bell)]
e/Een [m] [def: the letter E] 
editorya'l/N [m] [def: editorial (article)] 
	editorye'l/A [def: editorial] 
ef/N [m] [def: the letter F] 
efekt/N [m] [def: effect] efekti'v/K [def: effective]
	efektivkayt/N [f] [def: effectiveness]
	bay'efekt/N [m] [def: side effect] 
	benzin-efekti'v/A [def: fuel-efficient] [note: V] 
efn/V/T [def: open] /Goyf/Gfunander
	tseefn/V/Btseefnt [def: open]
	derefn/V/Bderefnt [def: open]
		derefenung/N [f] [def: opening]
	farefentlekh/V/Bfarefntlekht [def: publish]
	ofn/K [def: open] /Itlekh
		ofenerheyt [adv] [def: openly] 
		ofnkayt/N [f] ofntlekhkayt/N [def: openness] 
	efntlekh/A [def: public] efntlekhkayt/N [f] [def: publication]
		farefntlekh/A [def: public]
	efenung/N [def: opening]
efsher{#fSr}/H [def: maybe]
egalita'r/A egalitarish/A [def: egalitarian] 
ego [def: ego]
	egoi'st/N [m] [def: egotist] /Iish [def: egotistical]
		egoti'st/N [m] [def: egotist] /Iish [def: egotistical]
	egoi'zm [m] [def: egoism] 
	egofo'b/N [m] [def: self-hater] 
ek/N [m] [def: border; tail] /D /Iik
	ek/V/T [def: end (with "zikh")]
	ekst/A [def: final; ultimate]
	drayek/N [m] [def: triangle] /Iik
	filek/N [m] [def: polygon]
	finfek/N [m] fi'nefek/N [def: pentagon]
	firek/N [m] [def: quadrilateral] /Iik /Iekhik
	grodek/N [m] [def: rectangle] /Iik
	zeksek/N [m] [def: hexagon]
	hartnekik/A [def: stubborn]
	loshik-ekl/Eekh [def: pony tail (hair style)]
ekdish/N [m] [def: scorpion (animal)]
ekho/S [m] [def: echo] % Harduf
	ekho/V/T [def: echo] /Gop % Rokhl Korn: shotns
ekht/A [def: true to form]
	ekhtkayt/N [f] [def: true nature]
	baekhtik/V/Bbaekhtikt [def: authenticate; certify]
ekipa'zh/N [m] [def: equipment (French); carriage]
	fli'-ekipa'zh [def: flight crew] [note: V]
ekl/V/T [def: disgust] [usage: doubtful admissibility]
	ekldik/A [usage: doubtful admissibility]
	eklhaft/K /Iik [def: disgusting] [usage: inadmissible]
	farekl/V/Bfareklt [def: disgusted] % Forwards
ekli'ps/N [n] [def: eclipse]
ekologye/S [f] [def: ecology] ekologish/A
ekonomye/S [f] [def: economy] ekonomik [def: economics]
	ekonomish/A [def: economic, economical] ekonom/N [def: accountant]
	ekonomi'st/N [m] ekonomistke/S [def: economist]  % Forwards
	ekono'miker/S [m] [def: economist] % Forwards: Sholem Berger
ekran/N [m] [def: screen]
eksisti'r/V/Beksisti'rt [def: exist] eksistents [f] [def: existence]
eksklusi'v/A [def: exclusive] 
ekskursye/S [f] [def: excursion] 
eksmisi'r/V/Beksmisi'rt [def: evict] 
	eksmisye/S [f] [def: eviction] 
ekspedi'r/V/Bekspedi'rt [def: expedite; carry, transport; deliver]
	ekspeditor/N [m] ekspedirer/S [m] [def: expediter; delivery man; carryer]
	ekspeditsye/S [f] [def: expedition]
eksperime'nt/N [m] [def: experiment] /Ia'l [def: experimental]
	eksperimentali'zm [m] [def: experimentalism] 
ekspert/N [m] [def: expert] /A
eksplodi'r/V/Beksplodi'rt [def: explode] 
	eksplozye/S [f] [def: explosion]
	eksplosi'v/A [def: explosive (linguistics)] % Forwards: Shikl Fishman
ekspluati'r/V/Bekspluatirt [def: exploit, oppress]
	ekspluatatsye/S [def: exploitation, victimization]
	eksploatator/N [m] [def: exploiter, victimizer]
ekspona't/N [m] [def: exhibit (object)] 
eksporti'r/V/Beksporti'rt [def: export] 
	ekspo'rt/N [m] [def: export] 
ekspozitsye/S [f] [def: exposition; display; development of a theme]
ekspresye/S [def: expression]
	ekpresyoni'zm/N [m] [def: expressionism (art)]
	ekspresyonistish/A [def: expressionist (art)]
eksprom't/A [def: fleeting, short (time)]
ekpropryatsye/S [f] [def: expropriation, seizure (of property)]
ekstaz/N [n] ekstaze/S [f] [def: ecstacy]
	ekstatish/A [f] [def: ecstatic, fervent]
ekstempori'r/V/Besktempori'rt [def: improvise, jam (music)] [note: V] 
ekstern/S/N [m] [def: extern (student who takes exams, not classes)] /Iish
ekstravaga'nt/A [def: extravagant; unnatural, grotesque; eccentric]
ekstre [adv] extra [adv] [def: extra]
ekstrem/N [f] [def: extreme] ekstrem/K [def: extreme] 
	ekstremi'st/N [m] [def: extremist] /Iish % Forwards
	ekstremi'zm/N [m] [def: extremism] % Forwards: Yoel Matveyev
ektsele'nts [f] [def: excellency]
ekstsentrish/A [def: eccentric]
	ekstsentrishkayt/N [f] [def: eccentricity]
ektses/N [def: excess]
ekvilibri'st/N [m] [def: tight-rope walker]
ekvator [m] [def: equator] 
ekvivalent/A [def: equivalent]
ekzamen/S [m] [def: examination, test]
	ekzameni'r/V/Bekzameni'rt [def: examine] 
	ekzamenator/N [m] [def: examiner]
	[idiom: oyfnemen an ekzamen = give, administer an exam]
	[idiom: opgebn an ekzamen = take an exam]
ekze'm [f?] [def: eczema (skin disease)]
ekzisti'r/V/Bekzisti'rt [def: exist] 
	ekziste'nts [f] [def: existence] % Forwards
	koekziste'nts [f] [def: co-existence] % Lebns Fragn
ekumenish/A [def: ecumenical] 
ekzalt'irt/A [def: exalted (spiritually)]
ekzekutiv/A [def: executive] /N
	ekzekutsye/S [f] [def: execution]
	zakutsye/S [f] [def: unpleasant person; violent act]
ekzemplar/N [m] [def: copy]
ekzotish/A [def: exotic]
elastish/A [def: elastic] % Harduf
	elastishkayt/N [f] [def: elasticity] 
ele_{#l#}/H [def: rather] % must disambiguate from -ele diminutive ending
elebe'le etsh-petsh [interj] [def: so there! expression of triumph] 
elef{#lf}/Xalofem{alfym}/H [def: thousand] /Lbe{b} [def: in a thousand]
	elef{#lf}-hashishi{hSSy} [def: 6th millenium; distant place]
elega'nt/K [def: elegant, upscale] /Iish
elegye/S [f] [def: lament (song)] 
elehey [adv] lehey [adv] [def: as if, as though; just as; for instance]
elektron/N [m] [def: electron] /Iish
	elektre elektrye [def: electricity] elektrish/A
		elektrifitsi'r/V/Belektrifitsi'rt [def: electrify]
	elektriker/S [m] [def: electrician] 
	elektronik [f] [def: electronics (subject)]
		mikroelektronik [f] [def: microelectronics (subject)]
	elektrolit/N [def: electrolyte]
	elektroplatirung/N [f] [def: electroplating]
	elektro [adj] [def: electro] % uninflected, hyphenated
elel{#lwl}/H [m] [def: Hebrew month of Elul] /Idik
element/N [m] [def: element] /Ia'r/Iarish [def: primitive, elementary] 
	gruntelement/N [m]
elevator [m] eleveytor [m] [def: elevator]
elf [d] [def: 11] /It [def: 11th]
	elef [d] [def: 11] /It [def: 11th] elftl [n] [def: 1/11]
	elftns [adv] [def: 11th] 
elf/N [m] [def: elf (mythical creature)] /Iish
elimini'r/V/Belimini'rt [def: eliminate; suspend (from school)]
elite/S [f] elit [f] [def: elite] /Iar /Iarish /Iistish [def: elite] 
elnt/K [def: lonely] elntkayt/N [f] [def: loneliness]
elokven't/A [def: eloquent] eloqve'nts/N [f] [def: eloquence] 
em/En [m] [def: the letter M] 
emalye [f] [def: enamel]
	emali'r/V/Bemali'rt [def: enamel]
emanatsye/S [f] [def: emination, radiation; phosphorescence]
emantsipi'r/V/Bemantsipi'rt [def: emancipate]
	emantsipatsye/S [def: emancipation]
embargo/S [m] [def: embargo] % Harduf
emble'm/N [f] [def: emblem, badge]
emer/S [m] [def: bucket]
emeritur [f] [def: retirement] % Harduf
	emeritus [adj] [def: emeritus] % Stutchkoff
emes{#mT}/H [m] [def: truth]
	emes{#mT}/H/A [def: true] /Idik
	beemes{b#mT} [adv] [def: truly]
	hoemes{h#mT} [m] [def: the truth] 
	emesn{#mTn} [m] [noun dative]
	[idiom: zogn dem reynem emes{#mT} = tell it like it is]
	[idiom: vos emes iz emes = when you're right, you're right]
	[idiom: borekh{brwX} dayen{dyn} hoemes{h#mT} = blessed is the Righteous Judge (said when hearing of a death)]
emets emetser emetsn emetsns imets imetser imetsn imetsns emits emitser emitsn emitsns [def: someone or something]
emine'nts [f] [def: eminence]
emisye/S [f] [def: series (of currency); edition]
emotsye/S [f] [def: emotion] emotsyone'l/A
	emotsyonelkayt/N [f] [def: emotional nature] % Rokhl Boymvol
empirish/A [def: empirical, experimental]
emule't/N [m] [def: amulet] % Forwards
emune{#mwnh}/Xemunes{#mwnwT}/H [f] [def: faith; religion]
	beemune_shleyme{b#mwnh-Slymh} [adv] [def: confidently]
	-/Xketoney_emune{ktny-#mwnh}/H [def: people of little faith]
	nemones{n#mnwT}/H [f] [def: truth, faith]
		benemones{bn#mnwT}/H [def: in good faith]
en/En [m] [def: the letter N] 
end/N [f] [def: end] [usage: doubtful admissibility]
	endlozik/A [def: unlimited, infinite] [usage: not recommended]
ender/V/T [def: change] enderung/N [f] [def: change]
	farender/V/Bfarendert [def: change] farenderung/N [f] [def: change]
endik/V/T [def: finish]
	farendik/V/Bfarendikt [def: finish]
	endlekh/A [def: at last] onendik/A u'me'ndlekh/A [def: interminable]
		ume'ndlekhkayt/N [f] [def: persistence, durability]
energye/S [f] [def: energy] energish/A
	energe'tik [f] [def: energy] % Forwards: Estraykh
	energetish/A [def: energetic] % Forwards: Estraykh
eng/K [def: narrow] engshaft/N [f]
	engenish/N [n] [def: crowded situation] % Der Nister 
	geengt/A [def: closed-in] 
	eng/N/V [def: tighten] /Gayn [def: take in (clothing); limit; reduce]
enigme/S [f] [def: enigma, mystery]
	enigmatish/A [def: enigmatic]
enkavudenik/Ees [def: member of NKVD, Soviet secret police]
enlekh/A [def: similar] u'me'nlekh/A enlekhkayt/N [f] [def: similarity]
	endl/V/T [def: be similar, resemble (with "tsu")]
	[idiom: enlekh oyf = similar to]
entfer/V/T [def: answer] /Gtsurik/Garop
	/Giber [def: entrust] % Der Nister
	/Gop [def: rebut (with "oyf")]
	entfer/S [m] [def: answer]
		opentfer/S [m] [def: rebuttal, refutation]
	farentfer/V/Bfarentfert [def: give an excuse (with "zikh"); solve a problem]
		farentferung/N [f] [def: solution (to a problem)] 
	fara'ntvortlekh/A [def: responsible]
		fara'ntvortlekhkayt/N [f] [def: responsibility]
		u'mfara'ntvortlekh/A [def: not responsible]
	e'ntferke/S [f] [def: answering machine] [note: V] 
entomologye/S [f] [def: entomology, study of insects] % Forwards
	entomologi'st/N [m] entomologistke/S [f] [def: entomologist] % Forwards
entsiklopedye/S [f] [def: encyclopedia] 
	entsiklopedi'st/N [m] [def: expert at many things]
	entsiklopedish/A [def: encyclopedic]
entuzya'zm/N [m] [def: enthusiasm] 
	entuzyast/N/Iish [m] [def: enthusiast] 
enzi'm/N [m?] [def: enzyme]
epes [noun] [def: something] etvos [def: something (German)]
	epes [adv] [def: somehow; somewhat; very] 
	[idiom: gey tu epes = it's hopeless]
epidemye/S [f] [def: epidemic] epidemish/A
	epidemyolog/N [m] [def: epidemiolgist]
	pandemik/Ees [f] [def: pandemic]
epilepsye/S [f]  [def: epilepsy (disease)]
epilog/N [m?] [def: epilogue]
episkopaler/X [def: Episcopalian]
epistolar/A /Iish [def: epistolary, letter-writing]
epita'f/N [m] [def: epitaph]
epite't/N [f?] [def: epithet, title, name]
epizod/N [m] [def: episode]
epl/X/Depe [m] [def: apple (fruit)]
	erdepl/X [m] [def: potato (food)] 
	oygepl/Xoygeplen [def: eyeball]
	paltshine/S [f] [def: orange (fruit) (Ukranian апельсин)] % Sholem Aleykhem: Bashefenish
	may'-epl/X [m] [def: mayapple (Podophyllum peltatum) (plant)] % M. Schaechter: geviksn
epokhe/S [f] [def: epoch]
epole't/N [m?] [def: epaulet (ornament on clothing)] /D
epik/N [f] epopee/S [f] [def: epic] 
	epish/A [def: epic] 
er/En [m] [def: the letter R] 
erbyum [m] [def: erbium (Er)] 
erd/N [f] [def: earth] /Iish /Ien [def: earthy]
	erdishkayt/N [f] [def: earthliness; materiality] 
	drerd [def: in the earth]
	[idiom: ikh hob dikh in drerd = go to hell]
	khuts{Hwc}-erdish/A [def: extra-terrestrial]
	untererdish/A [def: subterranean]
		untererdler/S [m] [def: underground, secret worker]
	baerdik/V/Bbaerdikt [def: bury]
	[idiom: vi himl un erd = completely opposite]
ere/S [f] [def: honor (German)] [usage: inadmissible] 
	ern [adj] [def: of honor, honorable, testimonial]
		[grammar: often connected to next word]
	baer/V/Bbaert [def: honor] 
	farerer/S [m] fare'rerin/S [f] [def: devotée; suitor]
	geert/A [def: honorable; honored]
erekh{erx}/H [def: approximation]
	 beerekh{berx} leerekh{lerx} [adv] [def: approximately, about]
erets{#rc}/Xarotses{arcwT}/H [f] [def: land]
	erets_yisroel{#rc-yQr#l} [def: land of Israel] 
	ortse{orch} [adv] [def: downwards; on the ground]
	[idiom: vad{ved} arbe{arbe} arotses{arcwT} = Rabbinic Council of Four Lands]
erev_rav{erB-rB} [m] [def: large group of people]
ergets [def: somewhere]
	[idiom: ergets-vu = somewhere]
	[idiom: nit in ergets = nowhere]
e'rike [f] [def: heath, heather (plant genera Erica, Cassiope, Daboecia)] 
erlekh/K [def: honest, upright; in good faith; religiously observant]
	erlekhkayt/N [f] [def: honesty]
	u'me'rlekh/A [def: dishonest, in bad faith]
	u'me'rlekhkayt/N [f] [def: dishonesty, bad faith] 
ern- [prefix] [def: of honor, honorary; testimonial; honorable] 
	ernhaftik/A [def: honorable] 
ernst/K [def: earnest, serious]
	ernstkayt/N [f] [def: earnestness]
eropla'n/N aeropla'n/N ayropla'n/N [m] [def: airplane]
eropo'rt/N [m] aeropo'rt/N [m] [def: airport (American)] % Sheva Zucker
erotish/A [def: erotic]
	erotishkayt/N [f] erotitsi'zm/N [m] [def: eroticism] 
eruditsye/S [f] [def: erudition, learnedness]
	erudi't/N [m] [def: erudite, sage]
	erudi'rt/A [def: learned, sagatious] % Rokhl Boymvol
erve{ervh}/Xerves{ervwT}/H [f] [def: female genitalia; sexual immodesty; nakedness; shameful behavior] 
	arayes{erywT}/H [def: forbidden sexual relations or partners; sinful lust] 
es/En [m] [def: the letter S] 
es/V/Bgegesn [def: eat] /Gop/Giber/Gon
	/Goyf [def: eat up]
	/Goys [def: eat through (like rust)] % Forwards: Boris Sandler
	/Gtsu [def: become boring (with "zikh")] % Sholem Aleykhem: Oreme un Freylekhe 
	/Gayn [def: be a pest (with "zikh")]
	deres/V/Bderesn [def: consume; bore; annoy]
	eser/S [m] [def: eater]
	esn/S [n] [def: food] 
		fa'rtik-esn [n] [def: take-out food] 
		gi'khesn [n] [def: fast food] [note: V]
			gi'kheseray' [f] [def: fast food restaurant] [note: V]
	esenish/N [n] [def: annoyance, irritation]
	esevdik/A [def: edible]
esents/N sents/N [m?] [def: extract (food)]
	ma'ndlsents/N [m?] [def: almond extract (food)] % Forwards: S-R Schaechter 
esesovets/N [m] [def: SS officer (WWII)] 
esey/N [m] [def: essay]
	esei'st/N [m] eseyi'st/N [m] eseistke/S [f] eseyistke/S [f] [def: essayist] 
	eseyistik [f] [def: essay writing] % Forwards
eshafo't/N [m] [def: scaffold, gallows, gibbet]
eshelon [m] [def: echelon]
esik [m] [def: vinegar] /A [def: vinegary]
	[idiom: mit esik = par excellence]
eskadron/N [m] skadron/N [m] [def: squad, squadron] 
eskalatsye/S [f] [def: escalation] 
	eskalator/N [m] [def: escalator] % Harduf
eskhatologye/S [f] [def: eschatology] % Forwards
	eskhatologish/A [def: eschatologic] % Forwards
eskort/N [m?] [def: accompaniment, escort]
esreg{#Trwg}/Xesroygem{#Trwgym}/H [m] [def: ethrog]
	[idiom: batrakhtn vi an esreg{#Trwg} = look at each part in detail]
	[idiom: a lulev{lwlB} mit an esreg{#Trwg} = large and small horse harnessed together (balegole-loshn)]
	[idiom: a blinder esreg = something purchased without inspection]
estetik [f] [def: esthetics (subject)] estetish/A [def: esthetic]
et [interj] [def: et: expression of disdain]
etabli'r/V/Betabli'rt [def: establish] 
eta'p/N [m] [def: (activity) phase; (journey) leg; prisoner convoy]
	[idiom: mitn etap = in a prisoner convoy]
eta'zh/N [m] [def: floor, storey, level (architectural)]
eta'zherke/S [f] [def: chest with shelves (furniture)]
eter [m] [def: ether] % Harduf
etik [f] [def: ethics (subject)]
	etish/A [def: ethical] u'me'tish/A [def: unethical]
	byoetik [f] [def: bioethics] % Forwards: Sholem Berger
etike't/N [m] [def: label, tag, ticket] /D
	heng-etike't [m] [def: hangtag] [note: V]
etimologye/S [f] [def: etymology] etimologish/A
	etimolog/N [m] [def: etymologist (occupation)] % Stutchkoff
etlekh/A [def: several]
etnish/A [def: ethnic]
	etnolog/N [m] [def: ethnologist] /Iish [def: ethnological]
		etnologye [f] [def: ethnology]
	etnografye/S [f] [def: ethnography]
		e'tnograf/N [m] e'tnogra'fin/S [f] [def: ethnographer]
		etnografish/A [def: ethnographic]
etsem{ecm}/Xatsomes{ecmwT} [m] [def: bone; dice]
	etsem{ecm} [adj] [def: the same]
	beetsem{becm} [adv] [def: itself, alone]
	atsmoy{ecmw}/H [def: himself]
	etsemdik{ecmdik}/A [def: central, essential]
evakui'r/V/Bevakui'rt [def: evacuate (often with "zikh")]
	evakuatsye/S [f] [def: evacuation; exodus]
evangelye/S [f] [def: gospel] evangelish/A evangelistish/A
	evangelyum [def: the Catholic Church]
	evange'liker/X [def: evangelist Christian] 
eved{eBd}/Xavodem{eBdym}/H [m] [def: slave]
	oyved{ewBd}/H [def: laborer]
	meshubed{mSwebd} [adj predicative] [def: enslaved] 
eventue'l/A [def: possible, contingent] 
evenyu/S [def: avenue]
evkaliptus [m?] [def: eucalyptus (tree)] % Forwards: B. Sandler
e'vntov{#Bn-twB}/Xavonem-toyves{aBnym-twBuT}/H [m] [def: jewel; esteemed person]
evolutsye [f] [def: evolution]
evyen{#Bywn}/Xevyoynem{#Bywnym}/H [m] e'vyente{#Bywnte}/S [f] [def: poor person]
ey/Xeyer [n] eyele/Xeyelekh/Xeyerlekh [n] [def: egg; testicles (in plural); hand grenades (soldiers' argot)]
	eyen/A [def: pertaining to eggs]
	shpigley{shpigl#ey}/Eer [def: egg fried sunny-side up]
	[idiom: nit vert keyn oysgeblozn ey = worthless]
	[idiom: fir-kantike eyer = impossible request (jewelers' argot)]
eybik/A [def: eternal] eybikayt/N [f] [def: eternity]
	fareybik{far#eybik}/V/Bfareybikt{far#eybikt} [def: make everlasting]
		farey'biker/X [m] [def: immmortalizer, memorializer]
	[idiom: far der eybikayt = for the record]
	[idiom: oyf eybik = for ever]
eyd{ed}/Xeydem_{edym} [m] [def: witness]
	eydes{edwT}/X [f] [def: testimony] [m] [def: witness]
		[idiom: eydes{edwT} zogn = testify]
		eydesshaft{edwTshaft}/N [f] [def: testimony]
	meyid{me|id} [verb] [def: testify (with "zayn")]
	eydes{edwT}/V/T [def: testify (with "zikh mit")] % Bergelson
	gviyes_eydes{gByT-edwT}/H/N [m] [def: testimony, evidence] 
	[idiom: nemen gviyes-eydes{gByT-edwT} = hear testimony]
eyde{edh}/Xeydes{edwT}/H [m] [def: (Jewish) community; congregation]
	% plural form in Hebrew used in the singular in Yiddish
	kol_am_voeyde{Kl-em-|w|edh}/H [def: entire populace]
eydem/S [m] [def: son-in-law] /D
eyder [def: before; than]
eydl [adj] [def: noble, refined] eydeler/A eydele eydlen eydls eydlst/A % irregular
	eydl/V/T [def: become noble] /Goys
	eydlkayt/N [f] [def: nobility]
	fareydlt/A [def: refined]
eydn{edn}/H [def: Garden of Eden]
eyfemi'zm/N [m] [def: euphamism]
eyfer [m] [def: jealosy; zeal] /Idik /Iik /Izikhtik
	ey'ferzukht/N [f?] eyferzi'khtikayt/N [def: jealosy, envy]
eyforye/S [def: euphoria] % Forwards: Yoel Matveyev
eygenik [def: eugenics] eygenish/A [def: eugenic] 
eygn/A [def: own; same] /Itlekh eygnkayt/N [f] [def: property, quality]
	eygnshaft/N [f] [def: characteristic]
		laybeygnshaft/N [f] [def: serfdom]
	eygntum/N [n] [def: property, ownership]
	eygntlekh [adv] [def: actually] 
	eygntimlekh/A [def: unique] eygntimlekhkayt/N [f] [def: uniqueness] [usage: inadmissible]
	eygntimer/S [m] eygnti'merin/S [f] [def: owner]
		miteygntimer/S [m] [def: co-owner]
	eygn/V/T /Gtsu [def: acquire]
		fareygn{far#eygn}/V/Bfareygnt{far#eygnt} [def: acquire]
eykalipt/N [def: eucalyptus (tree)] 
eykho{#yxh}/H [def: Book of Lamentations]
eym{#m}/H [f] [def: mother]
	voeym{|w#m} [def: Jewish settlement (with "ir -")]
eyme{#ymh}/H/Idik [def: fear]
	meuyemdik{m#wymdik}/H/A [def: horrifying, fearsome]
	matil_eyme{mtyl-#ymh} [verb] [def: terrify (with "zayn")] % Stutchkoff
eyl/N [m] [def: oil] 
	kimleyl [m] [def: oil of caraway]
	konoplye-eyl [m] [def: hempseed oil]
	layneyl [m] laynzoymen-eyl [m] [def: flakseed oil]
	negelekh-eyl [m] [def: clove oil]
	oliveyl [m] olivke [f] [def: olive oil]
	palmeneyl [m] [def: palm oil]
	sala'teyl [m] [def: vegetable oil]
	eylbert/N [m] [def: olive]
eyl/N [f] [def: ell (45"); cubit] 
eyl [m] [def: ale (drink)] 
eylbert/N [m] [def: olive]
eyn [d] eyns/N [d] /D [def: one] eyntsln [adj] eyntslne/A % BUG: eyntsln/A generates forms wrong (extra e)
	eyntsik/K [def: only]  eyneyntsik{eyn#eyntsik}/A [def: unique]
	ersht [def: first; recently]
		/Iik [def: prime (mathematics)] 
		ako'rsht [def: once; just] korsht
		o'kersht [adv] [def: once; just now, recently] /Iik
			okorsht [adv] [def: once; just now, recently]
	ersht/A ershtns [def: first] tsuersht
		[idiom: tsum alem ershtn = first of all]
	forersht/A [def: previous]
	ershtling/N [m] [def: firstborn]
	eyn/A/Itsik/Iik/Itsl [def: single] % bug: need epenthetic e before l
		ey'nikayt/N [f] [def: unity, solidarity; singleness]
	eynzam/A eynzamkayt/N [f] [def: lonely] fareynzamt{far#eynzamt}/A
	eynhayt/N [f] [def: unity; unit (military)]
	eynik/V/T fareynik{far#eynik}/V/Bfareynikt{far#eynikt} [def: unite]
		fareynikung{far#eynikung}/N [def: unification] 
	fareyn{far#eyn}/N [m] [def: union, society]
	eyntslhayt/N [f] [def: detail]
	eyner eynem [pronoun] eynems [pronoun (possessive)] [def: one]
		eyntsikvayz [def: one at a time]
		[idiom: ... eyner = silly ... ]
	/Deyner [def: one ruble note (money)]
	ineynem{in#eynem} [def: together]
	altseyne/A [def: identical] 
	[idiom: alts eyns = all the same; it doesn't matter]
eynikl/Xeyniklekh [n] [def: grandchild; relative of a Hassidic rabbi]  % no positive form
	ureynikl{wr#eynikl}/Xureniklekh{wr#eyniklekh} [n] [def: great grandchild]
eyrev{e|yrwB}/H/N [m] [def: Sabbath boundary]
eyropyum [m] [def: europium (Eu)] 
eys{eT}/H [f] [def: time]
	lesate{leT-eWh}/H [def: until then]
	mesles{meT-leT}/H/N [def: 24-hour period]
		meslesnvayz{meT-leTnvayz} [adv] [def: by the day] 
eysek{esk}/Xasokem{eskym}/H/D [def: business; matter, concern]
	far|eysek|/V/Bfar|eysek|t [def: busy]
	mesasek{mTesk} [verb] [def: be occupied with (with "zayn")]
	oysek{ewsk}/H [def: busy]
	askn{eskn}/Xaskonem{esknym} [m] [def: worker (for a cause)] 
	[idiom: poter{ptwr} an eysek{esk} = done; no need to discuss further]
eysh-lehove{#S-lhBh} [adj predicative] [def: extremely angry] 
eyshes{#ST}/H [def: woman of]
eyter/N [m] [def: mucus; pus]
eytl [adv] [def: only, just, nothing but]
	eytl/A [def: vain, empty, void]
		eytlkayt/N [f] [def: emptiness, worthlessness]
eyts{ec}/H [m] [def: tree]
eytse{ech}/Xeytses{ecwT}/H [f] [def: advice]
	eytse{ech}/H/V/T [def: advise] eytsen/V/T
	[idiom: haltn zikh an eytse mit emetsn = ask someone for advice]
	bal_yoyets{bel-ywec}/Xbale_yoy'etsem{bely-ywecym}/H [m] [def: advisor]
eyver{#Br}/Xeyvrem{#Brym}/H [n] [def: limb; penis (body part) (common usage); body member]
	eyvrem|vayz [adv] [def: limb by limb]
	[idiom: kishe{kySwy} eyver{#Br} = erection]
eyzl/N [m] eyzlte/S [f] [def: donkey (animal)]
	kha'mer_eyzl{Hmwr-eyzl} [m] [def: man driven by sexual drive]
	moyleyzl{moyl#eyzl}/Xmoyleyzlen{moyl#eyzlen} [m] [def: mule (animal)] 
ezoterish/A [def: esoteric]
fabl/N [f] [def: fable] % Harduf
	fabule/S [f] [def: plot (literature)]
fabri'k/N [f] [def: factory] /D
	fabrike/S [f] [def: factory] [usage: archaic]
	fabrika'nt/N [m] [def: manifacturer] 
	fabrika't/N [m] [def: manufactured good]
	fabrikatsye/S [f] [def: fabrication, construction] 
	fabritsi'r/V/Bfabritsi'rt [def: manufacture] 
	gi'sfabri'k/N [f] [def: some sort of factory ??] % Bergelson: Yosef Shur 
	kva'sfabri'k/N [f] /D [def: kvass (Russian drink) factory]
faeton/N/S [m] [def: phaethon carriage (vehicle)] /Dfaetond
fago't/N [m] [def: bassoon] 
fakh/N [m] [def: trade, specialty, vocation, occupation; fold; shelf]
	eynfakh/A [def: simple] [usage: doubtful admissibility]
		fareynfakh{far#eynfakh}/V/Bfareynfakht{far#eynfakht} [def: simplify] 
	drayfakh /Iik [def: three-fold; three-part] 
	firfakh/A /Iik [def: four-fold; four-part]
	fulfakhik/A [def: full-fledged]
	hundertfakh/A [def: hundred-fold]
	tsveyfakh /Iik [def: two-fold] 
	sforem{sfrym}-fakh/N [m] [def: bookshelf]
	zibnfakh /Iik [def: seven-fold]
fakl/N [m] [def: torch] [usage: doubtful admissibility]
faks [def: fax (English)]
fakt/N [m] [def: fact] /Iish /Indik [def: factual]
	faktor/N [m] [def: factor, influence]
fakultet/N [m] [def: faculty (academic)] 
fal/V/Bgefaln [def: fall; occur]
	/Gtsu/Garayn/Garop/Garunter/Gavek/Gop/Gtsuzamen/Gum/Garoys
	/Gfarbay/Goys/Garoyf/Gariber/Gfunander/Gtsunoyf/Gtsurik/Ganider
	/Gayn [def: occur (impersonal, with dative and "az")]
	/Gdurkh/Gadurkh [def: fail]
	/Gon /Giber /Garum [def: tackle] [note: V] 
	/Gbay [def: come to mind (with dative)] % Forwards: Riki Royz
	bafa'l/V/Bbafa'ln [def: attack; tackle]
	antfa'l/V/Bantfa'ln [def: fail (strength, heart, ...)]
	falike/S [f] [def: epilepsy (disease)]
		falik/A [def: suffering from epilepsy]
	tsefal/V/Btsefaln [def: attack; distintegrate]
		byotsefalik/A [def: biodegradable] [note: V]
		tsefalung/N [f] [def: disintegration; decomposition]
	aynfal/N [m] [def: idea]
		/Ierish [def: novel, inventive]
	durkhfal/N [m] [def: failure] % Harduf
	eyntslfal/N [m] [def: unique occurrence] 
	funanderfal/N [m] [def: dissolution, disintegration] % Forwards: Yoel Matveyev
	feldznfal/N [m] [def: rockfall] 
	forfal/N [m] [def: event, accident] [usage: inadmissible]
	noytfal/N [m] [def: emergency]
	onfal/N [m] i'berfal/N [def: attack]
		onfaler/S [m] onfa'lerin/S [f] [def: attacker]
	opfal/N [m] [def: waste, discard]
		opfalekhts/N [n] [def: waste material]
	oy'snemfal/N [m] [def: unusual occasion] % Stutchkoff
	toytfal/N [m] [def: fatal incident] 
	tsufal/N [m] [def: accident, coincidence]
		tsu'felik/A [def: accidental; coincidental]
		tsufelikayt/N [f] [def: unusual situation]
		[idiom: bay tsufal = by coincidence]
	u'mglikfal/N [m] [def: unfortunate accident]
	vaserfal/N [m] [def: waterfall]
	farbayfalndikerheyt [def: in the act of falling]
	farfaln/A [def: beyond hope; disappeared]
	fal/N [def: occasion]
		yedn_fals{yedn~fals} [def: anyhow, in any case]
		[idiom: oyf yedn fal = in any case]
	gefalnkayt/N [f] [def: state of having fallen; depravity]
	[idiom: faln korem{Kwre|ym} = prostrate oneself]
falb/N fald/N [m/f] [def: fold of cloth; pleat]
	falb/V/T fald/V/T [def: fold; wrinkle; gather]
	fa'ldeve/V/T [def: make with tucks; fold (cooking)] % Bashevis; Jochnowits
falirtshik/Ees [m] [def: dumpling (food)]
falk/N [m] [def: hawk (bird)] 
falsh/A [def: false] falshkayt/N [f]
	fa'lsheve/V/T [def: cheat; play or sing flat] 
	felsh/V/T fe'lsheve/V/T farfelsh/V/Bfarfelsht [def: forge, falsify]
		felshung/N [f] farfelshung/N [f] [def: sham, forgery, falsification] 
		felsher/S [m] [def: forger] 
	falsivitsi'r/V/Bfalsifitsi'rt [def: falsify]
	false't [m?] [def: falsetto (voice)]
	feltshung/N [f] [def: treason, defection, desertion]
falye/S [f] [def: billow] 
familye/S [f] [def: family; family name]
fan/N/Dfend [f] [def: pan; frying pan]
fanatish/A [def: fanatic] fanatiker/S [m] [def: fanatic] 
	fanatik [m] [def: fanatic] [usage: not recommended]
	fanati'zm/N [m] [def: fanaticism] 
fanfaronke/S [f] [def: dandy, swell, fop]
fang/V/Bgefangen [def: catch; imprison] /Gon
	gefangenshaft/N gefe'nkenish/N [n] [def: prison; captivity]
	gefangener [m] [def: prisoner] % Harduf 
	fanger/S [m] [def: captor] % Forwards: Ludin
	onfang [def: begin (German)]
		onfanger/S [m] [def: beginner]
fant/N [m] [def: collateral; deposit; game of hazards (in plural; German Pfänder)]
fantazi'r/V/Bfantazi'rt [def: fantasize] fantazye/S [f] [def: fantasy]
	fantastish/K [def: fantastic]
	fantazyo'r/N [m] fantazyorke/S [f] [def: visionary, wishful thinker]
	fantastik [f] [def: fantasy (literary genre)] % Forwards: Yoel Matveyev
fanto'm/N [m] [def: phantom] 
far/P [def: for; before; in the time of] fara
	farik/A forik/A [def: previous]
	foroys [def: in front] fornt [def: front]
	derfar [def: therefore]
farakhte/V/T [def: be disgusted] farakhtung/N [f] [def: contempt]
faran/Iendik faranen faranet [def: exist (with "es iz")]
farb/V/T [def: color; paint] /Goys/Gop/Gtsu/Gon
	bafarb/V/Bbafarbt farfarb/V/Bfarfarbt [def: color]
	farb/N [f] [def: color]
		eylfarb/N [f] [def: oil-based paint]
	farbik/A [def: colorful]
		eylfarbik/A [def: oil-colored] % Der Nister
		buntfarbik/A [def: multicolored]
		eynfarbik/A [def: colorless]
		farsheydnfarbik/A [def: multicolored]
		filfarbik/A [def: multicolored]
		filfarbikayt/N [f] [def: multicolored nature]
		fulfarbik/A [def: highly colored]
		fulfarbikayt/N [f] [def: highly colored nature]
		farshidnfarbik/A [def: variously colored]
		rozfarbik/A [def: rosy] % Bergelson: rozfarbik ponem
	farber/S [m] fa'rberin/S [f] [def: painter (occupation)]
	hoytfarb [def: flesh color]
farborgn/K [def: hidden] farbo'rgenish/N [n] [def: hidden place]
farbot/V/Bfarbotn [def: forbid]
fardarb/V/Bfardorbn [def: corrupt; waste away]
	fardorbnkayt/N [f] [def: depravity, corruption]
farday/V/Bfardayet fardey/V/Bfardeyet [def: digest]
	fardayung/N [f] fardeyung/N [f] [def: digestion] 
fardris/V/Bfardrosn [def: annoy, exasperate; resent, regret (reverse construction)]
	/Ilekh [def: annoying]
	fardros/N [m] [def: annoyance, vexation; chagrin] /Iik [def: annoying]
		fardrus/N [m] [def: annoyance] [usage: not recommended]
	iberdrisik/A [def: tedious]
	[idiom: es fardrist mikh = I regret]
fareyn/N [m] [def: union]
farfl/Xfarfelekh [n] [def: matso crumb, noodle crumb (food)] 
	honikfarfl/Xhonikfarfelekh [n] [def: honeyed crumbs (food)] % Sholem Aleykhem
farges/V/Bfargesn [def: forget]
	fargesung/N [f] [def: act of forgetting] u'mfarge'sen/A [def: remembered]
	u'mfarge'slekh/A [def: unforgettable]
	u'mfarge'slekhkayt/N [f] [def: memorability]
	fargesnkayt/N [f] [def: category of forgotten things] % Forwards: Gershn Vayner
	farge'senish/N [n] [def: oblivion, forgetfullness]
	fargesnhayt/N [f] [def: category of forgotten things] % Forwards: Yechiel Szeintuch
	fargestnitl/Eekh [def: forget-me-not (flower, Boraginaceae)]
fargin/V/Bfargunen [def: indulge; not begrudge, not envy (with "zikh")]
	farginer/S [m] [def: booster, supporter]
		nisht-farginer/S [m] [def: envious person, jealous person]
	farginerish/A [def: indulgent]
		nit-farginerishkayt/N [f] [def: grudge]
fargleyz/V/Bfargleyzt [def: glaze (eyes)]
fargruznet farhruznet fargruzet farhruzet [verb] [def: be mired (with "vern")]
farine [f] [def: farina (American)]
farkiteve/V/Bfarkitevet [def: cement, plaster; harden]
farklastert/A [def: ??] % for feet: placed on a chair or table
farklyaknet/A farklyanet/A [def: arthritic; inflexible]
farlang/V/Bfarlangt [def: desire]
farlend/V/Bfarlendt [def: destroy, annihilate]
farlets/V/Bfarletst [def: transgress; hurt (German)]
farloymd/V/Bfarloymdt [def: slander] [usage: inadmissible]
	farloymdung/N [f] [def: slander] [usage: inadmissible]
farlyape/V/Bfarlyapet [def: become enamored of (with "zikh in"); drench]
farli'r/V/Bfarloyrn [def: lose] /Bfarlorn % both participles exist
	farloyrnkayt/N [f] [def: state of being lost]
	farlust/N [m] [def: loss] [usage: inadmissible]
farm [f] [def: farm] ferme/S [f]
	farmer/S [m] [def: farmer]
farmatse'vt/N [m] [def: druggist, pharmacist]
	farmatsye/S [f] farmatsevtik/Ees [m] [def: pharmacy, drugstore]
	farmakologye/S [f] [def: pharmacology]
farmog/V/Bfarmogt [def: possess, own]
	farmeg [n] farmegn/S [n] farmog [def: possession]
	farmeglekh/A [def: well off]
		nit-farmeglekh/A u'mfarme'glekh/A [def: poor; economically disadvantaged] [note: V]
	shprakhfarmog [def: ability to speak]
	farmoger/S [m] famogerin/S [f] [def: owner, possessor]
farmurze/V/Bfarmurzet [def: smear, streak]
farnikht/V/Bfarnikhtet [def: destroy, annihilate]
	farnikhtung/N [f] [def: destruction; annihilation] 
farpute/V/Bfarputet [def: jumble; entangle] 
farrostet/A farrost/A [def: rusty] % Sholem Asch: Motke Ganef
fars/N [m] [def: farce, burlesque]
farshnoshket/A [def: drunk, tipsy, pixilated] [usage: humorous]
farshvekh/V/Xfarshvekht [def: desecrate]
farshvend/V/Bfarshvendt [def: squander, waste]
	farshvendung/N [def: waste, dissipation]
		tsayt-farshvendung/N [def: waste of time]
farshvind/V/Bfarshvundn [def: disappear]
	farshvindung/N [f] [def: disappearance]
fartakhleve/V/Bfartakhlevet [def: spend foolishly]
fartaye/V/Bfartayet [def: hide, conceal] 
farteydik/V/Bfarteydikt [def: defend]
	fartey'dikung/N [f] [def: defense]
		zikh-fartey'dikung/N [f] [def: self-defense] 
	fartey'diker/S [m] fartey'dikerin/S [f] [def: defender] 
	fartey'dikerish/A [def: defensive]
	[idiom: klal-farteydiker = public defender]
fartik/A [def: ready]
	fartik/V/T [def: prepare] /Goys
		/Gop [def: finish preparation] 
	farfartik/V/Bfarfartikt [def: make ready] 
	re'khtfartik/A [def: righteous, right-minded, upstanding] 
	[idiom: fiks-un-fartik = prepared and ready, blowed and saucered]
farts/V/Bgefortst/Bgefortsn [def: fart, pass wind (taboo)]
	/Goys [def: remove as it were by farting]
	forts/Xferts [m] [def: fart (taboo)]
	fartsoyz/N [def: farter (vulgar)]
fartsay/V/Bfartsayt [def: excuse, forgive (German)] [usage: inadmissable]
fartsogt/A [def: very worried]
farvalter/S [m] farva'lterin/S [f] [def: manager]
	farvaltung/N [f] [def: management; board of directors] 
	aleyn-farvaltung/N [f] zelbstfarvaltung [f] [def: one-man rule] 
farvayl/V/Bfarvaylt [def: spend time] farvaylung/N [f] [def: party]
	farvayler/S [m] [def: entertainer]
	farvay'lerish/A [def: humorous]
farvorloz/V/Bfarvorlozt [def: abandon]
farzesn/A [def: old maid]
fas/Xfeser /Dfes [n/f] [def: barrel; vagina (body part; vulgar)]
	broyfas/Xbroyfeser [n] [def: still (brewing), alembic]
	hantfas/Xhantfeser [n] [def: ritual washstand (in a synagogue)]
	vaserfas/Xvaserfeser [n/f] [def: water barrel]
	gefe's/X [n] [def: dishes]
		blutgefes/X [n] [def: blood vessel] /D
	farfas/V/Bfarfast [def: organize]
		farfaser/S [m] [def: author]
		farfa'senish/N [n] [def: written work] 
	bi'rfesl/Eekh [n] [def: keg of beer]
	fu'terfesl/Eekh [n] [def: darling, beloved]
fasa'd/N [m] [def: facade]
fashi'zm [m] [def: fascism]
	fashi'st/N [m] [def: fascist] /Iish
	neofashistish/A [def: neo-fascist] % Forwards: Yoel Matveyev
fasolye/S [f] [def: bean (food, plant); genus Phaseolus] /Dfasolke
	[idiom: robe fasolye = kidney bean] % Forwards: Hershl Glaser
	[idiom: geshribnene fasolye = pinto bean] % Forwards: Hershl Glaser
faso'n/N [m] [def: fashion] 
	sherfaso'n/N [m] [def: hairstyle] % B. Sandler: Karolina-Bugaz
	[idiom: haltn fason = keep up appearances]
fast/V/T /Gop [def: fast (avoid food)]
	faster/S [def: someone who fasts]
	arayngefast/A [def: emaciated] % Sholem Aleykhem
fata-morgana/S [f] [def: mirage]
fatal/A [def: fatal]
	fatali'st/N [m] [def: fatalist] % Sholem Aleykhem
fatse't/N [m] [def: dandy, fop] 
fatsheyle/S [f] [def: scarf (clothing); handkerchief (clothing)]
	fatsheylke/S [f] [def: handkerchief]
	nozfatsheyle/S [f] [def: handkerchief] % Sholem Aleykhem
fatsyate/S [def: garret, attic room] fatsyatke/S [f]
favori't [m?] [def: favorite]
	favoriti'zm/N [m] [def: favoritism] [note: V] 
fayer/N/D [m/n] [def: fire] /Idik /Iik
	flam-fayerdik/A [def: flaming, extreme]
	[idiom: tsvishn tsvey fayern = in a difficult situation]
fayer/V/T [def: celebrate] [usage: inadmissible]
	fayerlekh/A [def: celebratory; solemn]
		fayerlekhkayt/N [f] [def: solemnity; holiday spirit] 
	fayerung/N [f] [def: celebration; festival] 
	fayerlekhkayt/N [f] [def: solemnity, celebratory nature]
	fayertog/Xfayerteg [m] [def: holiday] % Der Moment
fayf/V/T [def: whistle; disrespect (with "oyf")] /Gon/Goys/Gtsu
	/Gnokh [def: mock by whistling]
	fayf/N/D [n] [def: whistle]
	fayfer/S [m] [def: whistler, piper; gonorrhea (disease)]
	fayferay'/N gefayferay'/N [def: whistling]
fayg/N [f] [def: fig (fruit)]
	fikus [m?] [def: fig tree]
faykht/A [def: damp] faykhtkayt/N [f]
fayl/N [f] [def: arrow]
fayl/N [f] [def: file (tool)] fayl/V/T
fayn/K [def: fine] /Itshik
	fayn/V/T /Goys [def: appear in a good light (with "zikh")]
	farfaynerung/N [f] [def: decoration, improvement, refinement] 
faynd/X [m] [def: enemy] /Ilekh
	fayndlekhkayt/N [f] [def: hostility]
	fayndshaft/N/Ilekh [f] [def: enmity]
	me'ntshnfaynd/X [m] [def: misanthrope] 
faynt [verb] [def: despise, hate (with "hobn" or "krign")]
	/Ilekh [def: hostile] % Forwards
	fayntshaft/N [f] [def: hatred]
faza'n/N [m] [def: pheasant (bird)] 
faze [f?] [def: phase]
fe fu tfu fui [interj] [def: fooey! expression of disgust]
	[idiom: tfu zolstu vern = go fly a kite (mild hetero-malo-petitive)]
februar [m] [def: February]
feder/N [f] [def: feather; knife (ganovem-loshn)] /D /Idik bafedert/A
	fli'feder/N [f] [def: flying feathers] % Chava Rozenfarb: Botshani
	flu'sfeder/N [f] [def: fin (part of a fish)]
	feder/N shpringfeder/N [f] [def: spring (device)]
	[idiom: flik federn = work faster (sherer-loshn)]
feder/S [f] [def: pen]
	blayfeder/S [f] [def: pencil] [usage: doubtful admissibility]
	fe'dernik/Ees [m] [def: poet; writer] % Forwards: M-S Hoffman
feder/V/T [def: arise early]
federa'l/A [def: federal (political)] 
	federatsye/S [f] konfederatsye/S [f] [def: federation; amalgamation]
	federati'v/A [def: federal (political)] % Forwards: Y. London
fee/S [f] [def: fairy (mythical creature)]
fefer [m] [def: pepper] /Idik/Iik
	fefer/V/T /Gon [def: pepper]
	bafefer/V/Bbafefert [def: pepper] 
	[idiom: vu der shvartser fefer vakst = far away]
	[idiom: englisher fefer = allspice (spice)]
feik/K [def: able] u'mfe'ik/A feikayt/N [f] [def: ability]
	u'mfe'ikayt/N [f] [def: inability]
	arbet|sfeik/A [def: craftsmanlike]
fekhl/V/T [def: gleam; shine]
fel/V/T /Goys [def: lack; be dead (with "zikh")]
	/Bgefaln /Goys % variant participle
	farfel/V/Bfarfaln [def: be irrevocable, overlook]
		farfeler/S [def: absentee]
	felik/A [def: lacking]
		boy-felik/A [def: in need of repair] % Perets
	feler/N/S [m] [def: mistake, lack]
		drukfeler/N [m] [def: misprint, typo] 
fel [f] [def: skin; hide] /Dfelekh /Dfelkh [def: skin; hide]
	bernfel [f] [def: bearskin]
	tsignfel [f] [def: goatskin]
	shepsnfel [f] [def: sheepskin]
feld/Eer [n] [def: field]
	flifeld/Eer [n] [def: airport]
	kornfeld/Eer [n] [def: field of rye]
	luftfeld/Eer [n] [def: airport]
	nivetsfeld/Eer [n] [def: fallow field]
	shlakhtfeld/Eer [n] [def: battlefield]
	feld-glyander [m?] [def: coriander (herb)]
	fe'ldfebl/S/N [m] [def: staff seargeant (German)]
feldsher/S [m] fe'ldsherin/S [f] [def: barber-surgeon]
feldz/N [m] [def: cliff]
felyeto'n/N [def: broadside, feuilleton]
	felyetoni'st/N [m] felyetonistke/S [f] [def: columnist] 
femini'n/A [def: feminine] femini'zm/N [m] [def: feminism]
	femini'st/N [m] /Iish feministke/S [f] [def: feminist]
fenig/S [def: pfennig coin (German currency)]
fenomen/N [m] [def: phenomenon] /Ia'l
	bay'fenomen/N [m] [def: side effect] 
fentster/X/D [m/n] [def: window] /Idik
	[idiom: di hoykhe fentster = the upper echelon, the elite]
feodal/A [def: feudal] 
ferd/X/D [n] /Iish [def: horse (animal); vault, vaulting horse (gymnastics)]
	ferda'tsh/Ees [m] [def: horse (pejorative); fool]
	ka'rlikferd/X [n] [def: pony (animal)]
	fe'rdishkayt/N [f] [def: status of being a horse] % Sholem Aleykhem
	ferdl/Eekh [n] [def: hobby]
fershke/S [f] fe'rishke/S [f] farzhekh/Eer [m] [def: peach (fruit)]
fermenti'r/V/Bfermenti'rt [def: ferment]
	ferme'nt [m?] fermentirung/N [f] fermentatsye/S [f] [def: fermentation]
	ferme'nt/N [def: agent of fermentation]
fermyum [m] [def: fermium (Fm)] 
fertilizator [m] [def: fertilizer]
ferz/N [m] [def: line of a poem]
festik/V/T [def: tighten; affirm, assert; strengthen]
	/Ggrunt [def: establish; confirm; guarantee]
	/Gtsu [def: attach]
	fest/K [def: tight]
		festkayt/N [f] [def: strength, firmness; resolution]
		fas/V/T /Gayn [def: mount (jewelry)]
	bafestik/V/Bbafestikt [def: tighten, fortify]
		bafestikung/N [f] [def: fortification] 
	farfestik/V/Bfarfestikt [def: tighten]
		tson-farfestiker/S [m] [def: retainer (dentistry)] [note: V] 
		farfe'stikung/N [def: stronghold; reinforcement]
	farfas/V/Bfarfast [def: arrange]
	festung/N [f] [def: fort (military)] 
festival/N [def: festival]
fet/K [def: fat; off-color (jokes)] fetkayt/N [f]
	fets [m?] [def: fat] fetik/A [def: fatty]
	farfets/V/Bfarfetst [def: smear with grease]
feter/S [m] [def: uncle] /D
fey{fʼ}/H [m/f] [def: letter Feh]
fez [m?] feske/S [f] [def: fez (clothing)] % Stutchkoff
fi [n] [def: cattle] % no singular form
fiber/V/T [def: have a fever]
	fiber/N [m] [def: fever] /Idik /Iish [def: feverish]
	fiberhaftik/A [def: feverish; hectic]
fibre/S [f] [def: fiber (string; food component)] % Forwards: S-R Schaechter 
fidbek [m] [def: feedback (acoustic)] 
fidl/N [m/f] [def: violin] fidele/Xkh [def: little violin]
	fidl/V/T [def: play violin]
		/Gariber [def: raise (in card game)] % Sholem Aleykhem
		/Gunter [def: steal (thieves' argot)]
	fidler/S [m] fi'dlerin/S [f] [def: violinist; fiddler]
	fidleray'/N [def: fiddling (activity)] 
fifik/K [def: sly, artful, cunning, shrewd]
figur/N [f] [def: figure; (game) piece]
	figuri'r/V/Bfiguri'rt [def: have an appearance]
	figura'nt/N [m] [def: supernumerary (theater)]
	figurati'v/A [def: figurative (meaning); representational (art)]
	figurke/S [f] [def: small statue] % Forwards
fiksi'r/V/Bfiksi'rt [def: falsify] fiksirung/N [f] [def: falsification]
	farfiksi'r/V/Bfarfiksi'rt [def: depict, describe; set as a fixture]
fiktiv/A [def: imaginary]
	fiktsye/S [f] [def: fiction, imagination] 
fil/V/T [def: feel] /Goys/Giber/Gon/Gdurkh
	/Gmit [def: empathize; sympathize]
	derfi'l/V/Bderfilt [def: feel]
	filung/N [f] [def: feeling]
	gefi'l/N [n] [def: feeling] gefilful/A [def: heartfelt; sensitive]
		e'rngefi'l/N [n] [def: honorable sentiment] % Sholem Aleykhem
		fayngefi'l/N [n] [def: refined sentiment] 
		forgefi'l/N [n] [def: premonition] 
		kegngefi'l/N [n] [def: opposite feeling]
		mitgefi'l/N [n] [def: sympathy]
		ongefi'l/N [def: feeling]
		shpra'khgefi'l/N [def: language sense] % Stutchkoff
		shuldgefi'l/N [n] [def: guilty feeling]
		vidergefi'l/N [n] [def: repulsion] 
	eydlfilndik/A [def: of noble feeling]
	u'mfi'levdik/A [def: unfeeling, cold-blooded]
	mitfiler/S [m] mitfilerin/S [f] [def: sympathizer]
	[idiom: er filt mit mit emetsn = his heart goes out to someone]
filantropye/S [f] [def: philanthropy] filantropish/A [def: philanthropic]
	filantro'p/N [m] filantropin/S [f] [def: philanthrope]
	mizantro'p/N [m] [def: misanthrope]
file/Een [m?] [def: fillet (piece of fish)] % Forwards: S-R Schaechter
filigran [m?] [def: filigree]
film/N [m] filme/S [f] [def: film]
	filmogra'f/N [m] [def: filmmaker] 
	filmirke/S [f] [def: camcorder] [note: V]
	filmi'r/V/Bfilmi'rt [def: photograph, film] % Forwards: M-S Hoffman
	klangfilm/N [m] kla'ngenfilm/N [m] [def: talkie (film)] % Stutchkoff
	hoyptfilm/N [m] [def: mainstream film] % Forwards: S-R Schaechter
	mikrofilm/N [m] [def: microfilm] % Forwards: Genadi Estraykh
filologye [f] [def: philology] filolog/N /Iish [m] [def: philologist]
filosofye/S filozofye [f] [def: philosophy]
	filosof/N /Iish [m] filozof/N /Iish [def: philosopher]
	filosofke/S [f] filozofke/S [f] [def: philosopher]
	filosofi'r/V/Bfilosofi'rt filozofi'r/V/Bfilozofi'rt [def: philosophize]
	sofi'zm/N [m] [def: sophism; sophistry]
filotke/S [def: headband (clothing)] % Guess from "fillet"; M. Gildenman
filtri'r/V/Bfiltri'rt [def: filter] /Goys/Garoys
filts [n] [def: felt (material)] /In
filyal/N [m] [def: affiliate, branch (store or office)] 
filyer/S [m] filyerin/S [f] [def: fish seller]
fina'l/N [m?] fina'le/S [f] [def: final event]
finants/N [def: finance] finantsyel/A
	finantsi'r/V/Bfinantsi'rt finansi'r/V/Bfinansi'rt [def: finance]
	finantsirer/S [m] [def: financier] 
	finantsirung/N [f] finansirung/N [f] [def: financing] 
finf/N [d] finft/A [def: 5] finftns [adv] finftl [n] [def: 1/5]
	finef [d] [def: 5] % southern variant
	finfer/S /D [def: five-unit money (copper)]
	fuftsn [d] fuftsnt/A [def: 15] fuftsntl [n] [def: 1/15]
	fuftsik [d] /A fuftsikst/A [def: 50] fuftsikstl [n] [def: 1/50]
		fuftsiker/S [m] [def: 50-ruble note (money)
	finfuntsvantsiker{finf#untsvantsiker} [def: 25-ruble note (money)]
	finfthalbn [def: 4.5]
finger/X/D [m] [def: finger]
	fu'sfinger/X [m] [def: toe]
	mizi'nik-finger/X [m] [def: little finger] % Forwards: S-R Schaechter
	taytfinger/X/D [m] [def: forefinger]
	[idiom: shpits finger = fingertip]
	fingerl/Xfingerlekh [n] [def: ring] 
	[idiom: kedushen{kydwSyn} fingerl = wedding ring]
	[idiom: lekn fun/mit epes di finger = derive pleasure from something]
	[idiom: oyszoygn fun finger = invent, dream up]
	finger/V/T [def: touch, feel; drum fingers on]
fink [m?] [def: finch (bird)]
finkl/V/T [def: twinkle] /Goyf/Gop /Idik
fintster/K [def: dark] /Ilekh
	fintsternish/N [n] [def: darkness] fintsterkayt/N [f]
	shtokfintster/A [def: completely dark]
	fintster/V/T /Gop [def: waste (with "lebn" or "yugnt")]
	farfintster/V/Bfarfintstert [def: darken; embitter]
	fintsterling/N [m] [def: ignoramus; illiterate person]
fir/V/T [def: carry; act, behave (with "zikh")]
	/Gtsurik/Gon/Gadurkh/Garayn/Gariber/Garoys/Gayn/Garum/Gon
	/Gavek/Garum/Gavek/Goyf/Gayn/Gop/Gtsu/Garop/Gfunander/Gtsunoyf/Gaher
	/Garoyf
	/Giber [def: corrupt; spoil]
	/Gunter [def: lead, attend, escort]
	/Goys [def: be able]
	/Gdurkh [def: carry out; accomplish; route (computer)]
	farfi'r/V/Bfarfi'rt [def: seduce; mislead; swindle; strike up a conversation (with "a shmues")]
		farfi'rerish/A [def: seductive; misleading]
		farfirer/S [m] [def: seducer; swindler]
	tsefi'r/V/Btsefi'rt [def: lead astray] tsefirung/N [f]
	derfi'r/V/Bderfi'rt [def: bring about; accomplish; carry all the way]
		derfirung/N [f] [def: result; accomplishment]
	firer/S [m] fi'rerin/S [f] [def: leader, guide]
		ari'berfi'rer/S [m] [def: smuggler]
		re'dlfi'rer/S [m] [def: big shot] % Yankev Dinezon
		fi'rershaft/N [f] [def: leadership] firung/N [f]
			bu'khfirung/N [f] [def: bookkeeping] % Stutchkoff
		on'firershaft/N [f] [def: leadership] 
		lazer-gefi'rt/A [def: laser-guided] 
	firekhts/N [n] [def: habit, custom]
	araynfir/N [m] [def: introduction]
	aynfir/N [m] [def: custom, habit]
	durkhfir/N [m] [def: passage]
		durkhfirer/S [m] [def: router (computer)] [note: V] 
	onfir [m] onfirung/N [f] [def: leadership, direction]
		onfirer/S [m] [def: leader]
	oyffir/N [m] [def: action, behavior]
	gesheftfirung/N [m] [def: conduct of business] % Forwards: Khariton Berman
	oyffirung/N [f] [def: performance (in theatre)]
	oysfirung/N [f] oysfir [def: carrying out; conclusion]
		oysfirer/S [m] [def: executor (of a will)]
		oysfirkom/N [m] [def: executive committee (Soviet)]
		oy'sfirlekh/A [def: detailed, complete; feasible, doable]
	vaserfirer/S [m] [def: water carrier]
	unterfirer/S [m] [def: groomsman; slanderer] unterfi'rerin/S [f] [def: bridesmaid]
fir [d] fert/A fertns [adv] [def: fourth] fertstn [d] [def: 4] /Dfert [def: 1/4]
	fertsn [d] fertsnt/A fertset/A [def: 14] fertsntl [n] [def: 1/14]
	fertsik [d] /I fertsikst/A [def: 40] fertsikstl [d] [def: 1/40]
		fertsiker/S [m?] [def: 40-kopek coin (Russian currency)] % Sholem Aleykhem
	ferthalbn [def: 3.5]
firme/S [f] [def: company]
	hotsfirme/S [f] [def: lumber store]
firsht/N [m] [def: nobleman] firshtin/S [f] [def: noblewoman]
	firshtntum [n] [def: state, county, duchy] [usage: not recommended]
fish/X/D [m] [def: fish]
	-/Xfishn [noun] [def: varieties of fish; fish dishes]
	fishldik/A [def: fish-like]
	fisher/S [m] [def: fisher] fi'sherke/S [f] [def: wife of a fisher]
	gli'verfish/X [m] [def: jellyfish] [note: V] 
	hayfish/X [m] [def: shark (fish)]
	katsfish/X [m] [def: catfish (fish)] % Stutchkoff
	shelfish/X [m] [def: haddock (fish)] % Michael Wex
	shtokfish/X [m] [def: cod (fish)]
	tintfish/X [m] [def: squid (animal)]
	tunfish/X [m] [def: tuna (fish)]
	valfish/X [m] [def: whale (animal)] % Harduf
	vaysfish/X [m] [def: whitefish (fish)
	[idiom: khapn di lokshn far di fish / der yoykh = put the cart before the horse]
fishu' [m?] [def: fichu, kerchief]
fiter/V/T [def: feed (an animal)]
	futer [m] fiter [m?] gefiter [m?] [def: feed (for animals)]]
fitsh [adv] [def: soaking wet, wringing wet (with "nas") (German pitschnass)] 
fitske/V/T [def: thrash, whip] /Gon/Garayn
fizik [f] [def: physics (subject)] fizish/A fizikalish/A [def: physical]
	fiziker/X [m] [def: physicist] 
	astrofizik [f] [def: astrophysics] astrofizish/A [def: astrophysical]
	metafizik [f] [def: metaphysics (subject)] metafizish/A [def: metaphysical]
fizyonomye/S [f] [def: physiognomy, appearance]
flagme/S [f] flegme/S [f] [def: phlegm]
flaker/V/T [def: flicker (flame)] /Idik
	/Goyf [def: kindle] % Forwards: B. Sandler
	/Garoyf [def: enflame] 
	tseflaker/V/Btseflakert [def: flicker]
flakh/N [f] [def: plane, surface] /Iik flakh/A [def: flat; shallow]  
	hantflakh/N [f] [def: palm (of hand)] 
	ey'berflakh/N [f] [def: upper surface] /Iik
		ey'berfle'khikayt/N [f] [def: shallowness] % Forwards: Yoel Matveyev
	eyberflekhlekh/A [def: surface]
flako'n/N [m] [def: flask (container)]
flaks [m] [def: flax] /In
flam/V/T [def: flame] /Goyf/Gayn
	tseflam/V/Btseflamt [def: burst into flame]
	farflam/V/Bfarflamt [def: flame]
		farflamtkayt/N [f] [def: flame] 
	flam/N [m] [def: flame] /Iik [def: flaming] /Dflem 
	gefla'm/N [def: flame]
	fayerflam/N [def: flame]
	likhtflam/N [def: candle flame]
	/Dtsindflem [def: pilot light] 
	fleml/V/T [def: flicker]
flanel [m?] [def: flannel (material)]
flank/N [m] [def: flank (body part); flank steak (in plural)] 
flants/V/T [def: plant] /Gayn
	/Giber [def: transplant] 
	flantsung/N [f] [def: planting]
		iberflantsung/N [f] [def: transplant]
	farflants/V/Bfarflantst [def: plant]
	brust-aynflants/N [m] [def: breast implant] [note: V] 
flash/N/Xflesher /Dflesh [n] [def: bottle]
	fleshlekhvayz [def: by the bottle]
	fleshldik/A [def: bottle-like] % Sholem Aleykhem
	birflash/Xbirflesher [def: beer bottle] % Avrom Karpinovitsh
	varemflash/Xvaremflesher [def: hot-water bottle] % Itsik Manger
	fleshl/V/T [def: bottle] /Gayn
	[idiom: kleyne fleshelekh = medicine bottles]
flaster/V/T [def: plaster]
	/Goys [def: cement together]
	/Dflester [def: bandage]
flater/V/T [def: flutter] /Garoyf/Garum /Idik
	tseflater/V/Btseflatert [def: flutter about]
	geflater/N [n] flaternish/N [n] [def: fluttering]
		fla'terl/Eekh [n] [def: butterfly]
flays/V/T [def: be diligent, try hard (with "zikh" +infinitive)]
	flays [m] [def: industry, diligence] /Iik [def: industrious]
	[idiom: mit flays = on purpose]
fleg/V/T [def: used to]
fleger/S [m] fle'gerin/S [f] [def: personal attendant] 
flegmatik/A [def: phlegmatic, unemotional]
flek/N/D [m] [def: disfigurement; spot; stain]
	flek/V/T [def: disfigure]
		baflek/V/Bbaflekt [def: disfigure]
		farflek/V/Bfarflekt [def: disfigure; spatter]
	geburtsflek/N [m] [def: birthmark] % Forwards: Boris Sandler
	shandflek/N [m] [def: blemish, stain, defect]
	shaynflek/N [m] [def: sparkle] % Forwards: Boris Sandler
flekht/V/Bgeflokhtn [def: braid]
	/Garayn/Gayn/Gtsunoyf/Giber/Garum/Gdurkh/Gtsu/Goys
	/Gop [def: unbraid]
	flekht/N [m] [def: braid]
	tseflekhtn/V/Btseflokhtn [def: braid; spend money; make crazy]
	farflekht/V/Bfarflokhtn [def: braid]
flem/N [m?] flam/Xflem [m?] [def: powerful slap]
flentsye/S [f] influentse/S [f] influentsye/S [f] [def: influenza (disease)] 
fleysh/N [n] [def: meat]
	/Iik [def: meaty, meat-based (food, ritual)]
	/Iedik [def: meat-based (food, ritual)] 
	[idiom: makhn fleyshik = have a drink; start a business] % Michael Wex
	dikfleysh [n] [def: buttocks] [usage: polite]
	hakfleysh [n] [def: chopped meat] 
	hinerfleysh [n] [def: chicken (food)]
	kreplfleysh [n] [def: chopped meat for kreplekh]
		[idiom: makhn kreplfleysh fun emetsn = destroy someone]
	mentshnfleysh [n] [def: human flesh]
	oksnfleysh [n] [def: beef (food)] % Sholem Aleykhem: Menakhem Mendl
	rindfleysh [n] [def: beef (food)]
	roslfleysh [n] [def: pot roast, sourbraten (cooked food)] /D
	shandfleysh [n] [def: female genitalia] 
	shepsnfleysh [n] [def: lamb (food)]
	vildfleysh [n] [def: raw meat] 
	zitsfleysh [n] [def: patience, perserverence] [usage: humorous] 
	tsefleysht/A [def: withered] 
fleyt/N [f] [def: flute]
	fleytist/N [m] [def: flautist]
fleyts/V/T [def: flood] /Giber
	farfleyts/V/Bfarfleytst [def: flood]
		farfleytsung/N [f] [def: flood]
	i'berfleyts/N [m] [def: flood; surfeit, overabundance]
	shtu'remfleyts/N [m] [def: storm surge (meterological)]
fli/V/Bgefloygn [def: fly]
	/Gadurkh/Garayn/Garoys/Gunter/Gdurkh/Garoyf/Gmit/Gon/Gavek/Garum/Garop
	/Gtsunoyf/Gtsu/Gop/Gnokh/Giber/Gfarbay
	fli/N [m] [def: flight (airline)]
	tsefli/V/Btsefloygn [def: fly apart]
	farfli/V/Bfarfloygn [def: fly away]
	fligl/N/Dflig [m] [def: wing] gefliglt/A bafliglt/A
	flier/S [m] [def: flyer, pilot] shternflier/S [m] [def: spaceship]
	fliik/A [def: flying] durkhfliik/A [def: flying past]
	opfli/N [m] [def: departure (by air)]
	flug/N [m?] [def: quick glance]
		oysflug/N [m] [def: excursion]
	flug- [prefix] [def: air-]
	[idiom: nit geshtoygn, nit gefloygn = nonsense]
	[idiom: in flug = off hand, at first glance]
flig/N [f] [def: fly]
	titus-flig/N [f] [def: gnat that burrowed into Emperor Titus' brain] 
	[idiom: hobn moyre{mwr#} far a flig = be afraid of one's shadow]
flik/V/T [def: pluck] /Goys/Gon
	/Gop [def: pick fruit; pluck]
	flik/N [m]
	fliker/S [m] [def: plucker] 
	tseflik/V/Btseflikt [def: wear out (clothing)]
flikht/N [f] farflikhtung/N [f] [def: duty, obligation]
	farflikhtet/A [def: obligated]
flink/K [def: quick]
	flinkayt/N [f] [def: velocity]
fli'rteve/V/T flirt/V/T [def: flirt] 
	flirt/N [m] [def: flirtation] 
flis/V/Bgeflosn [def: flow] /Gop/Gfundander
	flisik/A [def: fluent] flisikayt/N [f] [def: fluency]
	opflus/N [m] [def: overflow] tsuflus/N [m] [def: inflow]
		moykhes{mwHwT}-opflus/N [m] [def: brain drain] [note: V] 
	lavaflus/N [m] [def: lava flow]
	tseflis/V/Btseflosn [def: flow apart]
		tseflosn/A [def: unkempt; spread out]
	fleys [m] [def: skill]
flister/V/T [def: whisper]
fliter/V/T [def: sparkle, coruscate]
	bafliter/V/Bbaflitert [def: glisten, embellish with sparkles]
	/Dfliter [def: tinsel; spangle]
flok/N [m] [def: flake] 
flokht/N [m] [def: fool]
flokn/S/Xfleker/Xflekener [m] /Dflek [def: pole, club]
	[idiom: shteln di fir flekener = set up the khupe = get married] % Chaim Grade
flo'nderke/S [f] [def: flounder (fish)]
flot/N [m] [def: navy] 
floy/Xfley [m] [def: flea] 
	[idiom: hobn fley in der noz = have a bee in one's bonnet; be prideful]
floym/N [f] [def: plum (fruit)]
	[idiom: getriknte floymen = prunes]
flukh/V/G [def: curse] [usage: not recommended]
	farflukh/V/Bfarflukht [def: curse] [usage: not recommended]
fluor [m] [def: fluorine (F)] 
flyaske/V/T [def: slap; daub; whitewash]
	farflyaske/V/Bfarflyasket [def: slap] % Sholem Aleykhem
	flyask/N [m] [def: slap]
fodem/Xfedem [m] [def: string, thread] /Dfedem
	fi'rfodem/Xfi'rfedem [m] [def: clue; trail]
	fedem/V/T [def: thread (a needle)] /Gayn/Garayn/Gdurkh
	[idiom: kadokhes{kdHT} mit koshere{KSre} fodem = serious illness (curse)]
foder/V/T [def: demand] /Goyf/Garoys
	foderung/N [f]
fodersht/A federsht/A [def: front] [grammar: attribute only]
	fodersht/A federsht/A [def: front-wheel (automotive)] [note: V]
	fe'dershter/S [m] [def: forward (position in sports)] [note: V]
foke [f] [def: harbor seal (animal)] 
fokhe/V/T [def: wave] /Garoyf
	tsefokhe/V/Btsefokhet [def: wave about]
	fokher/S [m] fekher/S [m] [def: fan (appliance)] 
	fokh/N [m] [def: wave]
	[idiom: fokhen mit der neshome{nSmh} = be on one's deathbed]
fokus [m] [def: focus]
	fokusi'r/V/Bfokusi'rt [def: focus] % Forwards
	oy'serfo'kusdik/A [def: out-of-focus] [note: V]
	fokusnik/Ees [m] [def: juggler] [usage: rare]
	hoy'ptfokus [m] [def: principal focus] % Forwards
folate [def: folate (food chemical)] 
folg/V/T
	/Gnokh [def: follow] 
	/Goys [def: obey, carry out] % Forwards: Yankev Goldshteyn
	folg/V/Bgefolgn [def: obey] % variant participle
	folgevdik/A [def: obedient]
	nokhfolger/S [m] [def: successor, sycophant]
	farfolg/V/Bfarfolgt [def: persecute, torment] 
		farfolger/X [m] [def: persecutor, tormentor]
		farfolgung/N [f] [def: pursuit, persecution, prosecution]
folk/Xfelker /Iish [n] [def: nation]
	folkishkayt/N [f] [def: nationhood] % Forwards: Shikl Fishman
	folklor [def: folklore] /Iish
		folklori'st/N [m] /Iish folkloristke/S [f] [def: folklorist] 
	bafelker/V/Bbafelkert [def: inhabit] bafelkerung/N [f] [def: population]
	felkerlekh/A folkstimlekh/K [def: national, popular, folksy]
		folkstimlekhkayt/N [f] [def: folksy nature] % Rokhl Boymvol
	porfolk/Xporfelker [n] [def: married pair] /D
	herenfolk [n] [def: master race (in Nazi terminology)]
	shklafnfolk/Xshklafnfelker [n] [def: nation of slaves]
	veltfolk/Xveltfelker [n] [def: world-wide nation] 
	folks- [prefix] [def: folk]
	fe'lkershaft/N [f] [def: nationality] % Sholem Asch: Ist River
	folkomfin [m] [def: folk commissariat for finance (Soviet)] % Kulbak: Zelmenyaner
folvark [m?] [def: farm]
folya'nt/N [m] [def: folio, volume]
fon/N/Xfener [f] fone/S [def: flag] /Dfend
	[idiom: gildene fon = aristocracy]
fona'r/N [m?] [def: headlight (auto)] % Yiddish League
fond/N [m] [def: fund]
fonem/N [m?] [def: phoneme (linguistics)] /Iish
	fonemik [f] [def: phonemics (linguistics)]
fonetik [def: phonetics] fonetish/A fonetizi'r/V/Bfonetizi'rt
	mikrofo'n/N [m] [def: microphone]
	polifonish/A [def: polyphonic]
fonfe/V/T [def: mumble; speak nasally] /Gunter
	fonfate/A [def: mumbling; nasal speech] 
	fonfevate/A [def: mumbling; nasal speech] % Sholem Aleykhem: Khanuke Gelt
	fonfa'tsh/Ees [m] [def: person with a nasal voice]
fonograf/N [m?] [def: phonograph]
fonologye/S [f] [def: phonology]
	fonologish/A [def: phonological]
	fonote'k/N [f] [def: library of recordings]  % Forwards
fontan/N [m] [def: fountain]
for/V/Bgeforn [def: travel (by vehicle)]
	/Gtsurik/Gtsuzamen/Gavek/Gadurkh/Gaher/Garayn/Garoys/Gdurkh/Gfarbay
	/Gfunander/Gnokh/Gon/Gop/Goys/Gtsu/Gum/Giber/Garop/Garoyf/Gahin/Gmit
	/Gaheym/Gtsunoyf
	/Gariber [def: transfer (money); move (with "zikh")]
	/Garum [def: tour (with "iber")]
	/Gunter [def: hitchhike] % Weinreich
	farfor/V/Bfarforn [def: travel too far; fetch, pick up; travel as far as (with "biz")]
	tsefor/V/Btseforn [def: travel about; be disorganized; disintegrate]
	araynfor [m] [def: entrance, driveway] aynfor [m]
		aynfor- [prefix] [def: drive-in] 
	aropfor [m] [def: descent (action or place)]
	aroysfor [m] [def: exit]
	avekfor [m] [def: departure]
	durkhfor [m] [def: transit] % Forwards: M-S Hoffman
	i'berfor [m] [def: overpass]
	no'khforer [m] [def: trailer (vehicle)]
	tsufor [m] [def: approach] 
	tsuzamenfor [m] [def: convention]
	onfor/N [m] [def: start of traveling]
	opfor/N [m] [def: departure]
	foreray'/N [def: traveling]
	forer/S [m] [def: traveler] mitforer/S [m] [def: traveling companion]
		aru'mforer/S [m] arumforerin/S [f] [def: commercial traveler] % Bergelson
		durkhforer/S [m] [def: traveler] % Der Nister
	[idiom: lozn durkhforn tsu ersht = yield the right of way]
	[idiom: khapn a for = hitchhike] [note: V]
forel/N [m] [def: trout (fish)] % Stutchkoff
forem/Xformen [f] forme/S [f] [def: form, shape; mold, cast]
	furem/V/T [def: form, shape, fashion] /Gayn/Goys/Giber
		furem/S [m] [def: mold, cast; pattern]
		furemung/N [f] aynfuremung/N [f] [def: formation; shaping]
	formi'r/V/Bformi'rt [def: form] /Goys
		formirung/N [f] [def: formation]
	forma't/N [m] [def: format]
		transformi'r/V/Btransformi'rt [def: transform]
			transformatsye/S [f] [def: transformation] 
			transformirung/N [f] [def: transformation]
	bukhforem/Xbukhformen [f] [def: bookform]
forkht/V/Bforkht [def: fear (with "zikh")]
	forkht [f] [def: fear, dread] /Iik/Ilekh/Izikhtik
		forkht/V/T [def: fear, dread (with "zikh")]
	furkht [f] [def: fear, dread] [usage: not recommended]
		furkht/V/T firkht/V/T [def: fear (with "zikh")] [usage: not recommended]
	got|sforkhtik/A [def: God-fearing, pious] 
		got|sforkhtikayt/N [f] [def: piety] 
formel/A [def: formal]
	formalite't/N [f] [def: formality] 
formuli'r/V/Bformuli'rt [def: formulate] formulistish/A
	formulirung/N [f] [def: formulation] % Forwards
	formula'r/N [m] [def: form; official form]
	formule/S [f] [def: formula]
fornt [adv] [def: in front] /Iik
foroys [adv] [def: in advance] /Iik
forsh/V/T [def: research] /Goys
	/Gnokh [def: search]
	forsher/S [m] /Iish fo'rsherin/S fo'rsherke/S [f] [def: researcher]
		shpra'khfo'rsher/S [m] [def: linguist, philolog] % Stutchkoff
	forshung/N [f] oysforshung/N [f] oysforsh/N [def: research]
	oysforsher/S [m] oysfo'rsherin/S [f] [def: researcher]
forshke/V/T [def: snort]
fort [adv] [def: after all, still] 
fortifikatsye/S [f] [def: fortification] 
fortke/S [f] [def: portal, doorway]
fortl [m?] [def: trick, method, manouver]
forto [adv] [def: loud, forte (music)] % Stutchkoff
	forti'simo [adv] [def: fortissimo (music)] % Stutchkoff
forum/S [m] [def: forum] 
forverts{forvert|s} [def: Forwards newspaper]
fosfor [m] [def: phosphorus] 
	fosfori'r/V/Bforsfori'rt [def: phosphoresce]
fosi'l/N [m] [def: fossil] 
fote'l/N [def: footstool (furniture)]
foter/S [m] [def: father (German)] /Ilekh
	foterl/Eekh [def: Father (priest)]
	shtamfoter/S [m] [def: ancestor]
	shtiffoter/S [m] [def: stepfather]
	toy'ffoter/S [m] [def: Godfather (Christian)
fotogra'f/N [m] fotografin/S [f] [def: photographer]
	foto/S [f] fotografye/S [f] [def: photograph]
	fotografish/A [def: photographical] 
	fotografi'st/N [m] fotografistke/S [f] [def: photographer] % Harduf
	fotografi'r/V/Bfotografi'rt [def: photograph] /Gop
fo|ye'/N [m] [def: foyer, lobby] 
foygl/N/Xfeygl [m] [def: bird] % both plurals exist
	foyglsh/A [def: birdlike]
	/Dfeyg [def: little bird; male homosexual (America, pejorative)] 
		zumer-feygele/Ekh [n] [def: butterfly] 
	feyglsh/A foyglish/A [def: bird-like] 
	foygldik/A [def: pleasant, fine]
	bloyfoygl/Xbloyfeygl [def: bluebird]
	nakhtfoygl/Xnakhtfeygl [def: owl; nocturnal bird; purse-snatcher]
	shpilfoygl/Xshpilfeygl [def: songbird] /Dshpilfeyg
foyl/V/T [def: spoil; be lazy (with "zikh")] /Gdurkh/Goys/Gtsu/Gunter
	farfoyl/V/Bfarfoylt [def: spoil]
	tsefoyl/V/Btsefoylt [def: spoil]
	foyl/A [def: lazy; rotten, spoiled]
		foylkayt/N [f] foylenish/N [n] [def: laziness] 
		foylya'k/Ees [m] foyler/S [m] [def: sloth (animal)] 
		[idiom: voyler yung = good-for-nothing] [note: apparently from "foyl", although "voyl"]
	foylekht|s/N [n] [def: rotten material]
	voylerish/A [def: mischievous]
foyst/N/D [def: fist]
fragme'nt/N [m] [def: fragment] /Iarish [def: fragmentary] 
	fragment'ir/V/Bfragmenti'rt [def: fragment] % Forwards
frak/N [m] [def: dress coat, tails (clothing)] 
frakht [m] [def: freight, cargo]
fraktsye/S [def: faction] 
fraktu'r [m?] [def: Gothic alphabetic font]
frandz/N/Xfrendz /Dfrendz [def: fringe]
	bafrandz/V/Bbafrandzt [def: fringe]
frank/A [def: simple]
frant/N [m] [def: fashionable gentleman; dandy, fop] /Iish
	fra'ntikhe/S [f] fra'ntsimerke/S [f] [def: voguish woman] % Stutchkoff
frantsyum [m] [def: francium (Fr)] 
-/Xfrantsn [def: syphilis (disease)]
	frantsevate/A [def: syphilitic; foul]
frask/N [m] [def: powerful smack, blow] 
	fraske/V/T [def: smack, slap]
fraternal/A [def: fraternal]
fray/A [def: free]
	bafray/V/Bbafray|t [def: liberate; make available (with "zikh")]
		bafrayung/N [f] [def: liberation] 
	frayhayt/N/S [f] fraykayt [f] [def: freedom] 
	bafrayer/S [m] [def: liberator]
	bafrayung/N [f] bafrayungs [def: liberation]
	frayshaft/N [f] [def: freedom]
		[idiom: poetishe frayshaft = poetic license] [note: V]
	[idiom: fraye tsayt = spare time]
fraynd/X [m] [def: friend]
	frayndlekh/K [def: friendly] 
		frayndlekhkayt/N [f] [def: friendliness]
	bafraynd/V/Bbafrayndt [def: befriend (usually with "zikh mit")]
	u'mfray'ndlekh/A [def: unfriendly] 
	frayndin/S [f] frayndine/S [f] [def: girlfriend]
	frayndshaft/N [f] gutfrayndshaft/N [f] [def: friendship]
		[idiom: shlisn frayndshaft = make friends]
	bafrayndet/A [def: befriend]
	buzemfraynd/X [m] [def: close friend, bosom buddy]
	hartsfraynd [m] [def: close friend]
	yugntfraynd [m] [def: friend of one's youth]
	ga'stfrayndlekh/A [def: hospitable] um'ga'stfrayndlekh/A [def: inhospitable] 
		gastfrayndlekhkayt/N [f] [def: hospitality] 
fraynt/X [m] [def: relative] /Ilekh [def: friendly] /Dfraynd
fraytik/N [m] [def: Friday]
fraze/S/Xfrazn [f] [def: phrase]
	frazeologye/S [f] [def: phraseology] frazeologish/A [def: phraseological] 
	frazirung/N [f] [def: phrasing] 
freg/V/T [def: ask] /Gnokh/Gon/Goys/Giber
	/Gop [def: contradict; disprove]
	onfreg/N [m] [def: question]
	derfreg/V/Bderfregt [def: discover by asking]
	tsefreg/V/Btsefregt [def: ask around (with "zikh")] % Sholem Aleykhem
	o'pfreglekh/A [def: questionable] u'mo'pfreglekh/A [def: unquestionable]
	freger/S [m] fre'gerke/S [f] [def: questioner; inquisitive person] 
		fre'gerish/A [def: inquisitive] 
	fregnisht/N [m] fregnishtse/S [f] [def: adult child's live-in lover] % Michael Wex
	frage/S/D [f] [def: question] freg/N/D [f]
		shtray'tfrage/S [f] [def: dispute]
		[idiom: a freg ton = ask]
	onfreg/N [m] oysfreg/N [m] [def: questionnaire, survey, poll]
		oysfregenish/N [n] [def: interrogation]
		onfrage/S [f] [def: questionnaire, survey] [usage: inadmissible]
	nokhfreg/N [m] [def: demand] % Harduf
frekh/K [def: fresh]
fremd/A [def: foreign, strange]
	fremdkayt/N [f] [def: foreignness]
	fremd/V/T /Gop [def: alienate; isolate]
		opgefremdkayt/N [f] [def: isolation] % Forwards: Boris Sandler
		opfremdung/N [f] [def: alienation; isolation] % Berish Goldstein
	farfremdt/A [def: foreign]
		farfremdtkayt/N [f] [def: foreignness; separation]
frenk/N [m] [def: inhabitant of Western Europe]
fres/V/Bgefresn [def: gulp down, eat (like an animal)] /Goyf/Gon
	/Giber [def: over-eat]
	freseray'/N [n] [def: gluttony]
	tsefres/V/Btsefresn [def: gulp down]
	freser/S [m] fre'serin/S [f] [def: fast eater]
		blutfreser/X [def: blood-sucker]
		freserish/A [def: gluttonous; ravenous]
		mentshnfreser/X/S [def: cannibal] % Sholem Aleykhem
		meser-freser/S [m] [def: sword swallower] [note: V]
	drekfreser/S [m] [def: someone who enjoys poor food (vulgar)] 
frey/V/T [def: rejoice (with "zikh")] 
	derfrey/V/Bderfreyt [def: gladden; be delighted (with "zikh")]
	freyd/N [f] [def: joy]
		le'bnsfreyd/N [f] [def: joie de vivre] /Iik [def: vivacious; convivial]
			le'bnsfrey'dikayt/N [f] [def: vivacity]
		shodnfreyd/N [f] beyze freyd/N [f] [def: schadenfreude]
		freydloz/A [def: joyless] [usage: inadmissible]
	fridn [def: peace] /Idik
	fridlekh/A [def: happy]
	freydik/V/T [def: make happy] freydik/A [def: happy]
	freylekh/K [def: happy]
		freylekhs/N [m?] [def: merry dance tune]
		freylekhkayt/N [f] [def: happiness]
		fray/A [def: happy] % unusual variant of freylekh
	tsufridn/A [def: satisfied, glad, pleased, content] /Idik
		tsufridnkayt/N [f] [def: satisfaction, gladness, contentment]
		u'mtsufri'dn/A [def: dissatisfied]
			u'mtsufri'dnkayt/N [f] [def: dissatisfaction, discontent]
		tsufridnshtelik/A [def: satisfactory]
			u'mtsufri'dnshte'lik/A [def: unsatisfactory]
		zelbsttsufridn/A [def: self-satisfied] % Esther Kraytman: Briliantn
		[idiom: tsufridn shteln = satisfy]
	bafridik/V/Bbafridikt [def: satisfy]
		bafridikung/N [f] [def: satisfaction] 
		u'mbafri'dikt/A [def: dissatisfied]
		bafri'dikndik/K [def: satisfactory]
fri/K /Iik/Ierik/Ierdik [def: early] tsufrier afrier friert
	farfrier [adv] [def: in front] % Der Nister
	inderfri [m] [def: morning] /Idik
	tsufriik/A [def: premature; untimely] 
	frieroys [adv] [def: in front] % Y. Y. Singer
	[idiom: oyf tsufrier = in front]
frid [m] [def: peace]
fridzhide'r/S [m] refri'dzherator/S [m] [def: refrigerator]
frikati'v/A [def: fricative, spirant (linguistics)] % D-H Katz
friling [m] [def: Spring (season)]
frir/V/Bgefroyrn [def: freeze] /Gop/Giber/Gon
	farfri'r/V/Bfarfroyrn [def: freeze]
		farfrirung/N [f] [def: freezing]
	frost/Xfrest [m] [def: frost] /Dfrest [def: shiver] /Iik [def: frosty]
		frostikayt/N [f] [def: frostiness] 
		fre'stldik/A [def: chilly]
		frestl/V/T [def: chill]
	frirke/S [n] [def: freezer (appliance)] 
	[idiom: der frost brent = it's very cold]
frish/K [def: fresh] /Iink frishkayt/N [f] [def: freshness]
	frish/V/T [def: freshen] /Gop/Goyf/Gtsu/Gunter
	derfrish/V/Bderfrisht [def: restore; refresh]
		derfrishung/N [f] [def: refreshment] 
frishtik [n] [def: breakfast]
	frishtik/V/T [def: eat breakfast] % Forwards
frizi'r/V/Bfrizi'rt [def: style (hair)]
	frizirer/S [def: barber, hair stylist]
	frizu'r/N [f] [def: hair style, coiffure] frizurke/S [f]
front/N [m] fornt/N [def: front] /Iik
	[idiom: haltn fun fornt = be at the start]
	fronton/N [m?] [def: facade of a building (architectural)]
frosh/Xfresh /Dfresh [f/m] [def: frog]
froti'r/V/Bfroti'rt [def: polish, scuff, rub down]
froy/N froyke/S [f] [def: woman; wife]
	froyish/A [def: womanly; wifely] froyishkayt/N [f] [def: womanliness; wifeliness] 
	fraylin/S [f] [def: unmarried woman] 
		krants-fraylin/S [f] krantsl-fraylin/S [def: bridesmaid]
	ga'snfroy/N [f] [def: prostitute] 
frukht/N [f] [def: fruit]
	frukhper/V/T [def: be fruitful]
		bafrukhper/V/Bbafrukhpert [def: fertilize]
		frukhper [m] [def: fertilizer]
	frukhtsheyk/N [m] [def: fruit shake, smoothie] [note: V] 
	beyndlfrukht/N [m] [def: stonefruit (botany)] % Forwards: Hershl Glaser
	greypfrukht/N [m] greypfrut/N [m] [def: grapefruit] 
	frukhtbar/A [def: fruitful] [usage: not recommended]
		frukhtbarkayt/N [f] [def: fruitfulness, fecundity] [usage: not recommended]
frum/Kfrim [def: pious]
	frumkayt/N [f] [def: piety]
	frumak/Ees [def: over-pious person] /Iish [def: sanctimonious] 
	farfrimt/K [def: pious]
fuks/N/D [m] [def: fox] fu'ksikhe/S [def: vixen] /Dfiks fiksn/A
	fuksl [m?] [def: fuschsia (plant)]
ful/A [def: full] fulkayt/N [f] [def: fullness]
	fulkum/A [def: full; entire] fu'lkumkayt/N [f] [def: fullness, completion]
		farfulkum/V/Bfarfulkumt [def: complete]
	iberfu'l/A ibergefu'lt/A [def: overfull]
	fil/V/T [def: fill; stuff] /Gon/Giber
		filekhts/N [n] gefilekhts/N [n] [def: filling]
		farfil/V/Bfarfilt [def: fill]
	fil [def: many (German)]
	tsufil [def: too many] vifl [def: how many]
		viflt/A [def: which (in order)] viflst/A
	prestizhful/A [def: prestigious] 
	farfu'l/V/Bfarfu'lt [def: complete, fill up]
fulya'r [m?] [def: foulard (fabric)] % Sholem Aleykhem
fun/P [def: from; of]
fundame'nt/N [m] [def: base, fundament] /Ia'l [def: fundamental] 
	fundamentali'st/N [m] [def: fundamentalist (religious)] /Iish
fu'ndeve/V/T [def: found, establish] /Gayn
	ayngefu'ndevetkayt/N [f] [def: foundation]
	farfu'ndeve/V/Bfarfundevet [def: found] /Gayn [def: instill]
	fundatsye/S [f] [def: foundation]
	derfind/V/Bderfundn [def: invent] [usage: inadmissible]
		derfindung/N [f] [def: invention] 
		derfinder/S [def: inventor]
			derfi'nderish/A [def: inventive]
fungus/N [def: fungus]
funk/N [m] [def: spark] /Dfink
funktsye/S [f] [def: function] 
	funktsyoni'r/V/Bfunktsyoni'rt [def: function]
	funktsyonel/A [def: functional] 
	funktsyona'r/N [m] [def: functionary] 
funt/N [m] [def: pound (measure of weight) (Russian фунт)] /D % Russian measure: about 0.9 pounds
	hipshfuntik/A [def: heavy] % Der Nister
	tsenfuntnik/Ees [m] [def: 10-funt weights] % Der Nister
fur/N/D [f] [def: wagon]
	furgon [m?] [def: wagon (Polish furgon)]
furazhke/S [f] [def: cap (men's clothing)]
fus/Xfis /Iik /Dfis [m] [def: leg, foot (body part)]
	fiskele/Ekh [n] [def: tiny foot]
	fus/X /Iik [m] [def: foot (measure of length)]
	drayfisik/A [def: tripodal] eynfusik/A [def: with one foot]
	kurtsfisik/A [def: short-footed] % Der Nister
	shverfisik/A [def: heavey; crude; unemotional]
	fisnoge/S [def: jellied calve's foot (food; Lithuanian Yiddish)]
	/Dgendznfis [def: quotation mark]
	akhtfus/N [m] [def: octopus (marine animal)]
	drayfus/N [m] [def: three-legged cooking pot]
	fusnoge [f] [def: jellied calves' feet (food)]
	gray'shlfus [m] kray'zlfus [m] [def: jellied sheep's feet (food)]
	shtekhnfus/Xshteknfis [m] [def: stick-like feet] % Chava Rozenfarb: Botshani
	tsufus [adv] [def: on foot]
		tsufusns [adv] [def: at someone's feet (with "bay")]
	/Dhi'nterfis [def: trick]
	[idiom: vu nor er shtelt a fus = whereever he goes]
	[idiom: mitn rekhtn fus (foroys) = good luck!]
	[idiom: hobn kadme_veazle{kdm#-w|azlo} fis = bow-legged]
	[idiom: hobn fis vi a merkhe_tipkhe{mrx#-typH#} = knock-kneed]
	[idiom: hobn aroysgedreyte fis = penguin-toed] [note: V]
	[idiom: hobn arayngedreyte fis = pigeon-toed] [note: V]
	[idiom: aroysshteln a kosher{KSr} khazer{Hzyr}-fisl = show only the good parts]
	[idiom: shteyn oyf hinershe fis = have an shaky foundation]
	[idiom: tsurikshteln oyf di fis = return to stable operating condition]
futbol [m] [def: (American) football] futboli'st/N [m] [def: football player]
futer/S [m] [def: fur (material); fur coat (clothing)] /In
	futerl/Xekh [n] [def: (fur-lined?) (violin) case] % M. Gildenman
	futrirt/A [def: fur-covered] % Opatoshu
futlya'r [m] [def: violin case]
	fidl-futlya'r [m] [def: violin case]
futrine/S [f] fitrine/S [f] [def: frame (window or door)]
futsh [interj] [def: spoiled!, finished!, ruined!]
	farfutsh/V/Bfarfutsht [def: ruin, botch] % Forwards: M-S Hoffman
futuri'st/N [m] futuristke/S [f] [def: futurist (artistic movement)] 
	futuristish/A [def: futuristic] % Forwards
fyaker/S [m?] [def: horse-drawn carriage]
fyalke/S [f] fyolke/S [f] [def: violet (flower)]
fyole't/A vyole't/A [def: violet (color)] 
gabe_{gb#y}/Xgaboyem{gbo|ym} [m] [def: charity overseer (Jewish religious functionary)] 
	gabete{gb#yte}/S [f] [def: wife of a charity overseer]
gabe{gby}/H [def: with regard to] legabe{lgby}/H [def: with regard to]
gabrele/S [f] [def: dressing gown]
gadolinyum [m] [def: gadolinium (Gd)] 
gadyo{gdy#}/H [def: kid (Aramaic)]
	khad_gadyo{Hd-gdy#} [def: jail] [usage: slang] % pun with Polish slang "koze"
gaf/V/T [def: stare]
	fargaf/V/Bfargaft [def: stare]
	fargaftkayt/N [f] [def: state of staring] % Shpiglblat
gal/N [f] [def: gall, bile; gall bladder]
	fargal/V/Bfargalt [def: gall]
	fargaltkayt/N [f] [def: state of being galled]
	galik/A [def: ill-humored] % % Rokhl Boymvol
	[idiom: oysshpayen di gal = be ill (often metaphoric)]
	[idiom: lakhn mit griner gal = laugh bitterly]
	[idiom: shlogn tsu der gal = nauseate]
	[idiom: on a gal = without malice]
gala/S [f] [def: gala, party]
galaga'n [m] [def: rooster (animal) (particular large variety)] /Isk
galaksye/S [f] [def: galaxy]
	 galaktik/N [f] [def: galaxy] [note: V] 
	 galaktish/A
gala'nt/A [def: gallant, knightly; courteous]
	galantkayt/N [f] [def: courtesy, politeness]
	galanterye/S [f] [def: haberdashery; men's clothing store]
	galant/N [m] galanto'n [m] [def: dandy, fop] % Stutchkoff
galekh{glH}/Xgalokhem{glHym}/H/D/N [m] [def: Christian priest (pejorative)] /Ish
	vide_galekh{vydwy-glH} [def: confessor] 
	goluekh{glwH}/Xglukhem{glwHym}/H [m] [def: clean-shaven Jew]
	galkhes{glHwT} [n] [def: non-Jewish (Latin) alphabet] 
galerye/S [f] [def: gallery] galerey'/N 
	galyorke/S [f] [def: gallery] [usage: not recommended]
galife' [noun] [def: riding breeches (clothing)] 
galke/S [f] halke/S [f] [def: knob (decoration); ballot; small glass]
galon/N [m] [def: gallon] % Harduf
galop/N [m] [def: gallop]
	galopi'r/V/Bgalopi'rt /Gavek
galyer [m] galyerte/S [f] [def: jellied calves' feet (food)] 
galyum [m] [def: gallium (Ga)] 
gam{gm}/H [def: also]
game/S [f] [def: scale, range]
	[idiom: dekn di game = cover the whole range, run the gamut] [note: V]
gamor{gmwr}/H [def: entire] legamrey{lgmry} [def: entirely]
gan{gn}/H [m] [def: garden]
gandz/Xgendz [f] [def: goose] /Dgendz gendzn/A
	gendzler/S [m] ge'ndzlerin/S [f] [def: goose merchant]
	gendzlyarnye/S [m] [def: goose-raising place] % Avrom Karpinovitsh, Chaim Grade
	gendzl/V/T [def: be squeamish (with "im in boykh"); be sexually aroused (with "zikh im"); be eager to do something (with "zikh im")}
ganef{gnB}/Xganovem{gnBym}/H [m] [def: thief; rascal]
	ganeyvish{gnBish}/A
	ganeyve{gnBh}/Xganeyves{gnBwT}/H [f] [def: theft]
		/Ish [def: stealthy; thieving; untrustworthy]
		begneyve{bgnBh} [adv] [def: stealthily; by theft]
	ganve{gnBe}/Vganvenen{gnBenen}/T [def: steal] 
		/Garayn/Garoys/Gavek/Garop/Garoyf/Gdurkh/Gtsu/Gtsurik
		/Gunter [def: steal up on someone (with "zikh")]
		baganve{bagnBe}/Vbaganvenen{bagnBenen}/Bbaganvet{bagnBet} [def: rob]
		farganve{fargnBe}/Vfarganvenen{fargnBenen}/Bfarganvet{fargnBet} [def: steal in (with "zikh")]
	[idiom: a metsiye{mcy#h} fun a ganef{gnB} = unbelievable bargain]
	[idiom: keshene-ganef{keshene-gnB} = pickpocket]
ganeydn{gn-edn}/H/S [m/n] [def: paradise] /Idik
	[idiom: tam{tem} ganeydn{gn-edn} = delicious]
ganik/Ees [m] [def: porch, stoop] /D
gants/A /In [def: whole, full, complete]
	gantserheyt [adv] [def: entirely]
	gantskayt/N [f] [def: whole] 
	ingantsn [adv] [def: entirely, completely]
	dergants/V/Bdergantst [def: complete]
gar/V/T [def: crave, yearn for (with "nokh" or "tsu")]
	gern [def: eager; willing] u'mgern [def: unwilling] [grammar: undeclined]
		[idiom: hobn im gern = to like him]
	bager/N [m] [def: desire]
	bager/V/Bbagert [def: desire] 
	girik/A [def: eager] 
		girikayt/N [f] [def: eagerness] % Der Nister
garantye/S [f] [def: warranty, guarantee] 
	garanti'r/V/Bgaranti'rt [def: guarantee] % Harduf
		krant/K karant/K [def: certain, secure]
gara'zh/N [m] [def: garage] % Harduf
garb/N [m] [def: bunch; sheaf; collection (usually of produce)]
garb/V/T [def: tan (leather)]
	garber/S [m] [def: tanner] 
	garberay'/N [f] [def: tannery] 
	garbarnye/S [f] [def: leatherworks]
gardero'b/N [m] /In garderobe/S [f] [def: wardroom; wardrobe, clock room, locker room]
gardi'n/N [m] [def: drape]  % Harduf
gargeres{grgrT} [f] [def: throat]
	[idiom: (arayn)krikhn yenem in der gargeres{grtT} = get on his nerves]
	[idiom: aynesn yenem in der gargeres{grtT} = rub it in]
gargole/S [f] [def: gargoyle] [note: V]
garn [m?] [def: yarn, thread]
garni'r/V/Bgarni'rt [def: garnish, decorate] 
	garni'r/N [m] garnitu'r/N [f] [def: garnish, decoration]
	garniter/S [m] [def: outfit, suit]
garnizo'n/N [m] [def: garrison (military)] 
gartl/V/T [def: wrap]
	/Gunter [def: prepare for effort (with "zikh")]
	tsegartl/V/Btsegartlt [def: open (purse), unlatch, unfasten]
	gartl/N [m] [def: belt, sash, girdle] gartele/Ekh [def: small belt]
	fargartl/V/Bfargartlt [def: wrap, belt, tie]
	bay'gartl/N [m] [def: money belt]
	brokhgartl/N [m] [def: hernia truss]
	retungs-gartl/N [m] [def: lifejacket]
	talye-gartl/N [m] [def: cummerbund] 
	[idiom: er farshtekt im in gartl = he's superior to him] % Stutchkoff
gas/N [f] [def: street] /Dges [def: alley] 
	ahingas/N [f] [def: one-way street] % Yiddish League
	hintergas/N [f] /Dhinterges [def: alley]
	/Dhoyptges [def: main street] 
	/Dunterges [def: side street] 
	geske/S [f] [def: alley, lane]
	[idiom: blinde gas = dead-end street]
gashmiyes{gSmywT}/H [def: physical] /Idik /Lbe{b} [adv] [def: physically]
	megu'shem{mgwSm} [adv] [def: exaggerated; grotesque; fat]
	megu'shemdik{mgwSmdik}/A [def: physical; large; awkward; grotesque]
gast/Xgest [m] [def: guest]
	erngast/Xerngest [m] [def: honoree] 
	[idiom: kumen tsu gast = visit]
gastroli'r/V/Bgastroli'rt [def: perform]
	gastrol/N [def: gig]
	gastroli'st/N [m] gastrolyo'r/N [m] [def: guest artist; performer]
gastronomye [f] [def: gastronomy] gastronimish/A
gatke/S [def: suspenders; underpants (clothing)] % usually in plural
gavendze/V/Bgavendzet [def: prattle, talk (Polish gawęda `chat, gossip')]
gaver [m] [def: spittle, saliva] /D [def: child's bib]
	gaver/N/T [def: drool]
gayst/Eer [m] [def: spirit] /Iik /Ilekh [def: spirited]
	gay'stikayt/N [f] [def: spirituality]
	gay'sterishkayt/N [f] [def: spiritedness, enthusiasm] 
	bagayster/V/Bbagaystert [def: enthuse, inspire]
	bagay'sterung/N [f] [def: enthusiasm, inspiration]
	tsaytgayst/Eer [m] [def: spirit of the times]
gaytsik/A [def: eager; desiring; stingy]
	gaytsikayt/N [f] [def: eagerness; desire; stinginess]
		ge'ltgay'tsik/A [def: stingy; money-loving]
gayve{g#vh}/H [f] [def: pride, arrogance] /Idik [def: proud]
	gayvenik{g#vhnik}/Ees [m] [def: proud person]
	bal-gayve{bel-g#vh}/Xbaley-gayve{bely-g#vh} [m] bal-gayvenitse{bel-g#vhnitse}/S [f] [def: proud person]
gaz/N [m] [def: gas]
	fargaz/V/Bfargazt [def: gas]
gaze/S [f] [def: gauze] % Harduf
gaze't/N [m] gazete/S [f] [def: journal; newspaper]
gazhe/S [f] [def: salary]
gazlen{gzln}/Xgazlonem{gzlnym}/H [def: robber, bandit; vicious person]
	gazlonish{gzlnish}/A
	gazl{gzl}/H/V/T [def: rob] /Gavek/Gtsu
	bagazl{bagzl}/H/V/Bbagazlt{bagzlt} [def: rob]
	gazlones{gzlnwT}/H/N [f] gazlevoystve{gzlevoystve} [f] [def: thievery, brigandage]
	gazlevoye{gzlevoy|e|}/A [def: murderous]
	gezeyle{gzylh}/Xgezeyles{gzylwT} [def: robbery; booty]
ge/Een [m] [def: the letter G] 
geb/V/Bgegebn [def: give]
	/Garayn/Garop/Garoys/Garoys/Gtsu/Gavek/Gmit/Gnokh
	/Gayn [def: bring to court (with "oyf emetsn"); be possible (with "es ... zikh")]
	/Gfor [def: suggest, propose] 
	/Giber [def: be devoted to (with "zikh mit"); hand over]
	/Gon [def: declare; admit]
	/Gop [def: give, render; return; be concerned with (with "zikh mit"), be devoted to (with "zikh mit")] 
	/Goyf [def: give up, yield, concede]
	/Goys [def: marry off; spend money; inform on somebody]
	/Gtsu [def: add; admit]
	/Gtsurik [def: return, give back; vomit]
	/Gunter [def: give up, yield, concede]
	gib gist git gibn gib [def: give] % some spurious forms in present tense
	geber/S [m] ge'berin/S ge'berke/S [f] [def: giver] 
		a'rbetgeber/S [m] [def: employer] 
		broy'tgeber/S [m] [def: breadwinner]
		ekza'men-geber/S [m] ekzamen-ge'berin/S [f] [def: examiner, tester]
	oysgabe/S [f] aroysgabe/S [f] [def: edition] aroysgeber/S [m] [def: publisher]
	ibergebnkayt/N [f] ibergegebnkayt/N [f] [def: devotion]
	nokhgibik/A [def: moderate, agreable]
	gob/N [f] [def: gift; talent; berate (with "gebn a")]
		bagob/V/Bbagobt [def: confer upon (with "mit")]
	bagabt/A [def: talented; gifted] [usage: doubtful admissibility]
		hoykhbagabt/A [def: highly talented] [usage: doubtful admissibility]
		bagabung/N [f] bagabtkayt/N [f] [def: talent] [usage: doubtful admissibility]
	ongab/N/Ees [m/f] [def: datum]
	opgob/N [m] [def: tax]
	oyfgabe/S/Xoyfgabn [f] [def: task, mission; assignment, exercise]
	oyfgob/N [m] [def: deposit, down payment] 
	oysgob/N [m] [def: change (money returned from payment)]
	tsugob/N [m] [def: addition (Mathematics); additional amount] /Ilekh [def: additional]
	gezetsge'berish/A [def: legislative] 
	tsegeber/S [m] [def: dispenser] [note: V]
	ga'stgeber/S [m] ga'stgeberin/S [f] [def: host; innkeeper]
gebe'r/V geboyr/V/Bgeboyrn [def: bear a child]
	geborn/A [def: born] u'mgeboy'rn/A [def: unborn]
	gebu'rt/N geburt|s [f] [def: birth]
		vidergeburt/N [f] [def: rebirth]
		gebi'rtiker/X [m] [def: native, indigene]
	ayngeborn/A ayngeboyrn/A [def: by birth, genetic]
	[idiom: geboyrn vern = be born]
	fargeb/V/Bfargebn [def: forgive]
		fargebung/N [f] [def: forgiveness]
gebi'ft/K [def: shrewd] % Harduf
gebi't/N [n] [def: territory, realm, field of knowledge] [usage: doubtful admissibility]
geday/V/Bgedayet [def: thrive]
gedempt/A [def: boiled]
-/Xgederim -/Xgederimlekh [def: innards] % no singular.  Not spelled Hebraically.
geder{gdr} [m?] [def: railing, fence]
gedikht/K [def: dense, thick; heavy; dense] /Ilekh
	gedi'khtenish/N [f] [def: thicket] 
gedikht [n] [def: poem]
gedroln/A ongedroln/A [def: swollen; fat] % no base verb
geduld [f/n] [def: patience] /Iik [def: patient]
	u'mgeduld [f] [def: impatience] /Iik [def: impatient]
gefa'r/N [f] [def: danger] geferlekh/K [def: dangerous; horrible, terrible] 
	u'mgefe'r [adv] [def: approximately (German)]
gefe'kht/N [m?] [def: struggle, fight]
gefel/V/Bgefeln [def: please; appeal to]
gefin/V/Bgefunen [def: find] /Goys/Gtsurik
	/Gop [def: find a lost object]
	gefi'ns/N [def: finding] 
gegnt/N [m/f] u'mgegnt/N [m/f] [def: neighborhood] 
gehay' [n] [def: pride; impudence]
	[idiom: er hot in mir dos gehay = he is taking advantage of me]
geher/V/Bgehert [def: belong]
	/Gon [def: connect]
	geherik/A tsugeherik/A [def: proper, appropriate]
		ongeherik/A [def: connected; relevant]
			ongeherikayt/N [f] [def: connection; category]
	[idiom: eyns tsum anderen geher nit on = one thing has nothing to do with the other]
	[idiom: vi es geher tsu zayn = as it should be]
geheym/A [def: secret] /Iish [usage: doubtful admissibility]
	gehey'menish/N [n] [def: secrecy]
	gehey'mlekhkayt/N [f] [def: secrecy]
	gehey'mnishful/A [def: secret] 
-/Xgehirn [m] [def: brains] 
gekholyet/A [def: slipshod (Russian халатный)] % Der Nister
gel/A [def: yellow; red (hair)] /Iblekh /Iink
	gelkayt/N [f] [def: yellowness]
	geler/X [m] ge'lerke/S [f] [def: blond; redhead]
	fargel/V/Bfargelt [def: make yellow]
	bagelt/A [def: yellowed]
	ge'lekhl/Xekh [n] gelekhts/Eer [n] [def: egg yolk] 
	[idiom: oyszen grin un gel = look unwell]
gelasn/K [def: calm; leisurely; measured] gelasnkayt/N [f] [def: calmness]
	oysgelasn/A [def: of loose morals]  oysgelasnkayt/N [f] [def: loose morals] 
gelender/S [n] [def: banister, railing; disorderliness]
gele'nk/N [n] [def: joint; wrist; ankle aptitude]
	fi'ngergele'nk/N [n] [def: knuckle]
	ha'ntgele'nk/N [n] [def: wrist]
geling/V/Bgelungen [def: succeed (German)]
gelt/Eer/N [n] [def: money]
	birgelt [n] [def: tip, gratuity (to a waiter)] 
	bsure_gelt{bQwrh-gelt} [n] [def: tip, gratuity (to a messenger)]
	bu'lbegelt [n] [def: tip, gratuity (to a worker)]
	dire{dyrh}-gelt/Eer [n] [def: rent] 
	esreg_gelt{#Trwg-gelt} [n] [def: tip for bringing communal lulav/esreg] % Stutchkoff
	forgelt/Eer [n] [def: fare]
	khsime_gelt{HTymh-gelt} [n] [def: tip when an engagement is signed]
	ki'ndergelt [n] [def: child support] 
	hantgelt [n] [def: earnest money]
	khsime{HTymh}-gelt [n] [def: bride gift]
	kleyngelt [n] [def: change (money)]
	lager-gelt [n] [def: savings] 
	leshgelt [n] [def: payment to non-Jew who extinguishes fires on the Sabbath]
	letsgelt [n] letstgelt [n] [def: gift upon departing on a trip] % Stutchkoff
	nitsgelt [n] [def: usage fee]
	o'nzoggelt [n] [def: tip, gratuity (to a messenger)]
	oy'sleyzgelt/Eer [n] [def: ransom]
	papi'rgelt/Eer [n] [def: paper money] % Yiddish League
	postgelt [n] [def: postage] 
	re'bi{rby}-gelt [n] [def: tuition] 
		[idiom: batsoln rebi{rby}-gelt far = pay dearly for something learned]
	sho'dngelt [n] [def: reparation, damages, financial penalty]
	sho'lem_gelt{Slwm-gelt} [n] [def: tip, gratuity (to the Rabbi's assistant)]
	tantsgelt [n] [def: tip, gratuity (to a musician)]
	teygelt [n] [def: tip, gratuity (to a waiter)] 
	toggelt [n] [def: per diem] 
	trinkgelt [n] [def: tip, gratuity (to a waiter)] 
	veggelt [n] [def: (road) toll]
	vokhgelt [n] [def: weekly installment payment]
	[idiom: mezumen{mzwmn} gelt = ready money]
	[idiom: dos genoye gelt = exact change] [note: V]
	[idiom: (on)nemen far gut gelt = take for granted] % Stutchkoff
	[idiom: makhn (emetsn) tsu kleyngelt = disrespect (someone)]
	[idiom: far glaykhn gelt = for a reasonable price]]
gemayzekhts/N [n] [def: wetlands]
gemeyn/K [def: worthless; mean; common, ordinary]
	gemeynhayt/N [f] [def: meanness, villainy]
gemeynzam/A [def: together]
	gemey'nzamkayt/N [f] [def: common ground, mutuality]
	gemeynde/S [f] [def: community] 
gemore{gmr#}/Xgemores{gmrwT}/H [f] [def: Talmud] /Ish
gena'nt/A [def: titled, named] [usage: archaic]
gene/S [f] [def: gene] /Itish [def: genetic]
	genetik [f] [def: genetics (subject)] 
		genetiker/S [m] [def: geneticist] % Forwards: Yoel Matveyev
	homogenish/A [def: homogeneous] % Stutchkoff
genealogye/S [f] [def: genealogy] % Harduf 
genem{gyhnwm}/H [n] [def: Hell] /Idik
genera'l/N [m] [def: general (military)] /Isk generalshe/S [f] [def: wife of a a general]
generator/N [m] [def: generator (electrical); creator]
	generi'r/V/Bgeneri'rt [def: generate] % Forwards: Yoel Matveyev
ge'nets/V/Bgegenetst [def: yawn] /Gayn % BUG autogenerate gegenetst fails
	 ge'nets/N [m] [def: yawn]
gengster/S [m] [def: gangster] % Harduf 
genezung/N [f] [def: cure, recovery]
	genezn [participle] [def: recover (with "vern")]
geni'k/N [n] [def: neck; nape (body part)]
geni's/V/Bgenosn [def: benefit (from, with "fun"); enjoy]
	geniser/S [m] [def: one who benefits] 
	genu's [m?] [def: pleasure, benefit] [usage: not recommended]
	genose/Xgenosn [m] [def: comrade (in party or union)]
geni't/A [def: experienced; skilled] genitung/N [f] [def: exercise, workout]
	genitshaft/N [f] genitkayt/N [f] [def: experience; skill]
genize{gnyz|h}/H [def: storehouse]
genose/Xgenosn [m] genosine/S [f] [def: comrade (obsolete title)]
genotsi'd/N [m] [def: genocide]
genoy/K [def: exact, precise]
genug/Iik/Indik [def: enough]
	genign/V/Bgenigntgenugn/V/Bgenugnt [def: suffice]
		genugndikayt/N [f] [def: sufficiency]
		fargenign/S [n] [def: pleasure]
	banugn/V/Bbanugnt bagnugn/V/Bbagnugnt [def: suffice; be satisfied (with "zikh")]
		banugen/V/Bbanugent [def: suffice; be satisfied (with "zikh mit")]
	ibergenug [def: more than enough]
genya'l/A [def: brilliant, superb, inspired]
	genyalkayt/N [f] [def: brilliance, genius]
geografye [f] [def: geography] geografish/A [def: geographical]
geologye [f] [def: geology] % Harduf
	geologish/A [def: geological]
geometrye [f] [def: geometry] geometrish/A [def: geometrical]
ger_{gr}/Xgeyrem{grym}/H [m] gerte{grte}/S gyores{gyrT} [f] [def: convert to Judaism]
	megayer{mgAr} [verb] [def: make Jewish (with "zayn"); become Jewish (with "zikh zayn")] 
	giyer{gywr} [m] [def: conversion to Judaism] 
gera'm/A [def: roomy, spacious, capacious] 
geranyum/S [m] [def: geranium (plant)] 
gerdik/Ees [m] [def: throat]
gerimandreve/V/T [def: gerrymander] % Yiddish League
	gerima'drye/S [f] [def: gerrymandering] % Yiddish League
germanyum [m] [def: germanium (Ge)] 
gero't/V/Bgerotn [def: succeed; come to fruition; resemble (with "- in emetsn"); be clever and attractive]
	/Gop/Garayn
	gerotn/K [def: ripe]
	gero't [n] gero'tnkayt/N [f] [def: ripeness]
		gere't [m] gere'tenish/N [n] [def: abundance; harvest] 
	barot [def: protection, providence] /In [def: protected]
gersht/N [m] [def: barley; grain of barley] /In
	/D [def: sty (abscess in the eye glands)]
geru'kh/N [n] [def: odor] % Harduf 
geshay't/A [def: clever, crafty]
	farshay't/A [def: insolent]
geshe/V/Bgeshen [def: occur] geshe'enish/N [n] [def: event]
	gesheen/A [def: actual, having occurred] % irregular
geshikhte/S [f] [def: history; story] /D geshikhtlekh/A
	fo'rgeshi'khte/S [f] [def: prehistory] % Forwards: Yoel Matveyev
	[idiom: far der geshikhte = for the record]
geshir [def: dishes; harness]
	teygeshir [def: tea set]
geshle'kht/Eer [n] [def: sex] /Ilekh [def: sexual]
geshpe'nst/N [n] [def: specter, spirit, ghost] /Iish [usage: deprecated]
geshvind/K [def: fast quick] geshvindkayt/N [f] [def: speed]
geshvi'r/N [n] [def: abscess; ulcer]
geshvoln/A [def: swollen] oyfgeshvoln/A ongeshvoln/A % no base verb
	untergeshvoln/A [def: swollen] % Sholem Aleykhem
	farshvoln/A [def: swollen]
geske/S [f] [def: yoke (of dress)]
gesrokhe{gesrHh}/Xgesrokhes{gesrHwT} [f/n] [def: stench] 
get{gt}/V/Bgeget{gegt} [def: divorce] /Gop
	get{gt}/N [m] [def: divorce]
	[idiom: oysgeputst vi Khavele{Hwhle} tsum get{gt} = woman dressed like a tart]
geto/S [f] [def: ghetto]
	getoizi'r/V/Bgetoizi'rt [def: ghettoize]
	fargetoizi'r/V/Bfargetoizi'rt [def: ghettoize]
getse'lt/N [n] [def: tent]
geule{g#wlh}/Xgeules{g#wlwT}/H [f] [def: redemption]
geva'ld/N [f] gva'ld/N [f] [def: force; violence]
	begva'ld{bgvald} [adv] [def: by force]
	gevaldik/A gvaldik/A [def: strong, powerful; great; fantastic]
	gvaldovne/A [def: huge, collossal]
	gevald/N [m] gvald/N [m] [def: scream; hue and cry]
		gevald [interj] gvald [interj] [def: help!]
		gevalderay'/N [n] gvalderay'/N [n] [def: shouts for help]
		geva'ldeve/V/T/Bgeva'ldevet gva'ldeve/V/T/Bgva'ldevet [def: shout for help]
		tsegva'ldeve/V/Btsegva'ldevet [def: make a commotion for a while (with "zikh")] 
	gevaldik/V/Bgevaldikt gvaldik/V/Bgvaldikt [def: rape]
		fargevaldik/V/Bfargevaldikt [def: rape] fargvaldik/V/Bfargvaldikt
			fargevaldle/V/Bfargevaldlet [def: commit sexual abuse] 
			fargeva'ldikung/N [f] fargva'ldikung/N [f] [def: rape] 
			fargeva'ldiker/X/S fargva'ldiker/X/S [m] [def: rapist] % Forwards
	[idiom: iber gvald/gevald = unwillingly]
geva'nt/N/Xgeventer [n] /D [def: cloth material] % < PIE *uendh- (to turn, wind, wend)   
	geventn/A [def: of cloth material]
	be'tgeva'nt [n] [def: bedding]
geve'lb/N/Eer /D [n] [def: store, shop; vault (architecture)]
	geve'lbt/A [def: vaulted]
	velbung/N gevelbung/N [f] [def: vault (architecture)] 
gevi'n/V/Bgevunen [def: win] /Giber/Gtsurik/Gop
	gevinung/N [f] [def: victory]
	gevi'ns/N [n] [def: winnings; prize, reward]
	geviner/S [m] [def: victor, winner] gevi'nerin/S [f] [def: child-bearer; woman in labor]
	[idiom: ver se gefint, der gevint = finders keepers] [note: V] 
geviser/S [m] [def: wet weather; flooding]
gevoyn/V/Bgevoynt [def: accustom; become accustomed (with "zikh")] /Gtsu/Gop/Gayn
	geveynlekh/A geveyntlekh/A [def: ordinary, usual, common; of course]
	u'mgevey'nlekh/A u'mgevey'ntlekh/A [def: unusual]
	oysergeveynlekh/A oysergeveyntlekh/A [def: extraordinary]
	gevoyntshaft/N [f] gevoynhayt/N [f] [def: habit]
gevoyr [def: become aware of, learn, discover (with "vern fun")]
	 gevor gevoyre % all three forms
gey/Vgeyn/Bgegangen [def: go; plan to (with infinitive)]
	% limitation:
	% infinitive forms are "geyn", irregular, but gerunds are "geyendik",
	%  regular.  We need to split those roots.
	/Gnokh/Gdurkh/Gadurkh/Garayn/Garoys/Gariber/Garop/Garoys/Gaheym
	/Gavek/Giber/Gmit/Gtsu/Gum/Gtsurik
	/Gunter/Garoyf/Gfunander/Garunter/Gayn/Gfor/Gtsunoyf/Gantkegn
	/Garum [def: go on a date]
	/Gahin [def: disappear]
	/Gfarbay [def: elapse; pass by] 
	/Gforoys [def: precede]
	/Gon [def: continue; bother (with dative)]
	/Gop [def: recede; melt]
	/Goyf [def: rise (as in dough); full of plants (with "mit")]
	/Goys [def: be extinguished, burn out; die; retreat at the close of the Amidah prayer; be crazy about (with "nokh"); date (with "mit")]
	/Bgegan % variant form, southern Yiddish
	gey'endik/A [def: walking; running; flowing]
		aru'mgey'endik/A [def: walking about]
		farbaygey'endik/A [def: passing]
	dergeyn dergey/V/Bdergangen [def: bother; figure out; achieve]
		[idiom: dergeyn di yorn = bother to death]
	durkhgey'evdik/A [def: passable (path)]
	geyn % irregular infinitive; bug: can't generate with converbs
		adurkhgeyn [def: pass through]
		arayngeyn [def: enter] arayntsugeyn
		aribergeyn [def: switch attention]
		aropgeyn [def: go down]
		aroysgeyn [def: go out; be extinguished, die]
		arumgeyn [def: go around, perambulate]
		aruntergeyn [def: sink, set]
			[idiom: aruntergeyn fun zinen = go crazy]
		avekgeyn avektsugeyn [def: go away; die]
		durkhgeyn [def: go through; undergo]
		farbaygeyn [def: pass nearby]
		fargeyn fargey/V/Bfargangen [def: disappear; go into the past]
			fargangenhayt/N [f] [def: the past]
			fargeyik/A [def: passing, temporary, momentary] 
		ibergeyn [def: be superior; repeat; change; inspect; be transmitted]
		mitgeyn [def: accompany; follow]
		nokhgeyn [def: imitate]
		ongeyn [def: continue; relate to; bother] [usage: "continue" is inadmissible]
		opgeyn [def: reach a conclusion, end; fail]
		oysgeyn [def: go out; expire]
		tsegeyn tsegey/V/Btsegangen [def: melt; grow]
		tsugeyn [def: approach]
	bagey/Vbageyn/Bbagangen [def: commit (crime); go without (with "zikh on"); treat (with "zikh mit")]
	gang/Xgeng [m] [def: walk; gait; way, manner; course] /Ibar [def: passable]
		/Dgeng [def: gait] % Forwards: Boris Sandler
		arayngang/N/S [m] [def: entrance]
		aropgang/N [m] [def: descent]
		aroysgang/N [m] [def: exit]
		aroyfgang/N [m] [def: ascent]
		avekgang/N [m] [def: departure]
		boygngang/N [m] [def: archway] 
		durkhgang/N [m] [def: pass (mountain), passageway] 
		ibergang/N [m] [def: overpass; disease; transition]
			faze-ibergang/N [m] [def: phase transition (physics)]
		farbaygang/N [m] [def: passage] 
		foroysgang/N [m] [def: preceeding]
		gedanken-gang [m] [def: reasoning, thought process]
		opgang/N [m] [def: departure; sale; flow (money); sewage; sewer, drain]
		oyfgang/N [m] [def: rising (sun)]
			zunoyfgang{zun#oyfgang}/N [m] [def: sunrise] 
		oysgang/N [m] [def: outlet, issue, vent; death]
		shneyfargang/N [m] [def: when snow melts] % Sutskever
		shpatsirgang/N [m] [def: stroll] % Der Nister
		shtulgang/N [m] [def: bowel movement]
		tsugang/N [m] [def: approach] tsugenglekh/A [def: approachable]
			tsugenglekhkayt/N [f] [def: approachability]
		untergang/N [m] [def: setting (sun); death; disease]
			zun-untergang/N [m] [def: sunset] 
		zunfargang/N [m] [def: sunset]
		u'mgang/N [m] [def: surroundings; disease; traffic] 
		[idiom: folg mikh a gang = too difficult]
	geyer/S [m] [def: traveler]
		ayngeyer/S [m] arayngeyer/S [m] [def: attendee; guest]
		aroysgeyer/S [m] [def: departing person]
		dorfgeyer/S [m] [def: traveling salesman]
		dro'tngeyer/S [m] drotngeyerke/S [f] [def: tightrope walker]
		du'rkhgeyer/S [m] [def: traveler]
		farbay'geyer/S [m] [def: someone passing by]
		fo'rgeyer/S [m] [def: advance guard]
		foroy'sgeyer/S [m] [def: predecessor] % D-H Katz
		fu'sgeyer/S [m] [def: pedestrian] 
		ley'dikgeyer/S [m] [def: jobless person]
		medi'ne{mdynh}-geyer/S [m] [def: travelling peddler; beggar]
		mi'tgeyer/S [m] [def: traveling companion]
		no'khgeyer/S [m] [def: follower] 
		tsufu'sgeyer/S [m] [def: pedestrian] % Der Nister
	[idiom: afile di velt zol untergeyn = come hell or high water]
geyder{gdr}/H [def: border]
geylish/A [def: Gaelic (language family)]
geyresh{gyrwS}/Xgeyrushem{gyrwSym}/H [m] [def: expulsion]
	megaresh{mgrS}/H [verb] [def: divorce (with "zayn")] 
	grushe{grwSh}/Xgrushes{grwSwT}/H [f] [def: divorced woman]
	goresh{grwS}/Xgrushem{grwSym}/H [m] [def: divorced man; exile]
gezandter/S [m] [def: minister, legate] [usage: inadmissible]
	gezandshaft/N [m] [def: ministry, legation] [usage: inadmissible]
geze{gze}/H/S [def: race; pedigree; breed; origin] 
geze'l/N [m] [def: apprentice; journeyman; partner]
	shnayder-geze'l/N [m] [def: tailor's apprentice]
	gezelshaft/N [f] [def: business, society] /Ilekh /Iik [def: social] 
	gezelshaftlekhkayt/N [f] [def: society]
gezikht/Eer [n] [def: face; countenance]
gezint [n] [def: members; family members]
	 hoyzgezint [n] [def: family members]
gezunt/A/Kgezint [def: healthy] gezunt [n] [def: health]
	gezunterheyt [adv] [def: in good health; if you must]
	umgezunt/A [def: unhealthy]
		umgezuntkayt/N [f] [def: unhealthiness]
	[idiom: zay gezunt = goodbye]
	[idiom: tsu gezunt = gesundheit!]
	[idiom: abi gezunt = as long as one is healthy]
giber{gybwr}/Xgeboyrem{gybwrym}/H [m] [def: hero, powerful person]
	/Lha{h} [def: the hero]
	giboyrish{gybwrish}/K [def: valiant, heroic]
	gvure{gBwrh}/Xgvures{gBwrwT} [def: strength, heroism; exploit; 80th birthday (plural)]
		goyver{gwBr} [verb] [def: conquer, overcome (with "zayn")]
	koyekh_gavre{KwH-gBr#} [m] [def: virility; male potency]
	gvar{gBr}/Xgvorem{gBrym}/H [m] [def: strong man]
	gevir{gByr}/Xgvirem{gByrym}/H [m] gevirte{gByrte}/S [f] [def: wealthy  person]
		gevirish{gByrish}/A [def: rich] 
		gevirishaft{gByrishaft} [f] gevirishkayt{gByrishkayt}/N [f] [def: wealth]
		geviremshaft{gByrymshaft} [f] [def: the wealthy]
		[idiom: gezelshaftlekhe gevirte{gByrte} = socialite]
gift/N [m] [def: poison] /Iik [def: poisonous]
	fargift/V/T/Bfargift fargiftik/V/T [def: poison]
	fargiftung/N [f] [def: poisoning] 
giga'nt/N [m] [def: giant] /Iish [def: gigantic]
gi'gerl/Eekh [n] [def: dandy, fop] % Stutchkoff
gikh/K [def: quick]
	gikhkayt/N [f] [def: haste]
		[idiom: ma'ksimum gikhkayt = speed limit] [note: V]
	ingikhn [adv] [def: quickly]
	fargikher/V/Bfargikhert [def: quicken, accelerate] 
		fargikherung/N [f] [def: acceleration]
	gikhert [interj] [def: quickly!]
gil/N [def: gland]
gilde/S [f] [def: guild dues] 
gilgl{gylgwl}/Xgilgulem{gylgwlym}/H [m] [def: reincarnation; transformation; evil spirit]
	megulgl{mgwlgl}/H nisgalgl{nTglgl}/H [def: reincarnated (with "vern")]
	seyfer_hagilgulem{sfr-hgylgwlym} [m] [def: book of transmigrations (mystic)]
gilt/V/Bgegoltn [def: be effective]
	/Gop [def: pay a reward]
	giltik/A [def: effective]
		endgiltik/A [def: definitive]
	glaykhgilt/N [m] [def: indifference]
		glaykhgiltik/A [def: unconcerned, indifferent]
			glaykhgiltikayt/N [f] [def: unconcern]
	laytnglaykh/A [def: like everyone]
	[idiom: dos gilt nit = that doesn't count!]
giluy{gylw|y}/H [def: revealed] /Lbe{b} [def: revealed]
	hisgales{hTglwT}/H [def: revelation (of a hidden saint)]
	megale{mglh}/H [verb] [def: reveal (with "zayn")] 
	nisgale{nTglh}/H [verb] [def: be revealed (with "vern")]
gilze/S [f] [def: a kind of pipe] 
gima'trye{gymtry#}/Xgima'tryes{gymtry#wT}/H [f] [def: method of textual interpretation treating each letter as a number (mystic)] 
giml/H [m/f] [def: letter Gimel]
gimnazye/S [f] [def: high school]
	gimnazi'st/N [m] /D gimnazistke/S [f] [def: high-school student] 
	gimnastik [f] [def: gym, athletics (subject)] 
		gimna'st/N [m] gimnastke/S [f] [def: gymnast]
		[idiom: makhn gimnastik = practice gymnastics]
	gimnastish/A [def: gymnastic] 
	progimnazye/S [f] [def: middle school]
gimze [f?] [def: goat hide, for shoe uppers, brown or block (material)] % German gemze, `chamois'.
	gemzn/A [def: chamois]
gin/V/T [def: wish]
ginekolog/N [m] [def: gynecologist (occupation)]
	ginekologye [f] [def: gynecology]
ginstik/A [def: opportunistic]
gintsik/K [def: favorable]
	gintsikayt/N [f] [def: expression of favor]
gips/N [m] [def: gypsum; plaster of Paris; surgical cast] /In
girland/N [m?] [def: garland, wreath]
gis/V/Bgegosn [def: pour; mint (money)]
	/Garayn/Garoyf/Garoys/Gariber/Goys/Gtsu/Gon/Gtsunoyf/Gop/Giber/Gunter
	/Gtsunoyf/Gtsuzamen
	fargis/V/Bfargosn [def: pour, drench; let drop]
		fargisung/N [f] [def: pouring]
		blut-fargisung/N [f] [def: bloodshed]
	dergis/V/Bdergosn bagis/V/Bbagosn [def: drench]
	tsegis/V/Btsegosn [def: splatter; melt]
	gisekhts/N [n] [def: liquid] % Forwards: S-R Schaechter 
	gos/N [m] gus/N [m] [def: drop] 
		ayngos/N [m] [def: bay, gulf (water)]
		aroysgos/N [m] [def: outpouring, disgharge]
		durkhgos/N [m] durkhgus/N [m] [def: strait (channel of water)]
		opgos/N [m] [def: sink]
		oysgos/N [m] [def: outpour; discharge] 
			blu'toysgos/N [m] [def: bleeding]
		oysgus/N [m] [def: outpour; discharge] [usage: doubtful admissibility]
	tsunoyfgisung/N [f] [def: mixture (liquids)]
	gisik/A [def: fluid, liquid] 
	o'ngiser/X [m] [def: person pouring] % Der Nister
	o'ngegosn/A [def: juicy] % Y. Kipnis
gitare/S [f] gitar/N [def: guitar (musical instrument)]
	gitari'st/N [m] [def: guitarist]
gitin{gytyn}/H [def: tractate Gitin (divorces) of Talmud]
glants/V/T [def: shine, gleam] /Goys /Gop [def: reflect]
	farglantst/A [def: gleaming] % Der Nister
	glentsl/V/T [def: sparkle]
	glantsik/A glantsedik/A [def: shiny]
	glentsnd/A glentsndik/K [def: bright, splendid] % Harduf, Stutchkoff
	opglants/N [m] [def: reflection]
glasne/S [m] [def: alderman] 
glat/A /Iik [def: smooth; simple] /Iink [def: small and smooth]
	glatkayt/N [f] [def: smoothness]
	glet/V/T [def: caress, stroke, pet] /Goys/Gtsu/Gfunander
		glet/N [m] [def: caress] 
		gle'tenish/N [n] [def: foreplay] [note: V]
	gletling/N [m] [def: pet] [usage: neologism]
	farglet/V/Bfarglet [def: smooth over] 
	[idiom: glat azoy = just like that]
glavne/A [def: chief, main, principal] [usage: not recommended]
glaykh/A [def: straight, even; direct; similar; right away] /Iik
	baglaykh [adv] [def: just like (with "mit")] % Forwards: Boris Sandler
	glaykhkayt/N [f] glaykhhayt/N [f] [def: equality]
		u'mglay'khkayt/N [f] [def: inequality] 
	glay'khenish/N [n] [def: similitude]
	glaykhung/N [f] [def: equation]
	desglaykhn [adv] [def: similarly; likewise] 
	tsuglaykh [adv] tsuglaykhn [adv] [def: at the same time]
	glaykh/V/Bgeglikhn [def: equate; compare]
		/Goys [def: even out (with "zikh"); adjust; resolve (question)] 
	farglaykh/V/Bfarglikhn [def: equate, compare]
		farglaykh/N [m] [def: comparison] /Ilekh [def: comparable] 
		farglaykhik/A [def: comparative]
		farglaykhung/N [m] [def: comparison; simile]
	glaykh/V/T [def: straighten] /Goys
	u'mglaykh/A [def: uneven] 
glaykh/V/T [def: like (English)]
gletsher/S [def: glacier] /D
gleyb/V/T [def: trust]
	/Gayn [def: be brainwashed]
	gleybik/A [def: trusting] u'mgley'bik/A [def: distrusting]
	fargleybt/A [def: trusting]
		fargley'btkayt/N [f] [def: bigotry] % Yiddish League
	bagleyb/V/Bbagleybt [def: trust]
	gleybenish/N [n] ayngleybenish/N [n] [def: foolish belief; superstition]
		ayngegleybtkayt/N [f] [def: gullible trust]
gli/V/T [def: glow; heat to glowing] /Gon/Goys
	tsegli/V/Btseglit [def: glow]
	gli/N [m] [def: glow] /Iik [def: glowing]
	glishtshe/S [f] [def: ember] % Menakhem Kipnis
glider/V/T [def: act as a part of, compartmentalize] /Gtsu
	/Gayn [def: assimilate (with "in")] 
	tseglider/V/Btseglidert [def: organize, structure; subdivide]
	glid/Eer [n] [def: limb]
		glid- [prefix] [def: once removed, second (genealogical)] 
	mitglid/Eer [m] [def: member]
		mitglidershaft/N [f] [def: membership]
		mitglidgelt [n] [def: membership fee]
glik/N [n] [def: happiness; luck; joyous event]
	glik/V/T [def: be lucky; be successful] /Gop/Goys
	gliklekh/K [def: lucky, happy] ibergliklekh/A [def: over-happy]
		gliklekhkayt/N [f] [def: happiness]
		gli'klekhervay'z [adv] [def: luckily, happily]
	u'mglik/N [n] [def: bad luck] u'mgliklekh/K [def: unlucky]
		farumglik/V/Bfarumglikt [def: ruin, devastate]
	baglik/V/Bbaglikt [def: make happy, make fortunate]
	glikishok [def: luck town] % vuhin ikh zol nit geyn vel ikh keyn glikishok nit dergeyn
	[idiom: zol zayn mit glik = good luck]
glimer/V/T [def: glimmer, shine]
	gliml/N [m] glimye/S [f] [def: sound; information]
	[idiom: a klang un a gliml = a report]
glin [interj] [def: ding (sound of a bell)] glon [def: dong (sound of a bell)]
glitserine [f] [def: glycerine, glycerol (chemical)]
glitsh/V/T [def: slip, skate (with "zikh")] /Garop/Garoys/Goys/Gavek
	/Gdurkh [def: swipe (card)] 
	glitsh/N [m] [def: slip; ice-skating rink] /Iik [def: slippery]
	glitsheray'/N [n] [def: slipping]
	erdglitsh/N [m] [def: landslide]
gliver/V/T [def: solidify]
	fargliver/V/Bfarglivert [def: solidify]
		farglivertkayt/N [f] [def: motionlessness] % Forwards: Boris Sandler
	geglivert|s [n] [def: jelly (food)]
	gliverdik/A [def: solid]
globus/N [m] [def: earth; geographic globe]
	global/A [def: global]
		globalizatsye/S [f] [def: globalization] % Forwards
glok/N/Xgleker [m] [def: bell] /Dglek
	glekerdik/A [def: bell-like]
	glekl/V/T [def: jingle] % Harduf
	may'glekl/Eekh [n] [def: lily of the valley (flower, Convallaria majalis)]
	tirglekl/Eekh [n] [def: doorbell] % Harduf 
	vintglekl/Eekh [n] [def: anemone (flower)] % Stutchkoff
glomp/N [m?] [def: tree stump; stalk (cabbage or lettuce); idiot]
glorye/S [f] [def: glory] /Idik
	glorifitsi'r/V/Bglorifitsi'rt [def: glorify, exhalt]
glosar/N [m?] [def: glossary] 
glots/V/T [def: squint; stare] /Garoys/Goys/Garoyf
	farglots/V/Bfarglotst [def: squint]
gloyb/V/T [def: believe] [grammar: takes dative]
	bagloyb/V/Bbagloybt [def: believe]
	gloybik/A [def: believing]
		ibergloybik/A [def: superstitious]
		u'mgloybik/A [def: disbelieving]
	gloyblekh/A [def: believable] u'mgloyblekh/A [def: unbelievable]
		fargloyblekh/A [def: credulous] % Sholem Aleykhem
	gloybn/S [m] [def: belief, trust]
		gloybenish/N [n] [def: unusual belief]
			ayngloybenish/N [n] [def: acquired belief] 
		obergloybn/S [m] [def: superstition] 
	gleyblekh/A [def: believable] u'mgleyblekh/A [def: unbelievable] 
		bagleyblekh/A [def: believable]
	[idiom: gloyb yo gloyb nit = believe it or not]
gloz/Xglezer [n/f] [def: glass (object); glass (material)]
	/Dglez [def: drinking glass] 
	glezern/A [def: glass] glezen/A glezerlekh % variant forms
	glezer/S [m] [def: glazier] % Harduf
	farglezer/V/Bfarglezert [def: make glassy]
	mestglezl/Eekh [n] [def: measuring cup] 
	birgloz/Ebirglezer [n/f] [def: beer stein] % Yosl Birshteyn
	teygloz/Eteyglezer [n/f] [def: tea glass] % Avrom Karpinovitsh
	glezl/V/T [def: guzzle, drink hard liquor] 
	gleyz/V/T [def: varnish, enamel; glaze (glass)]
	glazu'r [m] [def: glaze]
glust/V/T [def: desire]
	farglust/V/Bfarglust [def: desire]
	glust [m] /Iik glustung/N [f] glustikayt/N [f] [def: desire] 
	glustenish/N [n] [def: desire]
gluten [m?] [def: gluten (protein in wheat)]
gmine/S [f] [def: community]
gnyad/A [def: bay-colored horse] % Mendl Man
gnide/S [f] [def: nit (insect egg)] 
gnod/N [f] geno'd/N [f] [def: divine assent; grace; mercy; quarter (in battle)]
	gnedik/K [def: favorable; gracious] % zol mayn zikorn zayn gnediker
	bagnedik/V/Bbagnetikt [def: forgive, release from prison] 
gnom/N [m] [def: midget]
gno'teve/V/T [def: whip]
goder/V/T [def: babble; sound of a goose]
godl{gdwl}/Xgedoylem{gdwlym}/H [def: sage, great one; defecation (in plural)]
	godldik{gdwldik}/A [def: proud]
	hagodl{hgdwl} [def: the great]
	gadles{gdlwT}/H [def: greatness]
	gadlen{gdln}/Xgadlonem{gdlnym}/H [def: great one; arrogant person] 
	gedule{gdwlh}/H [def: greatness; grandeur]
	gedoyley{gdwly}/H [def: great ones of] 
	gedile{gdwlh}/H [def: big deal; glory; something worth bragging about]
	koyen_godl{Khn-gdwl} [m] [def: high priest]
	megadl{mgdl}/H [verb] [def: raise (a child) (with "zayn")]
	oyle_legdule{ewlh-lgdwlh} [m] [def: newly high status person]
	[idiom: nekovem{nkBym} gedoylem{gdwlym} = defecation]
goen{gown}/Xgeoynem{g#wnym}/H [m] [def: sage; genius]
	geoynish{gownish}/A [def: sagacious]
-/Xgo'gelekh [def: barley porridge]
gol/V/T [def: shave] /Gop/Goys
	gol/A [def: bare; pure]
	golebrodnik/Ees [def: beardless Jew; unobservant Jew] [usage: pejorative]
	[idiom: a gol kop = bald head]
gold /Iik [n] [def: gold (Au)] goldn/A gildern/A gildn/A [def: golden]
	gingold gingoldn/A [def: pure gold, spun gold]
	bagild/V/Bbagildt fargilt/V/Bfargilt gilt/V/T bagilt/V/Bbagilt [def: gild]
	gilder/V/T goldik/V/T [def: become golden] 
	gildoy'n/N/Eim gildey'n/N [def: coin unit of currency (30 kopeks)] gildn
goles{glwT}/H [f] [def: exile; diaspora] /Idik
	fargolest{farglwTt}/A [def: exiled] % Der Nister: Mashber
golf [m] [def: golf (game)] 
golf/N [def: turtleneck sweater]
golish/Ees [m] [def: oak gall]
	gulye/S [f] [def: gall, growth, wen] 
golova [m] [def: head, chief, mayor (Russian голова "head")] 
gombe/S [f] gembe/S [f] [def: chin]
	gembe/S [f] [def: strong voice]
gomer{gmwr}/H [def: finish]
gomlke/S [def: cheese ball or triangle (food); goat excrement] % farmer's cheese, egg, dried: Stutchkoff
	[idiom: makhn fun shney gomlkes = accomplish the impossible]
goner/S [m] [def: gander, male goose]
	gon [interj] [def: sound of a goose]
gonera'r/N [def: honerarium (payment)] 
gontine/S [f] [def: pagan place of worship]
gontse/S [def: messenger, horserider announcing news; hooligan]
gopl/N [m] [def: fork] /Dgep
	fargoplt/A [def: forked] 
	[idiom: tsenemen oyf gepelekh = verbally assault]
gor [adv] [def: very; entirely; surprisingly] /A [def: whole] 
	[idiom: biz gor = extremely]
gorgl/N [m] [def: throat] /Idik gergele/Ekh [def: throat, windpipe]
	gorgl/V/T [def: gargle] % Harduf
gorile/S [f] [def: gorilla (animal)] % Harduf
gorn/S [m] [def: (upper) floor, story; attic (part of building)] /Idik
	tsveygorndik/A [def: two-storied]
	draygorndik/A [def: three-storied]
	firgorndik/A [def: four-storied]
	finfgorndik/A [def: five-storied]
gortn/S/Xgertner [m] [def: garden] /Dgertnd /Dgert
	gertner/S [m] ge'rtnerin/S [f] [def: gardner]
	gertnerirer/S [m] gertneri'rerin/S [f] [def: gardner]
	gertneray' [n] [def: gardening, horticulture]
	kindergortn [n] [def: kindergarten] [usage: American] % Forwards: M-S Hoffman
	shtotgortn [n] [def: public garden, park]
	vayngortn/Xvayngertner [m] [def: vineyard]
gospodi'n [m] [def: Mister (Russian господин)]
got/Xgeter/C [m] [def: God, deity] gotenyu [def: dear God]
	getlekh/A [def: Godly, divine]
		getlekhkayt/N [f] gothayt/N [f] [def: Godliness]
	fargeter/V/Bfargetert [def: deify; idolize, adore]
		fargeterer/S [m] [def: deifier, idolator, worshipper]
	gets/N [m] getsh/Ees [m] getshke/S [m] [def: idol; idiot]
	opgot/Xopgeter [m] [def: idol] 
	getin/S [f] [def: goddess, idol]
	gotikhe/S [f] [def: pretentious woman]
	[idiom: got iz mir dir = what's wrong with you? (comforting)]
gotish/A [def: Gothic]
goy{gO}/Xgoyem{gOym}/H [m] [def: Christian man; nation]
	/Lle{l} [def: to a nation]
	goye{gOe}/S goyke/S [def: Christian woman]
	goyets/N [m] [def: rascal, scoundrel] /D % Sholem Aleykhem
	goyish{gOish}/A 
goyder/S [m] [def: double chin] /D
	goyder/V/T [def: be pretentious; take on airs (with "zikh")] /Gon/Goys
goylem{gwlm}/S/Xgoylomem{gwlmym}/H [m] [def: artificial man; fool]
	fargoylem{fargwlm}/V/Bfargoylmt{fargwlmt} [def: be mute (with "zikh")]
goyml{gwml}/H [def: blessing of deliverance]
	gmiles{gmylwT}/H [def: generosity]
	gmiles_khesed{gmylwT-Hsd} [def: interest-free loan]
	gema'kh_{gm″H} [def: mutual aid society; free-loan society]
goyrem{gwrm}/H [verb] [def: cause (with "zayn")]
	goyrem{gwrm}/Xgormem{gwrmym} [m] [def: cause]
goyrl{gwrl}/Xgoyroles{gwrluT}/H [def: fate] /Idik
	zoykhe{zwxh}-bagoyrl{bgwrl} [m] [def: lottery winner]
	[idiom: varfn goyrl = cast lots, toss a coin ("mit a matbeye{mtbe}")]
goyses{gwss}/H [def: person on deathbed] /Idik [def: at death's door]
	gesise{gsys|h} [def: last gasp] /Idik [def: at death's door]
	goyses{gwss}/V/T [def: be at death's door]
goyzer{gwzr}/H [verb] [def: command (with "zayn")]
	gezeyre{gzyrh}/Xgezeyres{gzyrwT}/H [f] [def: edict, decree; persecution]
	gzar{gzr}/Xgezeyres{gzyrwT}/H [def: decree of]
	[idiom: gezeyres{gzyrwT} takh{W″H} vetat{|uT″t} = Chmelnitski pogroms, 1648-9]
grabitelte/S [def: robber (Russian грабитель)] 
grabl/V/T [def: scratch; search on the ground by hand; rummage]
	grablye/S [f] [def: rake]
grabove/A [def: ghastly ??] % Rachel Korn: Erd
grad/N [m] [def: grade; degree] % Harduf 
	gradus/N [m?] [def: degree (temperature)] % Kulbak: Zelmenyaner
	gradnik/Ees [m] [def: thermometer] 
	gradke/S [f] [def: garden bed (Russian грядка)] [usage: not recommended]
	[idiom: tsvey inem grad tsen = 2 raised to the 10th power] % Forwards
grad grade [def: just] % mostly uninflected
gradui'r/V/Bgradui'rt [def: graduate]
	graduatsye/S [f] [def: graduation]
	gradua'nt/N [m] graduantke/S [f] [def: graduate] % Forwards
graf/N [m] grafin/S grafinye/S [f] [def: count, noble]
	graferay'/N [f] [def: county]
grafik [f] [def: graphics (subject)] grafish/A [def: graphic]
	gra'fiker/S [def: graphic designer] [note: V]
	-/Xgrafiti [def: grafiti] [note: V]
		grafiti'st/N [m] grafitistke/S [f] [def: graffiti artist] [note: V]
	grafe'm/N [m?] [def: grapheme, letter (linguistics)] % D-H Katz
grafintshik/Ees [m] [def: carafe]
grager/V/T greger/V/T [def: rattle] /Gon
	tsegrager/V/Btsegragert [def: rattle; make a commotion]
	tsegreger/V/Btsegregert [def: bother with noise]
	fargreger/V/Bfargregert [def: deafen]
	grager/S [m] greger/S [m] [def: noisemaker; rattle; penis (body part) (slang)]
	grageray'/N [f] [def: rattling]
gralnye/S [f] guralnye/S [f] gozhelnye/S [def: distillery]
	gozhelnik/Ees [def: brewer, distiller]
gram/N [m] [def: gram]
gram/V/T [def: rhyme] /Gtsunoyf
	gram/N [m] [def: rhyme] gramer/S [m] [def: rhymer, poet]
	shtram-gram [m?] [def: children's game]
gramofo'n/N [m] [def: gramophone, phonograph]
	/Dgramofond [def: rampion bellflower (Campanula rapunculus)]
gramatik/Ees [f] [def: grammar] gramatish/A [def: grammatical] 
	gramatiker/S [m] [def: grammarian] 
	gramatikalish/A [def: grammatical]
	gra'motne/A [def: literate; educated] 
		bezgramotne/A [def: illiterate] [usage: not recommended]
grana't/N/Ees [m] [def: grenade (weapon)] 
grana't/A [def: deep blue] % Stutchkoff
	/In % Forwards: M-S Hoffman
grandye'z/A [def: pompous; enormous]
granit [m] [def: granite] 
grasi'r/V/Bgrasi'rt [def: rule with an iron hand; have the upper hand] 
gra'shitse/S [f] [def: sweetbread (food); thymus]
grate/S [f] krate/S [f] krat/N [m] [def: grate (on a window); rack (of an oven)] 
	fargratet/A farkratet/A farkratevet/A [def: grated]
gratsh/N [m] [def: hot-headed person] 
	oysgegratshet/A [def: bulging (eyes)] 
	gratshke/S [f] [def: ratrace] 
gratsye [f] [def: elegance, grace]
	gratsye'z/A [def: gracious] 
gratuli'r/V/Bgratuli'rt [def: congratulate] % Harduf 
gravi'r/V/Bgravi'rt /Gayn [def: engrave] 
gravitatsye [f] gravite't [m?] [def: gravity (physics)]
	gravitatsyone'l/A [def: gravitational]
grayf/V/Bgegrifn [def: grasp]
	/Gon [def: attack, assault; tackle] 
	ongrayf/N [m] ongrayfung/N [f] ongrif/N [m] [def: attack, assault]
	bagrayf/V/Bbagrifn [def: grasp]
		umbagrayflekh/A [def: unbelievable, amazing]
	bagrif/N [f] [def: concept] /Iik [def: conceptual]
graylekh/A [def: most certain; unusual, remarkable] graylik/A
graytser/S [m?] [def: corkscrew; groshen (Austrian/German currency)]
grayz/N [m] [def: mistake, error]
	fargray'z/V/Bfargray'zt [def: err, make a mistake]
		fargrayzung/N [f] [def: error] % Stutchkoff
		fargrayzer/S [m] fargray'zerin/S [m] [def: culprit, offender]
	ti'pograyz/N [m] [def: typographic error] % Mine-Lifshe Viswanath
grende/S [f] [def: ceremony]
	[idiom: firn di grende = have no care in the world]
grenets/V/T [def: border on] /Gop
	fargrenets/V/Bfargrenetst [def: delimit]
	bagrenets/V/Bbagrenetst [def: limit]
		bagrenetsung/N [f] [def: limitation]
	grenets/N [m/f] [def: border; boundary]
		landgrenets/N [m] [def: border (country)]
grek/N [m] [def: bun (hair)]
grepts/V/T [def: burp, belch] /Garoys
	grepts/N [m]
gret [n] [def: laundry, clothes and linens to be washed] % no plural
greykh/V/T [def: reach]
	dergreykh/V/T [def: reach; achieve]
	dergreykhung/N [f] [def: reaching; goal; achievement]
	oy'gngreykh [m] [def: sight]
		[idiom: in oygngreykh = in sight]
		[idiom: mikhuts{mHwc} dem oygngreykh = out of sight]
	oy'ergreykh [m] [def: earshot] [usage: neologism]
greyt/V/T [def: prepare] /Gtsu/Gon
	fargreyt/V/Bfargreyt [def: prepare]
	greyt/A [def: ready]
	greytkayt/N [f] [def: readiness] % Harduf 
	tsugreytung/N [f] [def: preparation]
	tsugreyter/S [m] [def: pioneer]
	[idiom: esn fun greytn = eat food others have prepared (sign of wealth)]
grif/N [m] [def: vulture] % Harduf 
grike [f] [def: buckwheat (plant, Fagopyrum esculentum)]
gril/N [f] [def: cricket]
	grilts/V/T gril/V/T [def: chirp; grate, make an unpleasant sound]
	griltsik/A [def: harsh, grating (sound)]
grim/N [m] [def: actor's make-up] 
	grimi'r/V/Bgrimi'rt [def: apply make up] 
	fargrimi'r/V/Bfargrimi'rt [def: make up]
grimase/Xgrimasn [f] [def: grimace] 
grime/V/T [def: burn] 
	gri'menish [n] [def: colic (disease)] 
	grimik/A [def: burning] 
grin/A /Ilekh /Iink [def: green; inexperienced, naive]
	grinkayt/N [f] [def: green quality] 
	grinerheyt [adv] [def: while still green] % Sholem Aleykhem
	grins/N [n] [def: greens (vegetables)]
	grin/V/T [def: become green; be green] /Goys [def: become experienced]
	fargrint/A [def: made green]
	goldgrin/A [def: golden green] % Chava Rozenfarb: Botshani
grind/V/T [def: found]
	gegrindet/A [def: founded] % alternative spelling
	grinder/S [m] gri'nderin/S [f] [def: founder]
		mitgrinder/S [m] mitgri'nderin/S [f] [def: co-founder]
	grindung/N [f] [def: founding] 
	fargrind/V/Bfargrindet [def: found]
	bagrind/V/Bbagrindet [def: prove, substantiate] 
		umbagrindet/A [def: unfounded, unproven, unsubstantiated]
gring/K [def: easy; light; frivolous]
	fargringer/V/Bfargringert [def: ease; facilitate]
	otem-fargringerer/S [def: decongestant] [note: V]
gripe/S [f] [def: grippe, influenza (disease)] 
gris/V/T [def: greet]
	bagris/V/Bbagrist [def: greet] bagrisung/N [f] [def: greeting]
		hoyptbagriser/S [m] [def: host (of a lecturer)]
	gris/N [m] [def: regards] grus/N [m] bagrus/N [m] [def: greeting]
griske/S [f] [def: black peasant bread; a children's game with rolled bread scraps] % Forwards: M-S Hoffman
	/D [def: piece of bread]
grits [f] [def: grain porridge] gritsye [f] gretsye [f] 
	ho'bergrits [m] [def: oatmeal]
	manegrits [f] [def: farina]
	perlgrits [f] [def: barley porridge]
grive/S [f] gzhive/S [f] [def: mane (horse); bangs]
grivn/A grivenes [def: rendered poultry fat]
grivne/S [f?] [def: silver coin (15 kopeks?) (Russian currency)] % Sholem Aleykhem: Khanuke Gelt
grizhe/V/T [def: gnaw] /Gop/Garop
grizote [def: sorrow]
gro/A [def: gray] groy/A grov/A /Ilekh
	[idiom: blay gro = livid]
grob/A/Kgreb [def: thick; rude, coarse (Russian грубый); vulgar, obscene; uncouth; tacky]
	/Ilekh [def: coarse]
	grobyan/N [m] grubyan/N [m] [def: uncouth person] 
	grobkayt/N [f] [def: coarseness; rudeness]
	fargrebt/A [def: coarsened] 
		fargrebtkayt/N [f] [def: coarseness, rudeness]
	greb/N [f] [def: thickness] 
	[idiom: vern greber/breyter vi lenger = swell with pride (from family)]
grob/V/Bgegrobn [def: dig] /Garayn/Gayn/Gon/Gop/Garum
	/Gunter [def: slander]
	/Goyf/Goys/Garoys [def: unearth, excavate] 
		oysgrobung/N [f] [def: excavation] 
	bagrob/V/Bbagrobn [def: bury]
		bagreber/S [m] [def: undertaker; grave-digger] 
		bagre'benish/N [n] [def: burial]
	fargrob/V/Bfargrobn [def: bury]
	dergrob/V/Bdergrobn [def: dig]
	greber/S [m] [def: digger] 
	untergrober/S [m] [def: slnderer]
	[idiom: do ligt der hunt bagrobn = there's the rub]
grod/A [def: exact, even, straight] grod [adv] [def: precisely; just] 
grokhvine/S grokhovine/S [f] [def: pea straw (Russian горох, Polish groch)]
gromadne/A [def: massive (Polish gromad "clusters")] % Forwards: M-S Hoffman
gros/X [m] [def: a gross]
gro'seri [m] [def: grocery store (American)]
	gro'ser [m] [def: grocer (American)]
	gro'seri-leydi [f] [def: grocer (American)]
groshn/X/S [m] [def: groshen coin (currency, 30 to a zloty]
	gro'shedik/A [def: money-centered]
	gro'shnvayz [adv] [def: groshen by groshen] % Sholem Asch: Motke Ganef
	[idiom: nit hobn keyn groshn = impoverished]
	[idiom: nit vert keyn groshn = worthless]
grotesk/A [def: grotesque]
groy/A [def: gray] grinlekhgroy/A [def: green-gray]
	groyink/A [def: person with gray hair]
	fargroyt/A [def: graying]
groyl/N [m] [def: terror, horror, shudder] /Iik/Iekh [def: horrible, hideous]
	groyl/V/T [def: be horrifying]
groyp/N [f] [def: grain of cereal; cereal; barley; pellet]
	/Dgrayp [n] [def: pellet; granule; dry cereal] 
	-/Xhobergroypn [f] [def: oatmeal]
	-/Xmanegroypn [f] [def: farina]
	-/Xperlgroypn [f] [def: barley] 
	[idiom: farshitn di grayplekh = spill the beans = reveal a secret] % Hoffman
groys/Kgres [def: large]
	groys [f] [def: size] groyskayt/N [f] [def: greatness]
	fargreser/V/Bfargresert [def: enlarge]
		fargreserung/N [f] [def: enlargement] 
	greys/V/T [def: behave importantly (with "zikh")]
	[idiom: azoy groys azoy kleyn vi = neither more nor less than]
	[idiom: haltn zikh groys = gloat, brag, boast]
	greys [f] [def: size, dimension]
groyzam/A [def: cruel] groyzamkayt/N [f] [def: cruelty]
groz/N/Xgrezer [n] [def: grass] /Iik /Dgrez
	federgroz/N/Xfedergrezer [n] [def: fern] 
	ki'mlgroz [n] [def: fennel (plant)]
	lonkegroz/N/Xlonkegrezer [n] [def: meadow grass] 
	vildgroz/N/Xvildgrezer [n] [def: weed] 
	groz/V/T /Garoys [def: sprout forth]
	grezl//V/T [def: become grassy (with "zikh")] % Opatoshu: Polishe Velder
grozhe/V/T [def: threaten (with "mit a finger")]
grub/N [f] grubn/S [def: mine] 
	zaltsgrub/N [m/f] [def: saltmine]
grub/Xgriber [m/f] /Dgrib [def: pit; dungeon; grave]
	gribldik/A [def: pit-like]
	keslgrub/Xkeslgriber [m/f] [def: whirlwind; eddy] % in voser keslgrub zey zaynen arayngedreyt
	shmaltsgrub [m/f] [def: lap of luxury]
	shlosgrub/Xshlosgriber [m/f] [def: moat] [note: V]
	vasergrub/Xvasergriber [m/f] [def: moat] [note: V]
	/Dkheyn{Hn}-grib [def: dimple] 
	gribl/V/T [def: dig; search thoroughly, probe] /Garayn
		dergribl/V/Bdergriblt [def: manage to find]
		gribe/S [n] [def: piece of snot] [note: V] 
		gri'blenish/N [n] [def: probing]
		[idiom: griblen di noz = pick the nose]
grude/S rude/S hrude/S [def: dry ridge of earth]
grunt/N [m] [def: ground; foundation; reason]
	gruntik/K grintlekh/K gruntovne/A [def: attentive; fundamental, basic; thorough] 
	hintergrunt/N [m] [def: background]
	opgrunt/N [m] [def: abyss, cliff]
	untergrunt/N [m] [def: underground]
	yam_grunt{ym-grunt}/N [m] [def: ocean bed]
	[idiom: geyn tsu grunt = go astray]
	[idiom: mit a grunt = deeply, completely] % Avrom Karpinovitsh
	grunti'r/V/Bgrunti'rt gru'nteve/V/T [def: lay a foundation; fathom (with "zikh")] 
	dergru'nteve/V/Bdergru'ntevet [def: achieve (with "zikh tsu" or "biz")] 
grupe/S [f] grup/N [f] [def: group]
	grupke/S [f] [def: small group]
	grupi'r/V/Bgrupir't [def: group] % Harduf 
	grupirung/N [f] [def: grouping] 
	grupesvayz [adv] [def: in groups]
	shpilgrupe/S [f] [def: playgroup (children's)] % Forwards: S-R Schaechter
	u'ntergru'pe/S [f] [def: subcategory]
gruz [m] [def: load, cargo, gravel, rubbish] 
	gru'zeve/V/T gruze/V/T [def: carry a load; load up; embark] /Garayn
gruzne/S [f] [def: bog] 
gubernator/N [m] [def: governor]
	vitsegubernator/N [m] [def: vice-governor]
	governor/S [m] [def: governor (American)]
	gubernye/S [f] [def: state-level administrative district (Russian)]
	guberna'l/A [def: state-level (political)] % Forwards: Khariton Berman
	[idiom: shteln a gubernator = administer a beating] % Stutchkoff
	guvernantke/S [f] gubernantke/S [f] nyanye/S [f] nyanke/S [f] gubernantin/S [f] [def: babysitter, nanny, governess]
		nyantshe/V/T [def: babysit]
guf{gwf}/Xgufem{gwfym}/Xgufemlekh{gwfymlekh}/H [def: body] /Ilekh /Iik /D
	gufe{gwf#}/H [def: to the point, itself]
	gufniyes{gwfnywT}/H [def: physicality]
	da'rgufik{dargwfik}/A [def: thin]
	bal_aguf{bel-hgwf} [m] [def: fat person]
gula'yeve/V/Bgula'yevet [def: stroll (Slavic)] 
gume [f] [def: rubber] /In [def: rubber; elastic] gumi [f]
	/Dgume [def: rubber washer (device)] % Djigan
	gumke/S [f] [def: rubber eraser; droshky (vehicle)]
	kay'gume [f] kay'gumi [f] [def: chewing gum]
gumen/S [def: palate, roof of mouth]
gurt/V/T [def: gird; girdle] /Gon [grammar: requires "on"] 
	ongurt/N [m] [def: sash; girdle] % Bashevis
gust/N [m] [def: liking, taste] 
	[idiom: nokh emetsns gust = according to someone's taste]
gut/Kbes [def: good; thoroughly] /Iink
	aldosgut|s [def: the best] ambestn
	gut|skayt/N [f] gutkayt/N [f] [def: goodness]
	umgut/N [def: evil]
	gut/Xgiter [n] [def: property; possession; estate]
	beser/V/T [def: improve]
		/Goys [def: correct]
		farbeser/V/Bfarbesert [def: improve]
		beserung/N [f] farbeserung/N [f] [def: improvement]
		oysbeserung/N [f] [def: repair; correction]
	fargitik/V/Bfargitikt [def: upgrade; compensate] 
		fargitikung/N [f] [def: compensation] 
	nisht-gu't/A nit-gu't/A [def: evil] nisht-gu't [adj predicative] [def: nauseous]
	[idiom: ver mir guts gint = may you be blessed] % sic: Stutchkoff, Hoffman
guzme{gwzm#}/Xguzmes{gwzmowT}/Xguzmes_{gwzmwT}/H [f] [def: exaggeration] /Idik
	megazem{mgzm}/H [verb] [def: exaggerate (with "zayn")]
gvakamole/S [f] [def: guacamole (food)] % Forwards: Hershl Glaser
gvardye/S [f] [def: guard] gvardeyish/A
gvul{gBwl}/H/N [m] [def: border]
	gegvu'l{gegBwl}/N [m] [def: domain, realm] [usage: neologism]
gzims/N gezi'ms/N [m] [def: cornice, ledge; shelf]
	kamengzi'ms/N koymengzi'ms/N [m] [def: mantlepiece]
	tirgezi'ms/N [def: top of doorpost]
ha [interj] [def: ha! expression of surprise]
ha/Een [m] [def: the letter H] 
habore{hbrh}/Xhabores{hbrwT} [f] [def: syllable]
habe{hb#}/H haboem{hb#ym}/H [adj] [def: to come]
/Dha'des{hds} [n] [def: spice box]
hadibres{hdbrwT}/H [def: the words or commandments]
hadke/A [def: foul, loathsome]
hadloke{hdlk|h}/H [f] [def: candle lighting]
-/Xhadn -/Xhaydn [def: buckwheat porridge]
hafnyum [m] [def: hafnium (Hf)] 
hafsoke{hfsk|h}/Xhafsokes{hfskwT}/H [def: intermission]
haft/N [f] [def: coherence; substance] /Iik [def: coherent, substantial, tenable] 
	ha'ftikayt/N [f] [def: persistence, cohesion] 
	gevisnhaftik/A [def: intellectually substantial] 
	masnhaftik/A [def: substantial] [usage: not recommended]
	[idiom: nit hobn keyn haft = be insubstantial]
haft/N [m] [def: embroidery]
hagam{hgm}/H [conj] [def: although]
hagode{hgdh}/Xhagodes{hgdwT}/H [f] [def: Passover Haggadah] 
	agode{agdh}/Xagodes{agdwT} [def: Rabbinic legend]
	aga'dete{agdW#}/Xagadetes{agdWwT} [def: Rabbinic legends] 
hak/V/T [def: cut, chop; knock, bang; chatter]
	/Garayn/Garoys/Gayn/Gop/Goys/Gunter/Gtsu/Garop/Gon
	/Giber [def: interrupt, cut short]
	/Goys [def: fashion, form]
	farhak/V/Bfarhakt [def: chop; come to a standstill (with "zikh")]
		farhak/N [m] [def: standoff] % Yiddish League
	tsehak/V/Btsehakt [def: chop]
	hak/Xhek [f] [def: hatchet; axe] /Dhek [def: hatchet] 
	holts|haker/S [m] holts|heker/S [m] [def: woodcutter]
	heker/S [m] [def: butcher, flayer] % Sholem Asch: Motke Ganef
	haker/S [m] [def: (stone-) cutter]
hake/S [f] [def: hook] % Chava Rozenfarb: Botshani
	hakn/S [m?] hatshik/Ees [m] [def: hook]
hakhlote{hHlth}/Xhakhlotes{hHltwT}/H [f] [def: decision] 
hakhnoe{hxneh}/H [def: submissiveness] /Idik
hakhnose{hxns|h}/Xhakhnoses{hxnswT}/H [def: income; provision]
	hakhnosas{hxnsT}/H [def: provision for]
	makhnis{mxnys}/H [def: hospitable (with "- orkhem")]
hakhome{hHmh}/H [f] [def: the sun]
hakhone{hxnh}/Xhakhones{hxnwT}/H [f] [def: preparation]
	mukhen{mwxn}/H [def: prepared]
hakkhoshe{hKHSh}/Xhakkhoshes{hKHSwT} [f] [def: denial; retraction, disavowal]
hakl{hKl}/H [def: of all]
hakofe{hkfh}/Xhakofes{hkfwT}/H [f] [def: Torah procession; circumambulation] 
halb/A [def: half] onderthalbn onderhalbn [def: 1.5]
	finfhalbn [def: 5.5] zekshalbn [def: 6.5] zibnhalbn [def: 7.5]
	akhthalbn [def: 8.5] naynhalbn [def: 9.5]
	helft/N [f] [def: half]
haldz/Xheldzer [m] [def: neck] /Iik
	/Dheldz [def: neck (poultry or bottle)]
		roytheldzl/Eekh [def: robin (bird)]
	haldz/V/T [def: embrace (with "zikh")] /Garum
		haldzung/N [f] [def: embrace] 
	[idiom: es krikht fun haldz aroys = it's unbearably repetitive]
	[idiom: du megst zikh shemen in dayn vaytn haldz arayn = you should be ashamed of yourself]
	[idiom: treyfener haldz = glutton]
hale/S [f] [def: market (covered)]
ha'leshke/S ho'leptse/S [def: stuffed cabbage (food)]
	-/Xho'luptses -/Xho'lishkes [def: stuffed cabbage (food)] % only in plural
	-/Xhalkes -/Xalkes [def: potato and wheat dumpling (food) (Ukrainian галка)]
halevay{hlva|y}/H [def: if only!, would that!; hopefully]
halibo't/N [m] [def: halibut (fish)] % Michael Wex
halke/S [f] [def: petticoat (clothing)]
halo [interj] [def: hello!] 
halogen/S [m] [def: halogen (chemistry)]
halokhe{hlxh}/Xhalokhes{hlxwT} [f] [def: religious law]
	halokhish{hlxhsh}/A [def: according to religious law]
	hilkhas{hylxT}/Xhilkhes{hylxwT}/H [f] [def: religious law of]
halt/V/Bgehaltn [def: hold, contain; think; keep; stop (imperative)]
	/Gtsu/Gadurkh/Gfest/Gon/Goyf/Goys/Gtsurik/Gavek/Gafer
	/Goys [def: survive; sustain; succeed]
	/Gayn [def: restrain] 
	/Gop [def: abstain; restrain] 
	/Gmit [def: keep up (with); side (with); be equal (to)]
	/Gfor/Gfir [def: reproach]
	/Gunter [def: support]
	haltung/N [f] [def: posture; attitude] % Harduf
	oys|halt [m] [def: sustenance] % Der Nister
	oys|haltevdik/A [def: robust] 
	anthalt/N [m] [def: contents (German)]
	bahalt/V/Bbahaltn [def: hide; bury (euphamism)] /Goys
		bahaltung/N [f] [def: hiding]
			-/Xbahe'lterlekh -/Xbahe'ltelekh [def: hide-and-go-seek (game)]
		farbahalt/V/Bfarbahaltn [def: hide] 
		baheltenerheyt [adv] [def: in secret] % Forwards
	bahe'ltenish/N [n] [def: hiding place; hide-and-seek (game)]
		/Dbahalter [def: hiding place]
	derhalt/V/Bderhaltn [def: acquire; receive; preserve]
	geha'lt/N [n] [def: salary, pay]
	farhalt/V/Bfarhaltn [def: hide; delay, detain]
		farhaltenerheyt [adv] [def: hidden; delayed, detained] 
		[idiom: bashteln farhaltenerheyt = back order] [note: V]
		falha'lt/N [m] [def: tackle (play in American football)] [note: V]
			falhalter/N [m] [def: tackle (player in American football)] [note: V]
	inhalt/N [m] [def: contents]
		 in'haltraykh/K [def: compendious]
	ayngehaltnkayt/N [f] [def: restraint, reserve] % Der Nister
	oysgehaltnkayt/N [f] [def: survival]
		nitoysgehaltnkayt [f] [def: extinction]
	tsurikgehaltnkayt/N [f] [def: reserve, restraint; introverted nature] [usage: not recommended] % Sholem Asch: Ist River; J. Opatoshu: lintsheray
	onhalt/N [m] [def: grasp] onha'ltenish/N [n] [def: ??]
		onhaltung/N [f] [def: persistence; point of support]
	ophalt/N [m] [def: restraint; obstruction; delay; constraint]
		ophaltung/N [def: abstention] 
		ophaltenish/N [def: barrier]
	halter/S [m] [def: container, holder; base, stand; grip; penholder]
		bukhhalter/S [m] [def: book-end, accountant, bookkeeper] /Iish
			bukhhalterye/S [f] [def: account, bookkeeping]
		groy's|halter/S [m] [def: egoist; braggart] /Iish groysh|a'lterin/S [f]
			groys|halteray'/N [n] [def: ego; bragging]
		malbushem{mlbwSym}-halter/S [m] [def: clothes chest] % Esther Kraytman: Briliantn
	[idiom: haltn fun epes = believe in something]
	[idiom: haltn in eyn (+ infinitive) = do nothing but (+verb)]
	[idiom: haltn bay (+ infinitive) = be about to (+verb)]
	[idiom: nisht oystsuhaltn = outrageous]
halutsinatsye/S [f] [def: hallucination] % Forwards: Yoel Matveyev
halva [f] [def: Halvah (food)] % Forwards: S-R Schaechter
halvoe{hlv#h}/Xhalvoes{hlv#wT}/H [f] [def: loan]
ham [m] [def: food (baby talk)] hamenyu [m]
	ham/V/T [def: eat (baby talk)]
hamer/S [m] [def: hammer] /Dhemer
	hamer/V/T [def: hammer out] /Gdurkh
	farhamer/V/Bfarhamert farhermer/V/Bfarhemert [def: hammer shut]
hametne/A [def: hard; heavy, crude]
ha'meve/V/T [def: restrain, check, brake; steal from the boss (sherer-loshn)] /Gayn
hamoy'n{hmwn}/Xhamoy'nem{hmwnym}/Xen/H [def: crowd; rabble]
hamtsoe{hmc#h}/Xhamtsoes{hmcowT} [f] /D [def: creative idea; joke, trick]
handl/V/T [def: trade, buy and sell; act]
	/Gayn/Giber/Gop/Gunter/Goys
	bahandl/V/Bbahandlt [def: treat]
		bahandlung/N [f] [def: treatment] 
		[idiom: nit tsum bahandlen = unwieldy, awkward]
	farhandl/V/Bfarhandlt [def: buy and sell]
	unterhandler/S [def: agent, go-between] 
	handl/N [m] [def: commerce; store (with noun indicating merchandise)]
		/Ish [def: commercial]
		[idiom: sforem{sfrym} handl = bookstore]
		ga'snhandl [m] [def: street trade] 
		vay'nhandl/N [m] [def: wine trade; wine shop; wine storehouse]
		ve'lthandl [m] [def: world trade]
	handls- [prefix] [def: pertaining to trade] 
	handlung/N [f] [def: action] 
		bukhhandlung/N [f] [def: bookstore]
		farhandlung/N [f] [def: negotiation] 
		ophandlung/N [f] [def: treatise, discourse]
		unterhandlung/N [f] [def: secret handling]
	hendler/S [m] [def: merchant] /Iish
		bukhhendler/S [m] [def: bookseller]
		ferdhendler/S [m] [def: horse trader]
		fishhendler/S [m] [def: fishmonger]
		dorfs|hendler/S [m] [def: small-town merchant]
		gasnhendler/S [m] [def: street seller] 
		oksnhender/S [m] [def: ox trader]
	kleynhendl [def: small goods]
		kleynhendler/S [m] [def: small-good dealer]
handzye/S [f] [def: doll (plaything)]
	[idiom: geshleyerte handzye = voguish woman]
hanhole{hnhlh}/Xhanholes{hnhlwT} [f] [def: leadership, governing board (school or yeshiva)]
	menahel{mnhl}/Xmenalem{mnhlym}/H [m] menaheles{mnhlT} [f] [def: director (school or yeshiva)] 
hanoe{hn#h}/Xhanoes{hnowT}/H [f] [def: pleasure, enjoyment] /Idik
	hanoedikayt{hnohdikayt}/N [f] [def: pleasure] 
	nehene{nhnh} [verb] [def: enjoy (with "zayn")]
hanokhe{hnHh}/Xhanokhes{hnHwT}/H [def: setting down; discount (price); premise]
hant/Xhent [f] [def: hand] /Dhent [def: little hand; handle] 
	hantik/A [def: handy, convenient]
	alerhant [adj] [def: all sorts of]
	eyberhant/Xeyberhent [f] forhant/Xforhent [def: superior position; dominance] 
		[idiom: krign di eyberhant iber = get the advantage over]
	groys|hantik/A [def: generous]
	ophentik/K [def: helpless; discouraged] 
		o'phentikayt/N [f] [def: helplessness; dependence]
	hentshke/S/D [f] [def: glove]
	kikh-ha'ntsherke/S [f] [def: kitchen rag] % Forwards: Boris Sandler
	shtoys-hentl/Eekh [n] [def: plunger (of syringe)]
	tirhentl/Eekh [n] [def: door handle]
	[idiom: trogn emetsn oyf di hent = treat someone with special honor]
	[idiom: derlangen emetsn di hant = shake hands with someone]
	[idiom: nisht in emetsns hant = out of one's control]
	[idiom: bay emetsn in di hent = at one's mercy]
	[idiom: fun der ershter hant = hands-on experience]
	[idiom: leygn a hant oyf zikh = commit suicide]
hantshirke/S [def: rag]
hapokhes{hpHwT}/H [def: the least]
	lekhol_hapokhes{lxl-hpHwT} [adv] [def: at least]
harb/K [def: stringent; harsh; difficult] /Ilekh
	harbkayt/N [f] [def: tingling, stinging]
ha'rberik/Ees [m?] [def: tavern, inn; shelter]
	huraga'n-ha'rberik/N [m] [def: hurricane shelter] % Yiddish League
harbst/N [m] [def: Autumn (season)] /Iik
	shpetharbst [m] [def: late Autumn (season)]
harem/S [m] [def: harem] % Harduf, Bashevis, Avrom Karpinovitsh
harf/N [f/m] harfe/S [f] [def: harp (musical instrument)]
harge{hrge}/Vhargenen{hrgenen}/T [def: beat, strike] /Goys/Gavek
	derharge{derhrge}/Vderhargenen{derhrgenen}/Bderharget{derhrget} [def: murder; kill]
	farharge{farhrge}/Vfarhargenen{farhrgenen}/Bfarharget{derhrget} [def: murder; kill]
	tseharge{tsehrge}/Vtsehargenen{tsehrgenen}/Btseharget{tsehrget} [def: murder; kill]
	hoyreg{hwrg}/V/T [def: beat up] % Stutchkoff
	harige{hrygh}/Xhariges{hrygwT}/H [f] [def: slaughter]
	harug{hrwg}/Xharugem{hrwgym}/H [m] [def: victim of slaughter]
	nereg{nhrg} [verb] [def: be murdered (with "vern")]
	[idiom: harge{hrge} mikh ikh zol + infinitive = I couldn't possibly + verb]
harike/V/T /Gon [def: ??] % ongedungen zikh un ongehareket zikh gut
harmat/N [m] [def: cannon (weapon)] /D
	harmatnik/Ees [m] [def: cannoneer]
harmider [def: noisy gathering]
harmonye/S [f] [def: harmony; accordion (musical instrument)]
	harmonish/A [def: harmonious; harmonic (mathematics)] 
	harmonyum/S [m] [def: accordion (musical instrument)]
	filharmonye/S [f] [def: concert hall]
	filharmonish/A [def: philharmonic]
	harmoni'r/V/Bharmoni'rt [def: harmonize]
harmoshke/S [f] harmo'nike/S [f] garmoshke/S [f] [def: harmonica] 
harpsikhord [m?] [def: harpsichord (musical instrument)]
hart/K [def: hard] /Ilekh
	ha'rteve/V/T [def: harden]
	farha'rteve/V/Bfarha'rtevet [def: harden; make sturdy] 
		[idiom: farhartevet kop = senile]
	hartkayt/N [f] [def: hardness] 
	[idiom: hart far = just before]
harts/N/Xhertser [n] [def: heart]
	/Iik [def: delightful] /Iedik [def: hearty; cordial]
	/Dherts [n] [def: heart]
	hartsenyu [def: dear heart]
	hartsloz/A [def: heartless] 
	hertslekh/A [def: hearty]
	eydlhartsik/A [def: noble-hearted]
	bahartst/A [def: strong, heroic; heartfelt; spicy]
	baremhartsik/A [def: merciful] baremhartsikayt/N [f] [def: mercy] 
	barmhartsik/A [def: merciful] barmhartsikayt/N [f] [def: mercy]
	breythartsik/A [def: generous] breythartsikayt/N [f] [def: generosity] 
	guthartsik/A [def: generous] guthartsikayt/N [f] [def: generosity]
	kalthartsik/A [def: cold-hearted, unfeeling]
	laykhthartsik/A [def: lighthearted] 
	libhartsik/A [def: amiable]
	rey'nhartsik/A o'fnhartsik/A [def: honest, in good faith]
		rey'nhartsikayt/N o'fnhartsikkayt/N [f] [def: honesty, good faith] 
	veykhhartsik/A [def: sympathetic]
	[idiom: tsum hartsn = agreeable]
	[idiom: shlogn (emetsn) tsum hartsn = disgust (someone)]
	[idiom: shmalts untern hartsn = extra weight around the waist]
	[idiom: ayngebakn in hartsn = beloved]
	[idiom: onnemen zikh mit harts = pluck up one's courage]
	[idiom: makhn zikh a harts = take heart]
	[idiom: oyfn nikhtikn hartsn = on an empty stomach]
	[idiom: trogn a harts oyf = resent, hate]
has/V/T [def: hate] heslekh/A [def: hateful; ugly]
	farhast/A [def: hated]
	haser/S [m] [def: hater]
	has [m] [def: hatred]
		eygnhas [m] [def: self-hatred] % Forwards: Yechiel Szeintuch
		zelbsthas [m] [def: self-hatred] % Forwards: M-S Hoffman
hashgokhe{hSgHh}/H [f] [def: supervision, control, custody, Providence]
	mashgiyekh{mSgyH}/Xmashgikhem{mSgyHym}/H [m] [def: Rabbinic supervisor] 
hashkofe{hSkfh}/Xhashkofes{hSkfwT} [def: (religious) view]
hashore{hSerh}/Xhashores{hSerwT}/H [f] [def: guess, hypothesis, assumption]
	/Idik
hashpoe{hSpeh}/Xhashpoes{hSpewT}/H [f] [def: influence] hashpoedik{hSpehdik}/K
	mashpie{mSpye}/H [verb] [def: influence (with "zayn")] /Idik [def: influential]
	mushpe{mwSpe}/H [def: be influenced (with "vern")]
hashtone{hSWnh}/H [f] [def: urine]
	mashtn{mSWyn} [verb] [def: urinate (with "zayn")]
hastik/A [def: hasty]
hasyum [m] [def: hassium (Hs)] 
havaye_{hevyh}/Xhavayes_{hevywT}/H [f] havaye/S [f] [def: grimace; gesture]
	havayele{hevyhle}/Ekh [n] [def: small gesture]
havdole{hBdlh}/Xhavdoles{hBdlwT}/H [f] [def: ceremony at end of Sabbath; havdole candle]
	havdil{hBdyl}/H [def: distinguish] lehavdil{lhBdyl} [interj] [def: to make a distinction]
	[idiom: lehavdil{lhBdyl} beelef{b#lf} havdoles{hBdlwT} = to make a large distinction]
have{hwh}/H [def: it was]
have/V/T [def: hustle]
	ha'venish [n] haven [m] [def: hustle, bustle; effort]
	farhavet/A [def: preoccupied]
havir/V/Bhavirt [def: woo, try to please (often with "zikh")]
havke/V/T [def: bark (sound of a dog)] /Gunter/Goys hafke/V/T
	tsehavke/V/Btsehavket [def: start barking (with "zikh")]
havn/S [m] [def: harbor]
	hafn/S [m] [def: harbor] [usage: inadmissible]
havore{hBrh}/Xhavores{hBrwT} [f] [def: Hebrew pronunciation]
havtokhe{hBtHh}/Xhavtokhes{hBtHwT}/H [f] [def: assurance]
haybam/N [f] [def: midwife]
hayda [interj] [def: lo and behold] 
haydamak/Ees [n] [def: haidamaka, Ukrainian paramilitary band]
haye/V/T [def: tarry, procrastinate (with "zikh")]
hayitokhn{hyWxn} [interj] [def: how can this be? (expression of surprise)]
haylik/A [def: causing the teeth to tingle]
hayne_hakh{haynw-hx} [adj predicative] [def: similar, equivalent]
haynt/Iik [def: today] haynt [adv] [def: now consider]
	derhayntik/V/Bderhayntikt [def: update, upgrade]
hayrat/V/T [def: marry (German)]
	farhayrat/V/Bfarhayrat [def: marry]
hayte/S [f] [def: walk (baby talk)]
	[idiom: geyn hayte = take a walk (baby talk)]
hayter/V/T [def: cheer] /Goyf [usage: deprecated]
	hayter/K [adv] [def: cheerful] [usage: deprecated]
haze{hz|h}/H [def: this] /Idik
	hazenik{hz|hnik}/Ees [m] [def: person involved in the present] 
he [interj] [def: what?]
hebreish/A [def: Hebrew] hebrei'zm/N [m] [def: Hebraism]
	hebrei'st/N [m] [def: Hebraist]
	hebreizi'r/V/Bhebreizi'rt [def: Hebraize]
	dehebreizi'r/V/Bdehebreizi'rt [def: de-Hebraize]
		dehebreizatsye/S [f] [def: de-Hebraization]
hedonistish/A [def: hedonistic, self-indulgent] % Forward: Yoel Matveyev
hedyet{hdywt}/Xhedyoytem{hdywtym} [m] [def: ordinary person; ignoramus]
hefker{hfkr}/H [adj] [def: ownerless; licentious] /Idik
	hefkeyres{hfkrwT}/H [def: ownerlessness; licentiousness; anarchy]
	mafker{mfkyr}/H [verb] [def: declare ownerless, act altruistically (with "zikh") (with "zayn")] 
heflekh/K [def: polite] he'flekhkayt/N [f] [def: politeness]
hefsed{hfsd}/Xhefseydem{hfsdym} [m] [def: loss, injury] 
heft/V/Bgehoftn [def: weave; stitch; embroider] /Gtsuzamen/Gtsunoyf % variant: /T
	/Goys [def: embroider]
	haft/V/Bgehaft /Garayn [def: fit in (with "zikh")] % Sholem Aleykhem
	baheft/V/Bbahoftn [def: weave; attach; have sexual intercourse with (with "zikh mit")]
		baheftung/N [f] [def: weaving; sexual intercourse]
	farheft/V/Bfarhoftn [def: darn; repair by weaving] % Der Nister
	gehe'ft/N [n] [def: farmyard, compound]
	shofgeheft/N [n] [def: sheep farm]
	heft/N [n] [def: notebook] /D
		notits|heft/N [n]
		shulheft/N [n] [def: school notebook]
		tsunoyfheft/N [n?] [def: combination]
	heftik/A [def: violent, fierce (German)]
heftling/N [m] [def: prisoner (German)]
hegemonye/S [f] [def: hegemony] 
hek/N [m?] [def: distant place, hick town]
	[idiom: fun ekn un hekn = from all sorts of places]
hekhsher{hxSr}/Xhekhsheyrem{hxSrym}/H [def: rabbinical permit; seal of kosher supervision]
hekht/X [m] [def: pike (fish); sucker, sap, gullible person] /D
hekl/V/T [def: crochet]
	/Gon [def: spear, snag]
	/Dhek [def: loop]
	tseheklt/A [def: unfastened] % Bashevis
heksago'n/N [m] [def: hexagon]
hel/A [def: bright; clear] /Iish
	hel/V/T [def: become light] /Goyf
	[idiom: in mitn heln tog = unexpectedly; in broad daylight]
held/N [m] hold/N [m] heldin/S [f] [def: hero]
	heldish/A [def: heroic]
	heldishkayt/N [f] [def: heroism]
	antiheld/N [m] [def: antihero]
	hoyptheld/N [m] [def: protagonist; hero]
	holt [adj predicative, undeclined] [def: to like (with "hobn")]
heleni'zm/N [m] [def: Hellenism] helenistish/A
helf/V/Bgeholfn [def: help] [grammar: takes dative]
	/Garoys/Goys/Gunter/Gmit/Gtsu 
	derhelf/V/Bderhelft [def: help]
	hilf/N/S [f] gehi'lf/N [m] [def: help; assistant]
		mithilf/N [f] [def: assistance]
		gehilf [adj] [def: assistant] % uninflected, as in "gehilf redaktor" 
		teykef{WyKf}-hilf/N/S [f] [def: quick help] 
	helfer/S [m] mithelfer/S [m] bahelfer/S [m] helferin/S [f] [def: helper, assistant; police spy (ganovem-loshn)]
	belfer/S [m] [def: assistant teacher (in a kheyder)] 
	helfik/A bahilfik/A hilfik/A [def: helpful]
	bahelf/V/Bbaholfn [def: help]
	umbaholfn/A [def: clumsy; helpless; wretched]
	umbaholfnkayt/N [f] [def: clumsiness; helplessness]
	hilfloz/A [def: helpless]
	[idiom: got helf = guthelf = good (early) afternoon] % Southern Yiddish
helfand/N [m] /D helfandkhe/S [f] [def: elephant]
	helfant/N [m] /D helfantkhe/S [f] [def: elephant] % variant
	elfand/N [m] [def: elephant] % variant
helikopter/S [m] [def: helicopter]
helm/N [def: helmet] shtolhelm/N [def: steel helmet]
	bahelmt/A [def: helmeted] 
helyotro'p [m?] [def: heliotrope (Heliotropium spp.)]
helyum [m] [def: helium (He)] 
hemung/N [f] [def: inhibition] [usage: not recommended]
hemd/Eer/D [n] [def: shirt (clothing)]
	meshugoyem{mSwge|ym}-hemd/Eer/D [n] [def: straitjacket] 
	eyberhemd/Eer [n] [def: overcoat]
	nakhthemd/Eer/D [n] [def: nightshirt (clothing)]
	unterhemd/Eer [n] unterhemdl/Eekh [def: ] [def: undershirt (clothing)]
	[idiom: nemen zi in eyn hemd = marry a wife without dowry]
hendum-pendum [adv] [def: in a rush, at full speed]
heng/V/Bgehangen [def: hang] 
	/Garoyf/Garoys/Garop/Garunter/Gon/Goys/Gariber/Giber/Goyf/Garum/Gop
	/Bgehongen /Gon % variant
	farhang/V/Bfarhangen [def: drape]
	bahang/V/Bbahangen [def: drape] 
	arophang/N [m] [def: cliff, slope] 
	forhang/N [m] firhang/N [m] [def: curtain] /Dforheng /Dfirheng
		/Dforheng % Bergelson
	tsuzamenhang/N [m] [def: connection] 
	/Dheng [def: bunch (of grapes)] % Harduf
	henker/S [m] [def: hangman] % Harduf
	[idiom: zikh onhengen on/in/oyf = tailgate] [note: V] 
	heng/V/T [def: hang] /Goys/Gop/Garoys/Gariber/Gfunander/Gon
		firheng/D [m] [def: drape]
		henger/S [m] [def: hanger] onhenger/S [m] [def: adherent, supporter]
			o'nhengershaft/N [f] [def: support; group of followers or supporters]
		/Dhenger [n] [def: stem (of fruit)] % Sholem Aleykhem
		ophengik/A [def: dependent]
			ophengikayt/N [f] [def: dependence]
		umophengik/A [def: independent]
			umophengikayt/N [f] [def: independence]
heore{herh}/Xheores{herwT}/H [def: footnote; note]
hepati't [m?] [def: hepatitis (disease)]
hepe/V/T [def: dance, spring] /Gon
her/V/T [def: hear, smell (with "zikh")]
	/Gon/Gtsu
	/Gunter [def: eavesdrop]
	/Gayn [def: pay attention] 
	/Goyf [def: stop, cease]
		[idiom: nisht oyfhern tsu = keep on ..ing]
	/Goys [def: listen;hear somebody out]
	derher/V/Bderhert [def: discover]
	farhe'r/V/Bfarhert [def: listen to a student recitation]
		durkhfarher/N [m] [def: cross-examination] % Harduf
		farherer/S [m] [def: examiner]
	tsuher/V/Btsugehert [def: listen (to) (with "zikh (tsu)")] 
	herung/N [f] [def: examination, audition; rumor, tiding]
	ontsuhe'renish/N aynhe'renish/N [n] [def: remark; news]
	tsuherer/S [m] [def: attentive listener]
	onherenish/N [n] [def: remark] % Forwards
	oyfher/N [def: stopping] umoyfherlekh/A [def: unstoppable]
	oys|her/N [def: hear]
		oys|herer/S [m] [def: listener] 
	unterher/N [m] [def: eavesdropping]
	umgehert/A [def: unheard]
	gehe'r [n] [def: hearing, sense of pitch]
		[idiom: shpiln loytn gehe'r = play by ear] [note: V]
	herevdik/A [def: able to hear] 
	ay'nherik/A [def: attentive] 
		umay'nherik/A [def: unattentive] % Berish Goldstein
	tsiherste [interj] her-nor [interj] [def: term of address to one's wife]
	he'rerl/Eekh derhe'rl/Eekh [def: hearing aid] % Yiddish League
	[idiom: makhn zikh nit herevdik = turn a deaf ear]
	[idiom: fregn vos se hert zikh = say hello]
her/N [m] [def: Mister; gentleman] % Harduf
	herlekh/A [def: lovely; glorious, marvelous]
	har/N [m] [def: master] ha'rinte/S [f] [def: master's wife]
		oy'berhar/N [m] [def: overlord; mastermind] % Sholem Aleykhem
	he'rsheve/V/T [def: rule despotically]
herb/N [m] [def: badge (of status)]
heref_ayen{hrf-e|yn}/S [m] [def: instant, split second]
	keheref_ayen{Khrf-e|yn} [adv] [def: in an instant, immediately, in a flash]
hering [m] [def: herring (fish)]
hermetish/A [def: hermetic; pressurized] 
hero/N /Iish [m] [def: hero (English)]
herpes [m?] [def: herpes (virus)] % Forwards
hersh/V/T [def: rule]
	bahersh/V/Bbahersht [def: dominate] bahersher/S [m] [def: master]
		bahershung/N [f] [def: domination] 
	hershung/N [f] [def: rule] 
		aleyn-hershung/N [f] zelbsthershung/N [f] [def: self-rule] 
	hersher/S [def: ruler] 
	her/N [m] [def: mister] hershaft/N [f] [def: mastery]
	har/N [m] [def: master (German)]
hertsog/N [m] [def: duke] % Harduf
hese/S [f] [def: sconce (light fixture)]
heshayne{hwSen#}/Xheshaynes{hwSenwT} [def: Hoshana prayer (on Sukkes)] 
	heshayne_rabo{hwSen#-rbh} [def: sixth day of Sukkes] 
	[idiom: shlogn heshaynes = beating the willow branches on hoyshayne-rabo]
	[idiom: opgeshlogene heshayne = object no longer useful, person no longer active]
heshe/V/T [def: sob]
	farheshet/A [def: breathless, sobbing] 
	heshedik/A [def: sobbing; whinnying] % Sholem Asch: Ist River
hespayles{hTpelwT}/H [n] [def: delight]
	nispoyel{nTpel}/H [adj predicative] [def: amazed]
	[idiom: kelberne hespayles{hTpelwT} = infatuation, foolish enthusiasm]
hesped{hspd}/Xhespeydem{hspdym}/H [m] [def: eulogy; funeral lament]
	masped{mspyd}/H [verb] [def: eulogize (with "zayn")]
het [adv] [def: far away (space or time)]
	[idiom: het a mol = a long time ago]
heter{hyWr}/Xheteyrem{hyWrym}/H [m] [def: Rabbinical permission]
	mater_{mWyr} [verb] [def: permit (with "zayn")]
hets/V/T [def: incite; bait (with "kegn")] /Goyf
	hetse/S [f] [def: incitement]
	hetser/S [m] [def: inciter] 
	oyfhetsung/N [f] [def: incitement] % Forwards
hetske/V/T [def: swindle, gull; mock; bounce, jump (with "zikh")] /Garop/Gunter
hevl-havolem{hBl-hBlym} [m?] [def: insignificance]
hey [n] [def: hay]
hey [interj] [def: hey!] 
heyb/V/Bgehoybn [def: raise, lift; exalt] /Goyf/Gunter/Garoyf/Gunter
	/Gon [def: begin]
		[idiom: es heybt zikh nit on un es lozt zikh nit oys = nonsense]
	/Garoys [def: emphasize]
	baheyb/V/Bbahoybn [def: understand; manage, be able to]
	farheyb/V/Bfarhoybn [def: raise]
	derheyb/V/Bderhoybn [def: elevate] derheybung/N [f] [def: elevation] 
	onheyb/N [m] [def: start] onheyber/S [m] [def: beginner]
		onheybekht|s/N [n] [def: start, beginning]
	hoypt/A [def: principal]
		bahoypt/V/Bbahoypt [def: claim, argue; confirm] [usage: inadmissible]
			bahoyptung/N [f] [def: claims, arguments] [usage: inadmissible]
	iberhoypt [adv] [def: mostly]
	derhoypt [adv] [def: especially]
	hipsh/A [def: much; large; many (with "- bisl" or "etlekhe" or "shtikl")] /Ilekh
heyd/N [m] [def: heathen] heydntum [n] [def: heathenism, paganism] 
heydamak/N [m] [def: highway robber]
heykhi{hyxy}/H [def: what is it like? (with "- dami")]
heykhl{hyxl}/Xheykholem{hyxlym}/Xheykholes{hyxlwT}/H [def: palace; temple] 
heyl/N [f] [def: cave, cavern]
heyl/V/T [def: heal, cure] /Goys
	farheyl/V/Bfarheylt [def: heal, cure] 
	heylung/N [f] [def: healing, cure]
	heyler/S [m] [def: healer] 
		alheyler [m] [def: heal-all (plant)] 
		gloybn-heyler/S [m] [def: faith healer] 
		gaystheyler/S [m] [def: spiritual healer] 
	heylbar/A [def: curable] [usage: not recommended]
		umheylbar/A [def: incurable] [usage: not recommended]
heylik/K [def: holy]
	heylikayt/N [f] heyliktum [n] [def: holiness]
	heyliker/Xheylike [m] [def: saint] 
	heylik/V/T [def: sanctify]
	farheylik/V/Bfarheylikt [def: sanctify]
heym/N [f] [def: home] /Iish /Iishlekh [def: comfortable; familiar]
	/Ilekh [def: cheerful] % Harduf
	heymlekhkayt/N [f] [def: comfort]
	heymishkayt/N [f] [def: feeling of being at home, cosiness] 
	farheymisht/A [def: made comfortable] % Forwards: B. Sandler
	aheym [adv] aheymet [adv] [def: homeward]
	togheym/N [f] [def: day-care center] 
	noyte_lomes{nwth-lmT}-heym/N [f] [def: hospice] [note: V]
	umheymlekh/A [def: weird, uncanny, sinister; uncomfortable in reaction to a sinister situation]
	heymloz/A [def: homeless]
heyn{hn} [conj correl] [def: both .. and (with "azoy")] 
heyoys{hywT}/H [def: given that]
heypekh{hypwx}/H [m] [def: opposite]
	heypekhdik{hypwxdik}/A [def: opposite]
	leheypekh{lhypwx} [adv] [def: on the contrary]
heyrat/N [m] [def: marriage] [usage: not recommended]
	farheyrat/A [def: married] [usage: deprecated]
heys/V/Bgeheysn [def: order, tell]
heys/V/Bgeheysn [def: be called, be named]
	/Ggut [def: ratify, authorize (German)] [usage: not in present tense or imperative]
		gut|heysung/N [f] [def: approval, authorization]
	vi-heyst-men-es [m] [def: buttocks]
	[idiom: heyst es = that is to say]
hey'sherik/N [m] [def: locust]
heyts/V/T [def: heat] /Gayn/Gon
	tseheyts/V/Btsehitst [def: heat]
	baheyts/V/Bbaheytst [def: heat] 
		heytsung/N [f] baheytsung/N [f] [def: heating] 
	heys/K [def: hot]
	hits/N [f] [def: heat; fever] /Iik heytsung/N [f] [def: heat]
		[idiom: redn fun hits = speak crazily]
		zumerhits/N [f] [def: heat of Summer]
	hits/V/T [def: heat up (with "zikh")] /Gdurkh/Gon
-/Xheyvn [def: yeast] heyvndik/A [def: yeasty]
heyzerik/A [def: hoarse] /Ilekh heyzerikayt/N [f] [def: hoarseness]
hi [def: here] hig/A [def: local; resident of this locality] /Iedik
hider{hydwr}/H [def: beautification]
	mehader{mhdr}/H [verb] [def: beautify (with "zayn")]
	mehuder{mhwdr} [m] [def: something splendid] /Idik [def: exquisite, choice]
	hadres{hdrT}-ponem{pnym} [m] [def: person of dignified appearance; beard]
		/Idik [def: stately, dignified]
	lemehadren_min-hamehadren{lmhdryn-mn-hmhdryn} [adv] [def: by strictest measure]
hidra'nt/N [m] [def: fire hydrant] 
hidroksid [def: hydroxide (OH; chemical)]
hidrotsefalye/S [f] [def: hydrocephalus (illness)] % Forwards: Boris Sandler
hift/N [f] [def: hip, haunch (body part)] % seldom in singular
higer/S [m] [def: local person]
	nit-higer/S [m] [def: foreigner]
higl/N [m?] [def: ?? a topographic feature] % Chava Rozenfarb: Botshani 
higyene [f] [def: hygiene] % Harduf
	higyenish/A [def: hygienic; sanitary]
hikori [m?] [def: hickory (tree)] % Forwards: Hershl Glaser
hil/V/T [def: surround; wrap] /Gayn/Garum/Goys
	hile/S [f] [def: wrapper]
	farhilt/A [def: wrapped]
	aynhilung/N [f] [def: wrapper] 
hilekh{hylwx}/H [def: journey]
hilke/S [f] [def: bat (sport)]
hilkh/V/T [def: make a loud noise, resound]
	/Gop [def: resound, echo]
	farhilkh/V/Bfarhilkht [def: deafen (with noise)] 
	hilkhik/A hilkhedik/A [def: loud, resounding]
		ophilkhik/A [def: resounding, echoing]
	krik|hilkh [m] [def: feedback (acoustic)] 
	hilkher/S [m] [def: loudspeaker (device)]
	ophilkh/N [m] [def: sound, noise]
hilule{hylwlh}/Xhilules{hlwlwT}/H [def: observation of the anniversary of a tsadik's death]
himen/S [m] [def: anthem] himne/S [f] [def: hymn]
himl/N [m] [def: sky; heaven] /Idik /Iish /Ish [def: heavenly; celestial]
	[idiom: himl efn zikh = all hell breaks loose]
hin ahin [def: there] ahintsu hinter hintn [def: behind] bizahin
	hintn/S [m] [def: back, rear] % Harduf
hind/N [f] [def: doe (animal)] 
hindus/N [m] [def: Hindu] /Iish hinduizm [m] [def: Hinduism]
hine/V/T hinye/V/T [def: stay, linger]
hiney{hny}/H [def: behold]
hink/V/T/Bgehunken [def: limp] /Gunter/Gtsu
	hinker/V/T [def: limp; move slowly]
	hinkedik/A [def: lame; limping] 
hinter/P [def: behind; outside (of town)]
	hintersht/A [def: rear]
		hintersht/A [def: rear-wheel (automotive)] [note: V]
	ahinter [adv] [def: behind]]
	hintervaylekhts [adv] [def: backward]
hipe/V/T /Giber/Gariber [def: skip]
	hiper/V/T /Giber [def: skip; limp] % variant
hiper- [prefix] [def: over, more]
hipnotizi'r/V/Bhipnotizi'rt [def: hypnotize]
	farhipnotizi'r/V/Bfarhipnotizi'rt [def: hypnotize]
	hipnoz [m] [def: hypnosis] % Harduf
	hipnotish/A [def: hypnotic]
hipo- [prefix] [def: under, less]
	hipotensye/S [f] [def: hypotension (illness)] % Forwards: Sholem Berger
hipokri't/N [m] [def: hypocrite] /Iish 
	hipokritstve{hipokrit|stve} [f] [def: hypocrisy] 
hipote'k/N [f] [def: mortgage] % Harduf
hipote'z/N/Ees [m] [def: hypothesis]
	hipotetish/A [def: hypothetical] % Harduf
hipsh/A [def: very; considerable]
hirher{hyrhwr}/Xhirhurem{hyrhwrym}/H [m] [def: (transient) thought; doubt; sexual thought] 
	-/Xhoyries{hwrywT} [def: dreams, daydreams; tractate of Talmud]
hiroglif/N [m?] [def: hieroglyph] % Forwards: S-R Schaechter
hirsh/N [m] [def: deer, stag, buck (animal)] /D
	hirshns [n] [def: venison]
hirt/N [m] [def: shepherd] [usage: not recommended]
hirzh [m] [def: millet] /D /In
hirzhe/V/T [def: neigh, whinny (sound of a horse)] /Gunter
	tzehirzhe/V/Btsehirzhet [def: neigh loudly (with "zikh")] % Der Nister
	hirzheray'/Een [f] [def: whinnying]
hislayves{hTlhBwT}/H/N [f] [def: enthusiasm] /Idik
hisnatsles{hTnclwT} [f] [def: apology]
hisoyreres{hTewrrwT}/H [f] [def: awakening (spiritual)]
hisroymemes{hTrwmmwT}/H [f] [def: exaltation (spiritual)]
histami'n [m] [def: histamine] 
	antihistami'n [m] [def: antihistamine] 
histerye/S [f] [def: hysteria] % Harduf
	histerish/A [def: hysterical]
	histerik/N [m] histerike/S [f] [def: histeria]
historye/S [f] [def: history; story]
	historish/A [def: historical (English)]
		historishkayt/N [f] [def: historicality] 
		farhistorish/A [def: prehistoric]
	histo'riker/S [m] histo'rikerin/S [f] [def: historian]
	historyografye/S [f] [def: historiography] % Forwards: Krutikov
	prehistorye/S [f] [def: prehistory] 
		prehistorish/A [def: prehistorical] 
hit/V/T [def: guard; watch]
	/Gayn
	/Goys [def: guard successfully]
	/Gop [def: keep, observe; guard against (with "zikh fun")]
	/Gtsu [def: protect] % Forwards: M-S Hoffman
	/Goyf [def: save (computer), store (computer)]
	/Bgehitn % variant participle 
		/Gop/Goys/Goyf
	farhit/V/Bfarhit [def: prevent] 
		farhitung/N [f] [def: prevention] 
	bahit/V/Bbahit [def: guard]
		[idiom: bahit un bavornt = on guard]
	derhit/V/Bderhitn [def: be preserved (with "zikh")] % Forwards: Hershl Glaser
	ophit/N [m] [def: care] ophiter/N [def: protector]
		[idiom: palyativ-ophit = palliative care] [note: V] 
		[idiom: linder-ophit = palliative care] [note: V] 
	hiter/S [m] hi'terin/S [f] [def: guard; guardian]
		laybhiter/S [m] [def: bodyguard] 
		ti'rhiter/S [m] [def: doorman]
	opgehitkayt/N [f] [def: care]
hitsel/Ees [m] hitsl/Ees [m] [def: dogcatcher; rascal] 
hitshke/S [f] [def: forelock; peasant; beet greens]
hob host hostu hot hobn/Idik gehat/A [def: have; give birth] % irregular
	ho'berin/S [f] [def: woman in childbirth]
	libhober/S [m] [def: lover]
	makhthober/S [m] [def: ruler] /Iish [def: sovereign]
	[idiom: zayt|s mir un hot|s mir = goodbye (comical)]
hober [m/n] [def: oat; oats] /In
hodene/S [f] [def: cucumber tendril (Ukrainian худина)] % Sholem Aleykhem (grins af shvues)
ho'deve/V/T [def: raise, rear; breed; cultivate; be nourished by (with "zikh oyf")] /Goyf/Gon/Goys
	hodivle [def: feed (for poultry)]
hof/V/T/Bgehofn [def: hope] hofloz/A [def: hopeless]
	farhof/V/Bfarhofn [def: hope] 
	hofenung/N [f] [def: hope] hoferdik/K [def: hopeful]
		ho'fenungsfu'l/A [def: hopeful, optimistic]
	hofntlekh [adv] [def: hopefully]
	[idiom: lomir hofn = hopefully]
hogl/V/T [def: hail] 
	hogl/N [m] [def: hail]
hok/N [m] [def: hook] % Harduf
hoki [m] [def: hockey (game)] % Harduf
holder/V/T [def: gobble (sound of a turkey)] 
holedrige/S [m] holedrigekhe/S [f]  holedranyets/Xholedrantses [m] [def: poor person]
holmyum [m] [def: holmium (Ho)]
holoblye/S [f] [def: side-harness on a horse; temple-pieces on eyeglasses]
holoveshke/S [f] holeveshke/S [f] [def: (fire) brand; cinder, remnants after a fire; cigar (humorous)] 
holts/Xheltser [n] [def: wood (material); block of wood]
	hiltsern/A [def: wooden]
	valgerholts/Xvalgerheltser [n] [def: rolling pin]
	krik|holts [n?] [def: crutch]
	pik|holts/N [m] [def: woodpecker (bird)]
		[idiom: shoyte{Swth} ben{bn} pik|holts = fool]
	farhiltser/V/Bfarhiltsert [def: make wooden]
	gehilts [n] [def: lumber; wooden material]
	brenholts [n] [def: firewood]
	te'nenholts [n] [def: spruce wood]
homofob/N [def: homophobe]
homoge'n/A [def: homogeneous]
honik [m] [def: honey]
	[idiom: lekn honik far emetsn = benefit from someone]
honer [m] honor [m] [def: honor; dignity]
	honori'r/V/Bhonori'rt [def: honor] % Forwards
	honora'r/N [m] [def: honorarium; royalties] 
	honoriste/A [def: sensitive, touchy (ironic)]
	[idiom: onrirn dem honor = offend]
hopke/V/T [def: hop] 
	hop [interj] [def: there I/you go!]
hopn [noun] [def: confetti; hops (plant: Humulus lupulus)] 
hoptsha [interj] [def: sound of a sneeze] % B. Kovner (Jacob Adler)
hor/X [f] [def: hair; mainspring] /Dhere /Dhore
	horik/A bahort/A [def: hairy; haired]
		kurts|horik/A [def: short-haired]
		roythorik/A [def: red-haired]
		shtroyhorik/A [def: blonde]
	shtraymlhor/X [f] [def: hair of a Chassidic fur hat]
	[idiom: biz a hor vi = exactly like]
horb/N [m] horbat/N [m] [def: hump] /A [def: humped; hinged]
	/Dhorbik [def: hook]
horde/S [f] [def: horde] 
hore/S [f] [def: hora (Israeli dance)] % Harduf
hore_{hre}/H [def: the evil]
	enore{e|yn-hre}/H [def: evil eye] 
	[idiom: keyn enore{e|yn-hre} = may there be no evil eye]
	kinehore kenaynehore [interj] [def: no evil eye (heteromalofugitive expression] 
	[idiom: loshen{lSwn} hore_{hre} = gossip]
ho'reve/V/T [def: work hard, toil] /Gop/Gon/Goys/Garayn/Giber/Gtsu
	horevanye/S [f] [def: hard work]
	farho'reve/V/Bfarho'revet [def: obtain through hard work]
	horepashne/A [def: hard-working]
	horepashnik/Ees [m] [def: toiler, worker]
horizont/N [m] [def: horizon]
horkh/V/T [def: notice; listen; obey] /Goys/Gtsu
	horkhzam/A [def: noticable] 
	gehorkhzam/A [def: obedient] % Harduf
	geho'rkhzamkayt/N [f] [def: obedience] % Forwards
horme/S [f] hurme/S [f] hurbe/S [f] [def: pile, heap]
hormo'n/N [m] [def: hormone] % Harduf
horn/Xherner [m] [def: horn, antler] 
	bahernert/A farhornt/A [def: horned] 
	nozhorn/S [def: rhinoceros (animal)] % Forwards: M-S Hoffman
	valdhorn/Xvaldherner [def: french horn (musical instrument)]
ho'rnitse/S [def: parlor (Ukranian горница "upper chamber")]
hote'l/N [m] [def: hotel]
hots [interj] [def: sound of hoofbeats] % Mendele
hotseplots [n] [def: mythical distant place] [note: in Austria, near Silesia]
	hotseklots [n] [def: mythical distant place]
	ayshishtok [def: arbitrary distant place]
	shni'pishok shni'peshik [def: distant place with a funny name] [note: Jewish section of Vilna]
	pralnik [def: mythical book (with "seyfer -")]
hotske/V/T [def: shake, bump (with "zikh")] 
	/Idik [def: shaky, bumpy] 
hoyb/N [f] [def: bonnet; mitre (clothing)] /Dhayb
hoyde/V/T [def: swing]
	 hoyde/S [f] hoydlke/S [f] [def: swing]
hoyer/V/T [def: hover; loom] /Garop
hoyf/N/Xheyf /Iik [m] [def: yard; court] /Dheyf [def: patio] 
	banhoyf [m] [def: train station]
	durkhhoyf/N [m] [def: passageway]
	shulef{shulhoyf}/N [m] [def: synagogue courtyard]
hoyfn/S [m] [def: pile, heap; handful] /Dhayf [def: bunch, cluster, clump] 
	hoyf/V/T [def: heap up] /Gon
	misthoyfn/S [m] [def: dungheap] 
	[idiom: shayter-hoyfn = bonfire, death at the stake]
hoyker/V/T [def: bend over] /Gayn
	hoyker/S [m] /Idik /Dheyker hoy'kerin/S [f] [def: hunchback]
	ayngehoykerterheyt [def: hunched over]
hoykh/Khekh [def: high; tall; loud] hoykhlekh/A [def: somewhat tall]
	heykh/N [f] hoykhkayt/N [f] [def: height; elevation]
	tsveythekhst/A [def: second largest]
	hekher/V/T [def: raise (price, wages); promote; rise (with "zikh")]
		farhekher/V/Bfarhekhert [def: raise, increase]
	hekherkayt/N [f] [def: height]
	hekherung/N [f] [def: rise, increase]
	hekhst [adv] [def: extremely]
		hekhstns [adv] [def: at most]
	hoykh/V/T [def: raise; rise (with "zikh")] /Garoys/Goys
		derhoykh/V/Bderhoykht [def: rise (with "zikh")]
		bahoykh/V/Bbahoykht [def: raise; steam up]
		[idiom: oys|hoykhn di neshome{nSmh} = die]
	farhoykh/V/Bfarhoykht [def: raise]
hoykh/V/T [def: breathe; exhale]
	hoykh/N [m] [def: breath]
	[idiom: oyshoykhn di neshome = die]
	bahoykh/V/Bbahoykht [def: mist up; inspire]
hoyl/V/T [def: howl (sound of a dog or wolf)]
	gehoyl [n?] [def: howling]
hoyl/V/T /Goys [def: ream, hollow out]
	hoyl/A [def: unadorned, pure; bare; hollow]
	farhoyl/V/Bfarhoyln [def: maintain secret, hide]
hoylekh{hwlx} [m?] [def: manner of dress]
hoyn{hwn}/N [m] [def: treasure, fortune]
	hoyn_rav{hwn-rB} [m?] [def: treasure, fortune]
/Dhoypt /Dheypt /Dhipt [n] [def: piece (of fruit); head (of cabbage)]
hoysofe{hwsfh}/Xhoysofes{hwsfwT}/H [def: supplement, appendix; pay raise]
hoyt/N [f] [def: skin] /Iik
	/Dhayt [def: membrane] % Harduf
	eynheytlekh/A [def: uniform]
	gendznhoyt/N [f] [def: goosebumps] 
	hoylhoytik/A [def: bareskin] 	
	fo'rhoyt/N [f] [def: foreskin] [usage: not recommended]
	[idiom: shpringen fun der hoyt = become emotional]
	[idiom: gendzene hoyt = goosebumps]
	[idiom: oyfhern fun der heler hoyt = quit cold turkey]
	[idiom: shpiln fun der heler hoyt = improvise] [note: V]
hoytsoe{hwc#h}/Xhoytsoes{hwcowT}/H [f] [def: expenses]
hoyve{hvh} [m] [def: present (tense)] 
hoyz/Xhayzer [n] /Iik [def: house] /Dhayz
	hayzke/S [f] [def: hut] 
	bahoyzung/N [f] [def: shelter]
	aynforhoyz [n] [def: entrance hall]
	e'lterhoyz/Xe'lterhayzer [n] [def: old-age home] % Forwards: Boris Sandler
	dulhoyz/Xdulhayzer [n] [def: insane asylum]
	firhoyz/Xfirhayzer [n] [def: hall, lobby, antechamber] 
		firez [n] [def: antechamber] % Kulbak: Zelmenyaner
	fo'derhoyz/Xfo'derhayzer [n] [def: corridor] 
	gasthoyz/Xgasthayzer [n] [def: inn]
	hi'nerhoyz/Xhi'nerhayzer [n] [def: chicken coop]
	hurnhoyz/Xhurnhayzer [n] [def: house of prostitution]
	melts|hoyz/Xmelts|hayzer [n] [def: brewery]
	rothoyz/Xrothayzer [n] [def: town hall]
	shandhoyz/Xshandhayzer [n] [def: brothel]
	shekhthoys/Xshekhthayzer [n] [def: slaughterhouse]
	te'nement-hoyz/Xtenement-hayzer [n] [def: tenement house] 
	varn-hoyz/Xvarn-hayzer [n] [def: warehouse]
	va'remhoyz/Xvaremhayzer [n] [def: greenhouse] 
	yi'dishhoyz [n] [def: Yiddish house]
	hoyz/V/T [def: dwell] 
	[idiom: geyn iber di hayzer = beg from door to door]
	[idiom: freylekh hayzl = bordello, house of prostitution] % Avrom Karpinovitsh
-/Xhoyzn [def: trousers (clothing)] -/Xheyzlekh
	-/Xarbethoyzn [def: work pants (clothing)]
	-/Xunterhoyzn [def: underpants (clothing)]
	-/Xgalife'-hoyzn [def: riding breeches (clothing)] 
	heyzkes/X [def: short trousers (clothing)] % Forwards: S-R Schaechter
hoz/N/Xhezer [m] /Dhez hozikhe [f] [def: rabbit; hare]
hoze{hez|h}/H [f] [def: gall, impudence, insolence]
	ho'zedik{hez|hdik}/K [def: impudent, insolent]
	azesnik{ezwTnik}/Ees [m] azesnitse{ezwTnitse}/S [f] [def: brazen person] 
	azes{ezwT}/H [def: effrontery, impertinence; gall] /Idik
		azeskayt{ezwTkayt}/N [f] [def: insolence]
	meyiz{me|iz} [verb] [def: embarrass (with "zayn")]
hreblye/S greblye/S [f] [def: dike; dam]
hromade/S [f] [def: community (Ukranian громаде)]
hrube/S [f] [def: furnace; heating stove] 
hu{hw#}/H [def: he]
hu-ha [m] [def: bustle; noise] [interj] [def: wow!] 
hubl/N [m] [def: plane (tool)] 
	hubl/V/T hu'bleve/V/T [def: plane; smooth with a plane] /Gavek/Gop/Goys
	hublekhts/N [def: wood shavings]
hudzhe/V/T [def: buzz, hum (like machinery)]
	zuzhe/V/T zhuzhe/V/T huzhe/V/T % variants
	zuzheray'/N huzheray'/N [def: buzzing, humming (like machinery)]
huke/V/T [def: whoop; knock]
	huk/Ees [m] huke/S [f] [def: din; whoop, shout]
	farhuke/V/Bfarhuken [def: beat like a dog]
hulye/V/T [def: have fun, carouse, party] /Gon
	hu'lyeve/V/T /Gtsu [def: have fun, carouse, party]
	hulyake/S [def: partygoer]
	hulyanke/S [def: party]
	hultay'/Ees [m] hultayke/S [f] [def: merrymaker; scoundrel; libertine]
	tsehulye/V/Btsehulyet [def: run wild (with "zikh")]
humanist [m] [def: humanist] /Iish [def: humanistic]
	humanita'r/A [def: humanitarian; relating to humans]
	humanistik [f] [def: humanities (subject)]
humo'r/N [m] [def: humor]
	humori'st/N [m] [def: humorist] /Iish [def: humorous]
	humoreske/S [f] [def: humoresque]
hun/Xhiner [f] [def: hen] /Dhind [def: chick] hon/Xhener [m] /Dhend [def: rooster]
	hinersh/A hi'nerish/A [def: chicken] 
	-/Xhiner-hener [def: poultry]
	hi'nernik/Ees [m] hi'nerni'tse/S [f] [def: poultry dealer]
	[idiom: kapore{Kprh} hindl = scapegoat]
	[idiom: kukn vi a hun in di bney_odem{bny-odm} = exhibit clueless incomprehension]
hundert [d] /A [def: hundred] /Itst
	hunderter/S [m] [def: 100-dollar/ruble bill] 
	tsveyhundert [d] /A [def: 200]
	drayhundert [d] /A [def: 300]
	firhundert [d] /A [def: 400]
	finfhundert [d] /A [def: 500]
		finfhunderter/S [def: 500-dollar/ruble bill]
	zekshundert [d] /A [def: 600]
	zibnhundert [d] /A [def: 700]
	akhthundert [d] /A [def: 800]
	naynhundert [d] /A [def: 900]
	elfhundert [d] /A [def: 1100]
	tsvelfhundert [d] /A [def: 1200]
	draytsnhundert [d] /A [def: 1300]
	fertsnhundert [d] /A [def: 1400]
	finftsnhundert [d] /A [def: 1500]
	zektstsnhundert [d] /A [def: 1600]
	zibetsnhundert [d] /A [def: 1700]
	akhtsnhundert [d] /A [def: 1800]
	nayntsnhundert [d] /A [def: 1900]
	yorhundert/Eer/N [m] [def: century]
hunger/V/T [def: hunger; starve] /Gtsu/Goys/Gunter/Gon
	farhunger/V/Bfarhungert [def: hunger]
	hunger [m] [def: hunger; famine] /Iik [def: hungry]
		hungerikerheyt [adv] [def: in a state of hunger] 
hunt/Xhint [m] [def: dog] hintish/A [def: dog-like, canine; mean]
	/Dhint [def: puppy]
	pleghunt/Xpleghint [m] [def: watchdog ?? (German pflegehund)] % Sholem Aleykhem
	shofhunt/Xshofhint [m] [def: sheepdog] 
	vinthunt/Xvinthint [m] [def: greyhound]
	yam{|ym}-hunt/Xyam{|ym}-hint [m] [def: seal (animal)] 
	hintarnye/S [f] [def: (dog) kennel]
hur/V/T [def: frequent prostitutes]
	hur/N [f] [def: prostitute] hureray'/N [f] [def: prostitution]
hura'/Een [def: ovation, cheer]
	hura' [def: interj] [def: hurrah!, hooray!] 
	harey [def: interj] [def: calling attention to someone at a wedding (usually double or triple)]
huraga'n/N [m] hurika'n/N [m] uraga'n/N [m] [def: hurricane] 
hure/S [f] [def: heap (Russian гора)] % Itsik Kipnis
hurt [m] [def: wholesale]
	hurtovnik/Ees [m] [def: wholesale buyer]
	hurthendler/S [m] [def: wholesale dealer; wholesaler]
	hurtom [adv] [def: wholesale]
hurt/N hurte/S [f] [def: flock of ducks or geese] /Dhert
hushtshe [f] [def: rabble; dregs]
hust/V/T [def: cough] /Goys/Gavek/Garoys
	/Gunter [def: cough quietly; sputter (engine)]
	hust/N [m] [def: cough] /D
	farhust/V/Bfarhust [def: have a coughing fit (with "zikh")]
	kay'khhust [m] kay'khhis [m] ko'klhust [m] [def: whooping cough (disease)]
	his/V/T [def: cough]
		his/N [m] [def: cough]
hut/N/Xhit [m] [def: hat (clothing)] 
	/Dhit [m] [def: women's hat (clothing)]
	hitl/N [n] [def: men's hat (clothing)] 
	filts|hut [m] [def: felt hat] % Shpiglblat
	fi'ngerhut [m] [def: thimble]
	[idiom: drayen a hitl = annoy, pester]
hute/S [f] [def: glass factory]
hyene/S [f] [def: hyena (animal)] % Harduf
hyerarkh/N [m] [def: hierarch (Church position)]
	hyerarkhye/S [f] [def: hierarchy] hyerarkhish/A [def: hierarchical]
i [conj correl] [def: both .. and]
i/Een [m] [def: the letter I] 
i-e'm/N [m] [def: instant message, IM (computer) (with "shikn" or "oysbaytn"] [note: V] 
ib/V/T [def: practice, exercise (with "zikh")] /Goys
	ibung/N [def: exercise]
iber/P [def: over] /Iik [def: extra]
	i'berikayt/N [f] [def: excess] % Forwards: Sholem Berger
	iberikns [adv] [def: especially; moreover]
	ariber/P [def: over] iberal [def: generally]
	deriber [def: therefore]
		derimekh derimakh [adv] [def: therefore] [usage: humorous]
	fariber [def: past] % Esther Kraytman: Briliantn
	kegniber{kegn#iber} [adv] [def: across from, opposite] /Idik
	oybersht/A [def: most high] oybershtns eybersht/A eybershtns 
	eyber- [prefix] [def: chief, upper] 
		oyber- [prefix] [def: chief, upper] [usage: inadmissible]
ibl [m?] [def: disgust; nausea] /Idik [def: disgusting; nauseating]
	ibl/V/T [def: disgust; nauseate] 
	faribl{far#ibl}/N [m] [def: grudge] /Idik
	[idiom: hobn faribl oyf im = take offence, blame him]
ibuprofe'n [m] [def: ibuprofen (drug)] % Yiddish League
idee/N/S [f] [def: idea] ideish/A [def: pertaining to ideas] 
	ideal/N [n] [def: ideal]
		ideali'zm/N [m] [def: idealism, patriotism]
		ideali'st/N [m] [def: idealist] /Iish [def: idealistic]
		ideolog/N [def: idealogue] /Iish [def: idealogical]
		idealizi'r/V/Bidealizi'rt [def: idealize] % Forwards: Burko
	ideologye/S [f] [def: idealogy]
identifitsi'r/V/Bidentifitsi'rt [def: identify] 
	identifitsirung/N [f] identifikatsye/S [def: identification] 
	identite't/N [f] [def: identity]
	identish/A [def: identical] identishkayt/N [f] [def: sameness] 
	u'midentifitsi'rt/A [def: unidentified] % Forwards
idilye/S [f] [def: idyll, bucolic; episode] idilish/A
idyom/N [m] [def: idiom] /Iatish [def: idiomatic]
idyosynkrazye/S [f] [def: idiosyncrasy]
idyo't/N [m] [def: idiot] /Iish
igl{e|ygwl}/Xigulem{e|ygwlym}/H [m] [def: circle]
ignori'r/V/Bignori'rt [def: ignore]
	ignora'nt/N ignoramus/Ees [def: ignoramus; ignorant person; boor]
igrek/En [m] [def: the letter Y] 
iker{e|ykr}/Xikrem{e|ykrym}/H [m] [def: main point]
	ikerdik{e|ykrdik}/K [def: central, fundamental, main]
	beiker{be|ykr}/H [adv] der|iker{e|ykr}/H [adv] [def: especially]
	ikersh{e|ykrsht} derikersht{dere|ykrsht} [adv] [def: especially; essentially] 
	oyker{ewkr}/H [verb] [def: uproot (with "zayn")] 
	koyfer_beiker{Kwfr-be|ykr} [m] [def: atheist]
	iker_hoikorem{e|ykr-he|ykrum} [m] [def: the most important principle]
ikev{e|yKwB}/Xikuvem{e|yKwBym}/H [def: hindrance] 
ikh yakh [def: I] mir mikh [def: me] mayn/A/Iik [def: my]
		maynet [def: for my sake (in "fun maynet vegn")] 
	du dir dikh [def: you] dayn/A/Iik [def: your]
		daynet [def: for your sake (in "fun daynet vegn")]
		duts/V/T [def: speak in familiar voice]
		[idiom: zayn oyf du = speak in familiar voice]
	er [def: he] im [def: him] zayn/A/Iik [def: his]
		zaynet [def: his sake (in "fun zaynet vegn")]
	zi [def: she] ir/A/Iik [def: her]
		iret [def: for her sake (in "fun iret vegn")]
	es se s im [def: it] zayn [def: its]
	zikh [def: self]
		inzikhi'zm/N [m] [def: introspective movement (art)]
		inzikhi'st/N [m] [def: follower of the introspective movement]
		fa'rzikhdik/A [m] [def: freelance] 
			fa'rzikhnik/N [m] [def: freelancer] [note: V]
		zikhik/A farzikhik/A [def: self-absorbed, selfish] % Stutchkoff
	mir [def: we] undz [def: us] undzer/A [def: our]
		undzerik/A [adj predicative] [def: our]
		undzert [def: for our sake (in "far undzert vegn")]
	ir aykh ets enk enkers ayer/A/Iik [def: you (pl)]
		ayert [def: for your (pl) sake (in "far ayert vegn")] 
		irts/V/T [def: speak in formal voice]
	zey [def: they] zeyer/A/Iik [def: their]
		zeyert [def: for their sake (in "far zeyert vegn")]
ikhtyolog/N [m] [def: ichthyologist (occupation)] % Stutchkoff
ikone/S [f] [def: icon (religious)]
iks/En [m] [def: the letter X] 
ile{e|ylwy}/Xiluem{e|ylwym}/H [m] [def: child genius] 
	ilish{e|ylwyyS}/H/A [def: brilliantly clever (child)] 
ilustri'r/V/Bilustri'rt [def: illustrate]
	ilustratsye/S [f] [def: illustration]
iluzye/S [f] [def: illusion] iluzorish/A [def: illusory]
imam/S [m] [def: Imam (Moslem religious leader]
ima'zh/N [m] [def: image] 
	imazhi'st/N [def: spin doctor] [note: V] 
imenines [m?] [def: birthday celebration (Ukrainian іменіне)]
	imeninik/Ees [m] imeni'nitse/S [f] [def: birthday celebrant]
imenye/S [def: estate (Russian имение)]
imer [adv] [def: always (German immer)] [usage: deprecated]
imiti'r/V/Bimiti'rt [def: imitate] imitatsye/S
imperativ/A [def: imperative]
imperye/S [f] [def: empire] imperya'l/A /Iish
	imperyalistish/A [def: imperialist] 
	imperyali'zm/N [m] [def: imperialism] 
	perya'l/N [m] imperya'l/N [m] [def: Imperial coin (currency)] 
	imperya'l/N [m] [def: double-decker public bus (French autobus à impériale)] 
	imperato'r/N [m] [def: emperor] imperatorshe/S [f] [def: empress]
impet/N [m] [def: impetus, speed] /Idik /Iik
implanti'r/V/Bimplanti'rt [def: implant] % Forwards: Yoel Matveyev
implikatsye/S [f] [def: implication]
imponi'r/V/Bimponi'rt [def: impress]
	impoza'nt/K [def: impressive] 
importi'r/V/Bimporti'rt [def: import]
impresyoni'zm/N [m] [def: impressionism (art form)]
impreze/S [f] [def: social event, enterprise] 
	impresaryo/S [m] [def: impressario] % Yosl Birshteyn
improvizi'r/V/Bimprovizi'rt [def: improvize]
	improvizatsye/S [f] [def: improvization]
impuls/N [m] [def: impulse] /Iiv
in/P [def: in] inerlekh/K [def: internal]
	drinen [def: inside] /Idik
	derin derinen [def: within]
	inern [adj] [def: interior] % uninflected, as in "inern minister" 
	[idiom: in mitn drinen = suddenly]
ind/N [m?] [def: wave (water)]
	indl/V/T [def: surf (with "zikh")] [note: V] 
	indler/S [m] i'ndlerke/S [f] [def: surfer] [note: V] 
	indlen [n] indleray' [n] [def: surfing] [note: V] 
indeks/N [m] [def: index]
indik/Ees [m] inditshke/S [f] [def: turkey]
individue'l/A [def: individual]
	individualistish/A [def: individualistic, ideosyncratic] % Forwards: Yoel Matveyev
indorsi'r/V/Bindorsi'rt [def: endorse] 
	indorsirung/N [f] [def: endorsement] 
industrye/S [f] [def: industry] industrye'l/A [def: industrial]
	industryalizi'r/V/Bindustryalizi'rt [def: industrialize]
indyum [m] [def: indium (In)] 
indzl/N [m] [def: island] halbindzl{halb#indzl}/N [def: peninsula] 
inertsye/S [f] [def: inertia] inertsish/A [def: intertial]
infanterye/S [f] [def: infantry]
infektsye/S [f] [def: infection] dezinfektsye/S [f] [def: disinfection] 
	infekti'v/A [def: infectious]
inflatsye/S [f] [def: inflation (economic)] 
informi'r/V/Binformi'rt [def: inform]
	informatsye/S [f] [def: information]
	informati'v/A [def: informative] 
	[idiom: haltn informirt = keep posted] [note: V] 
ingber [def: ginger]
i'ngeveyd/N [m?] [def: intestines, viscera]
ingredye'nt/N [m] [def: ingredient] 
initsii'r/V/Binitsii'rt [def: initiate] % Forwards: S-R Schaechter
	initsya'l/N [m] [def: initial]
	initsyato'r/N [m] [def: initiator] 
initsyati'v/N [f] [def: initiative]
inkrusti'rt/V/Binkrusti'rt [def: encrust] 
inkubatsye/S [f] [def: incubation]
inkve'st/N [m] [def: inquest (juridicial)]
	inkvizitsye/S [f] [def: the Inquisition] 
		inkvizito'r/N [m] [def: inquisitor] /Iish
inse'kt/N [m] [def: insect] 
insinuatsye/S [f] [def: insinuation]
inspekti'r/V/Binspekti'rt [def: inspect]
	inspektor/N [m] [def: inspector]
inspiri'r/V/Binspirirt [def: inspire] inspiratsye/S [f] [def: inspiration]
instalatsye/S [f] [def: (object of) installation, facility] 
	instali'r/V/Binstali'rt [def: install] 
	instalirung/N [f] [def: (act of) installation] 
	instalator/Xinstalato'rn [m] [def: plumber; appliance installer] % palatal L
insta'nts/N [def: department]
insti'nkt/N [m] [def: instinct] /Iiv [def: instinctive]
institu't/N [m] [def: institute] institutsye/S [f] [def: institution]
instruktsye/S [f] [def: instruction]
	instrukto'r/N [m] [def: instructor]
instrume'nt/N [m] [def: instrument] /Ia'l
	leyt-instrume'nt/N [m] [def: soldering iron] % Stutchkoff
	smitshik-instrume'nt/N boygn-instrume'nt/N [m] strune-instrume'nt/N [m] [def: stringed instrument (musical)] [note: V]
integri'r/V/Bintegrirt [def: integrate]
	integratsye/S [f] [def: integration] 
	integra'l/N [m?] [def: integral (mathematics)]
intele'kt/N [m] [def: intellect] 
	intelektue'l/A [def: intellectual] /Iish
	intelektua'l/N [m] [def: intellectual]
	intelektuali'zm/N [m] intelektualite't/N [f] [def: intellectualism] 
	intelige'nt/K [def: intelligent]
		intelige'nts/N [f] [def: intelligence]
insul'in [m?] [def: insulin (hormone)]
intensiv/A [def: intensive]
interes/N [m] interesi'r/V/Binteresi'rt [def: interest]
	farinteresi'r{far#interesir}/V/Bfarinteresi'rt{far#interesirt} [def: interest; engage the interest]
	interesant/K [def: interesting]
interna't/N [m] [def: dormitory (college)]
interni'st/N [m] internistin/S internistke/S [f] [def: internist (physician)] [note: V]
interpreti'r/V/Binterpreti'rt [def: interpret]
	interpretatsye/S [f] [def: interpretation]
	interpretati'v/A [def: interpretive]
interveni'r/V/Binterveni'rt [def: intervene] 
	interve'nts/N [f] [def: intervention]
intervyui'r/V/Bintervyui'rt [def: interview]
	intervyu/N [m] [def: interview]
	intervyuer/S [m] [def: interviewer] % Sholem Aleykhem
	intervyua'nt/N [m] [def: interviewee] % Binyumen Schaechter
inti'm/K [def: intimate; private]
intrige/S [f] [def: intrigue]
	intrigi'r/V/Bintrigi'rt [def: plot, scheme] 
	intriga'nt/N [m] [def: plotter]
intsh/Ees [m?] [def: inch (American)]
intsident/N [m] [def: incident]
intuitsye/S [f] [def: intuition; inspiration]
invali'd/N [m] [def: invalid (person)]
	invalidkayt/N [f] invalidishkayt/N [f] [def: disability]
invazye/S [f] [def: invasion] 
inventa'r/N [m] [def: inventory]
inversye/S [f] [def: inversion]
investi'r/V/Binvesti'rt [def: invest] 
	investitsye/S [f] [def: investment] 
inye'ktsye/S [f] [def: injection (medical)] % Yiddish League
	tsugob-inye'ktsye/S [f] [def: booster shot] % Yiddish League
inyen{enyn}/Xinyonem{enynym}/H [m/n] [def: matter]
inzheni'r/N [m] inzhene'r/N [m] [def: engineer]
	inzhenerye/S [f] [def: engineering]
ion/N [def: ion]
	anyon/N [def: anion (chemistry)]
	katyon/N [def: cation (chemistry)]
iot/N [m] [def: letter J] 
ipesh{e|ypuS}/H [m] [def: stink] /Idik
	faripesh{fare|ypuS}/V/Bfaripesht{fare|ypuSt}
ir_{e|yr}/H [f] [def: city]
	ben-ir{bn-e|yr} [m] [def: townsman]
	resheyrn{r#S-e|yrwn}/S [m] [def: mayor (government)]
ire [def: people] [grammar: requires a counting word]
iridyum [m] [def: iridium (Ir)] 
iris/N [m?] [def: iris (flower)] % Stutchkoff
ironye/S [f] [def: irony] ironish/A [def: ironic]
	ironizi'r/V/Bironizi'rt [def: speak ironically] % Stutchkoff
iterbyum [m] [def: ytterbium (Yb)] 
itlekh/A [def: each]
itryum [m] [def: yttrium (Y)] 
itst [adv] /Iik itster [adv] itstert [adv] [def: now] 
	atsind [adv] atsinder [adv] atsindert [adv] yetst [adv] [def: now]
	itstikayt/N [f] [def: present (time)] 
	bizitstik/A [def: so far, up until now]
ivde/A [def: the next (with "vokh" or "yor")]
ivre{eBry}/H [n] [def: Hebrew (reading in Kheder)]
	ivri't{eBryW}/H [n] [def: modern Hebrew] /Iish
	i'vredik{eBrydik}/A [def: literate (in native language)]
ish_{#yS}/Xanoshem{#nSym}/H [m] [def: man]
	ishe{#ySh}/Xnoshem{nSym} [f] [def: woman] 
	eyshes_i'sh{#yST-#yS} [f] [def: married woman]
-/Xishkes [def: jellied feet (food)] % Stutchkoff
isla'm [m] [def: Islam] /Iish islamer/X [def: Moslem]
	islamistish/A [def: Islamist] % Forwards: B. Sandler
i'soglos/N [m?] [def: isogloss (linguistic)]
istmos/N [m] [def: isthmus] 
izdye'keve/V/Bizdye'kevet [def: mock, insult (with "zikh iber")]
	izdye'kenish/N [n] [def: mockery, insult]
izm/N [def: ism (philisophy)]
izoli'r/V/Bizoli'rt [def: isolate] 
	izolatsye/S [f] [def: isolation, aloneness]
	izolator/S [m] [def: isolation unit] % Yiddish League
	izolirke/S [f] [def: isolation unit] % Yiddish League
i'zomer/S [m] [def: isomer (chemical)] /Iish
	ste'reo-i'zomer/S [m] [def: stereoisomer (chemical)] /Iish
izoto'p/N [m?] [def: isotope] % Forwards: Yoel Matveyev
izovn{ezBwn}/Xisvoynes{ezBwnwT}/H [m] [def: legacy; dead author's unpublished work]
izvoztshik/Ees [m] izvoshtshik/Ees [def: carriage driver] 
ka/Een [m] [def: the letter K] 
kabak [m?] [def: pumpkin; melon (vegetable)] /D [def: squash]
kaban [m?] [def: wild boar (animal)]
kabaret/N [m] [def: cabaret]
kabine/S [f] [def: cabin (ship); booth (with "telefon-")]
kabinet/N [m] [def: work room, cabinet]
kabl/N [m] [def: cable (rope); telegram]
kabole{kblh}/H [def: Kabbalah] /Idik kabolistish{kblistish}/A 
	mekabl{mkbl}/Xmekablem{mkblym} [def: charity recipient]
	kibl [m?] [def: bucket]
	kubl [m] [def: slop pail; chamber pot]
	kabolas{kblT} [def: greeting of]
	mekubl{mkwbl}/Xmekubolem{mkwblym}/H [m] kabali'st/N [m] [def: Cabbalist, mystic] 
	beys_kibl{byT-kybul} [m] [def: receptacle, repository; belly (anatomy)]
	beys_hakibl{byT-hkybul} [m] [def: vagina (anatomy)]
kabtsn{kbcn}/Xkabtsonem{kbcnym}/H [m] kabtsnte{kbcnte}/S [def: pauper] % from "mekabets{mkbc} nedoves{ndBwT}"
	kabtsonish{kbcnish}/A [def: impoverished]
	kabtsansk [def: Kabtsansk (fictional town of Mendele Moykher Sforem)]
	kabtsanivke [def: Kabtsanivke (fictional town of Isaiah Lerner)]
	[idiom: draygorndiker kabtsn{kbcn} = full-fledged pauper] % Michael Wex
kade'nts/N [f] [def: term of office] 
	mi'tkade'nts/N [def: midterm] % Yiddish League
kadmyum [m] [def: cadmium (Cd)] 
kadmoyn{kdmwn}/Xkadmoynem{kdmwnym}/H [def: ancient time] /Iish
	mikadmoynem{mkdmwnym} [adv] [def: from earlist times; originally]
	hakdome{hkdmh}/Xhakdomes{hkdmwT}/H [f] [def: introduction, preface]
		akdomes{akdmwT}/H [def: introduction (Aramaic)]
kadokhes{kdHT}/H [def: (malarial) fever, disease]
kadri'l/N [m] [def: quadrille (dance)]
kadushke/S [f] [def: barrel; butter churn]
kaf{Kf}/H [def: palm]
	kaf_hakale{Kf-hkle} [def: purgatory] % mystic interpretation of 1 Samuel 25:29
	bekaf_zkhus{bKf-zHwT} [adv] [def: with the benefit of the doubt]
	tekiyes-kaf{WkyeT-Kf} [f] [def: handshake]
	neki-kapayemnik{nky-Kpymnik}/Ees [m] [def: incorruptible person]
kafe'/Een [m] [def: café]
	kafeterye/S [f] [def: cafeteria] 
kafein [m] [def: caffein (chemical)] % Forwards: Sholem Berger
	kafeinirt/A [def: caffeinated]
		dekafeinirt/A [def: decaffienated] % Yiddish League
kafrisin{kfrisin} [adj predicative] [def: excellent, high-quality]
kaftan/N/Dkaftand/Dkaftend [n] kaftn/S/Dkaftnd [def: caftan (coat; clothing)]
	kofte/S [f] koftl/N [m] kaftl/N/Eekh [m] [def: vest (clothing)]
-/Xkaftoyrem{Kftwrym} [def: hemorrhoids]
kak/V/T [def: defecate] /Gop
	/Goys [def: eliminate by defecation (with "zikh")]
	farkak/V/Bfarkakt
	kaker/S [m] [def: defecator; good-for-nothing]
	kakalovitsh [m] [def: son of a turd (vulgar)] 
	[idiom: alter kaker = old fart (vulgar)]
	[idiom: gey kak afn yam{|ym} = get lost (vulgar)]
kakao [m] [def: cocoa (food)]
kakemayke/S [f] [def: television] [usage: humorous]
kakh{Kx}/H [def: such] 
	lkakh{lKx} [adv] [def: therefore]
	kakhave{Kx-hvh} [clause] [def: that's how it occurred]
kakhi [def: kakhi: sound of a cough]
kakhlye/S [f] kakhl/N/X [f] [def: ceramic tile] 
kahanets [m?] [def: night light (Ukrainian)]
kalambu'r/N [m?] [def: pun]
kalamazhnye/S [f] [def: prison (thieves' argot)]
kalameyke/S [f] [def: kind of Jewish dance]
kalapotshe/V/T [def: prattle (with "mit der tsung")] % Mendele
kalb/Xkelber /Dkelb [def: calf]
	/Iik [def: pregnant (cow); crazy (mit "makhn")]
	kelbn/A [def: calf, veal] kelbern/A [def: calf-like; silly]
	kelb/V/T [def: bear a calf (sometimes with "zikh")] /Gop 
	monkalb/Xmonkelber [n] [def: monster, freak]
kalbase/S [f] [def: sausage]
	kalbasnik/Ees [m] kalba'snitse/S [f] [def: sausage seller, irreligious person]
kale{Klh}/Xkales{KlwT}/H [f] [def: bride; engaged woman; girlfriend]
	khosn_kale{HTn-Klh} [def: engaged couple] 
	kale{Klh}/V/T [def: dress as if younger than one is (with "zikh")]
	[idiom: vern khosn_kale{HTn-Klh} = become engaged (couple)]
	[idiom: zayn khosn_kale{HTn-Klh} = be engaged (couple)]
kaledzh/N/Ees [m] [def: college (American)] 
kalemashke/S [f] kalamashke/S [f] [def: horse-drawn carriage] % Avrom Karpinovitsh
kalenda'r [m?] [def: calendar] /Iish
kaley/V/T [def: freeze]
	farkaley/V/Bfarkaleyet [def: freeze]
kaliber [m?] [def: caliber]
kalifornyum [m] [def: californium (Cf)] 
kaligrafye [f] [def: calligraphy] 
	kaligra'f/N [m] kaligrafke/S [f] [def: calligrapher] 
kalik/A [def: ill] kalike/S [m/f] [def: paralized person; cripple] 
kaline/S [f] [def: viburnum (plant)] % Itsik Manger
kalitke/S [f] [def: gate; small door]
kalke/S [f] [def: calque, loan translation]
	kalki'r/V/Bkalki'rt [def: calque; imitate]
kalkh/V/T [def: whitewash; calcium; lime] /Goys/Gop
	kalkher/S [m] [def: whitewasher]
kalkulus [m] [def: calculus] 
-/Xkaloshn -/Xkalashn -/Xgaloshn [def: galoshes, boots (clothing)]
kalorye/S [def: calorie]
	kalorife'r/N [m] [def: radiator]
kalt/Kkelt [def: cold] /Ilekh kelt/N [f] [def: cold] /D
	kaltkayt/N [f] [def: coldness]
	ka'lterhey't [adv] [def: cold]
	kil/V/T [def: become cold] /Gop/Gtsu
		lu'ftkiler/S [m] [def: air conditioner] % Forwards
	farkil/V/Bfarkilt [def: catch cold (with "zikh")]
		farkilung/N [f] farkilekhts/N [f] [def: cold (disease)]
	kil/K [def: cold] kilkayt/N [f] [def: coldness]
		kilblekh/A [def: cold]
	ayzkalt/A [def: ice-cold]
	kelter/S [m] [def: cold storage; silo; wine press; icebox]
	kelterer/S [m] [def: refrigerator]
	lu'ftkilung/N [n] [def: air conditioning] % Forwards: S-R Schaechter
	[idiom: kalt makhn = murder (thieves' argot)]
kaltsyum [m] [def: calcium (Ca)] 
kalya's/N kolya's/N kales/N koles/N [m] [def: calash, open carriage (horse-drawn)]
kalupe/V/T [def: pick; scoop; dawdle (with "zikh")] /Goys
	/Gop [def: shorten]
	[idiom: kalupen di noz = pick one's nose]
kaluzhe/S [f] luzhe/S kaleyshe/S [def: puddle]
kalvani'st/N [m] [def: Calvanist (religion)]
kalye/A [def: ruined] /Idik
	kalyetshe/V/T [def: slap, strike; wound]
		tsekalyetshe/V/Btsekalyetshet [def: ruin; wound; flay]
kalyake/V/T [def: mispronounce]
kalyum [m] [def: potassium (K)] 
kam/V/T kem/V/T [def: comb (utensil or crest of a rooster)] /Goys/Garoyf
	farkam/V/Bfarkamt farkem/V/Bfarkemt [def: comb]
	kam/N /Dkem [m] [def: comb; mountain crest, ridge]
	tsekem/V/Btsekemt [def: comb, untangle (hair)] 
kamash/N [m] [def: spats; uppers; low boot (shoe part; clothing)]
kame{Kmh}/H [adj] [def: how many; many] 
	vekame{|wKmh} [adj] [def: and how many]
	kames{KmwT} [f?] [def: quantity]
	[idiom: kame{Kmh} vekame{|wKmh} = very many]
kame'nitse/S [f] [def: stone or brick building; tenement house]
kamer/N [f] [def: chamber] /Dkemer [def: small room, cell (political)] 
	shatskamer/N [f] [def: treasury (poetic)]
	komornik/Ees [m] komo'rnitse/S [f] [def: tenant]
	[idiom: kamer-kamer-hoyz = hide-and-seek]
kamera'd/N [m] [def: comrade]
ka'mere/S [m] [def: camera]
ka'merton/Xka'mertener [m] [def: tuning fork]
kameye{kmye}/Xkameyes{kmyewT}/H [f] [def: amulet]
kami'ln [m?] [def: chamomile (herb) (Matricaria chamomilla et al)]
kami'n/N [m] [def: fireplace] 
kami'sh/N [m] [def: rush (plant, family Juncaceae)]
kampanye/S [f] [def: campaign] 
	forval-kampanye/S [f] [def: primary election campaign]
	val-kampanye/S [f] [def: election campaign]
	kampa'nyeve/V/T [def: campaign (with "far")] % Forwards: Yankev Goldshteyn
kamtsn{kmcn}/H/S [def: miser] 
	kamtsones{kmcnwT} [f] [def: miserliness]
	kamtsonish{kmcnish}/A 
	kamtsn{kmcn}/V/T [def: being miserly, being tightfisted]
kamyone't/N [m?] [def: minivan] % Forwards: S-R Schaechter
kamzoyl/N [m?] kamzelke/S kamizelke/S kamezelke/S [f] [def: men's vest (clothing)]
kan/N [f] /Dkend [def: can (to hold liquid)]
kan_{Kan}/H [def: here]
kana'l/N [m] [def: channel]
	kanalizi'r/V/Bkanalizi'rt [def: provide with canals] 
	kanalizatsye [f] [def: provision of canals] 
kana'l_{Kn″l} [adv] [def: as mentioned earlier] [origin: kenizker_leeyl{KnyzKr~le|yl}]
kanalye/S [f] [def: nuisance; villain]
kanape/S kanapke/S [f] [def: sofa (furniture)]
kanapke/S [f] [def: sandwich (Polish kanapka)]
kanarik/Ees [m?] [def: canary (bird)] /D
kana't/N [m?] [def: hawser, cable] % a bergl tsefoylte kanatn oyf der shif
kanave/S [def: ditch; sewer]
kandelabre/S [f] kandelyabre/S [f] [def: candelabra]
kandida't/N [m] kandidatke/S [f] [def: candidate] 
	kandidi'r/V/Bkandidi'rt [def: run for office] 
	kandidatu'r/N [f] [def: candidacy] 
kane/S [f] [def: enema (medicine)]
kanets/D [def: lantern (kerosine)] 
kanfes{KnfwT}/H [def: corners]
	arbe_kanfes{arbe-KnfwT}/H [f] [def: ritually fringed undershirt] /D
kanfolye/S [f] kanifolye/S [def: rosin]
kangor [def: a type of cloth material] /In % Opatoshu: Polishe Velder 
kanibal/N [m] [def: cannibal] kanibali'zm [m] [def: cannibalism]
-/Xkani'kules [f] [def: summer vacation; dog days (hot summer days)] 
	kanikula'r/A [def: dog-day] 
kanola [f?] [def: canola (oil)] % Forwards: S-R Schaechter
kanoy{knoi}/Xkanoyem{knoim} [m] [def: zealot] 
	kanoish{knoiS}/H/A [def: zealous]
kano'n/N [m] [def: cannon (military); canon (music)]
kanonizi'r/V/Bkanonizi'rt [def: canonize]
kant [m/f] [def: edge, rim; corner; facet]
kant/N [m] [def: region; direction] /Iik [def: sided, angular]
	firkantik/A [def: rectangular]
kantate/S [f] [def: cantata (music)] % Stutchkoff
kantine/S [f] [def: cantine, recreation hall] % M. Gildenman
kantoni'st/N [def: drafted soldier in Czar's army]
kanto'r/N [f/m] [def: office] /D
	kantorke/S [f] [def: desk] 
	[idiom: in kantor = over the counter]
kantor [m] [def: cantor]
	oyber-kantor [m] eyberkantor [m] [def: chief cantor]
kantsler/S [m] [def: councellor (government office)]
	kantselarye/S [f] [def: office (place)]
kantshik/Ees [m] [def: whip] /D
kanu' [m?] [def: canoe (vessel)] % Forwards
kap/N [m?] [def: small amount; drop] /Dkap kapetshke 
kapabl kapav kapavl kapal [adj predicative] [def: capable of (with infinitive)] 
kapdn{kpdn}/Xkapdonem{kpdnym}/H [m] [def: meticulous person; pedant; wrathful person]
	kapdonish{kpdnish} [def: meticulous; pedantic; wrathful]
	kapdones{kpdnwT} [f] [def: pedantry; harshness; meticulousness, punctiliousness]
kape/V/T [def: drip, trickle] /Garop/Garoyf
kape/S [f] [def: bedspread; hearth cover]
kapelye/S [f] [def: musical group]
kaper/S [def: caper (food)] 
kapita'l/N [m] [def: capital]
	kapitali'st/N [m] [def: capitalist] /Iish [def: capitalistic (political)]
		kapitali'zm [m] [def: capitalism (political)]
kapita'n [m] [def: captain] /Iske
kapitl/N/Eekh [n/m] [def: chapter]
kapitshke/S [f] [def: slight amount]
kapituli'r/V/Bkapituli'rt [def: capitulate, admit defeat] 
	kapitulatsye/S [f] [def: capitulation] 
kaplan/N [m] [def: chaplain] 
kaplye/S [f] [def: drop] 
kapo/S [m] [def: kapo (position in concentration camp)]
	hoyptkapo [m] [def: head kapo (position in concentration camp)]
kapo [m] kapodaster [m] [def: capo (device for a fretted stringed musical instrument)] [note: V] 
kapore{Kprh}/Xkapores{KprwT}/H [f] [def: atonement]
	kiper{Kypwr}/H [def: atonement]
		yom_kiper{ywm-Kypwr} [def: Day of Atonement]
	mekaper{mKpr}/H [verb] [def: atone (with "zayn")] 
	kaporenik{Kprhnik}/Ees [m] kaporenitse{Kprhnitse}/S [f] [def: non-Jew (slang)]
	[idiom: a sheyne reyne kapore{Kprh} = good riddance]
	[idiom: shlogn kapores = ritually ridding oneself of sins]
	[idiom: vern di kapore{Kprh} far emetsn = have a crush on someone]
	[idiom: toygn oyf kapores{KprwT} = be worthless]
	[idiom: darfn oyf kapores{KprwT} = have no use for]
kapote/S [f] [def: caftan, overcoat] /D kapotke/S [f] /D
	[idiom: oystsien di kapote = die] % Y. Y. Singer
kapoyer/A kapoyr/A [def: inverted]
	[idiom: Moyshe{mSh} kapoyer = a person who does things in reverse of normal]
	[idiom: shteln di hor kapoyer = frighten]
	[idiom: makhn kapoyer = defeat the purpose] [note: V]
kapriz/N [m] [def: act of capriciousness]
	kaprizne/A [def: capricious, unpredictable]
	kapriznik/Ees [m] kapri'znitse/S [f] [def: capricious person]
kapsl/Eekh [n] kapsul/N [m] [def: capsule, flask]
kapter/S [m] kaptur/S [m] [def: lampshade; cowl, hood]
	bakaptert/A [def: hooded]
	[idiom: dreyen emetsn dem kapter = annoy someone]
kapuste [f] [def: cabbage borsht (food)]
kaputshino [m] [def: cappuccino (beverage)] % Yiddish League
kaput [def: broken]
kar/S [f] [def: trolley car] % B. Kovner (Jacob Adler)
karabin/N [m] [def: carbine]
karafke/S [f] karafin'/N [m] karafinke/S [def: carafe] 
	karafintshik/D [def: carafe]
karahod/N [m] [def: circle dance]
karakul [m?] [def: pelt of a karakul sheep] /In
karame'l/N [m?] [def: caramel (candy)]
	karamelizi'r/V/Bkaramelizi'rt [def: caramelize (cooking technique)] % % Eve Jochnowitz
karanti'n/N [m] [def: quarantine]
karapke/V/Bkarapket [def: climb with effort (with "zikh")] /Garop/Garoyf
kara't/N [m] [def: carat] /Iik
karau'l/N [m] [def: guardhouse; guard squad]
	[idiom: shrayen karaul = call for help]
karava'n/N [m] [def: gang, team, staff; caravan]
karb/N /Dkerb [def: ruble (Ukrainian money: карбованець)]
	karbo'n/N karbonts/Ees [def: kerbl]
	-/Xkarbovnitses [def: money]
	[idiom: ayngebrengt a groshn, oysgebrengt a kerbl = penny wise, pound foolish] [note: V]
karb/V/T [def: notch, nick, score, indent] /Gon/Gayn
	karb/N [m] [def: notch, nick, dent, indentation] 
	[idiom: trefn in karb (arayn) = hit the nail on the head]
	karbi'r/V/Bkarbi'rt [def: curl] /Gon
kardashe/V/T [def: cut into pieces; beat bloody]
	tsekardashe/V/Btsekardashet [def: beat up]
kardemo'n [m?] [def: cardemon (spice)]
kardina'l/N [m] [def: cardinal (Church)] /A [def: cardinal, principal]
kare/A [def: bay, brown, chestnut (color)]
karel/N [def: coral beads]
karete/S [f] karo't [m?] [def: carriage (vehicle)]
karg/A [def: stingy; lacking] /Ilekh
	karg/V/T [def: begrudge; be stingy with]
	kargshaft/N [f] [def: stinginess]
	[idiom: iz ementsn karg = it isn't enough for someone]
karikatur/N [m] [def: caricature] 
kark/N [m] [def: back of the neck]
	[idiom: forn afn kark = tailgate] [note: V]
karkashte{krkST#}/S [f] [def: rectum] 
karke{krke}/H [f] [def: plot of ground; (Jewish) burial site]
karlik/Ees [m] [def: dwarf, midget]
	karlevate/A [def: dwarf-like] % Rokhl Korn: shotns
karmelit/N [def: Carmelite (Catholic religious)] /Iish
karnatsele/Xkarnatselekh [n] [def: ground-meat loaf (food)]
karniz [m] [def: cornice; curtain rod]
karo [m] [def: diamonds (playing cards)] % no plural?
karomislik/Ees [m] karomisl/N [m] koromisl/N [n] [def: water-carrier's pole]
karoten [def: carotene (food chemical)] 
	beta-karoten [def: beta-carotene (food chemical)] 
karp/N [m] [def: carp (fish)] 
karpe/S [f] [def: tree stump]
karsh/N/D [f] kersh/N/D [f] [def: light-colored cherry]
	 kirsh/N [f] [def: light-colored cherry] [usage: not recommended]
kartave/V/T [def: speak throatily; use a uvular 'r']
kartazh/N [def: commission (on a trade)] 
karte/S [f] [def: ticket; map] /Dkart [def: card] 
	shifskarte/S [f] shifskartn/S [m] [def: ship ticket]
	forkartl/Eekh [n] [def: (transport) ticket] 
	kartote'k/N [f] [def: file; filing cabinet]
	kredi't-kartl/Xekh [n] [def: credit card] [note: V]
	postkartl/Eekh [n] [def: postcard] 
	kartogra'f/N [m] [def: map-maker]
karte'l [m?] [def: cartel, consortium, sindicate; agreement, pact]
kartine/S [f] [def: picture, scene (Russian картина)]
kartser/S [m] [def: dungeon]
kartofl/N [f] /Dkartof kartoflye/S [f] getoflye/S [f] [def: potato]
karto'n/N [m] [def: cardboard, carboard container, carton] /Ien
kartu'z/N [m] [def: cap (clothing)] /D
karubu'/Een [m] [def: caribou (animal)] [note: V]
karuse'l/N [m] karusele/S [f] [def: carousel]
karyere/S [f] [def: career] % Forwards
kas{Kes}/H [m] [def: anger] tse|kas|/V/Btse|kas|t
	lokhes{lhxe|ys}/H [def: in spite (with "oyf tsu -")] /Idik [def: spiteful]
	lakhesnik{lhxe|ysnik}/Ees [m] lakhesnitse{lhxe|ysnitse}/S [f] [def: spiteful person] 
	kaysn{Kesn}/H [m] kaysnte{Kesnte}/S [f] [def: angry person]
kase/S [f] [def: safe, strongbox; fortune (capital); ticket window; font (type)] 
	kasetke/S [f] [def: safe] 
	fayerkase/S [f] [def: fireproof safe] 
	kasi'r/V/Bkasi'rt [def: cash, repeal, annul, foreclose (mortgage)] /Gayn
	kasi'r/N [m] kasirshe/S [def: cashier, teller, treasurer] 
	[idiom: in kase = cash on hand]
kaserol/N [m] [def: casserole] 
kaset/N [def: cassette]
	kasetnik/Ees [m] [def: portable cassette player] [note: V] 
kashe [f] [def: buckwheat, cereal (food)]
	kashke [f] /D [def: morsel] % Forwards: Boris Sandler
	mane-kashe [f] [def: farina]
	ray'zkashe/S [f] [def: rice meal] % Yosl Birshteyn
	[idiom: lozn zikh shpayen in der kashe = let others take advantage of one]
	[idiom: farkokhn a kashe = make a mess of things]
	[idiom: fardinen vaser oyf kashe = be unsuccessful]
	[idiom: hobn/fardinen vaser oyf kashe = be in dire straits]
kashemi'r/A [def: cashmere] % Sholem Aleykhem
kashkaval [def: sheep-milk cheese]
kashke't/N [m] [def: cap (clothing)] /D
kashtn/Xkashtanes/Xkashtanen/Xka'shtenes [m] [def: horse chestnut, buckeye]
	kashta'nevate/A [def: chestnut colored (horse)] % Sholem Aleykhem
kashu/N [def: cashew (nut)] % Forwards: Hershl Glaser
kashye{kSy#}/Xkashyes{kSywT}/H [f] [def: question]
	[idiom: klots kashye{kSy#} = foolish question]
kaske/S [f] [def: helmet]
kasoke/A [def: cross-eyed]
kastn/S [m] [def: box] /Dkest
	kestldik/A [def: checkered] % Sholem Aleykhem
	ay'zkastn/S [m] [def: refrigerator; freezer] 
	bri'vkastn/S [m] [def: mailbox]
	bru'stkastn/S [m] [def: chest (body part)]
	fidl-kestl/Eekh [n] [def: violin case]
	hi'lfkestl/Eekh [n] [def: first-aid kit] [note: V]
	mi'stkastn/S [m] /Dmi'stkest [def: rubbish bin]
	postkestl/Eekh [n] [def: mailbox] 
	shmues-kestl/Eekh [n] [def: chat box (computer)]
	tishkestl/Eekh [n] [def: box on a table] % Sholem Aleykhem: Khanuke-Gelt
	untershit-kestl/Eekh [n] [def: (cat) litter box] [note: V]
	untershpreyt-kestl/Eekh [n] [def: (cat) litter box] [note: V]
	gekestlt/A [def: plaid (pattern)] 
kastravet [def: cucumber]
kastrul [def: frying pan] % Stutchkoff
kat/N [m] [def: executioner] 
	ka'teve/V/T [def: flog]
katakli'zm/N [m] [def: cataclysm, catastrophe; flood]
katalo'g/N [m] [def: catalog] 
	katalogi'r/V/Bkatalogi'rt [def: catalog]
katalonish/A [def: Catalan (language)]
kata'r [def: cold, nose drip (disease)] farkatart/A % ?? accent
katara'kt/N [m?] [def: cataract (disease)]
katastrofe/S [f] [def: catastrophe]
	 katastrofa'l/A katastrofish/A [def: catastrophic]
katedra'l/N [f] [def: cathedral (Catholic)] katedre
kategorye/S [f] [def: category] kategorish/A
	[idiom: shtayer kategorye = tax bracket]
kater/V/T [def: desire strongly (with "zikh")]
katerinke/S [f] [def: barrel organ; hand organ; jalopy; sewing machine] 
	katerinshtshik/Ees [m] katerinazh [m] katerinarzh [m] [def: organ grinder] 
kate't/N [m] [def: side]
katlen{ktln} [m] [def: murderer]
ka'teve/V/T [def: slap] /Gdurkh
	farka'teve/V/Bfarka'tevet [def: whip]
	tseka'teve/V/Btseka'tevet [def: whip to pieces]
kateyger{ktygwr}/H [def: accusing attorney]
	kitreg{kytrwg}/H [m] [def: accusation] [usage: literary]
	mekatreg{mktrg} [m] [def: accuser]
katolik/N [m] [def: Catholic] katolish/A [def: Catholic]
ka'torge/S [f] [def: exile; penal colony]
	ka'torzhnik/Ees [m] [def: convict sentenced to hard labor]
	[idiom: farshikn oyf katorge = send to labor camp]
katori katore [particle] [def: who]
	[idiom: vos katore = quite the ...]
	[idiom: katore velkher = someone really ...]
katoves/N [m/n] [def: jest] /D % Borokhov derives from {KWBwT}
	katovesnik/Ees [m] [def: jester, joker]
	-/Xva'nt-katovesn [def: graffiti] [note: V]
	[idiom: traybn katoves = jest, joke, fool around]
	[idiom: oyf katoves = as a jest]
	[idiom: on katoves = seriously]
katoy'l/N [def: Catholic person] /Iish [def: Catholic]
kats/Xkets [f] [def: female cat] /Dkets ketsn/A
	koter/S [m] [def: male cat]
		koter/V/T [def: bother, annoy]
		kote/S [f] [def: female genitalia (vulgar)]
		[idiom: fidl di kotke = work faster (sherer-loshn)]
	katshelap/N [m] [def: cat skinner; clumsy oaf; sycophant; outcast]
	ketsl/V/T [def: bear a litter of kittens]
	[idiom: hern vi dem koter = pay no attention]
	[idiom: geshtrayfte kats = paskevate kats = tabby cat] [note: V]
katsap/Ees [m] [def: Russian (derogatory)] /Iish
katset/N [m] [def: concentration camp] /Iish/Inish katsetnik/Ees/D [m]
	katsetler/S [m] katsetnik/Ees [m] [def: concentration camp inmate or survivor]
katsev{kcB}/Xkatsovem{kcBym}/H/S [m] [def: butcher]
	katsovish{kcBish}/A [def: pertaining to butchers]
	katsevte{kcBte}/S [f] [def: wife of a butcher]
katshan/Ees [m?] [def: fool; cabbage stump, cob]
katshe/V/T [def: crawl around] /Garayn/Giber/Garop % also katshen/V/T
	/Gop [def: pull away]
	/Goys [def: roll up (as noodles)] 
	/Gunter [def: roll up (as pants cuffs)]
	/Gtsunoyf [def: roll up (a scroll)] % Sholem Aleykhem
	farkatshe/V/Bfarkatshet [def: roll up (cloth)]
		[idiom: farkatshen di oygn = roll one's eyes] [note: V]
		farkasher/V/Bfarkashert [def: roll up (cloth)] % variant form
	ka'tshlke/S katshalke/S [f] [def: rolling pin] /D
katshke/S [f] [def: duck (female)] /D katsher [m] [def: duck (male)]
katukh/N [m] [def: chicken coop]
kavali'r/N [m] kavalye'r/N [def: cavalier; young man; boyfriend]
	kavalerye/S [f] [def: cavalry]
	kavaleri'st/N [m] [def: cavalryman]
kavalkade/S [f] [def: cavalcade]
kave/S [f] [def: coffee] /In
kavene/S [f] [def: watermelon]
kaviar [m] [def: caviar]
kavir/V/Bkavirt [def: guarantee; vouch for (with "far")]
kavke/S [f] [def: a kind of small bird]
kavone{Kvnh}/Xkavones{KvnwT}/H [f] [def: intention]
	bekavone{bKvnh} [adj] [def: intentional] [grammar: predicative]
	kivn{Kyvn}/H [def: intention] /Idik
	bekivn{bKyvn} [adv] [def: intentionally] /Idik
		umbekivn{umbKyvn} [adv] [def: unintentionally] /Idik
	mekavn{mkvn}/H [verb] [def: intend (with "zayn")] 
	[idiom: di kavone{Kvnh} iz geven derbay = it's the thought that counts] [note: V]
kavyar [m?] [def: caviar, fish roe (food)]
kavyo'r [m?] [def: expensive carpet] % Shpiglblat
kay/Vkay|en/Bgekay|t [def: chew] /Giber
	tsekay/V/Btsekay|t [def: chew]
	kayer/S [m] [def: jaw (body part)]
kayem{kym}/H [def: exists] 
	kayme{kaym#}/H [def: stands]
		kayme_lon{kaym#-ln} [def: truism, indisputable truth] 
		[idiom: a kayme_lon{kaym#-ln} fun = no less than (humorous)]
	kiyem{kywm}/H [def: existence; survival]
	mekuyem{mkw|ym}/H [def: established; materialize (with "vern")]
	mekayem{mkAm}/H [verb] [def: establish (with "zayn")] 
	yikum{ykwm}/H [def: may redemption arise (with "- purken")]
	tkume{Wkwmh}/H [f] [def: hope for salvation; recovery; survival]
	[idiom: shrayen khay_vekayom{Hy-|wkEm} = complain uselessly]
	[idiom: a proster khay_vekayom{Hy-|wkEm} = ordinary fellow]
kayen{ka|yen} [m?] [def: cayenne pepper (spice)] % Forwards: S-R Schaechter
kay'et [def: notebook] [note: Polish Yiddish]
kaykh/V/T [def: gasp; pant]
	farkaykh/V/T [def: gasp (with "zikh")]
	[idiom: kaykhn far gelekhter = laugh until out of breath]
kaykl/V/T [def: roll] /Gavek/Giber/Garop/Garoys/Gdurkh/Garum/Goys
	koykl/V/T [def: roll] % variant
	derkaykl/V/Bderkayklt [def: reach by rolling or inaction (with "zikh tsu")]
	kaykl/N [def: circle] /Idik [def: round] /Dkayk [def: marble (plaything)]
	kaylekh/Eer [m] [def: sphere; ring] /D
		kay'lekhik/A kaylekhdik/A [def: round]
			oy'sgekay'lekhikt/A [def: rounded] % Sholem Aleykhem
		[idiom: kaylekhdiker yosem{yTwm} = complete orphan]
		erdkaylekh [m] [def: Earth (planet)]
kayl/V/T [def: slaughter (usually an animal)]
kayor{ka|yor}/N [m] [def: early dawn]
kayre{kerh}/Xkayres{kerwT}/H [f] [def: bowl; alms-bowl (in synagogue on Yom Kippur); Seder plate]
ka|yute/S [f] [def: cabin (ship)]
kazarme/S [f] [def: barracks]
kazna' [f?] [def: state treasury (Russian казна)] [usage: not recommended]
kazyone [adj] [def: govenmental] [grammar: indeclinable, attributive]
	[idiom: kazyone rov{rB} = government-appointed Rabbi (Russia)]
kebudl/N [def: caboodle (English ??)] 
kedakhes{kdHT}/H/N [f] [def: fever]
keday{Kda|y}/H [def: worthwhile]
	kedey{Kdy}/H [def: in order that] bikhdey{bkhdy}/H
keglye/S [f] [def: bowling pin]
kegn/P [def: against, concerning]
	antkegn/P [def: across from, opposite, vis-à-vis] /Idik
	akegn/P [def: across from, opposite, vis-à-vis; near (in time)] /Idik
	dakegn/P derkegn/P gegn/P [def: against]
	kegnvart [m?] [def: present time] [usage: not recommended]
	kegner/S [m] [def: opponent] /Iish [def: opposite; in opposition]
		kegnershaft/N [f] [def: opposition]
		[idiom: onnemen dem tsad funem kegner = play devil's advocate] [note: V]
		[idiom: zikh onshteln farn kegner = play devil's advocate] [note: V]
	gegn/V/T /Gon [def: meet unexpectedly] % bug: doesn't give ongegegnt
		ongegegnt/A [def: met unexpectedly]
	bagegn/V/Bbagegnt [def: meet (with "zikh mit")]
		bage'genish/N [n] [def: meeting, encounter]
	[idiom: kegn iber = akegn iber = across from]
kehile{k|hylh}/Xkehiles{k|hylwT}/H [f] [def: Jewish community] /Idik
	kool{k|hl}/H [n/m] [def: community] /Ish [def: communal]
		rosh_hakool{roS-hk|hl} [m] [def: community leader]
	kool{k|hl}/V/T [def: participate in communal events] % I. J. Singer
keile{K#ylw}/H [def: as if]
kekhle/V/T kikhle/V/T [def: pamper]
kel/N [f] [def: throat] 
	[idiom: linke kel = esophagus, windpipe (body part)]
keler/S [m] [def: cellar]
	kelner/S [m] /Iish ke'lnershe/S [f] ke'lnerke/S [f] kelnerin/S [f] [def: waiter, waitress]
	vaynkeler/S [m] [def: wine cellar; tavern]
kelishek/Xkelishkes /D kelishok [m] [def: small drinking glass]
kelnish [m] [def: cologne (fragrance)
	[idiom: kelnish vaser = eau de Cologne]
kelnye/S [f] [def: coach-box]
kemat{Kmet}/H [def: almost]
kemf/V/T [def: struggle]
	bakemf/V/Bbakemf [def: fight, contest]
	kemfer/S [m] ke'mferin/S [f] [def: fighter]
	ke'mferish/A [def: competitive, eager to fight] 
		klasnke'mferish/A [def: pertaining to class struggle] 
		kemferishkayt/N [f] [def: pugnaciousness] 
	kamf/N [m] [def: fight, struggle]
		klasnkamf/N [m] [def: class struggle]
		lebnskamf/N [m] [def: struggle for life] 
		oksnkamf/N [m] [def: strife of bulls]
keminik [m?] [def: cumin (spice)]
keml/N [m] [def: camel]
kemp/S [m] [def: camp (English)] kemper/S [m] [def: camper (English)]
	zu'merkemp/S [m] [def: summer camp]
kempe/S [f] [def: small island]
kempus/N [m] [def: campus (University)] % Forwards: Yankev Goldshteyn
	kampus/N [m] [def: campus (University)] % Forwards: S-R Schaechter
ken/V/T [def: be able, know]
	/Goys [def: be expert at (with "zikh oyf")] 
	kon/V/T [def: be able]
		konyo'k/Ees [m] [def: forte]
	baken/V/Bbakant [def: recognize; introduce to or acquaint with (with "mit"); meet (with "zikh mit")]
		baka'nt/K [def: famous, well known]
		umbakant/A [def: unknown] umbakenevdik/A [def: unrecognizable]
			bakantshaft/N [f] [def: acquaintance]
		bakant-makhung/N [f] [def: announcement]
	derken/V/Bderkent [def: recognize]
		derkentshaft/N [f] [def: relationship (interpersonal)]
	onerken/V/Bonerkent [def: recognize] onerkenung/N [f] [def: recognition]
	kener/S [m] [def: expert] kentnish/N [def: knowledge]
		ka'ntkener/S [m] [def: local expert, guide] % Forwards
		kentlekh/A kentik/A kontik/A [def: apparent, marked]
		kentshaft/N [f] ke'ntenish/N [n] derkentenish/N [n] kentshaft/N [f] [def: knowledge]
		[idiom: shlisn kantshaft = become acquainted]
		shprakhkener/S [m] [def: linguist, polyglot]
	voylke'nevdikayt/N [f] [def: scholarship, learning]
kenig/N [m] /D /Ilekh kinig/N [m] [def: king] /Ilekh [def: kingly]
	kinigin/S [f] kenigin/S [f] [def: queen]
	kinig/V/T [def: rule] kinigraykh [n] [def: kingdom]
kep/Ees [m] kepke/S [f] [def: cap (men's clothing)]
ker/V/T [def: turn; clean; sweep]
	/Giber/Gavek/Gop/Gtsurik/Giber/Gon/Garoyf/Garoys
	/Goys [def: be spilled (with "zikh"); turn inside out; sweep]
	/Gum [def: return; overturn]
	farker/V/Bfarkert [def: turn around]
		farker [m] [def: traffic; transportation; intercourse]
	ke'reve/V/T [def: turn] /Gop [def: turn away]
		farke'reve/V/Bfarke'revet [def: turn]
	da'khkerer/S [m] [def: thatcher] % Forwards: Hershl Glaser
	koymenkerer/S [m] [def: chimney sweep]
	tsurikker/N [m] [def: return]
	oysker/N [m] [def: turnover; volume]
	umker/N [m] [def: turn around]
	iberke'renish/N [n] iberker/N [m] [def: upset, mess]
	ga'snkerer/S [m] [def: streetcleaner]
	[idiom: meg di velt zikh iberkern = come hell or high water]
ker/V/T [def: could, might (+ infinitive, usually impersonal + dative)]
keramik [f] [def: ceramics]
	keramish/A [def: ceramic]
keren{krn}/H [def: fund, horn]
ke'rmeshl/Eekh [n] [def: party, celebration] 
kern/S [m] [def: kernel, nucleus, core] /Dker/Dkernd [def: seed, pit, nut] 
	koren/V/T [def: remove the core] /Goys
	[idiom: sosne kerlekh = pine nuts]
kerosi'n [m] [def: kerosine] 
kerper/S [m] [def: body] /D /Ilekh [def: physical]
	ke'rperlekhkayt/N [f] [def: physicality] % Der Nister
	ke'rpershaft/N [f] [def: corporation; administrative body]
	farkerper/V/Bfarkerpert [def: incorporate]
		farke'rperung/N [f] [def: incorporation; actualization, realization]
kesele/Ekh [n] [def: type of hat (clothing)]
kesef{Ksf}/Xksofem{Ksfym} [m] [def: money; silver] 
	shove_kesef{Svh-Ksf} [m] [def: something worth money; payment in kind] 
		% bug: doesn't give each word separately
keser{Ksr}/Xksorem{Ksrym} [def: Torah crown (ritual object)]
keshene/S [f] [def: pocket]
	keshenke/S [f] /D 
	[idiom: hobn emetsn in (vestl) keshene = take someone for granted] [note: V]
kesher{kSr}/H [def: connection]
	bekesher{bkSr} [adv] [def: in connection, in contact (with "mit")]
kesl/N [m] [def: boiler; kettle]
	kesler/X/S [m] [def: boilermaker]
	[idiom: groyser kesl = cauldron]
	[idiom: kishef{KySwf}-kesl = witches' cauldron] [note: V]
kest [f] [def: board; financial support]
	/D [def: small box; square]
		gekestlt/A [def: checkered, checked]
	kest [adj] [def: foster] % uninflected, as in "kest eltern" 
	kestnik/Ees [m] [def: boarder; dependent] 
kest/N [f] [def: chestnut (tree)] 
kets_{kc} [m] [def: end; end of days]
ketshop [m?] [def: ketchup (condiment, food)] % Forwards: S-R Schaechter
kevyokhl{KByxwl}/H [def: as it were, God]
keye{ky#h} [f] [def: vomit] % ?? pronunciation
keyfl{Kfl}/H/V/T [def: multiply]
	keyfl{Kfl} [m] [def: multiplication (arithmetic)] 
	far|keyfl|/V/Bfar|keyfl|t [def: multiply]
keylev{KlB}/Xklovem{KlBym}/H [m] [def: (vicious) dog; scoundrel]
	klafte{KlBte}/H/S [f] [def: (human) bitch] [usage: very impolite]
keyli{Kly}/Xkeylem{Klym}/H [f] [def: vessel; utensil]
	kley{Kly}/H [def: vessels of]
	kli_mefoyer{Kly-mfw#r}/H [m] [def: special person; scholar]
	[idiom: puste keyli{Kly} = shallow person]
	[idiom: aroysgeyn fun di keylem{Klym} = lose one's temper]
keyn [def: to] [grammar: with a place name]
keyn keyne [def: not any]
	keyner keynem keynemen keynems [m] [def: nobody]
keysekh [m] [def: Easter (mocking)]
keyser/Xkeysorem{keysorym}/Xkisriyem{kysriim} [m] [def: czar, kaiser, emperor]
	keyzer [m] % variant spelling
	keyserinye/S [def: czarina]
	keyser_{kysr}/Xkeysorem_{kysrym} [m] [def: Kaiser, emperor]
	keyzerlekh/A keyserlekh/A [def: imperial]
keyt/N/D [f] [def: chain]
	keytl/V/T [def: chain together] /Garayn/Gtsu/Gop
	farkeytl/V/Bfarkeytlt [def: chain together]
	haldzkeyt/N [f] [def: (animal) collar]
	shaptsirkeyt/N [f] [def: (animal) leash]
	sprakhnkeyt/N [f] [def: linguistic chain] % Forwards: Yoel Matveyev
keyver{kBr}/Xkvorem{kBrym}/H/D [m] [def: grave]
	key'verl{kBrl}/Xkvo'remlekh{kBrymlekh} [def: grave]
	brider-keyver{brider-kBr} [m] [def: common grave] % Bashevis
	kvo'remdik{kBrymdik}/A [def: gravelike] 
	mekaber{mkbr} [verb] [def: bury (with "zayn")] [usage: lomdish]
	kvure{kBwrh}/Xkvures{kBwrwT}/H [def: burial]
		bes_hakvures{byT-hkBwrwT}/N [m/n] bes_kvures{byT-kBwrwT}/N [m/n] [def: cemetery] 
	kabren{kbrn}/Xkabronem{kbrnym}/H [m] [def: gravedigger]
		kabronish{kbrnish}/A
	kvores{kBrwT}/N [m] [def: cemetery]
		kvo'resman{kBrwTman}/Xkvo'reslayt{kBrwTlayt}/H [m] [def: gravedigger]
		kvo'res{kBrwT}-yid/N [m] [def: gravedigger]
	kabornish{kbrnish}/A [def: pertaining to gravediggers]
	khibet_hakeyver{Hybwt-hkBr} [def: the pains of the grave]
	[idiom: mestn feld = mestn kvorem{kBrym} = wrapping a grave with cotton thread as an amulet for a gravely ill person]
kez/N [m] [def: cheese; money (ganovem-loshn)] /D
	hartkez/N [m] [def: hard cheese] % B. Sandler: Karolina-Bugaz
	shmirkez [m] [def: cream cheese] 
kezayes{KzyT}/H/N [def: morsel the size of an olive] /D
kha kha-kha kha-kha-kha [interj] [def: ha-ha (sound of laughter)]
	khakhinke/S [f] [def: joke] % Avrom Karpinovitsh
khaba'r [m] [def: bribery, graft] /D
	khabarnik/Ees [m] [def: bribable person]
khabedyere [interj] [def: hello (German)] % < German: ich habe die Ehre
khabre/S [f] khaber [m?] [def: centaurea (flower)] % Chava Rozenfarb: Botshani 
khad{Hd}/H [def: one (Aramaic)]
	kheyder_meyukhed{Hdr-mywHd} [m] [def: private room]
khadatay [def: petitioner (Russian ходатай)] 
khag{Hg}/Xkhagem{Hgym}/H [m] [def: holiday]
	khoge{Hg#}/Xkhoges{HgwT}/Xkhagoes{HgowT}/H [def: Easter; Christian festival]
khaki [m] [def: khaki (color, material)] [adj] [grammar: indeclinable]
khal{Hl}/H [def: occurs]
khalamey' [adj] [def: dirty (vulgar insult)]
khalapenyo [m?] [def: jalapeño (pepper)] % Forwards: S-R Schaechter
khala't/N/D [m] [def: robe, housecoat, smock, frock (clothing)] 
	shtubkhala't/N [m] [def: housecoat]
khale{Hlh}/Xkhales{HlwT}/H [f] [def: egg bread, challah (food)]
	[idiom: khale{Hlh} nemen = remove ritual amount of dough; steal (sherer-loshn)]
khalef{Hlf}/Xkhalofem{Hlfym}/H [m] [def: knife (especially for ritual slaughter)] /D
	khalfn{Hlfn}/Xkhalfonem{Hlfnym} [m] [def: money changer]
khalesh{HlS}/H/V/T [def: faint]
	far|khalesh|/V/Bfar|khalesh|t [def: faint]
	khaloshes{HlSwT}/H [n] [def: faint, swoon; nausea] /Idik
	khulshe{HwlSh}/Xkhulshes{HwlSwT} [f] [def: plague; feeling faint]
	kholesh{HlwS} [m] [def: sickly person]
khalif/N [m] [def: caliph] 
khalitse{Hlych} [f] [def: ceremony to free sister-in-law to remarry (religious)]
khalupe/S [f] [def: shack, shed; cottage] khalupke/S 
khalyastre/S [f] [def: gang]
kham/Ees [m] khamule/S [m] khamoyle/S [m] khamruk/Es [m] [def: boor, ignoramus] 
khameleon/N [m] [def: chameleon (animal)] 
khamer{Hmwr}/Xkhamoyrem{Hmwrym}/H [m] [def: donkey, ass; prosecutor (slang)] % Michael Wex: prosecutor
	khamer_eyzl{Hmwr-eyzl} [m] [def: womanizer; lecher] % from Genesis 32
	khameru'k/Ees [m] [def: lout, goon]
khaneke{HnwKh}/H [m] [def: festival of Khanuke]
	khanu'kes_haba'yis{HnwKT-hbyT} [f] [def: dedication of a house; housewarming]
khaos/N [m] [def: chaos; confusion]
	khaotish/A [def: chaotic, confused]
khap/V/T [def: catch, grab; excite; realize (with "zikh"); hasten (with "zikh")]
	/Gariber/Garop/Garoys/Garum/Goyf/Goys/Gunter/Gop/Gtsu/Gmit/Gtsurik/Gavek
	/Gon [def: grab ahold of; ignite (with "zikh")] 
	/Garayn [def: enter in spite of difficulties (with "zikh")] 
	/Giber [def: snack] 
	/Garoyf [def: embark, climb aboard (with "zikh")] 
	onkhap/N [m] [def: grabbing; attack, fit; strange example]
	derkhap/V/Bderkhapt [def: grab]
		[idiom: derkhapn dos harts = take refreshment]
	farkhap/V/Bfarkhapt [def: grab, hijack, kidnap, capture; captivate; spellbind]
		farkhaper/S [m] [def: captor; kidnapper]
		farkhapung/N [f] [def: kidnapping, capture; hijacking]
		farkhaptkayt/N [f] [def: fascination, absorption, preoccupation]
		[idiom: vern farkhapt = die suddenly; disappear] % Michael Wex
	tsekhap/V/Btsekhapt [def: grab]
	farkhaper/S [m] [def: hijacker] 
	fey'glkhaper [m] foy'glkhaper [m] [def: bird catcher]
	fi'shkhaper/S [m] [def: fisherman]
	khaperay'/N [n] [def: grabbing]
		iberkhaperay'/N [m] [def: snack food] 
		kha'perish/A [def: greedy] 
	kha'penish/N [n] [def: rush, haste] 
		oy'skhapenish/N [n] [def: calamity; run on (merchandise) (with "oyf")]
	khaper/S [m] kha'perin/S [f] onkhaper/S [m] /Iish onkha'perin/S [f] [def: grabber]
	-/Xkhaperlekh [def: tag (game)] 
	khapik/A [def: hasty] umkhapik/A [def: slow, deliberate] 
		khapikayt/N [f] [def: hastiness] 
	khap-lap [adv] [def: helter-skelter; haphazardly] 
kharakter/S/N [m] [def: character] /Iistish [def: characteristic]
	kharakterish/A [def: characteristic] [usage: inadmissible]
	kharakteristik/N [def: characteristic]
	kharakterizi'r/V/Bkharakterizi'rt [def: characterize]
kharizmatish/A [def: charismatic] % Forwards
kharif{Hryf}/H [def: sharp] /Iish
	kharifes{HryfwT}/H [def: sharpness]
	mekharef_umegadef{mHrf-umgdf} [verb] [def: blaspheme (with "zayn")]
kharote{Hrth}/Xkharotes{HrtwT}/H [f] [def: regret]
	[idiom: hobn kharote{Hrth} = regret]
kharoyses{HrwsT}/H [def: a Passover food]
kharpe{Hrph}/Xkharpes{HrpwT}/H [def: disgrace]
	bekharpe{bHrph}/H [adv] [def: in disgrace] % Menakhem Kipnis
khart/N/Ees [m] khort/N/Ees [def: greyhound (animal)] 
khas{Hs}/H [interj] [def: God forbid (with "- vekholile{|uHlylh})]
	vekhas{|wHs} [interj] [def: God forbid (with "kholile -")]
khashmoynoem{HSmwno|ym}/H [def: Hasmoneans]
khasme{HTme}/Vkhasmenen{HTmenen}/T [def: seal] /Gop/Gtsu
	/Gunter [def: sign]
	khsime{HTymh}/Xkhsimes{HTymwT}/H [def: seal, approval, ratification]
	farkhasmet{farHTmet}/A [def: sealed]
khata [interj] [def: shut up! (with "pokrishke")]
khate/S [f] [def: shack, hut; cabin] khatke/S [f] [def: small shack] 
khatekhi'zm/N [m] [def: catechism, teaching] 
khatsitse{Hcych}/Xkhatsitses{HcycwT}/H [f] [def: barrier]
khatsos{HcwT}/N/H [def: midnight; midnight prayers]
khaver{HBr}/Xkhaveyrem{HBrym}/H [m] [def: friend, comrade (male); boyfriend]
	/Iish [def: comradely]
	khaverte{HBrte}/S [f] kha'vertorin{HBrtorin}/S [f] [def: girlfriend; comrade (female)]
	khevre{HBrh}/Xkhevres{HBrwT}/H [f] khevraye{HBry#}/Xkhevrayes{HBrywT} [f] [def: gang]
		khevretshke{HBrhtshke}/S [f] [def: group (humorous)] % Stutchkoff
		khe'vreman{HBrhman} [m] [def: one of the gang; playboy; pimp (ganovem-loshn)]
			khevremante{HBrhmante}/S [f] % Forwards: M-S Hoffman
		khevrenik{HBrhnik}/Ees
		oyto-khevre{oyto-HBrh}/H/S [def: car pool] [note: V] 
		[idiom: vayse khevre{HBrh} = kheyder-youngsters]
		khevre{HBrh}-drikung/N [f] khevre{HBrh}-druk/N [f] [def: peer pressure] [note: V] 
		khe'vreshaft{HBrhshaft}/N [f] [def: friendship] % Forwards: Yoel Matveyev
	khaverishkayt{HBrishkayt}/N [f] khavershaft{HBrshaft}/N [f] [def: friendship]
	khaver{HBr}/H/V/T [def: befriend] /Gtsunoyf
		farkhaverung{farHBrung}/N [f] [def: becoming friendly]
	khiber{Hybwr}/Xkhiburem{Hybwrym}/H [m] [def: connection; book, treatise; (mathematics) addition]
		shvarts-khiber{shvarts-Hybwr} [m] [def: completed treatise] % Bashevis
		mekhaber{mHbr}/Xmekhabrem{mHbrym}/H [m] mekha'berte{מחברטע}/S [f] mekha'berin{mHbrin}/S [f] [def: author]
			mekhabershaft{mHbrshaft}/N [f] [def: authorship] % Berish Goldstein
	khevruse{HBrwT#}/H [def: study partnership; group of people]
		bekhevruse{bHBrwT#} [adv] [def: in a group]
khaviv{HByB}/H [def: beloved]
khay{Hy}/H [adj] [def: alive] [m] [def: the number 18]
	khaye{Hyh}/V/T /Gop [def: revive]
	otkhaye{otHyh}/V/Boytkhayet{otHyht} [def: catch one's breadth; rest; refresh, revive] % Avrom Karpinovitsh, Sandler
	khayetshe{Hyhtshe}/V/T /Gop [def: revive]
	khaye/V/T [def: refresh (with "zikh")] % phonetic spelling
	khayem{HAm}/H [m?] [def: life] hakhayem{hHAm} [m?] [def: the life]
	khaye{Hyh}/Xkhayes{HywT}/H /D [f] [def: beast; animal] khayish{Hyish}/A
		shnobl-khaye{shnobl-Hyh}/Xshnobl-khayes{shnobl-HywT} [f] [def: platypus]
	khiyes{HywT} [n] [def: strength]
		[idiom: iz khiyes nit zikher = one's life is in danger]
		[idiom: oysgeyn di khiyes tsu = have a strong desire to]
	kheyune{Hywnh}/H [def: sustenance]
	mekhaye{mHyh}/H [f] [def: pleasure] [def: pleasant; reviving]
		khayes{HywT} [f] [def: pleasure]
		mekhayedik{mHyhdik}/K [def: pleasant; refreshing]
		mekhaye{mHyh}/H [verb] [def: revive (with "zayn")]
		[idiom: a mekhaye{mHyh}! = how marvellous!]
	beys_khayem{byT-HAm} [def: cemetery]
	lekhayem{lHAm} [def: to life! (toast)]
	shehekheyonu{ShHy|ynu} [m] [def: a prayer of thanksgiving for a novelty (with "makhn")]
khayel{HAl}/Xkhayoles{HAlwT}/H [n] [def: army; military]
khazal{Hz″l}/H [def: sages]
khazer{Hzyr}/Xkhazeyrem{Hzyrym}/H [m] [def: pig (animal)] /Ish
	khazerl{Hzyrl}/Xkhazeyremlekh{Hzyrymlekh} [n] [def: pig (diminutive); mumps (disease) (colloquial)]
		ya'm_khazerl{ym-Hzyrl}/Xya'm_khazeremlekh{ym-Hzyrmlekh} [n] [def: guinea pig, Cavy (animal: Cavia porcellusa)]
	khazeray'{Hzyray}/N [n] [def: item in bad taste; messy situation; junk food] 
	khazernik{Hzyrnik}/Ees [m] [def: pork-eater]
khazn{Hzn}/Xkhazonem{Hznym}/H [m] [def: cantor] /Dkhaznd{Hznd}
	khazonish{Hznish}/A [def: cantorial]
	khazones{HznwT} [f] [def: cantorial singing]
	khaznte{Hznte}/S [f] [def: cantor, cantor's wife] 
khazoke{Hzk|h}/Xkhazokes{HzkwT}/H [f] [def: claim to possession or title; (academic) tenure]  [note: V]
	khizek{Hyzwk} [m] [def: support; strengthening]
	mekhazek{mHzk}/H [verb] [def: strengthen (with "zayn")]
khemye [f] [def: chemistry] khemish/A [def: chemical]
	byokhemye [f] [def: biochemistry] byokhemish/A
	elektrokhemye [f] [def: electrochemistry]
		elektrokhemish/A [def: electrochemical]
	stereokhemish/A [def: stereochemical] % Stephen Cohen
	alkhemye [f] alkhimye [f] [def: alchemy]
	khemiker/X/S [m] [def: chemist]
	khemikalye/S [f] [def: chemical]
khes{Hʼ}/H [def: letter Khes]
khesed{Hsd}/H [def: generosity]
	khosed{Hsyd}/Xkhsidem{Hsydym}/H [m] [def: Chassid, follower]
		khsidish{Hsydish}/A [def: Chassidic]
		khosedl{Hsydl}/Xkhsidemlekh{Hsydymlekh} [def: Chassid (diminutive); a slow Jewish dance]
		khsides{HsydwT}/H [def: Chassidic philosophy; piety]
		khsidi'zm{Hsydizm} [m] [def: Chassidism] khsidish{Hsydish}/A [def: Chassidic]
		khsidak{Hsydak} [m] [def: Chassid (pejorative)] % Sholem Aleykhem
	khosed_shoyte{Hsyd_Swth} [m] [def: foolish zealot]
kheshbn{HSbwn}/Xkheshboynes{HSbwnwT}/H [m] [def: account; calculation]
	kheshbn{HSbwn}/V/T /Goys [def: reckon] 
	bank-kehshbn{bank-HSbwn}/Xbank-kheshboynes{bank-HSbwnwT} [m] [def: bank statement]
	din-vekheshbn{din-|wHSbwn} [m] [def: report, reckoning]
kheshvn{HSvn}/H/Idik [m] [def: month of Kheshvan]
khesorn{Hsrwn}/Xkhesroynes{HsrwnwT}/H [m] [def: defect]
	khoserdeye{Hsr-deh} [adj] [def: crazy] [grammar: predicative] /Idik
		khoserdeyenik{Hsr-dehnik}/Ees [m] [def: crazy person]
	khiser{Hyswr} [m] [def: subtraction (arithmetic)] 
khet{Ht#}/Xkhatoem{Hto|ym} [m] [def: sin]
	khatas{Ht#T}/Xkhateysem{Ht#Tym} [def: sin offering; Boer (slang)] % for Boer: from M. Avos "eyn bor yerey khet"
	al_khet{el-Ht#}/H [m] [def: confession]
	khoyte_umakhti_es_horabem{Hwt# |wmHty# #T hrbym}/H [m] [def: sinner who leads others to sin]
	khoyte{Hwt#}/V/T khoyten{Hwt#n}/V/T [def: sin; fornicate]
kheyder{Hdr}/Xkhadorem{Hdrym}/H [m] [def: Jewish religious school; room]
	kheyderl{Hdrl}/Xkhadoremlekh{Hdrymlekh} [m] [def: little rooms]
	dardake_kheyder{drdky-Hdr} [def: entry-level religious school]
	khadre_khadorem{Hdry-Hdrym} [def: innermost or hidden room]
	[idiom: nit oyszogn funem kheyder{Hdr} = not wash dirty linen in public]
kheyfets{Hyfc}/Xkhfeytsem{Hfcym}/H [def: treasure]
kheylek{Hlk}/Xkhalokem{Hlkym}/H [m] [def: portion]
	hinter-kheylek{hinter-Hlk}/Xhinter-khalokem{hinter-Hlkym} [m] [def: hindpart; buttocks]
	unter-kheylek{unter-Hlk}/Xunter-khalokem{unter-Hlkym} [m] [def: underpart; buttocks; thigh (chicken)]
kheylev{HlB}/H [n] [def: tallow; non-kosher fat from kosher animal] /In
	/Idik [def: tallowy; greasy; dirty, salacious]
	khey'levdikay't{HlBdikayt}/N [f] [def: greasiness]
	makhloyke{mHlwk|h}/Xmakhloykes{mHlwkT}/Xmakhloykesn{mHlwkTn}/H [def: dispute, quarrel]
		mekhalek{mHlk} [verb] [def: disagree (with "zayn")]
kheyme{Hmh} [f] [def: anger]
kheyn{Hn}/H [m] [def: grace]
	kheynevdik{Hnevdik}/A [def: graceful; cute, attractive; charming]
		shvarts-kheynevdik{shvarts-Hnevdik}/A [def: darkly handsome]
	bakheynt{baHnt}/A [def: charming]
	kheyndl{Hndl}/V/T [def: flirt (with "zikh")]
		kheyndl{Hndl}/Eekh [n] [def: flirtatious gesture]
	umkheyn{umHn} [m?] [def: dislike]
	noyse-kheyn{nwQ#-Hn} [verb: please (with "zayn bay")]
	[idiom: noyse_kheyn{nwQ#-Hn} zayn (bay ...) = please ...]
	[idiom: gefinen kheyn{Hn} (bay ...) = please ...]
	[idiom: makhn kheyn{Hn} = flirt]
	[idiom: makhn kheyndelekh{Hndelekh} = pander, flirt]
	[idiom: varfn an umkheyn{umHn} oyf im = take a dislike to him]
kheyrem{Hrm}/Xkharomes{HrmwT}/H [def: ostracism; ban]
	[idiom: freg mikh b|kheyrem = I have no idea]
kheyshek{HSk}/H [m] [def: eagerness; desire]
	onkhey'shekdik{onHSkdik}/A [def: disinclined, unwilling, uneager]
khibe [adv] akhibe [adv] [def: unless]
khiber{Hybwr}/Xkhiburem{Hybwrym} [m] [def: addition (mathematics); treatise; religious text with Yiddish translation]
khided{Hydwd}/Xkhidudem{Hydwdym}/H [m] [def: joke, sharp remark; sharpness of speech]
khidesh{HydwS}/Xkhidushem{HydwSym}/H [def: novelty, surprise, wonder]
	/Idik /Ilekh
	khidesh{HydwS}/H/V/T [def: marvel]
	farkhidesh{farHydwS}/V/Bfarkhidesht{farHydwSt}/H [def: astound]
		farkhideshtkayt{farHydwStkayt}/N [f] [def: astonishment]
khike/V/T [def: cut the throat]
	khik [def: sound of cutting]
	[idiom: makhn emetsn khik = cut someone's throat]
khikhe/V/T khikhike/V/T [def: giggle] /Gfunander
	khikhikendik/A [def: giggling] % Rokhl Korn: shotns
khilek{Hylwk}/Xkhilukem{Hylwkym}/H [m] [def: difference]
	[idiom: subtiler khilek{Hylwk} = diner khilek{Hylwk} = fine line]
khilel{Hylwl}/H [m] [def: profanation]
khilnik/Ees [m] [def: foot (klezmer jargon)] % Stutchkoff
khimere/S [def: chimera] khimerish/A
khinekh{Hynwx}/H [def: Jewish education; dedication, inauguration] [m] 
	mekhanekh{mHnx}/H [verb] [def: teach, initiate, educate Jewishly (with "zayn")] 
khinem{Hynm}/H [def: nothing] bekhinem{bHynm}/H /Idik [def: free]
khinin [m] [def: quinine] 
khipozn{Hypzwn}/H [m?] [def: speed] 
	bekhipozn{bHypzwn}/H [adv] [def: rapidly, quickly, hastily] /Idik
khirek{Hyryk}/H [def: a Hebrew punctuation mark, pronounced i or ɪ]
khirurg/N [m] [def: surgeon] /Iish
	khirurgye/S [f] [def: surgery]  
	nevrokhirurg/N [m] [def: neurosurgeon]
khitre/A [def: sly, cunning, shrewd] khitra'k/Ees [m] [def: sly person] 
	khi'treve/V/T [def: act shrewdly, slyly] /Giber [def: outsmart]
	khi'trekayt/N [f] [def: cunning, shrewdness] 
khizoyen{Hzyun}/Xkhizyoynes{HzyunwT} [m] [def: prophetic vision]
khkire{Hkyrh}/Xkhkires{HkyrwT}/H [m] [def: philosophy; speculation]
	khkire{Hkyrh}/V/T [def: speculate (with "zikh")]
	khakren{Hkrn}/Xkhakronem{Hkrnym}/H [m] [def: philosopher]
	khakren_{Hkren}/V/T [def: investigate deeply (with "zikh")]	
	khoyker{Hwkr}/Xkoykrem{Hwkrym}/H [m] [def: philosopher; investigator]
khlam [m] [def: junk; rags]
	khlamidnik/Ees [m] [def: clothing theif (thieves' argot)]
khlapotsh/V [def: plead (Russian)] 
khline/V/T [def: fill] /Gon [def: over-fill] % Forwards: Boris Sandler
	farkhline/V/Bfarkhlinet farkhlinye/V/Bfarkhlinye [def: fill; gag, choke on a drink (with "zikh")]
khlipe/V/T [def: sob] /Garoys/Gfunander
	tsekhlipe/V/Btsekhlipet [def: sob (with "zikh")]
	khlip/N [m] gekhli'p/N [m] [def: sob]
	khli'penish/N [f] [def: sobbing]
khlop/Ees [def: boor; churl; peasant]
khlor [m] [def: chlorine (Cl)]
	khlorid [def: chloride]
	hidrokhlor [def: hydrogen chloride (HCl; chemical)]
	tsinkkhlorid [def: zinc chloride (ZnCl2; chemical)]
khlyape/V/T [def: splash]
	khlyap [m?] [def: heavy rain]
khlyeptshe/V/T [def: guzzle] % Harduf
khmal/N [m] khmalye/S [def: powerful whack, smack] [pronunciation: khmaL]
	[idiom: gebn a khmal = smack]
khmare/S [f] [def: cloud] 
	khmare/V/T [def: be cloudy (with "zikh")] /Gon
	khmure/V/T [def: be cloudy (with "zikh")] /Gon
		khmurak/Ees [n] [def: pessimist] % Stutchkoff
		farkhmuret/A [def: overcast, cloudy]
	farkhmare/V/Bfarkhmaret [def: cloud up] 
	khmarne/A khmurne/A khmarik/A [def: dreary, gloomy; cloudy] 
khmime{Hmymh}/Xkhmimes{HmymwT}/S/H [f] [def: heat]
khnife{Hnyfh}/Xkhnifes{HnyfwT}/H /D [f] [def: toadying; flattery] /Idik
	khnifenik{Hnyfhnik}/Ees [m] [def: toady, flatterer]
	khanfe{Hnfe}/Vkhanfenen{Hnfenen}/T [def: butter up, flatter] /Gunter
	khoynef{Hwnf} [m] [def: sycophant]
khnyok/Ees [m] [def: bigot] 
khodak/Ees [m] [def: wooden shoe (clothing)]
khodo'be [def: cattle]
	khudo'be [f?] khadobe [f?] [def: poor possessions]
kho'dorom [def: topsy-turvy; be in confusion (with "geyn")]
khok{Hwk}/Xkhukem{Hwkym}/H [m] [def: law, custom] khukas{HwkT} [def: law of]
khokhem{Hxm}/Xkhakhomem{Hxmym}/H [m] [def: sage; fool (ironic)]
	khokheml{Hxml}/Xkhakhomemlekh{Hxmymlekh} [m] [def: little sages]
	khokhme{Hxmh}/Xkhokhmes{HxmwT}/H [f] [def: wit; wisdom; punchline] /D /Idik
	vay-khokhem{vay-HxM} [def: person incapable of telling a joke] % Hoffman
	tsekhokhme{tseHxme}/V/Btsekhokhmet{tseHxmet} [def: make a joke] % Stutchkoff
	khokhme{Hxmh}/V/T [def: make a clever statement] /Gunter
	[idiom: talmed{Wlmyd} khokhem{Hxm} = sage (Jewish)]
	[idiom: yofe{yfh} shtike{Styk|h} lekhakhomem{lHxmym} = silence is seemly for the wise]
khokhotshe/V/Bkhokhotshet [def: guffaw, laugh coarsely]
khol{Hwl}/H [def: not sacred] /Lbe{b} [adv] [def: not sacred]
	kholile{Hlylh}/H [def: God forfend, God forbid]
		/Lve{|w} [interj] [def: may it not be (with "khas -")]
kholel{Hll}/S/H [m] [def: opening; open space, void] /Ish
kholem{Hlwm}/Xkhaloymes{HlwmwT}/H [m] [def: dream]
	kholem{Hlwm}/H/V/T /Goys [def: dream (with "es ... zikh" +dative)]
	farkholemt{farHlwmt}/A [def: in a daze]
		farkholemtkayt{farHlwmtkayt}/N [f] [def: daze]
	poyser-kholem{pwTr-Hlwm} [verb] [def: explain a dream (with "zayn")]
	[idiom: kumen tsu kholem = appear in a dream]
kholerye/S [f] kholere/S [f] [def: cholera, plague (disease); raging person, shrew]
	kholere_{Hlyre} [f] [def: cholera, plague] % variant (Hebrew חולי רע)
khole'sterol [m] [def: cholesterol (chemical)]
kholets{Hlwc}/Xkalutsem{Hlwcym} [m] [def: pioneer]
kho'livke/S [f] [def: upper part of a shoe (clothing)]
kholodne/A [def: cool (Slavic)]
	kholodirnik/Ees [m] [def: refrigerator] % Eve Jochnowitz
	kholode'ts [m] [def: jellied meat (food) (Russian холодец `aspic')]
kho'lyeve/S kho'leve/S kho'levke/S [def: upper part of a boot (clothing)]
	[idiom: makhn fun moyl a kholyeve = put one's foot in one's mouth]
khomet khoment [?] [def: bridle (horse)] % Shpiglblat
	khometnik/Ees [m] [def: saddle-maker]
khomets{Hmc}/H [def: leavened food] /Idik /Iik
	bedikes_khomets{bdykT-Hmc} [f] [def: ritual search for leaven before Passover]
khomishoser{HmSh-eQr}/H [def: 15th of a month]
khonte/S [f] khone/S [f] [def: prostitute (vulgar)]
khopte/S [f] [def: gang, horde]
khor/N [m] [def: chorus, choir]
	folkskhor/N [m] [def: folk chorus]
khored{Hrd}/Xkhareydem{Hrdym} [m] [def: ultra-pious Jew]
	khareydish{Hrdish}/A [def: ultra-pious]
khoreogra'f/N [m] [def: choreographer]
	khoreografye/S [f] [def: choreography]
khorets{Hrwc}/Xkarutsem{Hrwcym} [m] [def: creative, imaginative man]
khorev{HrwB}/H [def: destroyed, laid waste] /A /Idik
	khurbn{Hwrbn}/Xkhurbones{HwrbnwT}/H [m] [def: mess; Holocaust; destruction, ruin]
	khurve{HwrBh}/Xkhurves{HwrBwT}/H [m] [def: ruin]
	farkhurvet{farHwrBht}/A [def: ruined]
	[idiom: khorev{HrwB} makhn = annihilate, destroy]
khorkhl/V/T [def: rattle, wheeze; snore; growl (like a dog)] /Gunter
	khorkhlenish/N [n] [def: wheezing]
khoser{Hsr} [adj predicative] [def: lacking, defective] 
khoshev{HSwB}/H/K [def: important; respected]
	 khshives{HSyBwT}/H [f] [def: importance; respect; cachet]
khosn{HTn}/Xkhasonem{HTnym}/H [m] [def: bridegroom; engaged man] /Idik
	/Dkhosnd{HTnd}
	khasene{HTwnh}/Xkhasenes{HTwnwT}/H [f] [def: marriage]
	mekhu'tn{mHwWn}/Xmakhetonem{mHwWnym}/H [m] [def: son- (daughter-) in-law's father; honored guest] [usage: also father-in-law of groom until the marriage] /Idik
		makhetey'neste/S [f] [def: son (daughter) in-law's mother]
		mekhuto'neshaft{mHwWnySaft} [f] [def: connection by marriage]
	khosnvayz{HTnvayz} [adv] [def: when a bridegroom] % Kulbak: Zelmenyaner
	[idiom: oyfshpiln a khasene{HTwnh} = make a scene]
	[idiom: vern a khosn{HTn} = become engaged]
khotsh [conj] [def: although; at least; you might as well (with imperative)]
	khotshe [conj] khotshbe [conj] khotshbi [conj] [def: although]
khotsi{Hcy}/H [def: half] bekhotsi{bHcy} [adv] [def: in halves]
	[idiom: bekhotsi{bHcy}-khinem{Hymwm} = practically free]
khove/V/T [def: cultivate; raise; keep, foster] /Goys/Goyf
khoydesh{HwdS}/Xkhadoshem{HdSym}/H [m] [def: month] /Idik/Ilekh
	mekhadesh{mHdS}/H [verb] [def: renew, bless (with "di levone") (with "zayn")] 
	bris_khadoshe{bryT-HdSh} [def: New Testament] 
	[idiom: honik-khoydesh{HwdS} = honeymoon]
khoykhe/V/T [def: deceive, cheat] % Harkavy
	khoykhe/S [m] [def: dealer in frippery; deceiver, cheater] % Harkavy
khoyle{Hwlh}/Xkheloyem{Hwlo|ym}/Xkhoylem{Hwlym}/H [m] [def: sick person] /Idik
	khala's{HlaT}/Xkhala'sn{HlaTn}/H [def: sickness]
		[idiom: shvere khalas{Hl#T} = epilepsy (disease)]
	makhle{mHlh}/Xmakhles{mHlwT} [f] [def: sickness]
	mevaker_khoyle{mBkr-Hwlh} [verb] [def: visit the sick (with "zayn")]
	[idiom: a gevise makhle{mHlh} = a bitere makhle{mHlh} = yene makhle{MHlh} = cancer]
khoymer{Hwmr} [m] [def: matter (not spirit), flesh, substance] /Idik
	[idiom: kal{kl} vekhoymer{|wHwmr} = all the more so]
khoyshekh{HwSx}/H [m] [def: darkness] /Idik [def: dark]
	khoyshekh{HwSx}/A [def: dark] % I. J. Singer
	farkhoyshekht{farHwSxt}/A [def: blackened; depressed]
	khashkhes{HSxwT}/N [n] [def: profound darkness; spiritual darkness]
	[idiom: vet zikh ton khoyshekh{HwSx} = you'll be sorry (threat)]
khoyv{HwB}/Xkhoyves{HwBwT}/H [m] [def: obligation; debt]
	far|khoyv|/V/Bfar|khoyv|t [def: obligated]
	khoyvas{HwBT}/H [def: obligation of]
	mekhayev{mHyB} [verb] miskhayev{mTHyB} [verb] [def: obligate (with "zayn")]
		mekhuyev{mHw|yB}/H [def: obligated]
		miskhayev{mTHyB}/H [def: obligated (with "zikh zayn")]
	khiyev{HywB}/H khayev{HAB}[def: obligated]
	hiskhayves{hTHIBwT}/H/N [n] [def: obligation]
	miskhayev{mTHyB}/H [verb] [def: obligate; be obligated (with "zayn")] 
	bal_khoyv{bel-HwB}/Xbaley_khoyves{bely-HwBwT}/H [m] [def: creditor]
khoyzek{Hwzk}/H [m] [def: mockery, ridicule]
	/V/T [def: mock] /Gop
khoyzer{Hwzr}/H [verb] [def: return (with "zayn")] 
	makhzer{mHzwr}/Xmakhzorem{mHzwrym}/H [def: holiday prayerbook]
	khazr{Hzr}/H/V/T [def: repeat] /Giber/Gayn
		iberkhazerung{iberHzrung}/N [f] [def: repetition]
	khazore{Hzwrh}/S [f] [def: repetition; regurgitation; return of product to vendor]
	[idiom: khazores{Hzwrh} hashats{hS″C} = reader's repitition of the Amidah prayer]
khrabye/S [m] [def: count (nobleman) (Polish hrabia)]
	khrabine/S khrabinye/S [f] [def: countess]
khrake/V/T [def: hawk; spit]
	khrake/S [f] [def: phlegmy spit]
khrashe/V/T [def: beautify (Russian)] /Goyf
khratshe/-khratshe tsekhratshe/V/Btsekhratshet [def: unbutton]
khremzl/Eekh [n] [def: Passover pancake (food)] 
khrestomatye/S [f] [def: reader (type of book), casebook, anthology]
khreyn [m] [def: horseradish]
khripe/V/T [def: rasp, grate] khripik/A [def: rasping]
	farkhripe/V/Bfarkhripet [def: grow hoarse (with "zikh")] % Avrom Karpinovitsh
khrishtshene [f] kroshtshine [f] [def: tip, gratuity (to a non-Jewish worker)] % Stutchkoff
khrizanteme/S [f] [def: chrysanthemum (flower)]
khrom [m?] [def: suede; Morocco leather (fabric)]
khrom [m] [def: chromium (Cr)] 
	khromosom/N [m] [def: chromosome] 
	tsitokhrom/N [m] [def: cytochrome (physiology)] % Forwards: Sholem Berger
khromtshe/V/T [def: gnaw; crunch] khroptshe/V/T khromke/V/T khrupe/V/T
	khromtshevdik/A [def: crunchy] % Berish Goldstein: Der Hobit
	khropevat/A [def: rough-surfaced]
khronologye/S [f] [def: chronology] 
	khronologish/A [def: chronological] 
	khronik [f] khronike/S [def: chronicle; annal]
		khro'niker/X [m] [def: chronicler, historian]
	khronish/A [def: chronic]
	anakhroni'zm/N [m] [def: anachronism]
	sinkhronizi'r/V/Bsinkhronizi'rt [def: synchronize] 
khrope/V/T [def: snore] /Garoys/Gop
	khroper/S [m] [def: snorer]
khruke/V/T [def: grunt] 
	khruk/Ees [m] [def: grunt (sound of a pig); swine (insult)]
khrushtshe/V/T [def: gnaw]
	tsekhrushtshe/V/Btsekhrushtshet [def: noisily chew bones into small pieces]
khshad{HSd}/Xkhshodem{HSdym}/H [m] [def: suspicion]
	khshodemdik{HSdymdik}/A [def: suspicious] % Forwards: B. Sandler
	khoshed{HSwd}/A [def: suspicious, fishy]
	khoyshed{HwSd} [verb] [def: suspect (with "zayn")]
	khoshed{HSwd}/Xkhshudem{HSwdym} [def: suspect]
khshash{HSS}/Xkhshoshem{HSSym}/H [m] [def: suspicion]
khukhe_utlule{Hwx#-|wtlwl#} [f] [def: mocking, laughter, lampooning]
khuliga'n/Ees [m] [def: hooligan, ruffian] /Iish
	khuligani'zm/N [m] [def: hooliganism, vandalism]
khumesh{HwmS}/Xkhumoshem{HwmSym}/H [m] [def: Pentateuch]
khumre{Hwmr#}/Xkhumres{HwmrwT} [def: stringency]
khumus [m?] [def: hummus (food)] % Forwards: S-R Schaechter
khupe{Hwph}/Xkhupes{HwpwT}/H [f] [def: wedding canopy]
	[idiom: geyn tsu der khupe{Hwph} = get married (poetic)]
	[idiom: shteln a khupe = arrange a wedding]
khurme/S [f] [def: persimmon (fruit; Diospyros spp.)]
khush{HwS}/Xkhushem{HwSym}/H [m] [def: sense; feeling] /Idik [def: sensory]
	khush{HwS}/V/T [def: sense (with "zikh")]
	khushem{HwSym} [m] [def: fool; confused person]
	farkhusht{farHwSt}/A tsekhusht{tseHwSt}/A [def: distracted; absentminded]
	her-khush{her-HwS} [m] khush-hashmie{HwS-hSmieh} [m] [def: sense of hearing]
	ze-khush{ze-HwS}  [m] hush-harie{HwS-hr#ieh} [m] [def: sense of sight]
	shmek-khush{shmek-HwS}  [m] hush-hareyekh{HwS-hriH} [m] [def: sense of smell]
	tam-khush{tem-HwS}  [m] hush-hata'm{HwS-hriH} [m] [def: sense of taste]
	tap-khush{tap-HwS}  [m] hush-hamishesh{HwS-hrmySuS} [m] [def: sense of touch]
khushem{HwSym} [m] khushemnik{HwSymnik}/Ees [m] [def: fool; deaf person] % Genesis 46:23
	khushemdik{HwSymdik}/A [def: deaf]
	meykhesh{myHwS}/N [m] [def: pain; frailty, weakness; disease]
khut{Hwt}/H [def: thread]
khutor [m] khuter [m] [def: tiny hamlet] 
khuts{Hwc}/H [prep] [def: except] mikhuts{mHwc} akhuts{aHwc}/P
	khitsoynyes{HycwnywT} [n] [def: appearance; outside]
	bal_khitsoynyes{bel-HycwnywT} [m] [def: spin doctor] [note: V]
	[idiom: sforem{sfrym} khitsoynem{Hycwnym} = secular books]
khutspe{Hwcph}/H [def: gall, impudence, nerve] /Idik [def: brazen]
	khu'tspenik{Hwcphnik}/Ees [m] khu'tspenitse{Hwcphnitse}/S [f] [def: impudent person]
	khu'tspenyak{Hwcphnyak}/N [m] [def: impudent person]
	khotsef{Hcwf}/Xkhatsufem{Hcwfym} [m] khatsufe{Hcwfh}/Xkhatsufes{HcwfwT} [f] [def: impudent or wanton person]
	mekhutsef{mHwcf}/Xmekhutsofem{mHwcfym} [m] mekutsefte{mHwcfte}/S [f] [def: impudent person]
khvalye/S [f] /Idik falye/S val/N vel/N [f] [def: wave]
	khva'lyesvayz [adv] [def: wave after wave]
	khvalye/V/T [def: wave] /Goyf
		tsevalye/V/Btsevalyet [def: full of waves] % Esther Kraytman: Briliantn
	mikrokhvalnik/Ees [m] [def: microwave oven] 
khvat/N [def: one of the gang] /Iish [def: comeradely]
khvorobe/S [f] khvarobe/S [f] [def: illness, plague] [usage: vulgar]
kibets/V/T [def: kibitz, give unwanted advice] 
	kibets/N [m] [def: kibitzing] 
	ki'betser/S [m] ki'betserke/S [f] [def: kibitzer] 
	kibetseray'/N [f] [def: frivolity, mockery]
kibuts{kybwc}/Xkibutsem{kybwcym}/H [m] [def: kibbutz (Israeli commune)]
kide/V/T [def: throw a tantrum (with "zikh") (Russian кидать)] % Yiddish League
kidnep/V/T [def: kidnap (American)]
	ki'dneper/S [m] [def: kidnapper (American)]
kekhl/V/T kikhl/V/T [def: pamper]
kile/S [f] [def: hernia (ailment: vulgar)]
kilo/S [m] [def: kilogram]
kilometer/S [m] [def: kilometer]
kimer/V/T [def: bother, trouble]
kiml [m] [def: caraway seeds; caraway brandy]
	feldkiml [def: mother-of-thyme]
kimpet [f] [def: labor, childbirth] kimpetorin/S [f] [def: woman in childbirth]
kin [m] [def: kindling wood or straw] /Dd
kin/N [m] [def: chin; jaw]
kinare/S [f] [def: artichoke (vegetable)]
kind/Eer [n] [def: child] kindenyu [def: dear child]
	kindele/Xkinderlekh
	kindish/A kindersh/A ki'nderish/A [def: childlike]
	kindvayz [adv] [def: as a child]
	kindhayt/N [f] kindshaft/N [f] [def: childhood]
	kindershkayt/N [f] kinderishkayt/N [f] [def: childishness]
	-/Xkindskinder [def: descendents]
	mentshnkind/Eer [def: human being]
	kinderloz/A [def: childless] [usage: doubtful admissibility]
	mapl{mpyl}-kind/Xmapl{mpyl}-kinder [n] [def: stillborn child] 
	dardake{drdky}-kind/Eer [def: child in entry-level school (about age 3)]
	kestkind/Eer [def: groom who boards with in-laws]
	shtifkind/Eer [n] [def: step-child] /D
	shulkind/Eer [def: schoolchild] % Forwards
	shvesterkind/Eer [n] geshvesterkind/Eer [n] [def: cousin]
		/Xshvesterkinderlekh /Xgeshvesterkinderlekh [def: little cousin]
	melupn{mlwpn}-kind/Eer [n] [def: weak or inexperienced person] [usage: negative only]
	zeygkind/Eer [n] [def: infant] 
	kindl/V/T [def: bear children] 
	[idiom: geyn tsu kind = be in labor]
kine{kyn#h}/H [f] [def: jealousy] /Idik
	mekane{mkn#}/H [def: jealous]
	miskane{mTkn#} [verb] [def: be jealous of (with "zayn in")]
	knoyes{kn#wT} [f?] [def: fanaticism]
ki'nigl/Eekh [n] [def: rabbit]
kino [def: film (theater)] 
	kinematograf/N [m?] [def: cinema, film]
kine_{kinh}/Xkines_{kynwT}/H [f] [def: lamentation]
kirbes/N [m] [def: pumpkin; gourd]
kirke/S [f] [def: axe, pickaxe] 
kirkh [f] [def: church] kirkhe % both variants
kiryum [m] [def: curium (Cm)] 
kirzhner/S [m] kirzhnerke/S [f] [def: hatmaker; furrier] 
kis{Kys}/Xkisem{Kysym}/H [m] [def: money pouch, scrotum] 
kisey{Ks#}/H [m] [def: chair, throne (furniture)]
	beys_hakisey{byW-hKs#} [def: toilet facility, privy, outhouse]
kishef{KySwf}/N/Xkishufem{KySwfym}/H [m] [def: magic; spell, sorcery] /Idik [def: magic]
	kishef{KySwf}/V/T /Goys [def: enchant]
	farkishef{farKySwf}/V/Bfarkisheft{farKySwft} [def: enchant, bewitch, charm]
	makhesheyfe{mxSfh}/Xmakhesheyfes{mxSfwT}/H [f] makhesheyfete{mxSfhte}/S [f] [def: witch]
		mekhashef{mxSf}/Xmekhashfem{mxSfym}/H [m] [def: magician, wizard]
	[idiom: opton a kishef{KySwf} = work a magic trick]
kishke/S [f] [def: intestine (body part); stuffed intestine (food); hose] /D
	tsvelffinger-kishke/S [f] [def: duodenum]
	[idiom: blinde kishke = appendix]
	[idiom: grobe kishke = large intestine, colon]
	[idiom: grode kishke = rectum]
	[idiom: hintershte glaykhe kishke = rectum]
	[idiom: shlyepe kishke = appendicitis] % Forwards: M-S Hoffman
kishn/S [m/n] [def: pillow] /Dkish [def: cushion]
	shney-kishele/Eekh [def: marshmallow (food)]
	fertsl-kishl/Eekh [def: whoopee cushion] [note: V]
	fu'skishele/Ekh [def: ball of foot (anatomy)] % Yiddish League
kislev{Kslw} [m] [def: Kislev (Hebrew month)]
ki'slitse/S [f] [def: apple in sour juice (food)]
kit [m] [def: putty]
	farki'teve/V/Bfarki'tevet [def: glaze (window)] % Kulbak: Zelmenyaner
kite{KyWh}/Xkites{KyWwT}/H [f] kat_{kW} [f] [def: class, group; sect]
kitl/N [m] [def: white robe (religious garment)]
-/Xkitnies{kytnywT} [def: small, edible seeds; Fabaceae (plant family)]
kitser{kycwr}/H [def: short]
	bekitser{bkycwr} [adv] hakitser{hkycwr} [adv] [def: in short]
	mekatser{mkcr}/H [verb] [def: shorten (with "zayn")]
kitsl/V/T [def: tickle] /Idik [def: ticklish]
kitsve{kycBh}/H [f] [def: handout (charity), relief, dole] 
kitye [f] [def: barley] % Stutchkoff
	kitke/S [f] [def: braided challah (food); braided bun ornament]
	kutye [f] [def: cereal with honey and raisins (food)] 
kiyer{Kywr}/S [m] [def: ritual washstand (in a synagogue)]
kizik [m?] [def: animal excrement] % most likely goat (koze)
kizl [def: quartz]
kladovke/S [f] [def: pantry, storeroom (Russian кладовке)]
klafter/X [m?] [def: fathom]
	/Ivayz [def: lengthwise] % Opatoshu: Polishe Velder
	klafter [def: crawl stroke (swimming) (with "leygn")]
klatke/S kladke/S [f] [def: footbridge]
klak/N [m] [def: sound of a fist beating a chest] 
klake/V/T [def: clack (sound of a stork)] % Chava Rozenfarb: Botshani
	tseklake/V/Btseklaket [def: noisily clack (sound of a stork)] % Chava Rozenfarb: Botshani
klal{Kll}/Xklolem{Kllym}/H [m] [def: rule; community]
	haklal{hKll} [adv] [def: in short] beklal{bKll} [adv] [def: in general]
	klal{Kll} [adj] [def: ordinary] [grammar: indeclinable]
	klolem{Kllym}/H  [def: rules]
	koylel{Kwll}/H [def: contains] /Idik [def: general]
	bederekh_klal{bdrx-Kll} [adv] [def: in general] 
	heskem_kulom{hsKm-Kwlm} [m] [def: consensus]
	sheym_hakoylel{Sm-hKwll} [m] [def: category] % Stutchkoff
klamer/V/T [def: squeeze] /Garum/Gayn
	farklamer/V/Bfarklamert [def: squeeze]
	farklem/V/Bfarklemt [def: squeeze]
		farklemt/A [def: upset (emotionally)] 
	tsekelm/V/Btseklemt [def: distress, deject]
	baklem/V/Bbaklemt [def: squeeze]
	klamer/N/Dklemer [m] [def: bracket, vise]
		gre'tklamer/N [m] ve'shklamer/N [m] [def: clothespin] 
	klem/V/T /Gayn [def: squeeze]
		klem/N [m] [def: squeeze, dilemma] 
			klemenish/N [n?] [def: grief, vexation]
				ha'rtsklemenish/N [n?] 
klan/N [m] [def: clan] 
klap/V/T [def: knock, beat] /Garayn/Goys/Gtsu/Gtsuzamen/Gon/Gop/Garop/Gdurkh
	/Gunter [def: squeeze (an udder)] % Menakhem Kipnis
	/Gavek [def: send off (telegram)]
	farklap/V/Bfarklapt [def: knock; combine; nail shut]
	klap/N/Xklep [m] [def: blow]
	klaper/V/T [def: make a knocking noise, clatter, rattle]
		geklaperay'/N [n] [def: knocking, hammering]
		klaper/S [m] [def: beater; rattle; card player]
			/Dkleper [def: door-knocker; rattle]
			/Dti'rkleper [n] [def: doorknocker]
	tseklap/V/Btseklapt [def: knock apart]
	[idiom: homen{hmn}-klaper = Purim rattle]
	gekla'p/N [m] [def: knock, strike]
	kla'penish/N [n] klaperay'/N [n] [def: knocking]
		hartsklapn/S [n?] hartskla'penish/N [n?] [def: beating heart]
	aynklap/N [m] [def: onset] % Forwards: M-S Hoffman
	toytklap/N [m] [def: final blow (with "derlangen")] 
	tsugeklapt/A [def: crazy (person)] % Avrom Karpinovitsh
	klepl/V/T [def: tap on, pat on (with "in")]
	ti'rklepl/Eekh [n] [def: doorknocker]
	[idiom: hargenen{hrgenen} tsvey flign mit eyn klap = kill two birds with one stone]
	[idiom: mit eyn klap = in one fell swoop]
klape{Klpy} [prep] [def: in the direction of, concerning, facing] 
	klape_khuts{Klpy-Hwc} [def: outward, external] 
	klape_pnem{Klpy-pnym} [def: inward, internal] 
klape/S [f] [def: lapel (clothing)]
klapotshe/V/T khlopotshe/V/T [def: worry; expend effort (with "zikh")]
klarine't/N/D [m] klarne't/N [def: clarinet (musical instrument)]
	klarneti'st/N [m] klarnetistke/S [f] [def: clarinet player] 
klas/N [m] [def: class]
	klasik [f] [def: classic literature (subject)] 
		kla'siker/S [m] [def: classic author]
		klasish/A [def: classic] klasik/A
		ershtklasik/A ershtklasish/A [def: first-rate] 
	klasifitsi'r/V/Bklasifitsi'rt [def: classify]
		deklasifitsi'r/V/Bdeklasifitsi'rt [def: declassify] % Forwards: Yankev Goldshteyn
		klasifikator/N [m] [def: classifier]
		klasifitsirung/N [f] klasifikatsye/S [f] [def: classification]
	kokhklas/N [m] [def: cooking class] % Forwards: S-R Schaechter
	mi'tlklas/N [m] [def: middle class] 
	o'vntklas/N [m] [def: evening class]
	tantsklas/N [m] [def: dance class]
	klasnloz/A [def: classless] % Forwards: Shikl Fishman
/Xklasn [def: hopscotch (game)]
klaster{klsWr}/H [def: facial appearance (with "- ponem")]
klatke/S [f] [def: footbridge]
klaun/N [m] [def: cloun] 
klavir [m] [def: clavier, piano (musical instrument)]
klavish/N [m] [def: key] klavyatur/N [f] [def: keyboard]
klay [def: clay]
klayb/V/Bgeklibn [def: choose, gather, harvest, prepare to travel (with "zikh")]
	/Garayn/Gfunander/Gop/Gtsuzamen/Goyf/Gariber/Gtsunoyf/Gunter/Gtsunoyf
	/Gtsu [def: fix; accomodate; clean]
	/Giber [def: be picky]
	/Goys/Gon [def: select]
	/Gon [def: select]
	/Garoys [def: move residence (with "zikh")]
	i'berklay'berish/A [def: picky]
		iberklayber/S [m] iberklay'berke/S [def: picky person] 
	opklayb/N [m] oysklayb/N [m] [def: choice]
	onklayb/N [m] [def: backlog] [note: V] 
	klayber/S [m] [def: collector]
		unterklayber/S [m] [def: collector]
	derklayb/V/Bderklibn [def: arrive to (with "zikh")]
	farklayb/V/Bfarklibn [def: collect; move residence (with "zikh keyn")]
klayen [def: bran; chaff; freckle] /A [def: bran]
klek/N [m] [def: blot, inkblot] 
	[idiom: shpayen klek oyf = berate]
klek/V/T [def: suffice]
klep/V/T [def: attach] /Gtsu/Goys/Garum/Goyf/Gon/Gtsunoyf
	kleb/V/T [def: attach] % variant
	farklep/V/Bfarklept [def: attach; seal (in an envelope)]
	tsukle'penish/N [n] [def: attachment]
	klepik/A klepedik/A [def: sticky; contagious]
		klepikayt/N [f] [def: adhesiveness; contagiousness] 
	klepekhts/N [n?] [def: glue]
klepke/S [f] klipke/S [f] klyopke/S [f] [def: barrel stave]
kler/V/T [def: consider, think, muse] /Goyf/Goys/Giber/Garayn/Gnokh
	kler [m] [def: belief] % Avrom Karpinovitsh
	oyfklerung/N [f] [def: consideration]
	bakler/V/Bbaklert [def: consider] baklerik/A [def: considerable]
	derkler/V/Bderklert [def: clarify, explain]
		derklerung/N [f] [def: clarification, explanation; statement]
		derkle'renish/N [n] [def: clarifying]
	araynkle'renish/N [n] [def: educated guess] % D-H Katz
	farkler/V/Bfarklert [def: consider]
	derkler/V/Bderkler [def: clarify]
	klor/V/T /Goys [def: clarify; understand (with "zikh")]
		oysklorung/N [f] [def: clarification]
	klor/K /Kkler [def: clear; sane; well-versed (with "in")]
		umklor/A [def: unclear]
		klorkayt/N [f] [def: clarity]
	oyfgeklert/A [def: enlightened]
	[idiom: klip un klor = as clear as day]
kleriker/S [def: cleric (Church)] klerika'l/A [def: clerical]
	klerikali'zm/N [n] [def: priesthood]
kleshtsh/S/N [m] klyeshtsh/S/N [m] [def: tick (insect)]
kleter/V/T [def: climb] /Gariber/Goyf/Garoyf
	derkleter/V/Bderkletert [def: reach up to]
klever [m] [def: clover (plant)]
kley/N [m] [def: glue] 
	tsekleyet/A [def: glued] 
	[idiom: tsien dem kley fun di beyner = exhaust/exploit]
kleyd/Eer [n] [def: dress (clothing)] /D [def: skirt; petticoat]
	kleydung/N [f] [def: manner of dress]
	froyenkleyd/Eer [f] [def: women's clothing]
	leybkleyd/Eer unterkleyd/Eer/D [def: underwear]
	shlep-kleyd/Eer [def: skirt with a train] % Bashevis
	kleyd/V/T /Goys/Gon [def: clothe, dress]
		bakleyd/V/Bbakleydt [def: clothe]
	[idiom: khupe{Hwph} kleyd = wedding dress]
	[idiom: eybike kleyder = burial shrouds (euphamism)] % Chaim Grade
kleyme/S [f] [def: mark, stamp (Ukrainian-Russian клейма)] % Sholem Aleykhem
kleyn/Kklen/Itshik/Ilekh [def: small] kleynink/A kleynitshk/A
	kleynikayt/N [f] [def: triviality] [usage: often ironic]
	kleynvayz [m?] [def: childhood]
	farklener/V/Bfarklenert [def: reduce]
		farklenerung/N [f] [def: reduction]
	kleynerheyt [adv] [def: when young]
	kleyner [m] [def: penis (body part) (slang)]
kleyt/N [f] [def: store] /D
	bakaley'-kleyt/N [f] [def: grocery store]
	bakaleyshtshik/Ees [def: grocer]
klezmer/S/Xklezmorem{klezmorym} /Iish [m] [def: musician]
	klezmerl klezmoremlekh [def: musicians]
	klezmurek/Xklezmurkes [def: musicians (pejorative)] 
klike/S [f] [def: clique] 
klima'ks/N [m] [def: climax, highest point] % Stutchkoff
	antiklima'ks/N [m] [def: anticlimax] % Stutchkoff
klima't/N [m] [def: climate]
	aklimatizi'r/V/Baklimatizi'rt [def: acclimatize]
	[idiom: klimatn-bayt = climate change] % Yiddish League
klimper/V/T [def: jingle; clatter]
klin/N/Ees [m] [def: wedge] 
	/Dklinek [n] [def: wedge-shaped printer's mark]
kling/V/Bgeklungen [def: ring; call on the phone]
	/Gon/Gnokh/Gunter/Gop/Giber/Goys/Gtsurik
	tsekling/V/Btseklungen [def: resound; ring loudly (with "zikh")]
	klingl/V/T [def: tinkle] 
	tsekling/V/Btsegklungen [def: ring out]
	farkling/V/Bfarklungen [def: make resound]
	bakling/V/Bbakling [def: toast (celebratory)] % Itsik Kipnis
	klingedik/A klingevdik/A [def: resounding]
		voylklingedik/A voylklingevdik/A [def: virtuosic]
	klang/N [m] geklang/N [m] [def: sound] unterklang/N [m] [def: sound]
		eynklang/N [m] [def: agreement]
			aynklang/N [m] [def: agreement] [usage: inadmissible]
		iberklang/N [m] [def: sound]
		opklang/N [m] [def: echo]
		ovntklang/N [m] [def: evening bell]
		poyknklang/N [m] [def: drumbeat] 
		verterklang/N [m] [def: vocal sounds] % Stutchkoff
		viderklang/N [m] [def: echo; reverberation]
	kling/N [m/f] [def: blade (knife, saw)] /D
	klinger/S [m] [def: bell clapper; coin (money); penis (body part) (slang)]
	kli'ngenish/N [n] klingeray'/N [n] geklingeray'/N [n] [def: ringing]
	klung/N [m] [def: telephone call; sound of a bell] 
		[idiom: b|tsiber{cybwr}-klung = conference call]
klinik/N [f] [def: clinic]
	poliklinik/N [f] [def: clinic]
klipe/S [f] [def: bat, stick; children's game]
klipe_{klyph}/Xklipes{klypwT}/H [def: evil; evil spirit; shrew; bothersome child]
klishe/S [f] [def: cut; printer's engraving] 
klishey'/N [m] [def: cliche] % Forwards: Estraykh
-/Xkliskes -/Xkloyskes -/Xklyotskes -/Xkliskelekh [def: egg-drop noodles (food)]
klog/V/T/Garoys/Gon/Goys/Gtsu [def: complain; accuse]
	/Gayn [def: indict (with "in")]
	baklog/V/Bbaklogt [def: lament, complain (with "zikh")]
	farklog/V/Bfarklogt [def: bewail; accuse someone]
	klogedik/A [def: complaining] % variant to klogndik
	geklogter [m] [def: defendent] 
	onklog/N [m] [def: accusation; complaint]
	klog/N [f] [def: lament; complaint; misfortune]
		[idiom: a klog tsu ... = to hell with ...] % Michael Wex
		[idiom: a klog tsu mir = woe is me] % Michael Wex
	klage/S onklage/S [def: accusation; complaint] [usage: not recommended]
	klo'gerin/S [f] [def: professional mourner]
klole{kllh}/Xkloles{kllwT}/H [f] [def: curse]
kloni'r/V/Bkloni'rt [def: clone]
	klonirung/N [f] klonevanye/S [f] [def: cloning]
	klonirevdik/A [def: clonable] [note: V]
	klon/N [m] [def: clone] [note: V]
	klonir- [prefix] [def: cloning] [note: V] 
klo'nitse/S [def: chopping stump]
klopo't/N [m] klapo't/N [m] [def: trouble, annoyance; concern (Polish klopot)] % Menakhem Kipnis
klor/Kkler [def: clear; sane] klorkayt/N [f] [def: clarity]
	derkler/V/Bderkler [def: clarify]
	klor/V/T /Goys [def: clarify; understand (with "zikh")]
		oysklorung/N [f] [def: clarification]
klostrofobye/S [def: claustrophobia] klostrofobish/A % Forwards: B. Sandler
klotnye/S [def: quarrel; brawl]
	klotnik/Ees [m] klo'tnitse/S [f] [def: quarreler]
klots/Xkletser [m] [def: block of wood; bungler, clumsy person] /Iik
	/Dklets [def: knife hilt]
	farkletsldikt/A [def: unmoving] % Sholem Aleykhem
klotsh/V/T [def: applaud, clap (Polish klaskać)] % Sholem Aleykhem
kloyster/S [m] [def: church]
kloyz/N [f] [def: prayer hall] /Dklayz
	kloyznik/Ees [def: person who is often at the prayer hall]
kloze't/N [m] [def: toilet]
	[idiom: geyn in klozet = go to the toilet]
klub/N [m] [def: club]
	atletik-klub/N [m] [def: health club] [note: V]
	genitung-klub/N [m] [def: health club] [note: V]
	nakhtklub/N [m] [def: nightclub]
	sportklub/N [m] [def: sport club]
klubes klibes [def: hips (body part) (Ukrainian клуб)] % Rokhl Korn: Erd
klubnik/Ees [m] [def: strawberry (Russian клубника)]
klug/Kklig [def: clever]
	klugitshke/A [def: clever] klugitshkerheyt [adv] [def: cleverly]
	klugshaft/N [f] [def: cleverness] klugerheyt [adv] [def: cleverly]
	kligl/V/T /Goys [def: gull, pull a fast one] 
	kli'gerish/A [def: clever, sly]
	klig/V/T [def: be clever (with "zikh")]
klumek/Xklumkes [def: cloth sack carried over the shoulders]
klump/N [m] [def: heap, pile; clump; copse, grove]
	geklumpt/A [def: congealed, clotted] % Berish Goldstein: Der Hobit
klyakne/V/T [def: harden, stiffen]
	farklyakne/V/Bfarklyaknet [def: harden, stiffen]
klyamke/S [f] [def: doorknob, door handle]
klyape/S [f] [def: lapel (clothing); drop leaf (furniture)]
klyatke/S [f] [def: cage]
klyatshe/S [f] [def: mare (female horse)]
klye'nt/N [m] [def: client, customer]
	klyentele/S [f] [def: clientele] % Forwards
klyon/N [m] [def: maple] 
klyotshe [f] klotshe [f] [def: oakum (maybe Rumanian câlţi)] 
	[idiom: a ful moyl klyotshe = of unclear speech]
klyukve/S [f] [def: bilberry (Vaccinium spp.); cranberry (Vaccinium oxycoccos) (Russian клюква)] 
klyuske/S/D [f] [def: eggdrop (food)] 
kmoy{Kmw} [adv] [def: pseudo-, ersatz; as it were]
knafl/X/N [m] [def: heel (shoe) (clothing)] 
knak/V/T [def: crack; crackle] /Gunter/Gtsu/Goys
	farknak/V/Bfarknakt [def: knock]
	knaker/S [m] [def: big shot] [usage: humorous]
	baknakt/A [def: tipsy] % J. Opatoshu: lintsheray
	knakl/V/T [def: crackle; rumble]
		knak/N [m] [def: snap, bank, click; shot (drink: slang); splendor (humorous)]
	knakedik/A [def: crackling]
knal/V/T [def: make a sharp noise]
	/Goyf % Der Nister
knap/K [def: mere; limited] [usage: often ironic]
knas{kns}/H [m] [def: engagement, fine]
	farknas{farkns}/V/Bfarknast{farknst} [def: become engaged (with "zikh")]
	knas{kns}/Vknasenen{knsenen}/T [def: fine]
knaype/S [f] [def: nightclub] % Stutchkoff, Avrom Karpinovitsh
knaytsh/V/T [def: wrinkle]
knekht/X [m] [def: slave]
	knekhtshaft/N [f] [def: slavery]
	laybknekht/X [m] [def: serf]
	farknekht/V/Bfarknekht [def: enslave]
knel/V/T [def: teach, tutor; hold forth (humorous)] /Garayn/Gtsu
	knelung/N [f] [def: job as a tutor] % Sholem Aleykhem
kneses{KnsT}/H [def: assembly] /Lha{h} [def: the assembly]
knet/V/Bgeknotn [def: knead; fashion] /Goys/Gayn/Garoys/Gdurkh
	farknet/V/Bfarknotn [def: knead]
	knetik/A knetevdik/A [def: pliable]
	kne'tenish/N [n] [def: kneading] % Sutskever
	/Dkneyd [def: dumpling (food)] % no positive form
	[idiom: tsi meynt men di hagode{hgdh} tsi di kneydlekh? = is he here for the right reasons?]
kneytsh/V/T [def: wrinkle; crease] /Gayn/Gtsu
	ayngekneytshtkayt/N [f] [def: wrinkled state] % Forwards: Boris Sandler
	kneytsh/N/D [def: wrinkle]
	farkneytsh/V/Bfarkneytsht [def: wrinkle]
	tsekneytsh/V/Btsekneytsht [def: wrinkle]
kni/N/X/Xknies [m/f] [def: knee]
	[note: Weinreich says only m, and Harduf says m/f]
	kni/V/T [def: kneel]
	[idiom: hobn aroysgeboygene kni = bow-legged] [note: V]
	[idiom: hobn arayngeboygene kni = hobn krume fis = hobn tsuzamenklapndike kni = knock-kneed] [note: V]
knik/V/T [def: squash] knik [def: sound of an insect being squashed] 
	kniks/N [m] [def: curtsey; bow]
knip/V/T [def: tie, knot; pinch] /Gtsu/Gon/Gtsunoyf
	/Gayn [def: tie together]
	/Goyf [def: untie]
	knup/N [m?] /Dknip [def: knot; bundle; nest egg]
	knipik/D [m] [def: penknife; gag]
	kniper/S [m] [def: teacher who uses pinching as a common punishment] % Michael Wex
	farknip/V/Bfarknipt [def: tie together, bind]
	knayp/V/T [def: pinch; crimp]
		/Garoys [def: pull out with pliers]
		/Bgeknipn % variant participle
		knayper/S [m] [def: penknife; pliers (instrument); cockroach (insect); stingy person] /D % Stutchkoff
	[idiom: knip in bekl = endearing pinch on the cheek]
	[idiom: knipl beknipl{bknipl} = hand-in-glove, in close companionship]
knish/S [m] [def: knish (filled-dough food); vagina (body part; vulgar)]
knobl/N [m/n] [def: garlic] /Dkneb knoblke/S [f] 
	farknobl/V/Bfarknoblt [def: season with garlic]
knoder/V/T knoyder/V/T [def: fold, crumple] /Gayn [def: hunch]
	tseknoder/V/Btseknodert tseknoyder/V/Btseknoydert [def: crumple]
knokh/N [m?] [def: knob; knuckle] /Iik [def: knobby]
	knekhl/N [n] [def: knuckle; ankle] /Dknekh
		geknekhlt/A oysgeknekhlt/A [def: knuckled] 
knop/Xknep [m] /Dknep [def: button]
	knopke/S [f] [def: press stud (clothing fastner)]
	[idiom: knepl shebeknepl{shbknepl} = closely allied; good buddies]
	farkenpl/V/Bfarkneplt [def: button]
	gorglknop/Xgorglknep [m] [def: Adam's apple (anatomy)]
knosp/N [m] [def: bud] 
knoyl/N [def: ball (of thread, string); lump] /Iik [def: lumpy]
	/Dknaylkh
	knoyl/V/T /Gayn [def: wind; roll]
		/Gtsunoyf [def: tangle]
knoyt/N [m/f] [def: wick] /Dkneyt [def: wick] 
	[idiom: leygn kneytlekh = making candles for charity with string used to measure graves, to seek mercy for a sick person]
	[idiom: leygn emetsn a kneytl = make things worse for someone (being punished)]
knufye{Knwfy#}/Xknufyes{KnwfywT}/H [f] [def: gang; clique]
knyaz/N [def: prince (Polish, Russian)]
koalitsye/S [f] [def: coalition]
kobalt [m] [def: cobalt (Co)] 
kobile/S [f] [def: mare (female horse)]
kod/N [m] [def: code]
	kodi'r/V/Bkodi'rt [def: encode] kodirung/N [f] [def: coding]
	postkod/N [m] [def: zip code, post code] [note: V]
	rayonkod/N [m] [def: area code]
	skanirkod/N [m] [def: bar code] [note: V]
	kodeks/N [m] [def: code of law] 
kodei'n [m] [def: codeine] 
koder/V/T [def: shred]
	koder/S [m] [def: tatter, rag]
kof{Kʼ}/H [m/f] [def: letter Kof]
kogna't/N [m] [def: cognate (word)] % Forwards: Hershl Glaser
	inko'gnito [adv] [def: incognito]
kokarde/S [f] [def: badge of authority]
koketi'r/V/Bkoketi'rt [def: flirt]
	koketi'reray'/N [n] koketstve{koket|stve} [f] [def: flirtation]
kokh/V/T [def: cook, bake] /Gop/Goys/Gon/Gayn
	/Giber [def: consider, cogitate on]
	/Goyf [def: exasperate, gall]
		oy'fgekokhtkayt/N [f] [def: exasperation, umbrage] % Berish Goldstein
	kokhen/V/T [def: cook (pejorative)] % Sholem Aleykhem
	tsekokh/V/Btsekokht [def: boil; become furious/enamored (with "zikh")]
	farkokh/V/Bfarkokht [def: be enamored of (with "zikh in"); overcook]
		farkokhtkayt/N [f] [def: heat; fever]
	kikh/N [f] [def: kitchen]
		gorkikh/N [f] [def: workers' kitchen]
	kekhne [f] kekhin/S [f] ke'kherin/S [def: (female) cook]
	kukher/S [m] [def: (male) cook, chef]
		kekher/S [m] [def: cook, chef] [usage: not recommended]
	kokhedik/A [def: cooking] % variant
	ko'khenish/N [m] kokheray'/N [m] [def: cooking, excitement]
	/Dkikh [def: cookie] /Dkukhlekh
		eyer-kikhl/Xekh [n] [def: cookie made of egg white and sugar (food)]
		mazl{mzl}-kikhele/Xkh [n] [def: fortune cookie] [note: V] 
	kukhn/S [m] [def: cake]
		ku'khnland [n] [def: cake-land] [usage: a kukhn fun kukhnland]
		geke'kht|s/N [n] [def: cooked food]
		fankukhn/S [m] faynkukhn/S [m] [def: pancake]
			fanke/N [f] [def: jelly roll (food)] % Khasidic usage
		ke'zkukhn/S [m] [def: cheesecake] % Forwards: S-R Schaechter
		ri'pkukhn [m] [def: rickets (disease)]
kokhanik/Ees [m] [def: lover (male)]
	kokhanke/S [f] [def: lover (female)]
kokoshes [def: popcorn]
kokoshnik/Ees [def: old-Russian woman's headdress (clothing)]
koks [noun] [def: chignon] 
kol{Kl}/H [def: all] /Lmi{m} [def: from all]  /Lle{l} [def: to all]
	ko'lerle'y{Klerley} [adj] [def: all kinds of] [grammar: indeclinable]
	kule{Kwlw} [adv] [def: all sorts of] 
	kolboynik{Kl-bwnik}/Ees [m] [def: jack of all trades; scoundrel]
kol_{kwl}/Xkeler_{kwler} [n] [def: voice; cry] /Dkelekh{kwlx}
	-/Xkoyles{kwlwT}/H [def: commotion, racket]
	kelekhl{kwlxl}/Eekh [def: 
	koyleynu{kwlnw}/H [def: voice] vider|kol_{kwl} [n] [def: echo]
	kol_koyre{kwl-kwr#} [def: lonely voice] 
	bal_koyre{bel-kwr#} [def: Torah reader] 
	kelekhl/Eekh kelekhl_{kwlxl}/Xkelekhlekh_{kwlexlex} [def: little voice] 
	viderkol{viderkwl}/Xviderkoyles{viderkwlwT} [def: echo] 
	bas_kol{bT-kwl} [f] [def: heavenly voice]
	bkol_ram{bkwl-rm} [adv] [def: out loud]
	/Xkole_koyles{kwly-kwlwT} [m] [def: loud sounds]
kolabori'r/V/Bkolabori'rt [def: collaborate; cooperate]
	kolaboratori'st/N [m] [def: collaborator (pejorative)] 
	kolaboratsye/S [f] [def: collaboration]
kolba's/S [m] [def: sausage (non-kosher)]
	kolbasnik/Ees [m] [def: sausage seller]
kolbe/S [f] [def: pistol-butt, rifle-butt]
koldn [m] kolda'n [m] [def: potbelly; paunch]
koldre/S [f] [def: blanket; bedspread] 
koldunye/S [f] [def: witch] 
koledzh/N [m] [def: college]
koleg/N [m] kolegin/S [f] kolege/S [m] [def: colleague] /D
	shulkoleg/N [m] [def: fellow student]
	kolegye/S [f] [def: board, committee; jury]
kolekti'r/V/Bkolekti'rt [def: collect]
	kolektiv/N [m] [def: collective] /A [def: collective]
	kolektor/S [m] [def: collector]
	kolektsye/S [f] [def: collection] 
koler/V/T [def: roll] /Garop
	kulke/S [f] [def: small ball]
kolerley{Klerley} [def: various] 
koleyke/S [f] [def: gang, band; local train; tramway]  
kolifyo'r [m?] [def: cauliflower (vegetable)]
koli'r/N [m] [def: color] /Iik [def: colored] /Ien [def: colored]
	koli'r/V/Bkoli'rt
		kolirung/N [f] [def: coloration] % Forwards: Shikl Fishman
	kolirful/A filkolirt/A farsheydnkolirik/A [def: colorful]
	baykolir/N [m] [def: tint] % B. Sandler: Karolina-Bugaz
	laybkolir/N [m] [def: tights (skin-colored)] 
	za'mdkolir/N [m] [def: sandy color] % Kulbak: Zelmenyaner
koli'sh [m?] kulishe/S [f] [def: barley-potato soup; thin gruel] % Niborski, Harkavy, Sholem Aleykhem
kolkhoz/N [def: Soviet collective farm]
	kolkhoznik/Ees [m] [def: resident of a Soviet collective farm]
kolner/S/Xkelner [m] [def: collar] /Dkelner
	[idiom: mit a ve-kolner = V-neck] [note: V]
kolodatsh [m?] kaledatsh [m?] [def: kitchen knife]
kolokotshe/V/T [def: make a tiny noise] 
kolone/S [f] [def: column (architecture; on a page; military)]
kolone'l/N [def: colonel (military rank)] 
kolonizi'r/V/Bkolonizi'rt [def: colonize]
	koloni'st/N [m] [def: colonist]
	kolonye/S [f] [def: colony]
	kolonizatsye/S [f] [def: colonization]
	kolonya'l/A [def: colonial]
		kolonyali'zm/N [m] [def: colonialism]
koloratu'r [def: coloratura (music)]
kolosa'l/A [def: enormous, colossal, gigantic]
kolotshe/V/T koloytshe/V/T koloytse/V/T [def: mix, shake; chat]
	farkolotshe/V/Bfarkolotshet [def: slap together, hammer; mix; confuse]
kolpak/N [m] [def: lampshade; yarmulke (head covering); dome (architectural)]
ko'ltn/Xko'ltenes [m] [def: matted hair; elflock]
	kolteneva'te/A [def: matted (hair)]
	farkoltn/V/Bfarkoltn [def: mat]
kolumne/S [f] [def: (newspaper) column] 
	kolum/S [f?] [def: (newspaper) column] [usage: American Yiddish]
	kolumni'st/N kolumnistke/S [def: columnist] 
kolye'deve/V/T [def: carol (Russian)] 
koma/S [f?] [def: coma]
komande/S [f] [def: troup, team]
	fli'-komande/S [f] [def: flight crew] [note: V]
	komando [m] [def: commando]
	komandi'r/N [m] komendant/N [m] [def: commander]
		eyberkomandir/N [m] [def: general, general commander] 
	koma'ndeve/V/Bkoma'ndevet [def: command] /Goys
		/Bgekoma'ndevet /Goys % alternative
	[idiom: pozharne komande = fire brigade]
koma'r/N/Ees [m] kome'r/N [m] koma'rnitse/S [f] [def: mosquito (insect)]
	komarske/S [f] [def: kind of dance (ironic?)] % Forwards: M-S Hoffman
kombini'r/V/Bkombini'rt [def: combine] kombinatsye/S [f] [def: combination]
	kombina't/N [m] [def: organization (Soviet)]
kome/S [f] [def: comma; decimal point] 
	[idiom: (eg) seks kome nayn = 6.9]
	pintl-kome [def: semicolon] 
komedye/S [f] [def: comedy]
	masknkomedye/S [f] [def: masked comedy]
	komedya'nt/N [m] /Iske ko'miker/S [m] komik [m] [def: comedian; buffoon]
	komedyantshik/Ees [m] [def: comedian (perjorative)] 
	tragi-komedye/S [f] [def: tragicomedy]
komenti'r/V/Bkomenti'rt [def: comment; explain] 
	komentatsye/S [f] komenta'r/N [m] [def: explanation] 
	komentator/N [m] [def: commentator; popularizer] 
	komentarish/A [def: explanatory] 
	komentirer/X [def: commentator; analyst] % Forwards: Yankev Goldshteyn
komerts [m] [def: commerce] /Iye'l [def: commercial]
	komertyalizatsye/S [f] [def: commercialization] % Forwards: Yoel Matveyev
komets{kmc}/H [def: a Hebrew punctuation mark, pronounced ɔ]
	komets{kmc}-berdl/Eekh [n] kometsl{kmcl}/Eekh [n] [def: Van Dyke beard] % Yiddish League
komfort [m?] [def: comfort]
komisar/N [m] [def: commissar] komisarya't/N [m] [def: precinct, commisariat] 
komish/K [def: comical]
komisye/S [f] [def: commission (organization)]
	 komisyone'r/N [m] [def: commisioner]
komite't/N [m] [def: committee]
ko'mizm/N [m] [def: joyousness]
komod/N [m] komode/S [f] [def: dresser (furniture)]
komodo'r [m] [def: commodore (naval officer)]
komore/S [f] [def: den, room] [usage: dialect]
kompa'kt/A [def: small, compact]
	/D [def: compact disk (CD)]
	kompaktkayt/N [f] [def: compactness] 
kompanye/S [f] [def: company, gang]
	akompani'r/V/Bakompani'rt [def: accompany]
	akompanime'nt/N [m] [def: accompaniment]
	kompanye/V/T [def: accompany] /Gtsuzamen % Sholem Aleykhem
kompensatsye/S [f] [def: compensation] 
	kompensi'r/V/Bkompensi'rt [def: compensate, adjust] % Rokhl Boymvol
kompete'nts/N [f] [def: competence]
	kompete'nt/A [def: competent]
komple'ks/N [n] [def: difficulty; complex (psychological); complex (grouping)] 
	komplikatsye/S [f] [def: complication] 
komple'ks/A [def: complex (mathematical)] 
komplektsye/S [f] [def: complexion]
komple't/N [m] [def: complete set] komple't/A [def: entire]
komplime'nt/N [m] [def: compliment; flattery]
komplitsi'r/V/Bkomplitsi'rt [def: complicate]
	komplitsirtkayt/N [f] [def: complication]
kompone'nt/N [def: component] /Iish
	kompozitsye/S [f] [def: composition]
	kompozito'r/S/N [m] kompozitorin/S kompozitorshe/S [f] [def: composer]
	komponi'ist/N [m] [def: composer] [usage: not recommended]
kompo'st [m] [def: compost] % Yiddish League
	komposti'r/V/Bkomposti'rt [def: compost] % Yiddish League
kompot/N [m] [def: fruit dessert]
	epl-kompot [m] [def: applesauce] 
kompre's/N [m] [def: compress (device)]
komprometi'r/V/Bkomprometi'rt [def: expose, endanger, compromise] % Yiddish League
kompromi's/N [m] [def: compromise, tradeoff]
	umkompromislekh/A [def: uncompromizing] 
	kompromisloz/A [def: uncompromizing] [usage: inadmissible]
kompyuter/S [m] /Iish [m] [def: computer] kompyuteray'/N [n] [def: computer]
	shoys-kompyuter/S [m] [def: laptop computer] 
	tish-kompyuter/S [m] [def: desktop computer] [note: V] 
	kompyuterizi'r/V/Bkompyuterizirt [def: computerize] % Forwards
		farkompyuterizi'r/V/Bfarkompyuterizirt [def: computerize] % Forwards
komsomo'l/N [m?] [def: Komsomol, Communist League of Youth (Soviet)] % Коммунисти́ческий сою́з молодёжи
	komsomolke/S [f] [def: member of Komsomol]
komuniki'r/V/Bkomuniki'rt [def: communicate]
	komunikatsye/S [f] [def: communication]
		telekomunikatsye/S [f] [def: telecommunication] % Forwards
	komunika't/N [m] [def: communiqué, communication] 
	komunikirke/S [f] [def: walkie-talkie] 
komuni'zm/N [m] [def: communism]
	komuni'st/N [m] [def: communist] /Iish komunistke/S [f] [def: communist]
	komuna'l/A [def: communal, collective]
	komune/S [def: commune]
kon [m] [def: dance figure; round of a card game] % Stutchkoff
	[idiom: oysnemen a kon = win a round]
	[idiom: oyskhapn dem kon = win by a trick] % Shpiglblat
konbinatsye/S [f] [def: clever plan] 
konditer/S [m] [def: confectioner]
	konditeray'/N [f] [def: confectionery]
konditsye/S [f] [def: condition, situation]
	konditsyone'r/N [m] [def: conditioner] 
		hor-konditsyone'r [m] [def: hair conditioner] 
		hoyt-konditsyone'r [m] [def: skin conditioner] 
konduktor/S/N [m] konduktorshe/S [f] [def: conductor]
konfe'kt/N [m] [def: (piece of) candy] /D
konferi'r/V/Bkonferi'rt [def: confer, discuss] 
	konfere'nts/N [f] [def: conference]
		mini-konfere'nts [f] [def: mini-conference] 
	konferansye/S [m] [def: boss; master of ceremonies] 
konfesye/S [f] [def: confession]
	konfesyona'l/A [def: pertaining to a religious group] % Forwards: Velvl Tshernin
konfiski'r/V/Bkonfiski'rt [def: confiscate]
konflikt/N [m] [def: conflict]
	konflikti'r/V/Bkonflikti'rt [def: contrast, disagree] % Forwards: Yoel Matveyev
konformi'st/N [m] konformistke/S [f] [def: conformist]
konfronti'r/V/Bkonfronti'rt [def: confront (English)] 
	konfronta'tsye/S [f] [def: confrontation] % Forwards: Yitskhok Luden
konglomera't [m] [def: conglomeration] 
kongres/N [m] [def: congress]
konishine [f] [def: clover (plant)]
konkret/A [def: concrete]
konkuri'r/V/Bkonkuri'rt [def: compete]
	konkure'nt/N konkurirer/S [m] [def: rival] /Iish [def: rival]
	konkure'nts/N [f] [def: rivalry]
		konkurentsye/S [f] [def: rivalry]
		[idiom: koshere{KSre} konkure'nts = level playing field] [note: V]
konkurs/N [m] [def: contest, competition, collection]
	shray'bkonkurs/N [m] [def: writing contest] % Forwards
	konkursi'st/N [m] konkursa'nt/N [m] [def: contestant] [note: V]
konoplye [m] kanoplye [m] [def: hemp (plant)]
	konople/S [f?] [def: crushed hemp seed (food)]
konoval/N [m] kaneval/N [m] [def: horse veterinarian]
konsekve'nts/N [m] [def: consequence] 
konseptsye/S [f] [def: conception] 
konservi'r/V/Bkonservi'rt [def: conserve] 
	konserv/N [def: preserves]
	konservativ/A [def: conservative (attitude)]
	konservati'zm/N [m] [def: conservativism]
	konservato'r/N [m] [def: conservative (political)]
	konservatorye/S [f] [def: conservatory (music school)] 
		konservatori'st/N [m] konservatoristke/S [f] [def: music student] 
konsilyum/S [def: council (gathering); doctor's conference] 
	[idiom: ophaltn a konsilium (mit) = consult]
konsonant/N [m] [def: consonant]
konspiri'r/V/Bkonspiri'rt [def: conspire] konspiratsye/S [f] [def: conspiracy]
	konspirati'v/A [def: conspirational] % Forwards: M-S Hoffman
konstati'r/V/Bkonstati'rt [def: assert, declare]
konstilatsye/S [f] [def: constellation]
konstitutsye/S [f] [def: constitution]
	konstitutsyone'l/A [def: constitutional] umkonstitutsyone'l/A [def: unconstitutional] 
konstrui'r/V/Bkonstrui'rt [def: construct]
	konstruktsye/S [f] [def: construction]
		konstruktor [m] [def: builder]
	konstruktiv/A [def: constructive]
	rekonstrui'r/V/Brekonstrui'rt [def: reconstruct] 
		rekonstruktsye/S [f] [def: reconstruction] 
		rekonstruktsyoni'st/N [m] [def: reconstructionist] % Hoffman
konsul/N [m] [def: consul (officeholder)]
	general-konsul/N [m] [def: consul general]
	konsula't/N [m] [def: consulate]
konsulti'r/V/Bkonsulti'rt [def: consult]
	konsulta'nt/N [m] konsultantin/S [f] [def: consultant, advisor]
konsumi'r/V/Bkonsumi'rt [def: consume; use]
	konsumtsye/S [f] konsumptsye/S [f] [def: consumption]
	konsume'nt [m] [def: consumer]
	konsum- [prefix] [def: consumer-]
konta'kt/N [m] [def: contact; electrical outlet]
	kontakti'r/V/Bkontakti'rt [def: contact]
konte/S [f] [def: account]
	ba'nkkonte/S [f] [def: bank account]
	bay'konte/S [f] [def: secondary account] % Stutchkoff
	hoy'ptkonte/S [f] [def: main account] % Stutchkoff
	loy'fkonte/S [f] [def: current account] % Stutchkoff
	tshekkonte/S [f] [def: checking account]
kontekst/N [m] [def: context] 
kontest/N [m?] [def: contest] [usage: Americanism]
konte't/A [m] [def: content, satisfied]
kontinent/N [m] [def: continent]
kontinui'r/V/Bkontinui'rt [def: continue]
	kontinuite't/N [f] [def: continuity]
kontraba'nd [m] kontrabande/S [f] [def: contraband, forbidden goods] /In
	kontrabandi'st/N [m] [def: smuggler, drug dealer] 
kontrakt/N [m] [def: contract]
	kontra'ktor/Xkontrakto'rn [m] [def: contractor]
kontrasti'r/V/Bkontrasti'rt [def: contrast]
	kontra'st/N [m] [def: contrast] 
kontre kontri [noun] [def: country (American)] [usage: inadmissible]
kontroli'r/V/Bkontroli'rt [def: control, check] /Gdurkh
	/Gnokh [def: verify]
	kontrol/N [m] kontrole/S [f] [def: control]
	kontrolyo'r/N [m] [def: inspector]
kontroversye/S [f] [def: controversy] 
	kontroversya'l/K kontroversa'l/A [def: controversial] 
kontsentri'r/V/Bkonsentri'rt [def: concentrate]
	kontsentratsye/S [f] [def: concentration]
kontseptsye/S [f] [def: conception]
	kontsept/N [m] [def: concept]
kontse'rt/N [m] [def: concert]
kontsesye/S [f] [def: concession] % Forwards
kontshe/V/T [def: finish] % Mendele, Sholem Aleykhem
kontur/N [m] [def: contour]
ko'nusl [n?] [def: coneflower (Echnicacea) (flower)] % M. Schaechter: geviksn
konvalye/S [f] [def: lily (flower)] % Chava Rozenfarb: Botshani
konveni'r/V/Bkonveni'rt [def: suit; be of advantage] [grammar: takes dative]
konve'nts/N [f] [def: convention]
	konventsyone'l/A [def: conventional] 
konve'rt/N [m] [def: envelope, paper jacket] 
konverti'r/V/Bkonverti'rt [def: convert] 
konvoy'/N [m] [def: convoy; escort]
konvulsi'v/A [def: convulsive, spasmodic; stormy]
	konvulsi'r/V/Bkonvulsi'rt [def: shake, agitate, convulse] % Forwards: M-S Hoffman
konya'k [m?] [def: cognac]
konyugi'r/V/Bkonyugi'rt [def: conjugate (grammar)]
	konyugatsye/S [f] [def: conjugation (grammar)]
	konyugirish/A [def: conjugate (mathematics)] 
koordini'r/V/Bkoordini'rt [def: coordinate]
	koordinirer/S [m] koordini'rerin/S [f] [def: coordinator]
	koordina't/N [m?] [def: coordinate, location]
kooperi'r/V/Bkooperi'rt [def: cooperate]
	kooperati'v/N kooperati'v/A [def: cooperative] 
	kooperatsye/S [f] [def: cooperation]
kop/Xkep [m] [def: head (body part)] /Dkep /Ikepik /Ikepldik
	kleynke'pldik/A [def: simple-minded] kleynke'pldikayt/N [def: simple-mindedness]
	tsveykepik/A [def: two-headed]
	tsukopns [def: at the head]
	eyberkop/Deyberkep [def: head]
	golkop/Xgolkep [def: skinhead] 
	hitskop/Xhitskep [m] [def: hothead] 
	kep/V/T [def: decapitate]
	ay'zlkop/Xay'zlkep [def: idiot]
	dreykop/N [def: liar; swindler]
	karpnkop/Xkarpnkep [def: intelligent person] 
	kendzhe-kop/Xkendzhe-kep [def: curly head of hair (Polish kędzior "ringlet of hair"] % Forwards: M-S Hoffman (Lodzh dialect)
	kirbeskop/Xkirbeskep [def: enormous head] % Avrom Karpinovitsh
	plikhkop/Xplikhkep [m] [def: bald head]
	toytnkop [m] [def: death's-head]
	tsapnkop/Xtsapnkep [m] [def: goat head (decoration on a staff)] 
	tsu'gobkepl/Eekh [def: caption] % Yosl Birshteyn
	/Dun'terkep [def: subtitle (film)] 
	vaserkop/Xvaserkep [m] [def: hydrocephalus (disease); fool]
	kapisho'n/N [m] [def: hood, cowl, bonnet]
	kopke/S [f] kupke/S /D [def: lady's cap (clothing)]
	kapl/N [n] [def: cap, yarmulke (clothing)]
		ka'pelyush/N [m] [def: hat (clothing)] /D 
			kapelhyushnikl/Eekh [def: helpful, hatted, small elf]
		kapele/Ekh [def: small hat (clothing); small amount] 
		knikapl/Eekh [n] [def: kneecap, patella (body part)] [note: V]
	[idiom: fun kop biz fis = from top to bottom]
	[idiom: hobn a kop tsu epes = be in the mood for something]
	[idiom: poyersher kop = goyisher kop = stupid]
	[idiom: flam-fayerdik kepl = genius (child)]
kope/V/T [def: kick] /Gayn/Garop kopye/V/T
	kope/S [m] [def: kick] 
/Dkopek [n] [def: caterpillar (animal)]
ko'perte/S [f] [def: watchcase]
ko'pete/S [f] kopit [m?] [def: cobbler's last; shoe form; hoof]
kopike/S [f] [def: kopek (coin; 1/100 ruble) (Russian currency)] /In
kopi'r/V/Bkopi'rt [def: copy] /Gop
	fotokopi'r/V/Bfotokopi'rt [def: photocopy]
	kopye/S [f] [def: copy]
kopite/S [f] [def: hoof]
koptish/A [def: Coptic (language)] % Stutchkoff
koptshe/V/T [def: emit smoke]
koral/N [m?] [def: coral]
kora'n [m] [def: Koran] % Forwards
korb/Xkerb /Dkerb [m] [def: basket]
	ayngekorbt/A [def: placed in a basket] % L. Shapiro
	koyber/S [m] [def: basket]
	korobke/S [f] [def: box (Russian коробка)]
korbe/S [f] [def: crank (tool)]
kore/S [f] [def: tree bark] /In
korenie/V/Bkoreniet 
	/Goys [def: eradicate; curse]
	koreneye/V/Bkoreneyet [def: shower with insults]
		/Goys [def: eradicate; curse]
kores /D karas karsh karesh [def: goldfish (Carassius auratus); carp (Carassius carassius]
korete/S [f] [def: trough (for food)]
korets/X [m] korts/X [def: bushel (solid measure)] /Dkerets /Dkerts
korev{krwB}/Xkroyvem{krwBym}/H [m] [def: relative (male)]
	kroyve{krwBh}/Xkoryves{krwBwT}/H [f] [def: relative (female)]
	mekarev{mkrB} [verb] [def: befriend (with "zayn")]
	mekurev{mkwrB}/Xmekurvem{mkwrBym} [m] [def: friend]
	kroyvish{krwBish}/A [def: related; cognate] 
	kroyvishaft{krwBishaft}/N [f] [def: relation]
	bekorev{bkrwB} [adv] [def: soon] 
	kirev{kyrwB} [m] [def: outreach to non-observant Jews]
	makrev{mkryB}/H [verb] [def: bring close, sacrifice, trade off (with "zayn")]
		korbn{krbn}/Xkorbones{krbnwT}/H [m] [def: sacrifice; victim]
	kurve/S [f] [def: prostitute] kurvish/A 
kori [m?] [def: curry (spice)] % Forwards: S-R Schaechter
koridor/N/D [m] [def: corridor]
korigi'r/V/Bkorigi'rt [def: correct]
	korekt/A [def: correct] u'mkore'kt/A [def: incorrect] [usage: for ideas or actions, not people]
		korektu'r/N [f?] [def: correction]
korik/Xkorkes [m] [def: fuse (electrical); cork] 
	ko'rkeve/V/T [def: plug, cork]
		/Goyf [def: uncork]
		/Gtsu [def: cork]
	ko'rkntsi'er/S [m] [def: cork pull]
kori'n [m?] [def: root (Ukrainian корінь)]
korme/V/T [def: feed] /Gadurkh [def: survive (with "zikh")]
	kormak/Ees [m] [def: wetnurse; breadwinner]
korn [m] [def: rye] koren/A [def: rye]
	kerner [def: grain]
	kerndl/Eekh [def: seed]
korporatsye/S [def: corporation] 
	inkorpori'r/V/Binkorpori'rt [def: incorporate; subsume]
korpus/N [m] [def: corps (military), body (anatomy), material]
korsazh [m] [def: corsage]
korse't/N [m] gorse't/N [m] [def: corset (clothing)]
	korse'tnitse/S [def: corset maker]
korshun [m?] [def: kite (bird)] % Stutchkoff; Chinese kite is Milvus korshun
kort/N [f] [def: (playing) card] /Dkert /Dkart
	[idiom: oyfdekn di kortn = put one's cards on the table]
	[idiom: varfn kortn = tell fortunes]
	[idiom: leygn kortn = tell fortunes]
	[idiom: alts vos in di kortn = every possible evil]
	[idiom: makhn a kertl = play a card game]
kort [m?] [def: cheap, shiny cloth] /In
kortetshke/S [f] [def: haunch?]
	[idiom: zitsn oyf di kortetshkes = sit on one's haunches; squat] % Forwards: Boris Sandler
kortiso'l [m?] [def: cortisol (chemical hormone)] % Forwards: Sholem Berger
kortsh/Ees [m] [def: tree stump] 
kortshe/V/T [def: toss and turn; fold] /Gayn/Gtsunoyf
	oysgekortshevet/A [def: rooted out and discarded; cleared (land)] 
korumpi'r/V/Bkorumpi'rt korupti'r/V/Bkorupti'rt [def: corrupt] 
	koruptsye/S [f] [def: corruption] 
korzh/Ees [m] korzhik/Ees [m] /D [def: cookie, dry cake (food)]
kos{Kws}/Xkoyses{KwswT}/H [m] koyse{Kwse}/H [def: cup, goblet, glass (vessel)]
	farkoset{farKwset}/A [def: tipsy] 
	koyse{Kwse}/V/T koysen{Kwsen}/V/T [def: become tipsy]	
		koyse{Kwse}/S [f] [def: alcoholic drink]
	may'-koysele{Kwsele}/S [f] [def: lily-of-the-valley (Convallaria majalis) (flower)] % M. Schaechter: geviksn
	[idiom: makhn a kos{Kws} = have a drink (alcoholic)]
kose/S [f] [def: small scythe]
	kose/V/T [def: reap, cut] /Gop/Goys
kose [adv] [def: aslant, diagonal; sloping; oblique] 
	[idiom: kukn kose = squint]
koshe{kSh}/H [def: difficult]
	nishkoshe{niSkSh} [def: not bad; no problem] /Idik [def: middling] 
koshe/S [f] [def: horse] [usage: baby talk]
kosher{KSr}/H/K [def: kosher]
	kashres{KSrwT}/H [def: kosher matters]
	kasher{KSr}/H/V/T [def: make kosher (by salting and soaking)] /Goys
	makhsher{mxSyr}/Xmakhshirem{mxSyrym}/H [m] [def: utensil, apparatus]
		rutir-makhsher{rutir-mxSyr}/Xrutir-makhshirem{rutir-mxSyrym} [def: router (computer)] [note: V] 
	kishren{KySrwn}/Xkishroynes{KySrwnwT}/H [m] [def: talent]
		bal_kishren{bel-KySrwn} [m] [def: talented person]
koshmar/N [m] [def: nightmare]
koshme/-koshme tsekoshmet/A [def: in disarray]
kosholye [f] [def: German measles, rubella (disease)] % Michael Wex
koshtshol/N [m?] [def: Polish Catholic church]
koshulke/S [f] [def: shirt (Polish koszulę); gas mantle]
kosmetik/N [f] [def: cosmetics, makeup]
	kosmetish/A [def: cosmetic]
	kosmetiker/S [m] kosmetikerin/S [f] [def: beautician] % Yiddish League
kosmos/N [m] [def: cosmos]
	kosmish/A [def: cosmic]
	kosmonoy't/N [m] [def: astronaut, cosmonaut]
	kosmopoli't/N [def: cosmopolitan (person)] /Iish
kost/V/T [def: cost] /Gop
	 kost/N [m] [def: cost]
kostard/N [m] [def: custard]
kostyum/N [m] [def: suit; costume]
	bodkostyum/N [m] [def: swim suit]
	kostyumi'r/V/Bkostyumi'rt [def: costume]
kotik/Ees [m] [def: sea otter (animal)] /In
kotle't/N [m] [def: chop, cutlet; hamburger (food)] 
kotn{ktn}/H [def: small] /Lha{h} [def: the small]
	ani_hakotn{any-hktn} [def: I, yours truly]
	tales_kotn{tlyT-ktn}/H/S [m?] [def: ritually fringed undershirt]
	-/Xktanem{ktnym} [def: urination]
	[idiom: nekovem{nkBym} ktanem{ktynym} = urination]
	[idiom: yosem{yTwm} kotn{ktn} = very young orphan]
kots/N [m/f] [def: blanket]
kotsh/N [m?] [def: coach, carriage (conveyence)] /D
	kutsher/S [m] [def: coachman] % Harkavy
		kutsher/V/T [def: drive a coach] % Harkavy
kotsher/N [m] [def: drake (male duck)] 
kotshere/S [f] [def: poker (fireplace)] 
kove/V/T [def: forge, hammer (metal); shoe (a horse)] /Gtsu 
	/Goys [def: mould, shape by forging]
	farkove/V/Bfarkovet [def: cover in chains]
kovel/Ees [m] koval/Eyes [m] [def: blacksmith] 
	kovadle/S [f] [def: anvil] 
	[idiom: tsvishn hamer un kovadle = in a difficult situation]
koved{KBwd}/H [def: honor; dignity] 
	lekoved{lKBwd}/H [prep] [def: for the sake of; in honor of]
	kol_hakoved{Kl-hKBwd}/H [interj] [def: bravo!]
	umkoved{umKBwd} [m?] [def: disrespect]
	kibed{Kybwd}/H [def: refreshments, snack in honor of a guest; honor]
	bekoved{bKBwd}/H/A bekovedik{bKBwdik}/K [def: honorable]
		umbekovedik{umbKBwdik}/K [def: dishonorable]
	bekhvoyde{bxBwdw}/H [def: in his glory]
	bekhvoyde_uveatsme{bxBwdw-|wBecmw} [def: himself (humorous)]
	mekhabed{mxbd}/H [verb] [def: honor; offer a snack (with "zayn")]
	mekhubed{mxwbd}/Xmekhubodem{mxwbdym}/H [m] [def: honored person, respected person, dignitary]
	kisey_hakoved{Ks#-hKBwd}/H [m] [def: God's throne; toilet facility, toilet] 
	khilel_hakoved{Hylwl-hKBwd} [m] [def: disrespect]
	roydef_koved{rwdf-KBwd}/Xrodfey_koved{rwdfy-KBwd}/H [m] [def: vain person]
	yiras_hakoved{yir#T-hKBwd}/H [f] [def: respect] 
	mase_kveyde{mQ#-KBdh}/H [m] [def: heavy load]
	[idiom: ikh bet iber ayer koved = pardon my French]
	[idiom: leygn groys koved{KBwd} oyf = esteem]
	[idiom: ophitn/shaneven emetsns koved{KBwd} = save face] [note: V]
ko|ye/V/T [def: flicker (flame)]
koydem{kwdm}/H [def: first]
	koydem_kol{kwdm-Kl} [adv] [def: first of all]
koydesh{kwdS}/H /Lha{h} [adj] the holy] /Idik [def: holy]
	koydesh{kwdS}/V/T [def: sanctify]
	kodesh{kdwS}/Xkedoyshem{kdwSym}/H [def: holy people]
	kidesh{kidwS}/H [def: benediction over wine for Sabbath and holidays]
	kedushen{kydwSyn}/H [def: marriage vows]
		mesader_kedushen{msdr-kydwSyn} [m] [def: Rabbi conducting a wedding]
	kedushe{kdwSh}/H [f] [def: holiness]
	kudshe_brikh_hu{kwdS#-bryx-hw#} [m] [def: God]
	kidshonu{kdSnw}/H [def: has sanctified us]
	kadesh{kdyS}/Xkadishem{kdySym} [def: Kaddish prayer; son]
		rabonen_kadesh{rbnn-kdyS} [def: Rabbi's Kaddish; mourner's prayer]
	mikdesh{mkdS}/H /Lha{h} [n] [def: Temple]
		beys_hamikdesh{byT-hmkdS} [def: Temple in Jerusalem]	
	mekadesh{mkdS} [verb] [def: sanctify (with "zayn")]
	hekdesh{hkdS}/H [def: poorhouse, public poor-person accomodation; mess]
	khevre_kedishe{HBrh-kdyS#}/H [f] [def: burial society]
	malke_kedishe{mlK#-kdyS#} [def: God (mystic)]
	ruekh_hakoydesh{rwH-hkwdS}/H [def: divine spirit]
koyekh{KwH}/Xkoykhes{KwHwT}/H [def: ability; strength]
	bekoyekh{bKwH} [adv] [def: by strength; strong enough]
	mikoyekh{mKwH} mikoyekhn{mKwHn} [prep] [def: in regard to, about, concerning]
	-/Xkoykhes{KwHwT}/H [def: strength]
	yasher_koyekh{y|ySr-KwH} [interj] [def: congratulations; well done; thanks]
	eyber-koyekh{KwH} [def: super strength] % Forwards: Noyekh Barera
	moykhiekh{mwxyH}/Xmoykhikhem{mwxyHym} [m] [def: preacher (concentrating on reproach)]
	[idiom: iber di koykhes{KwHwT} = beyond one's ability]
	[idiom: nit far mayne koykhes{KwHwT} = beyond my ability]
	[idiom: mit ale koykhes{KwHwT} = with all one's might]
	[idiom: emetsn tsukumen a tsveyter koyekh{KwH} = get a second wind] [note: V]
	[idiom: oyf s'koyekh{s'KwH} = by force]
koyen{Khn}/Xkohanem{Khnym}/H [m] [def: priest, Cohen; first Torah honor]
	[idiom: bakumen koyen{Khn} = get first priority] [note: V]
koyf/V/T [def: buy] /Goyf/Giber/Gon/Gop/Gavek/Gtsunoyf/Gtsu
	/Gayn [def: shop, buy]
	/Goys [def: redeem oneself (with zikh)]
	/Gunter [def: acquire by bribery]
	farkoyf/V/Bfarkoyft [def: sell] /Goys
		oysfarkoyf/N [m] [def: sale]
	koyfman [m] [def: merchant] koyfmenish/A [def: merchantlike]
	koyfer/S [m] koy'ferin/S [f] [def: buyer]
	farkoyfer/S [m] farkoy'ferke/S [f] farkoy'ferin/S [f] [def: merchant]
	aynkoyf/N [m] [def: shopping]
	aynkoyfer/S [m] [def: customer]
	oyskoyf/N [def: sale]
koyfer_{Kwfr} [def: deny the existence of God (with "zayn")]
	kefire{Kfyrh}/Xkefires{KfyrwT} [f] [def: heresy; apostasy]
koyl/N [f] [def: coal; bullet]
	erdkoyl/N [f] [def: coal] 
	shneykoyl/N [f] [def: snowball]
	keylekhdik/A [def: round]
koyle/V/T [def: slaughter, kill; ruin] /Goys/Gavek/Gop
	koylenen % variant infinitive
	derkoyle/V/Bderkoylet [def: slaughter] % Berish
	koyler/S [def: murderer] /Iish
	kayler/S [m] [def: non-Jewish slaughterer]
koyler/V/T /Garop koler/V/T [def: roll (with "zikh")]
	[idiom: koylern zikh fun gelekhter = fall over laughing]
koyletsh/N [def: braided bread] /D
koylrabi kilerib [def: kohlrabi (vegetable)] 
koym [adv] [def: barely, hardly (often with "vos")]
koymen/S [m] [def: chimney] milkoymen/S [m] [def: mill chimney]
koymer{Kwmr}/Xkomrem{Kwmrym}/H [m] [def: Christian clergyman]
koyne{kwnh}/Xkoynem{kwnym}/H [m] koynete{kwnhte}/S [f] [def: customer]
	knie{knyh}/Xknies_{knywT} [f] [def: purchase]
koyp/N [m] [def: hill, knoll; pile, heap] 
	koyp/V/T /Gon [def: pile up]
koysh/N /Dkeysh [m] [def: basket]
	koshik/Ees/D [m] [def: basket]
	/Dmistkeysh [def: wastebasket] % Forwards: Boris Sandler
koyt [n/m] [def: filth] /Iik [def: filthy] /Iiklekh
	mayznkoyt [def: mouse droppings] 
	tayvlskoyt [def: devil's droppings]
koytsye/S [f] [def: bail bond]
kozak/N [m] /Iish /D kozatshke/S [f] [def: Cossack, cavalryman] 
koze/S/D [f] [def: goat; prison; rowdy girl] % Stutchkoff for prison, rowdy girl
	kozak [m] [def: prison] % Stutchkoff
	koze-berdl/Eekh [n] [def: goatee beard] % Yiddish-League
	[idiom: makhn di grobe koze = make a profit] % Stutchkoff
koze/S [f] [def: piece of snot] [note: V] 
kozhlke/S [f] ko'zhelik/Ees [m] [def: somersault]
koriro'k/Ees [m] [def: visor]
	[idiom: pod korirok = touching the visor in salute (Russian под козырок)]
kozle/S [f] [def: coachman's seat; scaffold; sawhorse]
kraft/N [f] [def: force] /Iik kreftik/A [def: forceful]
	shtoyskraft/N [f] [def: pushiness] % Forwards
	shverkraft [f] [def: gravity] % Yiddish League
	tsikraft/N [f] [def: (automotive) drive] [note: V]
	tsutsikraft/N [f] tsutsiungs-kraft/N [f] [def: gravity; attractive force (physics)] 
	bakreftik/V/Bbakreftikt [def: verify] 
kragn/S [m] [def: collar (of clothing)] /Dkrag
	krogn/S [m] [def: neck (of poultry)]
krake/V/T [def: caw (sound of a crow), croak]
	krakeve/V/T [def: caw (sound of a crow)]
krakh/V/T [def: crash] /Garop/Garayn
	gekra'kh/N [m] [def: crashing noise] 
kramp/N kram/N [m] [def: cramp, intestinal pain]
	kremf/V/T [def: cramp] /Gayn
kran/N [m] [def: derrick, crane; spigot]
krank/A [def: sick] /Ilekh/A krenklekh/A [def: sick] 
	krankerheyt [adv] [def: while sick]
	krankayt/N [f] krankshaft/N [f] krenk/N [f] krenkung/N [f] [def: sickness]
		hartskrankayt/N [f] [def: heart desease] % Forwards: Sholem Berger
		parkinson-krankayt/N [f] [def: Parkinson's disease] % Forwards: Sholem Berger
		yam{|ym}-krankayt/N [f] [def: seasickness (disease)]
	krenk/V/T [def: ail] /Goys/Gtsu
		a'ltshaymer-krenk/N [f] [def: Alzheimer's disease] 
		tsu'kerkrenk/N [f] tsukerkrankayt/N [f] [def: diabetes (disease)]
	[idiom: di bitere krenk = di shvere krenk = yene krenk = epilepsy (disease)]
	farkrenk/V/Bfarkrenkt [def: spend on medicine]
	[idiom: visn a krenk = know nothing]
	[idiom: esn krenk un bentshn retsey{rch} = have little to eat]
krant/N [m] kran/N [m] [def: faucet]
	va'serkrant/N [m] va'serkran/N [m] [def: faucet]
krant/A kurant/K [def: current, valid, marketable]
	konte-kure'nt [f] [def: current account] % Stutchkoff
krants/N [m] [def: wreath] /Dkrents [def: group, gathering, huddle] 
	bakrants/V/Bbakrantst [def: crown, wreath]
	rozenkrants/N [m] [def: rosary] % Bashevis
krapi'r/V/Bkrapi'rt [def: die a wretched death] % Michael Wex
krasavets/N [m] [def: handsome man] krasa'vitse/S [f] [def: beautiful woman]
krase/A [def: colored]
krate/S [f] [def: bar (on window)] 
krats/V/T [def: scratch; plaster] /Goys
	/Gop [def: steal, make off with] % Menakhem Kipnis
	tsekrats/V/Btsekratst [def: scratch]
	kratsmikh kratsmakh [def: Christmas (pejorative)]
	volkn-kratser/S [m] himl-kratser/S [m] [def: skyscraper] 
	rukn-kratser/S [def: backscratcher]
	krets [f] [def: scabies (disease), itch; plague; leprosy]
		/Iik [def: leprous, scabrous; scratchy, rough; shaggy; itchy, mangy] % Harkavy
krava't/N [m] [def: necktie (clothing)]
krayd/N/D [f] [def: chalk]
krayke/S [f] [def: border, edge] % zi vigt zikh oyf a flamiker krayke
kraytekhts/N/Eer [n] [def: vegetables; herbs] krayt/N/Eer [n] 
kraytish/A [def: difficult; peculiar]
kraytser/S [m] [def: silver coin, kreutzer (Austro-Hungarian currency)]
krayz/V/T [def: circle] /Garum [def: surround; orbit]
	krayzl/V/T [def: circle] /Garum [def: surround; orbit]
	krayz/N [m] [def: circle] /D [def: circle; ripple]
		arumkrayz/N [m] [def: circle]
		halbkrayz/N [m] [def: semicircle] 
		umkrayz/N [m] [def: periphery, silhouette, outline]
	dramkrayz/N [m] [def: theatrical troupe] % Avrom Karpinovitsh
	leyenkrayz/N [m] [def: reading circle]
	shraybkrayz/N [m] [def: writing circle]
	shtotkrayz/N [m] [def: city district, ward]
	sternkrayz/N [m] [def: universe] 
	viklkrayz/N [m] [def: cycle] % Forwards: Estraykh
	grayzl/V/T [def: curl (hair); frizzle (with "zikh"); curl upward (smoke; with "zikh"] /Goys
		grayzl/Eekh [n] [def: curl] 
krede'nts/N [f] [def: credenza (furniture)]
	shraybkrede'nts/N [f] [def: writing table (furniture)]
kredi't [m] [def: credit]
	kley'tkredi't [m] kro'mkredi't [m] [def: store credit] [note: V]
	diskrediti'r/V/Bdiskrediti'rt [def: discredit]
	kreditor/N [m] [def: creditor]
krek/V/T [def: choke (with "zikh")]
krekhts/V/T [def: groan, moan] /Gop/Goys
	krekhts/N [m] [def: groan]
	krekhtser/S [m] [def: complainer] 
	kre'khtsenish/N [n] [def: groaning]
krel/N [m] [def: claw, scratch]
	krel/V/T [def: scratch]
krel/N [f] [def: bead]
krem [m] [def: cream]
	ayzkrem [m] [def: ice cream] ayzkrim [m] [def: ice cream (Americanism)]
	golkrem/N [m] [def: shaving cream] % Harduf
krematorye/S [f] [def: crematorium]
kremen/Ees [?] [def: flint]
	[idiom: lakhn mit grine verem = laugh bitterly]
kremini [adj] [def: cremini (kind of mushroom)] % Forwards: S-R Schaechter
kreml [m] [def: Kremlin]
kre'nitse/S [f] ke'rnitse/S [def: well, spring (water)]
	% ke'rnitse is used in Rumania (Forwards: B. Sandler)
krepdeshi'n/A [def: crêpe de Chine (fabric)] % Esther Kraytman: Briliantn
krepke/A [def: sturdy] 
krepl/Xkreplekh [def: filled dough, ravioli, wonton] % no positive; singular diminutive is rare
krepost/N [m] [def: fortress]
kreshtshendo [m?] [def: crescendo (music)] % Stutchkoff
kresle/S [f] [def: armchair]
kretshme/S [f] [def: tavern]
	kretshmer/S [m] [def: tavern keeper]
	kre'tshmerke/S [f] [def: tavern keeper]
	[idiom: nit trefn di kretshme = make a mistake]
krey/V/T [def: crow (sound of a rooster)] /Garayn/Goys
	tsekrey/V/Btsekreyt [def: burst into crowing] 
kreyts/N [m] [def: cross] [usage: doubtful admissibility]
	kreytsik/V/T [def: crucify] kreytsikung/N [f] [def: crucifiction] 
	haknkreyts/N [m] [def: swastika]
	kreytstsug/N [m] [def: crusade] 
	gekreytst/A [def: crossing; cross-shape] 
	kreyts/V/T [def: cross] /Gdurkh
krie/S [def: ice flow]
krie_{kryeh} [f] [def: ripping clothing as a sign of mourning]
	[idiom: raysn/shnaydn krie_{krye} = tear clothes in morning; work very hard]
krig/V/Bgekrogn/Bgekrign [def: receive, get] /Garoys/Gtsu/Gtsurik/Gtsu
	/Garayn [def: capture]
	krug/N [m] /Dkrig [def: jug, pitcher, container for liquid]
	[idiom: zayn tsum krign = available]
krig/V/T/Garayn/Gon [def: fight (with "zikh")]
	kriger/S [m] [def: fighter] krigeray'/N [n] [def: fight]
	birgerkrig/N [m] briderkrig/N [m] [def: civil war]
	tsekrig/V/Btsekrigt [def: fight]
	farkrig/V/Bfarkrigt [def: fight]
	krig/N [m] [def: war] krigs- [prefix] [def: war] 
	kri'gerish/A [def: warlike; aggressive]
krikh/V/Bgekrokhn [def: creep, crawl]
	/Garayn/Garoys/Garoyf/Garunter/Gop/Goys/Garop/Gavek/Gtsu/Gdurkh/Garum
	/Gariber/Gtsurik/Gunter
	farkrikh/V/Bfarkrokhn [def: creep; go astray; get stuck]
	tsekrikh/V/Btsekrokhn [def: creep]
	krikher/S [m] [def: crawler] 
		shikse-krikher [def: Jewish man who lusts for gentile women (taboo)] 
	opgekrokhnkayt/N [f] [def: broken-down state]
krimetarterum [m?] [def: cream of tartar (food)] % Sholem Aleykhem
kriminel/A [def: criminal] krimina'l/N [m] [def: jail]
	kriminolo'g/N [m] [def: criminologist]
	kriminalnik/Ees [m] [def: convict, jailbird]
krimini [adj] [def: crimini mushroom (food)] % Forwards: S-R Schaechter
krinoline/S [f] krineline/S [f] [def: crinoline (material); hoop skirt, farthingale (clothing)]
krip [m?] [def: dill (herb)]
kripl/N [m/f] [def: cripple]
	farkripl/V/Bfarkriplt [def: cripple]
kripton [m] [def: krypton (Kr)] 
krire{kryrh}/Xkrires{kryrwT}/H [f] [def: cold] 
krishl/V/T [def: crumble, be brittle (with "zikh")] /Idik
	tsekrishl/V/Btsekrishlt [def: crumble; fragment; fail to support (with "zikh")] 
	krish/N [m] krishke/S/D [f] [def: crumb; small amount]
krishme{kry#T-Sme} [f] [def: recital of the Shema prayer]
krishtol [m] [def: crystal] /Ien /Iik
krist/N [m] [def: Christian] /Ilekh [def: Christian] kristin/S [f] [def: Christian woman]
	urkrist/N [m] /Ilekh frikristlekh/A [def: early Christian] 
	kristntum [n] [def: Christianity]
		urkristntum [n] [def: early Christianity] 
	farkrist/V/Bfarkrist kristik/V/T [def: make Christian; baptize]
	kristl/V/T [def: occur among Christians]
kristal/N [m?] [def: crystal] /Iish
	kristalografye/S [f] [def: crystalography] % Forwards: Yoel Matveyev 
		rentgen-kristalografye [f] [def: X-ray crystalography] % Forwards: Yoel Matveyev 
kriterye/S [f] kriteryum/S [m?] [def: criterion]
kritiki'r/V/Bkritiki'rt [def: criticise]
	kritik [f] kritike/S [f] [def: criticism (subject)]
	kritish/A [def: critical] kritiker/S [m] [def: critic]
	krizis/N [m] [def: crisis] 
krits/V/T [def: engrave; scratch; gnash, grind] /Garayn/Gayn/Goys
	farkrits/V/Bfarkritst [def: engrave]
	kritsung/N [f] [def: scratching, engraving]
	kompaktl-aynkritser/S [m] [def: CD burner] [note: V]
krivde/S [def: grievance; injustice]
	[idiom: onnemen zikh emetsns krivde = stick up for someone]
	krivde/V/T [def: injure, wrong] 
	farkrivdet/A [def: injured, wronged] % Forwards: Mishe Lev
kriyes{kry|eT}/H [def: reading, splitting]
	kekries_yam_suf{Kkry|eT-ym-swf} [adv] [def: very difficult]
krizh/Ees [m] [def: loins; small of the back (body part)] 
	[idiom: boygn dem krizh = work hard]
	[idiom: faln oyf di krizhes = suffer lower-back pain]
kro/Een [m?] [def: crow (bird)]
krok/N [m] [def: crotch (body part); fly (clothing)]
kroket [def: croquet]
krokhik/A [def: friable, frangible] 
krokhmal [m] [def: starch]
	krokhmalye/V/T [def: starch] /Gon
krokodil/N [m?] [def: crocodile]
krokshtine/S [f] [def: bracket] 
krok/N [m] [def: crotch, groin]
krokus [m] [def: crocus (plant)]
krokve/S [f] [def: rafter, wooden beam]
krolik/Ees/D [def: rabbit; timid person] krulik/Ees/D
krom/N [f] [def: store] /Dkrem
	kremer/S /D [m] kre'merke/S [f] [def: storekeeper]
	apteykkrom/N [f] [def: pharmacy (store)]
	ay'znkrom/N [f] [def: hardware store]
	bakaley'-krom/N [f] [def: grocery store]
	bi'kherkrom/N [f] [def: bookstore]
	shnitkrom/N [f] [def: dry-goods store]
		shnitkremer/S [m] [def: dry-goods storekeeper]
	shpayzkrom/N [f] [def: grocery store]
		shpayzkremer/S [m] [def: grocery owner]
	shporkrom/N [f] [def: thrift shop] [note: V]
	tande'tkrom/N [f] [def: second-hand shop]
krootish/A [def: Croatian (language)]
krop [m] krip [m] koper [m] [def: dill (herb)]
kro'peve [f] [def: nettle]
kroshke/S [f] [def: sugar cube (with "tsuker") (food)] 
kroyn/V/T [def: crown]
	bakroyn/V/Bbakroynt [def: crown] 
	kroyn/N [f] [def: crown; darling; corona (astronomical)]
		kroynele/Eekh [n] kroyneshi [def: beloved, darling]
		korone/S [f] [def: corona (astronomical)]
	/Dkreynd [n] [def: funnel; badge]
kroyt/N [n/f] [def: cabbage]
	kreyter [def: herbs, vegetable-based medicines] [grammar: only in plural]
	bleterkroyt [n/f] [def: kale; collard greens] 
	umkroyt/N [n/f] [def: weed]
	zoyerkroyt [n] [def: sourkraut]
	[idiom: geviklte kroyt = gefilt kroyt = stuffed cabbage (food)]
	[idiom: shemen zikh vi a bok/tsig/koze in kroyt/gortn = display khutspe] % Stutchkoff
kroyz/N [m] [def: curl (smoke); tuft (hair)] /Dkrayz
	horkroyz/N [m] [def: tuft (hair)]
	shvartsgekrayzlt/A [def: black-haired] % Bergelson
kruk/Ees [m] [def: crutch; hook, peg, crook]
krukhe/A krukhle/A krukhke/A [def: brittle; crunchy] % Stutchkoff
krum/A/Kkrim [def: crooked; incompatible (marriage match)] /Ilekh
	krim/V/T [def: bend; grimace] /Garoys/Goys
		/Gnokh/Giber [def: imitate]
			nokhkri'menish/N [f] [def: imitation]
	oyskri'menish/N [f] [def: crooked state]
	farkrim/V/Bfarkrimt [def: bend, bastardize]
		farkri'menish/N [n] [def: bending, bastardization; grimace] 
	krumak/Ees [m] [def: cripple (pejorative)]
krup [noun] [def: flank of horse] 
krupnik [def: barley soup]
kruv{KrwB}/Xkruvem{KrwBym} [m] [def: cherub, angel]
ksantipe/S [f] [def: Xanthippe, shrew]
ksav{KTB}/Xksovem{KTBym}/H [m/n] [def: writing; writ, document]
	beksav{bKTB} [adj] [def: written]
	ksav_plaster{KTB-plsWr}/Xkisve_plaster{KTBy-plsWr}/H [m] [def: slanderous document, calumny]
	kasve_rabe{KTB#-rb#}/S [m] [def: calligrapher, scribe]
ksenofobye/S [f] [def: xenophobia]
	ksenofobish/A [def: xenophobic] 
ksenon [m] [def: xenon (Xe)] 
kseriskapye/S [f] [def: xeriscaping] % Forwards: Itsik Gottesman
kshake/S [f] [def: bush, shrub (Polish krzaka)]
ksilofon [m?] [def: xylophone (musical instrument)]
	ksilofoni'st/N [m] [def: xylophone player] % Forwards: Itsik Gottesman
ksube{KTwbh}/Xksubes{KTwbwT}/H [f] [def: marriage contract]
ku/Xki [f] [def: cow] kien/A [def: pertaining to cows]
	kiele/Xkh [def: little cow]
		[idiom: Moyshe rabeynus{rbynus} kiele = ladybug (insect)]
	blinde-ku [f] [def: blind-man's bluf, Colin Maillard (game)]
	ku'enkayt/N [f] [def: status of being a cow] % Sholem Aleykhem
	[idiom: kind un keyt = (child and cattle) = everyone]
ku/Een [m] [def: the letter Q] 
ku-ku-ri-ku [interj] [def: cockadoodle-doo (sound of a rooster)] 
kudre/S kuldre/S kudle/S [f] [def: tousled hair]
	kudlate/A kudlevate/A [def: shaggy, hairy]
	tsekudle/V/Btsekudlet [def: tousle (hair)]
kuf{kʼ}/H [m/f] [def: Hebrew letter Kuf]
kufert [m?] [def: trunk (furniture)]
kufl/N [m] kuflye/S [f] [def: mug, large cup]
kugl/N/Dkug [m] [def: pudding (baked savory food)]
	erdkugl [m] [def: earth (planet)] /Derdkug
kuk/V/T [def: look]
	/Giber/Gdurkh/Gadurkh/Garayn/Garop/Garoyf/Garum/Gnokh/Gon/Goys
	/Gtsu/Gum/Gariber/Gtsurik/Gafer/Gunter/Gavek
	/Gayn [def: look at (with "zikh oyf")]
	/Garoys [def: expect, look forward to]
	no'khkuker/S [m] [def: investigator; spy]
	o'nkuker/S [m] o'nkukerin/S [f] [def: (exhibit) visitor; sight-seer]
	oy'skuker/S [m] [def: spy; scout; lookout]
	tsu'kuker/S [m] [def: observer, audience, onlooker]
	bakuk/V/Bbakukt [def: inspect, examine]
	farkuk/V/Bfarkukt [def: ignore]
	aroyskuk/N [m] [def: prospect, hope]
	aynkuk/N [m] [def: attention, scrutiny]
	durkhkuk/N [m] [def: inspection, investigation; perusal]
	/Dkuker [n] [def: viewport, peephole] % Itsik Manger
kukavke/S [f] [def: cuckoo]
kuke/V/T [def: peck (like a woodpecker)] % Bashevis
kukle/S [def: doll (plaything); voguish woman]
kukuruze [def: maize]
kulik/Ees [m] kulak/Ees [m] [def: fist] /D [def: mitten]
kulinarye/S [f] [def: cafe] % Forwards: Boris Sandler
	kulinarish/A [def: culinary] % Forwards: S-R Schaechter 
kuli's/N [m] [def: theater wing]
	[idiom: hinter di kulisn = behind the scenes]
kulminatsye/S [f] [def: culmination, climax]
kult/N [m?] [def: cult]
kultivi'r/V/Bkultivi'rt [def: cultivate]
	kultu'r/N [f] [def: culture] /Iel [def: cultural]
		kegnkultu'r/N [f] [def: counterculture] 
		fizkultu'r/N [f] [def: gym, athletics (school subject)] 
		multi-kulturishkayt/N [f] [def: multiculturalism] 
		veltkultu'r/N [f] [def: world culture] % Forwards
	subkultu'r/N [f] [def: subculture]
	shprakhkultu'r/N [f] [def: linguistic culture]
kulye/V/T [def: roll about (with "zikh")] /Giber/Garop
	kulye/S [f] [def: crutch]
kum/V/Bgekumen [def: come]
	/Garoys/Gnokh/Garayn/Gdurkh/Gadurkh/Gaher/Gaheym/Gariber/Gum
	/Gtsurik/Gforoys/Garop/Gfir/Gtsu/Gtsunoyf/Goyf
	/Gtsuzamen/Gantkegn/Gakegn/Gavek/Garoyf/Gmit/Garunter/Gafer
	/Gahin [def: disappear]
	/Gfor [def: happen, occur]
	/Goys [def: manage or get along with (with "mit"); turn out, occur]
	/Gbay [def: prevent; overcome; get the advantage over] [grammar: not in present tense]
	/Gon [def: arrive; approach for assistance (with "tsu")]
	/Gop [def: lose weight; become untied; be defeated; do penance; be punished; survive]
		[idiom: opkumen mit abi vos = make do with very little]
	/Giber [def: survive; overcome; get deserved punishment (with "dos zaynike")] 
	/Gunter [def: appear; arrive unexpectedly; be imminent; catch up]
	bakum/V/Bbakumen/Garayn/Garoys/Gtsurik [def: acquire, receive]
		bakumer/S [m] [def: recipient]
		[idiom: zayn tsum bakumen = available]
		[idiom: zol voyl bakumen = in good health; enjoy it]
	kumedik/A [def: future; next] 
	forku'menish/N [n] tsuku'menish/N [n] [def: happening, event]
	iberku'menish/N [n] [def: income, sustenance] % Avrom Karpinovitsh
	opku'menish/N [n] [def: come-uppance; punishment]
	tsuzamenkum/N [def: meeting]
	oysku'menish/N [n] [def: sustenance, subsistence; reward]
	aynkunft/N [f] [def: salary, pay, earnings] 
	tsukunft/N /Iik [f] [def: future]
	araynkum/N [m] [def: entrance; scene (in a play)]
	aroyskum/N [m] [def: result]
	krikkum/N [m] [def: re-entry] % Yiddish League
	onkum/N [m] [def: arrival] 
	oyfkum/N [m] [def: origin; style; success]
	tsunoyfkum/N [m] tsunoyfkumenish/N [n] [def: meeting, gathering] 
	umkum/N [def: destruction]
		umkumenish/N [n] [def: downfall]
	[idiom: kumen tsu zikh = become conscious or recover]
	[idiom: kumen tsu geyn = visit]
	[idiom: opkumen mit shiye_piye{Shy-phy} = be unemployed] % shabes hayom, peysekh hayom
kumer/N [m] [def: grief, sorrow] 
kund/N [m] kundin/S [f] [def: customer] [usage: doubtful admissibility]
	kundshaft/N [f] [def: clientele]
	derkundik/V/Bderkundikt [def: inquire about (with "zikh") (German)]
kundes{kwnds}/Xkundeysem{kwndsym}/H [m] [def: prankster, wise guy; brat]
kune/S [f] [def: pillory; small room for enforced standing as punishment]
	[idiom: vest bay mir shteyn in kune = I'll get even with you] % Hoffman
kunst/N [f] [def: art] /Iik [def: artistic]
	kinstlekh/A kintslekh/A [def: artificial; artistic] 
	kinstler/S [m] ki'nstlerin/S [f] [def: artist]
		ki'nstlerish/A [def: artistic]
		grafiti-kinstler/S [m] grafiti-ki'nstlerin/S [f] [def: graffiti artist] [note: V]
		vortkinstler/S [m] [def: author]
	gekintslt/A [def: artificial]
	folkskunst/N [f] [def: folk art]
	kleynkunst/N [f] [def: cabaret-style (with "teater")]
	tsinglkunst/N [f] [def: tongue-twister]
	vortkunst/N [f] [def: word artistry] % Sutskever
kuntres{kwntrs}/Xkuntreysem{kwntrsym}/H [m] [def: notebook; brochure; commentary; Rashi's commentary]
kunts/N [f] [def: trick] /Iik [def: tricky; clever]
	kuntseray'/N [n] [def: tricks]
	shvartkintsler/S [n] [def: black magician]
kunzhut [m] [def: sesame (plant, seed) (Sesamum indicum)]
kupe/S [def: rick (hay); pile (wood); drift (snow); compartment (train)]
kupe_{kwph}/Xkupes_{kwpwT}/H [f] [def: money chest] 
kuper [n] [def: copper (Cu)] /Idik kupern/A [def: copper]
kupetshestve/S [def: permission to run a business]
	kupets/N [m] [def: holder of a kupetshestve] 
	kuplyonik/Ees [m] [def: perchased person (humorous)] % An-sky: Khane di Kekhin
kupke/S [f] [def: group, gang; clump] /D % J. Opatoshu: lintsheray
kuple't/N [m?] [def: couplet (poetry)]
kupol/N [def: cupola] 
kupon/Ees/N [m?] [def: coupon (monetary instrument)]
kurator/N [m] kuratorshe/S [f] [def: curator] 
	prokurator/N [m] [def: prosecutor; manager]
kuratsye/S [f] [def: cure] kurort/Xkurerter [n] [def: spa]
	kur [m?] [def: cure] [usage: not recommended]
kurazh [def: courage]
kurd/N [m] [def: Kurd] /Iish
kurelapnitshke/S [def: seller of eggs, chickens, ducks]
kurikulum [m] [def: curriculum] 
kuri'r/V/Bkuri'rt [def: nurse, tend, treat] /Goys [def: cure, heal]
kurkume [f] [def: turmeric (spice)]
kurnik/Ees [m] [def: chicken coop]
kuropatke/S [f] [def: partridge] 
kurs/N [m] [def: course; exhange rate, value (of money)]
	flikurs/N [m] [def: flight path] [note: V]
	kleynkurs/N [m] [def: short course (academic)]
	zumerkurs/N [m] [def: summer course (academic)]
	shprakhkurs/N [m] [def: language course]
	kursant/N [m] kursistke/S kursistin/S [f] [def: student]
kurtizane/S kurtizanke/S [f] [def: courtesan, mistress]
kurts/Kkirts [def: short] kurtsink/A
	kirtsung/N [f] [def: shortening]
	kirtslekh/A [def: short]
	kirts/V/T [def: shorten]
	farkirts/V/Bfarkirtst [def: shorten] farkirtsung/N [f] [def: shortening]
kurtshukl/Eekh [n] [def: chick (bird)] 
kurtye'r [m] [def: middleman (diamond trade)] % Esther Kraytman: Briliantn
kuryer [m?] [def: courier, runner; herald]
kuryo'z/N [m] [def: curiosity]
kush/V/T [def: kiss; kiss each other (with "zikh")] /Goys/Gop
	kush/N [m] [def: kiss] ku'shenish/N [n] [def: kissing]
	tsekush/V/Btsekusht [def: kiss each other (with "zikh")]
	kusheray'/N [n] [def: act of kissing]
kushetke/S [f] [def: sofa, couch (furniture)]
kushulye [f] [def: German measles, rubella (disease); scarlet fever (disease)]
kust/Ees/N [m] [def: bush] /Iik
	kustarnik/Ees [m] [def: underbrush]
kusta'r/N [m] [def: home worker] /Iish
kutas/N [def: tasseled braided belt (clothing); penis (vulgar); fool (vulgar)]
kute/V/T [def: put on warm clothing (with "zikh")] % Forwards: Boris Sandler
ku'tnitse/S [f] ki'tnitse/S [f] [def: uterus (of a cow)]
kutsenyu-mutsenyu [def: in an amorous relationship (with "vern mit emetsn")] 
kutsheme'nt/N [m] kotshume'nt/N [m] [def: prison]
kutsibabe [f] [def: blind-man's bluff (children's game)]
kutsher/S [m?] [def: lock of hair] % Stutchkoff
	kutsherove/A [def: with locks of hair; curly] % Stutchkoff, Forwards: B. Sandler
kutshme/S [def: fur hat; Persian-wool hat] 
kuzin/N [m] kuzine/S kuzinke/S [f] [def: cousin] 
ku'zhele/Xkh [n] [def: piece of snot] [note: V] 
kuznye/S [f] [def: smithy; forge]
kvadra't/N [m] [def: squared (mathematics); square (mathematics)]
kvake/V/T [def: croak (sound of a frog); quack (sound of a duck)]
kval/N [m] [def: spring (of water), well] /Iik
	nay'eskval/N [m] [def: news source] % Forwards: S-R Schaechter
	kvel/V/Bgekvoln [def: rejoice, swell with pride, be delighted] /Gon/Gop
	kvel/V/T [def: oppress, torture]
	tsekvel/V/Btsekvoln [def: burst with goodness] 
kvalite't/N [f] [def: quality]
	kvalitsi'r/V/Bkvalitsi'rt [def: qualify]
	kvalifitsi'r/V/Bkvalifitsi'rt [def: set conditions]
		kvalifitsi'rt/A [def: qualified, competent, eligible]
	diskvalifitsi'r/V/Bdiskvalifitsi'rt [def: disqualify] 
	kvalitati'v/A [def: qualified] % Forwards: Yoel Matveyev
kvantite't/N [f] [def: quantity]
	kvantum/S [m] [def: quantity] 
	kvant- [prefix] [def: quantum-] % Forwards
kvape/V/T [def: have an appetite for, crave (with "zikh oyf")]
	farkvape/V/Bfarkvapet [def: crave (with "zikh")]
kvart/A farkvart/A ayngekvart/A [def: thin]
kvarte't [noun] [def: quartets, go fish (card game)]
kvarti'r/N [f] [def: district, board, lodgings]
	kvartal/N [m] [def: neighborhood, quarter (of a town)]
	kvart'ir/V/Bkvarti'rt [def: lodge, board] 
		aynkvarti'r/V/Baynkvarti'rt [def: lodge, board] 
		kvartira'nt/N [m] [def: lodger, boarder]
			subkvartira'nt/N [m] [def: subletter]
			mitkvartira'nt/N [m] [def: roommate, housemate]
	hoyptkvartir/N [f] [def: headquarters] % Forwards
kvas [m] [def: kvass (Russian drink), cider]
	kvasnik/Ees [m] [def: kvass seller]
	kva'snitse/S [f] [def: cider apple] 
kva'shene [f?] [def: jellied meat? (Russian квашене `sour'] % Stutchkoff
kvater/S [m] kva'terin/S kva'tershe/S [f] [def: friend at a Jewish circumcision who brings in the infant]
kvati'r/N [m] [def: doorframe]
kvatsh [m] [def: soft mass; weakling; nonsense!; tag (game; Russian квач)]
kvatshe/V/T [def: squash; daub (paint); scribble; talk foolishly]
	tsekvatshe/V/Btsekvatshet [def: squash; daub (paint); scribble]
	kvatshke/V/T [def: dirty; daub (paint); scribble]
kvenkl/V/T [def: hesitate (with "zikh"), be reluctant (with "zikh")]
	kve'nklenish/N [n] [def: hesitation]
kvents [m] [def: straight flush (cards, such as in "oke"]
kver [f] [def: transversely, across (with "in der")]
	kver- [prefix] [def: transverse, cross]
kvestyoni'r/V/Bkvestyoni'rt [def: question the truth or value] 
kvetsh/V/T [def: squeeze, press, pinch; bother]
	/Gadurkh/Gmit/Garoys/Garayn/Gtsu/Gdurkh/Gayn/Goys/Gop/Gtsunoyf
	farkvetsh/V/Bfarkvetsht [def: squeeze]
	tsekvetsh/V/Btsekvetsht [def: squeeze]
	derkvetsh/V/Bderkvetsht [def: squeeze to death] % Forwards: Gershn Vayner
	gekvetshterheyt [def: squeezed]
	kvetsher/S [m] kve'tsherke/S [f] [def: complainer (American Yiddish)] 
		bankkvetsher/S [m] [def: bench-warmer; Yeshiva student] % Michael Wex
	[idiom: es kvetsht zikh im = he has an urge]
kveyker/S [m] [def: Quaker (religion)]
kveyt/N [m] [def: flower, blossom] 
kvik/V/T [def: refresh; enjoy (with "zikh")]
	derkvik/V/Bderkvikt [def: refresh; delight]
		derkvi'kenish/N [n] derkvikung/N [f] [def: refreshment] 
kvint/N [m] [def: measure of weight, 128th of a pound, 3.54 g]
kvinte/S [f] [def: 5th (music); highest and thinnest violin string (Polish kwinta, Russian квинта)]
	[idiom: oyfhengen dem noz oyf der kvinte = be dejected] % Sholem Aleykhem
kvintesents [f] [def: quintessence, gist] % Forwards: Yechiel Szeintuch
kvit [m] [def: receipt]
	/D [def: receipt, tag] 
		/Dprayzkvit [def: price tag, price label] 
	kvitantsye/S [f] [def: receipt]
	yoldes{ywldT}-kvitl/Eekh [n] [def: childbirth amulet]
	kvit [interj] [def: paid up: expression of finality]
	shtrofkvit/N [m] [def: ticket (infraction)] /D
	[idiom: lombardover kvit = pawnshop ticket]
kvitshe/V/T [def: squeak, squeal] /Goys
	tsekvitshe/V/Btsekvitshet [def: squeal (with "zikh")]
	kvitsh/N [def: squeak (sound of a bird), squeal (sound of a pig)] /D
		/Iik [def: squeaky]
		foy'glkvitsh/N [def: twitter of birds]
	kvi'tsherke/S [f] [def: squealer, screecher]
	kvitsheray'/N [f] [def: squealing, squeaking] 
	/Dkvitshik [def: yawning sound] % Bergelson
kvoder/S [m] [def: quarter (coin) (American currency)]
	kvo'derbek/S [m] [def: quarterback (American sport)]
kvoke/V/T [def: quack, honk (sound of a goose or chicken)] /Gtsu
	kvokeray'/N [n] [def: honking]
kvoke/S [f] kovtshke/S [def: brooding hen]
kvol/A [adj] [def: sickly, scrawny; hypersensitive] 
kvort/N/Xkvert [f/n] [def: quart] [note: Weinreich says f/n, GYD says f/m]
	/Dkvert [n] 
	[idiom: makhn fun a vort a kvort = make a mountain out of a molehill]
kvote/S [f] [def: quota]
kyo'sk/N [m] [def: newsstand] 
labedrik/Ees [def: crupper (horse)] % Bergelson: "tsurekht gemakht oyf di ferd di labedrikes"
laber/V/T [def: play (instrument or cards) (klezmer-loshn)]
labiri'nt/N [def: labyrinth; labyrinth in the inner ear] /Iish
labn/S/Dleb [m] [def: loaf]
laboratorye/S [f] [def: laboratory]
	laborator- [prefix] [def: laboratory]
labushnik/Ees [m] [def: klezmer (klezmer jargon)] % Stutchkoff
	labushinske [f] [def: klezmer jargon] % Stutchkoff
lad/V/Bgeladn/Gayn [def: invite]
	aynlad/N [m] aynladung/N [f] [def: invitation]
lad/N [m?] [def: order; sense] % Stutchkoff
	/Dlad [def: fret (on a stringed musical instrument)] [note: V]
ladino [n] [def: Ladino]
ladye/V/T [def: fix, improve (Slavicism)] /Goys/Gayn
lafer/S [m] [def: knight (chess piece)]
lag_boymer{l″g-bewmr} [m?] [def: Celebration of the 33rd day of the Omer]
lage/S [f] [def: situation]
	baylage/S [f] [def: supplement] 
	gruntlage/Xgruntlagn [m] [def: foundation] [usage: not recommended]
lager/S/N [m] [def: camp]
	balager/V/Bbalagert [def: besiege] balagerung/N [f] [def: siege] 
	lager/V/T [def: camp, reside] /Gop
	toytlager/S toytnlager/S [def: death camp]
lagodne/A [def: mild, lenient, easy-going]
lak [m] [def: lacquer; varnish]
	laki'r/V/Blaki'rt [def: varnish]
		lakirke/S [def: patent-leather shoes]
lakey'/N [m] [def: lackey, flunkey]
lakmus litmus [m?] [def: litmus (paper; dye from lichens)]
lakh/V/T [def: laugh] /Garayn/Gmit/Gnokh/Gon/Gfunander
	/Gop [def: ridicule (with "fun")]
	/Goys [def: ignore with laughter (with "zikh"); ridicule] 
	tselakh/V/Btselakht [def: laugh]
	derlakh/V/Bderlakht [def: laugh]
	farlakh/V/Bfarlakht [def: make fun of]
	gelekhter/S/N/D [n] [def: laughter]
		[idiom: vayt tsum gelekhter = a cause of worry]
	lakhedik/A [def: laughing; laughable, comic] % variant
	lekhlekh/A [def: laughable] lekherlekh/A
	lakherayke/S [def: comedy (theater)] 
	[idiom: lakhn oys emetsn = laugh at someone]
lakkhn{lkHn}/Vlakkhenen{lkHenen}/T [def: steal] /Gtsu/Gavek/Garoys
	mekekh{mkH}/Xmekokhem{mkHym}/H [m] [def: price]
	latkhn/V/T [def: steal]
	[idiom: mekekh{mkH} hashove{hSwh} = fair price] % Menakhem Kipnis
lakrets [m] [def: licorice; a particular playing card]
laks/N [m] [def: lox; salmon (fish)] 
laksi'r/V/Blaksi'rt [def: soften the bowel] % Stutchkoff
	laksirekhts/N [n] [def: diarrhea (disease)]
lalke/S [f] [def: doll]
lam/Xlemer /Dlem [def: lamb; gullible person] lemeshke/S
	lamedude/S [f/m] [def: fool]
	[idiom: kune{kuni} leml = fool, bumpkin]
lame{lmh}/H [def: why] /Lha{h}
	may_{ma|y}/H [def: what]
	lema'y{lma|y} alma'y{alma|y} halma'y{hlma|y}/H [def: why; why then]
lamed{lmd}/H [m/f] [def: Hebrew letter Lamed]
	lamden{lmdn}/Xlamdonem{lmdnym} [m] lamdonis{lmdnyT} [f] [def: learned person]
lamte'rn/S [m] /Dlamte'rnd lamterne/S [f] [def: lantern]
land/Xlender [m] [def: country] /Iish /Dlend
	anderlendish/A [def: foreign]
	mitlendish/A [def: Mediterranean (with "yam{|ym}")] 
	tsvishnle'nderish/A [def: cross-country]
	akerland/Xakerlender [n] [def: tillage, arable land]
	farmland/Xfarmlender [n] [def: farm land] % Forwards: Sh Fishman
	foterland/Xfoterlender [n]  heymland/Xheymlender [n][def: homeland]
		foterlendish/A
	fu'ksnland [n] [def: far-away place (balegole-loshn)]
	hoykhland/Xhoykhlender [n] [def: highland] 
	nivetsland/Xnivetslender [n] [def: wasteland]
	oysland [m] [def: a foreign country]
		oyslendish/A [def: foreign]
		oyslender/X [m] /Ish oysle'ndershe/S [f] [def: foreigner]
	palmenland [n] [def: place where palm trees grow]
	troymland [n] [def: dreamland] % Leon Elbe
	yidishland [n] [def: place where Yiddish is spoken]
	yidnland [n] [def: Israel (poetic)]
	yo'derland [n] [def: mainland] /Iish
	landshaft/N [m/f] [def: landscape; scenery]
	land/V/T [def: land, come to land] 
		landung/N [f] [def: landing, coming to land] 
lane [def: linen]
lang/Kleng [def: long; for (duration)] /Ilekh
	[grammar: postpositive to mean "for": a sho lang]
		vokhnlang/A [def: for weeks]
		yornlang/A [def: for years]
	langzam/K [def: slow (German)]
		farlangzam/V/Bfarlangzamt [def: make slow]
	leng [f] [def: length] /Ilekh
		lebnslenglekh/A [def: life-long] 
	langonik/A longonedik/A [def: old-time]
	farlenger/V/Bfarlengert [def: extend] 
		farlengerung/N [f] [def: extension] 
lantanum [m] [def: lanthanum (La)] 
lantekh/Eer/Ees [m] lantukh/Eer/Ees [def: tarp, sack; bridge goblin]
lantsi'r/V/Blantsi'rt [def: launch]
	lantsi'r/N [m] [def: launch pad] % Yiddish League
lap/N [def: lobe; ear lobe]
	lep/D [def: (ear) lobe; eyelid]
	oyer-lepl/Eekh [n] [def: earlobe]
	oygn-lepl/Eekh [n] [def: eyelid] % B. Sandler: Karolina-Bugaz
lap/V/T [def: grab]
lape/S [f] [def: paw] lapke/S [def: paw; bribery]
	lapuvke/S [f] [def: bribery]
lapene/S [f] lapn [m] lapen [m] [def: heavy washrag] % Harkavy
lapitut/N [m] [def: gnome]
lapsus/N [m] [def: lapse] 
	elter-lapsus/N [m] [def: senior moment] [note: V]
laptshe/S [f] [def: type of informal shoe (clothing)]
laringi't [m?] [def: laringitis (illnesillness)]
larkh/N [m] [def: lark (bird)]
larve/S [f] [def: larva]
lashtshe/V/T [def: crave (with "zikh"); hug (with "zikh")]
	lontshe/V/T [def: snuggle, caress (with "zikh"); fawn, act sycophantically] /Gtsu
		opgelo'ntshetkayt/N [f] [def: distancing] % Forwards: Yechiel Szeintuch
laske/S [f] [def: kindness, favor; caress]
	laskave/A [def: generous]
	[idiom: kumen oyf laskave broyt = depend on handouts]
last/N [f] [def: burden]
	balast/V/Bbalast [def: owe money; load up; debit]
	balastik/V/Bbalastikt [def: debit]
	balestik/V/Bbalestikt [def: impose, burden, encumber; molest]
		bale'stiker/S [m] [def: molester]
		bale'stikung/N [f] [def: abuse, molestation]
lastik [f?] [def: some sort of material] /In % ?? what sort
	gumelastik/Ien [def: rubber] 
latayn [n] [def: Latin] /Iish [def: Latin]
late/V/T [def: patch] /Goys
	farlate/V/Bfarlatet [def: patch]
	late/S [f] latke /D [def: patch]
	latutnik/Ees [m] [def: (shoe) repair man]
	latnik/Ees [m] [def: low-level tailor]
latik/Ees latek/Ees [m] [def: vagrant, bum]
latke/S [f] [def: potato pancake (food)]
lats/N [m] [def: lapel]
	[idiom: onnemen baym lats = to buttonhole]
latsh/N [m] [def: slippers (clothing)]
laurea't/N [m] laureatin/S [def: laureate; prizewinner]
lav/H/N [def: negative commandment]
lave/S [f] [def: sidewalk]
lave [f] [def: lava]
lave'ndl/N [n] ave'ndl [n] lave'nder [m] [def: lavender]
lavine/S [f] [def: avalanche] 
lavi'r/V/Blavirt [def: maneuver]
	lavir/N [m] [def: maneuver]
lay/V/Bgelien[def: borrow] /Gavek/Goys /Bgelign /Gavek/Goys [def: lend]
	antlay/V/Bantlien/Bantlign [def: lend] % not gelayt
	farlay/V/Bfarlien/Bfarlign [def: lend]
layb/Eer [n] [def: body] /D /Ilekh [def: blood (relative)]
	balaybt/A
	/D [def: little body; undershirt (clothing)] 
	laybke/S [def: undershirt (clothing)]
	fullaybik/A shverlaybik/A fetlaybik/A diklaybik/A [def: heavy, fat]
		fetlay'bikayt/N [f] [def: obesity]
	hartlaybik/A [def: stingy; constipated]
		hartlay'bikayt/N [f] [def: constipation]
layd/V/Bgelitn [def: suffer] /Gon
	/Gmit [def: sympathize]
	farlayd/V/Bfarlitn [def: bear, tolerate]
	leyd/N [f] laydn [n] [def: suffering, grief, pain]
		mitleyd/N [f] [def: empathy]
	baleydik/V/Bbaleydikt [def: insult]
		baleydikung/N [f] [def: insult]
	derlaydn/V/Bderlitn [def: suffer]
	laydnshaft/N [f] [def: passion] /Ilekh [def: passionate]
	layder [interj] [def: alas!, unfortunately] [usage: doubtful admissibility]
	[idiom: lange laydn un leydn = trials and tribulations]
layke [f] [def: gauze]
laykht/K [def: easy; light; fluffy (dough, batter)] laykhtkayt/N [f] [def: ease; lightness]
	otem-farlaykhterer/S [def: decongestant] [note: V]
	farlaykhter/V/Bfarlaykhtert [def: facilitate; lighten; relieve] 
		farlaykhterung/N [f] [def: relief] 
	derlaykhter/V/Bderlaykhtert [def: relieve] % Der Nister
		derlaykhterung/N [f] [def: relief] % Der Nister
layle{lylh}/H [m] [def: night] /Lve{|w} [def: and night]
	leyl{lyl}/H [def: night of]
	tkhilas_halayle{WHylT-hlylh} [f] [def: twilight] % Bashevis
laylekh/Eer [m/n] [def: bedsheet]
layn [m] [def: flax (plant: Linum usitatissimum)]
layst/N [f] [def: edge; molding (furniture); last (shoemaking)]
layt/N [def: people; upstanding person] laytish/K [def: proper, respectable]
	-/Xlaytlekh [def: little people] % Sholem Aleykhem: Shprintse
	adllayt/N [def: nobility]
	arbet|slayt/N [def: workers]
	bizneslayt/N [def: businessmen (American)] % Forwards: Yankev Goldshteyn
	dorfslayt/N [def: villagers]
	fayerlayt/N [def: firemen] % Chava Rozenfarb: Botshani
	gesheft|slayt/N [def: businessmen]
	gevelbslayt/N [def: merchants] 
	kongreslayt/N [def: congressmen (America)] % Forwards: Yankev Goldshteyn
	landslayt/N [def: people from the same district]
	laytishkayt/N [def: propriety]
	marklayt/N [def: merchants]
	oremelayt/N [def: poor people]
	shlakhtlayt/N [def: warriors]
	shtotlayt/N [def: city dwellers]
	yungelayt/N [def: youngsters] -/Xyungelaytlekh
	[idiom: tsu got un tsu layt = upstanding]
layvnt/N [f/n] [def: linen] /Ien % not leyvnt
	za'klayvnt [n] [def: sackcloth (material)]
	laynen [n] [def: linen] /A
lazare't [m?] [def: infirmary, hospital]
lazer/N [m] [def: laser] 
lazi'r/V/Blazi'rt /Garayn [def: pop in unannounced (with "zikh")] 
leb/V/T [def: live] /Gadurkh/Goyf/Gtsunoyf/Gop/Gdurkh/Gayn/Gmit
	/Giber [def: survive]
	/Goys [def: live out one's life, follow a life path (with "zikh")]
	antle'b/V/Bantlebt [def: take a life] 
	bale'b/V/Bbalebt [def: give life to]
		bale'bt/A [def: animate]
		u'mbale'bt/A [def: inanimate]
	farle'b/V/Bfarle'bt [def: live]
	derle'b/V/Bderle'bt [def: live to see]
	[idiom: ir zolt derlebn iber a yor = many happy returns]
	iberlebung/N [f] iberle'benish/N [n] [def: experience; occurrence]
	oyfleb/N [m] [def: revival] oyflebung/N [f] [def: reviving]
	opgelebtkayt/N [f] [def: worn-out nature] % Der Nister
	le'bedik/K [def: lively, alive]
		le'bedikayt/N [f] [def: liveliness; joy]
		le'bedikerhey't [adv] [def: alive]
	leblekh/A [def: room-temperature, tepid (liquid)] %
	[idiom: zol lebn = who should live long] [interj]
	lebn/S [n] [def: life; dear (after a name)]
		shtillebn/S [n] [def: still life (painting)] 
		tsuza'menlebn/S [n] [def: life together]
		khlebn [interj] [def: indeed; as I live] 
		[idiom: mayn gants lebn iz ... = I live for ...]
		[idiom: geyn in lebn = be very eager]
leber/S/D [f] [def: liver]
	[idiom: dobuven/esn dem leber = annoy, torment]
lebn/P [def: near]
leder [f/n] [def: leather] /In
	khro'mle'der [f/n] [def: suede, Morocco leather]
	sha'rfle'der/S [def: stropping leather] % Avrom Karpinovitsh
lefl/X/N [m] [def: spoon] lefele/Ekh [n] [def: teaspoon] 
	eslefl/X [m] eslefele/Xeslefelekh [n] [def: tablespoon]
	kokhlefl/X [m] [def: cooking spoon, busybody]
	sheplefl/X [m] [def: ladle] 
	shukhlefl/X [m] shukhlefele/Ekh [n] [def: shoe horn]
	teylefl [m] teylefele/Ekh [n] [def: teaspoon] 
legal/A [def: legal] umlegal/A [def: illegal]
	legitimi'r/V/Blegitimi'rt legitimizi'r/V/Blegitimizi'rt [def: legitimize]
		legiti'm/A [def: legitimate] umlegiti'm/A [def: illegitimate]	
		legitimatsye/S [f] legitimite't/N [f] legitimkayt/N [f] [def: legitimacy]
		legitimi'zm/N [m] [def: legitimism (form of government)]
	legisli'r/V/Blegisli'rt [def: codify, regulate]
		legislatu'r/N [m?] [def: legislature]
		legislatsye/S [f] [def: legislation]
		legislato'r/N [m] [def: legislator]
		legislati'v/A [def: legislative]
legende/S [f] [def: legend] legendar/A/Iish [def: legendary]
leger/V/T /Gtsu [def: leave lying about]
	farlegert/A [def: stale] 
	tsugelegert/A [def: stale] 
legi'r/V/Blegi'rt [def: alloy] 
	legirung/N [f] [def: alloy] 
legyon/N [m] [def: legion]
leibed{l#ybwd} [adv] [def: to waste (with "geyn")]
lek/V/T [def: lick; toady, fawn] /Goys/Gunter/Gop
	balek/V/Bbalekt [def: lick]
	lek/N [m] [def: lick] leker/S [m] le'kerke/S [f] [def: licker]
		unterleker/S [m] [def: toady, sycophant]
	lekekh/N/Eer [m] [def: honey or sponge cake (food); diamond (shape); diamond (playing cards)] 
		/D [def: cookie] 
		honik-lekekh/Eer [m] [def: honeycake (food)] 
		tsuker-lekekhl/Eekh [m] [def: sugar cookie (food)]
lekhem{lHm} [n] [def: bread]
	[idiom: kumen ad_kiker_lekhem{ed-KyKr-lHm} = be too poor to afford bread]
lekhlutin{lHlwtyn}/H [def: entirely]
lekhts/V/T [def: thirst; yearn]
	tselekhtst/A [def: dried up] % Bergelson
lekish/N [m] [def: fool, simpleton]
	lekishevate/A [def: ignorant]
leksikon [m] leksik [m] [def: lexicon]
	leksikograf/N [m] [def: lexicographer] /Iish [def: lexical]
	leksik/A leskikal/A leksish/A [def: lexical]
	umleksik/A [def: improper lexically]
lektor/N [m] le'ktorin/S [f] [def: lecturer]
	lektsye/S [f] [def: lecture]
	[idiom: haltn a lektsye = present a lecture]
leman{lmen}/H [def: for the sake of]
lemekh{lmx}/S [m] [def: fool, idiot]
lempert/N [def: leopard] 
len/V/T /Gon [def: lean]
	/Gop [def: set down]
	tselen/V/Btselent [def: lean back]
	onlen [m] [def: support]
	unterlen [m] [def: support; staff]
lend/N [f] [def: hip, waist; loin] % not usually in singular
	[idiom: ruk un lend zolstu brekhn afn glaykhn veg]
lente/S [f] [def: ribbon, tape]
	kino-lente/S [f] [def: movie film]
lepish/A [def: clumsy]
	lepishevate [def: clumsy, awkward] % Kulbak: Zelmenyaner
lepokhes{lpHwT}/H [def: at least]
ler/A [def: empty; good for nothing]
	oysgelert/A [def: deserted]
lern/Vlernen/T [def: teach; study (religious texts); study (with "zikh")]
	/Gayn/Gtsu/Gop
	/Gon [def: teach a harsh lesson]
	/Goys [def: memorize (with "zikh")] 
	/Gfor [def: teach] % Forwards
	derlern/Vderlernen/Bderlernt [def: master (a study)] 
	lerer/S [m] [def: teacher]
		ze'lbstlerer/S [m] [def: teach-yourself book] 
		ta'ntslerer/S [m] [def: dance teacher] % Forwards: I. Gottesman
		lereray'/N [n] [def: teaching (activity)]
	le'rerin/S [f] [def: teacher (female)] le'rerke/S
	lerner/S [m] [def: student] /D [def: young student]
	gele'rnt/A [def: learned, educated] 
		gele'rnter [m] [def: scholar; scientist]
		gele'rntkayt/N [f] [def: erudition]
	lere/S [f] ler [m] [def: subject of study] 
	lernung/N [f] [def: learning]
	lernekhts/N [n] [def: learning]
	onlernekhts/N [n] [def: lesson]
	balerndik/A [def: informative] % Forwards: B. Sandler
		balernevdik/A [def: informative] % Leybl Botwinik
lesh/V/T [def: extinguish] /Goys
	/Bgeloshn /Goys [def: extinguish] % variant participle
	farlesh/V/Bfarloshn [def: extinguish]
	lesher/S [m] [def: extinguisher] 
	[idiom: fayer-lesher = fireman]
leshtsh/N [m] lyeshtsh/N [def: silver bream (fish, Blicca bjoerkna)]
lesnik/Ees [m] leshnik/Ees [m] [def: forest ranger]
	 lesnitse/S [f] lesnitshe/S leshnitse/S [f] [def: wife of a forest ranger]
lester/V/T [def: blaspheme] 
	lesterung/N [f] [def: blasphemy] 
	lesterer/S [m] [def: blasphemer] 
letnik/Ees [m] [def: jacket (clothing)]
lets{lc}/Xleytsem{lcym} [def: joker; scoffer; smart-aleck]
	leytsn{lycn}/Xletsonem{lycnym}/H [m] [def: mischievous imp] 
	leytsekhe{lcekhe}/S [f] [def: joker]
	letsones{lcnwT}/H/N [def: pranks, jokes; mockery] /Idik [def: joking]
	halotse{hlch}/Xhalotses{hlcwT} [f] [def: joke]
	letseve{lceve}/V/T [def: poke fun] /Gop
letsiti'n [m?] [def: lecithin (chemical)] % Forwards: Yoel Matveyev
letst/A [def: last] 
	letstns [def: recently]
	tsuletst [adv] tsuletstns [adv] [def: finally, the last time]
		[idiom: tsu letst = finally]
	farletst/A [def: penultimate] 
levad{lBd}/H [def: alone]
	hisboydedes{hTbwddwT}/H [def: solitude]
levade/S [f] [def: field, meadow]
levantish/A [def: Levantine] % Forwards: B. Sandler
levaye{lvyh}/Xlevayes{lvywT}/H [f] [def: funeral]
levone{lBnh}/Xlevones{lBnwT}/H [f] [def: moon] /Ish
	levonedik{lBnhdik}/A [def: moonlike] 
	kidesh_levone{kidwS-lBnh} [def: blessing the new moon] 
levu'sh{lBwS}/H [def: clothing; exterior (figurative)]
	malbesh{mlbwS}/Xmalbushem{mlbwSym}/H [def: outer garment (clothing)]
		malbeshl{mlbwSl}/Xmalbushemlekh{mlbwSymlekh} [n] [def: clothes]
	halboshe{hlbSh}/Xhalboshes{hlbSwT} [def: clothing, attire]
levyosn{lvyTn}/H [def: Leviathan]
leyb/N [m] leybikhe/S [f] [def: lion]
leydik/A [def: empty; unmarried, single]
	ley'dikerheyt [adv] [def: while unmarried]
	frayleydik/A [def: unmarried, single]
	leydik/V/T [def: empty] /Goys
		leydikayt/N [f] [def: emptiness]
	derleydik/V/Bderleydikt [def: empty; annul, cancel]
	laydak/Ees [m] leydatshke/S [f] [def: scoundrel]
leyen/V/T [def: read] /Giber/Gfor/Gfir/Gop/Goys/Garop/Gdurkh/Garoys
	/Gon [def: read (with "zikh")]
	leyenung/N [f] lektu'r [f] [def: reading]
	ley'ener/S [m] lezer/X [m] ley'enerin/S [f] le'zerin/S [f] [def: reader]
		ley'enershaft/N [f] [def: readership]
	forleyen/V/T [def: recite]
		forleyenung/N [f] [def: recitation]
		forlezung/N [f] [def: recitation] [usage: inadmissible]
	opgeleyent/A [def: well-read; expert]
		balezn/A [def: well-read; expert] [usage: inadmissible]
leyke/S [f] [def: funnel] % palatal L
leykemye [def: leukemia (disease)] 
leykn/V/T [def: deny] /Gop
	farleykn/V/T [def: deny]
		farleykener/S [def: denier]
		farleykenung/N [f] [def: denial]
	leykener/S [m] [def: denier]
	leykenung/N [f] opleykenung/N [f] [def: denial]
leym [f] [def: clay] /Ien /Iik /Iedik [def: clay]
	leymer/S [m] [def: plasterer] % Yiddish League
leysh/V/T [def: gild (with gold leaf)]
leytena'nt/N [m] [def: lieutenant] 
leyter/S/D [m] [def: ladder] /D
leyter/V/T [def: ease, purify] /Goys
leytse/S [f] leyts/N [f] leytsh/N [f] [def: rein]
leyt/V/T [def: solder] /Gtsu
	farleyt/V/Bfarleyt [def: solder]
	li'teve/V/T farli'teve/V/Bfarli'tevet [def: solder] % Stutchkoff
	leytekhts/N [n] [def: solder]
leyv{lB}/H [def: heart] 
	beleyv{blB} [adv] [def: with the heart]
leyvi{lvy}/Xleviyem{lvAm} [m] [def: Levite]
leyz/V/T [def: release; solve; earn] /Gop
	/Goys [def: redeem]
	leyzung/N [f] [def: solution; liberation]
	oysleyz/N [m] oysleyzung/N [f] [def: redemption; liberation]
		oysleyzer/S [m] [def: liberator; redeemer]
	derleyz/V/Bderleyzt [def: liberate]
		derleyzung/N [f] [def: liberation]
		derleyzer/S [m] [def: liberator]
	oyfgeleyzt/A [def: cheerful] % Mendl Man
lez/V/Bgelezn [def: read]
	baleznhayt/N [f] [def: education]
le'zeberke/S [f] lezbyanke/S [f] [def: lesbian] 
le'zelke/S [f] [def: non-commercial small pear (fruit) (Polish ulȩgałka leżałka)] % Sholem Asch: Motke Ganef
lezhne/S [f] [def: roof scaffolding (Russian лежень)] % Sholem Aleykhem
	[idiom: bashmirn di lezhnes = seal where the stovepipe goes through the rafters to prevent fires]
lezhanke/S [f] [def: fireplace couch]
	-/Xkhakmey_halezhanke{Hxmy-hlezhanke} [def: armchair experts]
lgote/S [def: privilege, benefit (Russian льготе)]
lib/V/T [def: love]
	/Gayn [def: fall in love with (with "zikh")]
	lib/K [def: dear] balibt/K [def: beloved]
		u'mbali'bt/A [def: unloved; disagreeable]
	libhober/S [m] [def: lover; amateur (theater)]
	farlib/V/Bfarlibt [def: love; fall in love with (with "zikh in")]
		farlibtkayt/N [f] [def: love] % Forwards: Krutikov
		farli'benish/N [n] [def: crush] % Sholem Aleykhem
	libling/N [m] [def: pet] liblekh/A [def: dear]
		liblekhkayt/N [f] [def: dearness, loveliness]
	libe/S/D [f] [def: love (romantic)] libshaft [f] [def: love (affection)]
		yidnlibe [f] [def: philosemitism] 
		[idiom: firn a linke libe = have an extramarital affair]
	libele/Xkh [def: dragonfly (insect)] 
	lyubovnik/Ees [m] lyubo'vnitse/S [f] [def: lover, beloved]
		lyubken/V/T [def: have an affair (with "zikh")]
	liber [adv] libersht [adv] [def: rather; prefer (with "hobn")]
libera'l/N/A [m] [def: liberal] liberali'zm/N [m] [def: liberalism]
lid/Eer [n] [def: song; poem] /D
	kloglid/Eer [n] [def: dirge] 
	libeslid/Eer [n] libelid/Eer [def: love song]
	folkslid/Eer [n] [def: folk song]
	kunstlid/Eer [n] [def: art song] % Forwards: I. Gottesman
	tantslid/Eer [n] [def: dance tune] % Forwards: I. Gottesman
	toytnlid/Eer [n] [def: obituary notice] 
	viglid/Eer [n] [def: lullaby]
	zinglid/Eer [n] [def: song]
lift/N [m] [def: elevator]
liftshik/Ees [m] [def: brasierre]
lig/V/Bgelegn [def: lie] /Gop/Goys/Gavek/Gayn
	leyg/V/T [def: lay]
		/Gtsu/Garayn/Goys/Ganider/Garayn/Garoyf/Gunter
		/Gahin/Garoyf/Gayn/Garop/Gfunander/Garum/Gtsurik
		/Gtsunoyf
		/Gavek [def: kill; set aside]
		/Giber [def: yield, give in (with "zikh")]
		/Gon [def: welcome, appreciate]
		/Gop [def: postpone]
		/Goyf [def: fold; put in order; dispatch]
		/Gbay [def: enclose, attach] 
		/Gayn [def: deposit (money); fold (laundry); destroy; drill (students); preserve (cucumbers); settle down to sleep] 
		/Garoys [def: go out (card games)]
		/Gfir/Gfor [def: suggest, propose] 
		/Gglaykh [def: fold flat]
		/Gdurkh [def: travel (with "zikh a veg")]
		/Gtsuzamen/Gtsam [def: fold (laundry)]
		/Gtsunoyf [def: add (mathematics)]
		firleyg/N [m] forleyg/N [m] [def: suggestion, proposal]
			firleyger/S [m] forleyger/S [m] [def: suggester] 
		leyg/Ees [m] [def: blow, slap (slang)]
		[idiom: aynleygn veltn = move heaven and earth]
		[idiom: gut oyfgeleygt = tipsy; in a good mood]
			leyger/S [m] [def: setter]
				rern-leyger/S [def: plumber] % Stutchkoff
		baleyg/V/Bbaleygt [def: lay]
		derleyg/V/Bderleygt [def: add; lose money in an enterprise]
		farleyg/V/Bfarleygt [def: blocked (with "noz"), constipated; folded (with "hent)"; establish]
			[idiom: zitsn mit farleygte hent = choose not to act]
		tseleyg/V/Btseleygt [def: lay; stretch oneself out (with "zikh")]
			tseleyger/S [m] tseleygerke/S [f] [def: big shot]
		bayleyg/N [m] [def: enclosure, attachment (mail)] 
		firleyg/N [m] forleyg/N [m] [def: suggestion] 
		opleygekhts/N [n] [def: procrastination, postponement]
		oyflage/S [f] [def: edition]
		oysleyg [m] [def: spelling]
		tsuleyg [def: addendum]
		tsunoyfleyg [m] [def: addition (mathematics)]
		gruntleygndik/A [def: essential, fundamental] % Borokhov
		oyfgeleygt/A [def: in a good mood]
	farla'g/N [m] [def: publishing house]
		farleger/S [m] farle'gerin/S [f] [def: publisher] 
			farle'gerish/A [def: publication-related]
		farlegeray' [n] [def: publishing] 
	farlegn/A [def: stale, old] 
	geleger/S [n] [def: bed; couch] nakhtleger/S [n]
	gele'gnhayt/N [f] [def: opportunity, chance]
		[idiom: forn mit a gele'gnhayt = hitchhike] [note: V]
		ongele'gnhayt/N [f] [def: theme, subject]
		[idiom: mir iz gelegn = it's important/convenient to me]
	farle'gnhayt/N [f] [def: embarrassment; dilemma]
		[idiom: shteln in a farlegnhayt = embarrass, put on the spot]
	oplog/N [m] [def: cache; refuge, hiding place; meeting place]
	tsulog/N [m] [def: something added; attachment (mail)] [note: V]
	oyflog/N [m] [def: decoration]
	u'nterlog/N [m] [def: trivet] 
	oyfgeleygtlekh/A [def: calm] % Der Nister
ligatu'r/N [def: ligature]
lige/S [f] [def: league]
lign/S [m] [def: falsehood]
	layg/V/T [def: tell a lie]
	ligner/S /Iish li'gnerke/S [f] lignerte/S [f] lignerin/S [f] [def: liar]
		ligneray'/N [n] [def: lying] % Forwards: Yoel Matveyev
	ligner/V/T [def: lie] /Gop
lik/Ees [m] [def: alley] /D
like{lykui}/H [f] [def: eclipse (with "halevone{hlBnh}" or "hakhame{hHmh}")]
like'r/N [m] [def: liqueur (drink)]
likhoyre{lix#wrh} [adv] [def: apparently; at first glance]
likht/X/D [f] [def: candle]
	likht/X [n] [def: light]
	likhtik/K [def: bright] likhtikayt/N [f] [def: brightness]
		likhtik/V/T [def: become bright]
	loykht/V/Bgeloykhtn [def: shine] /Gdurkh/Goyf
		baloykht/V/Bbaloykhtn [def: illuminate]
			baloykhtung/N [f] [def: illumination]
		tseloykht/V/Btseloykhtn [def: illuminate]
		loy'khndik/A [def: illustrious]
	laykhter/S [m] [def: candlestick]
		henglaykhter/S [m] [def: candelabra]
	laykht/V/T [def: shine] /Gdurkh/Garayn/Gtsu
		/Goyf [def: start shining]
		balaykht/V/Bbaloykhtn [def: illuminate]
			balaykhtung/N [f] [def: illumination, lighting]
	ayzlikhtl/Eekh [n] [def: icicle]
	bentshlikht [def: Sabbath candles]
		[idiom: a teyrets{Wyrwc} far di bentshlikht = a weak excuse]
	blitslikht/N [def: flashlight]
	morgnlikht/X [n] [def: morning light] 
	toglikht/X [n] [def: daylight]
	yortsaytlikht/X [n] [def: memorial candle]
	likhttsier/S [m] likhttsi'erin/S [f] [def: candle-maker]
	[idiom: yortsayt likht = memorial candle]
likvidi'r/V/Blikvidi'rt [def: liquidate]
	likvidatsye/S [f] [def: liquidation; settlement (monetary)]
	likvidirung/N [f] [def: liquidation, elimination]]
lila/A lilove/A [def: violet, purple (color)] % final l is palatal
lilye/S [f] [def: lily (flower)]
	lilike [f] [def: Liliaceae (botanical family)] % Forwards: Hershl Glaser
limfe [f] [def: lymph] % Stutchkoff
li'mene/S [f] [def: lemon]
	limena'd/N [m] limona'd/N [m] [def: lemonade (drink)]
limuzi'n/N [m] limuzine/S [f] [def: limousine (conveyence)]
linder/V/T [def: ease]
	lind/A [def: gentle]
lindz/N [f] [def: lentil]
lingvi'st/N [m] lingvistke/S [f] [def: linguist]
	lingvistik [f] [def: linguistics (subject)] lingvistish/A [def: linguistic]
	tsvishnlingvistik [f] [def: comparative linguistics (subject)]
		tsvishnlingvistish/A
	sotsyolingvistik [f] [def: social linguistics (subject)] sotsyolingvistish/A
link/K [def: left; wrong; illegal] linki'st/N [m] [def: leftist (political)]
	gelinkt/A [def: left-handed]
	link/V/T [def: bend leftwards]
	link/V/Bgelunken /Goys [def: sprain; dislocate]
		lenk/V/T /Goys [def: sprain; dislocate]
linoleum [m] [def: linoleum] % B. Sandler: Karolina-Bugaz
linye/S [f] [def: line]
	hartlinik/A [def: hard-line, inflexible]
	liniar/A [def: linear]
	ba'nlinye/S [f] [def: railway line]
	fli'linye/S [f] [def: airline] [note: V] 
	rern-linye/S [f] [def: pipeline] 
	ta'ktlinye/S [f] [def: barline (written music)] % Stutchkoff
lip/N/D [f] [def: lip] lefts/N
	lup/N [m] lupe/S [f] [def: lip]
	hoznlip/N [def: cleft palate] 
	leftsung/N [f] [def: estuary; river mouth]
lipe/S [f] [def: log]
lipe/S [f] linde/S [f] [def: linden (tree)] lipove/A [def: linden]
li'prat_kotn{lprt-ktn} [def: in short form; without the thousands (Jewish year)]
	lapa'k{lp"k} [def: in short form]
lire/S [f] [def: lyre (musical instrument)]
lirik/N [f] [def: lyric] lirish/A [def: lyric]
	liriker/S [m] [def: lyric poet]
lise/S [f] [def: bald head] lisik/A
	lisine/S [f] [def: bald head]
lishay/Een/Ees [m] [def: lichen; skin fungus] 
lishe/V/T [def: make a noise; thud; strike a blow]
liske/S [f] [def: scale (fish)] 
liste/S [f] [def: list] 
listik/K hinterlistik/K [def: false-faced] [usage: archaic]
liter/S [m] [def: liter (metric unit)] 
literatu'r/N [f] [def: literature]
	fakt-literatur/N [f] [def: non-fiction] [note: V]
	literarish/A [def: literary] literarishkayt/N [f] [def: literariness]
	litera't/N [m] [def: writer; author]
		literator/N [m] [def: writer; author] [usage: not recommended]
litke/S [f] [def: thigh; calf (body part)] 
litogra'f [m?] [def: lithograph] /Iish
litsents/N [f] [def: license (permission)]
	[idiom: poetishe litsents = litsentsiya poetika = poetic license] [note: V]
litseum/S [m] [def: Lyceum, high school] 
litsiti'r/V/Blitsiti'rt [def: auction] litsitatsye/S [f] [def: auction]
liturgye/S [def: liturgy] liturgish/A [def: liturgical] 
lityum [m] [def: lithium (Li)] 
livak/Ees [m] [def: left-handed person]
liver/V/T [def: supply; transport] /Giber
	/Goys [def: deport; extradite]
	liverant/N [m] [def: contractor, caterer, purveyor, carriageman] 
	livree/S [f] [def: livery] 
	liver/V/T [def: supply] 
	oysliverung/N [f] [def: extradition]
	lifer/V/T [def: supply; transport] [usage: inadmissible]
		/Giber [usage: inadmissible]
		/Goys [def: deport; extradite] [usage: inadmissible]
		oysliferung/N [f] [def: extradition] [usage: inadmissible]
lyag [m] [def: brine]
lyak/Ees [m] hlyak/Ees [m] [def: jug, ewer, hot-water jar (Ukrainian глек)] % Z. Shneyer
lyarem/N [m] [def: din, noise, clamor]
	lyarem/V/T [def: make a commotion] % Menakhem Kipnis
lyaske/V/T [def: thrash, whip]
	lyask/N [m] [def: beating, whipping]
lyod [m] [def: ice] 
	lyode/S [f] [def: icy confection; ice cream (in plural)] 
	[idiom: kalt vi lyod = ice cold]
lyok [m?] [def: clay jug]
lyokhe/S [f] [def: sow (female pig)] 
lyustre/S [def: large mirror]
lyustri'n [m] [def: lustrine silk (glossy fabric)]
	lyustrirn/A lyustrinin/A [def: lustrine] % Sholem Aleykhem
lob/V/T [def: enjoy (with "zikh mit")]
lobus/N/Ees [m] lobuz/Ees [m] [def: rascal, youngster (pejorative)]
lobze/S [f] [def: trifle, silly thing] % Stutchkoff
loet{lhwt} [adj] [def: greedy]
logaritmik [f] [def: logarithmics]
	logaritm/N [m] [def: logarithm] /Iish [def: logarithmic]
	logaritmirung/N [f] [def: extracting logarithms]
	antilogaritm/N [m] [def: antilogarithm (exponential)]
logi'k [f] [def: logic] logish/A [def: logical] 
	logishervayz [adv] [def: logically] 
logl/N [f] [def: flask]
	logl/V/T [def: pour] /Goys/Giber/Gon
lod/V/Bgelodn [def: load; file suit against] /Gayn/Giber
	/Gon [def: load up; recharge (electric)]
	/Goys/Gop [def: unload]
	/Garop [def: download (from computer)]
	/Garoyf [def: upload (to computer)]
	loden/V/T [def: load] /Goys [def: unload] % variant
	balod/V/Bbalodn [def: load]
	farlod/V/Bfarlodn [def: load]
	lodung/N [f] [def: load, summons]
	lo'denish/N [n] [def: lawsuit, litigation; summons, subpoena]
	onlod/N [m] [def: additional ingredient] % Forwards: Yoel Matveyev
	on'loder/S [m] [def: charger (electric)]
lodishik/Ees lodishtshik/Ees [m] [def: jug]
lodke/S [f] [def: boat]
lodn/S [m] [def: shutter]
	/Dled [def: shutter; eyelid (part of body); cover, lid]
lodotshnik/Ees [m] [def: boatman]
lodzh [m?] [def: lodge, fraternal society] % Sholem Asch: Ist River 
lohem{lhm}/H [def: to them]
lok/N [f] [def: lock (hair)] /Dlek
	gelokt/A [def: curly (hair)]
lok/V/T [def: annoy]
loka'l/A [def: local]
	loka'l/N [m] [def: premises, locale] 
		atletik-lokal/N [m] [def: health club] [note: V]
		genitung-lokal/N [m] [def: health club] [note: V]
		na'khtlokal/N [m] [def: nightclub] 
	lokali'zm/N [m] [def: dialectical expression]
lokato'r/N [m] [def: tenant]
	sublokato'r/N [m] [def: subtenant]
lokene/S [f] [def: hair curler (Russian локон)] % "Yoshke fort Avek"
loker/V/T lug/N/T [def: lurk, lie in wait for (with "oyf")]
	loyer/V/T [def: lurk; lie in wait] [usage: not recommended]
	loker/N [def: ambush] /Idik
lokh/Xlekher [m/f] /Dlekh [def: hole; vagina (body part; vulgar)]
	lekherik/A [def: leaky, porous]
	fentsterlokh/Xfe'ntsterlekher [f] [def: window opening] % L. Shapiro
	knoplokh/Xkno'plekher [f/m] [def: buttonhole (clothing)]
	kroliklokh/Xkro'likleher [f] [def: rabbit hole] 
	moyznlokh/Xmay'znlekher [f] [def: mouse hole] 
	nozlokh/Xno'zlekher [f] [def: nostril]
	ratsnlokh/Xra'tsnlekher [f] [def: rat hole]
	shlisllokh/Xshli'sllekher [f/m] [def: keyhole]
	lekher/V/T /Gdurkh farlekher/T/Bfarlekhert [def: pierce]
lokomoti'v/N [m] [def: locomotive]
loksh/N [m] [def: noodle; thin person; American dollar (Brazilian Yiddish)] /Ien
	[idiom: langer loksh = tall, thin person]
lom/A [def: lame]
	geleymt/A [def: paralyzed]
		geleymtkayt/N [f] [def: paralysis]
	tselomt/A [def: crippled]
lombard/N [m] [def: pawnshop]
lomp/N/Xlemp [m] [def: lamp] /Dlemp [def: electric bulb]
	gasnlomp/N [m] [def: gas lamp]
	blitslomp/N [m] [def: chandelier] % Der Nister
		/Dblitslemp [def: flashlight] 
	henglomp/N [m] [def: chandelier]
	nakhtlomp/N [m] [def: night light] /Dnakhtlemp
	spirtlempl/Eekh [n] [def: alcohol lamp] 
	lomp-torsher [m] [def: kind of lamp] % Forwards: Boris Sandler
lonke/S [f] [def: meadow; forest clearing; lawn]
	lan/N [m] [def: meadow]
lontsh [m?] [def: lunch] [usage: Americanism]
lopete/S [f] [def: shovel; long wooden paddle] % not lopate
	/Dlopet [def: small shovel; cooking spoon]
	[idiom: kotsheres mit lopetes = scribblings]
	[idiom: kotshere-lopete = two opposites]
lopne/V/T [def: burst]
lorber/S [m] [def: laurel (tree)]
lord/N [m] [def: lord] 
	[idiom: lebn vi di lordn = live a life of ease]
lorentsyum [m] [def: lawrencium (Lr)] 
lornet/N [def: binoculars, lornette]
loshik/Ees [m] [def: colt] /D
loshn{lSwn}/Xleshoynes{lSwnwT}/H [n] [def: language]
	/Lha{h} [def: the language] /Lbe{b} [def: in the language]
	mameloshn{mame-lSwn} [n] [def: mother tongue, Yiddish]
	may'neloshn{menh-lSwn} [n] [def: cemetery prayers; eloquence]
	shtum-loshn{shtum-lSwn} [n] [def: sign language]
	targum_loshn{Wrgwm-lSwn}/H [n] [def: Aramaic]
	boze_haloshn{bz|h-hlSwn} [adv] [def: as follows, in these words]
	kehay_lishne{Kh#y-lySn#} [adv] [def: as follows, in these words]
	ume_veloshn{umh-|ulSwn} [m?] [def: people with a national language]
	loshn_hore{lSwn-hre} [n] [def: slander; gossip]
		loshn_horene{lSwn-hrene}/V/T [n] [def: slander; gossip] % Stutchkoff
		loshn_horenik{lSwn-hrenik}/Ees [m] [def: slanderer]
	loshn-koydesh{lSwn-kwdS} [n?] [def: Hebrew / Aramaic] /Idik
	[idiom: loshn{lSwn} sgenehoyr{sgy-nhwr} = euphemism]
	[idiom: eydl loshn{lSwn} = euphemistic speech]
lot/N [m] [def: plumbline]
loterye/S [f] loterey'/N [f] [def: lottery]
	loterayke/S [f] [def: lottery tickets] 
	loto [m] [def: lotto]
lotke/S [f] [def: boat]
lovke/A [def: nimble (Russian ловка)]
loy{l#}/H [def: not] lav{lav}/H [def: not]
	[idiom: loy{l#} mit an alef{alf} = absolutely not]
loya'l{lo|yal}/A [def: loyal]
	loyalkayt{lo|yalkeyt}/N [f] loyalite't{lo|yalitet}/N [f] [def: loyalty] 
	umloyal{umlo|yal}/A [def: disloyal]
		umloyalkayt{umlo|yalkeyt}/N [f] [def: disloyalty]
loyb/V/T [def: praise] /Gop
	/Goys [def: eulogize]
	farloyb/V/Bfarloybt [def: praise]
	derloyb/V/Bderloybt [def: allow] derloy'benish/N [n] [def: permission]
	loy'benish/N [n] [def: praise] loyb [f]
	urloyb/N [m] [def: leave, furlough] 
	[idiom: oplozn/aoysloyzn oyf urloyb = furlough something]
loybish/A [def: Polish (klezmer-loshn)]
loyeg_lero'sh{lweg-lrS} [m] [def: someone who makes fun of a poor or unlucky person]
loyf/V/Bgelofn [def: run]
	/Gavek/Garayn/Garoys/Garum/Gfarbay/Gon/Gtsu/Gtsurik/Gum/Giber/Gunter
	/Gantkegn/Gtsunoyf/Gadurkh/Gtsuzamen/Goys/Garop/Gdurkh/Gnokh
	/Gforoys/Gaheym/Gaher/Garoyf/Gop/Gariber/Giber
	/Goyf [def: swell]
	baloyf/V/Gbalofn [def: mount, cover, impregnate (animal); overflow]
	derloyf/V/Gderlofn [def: run to a goal] % Itsik Kipnis
	loyfl/V/T [def: jog] 
	loyfndikerheyt [def: running]
	loy'fenish/N [n] [def: diarrhea]
	farloyf/V/Bfarlofn [def: pass (time), occur]
		farloy'f [m] [def: passage of time]
		farloy'fenish/N [n] [def: happening, event]
	antloyf/V/Bantlofn [def: run away]
		antloyf [m] antloy'fenish/N [n] [def: running away]
	tseloyf/V/Btselofn [def: run]
	tsuzamenloy'fenish/N [n] [def: rushing together] % Menakhem Kipnis
	geloyf [n] [def: running] tsaytgeloyf [n] [def: passage of time]
		ayngeloyf/N [m] [def: running in] % Sholem Aleykhem
		ongeloyf [n] [def: stampede; running to something]
	unterloyf [n] [def: undercurrent] % L. Shapiro
	loyfer/S [m] [def: runner] loy'fenish/N [n] [def: running]
		mi'tloyfer/S [m] [def: companion; comrade] 
		no'khloyfer/S [m] [def: fellow traveller (Communist)] % Forwards: M-S Hoffman
		ve'gloyfer/S [m] [def: roadrunner (bird)] 
	oy'floyfenish/N [n] [def: disaster] % Sholem Aleykhem
	shpring-un-loyf [m] [def: track-and-field] [note: V]
	loyfik/A [def: up to date, current; rapid]
		loyfikayt/N [f] [def: speed] % Der Nister: Mashber
		forloyfik/A [def: meanwhile] [usage: not recommended]
	geleyfik/A [def: fluent]
loyn/V/T [def: pay; be worthwhile; be of use (with "zikh")]
	baloyn/V/Bbaloynt [def: reward, pay]
		baloynung/N [f] [def: reward, payment, fee for work]
	loyn/N [m] [def: wages; reward]
loyt/P [def: according to]
loyter/A [def: pure] loyterkayt/N [f] [def: purity] 
	layter/V/T /Goys loyter/V/T [def: purify] /Goys
loyz/V/T [def: empty]
	loyz/A [def: empty]
loyz/Xlayz [f] [def: louse (insect)]
	blatloyz/Xblatlayz [f] [def: aphid (insect)]
	loyz/V/T [def: delouse] 
	farlayzikt/A [def: louse-ridden] % Rokhl Korn: shotns
loz/V/T [def: let]
	/Garayn/Garop/Garoys/Garunter/Gavek/Gfarbay/Gop/Goys/Garoyf
		/Gdurkh/Gadurkh [def: let through; omit] 
		/Gfray [def: set free] % Sutskever; Rokhl Korn: shotns
		/Gfunander [def: depose; neglect health (with "zikh"); adjourn (meeting); be loquacious (with "zikh")]
		/Giber [def: abandon; leave behind; donate]
		/Gnokh [def: slacken; abandon; neglect]
		/Gtsu [def: permit]
	/Bgelozn % variant participle
	/Garayn/Garop/Garoys/Garunter/Gavek/Gfarbay/Gop/Goys
		/Gdurkh/Gadurkh [def: let through; omit] 
		/Gfray [def: set free] % Sutskever
		/Gfunander [def: depose; neglect health (with "zikh"); adjourn (meeting)]
		/Giber [def: abandon; leave behind; donate]
		/Gnokh [def: slacken; abandon; neglect]
		/Gtsu [def: permit]
	derloz/V/Bderlozt [def: allow; tolerate] derlozbar/A [def: allowable]
	farloz/V/Bfarlozt [def: depart from, desert; depend on (with "zikh oyf")]
		farloztkayt/N [f] [def: state of bein deserted]
		farlozn/A [def: deserted]
		farlozenish/N [n] [def: reliance on a Rabbi's opinion] % Sholem Aleykhem
		farlozlekh/A [def: reliable, dependable]
			umfarlozlekh/A [def: unreliable, undependable]
	tseloz/V/Btselozt [def: loosen (hair); melt]
		tselozn/A [def: loose (hair or morals); spoiled, pampered]
			tseloznkayt/N [f] [def: looseness (hair or morals)]
	aroy'sloz/N [m] [def: emission, discharge]
	durkhloz/N [m] [def: omission]
	lebnslo'zikayt/N [f] [def: lifelessness]
	lozung/N [f] [def: slogan, motto] 
	oploz/N [m] [def: release] % Forwards
	oysloz/N [m] [def: punchline; outcome] [note: V] 
	tsugelozt/A [def: approachable, amiable]
		tsugeloztkayt/N [f] [def: approachability, amiability]
	lomir [def: let's] lomikh [def: let me]
	[idiom: zikh nit lozn = play hard-to-get]
lozhe/S [f] lozh/N [m] [def: loge (theater seating section)]
luakh{lwH}/Xlukhes{lwHwT}/H [m] [def: calendar; tablet]
lumbago [m] [def: lumbago (disease)]
lufe/S [def: loofa (scrubber)]
luft/N [f] [def: air] /D [def: dandelion (plant)]
	luftik/K [def: airy]
		luftikayt/N [f] [def: airiness]
	lufter/V/T [def: ventilate] /Goys/Gdurkh/Giber
		lu'fternish/N [n] [def: ventilation, airing out] % Stutchkoff
	lufterer/S [def: fan, ventilator]
	luftshik/Ees [m] [def: transom; air-shaft]
	[idiom: durkhluftern an inyen{enyn} = consider a matter]
	[idiom: lozn luft/luftn = pass wind, fart]
lug/V/T [def: lurk; look for (with "oyf"); observe (with "oyf")] /Gnokh
luke/S [f] [def: porthole] % l is palatal
luksus/N [m] [def: luxury] luksusdik/K [def: luxurious, upscale] 
	luksurye'z/A [def: luxurious] [usage: not recommended]
lulev{lwlB}/Xlulovem{lulBym}/H [def: lulav (ceremonial bundle including willow, myrtle, palm waved on Succos] /Dlulev{lwlB}
lump/N [m] [def: scoundrel, bum]
lunatiker/S [f] [def: lunatic; crazy person] /Ilunatish
	lunati'zm/N [m] [def: insanity]
lung/N [f/m] [def: lung]
lupe/V/T /Gop [def: peel, flake]
lupe'/S [f] [def: loupe (jeweler's)]
lust [f] [def: desire, cheer] /Iik [def: cheerful]
lustre/S [f] [def: chandelier]
lutein [def: lutein (food chemical)] 
luteraner/X [def: Lutheran]
lutetsyum [m] [def: lutetium (Lu)] 
lyade [adj] [def: any] [grammar: indeclinable, attributive]
lyade/S [f] [def: counter of a sales stall] % Avrom Karpinovitsh
lyalke/S [f] [def: doll] /D
lyape/V/T [def: smear, botch]
	lyape/S [def: salve]
lyarem/V/T [def: make a commotion; raise an alarm]
	lyarem/Xlyarmen [def: din, noise, alarm] lyarmik/A
lyazg [m?] [def: blow, clang (Russian лязг)] % Stutchkoff
lyu [def: lyu: lullaby syllable]
	lyulye/V/T /Gayn [def: lull, put to sleep]
lyube/V/T [def: fondle; pet (with zikh); make love (with zikh)]
	farlyube/V/Bfarlyubet [def: enrapture (with "zikh" and dative)] % Sholem Aleykhem: Shprintse
	lyubenyu [def: dear] [grammar: term of address]
	lyubtshik/Ees [m] [def: forget-me-not (flower, Myosotis spp.)] % Rokhl Korn
lyulke/S [f] [def: pipe] /D
mabl{mbwl}/Een/H [m] [def: flood]
	mabl/V/T [def: pour torrentially (intransitive)]
madam/N [f] [def: madam] madamenyu [def: dear madam (usually sarcastic)] 
madone/S [f] [def: Madonna]
madreyge{mdrgh}/Xmadreyges{mdrgwT}/H [f] [def: level]
	hadroge{hdrgh}/Xhadroges{hdrgwT} [def: stage, level]
	behadroge{bhdrgh} [def: little by little, in stages, gradual] /Idik
	grunt-madreyge{grunt-mdrgh} [f] [def: ground state (energy level)]
mafter{mftyr}/H [m] [def: last reading of the Torah]
mafye/S [f] [def: mafia, gang]
magaritsh [m] moritsh [m] [def: tip, gratuity (to a non-Jewish worker)]
magazin/N [m] [def: warehouse, storage shed]
maged{mgyd}/Xmegidem{mgydym}/H [m] [def: itinerant preacher] 
magemase{mge-|wmQ#}/S [f/m] [def: business dealings (with "mit")]
mageyfe{mgfh}/Xmageyfes{mgfwT}/H [f] [def: plague, cholera (disease)] 
magik [f?] [def: magic] magish/A [def: magical]
magister [adj] [def: master (degree)] 
magistra'l/N [m] [def: rhapsody; main road or train line; window in defensive tower; sewer main]
magistra't/N [def: magistrate]
magnat/N [m] [def: magnate]
magnezyum [m] [def: magnesium (Mg)] 
magnet/N [m] [def: magnet] /Iish
	magnetiz'ir/V/Bmagnetizi'rt [def: magnetize]
magreb [m] [def: Magreb (region of northern Africa)] 
	mugrabish [def: Judeo-Arabic from the Magreb] 
mahala [noun] [def: district in a town (Russian)] 
makare'l/N makre'l/N [m?] [def: mackerel (fish)]
make{mKh}/Xmakes{mKwT} [f] [def: plague, sore, wound, abcess; nothing of value]
	[idiom: esn makes{mKwT} mit bkhoyres{bxwrwT} = have little to eat]
makel{mkl}/H [def: stick]
makeron/Dmakerond [def: macaroon (food)]
makh/V/T [def: make; defecate (with "mit")] /Giber/Gadurkh/Goyf/Gtsuzamen
	/Gavek [def: dismiss; brush off; shrug off]
		[idiom: avekmakhn mit der hant = dismiss with a wave of the hand]
	/Gtsu [def: close]
	/Gmit [def: endure] 
	/Gnokh [def: imitate]
	/Gon [def: ruin]
	/Gop [def: finish; arrange; agree]
	/Ggut [def: recompense]
	/Goys [def: make a difference]
	/Gdurkh [def: go through; undergo] 
	/Gunter [def: fake, counterfeit; defecate (slang)]
	gema'kht/A [def: artificial] 
		ha'ntgema'kht/A [def: hand-made]
	farmakh/V/Bfarmakht [def: lock]
	dermakh/V/Bdermakht [def: complete]
	tsemakh/V/Btsemakht [def: make]
	ayngemakht|s/N [n] [def: preserves, jam (food)]
		[idiom: dem oremans ayngemakhts = sexual intercourse]
	opmakh/N [m] [def: agreement, arrangement, entente; contract]
	gema'kh [def: at ease, in peace (with "lozn -")]
	makher/S [m] [def: big shot; fixer]
		[idiom: gantser makher = very important person]
		baytl-makher/S [m] vatn-makher/S [m] vatl-makher/S [m] [def: devil]
		hitl-makher/S [m] [def: hatmaker]
		kishef|makher/S [m] kishef|ma'kherin/S [f] [def: magician]
		ko'zhelik-makher/S [m] [def: acrobat]
		kuntsnmakher/S [m] [def: trick performer, juggler] 
		meltsmakher/S [m] [def: brewer]
		neplmakher/S [m] [def: nebulizer] % Maurice Wolfthal
		pari'k-makher/S [m] /Iski parikma'khershe/S [f] [def: hairdresser]
			parikma'kherske/S [f] [def: barber shop, hairdresser] % Stutchkoff, Avrom Karpinovitsh
		shakher-makher [m] [def: illegal dealings]
		shindlmakher/S [m] [def: shingle-maker] % Y. Y. Singer
		shtepnmakher/S [m] [def: fashioner of shoe uppers]
		stelmakh/Es stelmakher/S [m] [def: maker of yokes/wheels for horses and carts] 
		zotl-makher/S [m] [def: saddle-maker]
		zeyger-makher/S [m] [def: watchmaker] 
		zeyger-makheray/N [n] [def: watchmaking] 
	gutmakhung/N [f] vidergutmakhung/N [f] [def: recompense]
	nokhmakhung/N [f] [def: imitation] 
		nokhmakher/S [m] [def: imitator, mimic]
	makherayke/S [f] [def: imitation; contraption, widget, gadget] 
	makhenatsye/S [f] [def: plot, intrigue]
/Xmakhzokes{mHzkwT} [f] [def: delay (often with "makhn")]
makhmer{mHmyr}/H [verb] [def: be ritually strict (with "zayn")]
makhmes{mHmT}/H [def: because]
makhne{mHnh}/Xmakhnes{mHnwT}/H [f] [def: crowd; multitude]
	makhnesvayz{mHnwTvayz} [def: in a crowd]
makhon /Ien mahon mahagoni [m?] [def: mahogany (wood)]
makhorke [def: coarse tobacco]
makhshove{mHSBh}/Xmakhshoves{mHSBwT}/H [f] [def: deep thought] 
makht/N [f] [def: power; regime] mekhtik/A [def: powerful]
	ummakht/N [f] onmakht/N [f] [def: swoon, faint]
		[idiom: faln in ummakht = faint]
		u'mmakhtik/A o'nmekhtik/A u'mmekhtik/A [def: powerless]
	almekhtik/A [def: almighty]
	groysmakht/N [f] [def: Great Gower (political)]
	oybermakht/N [f] [def: superior power, superiority]
	bafulmekhtik/V/Bbafulmekhtikt [def: authorize] 
		bafulmekhtikung/N [f] [def: authorization] 
	makhtloz/A [def: weak] makhtlo'zikayt/N [f] [def: weakness]
makhzik{mHzyk}/H [def: strengthen]
makohine/S [f] [def: pestle]
makped{mkpyd}/Xmakpidem{mkpydym} [m] [def: strict] 
	hakpode{hkpdh}/Xhakpodes{hkpdwT} [f] [def: strictness; sternness]
makrete/S [f] [def: soup bowl]
maksimum [m] [def: maximum]
makukhe/S [f] [def: poppy (plant)]
malay [def: a food made of corn meal (Ukraine)] 
male [def: no telling, it little matters (with a question word like "vos")]
malekh{ml#x}/Xmalokhem{mloxym}/H [m] malekhte{ml#xte}/S [f] [def: angel]
	hamalakh{hml#x} [m] [def: the angel]
	malekhl{ml#xl}/Xmalokhemlekh{mloxymlekh} [n] [def: little angel]
malene/S maline/S [f] [def: raspberry] % malene has a palatal l
maline/S [f] [def: hiding place] [usage: slang]
-/Xmalkes{mlkwT}/H [def: punishment of whipping]
malpe/S [f] /D [def: monkey] /Ish malpish/A
	malpeve/V/T /Gnokh [def: imitate] % Forwards: M-S Hoffman
malts/N [noun] [def: malt (food ingredient)]
ma'lyeve/V/T [def: paint]
	ma'lyever/S [m] [def: painter]
mame/S/C/J [f] [def: mother; mare (balegole-loshn)]
	mameshi [f] mamenyu [f] maminke/S [def: dear mother; wow! (interj)]
	mamele/Ekh [f] [def: little girl (affectionate); wow! (interj)]
	shti'fmame/S [f] [def: stepmother]
	u'rmame/S [f] [def: ancestor (female), foremother]
	-/Xtate-mame [def: parents (only in plural)] 
	alma_mater/S [f] [def: alma mater (institution); alma mater (song)]
mamelige/D [def: maize grits (food)]
mamesh{mmS}/H [def: actually]
	mamoshes{mmSwT}/H [def: actuality, substance] /Idik [def: actual]
	mameshdikayt{mmSdikayt} [f] mamoshesdikayt{mmSwTdikayt}/N [f] [def: actuality]
-/Xmamtakem{mmWkym} [def: sweet foods; money (slang); bribery]
mamze'l/N [f] [def: mademoiselle (French)]
mamzer{mmzr}/Xmamzeyrem{mmzrym}/H [def: bastard] /Iish /Ish
man/Xmener [m] [def: man] /Iish menersh/A me'nerish/A [def: male]
	mantsbil/N /Ish mansbil/N [def: male] /Ish /Iish /Idik [def: male]
	dzhentelmen/Eer [def: gentleman] /Iish
	militerman/Emilitermener [m] [def: soldier]
	menlekh/A [def: human] mantshik [def: man]
	manshaft/N [f] [def: team]
	landsmanshaft/N [f] [def: organization of people from the same district]
	a'dlman/Xadllayt [m] [def: nobleman]
	akerman/Xakermener [m] [def: plowman]
	arbet|sman/Xarbet|smener [m] [def: worker]
	bot|sman/Xbot|smener [def: boatsman] % Stutchkoff
	ey'dlman/Xey'dlmener [def: gentleman]
	ey'erman/Xey'ermener [def: stallion (balegole-loshn)]
	fakhman/Xfakhlayt [m] [def: skilled laborer]
		fakhmenish/A fakhme'nerish/A [def: skilled]
		fakhmenishkayt/N [f] [def: skill] 
	furman/Xfurmanes [m] [def: wagon driver] 
	gesheft|sman/Xgesheft|smener [m] [def: businessman] 
	hoyptman/Xhoyptmener [m] [def: chief]
	kongresman/Xkongresmener [m] [def: congressman (American)]
	landsman/N [m] [def: person from the same district]
	lot|sman/Xlot|smener [def: boatsman] % Stutchkoff
	musulman/Xmusulmener [m] [def: Moslem; emaciated person] 
		musulmenish/A musulmaner [adj] [def: Moslem; emaciated]
	shlakhtman/Xshlakhtmener [m] [def: warrior]
	shpilman/Xshpilmener [m] [def: bard, troubador]
	shtatman/Xshtetmener [m] [def: statesman]
		shtatme'nerish/A [def: statesmanlike] 
	tsaytungsman/Xtsaytungsmener [m] [def: newspaperman] % Forwards: M-S Hoffman
	vakhman/Xvakhmener [m] [def: watchman]
	vegsman/Xvegslayt [m] [def: voyager, traveller]
	yungerman [m] [def: youth] yungermantshik [m] 
		yungnman [m] yungnmantshik [m] [def: youth] % accusative, dative
	man/N [m] [def: husband] /D
		filmeneray'/N [n] [def: polyandry] 
man_{mn} [m] [def: manna] 
-/Xmanatkes [f] [def: poor belongings]
manazherye/S [f] [def: management] % Forwards: M-S Hoffman
manderin [def: Mandarin (language)] manderiner [adj] /Iish
mandat/N [m] [def: mandate]
mandiburke/S [def: potato] % Stutchkoff
mandl/N [m] [def: almond (food); tonsil (body part)]
mandl [m] mandl [m] [def: 15 (eggs)]
mandoline/S [f] [def: mandoline (musical instrument)]
mane [f] [def: semolina (grain)]
maneke'n/N [m] [def: manikin]
manevri'r/V/Bmanevri'rt [def: maneuver]
	manevre/S [f] manyevre/S [f] [def: maneuver, plan] 
	manever/S [m] [def: maneuver (military)]
mangan [m] [def: manganese (Mn)] 
mangl/N [m] [def: shortage]
manifesti'r/V/Bmanifesti'rt [def: demonstrate]
	manifest/N [m] [def: manifesto]
	manifestatsye/S [f] [def: demonstration (political)]
	manifesta'nt/N [m] [def: demonstrator]
maniforge/S [f] [def: device, stratagem, ploy]
maniki'r/V/Bmanikir't [def: manicure]
	manikuri'r/V/Bmanikuri'rt [def: manicure (with "zikh")] % Forwards: M-S Hoffman
	maniki'r/N [m] [def: manicure]
manipuli'r/V/Bmanipuli'rt [def: manipulate]
	manipulatsye/S [f] [def: manipulation] 
mani'r/N manye'r/N [m?] [def: method, manner]
manishke/S [def: shirt-front (male clothing)]
manke't/N [m] [def: cuff (of clothing) (French manchette)]
mankhe/A [def: many, some] [usage: inadmissible]
mantl/N [m] [def: coat] mentele/Xekh [def: short coat; Torah mantle]
	dekmantl/N [m] [def: overcoat]
	regnmantl/N [m] [def: raincoat]
	mentlik/N [m?] [def: fuss, bother]
		[idiom: makhn a mentlik = boast; get a strange idea] % Stutchkoff
		[idiom: ton emetsn a mentlik = do someone a favor] % Stutchkoff
		[idiom: tu mir nit keyn mentlik = I can manage by myself] % Hoffman
manufaktur [f] [def: manufacture]
	manufakturi'st/N [m] [def: manufacturer]
manuskript/N [m] [def: manuscript]
manya'k/N [m] [def: crazy person, maniac] /Ialish
manye/V/T [def: lure]
manzhe't/N [m] [def: cuff] /D
mape/S [f] [def: map]
	mapi'r/V/Bmapi'rt [def: map out] 
mapl{mpyl}/H/V/T [def: miscarry]
	mapole{mplh}/Xmapoles{mplwT}/H [f] [def: miscarriage; downfall]
mar{mr} [m] [def: Mr.] mores{mrT} [f] [def: Mrs. (usually with first name)]
mara'n/N [def: Marrano] 
marder/S [def: marten (animal)]
mare{mr#h}/H [f] [def: appearance]
marevikher/S [m] [def: pickpocket (ganovem-loshn)]
margari'n [m] [def: margarine (food)]
margaritke/S/D margeritke/S/D [f] [def: daisy]
margine/S [f] [def: margin] 
	margina'l/A [def: marginal, unlikely] % Forwards: Yoel Matveyev
marikh/H [verb] [def: lengthen (with "zayn")]
marikhuane [f] [def: marijuana] % Forwards: Boris Sandler
marinarke/S [f] [def: jacket (clothing)]
marini'r/V/Bmarini'rt [def: marinate]
mark/N [def: mark (German currency)]
markirer/S [m] [def: marker, pen (English marker)]
	gema'rk/N [n] [def: limit, boundary; region]
mark/Xmerk [m] [def: market] /Iish
	fleyshmark/Xfleyshmerk [m] [def: meat market]
	holtsmark/Xholtsmerk [m] [def: lumber yard] % Avrom Karpinovitsh
	hoyptmark/Xhoyptmerk [m] [def: major supplier] % Forwards: S-R Schaechter
	supermark/Xsupermerk [m] [def: supermarket] % Harduf
	yormark/Xyormerk [m] [def: annual fair]
	[idiom: arop fun mark = discussion over; that's all for you!]
	[idiom: arop fun mark = for sale at any price]
	[idiom: arop fun mark = out of the picture]
marke/S [f] [def: stamp] postmarke/S [f] 
markh [m] [def: marrow; brain (only in Lithuania)]
	markheve/V/T /Goys [def: work hard (with "zikh")] % Fradl Shtok
marksi'zm/N [m] [def: Marxism]
	marksistish/A [def: Marxist]
marlye merlye mulye [f] [def: marl (fabric)]
marmelad/N [m] [def: marmelade]
marmer [m] /In mirml [m] /In marmor [n] /In [def: marble]
marodi'r/V/Bmarodi'rt [def: maraud, raid, foray]
marokhe{merxh}/H [def: fate]
marotshe/V/T [def: confuse (with "a kop")] % Mendele
maro'zhene [f] [def: ice cream (Russian мороженное)]
mars [m] [def: Mars (planet, Roman god)]
marshi'r/V/Bmarshi'rt [def: march] /Garayn/Garoys/Gdurkh/Gforoys/Gavek/Garop
	marsh [m] [def: march]
		aroysmarsh [m] [def: march out]
		foroysmarsh [m] [def: advance] 
		marshru't/N [m] [def: march route, itinerary] 
	toytnmarsh [m] [def: death march]
	marsha'l/N [m] [def: marshal]
		fe'ldmarsha'l/N [m] [def: field-marshal]
		ma'rshelik/Xma'rshelkes [m] [def: jester] 
martirer/S [m] [def: martyr]
	martirologye/S [f] [def: martyrology]
marts [m] [def: month of March] /Iov
	merts [m] [def: month of March] [usage: inadmissible]
martsipa'n [m] martsepa'n/N/Ees [m] [def: marzipan (almond confection)]
marudnik/Ees [m] marudnitse/S [f] [def: plodder, laggard]
marvikher/S [m] [def: thief; fence (of stolen items)]
masazhi'r/V/Bmasazhi'rt masi'r/V/Bmasi'rt [def: massage]
	masazhist/N [m] masazhistin/S masazhistke/S [f] [def: masseur]
	masa'zh/N [m] [def: massage]
mase/Xmasn [f] [def: mass of people; mass (physics)]
	masnvayz [adv] [def: in great quantity]
	masiv/A [def: massive, substantial; solid; hard]
	folksmase/Xfolksmasn [f] [def: hoi polloi] 
mase_{mQ#}/Xmasoes{mQowT}/H [f] [def: burden]
	mase_umotn{mQ#-|wmWn} [m] [def: business dealing]
	masematn [m?] [def: purse full of money (ganovem-loshn)]
	noyse_mite{nwQ#-myth}/Xnoysey_mite{nwQ#y-myth}/H [def: pallbearer] % Der Nister
	noyse_hamite{nwQ#-hmth}/Xnoysey_hamite{nwQ#y-hmth} [def: pallbearer] % Opatoshu: Polishe Velder 
mashin/N [f] /Dmashind mashine/S [f] [def: machine] /D
	mashinke/S [f] [def: machine; meat grinder] /D % Sheva Zucker: meat grinder
	mashinerye/S [f] [def: machinery]
	mashini'st/N [m] mashinistke/S [f] [def: machinist, engineer] 
	dre'shmashin/N [f] [def: threshing machine]
	fa'ksmashin/N [f] [def: fax machine]
	hey'bmashin/N [f] [def: crane (machine)] 
	khiber{Hybwr}-mashin/N [f] [def: adding machine] % Weinreich
	ney'mashin/N [f] [def: sewing machine]
	rekordir-mashin/N [f] rekordir-mashinke/S [f] [def: recorder] 
	re'khn-mashin/N [f] rekhn-mashindl/Eekh [n] [def: calculator] 
	rotatsyon-mashin/N [f] [def: rotary press (newspaper)] % Z. Shneyer
	shpa'nmashin/N [f] [def: treadmill] 
	shpay'zmashin/N [f] [def: food processor] % Forwards: S-R Schaechter
	shray'bmashin/N [f] shraybmashinke/S [f] [def: typewriter]
	shti'mmashin/N [f] [def: voting mashine] % Yiddish League
	toy'tmashin/N [f] [def: deadly device] % Forwards: Yoel Matveyev
	va'shmashin/N [f] [def: washing mashine] 
		fornt-va'shmashin/N [f] [def: front-loader] [note: V] 
		oybn-va'shmashin/N [f] [def: top-loader] [note: V] 
	mashina'l/A [def: mechanical]
	makhinatsye/S [f] [def: machination]
mashkante{mSKnW#} [f] [def: beating while being held down (with "makhn")]
mashke{mSk|h}/Xmashkoes{mSkowT}/H [def: strong drink]
mashkhes{mSHyT}/Xmashkhisem{mSHyTym} [def: destroyer]
	malekh_hamashkhis{ml#x-hmSHyT} [m] [def: angel of destruction]
mashkn{mSKwn}/Xmashkones{mSKnwT}/H [def: pledge (object); pawned item; hostage]
	farmashken{farmSKwn}/V/Bfarmashkent{farmSKwnt}/H [def: pawn; mortgage; be in debt (with "zikh")]
mashtshe/V/T [def: drag] % Esther Kraytman: Briliantn
masline/S [f] [def: olive] 
maslinke [f] mashlinke [f] [def: buttermilk (food)] % Michael Wex; Rachel Korn
masig{mQyg}/H [verb] [def: reach (with "zayn")]
	hasoge{hQgh}/Xhasoges{hQgwT}/H [f] [def: grasp; expectation]
	masig_gvul{mQyg-gBwl} [def: trespass (with "zayn")]
maske/S [f] [def: mask]
	gazmaske/S [f] [def: gas mask]
	maski'r/V/Bmaski'rt [def: mask]
	farmaski'r/V/Bfarmaski'rt [def: mask]
	demaski'r/V/Bdemaski'rt [def: unmask]
maskem{msKym}/H [verb] [def: agree (with "zayn")]
	haskome{hsKmh}/Xhaskomes{hsKmwT}/H [m] [def: approval]
	heskem{hsKm}/H/S [m] [def: agreement, entente]
	beheskem{bhsKm}/H [prep] [def: in agreement (with "mit")]
	[idiom: beheskem{bhsKm} kulem{Kwlm} = by common agreement]
maskone{mskn#}/Xmaskones{mskn#wT}/H [f] [def: inference, conclusion] 
mason/N [m] [def: Freemason] /Iish
masshta'b/N [m] [def: map scale; order of magnitude]
mat/A [def: opaque; tarnished] 
	ma'teve/A [def: matte]
mata'ts [m] [def: swinder] % Forwards: M-S Hoffman
matbeye{mtbe}/Xmatbeyes{mtbewT}/H [f] [def: coin; currency, cash (money)]
mate{mth}/H [m?] [def: below]
	[idiom: shel-mate{Sl-mth} = earthly]
matematik [f] [def: mathematics (subject)] matematish/A [def: mathematical]
	matematiker/S [m] [def: mathematician]
mater/V/T [def: weary] /Gop
	/Goys [def: exhaust]
	materdik/A [def: grueling, wearying] 
	maternish/N [n] [def: wearying]
	farmater/V/Bfarmatert [def: weary]
	umfarmaterlekh/A [def: untiring]
materye/S [f] [def: matter]
	materya'l/N [m] matrya'l/N [m] [def: material]
		materyali'st [def: materialist] /Iish 
		materyali'sm/N [m] [def: materialism]
	materye'l/A [def: material, physical]
matike/S [f] [def: mattock (instrument)] % Rokhl Korn: Erd
matkhe/V/T [def: see (klezmer jargon)] % Stutchkoff
matmen{mtmwn}/S/Xmatmoynem{mtmwnym}/H [m] [def: treasure, hoard (with "mit")]
matone{mWnh}/Xmatones{mWnwT}/H [f] [def: gift] /Lbe{b} [adv] [def: as a gift]
	eyfele_matoneray'{ewfele-mWnhray} [n] [def: baby shower] [note: V] 
	[idiom: matone{mWnh} far di gest = party favor]
matore{mtrh}/Xmatores{mtrwT}/H [f] [def: goal]
matrats/N [m] [def: mattress]
matriyekh{mtryH}/H [verb] [def: exert effort (with "zayn")]
	[idiom: zay zikh nit matriyekh{mtryH} = never mind; don't go out of your way]
matronise{mtrwnyTo}/H [f] [def: noblewoman]
matro's/N [m] [def: sailor] 
	matro'z/N [m] [def: sailor] [def: usage: inadmissible]
matrya'rkh/N [f?] [def: matriarch]
	 matryarkhye/S [f] matryarkha't [f?] [def: matriarchy]
matse_{mch}/Xmatses{mcwT}/H [f] [def: matso bread (food); stone cut flat at widest spot (jewelers' argot)]
matse/V/T [def: grope]
matsel{mcyl}/H [verb] [def: rescue (with "zayn")] 
	nitsel{nycwl}/H [def: rescued (with "- vern")]
matsev{mcB}/Xmatsovem{mcBym}/H [m] [def: situation]
matseyve{mcBh}/Xmatseyves{mcBwT}/H [f] [def: gravestone]
matsh/N [def: match (English)] 
matsil{mcyl}/H [verb] [def: save (with "zayn")] /Lu{|w} [adv] [def: and save]
	hatsole{hclh}/H [f] [def: rescue squad]
	[idiom: zol got shoymer umatsil{|umcyl} zayn = may God protect]
matsliyekh{mclyH}/H [def: successful]
	hatslokhe{hclHh}/Xhatslokhes{hclHwT}/H [def: success] /Idik
	[idiom: loy{l#} yutslekh{ywclH} = ne'er do well]	
mature/S [f] [def: graduation, diploma] 
mavzoley'/N [n] [def: mausoleum] 
	farmavzoleyevt/A [def: placed in a mausoleum] % Forwards: Genadi Estraykh
may [m?] [def: lilac (bush, flower)]
may [m] [def: month of May]
mayd/V/T /Goys /Bgemitn /Goys [def: avoid]
	farmayd/V/Bfarmitn [def: avoid] 
	farmaydlekh/A [def: avoidable] umfarmaydlekh/A [def: unavoidable]
maydem{madym}/S [m] [def: expert; connoisseur]
mayestet{ma|yestet} [m/f] [def: majesty] /Iish
maykhl{m#xl}/Xmaykholem{m#xlym}/H [m/n] [def: light meal; delicacy (food)]
	akhl{axl}/H/V/T [def: eat (humorous)]
	akhile{axylh}/H [def: food]
mayl/N [f] [def: mile]
mayle_geyre{melh-gyrh} [verb] [def: chew the cud (with "zayn")]
	malegere{melh-grh}/V/Bmalegeret{melh-grht} [def: chew the cud; eat noisily; speak unclearly] 
maymen{m#myn}/Xmayminem{m#mynym}/H [m] [def: believer]
maymer{m#mr}/Xmaymorem{m#mrym}/H [m] [def: saying]
	maymorey{m#mry}/H [def: sayings of]
	omar{omr}/H [def: he said]
	venemerl{|wn#mrl}/Xvenemerlekh{|wn#mrlekh} [n] [def: type of religious melody] % Stutchkoff
	loymer{l#mr}/V/T [def: speak]
		/Goys [def: tell all]
	kloymersht_{KlwmrSt}/A /Iik mikloymersht{mKlwmrSt}
		kloymersht [def: as it were] /Iik
		klompersht miklompersht mikloymersht [adv] 
	meymre{mymr#}/Xmeymres{mymrwT} [f] [def: talmudic discourse]
mayonez{ma|yonez} [m] [def: mayonnaise (food)]
mayontik{ma|yontik}/Xmayontkes{ma|yontkes} [def: estate; fortune]
mayra'n [f?] [def: marjoram (herb: Origanum majorana)]
mayrev{merB}/H [m] [def: west] /Idik
	mayrev_{meryB}/H [m] [def: evening prayer] /Idik
	erev{erB}/H [def: evening, day before]
mayse{meQh}/Xmayses{meQywT}/H [f] [def: story; genitalia (vulgar)]
	lemayse{lmeQh} [adv] [def: as it happens; actually]
	maysele{meQhle}/Xmayselekh{meQhlekh} [def: story, tale]
	-/Xmaysem{meQym}/H [def: deeds]
	siper_hamayse{sypwr-hmeQh} [m] [def: plot (story)] 
	avantu'r-mayse{avantu'r-meQh} [m] [def: adventure story]
	ma-yaysenik{mh-yeQhnik}/Ees [m] [def: vagabond, good-for-nothing]
	bobe_mayse{bb#-meQh}/Xbobe_mayses{bb#-meQywT} [f] [def: old-wive's tale (from Bovo Mayse)]
	[idiom: di emese{#mTe} mayse{meQh} = yene mayse{meQh} = cancer]
	[idiom: yene mayse{meQh} = female genitalia (taboo); sex]
	[idiom: gekhapt in der mayse = caught red-handed]
	[idiom: bobe mayse = fairy tale]
	[idiom: zikh onton a mayse{meQh} = commit suicide]
	[idiom: a mayse on an ek = a rabbit hole]
mayser{meQr}/Xmaysres{meQrwT}/H [m] [def: tithe]
mayster/S [m] [def: master; expert] /Iish maysterin/S [f] [def: expert (female)]
	birger-mayster/S [m] birger-may'sterke/S [f] [def: mayor] 
	feder-mayster/S [m] [def: accomplished author] 
	groysmayster/S [m] [def: grandmaster (chess)] % Forwards: Boris Sandler
	kape'lmayster/S [m] [def: music director] % Forwards: I. Gottesman
	poli'tsmayster/S [m] [def: police chief] % Sholem Aleykhem
	ro'khmayster/S [m] ra'khmister/S [m] [def: bookkeeper]
	vebmayster/S [m] [def: web master] postmayster/S [m] [def: postmaster]
	maystreve/V/T mayste'reve/V/T [def: putter around; jury-rig]
		farmay'streve/V/Bfarmay'strevet [def: control, overcome] % Forwards: Sholem Berger
	maynster/S [m] [def: master] % variant
		imazh-maynster/S [def: spin doctor] [note: V] 
	mayster/V/T [def: create a masterwork] /Goys
	masterskaye/S [f] [def: workshop]
	may'stershaft/N [f] [def: mastery, expertise]
/Xmaytkes [f] [def: bloomers, underpants (women's clothing)] /D
maytneryum [m] [def: meitnerium (Mt)] 
mazek{mzyk}/Xmazikem{mzykym}/H/D [m] [def: damager, damaging; scamp, mischievous brat; destructive elf; accomplished person]
	nizek{nyzwk}/V/T [def: damage]
		nezek{nzk}/H [m?] [def: damage]
	mazek{mzyk}/H/V/T [def: damage]
		tsemazik{tsemzyk}/V/Btsemazikt{tsemzykt} [def: damage, injure]
	hezek{hyzk}/Xhezeykes{hyzkwT}/H [m] [def: damage]
mazl{mzl}/Xmazoles{mzlwT}/H [n] [def: good luck; sign of the Zodiac] /Idik
	shlimazl{shlimzl}/S/N [m] [def: unlucky person, clumsy person]
		/Idik [def: with bad luck]
	shlimazalnik{shlimzlnik}/Ees [m] shlimaza'lnitse{shlimzlnitse}/S [f] [def: slovenly person; unlucky person]
	lemazl{lmzl} [adv] [def: luckily, with good fortune]
	[idiom: mit mazl{mzl} zolt ir lebn = (reply to mazl-tov)]
	[idiom: zolst onkumen tsu mayn mazl{mzl} = you should have my luck (curse)]
	[idiom: treyfener mazl{mzl} = unusually good luck]
mazokhistish/A [def: masochistic] % Forwards: Yoel Matveyev
	sado-mazokhistish/A [def: sado-masochistic] % Forwards: Yoel Matveyev
mazolye/S [def: callus, corn (on foot)]
	mazolish/A [def: callused]
mazurke/S [def: mazurke dance]
me [interj] [def: well then: expression of dismissal] 
	[idiom: be-me = blah blah]
meakev{meKB} [verb] [def: inhibit, prevent (with "zayn")]
meanes{mans} [verb] [def: force (with "zayn"); rape (with "zayn")]
mebl/X [n] [def: furniture]
	mebli'r/V/Bmebli'rt [def: furnish]
	[idiom: bay im iz dos mebl ibergeshtelt = he is crazy]
med [m] [def: mead]
meda'l/N [m] menda'l/N [m] [def: medal (honorary)]
	medali'st/N [m] [def: medalist]
	medalyo'n/N [m] [def: medallion]
		medalyo'ntshik/Ees [m] [def:  medallion (humorous)] % Forwards: M-S Hoffman
medine{mdynh}/Xmedines{mdynwT}/H/D [f] [def: country]
	medinas{mdynT} [def: country of] 
mediti'r/V/Bmeditirt [def: meditate]
	meditatsye/S [f] [def: meditation]
	meditati'v/A [def: reflective, meditative, pensive]
meditsi'n/N [f] [def: medicine] /Iish [def: medicinal]
	biomeditsi'n [f] [def: biological medicine]
	[idiom: i'nveynikste meditsi'n = internal medicine] [note: V]
	me'diker/X [m] [def: medical researcher] 
	medikame'nt/N [m] [def: medicine]
	mediki'r/V/Bmediki'rt [def: medicate] [note: V]
me'dlive/V/T [def: delay, hold back]
me'dnitse/S [f] [def: large copper pan or pot] 
meduze/S [f] [def: jellyfish; Medusa (Greek myth)] % Stutchkoff
medyum/S [m] [def: medium]
	medya [f] [def: media (communication)] % Forwards
mefunek{mfwnk}/Xmefunokem{mfwnkym} [m] [def: fastidious person, epicure, picky person] 
	mefunekdik{mfwnkdik}/A [def: fastidious, picky]
meg/V/T [def: may]
	meglekh/A miglekh/A [def: possible] % both variants
		ummeglekh/A ummiglekh/A [def: impossible]
		meglekhkayt/N [f] miglekhkayt/N [f] [def: possibility]
		umeglekhkayt/N [f] umiglekhkayt/N [f] [def: impossibility]
	dermeglekh/V/Bdermeglekht [def: make possible]
megele/Ekh [def: filled neck (food)] % Karpinovitsh
megefo'n/N [m] [def: megaphone] % Forwards
megege/S [m] [def: dawdler, ditherer]
	shmegde/S [m] [def: fool, simpleton]
	shmegege/S [m] [def: dawdler, ditherer; bungler] % Michael Wex
megile{mgylh}/Xmegiles{mgylwT}/H [f] [def: scroll, long story] 
	megilas{mgylT}/H [def: scroll of]
mehalekh{mhlx}/H/N [def: travel; journey] /Idik
mehane{mhnh}/H [verb] [def: please, provide (with "zayn")]
mehires{mhyrwT}/H [f] [def: speed]
mehume{mhwmh}/Xmehumes{mhwmwT}/H [f] [def: panic, turmoil]
	[idiom: a beyze mehume{mhwmh} oyf dir = a wild panic on you (curse)]
mehus{mhwT}/H [n] [def: substance]
mek/V/T/Gop [def: erase] /Goys % Borokhov derives from {mHh}
	farmek/V/Bfarmekt [def: erase]
mekabeyer{mKbeyer}/X [m] [def: Maccabee]
meke/V/T [def: bleat (sound of a calf)] 
mekene/S [f] [def: chaff]
mekhabl{mHbl}/Xmekhblem{mHblym}/H [m] [def: destroyer; demon of destruction; terrorist] % Forwards: terrorist
mekhalel{mHll}/H [verb] [def: desecrate (with "zayn")] 
mekhanik [f] [def: mechanics (subject)] mekhanish/A [def: mechanical]
	mekhaniker/S [m] [def: mechanic] 
	mekhani'zm/N [m] [def: mechanism] 
mekhitse{mHyc|h}/Xmekhitses{mHycwT}/H [f] [def: separation between men and women at prayer] 
mekhteyse{mhyx#-WyTy}/H meykheteyse{mhyx#-WyTy}/H [interj] [def: of course; all right; O.K.]
	mekhtey'sedik{mhyx#-WyTydik}/A [def: however it is]
	mekhtey'senik{mhyx#-WyTynik}/Ees mekhtey'senitse{mhyx#WyTynitse}/S [f] [def: person who agrees with everyone]
mekhule{mxwlh} [adj] [def: ill; spoiled; bankrupt] [grammar: predicative]
mekintash [def: Macintosh (computer)]
mekler/S [m] me'klerin/S me'klerke/S [f] [def: broker, agent, intermediary]
	oysmekler/S [m] oysme'klerin/S [f] [def: broker, agent]
		[idiom: pirge mekler = pimp (taboo)]
	mekleray'/N [n] [def: brokerage, agency]
	mekl/V/T /Goys mekler/V/T [def: act as agent]
melankholye/S [f] [def: melancholy; depression] melankholish/A
	mankolye/S [f] [def: craziness; desire; obsession]
		mankolinik/Ees mankolinitse/S [def: crazy person]
		mankolyedik/A [def: obsessed person]
meld/V/Bgemoldn [def: announce] /Gon
	meldung/N [f] [def: announcement]
melodye/S [f] [def: melody] melodish/A [def: melodic]
melokhe{mloxh}/Xmelokhes{mloxwT}/H [f] [def: handcraft]
	balmelokhe{bel-mloxh}/H/S [m] [def: craftsman] /Ish
	gemelokhet{gemloxht}/A [def: artificial, fake] % Sholem Aleykhem
melon/N [m] [def: melon]
melts/V/T [def: brew]
	meltsera'y/N [f] [def: brewery]
	meltser/X/S [m] [def: brewer]
melupn{mlwpn}/S [m] [def: diacritic dot placed on some vov letters]
mem{mm}/H [m/f] [def: Hebrew letter Mem] 
memorandum/S [m] [def: memorandum] 
	memorya'l [m?] [def: memorial (object or place)]
memuar/N [def: memoirs]
memune{mmwnh}/Xmemunem{mmwnym}/H [m] [def: appointed responsible party]
men me [def: one (indefinite subject)] 
menashke/S [f] [def: mess tin] 
menatsl{mncl}/H [verb] [def: rescue (with "zikh") (with "zayn")] 
	misnatsl{mTntsl} [verb] [def: interrupt oneself?? (with "zikh") (with "zayn")]
	hisnatsles{hTnclwT}/N [n] [def: apology; vindication; justification]
menazherye/S [f] [def: menagerie]
mendelevyum [m] [def: mendelevium (Md)] 
menge/S [f] [def: crowd, multitude] 
meniye{mnyeh}/Xmeniyes{mnyewT}/H [def: interference, obstacle, hurdle]
menore{mnwrh}/Xmenores{mnwrwT}/H [f] [def: candelabrum] 
menstruatsye/S [f] [def: menstruation]
mentalite't/N [f] [def: mentality; intelligence]
mente [m] [def: policement (ganovem-loshn)]
mentsh/N/D/J [m] [def: person, human, responsible or mature person]
	mentshlekh/K [def: humane]
		almentshlekh/A [def: universal (human)] % Forwards: Yoel Matveyev
		ibermentshlekh/A [def: superhuman] % Forwards: Krutikov
		mentshlekhkayt/N [def: humanity] 
		ummentshlekh/A [def: inhuman]
			ummentshlekhkayt/N [f] [def: inhumanity]
	mentshl/V/T /Goys [def: become mature; acquire full status]
	mentshish/A [def: human]
	mentshkayt/N [f] mentshhayt [f] [def: humanity]
	folksmentsh/N [m] [def: ordinary person]
	ga'snmentsh/N [m] [def: man on the street] 
	gaystmentsh/N [m] [def: spiritual person] % Forwards: M-S Hoffman
	kopmentsh/N/Xkepmentshn [m] [def: intellectual]
	luftmentsh/N [m] [def: person with impractical ideas]
	milmentsh/N [m] [def: mill worker] % Bergelson: Yosef Shur
	ummentsh/N [m] [def: evil person]
	untermentsh/N [m] [def: subhuman person] % Forwards: Yoel Matveyev
	valdmentsh/N [m] [def: forest dweller]
menukhe{mnwHh}/H [def: rest, quiet, calm]
menyu/N [m] [def: menu] 
mer [m] [def: problem] 
	[idiom: vos iz der mer = what is the matter?]
mer/V/T [def: increase] 
	farmer/V/Bfarmert [def: increase] 
	mer/A [def: more] % CY C.14.c
		amer [adv] [def: rather]
	merste merstn merstns ammerstn [def: mostly] meyn/A meynst/A meynstns meyst meystns
	merhayt/N [f] [def: majority]
	mernit [conj] [def: besides; but only]
	mernit [adv] [def: just, only]
	merung/N [f] [def: multiplication (mathematics); increase]
	nokhmer [conj] [def: besides]
-/Xmeridn [def: hemorrhoids] % plural only
merin/Ees [m] [def: gelding (horse) (animal)]
merk/V/T [def: notice] /Gon/Gop
	bamerk/V/Bbamerkt [def: notice]
		bamerkung/N [f] [def: notice]
		bamerkevdik/K bamerkbar/A [def: noteworthy]
	merkzam/A [def: noteworthy]
	oyfmerk/N [m] [def: notice; care] 
		oyfmerkzam/A [def: aware; careful; inform (with "makhn")]
			oyfmerkzamkayt/N [f] [def: attention, awareness]
	onmerkung/N [def: note, comment]
	umopmerklekh/A [def: unnoticable, invisible] % Forwards: Mishe Lev
	umbamerkt/A [def: unnoticed]
		umbamerkterheyt [adv] [def: unnoticed]
merkhek{mrHk}/Xmerkhokem{mrHkym}/H [def: distance; distant lands (in plural)] 
merkhets{mrHc}/Xmerkhotsem{mrHcym}/H [m/n] [def: bath house] 
merkove{mrKbh}/Xmerkoves{mrKbwT}/H [f] [def: (divine) chariot]
mer/N [f] [def: carrot] /D
meroyekh_o'shekh{mrwH-oSx}/H [m] [def: impotent man; man with damaged testicles]
mesedzh [m] [def: message] [usage: doubtful admissibility] % Stutchkoff
mesekhte{msxW#}/H mesekhtes{msxWwT}/H [def: Talmudic tractate] 
meser/S [n/m] [def: knife] /D
	golmeser/S [m] /D [def: razor] % Harduf
	go'rtnmeser/S [m] [def: pruner, pruning shears] % Stutchkoff
	hakmeser/S [m] [def: chopping knife, chopper] 
	shnay'dmeser/S [m] [def: pruning hook] % Sholem Aleykhem
	shekhtmeser/S [m] [def: slaughterer's knife]
	shtekhmeser/S [m/n] [def: dagger]
	tsva'ygmeser/S [m] [def: pruner, pruning shears] % Stutchkoff
	[idiom: oyfn shpits meser = off the cuff, without deep thought]
mesh [n] [def: brass] /In [def: brass]
meshayer{mSer} [verb] [def: estimate, guess (with "zikh") (with "zayn")] 
meshekh{mSx}/H [def: period of time] /Idik [def: long (in duration)]
	bemeshekh{bmSx} [def: during (with "fun")]
	mamshekh{mmSyx}/H [verb] [def: continue (with "zayn")]
	hemshekh{hmSx}/Xhemsheykhem{hmSxym}/H [m] [def: continuation; sequel; installment]
meshores{mSrT}/H [def: assistant] /D meshorsem{mSrTym}/H
meshoyrer{mSwrr}/Xmeshoyrerem{mSwrrym}/H [m] [def: singer] 
meshte/S [f] [def: slippers (clothing)]
meshu'm{mSwm}/H [def: because of]
meshuge{mSwge}/H [adj] [def: crazy] [grammar: only predicative]
	meshugen{mSwgen}/A [adj] [def: crazy] [grammar: only attributive]
	meshugedik{mSwgedik}/A [def: crazy]
	meshugevate{mSwgevate}/A [def: crazy, addled] % Bergelson
	meshugenervayz{mSwgenervayz} [adv] meshugenerheyt{mSwgenerheyt} [adv] [def: crazily]
	meshegas{mSwgeT}/H/N [n] [def: insanity, craziness, madness; whim; idiosyncracy; craze]
		[idiom: hintishe meshegas{mSwgeT} = rabies] % Forwards: M-S Hoffman
	meshugoyem{mSwge|ym}/H  [def: crazy people]
	shigoen{Sgewn}/N/Xshigoynes{SgewnwT}/H [m] [def: craziness; whim] 
	shoygeyg{Swgg}/H [def: unintentional] /Lbe{b} [adv] [def: unintentionally]
meshune{mSwnh}/H [def: strange] /Idik
	mise{myTh}-meshune{mSwnh} [f] [def: violent death]
mesibe{msybh}/Xmesibes{msybwT}/H [f] [def: society; group of friends]
mesikes{mTykwT}/H [def: sweetness]
mest/V/Bgemostn [def: measure; survey (land); traverse] /Gop/Goys/Gon
	farmest/V/Bfarmostn [def: contest (with zikh)] 
		farmest/N [m] [def: contest, race (game)] 
			farmestler/S [m] [def: contestant] [note: V]
	dermest/V/Bdermostn [def: keep good accounts] % Bashevis
	mos [f] [def: measure (abstract)]
		fulmosik/A [def: in full measure]
		glaykhmosik/A [def: in equal measure]
	mest/N [m?] /D [def: measure (implement)]
		zaltsmestl/Eekh [n] [def: salt cellar]
	glaykhgemostn/A [def: of identical length] % Forwards: Boris Sandler
	gemostnkayt/N [f] [def: restraint, moderation] % Der Nister: Mashber
		opgemostnkayt/N [f] [def: moderation] % Sholem Aleykhem
	mesik/A [def: measured]
		gemesikt/A [def: moderate] % Harduf 
		reglmesik/A [def: regular]
			umreglmesigkayt/N [f] [def: irregularity]
		mitlmesik/A [def: middle-sized, moderate, of average quality, mainstream]
		zhargonmesik/A [def: colloquial] % L. Shapiro
	mester/S [m] [def: meter]
		erdmester/S [m] landmester/S [m] feldmester/S [m] [def: surveyor] 
mesyanish/A [def: Messianic] 
mesye [m] [def: Mr. (French)]
	madam [f] [def: Mrs. (French)]
	madmauzel [f] demuazel [f] [def: Miss (French)]
metaboli'zm/N [m] [def: metabolism] 
metafizik/A [def: metaphysics]
metafor/N [m] [def: metaphor] /Iish [def: metaphoric]
	metaforik/N [f] [def: metaphorics]
meta'l/N [m] [def: metal] /In
	tsinkmetal [m] [def: zinc metal]
metaltl{mtltl}/H metaltelem{mtltlym}/H [def: movable possessions] 
metapl{mtpl}/H [verb] [def: occupy (with "zikh"), mind a child (with "zayn")] 
meteor/N [m] [def: meteor] 
meter [m] [def: meter] 
	galvanometer [m] voltmeter [m] [def: voltmeter]
meteorologish/A [def: meteorological]
meto'd/N [m] /Iish metode/S [f] [def: method] 
	metodik [f] [def: methods; methodology, study of methods] % Forwards: S-R Schaechter
metodi'st/N [m] [def: Methodist (religion)]
metrike/S mentrike/S [f] [def: certificate; birth certificate]
metro/S [def: subway]
metropolye/S [def: big city]
metsaref{mcrf}/H [verb] [def: include, add in (with "zayn"); participate in (with "zikh zayn")]
metsena't/N [m] [def: magnate, financier]
metshe't/N [m] [def: mosque]
metsiye{mcy#h}/Xmetsiyes{mcy#wT}/H [f] [def: bargain]
	metsiyas{mcy#T}/H [f] [def: existence] 
	yeka'r_hamtsiyes{ykr-hmcy#wT}/N [n] [def: unusual object; rare book]
	metsotse/S [f] [def: bargain, godsend (ironic)]
	[idiom: ko'shere{KSre} metsiye{mcy#h} = true bargain]
metupl{mtwpl}/H/A [def: burdened (usually with children)]
metushtesh{mtwStS}/H/A [def: unclear, beclouded, shadowy; confused]
meve/S [f] meyv/N [m?] [def: seagull (bird)]
mevater{mvWr}/H [verb] [def: forgo, set aside a right (with "zayn")] 
mevusem{mBwsm} [adj] [def: tipsy, drunk] /Idik
meye{m#h}/H [f] [def: money] 
me'ykenish/N [n] [def: vomiting]
meykl{mykl}/H [verb] [def: be ritually lenient (with "zayn")]
meyle{myl#}/H [def: so be it; anyhow; never mind]
	bemeyle{bmyl#} [def: in the course of things]
	mimeyle{mmyl#} [def: in any case] 
meylekh{mlx}/Xmelokhem{mlxym}/H [m] [def: king] /Lha{h} [noun] [m] [def: the king] 
	malkhey{mlxy}/H [def: kings of]
	malkhes{mlxwT}/H [f] [def: kingdom] /Idik
	melukhe{mlwxh}/Xmelukhes{mlwxwT}/H [f] [def: government]
		melukhish{mlwxish}/A [def: government]
		melukheshaft{mlwxhshaft}/N [def: statehood, dominion, self-rule]
	benmeylekh{bn-mlx}/Xbney_malokhem{bny-mlxym} [m] [def: prince] 
	malke{mlKh}/H [f] [def: queen] /Lha{h} [noun] [f] [def: the queen]
		basmalke{bT-mlKh}/Xbasmalkes{bT-mlKwT} [def: princess] 
		melave_malke{mlvh-mlKh}/H/S [f] [def: formal meal Saturday night] 
meylets{mlyc}/Xmeylitsem{mlycym}/H [m] [def: attorney]
	melitse{mlych}/Xmelitses{mlycwT}/H [f] /Idik [def: fancy linguistic style]
meyn/V/T [def: intend]
	meyn/N [m] [def: intention] 
	meynung/N [f] [def: opinion] 
	[idiom: nit zey meynt men = it doesn't apply to them]
meyor{me|yor}/S [m] [def: mayor (American)]
meyre/S [f] [def: piece of matso dough]
meys{mT}/Xmeysem{mTym}/H [m] [def: dead person]
	/Lha{h} [noun] [m] [def: the dead person]
	meymes{mmyT}/H [def: strike, beat up, attack viciously]
	tse|meymes|/V/Btse|meymes|t [def: kill (usually figurative)]
	tkhies_hameysem{WHyT-hmTym} [f] [def: resurrection]
	[idiom: oyfshteyn tkhies_hameysem{WHyT-hmTym} = be resurrected]
	[idiom: mekhaye{mHyh} meysem{mTym} (zayn) = bring the dead to life]
meyvn{mByn}/Xmevinem{mBynym}/H [m] [def: expert]
	mevinish{mBynish}/A [def: expert]
	mevines{mBynwT}/H/N [f] [def: expert opinion] 
	havone{hBnh}/Xhavones{hBnwT} [f] [def: ability to understand; comprehension]
	[idiom: zayn oyf zikh der bester/shtarkster meyven = be one's own worst critic]
mezeg{mzg}/N [def: disposition, attitude]
	me'zektov{mzg-twB} [m] [def: good-natured person]
mezoyn{mzwn}/H [m] [def: food]
	mezoynes{mzwnwT} [def: baked goods other than bread]
mezumen{mzwmn}/Xmezumonem{mzwmnym}/H [def: currency, cash (money)] /A
	mezumenke{mzwmn|ke}/H/S [f] [def: automated teller machine (ATM)] 
mezuze{mzwz|h}/H/Xmezuzes{mzwzwT}/S [f] [def: mezuzah (ritual symbol on doorposts)] /D
mi/V/T [def: exert]
	bami/V/Bbamit [def: strive, exert oneself (with "zikh")]
		bamiung/N [f] [def: effort] 
	mi [m] [def: effort] 
mid/K [def: weary] /Ilekh
	midkayt/N [f] [def: weariness] miderheyt [def: wearily]
		flimidkayt/N [f] [def: jet lag] [note: V]
	umdermidlekh/A [def: untiring]
	ayngemidt/A [def: tired out, exhausted] % Der Nister
	oysgemidt/A [def: exhausted] % Sholem Aleykhem
	mid/V/T [def: become tired (with "zikh")] /Gayn
midber{mydbr}/Xmidbaryes{mydbrywT}/H/Idik [f] [def: desert]
	bemidber{bmydbr} [adv] [def: in the desert]
mide_{mydh}/H mides{mydwT}/H [def: quality, attribute] 
	bal_mide{bel-mydh} bal_mides{bel-mydwT}/Xbale_mides{bely-mydwT} [m] [def: courteous person; person of high moral character]
	mides_hadin{mydT-hdyn} [m] [def: feeling for justice]
mies{my#ws}/H/K [def: ugly, obscene, loathsome, dirty]
	miest{my#ws|t}/A [def: ugliest]
	mies{my#ws}/V/T [def: make ugly] 
	farmies{farmy#ws}/V/Bfarmiest{farmy#wst} [def: deprecate] [note: V]
	mieskayt{my#wskayt}/N [f] [def: ugliness; ugly thing]
	nimes{nym#s}/H [def: boring; distasteful, disgusting] 
migl/V/T [def: disgust] migl/N [m] [def: feeling of disgust] /Idik
	[idiom: aroysrufn a migl (bay emetsn) = disgust (someone)]
migratsye/S [f] [def: migration] 
	moykhes{mwHwT}-migratsye/S [f] [def: brain drain] [note: V] 
	migri'r/V/Bmigri'rt [def: migrate]
	migran't/N [m] [def: migrant] migratsye/S [f] [def: migration]
	emigri'r/V/Bemig'rirt [def: emigrate]
		emigra'nt/N [m] [def: emigrant] emigratsye/S [f] [def: emigration]
	imigri'r/V/Bimigri'rt [def: immigrate]
		imigra'nt/N [m] [def: immigrant] /Iish imigrantke/S [f]
		imigratsye/S [f] [def: immigration]
migre'n/N [m] [def: migraine (illness)] % Yiddish League
mikhshel{myxSwl}/Xmikhshoylem{myxSwlym} [m/n] [def: obstacle] 
	makhshel{mxSyl} [verb] [def: be a stumbling block (with "zayn")]
miklet{myklt}/Xmiklotem{mykltym}/H [m] [def: refuge] 
	mokem_miklet{mkwm-myklt} [m] [def: place of refuge] 
mikro [m] [def: microwave oven] 
	mikroi'r/V/Bmikroi'rt [def: cook with microwave] 
	mikrosko'p/N [m] [def: microscope] /Iish
mikrob/N [m] [def: microbe]
mikstur/N [f] [def: compound (medicine)] /D
mikve{mykvh}/Xmikveyes{mykv|wT}/H [m] [def: ritual bath]
milb/N [f] [def: mite (arachnid)]
	tsvangmilb/N [f] [def: tick (insect)]
mild/K [def: mild] milderheyt [adv] [def: mildly; gently] 
milenyum [m] [def: millenium]
milgroym/N [m] [def: pomegranate] 
milimeter/S [m] [def: millimeter] 
milite'r [n] [def: army, troops] /Iish [def: military]
	milita'nt/N [m] [def: militant] /Iish
	militari'zm/N [m] [def: militarism]
		militaristish/A [def: militaristic]
mili'ts/N [f] [def: militia] 
	militsya'nt/N [m] militsyone'r [m] [def: militiaman]
mi'litse/S [f] [def: crutch]
milkh [f] [def: milk] /Iik [def: made of milk]
	/Iedik [def: milk-based (food) (ritual)] 
	milekh [f] [def: milk] [usage: dialectical variant; SY]
	milkhiker/S [m] [def: dairyman]
	melk/V/T/Bgemolkn [def: milk] /Goys/Gon/Garoys
		melkedik/A [def: for milking (animal)] % Sholem Aleykhem
	foyglmilkh [f] [def: dainties (symbol of luxury)]
	mishmilkh/N [f] [def: shake (food)] [note: V] 
	zoy'ermilkh/N [f] [def: buttermilk (food)]
	[idiom: blut un milkh = fair complexion]
milkhome{mlHmh}/Xmilkhomes{mlHmwT}/H [f] [def: war] /Idik [def: warlike]
	far|milkhome|dik/A [def: before the war]
	velt-milkhome{velt-mlHmh}/Xvelt-milkhomes{velt-mlHmwT} [f] [def: world war] 
milts/N D [f] [def: spleen] 
milya'rd/N [m] [def: billion]
	milyarde'r/N [m] [def: billionaire]
milya's/N [m] [def: myriad]
	-/Xmilye-milya'sn [def: myriads of myriads]
milyo'n/N [m] [def: million] /Iik /Dmilyond
	milyone'r/N [m] milyonershe/S [f] [def: millionaire]
	milyontshik/Ees [m] milyontshitse/S [f] [def: millionaire] % Sholem Aleykhem: Shprintse
mimaamakem{mmemkym} [adv] [def: from the (spiritual) depths] /Idik
mimik [f?] mimike/S [f] [def: gesticulation; comic imitation]
min{myn}/Xminem{mynym}/H [m] [def: species; genus (taxonomy); heretic]
	/Lha{h} [noun] [m] [def: the species]
	miney{myny}/H [def: species of] 
	filminik/A [def: multifaceted] [usage: not recommended]
	transminik/A [def: transgender]
	kol_haminem{Kl-hmynym} [def: all sorts of]
	[idiom: yokhed_bminoy{yHd-bmynw} = unique]
	[idiom: klern oyf der heyser minut = think on one's feet]
minare't/N [m?] [def: minaret (mosque tower)]
mindik/A [def: of legal age; self-supporting]
mine/S [f] [def: facial expression] /D
mine/S [f] [def: mine (explosive)] 
	farminirt/A [def: mined] 
mine_{mynh}/Xmines{mynwT}/H [f] [def: appearance] 
mineg{mynhg}/Xminhogem{mynhgym}/H [m] [def: custom]
	manhig{mnhyg}/Xmanhigem{mnhygym}/H [m] [def: leader] 
		manhiges{mhygwT} [f] [def: leadership] 
	hanhoge{hnhgh}/Xhanhoges{hnhgwT}/H [f] [def: custom] 
	noyeg{nwhg}/H [verb] [def: be accustomed (with "zayn")] 
miner/V/T [def: make small] 
	farminer/V/Bfarminert [def: reduce] farminerung/N [def: reduction]
	mindst/A [def: smallest] % not in positive or comparative
		mindstns [adv] [def: in the least]
		[idiom: nit tsum mindstns = not in the least]
	minderhayt/N [f] [def: minority] 
	mindlekh/A [def: small] 
	gemi'nertkayt/N [f] [def: disability] % Yiddish League
minera'l/N [m] [def: mineral] /A
minimizi'r/V/Bminimizi'rt [def: minimize]
	minimum [m] [def: minimum] minimal/Kminimel [def: minimal]
minister/Xministorn [m] ministerke/S ministershe/S mi'nsterin/S [f] [def: minister]
	ministeryum/S [m] [def: ministry]
mink/N [m] [def: mink (animal)] /In
minkhe{mynHh}/Xminkhes{mynHwT}/H [f] [def: afternoon prayer]
	minkhe_{mnHh}/Xminkhes_{mnHwT}/H [f] [def: afternoon prayer] % variant
	korbn-minkhe-sider{krbn-mynHh-sydur} [m] [def: prayer book specifically for women]
minorite't/N [f] [def: minority] 
minor minorn/A [def: minor (music)] 
minter/V/T [def: stimulate; attempt to revive] /Gop
mints/N mint/N myente myate [def: mint (plant)]
	fefermints/N [def: peppermint]
mints [f] [def: small change (money)]
minue't/N [def: minuet (music)]
minus/N [m] [def: minus] 
minut/N [f] [def: minute] /Dminutke
	minutnvayz [def: minute by minute]
	min' [def: minute (abbreviation)]
	[idiom: fun der heyser minut = from the first moment]
minyatur/N [f] [def: miniature] 
minye/V/T [def: change one's emotions (with "zikh"); change color] 
minyen{mnyn}/Xminyonem{mnynym}/H [m] [def: prayer quorum]
merbik/A [def: brittle]
	mirbik/A [def: brittle] [usage: not recommended]
mirt [m?] [def: myrtle (bush) (Myrtus)] % M. Schaechter: geviksn
mirovoy'{mirovo|y} [m] [def: justice of the peace (Russian мировой)]
misboyded{mTbwdd}/H [def: hermit]
mise{myTh}/H [f] [def: death]
	malekh_hamoves{ml#x-hmvT} [m] [def: angel of death]
mish/V/T [def: mix; get involved (with "zikh")] /Goys/Gtsunoyf
	/Goyf [def: find a place in a book]
	/Giber [def: shuffle]
	/Garayn [def: mix in (uninvited) (with "zikh")]
	farmish/V/Bfarmisht [def: confuse]
	tsemish/V/Btsemisht [def: mix up, confuse, trouble]
		tsemishung/N [f] tsemi'shenish/N [n] [def: confusion, muddle; trouble]
		tsemisht/K [def: confused]
	araynmishung/N [f] [def: mixture]
	gemi'sh/N [n] gemishekhts/N [n] mi'shenish/N oysmi'shenish/N [n] [def: mixture]
	tsumish/N [m] [def: admixture]
	mishmash/N [m] [def: mish-mash] 
	oysmish/N [m] [def: mixture]
	mishling/N [n] [def: child of mixed ancestry] 
	mishke-moshke [adj] [def: confused, messy] 
	misher/S [m] [def: mixer]
		aray'nmisher/S [m] [def: unwanted participant]
mishkav{mySKB} [m] [def: sex (activity)]
	mishkav_zokher{mySKB-zxr} [def: (male) homosexual sex]
mishkn{mSKn}/H [m] [def: tabernacle] 
mishkoyles{mSkwlT} [f?] [def: shakiness, instability]
mishne{mySnh}/Xmishnayes{mySnywT}/H [f] [def: Mishnah]
mishpet{mySpt}/H/V/T [def: judge] /Gop
	farmishpet{farmySpt}/V/Bfarmishpet{farmySpt} [def: sentence] 
	mishpotem{mSptym}/H [def: ordinances] 
	shoyfet{Swft}/Xshoyftem{Swftym}/H [m] [def: judge] 
mishpokhe{mSpHh}/Xmishpokhes{mSpHwT}/H [f] [def: family, clan] /D /Idik 
	mishpokhedikayt{mSpHhdikayt}/N [f] [def: family feeling]  % Forwards
	mishpakhte{mSpHte}/S [f] mishpakhtere{mSpHtere}/S [def: family (pejorative)] 
	mishpokhevayz{mSpHhvayz}/A [def: family by family]
mishte{mSWh}/H/D [m] [def: drinking bout, dinner party]
mishteyns [def: as it were] umshteyns
	nishteyns % Harduf
	[idiom: mishteyns gezogt = after all; alas!]
misl/N [m] [def: missile]
misnaged{mTngd}/Xmisnagdem{mTngdym}/H [m] [def: opponent of Chassidism]
	misnagdes{mTngdwT}/H [def: opposition to Chassidism]
	misnagdish{mTngdiS}/H/A [def: in opposition to Chassidism]
mist/N [n] [def: garbage, excrement] 
	mistik/V/T bamistik/V/Bbamistikt [def: fertilize; befoul]
		bamistikung/N [f] bamistekhts [n][def: fertilizer]
	blitsmist/N [n] [def: spam (computer)] [note: V] 
	kunstmist [n] [def: fertilizer]
mister [def: Mister]
misterye/S [f] [def: mystery] misterye'z/A [def: mysterious] 
	mistifikatsye/S [f] [def: puzzle] 
mistish/A [def: mystical] 
	mistiker/S [def: mystic]
	mistitsi'zm/N [m] [def: mysticism]
misye/S [f] [def: mission] 
	misyone'r/N [m] [def: missionary] /Iish
mit/P [def: with] dermit [def: thereby]
mit [f] [def: middle] /Iel
	inmitn [def: in the middle]
	mitndik/A [def: central; intermediate]
	[idiom: in mitn drinen = just then]
	[idiom: in mitske drinen = just then]
mite{myth}/H [f] [def: bed; funeral bier] 
	tashmish_hamite{WSmyS-hmyth} [noun] [def: sexual intercourse]
miting/N [m] [def: meeting (English)]
mitl/Een [n] [def: means, resource, method]
	baruik-mitl/N [n] [def: tranquilizer] % Stutchkoff
	farzikherungs-mitl/N [n] [def: protective measure] % Sholem Aleykhem
	fo'rmitl/N [n] [def: vehicle]
	halbmitl/N [n] [def: half measure] 
	hey'lmitl/N [n] [def: medicine; medical treatment]
	linder-mitl/Een [n] [def: palliative]
	reynik-mitl/Een [n] [def: cleaning fluid] 
	shi'tsmitl/Een [n] [def: prophylactic measure; protective device]
	shlo'fmitl/Een [n] [def: sedative, soporific]
	veytik-mitl/Een [n] [def: painkiller] [note: V] 
	zayers-mitl/Een [n] [def: antacid] [note: V]
	mitl/V/T /Goys [def: find a method or compromise] [usage: non-literary]
	farmitl/V/Bfarmitlt [def: act as agent]
		farmitler/X/S [m] farmitlerin/S [f] [def: proxy; agent; go-between] 
		farmitlung/N [f] [def: intervention; agency]
	bamitlt/A [def: rich; favored]
mitn [m] [def: middle] mitl/K
mitos [m?] [def: mythos; legend] mitish/A [def: mythical] 
	mitologye/S [f] [def: mythology]
	mitologish/A [def: mythological] % Forwards: Yoel Matveyev
mits [f] [def: mitre (clothing)] /D mitske/S [f]
	lapnmitsl/Eekh [n] [def: winter hat with flaps; milksop]
	shlofmits/N [m] shlofmitsl/Eekh [n] nakhtmitsl/Eekh [n] [def: sleeping cap] 
	vegmitsl/Eekh [n] [def: travel cap] % Stutchkoff
mitsve{mycvh}/Xmitsves{mycv|wT}/H [f] [def: commandment]
	/Lbe{b} [adv] [def: by commandment]
	bal_mitsvotnitse{bel-micvhotnitse} [f] [def: person of good deeds] % Chaim Grade
miyet{myewt} [m] [def: minority]  % Forwards
mizbeyekh{mzbH}/H [m] [def: altar] 
mizinik/N/D [m] [def: youngest son]
	mizinke/S [f] [def: youngest daughter] 
mizrekh{myzrH}/H [m] /Idik mizrekh_{mzrH}/H [def: East] /Idik
	mizrakhish{myzrHish}/A [def: eastern, oriental]
mlie/V/T [def: simmer] 
mlosnekayt/N [f] [def: amorous feeling] % Der Nister
mnemonish/A [def: mnemonic] [note: V]
mobil/A [def: mobile] 
	mobilkayt/N [f] [def: mobility]
	mobilizi'r/V/Bmobilizi'rt [def: mobilize]
	mobilizatsye/S [f] [def: mobilization]
	demobilizi'r/V/Bdemobilizi'rt [def: demobilize] 
	mobilke/S [f] [def: mobile telephone]
mode/S [f] [def: fashion] modish/A
	shraybmode/S [f] [def: manner of writing]
	altmodish/A [def: of ancient fashion] 
	hayntmodish/A [def: of modern fashion] 
	naymodish/A [def: modern; fashionable; newfangled (pejorative)]
	[idiom: kurtse mode = fad]
modeli'r/V/Bmodeli'rt [def: model]
	mode'l/N [m] [def: model; design] [pronunciation: mode'L]
	modelke/S [f] [def: model (person)]
	modeli'st/N [m] modelistke/S [f] [def: designer]
/Xmoes{mewT} [def: money, dough]
modem/S [m] [def: modem (electronic: modulator-demodulator)] [note: V]
	kabl-modem/S [m] [def: cable modem] [note: V]
modern/K [def: modern]
	modernizi'r/V/Bmodernizi'rt [def: modernize]
		modernizirer/X [m] [def: modernizer]
	modernkayt/N [f] [def: modernity] 
	modernizatsye/S [f] modernizirung/N [f] [def: modernization] 
	moderni'zm/N [m] [def: modernism]
	modernistish/A [def: modernistic]
modistke/S [f] modistin/S [f] [def: hatmaker]
modne/A [def: strange] 
mo'es_khitn{mewT-Hytyn} [m?] [def: fund to provide Passover needs for the poor]
moger/A [def: lean; skimpy] 
mogn/S/D [m] [def: stomach] /Idik [def: intestinal]
	[idiom: hobn dem mogn = move the bowels, defecate]
	[idiom: loyzer mogn = diarrhea]
mok/N [n] /Dmek [def: penis (body part) (slang); fool]
mokem{mkwm}/Xmekoymes{mkwmwT}/H [m] [def: place]
	memale_mokem{mml#-mkwm} [m] [def: substitute; understudy] 
	memale_mokem{mml#-mkwm} [verb] [def: take the place (with "zayn")] 
	oyse_mokem{#OTw-mkwm} [def: female genitalia]
moker{mkwr}/Xmokrem{mkrym}/Xmekoyrem{mkwrym}/H [m] [def: source; well]
mokh/N [m] [def: moss] /Iik mokhnate/A
	bamokht/A [def: moss-covered]
mol/N [m] [def: moth (insect)] 
mol/N [m] [def: pier] 
mol/V/Bgemoln [def: grind] /Giber
	tsemol/V/Btsemoln [def: grind finely] 
	mil/N [f] [def: mill] /Dmilkh
		miler/S milner/S [m] mi'lnerin/S [f] [def: miller]
		baytlmil/N [f] [def: flour mill] % Bergelson
		vasermil/N [f] [def: water-mill] % Bergelson
		vintmil/N [f] [def: windmill]
		fleysh-milekhl/Eekh [n] [def: meat grinder]	% Stutchkoff
		mel [f] [def: meal, flour] /Iik
			kornmel [f] [def: rye meal]
			papshoymel [f] [def: corn meal] 
		farmelikt/A [def: flour-covered] % Bashevis
		farme'lt/A [def: flour-covered] % Y. Y. Singer
	namo'l [m] [def: alluvium, silt, sediment]
mol/V/T [def: paint, imagine (with "zikh")] /Goys/Gon/Gop
	dermol/V/Bdermolt [def: picture]
	bamol/V/Bbamolt [def: picture]
	farmol/V/Bfarmolt [def: draw]
	geme'l/N [n] [def: illustration]
		va'ntgemel/N [n] [def: mural (art)]
	moleray'/N [n] [def: painting] 
		grafito-moleray'/N [n] [def: graffiti] [note: V]
	moler/S [m] [def: painter]
		grafiti-moler/S [m] [def: graffiti artist] [note: V]
		hoy'zmoler/S [m] malyar/Ees [m] /Isk [def: house painter]
		shtubmoler/S [m] [def: house painter] 
		vortmoler/S [m] [def: author]
	oysmo'lerish/A [def: fantastic, with much detail]
	ma'lyeve/V/T [def: paint houses] /Goys
		malyer/S [m] [def: house painter]
	gemolekhts/N [n] [def: painting]
mol [n] [def: time] amol [def: once upon a time] /Iik [def: former; in former days]
	demolt [adv] demolts [adv] demolst [adv] yemolt [adv] [def: then]
	demoltik/A demolsdik/A [def: of that time] 
	denstmol [adv] [def: then] /Iik dent|smol [adv] % both spellings
	alemol [adv] [def: always]
	keynmol [adv] [def: never]
	eynmol [adv] /Iik [def: once; especially]
	hayntmol [adv] [def: now] 
	oftmol [adv] [def: often]
	mi'tamol [adv] [def: suddenly] /Iik [def: sudden]
	no'khamol [adv] [def: again]
	teylmol [adv] [def: sometimes] /Iik [def: occasional] 
	tsumol [adv] [def: occasionally]
	vi'deramol [adv] [def: yet again]
	firmolik/A [def: four-fold] 
		[idiom: firmoliker kalike = quadriplegic]
	knas{kns}-mol [n] [def: engagement party]
	nakhtmol/S [def: supper (German)] [usage: inadmissible] % Hungarian Khsidem
	[idiom: zayn vi' a mol = unpredictable; it depends]
	[idiom: far a mol = all at once]
	[idiom: nit a mol = not even]
mole{ml#}/H [def: full (with noun); drunk] 
	memale{mml#} [verb] [def: fill, refill, repay (with "zayn")]
molekul/N [m] [def: molecule] /Iar
molibdenum [m] [def: molybdenum (Mo)] 
molodyets [m] [def: hero]
	[idiom: bist a molodyets = well done! bravo!]
molokoso's/N [m] [def: immature youth]
molye/V/T modlye/V/T [def: pray (with "zikh") (Christian)] 
	bohomolye/V/T [def: prattle ??] % Stutchkoff
momen{mmwn}/H [def: riches] 
	measef_momen{masf-mmwn} [verb] [def: become wealthy (with "zayn")]
moment/N [m] [def: moment] /Ia'l [def: soon, in a short timin a short time]
	momentvayz momentnvayz [def: moment by moment]
	[idiom: klern oyf dem heysn moment = think on one's feet]
mon [m] [def: poppy, poppy seed, tiny object] 
	mondl/Eekh [n] [def: poppy-seed bun (food)]
	mo'nele/Ekh [n] [def: poppy-seed cake; scrap]
	montshink/A [adj] [def: tiny] [grammar: only attributive]
mon/V/T [def: demand] /Gayn/Goyf
	derman/V/Bdermant dermon/V/Bdermont [def: remind; recollect (with "zikh")]
		% both forms
		dermonung/N [f] [def: reminder]
	oybndermont/A [def: mentioned earlier]
	moner/S [m] [def: plaintiff; demander]
monakh/N/Ees [m] [def: monk] 
	monasti'r/N [m] [def: convent; monastery] 
monarkh/N [m] [def: monarch] monarkhye/S [f] [def: monarchy]
monat/N [m] [def: month] 
mones{mnwT}/H/N [def: Purim gifts of food (with "shalekh -")] 
mongol/N [m] [def: Mongol] /Iish
monografye/S [f] [def: monograph] 
monokl/N [m] [def: monocle]
monolitish/A [def: monolithic, undiversified] % Forwards
monolo'g/N [m] [def: monologue] 
mononukleoz [m?] [def: mononucleosis (disease)] % Forwards: Sholem Berger
monopol/N [m] [def: monopoly]
monosilabish/A [def: monosyllable] % Forwards: Khane-Faygl Tertltoyb
monster/S [m] [def: giant; fiend]
monta'zh/N [m?] [def: montage; installation]
montik/N [m] [def: Monday] 
monti'r/V/Bmonti'rt [def: assemble; install; mount] /Gayn
	remonti'r/V/Bremonti'rt [def: remodel, repair]
		remont/N [def: remodeling] 
montshe/V/T [def: appear in a confused way (with "zikh")] % Forwards
	/Goys [def: swindle]
	tsemontshe/V/Btsemontshet [def: mix together]
montshke [f] [def: granulated sugar]
	montshke/S [f] [def: a sweet food made with granulated sugar ??] % Sholem Aleykhem
monument/N /Ial [m] [def: monument] 
	monumentali'zm/N [m] [def: monumentalism] % Forwards
mops/N [m] [def: kind of dog] /Iish
moral/N [f] [def: ethics] /Iish [def: moral] moralishkayt/N [f] [def: morality]
	ummoralish/A [def: immoral]
	demoralizi'r/V/Bdemoralizi'rt [def: demoralize] % Harduf 
moravlye/S [f] [def: anthill] % Rochl Korn: Erd
mord/N [m] [def: murder] 
	merder/V/T [def: murder] /Gmit [def: be accomplice to a murder]
		merder/S [m] [def: murderer, ruffian] /Iish /Ilekh [def: murderous]
		merderay'/N [n] [def: murder]
	mo'rdeve/V/T [def: attack; fling oneself (with "zikh")]
		/Gon [def: works hard (with "zikh")]
	aleynmord/N [m] zelbstmord/N [m] [def: suicide]
		aleynmerder/N [m] aleynme'rderke/S [f] [def: person who commits suicide] 
	masnmord/N [m] [def: mass murder]
	dermorde/V/Bdermordet [def: murder]
morde/S [f] [def: chin, snout] /D /Idik mordetshke/S
	brokhmorde/S [f] [def: disaster, calamity] % Michael Wex
more [f] [def: mohair (material)]
	ratsemore/S [f] [def: mohair (material)] ratsemorn/A 
more/V/T [def: famish, make hungry]
	farmore/V/Bfarmoret [def: famish, make hungry]
morer{mrwr} [m] [def: bitter herb for Passover]
morfologye/S [f] [def: morphology]
	morfologish/A [def: morphological] 
morgn/S [m] [def: morning, tomorrow] /Idik [def: pertaining to tomorrow]
	ibermorgn [m] /Idik [def: day after tomorrow]
	frimorgn/S [m] /Idik [def: dawn] 
	tsumorgns [def: at dawn] 
	morgedik/A [def: future]
mormon/N [m] [def: Mormon]
morotshe/V/T [def: annoy; prattle]
morsh/N [m] [def: buttocks (vulgar)]
mos/N [f] [def: measure] /Iik [def: abundant] 
	ibermosik/A [def: overabundant] 
	[idiom: iberkhapn di mos = overstep a boundary]
moshiyekh{mSyH}/Xmeshikhem{mSyHym}/H/C [m] [def: messiah] 
	meshikhish{mSyHish}/A [def: messianic]
		meshikhishkayt{mSyHishkayt}/N [f] [def: messianism]
	[idiom: men zol nor dermonen moshiyekh{mSyH}|n = speak of the devil]
moski't/N [m?] moskito/S [m?] [def: mosquito (insect)]
moshl{mSl}/Xmesholem{mSlym}/H [n] [def: example, demo (computer)]
	lemoshl{lmSl}/H [adv] [def: for example] 
	nimshl{nmSl}/H [m] [def: moral] 
	memshole{mmSlh}/H memsholes{mmSlwT}/H [def: government] 
	mishley{mSly}/H [def: Proverbs] 
	moshl{mSl}/V/T /Gop [def: depict]
moshtshe/V/T [def: find one's place (with "zikh")]
	/Gayn [def: find a place for]
mostye/V/T [def: seat (person)] /Gayn
moti'v/N [def: motif]
	fo'lkmoti'v/N [def: folk motif]
motivi'r/V/Bmotivi'rt [def: motivate] motivatsye/S [f] [def: motivation]
motl/V/T [def: gossip]
moto/S [m] [def: motto] 
motor/N [m] [def: motor, engine]
	elektromotor/N [m] [def: electric motor]
	damfmotor/N [m] [def: steam engine]
move/S [f] [def: idle talk, speech (Polish mowa)]
moves{mvT}/H [m] [def: death] /Lha{h} [noun] [m] [def: the death]
	meymes{mmyT}/V/T [def: kill]
	mise{myTh} [f] [def: death] 
	eymes_moves{#ymT-mvT} [f] [def: deathly fear]
    malakhamoves{ml#x-hmwT} [m] [def: angel of death]
	noyte_lomes{nwth-lmT}/N [m] [def: deathly ill person]
moyd/N/Xmeydn [f] mad/N [f] [def: maid] /Dmeyd [n/f] [def: girl]
	meydlish/A meydlsh/A [def: girl-like] 
	meydlvayz [def: as a girl]
	dinstmoyd /Ddinstmeyd [f] /Dshtubmeyd [def: servant girl or maid]
	kale{Klh}-moyd [f] [def: marriagable girl] 
	ba'rmeydl/Eekh [def: barmaid] % Berish Goldstein
	ka'mermey'dl/Eekh [def: chambermaid]
	yam_meydl{ym-meydl}/Eekh [def: mermaid]
	/Dga'snmeyd [n/f] [def: prostitute] 
moyde{mwdh}/H [verb] [def: admit fault (with "zikh zayn"); thank (with "zayn")] 
	hoydoe{hwd#h}/Xhoydoes{hwdowT}/H [f] [def: admission, confession]
moyed{mwed}/H [m] [def: holiday] /Lha{h} [noun] [m] [def: the holiday]
	khol_hamoyed{Hwl-hmwed} [m] [def: intermediate day of a festival]
moyekh{mwH}/Xmoykhes{mwHwT}/H [m] [def: brain] 
	katnes_demoykhn{ktnwT-dmwHyn} [f?] [def: low stage of awareness of God (mystic)]
	moyekh{mwH}/V/T [def: ponder, concentrate] % Opatoshu: Polishe Velder 
		farmoyekh{farmHt}/V/Bfarmoyekht{farmHt} [def: in deep thought (with "zikh")]
moyel{mwhl}/H [def: circumcisor]
	mile{mylh}/H [def: circumcision; foreskin; penis (body part)]
		bris_mile{bryT-mylh} [def: circumcision, baby naming for son] 
	mal{ml}/H [def: circumcise (with "- zayn")]
		gemalt{gemlt}/A [def: circumcised]
moyer/N [m/f] [def: (outside) wall; (brick or cement) building] /D
	moyer/V/T [def: build a wall] /Gayn [def: wall in]
		moy'erer/S [m] [def: bricklayer, mason]
	farmoyert/A [def: walled in] 
	fraymoyerer/S [m] [def: Freemason] 
moyfes{mwfT}/Xmofsem{mwfTym}/H [m] [def: miracle, marvel, wonder] 
	bal_moyfes{bel-mwfT}/Xbal_mofsem{bel-mwfTym}/H [m] [def: wonder worker]
moykher{mwxr}/H [verb] [def: sell (with "zayn")] 
	mekhire{mxyrh} [f] [def: sale]
	shtar_mekhire{mxyrh} [m] [def: bill of sale; receipt]
	mekhires-yoysef{mxyrT-ywsf} [def: the sale of Joseph (play)]
	mekhires-khomets{mxyrT-Hmc} [def: the sale of leaven before Passover]
	[idiom: mekekh_umemker{mkH-|wmmKr} = commerce]
moykhl{mwHl}/H [verb] [def: forgive (with "zayn")]
	mekhile{mHylh}/H [f] [def: forgiveness, forgive me, pardon; buttocks] 
		mekhilevdik{mHylhvdik}/K [def: forgiveable, pardonable]
		bimkhile{bmHylh} [adv] [def: excuse my saying so, but ...]
moykhsn{mwxsn} [m] [def: tax collector] % Menakhem Kipnis
	moykhsnte{mwxsnte}/S [f] [def: wife of a tax collector] % Menakhem Kipnis
moyl/Xmayler [n] [def: mouth; rim] /Dmaylkh
	folksmoyl/Xfolksmayler [n] [def: common wisdom]
	ley'bnmoyl/Xley'bnmayler [n] [def: snapdragon (flower)]
	oyvnmoyl/Xoyvnmayler [n] [def: opening of an oven]
	[idiom: nemen in moyl arayn = have a bite of something]
	[idiom: mit a halb moyl = halfheartedly]
moyled{mwld}/H [m] [def: new moon]
moylvorf/N [m] [def: mole (animal)]
moyre{mwr#}/Xmoyres{mwr#wT}/H [f] [def: fear] /Ivdik [def: fearful]
	/Idik [def: dreadful; formidable]
	yiras{yr#T}/H [def: fear of] 
	-/Xyomem_noroem{ymym-nwro|ym} [def: days of awe, between Rosh Hashono and Yom Kippur]
moyred{mwrd}/Xmordem{mwrdym}/H [def: rebel (with "zayn")]
	meride{mrydh}/H [f] [def: rebellion] 
	yordem{ywrdym}/H [def: emigrants from Israel] 
moyser{mwsr}/Xmoysrem{mwsrym} [m] [def: tattletale]
moyshev{mwSB}/H [def: mess] 
	moyshev{mwSB}/V/T [def: begrime] /Gon
moyshev{mwSB}/H [m] [def: residence, town] 
	toyshev{WwSB}/Xtoyshvem{WwSBym}/H [m] [def: resident]
	yishev{yiSwB}/Xyishuvem{yiSwBym}/H [m] [def: settlement]
		yishevnik{yiSwBnik}/Ees [m] yishevnitse{yiSwBnitse}/S [f] [def: settler]
		yoysheyv{ywSB}/H yoyshvem{ywSBym}/H [def: resident] 
	meyashev{mySB}/H [def: decide (with "zikh zayn")] 
	meyushev{mywSB} [m] [def: sane man] meyusheve{mywSBe} [f] [def: sane woman]
moytse{mwcy#}/H [verb] [def: bring out; fullfill an obligation (with "zayn")]
	hamoytse{hmwcy#}  [def: blessing over bread] 
		[idiom: es nisht di khale{Hlh} far hamoytse{hmwcy#} = no sex before marriage]
	hamoytsemlekh{hmwcy#mlekh} [def: scraps of bread] 
		moytse{mwcy#}/S [m?] [def: piece of bread]
	moytsey{mwc#y}/H [def: end of holiday (with "- shabes", for instance)] 
	yoytsi{ywc#}/H [verb] [def: fulfill an obligation (with "zayn")] 
	yoytsres{ywcrwT}/H [def: additional liturgical poetry]
		[idiom: (far)mishn/(far)baytn di yoystres = be confused]
	[idiom: yegati{ygeWy} umatsosi{|wmc#Ty} = seek and you shall find]
moyz/Xmayz /Dmayz [f] [def: mouse]
	fle'dermoyz/Xfle'dermayz [f] [def: bat] 
mozaik/Ees [f] [def: mosaic]
/Xmozlen [def: German measles, rubella (disease)]
	mozl/V/T [def: have measles]
	[idiom: er hot shoyn gepokt un gemozlt = he's experienced]
mrake/S [f] mrak [m?] [def: fog and drizzle; gloom] 
	mrake/V/T [def: drizzle] 
mirtshe/V/T [def: moo (sound of an ox)] % Sholem Asch: Motke Ganef
mruke/V/T mrutshe/V/T [def: moo (sound of a cow); growl]
	mrukenish/N [n] [def: growling; mooing]
	mruk/Ees [m] [def: pessimist, curmudgeon, man of few words]
	farmruket/A [def: surly, gruff]
mruzhe/V/T [def: squint] /Gtsu
	farmruzhe/V/Bfarmruzhet [def: squint]
muberes{mewbrT}/A [def: pregnant] /Idik
mufleg{mwflg}/Xmuflogem{mwflgym}/H [m] [def: unusual; important; scholar] 
mufte/S [f] [def: muff (clothing)] 
muk/N [m?] mik/N [m?] [def: mosquito (insect)]
muke/V/T [def: moo (sound of a cow)] meke/V/T mruke/V/T
mukhe/S [f] [def: moribund cow (katsoves-loshn)]
mukhomor/N [m?] [def: fly agaric mushroom, Amanita muscaria]
mula/S [m] [def: Mullah (Islam)]
/Xmu'lines [f] [def: suds]
mulyer/S/Xmulya'res [n] [def: bricklayer, mason]
multer/S/D [f] [def: trough] 
multimedea [f?] [def: multimedia] % Forwards
multiplikatsye/S [f] [def: multiplication (mathematics)] % Stutchkoff
mum{mwm}/H [m] [def: defect; deformity]
mume/S/C/J/D [f] [def: aunt] mu'menyu [f] [def: dear aunt]
mumifitsi'r/V/Bmumifitsi'rt [def: mummified] % Forwards: Y. London
mumkhe{mwmHh}/Xmumkhem{mwmHym}/H [m] mumkhete{mwmHhte}/S [f] [def: expert] 
	mu'mkheshaft{mwmHhshaft}/N [n] [def: expertise] 
mums [m] [def: mumps (disease)]
mumye/S [f] [def: mummy]
mund'ir/N [m] [def: uniform] /D
munitsipal/A [def: municipal] munitsipalite't/N [def: municipality]
munitsye/S [f] amunitsye/S [f] [def: ammunition]
munkle/V/T [def: spread gossip]
munter/V/T [def: encourage; cheer up; animate; revive] 
	/Gop [def: revive]
	/Goyf [def: alleviate] 
	dermunter/V/Bdermuntert [def: revive]
	munter/K [def: happy] 
mural/N [m?] [def: mural (art)]
murashke/S [f] [def: ant]  % also pronounced me'reshke
	murashnik/Ees [m] [def: anthill] 
murke/V/T [def: growl; purr (sound of a cat)]
murml/V/T [def: murmur] /Gmit/Garoys/Goys
	murml [m] [def: murmur] /Idik [def: murmuring] 
	gemu'rml/N [n] [def: murmuring] 
murze/S [m/f] [def: slob] % Weinreich, Stutchkoff
muser{mwsr}/H/V/T [def: upbraid] /Goys/Gop
	muser{mwsr}/H [m] [def: lecture on morality; ethical Musar movement]
		/Lha{h} [noun] [m] [def: the Musar]
	muser|nik/Ees [m] [def: follower of the Musar movement] 
	moyser{mwsr}/Xmosrem{mwsrym} [m] [def: tattletale, snitch]
	mesire{msyrh}/H [f] [def: denunciation, informing (to authorities)] /D
		mesires{msyrwT}/H [def: endangerment; informing]
	mesoyre{mswrh}/H [def: tradition] 
	maser{msr}/V/T [def: turn in to the authorities]
		farmaser{farmsr}/V/T [def: turn in to the authorities] % A. Vergelis, "der teater fun mayn neshome"
mushkat [m?] [def: nutmeg (spice)]
muske't/N [m] [def: musket (weapon)]
mushl/N [m?] [def: sea shell]
	oyer-mushl/N [def: ear]
mushti'r/V/Bmusti'rt [def: drill (exercise; with "zikh")]
	mushti'reve/V/T [def: command like soldiers] % Sholem Aleykhem
	mushtir/N [m] [def: drill (exercise)]
muskl/N [m] [def: muscle] muskuli'rt/A [def: muscled]
	muskulyez/A [def: muscular] % Forwards: S-R Shaechter
	bo'ykhmuskl/N [m] [def: diaphragm (anatomy)] % Forwards: Sholem Berger
	hoy'ptmuskl/N [m] [def: main muscle] % Forwards: Sholem Berger
muster/N [m] [def: pattern, example]
	shnitmuster/N [m] [def: fashion example] % Forwards: Genadi Estraykh
mut [def: courage] /Iik [def: courageous]
	mutik/V/T [def: encourage]
		antmutik/V/Bantmutikt [def: discourage]
	mutikayt/N [f] [def: courage]
		shvermutikayt/N [f] [def: bad emotional disposition] % Der Nister
	gutmut [m] [def: good mood] % Der Nister: Mashber
		gutmutik/A [def: of good disposition]
		gutmutikayt/N [f] [def: good emotional disposition]
	groysmutik/A [def: of a generous disposition]
	dermutik/V/Bdermutikt [def: encourage]
		dermutikung/N [f] [def: encouragement] % Forwards: M-S Hoffman
	gemit/Eer [n] [def: disposition, frame of mind, mood] 
		gemitlekh/A [def: pleasant; cozy]
		gemitlekhkayt/N [f] [def: pleasantness, coziness]
	umet [def: uneasy feeling, anomie]
		umetik/K [def: uneasy (with dative)] /Iiklekh
		farumetik/V/Bfarumetikt [def: make uneasy] 
		farumer{far#umer}/V/Bfarumert{far#umert} [def: sad; uneasy]  % possibly Polish "umer" die; maybe "umer" humor
	[idiom: shver gemit = heavy heart]
	[idiom: gring gemit = light heart]
	[idiom: hobn an alt gemit = be precocious]
	gutvilik/A [def: kindly, good-hearted]
	mutvilik/A [def: wanton, arbitrary]
mutatsye/S [f] [def: mutation] 
muter/S/D [f] [def: mother] /Ilekh
	heybmuter/S [f] [def: uterus]
	klo'gmuter/S [f] [def: professional mourner; crybaby]
	pe'rlmuter [f] [def: mother-of-pearl] /In
	toy'fmuter/S [f] [def: Godmother (Christian)
	[idiom: matke boske = mother of God, Virgin Mary (Polish Matka Boska)]
muterl [f] mu'terke/S [f] ma'terke/S [f] shroyfmuter/S [f] [def: nut (hardware)] /D
mutne/A [def: cloudy, turbid; sad]
	kalemutne/A [def: out of sorts]
	smutne/A [def: lonely; sorrowful, sad] 
	montne/A [def: sad] [usage: not recommended]
mutshe/V/T [def: bother, abuse; suffer; toil, expend effort (with "zikh")]
	/Gon/Gop
	/Goys [def: exhaust]
	farmutshe/V/Bfarmutshet [def: bother; wear down]
muvek{mwBhk} [adj] [def: brilliant, clear] 
muz/V/T [def: must]
	muz/N [m] [def: necessity]
muze/S [f] [def: Muse (Greek mythology)]
muzey'/N [m] [def: museum] /Iish muzeum/S [def: museum] 
	ontap-muzey/N [m] [def: hands-on museum] 
muzhik/Ees [def: peasant (Russian мужик)]
	 muzhitshke/S [f] [def: peasant woman] % Mendele
muzi'k [f] [def: music] /Ial/Ialish [def: musical]
	muzika'nt/N [m] mu'ziker/S [m] [def: musician]
	folksmuzi'k [f] [def: folk music]
	ka'tsn-muzi'k [f] [def: cacophony]
	ma'rshmuzi'k [f] [def: marching music]
	muzikologye/S [f] [def: musicology]
		muzikologish/A [def: musicological]
		muzikolo'g/N [m] [def: musicologist] 
myantshe/V/T [def: ??]
myatsh/Ees [m] [def: ball] myatshik/Ees [m] 
myauke/V/T [def: meow (sound of a cat)] 
myeshtshanin/Xmyeshtshanyes [m] [def: petty bourgeois]
na nat [def: take] [grammar: only in imperative]
	[idiom: na dir = take that]
-/Xnaanuem{nenwe|ym} [def: lulav (religious article for Sukkos); waving the lulav]
nadn{ndn}/H [m] [def: dowry] 
nadye/V/T /Garayn [def: sneak in (with "zikh")]
nadziratel/Ees [m] [def: overseer, warden (Russian надзиратель)]
nadzhe/V/T [def: lure; decoy] /Gayn [def: insinuate oneself (with "zikh")]
nafke_{nfk#}/H/S [f] nafke/S [def: prostitute (vulgar)] 
na'fkemine{nfk#-mynh}/Xnafkemines{nfk#-mynwT}/H [f] [def: effective difference] 
naft [m] [def: kerosene; naphtha] 
	naftali'n [m?] [def: naphthalene ??] % Sholem Aleykhem
	naftfeld/Xer [n] [def: oil field] 
nagan/Ees [m] [def: pistol (weapon)] % 7-chambered, made by  Emile and Leon Nagant, Belgium
nagrade/S [f] [def: prize, reward (Russian наград)]
nahi't [def: chickpeas (food)] 
naiv/A [def: naïve] naivkayt/N [f] naivite't/N [f] [def: naïvité]
naket/K [def: naked] naketkayt/N [f] [def: nakedness]
	naketerheyt [def: in a naked state]
	opgenaket/A [def: unclothed] % Der Nister
nakha'l/N [m] nakhalke/S [f] [def: impertinent person]
nakher [def: afterward(s) (German)]
nakhes{nHT}/H [n/m] [def: pleasure] /Idik [def: pleasant]
	umnakhesdik{umnHTdik}/A [def: without pleasure] % Der Nister: Mashber
	[idiom: shepn nakhes{nHT} = derive pleasure]
nakhle{nHlh}/Xnakhloes{nHlowT}/H [def: inheritance (real estate)]
nakhso'l [adv] [def: why?] [conj] [def: because]
nakht/Xnekht [f] [def: night] /Iik nekht/D
	baynakht [adv] /Iik [def: at night]
		baynakht/N [f] [def: nighttime] % Der Nister
		baynakhtik/A [def: demon] % Bashevis
	oyfdernakht [adv] [def: at night]
	farna'kht/N [m] /Iik /Ilekh [def: dusk]
	halbna'kht/N [m] [def: midnight]
	nakhtish/A nakhts [def: night]
	afdernakht{Ofdernakht} [adv] [def: at night]
	ibernakht [adv] [def: overnight, suddenly] % Forwards: M-S Hoffman
	nekhtik/V/T [def: spend the night] /Giber/Gunter 
		nekhtik/A [adj attributive] [def: of yesterday; confused, depressed, anemic (person)]
	eyernekhtn [def: day before yesterday] 
		eyernekhtik/A [def: of the day before yesterday]
	nekhtn [def: yesterday] nekhtik/A [def: yesterday]
	[idiom: a nekhtiker tog = an impossibility]
	khupe{Hwph}-nakht/Xkhupe{Hwph}-nekht [f] [def: wedding night] % Michael Wex
	mitlnakht/Xmitlnekht [f] [def: midnight] /Iik
		halbnakhtik/A [def: at midnight]
	shabey'senakhts{SbT-tsu-nakht|s} [def: Saturday night]
	shternnakht/Xshternnekht [f] [def: starry night]
	vakhnakht/Xvakhnekht [f] [def: vigil (religious)] 
	zumernakht/Xzumernekht [f] [def: summer night]
	vinternakht/Xvinternekht [f] [def: winter night]
	[idiom: di vayse nakht = all-nighter (remain awake through the night)]
	[idiom: halbe nakht = middle of the night]
	[idiom: oyf der nakht = in the evening]
	[idiom: vi tog un nakht = completely opposite]
	[idiom: di nakht fun donershtik oyf fraytik = Thursday night]
na''khtigal/N [f] [def: nightingale (bird)] 
nakidke/S [f] [def: cape (clothing)]
nakn/S [m] [def: neck] 
nalivke/S [f] [def: flavored liquor]
namnam [noun] [def: food (baby talk)]
napad/N [m?] [def: attack, assault (Polish napad)] % Forwards: Yechiel Szeintuch
napoleonke/S [f] napoleon/N [m] [def: bicome (hat)]
nar/V/T [def: fool, trick] /Garoys/Gayn/Garayn/Goys
	/Gop [def: disappoint]
	farnar/V/Bfarnart [def: foo]
	banarish/V/Bbanarisht [def: act foolishly (with "zikh")] 
	nar/Xnaronem{naronym}/D [m] [def: fool] narish/K [def: foolish] 
		[idiom: makhn zikh narish = fool around, act silly; flirt]
	narishevate/A [def: silly; foolish]
	narishkayt/N [f] [def: foolishness]
	opnarer/S [m] opna'rerin/S [f] [def: swindler, someone who fools others]
		opnarish/A [def: swindling; confusing]
	genareray'/N [n] gena'r [n] [def: deception] % Harduf 
		[idiom: er hot in mir dos genar = he is taking advantage of me]
narativ/N [def: narrative] folksnarativ/N [def: folk narrative]
	naratsye/S [f] [def: narration, recital] % Forwards: M-S Hoffman
	narator [m] [def: narrator] % Forwards: Itsik Gottesman
naraye/V/Bnarayet [def: suggest, offer] 
	naray/N [m] [def: suggestion, offer, recommendation] 
		narayer/S [m] [def: advisor] % Der Nister
nard/N [m] [def: spikenard (oil of Nardostachys jatamansi)]
narkotik/N [m] [def: narcotic (drug)] 
	narkotiker/S [m] [def: drug addict] 
	narkomanye/S [def: addiction] % Forwards: Yoel Matveyev
		narkoma'n [m] [def: addict] % Forwards: S-R Schaechter
narod [def: people (collective noun, Russian народ)] 
narte/S [f] [def: ski]
	nartl/V/T [def: ski] nartler/S [m] [def: skier]
	[idiom: geyn af narte = go skiing]
nartsis/N [m] [def: narcissus (plant)] 
nas/A [def: wet] /Ilekh
	nets/V/T [def: moisten] /Gdurkh/Gayn
	banets/V/Bbanetst [def: moisten]
	farnets/V/Bfarnetst [def: wet]
nash/V/T [def: snack, plagiarize]
	nash/N/D [def: snack]
	nasher/S [m] na'sherke/S na'sherin/S [f] [def: snacker]
	nasheray'/N [n] [def: snack] 
	farnash/V/Bfarnasht [def: spend on sweets] 
nastartsh/V/T [def: provide enough; satisfy] [usage: lower-class] % Der Nister
natryum [def: sodium (Na)] 
natshalnik/Ees [m] [def: boss (Russian)] 
	natshalstve [def: ruling authority (Russian)]
	natshelnik/Ees [m] [def: official, chief (Polish naczelnik)]
natsi/S [m] /Ish /Istish natsikhe/S [f] [def: Nazi]
	natsi'zm/N [m] [def: Nazism]
natsye/S [f] [def: nation]
	natsyonal/A [def: national] /Iish
		natsyonali'zm/N [m] [def: nationalism] 
		natsyonali'st/N [def: nationalist] /Iish
	internatsyona'l/A [def: international]
		internatsyonali'st/N [m] [def: internationalist] /Iish
	natsyonalite't/N [f] [def: nationality]
natu'r [f] [def: nature] natirlekh/A nature'l/A [def: natural]
	ibernatirlekh/A [def: supernatural]
	umnatirlekh/A [def: unnatural]
	naturalizi'r/V/Bnaturalizi'rt [def: become a citizen] 
	naturalistish/A [def: naturalistic (literary style)]
nava'redker/X [def: follower of the Musar movement] % after Yoysef-Yoyzl Hurvits (der Alter) from Nava'redok
navenad{ne-|wnd} [adj] [def: homeless; homelessness; wanderer]
	navenadnik{ne-|wndnik}/Ees [m] [def: wandering person]
navigi'r/V/Bnavigi'rt [def: navigate]
	navigator/S [m] [def: navigator]
	navigatsye/S [f] [def: navigation]
nay/K [def: new] nayes/N [def: news]
	naykayt/N [f] nayhayt/N [f] [def: newness]
	banay/V/Bbanay|t [def: renew] banayung/N [f] [def: renewal]
	iberanays [adv] [def: yet again]
	funsnay' oyfsnay' oyfdosnay' [def: anew]
	nayink/A [def: small new]
nayert [adv] [def: rather, but] 
nayger/Iik [def: eager] naygerikayt/N [f] [def: eagerness]
nayn [d] [def: 9] /It nayntl [n] [def: 1/9] nayntns [adv] [def: ninthly]
	nayntsn [d] [def: 19] nayntsnt/A [def: 19th] nayntsntl [n] [def: 1/19] 
	nayntsik [d] /A [def: 90] nayntsikst/A [def: 90th] nayntsikstl [n] [def: 1/90] 
nebekh [interj] [def: nebekh: expression of pity]
	/D /Dnevik[def: helpless or hapless person] 
	ne'bekhdik/K [def: pitiable] 
	ne'bekhdikayt/N [f] [def: pitiability]
nebl/Idik [def: cloud]
nebn/P [def: near] dernebn danebn
nebul/S [f] [def: nebula] [note: V] 
nedove{ndBh}/Xnedoves{ndBwT}/H [f] [def: handout]
	menadev{mndB}/Xmenadvem{mndBym}/H [m] [def: donor]
	menadev{mndB} [verb] [def: donate (with "zayn")]
	nadven{ndBn}/Xnadvonem{ndBnym} [def: donor] 
neelm{nelm}/H [verb] [def: disappear (with "vern")] 
nefesh{nfS}/Xnefoshes{nfSwT}/H/D [n] [def: soul, person]
	/Lha{h} [noun] [n] [def: the soul]
	moyser_nefesh{mwsr-nfS} [verb] [def: self-sacrificing (with "zayn")] 
		mesiras_nefesh{msyrT-nfS} [def: self-sacrifice]
	agmes_nefesh{egmT-nfS}/H [def: heartache; grief, sorrow]
	kheshbn_hanefesh{HSbwn-hnfS}/H [def: self-appraisal]
	koyekh_nafshi{KwH-nfSy}/H [def: personal strength]
	mo'neshekh{mmh-nfSx}/H [interj] [def: in any case, it makes no difference]
	[idiom: sakonas{sKnT} nefoshes{nfSwT} = mortal danger; exceedingly]
	[idiom: beleyv{blB}-venefesh{|unfS} = utterly]
nefikhe{nfyHh}/S/H [f] [def: flatus, release of gas, fart] [usage: taboo] % ?? spelling
negativ/A [def: negative]
neged{ngd}/H [def: against] keneged{Kngd} [def: opposite (position)]
	shekeneged{Skngd} [def: opposing]
neger/S [m] ne'gerte/S [f] [def: Negro] [usage: was polite, no longer acceptible in America]
negeye{nwge}/H [verb] [def: touch (with "zayn")]
	benegeye{bnwge} [def: in regard to]
	negiye{ngyeh}/H negiyes{ngewT}/H [def: contact] 
negishes{ngySwT}/H [def: torture, discrimination, oppression, persecution] 
negl/X/Eekh  [def: nail] 
	nigl/V/T /Gon [def: attach oneself (with "zikh")] 
	ne'gelekh [n] [def: cloves (plant)] 
	negl/Eekh [n] [def: clove (spice)]
	negele/S [f] [def: pink (flower, Caryophyllaceae)]
	blumennegl/Eekh [def: flower spike] 
	baneglt/A [def: spiked; cleated]
nekeyve{nkBh}/Xnekeyves{nkBwT}/H [f] [def: female; woman (pejorative)] /Ish
	/Lu{|u} [noun] [f] [def: and woman]
	nekeyvenik{nkBhnik}/Ees [def: womanizer] 
	-/Xnekovem{nkBym} [def: orifices; defecation or urination]
nekhay' nikhay' [adv] [def: let it be (Russian нехай)] 
nekhome{nHmh}/Xnekhomes{mHmwT}/H [f] [def: comfort]
	/Xtankhumin{WnHwmyn} [def: comfort]
nekhos_darge{nHwT-drg#}/S [m] [def: boor, oaf, low-caste] % also pronounced "khos-darge"
nekhosem{nxsym}/H [def: property]
nekies{nkywT} [n] [def: cleanliness; bowel movement]
nekome{nkmh}/Xnekomes{nkmwT}/H [f] [def: revenge]
	noykem{nwkm}/H [verb] [def: take revenge (with "zayn zikh")] 
nekrolog/N [m] [def: obituary notice] 
nekst/A [def: next (English)]
nekteri'n/N [m] [def: nectarine] % Michael Wex
nekude{nkwdh}/Xnekudes{nkwdwT}/H [f] [def: punctuation]
	menaked{mnkd}/H [verb] [def: punctuate (with "zayn")] 
nem/V/Bgenumen [def: take; begin (with infinitive); derive from (with "zikh fun")]
	/Gavek/Gtsu/Garayn/Garoys/Gunter/Gdurkh/Giber
	/Gtsurik/Gtsuzamen/Gtsunoyf/Garunter/Garoyf/Gfor/Gfunander/Gaheym
	/Gadurkh/Gariber
	/Gafer [def: undertake]
	/Garop [def: subtract]
	/Garum [def: embrace]
	/Gayn [def: ingest; engulf; quiet (a child)]
	/Gon [def: accept; fill]
	/Gmit [def: carry along; hitchhike (with "lozn zikh")] % Weinreich
	/Goys [def: be a success, make a hit, stipulate (with "bay ... "az"), run out (with "zikh")] 
	/Goyf [def: greet, receive; host] 
	/Gop [def: fetch; pick up; paralyze] 
	bane'm/V/Bbanumen [def: comprehend]
		bane'm/N [m] [def: comprehension] banemung/N [def: comprehension]
			ve'ltbane'm/N [m] [def: worldview]
		banumen/A [def: possessed, crazy]
	dernem/V/Bdernumen [def: take]
	farnem/V/Bfarnumen [def: be busy; occupy] 
		farnumen/K [def: busy; occupied]
			farnumenkayt/N [f] [def: preoccupation]
	tsenem/V/Btsenumen [def: take]
	unternemung/N [f] [def: undertaking, affair]
		unternemer/S [m] [def: contractor]
			/Iish [def: able to organize undertakings]
		unternemerishkayt/N [f] [def: ability to organize undertakings]
	onnem/N [m] [def: acceptance]
	opnemer/S [m] [def: customer] 
	teylnemer/S [m] onteylnemer/S [m] [def: participant]
	nemlekh/A [def: similar]
	aru'mnemik/K aray'nnemik/A [def: thorough, complete, exhaustive] 
	ay'ngenem/K [def: pleasant] o'ngenem/K o'ngenemen/A a'ngenem/A ay'ngenumen/A ay'ngenemen/A
		
		umay'ngenem{um#ayngenem}/A umo'ngenem/A uma'ngenem/A [def: unpleasant]
	aropnem [m] [def: subtraction (mathematics)] % Stutchkoff
	aroysnem/N [m] aroysnemekhts/N [n] [def: take-out food] [note: V]
	farne'm/N [m] [def: size] /Iik [def: bulky, large]
	farne'm/K [def: important] 
	oyfnem/N [m] [def: reception; conception, perception]
	oysnem/N [m] [def: exception] oysnam/N [m] [def: exception] [usage: doubtful admissibility]
		oysnemlekh/A [def: exceptional]
			oysnemlekhkayt/N [f] [def: exceptional nature]
		oysnemenish/N [n] [def: removal of the Torah from the ark; stipulation]
	oyfnam/N [m] oyfname/S [f] [def: reception; shot (photographic)] 
	nemer/S [m] [def: taker]
	ongenumen/K [def: accepted]
	[idiom: oyf mi'ttsunemen = oyf aroystsunemen = take-out (food)]
nemen_{n#mn}/Xnemonem{n#mnym} [m] [def: trusted person]
neo- [prefix] [def: neo, new] 
neodimyum [m] [def: neodymium (Nd)] 
neologi'zm/N [m] [def: neologism, word coinage] 
neon [m] [def: neon (Ne)] 
nepl/N [m] [def: fog] /Idik [def: foggy]
	ne'pldikayt/N [f] [def: fogginess, mistiness]
	farneplt/A [def: fogged up] 
		farnepltkayt/N [f] [def: fogginess]
nepoti'zm/N [m] [def: favoritism; nepotism]
neptunyum [m] [def: neptunium (Np)] 
ner/V/T [def: nourish] ner/N [m] [def: nourishment] 
	nerung/N [f] [def: nourishment] 
	derner/V/Bdernert [def: nourish] dernerung/N [f] [def: nourishment]
	narhaftik/A nerevdik/A [def: nutritious] 
	[idiom: ner-spetsyalist = nutritionist]
nerv/N [m] [def: nerve] /Iez /Ieish nervezlekh/A [def: nervous]
	nervezkayt/N [f] nervezite't/N [f] [def: nervousness]
	denervi'r/V/Bdenervi'rt [def: vex, put on edge, annoy; be nervous (with "zikh")]
		denervirtkayt/N [f] [def: nervousnous, anxiety]
		[idiom: travmatishe denervirtkayt = post-traumatic stress syndrom (PTSD)] % Mikhail Krutikov
	nervi'r/V/Bnervi'rt [def: make nervous] % Harduf
nes{ns}/Xnisem{nsym}/H [m] [def: miracle] 
	nisemdik{nysymdik}/A [def: miraculous]
	[idiom: lebn fun nisem{nsym} = without visible means of support]
neshike{nSykh}/H [f] [def: kiss] /Lbe{b} [adv] [def: by a kiss]
	khibek_venishek{Hybwk-|wnySwk} [m] [def: caressing; sexual intercourse]
neshome{nSmh}/Xneshomes{nSmwT}/H [f] [def: soul]
	neshomenyu{nSmhnyu} [def: dear soul] 
	neshomedik{nSmhdik}/A [def: soulful]
		neshomedikayt{nSmhdikeyt}/N [f] [def: soulfulness] % Forwards: Gershn Vayner
	porkhe_nishmose{prHh-nSmTw} [verb] [def: become terrified, panic (with "vern")]
nesiye{nsyeh}/Xnesiyes{nsyewT}/H [f] [def: journey] 
nesoyen{nsywn}/Xnesyoynes{nsywnwT}/H [m] [def: test] 
nest/N/D [f] [def: nest] /Gayn
	bu'shlennest/N [f] [def: stork nest] % Chava Rozenfarb: Botshani
	ve'rternest/N [f] [def: collection of related words (linguistics)] % Forwards: Hershl Glaser
net/A [def: flush, snug; neat and fine] 
	[idiom: pasn net = fit tightly]
neto [def: net (as a measure)] % Harduf
nets/N [f] [def: net]
	veltnets [f] i'nternets [f] [def: Internet] internetish/A
	netsverk/N [m] [def: network] 
netsekh{ncH} [m] [def: eternity; the Sefirah Netsakh (kabbalah)] 
	nitsokhn{ncHwn}/Xnitskhoynes{ncHwnwT} [m] [def: victory, triumph; conquest] /Idik
		menatseyekh{mncH}/H [def: be victorious, conquer (with "zayn")] 
ne'vrolog/N [m] [def: neurologist] /Iik
	nevro'z/N [m] [def: neurosis]
ney/V/T [def: sew; embroider]
	/Gayn/Goyf/Gtsu/Gtsunoyf/Garum/Garayn/Goys/Gunter/Gon
	baney/V/Bbaneyt [def: sew]
	farney/V/Bfarneyt [def: sew up] /Gtsurik
	neytorin/S [f] [def: seamstress]
	geney'/N [n] [def: sewing; work being sewn]
	oysney'ekhts/N [n] [def: embroidery]
neyder{ndr}/Xnedorem{ndrym}/H [m] [def: oath]
	kol-nidrey{Kl-ndry} [def: Kol Nidrey prayer at start of Yom Kippur]
	menader{mndr} [verb] [def: donate to charity (with "zayn")]
	[idiom: gebn nedorem = make a pledge]
neyg/V/T [def: nod; be inclined; be different] /Garop
	/Gop [def: differentiate] 
	/Goyf [def: open slightly]
	farneyg/V/Bfarneygt [def: nod in agreement or recognition] 
	neygung/N [f] [def: leaning, inclination] 
	noyg/V/T [def: nod] [usage: doubtful admissibility]
		farnoyg/V/T [def: nod in agreement] [usage: doubtful admissibility]
	opneyg/N [m] opneygung/N [f] [def: trajectory; difference]
neylon [m?] [def: nylon (material)] % B. Sandler: Karolina-Bugaz
neyn [def: no] 
neyro'n/N [m?] [def: neuron] % Forwards: Yoel Matveyev
neyt/V/T neytik/V/T [def: force; need (with "zikh")]
	geneytik/V/Bgeneytikt [def: need (with "zikh")]
	noyt/N [f] [def: need]
	neytik/K [def: necessary] umneytik/K [def: unnecessary]
		noytik/K [def: necessary] [usage: doubtful admissibility]
		noytvendik/A [def: necessary]
			noytve'ndikayt/N [f] [def: necessity]
		geneytik/A [def: urgently]
		noytbaderfenish/N [f] [def: poverty]
		noytbaderftik/A [def: impoverished]
	neytikayt/N [f] [def: need]
neytral/K [def: neuter; neutral]
	neytralite't [f] [def: neutrality]
	neytralizi'r/V/Bneytralizi'rt [def: neutralize] 
	neytralizirung/N [f] [def: neutralization] 
neytron/N [def: neutron] 
nezir{nzyr}/Xnezirem{nzyrym}/H [m] [def: Nazirite] /Iish 
nibl{nybwl}/H [def: vulgar]
	menuvl{mnwvl}/Xmenuvolem{mnuvlym} [m] menuvlte{mnuvlte}/S [f] menuveles{mnuvlT}/N [f] [def: person or thing of low moral character]
	neveyle{nBlh}/Xneveyles{nBlwT}/H [def: corpse, carcass (animal); slut; slovenly woman]
	nevole{nBlh}/Xnevoles{nBlwT}/H [def: scandal; scandalous behavior] 
	nibl_pe'{nybwl-ph} [m] [def: pornography, vulgarity, obscenity]
	banavl{banBl}/V/Bbanavlt{banBlt} [def: sully, besmirch, denigrate]
nide{nydh} [f] [def: menstruation taboos and rituals]
	dam_nide{dm-nydh}/H [m] [def: menstrual blood]
	-/Xyemey_nide{|ymy-nydh}/H [def: menstrual days]
nider/V/T/Garop [def: descend]
	dernider/V/Bdernidert [def: descend]
	derni'derik/V/Bderni'derikt [def: lower; humiliate]
		derni'derung/N [f] derni'derikung/N [f] [def: humiliation]
	farni'derik/V/Bfarni'derikt [def: lower]
	ni'derik/K ni'deritshke/A ni'deriklekh/A [def: low, short]
	anider [def: downwards] [adv]
nifloes{nifl#wT}/H [def: miracles]
	pile{pl#y}/H peloem{plo|im}/H [def: miracle] /Idik [def: miraculous]
	nifle{nyfl#h} [adj] [def: marvelous; miraculous]
	[idiom: nisem{nsym}-venifloes{|unifl#wT} = miracles and wonders]
niglezhe [m] [def: negligée] 
nign{nygwn}/Xnigunem{nygwnym}/H [m] [def: melody]
	nigndl{nygwndl}/Xnigunemlekh{nygwnymlekh} [def: melody]
		ni'gele/Xkh [def: light tune] 
	negine{ngynh}/H [def: song]
	nign{nygwn}/V/T [def: hum] /Garoys
	menagen{mngn}/Xmenagdem{mngnym} [m] [def: song-smith; melody crafter]
	misinay_nign{msyny-nywwn}/Xmisinay_nigunem{msyny-nygwnym} [def: ancient melody]
niked{nykwd}/Xnikudes{nkwdwT}/H [m] [def: point (orthographic)]
niker{nyKr} [adj predicative] [def: clear, apparent]
nikhe{nyH#}/H [adj] [def: pleasant] 
	reyekh_nekhoyekh{ryH-nyHwH} [m] [def: pleasant aroma]
nikhne{nyxne}/Xnikhnoem{nyxno|im}/H [m] [def: subservient]
nikhpe{nyxph}/H [def: epilepsy (disease)]
	nikhpenik{nxphnik}/Ees [m] nikhpenitse{nxphnitse}/S [f] [def: epileptic person]
nikhshl{nyxSl}/H [def: trip, stumble (with "vern")]
nikhter/V/T [def: sober up] /Goys
	nikhter/A [def: sober] oysnikhterung/N [f] [def: becoming sober]
	nikhterkayt/N [f] [def: sobriety; seriousness]
nikl [m] [def: nickel (Ni); 5-cent coin (American currency)] /In
/Xnikn [def: grimaces]
nikoti'n [m] [def: nicotine (chemical)] 
nile{ne|ylh}/H [def: Neilah prayer on Yom Kippur] 
nimfe/S [f] [def: nymph] % Harduf
nimtse{nymc#}/H [def: consequently; is found]
	benimtse{bnymc#} [adj predicative] [def: available] 
	hamtsoe{hmc#h}/Xhamtsoes{hmcowT}/H [f] [def: gadget, device; creative idea, invention; joke, trick] 
		hamtsoedik{hmc#hdik}/A [def: ingenious]
			hamtsoedikayt{hmc#hdikayt}/A [def: ingenuity]
nir/N [f] [def: kidney] /D
nis/V/Bgenosn [def: sneeze] 
	tseni's/V/Btsenosn [def: sneeze loudly]
	nos/N [m] nis/N [m] [def: sneeze] 
	niseray'/N [n] [def: sneezing fit] % Sholem Aleykhem
nishe/S [f] [def: niche]
nisht nit [def: not]
	nite [def: don't (do it)]
	gornit gornisht /Iik gornishteray/N [n] nitl [def: nothing] 
		[idiom: a gornisht mit a nisht = worthless]
	nito /Iik nishto gornishto [def: not present; not existing]
		nitoikayt/N [f] [def: absence; non-existence] 
	anisht anit [def: if not]
	mernisht mernit [def: only] 
	umnisht [def: for no good reason (with "umzist un -")] 
	nishtik/A [def: unimportant] nishtikayt/N [f] [def: unimportance]
	mitnitshke/S [f] [def: seller of minor food items like flour]
	nishme'r [conj] [def: however]
	mernisht [conj] mernit [conj] [def: however] 
	mernisht [adv] mernit [adv] [def: only] 
	tsunisht [def: to nothing] 
	[idiom: makhn tsunisht = destroy]
nishter/V/T [def: look through, rummage] /Gdurkh
nishtoymem{nSWwmm}/H [def: amazed] 
	nivl_venishtoymem{nBhl-|wnSWwmm} [def: utterly amazed; afraid and confused]
nister{nsWr}/Xnistorem [m] [def: hidden holy sage]
nister{nsWr}/Xnistores [m] [def: hidden wisdom]
beseyser{bsWr}/H [def: privately] 
nitl/N [m] [def: Christmas] [origin: natal]
nits/V/T [def: use] /Goys [def: abuse; make use of (with "zikh mit")]
	/Gop [def: use up, exhaust; wear out]
	banits/V/Bbanutst [def: use, employ]
	banits/N [m] [def: use] shprakhbanits/N [def: language usage]
	i'bernits [m] [def: recycling] % Yiddish League
	nits/N [m] [def: use] /Ilekh /Iik [def: useful] 
		umnitslekh/A [def: useless]
	nuts/V/T [def: use] /Goys [def: abuse] % variant spelling
		banuts/V/Bbanutst [def: use, emply] % variant spelling
		farnuts/V/Bfarnutst [def: use]
		nuts/N [m] [def: use] /Ilekh /Iik [def: useful] % variant
			nutslekhkayt/N [f] nutsikayt/N [f] [def: utility, usefulness]
			umnutsik/A umnutslekh/A nutsloz/A [def: useless]
		ey'gnnutsik/A [def: self-absorbed, selfish] % Stutchkoff
	opnits [m] [def: wear and tear; short-term rental (often with "oyf")]
	oysnitseray'/N [n] oysnutseray'/N [n] [def: exploitation] % Leybl Botwinik
	ni'tseve/V/T /Giber [def: recycle; re-sew with sides reversed to re-use]
		li'tseve/V/T /Giber
		i'bernitseven [m] [def: recycling] % Yiddish League
		ibernitseray'/N [f] [def: recycling plant] % Yiddish League
	nitser/S [m] banitser/S [m] oysnitser/S [def: user]
	farnits/V/Bfarnitst [def: use up] 
nitses{nycwc}/H [def: sparkle]
nivets [m?] [def: waste]
	[idiom: geyn in nivets = be discarded, go to waste]
nivo/N [m] [def: level] 
niyef{ny#wf}/H [m] [def: adultery]
	noyef{nw#f}/Xnoyofem{nw#fym}/H [m] [def: adulterer; lecher]
	noy'efte{nw#fte}/S [f] [def: adulteress]
nobe'l/N [def: Nobel prize (with "premye")] 
nobe'l/A [def: noble, refined]
nobe'lyum [m] [def: nobelium (No)] 
nodl/N [f] [def: needle] /Dned 
	tsiter-nodl/N [f] [def: brooch-pin]
	za'knodl/N [f] [def: sack needle; heavy-duty needle]
	nodl/V/T [def: pierce (with dative)]
	[idiom: fun der nodl = new]
noent/A neenter/A noent|st/A [def: near] % irregular comparative/superlative
	nent|st/A [def: nearest] % variant superlative
	noentkayt/N [f] noentshaft/N [f] [def: nearness]
	nen/V/T [def: approach] gene'n/V nenter/V/T [def: approach] 
	dernenter/V/Bdernentert derneenter/V/Bderneentert [def: bring near; approach (with "zikh")]
		dernenterung/N [f] [def: approach] 
nog/V/T [def: gnaw; annoy] /Goys
noged{ngyd}/Xnegidem{ngydym}/H [m] [def: wealthy person]
	negidish{ngydish}/A [def: wealthy] 
	negidis{ngydyT} [f] negidiste{ngydyTte}/H/S [f] [def: wealthy woman] 
nogl/N [m] [def: nail] 
	naytnogl/N [m] [def: hangnail] 
	nogl/V/T /Gtsu
nokh/P [def: after; yet, still; even; more (in positive constructions only)] dernokh/P
	dernokhdem [def: afterwards] 
	azoyerernokh [adv] [def: in such a manner]
	[idiom: un nokh vi', un nokh vo's, un nokh a mi'n = exceedingly (interj)] 
	[idiom: nokh ale ha|yoyms{hywms} = too late]
nokhes_darge{nHwT-drg#} [m] [def: low-class person]
nokhesh{nHS}/Xnekhoshem{nHSym} [m] [def: snake; snake from Garden of Eden]
	nokhesh_hakadmoyni{nHS-hkdmwny} [m] [def: snake from Garden of Eden]
no'khlesik/A na'khlesik/A [def: negligent] 
	nakhlesikayt/N [f] [def: negligence]
	farnakhlesik/V/Bfarnakhlesikt [def: treat cavalierly]
nokturn/N [m] [def: nocturne (music)]
nol/N [f/m] [def: awl] 
nomad/N [m] [def: nomad] % Harduf
nomen/Xnemen [m] [def: name]
	bay'nomen/Xbay'nemen [m] [def: family name, surname]
	fo'rnomen/Xfo'rnemen [m] [def: first name, given name]
	tsunomen/Xtsunemen [m] tsune'menish/N [m] [def: nickname] 
	nominativ/A [def: nominative (grammar)] 
	nomini'r/V/Bnomini'rt [def: nominate] 
		nominatsye/S [f] [def: nomination] 
	banoment/A [def: called, titled]
	folksnomen/Xfolksnemen [m] [def: common name; vernacular name] % Stutchkoff
	ortnomen/Xerternemen [m] [def: place name, toponym]
	rufnomen/Xrufnemen [m] [def: official Jewish nam official Jewish namee]
	shtotnomen/Xshtotnemen [m] [def: city name]
	nomenloz/A [def: anonymous; unknown]
	onomastik [f] [def: study of personal names]
	nomenklatu'r/N [f] [def: nomenclature, terminology; nomenklatura, Soviet elite] % номенклату́ра
	[idiom: onrufn dos kind baym rikhtikn nomen = face reality] % Stutchkoff
none/S [f] [def: nun] no'neshaft/N [f] [def: nunnery (occupation)]
nonye/S [f] nyonye/S [f] [def: (large) nose]
nopl/N [def: umbilical cord; navel]
	opnoplung/N [f] [def: separation from mother]
	[idiom: zol dir dreyen fun nopl = may you suffer dizziness (curse)]
nor [def: but, only] 
nore/S [f] [def: lair] 
	nure/V/T [def: look deeply into] /Gayn [def: burrow into; snuggle in]
	nuredik/A [def: snug, cuddly]
norma'l/A [def: normal] /Iish [def: normal] 
	umnorma'l/A /Iish [def: abnormal] 
	paranorma'l/A [def: paranormal, supernatural] % Forwards
	norme/S [f] [def: norm] % Harduf
	normati'v/A [def: normative, prescriptive] % neologism
	normalkayt/N [f] [def: normality]
		umnormalkayt/N [f] [def: abnormality]
	normalizi'r/V/Bnormalizi'rt [def: normalize; regulate]
nosi{nQy#}/Xnesiyem{nQy#ym}/H [def: prince; ruler] 
nostalgye/S [f] [def: nostalgia] nostalgish/A [def: nostalgic] 
not/Xnet [f] [def: seam (clothing)] /Dnet
nota'r/N [m] notaryus/N [m] [def: notary] 
note/Xnotn [f] [def: musical note] 
	[idiom: shpiln on notn = play by ear] [note: V]
noti'ts/N [f] [def: notice, note (written)]  
	notatsye/S [f] [def: accusation]
	noti'r/V/Bnoti'rt [def: notate, annotate]
		farnoti'r/V/Bfarnoti'rt [def: notate, annotate]
	anotirung/N [def: annotation]
notsri{nwcry}/Xnotsrem{nwcrym}/H [m] [def: Christian]
novele/Es/Xnoveln [f] [def: novel] 
	novelistik [f] [def: novel writing] % Forwards
	noveli'st/N [m] [def: novelist]
november [m] [def: November] 
novi{nBy#}/Xneviyem{nBy#ym}/H [m] neviyete{nBy#te} [f] [def: prophet]
	/Lha{h} [noun] [m] [def: the prophet]
	neviish{nBy#ish}/A [def: prophetic] 
	neviyes{nBy#wT}/H/N [def: prophesy] 
		[idiom: neviyes{nBy#wT} zogn = prophesize]
	nevue{nBu#h}/Xnevues{nBu#wT}/H [def: prophesy]
novine/S novene/S [f] [def: rare occasion; new thing] 
	inovatsye/S [f] [def: innovation]
		inovator/N [m] novato'r/N [m] [def: innovator] /Iish
novobranyets/Xnovobrantses [m] [def: recruit]
noy [f] [def: decorations]
noye/V/T [def: ache; gnaw; haunt (feelings)] 
noyfl{nwfl}/Xnoyflem{nwflym}/H [def: fall (with "zayn")] 
	nefile{nfylh}/Xnefiles{nfylwT}/H [f] [def: downfall] 
noyre{nwr#}/H [def: wondrous] 
noyte{nwth}/H [def: incline (with "zayn")] 
	netiye{ntyh}/Xnetiyes{ntywT}/H [def: inclination] 
	[idiom: noyte{nwth} l|moves{mwT} = near death]
noz/Xnez/Xnezer [f] [def: nose] /Dnez /Iik [def: nasal]
	nezl/Eekh [def: nozzle]
	nozdre/S [def: nostril] 
	roytnozik/A [def: red-nosed] % Forwards: M-S Hoffman
	karnose/A kurnose/A [def: pug-nosed]
	noske/S [f] [def: toe (shoe)]
	[idiom: arayn emetsn in der noz = well remembered by someone]
	[idiom: aroplozn di noz = feel dejected]
nu anu [interj] [def: well then] 
	anu/Een [m] [def: challenge] 
	[idiom: anu, pruv nor = just try; I dare you]
nudne/K [def: boring] /Idik [def: queasy] 
	nudnik/Ees [m] nu'dnitse/S [n] [def: boring person] 
	nudye/V/T nudzhe/V/T nude/V/T [def: bother, annoy; bore] 
	farnudye/V/Bfarnudyet [def: bore]
	nudote [f] [def: boredom] 
nu'kleus/N [m?] [def: nucleus]
	nuklea'l/A [def: nuclear] % Forwards: Estraykh
	nuklea'r/A [def: nuclear] % Forwards: B. Sandler
		termonuklea'r/A [def: thermonuclear] % Forwards: Yoel Matveyev
nul/N [m] [def: zero, null] 
	anuli'r/V/Banuli'rt [def: annul, nullify] 
	anulirung/N [f] [def: annulment, nullification] 
numer/N [m] [def: number; issue (journal)] /Iish
	numeri'r/V/Bnumeri'rt [def: enumerate] 
	numerator/N [m] [def: calculator] 
	fli'numer/N [m] [def: flight number] [note: V]
	ha'rbstnumer/N [m] [def: Autumn issue] % Forwards: I. Gottesman
	shlu'snumer/N [m] [def: closing number (concert)] 
	[idiom: tsugob-numer = addend]
	[idiom: ershter numer = opening number (concert)]
nun_{nʼ}/H [m/f] [def: Hebrew letter Nun] 
nun [adv] [def: suddenly; now]
nus/Xnis [m] /Dnis [def: nut; nit (insect egg); jacks (in plural: game)]
	brazil/A [def: brazil nut (with "nus")] % Forwards: Hershl Glaser
	khazer{Hzyr}-nisl/Eekh [n] [def: acorn] 
	knaknisl/Eekh [n] [def: nutcracker]
	hozlnus/Xhozlnis hoznus/Xhoznis hoznnus/Xhoznnis [m] [def: hazlnut]
		hozish/A [def: hazlnut (with "nus")]
	mu'shkatnus/Xmu'shkatnis [m] [def: nutmeg seed (spice)]
	peka'nnus/Xpeka'nnis [m] [def: pecan (nut, food)]
	[idiom: ruf im knaknisl = you can't hurt him]
	[idiom: velshene (veltshene, velishe, vilshene) nis = butternut (?)] % Stutchkoff
nusekh{nwsH}/Xnuskhoes{nwsHowT}/H [m] [def: version; style; edition] 
nutrikn{nwtrikwn}/S [m] [def: method of textual interpretation taking each letter as an abbreviation (mystic)]
nyavke/V/T [def: meow (sound of a cat)]
nyanye/S [f] nyanke/S [f] [def: babysitter, nanny, governess]
	nyantshe/V/T [def: babysit]
nyerakhe/S [f] [def: filthy person]
nyezheli [conj] [def: than, rather than (Russian нежели "than")] 
nyobyum [m] [def: niobium (Nb)] 
nyuans/N [m] [def: nuance]
nyukhe/V/T [def: sniff] /Gayn
	nyukh/N [m] [def: sniff]
nyunkele/Xkh [n] [def: helpless person]
o [interj] [def: oh! expression of dismay] 
o [article] [def: particular, as in "der-o", "di-o"]
o/Een [m] [def: the letter O] 
oazis/N [m] [def: oasis]
o'bdirik/Xo'bdirkes [m] o'dirke/S [f] [def: carcass, pre-cooked meat (poultry)]
obedye [noun] [def: a particular Russian Orthodox service] 
ober [def: but] 
obidye/V/Bobidyet [def: insult] % Mendele
oblave/S [f] [def: police raid; search (Russian облава)] 
obligatsye/S [f] [def: obligation; bond (financial)]
	obligatorish/A [def: obligatory] 
	obligato [adv] [def: obligato (music)] % Stutchkoff
observi'r/V/Bobservi'rt [def: observe]
	observator/N [m] [def: observer]
	observatsye/S [f] [def: observation] 
obsesye/S [f] [def: obsession] % Forwards: Sholem Berger
obshtshestve [def: society, common folk (Russian обществе)] /In
obstetrik [f] [def: obstetrics (medicine)]
obyave/V/T [def: announce; inform]
obyekt/N [m] [def: object] /Iiv [def: objective (grammar)] 
odekolon [noun] [def: eau de cologne (perfume)] 
odem{odm}/H [def: person, Adam] 
oder/N/D [f] [def: vein] /Idik
	eder/V/T [def: irk, annoy, vex, exasperate]
	[idiom: shlogn/lozn oder = let blood (as a cure)]
	[idiom: shlogt zikh an oder = the pulse beats]
	[idiom: trenen di odern = vex, exasperate]
	[idiom: gildn oder = gildene oder = hemorrhoids]
	[idiom: trenen di odern = cut to pieces, give a hard time to someone]
oder [def: or] 
odler/S [m] [def: eagle (bird); horse (balegole-loshn)] 
o'dlige/S [f] [def: ice melt; thaw]
odn{odwn}/Xadoynem{adwnym} [m] [def: mister, lord, rich person (usually non-Jewish)]
of{ewf}/Xoyfes{ewfwT}/H [n] [def: bird, chicken]
	eyfele{ewfele}/Xeyfelekh{ewfelekh} [def: infant] 
		eyflvayz{ewflvayz} [adv] [def: during infancy] % Michael Wex
		ey'flshaft{ewflshaft}/N [f] [def: infancy] [usage: neologism] 
ofensiv/A [def: offensive] 
	ofensive/S [f] [def: offensive] 
ofits'ir/N [m] [def: officer] /D ofitsirshe/S [f] [def: officer's wife]
ofitsye'l/A [def: official]
	umofitsye'l/A [def: unofficial; unauthorized]
	ofis/N [m] [def: office (English)] 
oft/K [def: frequent; rife]
	oft [adv] oftlekh [adv] [def: often] 
	efter efters [adv] [def: quite often]
	[idiom: oft mol = frequently]
oger/S [m] [def: stallion (male horse)]
oydef{ewdf} [m] [def: excess, surplus] 
oyel{#whl}/Xoyolem{#whlym} [m] [def: monument over a grave]
oyfn_{#wfn}/H oyfanem{#wfnym}/H [def: method, manner]
	beeyn_oyfn{b#yn #wfn} [adv] [def: in no manner] [usage: in negative sentences]
oyneg{eung} [m] [def: enjoyment] 
oynesh{eunS} [m] [def: punishment] 
okazye/S [f] [def: occasion (time)]
oke/S [f] [def: measure of weight (Ukrainian)]
oke/S [f] [def: a card game] /D
okea'n/N [m] okyones{#wkynus} [m] [def: ocean]
okevi't [m?] [def: distilled alcoholic spirits]
okh [def: woe (okh un vey)] 
	okhts/V/T [def: groan, sigh]
		o'khtsenish/N [n] [def: groan]
okher{oHwr}/S [m] [def: rear, behind, hindpart; buttocks] [usage: impolite]
okhlyap/Ees okhlap/Ees [m] [def: offal; glutton; criminal; slap]
	okhlyapeve/V/Bokhlyapevet [def: eat gluttonously] % Forwards: M-S Hoffman
okhre/S [f] oker [m?] [def: ochre]
oko'litse/S [f] [def: region, district]
okoleshke/S [f] [def: candy; trinket (Russian околешки)] % Sholem Aleykhem
okuli'st/N [m] [def: oculist, optometrist]
okope/S [f] oko'p/Ees [m] akope/S [f] [def: trench]
okrent/N [m] [def: ship]
okril [m?] [def: bread (klezmer-loshn)]
okrop [m] okrep [m] [def: boiled/boiling water] 
oks/N [m] [def: ox] /Ien /Deks
oksidi'r/V/Boksidi'rt [def: oxidate (chemistry)]
	oksidirung/N [f] [def: oxidation (chemistry)]
	oksid [m?] [def: oxide (chemical)]
oksimoron/N [m] [def: oxymoron (rhetoric)]
oktave/S [f] [def: octave (music)]
	[idiom: oyf der hekhster oktave = as loudly as possible]
oktober [m] [def: October] 
oktopus [m] [def: octopus (marine animal)]
okulti'zm/N [m] [def: occultism, spiritism]
	okulti'st/N [m] [def: occultist, spiritist]
okun/Xyes [m] [def: perch (fish)] [usage: northern Yiddish]
okupi'r/V/Bokupi'rt [def: occupy]
	okupa'nt/N [m] [def: occupant] 
	okupatsye/S [f] [def: occupation] 
ol{ewl}/H [m] [def: yoke] 
oleander/S [m] [def: oleander (Nerium oleander) (plant)]
olel{elwl}/H [adj] [def: capable of (with "tsu")] [grammar: indeclinable, predicative]
oliga'rkh/N [m] [def: oligarch] /Iish
	oligarkhye/S [f] [def: oligarchy]
olimpyade/S [f] [def: Olympic games]
	olimpish/A [def: Olympic; stoic] 
oli'v/N [m] olivke/S [def: olive (fruit)]
olov{elyw}/H [def: on him] oleynu{elynw}/H [def: on us] 
olrayt [adv] [def: all right, OK] [usage: Americanism]
	olraytnik/Ees [m] olray'tnitshke/S [f] [def: successful person] [usage: humorous] % Sholem Aleykhem
olshene/S [f] [def: Alder (tree, Alnus spp.)]
omed{emwd}/H [def: podium] /D
	[idiom: davnen farn omed{emwd} = lead congregational prayers]
omeyn{omn}/H [interj] [def: amen: expression of pious agreement] 
omnibus/N [m?] [def: bus, omnibus]
on/P onet [adv] [def: without, upon (as separable part of verb)] 
	[idiom: a tson on a tson = one tooth against another]
onani'r/V/Bonani'rt [def: masturbate]
	onani'zm/N [m] [def: onanism, masturbation, auto-eroticism]
	mayse_oynen{meQh-#wnn} [f] [def: masturbation]
onerken/V/T [def: respect] 
ones{anws}/Xanusem{anwsym}/H [def: forced convert from Judaism] 
	meanes{mans} [verb] [def: force, rape (with "zayn")]
onetshe/S [f] [def: socks tied to feet] % Der Nister
o'ngepikevet/A [def: chock-full of (with "mit")] 
ongeshnyokert/A [def: tipsy, drunk] 
ongezolyet/A [def: ill at ease] % no base verb
onkl [m] [def: Uncle] [usage: inadmissible]
onlayn [adj] [def: on-line] [grammar: indeclinable]
o'nkreytik/A [def: tender, sensitive; touchy; prone to illness]
onmut/V/Bongemut [def: suggest; request] % no base verb.  ?? participle
	onmut/N [m] [def: suggestion; request]
	[idiom: far an onmut kumt nit keyn patsh = you can't blame someone for trying]
onov{env}/Xanovem{envym}/H [m] [def: modest person] 
	anives{enyvT}/H [f?] [def: humility] /Idik
	anove{envh} [f?] [def: humility]
	oni{eny}/Xoniyem{enyym} [m] onite{enyte}/Xonites{enytes} [f] [def: poor person]
onver/V/Bongevoyrn/Bongevorn [def: lose, forfeit] 
	onver [m] [def: loss]
op [prep] opet [adv] [def: finishing; up (as separable part of verb)] 
opa'l/N [m] [def: opal (mineral)]
opeku'n/N [m] [def: guardian (legal)] 
opere/S [f] [def: opera] operete/S [f] [def: operetta] 
operi'r/V/Boperi'rt [def: operate (machinery); conduct surgery]
	operatsye/S [f] [def: operation] 
	[idiom: durkhmakhn an operatsye = undergo surgery]
	operativ/A [def: functional, operational] 
o'pgekhoymlt/A [def: shabby] 
opone'nt/N [m] [def: opponent]
opore/V/T [def: finish off, unload (with "zikh")] % Mendele
opozitsye/S [f] [def: opposition] opozitsyone'l/A [def: contrary; antagonistic]
	opozitsyone'r/N [m] [def: opposition member] % Forwards
opshay [m] [def: respect] 
optimistish/A [def: optimistic]
	optimi'st/N [m] [def: optimist] 
	optimi'zm/N [m] [def: optimism] 
o'ptrinik/A [def: dissident] 
optsa's/N [m] [def: heel of shoe (clothing)]
optsye/S [f] [def: option] 
opyekun [m] [def: guard, caretaker (Polish opiekun)] % Avrom Karpinovitsh
or{#wr}/H [m] [def: light] 
oranzh/N [m?] [def: orange (fruit)]
	oranzherye/S [def: greenhouse]
	oranzh/A /In [def: orange color] 
orator/N [m] [def: orator] /Iish
	oratorye/S [f] [def: oratorio (music); oratory]
orbi't/N [m] [def: orbit] 
	orbiti'r/V/Borbiti'rt [def: orbit] /Garum
ordn/V/T [def: set in order] /Gayn
	farordn/V/Bfarordnt [def: command, order] [usage: doubtful admissibility] % Forwards
	o'rdenung/N [f] aynordenung/N [f] farordenung/N [f] [def: order, command]
	umo'rdenung/N [f] [def: disorder]
	ordn/S [m] [def: order (organization), medal] 
	o'rdener/S [m] [def: usher] 
	ordntlekh/A [def: systematic]
		oyserordntlekh/A [def: irregular] % Forwards: Moshe Lemster
ordinarye/S [f] [def: supplies, provisions]
orginizatsye/S [f] [def: organization]
oreo'l [m?] [def: corona, halo]
orem/K [def: poor]
	farorem/V/Bfaroremt [def: impoverish]
		faroremung/N [f] [def: impoverishment] 
	oreman [m] [def: pauper] /Iske
	oremkayt/N [f] oremshaft/N [f] [def: poverty] 
	ordina'r/A ordine'r/A [def: ordinary, customary, conventional]
orem/S [m] [def: arm (body part)]
	fangorem/S [m] [def: tentacle]
orev{erB}/Xorvem{erBym}/Xareyvem{erBym} [def: guarantor; sponsor] 
	orev{erB} [verb] [def: guarantee, be responsible (with "zayn")] 
	orev{erB}/V/T [def: guarantee (with "zikh")] % Bergelson
	o'revnik{erBnik}/Ees [def: hostage] % Forwards, Niborski
	orves{erBwT}/N [n] [def: guarantee; bail]
orga'n/N [m] [def: organ (biological)] /Iish [def: organic] 
	umorganish/A [def: inorganic]
	o'temorga'n/N [m] [def: breathing organ] 
organizatsye/S [f] [def: organization]
	organizi'r/V/Borganizi'rt [def: organize]
		organizirung/N [f] [def: organization (act)] 
		teke-organizirke/S [f] [def: directory (computer)] [note: V]
	organi'zato'r/N [m] [def: organizer] /Iish organi'zato'rin/S [f]
	reorganizi'r/V/Breorganizi'rt [def: reorganize]
		reorganizatsye/S [f] [def: reorganization] 
	organi'zm/N [m] [def: organism] 
	orga'n/N [m?] [def: government institution]
		ma'khtorga'n/N [m?] [def: government institution]
orgl/N [m] [def: musical organ]
	drey'orgl/N [m] [def: hand organ]
	ga'sorgl/N [m] [def: hand organ; barrel organ]
orgye/S [f] [def: orgy, bacchanalia]
origa'n [m?] [def: oregano (herb)] % M. Schaechter: geviksn
original/N [m] [def: master copy] 
	origine'l/A [def: original] originelkayt/N [f] [def: originality] 
orkester/S [m] [def: orchestra] 
orl{erl}/Xareylem{erlym}/H [def: uncircumcised; non-Jew]
	areyles{erlyT}/N [f] orlte{erlte}/S [f] [def: non-Jewish woman]
	orle{erlh}/Xorles{erlwT} [f] [def: foreskin]
	[idiom: der orl{erl} meyven{mByn} kol{Kl} diber{dybwr} = The non-Jew understands Yiddish]
orn{orwn}/Xaroynes{arunwT}/H [m] [def: ark (cabinet for Torah scroll); coffin, casket (Jewish)] 
	orn_koydesh{orwn-kwdS} [m] [def: ark (cabinet for Torah scroll)] 
orntlekh/A [def: honest, in good faith] 
	orntlekhkayt/N [f] [def: honesty, good faith]
	umorntlekh/A [def: dishonest, in bad faith] 
	umo'rntlekhkayt/N [f] [def: dishonesty, bad faith] 
ort/Xerter [n] [def: place; position] /Iik /Dert
	ekranort/Xekranerter [n] [def: desktop (computer)] [note: V]
	parkirort/Xparkirerter [n] [def: parking place] 
	shmuesort/Xshmueserter [n] [def: chat room] [note: V]
	vaserort/Xvasererter [n] [def: wetland] 
	voynort/Xvoynerter [n] [def: habitation] 
	zitsort/Xzitserter [n] [def: seat] 
	eynartik/A [def: unique] [usage: inadmissible]
	eygnart [def: individuality] /Iik [def: individual; idiosyncratic]
		eygnartikayt/N [f] [def: individuality; uniqueness]
	farsheydnartik/A farshidnartik/A [def: multi-faceted] [usage: inadmissible]
	ertervayz [adv] [def: in places] 
	ortshaft/N [f] [def: neighborhood]
	[idiom: dos gute ort = cemetery (euphamism)]
ortodoks/A [def: orthodox] /Iish
	ortodoksishkayt/N [f] [def: orthodoxy] % Forwards
	ortodoksye/S [def: orthodoxy]
ortografye/S [f] [def: orthography]
	ortografish/A [def: orthographic] 
ortshik/Ees [m] [def: drawbar of a wagon]
oryent [m?] [def: Orient] /Ialish
	oryentali'st/N [m] [def: orientalist]
		orientalistik [f] [def: orientalism (subject)] 
oryenti'r/V/Borienti'rt [def: orient]
	orientirung/N [f] oryentatsye/S [f] [def: orientation] 
os{#wT}/H oysyes{wTywT}/H [def: letter of alphabet] 
	-/Xoysyeslekh{wTywTlekh} [def: little letters]
	[idiom: kidesh_levone{kidwS-lBnh} oysyes{#wTywT} = large lettering]
osed{eTyd} [m] [def: future] 
oshamnu{eSmnw}/H [def: penitential prayer vidui] 
osine/S [f] [def: aspen (tree: Populus spp.)]
	osinove/A [def: of aspen]
osobe/S [f] [def: personage]
osteoporo'z [m?] [def: osteoporosis (disease)] % Forwards: S-R Schaechter
osyen [m] [def: Autumn (season)] /Idik
ot [adv] [def: here; this very; just now] 
	oto [adv] [def: right here]
	[idiom: ot-ot = any minute now]
otem/V/T [def: breathe] /Gayn/Gop
	etem/V/T [def: breathe] /Gayn/Gop % variant spelling
	otem/N [m] [def: breath] /Idik 
otizne/S [f] otizdne/S [f] atezne/S [f] otyezne/S [f] otyezdne/S [f] [def: gift upon departing]
	nadizne/S [f] 
otoman/N [m] otomane/S [f] [def: sofa (furniture)] 
otryad/N [m?] [def: military cohort]
otshene/S [f] [def: flower of indoor plant] 
otshiske/S [f] [def: scabies (disease)]
ov{oB}/Xoves{oBwT}/H [m] [def: father; ancestor]
	ovesdik{oBwTdik}/A [def: ancestral] % Berish Goldstein
	ovinu{oBynw}/H [def: our father]
	avoyseynu{aBwTynw}/H [def: our ancestors] 
	keyver_oves{kBr-oBwT}/N [m] [def: parental graves]
	zkhus_oves{zxuT-oBwT}/N [f] [def: inherited merit]
ova' [interj] [def: wow! (positive or negative)]
ova'l/N [m] [def: oval] /A
ovatsye/S [f] [def: ovation] 
over{eBr}/H/S [m] [def: (time) past] 
ovir/V/Bovirt [def: woo; cultivate; attend]
	ovirung/N [f] [def: attentions; acts of kindness]
ovl{oBl}/Xaveylem{aBlym}/H [m] [def: mourner] ovlte{oBlte}/S [f] [def: mourner]
	aveyles{aBlwT} [n] [def: mourning] 
	menakhem_ovl{mnHm-oBl} [verb] [def: comfort a mourner (with "zayn")]
ovn{evn}/Xavoynes{evnwT}/H [m] [def: sin] [usage: singular form is rare]
ovnt/N/D [m] [def: evening] /Iik
oy [interj] [def: woe! expression of pain or wonder] 
oyb [def: if]
oybn [adv] oybns [noun] [def: above]
	oybnon [adv] [def: at the head of the table; in a position of honor] 
	oyber- [prefix] [def: chief]
	oybnoyfik/A [def: superficial, shallow]
oyps [n] oybs [n] [def: fruit (collective noun)]
oyditorye/S [f] [def: listening public; auditorium] 
	oyditoryum/S [f] [def: auditorium] 
oyditsye/S [f] [def: audition; radio program]
oyer/N/D [m] [def: ear (body part)] 
	[idiom: untershteln an oyer = eavesdrop]
oyf/P af{Of}/P [def: on]
	oyfn afn{Ofn} [def: on the]
	deroyf [adv] [def: above] 
	aderoyf/N [m] [def: financial advance]
	oybnoyf{oybn#oyfik}/A [def: on the surface] /Iik
	oyf [adj predicative] [def: awake]
oyg/N /Deyg /Doyg [n] [def: eye (body part)] /Iik
	hinteroygik{hinter#oygik}/A [def: secret]
	-/Xoy'genes -/Xoy'ganes [def: beautiful eyes]
	[idiom: khaneles eygelekh{Hnlhs eygelekh} = wild pansy (flower; Viola tricolor)]
	[idiom: blut-farlofene oygn = bloodshot eyes] % I. J. Singer
	[idiom: fardreyen di oygn = roll one's eyes] [note: V]
	[idiom: fargleyzn di oygn oyf = stare at]
	[idiom: ful vi an oyg = ful mitn oyg = ful bizn oyg = overflowing]
	[idiom: gut oyg = beyz oyg = evil eye]
	[idiom: haltn ofn di oygn (far) = keep an eye out (for)] [note: V] 
	[idiom: haltn oyfn oyg = keep track of]
	[idiom: oyfn oyg = approximating, eyeballing]
	[idiom: kukn mit glezerne oygn = be blind to the faults of someone]
	[idiom: kukn mit milkhike oygn = look adoringly]
	[idiom: oyg oyf oyg = in close proximity]
	[idiom: zikh varfn in di oygn = be obvious, be visible]
	[idiom: hinter di oygn = hidden, secret]
oygust [m] [def: August] 
oykets{ewkc}/H [m] [def: small amount; sharp jest] % Shpiglblat: jest
oykh [adv] oykhet [adv] [def: also] 
oyle{e|wlh}/Xoylim{ewlym}/H [def: immigrant to Israel] 
oylem{ewlm}/Xoylomes{ewlmwT}/H [m] [def: world; eternity; congregation]
	/Lho{h} [noun] [m] [def: world] /Lbo{b} [adv] [def: in the world]
	/Lmey{m} [adv] [def: from everlasting]
	leoylem{lewlm} [def: for ever; after all; actually] 
	besoylem{byT-ewlm}/S/H [m/n] besalmin{byT-elmyn}/H [m/n] [def: cemetery] 
	oylem_hoatsiles{ewlm-hacilwT} [m] [def: world of Divine emanation (mystic)]
	marish_oylem{mreiS-ewlm} [verb] [def: be amazing (with "zayn")]
	[idiom: shay{S″y} oylomes{ewlmwT} = 310 worlds: reward for a righteous person] % M. Uktsim 3:12
oymer{ewmr} [m] [def: 50-day period between peysekh and shvues] 
oyps/N [n] [def: fruit]
oyrekh{#wrH}/Xorkhem{#wrHym}/H [m] [def: guest; visitor]
	orkhe_porkhe{orHy-prHy}/X [m] [def: wanderer; beggar; bum, tramp, vagabond]
	hakhnoses_orkhem{hxnsT-#wrHym} [f] [def: hospitality]
oys [adv] oyset [adv] [def: out; because of] oyset [interj] [def: gone]
	oysn [adj predicative] [def: intending] 
	[idiom: nit in dem bin ikh oysn = that's not my point (often ironic)]
	oyser/P [def: except for] /Ilekh [def: external] 
		[idiom: oyser zikh = beside oneself]
	deroys [adv] [def: out from there] 
	lengoys{leng#oys}/P [def: along]
	droysn [def: outdoors; outside] /Idik
		droysn/S [m] [def: exterior] 
			indroysn [def: outside] /Idik
		droysik/A [def: exterior]
	oysterlish/A [def: exceptional; bizarre; mysterious] 
	oysern [adj] [def: foreign] % uninflected, as in "oysern minister" 
	oyserlekh/A [def: outdoors] [usage: not recommended]
		oyserlekhkayt/N [f] [def: outdoors quality] [usage: not recommended]
	[idiom: (epes) leng oys = the length of (something)]
oysgefyokevet/A [def: dolled up] 
oysher{ewSr}/H [m] ashir{eSyr}/Xashirem{eSyrym} [m] [def: rich person]
	ashires{eSyrwT}/H [n] [def: wealth]
	nisasher{nTeSr} [verb] [def: become wealthy (with "vern")] 
oyster/S [m] [def: oyster (shellfish)]
oytentish/A [def: authentic] 
oyto/S [m] [def: auto] oytomobil/N avtomobil/N [m] 
	la'stoyto/S [m] [def: truck, lorry]
	sha'royto/S [m] shney-sharoyto/S [m] [def: snow plow (vehicle)] [note: V]
oytobus/N [m] [def: bus] 
oytoklav/N [m] [def: autoclave (sterilizing device)] 
oytomatish/A [def: automatic] 
	oytoma't/N [m] avtoma't/N[def: machine gun; cafeteria] 
		gelt-oytoma't/N [m] [def: automated teller machine (ATM)] % Yiddish League
oytonomye/S [f] [def: autonomy]
	oytono'm/A [def: independent (political); autonomic (anatomy)]
	/Iish [def: independent (political)] % Forwards: Yoel Matveyev
oytor/N [m] [def: author] 
	oytorite't/N [f] [def: authority] /Iish /Ine [def: authoritative] 
	oytorizatsye/S [f] oytorizirung/N [f] [def: authorization, permission]
	oytorizi'rt/A [def: authorized, permitted]
oytser{#wcr}/Xoytsres{#wcrwT}/H [m] [def: treasure] 
	oy'tserer{#wcrer}/S [m] [def: treasurer] [usage: neologism]
oyver{ewBr}/H [verb] [def: violate; sin (with "zayn (oyf)"]
	oyver{ewBr}/Xoyvrem{ewBrym} [m] [def: transgressor]
	mayver{meByr} [verb] [def: depose (with "zayn"); review text (with "zayn"); tempt to violate (with "zayn oyf"); cross over (with "zayn")]
	abaryen{ebrywn}/Xabaryonem{ebrynym} [m] [def: sinner]
	[idiom: oyver{ewBr}-botl{btl} = senile]
oyvn/S [m] [def: oven] /Deyv /Doyvnd
	ba'koyvn [def: baking oven] /Dbakeyv
	bro'toyvn{brot#oyvn}/S [m] [def: broiler] 
	kakhl-oyvn/S [m] [def: furnace; heating oven]
	ka'lkhoyvn{kalkh#oyvn}/S [m] [def: lime kiln]
	mi'krooy'vn{mikro#oyvn}/S [m] [def: microwave oven] 
	vantoy'vn{vant#oyvn}/S [m] [def: fireplace (between two rooms)]
	hinteroyvndik{hinter#oyvndik}/A [def: behind the oven] % Kulbak: Zelmenyaner
ozere/S [f] [def: lake] 
-/Xo'zhenes [def: blackberry; dewberry (fruit)]
ozmyum [m] [def: osmium (Os)] 
pade/V/T [def: fawn on, woo; philander; bustle about] /Garum
	pa'dkeve/V/T [def: bustle about] /Garum % Sholem Aleykhem
paga'n/N [m] [def: pagan] /Iish paganer/X
padle/S [f] [def: carrion]
pagone/S [f] [def: epaulet (ornament on clothing)]
pak/V/T [def: pack; catch] /Gayn/Gon/Goys/Garayn/Gtsunoyf
	pa'keve/V/T [def: pack] /Gayn
		tsepa'keve/V/Btsepa'kevet [def: unpack] % Forwards: Boris Sandler
	pekl/V/T /Gavek [def: pack]
		/Garayn [def: pack] 
		/Gariber/Giber [def: move (with "zikh")]
	farpak/V/Bfarpakt [def: pack] 
	pak/N/Xpek [m] /Dpek gepek [def: pack]
		sanitar-pekl/Eekh [def: first-aid kit] [note: V]
		pasik-pekl/Eekh [n] [def: fanny pack] [note: V] 
pake't/N [m] [def: parcel, package]
pakhozhe/A [def: similar to (with "oyf")]
pakhed{pHd}/Xpekhodem{pHdym}/H [m] [def: fear, terror] 
	pakhdones{pHdnwT}/H [n] [def: timidity; cowardice] /Idik [def: timid] 
	pakhdonish{pHdnish}/A [def: timid; cowardly] 
	pakhdn{pHdn}/Xpakhdonem{pHdnym}/H [m] pakhdnke{pHdnke}/S [f] [def: timid person, coward]
pakhter/S [m] [def: leaseholder (Jewish); tax farmer] 
	likhtpakhter/S [m] [def: candle-tax collector] 
	farpakht/V/Bfarpakhtn [def: lend]
paklade/S [f] [def: bedspread] % Stutchkoff
pakt/N [m] [def: agreement, compact, pact] 
	kompa'kt/N [m] [def: agreement, compact] 
pakhve/S [f] [def: armpit] /D
	[idiom: (baysn) vi a loyz in pakhve = be vicious]
palate/S [f] [def: hospital ward] 
pa'lats/Xpala'tsn [m] [def: palace] 
palge/S [m] palgu'ts [m] [def: unworkmanlike tailor]
pale'nt [m?] [def: a kind of game played with a stick ??] % Stutchkoff
palitre/S [f] [def: palette]
palm/N palme/S[f] [def: palm (tree)] 
	shtekhpalme/S [f] [def: holly (tree)] 
paltn/S [m] palto/S [m] [def: overcoat (clothing)] 
palumesik/Ees [m] [def: tureen, serving dish, platter]
palyati'v/N [m] [def: palliative]
palye/V/T [def: flame, burn]
	tsepalye/V/Btsepalyet [def: flame] % Forwards: Boris Sandler
	farpalyet/A [def: flaming; busily occupied]
pamelekh/A /Ilekh [def: slow] /Iink
	farpamelekh/V/Bfarpamelekht [def: slow down, slacken pace] 
pamalye_shel_mayle{pmly#-Sl-melh}/H [def: God and angels, heavenly host] 
pamfle't/N [m] [def: pamphlet] 
pa'mpushke/S [f] pa'mpeshke/S [f] [def: fried cake, fritter]
pan [def: Mister (Polish)] pani [def: Mrs.] 
	panski [adj] [def: of the nobility] [grammar: indeclinable]
	panibrat [adj predicative] [def: good buddy] [grammar: indeclinable]
		zapanibrat [adj predicative] [def: on familiar terms]
	yashne-panye [def: Your Excellency (Polish, slightly ironic)] 
	panish/A panske/A [adj] [def: relating to nobility] 
	panitsh/Ees [m] [def: young lord] /D
	panyenke/S [f] [def: maiden (noble)]
pa'name/S [f] [def: Panama hat (clothing)] % Sholem Aleykhem
panatsee/S [f] [def: panacea] % Forwards: Sholem Berger
panel [m?] [def: panel (construction); panel (committee)] % Forwards: S-R Schaechter (committee)
panik [f] [def: panic] 
panorame/S [f] [def: panorame] 
panshtshizne [f] [def: feudalism]
pansyo'n/N [m] [def: boarding house] 
	pansyona't [m] [def: boarding house] % B. Sandler: Karolina-Bugaz
panteo'n/N [m] [def: Pantheon (building); pantheon]
panter/N [m] [def: panther (animal)] 
pantofl/Eekh [n] [def: slipper]
pantomim [f] pantomime/S [def: pantomime] /Iik
pantser/V/T [def: armor-plate]
	bapantser/V/Bbapantsert [def: armor] 
	farpantser/V/Bfarpantsert [def: armor] 
	pantser [m] [def: armor]
pantsher/S [m] [def: flat tire; puncture] 
pap [m] [def: pulp; paste]
papa papashe [m] [def: father]
papakhe/S [f] [def: round fur hat (clothing)] 
pape/S [f] [def: pap, infant's food]
papke/S [f] [def: folder (paper, computer)] 
	hoyptpapke/S [f] tekepapke/S [f] [def: directory (computer)] [note: V]
papi'r/N/D [n] [def: paper (material)] /Ien
	asher_yotser_papi'r{aSr-ycr-papir}/N [n] [def: toilet paper]
	bibule-papi'r/N [n] babule-paper/N [n] [def: cigarette paper; blotting paper]
	gloz-papi'r/N [n] [def: sandpaper]
	goldpapi'r/N [n] [def: gold-colored wrapping paper] % Forwards: M-S Hoffman
	kloze't-papi'r/N [n] [def: toilet paper]
	papiro's-papi'r/N [n] [def: cigarette paper]
	reykher-papi'r/N [n] [def: cigarette paper]
	royznpapi'r/N [n] [def: rose-scented (??) paper] % Sholem Aleykhem
	shmergl-papi'r/N [n] [def: sandpaper]
	tuale't-papi'r/N [n] [def: toilet paper]
	zay'dpapir/N [n] [def: tissue paper]
	zilberpapi'r/N [n] [def: silvered paper] 
	papiro's/N [m] [def: cigarette] /D /Dpapires
		papirosnik/S [m] [def: cigarette seller or user] 
papirovke/S [f] [def: green apple variety (Polish papierówka)]
papo'rt [m?] [def: bracken (genus Pteridium of ferns)]
	paporotnik/Ees [m] [def: fern]
paprike [f] [def: paprika (spice)]
papshoy/Ees [m] [def: corn (ear of)]  
para'd/N [m] parade/S [def: parade; fanfare] /Iparadn
paradke/S [def: decree, order (Russian)] 
parado'ks/N [m] [def: paradox] /Iish/Ia'l
parafra'z/N [m] [def: paraphrase] % Harduf
	parafrazi'r/V/Bparafrazi'rt [def: paraphrase] % Harduf
parafye/S [f] [def: parish, ecclesiastical region]
paragra'f/N [m] [def: paragraph] 
parale'l/A [def: parallel]
	paraleli'zm/N [m] [def: paralelism] 
parali'z [m] [def: paralysis] 
	paralizi'r/V/Bparalizi'rt [def: paralyze] 
	kinder-parali'z [m] [def: polio (disease)] % Sholem Asch: Ist River
paranoye{parano|ye}/S [f] [def: paranoia] 
	paranoish/A [def: paranoid]
parape't [m?] [def: parapet, railing]
parashu't/N [m] [def: parachute] % Harduf
	parashuti'st/N [m] [def: parachutist] 
parava'n [m?] [def: screen, bed-netting]
parazi't/N [m] [def: parasite] /Iish
	pariziti'zm/N [m] [def: parasitism]
pardes{prds}/Xpardeysem{prdsym} [m] [def: fruit garden, paradise (mystic)] 
pardo'n [interj] [def: excuse me; good morning (French)] % Stutchkoff
pare/S [f] [def: steam] /Idik
	pare/V/T [def: steam; cook meat] /Goys/Gdurkh
		tsepare/V/Btseparet [def: steam]
	farpare/V/Bfarparet [def: steam; prepare tea]
		farparekhts/N [n] [def: tea leaves] % Yiddish League
	parove [adj] [def: steam-powered] [grammar: undeclined]
		parokho'd/N/D [def: steam boat] 
		parovo'z/N [m] [def: steam locomotive] % Forwards: Yoel Matveyev
	[idiom: onnemen pare = get underway]
parekh/Ees parkh/Ees [def: scalp canker, mange, scab (disease); nasty person] 
	parkehvate/A [def: scabby, scabrous] 
pare'ntsh/N [m] parentshe/S [f] [def: railing; back of a chair]
pareve/A [def: neutral; neither milk nor meat (food)]
parfumi'r/V/Bparfumi'rt [def: perfume] 
	parfum/N [m] [def: perfume] 
park/N [m] [def: park] 
	park/V/T [def: park (a vehicle)] % Harduf
		parki'r/V/Bparki'rt [def: park (a vehicle)]
	zoopark/N [m] [def: zoo] % Forwards: B. Sandler
parkan/Ees [m] parkn/S [m?] [def: fence] 
/Dparkh /Dperkh [def: butterfly]
parlament/N [m] [def: parliament] /Iarish
parme't/N [m] /In [def: parchment] 
parnose{prns|h}/H [def: income, livelihood] /D parnoses{prnswT}/H
	parnes{prns}/Xparnosem{prnsym}/H [m] [def: financial supporter]
	mefarnes{mfrns}/H [def: financially supporting] 
parobik/Xparobkes/Xparobikes [m] [def: farmhand]
parodye/S [f] [def: parody] parodish/A [def: parodic] 
	parodi'ist/N [m] [def: parodist] % Forwards: I. Gottesman
parol/N [def: fight song; password] 
parom/N [m] [def: ferry boat] 
parondik/Xparondkes [def: order, arrangement] 
	paro'ndkeve/V/T [def: arrange]
parshe{prSh}/Xparshes{prSywT}/H [f] [def: section of the Pentateuch, Biblical text; matter]
	parshevayz{prShvayz} [adv] [def: text by text] 
	parshas{prST}/H [def: Biblical text of]
	smikhes_haparshe{smyxwT-hprSh}/H [f] [def: similiarity]
parshive/A [def: scabrous] parshivekayt/N [f] [def: scabrousness]
	parshivets/Xparshivtses [m] [def: scabrous person; vile person]
parsish [def: Judeo-Persian] 
parta'tsh/Ees [m] partatshke/S [f] [def: bungler] /Iish [def: sloppy] 
	parta'tsheve/V/Bparta'tshevet [def: bungle] 
parter [m?] [def: downstairs]
partey'/N/Iish [f] [def: political party]
	umparteyish/A [def: without party affiliation] 
	folkspartey'/N [def: folk party (political)]
	parteytse/S [f] [def: member of a political party (Communist)] % Chaim Grade
partikl/N [def: particle (grammar)] 
partitsip/N [m] [def: participle] 
partiza'n/N [m] partizaner/S [m] partisanke/S [f] [def: partisan] 
	partizanish/A [def: partisan]
partner/S [m] pa'rtnerin/S [f] [def: domestic partner] 
	shtubpartner/S [m] [def: domestic partner] [note: V]
	ta'ntspartner/S [m] [def: dance partner] % Yiddish League
partsef{prcwf}/Xpartsufem{prcwfym}/H [m] [def: face] 
partye/S [f] [def: game; article of goods]
	shokhpartye/S [def: chess game]
pa'rubek/Xpa'rubkes [m] [def: unmarried non-Jewish youth (Ukrainian)]
paru'k/N [m] /D paruke/S [f] [def: wig] 
parusine [def: sail material] 
pas/Xpeser [m] [def: pass, passport; permit] 
	paser/S [m] [def: fence (for stolen goods)]
pas/N [m] [def: belt; track (electronics); measuring tape]
	pasik/N/Ees [m] [def: belt (clothing)]
		/D [def: ribbon]
		paskevate/A gepasikt/A gepa'skevet/A tsepa'skevet/A [def: striped; belted]
		shvartspasik/A [def: black-striped] % Bergelson: Yosef Shur 
	pasme/S [f] [def: strip] 
		regn-pasme/S [f] [def: rain rivulet]
	elektre-pas [m] [def: power strip or board (electric)] 
	shitspas/N [m] [def: safety belt] 
	shlumperpas/N [m] [def: cummerbund] 
	shmaltspasik/N [m] [def: extra weight around the waist] [note: V] 
pas/V/T [def: be appropriate; fit]
	/Gtsu [def: adjust]
	/Goyf
	/Garayn [def: become appropriate (with "zikh")]
	pasik/K [def: appropriate] umpasik/A [def: inappropriate] 
	oyfpaser/S [m] oyfpa'serin/S [f] [def: protector] 
	tsupasung/N [f] [def: adjustment, accommodation] 
pas [def: void (with "pust un -")]
	pustunpasnik/Ees [m] pustepasnik/Ees [m] [def: someone without income] 
	pustepas [adv] [def: rudderless (about a person)] % Sholem Asch: Motke Ganef
pasa'zh/N [m?] [def: passage (of text or music)]
pasazhi'r/N [m] pasazhirin/S [f] [def: passenger]
	[idiom: blinder pasazhi'r = stowaway]
pasekh{pTH}/H/N [def: Hebrew vowel point pasekh /a/] 
pashe/V/T [def: pasture]
	/Goys/Gop [def: fatten]
	pashe/S [f] [def: pasture; forage, fodder]
pashkevi'l [m] paskvi'l [m] [def: slanderous document; spoof, caricature]
pashol [interj] [def: giddyap, let's go (Russian пошел)] 
pashte't/N [m] [def: meat pie, pasty (food)]
pasi'r/V/Bpasi'rt [def: occur]
	pasirung/N [f] [def: occurrence] 
pasi'v/A [def: passive] pasivkayt/N [f] [def: passivity] 
paskudne/A [def: ugly, nasty, loathesome]
	paskudnik/Ees [m] pasku'dnitse/S [f] [def: digusting person] 
	paskudnya'k/Ees [m] paskudnya'tshke/S [f] [def: scoundrel, vile person] 
	paskudstve/S [f] [def: filth, abomination] 
	farpaskudik/V/Bfarpaskudikt [def: make filthy] % Sholem Aleykhem
paspo'rt/N [m] [def: passport] 
	onpasportler/S [m] [def: person without a passport] 
paste/S [f] [def: paste] 
pastekh/Eer/D [m] [def: shepherd]
	pastushke/S [f] [def: shepherdess] 
paste'l [m?] [def: pastel (color, material)]
pastke/S [f] [def: trap; mousetrap] 
pa'sternak [m] [def: parsnips]
pastrame/S [f] /D [def: pastrami (food)] 
pasude [f] [def: dishes, cookware]
pasya'ns/N [m] [def: solitaire (card game)]
	[idiom: leygn a pasyans = play solitaire]
pasye/S [f] [def: rage, fury]
	[idiom: araynkumen in der pasye = fly into a rage]
pat/N [m] [def: standoff, tie] % Yiddish League
patalo'k/N [m] [def: ceiling] [usage: Northern Yiddish]
pateke [f] [def: molasses]
patelnitse/S [f] [def: rear of head (Ukrainian потилиця)]
patelnye/S [f] [def: frying pan]
pate'nt/N [m] [def: patent (legal); license to do business] 
pater{ptr}/H/V/T [def: waste; ruin] /Gop/Gtse/Garoys
	tsepatr{tseptr}/V/Btsepatrt{tseptrt} [def: completely waste] 
	poter{ptwr}/H [def: free; exempt]
	ptire{ptyrh}/H [def: death (of a saint)]
	nifter{nyftr} [verb] [def: die (human, honorable) (with "vern")] 
		nifter{nyftr}/Xniftorem{nyftrym} [m] [def: dead person (honorable)]
	[idiom: vern nifter = die (said only of a saint)]
	haftoyre{hftwrh}/Xhaftoyres{hftwrwT} [f] [def: prophetic (Bible) reading] 
	[idiom: a nomen fun der haftoyre{hftwrh} = a fictitious name]
	[idiom: oppatern{optrn} mit shiye_piye{Shy-phy} = put someone off by a pretense]
patetish/A [def: pathetic] 
pati'lnitse/S [f] pati'litse/S [f] poti'litse [def: rear side of head (Ukrainian)]
	pati'litshnik/Ees [m] poti'litshnik/Ees [m] [def: blow to the rear of the head]
patle/S [f] [def: tuft of hair, lock]
	tsepatl/V/Btsepatlt [def: dishevel, disorder]
patlezhan/Dpatlezhe [m] [def: eggplant] 
patlye/S [f] [def: mass (of hair)] % Forwards: Boris Sandler
patologye/S [f] [def: pathology] patologish/A [def: pathological] 
patos [m] [def: pathos] 
patoype/V/Bpatoypet [def: fit]
	[def: dos patoypet zikh mir nit in kop = I can't figure it out]
patrol/N [m] [def: patrol] 
patro'n/N [m] [def: patron]
	patroni'r/V/Bpatroni'rt [def: patronize] patrona'zh [def: patronage] 
patrya'rkh/N [m] [def: patriarch (elder or Church leader)] /Ia'l
	patryarkhye/S [f] [def: patriarchy]
	patryarkha't/N [f?] [def: patriarchate (Church)]
patryot/N [m] [def: patriot; devotee (actors' argot)] /Iish [def: patriotic] 
	patryoti'zm/N [m] [def: patriotism] 
	patryo'tishkayt/N [f] [def: patriotism] % Forwards: Estraykh
patsh/V/T [def: slap; applaud (with "mit di hent")] /Gon/Gdurkh/Goys
	/Gunter [def: slap in secret]
	/Gtsu [def: close bidding in an auction] % Sholem Aleykhem: Khanuke Gelt
	patsh/Xpetsh [m] [def: slap; blow] /Dpetsh [def: tap] 
		patsheray'/N [n] [def: slapping] 
	farpatsh/V/Bfarpatsht [def: slap] 
	tsepatsh/V/Btsepatsht [def: slap] 
	patsher/S [m] [def: slapper, spanker]
	pa'tsherke/S [f] [def: bead; glass trinket; rosary]
pa'tsherke/S [f] [def: bead, pearl] 
patshke/V/T [def: daub, smear; dirty, soil]
	/Gon [def: ruin by overdoing] 
	/Garum [def: make a general mess] 
	bapatshke/V/Bbapatshket farpatshke/V/Bfarpatshket [def: besmear, soil; daub] 
	[idiom: eydl gepatshket = picky]
patsu'k/Ees [m] [def: rat (animal)]
patsye'nt/N [m] patsyentke/S [f] [def: patient] 
pave/S [f] [def: peacock] 
pavilyon/N [m] [def: pavilion] 
pavolye/A pavolink/A [def: slow (Ukrainian поволє)] 
pavya'k/N [def: prison for political prisoners]
pavyatovi [adj indeclinable] [def: district (Polish powiatowi)] % Chava Rozenfarb: Botshani
paya'ts{pa|yats}/N [m] [def: clown]
	paya'tseve{pa|yatseve}/V/Bpaya'tsevet{pa|yatsevet} [def: clown] 
payde/S [f] [def: lump; clod; chunk]
paynik/V/T [def: torture]
	/Goys [def: torture to exhaustion]
	farpaynik/V/Bfarpaynikt [def: torture, torment] 
	payn/N [def: pain] /Ilekh [def: painful]
		paynlekhkayt/N [f] [def: painfulness]
	payniker/S [m] [def: torturer]
	paynikung/N [f] [def: torture] 
pa|ok [m?] [def: ration, diet (Russian паек)]
paze [prep] [def: along] 
pazukhe/S [f] [def: bosom (body part)]
pe/En [m] [def: the letter P] 
pe_{ph}/H [def: mouth] pi{py}/H [def: mouth of] 
	bal_pe{bel-ph} [def: oral] /IJk
	al_pi{el-py} [prep] [def: according to]
		[idiom: al_pi din = by all rights]
pebl [n] [def: mob, rabble]
pedagogye/S [f] [def: pedagogy] pedagogik [f] [def: pedagogy]
	pedago'g/N [m] [def: pedagogue; teacher] /Iish [def: pedagogic]
peda'l [m?] [def: pedal (part of car, musical instrument, or loom)]
pedan't/N [m] [def: pedant] 
	pedantish/A [def: pedantic] 
		pedantishkayt/N [f] [def: pedantry, obsessiveness, punctiliousness]
pedler/S [m] [def: peddlar] 
	pedl/V/T [def: peddle] 
pedofi'l [m] [def: pedophile] % Forwards: S-R Schaechter
pege{pge}/Xpegoyem{pge|ym} [def: trouble, disaster; annoyance; annoying person]
pekelik/Ees [m] pyekelik/Ees [m] [def: wall oven]
pekh [n] [def: pitch] /Iik
pekhke/V/T [def: puff, chuff (Ukrainian пихкати)] % Der Nister
pekhote [f] pyekhote [f] [def: infantry (military) (Russian, Polish piechota)] /Ine
pele{pl#}/Xploim{pl#ym} peyle{pl#} [f] [def: wonder, miracle; wow!] /Idik
pelene/S [f] [def: cover, shroud (Ukrainian пелена)] % Sholem Aleykhem (grins af shvues)
pelerine/S [f] [def: cape, pelerine] /Dpelerink % palatal L
pelika'n/N [m] [def: pelican (bird)]
pelts/N/D [m] [def: fur; fur coat (clothing)] /Iern
	peltsl/Eekh [def: small fur, fruit peel] 
	pelts/V/T [def: wear a fur coat] % Der Nister
		/Gon [def: put on a fur coat] % Bergelson, Der Nister, Opatoshu: Polishe Velder 
pelvis [m?] [def: pelvis (body part)]
pempik/N/D [m] [def: belly (anatomy); squat or chubby lad] 
	pempikevate/A [def: chubby] % Bergelson
pen/N/Ees [f] [def: pen] 
	hentlpen/N [f] [def: handled pen??] % Forwards: Mishe Lev
	kvalpen/N [f] [def: fountain pen] % Forwards: Boris Sandler
	penal [m?] [def: pen or pencil container]
	pendzl/N [m] [def: paintbrush] /Dpendz
		pendzl/V/T /Goys [def: depict by painting]
pendum [def: (with "hendum -") in a rush] 
pendze [f?] [def: object of mockery, laughingstock]
	[idiom: makhn pendze fun emetsn = make fun of someone] % Avrom Karpinovitsh
penets/N/Eer [m] [def: slice (bread); thin layer] /D
peni/S [m] [def: penny] 
penis/N [m] [def: penis (body part)]
penitsili'n [m] [def: penicillin (medicine)]
penke/S [f] [def: part of a feather]
penkher/S [m] pokhi'r/N [m] pakhi'r/N [m] /D pukhi'r/N [m] [def: bladder (body part)]
pensne' [f/n] [def: pince-nez (clothing)] 
pensyon'r/V/Bpensyoni'rt [def: retire]
	pensye/S [f] [def: pension] 
	pensyone'r/N [m] [def: retired person] % Harduf
	elter-pensye/S [f] [def: old-age pension] 
	[idiom: oyf pensye = retired]
pentago'n/N [def: pentagon]
pente/V/T [def: chain, bind; beg]
-/Xpentlekh [def: barley] % Stutchkoff
pentsak [m] [def: pearl barley; gruel] /Dpentsik
pentyukh/Ees [m] [def: blockhead, fool]
pepke/S [m] [def: blockhead, fool]
per [def: per; via; by] % Harduf
pe'rene/S [f] [def: feather bed; down quilt] 
perednye/S [f] [def: foyer, antechamber]
pereodem{pr#-odm}/H/S [m] [def: savage; imbecile] 
peresyadke/S [f] peresadke/S [f] [def: change of train]
perfekt/K [def: perfect]
	umperfekt/A [def: imperfect]
		umperfektkayt/N [f] [def: imperfection] 
	perfektiv/A [def: perfective (grammar)] 
	perfektsye/S [f] [def: perfection; completeness]
pergame'nt [m?] [def: parchment (material)] % B. Sandler: Karolina-Bugaz
peri{pry}/Xpeyres{pyrwT}/H [f] [def: fruit]
	pri{pry}/H [def: fruit of] 
periferye/S [m] [def: periphery] % Harduf
perifrastish/A [def: periphrastic] 
perl/X [m] [def: pearl] /Idik /Dper 
permane'nt/A [def: permanent] 
perokhes{prwxT}/H/N [def: cloth ark curtain (religious)] 
perve/A [def: first-class, best (Russian первый)]
peryod/N [m] [def: period] /Iish [def: periodic] 
perzo'n/N [f] [def: person] [grammar: may use singular after a plural number]
	/Dperzond
	perzonik/A perzenlekh/A [def: personal]
	perzenlekhkayt/N [f] [def: personality] 
	perzonifitsi'r/V/Bperzonifitsi'rt [def: personify] 
		perzonifikatsye/S [f] [def: personification] 
	persona'l [m] [def: staff, personel] 
		fli-persona'l [m] [def: flight crew] [note: V]
		persona'l/A persone'l/A [def: personal (regarding persons)] 
		personalite't/N [f] [def: personality (quality)] 
		persona'zh/N [m] [def: personality (person)] 
	persona grata [def: welcome person] 
	persona non grata [def: unwelcome person] 
	parshoyn/N [m] [def: person] /Dparshoynd parshoynte/S [f] [def: person]
		mansparshoyn/N [m] [def: male human] 
pesimi'st/N [m] pesimistke/S [f] [def: pessimist]
	pesimi'zm/N [m] [def: pessimism] pesimistish/A [def: pessimistic] 
pest [def: poison] 
	farpestik/V/Bfarpestikt [def: poison] 
		farpe'stikung/N [f] [def: pollution; poisoning]
	tsepestet/A [def: spoiled, pampered]
peste/V/T [def: pamper, spoil; indulge oneself (with "zikh")] /Goys
peti-meti [m?] [def: cash]
peti't [def: small typeface] 
petitsye/S [f] [def: petition] 
petrishke/S [f] [def: parsley (food)] 
	[idiom: hefker{hfkr} petrishke = anything goes! (interj)]
	[idiom: vert a petrishke = worthless]
petlye/S [f] [def: leash; noose, looped string]
petrol petroleum petrolyum [def: petroleum]
petsha' petshe' petsa' [m/f] [def: jellied calves' feet (food)] 
petshatek [m] [def: business deal]
petsheritse/S [f] [def: mushroom (Southern Yiddish)]
petshl/V/T /Gon [def: tap; dab]
pevne/A [def: certain]
pey{pʼ}/H [def: Hebrew letter Pe] 
peyde/S [def: payday (American)]
peye{p#h}/Xpeyes{p#wT}/Xpeyesn{p#wTn}/H [def: sidelock] peyele{p#hle}/Xpeyeslekh{p#wTlekh}
	[idiom: shvern bay bord un peyes{p#wT} = swear up and down]
peyger{pgr}/H/V/T [def: die (animal)]
	pegire{pgyrh}/Xpegires{pgyrwT}/H [f] [def: death (animal); carcass] /D
	peyger{pgr}/Xpegeyrem{pgrym}/H [m] [def: corpse (animal)]
pe|yorati'v/A [def: pejorative] % Forwards: Hershl Glaser
peyrek{prk}/Xprokem{prkym}/H [m] [def: chapter]
	pirkey{prky}/H [def: chapters of] 
peyresh{pyrwS}/Xpeyrushem{pyrwSym}/H [m] [def: explanation]
	meforesh{mfrS}/Xmeforshem{mfrSym}/H [def: explain, explainer, Rabbinic authority]
	poresh{prwS}/Xprushem{prwSym} [def: Pharisee; ascetic] 
		poreshdik{prwSdik}/A [def: isolated]
peysekh{psH}/H [m] [def: Passover] /Idik /Iik
	far|peysekh|dik/A [def: pre-Passover]
	nokh|peysekh|dik/A [def: post-Passover] 
	kosher_lepeysekh{KSr-lpsH} [adj predicative] [def: Kosher for Passover]
peyza'zh/N [m] peysa'zh/N [m] [def: landscape] % Sandler; French "paysage"
pgam{pgm}/Xpgomem{pgmym}/H [def: defect, blemish] 
	pgime{pgymh}/Xpgimes{pgymwT}/H [def: scratch; defect] 
		/Dpgim % apparently loses the h
pidmurke/S [f] [def: masonry foundation of a wooden house (Polish podmurówka)] % Der Nister
pidpalik/Ees/Xpidpalkes [m] [def: flat loaf (food)]
pidyen{pdywn}/H [def: redemption] 
	pidnaben{pdywn-h|bn}/H [def: redemption of the first-born son] 
pidzha'k/N [m] [def: jacket (clothing)] /D
piet{pywt}/Xpyutem{pywtym} [def: liturgical poem]
	payet{piwt} [m] % alternative spelling
	patyn{paytn}/Xpaytonem{paytnym} [m] [def: liturgical poet]
pik/N [m] [def: spades (playing cards)] % no plural?
pik/V/T [def: peck] /Goys/Gon
	/Goys [def: shovel out (with "zikh"); hatch]
	pike/V/T [def: peck] % variant
	pi'keve/V/T/Gon [def: find fault] 
	boympiker/S [m] [def: woodpecker (bird)] % Opatoshu: Polishe Velder 
pik/V/T [def: eat]
	tsepikt/A [def: burst (from overeating)]
	piker/S [def: eater; baby]
pika'nt/A pika'ntne/A [def: sharp; spicy; sexy] 
pike/S [f] [def: pike, spear]
piketi'r/V/Bpiketi'rt [def: picket (English)] 
pikeyekh{pykH}/Xpikkhem{pykHym} [m] pikeyekhte{pykHte}/S [f] [def: clever person]
piknik/N/S [m] [def: picnic] 
pil/N [f] [def: pill] 
	baruik-pil/N [f] [def: tranquilizer] [note: V]
pilder/V/T [def: be loud (with "zikh")]
	tsepilder/V/Btsepildert [def: be loud (with "zikh")
	gepilder/N [n] [def: clamor, noise]
pilegesh{plgS}/Xpilgoshem{plgSym} [m?] [def: concubine]
	veg-pilegesh{veg-plgS}/Xveg-pilgoshem{veg-plgSym} [m?] [def: traveler's concubine] % Bergelson 
pi'lenitse/S [f] pi'linitse/S [f] [def: wild strawberry]
pi'leve/V/T pi'lneve/V/T [def: nurse; feed]
pilgri'm/N [m] pilgrimke/S [f] [def: pilgrim (non-Jewish)]
pilke/S [f] [def: ball, baseball (with "hilke -")] 
pi'lneve/V/T [def: nurse, pamper] pi'leve/V/T
pilo't/N [m] [def: pilot] % Harduf
	pilotloz/A [def: pilotless] [usage: inadmissible] % Forwards
	umpilotnik/Ees [m] [def: drone (aircraft)] % Forwards
pilpl{pylpwl}/Xpilpulem{pylpwlym}/H [def: Talmudic hairsplitting] 
	pilple{pylpwle}/H/V/T [def: split hairs (with "zikh")]
	mepalpl{mplpl}/H [verb] [def: debate (with "zayn")] % Opatoshu: Poylishe Velder
pinakote'k/N [f] [def: picture album] % Stutchkoff
pingpong [m] [def: ping-pong (game)] 
pingvin/N [m?] [def: penguin (bird)]
pinkes{pynks}/Xpinkeysem{pynksym}/H [m] [def: town register; notebook] 
pint/N [m] [def: pint (liquid measure)]
pintl/V/T [def: squeeze the eyes almost shut; squint] 
	/Dpint [n] [def: point] % no positive
		/Ddraypint [n] [def: ellipsis marks (printing)] 
	gepintlt/A [def: speckled; dotted] % Harduf 
	pintlekh/A [def: precise]
pintsher/S [m] [def: Pinscher (terrier; type of dog)] % Forwards: Boris Sandler
pinye/V/T pine/V/T [def: froth, foam]
pipernoter/S [m] [def: dragon, monster] /Iish
pipke/V/T [def: peep (sound of a bird); puff (pipe or cigarette)] 
	pipke/S [f] [def: pipe]
pips/N [m] [def: squeak] 
	pipser/S [m] [def: beeper (telephone messages); pager] [note: V]
	pipsnik/Ees [m] [def: pager] [note: V]
pirami'd/N [m] piramide/S [f] [def: pyramid] 
pira't/N [m] [def: pirate] % Harduf
pirezhke/S [f] [def: sweet roll (like macaroon or jelly roll??) (food)]
pirkhey{prHy}/H [def: children] 
piro'g/N [m] pyeroge/S [f] [def: meat pie; vagina (body part; vulgar)]
	pirge/S [f] [def: vagina (body part; taboo)] 
pirsem{pyrswm}/H [m] [def: publicity; publication]
	mefursem{mfwrsm}/H [def: famous] /Idik
	mefarsem{mfrsm}/H [verb] [def: publish (with "zayn")] 
	iber-pirsem{iber-pyrsym}/H [m] [def: hype] 
pish/V/T [def: urinate]
	/Goys [def: eliminate by urinating (with "zikh")]
	pishekhts/N [n] [def: urine]
	pisher/S [m] /D [def: child; inexperienced person (humorous)]
	pi'sherke/S [f] [def: child]
	[idiom: ruf mikh kaker pisher = sticks and stones]
pishe-peyshe [f] [def: a children's card game] 
pishtshe/V/T [def: chirp (sound of a bird), squeal, whine] 
	pishtsh/N [m] [def: chirp, squeal, whine] 
	pishtsher/S [m] [def: chirper; whiner]
pishtshevke/S pitshevke/S [f] [def: detail]
pisk/Ees /D [m] [def: snout, mouth (body part) (of animal)]
	piskate/S [f] [def: foul-mouthed woman]
	pi'skeve/V/T [def: be garrulous]
	piskl/V/T [def: pout, grimace (with "zikh")]
	pisklyate/S [f] [def: infant; newly hatched chick]
pisn/A [def: moldy (Russian)]
pistoyl/N [m] pistole't/N [def: pistol (weapon)] 
	[idiom: vi a pistoyl in hartsn = like a knife in the heart]
pi-taba's{tbeT} [m] [def: anus (body part)] % ?? spelling
pitak/Ees /D [n] [def: 5-kopek coin (Russian currency)]
pitem{pytwm} [m] [def: flower-end of fruit] /D
pitse/S [f] [def: pizza (food)] 
pitshnik/Ees [m] [def: specialist in building and repairing stoves (Russian печник)]
	podpitshnik/Ees [m] [def: chicken coop under the oven] % Sholem Aleykhem
/Dpits pitsink/A [def: tiny] % not in the positive
	tsepitslt/A [def: tiny] 
	pitshimontshkel/A [def: minuscule] % Forwards: M-S Hoffman
	-/Xpits-pitslekh [def: shreds]
	pitshedik/A pitshink/A pitshinyunkl/A pitshemontshink/A [def: tiny]
	papi'r-tsepitsler/S [m] [def: paper shredder] [note: V]
pivonye/S [f] [def: Peony (flower)] % Opatoshu: Poylishe Velder
pizde/S [f] [def: vagina (taboo) (Russian пизда)]
pizhame/S [def: pajamas (clothing)] % Harduf, Sandler
pizmen{pyzmwn}/Xpizmoynem{pyzmwnym}/Xpizmoynes{pyzmwnwT} [m] [def: liturgical poem; litany; tall tale] 
pkhe [interj] [def: pkhe: expression of dismissal]
plagya't [def: plagiarism]
plaka't/N [m] [def: poster, plackard]
plakhe [def: block, log]
plakhte/S [f] [def: bedspread (cloth)]
plan/N/Xplener [m] [def: plan; map]
	plani'r/V/Bplani'rt [def: plan] /Goys
		farplani'r/Bfarplani'rt [def: plan, schedule]
		planirung/N [f] [def: planning] 
		geveytlekh-planirt/A [def: regularly scheduled] [note: V] 
	pla'neve/V/T [def: plan] 
	planmesik/A [def: methodical, systematic]
	fliplan/Xfliplener [m] [def: flight schedule] [note: V]
	tsaytplan/Xtsaytplener [m] [def: schedule] 
	lernplan/Xlernplener [m] [def: syllabus]
	groy'spla'nik/A [def: wide-angle (photography)] % Stutchkoff
	brey'tpla'nik/A [def: wide-angle (photography)] [note: V]
plane't/N [m] [def: planet] 
	planete/S [f] [def: planet] % B. Sandler: Karolina-Bugaz
plantator [m] [def: planter]
plapl/V/T [def: babble] /Garoys
	/Gnokh [def: repeat platitude]
	plapleray'/N [n] [def: babble] 
plastik [m] [def: plastic] plastish/A
platforme/S [f] [def: platform] 
	lantsi'r-platforme/S [f] [def: launch pad] % Yiddish League
platinum [m] [def: platinum (Pt)] 
plats/V/T [def: burst] /Goys
	tseplats/V/Btseplatst [def: burst]
	/Dplets [def: cracker (food); roll] % no positive form
		[idiom: tsibele pletsl = onion roll]
		[idiom: khevre{HBrh} pletsl = youngsters (humorous)]
plats/Xpletser [m] [def: place]
	arbetsplats/Xarbetspletser [m] [def: workplace] % Forwards: M-S Hoffman
	hoyptplats/Xhoyptpletser [m] [def: main place]
	markplats/Xmarkpletser [m] [def: marketplace] 
	mistplats/Xmistpletser [m] [def: garbage dump] % Forwards: S-R Schaechter
	shpilplats/Xshpilpletser [m] [def: playground] 
	sportplats/Xsportpletser [m] [def: sport ground, arena]
	vebplats/Xvebpletser [m] [def: website]
	zitsplats/Xzitspletser [m] [def: seat] 
platshik/A [def: shallow, low-lying] 
	pletsh/V/T [def: flatten] /Gtsu % Avrom Karpinovitsh
	[idiom: makhn platshik = flatten]
plazhe/S [f] [def: sea shore] 
	plazhenik/Ees [m] [def: beach bum] [note: V]
plazme [f] [def: plasma] % Harduf
plebanye/S [f] [def: rectory (Polish plebania)] % Chava Rozenfarb: Botshani
plebitsi't/N [m] [def: plebiscite] % Harduf
pled/N [m] [def: travel blanket]
plef/V/T [def: astound; puzzle, baffle]
	ple'ferish/A [def: astonishing]
	geple'f/N [n] [def: perplexity, bafflement] 
	farbli'ft/A [def: astounded] [usage: not recommended]
plen [m] [def: captivity]
	plenik/Ees [m] [def: captive; prisoner of war] % palatal L
	[idiom: nemen in plen = take prisoner]
plenum/S [m] [def: meeting, general meeting]
plet/V/T [def: raffle] /Goys [def: raffle off]
	plet/N [m/f] [def: raffle]
	[idiom: nemen a plet = take someone in for a Sabbath meal]
	[idiom: plet oyf shabes{SbT} = a Sabbath meal (as charity)]
plet/V/T [def: smash, crack]
	hinerplet [m/n?] [def: lethargy; daze, stupor; trance]
	[idiom: pletn a moyekh{mwH} = bash in someone's head]
pleyade{ple|yade}/S [def: Pleiades (constellation); cluster] 
pleyn/N [m] [def: plain; (geometric) plane] 
pleytse/S [def: shoulder (including the scapula) (body part)]
	pleytsik/A [def: shouldered] [usage: breyt-pleytsik]
	breytpleytsik/A breytpleytsedik/A [def: broad-shouldered] 
	krumpleytsik/A [def: hunchbacked] % Rokhl Korn: Erd
	[idiom: tsushteln a pleytse = help]
	[idiom: tsien/kvetshn mit di pleytses = shrug one's shoulders]
plikh/N/Ees [m] [def: bald head] /D
	/Ievat [def: bald] 
plimenik/Ees [m] [def: nephew] plime'nitse/S [f] [def: niece] 
plis [m] [def: velveteen (material)] /In
plishke/S [f] [def: a children's game] % Perets: ale mentshn zaynen brider
plit/N [m] [def: vinyl record; raft]
	plate/S [f] [def: plate, slab; phonograph record]
	plite/S [f] [def: plate]
		ga'zplite/S [f] [def: gas burner (part of a stove)]
plitke/A [def: shallow] 
plitsh/Xpletsh [n?] [def: morsel of bread (food)]
	plits/Xplets [n?] % variant: Bashevis
plodye/V/T [def: breed] /Gon
plog/V/T [def: torment, plague afflict, harass] 
	plog/N [f] [def: plague, affliction; scourge] 
plokhe/A [def: poor; lowly; afflicted]
plombe/S [f] [def: lead seal, filling (dental)] 
	plombi'r/V/Bplombi'rt farplombi'r/V/Bfarplombi'rt [def: seal; fill (tooth)]
	blomb [def: permission, sealed with a plombe] 
	[idiom: leygn +dative a plombe = put a filling in the tooth in someone]
plonter/V/T [def: stumble; tangle] /Garum/Gfunander/Garayn/Gtsu
	plonte/V/T [def: stumble; tangle] /Garum/Gfunander/Garayn/Garoys/Gon
	/Goyf/Goys [def: untie, disentangle] 
	plonter/S [m] plonternish/N [n] plontenish/N [n] geplonter/S [m] [def: muddle, tangle, jumble]
	farplonter/V/Bfarplontert [def: stray (with "zikh"); mix up, confuse (with "mit")] 
	farplonte/VBfarplontet [def: stray (with "zikh")] % variant
		farplonternish/N [n] farplontenish/N [n] [def: muddle]
plosh/N [m] [def: gust (of wind)] 
ploshe/V/T [def: run in circles]
	tseploshet/A [def: in disarray] 
ploster/N [def: some body part] % plostern fun di gendz
-/Xplostn [def: herbs and onions for cooking] % ??
plotke/S [f] plote/S [f] [def: dart (fish)] % Stutchkoff
ployder/V/T [def: gossip; prattle] /Idik [def: gossiping; prattling] 
	ployderay'/N [n] [def: gossip; prattle] 
ployne{plwny}/H [def: what's his name; John Doe]
	ployneste{plwnyTte}/Xploynestes{plwnyTtes} [f] ploynes{plwnyT} [def: woman; wife] [usage: humorous, deprecating]
ploysh/V/T [def: chat, banter]
ployt/N [m] [def: fence] 
-/Xpludern [def: trousers (clothing)]
plug [m?] [def: plow (Polish plug)]
plugte{plwgW#}/Xplugtes{plwgWwT}/H [f] [def: controversy, dispute]
plump/N [m] [def: pump] /D
	plump/V/T [def: pump] /Goys
	plumper/D [def: ??]
	leshplump [m] [def: fire hydrant] 
pluntsh/V/T [def: splash] /Garop
plurali'zm/N [m] [def: pluralism] pluralistish/A [def: pluralistic] 
plus/N [m?] [def: plus] 
plute/V/T pluteve/V/T [def: be carefree, act cavalierly; swindle] % Mendele
	plut/N [m] [def: scatterbrain, fickle person] 
	farplutet/A [def: out of kilter] 
plutonyum [m] [def: plutonium (Pu)] 
plustern [m?] [def: pumpkin]
	-/Xplutserndike [def: Cucurbitaceae (plant family)] % Forwards: Hershl Glaser
plutsling [adv] [def: suddenly] /Idik [def: sudden]
	plutsem [adv] [def: suddenly] /Idik [def: sudden] 
		plutskedrinen [adv] [def: unexpectedly] % Forwards: Yechiel Szeintuch
	plutslung [adv] [def: suddenly] /Idik [def: sudden] 
plyame/S [f] [def: spot, stain (Polish plama)] 
plyeske/V/T [def: applaud; clap to a beat] /Gtsu
	plyesk/N [m] [def: applause; clap]
plyetshe/V/T [def: talk fast] pletshe/V/T
plyotke/S [def: slander, rumor; gossip]
	plyo'tkeve/V/T [def: slander; gossip]
plyukhe/V/T [def: pour, gush; slop] 
	plyukh/N [m] plyusk/N [m] plyesk/N [m] plyushk/N [m] [def: splash (sound of liquid falling)] 
	plyushke/V/T plyeske/V/T plyuske/V/T polyoske/V/T [def: splash] 
plyush [m] [def: plush; velvet] /In
plyushtsh [m] [def: ivy (plant)]
pniye{pnyh}/Xpniyes{pnywT} [f] [def: ulterior motive] 
pnyak/Ees [m] [def: tree stump] 
	penye/S [f] [def: tree stump]
podagra [m?] [def: podagra (foot disease)] % Forwards: Sholem Berger
podane/S [def: subject (person), citizen (Russian)] 
	podanstve [f] [def: serfdom (Russian)]
podanye/S [f] [def: official appeals (Polish podania)]
podbokem [def: on the hips (with "nemen di hent -")] 
podelik/Ees [m] [def: lap (body part)]
-/Xpodeshkes [def: garter belt] % Michael Wex
pode'shve/S [f] [def: sole (shoe) (clothing)] 
podkove/S pidkove/S [f] [def: horseshoe]
podle/A [def: dastardly; unworthy; nasty]
	podlye'ts [m] [def: bastard, unpleasant person (Russian подлец)]
podloge/S [f] padloge/S [f] podlike/S [f] [def: floor]
	pol/N [m] [def: floor] [usage: Northern Yiddish]
podobne [adj] [def: similar] [grammar: undeclined]
po'dlost/N [f] [def: mean act (Ukrainian)] 
podrad/N [m?] [def: contract (Russian подряд); matzo bakery; factory]
	podratshik/Ees [m] [def: contractor, builder (Russian подрядчик)
poet/N [m] [def: poet] /Iish [def: poetic] 
	poetik [f] [def: art or study of poetry]
	poetese/S [f] [def: poetess] 
	etnopoetish/A [def: ethno-poetic] 
	poeme/S [f] [def: poem] /D poem/N
	poezye/S [f] [def: poetry] 
pof/V/T/Bgepofn [def: sleep overlong]
	pefer/S [m] pe'ferin/S [f] [def: lazybones] 
pogode/S [def: pogoda] 
pogode/S [def: climate] % Stutchkoff
pogro'm/N [m] [def: anti-Jewish riot]
	pogromi'r/V/Bpogromi'rt [def: riot] 
	pogro'mshtshik/Ees [def: anti-Jewish rioter] /D
pohibel [m] [def: destruction, ruination (Ukrainian погибель)]
pok/N [f] [def: pock] % katshkes hobn moyre far pokn
-/Xpokn [def: (chicken) pox (disease)]
	pok/V/T [def: have (chicken) pox]
	-/Xvintpokn [def: chicken pox (disease)
	[idiom: shteln pokn = vaccinate]
	[idiom: pokn un mozlen = go through childhood diseases]
poked{pqyd}/Xpkidem{pqydym} [m] [def: official; superintendant]
poker [m?] poyker [m?] [def: poker (card game)]
	[idiom: a poker = a game of poker]
pokhozhe [adj] [def: similar to (with "oyf") (Russian похожа)] [grammar: indeclinable] % Sholem Aleykhem
pokoye/S [f] [def: lodging]
	pokoyo've{poko|yove}/S [def: chambermaid, servant girl]
pokrishke/S [f] [def: lid, pot cover]
	[idiom: khata pokrishke = shut up]
pokshive/S [f] [def: nettle (plant)] % Harduf
poladyum [m] [def: palladium (Pd)] 
pole/S [f] [def: pole; hem, lap of clothing]
	polar/A [def: polar (mathematics)] 
	[idiom: raysn emetsn a pole = swindle]
	[idiom: a kabtsn{kbcn} in zibn poles = destitute person]
pole/V/T [def: weed (a garden)] /Goys
	poleve/V/T [def: weed (a garden)] /Goys
polemik/Ees [f] [def: polemics] polemish/A [def: polemic]
	polemizi'r/V/Bpolemizi'rt [def: argue, debate]
	pole'miker/S [m] [def: debater]
polet{plyt}/Xpleytem{plytym}/H [m] [def: refugee]
	pleyte{plyth}/Xpleytes{plytwT}/H [def: escape] /Lha{h} [noun] [m] [def: the escape]
	-/Xsheyres_hapleyte{S#ryT hplyth} [def: Holocaust survivors]
	[idiom: makhn pleyte = run away]
	[idiom: moyekh{mwH}- pleyte = brain drain] [note: V] 
poligamye/S [f] [def: poligamy] 
poligo'n/N [m] [def: polygon]
poliglot/A /Iish [def: multilingual]
poli'r/V/Bpoli'rt [def: polish; burnish, shine] /Gop
	poli'r/N [m] [def: polish; surface glow] 
polish [m/n] [noun] [def: synagogue anteroom] 
polite'khnikum [n] [def: polytechnic school]
po'litik [f] [def: politics (subject); policy] /A
	politish/A [def: political]
		umpolitish/A [def: apolitical] % Forwards: Yoel Matveyev
	politiker/S [def: politician]
	politizi'r/V/Bpolitizi'rt [def: politicize] 
	oysglaykh-politic [f] [def: affirmative action] [note: V]
	realpolitik [f] [def: realpolitic] 
po'litse/S [f] [def: shelf, bookshelf] 
politsey' [f] [def: police] /Iish
	politsi'st/N [m] [def: policeman]
	politsye/S [f] [def: police] [usage: doubtful admissibility]
	politsya'nt/N [m] politseyman/Xpolitseymener [m] [def: policmeman] 
politu'r/N [f] [def: polish (substance)] 
polk/N [def: regiment (Russian полк)]
	polkovo|y' [adj] [def: regimental]
	polkovnik/Ees [m] [def: lieutenant (Russian полковник "colonel")] 
polk/V/T /Goys [def: reveal a secret] % Hoffman
polke/S [n] [def: polka (dance)] 
polne/A [adj] [def: perfect (ironic); incomplete]
	[grammar: may be left undeclined]
	[idiom: oyf polnem zikher = for certain]
polo [m?] [def: polo (sport)]
	vaser-polo [m?] [def: water polo (sport)]
polonik/Ees [m] [def: ladle] 
polonke/S polyanke/S [f] [def: ice hole]
polonyum [m] [def: polonium (Po)] 
po'love/S [f] [def: chaff]
polozhenye/S [f] [def: situation, condition]
polu'mesik/Xpolu'meskes [m] [def: shallow wooden bowl; platter]
polus/N [def: pole (magnetic, electrical)] 
polustanek/Ees [m] [def: stop on a transportation line] [usage: not recommended] % Stutchkoff
polyane/S [f] [def: glade, forest clearing]
polyo [m] [def: polio (disease)] % Forwards: M-S Hoffman
polyube/V/Bpolyubet [def: please; make a good impression on (with dative)]
pomade/S [f] [def: pomade (hair-styling grease]
po'merants/N [m] mara'nts/N [m] [def: orange (fruit)]
pometsh [m] [def: assistant (Ukrainian помічник)] % Sholem Aleykhem
	pomotshnik/Ees [m] [def: assistant]
pomido'r/N [m] [def: tomato (vegetable)] /D
poml/Xpomelekh [n] [def: oven broom] 
pompedikl/N [m] [def: pendulum]
pompe/S [f] [def: pump] /Dpemp
	po'mpeve/V/T pompe/V/T [def: pump] 
	pomp/N [m?] /Dpimp /Dpemp [def: penis (body part) (slang)]
	ongepompet/A [def: stuffed, pumped up] % Forwards: M-S Hoffman
pompe/S [f] [def: pomp] 
	pompe'z/A [def: pompous] 
poms [m] pomsn/A [def: crimson (color)]
pomu'ni'tse/S [f] [def: slops, slop pail] pomoy'nitse/S pomenitse/S % either accent ok
	pomesha'f/N [m] pamu'ntskele/Ekh [n] [def: slop pail] 
	-/Xpamoyes [def: waste water]
pomve/S [f] [def: frying pan] % Stutchkoff
pomyeshtshik/Ees [m] pomeshtshik/Ees [def: estate owner (Russian помещик)] 
ponem{pnym}/Xpenemer{pnymer}/H [def: face] /Dpenem{pnym}
	ponem_khadoshes{pnym-HdSwT} [n] [def: novelty] 
	azes_ponem{ezwT-pnym} [def: effrontery; disrespectful person]
	matse-ponem{mch-pnym} [def: acne-scarred face (humorous)]
	al_kol_ponem{el-Kl-pnym}/H [def: in any case]
	leponem{lpnym}/H [adv] [def: apparently, seemingly; as a formality]
	hester_ponem{hsWr-pnym} [noun] [def: concealment of Divine providence]
	-/Xpney{pny} [def: élite social stratum]
	[idiom: a ponem{pnym} = obviously, clearly]
	[idiom: onkukn epes in ponem arayn = face up to something] [note: V]
	[idiom: mitn ponem{pnym} arop = face down]
poni/S [m] [def: pony (animal)]
ponts/N [m] [def: paunch; bulge; beer belly]
pontshke/S [f] [def: jelly roll (food)]
pop/N [m] [def: Leader of Eastern Orthodox Church]
popas [m?] [def: rest to feed horses]
popelyate/A [def: gray]
poperik [def: athwart]
popetshitel/Eyes [def: caretaker, trustee (Russian)] 
popke/S [f] pupe/S [f] pupke/S [f] [def: doll (plaything)] 
popugay'/N [m] papuge/S [f] [def: parrot] 
	[idiom: la'ngnekiker popugay = parakeet]
popule'r/K [def: popular]
	populazito'r/N [m] [def: popularizer]
	popularite't/N [f] popule'rkayt/N [f] [def: popularity]
	umpopule'r/A [def: unpopular]
po'puri [m?] [def: musical potpourri; medley]
por/N/D [f] [def: pair]
	por/V/T [def: pair up] /Gtsunoyf
	porvayz po'rlekhvayz [adv] [def: in twos] /A
poradke/S [def: decree, order (Russian порядке)] 
pore/V/T [def: busy oneself] /Garum
	farporet/A [def: busy, occupied]
poresh{prwS}/H [def: Pharisee] prushem{prwSym}/H
porets{pryc}/Xpritsem{prycym}/H [m] [def: landowner; lord] [origin: "porets{pryc} geder{gdr}"]
	pritse{prych}/Xpritses{prycwT} pritste/S [def: noblewoman]
	pritsish{prycish}/A [def: noble, aristocratic]
	pritste{prycte}/S [f] [def: wife of a landowner]
	pritsa'k/Ees [m] [def: landowner (pejorative)]
porke/V/T [def: be lazy (with "zikh"); busy oneself (with "zikh"); poke at]
porkh [m?] porekh [m?] porokh [m?] [def: dust]
	farporoshet/A [def: dusty; snowy]
pornografye/S [f] [def: pornography]
	pornografish/A [def: pornographic] 
porode/S [def: species] % NY
porpl/V/T [def: fling oneself (with "zikh")]
porske/V/T [def: snort] porshke/V/T
porta'l/N [m?] [def: portal, entranceway]
porto [m] [def: cost of delivery, mailing charge]
	portativ/A [def: portable]
	portativkayt/N [f] [def: portability] 
portfel/N [m] [def: portfolio, document case]
portobelo [adj] [def: portobello mushroom (food)] % Forwards: S-R Schaechter
portret/N [m] [def: portrait]
portsela'n portselay' [n] [def: porcelain] portselayen/A
portsye/S [f] [def: portion] 
portye'/Een [m] [def: doorman, butler]
portye'r/N [m?] [def: portiere; curtain] 
posek{pswk}/Xpsukem{pswkym}/H [def: verse of Bible]
	posekvayz [adv] [def: verse by verse] 
	psak{psk}/H [def: adjudication; sentence] 
	paskn{pskn}/Vpaskenen{pskenen}/T [def: decide, adjudicate, rule] /Gtsu/Gop
	poysek{pwsk}/Xposkem{pwskym} [def: Rabbinic authority; commentary] 
	mafsek{mfsyk} [verb] [def: interrupt one's prayer (with "zayn")]
poselenye [def: settlement (Russian поселение)] 
posesye/S [f] [def: possession] 
	posesor/S [m] [def: landowner; tenant farmer]
poshe{pwSe}/Xposhem{pwSeym}/H [m] [def: sinner]
poshet{pSwt}/H/K pshite{pSyt#}/H [def: simple; plain]
	pashtes{pStwT}/H [def: simplicity] 
	pshat{pSt}/H [def: simple textual meaning] /D pshetl/Xekh
	pshetl{pStl}/Xpshetlekh{pStlekh} [def: quibbling]
		pshetl{pStl}/V/T [def: quibble (with "zikh")] /Goys
	apshite{apSyt#}/H [def: all the more]
poshline/S [f] [def: tax, dues] 
poshlyad [m?] [def: vegetable waste]
posl{pswl}/H [def: unfit]
	pasl{psl}/H/V/T [def: declare unfit] 
		[idiom: paslen{pslen} a krankn = heal someone from an evil eye by washing with urine]
	poslen{pswlen}/H [def: unfit things (with "treyf-")]
	pasles{pslwT} [f] [def: dishonesty]
	paslones{pslnwT}/N [n] [def: immorality, evil]
	treyf-posl{tryf-pswl} [m] [def: nonreligious or heretical book (in Hebrew or Yiddish)]
posma'keve/V/T [def: smack the lips] 
	[idiom: posmakeven zikh mit epes = thoroughly enjoy something]
pospishne/S [f] [def: gift upon departing] % Stutchkoff
post/N [f/n] [def: mail] % MEYYED [f], Harduf [n]
	blitspost/N [f/n] [def: electronic mail]
		bli'tspostekhts/N [n] [def: spam, junk email] [note: V]
	blogpost/N [f/n] [def: blog posting] % Forwards
	diplomatn-post [f/n] [def: diplomatic bag] % Yiddish League
	flipost [f/n] [def: airmail] % Stutchkoff
	luftpost [f/n] [def: airmail]
	peklpost [f/n] [def: parcel post] % Harduf
	shleppost [f/n] [def: physical mail] 
	posilke/S/D [def: parcel (Russian посылка)] 
	potsht/N [f] [def: gossip; mail coach; mail]
		[idiom: optrogn potshtn = gossip]
	potshter/S [m] potshtalyon/N [m] [def: letter carrier, mailman]
postave/S [f] [def: posture (Polish postawa); appearance] % Avrom Karpinovitsh
postele/S [f] postale/S [f] [def: a type of boot (clothing)] % Stutchkoff
postemke/S [f] [def: facial expression]
postn/S [m] [def: soldier's position; job appointment]  
	avanpo'st/N [m] [def: military outpost]
	va'khpostn/S [m] [def: lookout post] % Berish Goldstein: Der Hobit
postoronke/S [f] [def: extraneous things?  Russian посторонний] % Sholem Aleykhem: Leykh Lekho
postula't/N [f?] [def: postulate, axiom; principl postulate, axiom; principlee]
	postuli'r/V/Bpostuli'rt [def: postulate] % D-H Katz
pota'keve/V/T [def: consent; nod in agreement (Polish "tak")]
	pota'kever/X/S [m] [def: yes-man, flunky] % Stutchkoff
potash [m] [def: potash (KOH)] 
potefalnost [n] [def: khutspe, audacity]
	potefalne/A [def: audacious]
pote'nts [f?] [def: power]
	potentsya'l/N [m] [def: potential]
	potentsye'l/A [def: potential] 
potike{pwWik#} [f?] [def: treasure, sum of money]
potkeve/S podkeve/S [f] [def: hoof; horseshoe]
	po'tkeve/V/T po'dkeve/V/T [def: nail a shoe]
	[idiom: dem ferds baytsh-shtekels potkeve = a distant relation]
potrave/S [f] [def: course (of a meal); cooked dish]
-/Xpo'trekhes [def: innards; rags]
	[idiom: er farshtekt im in di potrekhes = he's superior to him] % Stutchkoff
pots/Xpets [m] [def: penis (body part) (taboo)] petske/S [f]
potsh/N [f] [def: rumor; gossip]
po'tshene/S [f] [def: sidewalk] % Stutchkoff
	po'tshene/S [f] [def: awning] [note: V]
potshontek/Xpotshontkes [m] [def: beginning, start]
potsherane [f?] [def: semolina (grain)]
potshevke/S [f] [def: lining (clothing)] 
povetine/S [f] [def: spider web]
povidle/S [f] [def: prune jam (food)] 
po'vod [def: reins (horse)]
povterne [adv] [def: next; immediately]
povyerene/S [def: attorney (Russian поверенный)] 
poye/V/T [def: give drink to (animals)] /Gon
poyer/N/Xpoy'erem{poyerym}/D [m] /Iish /Ish poy'erte/S [f] [def: peasant; jack (playing cards)]
po|yezd [m] [def: train (Russian поезд)]
poyk/V/T [def: drum]
	/Goys [def: publicise]
	tsepoyk/V/Btsepoykt [def: drum, hype] 
	poyk/N [f] [def: drum] /Dpayk
		keslpoyk/N [f] [def: kettledrum]
		paykler/S [m] [def: drummer]
poyl{pw|el}/H/V/T [def: accomplish]
	/Goys [def: achieve]
	poyl{pw|el}/H [m] [def: result] /Lbe{b} [adv] [def: in effect]
	poyl_yoytse{pw|el-ywc#} /H [m] [def: result, upshot]
		/Lbe{b} [adv] [def: as a result]
	pule{pewlh}/Xpules{pewlwT}/H [f] [def: effect]
poyser{pwTr}/Xpoysrem{pwTrym} [m] [def: explainer]
	poyser{pwTr} [verb] [def: explain (with "zayn")]
	pisren{piTrwn}/Xpisroynes{piTrwnwT} [m] [def: explanation]
poysh/N [m] [def: bulge, swelling] /Iik
	poysh/V/T [def: puff up, swell (with "zikh")] /Gon
poy'tike{pwWyky}/Xpoy'tikes{pwWykwT} [f] [def: treasure]
poyze/S [f] pauze/S [f] [def: pause] 
poyze/V/T [def: creep, crawl] /Garayn/Garoys
	poyzhe/V/T [def: creep, crawl]
poze/S [f] [def: pose] 
	pozi'r/V/Bpozi'rt [def: pose] 
	puent-poze/S [f] [def: pointe (ballet)] [note: V]
po'zemke/S [f] po'zhemke/S [f] [def: wild strawberry (food)]
pozesiv/A [def: possessive (grammar)] 
pozharne/A [def: fire station (Russian пожар)]
pozitiv/K [def: positive]
pozitsye/S [f] [def: position] 
-/Xprakes [def: cabbage stuffed with rice and meat (food)] % only in plural
pragmatizm/N [m] [def: pragmatism]
	pragmatish/A [def: practical, pragmatic]
prakht [f] [def: splendor, magnificence; precious thing]
	prakhtful/A prekhtik/A prakhtik/A [def: precious; marvelous] 
praktik praktish/A [def: practical]
	praktike/S [f] [def: medical practice]
	praktika'nt/N [m] praktika'ntke/S [f] [def: intern (student)] 
	praktisti'r/V/Bpraktitsi'rt [def: practice]
pral/V/T [def: bounce off; show off] /Garayn/Goys
	/Goyf [def: open wide]
	/Gtsurik [def: flinch, start with surprise; recoil]
	tsepral/V/Btsepralt [def: open wide]
	onpral/N [n] [def: attack]
pralne [f?] [def: laundry (Polish pralnia)] % J. Opatoshu: dzhim vang
	pralnik/Ees [m] [def: laundry beater]
prazeodimyum [m] [def: praseodymium (Pr)] 
prat{prt}/Xprotem{prtym}/H [m] [def: detail] /D
	protemdik{prtymdik}/A [def: detailed]
	protis{prtyT}/H [def: divine providence (with "hashgokhe -")] 
pratse/X [f] [def: toil]
	pra'tseve/V/T [def: toil] 
pratshke/S [f] [def: washerwoman] [usage: not recommended]
	pratshe/V/T [def: wash clothes] % Der Nister
	pratsh/N [m] [def: laundry beater; mallet]
prave/V/T [def: celebrate]  /Goys [def: equip (with "mit")]
	farprave/V/Bfarpravet [def: equip (with "mit")]
pravoslav/N [def: Greek Orthodox person]
	/In /Ine [def: Greek Orthodox]
	pravoslavye [f] [def: Greek Orthodoxy]
prav [m] prave/S [f] [def: right, permission (Russian прав)]
	pravozhitelstve/S [def: residency permit]
praykh/V/T /Garoys prakh/V/T [def: wheeze]
praymeri/Es [f?] [def: primary election (America)]
prays/N [m] [def: cockroach (animal)] 
	prusak/Ees [m] [def: cockroach (animal) (Belarusian `прусак')] % Stutchkoff
prayz/N [m] [def: price; award] 
	markprayz/N [m] [def: market price] [note: V] 
prazhe/V/T [def: fry] /Goys
prenumera'nt/N [m] [def: subscriber (to support an upcoming publication)]
predsyetdatel/Ees [m] [def: chairman (Russian председатель)]
prefera'ns prefera'nts [def: preference (card game)]
preferi'r/V/Bpreferi'rt [def: prefer] % Stutchkoff
	prefere'nts/N [f] [def: preference] 
prefiks/N [m] [def: prefix] 
pregl/V/T [def: fry; render (fat)] /Goys/Gop/Gon/Gayn
prela't/N [m] [def: priest, prelate]
premye/S [f] [def: award, prize] 
	premi'r/V/Bpremi'rt [def: win an award]
premye'r/N [m] premyershe/S [f] [def: prime minister] 
premyere/S [f] [def: premiere (theatrical)] 
	avanpremyere/S [f] [def: advance screening (film)] 
prent/N/Ees [m] [def: stake; metal bar] /D [def: slice (of bread) (food)]
prepara't/S [f?] [def: preparation, compound; patent medicine]
	preparatke/S [f] [def: preparation, compound]
prepozitsye/S [f] [def: prep (grammar)] 
prerye/S [f] [def: prairie] 
pres/V/T [def: press] /Gtsunoyf
	/Goys [def: balance out (with "zikh"); iron (clothing)]
	prese/S [f] [def: press] /Dpres
		veltprese/S [f] [def: world-wide press] % Forwards: Yoel Matveyev
	farprest/A [def: pressed together]
presbiteryer/X [def: Presbyterian (religion)]
preservi'r/V/Bpreservi'rt [def: preserve] % Forwards: Burko
prestarets [m] [def: old man (Ukrainian престарец)]
presti'zh [m] [def: prestige; cachet] % Harduf
pretendi'r/V/Bpredendi'rt [def: pretend]
	pretenzye/S [f] [def: pretence; claim] 
	pretende'nt/N [m] [def: claimant] 
pretsede'nt/N [m] [def: precedent] 
	[idiom: on a pretsedent = unprecedented]
pretsept/N [def: precept] 
pretshmelyet/A [def: stupefied]
pretsl/Xpretslekh [n] [def: pretzel] 
pretsiz/A [def: precise]
	pretsizkayt/N [f] [def: precision] 
preventi'v/A [def: preventive; protective]
preyd [m] preydik/Ees [m] [def: forequarters (meat)]
preydik/V/T predik/V/T [def: preach] 
	preydikung/N [f] predikung/N [f] [def: preaching] 
	preydiker/S [m] preydikerke/S [f] [def: preacher] 
preygl/V/T [def: fry] /Gayn
preykhe/V/T [def: pant] % Y. Y. Singer
preympl/V/T prepl/V/T [def: pray (non-Jewish) (pejorative)]
prezent/N [m] [def: present, gift] 
	prezenti'r/V/Bprezenti'rt [def: present] 
prezervi'r/V/Bprezervi'rt [def: preserve]
pre'zhenitse/S [def: omelet, scrambled eggs]
prezide'nt/N [m] [def: president] /Iish [def: presidential] 
	prezidentshaft/N [f] [def: presidency]
	vitseprezide'nt/N [m] vitseprezidentin/S [f] [def: vice-president]
	printsedatel/Ees [m] [def: president (humorous)]
pribludne/A [def: confused]
prie/V/T praye/V/T [def: cook; steam; sweat; bother]
	tseprayet/A [def: sweating; in a bother]
prika'z/N [m] [def: command, order]
	prikashtshik/Ees [m] prikaztshik/Ees [def: overseer; merchant's clerk]
prikre/K [def: unpleasant]
	 pri'krekayt/N [f] [def: unpleasantness; embarrassment]
prima [adj predicative] [def: first-rate, prime]
primiti'v/A [def: primitive]
	primitivkayt/N [f] [def: primitiveness]
prints/N [m] [def: prince] printsesin/S [f] [def: princess]
	pri'tseve/V/T [def: play prince; lord it] 
	kroynprints/N [m] [def: crown prince]
printsip/N [m] [def: principle] /Ial [m] [def: principal] 
	printsipye'l/A [def: in principle] % Forwards: Yoel Matveyev
priom [m] [def: Russian army draft]
priparke/S [def: hot bandage]
	[idiom: kalte priparkes = a punishment]
pripetshik/N [def: oven] 
prishtsh/Ees [m] [def: pimple] /Iik /D prishtshik/Ees [m] /D
	prishtshevat/A [def: pimply] % I. J. Singer
prisik [m] [def: embers, live coals]
prista'n [n] [def: pier] [usage: not recommended]
pristav/Ees [n] [def: police commissioner (Russian пристав "bailiff")] 
prister/S [m] pri'sterin/S [f] [def: pagan priest]
prisut|stve/S [f?] [def: municipality building]
pritshepe/S [f] [def: quarreler; annoyance; well hoist]
	pritshepke/S [f] [def: occasion for quarrel]
pritshmelye/V/Bpritshmelyet [def: astound; overwhelm, stupefy, stun, daze, stagger]
pritulye/V/Bpritulyet [def: care for, protect] [usage: not recommended]
privat/A [def: private]
	privatkayt/N [f] [def: privacy] 
	privatizi'r/V/Bprivatizi'rt [def: privatize] 
privilegye/S [f] [def: privilege] 
	privilegirt/A [def: privileged]
priz/N [m] [def: prize]
prizbe/S [f] [def: bench (earthen, on outside of house)]
priziv/Ees [m] [def: draft into the Russian army (Russian призыв)]
	prizivnik/Ees [def: draftee] 
	[idiom: zikh tsushteln tsum priziv = enlist]
probe/S [f] prob/N [m] [def: attempt, essay; probation; try-out (theatrical); rehearsal (theatrical)] 
	klangprobe/S [f] [def: sound check] [note: V] 
	[idiom: zayn oyf probe = hobn probe = be on probation]
	[idiom: nemen/shteln oyf probe = put on probation]
	[idiom: extemporir-probe = improvizir-probe = jam session (music)] [note: V]
problem/N [f] [def: problem] /D
	problematish/A [def: problematic] 
		problematishkayt/N [f] [def: problematic nature] % Forwards: M. Krutikov
produtsi'r/V/Bprodutsi'rt [def: produce]
	produtsirer/S [m] produtse'nt/N [m] produtsentke/S [f] [def: producer] 
	produkt/N [m] [def: product]
		mitprodukt/N [m] [def: co-product (chemistry)] % Stephen Cohen
		produktiv/A [def: productive]
			produktivkayt/N [f] [def: productivity]
		produktsye/S [f] [def: production] 
		reproduktsye/S [f] [def: reproduction] 
profesor/Xprofeso'rn [m] /D profe'sorin/S profesorshe/S [f] [def: professor]
	profesye/S [f] [def: profession] 
	profesyone'l/A [def: professional] /Iish
	profesyona'l/N [m] [def: professional]
profi'l/N [m] [def: profile] % Harduf
profi't/N [m] [def: profit] % Harduf
	profiti'r/V/Bprofiti'rt [def: profit] 
	profitik/A [def: profitable] % Forwards: Hershl Glaser
prognoz/N [m] [def: forecast] 
	veter-prognoz/N [m] [def: weather forecast] 
program/N [f] [def: program]
	programke/S [f] [def: program (printed)] 
	programi'r/V/Bprogrami'rt [def: program] 
		programirer/S [m] programi'st/N [m] [def: programmer] 
	farprogrami'rt [def: programmed to be compliant] % Forwards: Estraykh
progres [m] [def: progress]
	/Iiv [def: progressive] 
	progresi'r/V/Bprogresi'rt [def: progress] 
proklami'r/V/Bproklami'rt [def: proclaim] 
	proklamatsye/S [f] [def: proclamation] 
prokuri'r/V/Bprokuri'rt [def: prosecute]
	prokurirung/N [f] [def: prosecution (act)] 
	prokuro'r/N [m] [def: prosecutor; district attorney] 
	prokuratu'r [f] [def: prosecution (office); district attorney's office] 
prol/N [m] [def: boast]
proletarya't/N [m] [def: proletariat]
	proletaryer/X [m] [def: proletarian] 
	proletarish/A [def: proletarian] 
prolo'g/N [m] [def: prologue] 
promakh [m] [def: error (Slavic)]
	[idiom: er iz nisht keyn promakh = he's clever with his hands]
promenad/N [f] promenade/S [f] [def: promenade (structure)]
prometyum [m] [def: promethium (Pm)] 
promilnik/Ees [m] [def: broker, agent]
prominent/A [def: prominent] 
prono'm/N [m] [def: pronoun (grammar)] 
propagandi'r/V/Bpropagandi'rt [def: propagandize] 
	propagande/S [f] [def: propaganda] 
	propagandistish/A [def: propaganda] 
propagi'r/V/Bpropagi'rt [def: propagate] 
propinatsye/S [f] [def: distillery] 
propn/S [m] propke/S [f] probke/S [f] [def: bottle stop; cork]
	on'gepropt/A [def: stuffed, crowded]
	farpro'bkeve/V/Bfarpro'bkevet [def: cork]
	farpro'pkeve/V/Bfarpro'pkevet [def: cork]
proponi'r/V/Bproponi'rt [def: propose] % Harduf
	propozitsye/S [f] [def: proposition, suggestion; theorem]
proportsye/S [f] [def: proportion]
	proports [f] [def: proportion] [usage: not recommended]
	proportsyonel/A [def: proportional] 
	disproports/N [f] [def: disproportion] 
prose [f] [def: millet]
proshik/Xproshkes [m] [def: powder; medicine] 
	ba'kproshik [m] [def: baking powder] % Forwards: S-R Schaechter
	milkhproshik [m] [def: dehydrated milk] 
	proshe/V/T [def: sprinkle] farproshet/A [def: drugged] 
proshenye/S [def: petition (Russian прошение)] proshenyele/Eekh 
prosperite't [f] [def: prosperity] % Harduf
prost/A [def: simple, unrefined, crude; ordinary; tacky, vulgar]
	prosta'k/Ees prostnya'k/N [m] [def: simple person] 
	prostkayt/N [f] [def: vulgarity] 
	farprosteve/V/Bfarprostevet [def: degrade]
prosta't/ [m] [def: prostate gland (body part)] % Michael Wex
	prostati't [m?] [def: prostatitis] % B. Sandler: Karolina-Bugaz
prostitutke/S [f] [def: prostitute] 
protaktinyum [m] [def: protactinium (Pa)] 
protagoni'st/N [m] protagonistke/S [f] [def: protagonist] 
protein/N [m] [def: protein (chemical)] 
protektsye/S [f] [def: patronage, pull, special influence; recommendation letter] 
	protektora't/N [m] [def: protectorate] 
protesti'r/V/Bprotesti'rt [def: protest] 
	protestirer/X/S [def: protester] % Forwards
	prote'st/N [m] [def: protest, formal complaint]
		[idiom: unter prote'st = under protest] 
		[idiom: oys prote'st = in protest] 
	protesta'nt/N [m] [def: Protestant] /Iish
protezhi'r/V/Bprotezhi'rt [def: promote, countenance, back] 
	protezhe [m] [def: protegée] 
protivlyave/V/Bprotivlyavet [def: oppose (Russian)] 
protokol/N [m] [def: protocol; summons; etiquette] 
proton/N [def: proton] 
prototip/N [m] [def: prototype] 
protsedu'r/N [f] [def: procedure] 
protsent/X/N [m] [def: percent; interest] /Iik /D
	protsentnik/Ees [m] [def: usurer] 
protses/N [m] [def: court case; process] 
	protsesi'r/V/Bprotsesi'rt [def: process, try (a court case)]
		farprotsesi'r/V/Bfarprotsesi'rt [def: acquire by litigation] % Rokhl Korn: Erd
	protsesirung/N [f] [def: processing] 
protsesye/S [f] [def: procession] 
provints/N [f] [def: province]
	provintsyali'zm/N [m] [def: provincialism]
	provintsyel/A [def: provincial] 
provizor/S [m] provizorin/S [f] [def: pharmacist]
provizorish/A [def: provisional, temporary] 
provotsi'r/V/Bprovotsi'rt [def: provoke]
	provokatsye/S [f] [def: provocation] 
	provokato'r/N/Ees [m] [def: informer (to the police); provocator]
		/Iish [def: provocative]
		provokati'v/A [def: provocative] % Forwards
provya'nt [m] [def: provisions] provizye
	aprovizatsye/S [f] [def: provisions] % Forwards
proye'kt{pro|yekt}/N [m] [def: project]
	forshproye'kt{forshpro|yekt}/N [m] [def: research project] 
	proyekti'r{pro|yektir}/V/Bproyekti'rt{pro|yektirt} [def: project; plan]
		proyektirung{pro|yektirung}/N [f] [def: projection; planning]
	proyektor{pro|yektor}/H/S [m] prozhektor/S [m] [def: projector]
		proyektsye{pro|yektsye}/S [def: projection]
proze [f] [def: prose]
	a'rblproze [f] [def: improvized speech (theater)] 
	fa'ktproze [f] [def: non-fiction] [note: V]
	folksproze [f] [def: prose of the people]
	takhles{WxlyT}-proze [f] [def: non-fiction] [note: V]
	prozaiker/S [m] [def: prose writer] prozaish/A [def: prosaic] 
	[idiom: hametne proze = boring prose]
prozhbe/S [f] [def: petition]
prute{prwth}/Xprutes{prwtwT}/H [f] [def: small coin (Mishnaic currency)] 
pruv/V/T [def: try; prove by affliction]
	/Goys [def: try out] 
	prubi'r/V/Bprubi'rt [def: try] /Goys
	probe/S [f] [def: test; attempt]
pyeshtshe/V/T [def: spoil (child), give in to, pamper] /Gavek
	tsepyeshtshe/V/Btsepyeshtshet [def: pamper]
pyo'n [m] [def: peony (flower)]
pyo'n [m] [def: pawn (chess piece)]
pyoni'r/N/Iish [m] pyone'r/N/Iish [def: pioneer] 
pryorite't/N [f] [def: priority; right of way] 
psevdoni'm/N [m] pseydoni'm/N [m] [def: pseudonym] 
pshistanek/Ees [m] [def: stop on a transportation line (Polish przystanek)] [usage: not recommended] % Stutchkoff
pshore{pSrh}/Xpshores{pSrwT}/H [f] [def: compromise, tradeoff]
	umpshoredik{umpSrhdik}/A umpshoresdik{umpSrwTdik}/A [def: uncompromising, inflexible] 
psikhe{pTyHh}/Xpsikhes{pTyHwT}/H [f] [def: opening] 
psikholo'g/N [m] [def: psychologist]
	/Iish [def: psychological]
	psikho- [prefix] [def: psycho-]
	psikhologye/S [f] [def: psychology] 
	psikhe [def: psyche]
		psikhik/A [def: psychic] 
		psikhish/A [def: spiritual; psychological]
	psikhodelish/A [def: psychodelic] % Forwards: Yoel Matveyev
	psikhoze/S [f] [def: psychosis] 
	parapsikhologye/S [f] [def: parapsychology]
		parapsikhologish/A [def: parapsychological] 
	psikhyatrye/S [f] [def: psychiatry] 
		psikhyater/S [m] [def: psychiatrist] 
pubertet/N [f] [def: puberty] 
publikatsye/S [f] [def: publication] 
	publikum [def: public] 
	publitsi'st/N [m] [def: publicist]
		publitsistik/N [f] [def: journalism]
		publitsistish/A [def: journalistic]
	publiki'r/V/Bpubliki'rt [def: publish] 
pud/N [def: about 36 pounds (Russian)] /Iik % abolished in USSR 1924
pudele/S [f] pudzhele/S [f] [def: scarecrow; fool]
	[idiom: makhn pudele fun = make fun of]
puder/S [m] pudre/S [f] [def: powder (cosmetic)] 
	ba'kpuder [m] [def: baking powder] % Forwards: S-R Schaechter
	milkhpuder [m] [def: dehydrated milk] 
	puder/V/T [def: apply powder] /Gon
	pudri'r/V/Bpudri'rt [def: apply powder] % Forwards: M-S Hoffman
	farpuder/V/Bfarpudert [def: apply powder to]
puding/N [m] [def: pudding] % Harduf
pudl/N [m] [def: poodle (dog)] % Harduf, Sholem Asch
pudle/S [f] [def: case, box]
puf/N [m] [def: puff (wind)] % L. Shapiro
puhatsh [m?] [def: screech owl (bird)]
pukh [m] [def: feather down; fluff]
	/Iik /Iove /Ike /In [def: soft; feather down] 
pulke/S polke/S [f] [def: thigh] 
pulpit/N [m] [def: pulpit] % Harduf
puls/N [m] [def: pulse] pulsi'r/V/Bpulsi'rt [def: pulsate] 
pulver/S [m] [def: powder] 
	pulverizi'r/V/Bpulverizi'rt [def: reduce to powder, atomize (convert to mist)] 
punkt/N [m] [def: point, exactly]
	punkti'r/V/Bpunkti'rt [def: dot, punctuate] 
	punkt [adv] [def: just, exactly] 
	pinktlekh/A [def: exact] umpinktlekh/A [def: vague] 
		farpinktlekh/V/Bfarpinktlekht [def: specify, be exact]
	pinktlekhkayt/N [f] [def: exactitude] umpinktlekhkayt/N [f] [def: vagueness] 
	aroyfshis-punkt/N [m] [def: launch pad] % Yiddish League
	dreypunkt/N [m] [def: pivot] 
	farbindpunkt/N [m] [def: hub (transportation)] [note: V]
	hoykhpunkt/N [m] [def: summit] 
	iberzets-punkt/N [m] [def: station where one changes trains] % Stutchkoff
	kerpunkt/N [m] [def: turning point]
	knippunkt/N [m] [def: hub (computer communications)] [note: V] 
	registri'r-punkt/N [m] [def: clearinghouse] [note: V]
	shtandpunkt/N [m] [def: standpoint]
	shtraytpunkt/N [m] [def: central issue; main conflict]
	shverpunkt/N [m] [def: bone of contention; difficulty]
	zamlpunkt/N [m] [def: center; gathering point]
pupik/Xpupkes/D [m] [def: navel, belly button (body part); gizzard (food)] 
	[idiom: Moyshe{mSh} pupik = John Doe (humorous)]
purem{pwrym}/H [m] [def: holiday of Purim] /Idik [def: Purim-like] 
puristish/A [def: purist] 
purita'n [m] [def: Puritan] /Iish % Sholem Asch: Ist River
purken{pwrkn}/H [def: redemption] 
puronyes{pwrenywT}/X/N [n] [def: disaster]
purpur /In [m] [def: purple] 
	purpl [m] [def: purple] /In
pushke/S [f] [def: can, charity box] /D
pushta'k/Ees [m] [def: hollow nut; dud] 
pust/A [def: empty; idle] /Ilekh pustkayt/N [f] [def: emptiness] 
	pu'stenish/N [f] [def: wasteland] 
	pusterheyt [adv] [def: emptily]
	pustsha'k/Ees [m] [def: empty nutshell; shallow person] 
	pustke/S [f] [def: slum; derelict housing]
	pu'steve/V/T [def: be empty] % Kulbak: Zelmenyaner; Y. Y. Singer 
	pustya'k [m] [def: simpleton]
puter [f] [def: butter] /Idik [def: buttery] 
	puter/V/T [def: churn butter]
	[idiom: geyn mit der puter arop = suffer misfortune]
puts/V/T [def: clean, shine; brush (teeth)] /Garayn/Gop/Gtsu
	/Goys [def: doll up, make fancy]
	baputs/V/Bbaputst [def: clean] baputsung/N [f] [def: cleaning] 
	farputs/V/Bfarputst [def: clean] 
	putser/S [m] pu'tserke/S [f] [def: cleaner; hatmaker]
	shikhputser/S [m] [def: shoe-shine person] 
	oysgeputsterheyt [adv] [def: well washed] % Bergelson
puzate/A [def: paunchy, big-bellied]
	puzevate/A [def: big-bellied] % Z. Sher, Fun der alter un nayer velt
pu'zhele/S [def: stick to control a horse]
pyane [f] pine [f] pyene [f] [def: foam, scum]
pyane/S [f] pyano/S [f] fortepya'n/N [m] fortepyano/S [f] [def: piano]
	pyani'st/N [m] pyanistke/S [f] [def: pianist] 
	pyano [adv] [def: piano, quiet (music)] % Stutchkoff
		pyani'simo [adv] [def: pianissimo (music)] % Stutchkoff
pya'nitse/S [f] [def: bilberry (Vaccinium spp.); lingonberry/cowberry (Vaccinium vitis-idaea); cranberry (Vaccinium oxycoccos)]
pyaske/S [f] [def: hound, bitch]
pyaster/S [m?] [def: piaster coin (Ottoman currency)]
pyata'k [m?] [def: 5-kopek coin (Russian currency)]
pyate/S [f] pyatke/S [f] /D pyente/S [f] [def: sole or heel of foot (body part)] 
	[idiom: akhileses-pyate = Achilles heel]
pyavke/S [f] [def: leech (animal)] /D
pyese/S/Xpyesn [f] [def: drama, play] 
pyeshtshe/V/T [def: spoil, dote on]
pyete't/N [f?] [def: piety] pyeti'zm/N [m] [def: piety]
pyeze/S [def: play (drama)] 
rabarber [m?] [def: rhubarb (vegetable)] % M. Schaechter: geviksn
rabe/A [def: speckled, spotted; calico (cat)]
	rabetine/A [def: freckled]
rabeve/V/T [def: steal, rob from (with "bay")] /Gtsu/Gon
ra'bine/S [f] [def: mountain ash (tree)] % M. Schaechter: geviksn
rabi'r/V/Brabi'rt [def: rob] /Goys
radar/N [m] [def: radar]
radika'l/N [m] [def: radical] /K
	radikali'zm [m] [def: radicalism]
radon [m] [def: radon (Rn)] 
radyo/S [m] [def: radio] 
radyum [m] [def: radium (Ra)] 
radyus/N [m] [def: radius] 
rafini'r/V/Brafini'rt [def: refine] 
	rafinerye/S [def: refinery (sugar or oil)]
	rafina'd [m] [def: refined sugar]
rahetsh [m] [def: device made from a wooden pole and a two-pronged metal holder for removing a pot from an oven (Ukrainian)]
rak [m] [def: cancer (disease); crayfish (animal); crustacean] /D
rak_{rk}/H [def: only]
rakem [adv] [def: face down]
rake't/N [m] rake'te/S [f] [def: rocket] /Draketke
	hey'brake't/N [m] [def: booster rocket] % Yiddish League
raketke/S [f] [def: racket (sports equipment); paddle (utensil)] % % Forwards: S-R Schaechter (paddle)
rakhash{rH″S} [n] [def: fee for religious service such as matchmaking] 
	[note: from "rov, khazn, shoykhet"]
rakhmone{rHmn#}/Xrakhmones{rHmnwT}/H [f] [def: mercy, pity]
	/Idik [def: merciful] 
	rakhomem{rHmym}/H [def: mercy; merciful people]
	umberakhmonesdik{umbrHmnwTdik}/A [def: unmerciful] 
	merakhem{mrHm}/H [verb] [def: show mercy (with "zayn")] 
	-/Xbney_rakhmonem{bny-rHmnym} [def: merciful people]
	rakhmone_letslan{rHmn# lycln}/H [def: God defend us] [connotations: out, demons!; tsk-tsk]
	hashem_yerokhem{hSm~yrHm} [interj] [def: may God show mercy]
	[idiom: mir iz a rakhmones{rHmnwT} oyf = my heart goes out to]
rakhves{rHBwT}/N/H [f] [def: breadth; luxury] /Idik [def: broad, spacious] 
	harkhove{hrHBh}/H [f] [def: breadth; luxury]
		beharkhove{bhrHBh} [adv] [def: at ease]
ram/N [f] [def: frame, bed frame, chassis] /Drem
	rem/V/T /Gayn reml/V/T /Gayn [def: frame, outline]
	hey'brem/N [f] [def: sash]
ramay{rmay}/Xramoem{rmoym} [def: swindler; imposter]
rampe/S [f] [def: ramp (in theater)] 
ramsh/N/Ees [def: junk, odds and ends] /D
rand/N [m] [def: edge]
	/Drend [def: ducat; gold coin (currency)]
	betrand/N [m] [def: edge of bed] % Rokhl Korn: shotns
	[idiom: a rendl arop, a rendl aroyf = you win some, you lose some]
	[idiom: oysbaytn dos rendl = convert to a different religion]
	[idiom: kostn a rendl = be expensive due to insufficient supply]
randevu [m] [def: rendezvous, date]
	randke/S [f] [def: date (social)] 
		ra'ndkeve/V/T [def: date (social, with "zikh ... mit")] 
rang/N [m] [def: rank; rating] /Iik
	range/S [f] [def: rank] % Avrom Karpinovitsh
	e'rshtrangik/A [def: top-ranking; straight-A] [note: V]
	hoy'khrangik/A [def: high-ranking] % Forwards
rangl/V/T [def: fight]
	gera'ngl/N [n] [def: struggle] ra'nglenish/N
rane/V/T ranye/V/T [def: wound] 
	rani'r/V/Brani'rt [def: wound] [usage: doubtful admissibility]
rapi'r/N [m] [def: rapier] % L. Shapiro
rapnik/Ees [m] harapnik/Ees [m] arapnik/Ees [m] narapnik/Ees [m] ratnik/Ees [m]  [def: whip]
rapo'rt/N [m] [def: report] % Stutchkoff, Avrom Karpinovitsh
	[idiom: konte-raport = bank statement] [note: V]
raptum [def: suddenly (Polish raptem)] raptem % both variants
rase/Xrasn/Xrases [f] [def: race] 
	rasi'st/N [m] [def: racist] /Iish
	rasi'zm/N [m] [def: racism] % Forwards
rash/V/T /Giber [def: astound, surprise] % only used with complement
	farrash/V/Bfarrasht [def: surprise] 
	iberrasht/A [def: surprised]
	iberrashung/N [f] [def: surprise] 
rash_{reS}/N /Iik /Idik [def: commotion]
	rashik/A [def: hasty; noisy] % spelled phonetically
	rash{reS}/V/T [def: make a commotion] 
rat/V/Bgerotn [def: advise] /Gop
	rot/V/Bgerotn [def: advise] % variant
	rot/N [m] rat/N [m] [def: council]
		rotgeber/S [m] rotge'berin/S [f] [def: advisor] 
		shtotrot/N [m] [def: city council]
	barat/V/Bbarotn [def: consult (with "mit")] 
		baratung/N [f] [def: consultation, suggestion] 
		[idiom: oyfn barot fun emetsn = at one's mercy]
	farrat/V/Bfarrotn [def: betray] farreter/S [m] farrater/S [def: traitor] 
		farra'terish/A [def: treasonous; treacherous] 
		farratung/N [f] [def: betrayal, treason]
	landshulnrat [m] [def: school council] 
	shtotrat [m] [def: municipal council]
	veltrat [m] [def: world council]
	yudnrat [m] [def: Jewish council]
rate/S [f] [def: premium, part payment, installment] 
	[idiom: nemen oyf rates = buy by installments]
ra'teve/V/T [def: rescue, save] /Garoys/Gop
	ra'tever/S [m] ratirer/S [m] [def: rescuer, lifeguard] 
	reter/S [m] [def: rescuer] retung/N [f] [def: rescue]
	ratir- [prefix] [def: rescue] % Forwards: S-R Schaechter
ratifitsi'r/V/Bratifitsi'rt [def: ratify (political)]
	ratifikatsye/S [def: ratification (political)]
rats/N/D [m] [def: rat] 
ratsik/A [def: rough] 
ratsye/S [f] [def: ration (food); reason, argument; point of view; kite; rocket]
ratsyone'l/A [def: rational (mathematics), reasonable]
	umratsyone'l/A [def: irrational (mathematics), unreasonable]
	ratsyonalizi'r/V/Bratsyonalizi'rt [def: rationalize (mathematics)]
	ratsyona'l/A [def: intellectual, rational, sober; wise; meaningful]
		ratsyonali'st/N [m] [def: intellectual]
		ratsyonali'zm/N [m] [def: rationalism (philosophy)]
			ratsyonalistish/A [def: rationalistic (philisophy)]
rayb/V/Bgeribn [def: grate, rub; devour; have sex with (vulgar); masturbate (with "zikh")]
	/Gop/Gayn/Gon/Gtsunoyf/Garayn
	/Goys [def: express; masturbate (with "zikh")]
	tserayb/V/Btseribn [def: grate; grind] 
	farrayb/V/Bfarribn [def: rub off]
	raybung/N [f] [def: friction, rubbing]
		aynraybung/N [f] [def: ointment, salve]
	ray'benish/N [n] [def: rubbing]
	
	[idiom: raybn a sude{sewdh} = binge]
	[idiom: raybn in beshalekh{bSlH} arayn = binge]
	[idiom: raybn a sude{sewdh} = eat with appetite]
raye{ra|yh}/Xrayes{ra|ywT}/H [f] [def: proof]
	[idiom: an ayzerne raye{ra|yh} l|dover{dBr} = smoking gun] [note: V]
ra|ye'l/A [def: realistic; honest]
rayf/K [def: ripe] rayfkayt/N [f] [def: ripeness] 
raykh/K [def: rich, wealthy] raykhkayt/N [f] [def: wealth] 
	raykhtum/Xraykhtimer [n] [def: wealth] [usage: inadmissible]
	baraykher/V/Bbaraykhert [def: enrich]
		baraykherung/N [f] [def: enrichment] 
	aynflusraykh/K [def: influential] 
	derfolgraykh/A [def: successful]
	farbnraykh/A [def: colorful]
	glorraykh/A [def: glorious] 
	tsolraykh/A [def: frequent; many] [usage: doubtful admissibility]
raynish/X [m] [def: coin (Austrian currency)]
rayo'n{ra|yon}/N [m] /Ier regyo'n/N /Ia'l [def: region]
rayon_{re|ywn}/H rayones{re|ywnwT}/H [def: imagination; meditation] 
rays/V/Bgerisn [def: pull; tear]
	/Garayn/Garoys/Garum/Gop/Gdurkh/Giber/Gavek
	/Garop [def: pull down; deprecate] [note: V]
	/Garunter /Gunter [def: tear down, destroy; damage; belittle] 
	/Gayn [def: budge; destroy one's health (with "zikh dos gezunt")] 
	/Giber [def: interrupt] 
	/Gmit [def: transport]
	/Gon [def: pick (flowers)]
	/Goyf [def: explode; open wide] 
	/Goys [def: tear away; suffer (with "vern")]
	opgerisn/A [def: ragged, tattered, in shreds]
	[idiom: opgerisener nar = complete fool]
	[idiom: aynraysn veltn = move heaven and earth]
	tserays/V/Btserisn [def: tear, rip] /Gtsu
		tserisnkayt/N [f] [def: opposition; disunity]
	farrays/V/Bfarrisn [def: tear]
		farrisn/A [def: torn; proud, snobbish, arrogant]
		farrisnkayt/N [f] [def: state of being torn; pride, arrogance] 
	hartsraysndik/A [def: heart-rending] 
		hartsraysenish/N [n] [def: heartbreak]
	iberrays/N [m] [def: interruption]
	opgerisnkayt/N [f] [def: separation; nakedness]
	oyfrays/N [m] [def: explosion] 
	oysray'senish/N [n] [def: disaster; unreachable place]
	rayser/S [m] [def: ripper, yanker] 
		arunterrayser/S [m] [def: vandal] /Iish [def: destructive]
			arunterrayserishkayt/N [f] [def: vandalism]
		aynrayser/S [m] [def: greedy person] /Iish [def: greedy]
		barayser/S [m] [def: expensive merchant, gouger] /Iish [def: expensive]
		iberrayser/S [m] [def: interrupter]
	rayseray'/N [n] gerayseray'/N [n] [def: argument, conflict]
	ray'senish/N [n] [def: fight] % Menakhem Kipnis
	raysik/A [def: stunning (color); abrasive (sound)]
	ris/N [m] [def: tear, crack, rip; sudden terminatin; gap, yank, jerk] 
		ayngerist/A [def: filthy] % perhaps from a different root
	[idiom: ris in a zayt = swerve]
	[idiom: ris in hartsn = a great pity]
	[idiom: ris oyf = start]
rayt/V/Bgeritn [def: ride]
	/Garayn/Garum/Gavek/Gon/Gariber/Gop/Garop/Garoys/Garoyf/Gtsu/Gnokh
	rayter/S [m] ray'terin/S [f] [def: rider] 
	riter/S [m] [def: knight (chivalry); knight (chess piece)]
		/Ilekh [def: knightly] ri'terke/S [f] [def: lady]
		ritershaft/N [f] [def: knighthood]
		bariter/V/Bbaritert [def: knight] % Forwards: M-S Hoffman
rayz [m] [def: rice] 
rayz/V/T [def: travel] /Garum/Gdurkh/Gtsu
	rayze/S [f] [def: voyage] 
	ray'znder/X [m] [def: (merchant) voyager] 
	barayz/V/Bbarayzt [def: travel widely (with "di velt")]
razberaye/V/T [def: understand, comprehend a problem (Russian)] 
razi'r/V/Brazi'rt [def: shave] /Gop
	razirer/S [m] [def: razor]
razmakh [m] [def: haste; impulse] [usage: not recommended]
razvedke/S [f] [def: reconnaissance (Russian разведка)
reagi'r/V/Breagi'rt [def: react]
	reaktsye/S [f] [def: reaction] 
		farbindung-reaktsye/S [f] [def: addition reaction (chemistry)] % Shmuel Broches
		oksidi'r-reaktsye/S [f] [def: oxidation reaction (chemistry)]
		zayers-reaktsye/S [f] [def: acid-base reaction (chemistry)] % Stutchkoff
	reaktsyone'r/A [def: reactionary (political)]
rea'l/A [def: real, actual] /Iistish [def: realistic]
	realizi'r/V/Brealizi'rt [def: make real; convert to money]
		realizatsye/S [f] realizirung/N [f] [def: realization, actualization] 
			[usage: inadmissible to use to mean "become aware of"]
	realite't/N [f] realkayt/N [f] [def: reality]
		umrealkayt/N [f] [def: unreality] 
	reali'zm/N [m] [def: realism]
	umreal/A [def: unreal] /Iistish [def: unrealistic]
	surealistish/A [def: surrealistic] 
rebeli'r/V/Brebeli'rt [def: rebel] 
	rebe'l/N [m] [def: rebel]
red/V/T [def: speak]
	/Garoys/Gtsu/Garayn/Garum/Gfunander/Gunter/Gtsuzamen
	/Gayn /Garayn [def: convince; agree] 
	/Garop [def: unburden oneself by talking] % Michael Wex
	/Gdurkh [def: discuss (with "zikh")] 
	/Giber [def: reconcile]
	/Gnokh [def: repeat]
	/Gon [def: disparage, denigrate (with "oyf")]
	/Gop [def: preclude; arrange, agree upon] 
		[idiom: opgeredt = out of the question]
	/Goyf [def: collaborate; get along]
	/Goys [def: talk things out; stipulate a condition]
	/Gtsunoyf [def: collude (with "zikh")] % Yiddish League
	/Gtsurik [def: retract (statement)] 
		[idiom: ober tsurikgeredt = on the other hand]
	reyd/V/T [def: speak] % variant
		/Garop/Garoys/Gon/Gtsu/Garayn/Goys/Garum/Gfunander/Goyf/Gunter/Gtsuzamen
		/Giber [def: reconcile]
		/Gop [def: preclude] 
		/Gayn [def: convince] 
		/Gtsurik [def: retract (statement)] 
		/Gdurkh [def: discuss (with "zikh")]	
	re'denish/N [n] [def: discussion]
		aynre'denish/N [n] [def: misconception, delusion, idée fixe] 
		oysre'denish/N [n] [def: pronunciation] % I. J. Singer
	reder/S [m] re'derin/S [f] [def: speaker]
		redner/S [m] re'dnerin/S [f] [def: speaker]
		boy'khreder/S [m] boy'khrederin/S boy'khrederke/S [f] [def: ventriloquist]
		gastredner/S [m] [def: guest speaker] 
	redevdik/A [def: talkative] 
	rede/S [f] [def: speech]
		forrede/S [f] [def: introduction]
	reyd [f] gerey'd [m] [def: speech]
		aroysreyd/N [m] aroysred [m] [def: speech; pronuciation; excuse]
		i'berreyd/N [m] i'berred/N [m] [def: dispute; conversation]
		opred/N [m] [def: agreement]
		oysreyd [def: false explanation; excuse] % Avrom Karpinovitsh
		tsunoy'fred [m] [def: collusion] % Yiddish League
		bareydevdikayt/N [f] [def: loquaciousness, talkativeness]
		[idiom: hobn in zikh nayn mos reyd = be talkative]
		[idiom: puste reyd = nonsense]
	farred/V/Bfarredt farreyd/V/Bfarreydt [def: disturb; talk overlong (with "zikh")]
	bared/V/Bbaredt [def: slander, defame; backbite]
		bareder/S [m] [def: slanderer]
		bare'devdik/A [def: voluble, loquacious; slanderous] 
		bare'devdikayt/N [f] [def: volubility, loquaciousness]
	tsered/V/Btseredt [def: talk for a while (with "zikh")] 
	derred/V/Bderredt [def: reach an understanding (with "zikh")] 
		derredtkayt/N [f] [def: inconclusiveness] 
	[idiom: derredn zikh tsu = come to the conclusion (in conversation)]
	gere'd/N [n] geredekhts [n] gerederay'/N [n] [def: talk] 
	[idiom: kumen tsu red = be under discussion]
	[idiom: vi mir hobn geredt = as per our conversation] [note: V]
redagi'r/V/Bredagi'rt [def: edit] /Goys
	redakti'r/V/Bredakti'rt [def: edit]
		redaktor/S/N [m] /Iish reda'ktorin/S redaktorshe/S [f] [def: editor]
		redaktsye/S [f] [def: editorial staff] 
reduktsye/S [def: reduction (also chemistry); discount, rebate]
	[idiom: reduktsye fun brukhtsoln = reduction of fractions (mathematics)]
referi'r/V/Breferi'rt [def: give a lecture] 
	refera't/N [m] [def: lecture; scholarly paper] 
		bukh-refera't/N [m] [def: book report]
		refere'nt/N [m] [def: lecturer]
	refere'nts/N [f] [def: reference] 
	referendum/S [m] [def: referendum (polictics)] % Forwards: Y. London
reflekti'r/V/Breflekti'rt [def: reflect] 
	reflekti'v/A [def: bright] % Sholem Aleykhem
	refleks/N [m] [def: reflex (physiology)]
	refleksye/S [f] [def: reflection]
	refleksi'v/A [def: reflexive (linguistics)]
reform/N [f] [def: reform] /Iish [def: reform]
	reformi'r/V/Breformi'rt [def: reform]
	reformirer/S [m] [def: reformer] 
	reformer/S [m] reformi'st/N [m] [def: member of reform sect] /Iish
refreyn/S [m] [def: refrain] 
rift/N [m?] [def: piece] % Forwards: Boris Sandler
	reftl/Eekh [n] [def: slice; first cut] 
	tsere'ftlt/A gere'ftlt/A [def: sliced] % Forwards: S-R Schaechter
reg/V/T [def: trouble] /Goyf [def: annoy] /Gon
	oyfregung/N [f] oyfgeregtkayt/N [f] [def: annoyance] 
rege{rge}/Xreges{rges}/H [f] [def: moment, second (unit of time)] /D
regiles{rgylwT}/H/N [f] [def: custom]
regime'nt/N [m] [def: regiment (military)]
regi'r/V/Bregi'rt [def: rule] 
	regirung/N [f] [def: government]
	regirungs [adj] [def: governmental] [grammar: indeclinable]
	reglame'nt/N [m] regulami'n/N [m] [def: regulation] 
		reglamenti'r/V/Breglamenti'rt [def: regulate] 
registratsye/S [f] [def: registration]
	registri'r/V/Bregistri'rt [def: register] 
		registrirung/N [f] [def: registration]
	farregistri'r/V/Bfarregistri'rt [def: pre-register] 
	register/S [m] reyster/S [m] [def: register (music); register (record)]
		tsayt-register/S [m] [def: almanac]
regl{rgl}/Xregolem{rglym}/H [def: pilgrimage holiday]
	oyle_regl{ewlh-rgl} [verb] [def: make a pigrimage (with "zayn")]
	drises-horegl{drysT-hrgl} [n] [def: permission to enter (with "in")]
regn/S [m] [def: rain] /Idik [def: rainy] /Dregnd
	go'ldregn/S [m] [def: laburnum, golden chain (small tree)]
	regn/V/T [def: rain] 
	shlaksregn/S [m] [def: downpour]
reguli'r/V/Breguli'rt [def: regulate; adjust] /Gayn
	reguler/A [def: regular]
		regulerkayt/N [f] [def: regularity]
		umregulerkayt/N [f] [def: irregularity]
	harts-regulirer/S [m] [def: pacemaker] 
	regulatsye/S [f] [def: regulation] 
	umregulirt/A [def: unregulated] % Forwards: Yankev Goldshteyn
rehabiliti'r/V/Brehabiliti'rt [def: rehabilitate] 
rekhiles{rxylwT}/H [def: malicious gossip] 
	rekhileve{rxylhve}/V/Brekhilevet{rxylhvet} [def: spread gossip]
	rekhiles{rxylwT}/V/T [def: spread gossip]
	rekhilesnik{rxylwTnik}/Ees [m] [def: gossip]
rekhitse{rHych}/Xrekhitses{rHycwT} [f] [def: murder]
rekhn/V/T [def: calculate, plan] /Goys/Giber/Gtsunoyf/Gtsu
	/Garayn [def: include]
	/Gop [def: deduct; pay or receive payment for a bill]
	/Garop [def: deduct (amount)]
	/Gunter [def: sum up, enumerate]
	barekhn/V/Bbarekhnt [def: calculate, consider; change one's mind (with "zikh")]
	farrekhn/V/Bfarrekhent [def: account] 
	tserekhn/V/Btserekhnt [def: deal with (with "zikh")] % Forwards: Genadi Estraykh
	re'khenung/N [f] [def: accounting; arithmetic] 
		aro'prekhenung/N [f] [def: discount] 
		farre'khenung/N [f] [def: payment] 
		fi'nger-rekhenung/N [f] [def: counting on fingers] 
		o'prekhenung/N [f] [def: deduction (amount)]
		oy'srekhenung/N [f] [def: computation]
		tsay'trekhenung/N [f] [def: calendrical scheme]
	[idiom: dos rekhent zikh nit = that doesn't count!]
rekht/N [n] [def: right (privilege)]
	rekht/A [def: right (direction)]
		rekht|s [def: right (direction)] 
	gere'kht/A [def: correct, right] [usage: of a person]
		umgerekht/A [def: wrong] [usage: of a person]
		gerekhtikayt/N [f] [def: correctness; justice] 
		umgerekhtikayt/N [f] [def: incorrectness; injustice] 
		[idiom: gerekht iz gerekht = when you're right, you're right]
	barekhtik/V/Bbarekhtikt [def: justify]
		barekhtikung/N [f] [def: justification]
			glaykhbarekhtikung/N [f] [def: equal rights] 
				glaykhbarekhtikt/A [def: equally justified] 
		barekhtiktkayt/N [f] [def: justifiability] 
		onbarekhtikt/A [def: without civil rights] % Sholem Aleykhem
		fulbarekhtikt/A [def: entitled]
		[idiom: barekhtikt tsu = entitled]
	tsurekht [def: in order] 
		[idiom: tsurekht makhn = fix]
	mentshnrekht [n] [def: human rights]
	shtimrekht [n] [def: voting rights]
	drukrekht [n] [def: imprimatur; copyright]
	postnrekht [n] [def: tenure] 
	umrekht [n] [def: wrong, injustice] 
	vetorekht [n] [def: veto power] 
	rekhtfartik/A [def: upright, proper] [usage: archaic]
rekl/N [n] [def: jacket (clothing)] 
reklami'r/V/Breklami'rt [def: advertise] 
	reklame/S [f] [def: advertisement] 
		info-reklame/S [f] [def: infomercial] [note: V] 
rekomendi'r/V/Brekomendi'rt [def: recommend] 
	rekomendatsye/S [f] [def: recommendation]
rekordi'r/V/Brekordi'rt [def: record]
	reko'rd/N [m] [def: record (evidence; achievement)] 
	rekordirke/S [f] [def: recorder (machine)]
	rekordirung/N [f] [def: recording (object)]
rekrut/N [m] [def: recruitment] 
	rekruti'r/V/Brekruti'rt [def: recruit]
	rekru'tshine [def: military press gang] % Der Nister
	[idiom: zikh tsushteln tsum rekrut = enlist]
rektor/N [m] rektorshe/S [f] [def: rector, dean]
rekvizi'r/V/Brekvizi'rt [def: requisition] 
	rekvizitsye/S [def: requisition]
	rekvizit/N [def: prop (theater)]
relati'v/A [def: relative]
	relativkayt/N [f] relati'vite't [f] [def: relativity] 
religye/S [f] [def: religion] /Iz [def: religious] 
	religye'z/A [def: religious] religyezkayt/N [f] [def: religiousity]
		umreligye'z/A [def: irreligious] umreligyezkayt/N [f] [def: irreligiousity]
rels/N [m] [def: rail] 
relye'f/N [m] [def: relief (sculpture)]
	barelye'f/N [m] [def: bas relief (sculpture)]
	hoykhrelye'f/N [m] [def: high relief]
rem/V/T /Gayn [def: border]
remarke/S [f] [def: note, notation]
rema'tes [m] rematn-feler/S [m] revmatizm/N [m] [def: rheumatism (disease)]
remez{rmz}/Xremozem{rmzym}/H [def: hint, allegory, allusion]
	meramez{mrmz}/H [verb] [def: hint (with "zayn")] 
remi{rmy}/H [def: tie (outcome of contest)] 
renesans/N [m] [def: renaissance] 
renife'r/N [m] [def: reindeer (animal)]
renome/S [f] [def: good name]
renovi'r/V/Brenovir't [def: renovate] 
/Drents [n] [def: satchel] % no positive form
	shu'lrentsl/Eekh [n] [def: school bag] % Forwards: Boris Sandler
renyum [m] [def: rhenium (Re)] 
repari'r/V/Brepari'rt [def: make amends]
	reparatsye/S [f] [def: reparation] 
repertuar/N [m] [def: repertoire] 
repeti'r/V/Brepeti'rt [def: practice (a speech)]
	repetitsye/S [f] [def: rehearsal]
	repetito'r/N [m] [def: tutor] % Sholem Aleykhem
	repetireve/V/T [def: practice; tutor] % Sholem Aleykhem
repli'k/N [m?] replike/S [f] [def: dialogue (theater); repartee; replica, copy]
repo'rt/N [m] [def: report]
	reporter/N [m] reporterin/S [f] [def: reporter]
	reporta'zh/N [def: reporting, reportage] 
represye/S [f] [def: repression, subjugation]
	represiv/A [def: repressive] 
reprezenti'r/V/Breprezenti'rt [def: represent, speak for]
	reprezentant/N [m] [def: representative]
		reprezentatsye/S [m] [def: representation]
		reprezenta'nts/N [m] [def: leadership] 
republik/N [f] [def: republic]
	folksrepublik/N [f] [def: people's republic]
	republikaner [adj] republikanish/A [def: Republican (political party)] 
reputatsye/S [f] [def: reputation]
reshime{rSymh}/Xreshimes{rSymwT}/H [def: list] 
reshinke/S [f] [def: fruitcake served after a circumcision]
reshotke/S [f] [def: grate, grill (window); barbeque grill] 
	reshete/S [f] [def: sieve]
resht/N [f/n] /D reshte/S [f] [def: rest, remainder, excess; change (money)]
reso'r/N [m] [def: shock absorber (on a vehicle)]
reshu's{rSwT}/H [m] [def: permission; ownership] 
respekt [m] [def: respect, honor] 
	respekti'r/V/Brespekti'rt [def: respect, honor] % Forwards: S-R Schaechter
	umrespekt [m] [def: disrespect] 
responde'nt/N [m] [def: respondent] % Forwards: B. Sandler
	korespondi'r/V/Bkorespondi'rt [def: correspond]
		korespondent/N [m] [def: correspondent]
		koresponde'nts/N [f] korespondentsye/S [f] [def: correspondence]
			teykef{WyKf}-korespondentsye/N [f] [def: instant message, IM (computer)] [note: V] 
restavri'r/V/Brestavri'rt [def: restore]
	restitutsye/S [f] [def: restitution]
restora'n/N [m] restoratsye/S [f] [def: restaurant] 
resurs/N [m] [def: resource] 
retekh [m] [def: radish] /D
re'tenish/N [n] [def: puzzle] 
retikyu'l/N ridikyu'l/S ridiku'l/S [m] [def: handbag]
retorik [f] [def: rhetoric (subject)] retorish/A [def: rhetorical] 
retsenzi'r/V/Bretsenzi'rt [def: review (critical)]
	retsenzye/S [f] [def: review (critical)] 
	retsenzent/N [m] retsenzentin/S [f] [def: reviewer, critic]
retse'pt/N [m] [def: recipe; prescription] 
retsesi'v/A [def: recessive (genetic trait)] [note: V]
	retsesye/S [f] [def: recession (economic)] % Forwards
retseyekh{rwcH}/Xrotskhem{rwcHym}/H [m] ratskhn{rcHn}/Xratskhonem{rcHnym} [m] [def: brutal person; murderer]
	retsikhe{rcyHh}/H [f] [def: strong anger; murderousness; murder] /Kretsikhedik{rcyHhdik}
		retsikhish{rcyHish}/A retsikhedik{rcyHhdik}/A [def: murderous; violent; furious]
	rotskhish{rwcHish}/A [def: murderous, vicious]
	tirtsakh{WrcH}/H [def: you shall (not) murder] 
	retsikhe{rcyHh}/Xretsikhes{rcyHwT}/H [f] [def: murderous intent] /Idik
	ratskhn{rcHn}/V/T [def: murder, kill]
retsiti'r/V/Bretsiti'rt [def: recite]
	retsitatsye/S [f] [def: recitation] 
	retshitati'v [m] [def: recitative (music)]
retshke [f] [def: buckwheat (plant)] retshn/A [def: buckwheat]
	retshishnik/Ees [m] retshitshnik/Ees [m] retsisnik/Ees [m] [def: buckwheat pudding]
retsue{rcweh}/Xretsues{rcwewT} [f] [def: strap; thong]
retushi'r/V/Bretushi'rt [def: retouch, touch up]
revansh/N [m?] [def: revenge]
	revantshistish/A [def: revisionist] 
	revanshi'r/V/Brevanshi'rt [def: reciprocate (with "zikh")]
reve/V/T [def: roar, howl] /Goys/Goyf
	rev/N reve/S [m] gere'v/N [n] [def: howl]
revekh{rvH}/Xrevokhem{rvHym}/H [m] reyvekh{ryvH}/Xrevokhem_{ryvHym} [m] [def: profit, increase]
	 /Idik revokhemdik{rvHymdik}/A [def: profitable]
revelatsye/S [f] [def: revelation] % Forwards: Yitskhok Luden
revera'ns/N [m] [def: curtsey] 
revere'nd/N [m] [def: Reverend]
revidi'r/V/Brevidi'rt [def: review, inspect, audit] 
	revizo'r/N [m] revizorshe/S [f] [def: inspector, auditor] 
	revizye/S [f] [def: revision; house search; audit] 
revir/N [m] [def: precinct] 
revolti'r/V/Brevolti'rt [def: revolt] 
	revo'lt/N [m?] [def: rebellion]
	revolutsye/S [f] [def: revolution]
		konter-revolutsye/S [f] [def: counter-revolution] % Sholem Aleykhem
	revolutsyone'r/S/A [m] /A revolutsyonerke/S [f] [def: revolutionary (person)]
		revolutionerish/A [def: revolutionary]
	farrevolutsyone'r/A [def: pre-revolutionary]
revolver/N [m] [def: revolver] 
revyu/N [def: burlesque] 
rey/N [f] reye/S [def: row, turn (at a game), series] 
	tsolnrey/N [f] [def: series of numbers (mathematics)] % Stutchkoff
	[idiom: harmonishe rey = harmonic series]
	[idiom: logaritmishe rey = logarithmic series]
	[idiom: parki'rn in der tsveyter rey = double park] % Yiddish League
reyekh{ryH}/Xreykhes{ryHwT}/H [m] [def: smell]
reyf/N [m/f] [def: hoop, barrel stave; tire] [def: ring] /D [def: halo]
	reyfl/V/T [def: circle (with "zikh")]
	[idiom: geplatster reyf = flat tire]
reykher/V/T [def: smoke] /Gon/Goys/Garoys
	roykher/V/T [def: smoke; distill] /Gon/Goys/Garoys [usage: not recommended for "smoke"]
	farreykher/V/Bfarreykhert farroykher/V/Bfarroykhert [def: smoke] 
	derreykher/V/Bderreykhert [def: consume (cigarette) by smoking] 
	roykh/N [m] [def: smoke] /D /Iik
		veyroykh/N [m] [def: incense]
	reykerer/S [m] [def: smoker]
		roykhner/S [m] [def: smoker] % Sholem Aleykhem
reynik/V/T [def: purify] /Gop/Goys
	reyn/K [def: pure, clean]
		reynkayt/N [f] reynikayt/N [f] [def: purity, cleanliness] 
		reynikayt/N [f] [def: Torah scroll]
		reynikung/N [f] [def: purge, liquidation] % Forwards: M-S Hoffman
	umreyn/K [def: impure, dirty]
		umreynkayt/N [f] umreynikayt/N [f] [def: impurity, uncleanliness] 
	farumreynik{far#umreynik}/V/Bfarumreynikt{far#umreynikt} [def: taint, dirty] 
reysh [m/f] [def: letter Reysh] 
reyster/S [m] [def: register, account book]
-/Xreytuzn [def: jodhpurs, tights (undergarment; clothing)] 
reyts/V/T [def: annoy, tease (with "zikh mit"); attract (sexually); tear]
	/Gon/Goyf
	onreytser/X [def: attacker]
	tsereyts/V/Btsereytst [def: tear up; exasperate] 
		tsereytstkayt/N [f] [def: exasperation] % Forwards: M-S Hoffman
rezervi'r/V/Brezervi'rt [def: reserve] 
	rezervua'r/N [m] [def: reservoir] 
		tala'nt-rezervua'r/N [m] [def: talent pool] [note: V]
	rezer'v/N [m] [def: backup (in case of failure)] 
		rezervpekl/Eekh [def: spare packet] 
	rezervatsye/S [f] [def: condition, provision; rezervation (thought, activity)] 
	rezervi'st/N [m] [def: soldier in the reserves]
	[idiom: general in rezerv = general in the reserves]
rezhim/N [m] [def: regime]
rezhisi'r/V/Brezhisi'rt [def: direct] /Goys
	rezhiso'r/N [m] rezhisorke/S [f] rezhisorin/S [f] [def: director] 
	rezhi [f] [def: direction] 
rezide'nts/N [m?] [def: official abode]
rezigni'r/V/Brezigni'rt [def: resign oneself (with "zikh"); be calm (with "zikh"); abdicate] 
rezolutsye/S [f] [def: resolution]
rezona'ns/N [m] rezona'tns/N [def: resonance; echo]
	rezoni'r/V/Brezoni'rt [def: resound; resonate]
rezultat/N [m] [def: result]
	gruntrezultat/N [m] [def: primary result] 
ridikyul/N [m] [def: reticule, handbag, purse]
ridl/N [m] [def: shovel, spade]
rifs [def: reps (a corduroy-like material)] /Ien
ri'geve/V/T [def: untie; remove stitches]
rigl/V/T [def: lock, bolt, chain] 
	farrigl/V/Bfarriglt [def: lock] 
	rigl/N [m] [def: bolt] 
rike/S [f] [def: brook, creek]
riked{rykwd}/H [def: dance]
rikht/V/T [def: judge; expect (with "zikh az/oyf/tsu")] /Goys/Gtsu
	/Gayn [def: soil] 
	/Gop [def: expect, celebrate]
	/Goyf [def: restore]
	[idiom: oprikhtn goles = go on spiritual wanderings]
	/Gunter [def: teach] [usage: inadmissible]
	rikhtik/K [def: right, correct] [usage: not applied to people]
		rikhtikayt/N [f] [def: correctness] 
		umrikhtik/A [def: incorrect]
			umrikhtikayt/N [f] [def: error]
	oy'frikhtik/A [def: honest, in good faith] 
		oy'frikhtikayt/N [f] [def: honesty, good faith] 
	rikhter/S [m] ri'khterin/S [f] [def: judge] 
	ri'khteve/V/T [def: adjust]
	umgeri'kht/K [def: unexpected]
		umgeri'khterheyt [adv] [def: unexpectedly] 
		umgeri'khtkayt/N [f] [def: unexpectedness] 
	farrikht/V/Bfarrikht/Bfarrokhtn [def: fix, repair; correct] /Goys
		farrikhtik/V/Bfarrikhtikt [def: fix, repair, correct] 
	rikht/N geri'kht/N [def: court]
	bari'kht/N [m] [def: report, account]
		bukhbari'kht/N [m] [def: book report] [note: V] 
	rikhtung/N [f] [def: direction] 
		ay'nrikhtung/N [f] [def: soil]
		o'prikhtung/N [f] [def: celebration, expecttation]
		oy'srikhtung/N [f] [def: burial clothes; preparation; donation; clothing]
		u'nterrikht/N [m] [def: education, pedagogy	(German)]
			u'nterrikhtung/N [f] [def: educational system (German)]
	geri'kht/N [n] [def: course of a meal; dish (food)]
		bay'geri'kht/N [n] [def: side dish (food)]
		forgeri'kht/N [n] [def: appetizer (food)]
		no'khgerikhkt/N [n] no'khgerikhts/N [n] [def: dessert]
	nakhrikht/N [m?] [def: news, information] [usage: not recommended]
rimen/S [m] /I rimet/N [m] [def: strap, belt]  /Drimend
	rimen/A [def: leather]
	hoyznrimen/S [m] [def: trouser belt] 
	hu'ntrimen/S [m] [def: leash]
	rimer/S [m] [def: saddle-maker]
rim [m] [def: rubble, debris] % no plural
rim/V/T barim/V/Bbarimt [def: boast, gloat (with "zikh"); be known, be famous]
	barimt/K [def: famous] 
	barimtkayt/N [f] [def: fame] 
	barimer/S [m] [def: braggart, boaster] 
	barimeray'/N [n] [def: bragging, boasting]
	troyerik-barimt/A [def: notorious]
	veltbarimt/A [def: world-famous]
	[idiom: (ba)rimen zikh vi (a nar, a shoyte, der khazer{Hzr} mit zayn fisl, der keml mit zayn hoyker = gloat, boast] % Stutchkoff
rimpl/V/T [def: fiddle in an amateurish fashion]
rin/V/Bgerunen [def: run] /Garoys/Gop/Garop
	/Gdurkh/Gadurkh [def: percolate] % Yiddish League
	/Goys [def: diminish] 
	antrin/V/Bantrunen [def: run away, flee] 
		antrinung/N [f] [def: refuge; escape]
	tserin/V/Btserunen [def: run apart] 
	rine/S [f] rinve/S [f] [def: gutter]
		tsamrine [f] [def: border gutter]
	gerinen/A [def: curdled (milk)]
rind/Xrinder [def: cow or ox] rindern/A [def: beef]
ringl/V/T [def: surround] /Garum
	ring/N/D [m] [def: ring]
		dimentring/N/D [m] [def: diamond ring] 
		halbring/N [m] [def: half circle] % Forwards: Boris Sandler
		oyering/N [m] /D [def: earring]
		tsiglring/N [m] [def: signet ring] % Forwards: S-R Schaechter
		zumpnring/N [m] [def: swampy circle] % Chava Rozenfarb: Botshani
	aru'mringlung/N [n] [def: surroundings]
rip/N [f] [def: rib] /Isn [def: ribbed fabric]
	[idiom: arayntsuzogn emetsn in der zibeter rip arayn = make a cutting comment]
	[idiom: derlangen in zibetn rip = annoy]
rir/V/T [def: move (with "zikh")]
	/Gtsu/Goyf/Gtsu
	/Gon [def: contact, touch] 
	onrir/N [m] [def: contact, touch]
	oyfrir/N [m] [def: commotion]
	tsurir/N [m] [def: touch, approach] % Forwards: Boris Sandler
	bari'r/V/Bbari'rt [def: touch, mention (a problem)]
		barirung/N [f] [def: contact] 
	umbarirt/A [def: untouched] 
	rirevdik/A [def: moving]
		rirevdikayt/A [def: mobility]
	shlakririk/A [def: paralyzed]
		shlakririkayt/N [f] [def: paralysis]
	gerirtkayt/N [f] [def: emotion] % Esther Kraytman: Briliantn
rishtevanye/S [f] [def: scaffold] 
ritem/S/Xritmen [m] [def: rhythm] ritmish/A [def: rhythmic]
ritsh/V/T [def: crawl; creep] /Garoys
ritshe/V/T [def: yell] 
	tseritshe/V/Btseritshet [def: yell] 
ritshke/S [f] [def: stream, creek] /D
ritua'l/N [m] [def: ritual] 
ritu'z/N [m?] [def: tights (women's clothing) (Polish rajtuza)]
riv/N [m] [def: drainpipe; culvert] 
riye{r#yh} [f] [def: sense of sight]
	rouy{r#wy}/H [adj] [def: deserving]
	/Xrayes{ra|ywT} [def: evidence]
riz/N [m] [def: giant, ream (paper)] /Iedik rizik/K [def: giant] 
	ri'zikayt/N [f] [def: hugeness]
riziki'r/V/Briziki'rt [def: risk]
	ri'zike/S [f] [def: attempt; risk]
	rizika'nt/N [m] [def: risk-taker] 
	rizikalish/A [def: foolhardy] 
rizl/V/T [def: trickle; gurgle] 
	rizldik/A [def: trickling; gurgling] 
rob/N [m] [def: raven (bird); wren (bird)] 
robo't/N [m?] [def: robot]
rod/Xreder [f/n] [def: wheel; circle]
	/Dred [def: group; dial]
		redlekhvayz [adv] [def: in small groups]
	halbrod/Xhalbreder [f/n] [def: semicircle]
	redl/V/T [def: roll; dial] /Gtsunoyf/Gop/Goys
	i'mpetrod/Xi'mpetreder [f] [def: flywheel]
	tseynrod/Xtseynreder [f] [def: gear (mechanical)] 
	a'lrodik/A [def: all-wheel (automotive)] [note: V]
	fir-rodik/A [def: four-wheel (automotive)] [note: V]
	frontrodik/A [def: front-wheel (automotive)] [note: V]
	tsvey-rodik/A [def: two-wheel (automotive)] [note: V]
rodyum [m] [def: rhodium (Rh)] 
roe{reh}/H roes{rewT}/H [def: wild, evil] 
	ruekh_ra{rwH-re}/Xrukhes_roes{rwHwT-rewT}/H [def: evil spirit]
roe_{roO}/H [adj predicative] [def: worthy of (with "tsu")]
rog/N [m] [def: (street) corner] 
	rogal/N [m] [def: crescent-shaped pastry (food)] % I. J. Singer
		rogele/X [def: small crescent-shaped pastry (food)]
rogatke/S [f] [def: town gate or entrance]
rogozhe/S [f] [def: straw mat] 
rok/N [m] /Drek [def: suit coat; robe (clothing)]
	oyberrok/N [m] [def: overcoat] % Sholem Aleykhem
	shlofrok/N [m] [def: morning gown, bathrobe (clothing)] 
	u'nterrok/N [m] [def: undershirt (clothing)]
rokh/N [m] [def: rook (chess piece)]
rol/V/T [def: ball up; wrap; rotate] /Gtsunoyf
	rolke/S [f] [def: bobbin, spool; pulley; (money) roll]
	rolye't/N [m] role't/N [m] [def: venetian blind; rolling shutter] % Esther Kraytman: Briliantn
role/S/Xroln [f] rolye/S [f] [def: rôle] 
	rol/N [f] [def: role] [usage: doubtful admissibility]
	roli'st/N [m] [def: player (theatrical)]
		hoyptroli'st/N [m] hoyptrolistke/S [f] [def: star (of a performance)] 
	[idiom: dos shpilt nit keyn role = that doesn't count!]
rom/N [f] ram/N [f] rem/N [f] [def: frame, border, limit] /Drem
	ayngeramt/A [def: framed] 
	baremlt/A [def: framed] % Forwards: Boris Sandler
	spruzhine-rom/N [f] [def: box spring (furniture)] [note: V] 
	gere'm/N [m?] [def: limited region of space] % Forwards: Boris Sandler
roma'n/N [m] [def: novel; romance] /Itish [def: romantic] 
	romani'st/N [m] romanistke/S [f] [def: novelist]
	romansi'r/V/Bromansi'rt [def: be attractive; flirt]
	romanti'zm/N [m] romantik [f] [def: romanticism]
		romantitsi'zm/N [m] [def: romanticism] [usage: inadmissible]
		romantiker/S [m] [def: romantic (artist)]
	romantistish/A [def: romantic (literary)]
		neoromantish/A [def: neoromantic] 
	avantu'r-roma'n/N [m] [def: adventure novel]
	radyo-roma'n/N [m] teleroma'n/N [m] [def: soap opera] [note: V]
	roma'ns/N [m] [def: love affair; literary romance]
romb [m?] [def: rhombus, diamond shape] /Iish
romyanik/Xramoynkes [m] romashke/S [f] [def: Mayweed chamomile (herb) (Anthemis cotula)]
ror/N [m] [def: reed, cane] royr/N [m]
	rer/N [f/m] [def: pipe; tube] /Indik
		/D [n] [def: telephone receiver] 
	moylrerl/Eekh [n] [def: gargoyle; downspout] [note: V]
rose/S [f] [def: dew, condensation]
rosh{roS}/Xroshem{roSym}/H [m] [def: head; chief] berosh{broS} [adv] [def: at the head] 
	reyshes{r#SyT}/H [def: beginning]
		/Lbe{b} [adv] [def: at first; book of Genesis]
		berey'shesdik{br#SyTdyk}/A [def: pertaining to Genesis] 
		[idiom: reyshes{r#SyT} khokhme{Hxmh} = first of all]
		[idiom: reyshes{r#SyT} kol{Kl} = first of all]
	rosheteyves{roSy-WyBwT}/H/N [def: abbreviation] 
	rishen{r#Swn}/H [def: first, early sage] rishoynem{r#Swnym}/H
		odem-horishen{odm-hr#Swn} [def: Adam]
	kales_rosh{klwT-roS} [f] [def: frivolity]
	shel_rosh{Sl-roS}/N/H [m] [def: tefillin worn on the head]
roshe{rSe}/Xreshoyem{rSe|ym}/H [m] marsha's{mrSeT}/N/H [f] [def: malicious, wicked person] 
	rishes{rySewT}/H [def: evil] /Idik [def: evil] 
	roshe_merushe{rSe-mrwSe} [def: completely evil person]
roshtshine/V/T roshtshe/V/T [def: let bread rise; prepare batter for frying]
	roshtshene [f] [def: leaven]
roskosh [m] [def: comfort, luxury] [usage: not recommended]
rosl/N [m] [def: (beef) broth; brine; pickle]
rostye/V/T /Goys [def: stretch out (Russian расти)] % [Bessarabian Yiddish; B. Sandler]
rot/V/Bgerotn /Goys [def: eradicate] 
	oysrotung/N [f] [def: eradication]
rote/S [f] [def: company (military)] 
rotonde/S retonde/S [f] [def: coat (clothing: women's, loose, fur-lined)]
rots [def: snot] farrotst/A [def: snotty] 
	rotser/S [m] [def: brat]
rotsn{rcwn}/H [def: desire] 
rov/N [m] [def: ditch] 
rov__{rwB}/H [def: most (with "dos")] /Lle{l} [adv] [def: mostly]
	lorov{lrwB} [adv] [def: mostly; abundantly]
	rabem{rbym}/H [def: majority]
	priye_urviye{pryh-|wrByh} [f] [def: command to multiply and increase]
	[idiom: keyn_yirbu{Kn~yrbw} = may they increase (warding off an evil eye)]
rov_{rB}/H [m] [def: Rabbi] /Lho{h} [noun] [m] [def: the Rabbi]
	reb_{rb}/H [m] reb [def: Mister (with first name)]
	reboyne{rbwnw}/H [def: master (with "- shel oylem", of the world)] 
	rabeynu{rbynw}/H [def: our master]
	raboysay{rbwTy}/H [def: gentlemen, my masters (direct address)]
	rabon{rbn}/Xrabonem{rbnym}/H [m] [def: Rabbi]
		rabonish{rbnish}/A [def: Rabbinic]
		rabones{rbnwT} [f] [def: Rabbinate; occupation of Rabbi]
	rabina't [m?] [def: rabbinical court or location]
	rebe{rby}/Xrebeyem{rbeym}/H/C/J [m] [def: Rabbi (Hassidic); state-appointed Rabbi] /Ish
		rebenyu{rbynyu} [def: dear Rabbi] 
		rebile{rbyle} [m] [def: little Rabbi]
		rebn{rbyn} [def: Rabbi (dative form)]
		rebitsin{rbycyn}/S [f] [def: Rabbi's wife] 
		rebistve{rbistve} [f] [def: Rabbinate; occupatoin of Rabbi] % Shpiglblat
			[idiom: praven rebistve{rbistve} = function as a Rabbi]
	rabiner/S [m] [def: Rabbi (Reform)] /Iish /Ish [def: Rabbinic] 
		rabinerte/S [f] rabi'nerin/S [f] [def: Rabbi] 
	rabay [m] [def: Rabbi (American)]
	reboyne_shel_oylem{rbwnw-Sl-elwm} [m] [def: God, Master of the Universe]
	[idiom: eyner hot lib dem rebn, un der anderer di rebitsin{rbycyn} = everyone to his own tastes]
rover/S [m] [def: bicycle] % Rover Safety Bicycle of 1885
roy/A [def: raw]
royb/V/T [def: rob] /Gavek/Gtsu
	royb [m] [def: booty, spoils, loot, prey]
		zakroyb [m] [def: plunder]
	royber/S [m] [def: robber] /Iish
	ra'beve/V/T /Goys bara'beve/V/Bbara'bevet [def: rob] 
	baroyb/V/Bbaroybt [def: rob] 
roydef{rwdf}/H/V/T [def: pursue; oppress]
	roydef{rwdf}/Xrodfem{rwdfym} H [m] [def: pursuer, persecutor]
	roydef{rwdf} [verb] [def: pursue (with "zayn")]
	redife{rdyfh}/H redifes{rdyfwT}/H [def: pursuit, persecution] 
ro|ye/V/T roye/V/T [def: swarm, teem; hover; rummage, seek among items (with "zikh")]
	/Garoyf
royfe{rwf#}/Xroyfem{rwf#ym}/H [m] roy'fete{rwf#te}/S [f] [def: healer] 
	refue{rfw#h}/H refues{rfw#wT}/H [def: cure] 
	veytik-refue{veytik-rfw#h} [def: painkiller] 
	[idiom: nit oyf a refue = not at all]
royg/N [m] [def: fish eggs, roe; spawn]
roygez{rwgz}/H [m] rugze{rwgz|h}/H [f] /Idik ragzones{rgznwT}/H [f] yirgozn{yrgzwn} [n] [def: anger]
	broygez{brwgz}/A [def: angry] /Ilekh /Idik
		broygez{brwgz}/V/T /Gon [def: become angry (with "zikh")]
	rugzedik{rwgzhdik}/A ragzonesdik{rgznwTdik}/A ragzonish{rgznish}/A [def: angry]
	derragzn{derrgzzn}/Vderragzenen{derrgznen}/Bderragznt{derrgznt} [def: anger, provoke]
roym/V/T [def: clean] /Gtsu/Gop/Goys/Goyf/Garum/Goys/Garoys
	roymerke/S [f] [def: house cleaner] % Forwards: Riki Royz
	ram/V/T [def: clean (house)] /Gtsu/Gop/Goys/Goyf/Garum/Goys/Garoys % variant
		ra'merin/S [f] [def: house cleaner]
roym/V/T [def: whisper (a secret)] /Gayn/Garayn
roym/N [m] [def: room; space] /Iik
	himlroym/N [m] [def: outer space] 
	geroy'm/A /Iik gera'm/K [def: roomy; spacious]
roysh/V/T [def: make a commotion] /Gdurkh
	geroy'sh/N [n] [def: (faint) noise] 
	royshik/A [def: noisy] 
	roy'shenish/N [n] roysheray'/N [n] [def: enthusiasm, excitement] 
	tseroysh/V/Btseroysht [def: create excitement (with "zikh es")] 
	baroysht/A [def: confused, excited] % Avrom Reisen
royshem{rwSm}/H [m] [def: impact, impression] /Idik
royt/A /Ilekh /Iink [def: red]
	royts [n] [def: hearts (playing cards)] % no plural?
	roytkayt/N [f] [def: redness] 
	roytl/V/T [def: become red (with "zikh")] [usage: not recommended]
		farroytl/V/Bfarroytlt [def: make red, redden] [usage: not recommended]
	reytl/V/T [def: become red (with "zikh")] [usage: not recommended]
		farreytl/V/Bfarreytlt [def: make red, redden] [usage: not recommended]
	morgnroyt [m] [def: dawn, daybreak]
	tseroytlt/A [def: flushed, reddened]
royz/N [f] [def: rose; rash (skin disease)]
	rozik/A [def: rosy] roze/A roz/A /Ilekh [def: pink]
	razeve/A rozeve/A [def: whole-wheat (flour, bread)]
	ga'rtlroyz [f] [def: rash (skin disease); shingles (disease)]
	fi'dlroyz/N [f] [def: fiddle rose] % Sutskever
	ki'stroyz/N [f] [def: rockrose (flower: family Cistaceae)]
	vintreyzl/Eekh [f] [def: anemone (flower)] 
	zunroyz/N [f] [def: sunflower (plant)]
	-/Xroyznblumike [def: Rosaceae (plant family)]
rozhdestve [def: Christmas (Russian Рождество)] 
rozhik/Ees [def: snuffbox; crust of bread] /D
rozhinke/S [f] [def: raisen] /D
-/Xrozn_derozn{rzyn-drzyn} [def: deepest mystical secrets]
rozmari'n [m?] [def: rosemary (herb)]
ru/V/T [def: rest] /Gop/Goys/Gayn
	baruik/V/Bbaruikt [def: calm] 
		baruikung/N [f] [def: calming down; soothing; tranquilization]
		baruekhts/N [n] [def: tranquilizer] % Weinreich
	bau'mruik{ba#umruik}/V/Bbau'mruikt{ba#umruikt} [def: disquiet]
	ruik/K [def: calm, peaceful]
		ruikerheyt [adv] [def: calmly, peacefully]
		ruikayt [f] ru/N [f] ruung/N [f] tsuru [adv] [def: peace, resting]
	umruik/A umruikayt/N [f] umru/N [m] [def: disquiet]
	umru/N [m] [def: pendulum; figdety person]
		umras/N [m] [def: restless person]
	ru [f] opru/N [m] [def: rest] 
		barut/A [def: calm] barutkayt/N [def: calmness]
			umbarut/A [def: restless, upset] % Neydus
	[idiom: vu di yidn hobn gerut = buttocks (vulgarism)]
rubidyum [m] [def: rubidium (Rb)] 
rubi'n/N [m] [def: ruby] /Drubind
rubl/N [m] [def: ruble (Russian currency)] /Idik
rubrik/N [def: rubric] 
ruder/V/T [def: rumble; trouble; row (boat)] /Garum/Garoys
	/Goyf [def: trouble, disturb]
	tseruder/V/Btserudert [def: confuse]
	geruder/S [n] [def: commotion, tumult]
	oyfruderung/N [f] [def: commotion] 
	oyfgerudertkayt/N [f] [def: mental upset, disturbance]
	ruder/S [m] [def: oar, paddle; tiller] 
	ru'derer/S [m] [def: oarsman]
	[idiom: a shif on a ruder = without a leader, drifting]
ru'deve/V/T [def: bustle, move around busily]
ruekh{rwH}/Xrukhes{rwHwT}/H [m] [def: disembodied spirit, ghost; devil]
	rukhish{rwHish}/A [def: spiritual]
	[idiom: tsu aldi rukhes = damn it all]
	[idiom: a ruekh{rwH} in dayn tatns tatn arayn = damn you]
	[idiom: oyfhengen oyf zikh dem ruekh{rwH} = overadorn oneself]
	rukhniyes{rwHnywT}/H [f] [def: pure spirit] /Idik [def: spiritual]
		berukhniyes{brwHnywT} [adv] [def: spiritual] 
		rukhni{rwHny} [adj indeclinable] [def: spiritual]
		[idiom: lebn fun rukhniyes{rwHnywT} = without visible means of support]
ruf/V/Bgerufn [def: call]
	/Garoys/Goyf/Goys/Gtsu/Gtsurik/Gtsuzamen/Garayn/Gnokh/Gavek/Gtsunoyf
	/Gon [def: speak, say (with "zikh")]
	/Gop [def: cancel, postpone; respond; influence (with "zikh oyf"); give feedback (with "zikh")] 
	/Garoyf [def: summon (usually for an Aliya to the Torah (religious)]
	/Gayn [def: invite; gather]
	baruf/V/Bbarufn [def: assign a job] 
	derruf/V/Bderruft [def: get someone's attention (with "zikh")] % Der Nister: Mashber
	onruf/N/D [m] [def: call]
	aroysruf [m] [def: call out]
		aroysru'fenish/N [n] [def: calling out] 
	opruf/N [m] [def: call; feedback; reaction] 
	oysruf/N [m] [def: call]
	oyfruf/N [m] oyfrufns [m] [def: summons, groom's Torah call-up before wedding]
	farruf/V/Bfarruft [def: call, cite (with "zikh oyf")] 
		farrufung/N [f] [def: citation; link (web)]
	hilfsruf/N [m] [def: call for help]
	hornruf/N [m] [def: horn call] 
	yugntruf [m] [def: Yugntruf-Youth for Yiddish]
		yugntrufnik/Ees [m] yugntrufi'st/N [m] [def: member of Yugntruf]
	gerufenerheyt [adv] [def: summoned]
ruini'r/V/Bruini'rt [def: ruin]
	rui'n/N [f/m] ruinirung/N [f] [def: ruin] 
ruk/V/T [def: turn away] /Garop/Garoyf/Garoys/Gop/Gon/Garayn/Giber/Gtsu
	/Gtsurik/Gavek/Gfunander/Gunter/Garunter/Gtsunoyf/Gdurkh/Garum
	/Gforoys [def: advance]
	opruk/N [m] [def: distance, interval] % neologism
	farruk/V/Bfarrukt [def: turn] 
	tseruk/V/Btserukt [def: turn; unfurl] 
	ruker/S [m] [def: latch (door)] % Sholem Aleykhem
	rukn/S [m] [def: back] 
		bargrukn/S [m] [def: mountain ridge] 
	tsurik [adv] tsuriket [adv] krik [adv] [def: back]
	[idiom: a vokh gerukt = a week apart]
	[idiom: hin-krik (epes) = two-way (something)] [note: V]
ru'kheve/V/T [def: resound, be full of (with "zikh")] % Forwards: M-S Hoffman
rule't/N [m] role't/N [m] ruletke/S [f] [def: window blind]
rum [m] [def: glory, fame]
	veltrum [m] nokhrum [m] [def: glory, fame]
ruml [m] [def: heap of old goods; flush (in card game poker); hubbub]
	[idiom: tsum ruml = into the bargain; add insult to injury]
rund/A [def: round] [usage: inadmissible] /Ilekh /Iik
	rund/V/T [def: round] /Goys/Gop
	rundik/V/T [def: round] /Goys/Gop
	farrundik/V/Bfarrundikt [def: round]
runde/S [f] [def: round (of voting or a game)] 
runtsl/V/T [def: wrinkle; ripple (with "zikh")]
	runtsl/N [m/n] [def: wrinkle] 
	tseruntsl/V/Btseruntslt [def: wrinkle] 
rupe/V/T rupen/V/T [def: be worrysome, rankle; make restless; rush about (with "zikh")] [usage: impersonal]
rus [m] [def: soot]
	 /Iik [def: sooty]
	farris/V/Bfarrist [def: smudge (with soot)]
	ris/V/T [def: smudge] /Gayn
rut/Xriter [f] [def: switch (made from a stalk or branch); scepter] /Drit
rute/S [f] [def: route] 
	ruti'r/V/Bruti'rt [def: route (computer)] [note: V] 
rutenyum [m] [def: ruthenium (Ru)] 
ruterfordyum [m] [def: rutherfordium (Rf)] 
rutin/N [f] [def: routine (English)] 
sablye/S [f] [def: saber (weapon)] 
sabotazh/N [m] [def: sabotage]
	sabotazhnik/Ees [m] [def: saboteur] 
	saboti'r/V/Bsaboti'rt [def: sabotage] 
sadi'st/N [m] [def: sadist] /Iish [def: sadistic] 
safari/S [m?] [def: safari] % Forwards: M-S Hoffman
safyan [m?] [def: Morocco leather (fabric)]
sagenoer{sgy-nhwr}/H [m] [def: blind person (Aramaic: "full of light")] 
sakh{sx}/H [def: many, sum] /Lbe{b} [adv] [def: in sum]
	sakhakl{sx-hKl}/H [def: total, summary] /Lbe{b} [adv] [def: totaling] 
sakhari'n [m] [def: saccharine (chemical)] % Harduf
sakone{sKnh}/Xsakones{sKnwT}/H [f] [def: danger]
	sakonedik{sKnhdik}/K sakonesdik{sKnwTdik}/K [def: dangerous]
	sakonas{sKnT}/H [def: danger of] 
	mesukn{mswKn}/A [def: dangerous] /Idik
		khoyle_mesukn{Hwlh-mswKn} [def: dangerously ill person] 
		[idiom: mesukn{mswKn} krank = dangerously ill]
saksofo'n/N [m] [def: saxophone]
	saksofoni'st/N [m] saksofoni'stke/S [f] [def: saxophone player] % Forwards: Berinski, Itsik Gottesman
sakve/S [f] [def: sack] 
sala't/N [m] [def: salad, lettuce (food)]
	bleter-sala't [m] [def: salad (food)]
sale/S [f] salye/S [f] [def: parlor] salon/N [m] salke/S [def: room]
	zal/N [m] [def: hall, auditorium]
		gerikhtzal/N [m] [def: courtroom] 
salu't/N [m] [def: salute] % Harduf
	saluti'r/V/Bsaluti'rt [def: salute]  % Harduf
sam{sm}/H [m] [def: poison] /Iik [def: poisonous, toxic] 
	sam{sm}/V/T [def: poison] /Gop/Gavek
	sam_hamoves{sm-hmvT} [def: lethal poison]
	farsam{farsm}/V/Bfarsamt{farsmt} [def: poison]
	farsamung{farsmung}/N [f] opsamung{opsmung}/N [f] [def: poisoning] 
		mogn-farsamung{mogn-farsmung}/N [f] [def: food poisoning] 
samaryum [m] [def: samarium (Sm)] 
same/A samerodn/A [def: complete; genuine; the very]
samerodne/A [def: best, first-class]
samet [m] [def: velvet (material)] /In [def: velvet] 
samogon/N samohon/N [m?] [def: home-brew, moonshine (liquor) (Russian or Ukrainian самогон)] 
samovar/S/N [m] [def: samovar] 
samsan [m] [def: groom (klezmer jargon)] samsanitse/S [f] [def: bride (klezmer jargon)] % Stutchkoff
sanatorye/S [f] sanatoryum/S [m] [def: sanatorium] 
sandal/N [m] [def: sandal] 
sandek{sndk} [m] [def: Sandek (holds child during ritual circumcision)] 
	sandekoes{sndk#wT}/H [def: role of the Sandek (with "nemen")]
saneyger{snygwr}/H [m] [def: defender, defense attorney]
sanhedren{snhdryn} [m] [def: Sanhedrin (ancient Jewish high court)]
sanitar/N [m] sanitarin/S [f] [def: cleaning person] 
sankt- [prefix] [def: Saint (Christian)]
sanktsye/S [f] [def: sanction] 
sanskritish/A sanskrit [def: Sanskrit (language)]
sa'peve/V/T [def: weed] /Goyf
sar{Qr} [m] [def: prince; angel; nobleman]
sara [def: such (= vos far a)] 
saray'/N [m] [def: shed, lean-to (structure)]
sardin/N [m] [def: sardine] 
sarg [m?] [def: filth]
	farsarget/A [def: filthy]
sarkazm [m] [def: sarcasm] sarkastish/A [def: sarcastic] 
sarne/S [f] [def: doe (animal)]
sarver/S [m] sa'rverke/S sa'rverin/S [f] [def: waiter, waitress] 
	fli'sa'rver/S [m] fli'sa'rverke/S [f] [def: flight attendant] [note: V]
	sarveray'/N [n] [def: service]
satelit/N [m] [def: satellite] 
satire/S [f] [def: satire ] satirish/A [def: satirical] 
	satiriker/S [m] [def: satirist]
satisfaktsye/S [f] [def: satisfaction; revenge] 
	[idiom: fodern satisfaktsye = challenge to a duel]
	[idiom: gebn satisfaktsye = duel]
satmer /Eer [def: Satmar (Chassidim)] 
savlones{sBlnwT} [f] [def: patience] 
	soyvl{swBl} [verb] [def: bear, tolerate (with "zayn")]
	savlen{sBln}/Xsavlonem{sBlnym} [m] sa'vlente{sBlnte}/S [f] [def: patient person]
savule/S [def: despicable boy] % a khalyastre fun savules un fun gontses
say [conj correl] [def: both] 
	[idiom: say vi (say) = in any case]
saydn [def: unless] 
sazhe/S [f] [def: soot; lamp-black] 
	farsazhet/A [def: sooty]
sazhen/Xsazhenyes [m] [def: fathom (2.13 meter) (Russian сажень)] 
sek/V/T [def: lie down; become pregnant (with "in") (vulgar)]
sekher/S [m?] [def: cracker (food)]
sekreta'r/N [m] sekretarin/S [f] sekretarshe/S [f] [def: secretary]
	sekretarya't/N [m] [def: department, secretariat (government)]
	sekretaray' [n] [def: secretarial work]
	sekrete'r [def: desk] 
seks [m] [def: (matters of) sex] /Iue'l
	homoseksue'l/A [def: homosexual]
		homoseksua'l/N homoseksuali'st/N [m] [def: homosexual]
		homoseksuali'zm/N [m] [def: homosexuality]
sekte/S [f] [def: sect]
	sekta'nt/N [def: sectarian] /Iish [def: sectarian]
		umsektantish/A [def: non-denominational] 
	sektor/N [m] [def: sector]
	sektsye/S [f] [def: section] 
sekule'r/A [def: secular, non-religious]
	sekulari'st/N [m] [def: secular person] % Forwards: S-R Schaechter
sekunde/S [f] [def: second (unit of time, musical interval, angular measure)] /D
	sek' [def: second (unit of time, musical interval, angular measure; abbreviation)]
	sekundnik/Ees [m] [def: second hand of a clock]
sekunda'nt/N [m] [def: second (in a duel)]
sekvesti'r/V/Bsekvesti'rt [def: kidnap] 
	sekvester/S [m] [def: kidnapper] 
sele{slh}/H [interj] [def: Selah: expression of satisfaction] 
selekti'r/V/Bsekti'rt [def: select] /Goys
	selektsye/S [f] [def: selection] 
	selekti'v/A [def: picky, selective] 
selenyum [m] [def: selenium (Se)] 
selerye [f] [def: celery] 
semantik [f] [def: semantics (subject)] semantish/A [def: semantic]
semer/N [m] [def: food stand] % pronouced "shemer" in Vilne: Chaim Grade
semester/S [m] [def: semester]
se'metshke/S [def: sunflower seed] 
semina'r/N [m] [def: seminar]
semiotik/N [f] [def: semiotics]
semit/N [m] [def: Semite] /Iish [def: Semitic] 
	antisemit/N [m] [def: antisemite] /Iish [def: antisemitic]
	antisemitishkayt/N [f] antisemiti'zm [m] [def: antisemitism]
semoline [f?] [def: semolina (grain)]
sendvitsh/N [m] [def: sandwich] 
senezents/N [def: pasture; hayloft] 
sensatsye/S [f] [def: sensation] sensatsyonel/A [def: sensational] 
	sensatsyonali'zm/N [m] [def: sensationalism] % D-H Katz
sensiti'v/A [def: sensitive] 
	sensitivite't/N [f] sensitivkayt/N [f] [def: sensitivity]
		umsensitivkayt/N [f] [def: insensitivity] % Forwards: Yoel Matveyev
senke/S [f] suk/Ees [m] [def: knot (wood) (Polish sęk, Russian сук)]
	senkove/A [def: knotty (wood)] % Menakhem Kipnis
sensuel/A [def: sensual] 
sentime'nt/N [m] [def: sentiment] /Ial [def: sentimental] 
se'ntserl/Ekh [n] [def: tea bag] % Yiddish League
senyo'r [m] [def: Mister (Spanish)] senyora [f] [def: Mrs. (Spanish)]
	sinyor [m] [def: Mister (Italian)] sinyora [f] [def: Mrs. (Spanish)]
separi'r/V/Bsepari'rt [def: separate]
	separati'st/N [m] separatistke/S [f] [def: separatist]
	separati'zm/N [m] [def: separatism]
september [m] [def: September] 
ser [def: Sir (British)]
serdak [m?] surtuk [m?] serdet [m?] [def: men's cloak (clothing); corset (clothing)]
	lay'bserdak/Ees [m] [def: ritually fringed undershirt]
serenade/S [f] [def: serenade]
sermege/S sermenge/S [f] [def: sheepskin coat (clothing)]
sernik/Ees [m] [def: cheesecake (food)]
serp/N [m] [def: scythe, sickle] 
sertse/D sertdtse [adj] [def: beloved, darling] [grammar: follows name]
servetke [f] [def: sour milk; yogurt]
servi'r/V/Bservi'rt [def: serve]
	servet [m] [def: tablecloth; cloth cover] /D
		servetke/S [f] [def: serviette, napkin]
	se'rvetl/Xekh [n] [def: placemat] 
serye/S [f] [def: series]
	serya'l [m?] [def: serial program] % Forwards: Mishe Lev
		seryalizi'rt/A [def: serialized] % Forwards: Yechiel Szeintuch
		teleserya'l [m?] [def: serial television program] % Forwards: Mishe Lev
seryo'zn/A [def: serious]
serzha'nt/N [m] [def: sergeant (military)] 
sesye/S [f] [def: session]
seyder{sdr}/Xsedorem{sdrym}/H [m] [def: order; Passover meal]
	beseyder{bsdr}/H [adj predicative] [def: in order; in good order]
		/Idik
	keseyder{Ksdr}/H [adv] [def: continually; in a row] /Idik [def: continual] 
	sedre{sdrh}/Xsedres{sdrwT}H [def: portion of the Torah; series of events] 
	seyder{sdr}/V/T [def: place in order] /Goys/Gayn
	mesader{msdr} [verb] [def: officiate at a cermony (with "zayn")
	[idiom: der ershter shpil-seyder{shpil-sdr} = starting lineup (sports)]
	[idiom: mesader{msdr} kedushen{kydwSyn} zayn = officiate at a wedding]
seyfer{sfr}/Xsforem{sfrym}/H [m] [def: religious book]
	seyferl{sfrl}/Xsforemlekh{sfrymlekh} [def: religious book]
	sforem|nik/Ees [m] [def: bookseller] 
	soyfer{swfr}/H sofrem{swfrym}/H [def: scribe] 
		sofrish{swfrish}/A [def: scribal]
	misper{mspr}/Xmisporem{msprym}/H [m] [def: count, number]
	[idiom: am_{em} haseyfer{hsfr} = people of the Book]
seykhl{Qxl}/H [m] [def: wisdom, common sense, prudence] /Idik
	seykhldikayt{Qxldikayt} [f] [def: wisdom] % Forwards: Yechiel Szeintuch
	maskel{mQKyl}/Xmaskilem{mQKylym}/H [m] [def: enlightened person]
		maskilish{mQKylish}/A [def: of the Jewish Enlightenment]
	haskole{hQKlh}/H [def: enlightenment]
	iberseykhldik{iberQxldik}/A [def: beyond understanding]
	umseykhldik{umQxldik}/A [def: nonsensical]
	muser_ha'skl{mwsr-hQKl}/N [m] [def: moral, lesson]
	[idiom: faln afn seykhl{Qxl} = pop into the head]
seym [def: Polish parliament] 
	seymi'st/N [def: parliamentarian]
sezon/N [m] [def: season (of year)] 
sfard{sfrd}/Xsfardem{sfrdym}/H [m] sfardi{sfrdy} [def: Sephardic Jew] /Ish 
sfere/S/Xsfern [f] [def: sphere; region of influence; cosmos (in plural)]
	sferish/A
sfire{sfyrh}/Xsfires{sfyrwT}/H [f] [def: heavenly sphere, counting]
	sfiras{sfyrT} [f] [def: counting of (with "h|oymer{ewmr}")] 
sgule{sgwlh}/Xsgules{sgwlwT}/H [f] [def: charm, amulet; remedy]
	mesugl{mswgl}/H [def: charmed; able, capable] 
	-/Xyekhidey_sgule{yHydy-sgwlh} [def: privileged few] 
	shternshis-sgule{shternshis-sgwlh}/Xshternshis-sgules{shternshis-sgwlwT} [def: childbirth amulet]
sha [verb] [def: be quiet] [verb] shat shats [grammar: only imperative]
	sha-shtil/A [def: silent] 
	[idiom: zol zayn sha = quiet!]
shabe [f] [def: cockroach (German die Schabe/n)] [grammar: I expect the plural form is absent]
	 shvab/N [def: cockroach; Swabian; German (pejorative)] 
shabes{SbT}/Xshabosem{SiTym}/H [m] [def: Sabbath] /Idik 
	sha'besdikayt{SbTdikayt}/N [def: Sabbath characteristic]
	shabes_hagodl{SbT-hgdwl} [m] [def: Sabbath before Passover]
	[idiom: makhn shabes{SbT} far zikh = take an independent path]
shablo'n/N [m] [def: stencil; cliche] /Iik /Iish [def: hackneyed]
shada'r{Sd″r} [m] [def: itinerant charity collector] [origin: shlukhe_derabonen{SlwH#-drbnn}]
shadkhn{Sdxn}/Xshadkhonem{Sdxnym}/H [m] /Iish shadkhnte{Sdxnte}/S [f] [def: matchmaker] 
	shadkhonish{Sdxnish}/A [def: matchmaker-like]
	shadkhones{SdxnwT}/H [f] [def: matchmaking] 
	shidekh{Sydwx}/Xshidukhem{Sydwxym}/H [m] [def: match]
		[idiom: redn a shidekh{Sydwx} = arrange a marriage]
		[idiom: (op)ton a shidekh{Sydwx} = engage]
	meshadekh{mSdx}/H [verb] [def: match (with "zayn")] 
	shadkhn{Sdxn}/H/V/T [def: make a match (with "zikh")] 
shaf/V/Bgeshafn/Bgeshaft [def: create]
	/Gayn [def: acquire]
	/Gop [def: nullify, cancel; fire]
	shafung/N [f] [def: creation]
		boyshafung/N [f] [def: construction (building)] 
		folksshafung/N [f] [def: folkways creation]
		nayshafung/N [f] [def: neologism, word coinage] [note: V] 
	shafer/S [m] sha'ferin/S [f] [def: creator] 
	shaferay'/N [n] [def: creation] 
	geltshaferay' [n] geltsha'fenish [def: income; fundraising]
	bashaf/V/Bbashafn [def: create]
		bashafung/N [f] [def: creation]
		umbashafn/A [def: unformed]
		bashe'fenish/N [n] [def: creature] /D
		shefer/S [m] bashefer/S [m] bashafer/S [m] [def: creator]
	farshaf/V/Bfarshaft [def: create] 
	she'ferish/K sha'ferish/A [def: creative]
		sheferishkayt/N [f] shaferishkayt/N [f] [def: creativity] 
	geshe'ft/N/D [m/n?] [def: business; store] /Ilekh [def: business]
		ay'zngesheft/N [m] [def: ironworks] 
		go'ldgesheft/N [m] [def: goldsmith shop]
		vay'ngesheft/N [m] [def: wineshop] % Forwards: S-R Schaechter
		[idiom: luft gesheft = enterprise without a solid foundation]
	basheftik/V/Bbasheftikt [def: employ]
		basheftikung/N [f] [def: employment, pursuit] 
shaf [m?] /Dshef [def: dish bucket]
	kne'tshefl/Eekh [n] [def: kneading board]
	me'lkshefl/Eekh [n] [def: milk pail]
shafe/S [f] [def: shelf (with doors); closet] shafke/S [f] /D
	bi'khersha'fe/S [f] [def: bookcase] 
	kley'dersha'fe/S [f] [def: wardrobe] 
	va'ntsha'fke/S [f] [def: cupboard] /D % Forwards: Boris Sandler
shafi'r/N [m] sapi'r/N [m] [def: sapphire]
shakal/N [m] [def: jackal]
shakh/C [m] [def: Shah]
shakhres{SHryT}/H [m] [def: morning prayer] 
shakhte/S [f] [def: mine (excavation)] 
shakl{ShKl}/Een [m] [def: blessing for drinks other than wine]
	[idiom: makhn shakl{ShKl} = take an alcoholic drink]
shaklo_vetaryo{Skl#-|wtry#} [def: give and take (Talmudic argument)] 
shal/N [m/f] [def: shawl; scarf] /Dshalekh shalik/Ees [m] /D
	shpitsnshalik/Ees /D [def: lace scarf]
shal/V/T [def: howl]
	sha'lenish/N [n] [def: howling]
-/Xshala'tn [def: lettuce (food)]
shalemoy'z/V/Bshalemoy'zt [def: sing-song]
	shalemoy'z/N [def: unimportant details; whims; nonsense; crackpot, crank]
shalfey [def: sage (plant)] 
sha'lk|haftik/A [def: evil; cunning]
shalsheles{SlSlT}/H [f] [def: a lengthy Torah accent]
	[idiom: oysdreyen a shalsheles{SlSlT} = administer a series of slaps to alternate cheeks]
sha'lteve/V/T [def: act as a tyrant] % ?? Avrom Karpinovitsh
shalve{Slvh}/H [f] [def: peace, calm] /Lbe{b} [adv] [def: in peace] /Idik [def: peaceful] 
	shalvedikayt{Slvhdikayt}/N [f] shalvekayt{Slvhkayt}/N [f] [def: peacefulness] 
shalvye [f] [def: sage (herb): Salvia officinalis]
shames{SmQ}/Xshamosem{SmQym}/H [m] [def: beadle, sexton, synagogue caretaker] /D
	sha'meste{SmQte}/S [f] [def: beadle's wife] 
	meshames{mSmQ}/H [verb] [def: serve (with "zayn")] 
	shalatn-shames{shalatn-SmQ} [def: errand boy]
	tashmish{WSmyS} [noun] [def: sexual intercourse]
		[idiom: oyszen vi a hon nokh tashmish{WSmyS} = look exhausted (humorous)]
shampu [m] [def: shampoo] % Forwards: Boris Sandler
shandolyer/N [m?] [def: chandelier] % Forwards: M-S Hoffman
sha'neve/V/T [def: spare, save; take care of, cherish] 
	shanevdik/A [def: sparing] 
shank/Xshenk [f/m] shrank/N/Xshrenk [m] [def: closet; chest (furniture)]
	bi'khershank/Xbi'khershenk [def: bookshelf]
	kley'dershank/Xkleydershenk [f/m] [def: clothes-closet] 
	sforem_shrank{sfrym-shrank} [m] [def:  bookcase]
	bashrenk/V/Bbashrenkt [def: limit, inhibit] [usage: inadmissible]
		umbashrenkt/A [def: unlimited, uninhibited] [usage: inadmissible]
		bashrenktkayt/N [f] [def: limitation] % Rokhl Boymvol
shans/N [def: chance] shants/N
	-/Xshansn -/Xshantsn [def: odds, chances] 
shanta'zh [m?] [def: blackmail, extortion]
shants/N [m] [def: ditch, trench] 
	vasershants/N [m] [def: moat] [note: V]
shanzhirt/A [def: colored ??] % Rokhl Korn: der letster veg
shap/Xsheper [m?] [def: factory; shop]
	svetshap/S [m?] [def: sweatshop]
shar/V/T [def: shuffle, move along; rake, remove by shoveling; scrape]
	/Garum/Gtsu/Gunter/Garoys/Garayn/Gop/Gavek/Gariber/Garop/Gtsunoyf/Giber
	/Garoyf [def: rolled up (sleeves)]
	tseshar/V/Btseshart [def: ??] 
	farshar/V/Bfarshart [def: rub; rake over] % farsharn a tepele mit ash
	shareve/V/T [def: shuffle along] % Sholem Aleykhem: Khanuke Gelt
	[idiom: sharn di shney = shovel/plow the snow]
shareva'r/N [m?] [def: wide trousers (Polish Szarawary)]
sharmanke/S [f] [def: hand organ; barrel organ]
sharbn/S [m] [def: skull (body part); small portion; potsherd] 
	sharb/Dsherb [m] [def: shard] 
	koylsharbn/S [m] [def: cooking pot]
	kugl-sharbn/S [m] [def: cooking pot]
sharf/N [f] [def: scarf (clothing)]
sharf/K [def: sharp]
	sharfkayt/N [f] [def: sharpness]
	sharf/N [f] [def: blade] 
	sharf/V/T /Gon/Gop [def: sharpen]
	farsharf/V/Bfarsharft [def: sharpe sharpenn] 
sharie/V/Bshariet sharey/V/Bshareyt [def: dawn (often with "oyf tog")]
sharlakh/A sharlekh/A [def: scarlet (color)]
sharlata'n/N [m] [def: swindler; seducer]
sharm [m] [def: charm, appeal]
sharts/V/T [def: roll up, fold up] /Garoyf/Garop
	farsharts/V/Bfarshartst [def: roll up] 
sharzh [m?] [def: caricature (Russian шарж)]
shas_{S″s}/H [m] [def: Talmud]
shaste/V/T [def: cut, run around] 
shat/V/Bgeshat [def: harm, injure, hurt] farshat/V/Bfarshat
	shedik/V/T [def: damage]
		tseshedik/V/Btseshedikt [def: damage]
		shedikung/N [f] [def: damage, hurt] 
	antshedikung/N [f] [def: reparation] 
	bashedik/V/Bbashedikt [def: damage, hurt] 
	shod/N [m] [def: shame, pity]
	shodn/S [m] [def: damage; mischief] 
		vi'ntshodn/S [m] [def: wind damage] % Yiddish League
	shedlekh/A [def: dangerous] umshedlekh/A [def: safe, not injurious] 
shataye/V/Bshatayet [def: stagger (with "zikh"); stroll (with "zikh")]
shatine/A [def: chestnut color]
	shatinke/S [f] [def: woman with chestnut hair]
shatirung/N [f] [def: shade (of color), hue] 
shatnez{Setnz}/H [m] [def: ritually unacceptable linen/wool mixture; mismatch; unwelcome person]
shats/V/T [def: value; evaluate]
	/Garayn
	/Gop [def: appreciate; appraise]
	/Giber [def: over-estimate]
	dershats/V/Bdershatst [def: appreciate]
	shatsung/N [f] opshatsung/N [f] opshats/N [m] [def: evaluation]
		opsha'tserish/A [def: evaluative, critical]
		hoykhshatsung/N [f] [def: esteem]
			hoykhgeshetst/A [def: esteemed] % Forwards: M-S Hoffman
		gringshatsung/N [f] laykhtshatsung/N [f] [def: deprecation, belittling] 
	laykhtshetsik/A [def: belittling] 
	ibershetslekh/A [def: inestimable]
	opshatser/S [m] [def: appraiser]
	umshatsbar/A [def: priceless] [usage: not recommended]
shaver [m] [def: yellow flag iris (Iris pseudacorus)]
shavesheker{Sv#-|wSkr} [m] [def: complete falsehood]
shayekh{SAx}/H /Idik [def: relevant]
	shaykhes{SIxwT}/H/N [n] [def: relevance; connection] /Idik
		umshaykhes{umSIxwT}/N [n] [def: irrelevance]
	[idiom: vos shayekh{SAx} = concerning]
shayer/N/S [m] [def: barn] 
shayer/V/T [def: scrub] /Goys
	shay'ernish/N [def: scrubbing] % Stutchkoff
shayke/S [f] [def: gang]
shayle{S#lh}/Xshayles{S#lwT}/H [f] [def: question of ritual] 
	konter-shayle{konter-S#lh}/Xkonter-shayles{konter-S#lwT} [def: question in response]
shayn/V/T [def: gleam] /Garayn/Gop/Garop/Garoys/Gdurkh
	/Goyf [def: appear]
	dershayn/V/Bdershinen [def: appear; be published]
		dershaynung/N [f] [def: appearance; phenomenon] 
	farshayn/V/Bfarshinen [def: illuminate]
	tseshayn/V/Btseshinen [def: gleam] 
	bashayn/V/Bbashaynt [def: appear]
		bashaynperlekh/A [def: obvious]
	vorshaynlekh/A varshaynlekh/A [def: clearly] [usage: inadmissible]
	opshayn [m] [def: reflection; glare] 
	zu'nenshayn [f] zunshayn [f] [def: sunshine] 
shayn [m] [def: luster, shine; light (device); certificate] 
	arbetshayn [m] [def: work permit] % Rokhl Korn: shotns
	geburtshayn [m] [def: birth certificate] % Forwards: M-S Hoffman
	lombardshayn [m] [def: pawnshop ticket]
shays/V/T [def: defecate] [usage: taboo]
	shayse/S [def: feces] [usage: taboo]
shayt{SIt}/N [m/n] [def: chunk, block (of wood)] /D
	shayter/N [m] [def: pyre; woodpile; bonfire] 
	[idiom: keyn shaytl ivre{eBry} = not a word of Hebrew]
shedever/S [m] [def: masterpiece] 
shedre{Sdrh}/Xshedres{SdrwT}/H [f] [def: spine] 
	khut_hashedre{Hwt-hSdrh}/S/Xkhut_hashedres{Hwt-hSdrwT} [def: backbone (body part)]
shef/N [m] [def: chief, head, boss, principal, superior] 
shefe{Sfe}/H [f] [def: cornucopia] /Idik
shehoye{Shyh}/H [def: that was] 
shekel{Skl}/H [m] [def: coin (Biblical currency)] 
sheker{Skr}/Xshkorem{Skrym} [m] shakres{SkrwT}/H [def: falsehood] 
	shakren{Skrn}/Xshakronem{Skrnym}/H [m] shakrente{Skrnte}/S [f] [def: liar]
	sheker_vekozev{Skr-|wKzB} [m] [def: complete falsity]
shekheyanu{ShHynw}/H [m] [def: prayer of renewal] 
shekht/V/Bgeshokhtn /Goys
	shekhter/S [m] [def: slaughterer]
	shoykhet{SwHt}/Xshokhtem{SwHtym} /H/D [m] [def: ritual slaughterer] 
		shoy'khetke{SwHtke}/S [f] [def: slaughterer's wife]
	shkhite{SHyth}/Xshkhites{SHytwT}/H [f] [def: slaughter; massacre]
shekht/N [m?] [def: box; carton; maid (klezmer-loshn)] /D
	shakhtl/N /Dshket /Dshkut shaktulke/S [f] 
	tabek-shketele [def: tobacco can]
	besomem_shketele{bQmym-shketele} [def: spice box]
shel{Sl}/H [def: of] 
shel [m] [def: diamonds (playing cards)] % no plural?
sheleshtshe/V/T [def: rustle, crinkle]
sheliyekh{SlyH}/Xshlikhem{SlyHym}/H [m] [def: messenger, agent]
	shluekh{SlwH}/Xshlukhem{SlwHym}/H [m] [def: religious outreach agents (Chabad)]
	shlikhes{SlyHwT}/Xshlikhesn{SlyHwTn}/H [n] [def: embassy] 
	meshulekh{mSwlH}/H [m] [def: messenger, emissary] 
	meshaleyekh{mSlH}/V/T [verb] [def: expel (usually with "zayn fun")] [usage: humorous]
		/Garoys
	mishlakhes{mSlHT}/N [n] meshulakhes{mSwlHT}/N [def: misfortune, disaster; epidemic]
	shalekh{SlH}/D [def: sending] meshloyekh{mSlwH}
shelme/S [f] shelmak/Ees [m] [def: rascal] shelmish/A [def: roguish]
shem/V/T [def: be embarrased (with "zikh"); be self-conscious (with "zikh")]
	farshem/V/Bfarshemt [def: embarrass]
		farshemtlekh/A [def: somewhat embarrassed] % Der Nister
		umfarshemt/A [def: unembarrassed, ashamed]
			umfarshemterheyt [adv] [def: unashamedly]
		umfarshemtkayt/N [f] [def: lack of embarrassment]
	shemevdik/A [def: shy] shemevdikayt/N [f] [def: shyness] 
shemets{Smc}/H [m?] [def: a small amount]
shend/V/T [def: dishonor; desecrate; rape]
	shendlekh/A [def: dishonorable, shameful, disgraceful]
	shendung/N [f] [def: rape]
	shande/S [f] shand [def: embarrassing disgrace, shame]
		shend/V/T [def: disgrace] shendlekh/K [def: disgraceful] 
		shandre bandre [m?] [def: disgraceful unfairness]
shendeli'r/N [def: chandelier]
shenik/Ees [m] [def: straw mattress]
shenk/N/D [f] [def: tavern]
	shenker/S [m] she'nkerke/S [f] [def: innkeeper]
		ba'rshenker/S [m] [def: barman] ba'rshenkerin/S [f] [def: barmaid]
	vaynshenk/N [f] [def: tavern] % Sholem Aleykhem
		vaynshenker/S [m] [def: tavern keeper; wineseller]
shenk/V/T [def: give away] /Gavek/Gop
	/Bgeshonken /Gavek/Gop % variant participle
	bashe'nk/V/Bbashonken [def: gift] 
	tseshe'nk/V/T [def: distribute gifts] 
	gesha'nk/N [n] [def: gift] 
	droshe_gesha'nk{drSh-gesha'nk}/N [n] [def: gift to the groom]
	kale_gesha'nk{Klh-gesha'nk}/N [n] [def: gift to the bride]
shep/V/T [def: draw, dip, ladle; derive] /Gon/Gop
	/Goys [def: use up, exhaust, deplete]
	dershep/V/Bdershept [def: use up, exhaust]
	umoyssheplekh{um#oyssheplekh}/A umdersheplekh/A [def: inexhaustible, limitless]
	oysgesheptkayt/N [f] [def: state of being drained]
	shep/N [f] [def: scoop, dipper]
shepelyave/A shipelyave/A shtshipelyave/A [def: lisping]
sheps/N [m] [def: sheep] /Ien
	shof/X/N [f/m] /In /Dshef [def: sheep] 
	yungshof/X/N [f/m] [def: lamb] % Stutchkoff
sheptshe/V/T [def: whisper] /Garoys/Garayn/Gdurkh
	sheptsh/N [m] [def: whisper]
	sheptsheray'/N [n] [def: whispering]
sher/V/Bgeshoyrn [def: cut] /Gop/Garum/Goys/Gtsu/Gunter
	/Gkurts [def: close-cut] % B. Sandler: Karolina-Bugaz
	/Bgeshorn /Gop/Garum/Goys/Gtsu/Gunter % variant participle
	sher/N [n] [def: type of dance]
	sher/N [f] [def: scissors] /D
	sherer/S [m] she'rerin/S [f] [def: barber] 
	bo'rdsherl/Eekh [n] [def: beard trimmer] % Yiddish League
	go'rtnsher/N [m] [def: pruner] % Stutchkoff
	oysshe'renish/N [n] [def: papercut (craft)] % Forwards: Yoel Matveyev
sherenge/S [f] [def: line, file] 
	sherengesvayz [adv] [def: in a line] 
sherets{Src}/Xshrotsem{Srcym}/H [def: reptile, worm, crawling animal] 
	farsherets{farSrc}/V/Bfarsheretst{farSrct} [def: infest]
sheri [m?] [def: sherry (wine)]
sherts /Dsherts [m] shirts [m] /Dshirts [def: apron; pinafore]
shetekh{StH}/N/Xshtokhem{StHym}/H [def: district; territory] 
shevekh{SBH}/Xshvokhem{SBHym}/H [m] [def: praise] /Lle{l} [adv] [def: in praise]
shevet{SBt}/Xshvotem{SBtym}/H [m] [def: tribe] 
	[idiom: asores{eQrT} hashvotem{hSBtym} = ten lost tribes of Israel]
shevet_{SBt}/H [m] [def: month of Shevat]
	beshvat{bSBt}/H [def: in the month of Shevat]
	[idiom: vi di zun in shevet = cold and distant]
sheybe/S [f] [def: round piece of metal for holding diamonds being polished] % Esther Kraytman: Briliantn
sheyd/N [f] /D [def: sheath; vagina (body part)] 
	mutersheyd/N [f] [def: vagina (body part)]
sheyd/V/T [def: separate] /Gop/Gfunander
	/Gunter [def: differentiate]
	tsesheyd/V/Btsesheydt [def: separate] 
		tsesheydung/N [f] [def: separation]
	antsheyd/V/Bantsheydt [def: decide]
		antsheydn/A antsheydnd/A [def: decisive] 
	farsheydn/K farshidn/K [def: different]
		farsheydnerley [def: various]
		farsheydnkayt/N [f] [def: difference] 
	basheyd/V/Bbasheydt [def: interpret] 
		basheyd/N [m] [def: interpretation; decision; solution] 
	basheydn/A [def: modest, reserved] basheydnkayt/N [f] [def: modesty] 
	opsheyd/N [m] [def: distance, separation; divide]
	oyssheydung/N [f] [def: secretion]
	untershid/N [f] untersheyd/N [f] [def: difference]
		untersheydung/N [f] [def: differentiation] % D-H Katz
	tsvishnsheyd/N [f?] [def: distinction]
	shayd/V/Bgeshidn [def: separate] 
	tseshayd/V/Btseshidn [def: separate] 
	[idiom: opgesheydt zol X zayn = may X rest in peace]
sheyd_{Sd}/Xsheydem{Sdym}/H [m] [def: demon (Jewish)] /Iish
	-/Xsheydemlekh{Sdymlekh} [def: little demons]
	sheydikhe{Sdikhe}/S sheyde{Sydh}/Xsheydes{SydwT} [def: female demon (Jewish)]
sheydl/N [m?] [def: skull] [usage: not recommended]
	markh-sheydl/N [m?] gehirn-sheydl/N [m?] [def: skull] [usage: not recommended]
sheyfe{Sfe}/H [def: cornucopia] /Lbe{b} [adv] [def: in full measure] 
sheykh [m] [def: sheik (Islamic leader; Arabic)]
sheyl/V/T [def: peel] /Gop/Gavek/Goys/Garoys
	sholekhts/N/Eer [f] [def: peelings]
	olev_hasholekhts{elyw~hsholekhts} [def: may he rest in peace (mocking)] 
shem_{Sm}/H [m] [def: name]
	-/Xsheymes{SmwT} [def: papers containing God's name, requiring burial or burning; combinations of God's name (mystic)]
	shem_havaye{Sm-hw|yh} [m] [def: explicit name of God]
	shem_{Sm}/V/T/H [def: be famous] 
	farshemt_{farSmt}/A [def: famous]
	shmoy{Smw}/H [def: his name]
	shmoys{SmwT}/H [m] [def: Exodus (book of the Bible)]
	balshem{bel-Sm} [m] [def: wonder worker] 
	leman_hashem{lmen-hSm} [interj] [def: for God's sake]
	kidesh_hashem{kydwS-hSm} [def: martyr's death]
	hashe'm{hSm}/H/S [def: God]
		im_yi'rtsashem{#m-yrc|h-hSm} mirtsashem mirtshem [interj] [def: God willing]
		khi'lel_hashe'm{Hylwl-hSm}/H [m] [def: profanation of God's name; public sinning]
sheyn/Kshen [def: pretty] /Iink /Itshink /Itshik
	sheynkayt/N [f] [def: beauty] sheynhayt/N [f] [def: beautiful person or thing]
	farshener/V/Bfarshenert [def: beautify; clean up]
	bildsheyn/A [def: beautiful]
sheyres{S#ryT}/H/N [f] [def: remnant; Holocaust survivor (with "- h|pleyte")]
	shirayem{SyrAm}/H [def: leftovers] 
	nisher{nS#r}/H [m] [def: remnant; vestige]
shiber/X/S [m] [def: baker's peel; oven attendant; splinter]
shibesh{SybwS}/Xshibushem{SybwSym} [m] [def: trivial amount of money]
shibiltnitse/S[f] [def: window pane (Ukrainian)]
shier [adv] [def: almost, nearly (with "nit")]
shier_{Syewr}/Xshiurem{Syewrym}/H [m] [def: limit, boundary; Talmud lesson]
	[idiom: vifl iz der shier_{Syewr} = how long will it last?]
	eyn-leshayer{#yN-lSer} [adj predicative] [def: tremendous, unfathomable]
-/Xshies{ShywT} [def: delays (often with "makhn": dawdle, delay)]
shif/N/D [f] [def: ship]
	shifer/S [m] shi'ferin/S [f] [def: sailor]
	shif/V/T [def: go boating] % Sholem Aleykhem: Shprintse
	shifl/V/T [def: row] 
	kosmosshif/N [f] [def: space ship] 
	damfshif/N [f] [def: steam ship] 
	hotelshif/N [f] [def: hotel ship] % Forwards: M-S Hoffman
	krigshif/N [f] [def: warship] 
	lu'ksusshif/N [f] [def: yacht, luxury ship] % Forwards: M-S Hoffman
	zeglshif/N [f] [def: sailboat] 
	[idiom: farbrent ale shifn = no way back (burned one's bridges)]
shif/A [def: aslant, oblique]
shifer/N [m] [def: cipher, code] 
	yerishe_shifer{yrySh-shifer}/N [m] [def: genetic code] [note: V]
shifl [n] [def: syphilis (disease)]
shiit/N [m] [def: Shiite (Moslem)] 
shik [m] [def: elegance]
shik/V/T [def: send]
	/Gaheym/Garayn/Garop/Garoyf/Garoys/Gop/Gtsurik/Gavek/Gtsu/Gmit/Gahin
	/Gaher/Gariber/Gfunander/Gunter
	/Giber [def: forward]
	/Gnokh [def: send to; forward]
	/Gon [def: send (a calamity)]
	farshik/V/Bfarshikt [def: exile]
		farshikung/N [f] [def: exile]
	tseshik/V/Btseshikt [def: send away] 
	geshi'kt/A [def: skillful, deft, dexterous]
		geshiktkayt/N [f] [def: dexterity] 
	onshi'kenish/N [f] [def: curse, calamity; blockhead]
	shikeve/V/T [def: get ready (with "zikh")]
	o'pshi'ker/S [m] [def: sender]
shikani'r/V/Bshikani'rt [def: vex, annoy, irk]
	shikane/S [f] [def: vexation]
shiker{SyKwr}/Xshikurem{SyKwrym}/H [m] shikerte{SyKwrte}/S [f] [def: drunkard]
	shiker{SyKwr}/A [def: intoxicated] /Iish [def: drunken] /Ilekh [def: tipsy]
		/Ievate
	shikerl{SyKwrl}/Xshikerlekh{SyKwrlekh} [n] [def: tipsy feeling] % Der Nister: Mashber
	shikererheyt{SyKwrerheyt} [adv] [def: in a drunken state]
	shiker{SyKwr}/H/V/T [def: become drunk (with "zikh")] /Gon/Gayn
	farshiker{farSyKwr}/V/Bfarshikert{farSyKwrt}/H [def: intoxicate] 
	shikres{SyKrwT}/H [f] [def: drunkeness] 
shikht/N [m] [def: layer, level]
	filshikhtik/A [def: multi-layered] % Forwards: Boris Sandler
shikse/S [f] [def: non-Jewish young woman (derogatory)] /In /Dshiks
	shi'ksenik/Ees [m] [def: womanizer who likes non-Jewish women] 
	gasnshikse/S [f] [def: prostitute] % Sholem Aleykhem
	sheygets sheygets_{Sgc}/Xshkotsem{Skcym}/H [m] [def: non-Jewish young male (derogatory); brat; pastry made of honey-glazed dough stuffed with poppy seeds (food)]
		sheygetsl{Sgcl}/Xshkotsemlekh{Skcymlekh} [def: brat] 
		shkots/Xshkotsem{Skcym} [m] [def: Jewish young male (derogatory)]
		shkotseray'/N [n] [def: misbehavior]
	oyssheygetsn{oysSgcn}/S [m] [def: scolding]
	shikets_meshoymem{Sykwc-mSwmm} [def: idol, idolatry (scoffing)]
shikzal [m] [def: fate, luck]
shild/N/D [m/f] [def: metal plate, sign, signboard, shield] 
	onerke'n-shild/N/D [m/f] [def: plaque] [note: V]
	stopshild/N [m] [def: stop sign] % Yiddish League
shilder/V/T [def: depict] 
	farshilder/V/Bfarshildert [def: sign-posted] 
	shilderung/N [f] [def: depiction] 
shildkroyt [def: tortoise] 
shilshel{SylSul} [m] [def: diarrhea]
shilt/V/Bgesholtn shelt/V/Bgesholtn [def: curse] /Goys
	farshilt/V/Bfarsholtn [def: curse] 
shilyue/S [m] shiluye/S [m] [def: rapscallion; scoundrel]
shimenesre{Smwnh-eQrh}/H [def: eighteen benedictions, amidah] /Idik
shimer/V/T [def: shimmer]
	shimeri'r/V/Bshimeri'rt shemeri'r/V/Bshemeri'rt [def: shimmer] 
	shimerirung/N [f] [def: shimmer] 
shiml [m?] [def: grey horse with brown spots]
shiml [m] [def: mold] /Idik
	shiml/V/T [def: molder]
	farshiml/V/Bfarshimlt [def: molder] 
shind/V/Bgeshundn [def: flay, skin] /Garop/Gop
	shinder/S/X [m] [def: flayer]
shindl/N [f] [def: shingle]
shine/S [f] [def: wheel rim; rail; iron bar]
shine_{Synwy}/Xshinuem{Synwym} [def: euphamism; modification] 
shine'l [m] [def: woolen overcoat (clothing)]
shinke [f] [def: ham (food)]
shipe/V/T [def: hiss (sound of a snake)] /Goys/Garoys
shipue{Sypwe}/Xshipuem{Sypwe|im} [m] [def: hillside; cliff] 
	meshupe{mSwpe}/H [def: aslant, sloping; downhill] /Idik
shir{Syr}/Xshirem_{Syrym}/H [m] [def: song] /Lha{h} [noun] [m] [def: the song]
	shire{Syrh}/H [def: song] 
	shirashirem{Syr-hSyrym} [m] [def: Song of Songs (Biblical)]
shirem/V/T [def: protect]
	bashirem/V/Bbashiremt [def: protect]
	shirem/S [m] [def: umbrella] /D
		lompn-shirem/S [m] [def: lightshade]
shis/V/Bgeshosn [def: shoot, fire] /Garop/Garoys/Gavek/Goys/Gtsu/Gdurkh
	/Gunter [def: shoot down] 
	dershis/V/Bdershosn [def: shoot to death] 
	bashis/V/Bbashosn [def: shoot] 
	tseshis/V/Btseshosn
	shiser/S [m] [def: shooter]
		flokn-shiser/S [m] flokn-shi'serke/S [f] [def: braggart (ironic), swashbuckler] 
		trefshiser/S [m] [def: marksman, sharpshooter]
	shiseray'/N [n] [def: shooting]
	shos/N [m] [def: shot] 
	oy'sshis [m] [def: leftovers, rejects (jewelers' argot)]
	[idiom: shisn tsvey hozn mit eyn shos = kill two birds with one stone]
shishke/S [f] [def: pine cone; bigshot] 
	[idiom: nit vert keyn shishke = worthless]
shisl/N [f] [def: bowl; dish] shi'sele/Xkh [n] [def: bowl]
	knishisele/Ekh [n] [def: patella (body part)]
	[idiom: zitsn bay der shisl = be in authority]
shit/V/Bgeshotn [def: pour (dry material)]
	/Garop/Gop/Garoys/Garop/Goys/Gon/Garayn/Gop/Giber
	/Bgeshit % variant participle
		/Garop/Gop/Garoys/Garop/Goys/Gon/Garayn/Gop/Giber
	dershit/V/Bdershotn [def: pour] 
	tseshit/V/Btseshotn/Btseshit [def: scatter, strew] 
	farshit/V/Bfarshotn [def: fill by pouring] 
	bashit/V/Bbashotn [def: fill by pouring] 
	oysshit/N [m] oyshitekhts/Eer [def: rash (skin disease)]
	untershit/N [m] [def: (cat) litter] [note: V]
	shot/N [m] [def: an incident of pouring]
		oysshot/N [m] [def: scattered pieces]
shitake [adj] [def: shitaki (kind of mushroom)] % Forwards: S-R Schaechter
shite{Syth}/Xshites{SytwT}/H [f] [def: method, system; school of thought]
shiter/K [def: thin]
	shiterkayt/N [f] [def: thinness]
shits/V/T [def: protect]
	bashits/V/Bbashitst [def: protect]
		bashitsung/N [f] [def: protection] 
		bashitser/S [m] [def: protector] 
		umbashitst/A [def: unprotected] 
	shuts/N [f] [def: protection]
		verkshuts [f] [def: worker's compensation]
		zelbshuts [f/m] [def: self-defense] 
	shitser/S [m] [def: protector] 
	shlyakhtshits/N [m] [def: Polish nobility; landowner]
shive{SyBeh}/H [f] [def: seven days of mourning for a deceased relative] 
shiyer{Syewr}/Xshiurem{Syewrym}/H [m] [def: limit]
shkape/S [f] [def: mare (female horse)]
shkarlati'n/Ees [m] skarlati'n/Ees [m] shkarlatine/S [f] [def: scarlet fever (disease)]
shkarpetke/S skarpetke/S [f] skarpe't/N [m] [def: stocking, sock (clothing)] 
shketl/N [m] /Dshkete shkutl/N [m] shkatulke/S [f] [def: box]
	/Dyam-shketele [def: some sort of animal that hums] % ?? J. Opatoshu: lintsheray
shkhine{Sxynh}/H [f] [def: divine presence] 
shki'v_mera{SxyB-mre} [m] [def: dying person]
shkiye{Skyeh}/Xshkiyes{SkyeT}/H [f] [def: sunset]
shklaf/N [m] [def: slave]
	shklaferay' [n] [def: slavery] 
	farshklaf/V/Bfarshklaft [def: enslave] 
		farshklafung/N [f] [def: enslavement] 
shkole/S [f] [def: school (typically non-Jewish)] 
	shkolnik/Ees [m] [def: student]
shkarmu'ts/N [m] /D shkormi'ts/N [m] /D skormu'tsh/N [m] [def: paper bag (funnel or cone shaped)]
shkrobe/V/T /Goys skrobe/V/T skrobeve/V/T [def: scrub, scour, rub, polish]
	skro'benish/N [n] [def: scouring]
	shkrab/Ees [m] [def: old, worn-out shoe]
	shkrabe/S [f] [def: old horse] 
shlaba'n/N [m] shlaboym [m] [def: toll gate; barrier at city wall]
shlaberik/A [def: slack] 
shlaf/A farshlaft/A [def: very ill (Ukraine); weak (Lithuania)]
	shlafkayt/N [f] [def: disease (Ukraine); weakness (Lithuania)]
shlager/S [m] [def: success, hit, smash (theater)] % Forwards: M-S Hoffman 
shlak/N [m] [def: roof of a Succoh]
	durkhshlak/N [m] durkhshlog/N [m] [def: colander; strainer]
	toybnshlak/N [m] [def: dovecote; pigeon coop]
shlak/Xshlek [m/n] [def: stroke; evil, nuisance; dross, junk; shrew; misfortune]
	shlak/A [def: junky] 
	eybershlak/N [def: material used as a cover]
	hartsshlak/N [def: heart attack]
	hintershlak/N [def: lining (material)] % Bashevis
	hitsshlak/N [def: heatstroke]
	zunshlak/N [def: sunstroke]
	[idiom: tsores mit shlek = one misfortune after another]
shlakht/N [f] [def: slaughter, battle]
shlakhta [f] [def: gentry, nobility (Polish szlachta)] % Opatoshu: Poylishe Velder
shlal{Sll} [m] [def: great number of (often with "mit")] 
shlang/N/Xshleng [m/f] [def: snake; penis (body part) (taboo); hose] /Dshleng
	shlengl/V/T [def: weave through] /Garop/Garayn/Gavek/Garoyf
		shlengldik/A [def: weaving, snaking]
shlank/K [def: lithe] /Iik
	shlankayt/N [f] [def: litheness] 
shlayder/V/T [def: fling] /Garayn/Gavek/Garunter
	farshlayder/V/Bfarshlaydert [def: fling]
shlayen/V/T [def: wander (with "zikh")] /Garum
shlayen/S [m] [def: tench (fish: Tinca tinca)] 
shlayf/V/T [def: polish; whet; smooth] /Bgeshlifn % variant participle
	/Gop
	/Goys [def: become sensitive (with "zikh")]
	/Gon [def: sharpen]
	geshlifn/A [def: glib]
	shlayfer/S [def: polisher]
	shlif/N [m] [def: facet (of jewelry); polish, shine; refinement]
shlaykh/V/T /Garoys/Gdurkh/Garum [def: pass unnoticed] 
shlaym/N [m] [def: mucus; phlegm; slime; sludge] /Iik
	tsonshlaym [m] [def: plaque (dental)] [note: V]
	farshlaym/V/Bfarshlaymt [def: bemire, begrime, slime] % Berish Goldstein: Der Hobit
shlekht/Kerg [def: bad] /Iink
	shlekht|skayt/N [n] [def: evil things] % Sholem Aleykhem
	shlekhtkayt/N [f] shlekhtikayt/N [f] [def: evil]
	amergstn [adv] [def: worst]
	erger/V/T [def: anger; annoy] 
		ergernish/N [n] [def: anger]
	farerger/V/T [def: worsen]
		farergerung/N [f] [def: worsening]
	[idiom: dos noytike shlekhts = necessary evil] [note: V] 
shlender/V/T [def: wander, meander (with "zikh")] /Garum
	shlenderl [n] [def: morning glory (flower, Convolvulaceae)] 
shlep/N [m] [def: train (clothing)]
shlep/V/T [def: drag; pay late (jewelers' argot)]
	/Gaher/Garoys/Garunter/Gavek/Gmit/Gtsu/Gmit/Garum/Garop
	/Garayn/Garoyf/Giber/Gtsurik/Gafer/Gop
	/Gnokh [def: imitate] 
	dershlep/V/Bdershlept [def: arrive with difficulty (with "zikh")]
	farshlep/V/Bfarshlept [def: drag along]
	shleper/S [m] [def: poorly dressed person; tramp, hobo] /Iish
	nokhshleper/S [m] [def: imitator, sycophant] 
	shle'penish/N [n] [def: drawn-out affair] % Sholem Aleykhem
shleyer/V/T [def: veil] /Gon
	/Gop [def: unveil]
	shleyer/S [m] [def: veil (clothing)] 
	shleyerl/Eekh [def: caterpillar (animal)]
	farshleyer/V/Bfarshleyert [def: veil]
shleyf/N [f] [def: temple (part of the head)]
	/D [def: headband] % Stutchkoff
shleyf/N [m] [def: loop, bow] /D 
-/Xshleykes -/Xshelkes [def: suspenders (clothing)]
shleyme{Slymh}/H [def: complete (with "refue -" or "geule{g#wlh) -"] 
	shleymes{SlmwT}/H [def: completeness; perfection] /Idik [def: faultless, perfect]
		beshleymes{bSlymwT} [adv] [def: completely, perfectly] /Idik [intact, entire[
	mashlem{mSlym}/H [verb] [def: complete (with "zayn")] 
shlider/S [m] [def: blinker (for horse)]
shlima'k/Ees [m?] [def: snail (animal)] [usage: not recommended]
shling/V/Bgeshlungen [def: swallow, guzzle]
	/Garayn/Garop/Garunter/Gayn/Gmit/Gon
	farshling/V/Bfarshlungen [def: swallow up] 
	fayer-shlinger/S [m] [def: fire swallower]
	shverdshlinger/S [m] [def: sword swallower] 
	shlung/N [m] [def: esophagus (body part); swallow]
-/Xshlipyes [def: eyes]
shlis/V/Bgeshlosn [def: lock] /Gayn/Gon/Gtsu/Garoys/Gtsunoyf
	/Goys [def: lock out; suspend (from school)] /Gtsunoyf
	/Gop [def: isolate; seclude; conclude]
	/Goyf [def: unlock]
	bashlis/V/Bbashlosn [def: decide]
		bashlus/N [m] [def: decision]
		umbashlosn/A [def: irresolute; undecided]
			umbashlosnkayt/N [f] [def: indecision]
	farshlis/V/Bfarshlosn [def: lock] 
		farshlosnkayt/N [f] [def: secretiveness]
	antshlis/V/Bantshlosn [def: unlock; decide]
		antshlosnkayt/N [f] [def: unlocked state; indecisiveness] 
	oysshlislekh/A [def: exclusive]
	shlos/Xshleser [m] [def: lock; castle] 
		shlisl/X/N [m] [def: key; domain] /Dshlis
		muter-shlisl/X [m] [def: wrench (hardware)]
		shloser/S [m] [def: locksmith] 
			shloseray'/N [f] [def: locksmith shop] 
		kombinatsye-shlos/Xshleser [m] [def: combination lock] [note: V]
	geshlo's/N [def: decision] 
	/Dshles [def: zipper]
	opgeshlisn/A [def: ragged]
	rern-shloser/S [m] [def: plumber] 
	shlus [m] [def: termination, end]
		kurtsshlus [m] [def: short circuit (electric)]
	shlisung/N [f] [def: termination, end, completion; joint (carpentry)]
shlite{Slyth}/H [f] [def: domination, power] 
	shoylet{Swlt} [verb] [def: dominate (with "zayn", "iber")]
shlite_{Slyt″#}/H [interj] [def: may he live long]
shlitn/S [m] [def: sled; sleigh] /Dshlit
	shlitl/V/T [def: sled] /Garop
	oytoshlitn/S [m] [def: snowmobile] % Forwards: Berinski
shlof/V/Bgeshlofn [def: sleep] /Gayn/Giber/Gop/Goys
	/Gayn [def: fall asleep; die (euphamism)]
	/Gunter [def: have a sexual affair] % Avrom Karpinovitsh
	farshlof/V/Bfarshlofn [def: affected by sleep] 
		farshlofnkayt/N [f] [def: sleepiness] % Der Nister
		farshlofenerheyt [adv] [def: sleepily] % Bergelson: Yosef Shur 
	antshlof/V/Bantshlofn [def: fall asleep] 
	dershlof/V/Bdershlofn [def: sleep soundly] 
	shlof/N [m] [def: sleep] shlofloz/A [def: sleepless] 
	shlefer/V/T [def: be sleepy]
		/Gayn [def: make sleepy]
	shlefer/X/S [m] shle'ferin/S [f] [def: loafer, layabout]
		mi'tshlefer/X/S [m] mitshle'ferin/S [f] [def: spouse; housemate]
	shleferik/A [def: sleepy] shleferikayt/N [f] [def: sleepiness]
		aynshleferdik/A [def: sleep-inducing] % Forwards: Boris Sandler
		farshlefer/V/Bfarshlefert [def: made drowsy] % Avrom Karpinovitsh
	bayshlof [m] [def: sexual intercourse]
	umshlof [m] [def: insomnia] % Leyzer Burko
	[idiom: gey shlofn = go to sleep]
shlog/V/Bgeshlogn [def: hit, beat; fight (with "zikh")]
	/Garoys/Gop/Gdurkh/Gavek/Gtsurik/Gtsunoyf/Garop
	/Garoyf /Gtsu [def: nail up; affix] 
	/Garum [def: line (inside)]
	/Garunter [def: deduct (money); tackle] 
	/Gfor [def: suggest]
	/Giber [def: interrupt (with dative)]
	/Gon [def: thrash; repair; churn; propose; reach (with "in"/"keyn")]
	/Goyf [def: whisk, mix]
	/Goys [def: recoup expenses, strike (the hour), knock out] 
	/Gunter [def: affix (lining to clothing; support to wood)]
	bashlog/V/Bbashlogn [def: beat] 
	dershlog/V/Bdershlogn [def: oppress; depress; achieve (with "zikh")]
		dershlognkayt/N [f] [def: oppression] 
	farshlog/V/Bfarshlogn [def: beat]
	ibershlog/N [m] [def: interruption]
	tseshlog/V/Btseshlogn [def: hit; whip (food, such as egg whites)] 
	shloger/S [m] [def: hitter]
		oyfshloger/S [m] shoymshloger/S [m] [def: whisk, beater (instrument)]
	forshlog/N [m] [def: suggestion] 
	shlog/Xshleg [m] [def: punch; wound]
		opshlog [m] [def: derivative]
		oysshlog/N [m] [def: rash (skin disease)] % Yiddish League
	geshle'g/N [n] [def: fight, contest] 
		freggeshleg/N [n] [def: College Bowl (game of questions)] [note: V] 
		geshlegeray'/N [n] [def: hand-to-hand fight] % Menakhem Kipnis
	shleger/X/S [m] [def: thug] /Iish
		hint|shleger/X/S [m] [def: dogcatcher]
		toyt|shleger/X/S [m] [def: murderer]
	u'ntershla'k/N [m] [def: lining (of clothing); background]
	[idiom: oder shlogn = bleed (as a curative)]
	[idiom: kapoyr shlogn = vomit] % Michael Wex
shluk/N [m] [def: sip] 
shlukerts/V/T [def: hiccup] shlukekhts/N [m] [def: hiccup] 
	shluke'rtsenish/N [n] [def: hiccupping fit] % Forwards: Sholem Berger
	shlu'kertser [m] [def: person hiccupping] % Forwards: Sholem Berger
shlukhts/V/T shlokhts/V/T [def: sob]
shlump [m] [def: hangdog person] 
	farshlumpert/A [def: wrinkled, in poor repair] 
	shlumperl [n] [def: Cinderella] 
	shlumperdik/A [def: dowdy] 
	shlu'mperke/S [f] [def: woman who doesn't care about cleanliness]
	shlumparsk/A [def: impoverished]
shlyakh/N [m] [def: path, dirt road, unpaved road]
shlyakhetin/S [f] [def: wash-woman] % Bergelson
shlyakhte/S [f] [def: princely station, barony, dukedom]
shlyape/S [f] [def: hat worn by Chasidim (clothing); worthless person]
shlyare/S [f] [def: ruffle] 
shlyepak/Ees [m] [def: half-blind person (Polish ślepy)] %
shlyonder/V/T [def: stroll, wander; lounge] /Garum
	shlyondreve/V/T /Garum
shloyshem{SlwSym} [m] [def: thirty-day period of mourning]
	[idiom: oyszen vi an almen{almn} nokh shloyshem{SlwSym} = overdressed man]
shloyz/N [?] [def: sluice; mill lock]
shlyokh/N [m] shlyokhe/S [f] [def: slob, slattern] % Stutchkoff, Bashevis
	shlyukhe/S [f] [def: whore (vulgar) (Ukrainian-Belarusian шлюха]
shlyonder/V/T shlyo'ndreve/V/T [def: ramble, wander, roam] /Gfarbay
	shlyonder/S shlyondre/S [f] [def: slob, slovenly person] 
	shlyondrik/Ees [m] [def: slob] [note: V]
	shlyonderay'/N [f/n] [def: carelessness, negligence]
shlyope/V/T [def: wade (through snow or mud)]
	farshlyopet/A [def: deep in mud]
shlyukhote/S [f] slyukhote/S [f] slyakote/S [f] slyote/S [f] [def: rainy weather; mud]
shmad{Smd}/H/V/T [def: convert from Judaism] /Gop/Gunter
	farshmad{farSmd}/V/Bfarshmadt{farSmdt} [def: convert from Judaism] 
	meshumed{mSwmd}/Xmeshumodem{mSwmdym}/H [m] /Eeste/Eestes [f] [def: convert from Judaism]
	shmadilnik{Smdilnik}/Ees [m] shmadilnitse{Smdilnitse}/S [f] shmad_kop{Smd-kop}/Xshmad_kep{Smd-kep} [m] [def: rascal, scamp]
shmakh [m?] [def: dishonor] [usage: archaic]
shmakht/V/T [def: pine away, languish]
	farshmakht/A [def: faint, languishing, prostrate]
shmalts [n/f] [def: poultry fat (food)] /Iik
	gendznshmalts [def: goosefat (food)] 
	khazer_shmalts{Hzyr-shmalts} [n/f] [def: lard (food)]
	shmalts/V/T [def: grease]
		mu'knshmalts [n/f] [def: impossible request]
	farshmo'ltsevet/A [def: greasy] % I. J. Singer, Sholem Aleykhem
		farshmoltsn/A [def: greasy]
	shmelts/V/T [def: make fat; smelt (metal)] /Gtsu/Giber
shmant/N [m] [def: cream] 
	shlogshmant/N [m] [def: whipped cream]
	[idiom: parever shmant = non-dairy creamer (liquid)]
shmarts/V/T [def: hurt, ache, sting] shmerts/V/T
	shmarts/N [m] shmerts/N [def: pain]
	shmertslekh/A [def: painful]
shmate/S [f] [def: rag] /Idik /In
	shmatke/S [f] [def: rag; pacifier made of a cloth holding a sugar cube]
	shmateva'te/A [def: poor (quality)]
shmayd/V/Bgeshmidt [def: strike] /Goys/Gayn/Gtsu/Giber
	farshmayd/V/Bfarshmidt [def: strike; shackle] 
	shmid/N/D [m] [def: smith]
		goldshmid/N [m] [def: goldsmith]
		shmideray' [n] [def: smithy] 
	shmaydik/A [def: striking] 
	geshmaydik/A [def: agile, spry]
	[idiom: geshmidte geslekh = ??]
	[idiom: shmaydn in keytn = bind in chains]
shmaye/V/T [def: grin; bustle, move around busily]
	/Garum [def: bustle, pretend to accomplish something] 
	farshmaye/V/Bfarshmayet [def: grin; bustle] 
shmays/V/Bgeshmisn [def: strike, whip; outbid (with "zikh")]
	/Gop/Gavek/Gtsu/Garop/Garayn/Garoys/Gon/Gunter
	farshmays/V/Bfarshmisn [def: whip] % Sholem Aleykhem
	tseshmays/V/Btseshmisn [def: whip apart] % Sholem Aleykhem
	shmayser/S [m] [def: wagon driver] /D
	shmits/X [m] [def: lash] /D [def: small amount]
shmek/V/T [def: smell; sniff; be appealing]
	/Garayn/Gon/Gtsu/Garum/Gnokh/Goys/Gunter
	/Gon [def: sense]
	/Iedik [def: fragrant] 
	dershmek/V/Bdershmekt [def: smell; detect by smelling] 
	farshmek/V/Bfarshmekt [def: fill with fragrance] 
	tseshmek/V/Btseshmekt [def: emit odor (with "zikh")] 
	geshma'k/K [def: tasty] geshmakn/A
	geshma'k/N [m] [def: taste] 
		[idiom: yederer loyt zayn geshmak = everyone to his own tastes]
	shmek/N [m] [def: smell]
	shmeker/S [m] [def: nose]
	faynshmeker/X/S [m] [def: connoisseur] 
shmelke/S [m] [def: best friend (with "gants")]
shmelts/V/Bgeshmoltsn [def: melt] /Giber/Gtsunoyf/Gtsuzamen/Gunter
	/Gtsu [def: invent, dream up] % Sholem Aleykhem: Oreme un Freylekhe
	tseshmelts/V/Btseshmoltsn [def: melt] 
		tseshmeltser/S [def: fusion artist] % Forwards: I. Gottesman
	farshmelts/V/Bfarshmoltsn [def: melt]
	geshme'lts/N [n] [def: alloy] 
shmendrik/Ees [def: fool, simpleton, weakling] 
	shmendrikizm/N [n] [def: embarrassment at speaking Yiddish in public]
	[note: from the name of a Goldfaden operetta] 
shmergl/N [m?] [def: sandpaper]
shmerts/N [m] [def: pain]
	boykhshmerts/N [m] [def: stomache ache] 
shmeter/V/T [def: destroy]
	tseshmeter/V/Btseshmetert [def: destroy; smash to pieces]
		tsushmeterung [f] [def: destruction] 
shmeterling/N/D [def: butterfly (German)]
shmie{Smyeh} [f] [def: sense of hearing]
	shema{Sme}/H [f] [def: declaration of God's unity] 
	mashmoes{mSmewT}/H [adv] [def: apparently] /Idik
		mashmoesdikayt{mSmewTdikayt}/N [f] [def: probability (mathematical)]
	shmues/V/T [def: converse] /Gadurkh/Goys/Gop/Gayn/Gtsurik/Gdurkh/Giber
		shmues/N [m] [def: conversation]
		shmue_{Smweh}/Xshmues_{SmwewT} [def: rumor; piece of news] 
		shmues- [prefix] [def: conversational] 
		shmueser{Smweser}/S [def: partner in conversation]
			mitshmueser{mitSmweser}/S [def: partner in conversation]
		[idiom: loyt undzer shmues = as per our conversation] [note: V]
shminder [m] [def: term of disparagement (with "benets{bnc}")] % Sholem Aleykhem
shminke/S [def: makeup, rouge] 
	shmink/V/T [def: apply makeup] 
shmini_atseres{Smyny-ecrT} [def: festival directly after Sukkes] 
shmints/V/T [def: fornicate (vulgar, taboo)] % Michael Wex
shmir/V/T [def: spread; grease, lubricate; whitewash; bribe (slang)] /Goys/Gon
	/Gunter [def: bribe] 
	bashmi'r/V/Bbashmi'rt [def: spread (with "mit"); grease] 
		bashmi'rekhts/N [n] [def: spread]
	farshmi'r/V/Bfarshmi'rt [def: spread; grease; whitewash] 
	tseshmi'r/V/Btseshmi'rt [def: stain; exaggerate] 
	shmirekhts/N [n] [def: spread, grease, salve, lotion] 
		hoytshmirekhts/N [n] [def: hand and body lotion] 
		-/Xva'nt-shmi'rekhtsn [def: graffiti] [note: V] 
	shmirer/S [n] [def: bad playright (actors' argot)]
	shmirung/N [n] [def: spreading, greasing]
	shmi'renish/N [n] [def: greasing]
	ma'ndlshmir [m] [def: almond butter]
	sta'shkeshmir [m] [def: peanut butter]
	[idiom: der gantser shmir = the total package (German)]
	[idiom: vi geshmirt = smoothly, fluently]
shmite{Smyth}/H [def: Sabbatical year] 
shmits/V/T [def: strike; be angry (with "zikh")]
	shmitsik/S [def: bow (of violin)] 
shmoder/S [m] [def: dirt, filth; slob]
	farshmodert/A [def: filthy]
shmokh/N [m] [def: smile] /Dshmeykh
	shmeykhl/V/T [def: smile] /Garoyf/Gunter/Garoys/Gtsu
	tseshmeykhl/V/Btseshmeykhlt [def: smile] 
	shmeykhl/N/D/Idik [m/n] [def: smile]  
shmokhte/S [f] shmontse/S [f] [def: trifle, nonsense; trinket]
	shmokhtelyake/S [f] [def: trinket] % Sholem Aleykhem
shmol/Kshmel [def: narrow] /Iblekh
	farshmel/V/Bfarshmelt farshmeler/V/Bfarshmelert [def: narrow]
	[idiom: haltn shmol = be in a critical state]
shmonde/S [f] [def: female genitalia (taboo)] 
-/Xshmonem{Smwnym} [def: 80]
	[idiom: in di shmonem{Smwnym} = in the 80's (age)]
shmora'k/N [m] shmara'gd/N [m] [def: emerald (precious stone)]
shmore/V/T [def: snort; sniff]
shmoyger/S shmeyger/S [m] [def: fool]
shmoysh/N [m] shmoys/N [m] [def: lambskin (clothing); fool; female genitalia] /In
	/Dshmoys [def: girl's genitalia]
shmugl/V/T [def: smuggle] /Garayn/Garoys/Gdurkh
	shmugl/N [def: smuggling activity] 
		shumgler/S [def: smuggler]
	shmukhl/V/T [def: smuggle] % variant
shmuk/N [def: jewelry] [usage: inadmissible] 
	shmukler/S [m] shmu'klerke/S [f] [def: lacemaker] 
		shmukleray'/N [n] [def: lace-making]
shmukht/V/T [def: reek of (with "mit")] 
	shmukht/N [m/f] [def: scent, odor] 
shmuts [n] [def: dirt] /Iik /Iedik
	farshmuts/V/Bfarshmutst bashmuts/V/Bbashmutst [def: defile, pollute]
		bashmutsung/N [f] [def: dirt] 
	farshmutsik/V/Bfarshmutsikt [def: befoul, dirty] % Forwards: Boris Sandler
shmutser/V/T [def: chirp (sound of a cricket); express negation]
shnap/V/T [def: spy, sniff around]
	shnaper/S [m] [def: medical lancet]
	dershnap/V/Bdershnapt [def: sense; detect] 
shnaps/N [m] [def: brandy, whiskey, alcoholic drink; shot of brandy] /Dshneps
	[idiom: makhn a shnepsl = have a drink]
shnar/N [m] [def: scar]
shnar/V/T [def: make a commotion]
	[idiom: shnarn vi der hunt nokhn tsholnt = snore loudly]
shnayd/V/Bgeshnitn [def: cut; harvest; mow]
	/Garoys/Gayn/Giber/Gop/Goys/Garayn/Gdurkh/Gadurkh/Gon/Goyf/Garop
	/Garum/Gunter [def: prune (branches)] [note: V]
	/Gtsu [def: mark (as in cards)] % Avrom Karpinovitsh
	tseshnayd/V/Btseshnitn [def: cut apart] 
	farshnayd/V/Bfarshnitn [def: cut] 
	shnayder/X/S /D [m] /Ish shnay'derke/S shnay'derin/S [f] [def: tailor (occupation)] 
		gorgl-shnayder/X/S [m] [def: cutthroat]
		groz-shnayder/X/S [m] [def: lawnmower]
		kepshnayder/X/S [m] [def: headman, executionar; cutthroat] % Sholem Aleykhem
		tsushnayder/X/S [m] [def: cutter (occupation)]
		shnayderay' [n] [def: tailoring] shnayderay' [f] [def: tailor shop]
		shnay'deruk/Ees [m] [def: tailor (pejorative)]
	shnit/N [m] [def: cut, slice; fashion; harvest]
		durkhshnit/N [m] [def: average (numerical); crosscut] /Ilekh
		opshnit/N [m] [def: section]
		oyfshnit/N [m] [def: cold cut (food)]
		oysshnit/N [m] [def: selection] 
		tsayt-opshnit/N [m] [def: period of time]
		shnitke/S [f] [def: sandwich] [usage: neologism]
	farshnitn/A [def: cut off] 
	shnaydik/A [def: cutting]
	shnitsl/N [m] [def: meat slice]
	shnitsl/Eekh [n] [def: small piece of something]
		o'pshnitsl/Eekh [n] [def: remnant; shaving; scheme; joke]
shnayts/V/T [def: blow (a nose); snuff (a candle)] 
	/Goys [def: blow (a nose) (with "zikh")]
shnek/N [m] [def: snail (animal)] /D
	[idiom: der hoyler erdshnek = slug (animal)]
shnel/K [def: quick] shnelkayt/N [f] [def: haste] 
	farshneler/V/Bfarshnelert [def: hasten]
	amshnelstn [adv] [def: as soon as possible] % Forwards: M-S Hoffman
shnel/V/T [def: deliver a fillip]
	shnel/N [m?] [def: fillip, flick of the middle finger from the thumb]
	shneler/S [m] [def: teacher who uses the shnel as a common punishment] % Michael Wex
shney/N/D /Iik [m] [def: snow; stiffly beaten egg-whites] shneyele/Ekh [def: snowflake]
	shney/V/T [def: snow]
		farshneyt/A [def: snow-covered] 
	feter-shneyer [m] [def: snowman] 
	papshoy-shneyelekh [def: corn flakes] 
shney_{Sny} [adj] [def: two] [grammar: indeclinable]
	sheynes{SnyT} [adv] [def: again]
		vehasheynes{|whSnyT} [adv] [def: and secondly]
shnidl/V/T [def: curse; revile; scold]
shnif [m] [def: sniff] % Opatoshu: Poylishe Velder
shnip/V/T [def: cut finely] /Gavek/Garop
	shniper/X/S [def: night-thief]
shnips/N [m] [def: necktie] /D
shnits/V/T [def: whittle, carve] /Gon/Goys
	shnitser/S [m] [def: woodcarver]
	shnitseray'/N [n] [def: carving (activity)]
	geshni'ts/N [n] [def: carving (object)]
shnobl/N [m] [def: beak] shnobele/Ekh /Dshneb
	vaser-shnobl/N [m] [def: gargoyle; downspout] [note: V]
	olev_hashnobl{elyv~hshnobl} [interj] [def: may he rest in peace (mocking)]
shnol/N [m] [def: poke; belt buckle (clothing)]
	farshnol/V/Bfarshnolt [def: poke] 
shnor/V/T [def: beg, scrounge] /Gtsuzamen
	shnorer/S [m] [def: beggar; mooch, sponge] 
shnorkh/V/T /Garoys shnorkhts/V/T [def: snore; snort]
shnoyts/N [m] [def: prow (ship)]
shnuf/V/T [def: snuffle, inhale] % Sholem Asch: Motke Ganef
shnuk/N [m] [def: snout, trunk (elephant)] 
shnur/N/Xshnir [f] [def: daughter-in-law]
shnur/N [m/f] [def: rope, chain, line, thread, cord] /Dshnir
	shnu'reve/V/T [def: chain] /Gtsunoyf 
	farshnu'reve/V/Bfarshnurevet [def: chain; smirk] 
	tseshnu'reve/V/Btseshnu'revet [def: untie (laces)]
	onshnurik/A [def: cordless, wireless] 
		onshnurke/S [f] onshnurikl/Eekh [n] [def: cordless telephone] 
	shnurovadle/S [def: shoelace (clothing)] 
	relsnshnur/N [m/f] [def: railway line] % Bergelson: Yosef Shur
sho{Seh}/Een/H [f] [def: hour] beshas{bSeT}/H/P [def: when] 
	shoenvayz{Sehnvayz} [def: by the hour] 
	beshate{bSeWw} [adv] [def: in his or its time] 
	lekhayem_sho{lHAm-Seh} [def: cocktail hour] [note: V]
	ibersho{iberSeh}/Xen [def: overtime] % Avrom Karpinovitsh
	shas_hakoysher{SeT-hKwSr} [f] [def: auspicious time]
	[idiom: b|shas mayse{meQh} = meanwhile]
shob/V/Bgeshobn [def: scrape; scale (fish)] /Gop
	shobl/N [m?] [def: ?? (food)] % shobelekh mit ferfl (Stutchkoff); royte shoblen (Rozenfeld)
shofe'r/N [m] sho'fershe/S [f] [def: chauffeur]
shofl{Sfl}/A [def: humble, lowly; discouraged] /Idik
	[idiom: es is shofl{Sfl} = it's going badly]
	shifles{SflwT}/H [def: humility] 
shok [m] [def: 60; a long time (with "a - mit yorn")] 
shok [def: sound made to calm a horse] 
shokh [m] shakhma't [m] [def: game of chess]
	shakh [m] [def: game of chess] [usage: doubtful admissibility]
	shakhmati'st/N [m] [def: chess player]
shokher{SHwr}/Xshokhrem{SHrym}/H [m] [def: black man] [usage: code]
	shokherte{SHwrte}/S [f] [def: black woman]  [usage: code]
	more_shkhoyre{mrh-SHwrh}/H [def: depression; despondency] /Idik
		more_shkhoyrenik{mrh-SHwrhnik}/Ees [def: depressed person; pessimist]
shokhn{Sxn}/Xshkheynem{Sxnym}/H [m] [def: neighbor; tenant]
	shokhnte{Sxnte}/S [f] shkheyne{Sxnh}/H [f] [def: neighbor; tenant] 
		shkheynete{Sxnhte}/S [f] [def: neighbor]
	shkheynes{SxnwT}/H [def: proximity] /Idik [def: neighboring] 
		beshkheynes{bSxnwT} [adv] [def: close by] 
	shkeynish{Sxnish}/A [def: neighboring]
	shkeyneshaft{Sxnhshaft}/N [f] [def: neighborhood]
	mitshokhn{mitSxn}/Xmitshkheynem{mitSxnym} [m] [def: cotenant]
shoki'r/V/Bshoki'rt [def: shock] 
shokl/V/T [def: rock; shake] /Gtsu/Goys/Gop/Garop
	tseshokl/V/Bteshoklt [def: rock] 
	[idiom: shoklen mit dem oyer / der noz = wiggle the ear / nose]
shokolad/N [m] [def: chocolate] /In [def: chocolate]
	shokoladke/S [f] [def: chocolate candy] 
	tshekolad tshokolad % variants
shol/N [f] [def: saucer; bowl; shell] /Dshelekh
	sho'lekhl/Eekh [def: saucer] % Forwards: Boris Sandler
	she'lekhl/Eekh [def: little shells] % Sholem Aleykhem
shol_takhtiye{S#wl-WHTyh}/H [m/f] shol_takhtes{S#wl-WHTyT} [def: purgatory, hell] 
sholem{Slwm}/H/Idik [m] [def: peace]
	besholem{bSlwm} [adv] [def: in peace]
	hasholem{bSlwm} [adv] [def: the peace]
	vesholem{|vSlwm} [adv] [def: and peace]
	mushlem{mwSlm}/Xmushlomem{mwSlmym}/H [m] [def: well-rounded (religously) person]
		/Idik [def: talented]
	olev_hasholem{elyw~hSlwm} [interj] [def: may he rest in peace] 
	khas_vesholem{Hs-|wSlwm} [interj] [def: God forbid]
	[idiom: mushlem{mwSlm} bekhol{bxl} hamayles{hmelwT} = talented]
shomayem{Smym}/H [def: heaven] /Lha{h} [noun] [m] [def: the heaven]
	min_hashomayem{mn-hSmym} [adv] [def: by heavenly decree]
	yiras_shomayem{yir#T-Smym}/H [f] [def: fear of God] /Idik
		yiras_shomayemdikayt{yir#T-Smymdikayt}/N [f] [def: fear of God] 
		yore_shomayem{yr#-Smym}/Xyorey_shomayem{yr#y-Smym} [m] [def: God-fearing person]
	[idiom: shoymu{Swmw} shomayem{Smym} = how can it be, oh Heavens!]
shone{Snh}/Xshonem{Shnym} [f] [def: year]
	rosheshone{roS-hSnh}/H [m] [def: Jewish New Year] 
	shnas{SnT} [def: year of]
shop/N [m] [def: racoon (animal)] /In
shor{Swr}/H [def: ox] 
shorkhe/V/T shorkh/V/T [def: snore; rustle] 
	shorkh/N [m] [def: snort] 
	shorkhenish/N [n] [def: snoring]
shorsh/V/T [def: rustle (noise)] 
shosey'/N [m] [def: highway] 
shotn/S [m] [def: shadow] /Idik
	shotn/V/T [def: shade] 
		tseshotnkayt/N [f] [def: shade] 
	farshotn/V/Bfarshotnt [def: shade, cast a shadow] 
	bashotn/V/Bbashotnt [def: shade] 
	ha'lbshotn/S [m] [def: penumbra (astronomical)]
	na'khtshotn [m] [def: nightshade, Solanaceae (plant family)]
shove_beshove{Svh-bSvh} [adj predicative] [def: capable, expert]
shovini'zm/N [m] [def: chauvinism] shovini'st/N [def: chauvinist] /Iish
shoy [def: storefront (with "fentster")]
	bashoy/V/T [def: observe] [usage: archaic]
		bashoy/N [m] [def: observation] [usage: dialect]
	velt-anshoyung/N [f] [def: worldview (German Weltanschauung)] % Der Moment
	[idiom: bashoyen di kale{klh} = look over the potential bride]
shoyb/N [f] [def: shutter; pane  (window)]
	/Dshayb [def: eye-glass lens] % Yosl Birshteyn
	akhtshoybik/A [def: 8-shuttered] 
	vintshoyb/N [f] [def: windshield (vehicle part)] % Forwards: S-R Schaechter
shoyber/V/T [def: dishevel]
	tseshoyber/V/Btseshoybert [def: dishevel]
shoyder/V/T [def: shudder] /Goyf
	shoyder/N [m] [def: shudder] shoyderlekh/K [def: dreadful] 
shoyfer{Swfr}/Xshoyfres{SwfrwT}/H [m] [def: shofar] 
	tekiyes_shoyfer{WkyeT-Swfr} [f] [def: long blast of the shofar]
shoygeg{Swgg} [m] [def: unintentional criminal] /Idik
	beshoygeg [adv] [def: unwittingly]
shoykhet{SwHt}/H [m] [def: ritual slaughterer]
	shkhite{SHyth}/Xshkhites{SHytwT}/H [f] [def: slaughter] 
shoym/N/D [m] [def: foam; head (beer); scum] /Iik
	/Iish % Forwards: M-S Hoffman
	shoym/V/T [def: foam (intransitive); skim (transitive)] 
shoymer{Swmr}/Xshoymrem{Swmrym}/H [m] [def: guard]
	shmire{Smyrh}/H [f] [def: watch, guard, vigil] shmiras{SmyrT}/H [def: watching of] 
		likthl-shmire{likhtl-Smyrh} [f] [def: candlelight vigil] % Yiddish League
shoyn/V/T [def: look after; care for] [usage: inadmissible]
	bashoyn/V/Bbashoynt [def: look at, look after] [usage: archaic]
	farshoyn/V/Bfarshoynt [def: look after] % Itsik Manger
shoyn [def: already; right away] 
	[idiom: nit shoyn zhe = after all (accusing)]
shoyresh{SwrS}/Xshorashem{SrSym}/H [m] [def: root] 
shoys/N [m] [def: lap] 
	shoyserl/Eekh [n] [def: laptop computer] [note: V]
shoyt/N [m] [def: seed pod] /Dsheyt
	sheytl/N [n] shaytl/N [n] [def: wig] 
shpadl/N [m?] shpadle/S [f] [def: spade, shovel (tool)]
shpaga't/N [m] [def: cord, string]
shpage/S [f] [def: epée]
shpak/Ees [m] [def: roan horse]
shpakhl [m] [def: spackle (material)]
	shpa'khleve/V/T [def: spackle]
shpaktiv/N [m?] [def: lens (optical); magnifying glass]
shpaku'l/N [m?] [def: eyeglass, spectacle]
shpalt/V/Bgeshpoltn [def: split] /Goyf
	/Gop [def: compartmentalize] 
	farshpalt/V/Bfarshpoltn [def: split]
	tseshpalt/V/Btseshpoltn [def: split, compartmentalize] 
	shpalt/N/Xshpelter [m] [def: crack; female genitalia (vulgar)]
		/Dshpelt [def: crevice; crack] 
		lodnshpalt/N [m] [def: shutter cracks]
		oygnshpalt/N [m] [def: eye-slits] % Forwards: Boris Sandler
	shpaltung/N [f] [def: separation, split, rupture, falling out, schism]
shpan/V/T [def: tighten; bridle; stride]
	/Gayn/Garum/Gavek/Gtsu/Garoys/Gforoys/Gum/Giber
	/Gon [def: tighten, make tense] 
	/Goys [def: relax; unwind; unbridle]
	/Gariber [def: surpass]
	/Gop [def: unbridle, loosen]
	geshpa'n/N [n] [def: stride; harness] 
	shpan/N [m] [def: span (short distance), horse-drawn carriage]
	shpanung/N [f] [def: tension] geshpa'nt/A [def: strained] 
		geshpantkayt/N [f] [def: strain, tension] % Forwards: Yankev Goldshteyn
	[idiom: a shpan oyf a shpan = very small area]
shpar/V/T [def: press; dispute, debate (with "zikh")]
	/Gdurkh/Gtsu/Garoys/Garayn/Giber
	/Gayn [def: be stubborn; cage]
	/Gon [def: support]
	/Gtsu [def: lie down (with "zikh")] % Opatoshu: Polishe Velder 
	/Gunter [def: pry out] % Sholem Asch: Motke Ganef
		ayngeshpartkayt/N [f] [def: stubborness] 
	farshpar/V/Bfarshpart [def: make stubborn; reinforce; stuff into a bag] 
	geshpar/N [m] geshpareray'/N [n] [def: battle]
	onshpar [m?] [def: support]
		onshparenish/N [f] [def: support]
	shpa'renish/N [n] [def: argument]
shparber/S [m] [def: sparrow hawk (bird)] /Iish
shpare/S [f] shparune/S [f] [def: crack, slit]
	shparunkele/Ekh [n] [def: tiny crack]
shpas/N [m] [def: joke] /Iik [def: humorous, joking] 
	shpas/V/T [def: joke]
shpatsi'r/V/T [def: stroll] /Garum/Gdurkh/Garoys/Gavek/Gaheym
	/Bshpatsirt /Garum/Gdurkh % variant participle
	shpatsirer/S [m] shpatsirerin/S [f] [def: walker, pedestrian; hiker]
shpay/V/Bgeshpign [def: spit] /Goys/Gon
	bashpay/V/Bbashpign [def: cover with spit] 
		bashpayt/A [def: spat upon]
	farshpay/V/Bfarshpign [def: cover with spit] 
	oysshpay [def: spit] shpayekhts/N [n] [def: spit, saliva] 
	shpayer [def: spitter; revolver (ganovem-loshn)]
shpaykhler/S [m] [def: granary, storehouse, grain elevator] 
shpayz/V/T [def: feed] /Gmit
	shpayz/N [f] [def: food] 
		forshpayz/N [f] [def: appetizer (food)]
		nokhshpayz/N [f] [def: dessert (food)] 
		tsushpayz/N [m] [def: side dish (food)]
	shpayzer/S [m] [def: breadwinner; wetnurse]
	shpayzarnye/S [f] shpizarnye/S [f] [def: pantry, larder] [usage: Northern Yiddish]
shpek/N [m] [def: bacon (food)] % Michael Wex
shpekuli'r/V/Bshpekuli'rt [def: speculate (financial)]
	farshpekuli'r/V/Bfarshpekuli'rt [def: lose money at speculation (with "zikh")]
	shpekula'nt/N [m] [def: speculator] % Forwards: M-S Hoffman
	shpekulatsye/S [f] [def: speculation] % Forwards: M-S Hoffman
	shpekulator/Ees [m] [def: speculator] % Sholem Aleykhem
shpelt [m] [def: spelt] /In
shpend/D /-shpend [def: kindling]
	[idiom: aroysvarfn oyf dray shpendlekh = discard as worthless]
shpentser/S shpantser/S [def: undershirt; jacket]
	shpantsirik/Ees [m] [def: undershirt] % Stutchkoff
shperl [def: sparrow (bird)]
shpet/K /Iik/Ierdik/Ilekh [def: late] 
	shpetertsu [adv] [def: later] 
	shpetik/V/T [def: delay, be late (with "zikh")]
	farshpetik/V/Bfarshpetikt [def: delay, be late (with "zikh")]
		farshpetikung/N [f] [def: delay]
shpet/V/T [def: deride (with "fun")] /Goys/Gnokh/Gop % shpotn is German
	shpot/N [m] [def: mockery, object of derision] /Iish /Iik [def: mocking] 
	shpeter/S [m] opshpeter/S [m] bashpeter/S [m] [def: mocker]
	geshpe't/N [n] [def: mockery] % Harduf 
shpigino'r [m] [def: turpentine] % Yiddish League
shpigl/V/T [def: mirror] /Gop [def: reflect] /Gon
	opshpiglung/N [f] [def: reflection] 
	shpigl/N [m] [def: mirror] /Dshpige shpigldik/A [def: reflective] 
shpik/Ees [m] [def: secret agent]
shpi'keve/V/T [def: fill; stuff (an intestine)] /Gdurkh
	shpi'geve/V/T [def: fill] /Gdurkh
shpil/V/T [def: play] /Gop/Goys/Gtsu/Goyf/Gon/Gmit
	/Goys [def: play out, become weak]
	/Giber [def: revisit]
	shpiler/S [m] /Iish shpi'lerin/S [f] [def: performer] 
		shokhshpiler/S [m] [def: chess player]
		shoy'shpiler/S [m] [def: actor] /Iish shoyshpi'lerin/S [f]
		tashnshpiler/S [m] [def: pickpocket] 
		shpi'lerke/S [f] [def: player (machinery)] 
	shpil/N [f/n] [def: game; female genitalia (taboo)] /Dshpilkh
		azartshpil/N [f/n] [def: game of chance, gambling] 
		bayshpil/N [m] [def: example]
		bretshpil/N [f/n] [def: board game] 
		forshpil/N [f/n] [def: prelude (drama); presentation of the bride]
		ki'ndershpil/N [f/n] [def: children's play] 
		ko'rtnshpil/N [f/n] [def: card came]
		le'bnsshpil/N [f/n] [def: lifestyle] % Forwards: Boris Sandler
		pu'rim|shpil/N [f/n] [def: Purim play] 
		shokhshpil/N [f/n] [def: chess game] 
		shoyshpil/N [f/n] [def: play (performance)] 
		tisshpil/N [f/n] [def: board game] % Forwards: Yoel Matveyev
		tsey'khnshpil/N [f/n] [def: jacks (game)] % Stutchkoff
		tsuza'menshpil/N [m] [def: interplay]
		vortshpil/N [f/n] vertershpil/N [f/n] [def: pun]
		[idiom: oys shpil = the game's over]
	farshpil/V/Bfarshpilt [def: lose (contest)] 
		umfarshpilik/A [def: win-win; unlosable] % Forwards: B. Sandler
	dershpil/V/Bdershpilt [def: accidentally result in (with "zikh")] % Sholem Aleykhem
	tseshpil/V/Btseshpilt [def: play] 
		tseshpiltkayt/N [f] [def: playfulness] % I. J. Singer
	shpilevdik/A [def: playful] 
		shpilevdikayt/N [f] [def: playfulness]
	shpilekhl/Eekh shpilkhl/Eekh [n] [def: plaything]
	shpileray'/N [n] [def: game] % Forwards
shpilye/V/T [def: pin] /Gayn/Gfunander/Goyf
	farshpilye/V/Bfarshpilyet [def: pin, button] 
	tseshpilye/V/Btseshpilyet [def: unpin, unbutton] 
	shpilke/S [f] [def: pin] 
		horshpilke/S [f] [def: hairpin] % Harduf
		tsitershpilke/S [f] [def: (some sort of pin)] % Bashevis
	[idiom: zitsn oyf shpilkes = wait nervously]
shpin/V/T/Bgeshpunen [def: spin] /Goys [def: draw out]
	geshpins/N [n] [def: web; tissue]
	shpin/N [f] [def: spider (arachnid)] /Ievdik
	shpiner/S [m] [def: spinner]
	goldshpiner/S [m] [def: gold spinner] 
	shpindl/N [m] [def: spindle] 
shpina't/N [m] [def: spinache] 
shpinte/S [f] [def: cigarette butt] 
shpon/Xshpener [m?] [def: piece of wood]
	grinshpon [m?] [def: verdigris (copper oxide)]
shpongele/S [f] [def: huckleberry (Vaccinium spp.)]  % Stutchkoff
shpyon/N [m] shpyonke/S [f] [def: spy] shpyonazh [m] [def: espionage] 
	shpyoni'r/V/Bshpyoni'rt /Goys [def: spy out] 
shpir/V/T [def: sense]
	/Gnokh [def: detect] 
	/Goys [def: spy out]
	dershpi'r/V/Bdershpi'rt [def: sense] 
	oysshpir/N [m] [def: espionage]
		/Ierish [def: spying] % Forwards: Krutikov
		oysshpirer/S [m] [def: spy]
		ko'nteroy'sshpir [m] [def: counterintelligence] % Yiddish League
shpitol/N/Xshpiteler [m] [def: hospital] 
	shpitolizi'r/V/Bshpitolizi'rt [def: hospitalize] 
		shpitolizirung/N [f] [def: hospitalization]
shpits/V/T [def: make a tip; tat (make lace)] /Giber/Goyf/Gon
	shpitsn [m?] [def: lace]
		[idiom: brabander shpitsn = lace from Braband, Belgium]
	geshpi'tst/A [def: clever]
		geshpitstkayt/N [f] [def: cleverness]
		nit-i'bergeshpi'tstkayt/N [f] [def: foolishness] % Kulbak: Zelmenyaner
	shpits/N [m/f] [def: tip, point; top; punchline] /Iik /Iekhik
		/D [def: joke, trick] 
		boyershpits/N [m] [def: drill bit] % Maurice Wolfthal
		boymshpits/Xbeymershpitsn [m/f] [def: treetop] 
		ey'bershpitsl/Eekh [n] [def: scheme, gimmick]
		fingershpits/X/N [def: fingertip]
		horshpits/N [def: tip of the hair] 
		kloy'stershpits/N [def: church steeple] % Bergelson
		nashpits/Iik [def: in a row (horses)] 
		shvartsshpitsik/A [def: black and pointy] % Forwards: Boris Sandler
	oybershpitslekh/A  [def: principle] 
	farshpits/V/Bfarshpitst [def: make pointed]
		farshpitst/A [def: pointed; clever]
		farshpitstkayt/N [f] [def: pointedness; cleverness] 
	[idiom: farshpitsn di oyern = listen attentively]
shpitsl/N [m] [def: spy] % Yiddish League
shpiz/N  [m/f] [def: spear] /Iik
	shpizl/Eekh [def: knitting needle] /Idik
	shpiz/V/T [def: spear] /Gadurkh [def: impale] 
	bashpiz/V/Bbashpizt [def: equip with a spear] % Forwards: M-S Hoffman
	brotshpiz/N [f] [def: spit (for roasting)] /D
	/Dvarfshpiz [n] [def: dart (game item)]
shpliter/N [m] [def: splinter, sliver] 
	shpliter/V/T [def: splinter] /Gop
shpog [m] [def: club (playing cards)] % no plural?
shpogl [def: brand new (with "nay")] 
shponke/S [f] [def: a kind of cherry (fruit)]
shpondre/S [f] [def: sirloin; flanken, soup meat]
	shpondrik/Ees [m] [def: person (derisive)] 
shpor/N [m] [def: spur]
shpor/V/T [def: save up] /Gon/Gayn/Gop
	farshpor/V/Bfarshport [def: avoid] 
	shpo'revdik/A [def: practical; thrifty]
	opshporung/N [f] [def: savings] [usage: plural]
 shprakh/N [f] [def: language] /D
	oysshprakh/N [f] [def: expression]
	kvalshprakh/N [f] [def: original language] 
	ke'rpershpra'kh/N [f] [def: body language]
	shprakhik/A [def: language]
		andershprakhik/A [def: foreign language]
		drayshprakhik/A [def: trilingual]
		tsveyshprakhik/A [def: bilingual]
		tsvishnshprakhik/A [def: multilingual] mershprakhik/A
			tsvishnshprakhikayt/N [f] [def: multilingualism]
		shprakhikayt/N [f] [def: ability to speak] 
	shprakhlekh/A [def: linguistic]
	guf_shprakh{gwf-shprakh}/N [def: body language] 
	folkshprakh/N [def: folk language] /Iik
	fremdshprakh/N [f] [def: foreign language]  /Iik
	kulturshprakh/N [f] [def: high language] 
	landshprakh/N [f] [def: national language]
	mutershprakh/N [f] [def: mother tongue]
	redshprakh/N [f] reydshprakh [f] [def: spoken language] /Iik
	shmuesshprakh/N [f] [def: common parlance, vernacular]
	shokhshprakh/N [f] [def: technical language of chess] % Forwards: Boris Sandler
	veltshprakh/N [f] [def: universal language; lingua Franca]
	shprukh/N [m] shprokh/N [m] [def: incantation, formula (verbal)]
		vidershprukh/N [m?] [def: contradiction] [usage: not recommended]
			vidershprekh/V/Bvidergeshprokhn [def: contradict] [usage: not recommended]
		shprekh/V/T [def: recite a formula] /Gayn/Goys
			/Gop [def: charm away]
			/Bgeshprokhn /Gayn/Gop/Goys % variant participle
			farshprekh/V/Bfarshprokhn [def: recite a charm]
			opshprekher/S [m] opshpre'kherin/S [f] [def: curse remover]
				opshpre'khenish/N [n] [def: charm (verbal)]
			firshprekher/S [m] [def: spokesman; defender]
		geshpre'kh/N [n] [def: formula; conversation]
	antshprekh/V/Bantshprekht [def: correspond, be appropriate] 
shprayz/V/T [def: walk; stalk] /Garum/Giber/Garop/Garoyf/Garayn
	ibershprayz [m] [def: stroll]
	ibershprayzer/S [m] [def: stroller] 
shprenkl/V/T [def: sprinkle] /Dshprenk [def: freckle] 
	/Dshprink [def: spot, defect]
	tseshprenkl/V/Btseshprenklt [def: speckle]
	zumer-shprenkele/Eekh [n] [def: freckle] 
	bashprenklt/A [def: speckled] 
shpreyt/V/T [def: spread out] /Goys/Gfunander
	farshpreyt/V/Bfarshpreyt [def: disseminate; spread (with "zikh")]
		farshpreyt/K [def: widespread] farshpreytung/N [f] [def: dissemination] 
	tseshpreyt/V/Btseshpreyt [def: disseminate] 
		tseshpreytung/N [f] [def: dissemination]
	shpreyt/K [def: widespread]
	untershpreyt/N [m] [def: (cat) litter] [note: V]
shprikh/N [m?] shprikhe/S [f] [def: rim (of wagon wheel)]
shpring/V/Bgeshprungen [def: jump] 
	/Garoys/Garayn/Gariber/Garop/Garoyf/Gum/Goyf/Gunter/Gtsurik/Garum
	/Gforoys/Gavek/Giber
	/Gop [def: recoil; flinch]
	shprung/N [m] [def: jump] hoykhshprung/N [m] [def: high jump] 
		katsnshprung/N [m] [def: short distance]
		urshprung/N [m] [def: beginning] [usage: inadmissible]
		urshpringlekh/A [def: primitive, rudimentary; original] [usage: inadmissible]
	tseshpring/V/Btseshprungen [def: shatter; explode]
	shpringer/S [m] [def: jumper; knight (chess piece)] 
shprits/V/T [def: spray] /Garoys/Gop
	/Gayn [def: inject]
	geshpritseray'/N [n] [def: spraying] 
	bashprits/V/Bbashpritst [def: sprinkle, splash] 
		bashpritser/S [m] [def: sprinkler] 
	farshprits/V/Bfarshpritst [def: sprinkle, splash]
	shpritser/S [m] [def: fountain; shower; selzer bottle; sprinkler] 
	ay'nshpritser/S [m] [def: syringe]
		aynshpritsung/N [f] [def: injection] % Forwards
	shpritsl/V/T [def: sputter, splutter]
	tseshprits/V/Btseshpritst [def: spray]
		tseshpritser/S [m] [def: sprinkler]
		vaser-tseshpritser/S [m] [def: sprinkler]
	va'sershprits/N [m] [def: hose]
shpronshke/S [f] [def: belt buckle (clothing)] % Forwards: Boris Sandler
shprots/V/T [def: sprout] /Goyf/Garoys
	shprots/N [m] [def: sprout] /D
	shprotsung/N [f] [def: sprouting, bloom]
shprudl/V/T [def: well, sputter] 
	shprudldik/A [def: ebullient] 
shpul/N [m?] [def: spool, coil]
shpunt/N [m] [def: cork, plug, stopper]
shpur/N [f/m] [def: trace] 
	shpurloz/A [def: without a trace] % Der Nister
shrage/S [f] [def: clothespin]
shram/N [m?] [def: slit; mark on the skin, scar]
shrapne'l/N [m?] [def: shrapnel]
shray/V/Bgeshrign [def: call, shout, scream]
	/Garayn/Garop/Goys/Giber/Gon/Gnokh/Garayn/Gtsurik/Garoys/Gunter
	/Bgeshrien /Garayn/Garop/Goys/Giber/Gon/Gnokh/Garayn/Gtsurik/Garoys/Gunter % variant 
	geshrey'/N [n] [def: call, shout; scream] geshreyeray'/N [n] % not geshray
		oy'sgeshrey'/N [n] [def: outcry] 
		vey'geshrey'/N [n] [def: cry of pain]
	tseshray/V/Btseshrign/Btseshrien [def: call for a period of time (with "zikh")] 
	himlshrayendik/A [def: abysmal, terrible] 
	shray/N [m] [def: hoot (sound of an owl)] [note: V]
	farshray/V/Bfarshrign [def: cast an evil eye] 
	shrayer/S/X [m] [def: caller] /Iish shrayik/A [def: screaming]
		mark-shrayer/S [m] [def: bombastic person; braggart, boaster]
		oysshrayer/X [m] [def: town crier]
		hura-shrayer/X [m] [def: sycophant]
		mark-shrayer/X [m] [def: tout]
shrayb/V/Bgeshribn [def: write]
	/Garayn/Goyf/Gop/Garoys/Gavek/Giber/Gnokh/Gtsu/Gunter/Gayn
	/Gdurkh/Gadurkh [def: correspond (with "zikh")] 
	/Gon [def: register, check in (with "zikh")]
	/Goys [def: check out (hotel) (with "zikh")]
	bashrayb/V/Bbashribn [def: depict, describe]
		bashrayber/S [m] [def: depicter, writer] /Iish
		bashraybung/N [f] [def: depiction, description] 
		bashray'benish/N [n] [def: depiction]
		bashraybekhts/N [f] [def: depiction, description] 
	farshrayb/V/Bfarshribn [def: prescribe; include in a list; register]
		farshraybung/N [f] [def: registration (action)]
	tseshrayb/V/Btseshribn [def: agree through letters (with "zikh")]
	shrift/N/Ilekh [m] [def: font; written document]
		oyfshrift/N [m] [def: writing] 
		aynshrift/N [f] [def: inscription]
		fle'klshrift [f] [def: cuneiform]
		forshrift/N [f] [def: prescription (medical); example (written)]
		hantshrift/N [f] [def: handwriting] [def: doubtful admissibility] 
		monatshrift/N [f] [def: monthly journal] % Sholem Aleykhem
		tsaytshrift/N [f] [def: newspaper] 
		u'ntershrift/N [f] [def: signature]
		va'sershrift/N [f] [def: disappearing ink] % Yosl Birshteyn
		geshrift/N [n] geshrifts/N [n] [def: document; legend]
	shrayber/S [m] /D shray'berin/S [f] [def: writer] 
		shray'berish/A [def: authorial] 
		mitshrayber/S [m] [def: co-author] % Forwards: J. Shekhter
		va'ldshrayber/S [m] [def: lumbering accountant]
		shrayberuk [m] shraybune/S [f] [def: writer (pejorative)]
	shrayberay'/N [n] [def: writing] shraybung/N [f]
	shraybekhts/N/Eer [n] [def: written material (usually pejorative)]
	aroysshrayb [def: output]
	umbashrayblekh/A [def: unwritable]
	shraybke/S [f] [def: writing pad] [note: V]
		byuro'-shraybke/S [f] [def: memo pad] [note: V]
		notits-shraybke/S [f] [def: note pad] [note: V]
	[idiom: es shteyt geshribn = it is accepted (in the tradition)]
shrayt/V/Bgeshritn [def: walk, stride] [usage: not recommended] /Giber
shrek/V/Bgeshrokn [def: fear] /Gop/Giber/Gon/Garoys/Gayn
	dershrek/V/Bdershrokn [def: frighten; terrify] 
	tseshrek/V/Btseshrokn [def: frighten] 
	shreklekh/K shrekik/K [def: terrible] 
	shr'ekedik/A [def: terrifying] % Forwards: Yoel Matveyev
	shre'kevdik/A [def: timid] 
	foygl-shreker/S [m] [def: scarecrow]
	ibershrek/N [m] [def: great fear]
/Dshret [n] [def: dwarf; elf (playful, helpful); gnome] shre'tldik/A
shrimp/N [m] [def: shrimp (animal)] % Michael Wex
shrit/X/N [m] [def: step]
	forshrit/N [m] [def: progress]
	oksnshrit/N [m] [def: (stubborn) ox-movement] % Forwards: M-S Hoffman
shroyf/V/T [def: turn a screw]
	/Gayn/Garayn [def: screw in]
	/Gtsu/Gtsunoyf [def: attach by screws]
	/Garoyf [def: increase by degrees] % Forwards
	/Gop /Goys [def: separate by unscrewing]
	tseshroyf/V/Btseshroyft [def: unscrew]
	shroyf/N /Dshrayf [m] [def: screw]
	ayzshroyf/N [m] [def: icicle]
	[idiom: im gefelt a shrayfele = he is mentally impaired]
	[idiom: a tsung oyf shroyfn = a wicked speech habit]
shroyt [m] [def: shot, buckshot] /Iik
shrump/V/Bgeshrumpn [def: fold, bend, shrink] /Gayn/Gtsunoyf
	ayngeshumpnkayt/N [f] [def: shrunken state] % Forwards: Boris Sandler
	tsunoy'fshrumpenish/N [n] [def: calamity] % Sholem Aleykhem
shrunt/N [m] [def: part in the hair; gap]
shrupshtak/Ees [m] [def: vise (implement)]
shtab/N [m] [def: staff, headquarters] 
shtabe/S [f] shtab/N [m] [def: rod, metal bar] 
shtadlen{SWdln}/Xshtadlonem{SWdlnym}/H [m] [def: intercessor]
	shtadlones{SWdlnwT}/H [n] [def: intercession] 
	hishtadles{hSWdlwT}/H [n] [def: intercession; diplomacy] 
	mishtadl{mSWdl} [verb] [def: intercede, negotiate (with "zayn")]
shtafet/N [m] [def: runner, herald]
shtakhet/N [m] [def: fence paling, picket; grate] /D
shtal/N [f/m] [def: stall (for animals)]
	/Dshtelkh [def: stall (for selling goods)] % Der Nister
	/Dshtelekh [def: stall (animals)] % Sholem Aleykhem
	shtalung/N [f] [def: stalls (animals)] % Sholem Aleykhem
	hi'nershtal/N [f] [def: chicken coop] 
	khazer_shtal{Hzyr-shtal} [f/m] [def: pigsty] 
shtalir/V/Bshtalirt /Goys [def: crystallize (with "zikh")]
shtaltik/A shtaltne [def: handsome, shapely; stately, presentable] 
	shtaltne/A 
	geshta'lt/N [def: appearance; shape, form] /Iik [def: of imposing appearance]
shtam/N [m] [def: stem; trunk (of a plant); race, tribe]
	boymshtam/N [m] [def: tree trunk
shtam/V/T [def: originate] /Gop
	opshtam/N [m] [def: origin] /Iik opshtamung/N [f] [def: origin] 
		opshtamling/N [m] [def: descendent]
	shtam/N [m] [def: origin] /Iik
	shtamling/N [m] opshtamling/N [m] [def: descendent] 
	boymshtam/Xbeymershtamen [m] [def: tree trunk] 
shtaml/V/T /Garoys [def: stammer; stutter]
	shtamldik/A [def: stuttering]
shtamp/N [m] stempe/S [f] stepke/S [f] shtempe/S [f] [def: pestle] [note: V] 
shtang/N/D [m/f] [def: pole, bar, beam] /Dshteng
	bangenshtang/N [m] [def: ??] % haynt hot er gearbet bay bangenshtangen
	balansir-shtang/N [m/f] [def: balance beam (gymnastics)]
	tsveyshtang/N [m/f] [def: parallel bars (gymnastics)] 
	khupe_shtang{Hwph-shtang}/N [def: wedding-canopy pole]
shtapl/N [m/f] [def: step] 
shtar/V/T [def: stare]
	/Garoys [def: stick out]
	farshta'rt/A [def: frozen]
		farshtartkayt/N [m] [def: frozen state]
shtar{Str}/H [m] [def: receipt, document] 
shtarb/V/Bgeshtorbn [def: die]
	/Gavek/Gop/Goys
	farshtarb/V/Bfarshtorbn [def: die] 
	oysshtarb [m] [def: extinction] 
	shtarbik/A [def: mortal] umshtarbik/A [def: immortal]
		shta'rbikayt/N [f] [def: mortality] % Forwards: Sholem Berger
		umshta'rbikayt/N [f] [def: immortality] % Forwards: Sholem Berger
	shtarblekh/A [def: mortal] umshtarblekh/A [def: immortal] 
	shterblekh/A [def: mortal] [usage: not recommended]
		shtarblekhkayt/N [f] [def: mortality] 
		umshterblekh/A [def: immortal]
			umshtarblekhkayt/N [f] [def: immortality] 
	[idiom: es iz tsum shtarbn = it's to die for] % Esther Kraytman: Briliantn
shtark/V/T [def: strengthen] 
	farshtark/V/Bfarshtarkt [def: strengthen]
		farshtarkung/N [f] [def: strengthening] 
	shtark/K [def: strong, powerful; very] shtarkayt/N [f] [def: strength] 
		harbshtark [m] [def: ammonia (chemical); smelling salts]
	shtark/V/T /Giber [def: overpower, vanquish]
shtarts/V/T [def: poke] /Garoys/Gafer
shtat/N [m] [def: state (political)] /Iish
	eybershtat/N [m] [def: high part of town] 
	varshta't/N [m] verkshta't [m] [def: workshop] 
shtat/N [m] [def: pomp] 
	shtatne/A [def: majestic]
	statetshne/A statne/S [def: stately, elegant; motionless] 
	[idiom: firn a groysn shtat = live in high style]
	[idiom: haltn shtat = keep up appearances]
shtat/V/T /Goys [def: equip, furnish, fit out, endow]
	/Gop [def: visit (with "a vizit")]
	oysshtatung/N [f] [def: equipment] 
shtayer/V/T [def: support] /Goys [def: equip] 
	shtayer/N [m] [def: tax]
	bayshtayer/V/Bbaygeshtayert [def: contribute, tax, donate] [grammar: not in present tense]
	bayshtayer/N [m] [def: contribution, taxation]
		bayshtayerer/S [m] [def: contributor, supporter] 
		bayshtayerung/N [f] [def: contribution, support] % Forwards
	oysshtayer/N [m] [def: equipment, outfit, trousseau] 
	tsushtayer/N [m] [def: thesis, paper; (content) contribution]
shtayg/N [f] [def: cage] /D [def: trap]
	kha'pshtaygl/Eekh [n] [def: trap]
	hi'nershtayg/N [m] [def: chicken coop]
shtayg/V/Bgeshtign [def: climb] /Gariber/Goyf/Garoyf/Giber/Gop/Gayn
	/Goys [def: excell (usually in religious study)]
	/Bgeshtoygn /Gariber/Goyf/Garoyf/Giber/Gop % variant participle
	oyfshtayg [m] [def: rise, increase]
	shtig/N [f] [def: stair] 
shteg/N [m] [def: path, lane, trail]
shtek/V/T [def: place] /Garoys/Garayn/Garoyf/Gavek/Gforoys/Gtsurik/Gdurkh/Garum
	/Gon [def: infect, catch a disease (with "zikh fun")]
	/Gop [def: reach out in greeting]
	/Gunter [def: bind; tuck in]
	farshtek/V/Bfarshtekt [def: place; consign, relegate; stop up a hole]
		farshtekl/Eekh [n] [def: stopper (device)]
	bashtek/V/Bbashtekt [def: place] 
		bashte'kerin/S [f] [def: menial worker, placing objects for work] % Forwards: M-S Hoffman
	shtekn/S [m] [def: stick] /Dshtek
		shmekele/Ekh [n] [def: penis (body part) (baby talk)]
		shmok [m] [def: penis (body part) (taboo)] /Dshmek
		dirige'ntn-shte'kele/Ekh [def: baton]
	binshtok/N [m] [def: beehive] 
	rinshtok/N [m] [def: gutter; sewer] /D
	vaynshtok/N [m] [def: grapevine]
	/Dtsoybershtek [def: magic wand] 
	onshtekik/A onshtekevdik/A [def: contagious]
shtekh/V/Bgeshtokhn [def: poke; cut, stab] /Gdurkh/Goys/Garop/Garayn
	/Gon [def: infect (with "mit")]
	dershtekh/V/Bdershtokhn [def: stab to death]
	farshtekh/V/Bfarshtokhn [def: poke; cut]
	shtekhik/A shtekhedik/A [def: sharp; barbed; prickly; pungent, caustic] 
		durkhshtekhik/A [def: piercing]
		durkhshte'khevdik/A [def: pervious] % Berish Goldstein: Der Hobit
	tseshtekh/V/Btseshtokhn [def: poke] 
	shte'kheve/V/T [def: poke] 
	shte'khenish/N [n] [def: sharp pain] % Sholem Aleykhem
	shtokh/N [m] [def: prick, sting; pang; stab; insinuation] /Iik
		mesershtokh/N [m] [def: knife cut] 
	shtokh/Xshtekh [m] [def: stitch] 
	shtekher/S [m] [def: hole puncher]
		o'ksn-shtekher/S [m] [def: toreador] % Stutchkoff
		tsey'nshtekher/S [m] [def: toothpick] % Stutchkoff
		meser-shtekheray'/N [n] [def: knife-sticking]
	shtekhl/V/T [n] [def: prick] /Idik
		shtekhlke/S [f] [def: prickle; barb; bramble] 
		shtekhler/S [m] [def: hedgehog (animal)] 
	shtekheli'r/V/Bshtekheli'rt [def: needle] 
	shtekhler-frizur/N [f] [def: crewcut] % Yiddish-League
	[idiom: oystsushtekhn emetsn di oygn = elicit jealousy by someone]
shtekh [m] [def: barter] 
	shte'kheve/V/Bshte'khevet [def: barter, dicker] 
shtel/V/T [def: place; become bankrupt (with "zikh")]
	/Garayn/Gakegn/Gantkegn/Garoys/Gtsurik/Gtsunoyf
	/Gop/Gtsuzamen/Gfest/Gforoys/Ganider/Garoyf/Garum/Garop
	/Gunter/Giber
	/Gayn [def: set in order; pickle (vegetables); defend (with "zikh far"); enter into danger (with "dos lebn")]
	/Gavek [def: set up]
	/Goyf [def: stand up]
	/Gkegn [def: oppose] 
	/Gfor [def: introduce; present; perform; imagine (with "zikh")] 
	/Gglaykh [def: arrange]
	/Goys [def: make out (a check); exhibit] 
	/Gon [def: pretend (with "zikh vi"); argue for (with "zikh")] 
	/Gtsu [def: prepare (food); provide; set up]
	bashtel/V/Bbashtelt [def: order (goods)]
		bashtelt/A [def: custom-made] 
		bashtelung/N [f] [def: order (for goods) (with "oyf": to order)] 
		[idiom: farhaltene bashtelung = back order] [note: V]
	farshtel/V/Bfarshtelt [def: hide, obstruct; disguise; imagine (with "zikh")]
		farshtelung/N [f] [def: disguise]
		farshteltkayt/N [f] [def: obstruction]
	tseshtel/V/Btseshtelt [def: group, arrange, line up] 
	geshtelterheyt [adv] [def: in bankruptcy]
	shtel/N [m] shtelung/N [f] [def: position; disposition; location in a text] 
		aynshtel/N [m] aynshtelung/N [f] [def: order; situation]
		forshtelung/N [f] [def: performance; introduction]
			forshteler/S [m] [def: performer]
		geverk-shtel/N [m] [def: workroom] % Sholem Asch: Motke Ganef
		ibershtelung/N [f] [def: combination, permutation (mathematical)] 
		modeshtel/N [m] mode-shtelung/N [f] [def: fashion statement] [note: V] 
		opshtel/N [m] [def: bus-stop; stop] opshtelung/N [f] [def: stop] 
			banopshtel/N [m] [def: train station]
			[idiom: on opshtel = non-stop]
		oyfshtel/N [m] oyfshtelung/N [f] [def: construction (mathematical)] 
		tseshtelung/N [f] [def: deployment] 
		tsuzamenshtelung/N [f] tsunoyfshtel/N [m] tsunoyfshtelung/N [f] [def: composition] 
		untershtel/N [m] untershtelung/N [f] [def: substitution (mathematical)] 
	kegnshtel [m] [def: opposition]
	mode-shtelung/N [f] mo'deshte'l/N [m] [def: fashion statement] [note: V] 
	oysshtel [m] oysshtelung/N [f] [def: performance; exhibition] 
	onshtel/N [m] [def: pretense] /Ierish [def: pretentious; hypocritical]
	shriftshteler/X/S [m] shriftshte'lerin/S [f] [def: author] 
	untershtelik/A hintershtelik/A hintershtelikayt/N [f] [def: retarded; late]
	shtele/S [f] [def: position]
		shtel-fartreter/S [m] [def: spokesman, agent; substitute]
	anshtalt/N [m] [def: institution] 
	geshte'l/N [n] [def: easel; scaffold; rack; stand]
	shteler/X [def: builder; performer]
		oysshte'lerke/S [def: voguish woman] % Stutchkoff
		shriftshteler/X [def: author]
		tsunoyfshteler/S [m] tsuzamenshteler/S [m] [def: collector]
			tsuzamenshtel [def: collection] 
		tsushteler/S [m] [def: provider]
	o'ngeshte'lt/A [def: employed]
	[idiom: aynshteln dos lebn = risk one's life]
	[idiom: shteln mit zikh for (+acc) = be composed of]
shtempl/V/T [def: stamp] /Gop/Goys
	shtempl/N [m] [def: stamp] 
	postshtempl/N [m] [def: postmark] 
shtep/V/T [def: stitch; quilt; construct shoe uppers from leather] 
	/Goys/Giber/Gon/Gop/Garum/Garayn/Gfundander/Gtsu
	farshtep/V/Bfarshtept [def: stitch; quilt]
	meysem_shtep{mTym-shtep} [m?] [def: shroud stitc shroud stitch]
	shteper/S [m] [def: tradesman who sews]
		kamashn-shteper [m] [def: tradesman who sews a shoe/boot upper to the sole]
shter/V/T [def: prevent] 
	tseshter/V/Btseshtert [def: destroy] tseshterung/N [f] [def: destruction]
		tseshterer/S [def: destroyer] /Iish [def: destructive] 
		umtseshterlekh/A [def: indestructable]
	farshter/V/Bfarshtert [def: prevent] 
		[idiom: der freyd-farshterer = party pooper] [note: V]
	shte'renish/N [n] shterung/N [f] [def: obstacle] 
	umgeshtert/A [def: unhindered]
shter/N [m] [def: sturgeon (fish)]
shterling [n?] [def: sterling (British currency)] % Avrom Karpinovitsh
shtern/X /Dshternd [m] [def: star] 
	geshternt/A [def: starry] oysgeshternt/A
	morgn-shtern [m] [def: Venus or Mercury; morning star]
	ovnt-shtern [m] [def: Venus or Mercury; evening star]
shtern/S [m] [def: forehead (body part)]
shternshis/N [m?] [def: eaglestone] % Michael Wex
shtertsl/Eekh [n] [def: lid, pot cover] 
shtey/Vshteyn/Bgeshtanen [def: stand] /Garum/Gant/Gon/Gfor/Gavek
	/Gayn [def: settle (in a place)]
	/Gbay [def: be present; help; withstand; pass a test]
	/Giber [def: turn sour] 
	/Gop [def: stop over; lag behind]
	/Goyf [def: stand up] 
	/Goys [def: surmount] 
	/Gtsu [def: oppose; importune (with "tsu")] /Goyf [def: rebel, awake]
	/Gtsurik [def: be backward, be old-fashioned] 
	shtey'endik/A [def: standing] % irregular gerund
		shteyendikerheyt [adv] [def: while standing]
		gutshtey'endik/A [def: in good standing] % Sholem Asch: Ist River
	farshtey/Vfarshteyn/Bfarshtanen farshtand [def: understand]
		farshteyendik/A [def: understanding] % irregular construction
		farshtendik/A [def: intelligible] farshtendlekh/A
			farshte'ndlekhkayt/N [f] [def: intelligibility, intelligence] 
			farshte'ndenish/N [n] farshtendikung/N [f] [def: understanding]
			misfarshte'ndenish/N [n] [def: misunderstanding] 
		ay'nfarshtanen/A [def: in agreement]
		umfarshtendlekh/A [def: unintelligible] 
		zelbstfarshtendlekh/A [def: self-evident] 
		[idiom: es farshteyt zikh (aleyn) = of course, obviously]
		[idiom: vifl ikh farshtey = as much as I like
	aynfarshtey/Vaynfarshteyn/Baynfarshtanen [def: agree] 
		aynfarshtey'enish/N [n] aynfarshte'ndenish [n] [def: agreement]
	bashtey/Vbashteyn/Bbashtanen [def: consist of; consent; speak for oneself (with "zayn shtetl"]
	antshtey/Vantshteyn/Bantshtanen [def: consist of; exist; congeal] 
		antshteyung/N [f] [def: rise, origin]
	opgeshtanenkayt/N [f] [def: retardation; undeveloped status]
	shtand/N [m] [def: standing, estate, station; situation] 
		bashtand/N [m] [def: situation] 
			umbashtand/N [m] [def: weak situation]
			voyl-bashtand/N [m] [def: well-being] 
		gegnshtand/N [m] [def: thing (German)]
		imshtand [adj predicative] [def: capable, able] [usage: not recommended]
		kegnshtand/N [m] [def: rebellion, rebellious act]
		kegnshtand/N [m] [def: subject, thing] [usage: not recommended]
		opshtand [def: separation] 
		oyfshtand/N [m] [def: uprising; rebellion] 
			oyfshtandler/S [m] oyfshtendler/S [m] [def: rebel] /Iish
		tsushtand/N [m] [def: state, condition]
		umshtand/N [m] umshtend/N [m] [def: circumstance]
		vidershtand/N [m] [def: opposition, resistance]
			vidershtendler/S [m] [def: resistance fighter] % Forwards: Mishe Lev
		vofn-shtilshtand/N [m] [def: armistice; cease-fire] 
		voylshtand/N [m] [def: public health; welfare; prosperity] 
	shtendik/A [def: continual]
		zelbshtendik/A [def: independent]
		zelbstshtendik/A [def: independent] [usage: inadmissible]
		bashtendik/A [def: continual] 
			bashtendikayt/N [f] [def: persistence]
		onshtendik/A [def: respectible] umonshtendik/A [def: disrespectable] 
		fulshtendik/A [def: complete]
		zelbshtendik/A [def: independent] 
			zelbshtendikayt/N [f] [def: independence] 
	fo'rshteyer/S [m] forshtey'erin/S [f] [def: president; representative]
		forshteyershaft/N [f] [def: representation]
	shtender/S [m] stender/S [m] [def: podium, lectern] 
	zelbshtendik/A [def: independent]
		zelbstshtendik/A [def: independent] [usage: indadmissable]
	[idiom: vi in posek{pswk} shteyt = fulfilling all requirements]
shteyger/S [m] [def: custom; after all (with "a")] /Iish
	[idiom: lebns-shteyger = lifestyle]
	[idiom: firn di shteyger fun vayber = have a menstrual period]
shteyn/Eer/Dshteynd [m] [def: stone]
	farshteynert/A [def: fixed, unchanging]
	farshteyner/V/Bfarshteynert [def: stone (punish); solidify] % Forwards: M-S Hoffman (stone)
		farshteynerung/N [f] [def: stoning; solidification] % Forwards: M-S Hoffman (stoning)
	farshteynt/A [def: stony] 
	shteynern/A shteynerdik/A [def: stony] 
	brukshteyn/Eer [def: cobblestone]
	burshtin burshteyn/Eer brushtin [m] [def: amber] /Dburshtind
	eydlshteyn/Eer [m] [def: jewel] 
	fayershteyn/Eer [m] [def: flint]
	galshteyn/Eer [m] [def: gallstone]
	grinshteyn/Eer [m] [def: jade] % Harduf 
	gruntshteyn/Eer [m] [def: cornerstone] % Harduf 
	kizlshteyn/Eer [m] [def: flint]
	mirmlshteyn/Eer [m] [def: marble (material)]
	maylshteyn/Eer [m] [def: milestone] 
	milshteyn/Eer [m] [def: millstone]
	oniklshteyn/Eer [m] [def: onyx]
	ovalshteyn/Eer [m] [def: oval stone] /Dovalshteynd % Forwards: Boris Sandler
	penkhershteyn/Eer [m] [def: bladder stone (illness)] % Forwards: Sholem Berger
	sharfshteyn/Eer [m] [def: sharpening stone] /Dsharfshteynd
	shlayfshteyn/Eer [m] [def: grindstone]
	tungshteyn [m] [def: tungsten (W)] 
	vinklshteyn/Eer [m] [def: cornerstone] 
	vundershteyn/Eer [m] [def: magic stone] % Sholem Aleykhem
	zamdshteyn/Eer [m] [def: sandstone]
shtidl/N/Eekh [n] [def: lintel; doorpost]
	bay'shtidl/Eekh [n] [def: doorpost, doorjamb]
shtif/V/T [def: joke] /Garum
	shtifer/S [m] [def: joker; brat] /Iish [def: joking; bratty]
		shtiferay'/N [n] [def: mischief; childish pranks]
shtif/V/T [def: stiffen] 
	farshtif/V/Bfarshtift [def: stiffen] 
	shtayf/A [def: stiff, rigid]
		farshtayf/V/Bfarshtayft [def: stiffen] 
		shtayfkayt/N [f] [def: rigidity, stiffness]
shtif- [prefix] [def: step- (genealogical)] shtifs- [prefix]
shtift/N [m?] [def: pin (usually metallic)] /D
	blayshtift/N [m] [def: pencil]
shtiguter/Ees [m] [def: antagonist, adversary]
shtik/Eer [n/f] /D [def: piece (of substance); small amount of; piece (in a performance); gimmick]
	shtiklekhvayz [adv] [def: piece by piece] 
	kopshtik/X [m] [def: schemer; smart aleck; creative idea; dirty trick]
	shmad{Smd}-shtik/X [m] [def: dirty trick]
	teatershtik/Eer [n/f] [def: play] 
	-/Xshtik [def: pranks, tricks]
		-/Xshmad_shtik{Smd-shtik} [def: wild tricks, pranks; stratagems; maneuvers]
		/Dkuntsshtik [def: clever trick]
	/Dshtik [def: foreskin discarded after circumcision] % Michael Wex
	[idiom: kostn a shtik gezunt = damage health]
	[idiom: oysraysn a shtik harts = damage emotional calm]
shtik/V/T [def: suffocate] 
	dershtik/V/Bdershtikt [def: suffocate; choke; strangle]
		dershti'kenish/N [n] [def: suffocation] 
		dershtikung/N [f] [def: suppression]
	farshtik/V/Bfarshtikt [def: suffocate] 
shtik/V/T [def: embroider; sew] /Goys
	shtikeven/V/T [def: sew] /Gtsu/Gtsuzamen/Goys
shtike{Styk|h} [f] [def: silence]
	shoysek{Swsk}/Xshoskem{Swskym} [def: person who chooses not to speak]
shtil/V/T [def: quiet, silent; still] /Gayn
	farshtil/V/Bfarshtilt [def: quieten] 
	shtil/K [def: quiet] shtilink/A [def: small and quiet]
	shtilerheyt [adv] shtilinkerheyt [adv] [def: silently]
	shtilkayt/N [f] shti'lenish/N [n] [def: silence] 
	shtil/V/T
		antshtil/V/Bantshtilt [def: quiet down] 
shtile't/N [m] [def: dagger, stiletto] % palatal l
shtim/V/T [def: agree; vote; make sense] /Gop/Gtsu
	/Gayn [def: agree (with "mit")]
	/Gon [def: tune (musical instrument)]
	aynshtimik/A [def: in agreement]
	eynshtimik/A [def: in accord, unanimous]
	bashtim/V/Bbashtimt [def: settle, appoint, designate]
		bashtimt/A [def: definite] 
			umbashtimt/A [def: indefinite, uncertain]
				umbashtimtkayt/N [f] [def: uncertainty]
		bashtimung/N [f] [def: agreement] 
			zelbstbashtimung/N [f] [def: self-determination] 
	shtimung/N [f] [def: mood, spirits] opshtimung/N [f] [def: voting]
		geshtimt/A [def: disposed] 
	shtim/N [f] [def: ballot]
		tsushtim/N [m] [def: approval; consent]
			tsushtimung/N [f] [def: agreement]
		froyenshtim/N [f] [def: women's vote] 
shtim/N [f] /Iik shtime/N [f] [def: voice] /Dshtim
	boykhshtim/N [f] [def: deep voice] % Kulbak: Zelmenyaner
	froyenshtime/S [f] [def: woman's voice]
	shtimloz/A [def: voiceless (linguistics)] % D-H Katz
	filshtimikayt/N [f] [def: cacophany] % Forwards
shtink/V/Bgeshtunken [def: stink; fail to pay (jewelers' argot)] 
	/Gon [def: stink up]
	farshtink/V/Bfarshtunken [def: stink] 
	geshta'nk/N [n] [def: stink] 
	shti'nkerke/S [f] [def: woman who doesn't care about cleanliness]
	shtunk/N [m] [def: stink]
shtinke/S [f] stinke/S [f] stint/N [m] [def: smelt (fish)] % Stutchkoff
shtirkhe/V/T [def: poke, budge] % Mendele
shtirts/V/T [def: break, destroy (German)] [usage: not recommended]
	/Gayn % Sholem Asch: Ist River
shtits/V/T [def: support] /Gunter [def: sponsor; support]
	shtits/N [m] shtitse/S [f] [def: support (often with "gebn")] 
	shtitser/S [m] untershtitser/S [m] [def: supporter; sponsor] 
	untershtitsung/N [f] [def: support] % Forwards
	kra'gnshtitsl/Eekh [n] [def: collar stay] % Maurice Wolfthal
shtivl/X [m] /Dshtiv shtivale/S [f] [def: boot] [usage: usually plural]
	shtivle't/N [m] [def: half-boot]
	shtivloyne/S [f] [def: boot ??] 
	toykher-shtivl/X [def: wading boot] % Bashevis
	links-shtivl/X [def: parcel in which nothing matches (jewelers' argot)]
shtof/N [m] [def: material] 
	khemikalye-shtof/N [m] [def: chemical]
	brenshtof [m] [def: fuel] % Forwards
	koylnshtof [m] [def: carbon (Ca)] 
	oy'fraysshtof [m] [def: explosives] 
	runtslshtof [m] [def: seersucker] /In
	shtikshtof [m] [def: nitrogen (N)] 
	vasershtof [m] [def: hydrogen (H)] 
	vayslshtof [m] [def: egg-white, albumin; protein]
	zoyershtof [m] [def: oxygen (O)] 
	zumershtof/N [m] [def: summer-weight material] 
shtok/N [m] [def: floor, storey (part of building)] /Iik
	eynshtokik/A [def: one-storey]
shtok [adv] [def: completely] 
	[idiom: shtok nakht = full dark]
shtol/N [n] [def: steel] /Ien
	ongeshtoln/A [def: determined, resolute] % Sholem Aleykhem
	shtol/V/T shtoleve/V/T [def: reinforce] /Gayn
shtolts/A [def: proud]
	shtoltskayt/N [f] [def: pride]
	shtoltsi'r/V/Bshtoltsi'rt [def: be proud] 
shtolts/N [m?] shtoltse/S [f] [def: stilt]
shtomper/V/T [def: stumble, stagger forward] /Gavek
shtop/V/T [def: stuff; constipate; fornicate (vulgar)] /Gon/Garayn/Goys
	/Gop/Goyf [def: unclog, clear] 
		noz-o'pshtoper/S [def: decongestant] [note: V]
	farshtop/V/Bfarshtopt [def: stuff] 
shtopsl/Xekh [def: cigarette butt] 
shtor/N [m/f] [def: eye cataract; window shade]
shtorts/V/T [def: protrude]
	shtortsik/A [def: protruding]
shtot [f] [def: seat or place in synagogue] % cf English "stead"
	anshtot [def: instead of]
shtot/Xshtet [f] /Dshtet [def: town]
	shtetldik/A shtotish/A shtetlsh/A [def: town] 
		kleynshtetldik/A kleynshtetlish/A kleynshtetlsh/A [def: small-town]
		groysshtotish/A [def: big-city] 
		oysershtotish/A [def: out-of-town] 
	gebu'rtshtot/Xgebu'rtshtet [f] [def: home town]
	groysshtot/Xgroysshtet [f] [def: major city] % Forwards: Sh Fishman
	havnshtot/Xhavnshtet [f] [def: port city] 
	heymshtot/Xheymshtet [f] [def: home town] /Dheymshtetl
	hoyptshtot/Xhoyptshtet [f] [def: capital]
	kroynshtot/Xkroynshtet [f] [def: capital] 
	veltshtot/Xveltshtet [f] [def: world-class city]
	geburt|sshtot/Xgeburt|sshtet [f] [def: birthplace]
	portshtot/Xportshtet [f] [def: port city] 
	hintershtot/Xhintershtet [f] [def: suburb] /Iish /Dhintershtet
	forshtot/Xforshtet [f] [def: suburb] /Iish /Dforshtet
	oysershtotik/A [def: out-of-town] % Bergelson: Yosef Shur 
	onshtot [def: instead of] 
	bashtetik/V/Bbashtetikt [def: certify, confirm, corroborate, acknowledge, approve]
		bashtetikung/N [f] [def: confirmation, certification, acknowledgement, approval] 
shtotsik/A [def: steep, precipitous; abrupt] 
shtoyb [m/n] [def: dust, pollen] /Iik [def: dusty] 
	shtoyb/V/T /Gop [def: remove dust]
	farshtoyb/V/Bfarshtoybt farshtoybik/V/Bfarshtoybikt [def: make dusty] 
		farshtoybtlekh/A [def: somewhat dusty] % Der Nister
		farshtoybtkayt/N [f] [def: dusty objects] % Der Nister
	vegsshtoyb [m/n] [def: traveller's dust] 
	blumenshtoyb [m/n] [def: pollen] 
	bashtoyb/V/Bbashtoybt [def: pollinate] bashtoybung/N [f] [def: pollination] 
	tseshtoyb/V/Btseshtoybt [def: pulverize; cover with dust]
shtoyn/V/T [def: astound]
	shtoynung/N [f] [def: astonishment] 
	dershtoyn/V/Bdershtoynt [def: astonish, amaze] 
		dershtoynung/N [f] [def: astonishment, amazement]
shtoys/V/Bgeshtoysn [def: shove; crush; pound]
	/Gavek/Goys/Garum/Garoys/Garop/Gariber
	/Gon [def: figure out (with "zikh")]
	/Gop [def: disgust (often with "b|emes"); repel] 
	/Gtsuzamen/Gtsunoyf [def: collide] 
	/Gunter [def: force]
	farshtoys/V/Bfarshtoysn [def: shove; push aside; marginalize] 
		farshtoysung/N [f] [def: repression (psychology)]
	tsuzamenshtoys/N [m] [def: collision] 
	tseshtoy's/V/Btseshtoysn [def: grind with a pestle] [note: V]
	/Dshtoys /Dshteys [def: mortar; pestle]
		[idiom: does ey'bershte fun shtoysl = pestle; best]
	opshtoys [m] [def: repulsion]
		opshtoyser/S [m] [def: bumper (automotive); bumper (bowling)] [note: V]
shtral/V/T [def: shine] /Goyf/Garoys/Goys/Garayn
	shtral/N [m] [def: sunbeam] shtralekhl/Eekh [def: small beam]
		likhtshtral/N [m] [def: beam of light]
		rentgen-shtral/N [m] [def: X-ray beam] % Forwards: Yoel Matveyev 
		zunshtral/N [m] zunenshtral/N [m] [def: sunbeam]
	bashtral/V/Bbashtralt [def: shine on] 
	tseshtral/V/Btseshtralt [def: shine on] 
shtram/A [def: straight; rigid; upright]
shtrayf/N [m] [def: stripe, strip] [usage: deprecated]
	shtrayfldik/A [def: striped] % Der Nister
	geshtrayft/A [def: striped] % Forwards: S-R Schaechter
shtrayml/N [n] [def: Chassidic fur hat (clothing)]
shtrayt/N [m] shtrayteray'/N [n] [def: quarrel; war; disagreement]
shtreb/V/T [def: reach for]
	shtrebung/N [f] [def: striving, aspiration, pursuit]
shtrek/V/T [def: stretch] /Garoys/Goys
	dershtrek/V/Bdershtrekt [def: stretch] 
	tseshtrek/V/Btseshtrekt [def: stretch] 
shtreng/V/T [def: be severe]
	/Gon [def: strain; exert]
	shtreng/K [def: severe] 
		shtrengkayt/N [f] [def: severity]
	onshtreng/N [m] onshtrengung/N [f] ongeshtrengtkayt/N [f] [def: effort, strain] 
		o'nshtrengik/A [def: difficult, arduous]
shtrik/V/T [def: sew]
	/Goys [def: knit]
	shtrik/X [m/f] [def: rope] /D 
		gretshtrik/X [m/f] [def: clothesline]
		zeglshtrik/X [m/f] [def: rigging, tackle (nautical)]
	shtriker/S [m] shtri'kerke/S [f] [def: needleworker] 
shtrikh/V/T [def: make a stroke]
	/Gunter [def: underline] 
	/Bgeshtrokhn [def: make a stroke] % variant participle
		/Gunter /Giber [def: underline] 
	shtrokh/N [m] [def: stroke, line]
		ta'ktshtrokh/N [n] [def: barline (written music)] % Stutchkoff
	shtrikh/N [m] [def: stroke; trait, feature] /D
		ta'ktshtrikh/N [n] [def: barline (written music)] % Stutchkoff
	[idiom: shtrikh arop/aroyf = down/up stroke (violin playing)] [note: V] 
	baystrikh/N [m] [def: comma]
	bindshtrikh/N [m] [def: hyphen] 
	shtraykh/V/Bgeshtrokhn [def: mark]
		/Gunter [def: emphasize] 
		shtraykh/N/D [def: mark] 
			arayngeshtraykht/A [def: drawn in] % Sholem Aleykhem
shtrimp [noun] [def: hose (clothing)] 
shtrof/V/T [def: punish]
	bashtrof/V/Bbashtroft [def: punish]
		bashtrofung/N [f] [def: punishment]
	geshtroftkayt/N [f] [def: punished state] % Rokhl Korn: shotns
	shtrof/N [f] [def: punishment] toytshtrof [f] [def: capital punishment] 
	shtrafi'r/V/Bshtrafi'rt [def: punish]
shtrom/V/T /Garayn/Garum/Garop/Garoys
	shtrom/N [m] [def: stream] 
		aray'nshtrom/N [m] [def: infusion; input] % Forwards
	baystrom/N [m] [def: side stream] 
	hoyptshtrom/N [m] [def: main stream] /Iik
	klangshtrom/N [m] [def: ??] 
	untershtrom/N [m] [def: undertow] % Forwards: Noyekh Barera
	shtremung/N [f] [def: intellectual movement] 
shtroy/N [f] [def: straw] /D /Ien
	dakhshstroy/N [f] [def: thatch] % Weinreich
shtroykhl/V/T [def: go astray (with "vern"), falter; tempt; hamper]
	shtroykhlung/N [f] [def: temptation; obstacle] 
	shtroykhl/N [m] [def: bump] /Idik [def: bumpy] 
shtroys/N [m] [def: ostrich]
shtroysl [def: bouquet]
shtroz/N [m] [def: highway]
shtrudl/N [m] [def: strudel (food)] 
	tseshtrudlt/A [def: confused, disturbed] % Michael Wex
shtshav [m] [def: sorrel (plant, Rumex acetosa)] 
	shtshavye [f] [def: sorrel] % Kulbak: Zelmenyaner
shtsherbe/V/T /Gon [def: notch, jag]
	tseshtsherbe/V/Btseshtsherbet [def: notch]
	shtsherb/Ees/N [m] [def: nick, notch]
	shtsherbate/A [def: notched, jagged] 
shtshipe/V/T [def: nibble at] 
	/Dshtship [def: a nibble]
	shtshipl/V/T [def: tickle; excite] 
shtshipyor/N [def: chives (herb)] 
shtshire/V/T [def: grind (teeth), reveal the teeth] /Goys
	farshtshire/V/Bfarshtshiret [def: clench (teeth)]
shtshobe/V/T [def: sew loosely]
shtshogl [m] shtshogel [def: dandy, fop]
shtshoke/S [f] [def: cheek (part of face) (Russian щеке)] % M-S Hoffman
shtshuple/A [def: delicate, thin]
shtshur/Ees [m] [def: rat (animal)] 
shtub/Xshtiber/N [f] [def: house, home; room]
	/Iik [def: pertaining to the house; domestic (animal)]
	/Dshtib [def: room; prayer-room]
	oybershtibl/Eekh [n] [def: upstairs room] % Der Nister
	boydemshtub/Xboydemshtiber [f] [def: attic room] /Dboydemshtib
	dozorshtibl/Eekh [n] [def: warden's house] 
	esshtub/Xesshtiber [f] [def: dining room]
	shlofshtub/Xshlofshtiber [f] [def: bedroom] /Dshlofshtib
	verkshtub/Xverkshtiber [f] [def: workroom] 
	shtubik/V/T /Gayn [def: housetrain (an animal)]
shtuding [m?] [def: jellied meat] % Stutchkoff
shtudi'r/V/Bshtudi'rt [def: study] /Goys/Gayn
	shtudye/S [f] [def: study] 
	student/N [m] [def: student] /Iish /D
		studentke/S [f] studentin/S [f] [def: student] 
shtufe/S [f] [def: level, rung, grade] [usage: not recommended]
	shtu'fnvayz [adv] [def: by degrees]
shtukatu'r/N [f] [def: stucco (material)]
shtuke/S [def: trick]
	[idiom: shpiln a shtuke = play a trick]
	[idiom: makhn shtukes = play tricks]
	[idiom: a shtuke a yung = a hulk of a youngster]
	shtu'keve/V/T /Gtsunoyf/Goyf [def: piece together] 
shtul/N [f/m] [def: chair (furniture)]
	brokhshtul/N [f/m] broykhshtul/N [f/m] [def: birthing chair]
	fo'tershtul/N [f/m] [def: easy chair (furniture)]
	le'nshtul/N [f/m] [def: easy chair (furniture)]
	re'dlshtul/N [f/m] re'dershtul/N [f/m] [def: wheelchair]
	vebshtul/N [f/m] [def: loom] 
	vigshtul/N [f/m] [def: rocking chair]
	volter-shtul/N [f/m] [def: armchair]
shtum/V/T [def: be silent]
	shtum/A [def: silent; voiceless] /Eerheyt [adv] [def: voicelessly]
		shtumkayt/N [f] [def: voicelessness] 
		shtu'menish/N [n] [def: silence] 
	antshtum/V/Bantshtumt [def: silence]
	farshtum/V/Bfarshtumt [def: silence, mute] 
shtumpik/A [def: stupid; dull] 
shtund/N [f] [def: hour (German)] 
	shtunde/S [f] [def: private lesson] [usage: not recommended]
shtup/V/T [def: shove]
	/Garayn/Garoyf/Gavek/Garoys/Gdurkh/Gtsu/Gop/Gadurkh/Gunter/Garop
	/Gon [def: stuff]
	farshtup/V/Bfarshtupt [def: shove] 
	shtu'penish/N [n] [def: congestion]
	aroyfshtup/N [m] [def: press-up (athletic exercise)] 
	[idiom: shtup-sho{shtup-Seh} = rush hour]
	[idiom: shtupn zikh = be pushy] [note: V] 
shtupl/V/T [def: pit, pockmark; mark with a wheel; perforate]
shturem/V/T [def: storm]
	shturem/S [m] [def: storm] /Idik shturmish/A
		feldshturem/S [m] [def: storm] % Bergelson
		shneyshturem/N [m] [def: snowstorm] 
shturkats/N [m] [def: torch] 
shturkhe/V/T [def: jostle, poke]
	shturkh/N [m] [def: poke, bump, jab]
shtus{StwT}/Xshtusem{StwTym}/H [m/n] [def: foolishness; never mind!]
	shtuseray'{StwTeray}/N [n/f] [def: foolishness] 
	shoyte{Swth}/Xshoytem{Swtym} [m] shatye{Sty#}/H [f] [def: foolish woman] 
shtutser/S [m] [def: dandy, fop] % Stutchkoff
	shtu'tserke/S [f] [def: voguish woman]
shtutshke/S [def: trickery (Polish oszustwo)] 
shube/S [f] [def: fur coat (clothing)]
shufl/N [m] [def: shovel; scoop (tool)] 
	shufl/V/T [def: shovel (tool)] 
shuflod/N [m] [def: drawer (furniture)] /Dshufled
shukh/Xshikh [m] [def: shoe (clothing)] /Dshikh
	klapshukh/Xklapshikh [m] [def: tap-dance shoe (clothing)] [note: V]
	shtekshukh/Xshtekshikh [m] [def: slipper] [grammar: usually plural]
	sportshukh/Xsportshikh [m] [def: sport shoe, sneaker] % Forwards: Boris Sandler
	shuster/S [m] /D shu'sterke/S [f] [def: cobbler] 
		shusteray'/N [n] [def: shoe-making (occupation)] 
	puent-shukh/Xpuent-shikh [m] [def: pointe shoes (ballet)] [note: V]
	shuvaks [m] [def: shoe polish]
	bashukh/V/Gbashukht [def: shod]
shul/N [f] shule/S [f] shil/N [f] /Dshulkh /Dshilkh [def: school; synagogue]
	mitlshul/N [f] [def: high school]
		untermitlshul/N [f] [def: middle school]
	fakhshul/N [f] [def: vocational school] 
	folkshul/N [f] folksshul/N [f] [def: elementary school]
	forshul/N [f] [def: pre-school] % Forwards: S-R Schaechter
	kunstshul/N [f] [def: art school]
	lernshul/N [f] [def: school]
	onfangshul/N [f] onheybshul/N [f] [def: elementary school]
	ovntshul/N [f] [def: night school] 
	pilo'tnshul/N [f] [def: flight school] [note: V]
	togshul/N [f] [def: day school (religious)] 
	vaybershul/N/Dvaybershulkh [f] [def: women's section of synagogue]
	zuntikshul/N [f] [def: Sunday school]
	shiler/S [m] shi'lerin/S [f] [def: student] 
	shilekhl/Eekh [n] [def: chapel (in a synagogue)] [note: V] 
	oysgeshult/A [def: schooled, trained] 
		oysshulung/N [f] [def: schooling, training] % Forwards
shuld/N [f] [def: guilt] /Iik [def: guilty; indebted, in arrears]
	shuldikayt/N [f] [def: guiltiness] 
	antshuldik/V/Bantshuldikt [def: excuse] antshuldikung/N [f] [def: excuse]
	bashuldik/V/Bbashuldikt [def: indict, accuse, blame (with "in")]
		bashuldikung/N [f] [def: accusation, indictment]
	farshuldik/V/Bfarshuldikt [def: convict]
	umshuldik/A [def: innocent]
	mitshuldiker/X [def: co-defendant] 
	[idiom: got di neshome shuldik = completely innocent]
shulkhn_o'rekh{SwlHn-erwx} [def: Code of Jewish Law, Shulchan Oruch]
	[idiom: a din fun finftn shulkhn_orekh{SwlHn-erwx} = nonsense]
shulter/S [m?] [def: shoulder]
shum{Swm}/H /Lbe{b} [adv] [def: in no way]
	[idiom: keyn shum zakh = not a single thing]
shund/N [m] [def: cheap (in quality)] 
shup/N [n] [def: scale (fish); flake; dandruff] 
shur-bu'r shurum-burum [m] [def: patchwork, oddments]
shure{Swrh}/Xshures{SwrwT}/H [f] [def: line] 
	shuredik{Swrhdik}/A [def: lined] 
	shuresvayz{SwrwTvayz}/A [def: line by line; row by row]
	keshure{KSwrh} [adv] [def: smoothly; according to plan]
	shure{Swrh}-grizl/Eekh [n] [def: schoolbook example]
	[idiom: tsvelf shures{SwrwT} = bill of divorce]
	[idiom: di untershte shure{Swrh} = grand total (colloquial)]
shurek{Swrwk}/H [def: Hebrew vowel point shuruk /u/] 
shushke/V/T [def: quiet] 
shutef{SwWf}/Xshutfem{SwWfym}/H [m] shutefte{SwWfte}/S [f] [def: partner]
	shutfish{SwWfish}/A [def: in partnership]
	mitshutef{mitSwWf}/Xmitshutfem{mitSwWfym}/H [m] [def: partner] % Forwards
	shutfes{SwWfwT}/H [n] [def: partnership] /Idik
	bshutfes{bSwWfwT} [def: joint, in partnership] /Idik
	b|shutfesdikayt{SwWfwTdikayt}/N [f] [def: partnership] 
shvakh/K [def: weak] /Ilekh
	shvakhkayt/N [f] [def: weakness] 
	shvakh/V/T [def: weaken] /Gop
	opshvakhung/N [f] [def: weakening] % might not exist in non-combined form
	arbn-shvakh/N [m] [def: nervous breakdown] % Michael Wex
shvalb/N [f] /Dshvelb [def: swallow (bird)] 
shvan/N [m] [def: swan (bird)] 
shvanger/V/T [def: be pregnant] % Forwards: M-S Hoffman
	farshvanger/V/Bfarshvangert [def: become pregnant] % Chava Rozenfarb: Botshani
	shvanger [adj predicative] [def: pregnant]
	shva'ngershaft/N [f] [def: pregnancy]
shvants/Xshvents [m] [def: tail; penis (body part) (vulgar)]
shvarts/A [def: black] /Iink [def: somewhat black] /Ilekh [def: blackish]
	shvarts/A [def: Negro] [usage: no longer acceptible]
	shvarts/A [def: brunette]
	shvarts [n] [def: spades (playing cards)] % no plural?
	shvartskayt/N [f] [def: blackness] 
	shvarts/V/T [def: blacken (with "zikh")] 
	farshvarts/V/Bfarshvartst [def: blacken; oppress; cause to suffer] 
shvayg/V/Bgeshvign [def: be silent] /Gop/Gunter
	antshvayg/V/Bantshvign [def: become silent] 
	farshvayg/V/Bfarshvign [def: silence; be silent about] 
		farshvaygung/N [f] farshvay'genish/N [n] [def: silence] 
	shvay'genish/N [n] [def: silence]
		shtilshvaygn/S [m] shtilshvay'genish/N [n] [def: complete silence] 
	shvayger/S [m] /Iish shvay'gerin/S [f] [def: silent person] 
	shtilshvaygn [m] [def: armistice; silence] /Idik [def: silent] 
	shvaygns/X [n] [def: silence]
shvayn/N [m?] [def: pork, pig]
shveb/V/T [def: sweep; soar; float (in the air)]
	/Gdurkh/Gtsu/Gavek/Garoyf/Gtsurik/Garop/Garum
	/Gon [def: arrive by air]
shvebish [m?] [def: chintz (material)]
shvebl/Xshveblekh [m] shvebele/Xshvebelekh [def: sulfur (S); match]
shvel/N [f/m] [def: doorstep, threshold] 
	shtromshvel/N [f] [def: rapids (of a river)]
shvenk/V/T [def: rinse] /Goys/Gop/Gdurkh
	bashvenk/V/Bbashvenkt [def: rinse] 
	farshvenk/V/Bfarshvenkt/Bfarshvonken [def: flood] 
	horshvenkekhts/N [n] nokhtsvog-shvenkekhts/N [n] nokhtsvog-shvenkekhts/N [n]  [def: hair conditioner] 
	tseshvenk/V/Btseshvenkt [def: blur (boundaries)] % Forwards: Alkin
shver/K [def: difficult; heavy] shverlekh [adv]
	shverikayt/N [f] shverkayt/N [f] [def: difficulty] 
	shverink/A [def: difficult; heavy (diminutive)]
shver/V/Bgeshvorn [def: swear] /Gayn/Gop/Gtsu
	/Ggeshvoyrn /Gayn/Gop % variant
	bashver/V/Bbashvorn [def: cause to swear, exorcise] 
		bashverung/N [f] [def: exorcism] 
		bashverer/S [m] [def: exorcist] 
	farshver/V/Bfarshvorn [def: conspire] farshverung/N [f] [def: conspiracy] 
	shve'renish/N [n] [def: swearing] 
	geshvoyrener [n] [def: jurist]
		-/Xgeshvoyrene -/Xay'ngeshvoyrene [def: jury] 
	aynshverung/N [f] [def: investiture, inauguration, swearing-in]
shverd/N [f] [def: sword (weapon)] /D
	bashverd/V/Bbashverdt [def: equip with a sword] % Forwards: M-S Hoffman
shvester/X [f] [def: sister; mare (balegole-loshn)]  /D 
	geshvester [def: siblings (German)]
	krankn-shvester/X [f] [def: nurse]
		krankn-shvesteray'/N [m] [def: nursing (occupation)]
	shtifshvester/X [f] [def: step-sister] /D
	bruderl-shvesterl [def: pansy (flower, Viola wittrockiana)] % Stutchkoff
	shifshvester/X [m] [def: fellow passenger]
shveytsa'r/N [m] [def: gatekeeper, doorman]
shvibl/V/T [def: swarm, be full of (with "mit")] % Stutchkoff
shviger/S [f] [def: mother-in-law]
	shvi'gerin/S [f] [def: sister-in-law] 
	shvoger/S [m] shvogerik/Ees [m] [def: brother-in-law] 
	shver/N [m] [def: father-in-law] [usage: of bride right after engagement; of groom after marriage]
	-/Xshver-un-shviger [def: in laws (parents only) (only in plural)]
shvim/V/Bgeshvumen [def: swim; float; wallow] /Gavek/Garoyf/Garoys/Gnokh/Garayn
	/Gariber/Gdurkh/Gtsu/Garum
	/Goyf [def: swim to the surface]
	/Gop [def: swim or sail away; depart]
	tseshvim/V/Btseshvumen [def: swim about] 
	shvimer/S/X [def: swimmer; impressive stone (jewelers' argot)] /D
	shvum/N [m] [def: swimming stroke; swim] 
	farshvumen/A [def: disappeared]
shvindl/V/T [def: be dizzy; cheat] /Gadurkh/Gop
	shvi'ndlenish/N [n] [def: dizziness, vertigo]
	shvi'ndldik/A [def: staggering, vertiginous, dizzying]
	shvindler/S [m] [def: swinder, cheat] /Iish 
	shvindlyak [m] shvindlyuk [m] [def: swindler, cheat] 
	shvindlak [m] [def: swindler, cheat] 
	bashvindl/V/Bbashvindlt [def: defraud] 
	farshvindl/V/Bfarshvindlt [def: get dizzy]
	shvindleray'/N [n] [def: fraud]
shvintukh/Ees [m] [def: slob] % Weinreich, Stutchkoff
shvits/V/T [def: sweat, perspire] /Iik /Gdurkh/Gtsu
	/Goys [def: ooze; get by effort]
	farshvitst/A dershvitst/A [def: sweaty] 
	shvitser/S [m] [def: braggart] 
	shvits/N [f] [def: steambath]
	shveys [m] [def: sweat] 
		farshveyst/A [def: sweaty] % Der Nister
shvo/N [m] [def: Hebrew vowel point shwa /ə/ or null]
shvom/N [m/f] /Dshvem [def: sponge; mushroom] 
	shvemleray' [f] [def: mushroom hunting] % Forwards: Yoel Matveyev
shvue{SBweh}/Xshvues_{SBwewT}/H [f] [def: oath]
	mashbiye{mSbeh} [verb] [def: exorcise (with "zayn")] 
	hashboe{hSBeh} [def: exorcism]
shvues{SBwewT}/H [m] [def: holiday of Shavuos] /Ilekh /Idik
shvung/N [m] [def: zest; sway, swing; oscillation] [usage: doubtful admissibility]
	shving/V/T/Bgeshvungen [def: shake, swing; brandish] /Gtsurik/Garayn/Garum
shvyentshe/V/T [def: baptize]
	shventsl/V/T [def: baptize (taboo)]
		bashventsl/V/Bbashventslt [def: baptize (taboo)]
sibe{sybh}/Xsibes{sybwT}/H [f] [def: reason; accident; crisis] 
siborgyum [m] [def: seaborgium (Sg)] 
si'dele/S [f] [def: perch, roost (for birds)]
sider{sydwr}/Xsidurem{sydwrym}/H [m] [def: prayer book] 
	siderl{sydwrl}/Xsiduremlekh{sydwrymlekh} [def: prayerbook] 
si'filis [m?] [def: syphilis (disease)]
sifo'n/N [m?] [def: siphon; seltzer bottle] % Esther Kraytman: Briliantn
sige/S [f] [def: grimace; pose]
sigef{sygwf}/Xsigufem{sygwfym}/H [m] [def: self-mortification; penance]
signa'l/N [m] [def: signal] 
	signali'r/V/Bsignalirt signalizi'r/V/Bsignalizir't [def: signal] 
	signalizatsye/S [f] [def: (electronic) signaling equipment] 
	signatsye/S [f] asignatsye/S [f] [def: banknote]
		asigni'r/V/Basigni'rt [def: assign, appropriate, allot, allocate]
		asignirung/N [f] [def: appropriation]
	fo'rsigna'l/N [m] [def: green light; traffic light] % Yiddish League
sike/V/T [def: hiss (sound of a snake)] /Goys
sikhsekh{syxswx}/Xsikhsukhem{syxswxym}/H [m] [def: quarrel; conflict]
silek{sylwk}/H [m] [def: settlement (debt)]
	silek{sylwk}/V/T [def: pay off debts to someone (with "mit")] /Gop
	mesalek{mslk} [verb] [def: pay a debt (with "zayn")]
	nistalek{nsWlk} [verb] [def: die (of a saint) (with "zayn")]
		histalkes{hsWlkwT}/N [f?] [def: death (of a saint)]
	[idiom: a halber silek = partial payment]
silitsyum [m] [def: silicon (Si)] 
siltse/S [f] [def: snare]
silvester [m] silvester-ovnt/N [m] [def: New-Year's Eve] 
silye/V/T [def: string objects on a thread] /Gon/Goyf/Gayn/Gdurkh
simbol/N [m] [def: symbol] /Iish
	simbolizi'r/V/Bsimbolizi'rt [def: symbolize]
	simboli'st/N [m] [def: symbolist] /Iish simboli'zm/N [m] [def: symbolism] 
	simbo'leve/V/T /Garayn [def: read symbolism into something] 
	simbolik [f?] [def: symbolism] % Forwards: S-R Schaechter
simbyo'z/N [m] [def: symbiosis]
simen{symn}/Xsimonem{symnym}/H [m] [def: symbol, abbreviation; sign, indication] 
	bey'z-simendik{beyz-symndik}/A [def: ominous, forbidding, sinister]
simetrye/S [f] [def: symmetry] simetrish/A [def: symmetric] 
simfonye/S [f] [def: symphony] simfonish/A [def: symphonic] 
simkhe{QymHh}/Xsimkhes{QymHwT}/H [def: party, affair] /Idik
	besimkhe{bQymHh} [adj predicative] [def: joyous]
	simkhas{QymHT}/H [def: joy of, holiday of Simkhas Toyre (with "- toyre")] 
	mesameyekh{mQmH}/H [verb] [def: entertain (with "zayn")] 
	kale_simkhe{Klh-QymHh} [f] [def: bridal shower] [note: V] 
	eyfele_simkhe{ewfele-QymHh} [f] [def: baby shower] [note: V] 
	mole_simkhe{ml#-QumHh} [adj predicative] [def: full of joy]
simpatye/S [f] [def: sympathy]
	simpatish/A [def: genial; friendly] 
		umsimpatish/A [def: unfriendly, hostile]
	simpatizi'r/V/Bsimpatizi'rt [def: sympathize] 
	simpa'tiker/X [m] [def: sympathizer]
simpozyum/N [m] [def: symposium] 
simpto'm/N [m] [def: symptom] /Iatish [def: simptomatic] 
	tsuriktsi-simpto'm/N [def: withdrawal symptoms (addiction)] [note: V] 
simulatsye/S [f] [def: simulation]
sin{Qʼ}/H [m/f] [def: Hebrew letter Sin] 
sinagoge/S [f] [def: synagogue (usually with a choir)]
sina'ps/N [m?] [def: synapse] % Forwards: Yoel Matveyev
sindika't/N [m] [def: syndicate] 
	sindika'l/A [def: syndicate] 
	sindiki'r/V/Bsindiki'rt [def: syndicate]
sindrom/N [def: syndrome] 
sine{Qyn#h}/Xsines{Qyn#wT}/H [f] [def: hatred]
	sinas{Qyn#T} [def: hatred of] 
	soyne{Qwn#}/Xsonem{Qwn#ym}/H soynete{Qwn#te}/S [f] [def: enemy]
	soyney{Qwn#y}/H [def: enemies of]
	[idiom: onnemen dem tsad funem soyne{Qyn#} = play devil's advocate] [note: V]
	[idiom: zikh onshteln farn soyne{Qyn#} = play devil's advocate] [note: V]
sinematograf/N [m] [def: movie]
sinik/Ees [m] [def: bruise; black-and-blue mark]
sinke [f] [def: blueing (laundry product)]
sinod [m?] [def: synod] /Iish
sinokos/N [m?] [def: freshly-cut hay field] % Mendele
sinonim/N [m] [def: synonym] 
sinopsis/N [m] [def: synopsis; plot (story)] 
sintaks [m] [def: syntax] /Iish
sinte'z/N [m] [def: synthesis] 
	sintetish/A [def: synthetic] 
	sintezirer/S [m] sintetizo'r/N [m] [def: synthesizer] [note: V] 
sinusi't [m] [def: sinus headache (illness)] % Yiddish League
sinyak/Ees [m] [def: black eye (wound)]
siper{sypwr}/Xsipurem{sypwrym}/H [m] [def: story; storytelling] 
siratn/A [def: a kind of cloth]
sirene/S [f] [def: siren] % Harduf
sirup [m?] sirop [m?] tsirup [m?] [def: syrup]
siste'm/N [f] [def: system] /Iatish [def: systematic] 
	ge'ltsiste'm/N [f] [def: monetary system] % Yiddish League
	shray'bsiste'm/N [f] [def: writing system]
sitre_dimine{str#-dymyn#} [f] [def: natural, non-demonic side of the world (mystic)]
sitshke [f] [def: horse food] 
situatsye/S [f] [def: situation] 
sive/A [def: gray]
sivn/H [m] [def: Hebrew month of Sivan]
siyekh{QyH}/Xsikhes{QyHwT} [f] [def: speech (religious)]
siyem{sywm}/H [def: feast of completion] 
skabke/S [f] [def: splinter] 
skanda'l/N [m] [def: scandal; outrage] /Iyez [def: scandalous] 
skand'ir/V/Bskandi'rt [def: scan (verse); scan (optical transformation)] % optical transformation is a neologism
skandyum [m] [def: scandium (Sc)] 
skale/S [f] [def: scale (measure); scale (music); cliff] 
skarbove/A [def: banal, clichéd]
skatalogish/A [def: scatalogical] % neologism
skavutshe/V/Bskavutshet [def: yelp, whine (sound of a dog)]
skelet/N [m] [def: skeleton] /Iish [def: skeletal] 
skeptitsi'zm/N [m] skepsis/N [m] skeptishkayt/N [f] [def: skepticism] 
	skeptish/A [def: skeptical] 
	skeptiker/S [def: skeptic]
skhakh{sxx}/H [def: sukkoh topping (religious)] 
skhar{Qxr}/Xskhires_{QxyrwT} [def: payment]
skheme/S [f] [def: scheme, pattern]
	skhematish/A [def: schematic, underdeveloped] % Forwards: Genadi Estraykh
skhizofrenye/S [f] [def: schizophrenia (illness)]
	skhizofreniker/S [m] [def: schizophrenic person]
skhoyre{sHwrh}/Xskhoyres{sHwrwT}/H [f] [def: merchandise] 
	leger-skhoyre{lager-sHwrh} [def: shopworn articles] 
	shvarts-skhoyre{shvarts-sHwrh} [def: black-market articles] 
	miskher{mysHr}/Xmiskhorem{mysHrym}/H [m] [def: merchandise; business]
		miskher{mysHr}/H/V/T [def: buy and sell] 
	[idiom: shlisn a miskher{mysHr} = conclude a deal]
	soykher{swHr}/Xsokhrem{swHrym}/H [m] [def: merchant]
		soykherish{swHrish}/A [def: pertaining to merchants]
		soykherte{swHrte}/S [f] [def: merchant; wife of merchant]
		hurt-soykher{hurt-swHr}/Xhurt-sokhrem{hurt-swHrym} [m] [def: wholesaler] 
		oyver_lesoykher{ewBr-lswHr} [def: market price] [note: V] 
	skhires{sHyrwT}/H [def: merchandise] 
skhum{sxwm} [m] [def: sum total] 
ski/X [m] [def: ski] 
	[idiom: geyn af ski = go skiing]
skibe/S [def: small amount (bread, land)]
skirde/S [f] [def: haystack, pile] 
skitse/S [f] skits/N [m] [def: sketch, draft] 
	skitsik/A [def: sketchy] 
	skitsi'r/V/Bskitsi'rt [def: outline, sketch] 
sklad/N [m] [def: warehouse, storehouse; lumberyard; coalyard] 
	/D [def: collection] 
sklep/Ees/N [m] [def: cellar (part of building)] /Iish
sklero'z [m] [def: sclerosis (illness)]
skner/Ees [m] skneruk/Ees [m] [def: miser]
skolyo'z [m] [def: scoliosis (disease)]
sko'rinke/S [f] [def: crust (of bread)]
skoropeyke/S [f] [def: small potato] [usage: usually plural] % Stutchkoff
skorpyo'n/N [m] [def: scorpion (animal)] % Harduf
skorzhe/V/T [def: complain (Polish skarży "complains")] % Forwards: M-R Hoffman
skos/A [def: oblique (Russian скос)] % Forwards: M-S Hoffman
skotine/S [f] [def: mute animal]
skotsl [def: look who's here! (with "- kumt")] % < German: sei Gott willkommen
sko'vorode/S [f] sko'vrode/S [f] sko'verde/S [f] sko'verede [f] [def: frying pan] 
skrabne/A [def: elegantly dressed (woman) (Polish)] 
skripe/V/T [def: scrape, play (violin)]
	skrip/N [m] [def: squeak, creak]
		skriperay'/N [n] [def: squeaking] % Sholem Aleykhem: a farshterter peysekh
skripke/S [f] [def: part of a shoe that scrapes]
skript/N [m] [def: script] radyoskript/N [m] [def: radio script]
skrukhe/V/T [def: shudder]
	skrukh/N [m] skrukhe/S [f][def: shudder]
	[idiom: (der)filn a skrukh ibern layb = shudder involuntarily]
skulpto'r/N [m] skulptorin/S [f] [def: sculptor] 
	skulptur/N [f] [def: sculpture]
	skulpti'r/V/Bskulptirt [def: sculpt] % Leybl Botwinik
skunk/N/Ees [m] skunks/N [m] [def: skunk (Mephitis spp.)]
skutshne/A [def: boring, uninteresting]
slyedovatel/Ees [def: examining magistrate (Russian исследовать)]
slikhes{slyHwT}/H [def: penitential prayers] 
sline/S [f] [def: saliva, spittle]
sloy/Ees[m] [def: jar] /Iik
	[idiom: antkegn sloy = against the grain (cutting)] % Forwards: S-R Schaechter
slukh/N/Ees [m] [def: rumor]
slup/Ees [m] [def: pole, post]
sluzhe/V/T [def: serve faithfully] 
	sluzhbe/S [f] [def: service (occupation)]
slyad/N [m?] [def: trace, vestige]
	shlyad/N [m] shlyade/S [f] [def: trace, vestige; footprint] % An-sky, "di kekhin Khane", Rokhl Korn: Erd
smalye/V/T [def: be brave (Russian смелый); burn] /Goys
	[idiom: baker smalyer = two rubles (klezmer-loshn)]
smark [m?] [def: snot]
	smarkatsh [m?] [def: snotty person (literal); brat]
smete/S [f] [def: tax estimate]
sme'tene [f] [def: sour cream] 
	pid-sme'tene [f] [def: layer of milk under the sour cream (Ukrainian подсметанье)]
smike/V/T [def: fiddle]
smike/V/T [def: be pregnant (of animals)]
	sm'ikedik/A [def: pregnant]
smikhe{smyxh}/Xsmikhes{smyxwT}/H [f] [def: ordination] 
	smakh{smx}/H [m] [def: authority] 
	bar_samkhe{br-smx#}/S [m] [def: expert; authority]
	asmakhte{asmxW#}/Xasmakhtes{asmxWwT}/H [def: support (textual)]
	soymekh{swmx} [def: depend, rely on (with "zikh zayn oyf")] 
smitshik/Ees [m] smik/Ees [m] [def: bow (violin)] 
smoking [m] [def: smoking jacket, tuxedo (clothing)] 
smole [f] [def: tar, pitch, resin] /Idik [def: tarry, sulfurous]
	smalye/V/T [def: singe] /Gop
		farsmalyet/A [def: singed] 
		smalye/S [m] [def: burn; smell of burning] 
		smaline/S [f] [def: ashes??] % J. Opatoshu: lintsheray
	sma'lenish/N [n] [def: burn]
smore/V/T [def: snort] 
smotshke/V/T [def: smack the lips] /Gtsu/Goys/Garayn
	smotske/V/T /Gtsu/Goys /Idik shmoktse/V/T /Gtsu/Goys % variants
snaryad/N [m?] [def: artillery round]
snast [def: skeleton] % kuk nit oyf mayn snast, vos ikh bin azoy dar
snob/N [m] [def: snob] /Iish % Harduf
snop/Ees [m] [def: sheaf (grain or straw)] 
sobek [def: money stash] 
sobo'r/N [def: cathedral (Eastern Orthodox)] % Avrom Karpinovitsh
sod/Xseder [m] [def: orchard] /Dsed [def: park] 
	karshnsod/Xkarshnseder [m] [def: cherry orchard] 
	sadovnik/Ees [m] [def: orchard tender]
sod_{swd}/Xsoydes{swdwT}/H [m] [def: secret]
 	soydesdik{swdwTdik}/A soydesful{swdwTful}/A [def: secret]
	beso'd{bswd} [def: in secret]
		besodik{bswdik}/A [def: secret] 
			bsodikayt{bswdikayt}/N [f] [def: secrecy; concealment] 
	soyde{swde}/V/T [def: exchange secrets (with "zikh")] 
	farsoydet{farswdet}/A [def: secret] 
	[idiom: a sod far gants brod = an open secret]
sode/S [f] [def: soda (food; chemical)]
	baksode [def: baking soda]
	vani'l-sode [f] vani'le-sode [def: cream soda] [note: V]
sof{swf}/H [def: end]
	sof-sof{swf-swf} leso'f{lswf} [adv] [def: at last, finally]
	sofklsof{swf-Kl-swf}/H [def: all told] 
	eynsof{#yn-swf}/H [def: infinity] /Iik [def: infinite] 
	sofloz{swfloz}/A [def: endless] % Der Moment
	[idiom: az der sof iz gut iz alts gut = all's well that ends well]
sofe/S [f] sofke/S [f] [def: sofa (furniture)]
sofek{sfk}/Xsfeykes{sfkwT}/H [def: doubt] /Idik
	sofek{sfk}/V/T [def: doubt; be dubious of (with "in")]
	mesupek{mswpk}/H [m] [def: uncertain] /Idik [def: doubtful] 
		mesupke{mswpke} [f] [def: uncertain] % Der Nister
	onso'fekdik{onsfkdik}/A [def: certain; indisputable]
	[idiom: sofek{sfk} ... sofek{sfk} ... = it's hard to know whether ... or ...]
sofistitsirt/A [def: sophisticated] % Forwards
	sofistitsirung/N [f] [def: sophistication] % Forwards
sok/N [m] [def: syrup; sap] /Iik
sokhe/S [def: plow (Polish socha)] 
soldat/N soldat|ske/S [m] [def: soldier] 
	[idiom: tsunemen in soldatn = draft into the army]
solid/A [def: solid] 
	solidarish/A [def: in solidarity]
	solida'rishkayt/N [f] solidarite't [f] solidarizatsye/S [f] [def: solidary] 
	solidarizi'r/V/Bsolidarizi'rt [def: agree (with "zikh mit"); support] 
	konsolidatsye/S [def: consolidation]
soli'st/N [m] solistke/S [f] [def: soloist (musical)] 
solo [adv] [def: solo] % Stage direction in a hagode
solovey/N [m] [def: nightingale] soloveytshik/Ees [m]
sonate/S [f] [def: sonata (music)]
sond/Ees [m] [def: judge, law court (Polish sędzia)]
sone't/N [m?] [def: sonnet (poetry)]
sonishnik/Ees [m] [def: sunflower (plant)] % Sholem Aleykhem (grins af shavues)
sope/S [f] [def: ladle] 
sope/V/T [def: pant, breathe heavily; gasp] /Gtsu sape/V/T
	so'penish/N [n] [def: panting]
	farsopet/A farsapet/A [def: out of breath, panting]
sopra'n [m?] soprano/S [m?] [def: soprano (music)]
	koloratu'r-sopran [m?] koloratu'r soprano [m?] [def: coloratura soprano]
sored{Qryd}/H [def: remnant, impotent man] 
soroke/S [f] saroke/S [f] [def: magpie (bird)] 
	[idiom: khapn tsen sorokes bay eyn veydl = multitask; kill two birds with one stone]
sort/N [m] [def: sort] 
	sorti'r/V/Bsorti'rt [def: sort] 
	re'dnsort/N [m] [def: manner of speech]
sos/N [m] [def: gravy, sauce (food)] 
	tunksos/N [m] [def: dip (food)] [note: V]
sazhlke/S [def: lake]
sosne/S [def: pine (tree, Pinus spp.)] sosnov/A
sosulke/S [f] [def: icicle]
sot/Ees [m] [def: honeycomb]
sotsya'l/A [def: social] /Iish
	sotsyali'zm [m] def: socialism]
		sotsyali'st/N [m] sotsyalistke/S [f] tsitsili'st/N [m] [def: socialist]
		sotsyalistish/A [def: socialist] 
	sotsyologye/S [f] [def: sociology] sotsyologish/A [def: socialogical] 
		sotsyolog/N [m] [def: sociologist] 
	sotsyo- [prefix] [def: socio-]
sous/N [m] [def: sauce, dressing (food)] 
sove/S [f] [def: owl] 
sovest [m?] [def: conscience (Russian совесть)]
soybl/N [m?] [def: sable (animal); sable coat] /In
soye [f?] [def: soy (plant)]
sozhe/S [f] [def: soot] 
spageti [def: spaghetti (food)] 
spa'klyeve/V/T [def: apply spackle] 
sparzhe [f] [def: asparagus (vegetable)] 
	-/Xshpara'gn [def: asparagus (vegetable)] % M. Schaechter: geviksn
spazme/S [f] [def: spasm] 
	spazmatish/A [def: convulsive, spasmodic]
/-spekt 
	aspekt/N [m] [def: aspect]
	perspektiv/N perspective/S [f] [def: perspective]
	prospe'kt/N [m] [def: pamphlet; prospectus] 
		prospekti'v [adv] [def: future]
	retrospektsye/S [f] [def: retrospection; hindsight; re-analysis]
		retrospekt/N [m?] [def: retrospect] /Iiv [def: retrospective]
	spektakl/N [m] [def: spectacle] 
spekulatsye/S [f] shpegelatsye/S [f] [def: speculation]
	spekuli'r/V/Bspekuli'rt shpegeli'r/V/Bshpegeli'rt [def: speculate]
	spekulan't/N [m] shpegela'nt/N [m] [def: speculator] 
spetsye'l/A [def: special]
	spetsyalizi'r/V/Bspetsyalizi'rt [def: specialize] 
	spetsifish/A [def: specific] 
	spetsyali'st/N [m] [def: specialist] 
		spets/N [m] [def: specialist (Soviet)]
	spetsyalite't/N [f] [def: specialty] 
spilshlive/A [def: hot-blooded, hot-tempered, irascible]
	spiltsheve/A [def: hot-blooded, hot-tempered, irascible] % Forwards: Moshe Lemster 
spinke/S sponke/S shponke/S [f] [def: cufflink]
spira'l/N [m] [def: spiral] /Iish
spira'nt/N [m?] [def: fricative, spirant (linguistics)] % D-H Katz
	spirantizirung/N [def: spirantization (linguistics)] % D-H Katz
spirt [m] shpirt [m] [def: spirit (alcohol); scamp, brat, madcap, impulsive person] 
	spirtovke/S [f] [def: primus stove]
	vaynspirt [m] [def: grain alcohol] 
spiske/S [f] [def: list] % Chava Rozenfarb: Botshani 
spitse/S [f] [def: spoke (wheel)]
spitsh [m?] [def: speech (English)]
spodik/Ees [m] spodek/Ees [def: hat (high fur cap trimmed in plush or fur) (clothing)]
	[idiom: dreyen a spodik = annoy, pester]
spo'dnitse/S [f] [def: petticoat] spu'dnitse/S [f]
spoloshe/V/T [def: make (horse for instance) wild with fright (Belarusian  спалох)]
	raspoloshe/V/Braspoloshet [def: take fright (horse) (with "zikh")
sponsor/S [m] [def: sponsor] [usage: American Yiddish]
sponta'n/A [def: spontaneous] 
	sponta'neve/V/T [def: improvize, jam (music)] [note: V] 
sporadish/A [def: sporadic] 
sport/N [m] [def: sport] /Iiv [def: sporty]
	sportove/A [def: related to sport] % Avrom Karpinovitsh
	sportler/S [m] [def: sportsman] 
spotike/V/Bspotiket [def: stumble over (with "zikh in")]
sprave/V/T [def: accomplish, reach a goal (with "zikh mit")]
	sprave/S [f] [def: matter at hand] % Kulbak: Zelmenyaner
spravnik/Ees [m] ispravnik/Ees [m] [def: police prefect (Russian исправник)]
sprenzhine/S [f] sprunzhine/S [f] spruzhine/S [f] [def: spring (device)] 
	pruzhine/S [f] [def: coil; spring] % B. Sandler: Karolina-Bugaz
		pruzhinke/S [f] [def: spring] % Yankev Dinezon
spyokhe/S [f] [def: meat (klezmer jargon); breast (klezmer jargon)] % Stutchkoff
sreyfe{Qryfh}/Xsreyfes{QryfwT}/H [def: fire; conflagration]
	nisref{nQrf}/Xnisrofem{nQrfym}/H [m] [def: burned, person affected by a fire] 
	soref{Qrf}/Xsrofem{Qrfym} [def: fiery angel]
	farsarfe{farQrfe}/V/Bfarsarfet{farQrfet} [def: scorch; broil; char]
srore{Qrrh}/Xsrores{QrrwT}/Xsrorem{Qrrym}/H [m] [def: lord]
	srorish{Qrrish}/A [def: lordly; belonging to a lord]
stabi'l/A [def: stable; stationary]
	u'mstabi'l/A [def: instable]
	stabilizi'r/V/Bstabilizi'rt [def: stabilize]
		stabilizatsye/S [f] [def: stabilization] 
	stabilkayt/N [f] [def: stability] 
	stabilite't/N [f] [def: stability] [usage: doubtful admissibility] % Forwards
stade/S [f] [def: herd of animals] 
stadye/S [f] stadyon/N [m] [def: stadium] 
stadye/S [f] [def: stage, phase]
stagnatsye/S [f] [def: stagnation] 
stam{sWm}/H [def: plain, regular, ordinary] [grammar: attributive] /Iik
	min_hasta'm{mn-hsWm}/H [adv] mistome{msWm#}/H mista'm{msWm} [def: most likely, probably]
stambulke/S [f] [def: nose (klezmer jargon)]
standard/N [m] [def: standard] /A
	standardizi'r/V/Bstandardizi'rt [def: standardize]
	standardizatsye/S [f] [def: standardization]
	farstandardizi'r/V/Bfarstandardizi'rt [def: standardize] 
	standardizirung/N [f] [def: standardization] 
stanik/Ees [m] [def: brassiere (women's clothing)]
stanovo|y' [m] [def: district police officer (Russian)]
stantsye/S [f] [def: station; stop (bus, metro); living quarters] 
	statsye/S [f] [def: station][usage: inadmissible]
	banstantsye/S [f] [def: train station]
	kabl-stantsye/S [f] [def: cable (transmission) station] [note: V]
	metro-stantsye/S [f] [def: subway stop]
	[idiom: haltn stantsye = to board (at a rooming house)]
star [m] starine/S [f] [def: star (theatrical)]
stare/V/T [def: endeavor, try hard (with "zikh")] 
stareste/S staroste/S [def: head of organization, chairman, mayor of small town (Russian or Polish)] 
starter/S [m] [def: starter (sports)]
startshe/V/T [def: protrude] /Goys/Garoys
stashke/S [f] [def: peanut (food)]
	fistashke/S [f] [def: pistachio (food)]
statish/A [def: stationary, immobile] 
	statik/Ees/Xstatkes [def: well-behaved person]
stati'st/N [m] statistke/S [f] [def: supernumerary, extra (theater)]
statistik [f] [def: statistics (subject)]
	statistish/A [def: statistical] 
statue/S [f] [def: statue] 
	statuetke/S [def: statuette]
status/N [m] [def: status] 
stav/N/Ees [m] [def: artificial lake, artificial pool, artificial pond]
staye/V/T [def: suffice, last] 
staye/S [f] [def: wolf pack; flock; swarm]
stazh/N [m] [def: length of service; seniority] 
steari'n [m] [def: stearin (glyceryl tristearate)]
stelevate/A sotulevate/A [def: hunchbacked]
stelnik/Ees [m] [def: honeycomb]
stelye/S [f] [def: ceiling] 
stenge/S [f] steynge/S [f] [def: ribbon] /Dstenge
stenke/V/T [def: grumble, grouse]
stenografye [f] [def: stenography] 
	stenografi'st/N [m] stenografistke/S [f] [def: stenographer] 
step/Ees [m] [def: steppe (geographical term)] /Iish
stereo- [prefix] [def: stereo (chemistry)]
	diaste'reomer/S [m] [def: diastereomer (chemistry)] % Stephen Cohen
stereotip/N [m] [def: stereotype] 
sterilizi'r/V/Bsterilizi'rt [def: sterilize; neuter, spay] 
sterte/S [f] sterde/S [def: haystack (Polish sterta)] % Mendele
	sterdevayz/A [def: in heaps] % Sholem Aleykhem
steshke/S/D stezhke/S/D stetshke/S/D [def: path] % all acceptible
stigoter/S [def: enemy]
stikhye/S [f] [def: elemental force; the elements] 
	stikhish/A [def: elemental, natural] 
stil/N [m] [def: style] stilistik [def: stylistics] 
	stilizi'r/V/Bstilizi'rt [def: stylize]
stimuli'r/V/Bstimuli'rt [def: stimulate] 
	stimu'l/N [m?] stimulatsye/S [f] [def: stimulus]
stipendye/S [f] [def: stipend; scholarship]
	stipendyant/N [m] stipendyantke/S [f] [def: receiver of stipend] 
stire{sWyrh}/Xstires{sWyrwT}/H [f] [def: contradiction] 
	bestire{bsWyrh}/H [adv] [def: in contradiction]
	sti'resdik{sWyrwTdik}/A [def: contradictory]
		sti'resdikayt{sWyrwTdikayt}/N [f] [def: contradictory nature]
stirdes [n] [def: defiance; contempt]
stis [m] [def: lack, deficiency]
sti'seve/V/T [def: jibe; concur] 
stodole/S [f] [def: barn]
sto'ike/S [f] [def: sales counter] % Forwards: Boris Sandler
stoitsi'zm/N [m] [def: stoicism]
stolb/Ees [m] [def: post, pole; caisson (bridge support)]
stolyer/S [m] [def: cooper, carpenter, cabinetmaker (occupation)] /Iske
	stolyar/Xstolya'res [m] [def: cooper] /Iske
	stolyerke/S [f] [def: wife of a cooper]
	stolyeray'/N [n] [def: cooperage] 
ston/N [m] [def: waist (Polish stan); shirt, blouse] /Dstond
stop/N [m] [def: stop sign] % Yiddish League
stos/N [m] [def: a card game; cord of wood]
stotshik/Ees [m] [def: a kind of wax candle] % Sholem Aleykhem
stoyg/N [m] [def: haypile]
	sto'ygeve/V/T [def: pile (hay)]
stoyp/N [m] [def: post, pole, stake; pile; fool] 
	[idiom: baym stoyp = at the stake]
strakhi'r/V/Bstrakhi'rt [def: insure]
	strakhirung/N [f] [def: insurance]
	farstrakhi'r/V/Bfarstrakhi'rt [def: insure] 
straptshe/S [m] [def: policeman; defender] 
	[idiom: gots straptshe = hypocrite, zealot]
strashe/V/T [def: threaten] /Goys/Gon
	farstrashe/V/Bfarstrashet [def: torment] % Avrom Karpinovitsh
	strashidle/S [f] [def: scarecrow; bugbear] 
	strashunik/Xstrashunkes [m] [def: threat, warning; menace]
	[idiom: gebn strashunkes = make threats]
strayk/V/T [def: strike (labor)] 
	strayk/N [m] shtrayk/N [m] [def: strike (labor)] 
strategye/S [f] [def: strategy] 
	strategish/A [def: strategic]
strazhnik/Ees [m] [def: rural police constable (Russian стражник "guard")]
stremen/Ees [m] [def: stirrup (for riding a horse)]
strempl/Eekh [n] [def: icicle]
	stre'mpele/Xkh [n] [def: piece of snot] [note: V] 
stri'geve/V/T [def: baste (sewing)]
	 /Giber/Gayn/Goys/Garoyf/Garayn/Gon/Gtsunoyf/Gtsu
	farstri'geve/V/T [def: baste (sewing)] 
		fastrige/S [f] [def: basting stitch]
strikhe/S [f] strekhe/S [f] [def: rooftop, roof (part of building)]
strofe/S [def: verse]
stroke/S [f] [def: fashionable cord or lace]
stronge/S [f] [def: trout (fish)] 
strontyum [m] [def: strontium (Sr)] 
strope/S [f] [def: mortar; fool] % Michael Wex
stroye/V/T [def: build; construct] /Goys
	/Gon [def: tune (an instrument)]
	stroy/Ees [m] [def: oder; style, fashion; line, gantlet]
strozh/Xstrezher [m] strozhke/S [f] struzh/N/Ees [m] struzhnik/Ees [def: janitor; building superintendent]
	strazhak/Ees [m] [def: watchman (Russian стражак)
struktur/N [f] [def: structure] 
	infrastruktur/N [f] [def: infrastructure] 
	strukturi'r/V/Bstrukturi'rt [def: structure] 
-/Xstrulkes [def: jacks (game) played with calves' knuckles] %  Stutchkoff
strune/S [f] [def: string (of a musical instrument); animal hair]
	strunke/S [f] /Dstrunk [def: little string] % Sholem Aleykhem
	-/Xstrunes [def: string instruments] [note: V]
strushke/S [f] struzhke/S [f] [def: wood shaving; chip] 
strutshke/S [f] [def: peel (of vegetable); wood shaving; string bean] % Stutchkoff (peel); Forwards: S-R Schaechter (string bean)
stsene/S [f] [def: scene] stsenish/A stsenke/S
	stsenar/N [m] [def: scenario] 
	instseni'r/V/Binstseni'rt instsenizi'r/V/Binstsenizi'rt [def: dramatize] 
		instsenizirung/N [f] [def: dramatization]
	stseni'r/V/Bstseni'rt [def: dramatize] [usage: doubtful admissibility]
	avanstsene/S [f] [def: stage front]
studyo/S [m] [def: studio (artist)] studye/S [f] [def: studio (film)]
stu'klke [f] [def: a card came (Russian стукалка)]
stupe/S [f] [def: pestle; fool]  
sturde/S [def: rick (of hay)]
stusak/Ees [m?] [def: punch, slap (Ukrainian стусак)] % Sholem Aleykhem
stutshke/S /D [def: trick (with "ton")] % Mendele
styua'rd/N [m] styuardke/S [f] [def: steward, stewardess, attendant] [note: V]
suave/A [def: suave] % Forwards: M-S Hoffman
sublimi'r/V/Bsublimi'rt [def: sublimate] 
subotnik/Ees [m] subotnitse/S [f] [def: Christian observing Sabbath on Saturday] 
subpene/S [f] [def: subpoena] % Yiddish League
	subpeni'r/V/Bsubpeni'rt [def: subpoena] % Yiddish League
subre'tin/S [f] subretke/S [f] [def: soubrette (theater)]
subsidi'r/V/Bsubsidi'rt [def: subsidize, support]
	subsidye/S [f] [def: subsidy] 
substitu't/N [f?] [def: substitute (thing)] % Forwards: Sholem Berger
substa'nts/N [f] [def: substance] 
	substanti'v/N [m] [def: noun (grammar)]
subti'l/A [def: subtle] 
subtraktsye [f] [def: subtraction (mathematics)] % Stutchkoff
subve'nts/N [f] [def: subsidy, grant]
subye'kt/N [m] [def: subject]
	subyekti'v/A [def: subjective (grammar)] 
sude{sewdh}/Xsudes{sewdwT}/H [f] [def: feast, festive meal] /D
	sudenyu{sewdhnyu} [def: dear feast] 
sudyebne/A [def: judicial, forensic (Russian судебне "judicial")]
suf{swf}/H [def: Reed sea (with "yam{|ym}")]
sufiks/N [m] [def: suffix] 
sufi't/N [m] [def: ceiling]
suflyo'r/N [m] suflyorshe/S [f] [def: prompter (theatrical)]
	sufli'r/V/Bsufli'rt [def: prompt (theatrical)]
sugye{swgy#}/H [f] [def: subject (in Talmud)] 
suk/Ees [m] [def: knot (in wood); gnarl] 
	sukate/A sukevate/A [def: gnarled, knotty] 
suke/S [f] [def: bitch (animal)]
suke_{swKh}/Xsukes_{swKwT}/H [f] [def: booth for festival of Sukkoth] 
sukhar/Ees [m?] [def: zweiback, crackers (food)]
	sukhostoy [m?] [def: dried-up tree] 
	sukhote/S [f] tshakhotke/S [f] [def: tuberculosis (disease)]
		sukhotnik/Ees [m] sukho'tnitse/S [f] [def: consumptive person]
sulta'n/N [m] [def: sultan] % Harduf
sumatokhe/S [f] [def: mess, confusion, uproar] 
sume/S [f] [def: sum] 
	[idiom: di pinktlekhe/genoye sume = exact change] [note: V]
sumi'r/V/Bsumi'rt [def: add up] 
sumne/A [def: mournful, gloomy, drab]
	sumnekayt/N [f] [def: mournfulness; gloominess] % Forwards: Boris Sandler
su'msum [m?] [def: sesame (plant, seed) (Sesamum indicum)]
suni't/N [m] suni/S [m] [def: Sunni (Moslem)] 
superlativ/N [def: superlative] 
	superyorite't/N [f] [def: superiority]
	super- [prefix] [def: super, extreme]
surdut/N [m] [def: long coat] /D % French: surtout
surpri'z/N [m] [def: cause of alarm] 
sus{sws}/Xsusem{swsym}/H [m] [def: horse] 
sutane [f] [def: sutana, cassock (priest's garb)] % Shpiglblat
sutshke/S [f] [def: female puppy] % Harkavy
sutul/A [def: stoop-shouldered] % Forwards: Boris Sandler
	sutulevate/A [def: stoop-shouldered] % Stutchkoff
suveni'r/N [m] [def: souvenir] % Harduf
suveren [m] [def: sovereign] 
	suverenite't/N [f] [def: sovereignty] 
suzhe't/N [m] [def: plot (story)] 
svastike/S [f] [def: swastika] % Harduf
sveter/S [m] [def: sweater] 
sving [m] [def: swing (dance)] % Yiddish League
svinke [f] shvinke [f] [def: mumps (disease)]
svishtshe/V/T [def: whistle piercingly] 
	svishtsh/N [m] [def: piercing whistle] 
svite/S [f] [def: suite, escort, company]
svite/S [f] [def: frock coat (clothing)] % Stutchkoff
	svitke/S [f] [def: traditional Ukrainian upper clothing from woven wool] % Der Nister
svive{sByBh}/Xsvives{sByBwT}/H [def: neighbornood; milieu; environment] /Idik
svore{sBr#}/Xsvores{sBrwT}/H [f] [def: opinion; obvious conclusion] 
	svore_{sBrh} [f] % alternative spelling
	hasbore{hsbrh}/Xhasbores{hsbrwT}/H [f] [def: explanation; invention]
	masber{msbyr}/H [verb] [def: be of the opinion (with "zayn")] 
	mistaber{msWbr} [adj] [def: evident, obvious]
	svoreve{sBr#ve}/V/Bgesvorevet{gesBr#vet} [def: express an opinion]
ta [interj] [def: ah, well]
tabak/N taba'k/N [m]
	tabik [m] ta'bike/S [f] [def: snuff]
	tabatshnik/Ees [m] [def: tobacconist] 
	porttaba'k/N [m] [def: tobacco pouch]
	[idiom: vert a shmek tabak/tabike = worthless]
	[idiom: shmekn tabike = take snuff]
tabele/S/Xtabeln [f] [def: table]
tabor [m?] [def: Gypsy caravan] /Iish % Der Nister
tabu/N [m] [def: taboo]
tabu'n tabune/S [def: herd of horses] 
taburet/N [m?] /D taburetke/S [f] [def: stool (furniture)]
tadl/V/T [def: wag a finger] 
taflye/S [f] [def: slab, panel; window pane] /D
	[usage: "pane" is of doubtful admissibility] 
tag{Wg}/Xtagn{Wgyn}/H [def: letter crowns]
take [adv] [def: indeed, truly, really] 
takef{Wkyf}/Xtakifem{Wkyfym} [m] [def: influential person] /K
	-/Xtekifes{WkyfwT} [f] [def: force, stubbornness, authority]
	unesane_toykef{|unTnh-Wwkf} [noun] [def: a solemn prayer on the High Holidays]
takela'zh [n] [def: rigging, tackle (nautical)] [note: V]
takhanun{WHnwn}/Xtakhanunem{WHnwnym}/H [m] [def: a daily penitential prayer (Jewish)]
	/Idik takhanunemdik{WHnwnymdik}/A [def: penitential; sorrowful] 
takhbule{Wxbwlh}/Xtakhbules{WHbwlwT}/H [f] [def: means, method; remedy; tricky plan]
takhles{WxlyT}/H [def: purpose, result; business] /Idik
	farta'khleve/V/Bfarta'khlevet [def: waste; spend pointlessly]
	% also spelled Hebraically:
	farta'khleve_{farWxleve}/V/Bfarta'khlevet_{farWxlevet} [def: waste; spend pointlessly]
	bal-takhles{bel-WxlyT}/Xbaley-takhles{bely-WxlyT} [m] bal-taklhesnitse{bel-WxlyTnitse}/S [f] [def: pragmatic person]
-/Xtakhrikhem{Wxryxym}/H [def: shrouds] % only in plural
takhshet{WxSyt}/Xtashkhitem{WxSytym}/Xtashkhitn{WxSytyn} /D [def: decoration, adornment; brat, spoiled child; fine young man (ironic)]
takt/N [def: tact; (musbc) measure, cadence, bar, beat, downbeat]
	oyftakt/N [m] [def: up beat]
	taktish/A taktful/A [def: tactful]
		taktishkayt/N [f] [def: tact]
		umtaktishkayt/N [f] [def: tactlessness]
takse [def: a kind of dog] % Stutchkoff
takse/S [f] [def: tax on kosher meat]
	[idiom: hobn a kheylek in der takse = get a percent of the meat tax]
taksi/S [m/n] [def: taxicab] 
	taksist/N [m] [def: taxi driver] % Forwards: Boris Sandler
talabende/V/T [def: droop, loll (with "zikh")] % Mendele (referring to a sleeper's head)
talanke/V/T [def: clang (sound of tin bells)] 
tala'nt/N [m] [def: talent]
	talanti'rt/A talantful/A [def: talented]
	talantarnye/S [f] [def: talent show]
tales{tlyT}/Xtaleysem{tlyTym}/H [m] [def: prayer shawl] 
talmed{Wlmyd}/Xtalmidem{Wlmydym}/H [m] [def: student]
	talmido{Wlmydh}/Xtalmides{WlmydwT}/H [f] [def: student] 
	talmedl{Wlmydl}/Xtalmidemlekh{Wlmydymlekh}/H [m] [def: student]
	talmidey{Wlmydy}/H [def: students of]
	talmud{Wlmwd}/H [m] [def: Talmud] /Iish 
		talmudi'st{Wlmwdist}/N [m] /Iish
	melamed{mlmd}/Xmelamdem{mlmdym}/H [m] /D mela'medke{mlmdke}/S [f] [def: teacher (kheder)]
		melamdish{mlmdish}/A [def: learned] 
		dardake_melamed{drdky-mlmd} [m] [def: teacher of young children]
	limed{lymwd}/Xlimudem{lymwdym}/H [m] [def: subject of study] 
		-/Xgezelshaft-limudem{gezelshaft-lymwdym} [f] [def: social studies] 
	lamdn{lmdn}/Xlamdonem{lmdnym}/Xlomdem{lwmdym}/H [m] [def: scholar]
		lamdones{lmdnwT}/H [n] lomdes{lwmdwT}/H [f] [def: scholarship, learning] 
		lomdish{lwmdish}/A lamdonish{lmdnish}/A [def: scholarly] 
	melumed{mlwmd}/Xmelumodem{mlwmdym}/H [m] [def: sage]
talye/S [f] talke/S [f] [def: waist (of clothing); waistband; deck (cards)]
talyope/V/Btalyopet [def: rain??] % B. Sandler: Karolina-Bugaz
talyum [m] [def: thallium (Tl)] 
tam{tem}/N/Xtamem{temym}/H [m] [def: taste; reason]
	batamt{batemt}/A [def: tasty] umbatamt{umbatemt} [def: tasteless; tacky] 
	nokhtam{nokhtem}/N [m] baytam{baytem}/N [m] [def: aftertaste]
	toyem{tweM} [verb] [def: taste (with "zayn")]
	-/Xmatamem{mtemym} [def: delicacies, gourmet food]
	[idiom: nit hobn keyn tam{tem} = be unappealing]
	[idiom: hobn dem zibetn tam{tem} = be appealing]
	[idiom: tam{tem} ganeydn{gn-edn} = wonderfully good taste]
tam_{Wm}/H [def: simpleton] tamevate{Wmevate}/A [def: slow to understand]
	[idiom: zikh makhn tamevate{Wmevate} = pretend not to understand]
	temimes{WmymwT}/H [n] [def: simplicity] /Idik [def: simple, naive] 
		betemimesdik{bWmymwTdik}/A [def: simple, naive]
	betmimes{bWmymwT} [adv] [def: in simplicity]
tamez{Wmwz}/H [m] [def: Hebrew month of Tammuz] /Idik [def: summer-like] 
tamil/A [def: Tamil (language)]
taml/V/T [def: stagger, lurch; feel dizzy]
tamtses{WmcyT}/Xtamtseysem{WmcyTym}/H [m/n] [def: essence, gist; precis] 
tande't/N [m] [def: frippery; old clothes]
	tandetnik/Ees [m] [def: dealer in old clothes; poor tailor]
	tandetne/A [def: poorly made; botched]
tane{Wn#}/Xtanoem{Wno|im}/H [def: Rabbi of the Mishna]
	tane_bare{Wn#-br#}/S [m] tanebare/S [def: sage named in a Boraiso; smart aleck; simpleton]
tanakh{Wn|″X}/H [m] [def: Bible] /Iish
	tanakhnik{Wn″xnik}/Ees [m] [def: fortune teller who uses random biblical pages]
tango/S [m] [def: tango (dance)] 
tank/N [m] [def: tank (military); tank (vessel)] % BUG: plural should generate tankn?
	tankist/N [m] [def: tank driver (military)]
tano{Wn#}/H [m] [def: Mishnaic authority] 
tantalum [m] [def: tantalum (Ta)] 
tante [f] [def: aunt] 
tants/V/T [def: dance] /Gfunander/Gmit/Gakegen/Gop/Gakegn/Gtsu/Garum/Gon/Gariber
	/Gnokh [def: imitate, ape] 
	/Gunter [def: dance about]
	tants/Xtents [m] /Dtents [def: dance]
		boykhtants/Xboykhtents [m] [def: belly dance]
		folkstants/Xfolkstents [m] [def: folk dance]
		/Xbaltents [m] [def: ballroom dancing] % Yiddish League
		/Xsalontents [m] [def: social dancing] % Yiddish League
	tentser/S [m] te'ntserin/S [f] [def: dancer]
		boykhtentserin/S [f] [def: belly dancer]
		fo'lktentser/S [m] fo'lktentserin/S [f] [def: folk dancer]
		mi'ttentser/S [m] [def: dance partner]
	broygez{brwgz}-tants [m] [def: anger-dance (part of wedding celebration)]
	kla'ptants/V/T [def: tap-dance] [note: V]
		kla'ptentser/S [m] [def: tap tancer] [note: V]
	[idiom: meynen az emetser vet untertantsn = take someone for granted] [note: V]
tap/V/T [def: touch; probe; grope] /Gon/Garum/Gtsurik
	/Goys [def: palpate; feel all over]
	dertap/V/Bdertapt [def: reach; find] 
	batap/V/Bbatapt [def: touch] 
	ta'penish/N [n] [def: probing] 
tapetsi'r/V/Btapetsi'rt [def: bedeck with tapestry]
taptsha'n/Ees [m] toptsha'n/Ees [m] [def: sofa that can be a hard bed] 
taraka'n/Ees [m] [def: cockroach] 
tara'n/N [def: battering ram; post; beam]
tara'n/Ees [m] [def: roach fish (family Cyprinidae), usually dried]
taranke/S [f] [def: sun-dried salty fish (food) (Ukrainian таранька)] % Z. Shneyer 
tarera'm [m] tarara'm [m] [def: commotion, fuss]
	tarera'm/V/T [def: make a fuss] /Gop tarara'm/V/T [def: make a fuss] /Gop
	fartarara'mt/A fartarera'mt/A [def: upset]
tarashtshe/V/T [def: stare (Russian таращить)] /Goys [def: open (the eyes)]
tarbes{WrbwT}/H [n] [def: politeness]
	tarbes{WrbwT}-shul/N [f] [def: secular Hebrew-language school in Poland between the wars]
targ/N [def: market] 
targem{Wrgwm}/H [m] [def: Aramaic translation; Aramaic] 
tarif/N [m] [def: tariff] 
-/Xtarumes{WrewmwT}/Xtarumesn{WrewmwTn} [def: protests, complaints] /Idik [def: complaining]
	[idiom: hobn tarumes{WrewmwT} tsu = criticize]
tartak/N [m] [def: sawmill]
	holtstartak/N [m] [def: sawmill]
tartey_desasrey{WrTy~dsTry}/H [n] [def: oxymoron]
taryag{Wry″g}/H [def: 613, number of Biblical commandments] 
tas [m?] /Dtes [def: saucer]
tash/N [f/m] [def: purse, bag, pocketbook; pouch; pocket] /Dtesh
	aktntash/N [def: briefcase (German)]
	buzemtash/N [def: shirt pocket] 
	homentash{hmn-tash}/N [def: Purim pastry (filled)] 
	rayzntash/N [def: travel case]
	geney'-teshl/Eekh [n] [def: sewing kit] % Opatoshu
tashlekh{WSlyx} [m] [def: tashlikh ceremony of Rosh Hashono (religious)]
tashme/S [f] [def: tape] 
taske/V/T tashtshe/V/T taskeve/V/T [def: lug, pull, drag (Russian таскать)] /Gavek
tate/S/C/J/D [m] [def: father] /Idik 
	tatenyu tateshi tatelyu tatinke/S [m] [def: dear father; daddy; wow! (interj)] 
	tatele [m] [def: little boy (affectionate)]
	shti'ftate/S/J/C [m] [def: stepfather]
tats/N [f/m] [def: tray] /Dtets [def: saucer] 
	tas/N [m?] [def: saucer]
tatshke/S [f] [def: wheelbarrow]
tatu/S [m] [def: tatoo]
	tatuirung/N [f] [def: tatooing]
tatue{WeWwe}/Xtatuem{WeWwym}/H [m] [def: illusion; deceit]
	mayse_tatue{meQh-WeWwe}/Xmaysem_tatuem{meQym-WeWwym} [f] [def: deceitful action]
-/Xtaybelekh [n] [def: stuffed cabbage (food)] % only in plural
taye/V/T [def: conceal (imperfective); thaw]
	/Goys [def: thaw (with "zikh")]
tayer/K [def: dear; expensive] /Iink
tayge/S [f] [def: taiga (landform in Russia)] 
taykh/N [m] [def: river; lake (NY)] /Iik /D [def: creek, brook] 
	bay'taykhl/Eekh [def: tributary]
	[idiom: patsh zikh nit in baykhele, ven fishele iz nokh in taykhele = don't count your chickens before they're hatched] % Stutchkoff
tayne{tenh}/H/V/T [def: complain; argue; plead] /Goys/Gayn
	tayne{tenh}/Xtaynes{tenwT}/H [f] [def: complaint; claim] 
	tsetayne{tsetenh}/V/Btsetenht{tsetenht} [def: argue]
	[idiom: hobn taynes{tenwT} tsu emetsn = complain about someone]
	[idiom: tsum lets hob taynes{tenwT} = out of our control]
tayneg{Wenwg}/Xtaynugem{Wenwgym}/H [m] [def: pleasure, delight]
tayster/S [m] [def: wallet; purse]
	talye-tayster/S [m] [def: fanny pack] [note: V] 
taytl/V/T [def: point out] /Gon [def: accuse]
	ontaytler/S [m] [def: whistleblower, accuser] 
	tayt/V/T /Gon [def: point out] ontayt/N [m] [def: meaning]
		baytayt/V/Bbatayt [def: mean]
	dayt/V/T /Gon tayt/V/T /Gon [def: point out] [usage: inadmissible]
		ondayt/N [m] [def: proof] [usage: inadmissible]
		ondaytung/N [f] [def: mention] % Forwards: M-S Hoffman
		fildaytik/A [def: multi-faceted; with many meanings]
	/Dtayt [def: marker, bookmark] % Z. Shneyer
taytsh/V/T [def: explain; interpret] /Goys/Giber/Gop
	/Garayn /Gayn [def: read meaning into]
	/Garoys [def: express]
	taytsh/N [m/f] [def: meaning] /Iik
	taytsh [adj predicative] [def: means]
		arayntaytshung/N [f] [def: interpretation, explanation]
		grunttaytsh/N [f] [def: underlying meaning] % Forwards: Hershl Glaser
		optaytsh/N [m] [def: explanation]]
			optaytsher/X/S [m] [def: interpreter]
		oystaytsh/N [m] [def: interpretation]
			oystaytsher/S [m] [def: interpreter, explainer]
			oystaytshung/N [f] [def: interpretation, explanation]
	tsveytaytshik/A [def: ambiguous]
		tsveytaytshikayt/N [f] [def: ambiguity] 
	fartaytsh/V/Bfartaytsht [def: explain] 
		fartaytshung/N [f] [def: explanation]
	staytsh [def: how can it be?] 
	ivre{eBry}-taytsh [n] [def: archaic Yiddish] 
tayve{W#vh}/Xtayves{W#v|wT}/H [f] [def: desire] /Idik
	tayvas{W#vT}/H [def: desire of]
	bal_tayve{bel-W#vh} [m] bal_tayvenik{bel-W#vhnik}/Ees bal_tayvenitse{bel-W#vhnitse}/S [f] [def: lustful person]
tayvl/Xtayvlonem{tIvlonym}/Xtayvolem{tIvolym} [m] [def: devil]
	tayvlonish/A [def: devilish, diabolical] 
te/Een [m] [def: the letter T] 
te-te-te' [interj] [def: well, well; what do you know: expression of surprise] 
teater/S/N [m] [def: theater] /D
	teatra'l/N [m] teatra'lke/S [f] [def: showman, theater enthusiast] 
	teatra'l/A [def: theatrical] /Iish
	teatralizi'rt/A [def: theatricalized] % Forwards: Yoel Matveyev
teizm/N [m] [def: theism] teist/N [def: theist]
teke/S [f] [def: file (computer); briefcase] 
tekhnetsyum [m] [def: technetium (Tc)] 
tekhnik [f] [def: technique; technology (subject)]
	tekhniker/S [m] [def: technician] 
	tekhnish/A [def: technical] umtekhnish/A [def: non-technical] 
		mnemotekhnish/A [def: mnemonic] [note: V]
	tekhnologye/S [f] [def: technology]
		tekhnolog/N [m] [def: tech] /Iish [def: technological] 
	te'khnikum/N [def: 2-year vocational school]
		pedte'khnikum/N [def: teacher's college] % Kulbak: Zelmenyaner
tekl/N [m] [def: tackle (position in American football)] [note: V]
teksi/S [m] [def: taxi] 
tekst/N [m] [def: text] 
teksti'l/N [m] [def: textile] 
	tkufesvayz{WkwfwTvayz} [adv] [def: according to epoch] % Forwards, Hershl Glezer
telebende/V/T [def: slip, fall, totter, wander (with "zikh")] % Stutchkoff
telefo'n/N [m] /Iish [def: telephone] /Dtelefond [def: mobile phone] 
	telefoni'r/V/Btelefoni'rt [def: call on the telephone] /Gon
	kvetsh-telefo'n/N [m] [def: touch-tone phone] 
	smartfon/N [m] [def: smartphone] % Forwards: S-R Schaechter
	tselfon/N [m] [def: cell phone] 
telegra'f/N [m] [def: telegraph] /Iish
	telegrafi'r/V/Btelegrafi'rt [def: send a telegram] 
telegrame/S [f] telegram/N [m] [def: telegram] 
teler/X/S [m] [def: plate; bowl] /D [def: saucer] 
	[idiom: dos telerl fun himl = impossible request]
teleskop/N/Iish [m] [def: telescope] 
teletse/S [f] [def: heifer (animal)]
televizye/S [f] [def: television] televizor/N [def: television] 
	fla'khekran-televizor/N [def: flat-screen television] [note: V] 
	kabl-televizye/S [f] [def: cable television] [note: V]
teluryum [m] [def: tellurium (Te)] 
tember/S [m] [def: timbre (music)]
teme/S [f] [def: theme, topic]
	tematik/N [f] [def: theme]
	hoyptteme/S [f] [def: main point] 
temne/A [def: dark, somber]
temp/V/T [def: dull] /Gop [def: temper] 
	temp/A tump/A tumpik/A [def: dull, blunt; dense]
	dump/A demp/A [def: quiet; dull]
		fardumpn/A fardumpt/A [def: dulled, quieted]
	demp/V/T [def: muffle, deaden (sound)] 
temperame'nt/N [m] [def: temperament] 
temperatu'r/N [f] [def: temperature] 
templ/N [m] [def: temple] /Dtemp
tempo/S [m] [def: tempo, pace] 
tende-verende/S [f] [def: frock, coat]
tende'nts/N [f] [def: tendency] 
	tendentsye'z/A [def: tendentious, partisan]
tendl/V/T [def: deal in second-hand goods] 
	tendler/S [m] te'ndlerin/S [f] [def: second-hand dealer] 
tener/X [m] [def: palm of hand]
tenis [m] [def: tennis (game)] 
tenor [m?] [def: tenor (musica)]
tentativ/A [def: tentative, provisional] 
teologye/S [f] [def: theology]
	te'olog/N [def: theologist] 
	teologish/A [def: theological] 
teorye/S [f] [def: theory]
	teoretiker/S [m] [def: theoretician] 
	teoretish/A [def: theoretical] 
teosofye/S [f] [def: theosophy]
tepe/V/T trepe/V/T tripe/V/T [def: wear out (with "zikh")]
	tsetepe/V/Btsetepet [def: wear out]
tepekh/Eer [m] [def: rug] /D
terapye/S [f] [def: therapy] 
	terape'vt/N [m] [def: therapist] /Iish [def: therapeutic] 
		terapevte/S [f] [def: therapist]
	khemoterapye/S [f] [def: chemotherapy] % Forwards: M-S Hoffman
	psykhoterapye/S [f] [def: psychotherapy] % Forwards
	[idiom: palyativ-terapye = palliative therapy] [note: V] 
	[idiom: linder-terapye = palliative therapy] [note: V] 
terase/S [f] [def: terrace] 
terbyum [m] [def: terbium (Tb)] 
teritorye/S [def: territory] teritorye'l/A [def: territorial] 
	teritoryali'st/N [m] [def: territorialist (Jews should have their own Yiddish-speaking country]]
	teritoryali'zm [m] [def: territorialism]
terkhe/V/T terkhen/V/T [def: muff, spoil; scrawl; have sex with (vulgar)]
termin/N [m] [def: term; deadline] /Iik
	da'khtermi'n/N [m] [def: general term]
	terminologye/S [f] [def: terminology] 
	terminologish/A [def: terminological] 
termi't/N [m] [def: termite (insect)] 
termometer/S [m] [def: thermometer] 
termos [m?] [def: thermos]
terne [f?] [def: some kind of cloth] % ?? what kind of cloth?  Der Nister
ternitshke [f?] [def: a sort of game (Polish)]
tero'r [m] [def: terror] 
	terorizi'r/V/Bterorizi'rt [def: terrorize]
	terori'st/N [m] teroristke/S [f] [def: terrorist] 
		teroristish/A [def: terroristic]
	terori'zm/N [m] [def: terrorism] 
terpenti'n [m] [def: turpentine]
terpke/A [def: sharp, tart] [grammar: may be left undeclined]
tertl-mertl [n] [def: a card game played with 36 cards]
tes/H [m/f] [def: letter tes] 
tese/V/T [def: hew] /Goys [def: hew up] 
	te'seve/V/T [def: hew] % Forwards: Boris Sandler
	[idiom: gey tese fleker = try to make sense of it]
test/N [m] [def: test] 
	bluttest/N [m] [def: blood test] % Forwards: Sholem Berger
	brusttest/N [m] [def: breast (cancer) screening] 
	lebertest/N [m] [def: liver test] % Forwards: Sholem Berger
	testir/V/Btestirt [def: test]
testame'nt/N [m] [def: testament (biblical)]
	testamenti'r/V/Btestamenti'rt [def: will (an inheritance)]
testasteron [m?] [def: testasterone (hormone)] % Forwards: Khane-Faygl Tertltoyb
te'stikl/N [m] [def: testicle (body part)]
teve{tBe}/H/S [f] [def: nature; character]
	/Lha{h} [noun] [f] [def: the nature]
	/Lbe{b} [adv] [def: by nature]
tevtonish/A [def: Teutonic (language family)]
tey/N [f/m] [def: tea]
	tey'ele/Ekh [def: tea bag; tea leaves (in plural)] % Yiddish League
	blu'mentey/N [f/m] [def: herbal tea] % Yiddish League
	gevi'rtsn-tey/N [f/m] [def: herbal tea] % Yiddish League
teye/V/T /Gon [def: derive pleasure] % Shpiglblat
teyg [n] [def: dough; batter] [morphology: no plural] /D
	honikteygl/Eekh [def: a sweet baked good]
	teygekhts/N [n] [def: shallow baked kugl (baked savory food) (NY)]
	zoyerteyg [n] [def: leaven] 
teykef{WyKf}/H [adv] [def: immediately; right away] /Idik
teyku{Wykw} [m?] [def: tie; undecidable question] % Stutchkoff
teyl/V/T [def: apportion; divide; share (with "zikh mit ... ")] /Goys/Gfunander/Gop/Gayn/Gmit/Gtsu
	tseteyl/V/Btseteylt [def: distribute; divide; separate]
		tseteylung [f] [def: distribution; division, partition, separation]
		tseteylevdik/A [def: divisable] umtseteylevdik/A [def: indivisable] 
		tseteylbar/A [def: divisable] [usage: inadmissible]
			umtseteylbar/A [def: indivisable] [usage: inadmissible]
		tseteyltkayt/N [f] [def: separation, division]
	bateyl/V/Bbateylt [def: distribute] 
	farteyl/V/Bfarteylt [def: distribute] 
	bateylik/V/Bbateylikt [def: participate (with "zikh in ...")]
		bateylikung/N [f] [def: participation] 
		bateylikter/S [m] mitbateylikter/S [m] [def: participant]
	fartilik/V/Bfartilikt [def: decimate, annihilate, exterminate, destroy]
		fartilikung/N [f] [def: destruction, annihilation] 
	teyl/N [m/f] [def: part] /Iik
		/Dteylekh [def: small part; affix (linguistics)]
		halbteyl/N [m/f] [def: half portion] % Forwards: Boris Sandler
		hi'ntertey'l/N [m/f] [def: buttocks] [usage: polite]
		teylung/N [f] [def: division (arithmetic)] 
		teyler/S [m] [def: denominator] 
		drayteylik/A [def: three-part] [def: usage: inadmissible] % Forwards: M-S Hoffman
		firteylik/A [def: four-part] [def: usage: inadmissible] % Forwards: M-S Hoffman
		unterteyl/N [m/f] [def: substituent (chemistry)] % Stephen Cohen
		[idiom: tsum teyl = partly]
	onteyl [m] [def: participation] onteylung/N [f] [def: participation] 
	opteyl/N [m] [def: division, department]
		opgeteyltkayt/N [f] opteylung/N [f] [def: division, department] 
		optey'levdik/A [def: divisible]
		[idiom: intensiver opteyl = intensiv-opteyl = intensive care (medical)] [note: V]
	oy'steylenish/N [n] [def: distribution] % Sholem Aleykhem
	bashtandteyl/N [m] [def: component]
	veltteyl/N [m] [def: part of the world] 
	teylvayz/A [def: partial] teylnvayz [adv] [def: bit by bit]
	merstnteyl/S [adv] meynstnteyl/S [adv] [def: for the most part] 
	urtl/N [m] [def: sentence] 
		farurtl{far#urtl}/V/Bfarurtlt{far#urtlt} [def: sentence, doom] 
			farurtlung/N [f] [def: sentencing; condemnation] 
		fo'rurtl{for#urtl}/N [m] forurteyl{for#urteyl}/N [m] [def: prejudice] 
		[idiom: hobn a forurtl = be prejudiced]
		urteyl/N [m] [def: sentence] [usage: doubtful admissibility]
			farurteylung/N [f] [def: sentencing; condemnation (judicial)] 	
			farurteyltkayt/N [f] [def: sentencing, condemnation (judicial)]
teyl_{Wl}/H [m] [def: ruin]
teyrets{Wyrwc}/Xteyrutsem{Wyrwcym}/H [m] [def: authoritative response; answer; solution; excuse; pretext]
teyt/V/T [def: kill] 
	toyt/A [def: dead]
	toyt/N [m] [def: death] /Ilekh
	toyterheyt [adv] [def: in death] 
	teytlekh/A [def: deadly; mortal]
	[idiom: zikher iz nor der toyt = don't take anything for granted] [note: V]
teytl/N [m/f] [def: date (food)] 
teyve__{tBe} [f] [def: nature]
	beteyve{btBe} [adv] [def: by nature, naturally]
	[idiom: iber der teyve__{tBe} = unnatural, disgusting]
teyve_{WBh}/Xteyves_{WBwT}/H [f] [def: ark; box]
teyves{tBT}/H [m] [def: Hebrew month of Teves]
teze/S [f] tezis/N [m] tez/N [m] [def: thesis; theme] 
tfile{Wfylh}/Xtfiles{WfylwT}/H [f] [def: prayer]
	bal_tfile{bel-Wfylh}/Xbaley_tfiles{bely-WfylwT}/H [m] [def: prayer leader]
	mispalel{mTpll}/Xmispalelem{mTpllym}/H [verb] [def: pray (with "zayn")] 
	tfilen{Wfylyn}/H [def: tefillin (religious wear)] % only in plural
	tifle_{Wyflh}/H/S [f] tifle/S [f] [def: church] % spelled both ways
tfise{Wfys|h}/Xtfises{WfyswT}/H [f] [def: prison] 
	ayngetfiset{ayngeWfys|ht}/A [def: imprisoned] % Rokhl Korn: shotns
tfutses{WfwcwT}/H [def: exile] 
tif/K [def: deep]
	ti'fenish/N [n] [def: deep place] tifkayt/N [f] [def: depth] 
	fartif/V/Bfartift [def: immerse; engross; delve into (with zikh)]
		fartifung/N [f] [def: depression, dip, recess] 
	fartifer/V/Bfartifert [def: deepen] 
		fartiferung/N [f] [def: deepening] 
	tif/V/T /Garayn [def: be involved in (with "zikh")
tiferes{WfrT}/H [def: beauty] 
tifus [m] [def: typhus (disease)] 
	boykh-tifus [m] [def: typhoid (disease)]
tiger/S [m] [def: tiger] 
tik [def: tick (sound of a clock)]
	tak [def: tock (sound of a clock)]
	tik-tak [def: tick-tock] 
tiken{Wykwn}/Xtikunem{Wykwnym}/H [m] [def: repair, improvement; shot of liquor] 
	takone{Wknh}/Xtakones{WknwT}/H [f] [def: correction] 
	mesaken{mTkn} [verb] [def: repair (with "zayn")]
	[idiom: trinken tiken{Wykwn} = take a drink of shnapps at a yortsayt (Khasidic)]
tiket/N [def: ticket (English)] 
tikhtik/A [def: active; hard-working] tikhtikayt/N [f] [def: activity]
tilem{Whylym}/H/D [def: Psalms; book of Psalms] 
tilik/Xtilkes [m] [def: heel or back (of shoe); rump, buttocks; abdomen]
timyan [m] [def: thyme (herb)]
tinef{tynwf}/H [m] [def: excrement; low quality substance]
tink [m/f] [def: plaster] 
	tinker/S [m] [def: plasterer]
	ti'nkeve/V/T [def: plaster] /Goys
		ti'nkever/S [m] [def: plasterer]
tint/N [f] [def: ink] 
	tinter/S/D [m] [def: inkwell] 
	tintl/V/T [def: scrawl, scribble (pejorative)] /Gon
		tintler/S [m] tentler/S [m] [def: scribbler] 
tip/N [m] [def: type; type of person] /Iish
	stereotip/N [m] [def: stereotype] /Iish [def: stereotypic] 
	[idiom: atletisher tip = jock] [note: V] 
tipesh{typS}/Xtiphsem{typSym}/H [m] tipshe{typSh}/Xtipshes{typSwT} [f] [def: fool]
	tipshes{typSwT}/H [f] [def: foolishness] 
	tipsheva't/A [def: stupid] 
tipografye/S [def: lithography (printing); printing shop]
	khromotipografye/S [def: color printing]
	stereotipografye/S [def: stereo printing]
	fototipografye/S [def: photo printing]
tir/N/D [f] [def: door]
	droysntir/N [f] [def: outside door] 
	hintertir/N [f] [def: back door] 
	khaptirl/Eekh [n] [def: trap door]
	kikhtir/N [f] [def: kitchen door]
	ku'petir/N [f] [def: (train) compartment door] % Bergelson: Yosef Shur
	paradtir/N [f] [def: street door] 
	shpi'gltir/N [f] [def: door with a mirror ??] % Bergelson
	u'ntertir/N [f] [def: lower door]
	[idiom: fun tir tsu tir = door to door]
tir [m?] [def: wild animal] [usage: not recommended]
	murmltir [m?] [def: marmot (animal)] [usage: not recommended]
	vizltir [m?] [def: bison, buffalo, water buffalo (animal)]
tira'n/N [m] [def: tyrant] /Iish
	tiranye/S [f] [def: tyrrany] 
tirazh/N [m] [def: circulation (journal), drawing (lottery)] 
tire/N [n/m] [def: dash, hyphen (typography)]
tiref{tyrwf} [m] [def: frenzy, delirium, craziness] /Idik
tirkhe{tyrHh}/Xtirkhes{tyrHwT}/H [f] [def: effort, trouble] 
tish/N/D [m] [def: table]
	arbettish/N/D [def: work table] % Forwards: S-R Schaechter
	estish/N/D [m] [def: dining-room table] 
	kikhtish/N [m] [def: kitchen table]
	la'dntish/N [m] [def: (store) counter]
	nakhttish/N/D [m] [def: nightstand] 
	shraybtish/N/D [m] [def: writing desk] 
	shpiltish/N [m] [def: gaming table] % Avrom Karpinovitsh
	verktish/N [m] [def: work table]
	vashtish/N [m] [def: sink] /D % Sholem Aleykhem
	tishleray'/N [f] [def: table-making business]
	[idiom: tokhes{WHwT} afn tish = getting down to business (vulgar)]
tishboyres{WSbwrT}/H [n/f] [def: fractions (mathematics)]
tishe/V/T /Gon [def: enjoy (with "in" or "mit")
tishebov{WSeh-boB}/H [m] [def: commemorative day of the Ninth of Av] 
tishri{WSry}/H [m] [def: Hebrew month of Tishri] 
tishtshe [f?] [def: thousand (Russian тысяча)]
titanyum [m] [def: titanium (Ti)] 
titl/N/S [m] [def: title]
	u'nterti'tl/N [m] [def: subtitle (film, text)]
	batitl/V/Bbatitlt [def: title, name]
	ontitldik/A [def: untitled] 
	tituli'r/V/Btituli'rt [def: title] 
titshe/V/T [def: point (finger); poke; urge on]
titu'n [m] [def: tobacco (for smoking)] 
tizlik/Ees [m] [def: short coat, vest (clothing)]
tkheyles{WxylT}/H [m?] [def: purple] /Idik
tkhiles{WHylT}/H [def: outset, first of all] /Idik [def: primitive; original]
	lekhatkhile{lxWHylh}/H [def: before the fact, a priori] /Idik
	haskhole{hTHlh}/Xhaskholes{hTHlwT}/H [def: beginning] 
tkhine{WHynh}/Xtkhines{WHynwT}/H [f] [def: women's prayer] 
tkhiye{Whyh}/H [def: rebirth]
	tkhiyas{WHyT}/H [def: rebirth of] 
tkhoyr/N [m] [def: skunk (Mephitis spp.), polecat (Mustela spp.); coward] /In
	[idiom: shtubiker tkhoyr = European ferret]
tkhum{WHwm}/H [m] [def: Sabbath boundary] 
	tkum-hamoyshev{WHwm-hmwSB} [m] [def: Pale of Settlement]
tkiye{Wkyeh} [f] [def: long blast of the shofar]
tkufe{Wkwfh}/Xtkufes{WkwfwT}/H [f] [def: season (of year)] 
tlie/V/T [def: smolder; glow (with "zikh")] 
tlik/Ees [m] [def: stroke, blow; strumpet, slut; prostitute]
	tlike/V/T [def: knock, make noise]
tlise/V/T [def: trot] /Gavek/Garayn/Gtsu/Gtsurik/Garop
tliye_{Wlyh}/Xtliyes{WlywT}/H [f] [def: gallow]
	talyen{Wlyn}/Xtalyonem{Wlynym}/H [def: hangman] 
	tole{WlO}/H [m] [def: Jesus (disrespectful)]
		[idiom: oyfhengen oyf zikh dem tole{WlO} = overadorn oneself]
		[idiom: tole{WlO} hot dos mazl{mzl} = non-Jews have all the luck]
	tole{WlO} [adj] [def: depending on (with "oyf")] [usage: indeclinable]
tlo/N [f] klo/N [f?] [def: hoof] 
tlumik/Ees [m] /D klumik/Ees [m] [def: bundle] 
tnay{Wna|y}/Xtnoyem{Wno|ym}/H [def: condition; engagement agreement (plural)] 
	bitnay{bWna|y} [adv] [def: conditional] 
	[idiom: shraybn tnoyem{Wno|ym} = get engaged]
tnue{Wnweh}/Xtnues{WnwewT}/H [f] [def: gesture] 
to [def: so]
toes{tewT}/H/N/D [m] [def: error, mistake] 
	toye{tweh} [verb] [def: err (with "zikh") (with "zayn")] 
	[idiom: mekekh-toes{mkH-tewT} = sale at the wrong price]
	[idiom: oylem{ewlm} hatoye{htewh} = limbo] % ?? spelling
tof{Wʼ}/H [m/f] [def: Hebrew letter Tof] 
tog/Xteg [m] [def: day]
	/Iik /Ilekh [def: daylike]
	teglekh/A [def: daily] togteglekh/A [def: daily; ordinary]
		togteglekhkayt/N [f] [def: mundaneness, ordinariness]
	tegvayz [adv] [def: every day] % Sholem Aleykhem
	mitog [m] [def: noon] mitogs [def: lunch]
		frishtik-mitog [m] [def: brunch]  [note: V]
	baytog/N [def: by day] /Iik /Iedik [def: by day] 
	danktog [def: Thanksgiving (American holiday)] 
	farakhtogn [adv] [def: a week ago]
	farmitog/N [m] [def: morning] 
	fartog/S [m] [def: dawn] /Iik [def: dawning] 
		fartogedik/A [def: early morning] % Sholem Aleykhem
	geboyrntog/Xgeboyrnteg geburt|stog/Xgeburt|steg [m] [def: birthday] % Harduf
	halbtog/N [m] [def: mid-day, noon] /Iik
	harbsttog/N [m] [def: Autumn day]
	haynttsutog [def: these days] 
	iberakhttog iberakhttogn [def: in a week] 
	marktog/Xmarkteg [m] [def: market day] 
	nokhmitog/N [m] [def: afternoon]
	o'ndenktog/N [m] [def: memorial day] % Forwards: S-R Schaechter
	oyftog/Xoyfteg [m] [def: daybreak] 
	shturemtog/Xshturemteg [m] [def: stormy day]
	vintertog/Xvinterteg [m] [def: winter day] 
	voyltog/Xvoylteg [m] [def: festival, holiday; pleasure]
		shvoyltog [m] [def: luxury, conspicuous consumption (ironic)]
	yortog/Xyorteg [m] [def: anniversary] 
	zumertog/Xzumerteg [m] [def: summer day] 
	tog/V/T [def: become day, dawn]
	alteglekh/A [def: ordinary]
		alteglekhkayt/N [f] [def: ordinariness, banality]
	[idiom: halber tog = midday]
	[idiom: heler tog = broad daylight]
	[idiom: a nekhtiker tog = it won't work; nonsense; impossibility]
tok/V/T [def: turn on a lathe, fashion] /Goys/Gop
	toker/S [m] [def: woodworker (occupation)]
	[idiom: oysgetokte fis = shapely legs]
tokh{Wwx}/H [m] [def: contents] /Iik
	toykhn{Wwxn}/H [def: contents]
	besoykhem{bTwxm}/H [def: included]
tokhes{WHT}/N/Xtekheser{WHTer} [m] [def: rear end (vulgar), buttocks] /Dtekhes{WHT}
	takhtoynem{WHWwnym}/H [def: underwear] [grammar: only in plural]
	[idiom: tokhes{WHT} leker = sycophant (vulgar)]
	[idiom: kush mir in tokhes{WHT} = kiss my ass (vulgar)]
tokhter/Xtekhter [f] [def: daughter] /Dtekhter
	to'khtershi [f] [def: dear daughter] % Stutchkoff
	brudern-tokhter/Xbrudern-tekhter [f] [def: niece] 
	[idiom: yidishe tokhter = Jewish woman]
tol/N/Xteler [m] [def: valley] /Dtolkh [def: dale] 
	to'leke/S [f] [def: meadow, pasture] 
	do'lene/S [f] [def: small valley; depression in the ground] 
toleri'r/V/Btoleri'rt [def: tolerate]
	tolera'nts [f] [def: tolerance] 
		u'mtolera'nts [f] [def: intolerance]
	tolera'nt/A [def: tolerant]
		u'mtolera'nt/A [def: intolerant]
tolk/N [m] [def: order; sense] [usage: with "dergeyn"] /Iik [def: coherent, sensible]
	to'lkeve/V/T /Gayn/Garayn [def: teach]
tom{Whwm}/N [m] [def: void]
toma't/N [m] [def: tomato (vegetable)] 
tome{tm#}/Xtemeyem{tm#ym}/H [m] [def: ritually unfit] /Idik /In
	metame{mtm#}/H [verb] [def: render ritually unfit (with "zayn")] 
	tume{twm#h}/Xtumes{twm#wT}/H [f] [def: ritual unfitness; church (pejorative)] 
		-/Xshmoys_hatume{SmwT-htwm#h} [def: demonic names (mystic)]
		[idiom: m″t shayre_tume{Sery-twm#h} = source of ritual unfitness]
tomed{Wmyd}/H [def: always] 
	masmed{mTmyd}/Xmasmidem{mTmydym}/H [def: dedicated student] 
	hasmode{hTmdh}/Xhasmodes{hTmdwT}/H [def: dedication; diligence]
tomer [def: perhaps; lest; if perchance; in case] % Borokhov derives from {Wwmr}
ton/Xtener [m] [def: tone] 
	baton/V/Bbatont [def: sound; opine; accentuate] 
		batonung/N [def: accent]
	tonatsye/S [f] [def: key (musical)]
	intonatsye/S [f] [def: intonation, accent]
	eyntonik/A [def: monotone; monotonous]
		eyntonikayt/N [f] [def: monotony]
	monoton/A [def: monotone]
	oyberton/Xoybertener [m] [def: overtone, meaning]
ton/N [m] [def: ton (weight)] 
tones{WenyT}/Xtaneysem{WenyTym}/H [m] [def: fast (religious)]
	ester_tones{#sTr-WenyT} [f?] [def: Fast of Esther]
top/Xtep [m] [def: pot] /Dtep
	blumentop/Xblumentep [m] [def: flower pot] 
	lokshntop/Xlokshntep [m] [def: stew pot] /Dlokshntep [def: silly person]
	shmeltstop/Xshmeltstep [m] [def: melting pot] 
	mesttepl/Eekh [n] [def: measuring cup] 
	teper/S [m] [def: potter] 
	[idiom: kukn in yenems top = get involved in someone else's business]
topl/V/T [def: double]
	topl/A [def: double]
		topldik/A [def: double] % Forwards: Krutikov
		dopl/A [def: double] [usage: inadmissible]
		doplt/A [def: double] [usage: inadmissible]
		toplt/A [def: double] [usage: inadmissible]
	fartopl/V/Bfartoplt [def: double]
topol/N topolye/S [f] [def: poplar (tree)]
topologye/S [f] [def: topology (mathematics)] % Forwards: Yoel Matveyev
toponimik [f] [def: toponimics, place names] % Forwards: Genadi Estraykh
	toponomish/A [def: toponomical]
	toponim/N [m?] [def: toponym, place name]
toptshe/V/T [def: plod, trudge; tread; stamp (feet); wade (with "zikh")]
	/Gavek/Gtsu
topye/V/T [def: melt; sink; inundate] /Gon
tor/V/T [def: ought; be allowed] [grammar: only in negative constructions]
torbe/S [f] [def: sack; beggar's bag] 
tore/V/T torke/V/T turke/V/T shtorkhe/V/T shtorke/V/T [def: jab; annoy, badger] 
	fartoret/A [def: annoyed]
	farturke/V/Bfarturket [def: jab]
	[idiom: ton a tore = nudge]
tore_{thrh}/H [f] [def: purity, ritual fitness; ritual of purification] 
	toras{thrT} [def: ritual fitness of]
		toras_hamishpokhe{thrT-hmSpHh} [f] [def: observance of menstrual taboos]
	tor_{thwr}/H [def: ritually fit] 
tored{trwd} [adj] [def: busy]
torf [noun] [def: turf, peat] 
torg/Ees [def: market, fair; auction; buying and selling]
	to'rgeve/V/T [def: trade; do business; bargain (with "zikh")]
	torgovoy [adj] [def: trade (Russian торговой)] [grammar: indeclinable]
torkl/V/T [def: coo (sound of a dove)] % Harduf
tormoz/N [m] [def: brake (automotive)]
tornado/S [m] [def: tornado] 
torpede/S [f] [def: torpedo] 
tort/N [m] [def: cake] /Dtert
toryum [m] [def: thorium (Th)] 
tost/N [m] [def: toast (celebratory)] 
total/A [def: entire]
	totalita'r/A totalitaristish/A [def: totalitarian]
toter/N [m] [def: Tatar; quack doctor; fortune teller] /Ish /Iish 
	toterish [n] [def: gibberish, Tatar language] 
	taterke/S [f] [def: buckwheat porridge] % Stutchkoff
	[idiom: hobn a harts fun a toter = be unfeeling]
totshe/V/T [def: nag; sharpen]
	/Garoys [def: slip out (with "zikh")]
tov{twB}/H [def: good]
	tuv{twB}/H [def: goodness] 
	letoyvas{ltwBT} [prep] [def: for the sake of] 
tov_{Wv}/H [def: Hebrew letter Tov]
tove/S [f] [def: frying pan] % Forwards: Boris Sandler
tovl/N [m] [def: board; hard book cover] /Dtov
	tevele/Ekh [def: slab; card of needles (with "nodlen")] 
	tovl/V/T /Gayn [def: bind (book)]
	meldtovl/N [m] [def: bulletin board] 
	ondenktovl/N [m] [def: plaque] [note: V]
	batovlt/A [def: hard-covered (book)]
toy/N [m] [def: dew] 
toyb/A [def: deaf] /Ilekh
	toybkayt/N [f] toyblekhkayt/N [f] [def: deafness] 
		batoybtkayt/N [f] [def: induced deafness]
	batoyb/V/Bbatoybt fartoyb/V/Bfartoybt [def: deafen] 
toyb/N [f] [def: pigeon, dove] /Dtayb [def: little dove; darling, sweetie]
	ringltoyb/N [f] [def: trapping pigeon] 
toyevoye{Wwhu-|uBwhu} [m] [def: chaos, pandemonium]
	[idiom: mitn kop in oylem_hatoye{ewlm-hWwhu} = absent minded] % Stutchkoff
toyer/N [m] [def: gate; goal (sport)] 
	shultoyer/N [m] [def: school gate]
toyf/V/T [def: baptize] 
toyfes{Wwfs}/H [def: holding]
	tafsn{Wfsn}/Xtafsonem{Wfsnym} [m] [def: jailor, turnkey]
toyg/V/T [def: suit, be of use; be good for] 
	/Goys [def: have expertise (with "zikh")]
	toy'gevdik/A [def: fit, useful; convenient]
	toy'genikhts/N [m] [def: useless person]
toykh/V/T [def: plunge; immerse oneself]
	/Goyf [def: rise to the surface]
toy'khekhe{WwHHh}/Xtoy'khekhes{WwHHwT}/H [def: curse] 
toyre{Wwrh}/Xtoyres{WwrwT}/H [f] [def: tradition]
	/Lha{h} [noun] [f] [def: the Torah] /D
	din_toyre{dyn-Wwrh}/S [m] [def: judicial case (religous)]
	dvar_toyre{dBr-Wwrh}/S [m] [def: homily, sermon]
	matn_toyre{mWn-Wwrh}/H [m] [def: God's presenting the Torah to the Jews]
	seyfer{sfr}-toyre{Wwrh} [def: scroll of the Law] 
	talmetoyre{Wlmwd-Wwrh}/H [f] [def: grammar school (religious)] 
	[idiom: sisrey{sTry} toyre{Wwrh} = hidden depths of the Jewish law]
	[idiom: gedoyley{gdwly} toyre{Wwrh} = Jewish sages]
	[idiom: yevonishe{yvnishe} toyre{Wwrh} = filthy language, usually in Russian] % Michael Wex
toysfes{WwsfwT}/H [def: Tosafists: Talmudic commentators] 
toysh/V/T [def: exchange; change (with "zikh")] /Goys
	oystoysh/N [m] [def: exchange] 
	fartoysh/V/Bfartoysht [def: exchange; permute] 
toytshe/V/T [def: buzz around; cook]
toyve{twBh}/Xtoyves{twBwT}/H [f] [def: goodness, favor]
	/Lle{l} [adv] [def: for the good]
	toyv{twB}/Xtoyvem{twBym} [adj] [def: good] /Lha{h} [noun] [f?] [def: the good]
		evn_toyv{#Bn-twB}/Xavonem_toyves{aBnym-tuBuT} [m] [def: gem, jewel]
	toyves{twBwT}/H [def: favors] 
	tov{twB}/H [def: good]
	tuv{twB}/H [def: goodness] 
	mazl_tov{mzl-twB} [interj] [def: congratulations] 
	gam_zu_letoyvenik{gm-zw-ltwBhnik}/Ees [m] [def: optimist]
toyvl{twBl}/H/V/T [def: ritually immerse; dunk]
	tvile{tBylh}/Xtviles{tBylwT}/H [f] [def: ritual immersion] 
toyz/Xtayz [m] [def: ace (playing cards)] 
	[idom: boyen af fir tayz = be very hopeful]
toyznt/N/Eer [d] [def: thousand] /A
	toyznterley [adj] [def: thousands of]
	yortoyznt/Eer [m] [def: millenium] 
toz/N [m] [def: board of health (Poland)] 
	oze/S [f] [def: board of health (Russia)] 
trakhome/S [f] [def: trachoma (disease; Chlamydia trachomatis)]
	trakhomatish/A [def: trachomatic]
traditsye/S [f] [def: tradition]
	traditsyone'l/K [def: traditional] 
	umtraditsyone'l/A [def: untraditional] % Forwards
traf/N [m] [def: accent; syllable; random event] 
	[idiom: oyf (blindn) traf = in random order, at random]
	[idiom: durkh a traf = by chance]
tragedye/S [f] [def: tragedy]
	tragik [f] [def: tragedy] % Forwards: Gershn Vayner
	tragish/A [def: tragic] tra'gishkayt/N [f] [def: tragedy]
trakhke/V/T trakhe/V/T [def: make a racket] 
	trakh/N [m] trakhe/S [f] [def: collision, crash: sound of breaking] 
		trakh [interj] [def: bang!, crash!]
trakht/V/T [def: think; plan] /Garayn/Gdurkh/Giber/Gtsu
	/Goys [def: invent; conclude] 
	batrakht/V/Bbatrakht [def: consider; examine]
		batrakht [m] batrakhtung/N [f] [def: consideration; examination]
			guf{gwf}-batrakhtung/N [f] [def: physical examination] 
		[idiom: nemen in batrakht = take under advisement]
		[idiom: dos kumt nit in batrakht = that doesn't count!]
	fartrakht/V/Bfartrakht [def: ponder]
		fartrakhterheyt [adv] [def: deep in thought] 
		fartrakhtkayt/N [f] [def: state of being deep in thought]
	dertrakht/V/Bdertrakht [def: come to the conclusion that (with "zikh tsu")]
	trakht/N [f] [def: thought]
		[idiom: a trakht ton = give a thought]
	trakhtung/N [f] [def: thinking] tra'khtenish/N [n] 
	oystra'khtenish/N [n] [def: invention] 
	nidertrekhtik/A [def: base, vile] 
		nidertrekhtikayt/N [f] [def: baseness, vileness] % Forwards: M-S Hoffman
	[idiom: zolst nit ibertrakhtn = don't worry; never mind]
trakht/N [f] mutertrakht/N [f] [def: uterus, womb]
	umtra'khterin/S [f] [def: barren woman] % Bashevis
trakt/N [m] [def: dirt road; highway]
trakta't/N [m] [def: tractate, volume; subject]
trakti'r/V/Btrakti'rt [def: treat; handle]
trakti'r/N [m] [def: tavern; inn]
traktor/N [m] [def: tractor] 
trampl/V/T [def: walk, pace]
trampoli'n/N [m] [def: trampoline] 
tramvay'/N [m] [def: tram, trolley car, streetcar]
transferi'r/V/Btransferi'rt [def: transfer] 
	transfer/N [def: transfer] 
transhey/N/Ees [m] transhee/S [f] [def: trench, ditch]
transistor/N [m] [def: transistor] 
transkribi'r/V/Btranskribi'rt [def: transcribe] 
	transkri'pt/N [m] [def: transcript] % Yiddish League
	transkriptsye/S [f] [def: transciption]
	transkribirterheyt [adv] [def: in transcription]
	transkribirer/S [m] [def: transcriber] 
transliteri'r/V/Btransliteri'rt [def: transliterate]
	transliteratsye/S [f] [def: transliteration] 
transmiti'r/V/Btransmiti'rt [def: transmit] 
	transmisye/S [def: transmission]
transpara'nt/N [m] [def: transparency (paper)]
transporti'r/V/Btransporti'rt [def: transport] /Gop
	transport/N [m] [def: transport; shipment] 
	transportatsye/S [f] [def: relocation, transportation]
trante/S [f] [def: rag; junk (figurative)]
tranzit [m?] [def: transit; repatriation]
traske/V/T [def: hit] /Garop/Gariber
	trask/N/Ees [m] tryastse/S [f] [def: blow; bang, crash] 
	fartraske/V/Bfartrasket [def: hit] 
	tsetraske/V/Btsetrasket [def: beat into pieces] 
	[idiom: endikn mit a trask = finish with a bang]
travesti'r/V/Btravesti'rt [def: cross-dress, dress in drag] [note: V]
	travestirer/S [m] travesti'rerke/S [f] [def: cross-dresser, transvestite] 
travestye/S [f] [def: farce, travesty]
travme/S [f] [def: wound, trauma] 
	travmatish/A [f] [def: traumatic] 
	travmatizi'r/V/Btravmatizi'rt [def: traumatize] % Forwards
tray/A [def: true, trusty; faithful] getray/A [def: faithful] 
	trayshaft/N [f] getrayshaft/N [f] getraykayt/N [f] trayhayt/N [f] [def: trustworthiness, faithfulness]
	getroy'/V/Bgetroy't [def: trust] /Gon/Goys
	fartroy'/V/Bfartroy't [def: entrust] /Gon
		fartroylekh/A [def: trustworthy] 
	tsutroy [m] tsutroyen [m] [def: trust in (with "tsu"), reliance on (with "tsu")] 
		umtsutroy [m] [def: distrust, lack of confidence (to) (with "tsu")]
		zikh-tsutroy [m] [def: self confidence] 
trayb/V/Bgetribn [def: drive] /Gavek/Giber/Gdurkh/Garayn/Garum/Garoys/Gunter/Gtsu
	/Garoys [def: drive out, exorcise]
	/Gop [def: cause an abortion; abort]
	/Gon [def: urge; drive (horses); round up; supply power; inspire]
	batrayb/V/Bbatribn [def: drive] 
	fartrayb/V/Bfartribn [def: drive; expell] 
		tsaytfartrayb/N [m] [def: game, amusement]
	dertrayb/V/Bdertribn [def: drive to a conclusion] 
	tsetrayb/V/Btsetribn [def: drive] 
	trayber/S [m] ontrayber/S [m] [def: animal driver] 
		aroy'stray'ber/S [m] [def: exorcist] 
		may'zntray'ber/S [m] [def: exterminator] % Sholem Aleykhem
	traybenish/N [f] [def: expulsion] % Sholem Aleykhem
	getray'b/N [m] [def: (automotive) drive] [note: V]
trayber/V/T /Goys tsetrayber/V/Btsetraybert [def: remove certain veins from the hindquarters of animals as part of making kosher]
traybl/N [n] [def: telephone receiver; speaking tube]
tref/V/Bgetrofn [def: find, meet; guess; happen, occur (with "zikh")]
	/Gtsuzamen/Garayn/Gop
	/Gon [def: meet by chance, bump into (with "zikh mit" or "zikh oyf")]
	treflekh/A [def: clever]
	trefik/A [def: pertinent]
	batref/V/Bbatrofn [def: amount to]
		/Gon [def: meet] onbatref/N [def: meeting] 
		batref/N [m] [def: sum, value, importance, significance] 
		[idiom: hobn a batref = count]
	trefer [m] [def: finder]
	trefung/N [f] tre'fenish/N [n] [def: meeting, encounter]
	tsuzamentref/N [m] [def: meeting]
	ontre'fenish/N [f] [def: chance meeting]
tre'molo/S [m] [def: tremolo (musical)]
tre'mpeve/V/T [def: tramp; hitsh rides]
	tremp/N [m] [def: tramp, hobo]
	[idiom: khapn a tremp = hitchhike] [note: V] 
tren/V/T [def: rip out; fornicate (taboo)] /Goyf/Gop
	tsetren/V/Btsetrent [def: unravel (with "zikh")] % Avrom Karpinovitsh
treni'r/V/Btreni'rt [def: train] 
	trenirer/S [def: trainer] 
	trenirung/N [f] [def: training]
trep/X/D [f] [def: stair] /Iik [def: stairwise]
	fayertrep/X [f] [def: fire-escape stair] 
trer/N [f] [def: tear] /D
	fartrert/A [def: teary]
	-/Xtsibele-trern -/Xkrokodil-trern [def: crocodile tears]
treshtshe/V/T troshtshe/V/T [def: creak]
	treshtsh/N [m] [def: creak]
	tsetreshtshe/V/Btsetreshtshet [def: smash (glass)] % Avrom Karpinovitsh
tret/V/Bgetrotn [def: step; tread]
	/Garayn/Gariber/Giber/Goyf/Gtsu/Gon/Goys/Gayn/Garoyf/Gforoys/Garop
	/Garoys [def: appear for the purpose presenting a speech] 
	/Gop [def: retreat]
	aroystret/N [m] aroystretung/N [f] [def: revolt; upset]
	fartret/V/Bfartrotn [def: represent]
		fartreter/S [m] [def: representative] 
		fartretung/N [f] [def: representation] 
	tsetret/V/Btsetrotn [def: trample]
	batret/V/Bbatrotn [def: tread, set foot on]
	trot/Xtrit/N [m] [def: step, pace] 
		optrot/N [m] [def: withdrawal, retreat] 
	trit/X/D [m] [def: footstep] 
		arayntrit/X [m] ayntrit/X [m] [def: entrance; entrée]
		aroystrit/X [m] [def: public speaking appearance]
		fustrit/X [m] [def: footstep] 
		foroystrit/X [m] [def: advance]
		oyftrit/X [m] [def: appearance (performance); opening (performance)] 
		tsutrit/X [m] [def: approach; access] /Ilekh [def: approachable; accessible] 
		tritvayz/A [def: step-by-step, gradual]
	treter/S [m] [def: stirrup; pedal; doormat, runner] % J. Opatoshu: lintsheray: stirrup
	o'ptret/N optrit/N [m] [def: retreat; toilet facility] 
		[idiom: o'ptret gelt = legal bribe; monetary incentive]
		[idiom: optretn emetsn dem veg = yield] % Yiddish League
	trotua'r/N [m] [def: sidewalk] 
trevoge/S [f] [def: alarm, outcry]
treyf/A/Ien [def: non-kosher] % usually not in Hebraic spelling
	treyfe_{tryfh} treyf_{tryf} 
	meturef{mtwrf}/Xmeturofem{mtwrfym}/H [m] [def: crazy or confused man] 
		meturefes{mtwrfT}/Xmeturefesn{mtwrfTn} [f] meturfe{mtwrfe}/Xmeturfes{mtwrfes} [f] [def: crazy woman] % meturfe: Kulbak: Zelmenyaner
		meturefdik{mtwrfdik}/A [def: crazy, confused] 
	treyfnyak/S [m] [def: unkosher person] % loses Hebraic spelling
	treyfenik{tryfhnik}/Ees trefenitse{tryfhnitse}/S [def: unkosher person]
	tarfes{trfwT} [f] treyfes{tryfwT} [def: unkosher food]
	fartreyf/V/Bfartreyft [def: falsify, render unfit] 
		fartreyfung/N [f] [def: falsification, unkosher mixture] 
treysl/V/T [def: quiver; shake] /Goyf/Gop/Garop/Garoys/Giber
	/Goys [def: clean by shaking; dispossess (with "bay")]
	tsetreysl/V/Btsetreyslt [def: upset] 
		treyslenish/N [n] tsetreyslung/N [f] [def: agitation]
treyst/V/T [def: comfort, console] 
	treyst/N [f] [def: comfort, consolation]
	treyster/S [m] [def: comforter] 
trib/K [def: dismal, gloomy; sorrowful]
	tribkayt/N [f] [def: sorrow] 
	tribe [def: sorrow] 
tribun/N [m] [def: tribune (person)] 
tribune/S [f] [def: daïs, grandstand] 
trif/V/T [def: drip; fester (wound)] /Garunter/Gavek/Garop/Gon
	/Gdurkh/Gadurkh [def: percolate]
	durkhtrifung/N [f] [def: percolation]
	triflke/S [f] [def: icicle]
	triper/S [m] trifer/S [m] [def: gonorrhea (disease)]
	tropn/S [m] [def: drop] /D
		tropnvayz/A [def: drop by drop]
		regntropn/S [m] [def: raindrop] 
		[idiom: biterer tropn = hard liquor]
trigonometrye [f] [def: trigonometry (mathematics)]
trik-trak [m?] [def: trictrac (game like backgammon)] % Sholem Aleykhem
trikn/V/T [def: dry] /Goys/Goyf/Gayn/Gdurkh/Gtsu
	fartrikn/V/Bfartriknt [def: dry] 
	trukn/A [def: dry] /Ktrikn
	truknkayt/N [f] tri'kenish/N [f] [def: dryness; drought] 
	trikener/S [m] [def: (clothes) dryer] [note: V]
triko'/N [m] [def: tricot (fabric); vest; pair of tights; knitwear industry]
	trikota'zh [m] [def: knitwear]
tril/V/T [def: coo (sound of a dove); to fool] 
	triler/V/T [def: chirp, warble (sound of a bird)]
	trel/N [m?] [def: trill, warble]
trilyo'n/N [m?] [def: trillion]
trink/V/Bgetrunken [def: drink; drown (with "zikh")] /Goys/Gop
	/Gon [def: drink a lot (with "zikh")]
		ongetrunkent/K [def: drunk]
	fartrink/V/Bfartrunken fartrenk/V/Bfartrenken [def: serve a drink; flood] 
	dertrink/V/Bdertrunken dertrenk/V/Bdertrenkt/Bdertronken [def: drown] 
		dertrinkenish/N [n] [def: flood; drowning]
	trunk/N [m] [def: drink] getra'nk/N [n] [def: drink, beverage] 
		fru'khtgetra'nk/N [n] [def: fruit beverage]
	batrunken/A [def: drunk, intoxicated]
	trinker/S [m] [def: drinker]
	trinkal [m?] [def: tip, gratuity (to a worker)] % Stutchkoff
trishak [def: gleek (card game)]
trishtshe/V/T [def: make a breaking sound]
tritsiklet/N [def: tricycle; rickshaw] % Esther Kraytman: Briliantn
trityum [m?] [def: tritium (³H)] % Forwards: Yoel Matveyev
trivalne/A [def: serious; steady]
trivya'l/A [def: trivial, silly, banal]
tryumfi'r/V/Btryumfi'rt [def: triumph]
	tryumf/N [m] [def: triumph]
	tryumfali'zm/N [m] [def: triumphalism] % Forwards
trog/V/T/Bgetrogn [def: carry; be pregnant]
	% both participles exist, getrogn is dominant
	/Garayn/Garoys/Garum/Gdurkh/Gop/Gtsu/Garop
	/Gtsunoyf/Gantkegn/Garoyf/Gtsurik/Gmit
	/Gariber [def: derive]
	/Gavek [def: carry away, run about (with "zikh")] 
	/Gbay [def: increase, add onto; contribute]
	/Giber [def: bear; tolerate]
	/Gon [def: deliver]
	/Goyf [def: annoy, anger]
	/Goys [def: afford]
	/Gunter [def: anger]
	dertrog/V/Bdertrogn [def: bear] dertreglekh/A [def: bearable] 
		umdertreglekh/A [def: unbearable]
	fartrog/V/Bfartrogn [def: carry away, bear, tolerate]
		fartrogn/A [def: absent-minded, unconscious] 
		fartrognkayt/N [def: absent-mindedness]
	tsetrog/V/Btsetrogn [def: upset]
		tsetrognkayt/N [f] [def: agitation, disturbance] 
	ibertreglekh/A [def: bearable] 
	baytrog/N [m] [def: addition, contribution]
	troger/S [m] [def: bearer] treger/S [m] [def: porter] /Iish tre'gerin/S [f] [def: carrier (female)]
		brivtreger/S brivntreger/S [def: mailman] 
		pakntreger/S [def: itinerant salesman, peddler]
		potshttreger/S [m] [def: letter carrier, mailman]
		vasertreger/S [m] [def: water carrier] 
	trogedik/A [def: pregnant]
	firtrog/N [m] fortrog/N [m] [def: speech; testimony]
	[idiom: es trogt mit ... = it smells of ...]
	[idiom: oyf aroystsutrogn = take-out (food)]
tro|ike/S [f] [def: group of three leaders (Russian тройке)]
trok/V/T [def: complain] % ?? Karpinovitsh
	[idiom: hern im in trok = make nothing of his opinion]
trold/N [m] trolb/N [m] [def: fringe, tassel, pompom]
trombo'n/N [m] [def: trombone]
	trombeniker/S [m] [def: itinerant musician; glutton; loafer; braggart] 
tron/N [m] [def: throne; toilet] 
tron/N [m] [def: blubber; fish oil]
tronik/Ees [m] [def: shaft, handle]
tronts/N [m] [def: tantrum] 
	[idiom: in im arayn der tronts = he is throwing a fit]
trop/N [m] [def: accent; stress] 
	[idiom: leygn/shteln dem trop oyf = concentrate on]
tropik/N [m] [def: tropic (geographical)] tropish/A [def: tropical] 
trofey'/N [m?] [def: trophy] % B. Sandler: Karolina-Bugaz; Rokhl Korn
trots/P [def: aside from (German)] /Iik [def: contrary, perverse]
	trotsikayt/N [f] [def: contrariness]
troyb/N [f] [def: grape] vayntroyb/N [f]
troyer/V/T [def: be sad, mourn (with "iber"), grieve] 
	troyer [m] [def: sadness, grief, mourning] /Idik troyerik/K troyerlekh/A [def: sad]
		troyeriklekh/A [def: a bit sad]
		troyerikayt/N [f] [def: sadness] 
	fartroyert/A [def: sad, mournful]
troym/N [m] [def: dream]
	troymer/S [m] [def: dreamer]
	troym/V/T [def: dream (as of an ideal)]
	fartroymt/A [def: in a dream-like state] 
	troymeray' [n?] [def: dream state]
trubadur/N [m] [def: bard, troubador]
trube/S [f] [def: trumpet, bugle]
trufe{Wrwfh}/Xtrufes{WrwfwT}/H [f] [def: magical cure]
trufl trifl [m?] truflye/S [m] [def: truffle (genus Tuber)]
trume{Wrwmh}/Xtrumes{WrwmwT}/H [def: priestly portion] 
trumpeyt/N [m] trumeyt/N [m] trumeyter [m] [def: trumpet] 
	trumeyter/V/Btrumeytert [def: blow; trumpet] % Harduf
	tsetrumeyter/V/Btsetrumeytert [def: hype]
	trumey'teve/V/Btrumey'tevet [def: trumpet, announce] % Forwards: M-S Hoffman
	trumpeyter/S [def: trumpeter]
trune/S [f] trumne/S [def: casket, burial crypt (non-Jewish)] /D /Idik
trupe/S [f] [def: troupe] 
trus/N [m] [def: coward] 
tru'skafke/S [f] tru'skavke/S [f] tru'skave/S [f] [def: strawberry (fruit) (Polish truskawka)]
tsad{cd}/Xtsdodem{cddym}/H [m] [def: attribute; side (of a family or disagreement)] 
	min_hatsad{mn-hcd} [def: to the side] 
	metsad{mcd}/H [def: on the side of] 
	umtsdodemdik{umcddymdik}/A [def: impartial]
tsadi{cʼ}/H [m/f] [def: Hebrew letter Tsadi] 
tsadik{cdyk}/Xtsadikem{cdykym}/H [m] [def: righteous person; saint]
	/Lha{h} [adj] [def: the righteous]
	tsedeykes{cdkT}/H/N [f] [def: righteous woman]
	tsidkones{cdknyT}/Xtsidkonyes{cdknywT} [f] [def: God-fearing woman] /Idik
	tsedek{cdk}/H [m] [def: righteousness] 
	tsedoke{cdk|h}/H [f] [def: charity]  
		bal_tsedoke{bel-cdk|h} [m] [def: philanthropist]
	matsdek{mcdyk}/H [verb] [def: credit (with "zayn")] 
tsak/V/T [def: chip, notch] /Goys
	tsakn/S [m] [def: notch, chip]
	getsa'knt/A [def: jagged, chipped, saw-toothed]
tsam/N [m/f] [def: border, fence]
	tsam/V/T [def: tame, curb; restrain] /Gayn/Gop
		ayntsam/N [m] [def: hedge] 
	tsam/V/T /Garum
		fartsam/V/Bfartsamt [def: border] fartsamung/N [f] [def: boundary] 
	optsamung/N [f] [def: separation; enclosure, fence]
	tsoym/N [m/f] [def: border, fence; bridle] /Dtsaym % variant
		tsoym/V/T [def: put up a border] 
			/Garum [def: surround with a fence] 
			/Gop [def: fence off] 
				optsoym/N [m] [def: fenced-in area] 
		getsoymtkayt/N [f] [def: regulation, control]
		fartsoym/V/Bfartsoymt [def: border] fartsoymung/N [f]
	tsam/N [n] [def: plug, faucet]
tsank/V/T [def: sputter (candle)]
	tsankeray'/N [n] [def: quarrel] [usage: not recommended]
tsap/Ees [m/f] [def: (male) goat] /In
	tsapnberdl/Eekh [n] [def: goatlike beard] % Stutchkoff
tsap/V/T /Goys/Garoys/Gop [def: draw (liquid)]
	tsa'penish/N [n] [def: drawing] 
		bluttsa'penish/N [n] [def: drawing blood] 
	tsapn/S [m] [def: faucet] 
		ayztsapn/S [m] [def: icicle]
	bluttsaper/S [m] [def: bloodsucker]
tsapl/V/T [def: shudder] /Goyf
	/Idik [def: shuddering] 
	fartsapl/V/Bfartsaplt [def: terrify]
	[idiom: ton a tsapl = wince]
tsar/N [m] /Iish [def: Czar] /Iski
	tsa'rizm/N [m] [def: Czarism]
tsar_{cer}/H [m] [def: sorrow] 
	fartsar_{farcer}/V/Bfartsart{farcert} [def: sadden] 
	batsart{bacert}/A [def: remorseful]
	metsaer{mcer} [def: cause pain (with "zayn"); grieve, worry (with "zayn zikh")]
tsatske/S [f] /D tshatshke/S [def: bric-a-brac; plaything; nubile woman] 
	tsatske/V/T [def: play (with "zikh")] /Goys
	tsatskeray'/N [n] [def: ornamentation] % Sholem Aleykhem
	getsatsket/A [def: ornate] % Harduf 
		ibergetsatsket/A [def: excessively delicate or refined] [note: V]
	getsatsklt/A [def: ornate] % Forwards: Boris Sandler
	tsutsik/Ees [m] [def: youngster; brat]
tsavoe{cv#h}/Xtsavoes{cvowT}/H [f] [def: will] 
tsayg/V/T /Giber [def: convince] /Gon [def: demonstrate]
	ibertsaygt/A [def: convinced] % variant participle
	ibertsaygik/A ibertsaygevdik/A [def: convincing] 
		ibertsaygung/N [f] [def: convicing] 
	tsay'genish [n] [def: certificate]
	% ibertsaygt/A is German
tsayg [n] /In getsayg [n] [def: cloth, stuff, fabric] 
	ayzngetsayg [n] [def: ironware]
	estsayg [n] [def: cutlery]
	klaper-getsayg [n] [def: tools]
	shraybgetsayg [n] [def: writing materials]
	shpiltsayg [n] [def: toys] 
	verktsayg [n] [def: work materials] 
	veshtsayg [n] [def: linens]
	vaystsayg [n] [def: linens]
tsayl/N [f] [def: row, line]
tsayt/N [f] [def: time; menstrual period (with "di")] /Iik [def: ripe]
	tsaytik/V/T [def: ripen] 
	alttsaytish/A [def: ancient]
	blitsayt/N [f] [def: time of bloom; period of expansion]
	baytsaytik/K [def: timely; punctual]
	eyntsaytik/A [def: unique]
	fartsaytik/A fartsaytish/A [def: underripe; old-style, ancient] 
	glaykhtsaytik/A [def: contemporaneous]
	ibertsaytik/A [def: overripe]
	frilingtsayt/N [f] [def: springtime] 
	fritsaytik/A [def: early] 
	haynttsaytik/A [def: modern]
	fartsaytns [def: early; in ancient days] fartsaytish/A [def: of yore] 
	frishtiktsayt/N [f] [def: breakfast time] 
	mi'ttsaytler/X/S [def: contemporary] /Iish
	moltsayt/N [m] [def: meal] % gender masculine (PY: feminine)
	o'syentsay't/N [f] [def: autumn] % Sholem Aleykhem
	ovnttsayt/N [f] [def: evening]
	probetsayt/N [f] [def: probation period] [note: V]
	shterntsayt/N [f] [def: nightfall (poetic)]
	teytsayt/N [f] [def: tea time]
	vesnetsayt/N [f] [def: spring]
	vintertsayt/N [f] [def: winter]
	harbsttsayt/N [f] [def: autumn]
	zumertsayt/N [f] [def: summer] 
	fraytsayt/N [f] [def: time of freedom] 
	mitogtsayt/N [f] [def: midday] 
	tsvishntsayt/N [f] [def: interval]
	batsaytns [adv] [def: on time] 
	tsaytnvayz [adv] [def: time by time] 
	fartsaytn [adv] fartsaytns [adv] [def: of old] 
	[idiom: tsu der tsayt = punctually]
	[idiom: bay tsaytns = in time]
	[idiom: kedey ayntsushporn tsayt = in the interest of time] [note: V]
tsaytung/N [f] [def: newspaper] /D
	blattsaytung/N [f] [def: broadsheet] 
	togtsaytung/N [f] [def: daily newspaper] 
	va'nttsaytung/N [f] [def: broadsheet]
tse/Een [m] [def: the letter C]
tsebre/S tseber/S [m] tsuber/S [m] [def: manger; tub]
tsedrumshke/V/Btsedrumshket [def: disturb (NY)] 
tsegesn/A [def: corroded; eroded]
tsekardashe/V/Btsekardashet tsekaradashe/V/Btsekaradashet [def: destroy]
tsekh/N [def: guild] 
	neytsekh/N [def: sewing guild]
	[idiom: redn fun tsekh = talk shop]
tsekhrast/V/Btsekhrastet [def: unfasten, unbutton (with "zikh"); dishevel]
tsel/N [def: cell] /Iular [def: cellular] 
	tselke/S [f] [def: cell phone]
	tselula'r/A [def: cellular] 
-/Xtselkes [def: pearl barley]
tselnik/Ees [m] tselniker/S [m] tselnikerin/S [f] [def: notions seller; haberdasher] 
tselofan [m] [def: cellophane, cellophane tape] 
tseluloy'd [m?] [def: celluloid] % Sholem Aleykhem
tselzyus [adj] [def: Celsius] [grammar: postpositive]
tsemekh{cmH}/Xtsmokhem{cmHym}/H [def: sprout (plant)]
tsement/N [m] [def: cement] 
tsemursh/V/Btsemursht tsemurzhe/V/Btsemurzhet tsemursht/V/Btsemursht tsemorsht/V/Btsemorsht tsemersht/V/Btsemersht [def: grind, crush]
tsen [d] [def: ten] tsent/A [def: tenth]
	tsendlik/Eer [m] [def: unit of ten]
		tsendlikervayz [adv] [def: by tens]
	tsendlik/A [def: tens of] [usage: inadmissible]
	tsendling/Eer [m] [def: ten]
	tsentl/Eekh [def: 1/10]
	yortsendlik/Eer [m] [def: decade] 
	tsenerling/N [m] [def: teenager]
	tsener/D [def: 10-unit money (silver)] 
tsene{c#ynh}/H [def: go forth (plural feminine)] 
	tsenerene{c#ynh-|wr#ynh}/H [def: women's devotional book called Tseyne urene] 
tsenter/S [m] [def: center]
	aynkoyf-tsenter/S [m] [def: mall, shopping mall] 
	ideyen-tsenter/S [m]  [def: think tank] [note: V] 
	kontro'l-tsenter/S [m] [def: clearinghouse] [note: V]
	shtottsenter/S [m] [def: town center] % Bergelson: Yosef Shur
	tsentristish/A [def: centrist] % Forwards: B. Sandler
	detsentralizi'r/V/Bdetsentralizi'rt [def: decentralize]
tsentimeter/S [m] santimeter/S [m] [def: centimeter]
tsentral/A [def: central]
	ontsentrish/A [def: without center] 
	tsentrale/S [f] [def: central office, organization] 
	tsentralizirung/N [def: centralization]
	tsentralizi'r/V/Btsentralizi'rt [def: centralize]
		tsentralizatsye/S [def: centralization]
tsenzo'r/N [m] [def: censor] 
	tsenzuri'r/V/Btsenzuri'rt [def: censor]
	tsenzu'r/N [f] [def: censorship]
tsenzus [def: census] 
tsepletsh/V/Btsepletsht [def: flatten]
tsepolokhe/V/Btsepolokhet [def: readjust wings (bird)] % no base verb
tsepoloshet/A [def: wild with fright (horse)] % no base verb
tseprie/V/Btsepriet [def: rot] 
tser/V/T [def: feed; eat (with "zikh"); be hungry (with "zikh")]
	/Gayn [def: loan] % Stutchkoff
	opgetsert/A oysgetsert/A [def: thin, scrawny]
	fartse'r/V/Bfartse'rt [def: eat up, consume, swallow whole]
		fartse'rt/A [def: hungry]
	oysgetsertkayt/N [f] [def: starvation] % Forwards: Yoel Matveyev
tserabkop [noun] [def: central workers cooperative (Soviet)] % tsentraler arbeter kooperative; Kulbak: Zelmenyaner
tserate [f] [def: oilcloth; leather cloth] /In
tseremonye/S [f] [def: ceremony] 
	nomen-tseremonye/S [f] [def: naming ceremony] [note: V]
	tseremonya'l/N [m] [def: ceremony] /I
	tseremonye/V/T [def: mess around (with "zikh")]
		tseremonyeve/V/T [def: mess around (with "zikh")] % Forwards: Yoel Matveyev
tse'reve/V/T [def: darn clothing]
	fartse'reve/V/Bfartse'revet [def: darn] 
tserkve/S [f] [def: Orthodox church]
tsertifitsi'r/V/Btsertifitsi'rt sertifitsi'r/V/Bsertifitsi'rt [def: certify] 
	tsertifika't/N [m] sertifika't/N [m] [def: diploma; certificate] 
tsertl/V/T [def: comfort] 
	tsertlekh/A [def: tender, gentle]
		tsertlekhkayt/N [f] [def: compassion] 
	tsart/K [def: gentle]
		tsartkayt/N [f] [def: gentleness] 
	tse'rtlenish/N [n] [def: foreplay] [note: V]
tseryum [m] [def: cerium (Ce)] 
tseshtrey/V/Btseshtreyt [def: distract; have a good time (with "zikh)]
	tseshtreytkayt/N [f] [def: distraction, preoccupation] % Der Nister: Mashber
	tseshtreyung/N [f] [def: distraction] % Rokhl Korn: shotns
tsetl/N /Dtset [m] [def: receipt, document, note, slip, tag]
	batsetl/V/Bbatsetlt [def: write on a scap of paper] 
	mashkn{mSKwn}-tsetl/N [m] [def: pawnshop ticket]
	lombard-tsetl/N [m] [def: pawnshop ticket]
	ruftsetl/N [m] [def: subpoena] % Yiddish League
	shti'mtsetl/N [m] [def: ballot]
tsetrentsl/V/Btsetrenslt [def: drive apart; lose (money)]
tsetrukhnet/A [def: tattered, threadbare] 
tseydo{cdh}/H [def: food] 
	tseydo_ladeyrekh{cdh-ldrx}/H [def: food for a journey] 
tseykhn/V/T [def: depict] /Gon/Goys/Giber/Gop
	/Goys [def: condense, make a precis; be outstanding (with "zikh")]
	fartseykhn/V/Bfartseykhnt [def: depict; record] 
		fartseykhenung/N [f] [def: depiction, description; record]
	batseykhn/V/Bbatseykhnt [def: label, designate] 
		batseykhenung/N [f] [def: label, designation] 
	tseykhenung/N [f] [def: marking] 
		oystseykhenung/N [f] [def: distinction]
	o'ptseykhn [m] [def: badge]
	oysgetseykhnt/K [def: excellent]
		oysgetsey'khntkayt/N [def: excellence] % Der Moment
	tseykhner/X [def: artist] % Sholem Aleykhem
	tseykhn/S [m] ontseykhn/S [m] [def: mark, symbol] /Dtseykhnd
		aropnem-tseykhn/S [m] [def: subtraction sign (mathematics)]
		brandtseykhn/S [m] [def: brand]
		fortseykhn/S [m] [def: forewarning, premonition]
		fregtseykhn/S [m] [def: question mark (orthography)]
		glaykhtseykhn/S [m] [def: equal sign (mathematics)]
		grenents-tseykhn/S [m] [def: border sign]
		keyfl{Kfl}-tseykhn/S [m] [def: multiplication sign (mathematics)]
		khilek{Hylwk}-tseykhn/S [m] [def: division sign (mathematics)]
		ro'mbtseykhn/S [m] [def: diamond-shaped mark] % Forwards: Boris Sandler
		shri'fttseykhn/S [m] [def: character (letter or number)] 
		shrifttseykhn/S [m] [def: monogram; letter]
		teyl-tseykhn/S [m] [def: division sign (mathematics)]
		tsugob-tseykhn/S [m] [def: addition sign (mathematics)]
		vortsl-tseykhn/S [m] [def: radical, root sign (mathematics)]
	-/Xtseykhn/Xtseykhns [def: jacks (game)] %  Stutchkoff
tseyl/V/T [def: count] /Garayn/Gop/Goyf/Gon/Garoys/Goys
	/Giber [def: re-count]
	/Gunter [def: count up] % Forwards: Genadi Estraykh
	tsol/N [f] [def: number, count, inch] 
		umtsolik/A [def: countless]
		draytsol [adv] [def: thrice]
		grunttsol/N [f] [def: cardinal number] % Harduf
		eyntsol/N [f] [def: singular] /Iik
		kardina'l-tsol/N [f] [def: cardinal number] % Stutchkoff
		gruntsol/N [f] [def: cardinal number] 
		filtsolik/A [def: frequent; often; many] 
		mertsol/N [f] [def: plural] 
	tseylung/N [f] [def: count]
		folkstseylung/N [f] [def: census] 
	dertseyl/V/Bdertseylt [def: recount, tell, narrate]
		/Goys/Giber/Gop/Garoys/Gnokh/Gon
		dertseylung/N [f] [def: story, tale] 
		dertseyler/S [m] /Iish dertsey'lerin/S [f] [def: storyteller] 
		iberdertseyler/S [m] [def: storyteller] 
	fartseyl/V/Bfartseylt [def: recount, tell, narrate]
	getseylt/A [def: few] umgetseylt/A [def: countless] 
tseylem{clm}/Eer/Xtslomem{clmym}/H [m] [def: image; cross, crucifix] /D
	/Lbe{b} [adv] [def: in the image of]
	tseylem{clm}/H/V/T [def: make the sign of the cross] /Giber
	tsey'lemni'tse{clmnitse}/S [f] [def: pious non-Jewish woman]
tseyre{cyry}/S [f] [def: Hebrew vowel point tseyre /e/]
tsezyum [m] [def: cesium (Cs)] 
tshad [m] [def: carbon monoxide; charcoal fumes; daze]
	tshade/V/T [def: suffuse with fumes; babble]
	fartshadet/A [def: poisoned by carbon monoxide; dazed]
tshake/V/T [def: bluster; bluff]
tshakndik/A [def: lovely, ornamental]
tshape/V/T [def: go clumsily] 
tsharavnik/Ees [m] tsharavnitse/S [f] [def: sorcerer (Polish czarownik)]
tsharter/S [m] [def: charter] 
tshashke/S [f] [def: stool (furniture)] % Stutchkoff
tshate/S [f] [def: gang, flock (birds), pack (wolves)]
	tsha'teve/V/T [def: stalk; be on the lookout for] /Gop
	tsha'tesvayz [adv] [def: in a flock or pack] 
tshaynik/Ees /D [m] [def: teakettle, teapot] 
	tshaynye/S tshayne/S [def: tearoom; tavern]
	[idiom: hakn (emetsn) a tshaynik = annoy (somebody)]
tshek/N/S [m] [def: check (monetary instrument)] 
tsheke/V/T [def: go out of the way to get something ??] 
tshekhol/N [m?] [def: furniture cover]
tshelo/S [m] vyolontshe'l/N [m] [def: cello] 
tshemoda'n/Ees /Dtshemodand [m] [def: valise; suitcase]
	 /Dtshemodantshik % Forwards: M-S Hoffman
tshempyon/N [m] [def: champion]
	tshempyona't/N [m?] [def: championship contest] % Forwards: Boris Sandler
tshepe/V/T [def: touch; bother (with "zikh")] /Gtsu 
	/Gayn [def: be determined, resolute (with "zikh")]
	/Gon [def: affix] % Forwards: Boris Sandler
	/Gop [def: move away (with "zikh")]
	fartshepe/V/Bfartshepet [def: hook; stumble on; pick a quarrel with (with "zikh mit")]
		zatshepe/V/Bzatshepet [def: interfere] 
	tsutshe'penish/N [n] [def: nuisance, pest]
tshepke/A [def: clean, washed]
tshepukha [def: humbug] [usage: doubtful admissibility]
tshere/S [f] [def: turn (opportunity)]
tsherede/S [f] [def: flock] 
	tsherednik/Ees [m] [def: shepherd]
tsherepakhe/S [f] [def: tortoise; turtle] 
tsherepene/A [def: a material, maybe slate??]
tshere't/N [m] otshere't/N [m] [def: bullrush (river grass, family Cyperaceae)]
tsherta' [f] [def: pale of settlement (Czarist Russia)]
tsherezvitsheyke [f] [def: Cheka (Soviet secret police)]
tshernohu'z/N [m] [def: stork (bird)]
tshikave/K tsikave/K [def: curious; interesting] [grammar: indeclinable]
	tshikavekayt/N [f] [def: curiosity]
	tshikaves/N [def: curiousity (thing)]
	[idiom: oyf tshikaves = out of curiosity]
tshin/N [def: rank (Russian чин)]
	tshine/S [def: badge of rank]
	tshinovnik/Ees [m] [def: official, clerk, functionary (Russian чиновник)] 
tshipik [m] /D otshipik [m?] [def: veil, scarf (women's clothing)] /D
tshipkele/Ekh [n] [def: chip (food, as in chocolate chip)] % Forwards: S-R Schaechter
tshipmonk/N [m] [def: chipmunk (animal)] % Harduf
tshirik/Ees [m] [def: pustule]
tshirike/V/Btshiriket [def: chirp (sound of an cricket)]
	tshirku'n/Ees [m] [def: cricket (insect)]
tshiste/A [def: well-groomed ??] % a tshiste beheyme: Sholem Aleykhem
tshizik/Ees [m] [def: siskin (kind of bird, family Carduelis)] % Avrom Karpinovitsh
tshliene/S [def: member of an organization (Russian)] 
tshmel/Ees [m] [def: powerful blow; unexpected calamity]
	tshmelye/V/T [def: astonish, amaze]
	tshme'lyedik/A [def: astonishing, amazing]
	zatshmelye/V/Bzatshmelyet [def: deafen; stun]
tshoke/V/T [def: clink (sound); clink glasses (with "mit")]
tsholnt/N [m/n] [def: tsholent (slow-cooked Sabbath stew); servant girl (balegole-loshn)]
tshort [m] [def: Devil (Ukrainian чорт)]
tshub/N [def: tuft of hair]
	tshu'bekl/Eekh [n] [def: lock of hair (for children)]
	tshu'beva'te/A [def: with locks of hair] % Stutchkoff
tshuda'k/Ees [m] tshudatshke/S [f] [def: crank, oddball] 
tshudne/A [def: strange; wild]
tshugun/Ees [m] [def: cast iron (pot)] /Ien
tshuke{WSwk|h}/Xtshukes{WSwkwT}/H [f] [def: lust] 
	tshukhe/V/T /Goys [def: fully awaken, shake off sleep, come to one's senses (with "zikh)] 
tshukhe/V/T [def: scratch (with "zikh"); awaken] % Stutchkoff
	/Goys [def: sober up, come to one's senses (with "zikh")] % Stutchkoff, Michael Wex
	/Goyf [def: awaken; encourage] % Stutchkoff
	/Gop [def: be relieved (with "zikh")] % Stutchkoff
tshuprine/S [f] [def: forelock; well-styled hair (men)] 
	tshuprinke/S [f] [def: forelock] % B. Sandler: Karolina-Bugaz
tshuve{WSwBh}/Xtshuves{WSwBwT}/H [f] [def: answer; repentance]
	/Lbe{b} [adv] [def: in repentance] /Lu{|w} [noun] [f] [def: and repentance]
	[idiom: baltshuve{bel-WSwBh} = repentant; newly observant person]
	[idiom: frie tshuve{WSwBh} = early decision] [note: V]
tshvok/N/Xtshvekes [m] [def: nail (construction)] /Dtshvek
	tsvyok/N tsvokh/N tsvyokh/N tshvek/N [m] [def: nail] /Dtsvek
	fartsvyokeve/V/Bfartsvyokevet [def: nailed up] % Sholem Aleykhem
	-/Xtsviekhes [def: (building) (Ukrainian цвяхи)] % Sholem Aleykhem
tsi [def: whether; or] [grammar: introduces question]
tsi/V/Bgetsoygn [def: pull]
	/Garayn/Garoys/Garop/Garoyf/Gtsu/Gavek/Gtsunoyf/Gtsurik/Gayn
	/Gvayter/Giber
	/Giber [def: change (linens)]
	/Gon [def: wind up (clock)]
	/Gop [def: divert; extract (liquid); print (copy); flay; protract; sharpen; withdraw]
	/Goyf [def: raise (child)] % Sholem Asch: Motke Ganev
	/Goys [def: extract; draw out] 
	/Gtsurik [def: recall (political); wince (with "zikh")] [note: V] 
	tsutsi [m] [def: attraction]
		tsutsi-koyekh{KwH} [def: gravity; attractive force]
	shtrikh-untertsi [m] [def: underline] % Forwards: Mishe Lev
	tsiung/N [f] [def: pulling]
		oyftsiung/N [f] [def: upbringing (child)] % Sholem Asch: Motke Ganev
		tsutsiung/N [f] [def: attraction]
			tsutsiikayt/N [f] [def: attractiveness] % Forwards: S-R Schaechter
			tsutsievdik/A [def: attractive]
		aribertsi [def: pulling over] 
	tsi'enish/N [n] [def: pull] 
	batsi/V/Bbatsoygn [def: relate to (with "zikh"); cover with cloth; import (merchandise)]
		batsiung/N [f] [def: relation, attitude]
			tsvi'shnbatsi'ung/N [f] [def: relation] 
			u'mbatsi'ung [f] [def: disrespect]
		batsiekhts/N [f] [def: bed linens]
	dertsi/V/Bdertsoygn [def: educate; bring up]
		dertsiung/N [f] [def: education; upbringing]
		umdertsoygn/A [def: uneducated] 
		dertsier/S [m] [def: educator] /Iish [def: educational, pedagogical]
	fartsi/V/Bfartsoygn [def: delay, tighten, protract, call (sb.) for short, inhale (in smoking)]
	tsetsi/V/Btsetsoygn [def: draw out, stretch] 
	aroptsibar/A [def: (funds) that can be drawn upon]
	tsug/N [m] [def: train; move (in a game); draft (wind)]
		batsu'g [m] [def: clothing; covering; connection] [usage: inadmissible]
		ku'ryertsug/N [m] [def: express train]
		o'temtsug [m] [def: inhalation] [usage: not recommended]
		shneltsug/N [m] [def: express train]
	antsug/N ontsug/N [m] [def: suit of clothes]
	oystsug/N [m] [def: extract, excerpt] 
	aroyftsi/N [m] [def: chin-up (athletic exercise)] 
	ibertsier/S [m] [def: light jacket (clothing)]
	oyftsi/N [m] [def: (theater) act; rise of curtain]
	otemtsi [m] [def: inhalation]
	propntsier/S [m] [def: corkscrew] 
	likht-tsien [m] [def: candle dipping]
tsibele/S [f] [def: onion (vegetable)] tsibelke/S /D
	pore-tsibele/S [f] [def: leek (vegetable)] % Forwards: S-R Schaechter
	yoykhtsibele/S [f] yoykhtsibelke/S [f] [def: soup onion (vegetable)] 
	eymetsibele [def: egg and onion salad (ey mit tsibele)] % Forwards: Yehoshua Kahane
	[idiom: nit vert keyn tsibele = worthless]
tsiber{cybwr}/H [def: public; community] 
	betsiber{bcybwr} [adj] [def: communal; with a congregation]
tsibik/Ees tsibek/Ees [m] [def: pipe (for tobacco); pipe stem]
	lyulke-tsibik/Ees lyulke-tsibek/Ees [m] [def: long pipe] /D
tsier{ciwr}/Xtsiurem{ciwrym} [m] [def: painting]
tsifer/X/N [m/f] [def: digit, figure (number), numeral]
	tsiferl/X [def: numeral]
	tsifer/V/T /Gop [def: recall (with "di tsayt")] % Der Nister: Mashber
tsig/N/D [f] [def: goat] tsikele/Ekh [def: young goat] % Stutchkoff
	tsign-berdl/Eekh [n] [def: goatee beard]
	tsikl/V/T [def: bear young goat kids (with "zikh")]
	[idiom: vilde tsig = rowdy girl] % Stutchkoff
tsiga'r/N [m] siga'r/N [m] [def: cigar] 
	sigare't/N [m] [def: cigarette]
	tsigayer/S/N [m] [def: cigarette] [usage: SY]
	porttsiga'r/N portsiga'r/N [def: cigarette case]
tsigayner/S [m] /Iish tsiga'n [m] tsiga'ynerin/S [f] tsigay'nershe/S tsiganke/S [f] [def: Gypsy]
	tsigaynersh/A tsigaynish/A [def: Gypsy] 
tsigl/X [m] [def: brick; checker piece (game)] /In
	tsigelnye/S [f] [def: brickwork] 
tsikh/N [f] [def: tidy; blanket cover] /D [def: pillowcase] 
tsikhtik/K [def: clean] umtsikhtik/A [def: dirty] 
	tsikhter [def: cleaner] 
	[idiom: ferd-tsikhter = groom]
tsikl/N [m] [def: cycle] /Idik
	/Giber [def: recycle] % Yiddish League
	tsikl/V/T [def: ride a bicycle; sing with embellishment (with "zikh")]
		/Goys [def: draw or sing with embellishments]
	mototsikl/N [m] motortsikl/N [m] [def: motorcycle]
tsiklo'n/N [m] [def: cyclone] 
tsikorye [f] [def: chicory (drink)]
tsil/V/T [def: aim] /Gon
	tsi'leve/V/T [def: aim]
	tsil/N [m] [def: goal, purpose]
		hoypttsil/N [m] [def: principal goal]
		[idiom: mit kapoyerdike/kegnzaytike tsiln = at cross purposes] [note: V]
	sharftsiler/S [m] [def: sharpshooter] 
tsilinder/S [m] [def: top-hat (clothing)] 
tsimbl/N [m] [def: cimbalom (musical instrument related to the hammered dulcimer]
	tsimbl/V/T [def: beat a cymbal] /Garayn/Gariber
	[idiom: nemen emetsn oyfn tsimbl = poke fun at someone; submit to interrogation]
tsimer/N/D [m/n] [def: room] /Ilekh
	bodtsimer/N/D [m] [def: bath room]
	estsimer/N/D [m] [def: dining room]
	fo'rtsimer/N/D [m] [def: vestibule, foyer]
	froyentsimer/N/S [m] [def: woman]
	gasttsimer/N [m] [def: guest bedroom]
	klastsimer/N [m] [def: classroom]
	shloftsimer/N/D [m] [def: bedroom] 
	tuale't-tsimer/N/D [m] [def: locker room] 
	va'shtsimer/N/D [m] [def: toilet room]
	[idiom: geyn iber di krankn-tsimern = make (ward) rounds] [note: V]
tsimring [m] tsimbrik [m] tsimering [m] [def: cinnamon] 
tsimes/N [m] [def: a baked sweet root-crop food; fuss, commotion, big deal] 
	[idiom: makhn a tsimes = make a fuss]
	[idiom: a moyd vi a tsimes = robust young woman]
tsin [m] [def: tin (Sn)] /Iern
tsind/V/Bgetsundn [def: set fire] /Gon/Gunter
	tsetsind/V/Btsetsundn [def: enflame] 
	likhttsinder/S/X [m] [def: lamplighter]
	untertsinder/S/X [m] ontsinder/S [m] untertsinderin/S [f] ontsinderin/S [f] [def: igniter; arsonist]
		untertsindung/N [f] [def: arson]
	ontsindung/N [f] anttsindung/N [f] [def: setting afire; inflammation]
		lungen-ontsindung/N [f] [def: inflammation of the lungs; pneumonia (disease)] 
		moyekh{mwH}-ontsindung/N [f] [def: inflammation of the brain]
	likhtsinder/S [m] [def: candle lighter] 
	papiro's-tsi'nderl/Eekh [n] [def: cigarette lighter] % Forwards
tsindz/N [m] [def: tax, toll, tribute; interest (in plural)]
	tsindzer/S [m] [def: tax collector]
tsinish/A [def: cynical] tsiniker/X [def: cynic] tsinizm [m] [def: cynicism]
tsink [n] [def: zinc (Zn)] 
tsinor{cinwr}/H [def: pipeline, route] % Forwards: Hershl Glaser
tsikpe/S [f] tshipke [f] [def: fingertip; tiptoe]
tsipres/N [m] [def: cypress (tree)] 
tsir/V/T [def: ornament] /Goys [def: clothe]
	tsir/N [m] [def: ornament] 
	tsirung/N [f] [def: jewelry] 
	batsi'r/V/Bbatsi'rt [def: adorn] 
		u'mbatsi'rt/A [def: unadorned] % Berish Goldstein
		batsirung/N [f] [def: ornament, adornment]
	tsi'reve/V/T [def: mend (clothing), darn]
		fartsi'reve/V/Bfartsi'revet [def: darn]
	tsirevanye/S [f] [def: ornamentation] % Forwards: Yechiel Szeintuch
tsirk/N [m] [def: circus] 
	/D [def: compass (drawing instrument)]
tsirko [def: circa] 
tsirkonyum [m] [def: zirconium (Zr)] 
tsirkuli'r/V/Btsirkuli'rt [def: circulate]
	tsirkulatsye/S [f] [def: circulation] 
	tsirkular/N [m] [def: brochure, circular]
tsirulnik/Ees [m] [def: barber]
tsishe/V/T [def: hiss; sizzle] /Garoys
	tsish/N [n?] [def: hiss (sound)]
tsisterne/S [f] [def: cistern] 
	vaser-tsisterne/S [f] [def: water tank] 
tsiter/V/T [def: tremble; shiver] /Gnokh/Garoys/Goyf/Gop
	tsiter/S [m] [def: tremble] /Iik /Idik [def: trembling]
		tsiternish/N [n] [def: trembling]
			erdtsiternish/N [n] [def: earthquake] 
			nokhtsiternish/N [n] [def: aftershock] 
	tsiterdik/A [def: tender or worried-over child (usually with "kind"); trembling]
	fartsitert/A tsetsitert/A [def: atremble]
	nokhtsiter/S [m] [def: trembling] 
	dertsiter/V/Bdertsitert [def: strike]
		dertsiterung/N [f] [def: stroke (illness)] 
	dershiter/V/Bdershitert [def: shock; stroke (illness)]
		dershiterung/N [f] 
	oyftsiter/N [m] [def: trembling] 
	[idiom: tsitern hent un fis = tremble all over]
tsiti'r/V/Btsiti'rt [def: cite]
	tsitatsye/S [f] tsitat/N [m] [def: citation; reference] 
tsitron/N [def: citron, lemon] tsitrin/N [m]
	tsitrus [def: citrus] 
tsits [m] [def: chintz; calico (material)] /In
	sits [m] /In [def: chintz, calico] [usage: not recommended]
tsitse/S [f] [def: breast; teat (taboo)] /Dtsits tsitske/S 
-/Xtsitses_{cycyT}/H [f] [def: ritual fringe on garments]
	[morphology: Hebrew singular is both Yiddish singular and plural]
	[idiom: skhoyre{sHwrh} on tsitses{cycyT} = contraband]
tsivil/A [def: civil]
	tsivilizi'r/V/Btsivilizi'rt [def: civilize] 
		umtsivilizi'rt/A [def: uncivilized] 
	tsivilizatsye/S [f] [def: civilization] 
		tsibelezatsye/S [f] [def: civilization (humorous)] % Stutchkoff
	tsivili'st/N [m] [def: civilian] 
tsniyes{cnyewT}/H [n] [def: modesty, virtue, chastity]
	/Idik [def: modest, virtuous, chaste] 
	tsnue{cnweh}/Xtsnues{cnwewT}/H [f] [def: modest woman]
	tsnuedik{cnwehdik}/A [def: modest] % Sholem Aleykhem
tsofn{cfwn}/H [m] [def: north] /Idik [def: northern] 
tsol/V/T [def: pay] /Gop/Gtsu/Garum/Gtsurik/Gtse/Gayn/Goys/Gayn/Garoys
	/Giber [def: overpay (sometimes with "zikh")]
	/Gtsu [def: pay a bonus]
	tsoler/X [def: payer]
	batsol/V/Bbatsolt [def: pay; be of advantage (with "zikh")]
		batsolung/N [f] [def: payment] 
	dertsol/V/Bdertsolt [def: pay up] 
		[idiom: nit-dertsolte shtayern = back taxes] [note: V]
	tsetsol/V/Btsesolt [def: pay debt (with "zikh .. mit")]
	ayntsol/N [m] [def: payment; deposit (of money)]
	optsol/N [m] [def: dues, toll]
		badi'n-optsol/N [m] [def: service charge] % Yiddish League
	oystsol/N [m] [def: installment payment]
	brukhtsol/N [f] brokhtsol/N [f] brukhteyl/N [f] [def: fraction (mathematics)] 
	komplekstsol/N [f] [def: complex number (mathematics)] 
	tsutsol/N [m] [def: service charge, surcharge (money)] % Yiddish League
	[idiom: enge benge stupe stenge, artse bartse gole shvartse, eygele feygele khik = eenie meenie maynie mo (counting rhyme)]
tson/Xtseyn/Xtseyner [m] [def: tooth] /Iik /Dtseynd 
	baktson/Xbaktseyner [m] [def: molar teeth ??]
	khokhme{Hxmh}-tson/Xkhokhme{Hxmh}-tseyner [def: wisdom tooth]
	volftson/Xvolftseyner/Xvolftseyn [m] [def: canine tooth]
		/Dvo'lftseynd [def: teething bone; amulet]
	[idiom: farredn di tseyn = speak nonsense; use far-fetched justification]
	[idiom: a geshonkenem ferd kukt men nit in di tseyn = beggars can't be choosers] % Stutchkoff
	[idiom: shnayden tseyer = teethe] % Michael Wex
tsop/Xtsep /Dtsep [def: braid of hair] 
	ayztsepl/Eekh [n] [def: icicle]
tsora's{creT}/N [f] [def: leprosy (disease)]
	nege{nge}-tsora's{creT} [def: annoying person; overly demanding child]
	metsoyre{mcwre}/Xmetsoyroyem{mcwreym} [m] [def: leper]
tsore{crh}/Xtsores{crwT}/H [f] [def: trouble, misfortune, distress]
	tsoredik{crhdik}/A tsoresdik{crwTdik}/A [def: troubled] 
	tsoyrer{cwrr} [def: enemy; abuser]
	fartsoret{farcrht}/A [def: troubled, afflicted]
	[idiom: onton tsores = abuse]
	[idiom: gehakte tsores = troubles]
	[idiom: tsoyrer{cwrr} hayehudem{hyhwdym} = enemy of the Jewish people]
tseren/V/T [def: anger; be furious at (with "oyf")]
	dertseren/V/Bdertsernt [def: anger, vex, exasperate, insense, infuriate]
		dertserenung/N [f] [def: exasperation]
	tsorn/V/T [def: anger]
		dertsorn/V/Bdertsornt [def: anger]
		fartsornt/A [def: angry]
	tsorn [m] [def: rage; wrath] /Idik [grammar: no plural]
		grimtsorn [m] [def: wrath]
	dertsornt/A [def: angry] 
	[idiom: tsar_{cer} un tsorn = trials and tribulations]
tsoyber [def: magic] [usage: inadmissible] /Iish
	batsoyber/V/Bbatsoybert [def: enchant, charm; captivate] [usage: inadmissible] 
	batsoyberung/N [f] [def: enchantment] [usage: inadmissible]
tsoyrekh{cwrx}/Xtsrukhem{cwrxym}/X [def: need, necessity]
	[idiom: ton dem tsoyrekh{cwrx} = move one's bowels, defecate]
tsoye{cw#h}/H [f] [def: excrement] 
tsoyg/Xtsayg [f] /Dtsayg [def: bitch (animal)]
tsoyt/N [m?] [def: shag, loose ends] /Iik [def: shaggy] 
tsu/P tsun [prep] [def: towards] 
	tsu [adv] [def: in addition; each] 
	tsushoyer/S [m] [def: audience] [usage: doubtful admissibility]
-/Xtsudatn [def: fabric scraps] % ?? Stutchkoff, Avrom Karpinovitsh
tsuk/V/T [def: twitch, shrug (with "mit"); pull (thread); adorn] 
	fartsuk/V/Bfartsukt [def: devour, eat up]
		fartsukenish/N [n] [def: devouring]
		[idiom: a fartsukenish oyf dir = may you be devoured (curse)]
tsuker [m] [def: sugar] /Idik /D [def: candy] 
	tsuke'rke/S [f] [def: sugar candy] /D
	meltsuker melets [m] [def: granulated sugar]
	kandl-tsuker [m] [def: some sort of sugar ??]
	zamd-tsuker [m] [def: confectioner's sugar] % Menakhem Kipnis
	fartsuker/V/Bfartsukert [def: sweeten] 
	batsuker/V/Bbatsukert [def: with added sugar] 
	getsukert/A [def: sugary] % Sholem Aleykhem
	tsukrovnye/S [f] [def: sugar factory (Polish cukrownia]] % Opatoshu: Polishe Velder
tsukht/N [f] [def: tidy woman; slob (ironic)]
tsulib/P [def: for] 
tsung/N/Xtsinger/Xtsingen [f] /Dtsing [def: tongue]
	fayertsung/N [f] [def: flame]
tsunoyf [def: together]
tsunter/V/T [def: glow with heat] % Sutskever
	tsunter/S [m] [def: (glowing) tinder; wood ash]
tsup/V/T [def: tug; pluck; pick]
	tsipe/V/T /Gtsunoyf [def: gnash (teeth) ??] % Sholem Aleykhem
tsure{cwrh}/Xtsures{cwrwT}/H [f] [def: face; appearance] 
	tsuras{cwrT}/H [f] [def: appearance of]
	tsurkele/S [f] [def: little face] 
tsuzamen [adv] [def: together]
	tsuzamenkayt/N [f] [def: togetherness] % Glatstein
tsvayg/N/D [f] [def: branch] 
	tsvayg/V/T /Gop [def: branch off, separate (with "zikh")]
	tsvaygung/N [f] [def: branching] tsetsvaygung/N [f]
	tsetsvaygt/A [def: branching]
	tsvaygldik/A [def: ??] % ire tsvaygldike tseplekh
	optsvayg/N [f] [def: fork (in road)] [note: Khaver-Paver's Klinton Street] 
	fartsvaygt/A [def: branching] % Forwards
tsvek/N [m] [def: purpose] 
	batsvek/V/Bbatsvekt [def: aim] % Forwards 
	gezunttsvek/N [m] [def: purposes of health] % Forwards: Sholem Berger
tsvey/N [d] [def: 2]
	/It [def: 2nd] /Iik [def: binary (mathematical)] 
		/Itik [def: secondary] /Iendik [def: double]
	tsveytns [adv] [def: secondly; on second thought]
	tsveyerley [adv] [def: two-sorted] 
	tsveyer/S [m] [def: two-kopek coin (Russian currency)] % Sholem Aleykhem
	tsvelf [d] /It [def: 12] 
		tsvelftns [adv] [def: 12th]
		tsvelftl/Eekh [n] [def: 1/12] 
	tsvantsik [d] /A /It tsvontsik [d] /A [def: 20] tsvantsikst/A [def: 20th]
		tsvantsikstl [n] [def: 1/20] 
		[idiom: biz hundert un tsvantsik = until ripe old age]
	tsviling/N [def: pair of twins] 
tsveyfl/V/T [def: doubt] 
	fartsveyfl/V/Bfartsveyflt [def: confuse]
		fartsveyflung/N [f] [def: despair, desparation]
	ontsveyfldik/A [def: certain, without a doubt] 
	tsveyflhaftik/A [def: doubtful] [usage: inadmissible]
	tsveyfler/S [m] tsveyflerin/S [f] [def: person lacking confidence]
tsvik/Ees [m] [def: beet (vegetable)] /D
	baktsvik/Ees /D [def: red cheek ??] % Bergelson: Yosef Shur
tsvikl/V/T [def: decorate, dress up] /Goys % Sholem Aleykhem
	batsvikl/V/Bbatsviklt [def: decorate]
	fartsvikl/V/Bfartsviklt [def: ??]
tsving/V/Bgetsvungen [def: force] /Goyf
	/Garoyf [def: put on (ill-fitting clothing)] 
	batsving/V/Bbatsvungen [def: force; captivate] 
	tsvang/N [m] [def: force]
		shultsvang/N [m] [def: obligation to go to school] % Kulbak: Zelmenyaner
	tsvang/N [f] [def: pair of tongs; pair of pliers; pincer] /Dtsveng
		knayptsvang/N [f] [def: pliers, crimpers] % Stutchkoff
		tshvektsvang/N [m?] [def: screwdriver]
		nogltsvang/N [m?] [def: nail-puller]
		o'ptsvenge/S [f] [def: nail-puller??] % Sholem Aleykhem
tsvinter/S [m] [def: non-Jewish cemetery]
tsvishn/P tsishn/P tsevishn/P [def: between] 
	dertsvishn [adv] [def: in between]
	[idiom: geyn tsvishn mentshn = bring an case for informal judgement] % Beyle Shekhter-Gotesman
tsvit/N [m] [def: bloom, blossom] 
	tsvite/V/T [def: bloom, blossom]
tsvitshe/V/T tsvitsher/V/T [def: twitter (sound of a bird)] 
	tsvitsh/N [m] [def: twitter (sound of a bird)]
tsviyes{cByewT} [f] [def: hypocrisy] /Idik
	tsvua'k{cBwek}/Ees tsvuya'k{cBwyak}/Ees/Xtsviyem{cBwe|ym} [m] tsvuatshke{cBwetshke}/S [f] [def: hypocrite]
	tsvuatshe{cBwetshe}/V/T [def: be hypocritical; put on a pious front]
tsvog/V/Bgetsvogn /Goys/Garum [def: wash (head)]
tsvorekh [m] [def: cottage cheese] % no plural
tu/Vton/Bgeton [def: do]
	/Gahin/Goyf/Gtsu/Garoyf
	/Garayn [def: place inside]
	/Gon [def: wear, get dressed (with "zikh")]
	/Gop [def: complete an action]
	/Goys [def: take off]
	/Gnokh [def: imitate, repeat]
	/Giber [def: change the clothing]
	/Gvoyl [def: enjoy oneself (with "zikh")]
	tun getun % variant infinitive
	ongetonenerheyt [adv] [def: dressed] % Rokhl Korn: shotns
	tuendik/A [def: doing] % irregular gerund
		ontuendik/A [def: dressing (with clothes)]
	tuik/K [def: active]
	tetik/A [def: active, involved] tetikayt/N [f] [def: activity]
		voyltetik/A [def: philanthropic, service-oriented]
	optu/Een [m] [def: trick, prank]
	oyftu/Een [m] [def: exploit, feat, accomplishment, achievement]
		oyftuekhts/N [n] [def: accomplishment] 
		oyftuer/S [m] [def: innovator, trailblazer, groundbreaker]
	ontuekhts/N [n] [def: clothing]
	tuer/S [m] tu'erin/S [f] [def: doer; active person]
		gevaldtuer/S [m] gvaldtuer/S [m] [def: rapist] 
	tuung/N [f] tuekhts/N [n] [def: deed] 
	tat/N [m] [def: deed] [usage: inadmissible]
	fartu/Vfarton/Bfarton [def: occupy, use up, spend, get engrossed (with "zikh")] 
	[idiom: fregn vos se tut zikh = say hello]
	[idiom: ton mit emetsn = arrange a marriage with someone]
	[idiom: hobn tsu ton mit X = have an affair with X]
tuale't/N [m?] [def: toilet (fixture)]
tuberkulo'z [m] [def: tuberculosis]
tuflye/S [f] [def: slippers (clothing)] % Stutchkoff
	tufl/X [f?] [def: women's shoes (clothing)] % Avrom Karpinovitsh
tufyak/Ees [m] [def: mattress] % Stutchkoff
tuk/V/T [def: dunk] /Gunter
	/Garoys [def: be visible above the water]
	tu'kerin/S [f] tu'kerke/S [f] [def: ritual bathhouse attendant (Jewish)] 
	tukung/N [f] [def: dive] 
tukatsh/N [m] tukats/N [m] [def: pestle]
tukh/Xtikher [n] [def: cloth] /In /Dtikh [def: kerchief] 
	tishtekh/Eer [n] /D [def: tablecloth] 
	fartekh/Xfartekher [n] [def: apron] /D
		[idiom: halt zikh nokh bay der mames fartekh = he acts like a baby]
	/Dgavertikh [def: child's bib]
	hantekh/Xhantikher/Xhantekher [m/n] [def: towel] /Dhantikh [def: washcloth] 
		kikhhantekh/Xkikhhantikher/Xkikhhantekher [n] [def: kitchen cloth] 
	haldztikhl/Eekh [def: scarf; kerchief, neckcloth]
	koptukh/Xkoptikh /Dkoptikh [def: scarf (clothing)] 
	noztukh/Xnoztikher [n] /Dnoztikh [def: handkerchief] 
	shniftukh/Xsniftikher [n] [def: snuff cloth] % Opatoshu: Poylishe Velder
	tashntikhl/Eekh [n] [def: handkerchief]
tukhle/A [def: stale; mildewy]
tulep/N [m] tulup/Ees/N [m] [def: sheepskin coat (clothing)] /D
tulip/N tulpa'n [m] tulipa'n [m] tulpe/S [f] [def: tulip (flower)]
tulye/V/T [def: cuddle, nestle (intransitive: with "zikh"); clasp] /Gayn/Gtsu/Gtsunoyf
	fartulyet/A [def: nestled] % Chava Rozenfarb: Botshani
tulyum [m] [def: thulium (Tm)] 
tuma'n/N [m] [def: fog; mist] 
tumbe/S [f] [def: bollard; post]
tuml/V/T [def: make a commotion]
	tuml/N [m] [def: commotion] /Idik [def: noisy]
	tumler/S [m] [def: scrapper; entertainer]
	tu'mlenish/N [n] tumleray'/N [n] [def: enthusiasm, excitement] 
	fartuml/V/Bfartumlt [def: deafen] 
	tsetuml/V/Btsetumlt [def: confuse, bewilder, arouse excitement (with "zikh")]
		tsetu'mlenish/N [n] tsetumltkayt/N [f] [def: confusion]
	getu'ml/N [m] [def: commotion] 
tumor [def: tumor] 
tun/N [m?] [def: barrel]
	/Dtind [n] /Dtund [n] [def: keg]
tundre/S [f] [def: tundra]
tune'l/N [m] [def: tunnel] 
	tuneli'r/V/Btuneli'rt [def: tunnel] /Garop % Berish Goldstein: Der Hobit
tune|yadets [m] tune|yadtses [m] [def: sponger, freeloader]
tunik/Ees [m] [def: tunic, blouse (clothing)]
tunk/V/T [def: dip] /Gayn
	tink/V/Bgetunkt [def: dip] /Gayn/Garunter
	/Bgetunken /Gayn/Garunter % both participles exist
	tunk/N [m] [def: dip; gravy] 
	tunker/S [m] tuker/S [def: diver] 
		toykher/S [m] [def: diver] [usage: not recommended]
	tinkekhts/N [n] [def: dipping sauce (food)] % Forwards: S-R Schaechter 
tunkl/K [def: dark; dim; obscure] tunkel/A
	/-tunkler/-tunkle/-tunkln % still get some spurious forms
	tunklkayt/N [f] tunklhayt/N [f] tu'nklenish/N [n] [def: darkness] 
	halbtunkel/A [def: half-dark] 
	tunkl/V/T [def: darken, get dark] 
	fartunkl/V/Bfartunklt [def: darken] 
tupe/V/T [def: beat time; stamp the foot]
	tuperay'/N [n] getuperay'/N [n] [def: beating; stomping (in dance)]
	tup/N [m] [def: thump] 
turba'n [m?] tolpa'n [m?] [def: fez (clothing)]
tur/N [m] turne/S [f] [def: tour; circuit; trip]
	oydiotu'r/N [m] [def: audio tour] % Yiddish League
	pe'kltur/N [m] [def: package tour] % Yiddish League
	turizm [m] [def: tourism] % Yiddish League
		ekoturizm [m] [def: ecotourism] % Yiddish League
	turi'st/N [m] turistke/S [f] [def: tourist]
		turistik/N [f] [def: tourism] % Forwards
		turistish/A [def: touristic]
		turi'steven [n] [def: sightseeing] % Yiddish League
turem/S [m] [def: tower; rook (chess piece)] 
	likhtturem/S [m] laykhtturem/S [m] [def: lighthouse]
	turem/V/T [def: tower]
turlike/S [f] [def: object of derision] % Avrom Karpinovitsh
	[idiom: makhn fun emetsn turlikes = make fun of someone] % Avrom Karpinovitsh
turme/S [f] [def: prison] 
turname'nt [def: tournament] 
	turni'r/N [m?] [def: tournament]
tush/N [m] [def: India ink] 
tushe/V/T [def: stew (food); smother; extinguish]
tutin [noun] [def: cheap smoking tobacco] 
tuts/N [m] [def: dozen] 
	tutsnvayz/A [def: by the dozen]
tutshe/S [f] [def: swarm, cloud]
	titshke/S [f] [def: swarm, cloud; gang]
tuz [interj] [def: wham!]
tuzhurke/S [f] [def: double-breasted jacket (clothing)]
	% Bergelson: "s'felt dokh a knepl in dayn studentisher tuzhurke"
tvan [def: swamp] 
tviye{WBy|eh}/Xtviyes{WBy|ewT}/H [def: warning; command; complaint] 
tvue{WBw#h}/H [f] [def: grain] 
tyokhke/V/T [def: throb] 
	tyokh/N [m] [def: thump (sound of a beating heart)]
tyopke/V/T [def: poke, trip, move lightly] /Gon
	fartyopet/A [def: smeared (clothing)]
tyuke/V/T [def: shout]
	fartyuke/V/Bfartyuket [def: chase with a shout]
tyul [m] [def: tulle (fabric)] [pronunciation: tyuL] /In % no plural
tyulik [def: over-skirt; tutu (clothing)] 
u/Een [m] [def: the letter U] 
udobne [adj] [def: comfortable (Slavic)] 
ugaritish/A [def: Ugaritic] 
u'gerke/S [f] [def: cucumber] /D
	[idiom: zoyere ugerke = pickle]
ukaz/N [m] [def: decree (Russian указ)]
ukos [m] [def: slope, slant] 
	[idiom: oyf ukos = aslant, obliquely]
ulan/Eer [def: Polish-Lithuanian light cavalry armed with lances]
ultra- [prefix] [def: ultra]
umbre/S [f] [def: umbra (astronomical)]
	penumbre/S [f] [def: penumbra (astronomical)]
ume{#wmh}/Xumes{#wmwT}/H [f] [def: nation, people] 
	umes_hooylem{#wmwT-hewlm} [def: nations of the world] 
umetum [adv] [def: everywhere]
umgehayer/K [def: tremendous, enormous]
	umgehoyer/A [def: tremendous, enormous] [usage: not recommended]
umgelumpert/A [def: awkward, unwieldy] 
	umgelumpertkayt/N [f] [def: awkwardness, clumsiness]
umishlnye [adv] umishne [adv] umistne umistn [adv] [def: especially; on purpose] 
umzist/A [adv] [def: in vain] /Iik
un [conj] [def: and] 
uniform/N [f] uniforem [f] [def: uniform] % both versions use same plural
unikod [def: Unicode] % note: alphabetize under "kod"
unikum/S [m] [def: unique (copy)]
	unika'l/A [def: unique] % Forwards
univers/N [m] [def: universe] /Ial [def: universal] 
	unive'rsali'zm/N [m] [def: universalism (religious)]
universite't/N [m] [def: university] 
	/Iish [def: university] % Forwards: Genadi Estraykh
unter/P [def: under]
	untn [adv] [def: under]
	untn/S [m] [def: bottom]
	untersht/A [def: bottom]
	arunter/P
	derunter [adv] [def: below] 
untertenik/A [def: at a lower rank, subservient, humble, submissive]
	untertenikayt/N [f] [def: subservience, humility, submissiveness] 
	u'ntertan/N [m] [def: subject; serf]
	u'ntertaner/S [m] u'nternanerin/S [f] [def: subject, citizen]
unts/N [m?] [def: ounce (measure)]
upore/V/Buporet [def: finish work (with "zikh"); complete (with "zikh mit")]
uprave/S [f] [def: magistrate office] [usage: not recommended]
uspeye/V/Buspeyet [def: succeed; be on time]
utilizi'r/V/Butilizi'rt [def: use, utilize]
	utilizator/N [m] [def: user, utilizer]
	utilizatsye/S [f] [def: use, utilization]
	utilitar/A [def: utilitarian] /Iish
utopye/S [f] [def: utopia] 
	utopish/A utopistish/A [def: utopian]
	utopist/N [m] [def: optimist, utopian]
utshastok/Xutshastkes [m] [def: region; prison (Russian участок)]
ur- [prefix] [def: grand (genealogical)] 
uradnik/Ees [m] uryadnik/Ees [m] [def: police prefect (Russian урядник "constable")]
uranyum [m] [def: Uranium (Ur)] 
urba'n/A [def: urbane] 
	urbanizirung/N [f] [def: urbanization] 
	u'rbanizi'rt/A [def: urbanized]
urini'r/V/Burini'rt [def: urinate]
	ur'in [m?] [def: urine]
urne/S [f] [def: urn, ballot box] 
urok/N [m?] [def: lesson; homework]
urzakh/N [f] [def: cause, reason] [usage: inadmissible]
usha'k/Ees [m] [def: doorframe, doorjamb]
uvde{ewBdh}/Xuvdes{ewBdwT}/H [f] [def: accomplishment; occupation]
u|ye'zd [m] [def: county-level administrative district (Russian уезд "county")]
	u|yezdne/A
uzo'r/N [m] [def: pattern, motif]
vad{ved}/H [m] [def: council]
vaflye/S [f] [def: waffle (food)] % Harduf
vag/V/T [def: dare] 
	dervag/V/Bdervagt [def: dare] 
	derveg/V/Bdervegt [def: dare (with "zikh"); keep false accounts (with "nit")]
	gevagt/A [def: daring] % Harduf 
		gevagtkayt/N [f] [def: daring]
vagant/N [m] [def: vagrant] % Itsik Manger
vagine/S [f] [def: vagina (body part)]
vago'n/N/Ees [m] [def: railroad car] 
	mistvagon/N [m] [def: dumpster] 
	postvagon/N [m] [def: postal car (railway)]
	raytvogn/S [m] [def: carriage] 
	vogn/S/Xvegn/Xvegener [def: cart, buggy]
	/Dveg [n] [def: cart]
		aynkoyf-vegele/Xkh [n] [def: shopping cart] % Forwards: M-S Hoffman
		hantvegele/Xkh [n] [def: handwagon]
		kinder-vegele/Xkh [n] [def: baby buggy, perambulator]
vaka'ns/N vakansye/S [f] [def: job position]
vakatsye/S [f] [def: vacation] 
vakh/V/T [def: watch, keep vigil; be awake] /Goys/Goyf
	derva'kh/V/Bderva'kht [def: watch] 
	bava'kh/V/Bbava'kht [def: guard] 
		u'mbava'kht/A [def: unguarded] % Berish Goldstein
		bavakher/S [m] [def: guard] % Forwards: Yoel Matveyev
	vakh/N [f] [def: awakeness; guard; jail] /Iik /Iedik [def: awake]
	oyfvakhung/N [f] [def: awakening]
	vekhter/S [m] ve'khterin/S [f] [def: guard]
		vekhter/V/T [def: guard] % Stutchkoff
		laybvekhter/S [m] [def: bodyguard]
		toy'ervekhter/S [def: doorman]
	ernvakh/N [f] [def: guard of honor] 
	li'khtlvakh [f] [def: candlelight vigil] % Yiddish League
	[idiom: zayn oyf der vakh far = keep an eye out for] [note: V] 
vakhtl/N [m] [def: quail (bird)] % Harduf
vakkhanalye/S [f] [def: Bacchanalia, drunken festivity]
vakl/V/T [def: rock; shake; hesitate (with "zikh")] /Gunter
	va'klenish/N [n] [def: rocking] vakldik/A [def: unsteady] 
	vaklung/N [f] [def: hesitation]
vaks/V/Bgevaksn [def: grow]
	/Goyf/Goys/Garoys/Garayn/Garum/Gon/Gunter/Gfunander/Gayn/Gtsu/Gtsunoyf
	/Gtsuzamen
	/Giber [def: grow beyond]
	vaksung/N [n] [def: growth, overgrowth]
	tsevaksn/V/Btsevaksn [def: increase]
	farvaksn/A [def: overgrown; healed (wound)]
		farvaksnkayt/N [f] [def: state of overgrowth]
	dervaksn/A [def: adult]
		bi'zdervaksling/N [n] [def: pre-adolescent] 
	tsevaks/V/Btsevaksn [def: grow bigger]
	bavaksn/A [def: hairy]
	gevi'ks/N [n] [def: plant] /Iik [def: plant-like] 
		-/Xbo'bgevi'ksn [def: Fabaceae (plant family)]
	vuks/N [m] /Iik [def: growth, appearance]
		gevuks/N [m] [def: growth]
		beyzvuks/N [m] [def: malignant tumor] 
		nokhvuks/N [m] [def: regrowth] 
		dinvuksik/A [def: thin]
		kleynvuksik/A kurtsvuksik/A [def: short] 
		langvuksik/A [def: tall] 
		mitlvuks [n?] /Iik [def: medium-height] 
		onvuks [m] [def: growth (disease)]
		tsuvuks/N [m] [def: additional growth]
		shla'nkvuksik/A [def: thin] 
vaks/N [m] [def: wax (substance)] /In
	veksn/A [def: wax]
	veks/V/T [def: wax]
	trivaks [m] trifvaks [m] [def: sealing wax]
vaktsini'r/V/Bvaktsini'rt [def: vaccinate]
	vaktsinatsye/S [f] [def: vaccination] % Stutchkoff
	vaktsinirung/N [f] [def: vaccination] % Yiddish League
	vaktsi'n/N [m] [def: vaccine]
val/N [m] [def: roller (utensil); bulwark, rampart] 
	valik/Ees [m] [def: roller (utensil)]
	valger/V/T [def: roll; wander; be homeless (with "zikh")]
		/Gavek/Garum/Goys
		/Gum [def: knock down]
		/Gon [def: heap up]
          /Goys [def: roll out]
		farvalger/V/Bfarvalgert [def: lie about]
		tsevalger/V/Btsevalgert [def: spread out]
	velger/V/T [def: roll out; smooth] /Goyg
	valts/V/T [m] [def: mill; roll]
		valts/N [m] [def: roller (utensil)]
			akervalts/N [m] [def: plow-wheel] % ?? Stutchkoff
		valtsarnye/S [f] [def: rolling mill]
vald/Xvelder [m] [def: forest] /Iove /Dveld [def: grove] 
	veldldik/A [def: forest-like] 
	baveldert/A [def: forested] 
	nodlvald/Xnodlvelder [def: coniferous forest] % Chava Rozenfarb: Botshani
valiz/N [m] valize/S [f] [def: valise, suitcase]
	valizke/S [f] [def: small valise] % Forwards: M-S Hoffman
-/Xvaln [def: election] 
	val- [prefix] [def: elective] 
vals/N [m] [def: waltz (dance)]
	valsi'r/V/Bvalsi'rt [def: waltz]
valute/S [f] [def: currency (foreign) (money)] 
valye/V/T [def: roll; spin (with "zikh")]
	 /Garayn [def: toss in]
vamp/N [m] [def: tripe (food)] /Dvemp
vampi'r/N [m] [def: vampire; bloodsucker]
	-/Xvampiremlekh [def: little bloodsuckers] % Forwards: M-S Hoffman
vanadyum [m] [def: vanadium (V)] 
vanda'l/N [m] [def: vandal] % Harduf
	vandali'zm [m] [def: vandalism] % Harduf
vander/V/T [def: travel; wander] /Garum/Gtsunoyf/Gayn/Goys
	/Garayn [def: immigrate]
	/Goys [def: emigrate]
	/Giber/Gariber [def: migrate]
	vanderung/N [f] [def: wandering]
		oysvanderung/N [f] aroysvanderung/N [f] [def: emigration] 
		ay'nvanderung/N [f] [def: immigration]
	va'nderer/X/S [m] [def: wanderer]
		ay'nvanderer/X/S [m] [def: immigrant]
		i'bervanderer/X/S [m] [def: migrant]
		oy'svanderer/X/S [m] [def: emigrant] 
vandl/V/T [def: become; go for a walk] 
	farvandl/V/Bfarvandlt [def: transmogrify, convert, transform]
		farvandlung/N [f] [def: conversion, transformation]
	na'khtvandler/X [m] [def: sleepwalker]
	umvandlung/N [f] [def: vicissitude] 
vane/S [f] [def: bathtub] 
	[idiom: makhn a vane = take a bath]
vani'l vanile [def: vanilla] 
vant/Xvent [f] /Dvent [def: wall]  % < PIE *uendh- (to turn, wind, wend) (walls made of wattle)
	oy'gnvant/Xoy'gnvent [f] [def: eyewall (of a hurricane)] % Yiddish League
	shteynvant/Xshteynvent [f] [def: rock wall] 
	tsiglvant/Xtsiglvent [f] [def: brick wall] 
	[idiom: shlogn a kop in vant = make a commotion]
	[idiom: nit zey meyn ikh, di vant meyn ikh = not to mention names]
	[idiom: krikhn oyf di glaykhe vent = go stir-crazy]
	[idiom: klepn vi arbes tsu der vant = be irrelevant]
;ants/N [f] [def: bedbug] 
var/A [def: true] tsvor [def: truly] 
var [m] [def: boiling water]
vare/S [f] [def: path]
	[idiom: makht a vare = make way!]
vare/N/S [f] [def: merchandise]
varem/K [def: warm; thermal] /Ilekh
	tsevarm/V/Btsevaremt [def: warm up (with "zikh")] 
	varemkayt/N [f] [def: warmth] 
	varem/V/T [def: heat] /Gadurkh/Gon/Goys
		/Giber [def: reheat]
	dervarem/V/Bdervaremt [def: warm] 
	varmes/N [n] varemes/N [n] [def: dinner]
varenye/S [f] [def: jam, preserves (food)]
	varenik/Ees [m] [def: a kind of filled dumpling (food)] 
	-/Xvarnishkes -/Xvarnitshkes [def: a filled fried-pasta food]
varf/V/Bgevorfn [def: throw, pitch, cast; toss about (with "zikh")]
	/Garayn/Garoys/Garop/Garoyf/Gavek/Gfor/Gop/Gunter/Gariber/Garum/Gdurkh
	/Ganider/Giber/Gayn/Gum/Goys/Gtsu/Gtsurik/Garunter/Goyf/Gafer
	/Gon [def: attempt] 
	/Gfor [def: accuse]
	farvarf/V/Bfarvorfn [def: set aside for safekeeping; place down] % gendz in a shtayg
		firvarf/N [m] forvurf/N [m] [def: reproof, reproach] 
	tsevarf/V/Btsevorfn [def: toss] 
	bavarf/V/Bbavorfn [def: sprinkle, pelt] 
		eyfele{ewfele}-bavarfns [n] [def: baby shower] [note: V] 
	varfer/S [m] [def: pitcher, thrower] 
		minevarfer/S [m] [def: mine thrower (weapon)] % Forwards: Yitskhok Luden
	vorf/N [m] [def: toss, hurl, throw]
		oysvorf/N oysvurf/N [m] [def: discard; bad-mannered youngster; outcast, bum]
		oysvorfling/N [m] [def: bad-mannered youngster]
	onvarf/N [m] [def: attempt; draft, outline, sketch] 
	verfl [n?] [def: die (playing); cube (sugar)]
	[idiom: kartn varfer = fortune teller]
varg [n] [def: material]
	aheymvarg/N [n] [def: take-out food] [note: V]
	altvarg/N [n] [def: old things]
	apteykvarg/N [n] [def: pharmaceuticals]
	ay'znvarg/N [n] [def: ironware]
	brenvarg [n] [def: fuel]
	brokhvarg [n] [def: scrap]
	byotsefalvarg/N [n] [def: biodegradable material] [note: V]
	esnvarg [n] [def: food]
	flekhtvarg [n] [def: wickerwork, caning]
	glozvarg [n] [def: glassware]
	goldvarg [n] [def: gold utensils]
	gortnvarg [n] [def: garden produce] % Sholem Aleykhem
	grinvarg [n] [def: vegetables] 
	kley'dervarg [n] [def: clothing] % Der Nister
	kleynvarg [n] [def: small people or things]
	kunstvarg [n] [def: artistic wares] % Forwards: S-R Schaechter 
	kupervarg [n] [def: copper wares]
	lernvarg [n] [def: teaching aids] 
	leyenvarg [n] [def: reading material]
	loygvarg [n] [def: liquid detergent] % Forwards: S-R Schaechter
	luftvarg [n] [def: vaporware (advertized but unavailable goods) (computer)]
	nashvarg [n] [def: snack food]
	nervarg [n] [def: nutrient] 
	orga'nishvarg [n] [def: organic materials] % Yiddish League
	royvarg [n] [def: raw materials]
	roykhvarg [n] [def: smoking materials]
	shpilvarg [n] [def: playthings]
	shtubvarg [n] [def: household material]
	shukhvarg [n] [def: shoe materials] 
	tepvarg [n] [def: pottery] 
	veykhvarg [n] programvarg [n] [def: software (computer)]
	yungvarg [n] [def: youngsters] 
	zilbervarg [n] [def: silverware] 
	zisvarg [n] [def: sweet food] 
vart/V/T [def: wait] /Gop/Goys
	/Gtsu [def: wait a bit]
	/Giber/Gunter [def: wait out]
	dervart/V/Bdervart [def: await, expect] dervartung/N [f] [def: expectation] 
	umdervart/A [def: unexpected] 
	[idiom: haltn in vartn (oyfn telefon) = be on hold] [note: V] 
varyant/N [m] [def: variant]
	variatsye/S [f] [def: variation] 
	redvaryant/N [def: spoken variant] 
	varyatsye/S [f] [def: variation; (musical) variation] 
	varyabl/N [m] [def: variable (mathematics)] 
vaser/N/D [n] [def: water] /Iik /Idik [def: watery]
	blutvaser [n] [def: lymph] % Stutchkoff
	kvalvaser [n] [def: spring (water)] 
	matse{mch}-vaser [n] [def: water for baking matses]
		[idiom: loyfn vi nokh matse{mch}-vaser = run to get something]
		[idiom: khapn vi matse{mch}-vaser = buy something before it runs out]
	sheydvaser [n] [def: nitric acid (common name)] 
	vundervaser [n] [def: magic water] 
	za'ltsvaser [n] [def: saltwater; brine; ocean water]
	zeltservaser [n] [def: selzer water, sparkling water] % Sholem Aleykhem
	zeyfvaser [n] [def: soap water] % Avrom Karpinovitsh
	farvaser/V/Bfarvasert [def: water, wet] 
	bavaser/V/Bbavasert [def: irrigate] 
		bavaserung/N [f] [def: irrigation] 
	[idiom: ton a hant in kalt vaser = be involved in physical labor]
	[idiom: haltn zikh oyf vaser = float]
	[idiom: vi in vaser arayn = disappearing without a trace]
	[idiom: vi a fish in vaser = in one's element]
	[idiom: vi tsvey tropns vaser = very similar]
	[idiom: khapn vi matse{mch}-vaser = buy like crazy]
	[idiom: vi kumt di kats ibern vaser? = how can we overcome the obstacle?]
	[idiom: onnemen a ful moyl mit vaser = remain silent]
	[idiom: tsvishn fayer un vaser = in a difficult situation]
vash/V/Bgevashn [def: wash] /Garum/Gayn/Goys/Gop/Goyf/Giber/Gavek
	/Greyn [def: cleanse of impurity or sin]
	tsevash/V/Btsevashn [def: wash] 
	bavash/V/Bbavasht [def: soak]
	umgevashn/A [def: unwashed] 
	vesh [n] [def: laundry; underwear; linen] untervesh [n] [def: underwear]
		vesher/S [def: nighttime theif (thieves' argot)]
	vesher/S [m] ve'sherin/S [f] [def: washer (person)] 
		ve'shvasher/X [m] [def: washer (person)]
	vasher/S [m] [def: washer (machine)] 
		gefe's-vasher/S [m] [def: dishwasher] [note: V]
	[idiom: zikh vashn esn = wash the hands before eating]
vate [f] [def: cotton; cotton batting] /In [def: cotton] 
	vatove/A [def: cotton; quilted]
vatren{vWrn}/Xvatronem{vWrnym} [m] varente{vWrnte}/S [f] [def: generous person]
vayb/Eer [n/f] [def: wife; woman; rifle (soldiers' argot)] /D /Iish /Ilekh [def: female; feminine]
	kepsvayb/Eer [n] [def: concubine]
	klogvayb/Eer [n] [def: professional mourner]
	ma'rkvayb/Eer [n] [def: market woman]
	vay'berish/A vaybersh/A vayblekh/A vayberlekh/A [def: female] 
	bavaybt/A [def: married] 
	vay'bernik/Ees [def: womanizer, lecher] 
	[idiom: man un vayb = married couple]
vay-fay [m] [def: WiFi]
vayikro{|w|ykr#}/H [noun] [def: book of Leviticus] 
vayitsaku{|wycekw}/H [m] [def: outcry]
vayivrekh{|w|yBrH}/H [m] [def: escape, running away] 
	[idiom: makhn a vayivrekh{|w|yBrH} = escape, run away]
vaykh/V/T [def: move away; stay distant] /Goys [def: flee]
vayl [conj subordinating] [def: during, as long as; because]
	vaylik/A [def: temporary] % Forwards: Boris Sandler
		dervaylik/A [def: temporary]
	vayle/S [f] [def: while] 
	dervay'l [adv] dervay'ls [adv] dervayle [adv] [def: meanwhile]
	tsaytvaylik/A [def: temporary]
	vaylinke/S [def: little while] 
	langvayl/V/T [def: bore]
		langvaylik/K [def: boring]
		langvaylikayt [f] [def: boredom] 
		farlangvaylikt/A [def: bored] % Esther Kraytman: Briliantn
	vayl/V/T [def: stay; enjoy oneself (with "zikh")] % Harduf
	vay'letshke/S [f] [def: short time]
	zey'gervaylekhts [adv] [def: clockwise]
vayn/N [m] [def: wine] /Iik
	/Dvaymper [def: grape] % no positive; vaynperlekh is not recommended
	vaynshl/X [m] [def: sour cherry]
	mashlashn-vayn [m] [def: spiced wine] % Bashevis
	tsmukem-vayn{cymukym-vayn} [m] [def: raisin wine]
	vayner/S/X [def: wine-seller]
vaynrib/N [m] [def: vine]
vays/K [def: white] /Ier /Iink /Ilekh
	vayskayt/N [f] [def: whiteness] 
	farvays/V/Bfarvayst [def: whiten] 
	shneyvays/A [def: snow-white] 
	vaysl/Eekh [n] [def: egg white; white of the eye]
	vays/V/T [def: whitewash]
vayt/K [def: far; further, next (as "vayter")]
	/Iik [def: remote] /Ilekh [def: somewhat far] /Ierdik [def: next]
	vaytn/S [def: distance]
	vaytkayt/N [f] [def: distance]
	vaytenish/N [n] [def: distance]
	vaytn/A [def: distant] 
	dervayter/V/Bdervaytert [def: separate]
		dervaytertkayt/N [f] [def: separate status] 
		dervayterung/N [f] [def: distancing] 
	fundervaytns [adv] [def: from afar] 
vayz/V/Bgevizn [def: show] /Garoys/Goyf/Gon/Goys/Giber
	bavayz/V/Bbavizn [def: appear; show, prove; indicate; succeed (with infinitive)]
		/Garoys
		bavayz/N [m] [def: proof; evidence (in plural)] 
	dervayz/V/Bdervizn [def: show; proof] dervayz/N [m] [def: proof] 
	vayzer/S [m] [def: indicator, hand (clock or watch), needle (gauge)]
		likhtvayzer/S [m] [def: signal light] 
		vegvayzer/S [m] [def: directory, guide, guidebook]
	onvayz/N [m] [def: example; indication, proof]
		sto'ponvayz/N [m] [def: stop sign] % Yiddish League
		onvayzung/N [f] [def: proof, indication; instruction] 
	foroysvayz/N [m] [def: advance showing (drama, film)]
	vayzfinger/S [m] [def: index finger]
	oysvay'zenish [n] [def: appearance, mirage] 
vaze/S [f] [def: vase]
	vazon/N/Ees [m] [def: flower pot] 
vazeli'n/N [m] [def: vaseline] 
vazhne/A [def: fine] 
ve/Een [m] [def: the letter V] 
	to'plve/Een [m] [def: the letter W] 
veb/V/T [def: weave] /Gayn/Gdurkh/Goys/Gtsunoyf/Garayn
	veb [m] [def: web]
		shpinvebs shpi'ngeveb [n] [def: spider web] shpinvebekhts/N [n]
		geve'b/N [n] [def: web; tissue (body part); material; weave] 
			va'ntgeveb/N [n] [def: tapestry]
			li'mfgeve'b/N [n] [def: lymphatic tissue] % Stutchkoff
	bavebt/A [def: woven] farvebt/A [def: woven] 
	veber/S [m] ve'berke/S [f] [def: weaver] 
	veberay'/N [f] [def: weaving machine]
vedlik [prep] [def: according to; concerning]
vedme/S [f] [def: witch] 
veg/N/D [m] [def: way; road, path]
	avek aveket [adv] [def: away]
		[idiom: eyn mol avek = that's number one]
	durkhveg/N [m] [def: shortcut; passageway]
	forveg/N [m] [def: road; (traffic) lane]
	evakui'r-veg/N [m] [def: evacuation route] % Yiddish League
	eynvegs [adv] [def: at the same time (with "in")]
	feldveg/N [m] [def: field path]
	geyveg/N [m] [def: pathway] % Shpiglblat
	hinterveg/N/D [m] [def: byway]
	kreytsveg/N [m] [def: crossroad, intersection]
	lebnsveg/N [m] [def: life path]
	milkhveg [m] [def: Milky Way] 
	onleygveg/N [m] [def: detour; roundabout way] 
	oysveg/N [m] [def: exit] 
	sheydveg/N [m] [def: fork (in road)] 
	shpatsi'rveg/N [m] [def: walking path] % Forwards: Boris Sandler
	shlitveg/N [m] shlitnveg/N [m] shlitvegs/X [m] [def: sled path]
	toytnveg/N [m] [def: death path]
	umveg/N [m] [def: detour]
	unterveg/N [m] [def: byway]
	vanderveg/N [m] [def: wanderer's road] 
	zaytnveg/N/D [m] [def: side road] 
	tsurikvegs [adv] [def: backward]
	untervegs [adv] untervegns [adv] [def: on the way]
	[idiom: redn fun veg = be delirious] % Bashevis
veg/V/Bgevoygn [def: weigh] /Gop
	/Giber [def: outweigh; re-weigh] 
	bavog/V/Bbavoygn [def: weigh] 
	vog/N [f] [def: weight (measure); scale] /Iik [def: heavy] 
		vo'gikayt/N [f] [def: weightiness] % Rokhl Boymvol
		o'nvo'gikayt/N [f] [def: weightlessness] % Yiddish League
		[idiom: arop fun vog = having lost weight]
	opgevoygnkayt/N [def: thoughtfulness] % Sholem Aleykhem
	vogshl/N vogshol/N [f] [def: scale, scale dish]
	baveg/V/Bbavegt [def: move]
		bavegung/N [f] [def: movement, movement]
		baveglekh/A [def: movable]
		umbaveglekh/A [def: immovable] 
	gevi'kht/N [n] [def: weight (object)] /D /Iik [def: weighty]
		glay'khgevi'kht glaykhvog [f] [def: balance, poise]
		kegngevikht [n] [def: counterweight] % Forwards: Boris Sandler
veganish/A [def: vegan, absolute vegetarian] % Forwards: Yoel Matveyev
vegetaryer/X [m] [def: vegetarian] vegetarish/A [def: vegetarian]
	vegeteryaner/X [m] vegeteryantse/S [f] [def: vegeterian] % Sholem Aleykhem
	vegeteryani'zm [m] [def: vegetarianism] % Sholem Aleykhem
	vegeteryanish/A [def: vegetarian] % Sholem Aleykhem
vegs- [prefix] [def: travelling]
vek/V/T [def: awaken, wake] /Goyf/Goys/Giber
	dervek/V/Bdervekt [def: awaken; be roused (with "zikh")] 
	veker [m] [def: awakener, alarm clock] /D
veksl/N [m] [def: exchange; bill of exchange; promissory note] /Dveks
	veksl/N [def: exchange; change (clothes)]
		veksl/V/T [def: exchange; change (clothes)] [usage: not recommended]
	veksler/S [m] [def: money-changer; banker]
	veksl-geshe'ft/N [n] [def: exchange business]
ve'ktor/N [m] [def: vector (mathematics)]
vel vest vestu vet veln [verb] [def: will (future)] [grammar: takes infinitive]
	khʼvel [def: I will]
	velekhts/N [n] [def: desire]
velk/V/T [def: wither]
	farvelk/V/Bfarvelkt [def: wither] 
velkher [adj] velkhes [adj] velkhn [adj] velkhe avelkhe [adj] [def: which]
	% velkh/A generates bad forms: velkhs, velkh
velosipe'd/N [m?] [def: bicycle] /D
	velosipedi'st/N [m] [def: bicyclist] % Forwards: B. Sandler
velsh/N vels/N [m] [def: catfish]
velshn/A veltshn/A velish/A [def: walnut (food) (with "nus")]
velt/N/D [f] [def: world] /Iish
	veltlekh/K [def: worldly; secular]
		alveltlekh/A [def: old-worldly] 
		veltlekhkayt/N [f] [def: worldliness] veltishkayt/N [f]
	hayntveltik/A [def: modern]
	sportvelt/N/D [f] [def: world of sports] 
	untervelt/N/D [f] [def: underworld, criminal society]
		unterveltnik/Ees [m] [def: underworld character]
	vundervelt/N/D [f] [def: world of wonders]
	yeneveltik/A [def: of the world to come]
		yenveltik/A [def: otherworldly]
	oysveltlekh/A [def: unworldly]
	alveltlekh/A [def: world-wide] 
	[idiom: zint di velt iz a velt = it's always been this way]
	[idiom: stam{sWm} in der velt arayn = without evident purpose]
	[idiom: klingen/shemen mit emetsn a velt = be famous]
	[idiom: oyf vos di velt shteyt = exceedingly]
	[idiom: gut/klug/sheyn vi di velt = very good/clever/pretty]
	[idiom: visn a velt = know a lot]
	[idiom: kern veltn = be energetic]
	[idiom: a velt mit = many/much]
	[idiom: ikh veys nit oyf velkher velt ikh bin = I'm confused]
velvl/A volvl/A [def: cheap] /Kvelvl
ven [conj subordinating] [def: when; when (interrogative); if (contrary to fact)] 
	vens [adv] [def: ever] 
	farve'n [def: why (interrogative)] [usage: usually with "farvos un"]
	a'ndershve'n [def: another time]
	[idiom: eyder vos un eyder ven = immediately]
	[idiom: ven nit ven = sometimes]
	[idiom: vos-ven = at some time]
vend/V/T [def: turn; depend on (with "zikh in")] /Gop/Gon
	gevondn/A [def: turned]  % alternative participle
		/Gon [def: apply (with "in")] 
		/Gtsu [def: approach, turn to]
	aynvend/N [m] [def: objection]
	vendung/N [f] [def: turning]
	onvendung/N [f] [def: application] 
		onvendlekh/A [def: applied]
	farvendtkayt/N [f] [def: pampered, spoiled (child) (German Verwöhntheit)] % Hersh Nomberg
	[idiom: es vendt zikh = it depends]
	[idiom: ongevendte forshung = applied research]
vendzl/V/T vyondzl/V/T [def: smoke (as in fish)]
vene/S [f] [def: vein] 
	intravene'z/A intravenish/A [def: intravenous]
	[idiom: untergisn intravenez = intravenous drip] [note: V] 
ventilatsye [f] [def: ventilation] 
	ventilator/N [m] [def: fan, ventilator] 
ventke/S [f] [def: fishing rod]
vep/V/T [def: vaporize]
	/Goys [def: evaporate]
	vep/N [m] vepekhts/N [n] [def: vapor]
ver/V/Bgevorn [def: become]
ver/V/T [def: defend; forbid]
	/Gon [def: lose; forfeit]
	/Gop [def: ward off; dispell; prevent (with "fun"); defend self (with "zikh")]
	geve'r/N [n] [def: defense; weapon, arms]
	farver/V/Bfarvert [def: prohibit, forbid] 
		[idiom: reykhern farvert = no smoking] [note: V] 
	opver [adj] [def: defense] % uninflected, as in opver-kamf
ver [pronoun (subjective)] [def: who] 
	vemen vem [pronoun (objective)] [def: whom] 
	vemes vemens [pronoun (possessive)] [def: whose]
	[idiom: vi bay vemen = everyone to his own tastes]
	[idiom: nit abi ver = not just anybody]
verande/S [f] [def: veranda, porch] 
verb/N [m] [def: verb]
	konverb/N [m] [def: adverbial complement (grammar)] 
	verbal/A [def: verbal (spoken)] 
verbe/S [f] [def: willow] 
verbi'r/V/Bverbi'rt [def: solicit, recruit, canvass] 
	derverb/V/Bdervorbn [def: achieve; acquire; conquer]
verg/V/Bgevorgn [def: strangle; choke] varg/V/Bgevorgn % both forms
	dervarg/V/Bdervorgn derverg/V/Bdervorgn [def: suffocate; choke]
vergele'ts/N [m] [def: youth]
verk/X [n] [def: work]
	fayerverk/X [n] [def: fireworks]
	hantverk/X [n] [def: handicraft] hantverker [m] [def: handcrafter] 
		hantverkeray'/N [n] [def: handicraft] 
		ha'ntverkung/N [f] [def: handwork] 
	kroynverk/X [n] [def: magnum opus, principal work]
	kunstverk/X [n] [def: art] kunstverker [m] [def: artist]
	tantsverk/X [n] [def: dance (artistic)] % Forwards: S-R Schaechter
	geve'rk/N [n] [def: mechanism] 
versye/S [f] [def: version]
vert/N [f/m] [def: value; worth]
	verde/S [f] [def: dignity; worth] 
		ze'lbstve'rde/S [f] [def: self-respect] % Michael Wex
	vertik/A verdik/A vertful/A [def: dignified; worthy]
		gedenkverdik/A [def: memorable] 
		gley'bverdik/A [def: plausible; truthful]
		merkverdik/K [def: noteworthy, remarkable]
		umverdik/A [def: unworthy] umverdikayt/N [f] [def: unworthiness] 
		farumverdik/V/Bfarumverdikt [def: make or declare unfit] 
		virdik/A [def: dignified; worthy] [usage: inadmissible]
			umvirdik/A [def: unworthy, sinful] [usage: inadmissible]
			umvi'rdikayt/N [f] [def: unworthiness, sinfullness] [usage: inadmissible]
	[idiom: der hunt iz vert dem shtekn = he deserves his fate]
vertlik/Ees [m] [def: some sort of food ??] % Sholem Aleykhem
vertu't/N [m] [def: small pastry, usually cheese-filled]
ve'shlke/S [f] [def: clothes hanger] [usage: doubtful admissibility]
vesle/S [f] [def: oar] vyosle/S [f]
	vyos'leve/V/T [def: row] /Garoyf
vesne [f] [def: Spring (season)] 
vest_{vsW}/H [f] [def: menstruation]
vest/N [f] /D [def: vest (clothing)]
vestibu'l [m?] [def: vestibule]
vet/V/T [def: wager, bet (with "zikh")] 
	vet/N [m] vete/S [f] geve't/N [n] [def: bet, wager] geve'tenish/N [n]
veter/N [m] [def: weather] 
	tseveterung/N [f] [def: weathering, erosion] 
	umveter/N [m] [def: bad weather]
	geviter [m] [def: weather]
		shney-geviter [m] [def: snowy weather]
		umgeviter [m] [def: bad weather]
veteran/N [m] [def: veteran] 
veterina'r/N [m] [def: veterinarian] 
veto/S [m] [def: veto] 
	vetoi'r/V/Bvetoi'rt [def: veto] 
ve'tshere/S [f] [def: evening meal, supper] 
vevrik/S/D [m] [def: squirrel]
	ve'verke/S [f] [def: chipmunk; squirrel] 
vey/N [m] [def: woe; pain] 
	vey [interj] [def: woe!] 
	vey'enish/N [n] [def: pain]
		nokhvey/N nokhvey'enish/N [n] [def: residual pain]
		trogvey'enish/N [n] [def: labor pang] 
	nokhvey/N [m] [def: suffering]
	veytik/N [m] [def: pain] veytog/N [m] % variant spelling
		veytiklekh/K [def: painful]
		veytikdik/A [def: painful] 
		/Dveytik [n] [def: short jacket (humorous, pejorative)]
		ha'ldzveytik/N [m] [def: sore throat]
		ha'rtsveytik/N [m] [def: heartache]
		bo'ykhveytik/N [m] [def: stomach ache]
		ko'pveytik/N [m] [def: headache] 
		shte'khveytik/N [m] [def: sharp pain]
		tsey'nveytik/N [m] [def: toothache]
		vu'ksveytik/N [m] [def: growing pains] [note: V]
	veytik/V/T [def: ache] /Gon
		farveytikt/A [def: torture] 
	tseveytik/V/Btseveytikt [def: pain] 
	veytuendik/A [def: painful] 
	[idiom: vey iz mir = woe is me!]
	[idiom: es tut mikh vey = it hurts]
veye/V/T [def: blow (wind)]
veytikl/Ekh [n] [def: short jacket (clothing)]
veydl/N [m] /Dveyd veyndl/N [def: tail (body part); penis (body part)] 
	nashnveydl [n] [def: Cinderella] 
	[idiom: makhn mitn veydl = wag one's tail]
veye/V/T [def: blow (wind); winnow] 
	veye/N [m] [def: flurry] 
	farveyet/A [def: windswept] % Bashevis
veyk/V/T [def: soak] /Goys/Gdurkh/Gunter/Gayn
	tseveyk/V/Btseveykt [def: be drenched (with "zikh")]
	veykshaft/N [f] [def: koshering pot] 
veykh/K [def: soft] /Iink [def: small and soft] 
	farveykher/V/Bfarveykhert [def: soften, weaken] % Forwards: Krutikov
	veykhkayt/N [f] [def: softness] 
	vey'khenish/N [f] [def: pulp]
veyl/V/T [def: select, elect] [usage: inadmissible] /Goys
	derveyl/V/Bderveylt [def: select] /Goys
		oysderveyltkayt/N [f] [def: specialness] 
	-/Xvaln [def: election]
		-/Xtsuriktsi-valn [def: recall election] [note: V] 
	oysval/N [m] [def: choice, selection (often with "makhn")] 
	veyler/S [m] [def: voter]
veyn/V/T [def: cry, weep] /Gon/Goys/Gmit/Gop/Garayn/Garoys/Gfunander
	gevey'n/N [n] [def: groan; lament] geveyneray'/N [n] [def: groaning] 
	tseveyn/V/Btseveynt [def: cry for a while (with "zikh")] 
	farveyn/V/Bfarveynt [def: bemoan]
		farveynt/A [def: tearful] 
		farveyntkayt/N [f] [def: sorrow] 
	baveyn/V/Bbaveynt [def: lament, mourn]
		baveyner/S [m] bavey'nerke/S [f] [def: cryer] 
	antveyn/V/Bantveynt [def: wean]
	ve'ynerin/S [f] [def: professional mourner]
veynik/K [def: less (for non-countable nouns)]
	i'nveynik/K i'neveynik/K i'nenveynik/K i'nerveynik/K [def: internal, inside]
	oy'snveynik [adv] oy'sveynik/K [def: outside, external; by heart (with "fun" or "oyf")] 
		oy'snveynik/N [m] [def: outside] 
		oy'snveynikst/A [def: outside] 
	veynikstns [adv] [def: at least] 
		amveynikstn [adv] [def: least of all]
	veynikayt/N [f] [def: fewness, smallness] 
	[idiom: mer (oder) veyniker = give or take; approximately]
	[idiom: mayn veynikayt = I]
veys/Vvisn/Bgevust [def: know] % < PIE *weid- "see"
	bavust/A [def: famous] umbavust/A [def: unknown] 
	bavustzayn [n] [def: consciousness]
		bavustzinik/A [def: conscious] 
		umbavustzinik/A [def: unconscious]
			umbavustzi'nikayt/N [f] [def: unconsciousness; the unconscious]
		u'nterbavu'stzayn [n] [def: subconscious (psychology)]
	dervis/V/Bdervust [def: get wind of, learn, find out (with "zikh")] 
	visn/S [m] [def: knowledge] 
	visnshaft/N [f] [def: science] /Ilekh [def: scientific]
		visnshaftler/S [m] [def: scientist] 
		umvisnshaftlekh/A [def: unscientific]
	umvisndik/A [def: unwitting]
		umvisn [n] umvisnhayt/N [f] umvisndikayt/N [f] [def: ignorance] 
	visik/A [def: conscious] u'mvisik/A [def: unconscious]
		visikayt/N [f] [def: knowledge]
			shprakhvisikayt/N [f] [def: knowledge of languages] 
		untervisikayt/N [f] [def: subconscious (psychology)] 
		u'mvisikayt/N [def: unconscious (psychology)]
	gevi'sn/S [n] [def: conscience] /Idik [def: scrupulous; conscientious]
		[idiom: lign afn gevisn = lie on one's conscience]
	gevis/A [def: certain; particular]
		geviskayt/N [f] [def: certainty]
	altsveysndik/A [def: omniscient] % Avrom Karpinovitsh
	[idiom: men zol visn = for the record]
	[idiom: zolst visn (zayn) = zay visn = megst visn = for your information]
	[idiom: lozn visn = gebn tsu visn = keep posted, inform]
	[idiom: zikh makhn nit visndik = ignore]
veyshet{vSt}/N [m] [def: esophagus, gullet (body part)]
veyts [m] [def: wheat] /In [def: wheaten] 
vezn/S [n] [def: being; fuss]
	shulvezn/S [n] [def: school system] 
	vezntlekh/A [def: actual; systematic] 
	onveznhayt/N [f] onveznkayt/N [f] [def: presence] [usage: inadmissible]
	onvezndik/A [def: be present (with "zayn")] [usage: inadmissible]
vi [adv] [def: how; as]
	vibald [adv] [def: so long as] 
vibor/Ees [def: election (Russian выбор "choice")] 
vibri'r/V/Bvibri'rt [def: vibrate] /Gdurkh
	vibratsye/S [f] [def: vibration]
vide{vydwy}/Xviduem{vydwym}/H [f] [def: confession; penitential prayer vidui] 
	misvade{mTvdh} [verb] [def: confess sins (with "zayn zikh")]
video/S [m] [def: video] 
	videote'k/N [f] [def: video library] % Forwards
vider [adv] [def: again; on the other hand] 
vider [m] [def: repulsion]
	dervider/V/Bdervidert [def: answer; disagree; talk back]
		dervider [def: disgust] /Idik
	vidershpenik/V/Bvidershpenikt [def: disobey] % should be moved to shpan/V
	vidershpenik/A [def: contrary; disobedient]
	kider-vider [m?] [def: antagonism]
	[idiom: er iz mit mir kider-vider = we hate each other]
vider/S [m] [def: ram]
vidle/S [f] vile/S [f] [def: pitchfork (tool)]
vidme/V/T [def: dedicate] /Gop
	vidmenung/N [f] [def: dedication] 
vidmen/V/T [def: swarm, multiply, teem]
	vidmung/N [f] [def: swarming, teeming]
vidre/S [def: otter (animal)]
vie/S [f] [def: eyelash] 
vig/V/T [def: rock; swing] /Giber/Gfunander
	farvig/V/Bfarvigt [def: rock] 
	tsevig/V/Btsevigt [def: rock] 
	gevi'g/N [m] [def: rocking]
	vig/N /D [f] [def: cradle] 
vi'grishne/A [def: lottery (with "bilet")
vike [f?] [def: Vicia, genus of Fabaceae] % Forwards: Hershl Glaser
vikher/S [m] [def: whirlwind] 
	vikher/V/T [def: whirl, rush] /Garop/Garum
vikhetsh/N/Ees [m] vikhet/N [m] [def: wash cloth; dish cloth]
vikhtik/K [def: important, major]
	vikhtikayt/N [f] [def: importance] 
vikl/V/T [def: wrap; diaper] /Gayn/Garoyf/Goyf/Garum/Gop/Goys
	/Gfunander [def: unwrap]
	tsevikl/V/Btseviklt [def: wrap] 
	farvikl/V/Bfarviklt [def: wrap] 
	/Dvik [def: wrap] 
vikuekh{vyKwH}/Xvikukhem{vyKwHym}/H [m] [def: argument, polemic, dispute, debate]
	moykhiyekh{mwxyH}/H [m] [def: accuser, scolder]
vil/Vveln/Bgevolt [def: want]
	velndik/A [def: willing]
	bavilik/V/Bbavilikt [def: grant, accord, deign (with "tsu")]
	vilik/K [def: willing]
		beyzvilik/A [def: antagonistic; hateful]
			beyzvilikayt/N [f] [def: hate]
		umvilik/K [def: unwilling]
		frayvilik/A [def: freely willing, volunteer] 
	farvil/V/Bfarvolt farveln [def: desire (with "es - zikh")]
	vilndik/A [def: intentional] nishtvilndik/A [def: unwilling] 
	viln/S [m] [def: will, desire] 
		folksviln/S [m] [def: will of the people] % Forwards: Khariton Berman
		umviln/S [m] [def: unwillingness]
		[idiom: kegn undzer (ey'genem) viln = under protest] [note: V] 
	khʼvil [def: I want]
	viderviln [m?] [def: revulsion] 
	veler/X/S [n] [def: urge; lust; greedy person, persistent person]
vild/K [def: wild]
	vildkayt/N [f] [def: wildness]  vi'ldenish/N [f] [def: wilderness] 
	vi'ldeve/V/T [def: rampage] 
	farvi'ldeve/V/Bfarvildevet [def: rampage, run wild, degenerate]
	tsevi'ldeve/V/Btsevildevet [def: rampage] 
	gevi'ld/N [m] [def: game animal]
vile/S [f] [def: villa; summer home]
vilgotsh/X [def: dampness]
vilkir [def: brutality] [usage: not recommended] [origin: German Willkür]
viml/V/T [def: be crowded; teem] [usage: not recommended]
	vimldik/A [def: crowded; teeming]
	geviml [m] [def: crowd]
vimorozik [m] [def: freeze-concentrated syrupy wine]
vinakush [def: sex appeal]  % from Yekhiel Shraybman, via Sheva Zucker
vind [def: misfortune ("vey un vind")] 
vinde/S [f] [def: elevator (Polish winda)]
vindl/N [m] vindele/Ekh [n] [def: diaper]  % < PIE *uendh- (to turn, wind, wend)
	vindl/V/T [def: diaper] 
		/Giber [def: change diapers] 
	[idiom: la'yvntener vindl = geva'ntene vindele = cloth diaper] [note: V]
vink/V/Bgevunken [def: wink; sparkle; gesture] /Gon/Garop/Gunter/Giber
	vunk/N [m] [def: wink]
	onvunk/N [m] [def: wink] 
	[idiom: farshteyn zikh oyfn vunk = comprehend immediately]
vinkl/N [m] [def: corner; angle] /Dvink
	kukvinkl/N [m] [def: standpoint] 
	farvinklt/A [def: full of corners]
	grodvinkldik/A [def: right-angled] 
	hoy'fvinkl/N [m] [def: corner of a courtyard] % Kulbak: Zelmenyaner
	parkvinkl/N [m] [def: corner of a park] % Forwards: Boris Sandler
	shodnvinkl/N [m] [def: spirit of destruction; damager]
	sodvinkl/N [m] [def: corner of an orchard] % Bergelson
	[idiom: groder vinkl = right angle]
vint/N/D [m] [def: wind] /Iik
	tsevintl/V/Btsevitlt [def: flutter (with "zikh") (poetic)]
	boykhvint/N [m] [def: flatus, release of gas, fart]
	shtu'remvint/N [m] [def: storm wind]
	vi'rblvint/N [m] [def: whirlwind] 
	zu'mervint/N [m] [def: summer wind] 
	[idiom: lebn fun vint = without visible means of support]
vinter/S/N [m] [def: Winter (season)] /Idik /Iik [def: wintry] 
vintsh/V/Bgevuntshn [def: wish] /Gop/Gon/Gtsu
	vi'ntsheve/V/T [def: wish] /Gop/Gon/Gtsu
	vintshevanye/S [f] [def: good wishes] 
	vintshung/N [f] vuntsh/N [m] [def: wish] 
	vintshnsvert/A [def: desirable]
	umgevuntshn/A [def: undesirable, unwanted]
vintsik/K [def: few] /Ilekh [def: few] 
	vintsikstns [adv] [def: at least] 
	[idiom: mer oder vintsiker = fil-vintsiker = give or take; approximately]
	[idiom: vintsik vos = not much]
vinye't/N [m] [def: vignette]
viprave/S [f] [def: trousseau ?? (Polish wyprawa)] % Stutchkoff
virbl/V/T [def: seethe, whirl] 
	gevi'rbl/N [n] [def: whirling]
	vaservirbl/N [n] [def: whirlpool] % Forwards: Boris Sandler
vire/S [def: ruler]
	umgevirt/A [def: unruled, unlined]
	tseviret/A [def: lined (notebook)] % Forwards: Mishe Lev
virk/V/T [def: have an effect; cause] /Gayn/Goyf/Goys
	virkung/N [f] [def: effect] 
		oysvirkung/N [f] [def: effect] % Forwards
	virklekh/A [def: real; indeed]
		virklekhkayt/N [f] [def: reality] umvirklekhkayt/N [f] [def: unreality] 
		umvirklekh/A [def: unreal]
	virkzam/A [def: real, actual] [usage: inadmissible]
	farvirklekh/V/Bfarvirklekht [def: effect, realize, accomplish]
	bavirk/V/Bbavirkt [def: have an effect; cause] 
virobek/Xvirobkes [m] [def: factory worker (Polish wyrobnik)] % Sholem Asch: Motke Ganef
virt/N [m] [def: proprietor; boss; owner]
	hoyzvirt/N [m] [def: building owner]
		hoyzvirtshaft/N [f] [def: ownership]
	virtshaft/N [f] [def: economy] [usage: inadmissible]
		/Ilekh [def: of the economy] [usage: inadmissible]
	landvirtshaft/N [f] [def: national economy] [usage: inadmissible] /Ilekh
virts/V/T [def: season (with spices)]
	bavirts/V/Bbavirtst farvirts/V/Bfarvirtst [def: season (with spices)]
	virtsung/N [f] [def: seasoning]
	gevi'rts/N [n] [def: spice]
		gevi'rtslt/A [def: spicy] % Forwards: Boris Sandler
	gevirtsik/A virtsik/A [def: spicy] 
virtue'l/A [def: virtual] % Forwards
virtuo'z/N [m] [def: virtuoso] /Iish/In
	virtuozkayt/N [f] [def: virtuosity]
virus/N [m] [def: virus]
virvar [m] [def: chaos, disorganization, commotion]
vish/V/T [def: wipe] /Gop/Goys/Garoys
	/Gnokh [def: mop up] 
	farvish/V/Bfarvisht [def: wipe away] 
	dervish/V/Bdervisht [def: wipe; catch; trace, track down] 
	federvish/N [m] fledervish/N [m] [def: feather duster]
	shtroyvish/N [m] [def: straw whisk]
vishke/S [f] [def: rein]
vishnik [m] [def: cherry brandy]
viski/S [m] [def: whiskey] 
viskrobik/Ees [m] [def: youngest child]
	vishkrobik/Ees [m] [def: unwanted child] % Sholem Aleykhem: Bashefenish
vispe/S [f] [def: island] 
visper/V/T [def: whisper] % Opatoshu: Polishe Velder
vist/A [def: empty; desolate; dismal, wretched]
	vi'stenish/N vistkayt/N [f] [def: desolation; wasteland, desert]
	farvi'st/V/Bfarvi'st [def: desolate]
		farvistung/N [f] [def: desolation; destruction]
vist [m] [def: whist (card game)]
vistave/S [f] [def: show window; exhibition]
	vistavke/S [f] [def: exhibition] [usage: not recommended]
vitami'n/N [m] [def: vitamin] 
vitrine/S [f] [def: display case, shop window, showcase]
	vitrazh/N [def: stained-glass window] 
vits/N [m] [def: joke] /Iik /Iedik [def: witty; joking] 
	vitsl/V/T [def: joke (with "zikh")]
		tsevitsl/V/T [def: joke (with "zikh")] % Sholem Aleykhem
	vitsling/N [m] [def: wit, comic, jester]
	[idiom: privater vits = inside joke] [note: V]
vitse [def: vice (president)] 
viva't/N [def: ovation, cheer; wedding dance tune] 
	viva't [interj] [def: hurrah!]
vizavi [m?] [def: interlocutor] % Forwards: B. Sandler
vize/S [f] [def: visa] 
vize/S [f] [def: lawn, meadow, pature, prairie] 
vizele/Ekh [n] [def: weasel] 
	[idiom: dos shvarts-fusike vizele = American ferret]
vizge/V/T [def: yelp]
vizit/N [m] [def: visit]
vizye/S [f] [def: vision]
	vizue'l/A [def: visual] 
vodevil [m?] [def: vaudeville]
vofn/S [m] [def: weapon]
	gevofnt/A ongevofnt/A [def: armed]
	bavofn/V/Bbavofnt [def: arm] 
		bavofenung/N [f] [def: arming; armament]
	antvofn/V/Bantvofnt [def: disarm] 
	vofenung/N [f] onvofenung/N [f] [def: armament]
vogl/V/T [def: wander] /Garum
	vo'glenish/N [n] [def: wandering] 
	farvoglt/A [def: homeless; far from home]
vokabula'r/N [m] [def: vocabulary] 
voka'l/N [m] [def: vowel] /Iish [def: vocalic]
	vokalizi'r/V/Bvakalizi'rt [def: vocalize] 
vokh/N [f] [def: week] /Iik /Indik vekhntlekh/A [def: weekly]
	vokhedik/A [def: everyday, ordinary]
		vokhedikayt/N [f] [def: ordinary nature]
	kushvokh/N [f] [def: honeymoon]
	mitvokh/N [m] [def: Wednesday]
	vokhnik/Ees [m] vokhernik/Ees [m] vokherer/S [m] [def: usurer, lender]
		vukherer/X [m] [def: usurer] [usage: not recommended]
		vokher [m] [def: weekly payment on a loan]
	indervokh [def: weekday] /Iedik [def: week-day] 
		indervokhn [def: weekday]
	vokhntog [m] [def: weekday]
	eynvokhik/A [def: one-week old] % Forwards: Boris Sandler
	tsveyvokhndik/A [def: two-week] 
vokzal/S/N [m] [def: train station] /Dvokzalkh % < Russian вокзал < London Vauxhall Gardens
vol [f] [def: wool] /In [def: woolen] 
	volek/Ees volik/Ees [def: felt boot] 
	volitshke [f] vlotshke [f] [def: wool yarn] % L. Shapiro
	bavl [m] boyvl [m] banvl [m] [def: cotton; thread] [origin: boym vol] % J. Opatoshu: lintsheray
		/Dbavl [def: thin thread] % Forwards: Boris Sandler
volf/N/Xvelf [m] [def: wolf] /Iish [def: wolf-like] 
	ve'lfikhe/S [f] vo'lfikhe/S [def: she-wolf]
volkn/S [m] [def: cloud] /Idik [def: cloudy] /Dvolknd
	farvolknt/A [def: cloudy] 
	volken/V/T /Gon [def: become cloudy (with "zikh")]
vo'lkelak/Ees/N [m] vo'vkelak/Ees/N [m] vovkela'ke/S [f] [def: werewolf (mythical animal)]
volost [m?] [def: administrative district (Russian волость "town")]
volt/N [m] [def: volt (electrical)]
	voltazh/N [m] [def: voltage] 
volt/V/T [def: would] [grammar: takes infinitive]
	volst volstu [verb] % acceptable variant to voltstu
	mʼvolt [def: one would]
volunti'r/V/Bvolunti'rt [def: volunteer]
	volonti'r/N [m] volunti'r/N [m] volonte'r/N [m] [def: volunteer]
volye/S [f] [def: gizzard (fowl); goiter]
von [interj] [def: get away]
vonts/N [m] [def: whisker; moustache] vontse/S [f]
	/D [def: whiskers of an animal] % Harduf
	[idiom: shmirn iber der vontse = butter up, flatter, adulate]
vor [f] [def: reality] farvor [interj] [def: really] 
	vor/A [def: true, actual, real]
	vorhayt/N [f] [def: truth] % Harduf
	vorhaftik/A [def: true, real]
vor/A [def: awake]
	vor [def: state of being awake] 
	[idiom: oyf der vor = awake]
vorem vorn [conj] [def: because]
vorem/Xverem [m] [def: worm] /Dverem
	bandvorem/Xbandverem [m] [def: tapeworm] % Yiddish League
	glivorem/Xgliverem [m] [def: firefly] % Y. Y. Singer
	lindvorem/Xlindverem [m] [def: dragon] 
	farveremt/A [def: wormy] % Forwards: Yoel Matveyev
	[idiom: lakhn mit grine verem = laugh bitterly]
	[idiom: onkumen mit grine verem = be very difficult]
vo'retshik/Xvo'retshkes [def: sack]
vorke/V/T [def: coo (sound of a dove)] 
vorn/V/T [def: warn] 
	bavorn/V/Bbavornt [def: safeguard (with "zikh")] 
		bavo'rntkayt/N [f] [def: security]
		bavo'renish/N [n] [def: safeguard, precaution] 
	vorenung/N [f] vorenish/N [n] [def: warning] 
	gevorntkayt/N [f] [def: wariness] 
vorobey' vorobeytshik/Ees [m] [def: sparrow] /D
voron/Ees [m] vorone/S [f] [def: crow (bird)]
	zheyvoronke/S [f] [def: a kind of bird] % Rokhl Korn: Erd
vort/Xverter [n] [def: word]
	verterdik/A [def: word-like]
	vertl/Eekh vertele [n] [def: witty saying]
		gikhvertl/Xekh [n] [def: toungue-twister] % Forwards: Genadi Estraykh
		vertldik/A [def: witty, jovial]
		tsevertl/V/Btsevertlt [def: spar verbally]
	bindvort/Xbindverter [n] [def: conj (grammar)] 
	dankvort/Xdankverter [n] [def: thank-you speech] 
	forvort/Xforverter [n] [def: forword, preface] 
	gezegnvort/Xgeze'gnverter [n] [def: parting word] 
	ernvort/Xernverter [n] [def: word of honor; parole] 
		[idiom: oyf ernvort = on parole]
	glaykhvort/Xglay'khverter [n] /Dglaykhvert [def: witticism]
		glaykhvertl/Xglaykhvertlekh [n] [def: witticism]
		glaykhvertik/A [def: wittily said] 
	farfi'rvort/Xfarfi'rverter [n] [def: misnomer] 
	folksvort/Xfo'lksverter [n] [def: expressions] % Sholem Aleykhem
	hoyptvort/Xhoy'ptverter [n] [def: noun (grammar); main point] 
	klogvort/Xklo'gverter [n] [def: complaint] % Forwards: Boris Sandler
	layvort/Xlayverter [n] [def: loan word]
	libevort/Xlibeverter [n] [def: affectionate term] % Forwards: Hershl Glaser
	nokhvort/Xno'khverter [n] [def: final word, postscript]
	shlogvort/Xshlo'gverter [n] [def: slogan, motto]
	shpetvort/Xshpe'tverter [n] [def: jocular speech]
	shprikhvort/Xshpri'khverter [n] /Dshprikhvert [def: folk saying] 
	shtekhvort/Xshte'khverter [n] /Dshtekhvert [def: verbal jab] 
	trepvort/Xtre'verter [n] [def: missed bon mot opportunity] 
	treystvort/Xtreystverter [n] [def: consolation, solace]
	tsaytvort/Xtsay'tverter [n] [def: verb (German)]
	zakhvort/Xzakhverter [n] [def: noun] 
	zhargonvort/Xzhargonverter [n] [def: jargon] % Forwards: Itsik Gottesman
	zidlvort/Xzi'dlverter [n] /Dzidlvert [def: curse word]
	ve'lt|svertl/Eekh fo'lksvertl/Eekh [n] [def: folk saying] 
	vortirer/S [m] [def: word processor] % neologism
	vertl/V/T [def: jest]
		/Gdurkh /Giber [def: quarrel, dispute (with "zikh")] 
		durkhgevertlt/A [def: angry] 
	[idiom: nemen a vort = have a say]
	[idiom: zogn a yidish vort = read aloud a religious text in Hebrew]
vortshe/V/T [def: turn restlessly; growl, grumble] /Gunter
	vortsh/N [m] [def: growl] % Harduf
vortsl/V/T [def: root]
	/Gayn [def: plant]
	/Goys [def: uproot; excise] 
	farvortsl/V/Bfarvorstlt [def: root] 
	vortsl/N [m] [def: root] /Iish [def: root-like] /Dverts
		boymvortsl/N [m] [def: tree root] 
		tsonvortsl/N [m] [def: root (dental)] 
		urvortsl/N [m] [def: origin] % Forwards: Yoel Matveyev
vos voser/A voden vozhe vosi [def: what, why (interrogative); that (conj); something, someone (pronoun)]
	vos [def: as ... as possible (with a comparative adverb)]
	farvo's [def: why (interrogative)] 
	[idiom: nokh dem vos = after (conj)]
vov{vov}/H/N [m/f] [def: Hebrew letter Vav] 
	lamedvovnik{lmd-vovnik}/H/Ees [m] [def: hidden righteous person]
vovkalak/Ees [def: wereworlf] 
voyazhor/N [m] [def: peddler] 
	komivoyazho'r [m] [def: travelling salesman] % Forwards
	sakvoyazh/N [f?] [def: suitcase]
voye/V/T [def: howl (sound of a wolf)] voy'eve/V/T 
	gevoy'/N [m] voy/N [m] [def: howl (sound of a wolf); wailing] 
	tsevoyet/A [def: howling] % hint fun keytn voyen un vern tsevoyet
voy'eve/V/T [def: frolic; storm in anger; fight; run wild]
vo|yevode [m?] [def: officeholder (political)]
	vo|yevudestve/S [f] [def: administrative region, main town in a region (Polish)] 
voyl/A [def: nice, good] voylink/A [def: little nice]
	voyl [adv] oybvoyl [adv] [def: although] [usage: archaic]
voyn/V/T [def: live, reside] /Gop
	/Gbay [def: attend] 
	voyner/S [m] voy'nerin/S [f] [def: inhabitant] 
		aynvoyner/S [m] aynvoy'nerin/S [f] [def: resident] 
		mitvoyner/S [m] mitvoy'nerin/S [f] [def: roommate]
	voynung/N [f] [def: residence, dwelling; apartment] 
	bavoy'n/V/Bbavoy'nt [def: inhabit] 
		u'mbavoy'nt/A [def: uninhabited]
	aynvoyn- [prefix] [def: in residence] [note: V]
vozne/S [m] [def: bailiff] 
vu vanen vanet vanent avu [adv] [def: where]
	andershvu [adv] [def: somewhere else]
	vuhin [adv] [def: whither, whither?] 
	bizvanen [adv] [def: until, until when?] 
	[idiom: biz vanen, biz ven = before you know it]
vua'l [m?] [def: veil (clothing)]
vulga'r/A [def: vulgar] 
	vulgari'zm/N [m] [def: vulgar expression]
vulka'n/N [m] [def: volcano] 
vund/N [n] [def: wound]
	brenvund/N [f] [def: burn (wound)]
	vundik/V/T [def: wound]
	farvundik/V/Bfarvundikt [def: wound] 
	farvundet/A farvundt/A [def: wounded] 
	[idiom: oyf/in gehakte vunden = in trouble]
vunder/V/T [def: astonish; wonder, be surprised (with "zikh")]
	/Gop [def: marvel at, be astonished (with "zikh nit kenen")]
	vunderlekh/K vunderbar/A [def: wonderful]
	vunder/S [m] [def: marvel] 
	bavunder/V/Bbavundert [def: admire]
		bavunderung/N [f] [def: admiration] 
	farvunder/V/Bfarvundert [def: be amazed at]
		farvunderung/N [f] [def: amazement] 
		farvundertkayt/N [f] [def: amazement] 
	beyzvunder/S [n] [def: something marvelous or dreadful to see]
vursht/N [def: sausage; salami; clarinet (klezmer-loshn)]
	/D [def: hot dog, frankfurter] 
vredne/A [def: ugly; disgusting] 
vremyanke/S [f] [def: makeshift house (Russian времянка)]
vyane/V/T [def: wilt, fade, wither]
	farvyanet/A [def: wilted] 
	[idiom: vern farvyanet = wilt]
vyatrik/Ees [m] [def: windmill]
vyelmozhna [m] [def: nobleman (Polish)] % Mendl Man 
vyershik/Ees [m] [def: verse (poetry)] % Malke Li: durkh kindishe oygn
vyo [interj] [def: gidyap (to a horse)] 
	vyoke/V/T [def: say "gidyap"] % Sholem Aleykhem
vyole/S [f] [def: viola (musical instrument)]
vyolontshe'l/N [m] [def: cello, violoncello (musical instrument)]
vyorst/N verst/N [m] [def: verst (about 0.66 miles) (Russian верста)]
	 vyorstndik/A [def: verst-long] % Bergelson
yaades{yhdwT}/H [n] [def: Jewishness; Judaism] 
	yandes{yndwT} [n] [def: conscience; lack of conscience]
yabed/V/T [def: gossip (Russian ябеда "sneak")]
	ya'bednik/Ees [m] [def: informer; argumentative person; niggler]
yabke/S [f] [def: potato] 
	yabtsik/Ees [m] [def: shredded-potato kugl] % Forwards: M-S Hoffman
yaboshe{ybSh}/Xyaboshes{ybSwT} [f] [def: (dry) land]
yad{yd}/H/N/Xyadoyem{ydym} [m] [def: hand; pointer] [usage: yadoyem means "clumsy hands"]
	leyad{lyd}/H [adv] [def: at hand]
	miyad{myd}/H [adv] [def: immediately]
		teykef_umiyad{WyKf-|umyd} [adv] [def: immediately]
	beyad{byd}/H [adv] [def: in the hand] 
	matnas_yad{mWnT-yd}/H [f] [def: bribe; punch, blow, cuff]
	shel_yad{Sl-yd}/N/H [m] [def: tefillin worn on the arm]
	netilas_yadoyem{ntylT-ydym} [def: ritual hand-washing before a meal]
	[idiom: kafhayadke{Kf-hydke} = hand computer] % neologism
yadeshliv/A [def: asthmatic]
yagde/S [f] ya'gede/S [f] [def: berry] 
	e'rdyagde/S [f] [def: strawberry (fruit)] % Stutchkoff
	[idiom: shvartse yagde = blueberry]
	[idiom: royte yagde = strawberry] % Stutchkoff
yahudish [def: Judeo-Arabic] 
yak/N/D [f] [def: blouse, jacket (women's clothing)]
	yaker [m] [def: jacket (clothing)] % Rokhl Korn: Erd
yak [adv] [idiom: X yak vi X = never mind X]
yakbe [adv] [def: as it were (Ukranian якби)]
yakhmer/V/T [def: howl]
	tseyakhmer{tse|yakhmer}/V/Btseyakmert{tse|yakhmert} [def: be hysterical] 
	faryakhmert/A [def: emotional]
yakht/N [m] yakhte/S [f] [def: yacht] 
yakosh [adv] [def: somehow]
yakres{|ykrwT}/H/N [n/m] [def: inflation; high price; low availability] /Idik [def: inflationary]  
	beyoyker{bywkr} [adj] [def: expensive]
	ben_yaker{bn-ykyr} [m] [def: favorite son]
yalevke/S [f] [def: dry cow]
yam/N [m?] [def: sweet potato, yam (food)]
yam_{|ym}/Xyamem{|ymym}/H/N [m] [def: ocean, sea] % both plurals exist
	/Lle{l} [adv] [def: to the sea; over the sea] 
	yakren{ykrn}/Xyakronem{ykrnym} [m] ya'krente{ykrnte}/S [f] [def: profiteer; chiseler]
	yam_hakerekh{ym-hkrH} [m] [def: Arctic ocean]
	[idiom: eyver_{eBr} leya'm{lym} = over the sea]
	[idiom: a yam{|ym} mit = an enormous amount of]
yamsh [m] [def: bamboo (tree, wood)] /In /Iove
yanua'r [m] [def: January] 
yar/N [m] [def: gulch, ravine; dale] 
yard/N [m] [def: yard (distance measure)] 
yari'd yari'd_{yryd}/N/Xyaridem{yrydym}/H [m] [def: fair (for selling goods)] 
yarli'k/N [m] [def: label, ticket] [usage: rare]
yarme/S [f] [def: yoke]
ya'rmlke/S [f] ya'rmelke/S [def: scullcap] /D
yarshn{|yrSn}/Vyarshenen{|yrSenen}/T [f] [def: inherit] 
	yerushe{yrwSh}/Xyerushes{yrwSwT}/H [f] [def: inheritance]
		beyerushe{byrwSh} [adv] [def: by inheritance] 
		/Idik [def: inherited] 
		yerushedikayt{yrwShdikayt} [f] [def: inheritability] 
	yoyresh{ywrS}/Xyorshem{ywrSym}/H [m] [def: heir] 
yash{y″S}/H [m] [def: liquor, whiskey; home brew] [origin: yayin{y|yn} soref{Qrf}]
yasine/S [f] yashin [def: ash (tree, Fraxinus spp.) (Polish jesion)]
	yasinove/A [def: of ash (tree)]
	oshin/A [def: ashen (tree)] % Opatoshu: Poylishe Velder
ya'shtsherke/S [f] [def: lizard]
	[idiom: lakhn mit yashtsherkes = laugh bitterly]
yasine/S [f] yasen/S [m] [def: ash (tree), mountain ash or rowan (tree)] 
yasker [m?] [def: buttercup (flower, Ranunculus) (Polish jaskier)] % Rokhl Korn
yasle/S [f] [def: gums (mouth)]
-/Xyasles [def: manger] % plural only
yasmi'n/N [def: jasmine (plant)] 
yat/N [m] [def: fine lad; chap] yatikhe/S [f] [def: fine lass] 
	faryatl/V/Bfaryatlt [def: become pregnant out of wedlock (with "zikh")] % M-S Hoffman, Stutchkoff
yate/S [f] [def: burrow] % Rokhl Korn: shotns
ya-tebe-dam/N [m] [def: self-important person]  % Sholem Aleykhem
yatke/S [f] [def: butcher shop] 
yatsheyk/Ees [m] [def: political cell]
yave/V/T [def: show up surprisingly (with "zikh")] /Garoys
yazde/S [f] [def: wagon; trip]
	[idiom: aroyfkhapn zikh oyf a yazde = hitchhike] [note: V]
yede/A [def: each, every] % irregular; we show the forms
	yederer [adj] yedere [adj] yedern [adj] yedns [adj] [def: each] 
	yederns [adj] [def: each] 
	ayeder{a|yeder} [adj] ayederer{a|yederer} [adj] ayedn{a|yedn} [adj] [def: each] 
	yetveder [adj] yetvedn [adj] [def: each] 
	% CY E.27, E.28
yefeyfye{yfyfyh}/Xyefeyfyes{yfyfywT} [f] [def: beauty; beautiful woman] 
	yafestoyer{yfT-Ww#r} [f] [def: beauty; beautiful woman]
yehudi{|yhwdy}/Xyehudem{|yhwdym}/H [def: Jew]
	lehudem{lyhwdym} [def: joyous] /Idik % reference to Esther:9
yek/V/T [def: taunt] % Harduf
yeke/S [m] [def: German Jew (pejorative)]
yekhoyles{yxwlT}/H/N [n/f] [def: ability]
	bikhoyles{byxwlT} [adj predicative] [def: able, capable]
	yokhl{yxl}/V/T [def: be able; know how; be virile] [usage: often ironic]
	keviyokhl{KByxl} [adv] [def: as it were (referring to God]
	keviyokhl{KByxl} [m] [def: God]
yelole{yllh}/Xyeloles{yllwT}/H [f] yayle{yelh}/Xyayles{yelwT} [def: wail; shout]
yemakh{ymH}/H [def: be blotted out] 
	yemakh_shmoynik{ymH-Smwnik}/Ees [m] yemakh_shmoy'nitse{ymH-Smwnitse}/S [f] [def: evil person]
	[idiom: yemakh shmoy{Smw} = may his name be blotted out]
yener [adj] [def: that] % irregular; we show all forms; CY E.30
	yenem [adj] yene [adj] yents [adj] yenems [adj] yeners [adj] [def: that]
	yenik/A [def: that]
	yents/V/T [def: fornicate (taboo); defraud, swindle (vulgar)] 
		yentser/S [def: someone who fornicates (taboo)] 
yenike{ynyk|h}/Xyenikes{ynykwT}/H [f] [def: sustenance; inspiration] 
	girse_deya'nkese{gyrs#-dynkwT#} [f] [def: subjects learned as a child]
yenke/V/T [def: groan, moan]
	yenk/N [m] [def: moan] % Harduf
yente/C [def: Yente; blabbermouth, busybody; shrew] 
yer/V/T/Bgeyoyrn{ge|yoyrn} [def: ferment; rise (dough)] /Goyf/Giber
	yoyr/V/T/Bge|yoyrn /Goyf % variant
		yoyrn [n] yoyrung [f] [def: fermentation]
	tseyoyrn/A [def: doughy] % J. Opatoshu: lintsheray
yerokes{yrkwT}/H [def: vegetables]
yeseyre{yTyrh}/H [def: extra]
	yiter{yiWwr} [m] [def: tailor's remnants]
	[idiom: neshome{nSmh} yeseyre = extra soul for the duration of the Sabbath]
yesh{yS}/H [m] [def: existence] 
yeshive{ySyBh}/Xyeshives{ySyBwT}/H [f] [def: religious academy] 
	/Lbe{b} [adv] [def: in the acadamy] 
yeshue{ySweh}/Xyeshues{ySwewT}/H [f] [def: salvation] 
yeso'd{yswd}/Xyesoydes{yswdwT}/H [m] [def: foundation]
	yeso'd{yswd} [adj] [def: prime (mathematics)] [grammar: undeclined]
	meyased{mysd}/H [def: based] 
	yesoy'desdik{yswdwTdik}/A [def: fundamental]
-/Xyesurem{yswrym}/H [def: pains] 
	[idiom: hob nit keyn yesurem{yswrym} = dont worry; never mind]
yet/V/T [def: weed] /Goys
yetsire{ycyrh}/H [f] [def: creation]
	seyfer_yetsire{sfr-ycyrh} [def: a mystic work ascribed to R. Akiba]
yetsiyas{ycy#T}/H [def: departure from] % TODO: put under moytsi
	[idiom: yetsiyas{ycy#T} mitsrayem{mcrym} = exodus from Egypt]
yeytser{ycr}/H [def: inclination] 
	[idiom: yeytser{ycr} hore{hre} = evil inclination; libido, lust, desire]
	[idiom: kuperner yeytser{ycr} hore{hre} = sexual fetish] % Michael Wex
	[idiom: yeytser{ycr} hatoyv{htwB} = good inclination]
yezuit/N [m] /Iish [def: Jesuit]
yid/N/J/D [m] [def: Jew; person (Jewish); anonymous male stranger]
	yidntum [n] [def: community of Jews]
	yidene/S [f] [def: Jewish woman (sometimes pejorative); homemaker] 
	dorfsyid/N [m] [def: small-town Jew]
	yidish [n] [def: Yiddish language; Jewish] /K
		yidishke/S [f] [def: Jewish woman]
		yidishkayt/N [f] [def: Jewishness, Judaism]
		yidishi'zm/S [m] [def: Yiddish awareness movement]
		yidishlekh/A [def: Jewish, Yiddish] 
		faryidish/V/Bfaryidisht [def: Judaize] 
		yidishi'st/N [m] /Iish yidishistke/S [f] [def: Yiddishist, partisan of Yiddish] 
	yudaistik/N [f] [def: Judaic studies] yudaistish/A [de