#!/usr/local/bin/perl -T

# convert Mac Hebrew into transcription form, to some extent.

# Author: Raphael Finkel, 1997
# See the COPYRIGHT file enclosed with this distribution.

$CodeTable{""} = "!";  # RTO + ! 
$CodeTable{""} = "\"";  # RTO + " 
$CodeTable{""} = "$$";  # RTO + $ 
$CodeTable{""} = "%";  # RTO + % 
$CodeTable{""} = "'";  # RTO + ' 
$CodeTable{""} = ")";  # RTO + ( 
$CodeTable{""} = "(";  # RTO + ) 
$CodeTable{""} = "[";  # RTO + ] 
$CodeTable{""} = "]";  # RTO + [ 
$CodeTable{""} = "{";  # RTO + } 
$CodeTable{""} = "}";  # RTO + { 
$CodeTable{""} = "*";  # RTO + * 
$CodeTable{""} = "+";  # RTO + + 
$CodeTable{""} = ",";  # RTO + , 
$CodeTable{""} = "-";  # RTO + - 
$CodeTable{""} = ".";  # RTO + . 
$CodeTable{""} = ":";  # RTO + : 
$CodeTable{""} = ";";  # RTO + ; 
$CodeTable{""} = "?";  # RTO + ? 
$CodeTable{""} = "=";  # RTO + = 
$CodeTable{""} = "g";  # HEBREW LETTER GIMEL 
$CodeTable{""} = "d";  # HEBREW LETTER DALET 
$CodeTable{""} = "h";  # HEBREW LETTER HE 
$CodeTable{""} = "z";  # HEBREW LETTER ZAYIN 
$CodeTable{""} = "kh";  # HEBREW LETTER HET 
$CodeTable{""} = "t";  # HEBREW LETTER TET 
$CodeTable{""} = "y";  # HEBREW LETTER YOD 
$CodeTable{""} = "kh";  # HEBREW LETTER FINAL KAF 
$CodeTable{""} = "l";  # HEBREW LETTER LAMED 
$CodeTable{""} = "m";  # HEBREW LETTER FINAL MEM 
$CodeTable{""} = "m";  # HEBREW LETTER MEM 
$CodeTable{""} = "n";  # HEBREW LETTER FINAL NUN 
$CodeTable{""} = "n";  # HEBREW LETTER NUN 
$CodeTable{""} = "s";  # HEBREW LETTER SAMEKH 
$CodeTable{""} = "e";  # HEBREW LETTER AYIN 
$CodeTable{""} = "f";  # HEBREW LETTER FINAL PE 
$CodeTable{""} = "k";  # HEBREW LETTER QOF 
$CodeTable{""} = "r";  # HEBREW LETTER RESH 
$CodeTable{""} = "s";  # HEBREW LETTER SHIN WITH SIN DOT 
$CodeTable{""} = "sh";  # HEBREW LETTER SHIN 
$CodeTable{""} = "b";  # HEBREW LETTER BET 
$CodeTable{""} = "u";  # HEBREW LETTER VAV 
$CodeTable{""} = "kh";  # HEBREW LETTER KAF 
$CodeTable{""} = "p";  # HEBREW LETTER KAF 
$CodeTable{""} = "s";  # HEBREW LETTER TAV 
$CodeTable{""} = "ay";  # Pasakh tsvey yud
$CodeTable{""} = "";  # SHTUMER ALEPH

while (defined ($line = <STDIN>)) { # one line
	if ($line eq "\n") {
		print "\n<p>\n";
		next;
	}
	$line =~ s//v/g;  # HEBREW LETTER BET, HEBREW POINT RAFE 
	$line =~ s//u/g;  # HEBREW LETTER VAV, DAGESH OR MAPIQ 
	$line =~ s//v/g;  # HEBREW LETTER VAV, VAV
	$line =~ s//k/g;  # HEBREW LETTER KAF, DAGESH OR MAPIQ 
	$line =~ s//f/g;  # HEBREW LETTER PE, HEBREW POINT RAFE 
	$line =~ s//p/g;  # HEBREW LETTER PE, HEBREW POINT DAGESH
	$line =~ s//t/g;  # HEBREW LETTER TAV, DAGESH OR MAPIQ 
	$line =~ s//i/g;  # HEBREW LETTER YOD, HEBREW POINT HIRIQ 
	$line =~ s//ay/g;  # HEBREW LETTER YOD, YOD, PATAH 
	$line =~ s//oy/g;  # HEBREW LETTER VAV, HEBREW LETTER YOD 
	$line =~ s//ey/g;  # HEBREW LETTER YOD [twice] 
	$line =~ s//a/g;  # HEBREW LETTER ALEF, HEBREW POINT PATAH 
	$line =~ s//o/g;  # HEBREW LETTER ALEF, HEBREW POINT QAMATS 
	foreach $code (keys %CodeTable) {
		$line =~ s/$code/$CodeTable{$code}/eg;
	}
	$line =~ s/(.)((h|k)eyt)([ns]?)\b/$1$3ayt$4/g; # most heyt => hayt
	$line =~ s/ts(\b|[^h])/t|s$1/s; # prophylactic | between t and s
	$line =~ s//ts/g;	 # HEBREW LETTER FINAL TSADI 
	$line =~ s//ts/g;  # HEBREW LETTER TSADI 
	$line =~ s/zsh/zh/g;
	$line =~ s/([^aeiou]|\b)y([^aeiou]|\b)/$1i$2/g; # most y should be i
	print $line . " ";
} # one line;
