" syntax file for definitions files.
"
" I use this notation: =def is a defining instance; *def is a technical use of
" a term defined elsewhere in this document.  [A sentence like this is a
" concrete example of the previous abstract statement.]

hi clear
" Conventions
syn match myDef "=\([-a-zA-Z_]\)*" 
	hi link MyDef Constant 
syn match myUse "\*\([-a-zA-Z_]\)*"
	hi link myUse Question 
syn match myUnspecified "!\([-a-zA-Z_]\)*"
	hi link myUnspecified Error 
syn region   myExample   start="\[" end="\]"
	hi link myExample Comment

map , :call FindDef()

function! FindDef()
	let theWord = expand("<cword>")
	let myPattern = "=" . theWord
	let myPlace = line2byte(line(".")) " to put current location on jumplist
	exe "normal " . myPlace . "go"
	if search(myPattern) == 0
		let myPattern = myPattern . "s"
		if search(myPattern) == 0
			let myPattern = substitute(myPattern, "s*$", "", "" )
			if search(myPattern) == 0
				echo "Sorry, can't find the definition of \"" . theWord . "\"."
				exe "normal "
			endif
		endif
	endif
endfunction
