" Vim syntax file
" Language:    KATR
" Maintainers: Raphael Fikel <raphael@cs.uky.edu>
" Last Change: 2002 Apr 24

syntax reset

" KATR is case sensitive.
syn case match

syn match    KATRComment      +%.*+
syn region   KATRCComment     start=+/\*+ end=+\*/+
syn match    KATRCommentError      "\*/"

syn keyword  KATRKeyword      hide vars atom show if then elsif endif trace type analyze leaf
syn keyword  KATRStruct      ONLY ALL REST
syn match    KATRVariable      "\$[a-zA-Z0-9]*"
syn match    KATRNode         "\<[A-Z][a-zA-Z0-9]*"
syn region   KATRSetLHS   start="{"ms=s+1 end="}"me=e-1 contains=KATRVariable
syn match    KATRPathLHS   "\t<[^>]*>\_s*="ms=s+2,me=e-3 contains=KATRVariable

syn match   KATROperator "="
syn match   KATROperator "=="
syn match   KATROperator "=+="
syn match   KATROperator "?"
syn match   KATROperator "*"
syn match   KATRSpecialCharacter  "\.\|:\|#\|::"

syn sync ccomment maxlines=500

" For version 5.7 and earlier: only when not done already
" For version 5.8 and later: only when an item doesn't have highlighting yet
if version >= 508 || !exists("did_KATR_syn_inits")
  if version < 508
    let did_KATR_syn_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command! -nargs=+ HiLink hi def link <args>
  endif

" The default highlighting.
    HiLink KATRComment            Comment
    HiLink KATRCComment           Comment
    HiLink KATRCharCode           Special
    HiLink KATRKeyword          Keyword
    HiLink KATRSetLHS       Statement
    HiLink KATRPathLHS       Type
    HiLink KATRQuestion         PreProc
    HiLink KATRSpecialCharacter Constant
    HiLink KATRNode 	Underlined
    HiLink KATRNumber           Number
    HiLink KATRVariable           Special
    HiLink KATRAsIs             Normal
    HiLink KATRCommentError     Error
    HiLink KATRAtom             String
    HiLink KATRString           String
    HiLink KATROperator         Number
    HiLink KATRStruct         Type

  delcommand HiLink
endif

let b:current_syntax = "KATR"

" vim: ts=28
