" startup file for unicode Yiddish

set keymap=yi rl dict=$HOME/.vim/uyidwords.vim timeoutlen=5000
syntax on
map \eo	:call OnUYidSpelling()<CR>

fu! OnUYidSpelling()
	echo "... המישר רעטרעװ אַ ףראַד ךיא ;טונימ אַ טראַװ ... "
	so $HOME/.vim/uyidspell.vim
endfunction

fu! PrintUYid()
	%s/^/‮/g
	%s/$/‬/g
	%left 75
	:!uniprint -out test.ps -font cyberbit.ttf -hsize 0 -in %
	normal uuu
	w
endfunction

map \ep :call PrintUYid()<CR>

" shows the current line in a preview window in bidi.
:function! ShowBidi()
	:let storeit=getline(".")
	:set laststatus=0
	:silent only
	" :normal "xyy
	" :set previewheight=1
	" :botright pedit! showbidi
	:botright 1 new
	" :wincmd j
	:set buftype=nofile
	" :normal "xp
	:call append(0,storeit)
	:normal k
	:.!expand -4 | fribidi --reordernsm --wrtl
	:wincmd k
:endfunction

" possible ways to invoke ShowBidi, none enabled by default
:map  :call ShowBidi()
" :autocmd CursorHold * call ShowBidi()
" :set updatetime=100

